import React from 'react';
import { Image } from 'antd';
import './index.scss';

// 参数类型
interface propsType {
  src: string;
  width?: number;
  height?: number;
  autoPlay?: boolean;
  loop?: boolean;
  controls?: boolean;
}

const Video: React.FC<propsType> = (props) => {
  // 组件的默认值
  Video.defaultProps = {
    src: 'http://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/3505c402-cbf9-41a5-9d6f-bdb350625bea.jpg',
    width: 40,
    height: 40,
  };
  // 视频是否预览
  const [isPreview, setIsPreview] = React.useState<boolean>(false);
  return (
    <>
      <Image
        src={`${props?.src}?x-oss-process=video/snapshot,t_3618&x-oss-process=image/quality,q_25`}
        width={props?.width}
        height={props?.height}
        preview={false}
        onClick={() => {
          setIsPreview(true);
        }}
      />
      {isPreview && (
        <div className='video-preview'>
          <view className='preview-mask' onClick={() => setIsPreview(false)}></view>
          {/*<Button className='button' shape='circle' icon={<CloseOutlined />} />*/}
          {/* eslint-disable-next-line jsx-a11y/media-has-caption */}
          <video className='video' src={props?.src} autoPlay controls></video>
        </div>
      )}
    </>
  );
};

export default Video;
