import React, { useEffect, useState } from 'react';
import { Button, Steps, Image } from 'antd';
import { rentOrderDetailType } from '~/api/interface/orderManageType';
import { InterDataType } from '~/api/interface';
import { OrderManageAPI } from '~/api';
import LogisticsStepModal from '~/components/order/productOrder/logisticsStepModal';

// 接口返回的类型
type DataType = InterDataType<rentOrderDetailType>;
// 参数类型
type PropsType = {
  detail: DataType;
};

const DetailPurchaser: React.FC<PropsType> = (props) => {
  const { detail } = props;
  const [logisticsStepModalShow, setLogisticsStepModalShow] = useState<boolean>(false);
  const [currentKdnExpDTO, setCurrentKdnExpDTO] = useState<DataType[0]['kdnExpDTO']>();
  // 物流列表
  const [expressList, setExpressList] = React.useState<{ label: string; value: string }[]>([]);
  // 获取物流信息
  const getListExpressInfo = async () => {
    const res = await OrderManageAPI.listExpressInfo({});
    if (res && res.code === '200') {
      setExpressList(res.result.map((item) => ({ label: item.exName, value: item.exCode })));
    }
  };
  // 转换物流信息
  const getExpressInfo = (code: string | undefined | null) => {
    return expressList.find((item) => item.value === code)?.label || code;
  };
  // 物流弹窗
  const logisticsStepModalShowClick = (kdnExpDTO: DataType[0]['kdnExpDTO']) => {
    setCurrentKdnExpDTO(kdnExpDTO);
    setLogisticsStepModalShow(true);
  };
  const logisticsStepModalCancel = () => {
    setLogisticsStepModalShow(false);
  };

  // componentDidMount
  useEffect(() => {
    getListExpressInfo().then();
  }, []);
  return (
    <div className='detail-purchaser detail-half'>
      <div className='detail-title'>买家信息</div>
      <div className='detail-text'>UID：{detail?.userAccountId}</div>
      <div className='detail-text'>姓名： {detail?.nickname}</div>
      <div className='detail-text'>手机号： {detail?.phoneNum}</div>
      <div className='detail-text'>备注： {detail?.userRemark}</div>
      <div className='detail-title'>发货信息</div>
      <div className='detail-text'>收货人：{detail?.uavOrderExpressDTO?.takeName}</div>
      <div className='detail-text'>手机号：{detail?.uavOrderExpressDTO?.takePhone}</div>
      <div className='detail-text'>
        收货地址：
        {(detail?.uavOrderExpressDTO?.takeRegion?.split('/').join('') || '') +
          detail?.uavOrderExpressDTO?.takeAddress}
      </div>
      {detail?.uavOrderExpressDTO?.sendExpCode && (
        <>
          <div className='detail-text'>物流单号：{detail?.uavOrderExpressDTO?.sendExpNo}</div>
          <div className='detail-text'>
            物流公司：{getExpressInfo(detail?.uavOrderExpressDTO?.sendExpCode)}
          </div>
          <div className='detail-text' style={{ display: 'flex' }}>
            <span>物流进度：</span>
            <div>
              <Steps
                direction='vertical'
                current={0}
                progressDot
                items={[
                  {
                    title: detail?.kdnExpDTO?.traces?.[0].acceptStation,
                    description: detail?.kdnExpDTO?.traces?.[0].acceptTime,
                  },
                  {
                    title: `送至${
                      (detail?.uavOrderExpressDTO?.takeRegion?.split('/').join('') || '') +
                      detail?.uavOrderExpressDTO?.takeAddress
                    }`,
                  },
                ]}
              />
            </div>
            <div>
              <Button type='link' onClick={() => logisticsStepModalShowClick(detail?.kdnExpDTO)}>
                查看详情
              </Button>
            </div>
          </div>
        </>
      )}
      {detail?.confirmReceipt ? (
        <div>
          <div className='detail-title'>收货信息</div>
          {detail?.confirmReceipt.file ? (
            <div className='detail-text' style={{ display: 'flex' }}>
              <span>图片：</span>
              <div
                className='image-file'
                style={{ display: 'flex', alignItems: 'center', flexWrap: 'wrap' }}
              >
                {JSON.parse(detail?.confirmReceipt.file).map((v: any, index: number) => (
                  <div style={{ marginRight: '10px', marginBottom: '10px' }} key={index}>
                    <Image src={v} width={50} height={50} />
                  </div>
                ))}
              </div>
            </div>
          ) : (
            ''
          )}
          <div className='detail-text'>描述：{detail?.confirmReceipt.reason}</div>
        </div>
      ) : (
        ''
      )}
      {detail?.returnKdnExpDTO ? (
        <>
          <div className='detail-title'>归还信息</div>
          <div className='detail-text'>物流单号：{detail?.returnKdnExpDTO?.logisticCode}</div>
          <div className='detail-text'>
            物流公司：{getExpressInfo(detail?.returnKdnExpDTO?.shipperCode)}
          </div>
          <div className='detail-text'>
            物流进度：
            <Button
              type='link'
              onClick={() => logisticsStepModalShowClick(detail?.returnKdnExpDTO)}
            >
              查看详情
            </Button>
          </div>
        </>
      ) : (
        ''
      )}
      {detail?.storeDamageOrder ? (
        <div>
          <div className='detail-title'>破损信息</div>
          {detail?.storeDamageOrder.file ? (
            <div className='detail-text' style={{ display: 'flex' }}>
              <span>图片：</span>
              <div
                className='image-file'
                style={{ display: 'flex', alignItems: 'center', flexWrap: 'wrap' }}
              >
                {JSON.parse(detail?.storeDamageOrder.file).map((v: any, index: number) => (
                  <div style={{ marginRight: '10px', marginBottom: '10px' }} key={index}>
                    <Image src={v} width={50} height={50} />
                  </div>
                ))}
              </div>
            </div>
          ) : (
            ''
          )}
          <div className='detail-text'>
            扣除金额：￥{detail?.storeDamageOrder?.modifiedDeposit?.toLocaleString() || 0}
          </div>
          <div className='detail-text'>描述：{detail?.storeDamageOrder.reason}</div>
        </div>
      ) : (
        ''
      )}
      <LogisticsStepModal
        open={logisticsStepModalShow}
        onCancel={logisticsStepModalCancel}
        logisticsStep={currentKdnExpDTO}
      />
    </div>
  );
};

export default DetailPurchaser;
