import './index.scss';
import { DataDashboardsAPI } from '~/api';
import { useEffect, useState } from 'react';
import { InterDataType } from '~/api/interface';
import { releaseReportDataType, userReportDataType } from '~/api/interface/dataDashboardsType';

// 数据报表-用户信息返回类型
type userInfoDataType = InterDataType<userReportDataType>;
// 数据报表-信息发布返回类型
type releaseReportData = InterDataType<releaseReportDataType>;

const UserInfo = () => {
  const [userReportData, setUserReportData] = useState<userInfoDataType>();
  const [releaseReportData, setReleaseReportData] = useState<releaseReportData>();
  // 获取用户信息数据
  const getUserReportData = () => {
    DataDashboardsAPI.getUserReportData().then(({ result }) => {
      if (result) {
        setUserReportData(result);
      }
    });
  };
  // 获取信息发布数据
  const getReleaseReportData = () => {
    DataDashboardsAPI.getReleaseReportData().then(({ result }) => {
      if (result) {
        setReleaseReportData(result);
      }
    });
  };

  useEffect(() => {
    getUserReportData();
    getReleaseReportData();
  }, []);
  return (
    <div className='user-info'>
      <div className='user-info-card-1'>
        <div className='user-count-value'>{userReportData?.userCount}</div>
        <div className='user-count-meta'>用户总人数</div>
      </div>
      <div className='user-info-card-2'>
        <div className='card-header'>
          <div className='card-header-icon'></div>
          <div className='card-header-title'>用户概况</div>
        </div>
        <div className='card-info-1'>
          <div className='add'>
            <div className='value'>+{userReportData?.yesterdayAddUserCount}</div>
            <div className='label'>昨日新增</div>
          </div>
          <div className='active'>
            <div className='value'>{userReportData?.yesterdayActiveUserCount}</div>
            <div className='label'>昨日活跃</div>
          </div>
        </div>
        <div className='card-info-2'>
          <div className='user-auth'>
            <div className='value'>{userReportData?.dronePilotCount}</div>
            <div className='label'>实名认证</div>
          </div>
          <div className='flyer-auth'>
            <div className='value'>{userReportData?.realNameCount}</div>
            <div className='label'>飞手认证</div>
          </div>
        </div>
      </div>
      <div className='user-info-card-3'>
        <div className='card-header'>
          <div className='card-header-icon'></div>
          <div className='card-header-title'>信息发布</div>
          <div className='publish-count'>{releaseReportData?.releaseCount}</div>
        </div>
        <div className='card-info'>
          <div className='label'>帖子发布</div>
          <div className='value'>{releaseReportData?.postsReleaseCount}</div>
        </div>
        <div className='card-info'>
          <div className='label'>话题发布</div>
          <div className='value'>{releaseReportData?.topicReleaseCount}</div>
        </div>
        <div className='card-info'>
          <div className='label'>订单发布</div>
          <div className='value'>{releaseReportData?.orderReleaseCount}</div>
        </div>
      </div>
    </div>
  );
};
export default UserInfo;
