import './index.scss';
import * as echarts from 'echarts';
import { useEffect } from 'react';

const TradeInfo = () => {
  //   初始化柱状图
  const initEchartsBar = () => {
    const myChart = echarts.init(document.getElementById('histogram'));
    myChart.setOption({
      legend: {
        right: 20,
        top: 0,
        data: [
          {
            name: '总订单数',
            icon: 'pin',
          },
          {
            name: '总交易额',
            icon: 'pin',
          },
        ],
      },
      xAxis: {
        data: ['商城', '租赁', '服务'],
        axisLabel: {
          color: '#000',
          fontSize: 15,
        },
      },
      yAxis: {},
      series: [
        {
          name: '总订单数',
          type: 'bar',
          data: [50, 20, 36],
          barWidth: '13',
          itemStyle: {
            barBorderRadius: [7, 7, 0, 0],
            color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [
              { offset: 0, color: '#0B7CFE' },
              { offset: 1, color: '#FFFFFF' },
            ]),
          },
        },
        {
          name: '总交易额',
          type: 'bar',
          data: [50, 20, 36],
          barWidth: '13',
          itemStyle: {
            barBorderRadius: [7, 7, 0, 0],
            color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [
              { offset: 0, color: '#F22D40' },
              { offset: 1, color: '#FFFFFF' },
            ]),
          },
        },
      ],
    });
    window.addEventListener('resize', function () {
      myChart.resize();
    });
  };

  useEffect(() => {
    initEchartsBar();
  }, []);

  return (
    <div className='trade-info'>
      <div className='trade-info-card-1'>
        <div className='total-price'>12987.00</div>
        <div className='total-price-meta'>实时交易总额 (GMV)</div>
        <div className='time'>09.05更新</div>
      </div>
      <div className='trade-info-card-2'>
        <div className='card-header'>
          <div className='card-header-icon'></div>
          <div className='card-header-title'>交易详情</div>
        </div>
        <div className='card-echarts' id='histogram'></div>
        <div className='card-table'>
          <div className='card-table-header'>
            <div className='header-td'>类型</div>
            <div className='header-td'>订单总数(个)</div>
            <div className='header-td'>交易总额(元)</div>
          </div>
          <div className='card-table-tr'>
            <div className='td'>商城售卖</div>
            <div className='td'>123</div>
            <div className='td'>¥187.00</div>
          </div>
          <div className='card-table-tr'>
            <div className='td'>商品租赁</div>
            <div className='td'>123</div>
            <div className='td'>¥187.00</div>
          </div>{' '}
          <div className='card-table-tr'>
            <div className='td'>服务订单</div>
            <div className='td'>123</div>
            <div className='td'>¥187.00</div>
          </div>
        </div>
      </div>
    </div>
  );
};
export default TradeInfo;
