// 过滤路由
import { limitEntity } from '@/api/modules/role';

export const filterRouter = (list: any, routeList: limitEntity[]) => {
  return list.reduce((pre: any, cur: any) => {
    const obj = { ...cur };
    const bool: boolean = routeList.some((v) => v.id === obj.id);
    if (bool) {
      if (obj.children) {
        obj.children = filterRouter(obj.children, routeList);
      }
      pre.push(obj);
    }
    return pre;
  }, []);
};
export const isRoute = (list: any, pathname: string) => {
  return list.some(
    (v: any) =>
      v.path === pathname ||
      (v.alias && pathname.includes(v.alias)) ||
      (v.children && isRoute(v.children, pathname)),
  );
};
