import { Button } from 'antd';
import React from 'react';
import { ArrowLeftOutlined } from '@ant-design/icons';
import { useNavigate } from 'react-router-dom';

interface PropsType {
  isBack?: boolean;
  isFooter?: boolean;
  children: React.ReactNode;
  onCancel?: React.MouseEventHandler<HTMLAnchorElement> &
    React.MouseEventHandler<HTMLButtonElement>;
  onOK?: React.MouseEventHandler<HTMLAnchorElement> & React.MouseEventHandler<HTMLButtonElement>;
}

export const TableDetailView: React.FC<PropsType> = (props) => {
  // 组件默认值
  TableDetailView.defaultProps = {
    isBack: false,
    isFooter: false,
    onCancel: undefined,
    onOK: undefined,
  };
  // 参数解构
  const { children, isBack, isFooter, onCancel, onOK } = props;
  // 路由钩子
  const navigate = useNavigate();
  // Dom
  return (
    <div className='table-detail-view'>
      {isBack && (
        <Button
          type='primary'
          icon={<ArrowLeftOutlined />}
          style={{
            position: 'absolute',
            top: '10px',
            right: '10px',
            width: '100px',
          }}
          onClick={() => {
            navigate(-1);
          }}
        >
          返回
        </Button>
      )}
      {children}
      {isFooter && (
        <div className='detail-footer'>
          <Button onClick={onCancel}>取消</Button>
          <Button onClick={onOK} type='primary'>
            确认
          </Button>
        </div>
      )}
    </div>
  );
};
