import { Button, Form, Image } from 'antd';
import { useNavigate, useSearchParams } from 'react-router-dom';
import './index.scss';
import { MallManageAPI } from '~/api';
import { useEffect, useState } from 'react';
import { InterDataType } from '~/api/interface';
import { serviceDetailType } from '~/api/interface/mallManageType';

//服务详情-返回类型
type detailType = InterDataType<serviceDetailType>;
const ServiceDetail = () => {
  const navigate = useNavigate();
  const [searchParams] = useSearchParams();

  const [serviceDetail, setServiceDetail] = useState<detailType>();
  //服务详情
  const getServiceDetail = (id: number) => {
    MallManageAPI.getServiceDetail({ id }).then(({ result }) => {
      setServiceDetail(result);
    });
  };
  //返回
  const backRoute = () => {
    navigate(-1);
  };
  useEffect(() => {
    getServiceDetail(Number(searchParams.get('id')));
  }, []);
  return (
    <div className='service-detail'>
      <div className='service-detail-operate'>
        <Button type='primary' onClick={backRoute}>
          返回
        </Button>
      </div>
      <div className='service-detail-form'>
        <Form labelCol={{ span: 2 }} wrapperCol={{ span: 16 }}>
          <Form.Item label='服务名称'>{serviceDetail?.serviceName}</Form.Item>
          <Form.Item label='应用类型'>{serviceDetail?.applicationName}</Form.Item>
          <Form.Item label='对应行业'>{serviceDetail?.industryName}</Form.Item>
          <Form.Item label='展示状态'>
            {serviceDetail?.displayState === 0 ? '上架' : '下架'}
          </Form.Item>
          <Form.Item label='封面图'>
            <Image src={serviceDetail?.coverPlan} width={100} height={100} />
          </Form.Item>
          <Form.Item label='分享卡片'>
            {serviceDetail?.shareCard ? (
              <Image src={serviceDetail.shareCard} width={100} height={100} />
            ) : (
              '暂无'
            )}
          </Form.Item>
          <Form.Item label='视频'>
            {serviceDetail?.video ? <video src={serviceDetail?.video} /> : '暂无'}
          </Form.Item>
        </Form>
      </div>
    </div>
  );
};
export default ServiceDetail;
