import { Button, Tabs, TabsProps } from 'antd';
import { useState } from 'react';
import BaseInfo from './components/baseInfo';
import SkuInfo from './components/skuInfo';
import IntroduceInfo from './components/introduceInfo';
import SkuAddOrEditModal from './components/skuAddOrEditModal';
import './index.scss';
import { useNavigate } from 'react-router-dom';

const GoodsAddOrEditOrDetail = () => {
  const navigate = useNavigate();
  const [tabSelectKeys, setTabSelectKeys] = useState<string>('1');
  //新增、编辑sku弹窗
  const [addOrEditSkuModalShow, setAddOrEditSkuModalShow] = useState<boolean>(false);

  //新增、编辑sku弹窗显示
  const addOrEditSkuClick = () => {
    setAddOrEditSkuModalShow(true);
  };
  const addOrEditSkuModalCancel = () => {
    setAddOrEditSkuModalShow(false);
  };
  //tab 切换
  const tabSelectChange = (key: string) => {
    setTabSelectKeys(key);
  };
  //下一步
  const toNextStep = () => {
    setTabSelectKeys((Number(tabSelectKeys) + 1).toString());
  };
  //上一步
  const toBackStep = () => {
    setTabSelectKeys((Number(tabSelectKeys) - 1).toString());
  };
  const backRoute = () => {
    navigate(-1);
  };
  const TabItems: TabsProps['items'] = [
    {
      key: '1',
      label: `基础信息`,
      children: <BaseInfo />,
    },
    {
      key: '2',
      label: `商品规格`,
      children: <SkuInfo addOrEditSkuClick={addOrEditSkuClick} />,
    },
    {
      key: '3',
      label: `商品详情`,
      children: <IntroduceInfo />,
    },
  ];
  return (
    <div className='goods-operate-wrap'>
      <Tabs items={TabItems} activeKey={tabSelectKeys} onChange={tabSelectChange}></Tabs>
      <div className='next-step'>
        {tabSelectKeys !== '1' ? <Button onClick={toBackStep}>上一步</Button> : ''}
        {tabSelectKeys !== '3' ? (
          <Button type='primary' onClick={toNextStep}>
            下一步
          </Button>
        ) : (
          <Button type='primary'>保存</Button>
        )}
      </div>
      <div className='back-btn'>
        <Button type='primary' onClick={backRoute}>
          返回
        </Button>
      </div>
      {/*新增、编辑sku弹窗*/}
      <SkuAddOrEditModal open={addOrEditSkuModalShow} onCancel={addOrEditSkuModalCancel} />
    </div>
  );
};
export default GoodsAddOrEditOrDetail;
