import { Form, Input, Modal, ModalProps, Radio } from 'antd';
import { FC } from 'react';
import { InterDataType } from '~/api/interface';
import { rentOrderDetailType } from '~/api/interface/orderManageType';

// 租赁订单详情返回类型
type detailType = InterDataType<rentOrderDetailType>;

interface selfProps {
  onOk: () => void;
  onCancel: () => void;
  currentOrderItem: detailType | undefined;
}

const ConfirmReturn: FC<ModalProps & selfProps> = ({ open, onOk, onCancel }) => {
  const [form] = Form.useForm<{ damage: number; reason: string }>();

  const handleOk = () => {
    onOk();
  };
  const handleCancel = () => {
    onCancel();
  };

  return (
    <Modal open={open} title='确认归还' onOk={handleOk} onCancel={handleCancel}>
      <Form initialValues={{ damage: 0 }} form={form}>
        <Form.Item label='判定' name='damage'>
          <Radio.Group>
            <Radio value={0}>未破损</Radio>
            <Radio value={1}>破损</Radio>
          </Radio.Group>
        </Form.Item>
        <Form.Item label='原因' name='reason'>
          <Input.TextArea placeholder='请输入原因' maxLength={70} showCount rows={3} />
        </Form.Item>
        <Form.Item label='图片'>
          <div className='image-file'>{}</div>
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default ConfirmReturn;
