import { InterFunction, InterItemFunction } from '~/api/interface';
// 分类列表
export interface categoryEntity {
  id: number;
  directoryId: number;
  classifyName: string;
  pid: number;
  description?: any;
  icon: string;
  remark?: any;
  type: number;
  createTime: string;
  children: any[];
  isADD?: boolean;
  level?: number;
}

// 分类目录
export interface categoryDec {
  id: number;
  directoryName: string;
  pid: null;
  type: number;
  directoryType: string;
}

//分类列表类型
type categoryReposeType = {
  id: number;
  classifyName: string;
  icon: string;
  createTime: string;
  children: categoryReposeType[];
  directoryId: number;
  remark: string;
};
export type categoryListType = InterItemFunction<
  { directoryId?: number; type?: number },
  categoryReposeType[]
>;
//目录列表类型-分页
export type directoryPageListType = InterItemFunction<
  { type?: number },
  {
    id: number;
    directoryName: string;
    type: number;
  }[]
>;
//目录列表类型-不分页
export type directoryListType = InterFunction<
  { type: number },
  {
    id: number;
    directoryName: string;
    type: number;
  }[]
>;
//目录列表-产品指定
export type directoryProductType = InterFunction<
  any,
  {
    id: number;
    directoryName: string;
    type: number;
  }[]
>;
//分类-详情
export type categoryDetailsType = InterFunction<
  { id: number },
  { classifyName: string; description: string; icon: string; id: number; remark: string }
>;
//分类-关联列表
export type categoryRelevantType = InterFunction<{ id: number; type: number }, any>;

//分类管理-分类列表（新）
type categoryItemType = {
  id: number;
  name: string;
  createTime: string;
  icon: string;
  description: string;
  subDTOList: (Omit<categoryItemType, 'createTime' | 'icon' | 'subDTOList'> & {
    categoryPrimaryId: number;
  })[];
};
export type categoryListRespType = InterItemFunction<{ id?: number }, categoryItemType[]>;
//分类管理-1级分类新增（新）
export type addPrimaryCategoryType = InterFunction<
  {
    description: string;
    icon: string;
    name: string;
  },
  any
>;
//分类管理-1级分类编辑（新）
export type updatePrimaryCategoryType = InterFunction<
  {
    description: string;
    icon: string;
    name: string;
    id?: number;
  },
  any
>;
//分类管理-1级分类删除（新）
export type deletePrimaryCategoryType = InterFunction<{ id: number }, any>;
//分类管理-2级分类新增(新)
export type addSubCategoryType = InterFunction<
  {
    categoryPrimaryId: number;
    description: string;
    name: string;
  },
  any
>;
//分类管理-2级分类编辑（新）
export type updateSubCategoryType = InterFunction<
  {
    categoryPrimaryId: number;
    description: string;
    name: string;
    id?: number;
  },
  any
>;
//分类管理-2级分类删除（新）
export type deleteSubCategoryType = InterFunction<{ id: number }, any>;
