import React from 'react';
import { Table, Button } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import './index.scss';
import { ColumnsType } from 'antd/es/table';
import { customizeEntity, skuUnitType, specEntity } from '~/api/interface/goodsType';
import { InterDataType } from '~/api/interface';
import { categoryListType } from '~/api/interface/categoryManage';

//分类返回类型
type categoryType = InterDataType<categoryListType>['list'];

//产品-规格单位返回类型
type unitType = InterDataType<skuUnitType>;

interface selfProps {
  addOrEditSku: (record?: specEntity) => void;
  specData: specEntity[];
  categoryList: categoryType;
  skuUnitList: unitType;
}

const StockSku: React.FC<selfProps> = ({ addOrEditSku, specData, categoryList, skuUnitList }) => {
  const columns: ColumnsType<specEntity> = [
    {
      title: '序号',
      align: 'center',
      render: (_text: string, _record: specEntity, index: number) => index + 1,
    },
    {
      title: `产品类型`,
      align: 'center',
      dataIndex: 'categoryId',
      render: (text: string) => <div>{getGoodsTypeName(text)}</div>,
    },
    {
      title: '规格名称',
      align: 'center',
      dataIndex: 'goodsSpecName',
    },
    {
      title: `方案`,
      align: 'center',
      dataIndex: 'skuName',
    },
    {
      title: '选项来源',
      align: 'center',
      dataIndex: 'specIds',
      render: (_text: string, record) => (
        <div>
          {record.flag !== 1
            ? record.specIds.map((i: any, j: number) => (
                <div key={j}>
                  {i.specName}
                  {i.partNo && `(${i.partNo})`}
                </div>
              ))
            : record.customizeInfo &&
              record.customizeInfo.map((i, index: number) => (
                <div key={index}>{getSelfSpecName(i)}</div>
              ))}
        </div>
      ),
    },
    {
      title: '选择方式',
      align: 'center',
      dataIndex: 'chooseType',
      render: (text: number) => <div>{text === 0 ? '单选' : '多选'}</div>,
    },
    {
      title: '是否必选',
      align: 'center',
      dataIndex: 'must',
      render: (text: number) => <div>{text ? '必选' : '非必选'}</div>,
    },
    {
      title: '规格单位',
      align: 'center',
      dataIndex: 'skuUnitId',
      render: (text: number) => {
        return <div>{getSkuUnitName(text)}</div>;
      },
    },
    {
      title: '操作',
      align: 'center',
      width: '20%',
      render: (_text: any, record) => {
        return (
          <div>
            <Button
              type='link'
              style={{ marginRight: '10px' }}
              onClick={() => addOrEditSkuClick(record)}
            >
              编辑
            </Button>
            <Button type='link'>删除</Button>
          </div>
        );
      },
    },
  ];
  //添加、编辑规格操作
  const addOrEditSkuClick = (record?: specEntity) => {
    addOrEditSku(record);
  };
  // 自定义选项来源名称
  const getSelfSpecName = (obj: customizeEntity) => {
    return `${obj.specName}(${obj.partNo || ''})`;
  };
  // 行业或产品名称
  const getGoodsTypeName = (id: number | string) => {
    const obj = categoryList.find((i) => i.id === id);
    return obj?.classifyName;
  };
  // 单位名称
  const getSkuUnitName = (id: number) => {
    const unitObj = skuUnitList.find((i) => i.id === id);
    return unitObj?.unitName;
  };
  return (
    <div className='stock-sku'>
      <div className='stock-sku-title'>库存规格</div>
      <div className='stock-sku-content'>
        <div className='stock-sku-operate'>
          <Button icon={<PlusOutlined />} type='primary' onClick={() => addOrEditSkuClick()}>
            添加规格
          </Button>
        </div>
        <Table
          size='small'
          bordered
          dataSource={specData}
          rowKey='id'
          pagination={false}
          columns={columns}
        />
      </div>
    </div>
  );
};
export default StockSku;
