import { Button, Table } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { ColumnsType } from 'antd/es/table';
// import AddOrEditMakeModal from './components/addOrEditMakeModal';

const MakeList = () => {
  const columns: ColumnsType<any> = [
    {
      title: '品牌名称',
      align: 'center',
      dataIndex: 'brandName',
    },
    {
      title: '创建时间',
      align: 'center',
      dataIndex: 'createTime',
    },
    {
      title: '操作',
      align: 'center',
      render: () => (
        <>
          <Button type='link'>编辑</Button>
          <Button type='link' danger>
            删除
          </Button>
        </>
      ),
    },
  ];
  return (
    <div className='make-list'>
      <div className='make-list-operate'>
        <Button type='primary' icon={<PlusOutlined />}>
          新增
        </Button>
      </div>
      <div className='make-list-content' style={{ marginTop: '10px' }}>
        <Table bordered columns={columns} />
      </div>
      {/*<AddOrEditMakeModal />*/}
    </div>
  );
};
export default MakeList;
