import { FC, useEffect } from 'react';
import { Modal } from 'antd';
import { InterListType } from '~/api/interface';
import { industryCaseListCasePage } from '~/api/interface/resourceManageType';
import RichText from '~/components/richText';

// 列表的类型
type TableType = InterListType<industryCaseListCasePage>;
// 传参类型
interface propType {
  title: string;
  open: boolean;
  closed: any;
  data?: TableType[0];
}

const PreviewModal: FC<propType> = (props) => {
  PreviewModal.defaultProps = {
    data: undefined,
  };
  // 参数
  const { title, open, closed, data } = props;
  // 关闭弹窗
  const handleCancel = () => {
    closed();
  };
  // componentDidMount
  useEffect(() => {
    if (!open) return;
    if (!data) return;
    // console.log('data --->', data);
  }, [open]);
  return (
    <Modal
      open={open}
      title={title}
      onCancel={handleCancel}
      destroyOnClose
      width={768}
      footer={null}
    >
      <div
        style={{
          display: 'flex',
          justifyContent: 'center',
          alignItems: 'flex-start',
          flexDirection: 'column',
        }}
      >
        <div style={{ fontSize: '20px', fontWeight: 'bold' }}>{data?.caseTitle}</div>
        <div style={{ fontSize: '15px', marginBottom: '10px' }}>
          {data?.updateTime || data?.createTime}
        </div>
      </div>
      <RichText value={data?.caseContents} height={350} isDetail={true} />
    </Modal>
  );
};

export default PreviewModal;
