import { c as r, g as n } from "./utils-4kGecFw2.js";
import { n as e, c as i } from "./index-BcLRpF0n.js";
import "./index-YqpN0yec.js";
import "./index-CZypPRsn.js";
import "vue";
import "vue-clipboard2";
import "interactjs";
import "prismjs";
import "prismjs/themes/prism-okaidia.css";
import "@liveqing/liveplayer";
import "jquery";
import "mqtt/dist/mqtt";
import "vuex";
import "axios";
import "element-ui";
import "vue-router";
import "moment";
import "terraformer-wkt-parser";
import "dayjs";
import "file-saver";
import "nanoid";
import "jspack";
import "recorder-core";
import "recorder-core/src/engine/mp3";
import "recorder-core/src/engine/mp3-engine";
import "recorder-core/src/engine/pcm";
import "js-base64";
import "element-ui/lib/theme-chalk/index.css";
var t = {
  props: {
    containerStyle: {
      type: Object,
      "default": function _default() {
        return {};
      }
    },
    position: {
      type: Object,
      "default": function _default() {
        return {};
      }
    },
    payload: {
      type: Array,
      "default": function _default() {
        return [];
      }
    }
  },
  data: function data() {
    return {
      time: null,
      radio: 1,
      timer: null,
      control_speed: 3,
      mode: 1,
      zoom: 1,
      pitch: 0,
      yaw: 0,
      pow_mode: 0,
      control_mode: 0,
      light_mode: 0,
      brightness_mode: 0,
      record: !1,
      drd: {
        mode: [{
          id: 1,
          label: "跟随"
        }, {
          id: 2,
          label: "回中"
        }],
        pow_mode: [{
          id: 0,
          label: "普通"
        }, {
          id: 1,
          label: "最高"
        }],
        control_mode: [{
          id: 0,
          label: "关"
        }, {
          id: 1,
          label: "开"
        }],
        light_mode: [{
          id: 0,
          label: "关"
        }, {
          id: 1,
          label: "开"
        }, {
          id: 2,
          label: "闪"
        }],
        brightness_mode: [{
          id: 0,
          label: "亮"
        }, {
          id: 1,
          label: "高亮"
        }, {
          id: 2,
          label: "极亮"
        }]
      }
    };
  },
  watch: {
    payload: {
      handler: function handler(r) {
        this.resolve_payload(r);
      },
      deep: !0
    }
  },
  mounted: function mounted() {
    var _this = this;
    this.$nextTick(function () {
      _this.init_rocker();
    });
  },
  methods: {
    resolve_payload: function resolve_payload(n) {
      var e = new Uint8Array(n);
      if (165 === e[0] && r(e) === e[e.length - 1]) switch (e[1]) {
        case 1:
          this.msg_key_status1(e);
          break;
        case 248:
          this.gcs_button_ctrl(e);
      }
    },
    gcs_button_ctrl: function gcs_button_ctrl(r) {
      var n = r[3],
        e = r[4];
      if (4 === n) this.gimbal_mode_ctrl(e);
    },
    msg_key_status1: function msg_key_status1(r) {
      this.gimbal_mode_ctrl(3 & r[7]);
    },
    gimbal_mode_ctrl: function gimbal_mode_ctrl(r) {
      this.ptz_mode = r;
    },
    handle_change_mode: function handle_change_mode(r) {
      var e = n.gimbal_mode_ctrl(r);
      this.commit_directive(e);
    },
    handle_change_light_mode: function handle_change_light_mode(r) {
      var e = n.gimbal_light_mode_ctrl(r);
      this.commit_directive(e);
    },
    handle_change_brightness_mode: function handle_change_brightness_mode(r) {
      var e = n.gimbal_brightness_mode_ctrl(r);
      this.commit_directive(e);
    },
    handle_zoom: function handle_zoom(r) {
      var e = n.zoom(this.zoom + r);
      this.commit_directive(e), e = n.zoom(this.zoom = 1), this.commit_directive(e);
    },
    handle_change_pitch: function handle_change_pitch() {
      var r = n.change_pitch_angle(this.pitch);
      this.commit_directive(r);
    },
    handle_change_yaw: function handle_change_yaw() {
      var r = n.change_yaw_angle(this.yaw);
      this.commit_directive(r);
    },
    handle_change_camera_mode: function handle_change_camera_mode(r) {
      var e = n.camera_mode_ctrl(r);
      this.commit_directive(e);
    },
    handle_change_pow_mode: function handle_change_pow_mode(r) {
      var e = n.pow_mode_ctrl(r);
      this.commit_directive(e);
    },
    handle_change_control_mode: function handle_change_control_mode(r) {
      var e = n.control_mode_ctrl(r);
      this.commit_directive(e);
    },
    handle_take_photo: function handle_take_photo() {
      var r = this.position,
        e = n.take_photo(r || {});
      this.commit_directive(e);
    },
    handle_record: function handle_record() {
      this.record = !this.record;
      var r = n.record(this.record);
      this.commit_directive(r);
    },
    commit_directive: function commit_directive(r) {
      console.log(r), this.$emit("directive", r);
    },
    stopfxFn: function stopfxFn() {
      this.flag = !1, clearTimeout(this.time);
      var r = null;
      r = n.gimbal_pitch_ctrl(0, this.control_speed), this.commit_directive(r), r = n.gimbal_yaw_ctrl(0, this.control_speed), this.commit_directive(r);
    },
    fangxiang: function fangxiang(r) {
      var _this2 = this;
      clearTimeout(this.time);
      var e = null;
      switch (this.flag = !0, this.flag && (this.time = setTimeout(function () {
        _this2.fangxiang(r);
      }, 500)), r) {
        case "up":
          e = n.gimbal_pitch_ctrl(1, this.control_speed), this.commit_directive(e);
          break;
        case "right":
          e = n.gimbal_yaw_ctrl(1, this.control_speed), this.commit_directive(e);
          break;
        case "left":
          e = n.gimbal_yaw_ctrl(-1, this.control_speed), this.commit_directive(e);
          break;
        case "down":
          e = n.gimbal_pitch_ctrl(-1, this.control_speed), this.commit_directive(e);
      }
    },
    init_rocker: function init_rocker() {
      var _this3 = this;
      var r = null;
      joystick({
        onstart: function onstart(e) {
          switch (e) {
            case "up":
              r = n.gimbal_pitch_ctrl(1, _this3.control_speed), _this3.commit_directive(r);
              break;
            case "right":
              r = n.gimbal_yaw_ctrl(1, _this3.control_speed), _this3.commit_directive(r);
              break;
            case "left":
              r = n.gimbal_yaw_ctrl(-1, _this3.control_speed), _this3.commit_directive(r);
              break;
            case "down":
              r = n.gimbal_pitch_ctrl(-1, _this3.control_speed), _this3.commit_directive(r);
          }
        },
        onend: function onend() {
          r = n.gimbal_pitch_ctrl(0, _this3.control_speed), _this3.commit_directive(r), r = n.gimbal_yaw_ctrl(0, _this3.control_speed), _this3.commit_directive(r);
        }
      });
    }
  }
};
var o = function o() {
  var r = this,
    n = r.$createElement,
    e = r._self._c || n;
  return e("div", {
    staticClass: "cpt-MMC_Gimbal_L60",
    style: r.containerStyle
  }, [e("div", {
    directives: [{
      name: "interact",
      rawName: "v-interact"
    }],
    staticClass: "hd"
  }, [e("div", {
    staticClass: "title"
  }, [r._v("探照灯")]), r._v(" "), e("div", {
    staticClass: "close",
    on: {
      click: function click(n) {
        return r.$emit("close");
      }
    }
  }, [r._v("关闭")])]), r._v(" "), e("div", {
    staticClass: "bd"
  }, [e("div", {
    staticClass: "form-wrap"
  }, [e("div", {
    staticClass: "form-item"
  }, [e("div", {
    staticClass: "label-box"
  }, [r._v("控制速度")]), r._v(" "), e("div", {
    staticClass: "input-box"
  }, [e("div", {
    staticClass: "speedC"
  }, r._l(new Array(5).fill(1), function (n, i) {
    return e("div", {
      key: i,
      staticClass: "speed",
      style: r.control_speed == i + 1 ? "background: #FFFFFF;color: #333333;" : "",
      on: {
        click: function click(n) {
          r.control_speed = i + 1;
        }
      }
    }, [r._v("\n              " + r._s(i + 1) + "\n            ")]);
  }), 0)])]), r._v(" "), e("div", {
    staticClass: "form-item"
  }, [e("div", {
    staticClass: "label-box"
  }, [r._v("模式")]), r._v(" "), e("div", {
    staticClass: "input-box"
  }, [e("el-radio-group", {
    on: {
      change: r.handle_change_mode
    },
    model: {
      value: r.mode,
      callback: function callback(n) {
        r.mode = n;
      },
      expression: "mode"
    }
  }, r._l(r.drd.mode, function (n) {
    return e("el-radio", {
      key: n.id,
      attrs: {
        size: "mini",
        label: n.id
      }
    }, [r._v(r._s(n.label))]);
  }), 1)], 1)]), r._v(" "), e("div", {
    staticClass: "form-item"
  }, [e("div", {
    staticClass: "label-box"
  }, [r._v("功率")]), r._v(" "), e("div", {
    staticClass: "input-box"
  }, [e("el-radio-group", {
    on: {
      change: r.handle_change_pow_mode
    },
    model: {
      value: r.pow_mode,
      callback: function callback(n) {
        r.pow_mode = n;
      },
      expression: "pow_mode"
    }
  }, r._l(r.drd.pow_mode, function (n) {
    return e("el-radio", {
      key: n.id,
      attrs: {
        size: "mini",
        label: n.id
      }
    }, [r._v(r._s(n.label))]);
  }), 1)], 1)]), r._v(" "), e("div", {
    staticClass: "form-item"
  }, [e("div", {
    staticClass: "label-box"
  }, [r._v("联控模式")]), r._v(" "), e("div", {
    staticClass: "input-box"
  }, [e("el-radio-group", {
    on: {
      change: r.handle_change_control_mode
    },
    model: {
      value: r.control_mode,
      callback: function callback(n) {
        r.control_mode = n;
      },
      expression: "control_mode"
    }
  }, r._l(r.drd.control_mode, function (n) {
    return e("el-radio", {
      key: n.id,
      attrs: {
        size: "mini",
        label: n.id
      }
    }, [r._v(r._s(n.label))]);
  }), 1)], 1)]), r._v(" "), e("div", {
    staticClass: "form-item"
  }, [e("div", {
    staticClass: "label-box"
  }, [r._v("灯光模式")]), r._v(" "), e("div", {
    staticClass: "input-box"
  }, [e("el-radio-group", {
    on: {
      change: r.handle_change_light_mode
    },
    model: {
      value: r.light_mode,
      callback: function callback(n) {
        r.light_mode = n;
      },
      expression: "light_mode"
    }
  }, r._l(r.drd.light_mode, function (n) {
    return e("el-radio", {
      key: n.id,
      attrs: {
        size: "mini",
        label: n.id
      }
    }, [r._v(r._s(n.label))]);
  }), 1)], 1)]), r._v(" "), e("div", {
    staticClass: "form-item"
  }, [e("div", {
    staticClass: "label-box"
  }, [r._v("亮度")]), r._v(" "), e("div", {
    staticClass: "input-box"
  }, [e("el-radio-group", {
    on: {
      change: r.handle_change_brightness_mode
    },
    model: {
      value: r.brightness_mode,
      callback: function callback(n) {
        r.brightness_mode = n;
      },
      expression: "brightness_mode"
    }
  }, r._l(r.drd.brightness_mode, function (n) {
    return e("el-radio", {
      key: n.id,
      attrs: {
        size: "mini",
        label: n.id
      }
    }, [r._v(r._s(n.label))]);
  }), 1)], 1)])]), r._v(" "), e("div", {
    staticClass: "rocker-wrap"
  }, [e("div", {
    ref: "rocker",
    staticClass: "rocker"
  }, [e("div", {
    staticClass: "shangUp",
    on: {
      mousedown: function mousedown(n) {
        return r.fangxiang("up");
      },
      mouseup: r.stopfxFn,
      mouseout: r.stopfxFn
    }
  }), r._v(" "), e("div", {
    staticClass: "xaiUp",
    on: {
      mousedown: function mousedown(n) {
        return r.fangxiang("down");
      },
      mouseup: r.stopfxFn,
      mouseout: r.stopfxFn
    }
  }), r._v(" "), e("div", {
    staticClass: "zuoUp",
    on: {
      mousedown: function mousedown(n) {
        return r.fangxiang("left");
      },
      mouseup: r.stopfxFn,
      mouseout: r.stopfxFn
    }
  }), r._v(" "), e("div", {
    staticClass: "youUp",
    on: {
      mousedown: function mousedown(n) {
        return r.fangxiang("right");
      },
      mouseup: r.stopfxFn,
      mouseout: r.stopfxFn
    }
  })])])])]);
};
o._withStripped = !0;
var a = e({
  render: o,
  staticRenderFns: []
}, function (r) {
  r && r("data-v-10b922e8_0", {
    source: '.cpt-MMC_Gimbal_L60[data-v-10b922e8] {\n  position: absolute;\n  top: 0;\n  right: 0;\n  background: rgba(0, 23, 79, 0.7);\n  box-shadow: 0 2px 4px 0 rgba(1, 162, 255, 0.35), inset 0 0 40px 0 rgba(0, 184, 255, 0.5);\n  border-radius: 10px;\n  width: 500px;\n  height: 300px;\n  box-sizing: border-box;\n}\n.cpt-MMC_Gimbal_L60 .hd[data-v-10b922e8] {\n  display: flex;\n  justify-content: space-between;\n  background: rgba(16, 65, 215, 0.2);\n  box-shadow: inset 0 0 15px 0 rgba(0, 182, 255, 0.6);\n  border-radius: 10px 10px 0 0;\n}\n.cpt-MMC_Gimbal_L60 .hd .title[data-v-10b922e8] {\n  font-size: 18px;\n  color: #08c2d1;\n  font-weight: bold;\n  line-height: 2;\n  margin-left: 20px;\n}\n.cpt-MMC_Gimbal_L60 .hd .close[data-v-10b922e8] {\n  font-size: 18px;\n  color: #08c2d1;\n  font-weight: bold;\n  line-height: 2;\n  margin-right: 20px;\n  cursor: pointer;\n}\n.cpt-MMC_Gimbal_L60 .bd[data-v-10b922e8] {\n  padding: 10px 20px;\n  display: flex;\n  justify-content: space-between;\n}\n.cpt-MMC_Gimbal_L60 .bd .form-wrap[data-v-10b922e8] {\n  flex-shrink: 0;\n}\n.cpt-MMC_Gimbal_L60 .bd .form-wrap .form-item[data-v-10b922e8] {\n  display: flex;\n  align-items: center;\n  height: 40px;\n}\n.cpt-MMC_Gimbal_L60 .bd .form-wrap .form-item .label-box[data-v-10b922e8] {\n  color: #cbd0eb;\n  width: 75px;\n}\n.cpt-MMC_Gimbal_L60 .bd .form-wrap .form-item .btn-default[data-v-10b922e8] {\n  padding: 0 10px !important;\n  background: #2aefed;\n  border-color: #2aefed;\n}\n.cpt-MMC_Gimbal_L60 .bd .form-wrap .form-item .input-box[data-v-10b922e8] {\n  display: flex;\n  align-items: center;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap[data-v-10b922e8] {\n  flex: 1;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap .item-group[data-v-10b922e8] {\n  display: flex;\n  justify-content: space-evenly;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap .item-group .item-box .icon-box[data-v-10b922e8] {\n  width: 32px;\n  height: 32px;\n  background: #08c2d1;\n  border-radius: 32px;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap .item-group .item-box .icon-box .iconfont[data-v-10b922e8] {\n  font-size: 24px;\n  color: #dce9ff;\n  cursor: pointer;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap .rocker[data-v-10b922e8] {\n  margin: 10px auto 0;\n  width: 150px;\n  height: 150px;\n  position: relative;\n  margin: 0 auto;\n  background: center url("../assets/images/accident/caozuo.png") no-repeat;\n  background-size: 100% 100%;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap .rocker .shangUp[data-v-10b922e8] {\n  position: absolute;\n  left: 37%;\n  top: 4px;\n  border-radius: 50%;\n  width: 40px;\n  height: 40px;\n  border: 0px solid red;\n  cursor: pointer;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap .rocker .xaiUp[data-v-10b922e8] {\n  position: absolute;\n  left: 37%;\n  bottom: 4px;\n  border-radius: 50%;\n  width: 40px;\n  height: 40px;\n  border: 0px solid red;\n  cursor: pointer;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap .rocker .zuoUp[data-v-10b922e8] {\n  position: absolute;\n  left: 4px;\n  top: 37%;\n  border-radius: 50%;\n  width: 40px;\n  height: 40px;\n  border: 0px solid red;\n  cursor: pointer;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap .rocker .youUp[data-v-10b922e8] {\n  position: absolute;\n  right: 4px;\n  top: 37%;\n  border-radius: 50%;\n  width: 40px;\n  height: 40px;\n  border: 0px solid red;\n  cursor: pointer;\n}\n[data-v-10b922e8] .el-select {\n  width: 165px;\n  margin-right: 5px;\n}\n[data-v-10b922e8] .el-select .el-input .el-input__inner {\n  background: #000000;\n  border: 1px solid #08c2d1;\n  color: #dce9ff;\n}\n[data-v-10b922e8] .el-input {\n  width: 165px;\n  margin-right: 5px;\n}\n[data-v-10b922e8] .el-input .el-input__inner {\n  background: #000000;\n  border: 1px solid #08c2d1;\n  color: #dce9ff;\n}\n[data-v-10b922e8] .el-radio-group .el-radio .el-radio__input.is-checked .el-radio__inner {\n  border-color: #08c2d1;\n  background: #08c2d1;\n}\n[data-v-10b922e8] .el-radio-group .el-radio .el-radio__label {\n  color: #cbd0eb;\n}\n[data-v-10b922e8] .el-button {\n  background: #2aefed;\n  color: #000;\n  border: none;\n}\n[data-v-10b922e8] .el-slider__bar {\n  background: #fff;\n}\n.speedC[data-v-10b922e8] {\n  width: 203px;\n  height: 24px;\n  display: flex;\n  background: rgba(13, 34, 79, 0.65);\n  border: 1px solid #43deff;\n  border-radius: 12px;\n}\n.speedC .speed[data-v-10b922e8] {\n  width: 41px;\n  color: #ffffff;\n  border-radius: 12px;\n  text-align: center;\n  line-height: 24px;\n}\n.iconfont[data-v-10b922e8] {\n  color: #2aefed;\n}\n\n/*# sourceMappingURL=index.vue.map */',
    map: {
      version: 3,
      sources: ["E:\\work\\standardization\\mmc-stl-module\\src\\components\\MMCFlightControlCenter\\components\\mount\\MMC_Gimbal_L60\\index.vue", "index.vue"],
      names: [],
      mappings: "AAmXA;EACA,kBAAA;EACA,MAAA;EACA,QAAA;EACA,gCAAA;EACA,wFAAA;EACA,mBAAA;EACA,YAAA;EACA,aAAA;EACA,sBAAA;AClXA;ADoXA;EACA,aAAA;EACA,8BAAA;EACA,kCAAA;EACA,mDAAA;EACA,4BAAA;AClXA;ADmXA;EACA,eAAA;EACA,cAAA;EACA,iBAAA;EACA,cAAA;EACA,iBAAA;ACjXA;ADmXA;EACA,eAAA;EACA,cAAA;EACA,iBAAA;EACA,cAAA;EACA,kBAAA;EACA,eAAA;ACjXA;ADoXA;EACA,kBAAA;EACA,aAAA;EACA,8BAAA;AClXA;ADmXA;EACA,cAAA;ACjXA;ADkXA;EACA,aAAA;EACA,mBAAA;EACA,YAAA;AChXA;ADiXA;EACA,cAAA;EACA,WAAA;AC/WA;ADiXA;EACA,0BAAA;EACA,mBAAA;EACA,qBAAA;AC/WA;ADiXA;EACA,aAAA;EACA,mBAAA;AC/WA;ADmXA;EACA,OAAA;ACjXA;ADkXA;EACA,aAAA;EACA,6BAAA;AChXA;ADkXA;EACA,WAAA;EACA,YAAA;EACA,mBAAA;EACA,mBAAA;EACA,aAAA;EACA,mBAAA;EACA,uBAAA;AChXA;ADiXA;EACA,eAAA;EACA,cAAA;EACA,eAAA;AC/WA;ADoXA;EACA,mBAAA;EACA,YAAA;EACA,aAAA;EACA,kBAAA;EACA,cAAA;EACA,wEAAA;EACA,0BAAA;AClXA;ADmXA;EACA,kBAAA;EACA,SAAA;EACA,QAAA;EACA,kBAAA;EACA,WAAA;EACA,YAAA;EACA,qBAAA;EACA,eAAA;ACjXA;ADmXA;EACA,kBAAA;EACA,SAAA;EACA,WAAA;EACA,kBAAA;EACA,WAAA;EACA,YAAA;EACA,qBAAA;EACA,eAAA;ACjXA;ADmXA;EACA,kBAAA;EACA,SAAA;EACA,QAAA;EACA,kBAAA;EACA,WAAA;EACA,YAAA;EACA,qBAAA;EACA,eAAA;ACjXA;ADmXA;EACA,kBAAA;EACA,UAAA;EACA,QAAA;EACA,kBAAA;EACA,WAAA;EACA,YAAA;EACA,qBAAA;EACA,eAAA;ACjXA;ADyXA;EACA,YAAA;EACA,iBAAA;ACtXA;ADwXA;EACA,mBAAA;EACA,yBAAA;EACA,cAAA;ACtXA;AD0XA;EACA,YAAA;EACA,iBAAA;ACxXA;ADyXA;EACA,mBAAA;EACA,yBAAA;EACA,cAAA;ACvXA;AD8XA;EACA,qBAAA;EACA,mBAAA;AC5XA;ADgYA;EACA,cAAA;AC9XA;ADkYA;EACA,mBAAA;EACA,WAAA;EACA,YAAA;AChYA;ADmYA;EACA,gBAAA;AChYA;ADkYA;EACA,YAAA;EACA,YAAA;EACA,aAAA;EACA,kCAAA;EACA,yBAAA;EACA,mBAAA;AC/XA;ADgYA;EACA,WAAA;EAEA,cAAA;EACA,mBAAA;EACA,kBAAA;EACA,iBAAA;AC/XA;ADkYA;EACA,cAAA;AC/XA;;AAEA,oCAAoC",
      file: "index.vue",
      sourcesContent: ['<template>\r\n  <div class="cpt-MMC_Gimbal_L60" :style="containerStyle">\r\n    <div v-interact class="hd">\r\n      <div class="title">探照灯</div>\r\n      <div class="close" @click="$emit(\'close\')">关闭</div>\r\n    </div>\r\n    <div class="bd">\r\n      <div class="form-wrap">\r\n        <div class="form-item">\r\n          <div class="label-box">控制速度</div>\r\n          <div class="input-box">\r\n            <div class="speedC">\r\n              <div\r\n                v-for="(item, index) in new Array(5).fill(1)"\r\n                :key="index"\r\n                class="speed"\r\n                :style="control_speed == index + 1 ? \'background: #FFFFFF;color: #333333;\' : \'\'"\r\n                @click="control_speed = index + 1"\r\n              >\r\n                {{ index + 1 }}\r\n              </div>\r\n            </div>\r\n            \x3c!-- <el-select\r\n              v-model="control_speed"\r\n              size="mini"\r\n              placeholder="请选择控制速度"\r\n            >\r\n              <el-option\r\n                v-for="(item, index) in new Array(5).fill(1)"\r\n                :key="index"\r\n                :label="index + 1"\r\n                :value="index + 1"\r\n              ></el-option>\r\n            </el-select> --\x3e\r\n          </div>\r\n        </div>\r\n        \x3c!--  --\x3e\r\n        <div class="form-item">\r\n          <div class="label-box">模式</div>\r\n          <div class="input-box">\r\n            <el-radio-group v-model="mode" @change="handle_change_mode">\r\n              <el-radio v-for="item in drd.mode" :key="item.id" size="mini" :label="item.id">{{\r\n                item.label\r\n              }}</el-radio>\r\n            </el-radio-group>\r\n          </div>\r\n        </div>\r\n        \x3c!--  --\x3e\r\n        <div class="form-item">\r\n          <div class="label-box">功率</div>\r\n          <div class="input-box">\r\n            <el-radio-group v-model="pow_mode" @change="handle_change_pow_mode">\r\n              <el-radio v-for="item in drd.pow_mode" :key="item.id" size="mini" :label="item.id">{{\r\n                item.label\r\n              }}</el-radio>\r\n            </el-radio-group>\r\n          </div>\r\n        </div>\r\n        <div class="form-item">\r\n          <div class="label-box">联控模式</div>\r\n          <div class="input-box">\r\n            <el-radio-group v-model="control_mode" @change="handle_change_control_mode">\r\n              <el-radio\r\n                v-for="item in drd.control_mode"\r\n                :key="item.id"\r\n                size="mini"\r\n                :label="item.id"\r\n                >{{ item.label }}</el-radio\r\n              >\r\n            </el-radio-group>\r\n          </div>\r\n        </div>\r\n        <div class="form-item">\r\n          <div class="label-box">灯光模式</div>\r\n          <div class="input-box">\r\n            <el-radio-group v-model="light_mode" @change="handle_change_light_mode">\r\n              <el-radio\r\n                v-for="item in drd.light_mode"\r\n                :key="item.id"\r\n                size="mini"\r\n                :label="item.id"\r\n                >{{ item.label }}</el-radio\r\n              >\r\n            </el-radio-group>\r\n          </div>\r\n        </div>\r\n        <div class="form-item">\r\n          <div class="label-box">亮度</div>\r\n          <div class="input-box">\r\n            <el-radio-group v-model="brightness_mode" @change="handle_change_brightness_mode">\r\n              <el-radio\r\n                v-for="item in drd.brightness_mode"\r\n                :key="item.id"\r\n                size="mini"\r\n                :label="item.id"\r\n                >{{ item.label }}</el-radio\r\n              >\r\n            </el-radio-group>\r\n          </div>\r\n        </div>\r\n      </div>\r\n      <div class="rocker-wrap">\r\n        <div ref="rocker" class="rocker">\r\n          <div\r\n            class="shangUp"\r\n            @mousedown="fangxiang(\'up\')"\r\n            @mouseup="stopfxFn"\r\n            @mouseout="stopfxFn"\r\n          />\r\n          <div\r\n            class="xaiUp"\r\n            @mousedown="fangxiang(\'down\')"\r\n            @mouseup="stopfxFn"\r\n            @mouseout="stopfxFn"\r\n          />\r\n          <div\r\n            class="zuoUp"\r\n            @mousedown="fangxiang(\'left\')"\r\n            @mouseup="stopfxFn"\r\n            @mouseout="stopfxFn"\r\n          />\r\n          <div\r\n            class="youUp"\r\n            @mousedown="fangxiang(\'right\')"\r\n            @mouseup="stopfxFn"\r\n            @mouseout="stopfxFn"\r\n          />\r\n        </div>\r\n      </div>\r\n    </div>\r\n  </div>\r\n</template>\r\n\r\n<script>\r\nimport { cal_crc_table, MMC_Gimbal_L60 } from \'../utils\';\r\nexport default {\r\n  props: {\r\n    containerStyle: {\r\n      type: Object,\r\n      default: () => ({})\r\n    },\r\n    position: {\r\n      type: Object,\r\n      default: () => ({})\r\n    },\r\n    payload: {\r\n      type: Array,\r\n      default: () => []\r\n    }\r\n  },\r\n  data() {\r\n    return {\r\n      time: null,\r\n      radio: 1,\r\n      timer: null,\r\n      control_speed: 3,\r\n      mode: 1,\r\n      zoom: 1,\r\n      pitch: 0,\r\n      yaw: 0,\r\n      pow_mode: 0,\r\n      control_mode: 0,\r\n      light_mode: 0,\r\n      brightness_mode: 0,\r\n      record: false,\r\n\r\n      drd: {\r\n        mode: [\r\n          { id: 1, label: \'跟随\' },\r\n          { id: 2, label: \'回中\' }\r\n        ],\r\n        pow_mode: [\r\n          { id: 0, label: \'普通\' },\r\n          { id: 1, label: \'最高\' }\r\n        ],\r\n        control_mode: [\r\n          { id: 0, label: \'关\' },\r\n          { id: 1, label: \'开\' }\r\n        ],\r\n        light_mode: [\r\n          { id: 0, label: \'关\' },\r\n          { id: 1, label: \'开\' },\r\n          { id: 2, label: \'闪\' }\r\n        ],\r\n        brightness_mode: [\r\n          { id: 0, label: \'亮\' },\r\n          { id: 1, label: \'高亮\' },\r\n          { id: 2, label: \'极亮\' }\r\n        ]\r\n      }\r\n    };\r\n  },\r\n  watch: {\r\n    payload: {\r\n      handler(value) {\r\n        this.resolve_payload(value);\r\n      },\r\n      deep: true\r\n    }\r\n  },\r\n  mounted() {\r\n    this.$nextTick(() => {\r\n      this.init_rocker();\r\n    });\r\n  },\r\n  methods: {\r\n    resolve_payload(buff) {\r\n      const dataArray = new Uint8Array(buff);\r\n      if (dataArray[0] === 0xa5 && cal_crc_table(dataArray) === dataArray[dataArray.length - 1]) {\r\n        switch (dataArray[1]) {\r\n          case 0x01:\r\n            this.msg_key_status1(dataArray);\r\n            break;\r\n          case 0xf8:\r\n            this.gcs_button_ctrl(dataArray);\r\n            break;\r\n        }\r\n      }\r\n    },\r\n    gcs_button_ctrl(data) {\r\n      const button = data[3];\r\n      const status = data[4];\r\n\r\n      switch (button) {\r\n        case 4:\r\n          this.gimbal_mode_ctrl(status);\r\n          break;\r\n        default:\r\n          break;\r\n      }\r\n    },\r\n    msg_key_status1(data) {\r\n      this.gimbal_mode_ctrl(data[7] & 0x3);\r\n    },\r\n    gimbal_mode_ctrl(mode) {\r\n      this.ptz_mode = mode;\r\n    },\r\n    handle_change_mode(value) {\r\n      const buffer = MMC_Gimbal_L60.gimbal_mode_ctrl(value);\r\n      this.commit_directive(buffer);\r\n    },\r\n    handle_change_light_mode(value) {\r\n      const buffer = MMC_Gimbal_L60.gimbal_light_mode_ctrl(value);\r\n      this.commit_directive(buffer);\r\n    },\r\n    handle_change_brightness_mode(value) {\r\n      const buffer = MMC_Gimbal_L60.gimbal_brightness_mode_ctrl(value);\r\n      this.commit_directive(buffer);\r\n    },\r\n    handle_zoom(value) {\r\n      let buffer = MMC_Gimbal_L60.zoom(this.zoom + value);\r\n      this.commit_directive(buffer);\r\n      buffer = MMC_Gimbal_L60.zoom((this.zoom = 1));\r\n      this.commit_directive(buffer);\r\n    },\r\n    handle_change_pitch() {\r\n      const buffer = MMC_Gimbal_L60.change_pitch_angle(this.pitch);\r\n      this.commit_directive(buffer);\r\n    },\r\n    handle_change_yaw() {\r\n      const buffer = MMC_Gimbal_L60.change_yaw_angle(this.yaw);\r\n      this.commit_directive(buffer);\r\n    },\r\n    handle_change_camera_mode(value) {\r\n      const buffer = MMC_Gimbal_L60.camera_mode_ctrl(value);\r\n      this.commit_directive(buffer);\r\n    },\r\n    handle_change_pow_mode(mode) {\r\n      const buffer = MMC_Gimbal_L60.pow_mode_ctrl(mode);\r\n      this.commit_directive(buffer);\r\n    },\r\n    handle_change_control_mode(mode) {\r\n      const buffer = MMC_Gimbal_L60.control_mode_ctrl(mode);\r\n      this.commit_directive(buffer);\r\n    },\r\n    handle_take_photo() {\r\n      const { position } = this;\r\n      const buffer = MMC_Gimbal_L60.take_photo(position || {});\r\n      this.commit_directive(buffer);\r\n    },\r\n    handle_record() {\r\n      this.record = !this.record;\r\n      const buffer = MMC_Gimbal_L60.record(this.record);\r\n      this.commit_directive(buffer);\r\n    },\r\n    commit_directive(buffer) {\r\n      console.log(buffer);\r\n      this.$emit(\'directive\', buffer);\r\n    },\r\n    stopfxFn() {\r\n      this.flag = false;\r\n      clearTimeout(this.time);\r\n      let buffer = null;\r\n      buffer = MMC_Gimbal_L60.gimbal_pitch_ctrl(0, this.control_speed);\r\n      this.commit_directive(buffer);\r\n      buffer = MMC_Gimbal_L60.gimbal_yaw_ctrl(0, this.control_speed);\r\n      this.commit_directive(buffer);\r\n    },\r\n    fangxiang(type) {\r\n      clearTimeout(this.time);\r\n      let buffer = null;\r\n      this.flag = true;\r\n      if (this.flag) {\r\n        this.time = setTimeout(() => {\r\n          this.fangxiang(type);\r\n        }, 500);\r\n      }\r\n      switch (type) {\r\n        case \'up\':\r\n          buffer = MMC_Gimbal_L60.gimbal_pitch_ctrl(1, this.control_speed);\r\n          this.commit_directive(buffer);\r\n          break;\r\n        case \'right\':\r\n          buffer = MMC_Gimbal_L60.gimbal_yaw_ctrl(1, this.control_speed);\r\n          this.commit_directive(buffer);\r\n          break;\r\n        case \'left\':\r\n          buffer = MMC_Gimbal_L60.gimbal_yaw_ctrl(-1, this.control_speed);\r\n          this.commit_directive(buffer);\r\n          break;\r\n        case \'down\':\r\n          buffer = MMC_Gimbal_L60.gimbal_pitch_ctrl(-1, this.control_speed);\r\n          this.commit_directive(buffer);\r\n      }\r\n      // this.timer = setTimeout(() => {\r\n      //   clearTimeout(this.timer);\r\n      //   buffer = MMC_Gimbal_L60.gimbal_pitch_ctrl(0, this.control_speed);\r\n      //   this.commit_directive(buffer);\r\n      //   buffer = MMC_Gimbal_L60.gimbal_yaw_ctrl(0, this.control_speed);\r\n      //   this.commit_directive(buffer);\r\n      // }, 500);\r\n    },\r\n    init_rocker() {\r\n      let buffer = null;\r\n      joystick({\r\n        // zone: this.$refs["rocker"],\r\n        // mode: "static",\r\n        // position: { left: "50%", top: "50%" },\r\n        // color: "#9bacbe",\r\n        onstart: (type) => {\r\n          switch (type) {\r\n            case \'up\':\r\n              buffer = MMC_Gimbal_L60.gimbal_pitch_ctrl(1, this.control_speed);\r\n              this.commit_directive(buffer);\r\n              break;\r\n            case \'right\':\r\n              buffer = MMC_Gimbal_L60.gimbal_yaw_ctrl(1, this.control_speed);\r\n              this.commit_directive(buffer);\r\n              break;\r\n            case \'left\':\r\n              buffer = MMC_Gimbal_L60.gimbal_yaw_ctrl(-1, this.control_speed);\r\n              this.commit_directive(buffer);\r\n              break;\r\n            case \'down\':\r\n              buffer = MMC_Gimbal_L60.gimbal_pitch_ctrl(-1, this.control_speed);\r\n              this.commit_directive(buffer);\r\n          }\r\n        },\r\n        onend: () => {\r\n          buffer = MMC_Gimbal_L60.gimbal_pitch_ctrl(0, this.control_speed);\r\n          this.commit_directive(buffer);\r\n          buffer = MMC_Gimbal_L60.gimbal_yaw_ctrl(0, this.control_speed);\r\n          this.commit_directive(buffer);\r\n        }\r\n      });\r\n    }\r\n  }\r\n};\r\n<\/script>\r\n\r\n<style lang="scss" scoped>\r\n.cpt-MMC_Gimbal_L60 {\r\n  position: absolute;\r\n  top: 0;\r\n  right: 0;\r\n  background: rgba(0, 23, 79, 0.7);\r\n  box-shadow: 0 2px 4px 0 rgba(1, 162, 255, 0.35), inset 0 0 40px 0 rgba(0, 184, 255, 0.5);\r\n  border-radius: 10px;\r\n  width: 500px;\r\n  height: 300px;\r\n  box-sizing: border-box;\r\n  // padding: 10px 20px;\r\n  .hd {\r\n    display: flex;\r\n    justify-content: space-between;\r\n    background: rgba(16, 65, 215, 0.2);\r\n    box-shadow: inset 0 0 15px 0 rgba(0, 182, 255, 0.6);\r\n    border-radius: 10px 10px 0 0;\r\n    .title {\r\n      font-size: 18px;\r\n      color: #08c2d1;\r\n      font-weight: bold;\r\n      line-height: 2;\r\n      margin-left: 20px;\r\n    }\r\n    .close {\r\n      font-size: 18px;\r\n      color: #08c2d1;\r\n      font-weight: bold;\r\n      line-height: 2;\r\n      margin-right: 20px;\r\n      cursor: pointer;\r\n    }\r\n  }\r\n  .bd {\r\n    padding: 10px 20px;\r\n    display: flex;\r\n    justify-content: space-between;\r\n    .form-wrap {\r\n      flex-shrink: 0;\r\n      .form-item {\r\n        display: flex;\r\n        align-items: center;\r\n        height: 40px;\r\n        .label-box {\r\n          color: #cbd0eb;\r\n          width: 75px;\r\n        }\r\n        .btn-default {\r\n          padding: 0 10px !important;\r\n          background: #2aefed;\r\n          border-color: #2aefed;\r\n        }\r\n        .input-box {\r\n          display: flex;\r\n          align-items: center;\r\n        }\r\n      }\r\n    }\r\n    .rocker-wrap {\r\n      flex: 1;\r\n      .item-group {\r\n        display: flex;\r\n        justify-content: space-evenly;\r\n        .item-box {\r\n          .icon-box {\r\n            width: 32px;\r\n            height: 32px;\r\n            background: #08c2d1;\r\n            border-radius: 32px;\r\n            display: flex;\r\n            align-items: center;\r\n            justify-content: center;\r\n            .iconfont {\r\n              font-size: 24px;\r\n              color: #dce9ff;\r\n              cursor: pointer;\r\n            }\r\n          }\r\n        }\r\n      }\r\n      .rocker {\r\n        margin: 10px auto 0;\r\n        width: 150px;\r\n        height: 150px;\r\n        position: relative;\r\n        margin: 0 auto;\r\n        background: center url(\'../assets/images/accident/caozuo.png\') no-repeat;\r\n        background-size: 100% 100%;\r\n        .shangUp {\r\n          position: absolute;\r\n          left: 37%;\r\n          top: 4px;\r\n          border-radius: 50%;\r\n          width: 40px;\r\n          height: 40px;\r\n          border: 0px solid red;\r\n          cursor: pointer;\r\n        }\r\n        .xaiUp {\r\n          position: absolute;\r\n          left: 37%;\r\n          bottom: 4px;\r\n          border-radius: 50%;\r\n          width: 40px;\r\n          height: 40px;\r\n          border: 0px solid red;\r\n          cursor: pointer;\r\n        }\r\n        .zuoUp {\r\n          position: absolute;\r\n          left: 4px;\r\n          top: 37%;\r\n          border-radius: 50%;\r\n          width: 40px;\r\n          height: 40px;\r\n          border: 0px solid red;\r\n          cursor: pointer;\r\n        }\r\n        .youUp {\r\n          position: absolute;\r\n          right: 4px;\r\n          top: 37%;\r\n          border-radius: 50%;\r\n          width: 40px;\r\n          height: 40px;\r\n          border: 0px solid red;\r\n          cursor: pointer;\r\n        }\r\n      }\r\n    }\r\n  }\r\n}\r\n\r\n::v-deep {\r\n  .el-select {\r\n    width: 165px;\r\n    margin-right: 5px;\r\n    .el-input {\r\n      .el-input__inner {\r\n        background: #000000;\r\n        border: 1px solid #08c2d1;\r\n        color: #dce9ff;\r\n      }\r\n    }\r\n  }\r\n  .el-input {\r\n    width: 165px;\r\n    margin-right: 5px;\r\n    .el-input__inner {\r\n      background: #000000;\r\n      border: 1px solid #08c2d1;\r\n      color: #dce9ff;\r\n    }\r\n  }\r\n  .el-radio-group {\r\n    .el-radio {\r\n      .el-radio__input {\r\n        &.is-checked {\r\n          .el-radio__inner {\r\n            border-color: #08c2d1;\r\n            background: #08c2d1;\r\n          }\r\n        }\r\n      }\r\n      .el-radio__label {\r\n        color: #cbd0eb;\r\n      }\r\n    }\r\n  }\r\n  .el-button {\r\n    background: #2aefed;\r\n    color: #000;\r\n    border: none;\r\n  }\r\n}\r\n::v-deep .el-slider__bar {\r\n  background: #fff;\r\n}\r\n.speedC {\r\n  width: 203px;\r\n  height: 24px;\r\n  display: flex;\r\n  background: rgba(13, 34, 79, 0.65);\r\n  border: 1px solid #43deff;\r\n  border-radius: 12px;\r\n  .speed {\r\n    width: 41px;\r\n    // background: #FFFFFF;\r\n    color: #ffffff;\r\n    border-radius: 12px;\r\n    text-align: center;\r\n    line-height: 24px;\r\n  }\r\n}\r\n.iconfont {\r\n  color: #2aefed;\r\n}\r\n</style>\r\n', '.cpt-MMC_Gimbal_L60 {\n  position: absolute;\n  top: 0;\n  right: 0;\n  background: rgba(0, 23, 79, 0.7);\n  box-shadow: 0 2px 4px 0 rgba(1, 162, 255, 0.35), inset 0 0 40px 0 rgba(0, 184, 255, 0.5);\n  border-radius: 10px;\n  width: 500px;\n  height: 300px;\n  box-sizing: border-box;\n}\n.cpt-MMC_Gimbal_L60 .hd {\n  display: flex;\n  justify-content: space-between;\n  background: rgba(16, 65, 215, 0.2);\n  box-shadow: inset 0 0 15px 0 rgba(0, 182, 255, 0.6);\n  border-radius: 10px 10px 0 0;\n}\n.cpt-MMC_Gimbal_L60 .hd .title {\n  font-size: 18px;\n  color: #08c2d1;\n  font-weight: bold;\n  line-height: 2;\n  margin-left: 20px;\n}\n.cpt-MMC_Gimbal_L60 .hd .close {\n  font-size: 18px;\n  color: #08c2d1;\n  font-weight: bold;\n  line-height: 2;\n  margin-right: 20px;\n  cursor: pointer;\n}\n.cpt-MMC_Gimbal_L60 .bd {\n  padding: 10px 20px;\n  display: flex;\n  justify-content: space-between;\n}\n.cpt-MMC_Gimbal_L60 .bd .form-wrap {\n  flex-shrink: 0;\n}\n.cpt-MMC_Gimbal_L60 .bd .form-wrap .form-item {\n  display: flex;\n  align-items: center;\n  height: 40px;\n}\n.cpt-MMC_Gimbal_L60 .bd .form-wrap .form-item .label-box {\n  color: #cbd0eb;\n  width: 75px;\n}\n.cpt-MMC_Gimbal_L60 .bd .form-wrap .form-item .btn-default {\n  padding: 0 10px !important;\n  background: #2aefed;\n  border-color: #2aefed;\n}\n.cpt-MMC_Gimbal_L60 .bd .form-wrap .form-item .input-box {\n  display: flex;\n  align-items: center;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap {\n  flex: 1;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap .item-group {\n  display: flex;\n  justify-content: space-evenly;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap .item-group .item-box .icon-box {\n  width: 32px;\n  height: 32px;\n  background: #08c2d1;\n  border-radius: 32px;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap .item-group .item-box .icon-box .iconfont {\n  font-size: 24px;\n  color: #dce9ff;\n  cursor: pointer;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap .rocker {\n  margin: 10px auto 0;\n  width: 150px;\n  height: 150px;\n  position: relative;\n  margin: 0 auto;\n  background: center url("../assets/images/accident/caozuo.png") no-repeat;\n  background-size: 100% 100%;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap .rocker .shangUp {\n  position: absolute;\n  left: 37%;\n  top: 4px;\n  border-radius: 50%;\n  width: 40px;\n  height: 40px;\n  border: 0px solid red;\n  cursor: pointer;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap .rocker .xaiUp {\n  position: absolute;\n  left: 37%;\n  bottom: 4px;\n  border-radius: 50%;\n  width: 40px;\n  height: 40px;\n  border: 0px solid red;\n  cursor: pointer;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap .rocker .zuoUp {\n  position: absolute;\n  left: 4px;\n  top: 37%;\n  border-radius: 50%;\n  width: 40px;\n  height: 40px;\n  border: 0px solid red;\n  cursor: pointer;\n}\n.cpt-MMC_Gimbal_L60 .bd .rocker-wrap .rocker .youUp {\n  position: absolute;\n  right: 4px;\n  top: 37%;\n  border-radius: 50%;\n  width: 40px;\n  height: 40px;\n  border: 0px solid red;\n  cursor: pointer;\n}\n\n::v-deep .el-select {\n  width: 165px;\n  margin-right: 5px;\n}\n::v-deep .el-select .el-input .el-input__inner {\n  background: #000000;\n  border: 1px solid #08c2d1;\n  color: #dce9ff;\n}\n::v-deep .el-input {\n  width: 165px;\n  margin-right: 5px;\n}\n::v-deep .el-input .el-input__inner {\n  background: #000000;\n  border: 1px solid #08c2d1;\n  color: #dce9ff;\n}\n::v-deep .el-radio-group .el-radio .el-radio__input.is-checked .el-radio__inner {\n  border-color: #08c2d1;\n  background: #08c2d1;\n}\n::v-deep .el-radio-group .el-radio .el-radio__label {\n  color: #cbd0eb;\n}\n::v-deep .el-button {\n  background: #2aefed;\n  color: #000;\n  border: none;\n}\n\n::v-deep .el-slider__bar {\n  background: #fff;\n}\n\n.speedC {\n  width: 203px;\n  height: 24px;\n  display: flex;\n  background: rgba(13, 34, 79, 0.65);\n  border: 1px solid #43deff;\n  border-radius: 12px;\n}\n.speedC .speed {\n  width: 41px;\n  color: #ffffff;\n  border-radius: 12px;\n  text-align: center;\n  line-height: 24px;\n}\n\n.iconfont {\n  color: #2aefed;\n}\n\n/*# sourceMappingURL=index.vue.map */']
    },
    media: void 0
  });
}, t, "data-v-10b922e8", false, undefined, !1, i);
export { a as default };
