# 项目描述

基于城市之鹰的前端标准化组件库

# 项目部署

* yarn  
  `yarn ` 安装依赖  
  `cd vue2` 进入演示项目
  `yarn` 安装依赖
  `yarn serve` 启动本地服务  
* npm  
  `npm i` 安装依赖  
  `cd vue2` 进入演示项目
  `npm i ` 安装依赖
  `npm run serve` 启动本地服务  

* 不建议使用cnpm, 会生成.store目录, 并且会使用webpack5进行打包并出错, 本项目只能使用webpack4进行打包

# npm调试组件方法
* cnpm link （将npm包链接到本地全局目录（node_modules）下面，建议使用cnpm而不是npm，速度差很多）
* cd vue2 后执行 cnpm link mmc-stl-vue2 （在主项目中引用上一步挂到全局的软链接）
* npm run dev (开启演示项目服务)

# 项目引入方法：
`npm install git+http://git.mmcuav.cn/root/mmc-stl-vue2.git`  
若失败,使用yarn (可以在npm或cnpm安装的依赖环境下执行yarn add)
`yarn add git+http://git.mmcuav.cn/root/mmc-stl-vue2.git`
```
//main.js
import MMCSTL from 'mmc-stl-vue2';
Vue.use(MMCSTL);
```
# 备注
由于是使用git而非npm仓库, 不会自动拉取相应依赖, package.json中的dependencies依赖要复制到项目的package.json文件中.

生成目录树请安装  
`npm install -g tree-node-cli`  
执行以下命令生成  
`treee -I "node_modules|.idea|objects|.git|.vscode|dist|.png|.jpg|.svg|.gif|.mp4|cesium|index.vue|index.js" -a > tree.txt --dirs-first -d -L 3`

# 待解决问题
* css中的图片资源内联
* 非VUE2项目集成

# 版本
## v1.2.0
* 新增飞控中心模块
* 新增rollup打包配置
## v1.2.1
* 优化rollup打包配置
* 修正外部平台集成时的问题
## v1.2.2
* 修正iconfont.css样式冲突
## v1.2.3
* 修正机库定位图标样式冲突
## v1.2.4
* iframe集成修正
## v1.3.0
* 新增地图搜索功能
## v1.4.0
* 增加使用非标准航线库的支持
## v1.4.1
* 修正航线数据结构混乱
## v1.5.0
* 修正机库指令
* 增加是否定支持定时任务的判断
* 修正多个缺陷
## v1.6.0
* MQTT新增账号密码
## 1.6.1
* fix: 文件名大小写错误

## 项目结构
```
├── src                           组件源码
│   ├── assets                    资源文件
│   │   └── img
│   │       ├── fckernel
│   │       ├── home
│   │       ├── mount
│   │       ├── nest
│   │       ├── nest_v2
│   │       └── weather
│   ├── components                组件库
│   │   ├── MMCCodeDemo           源码案例组件
│   │   ├── MMCDataTransferPanel  数值面板组件
│   │   │   ├── assets
│   │   │   ├── components
│   │   │   ├── controlList
│   │   │   ├── controlMenu
│   │   │   ├── logger
│   │   │   └── videoTomap
│   │   ├── MMCPlayer             播放器组件
│   │   │   ├── assets
│   │   │   ├── components
│   │   │   └── lib
│   │   ├── MMCUavList            无人机列表组件
│   │   │   └── item
│   │   └── symbol-icon
│   ├── directives                指令库
│   ├── lib                       js依赖库
│   ├── observe                   
│   │   ├── fckernel
│   │   │   ├── methods
│   │   │   ├── nest
│   │   │   └── uav
│   │   └── fckernelVideos
│   │       ├── components
│   │       ├── data
│   │       └── methods
│   ├── plugins
│   │   └── MMCMQTT               mqtt插件
│   └── style                     全局样式
│       └── fonts
├── types                         ts需要的types
└── vue2                          案例网站源码
    ├── public
    │   ├── js
    │   └── liveplayer
    └── src
        ├── assets
        ├── components            公共组件
        ├── router                路由
        └── views                 页面
            ├── dataTransferPanel 数传面板页面
            ├── mount             挂载页面
            ├── mqtt              mqtt页面
            ├── player            播放器页面
            └── uavList           无人机列表页面
```