import API from "@/api";
export default {
    // 日志
    async operationTextFn(operationText) {
        await API.HOME.uavOperationLog({
            operationText,
        });
    },
    task_update(id, status, deviceHardId) {
        API.DEVICE.task_update({
            id,
            status,
            deviceHardId,
        });
    },
    // 激活无人机
    jhwrj(item, data) {
        let {
            id,
            deviceHardId
        } = data;
        this.jhFlag = true;
        this.$emit("fn", item.data);
        let operationText =
            "飞控中心-执行" +
            "激活无人机操作," +
            `设备id：${deviceHardId}` +
            `任务id：${id}`;
        this.operationTextFn(operationText);
        this.$message.success("操作成功");

    },
    // 一键起飞
    async yjqf(item, data) {
        let {
            id,
            deviceHardId
        } = data;
        if (!this.jhFlag) return this.$message.warning("请激活无人机");
        let checkBeforeTakeOff = await API.DEVICE.checkBeforeTakeOff({
            taskId: id,
        });
        console.log(checkBeforeTakeOff, "checkBeforeTakeOff");
        // 起飞前的校验
        if (!checkBeforeTakeOff.code) {
            this.uav_This.uav.LsdomVlue = checkBeforeTakeOff;
            this.uav_This.uav.LsdomFlag = true;
            return false;
        }

        let getFlightSortic = await API.DEVICE.getFlightSortic({
            taskId: id,
            deviceHardId,
        });
        console.log('架次号', getFlightSortic);
        // 告诉飞控中心任务和架次号
        this.$emit("fn", {
            data: {
                taskId: id,
                flightSortiesID: getFlightSortic,
            },
            type: 769,
        });
        // 执行一键起飞任务
        this.$emit("fn", item.data);
        let operationText =
            "飞控中心-执行" +
            "一件起飞操作," +
            `设备id：${deviceHardId}` +
            `任务id：${id}`;
        this.operationTextFn(operationText);
        // 一键起飞任务监听
        API.TASK.flytaskLisener({
            taskId: id,
            deviceHardId,
        });
        // 更改任务状态
        this.task_update(id, 3, deviceHardId);
        this.$message.success("操作成功");
    },
    // 航线暂停
    stop(item, data) {
        let {
            id,
            deviceHardId
        } = data;

        // 执行航线暂停操作
        this.$emit("fn", item.data);
        let operationText =
            "飞控中心-执行" +
            "航线暂停操作," +
            `设备id：${deviceHardId}` +
            `任务id：${id}`;
        this.operationTextFn(operationText);
        this.$message.success("操作成功");
    },
    continue (item, data) {
        let {
            id,
            deviceHardId
        } = data;
        // 执行航线暂停操作
        this.$emit("fn", item.data);
        let operationText =
            "飞控中心-执行" +
            "继续航线操作," +
            `设备id：${deviceHardId}` +
            `任务id：${id}`;
        this.operationTextFn(operationText);
        this.$message.success("操作成功");
    },
    // 结束航线
    end(item, data) {
        let {
            id,
            deviceHardId
        } = data;
        // 结束航线操作
        this.$emit("fn", item.data);
        // 告诉飞控中心任务结束
        this.$emit("fn", {
            data: null,
            type: 769,
        });
        // 结束任务
        this.task_update(id, 4, deviceHardId);
        let operationText =
            "飞控中心-执行" +
            "结束任务操作," +
            `设备id：${deviceHardId}` +
            `任务id：${id}`;
        this.operationTextFn(operationText);
        this.$message.success("操作成功");
    },
    // 一键返航
    yjfh(item, data) {
        let {
            id,
            deviceHardId
        } = data;
        // 执行一键返航操作
        this.$emit("fn", item.data);
        let operationText =
            "飞控中心-执行" +
            "一键返航操作," +
            `设备id：${deviceHardId}` +
            `任务id：${id}`;
        this.operationTextFn(operationText);
        this.$message.success("操作成功");
    },
    // 安全降落
    aqjl(item, data) {
        let {
            id,
            deviceHardId
        } = data;
        // 执行一键安全降落
        this.$emit("fn", item.data);
        let operationText =
            "飞控中心-执行" +
            "安全降落操作," +
            `设备id：${deviceHardId}` +
            `任务id：${id}`;
        this.operationTextFn(operationText);
        this.$message.success("操作成功");
    },

}