export default `
<template>
  <div>
    <el-form>
      <el-form-item label="地面站地址">
        <el-input v-model="url"></el-input>
      </el-form-item>
      <el-form-item label="账号">
        <el-input v-model="account"></el-input>
      </el-form-item>
      <el-form-item label="密码">
        <el-input v-model="password"></el-input>
      </el-form-item>
      <el-button @click="login">登录</el-button>
      <el-form-item label="个人信息">{{ userInfo }}</el-form-item>
      <el-form-item label="无人机id">
        <el-input v-model="deviceHardId"></el-input>
      </el-form-item>

      <el-form-item label="操作">
        <el-button @click="connect">连接地面站ws</el-button>
        <el-button @click="subscribe">订阅</el-button>
        <el-button @click="unsubscribe">取消订阅</el-button>
        <el-button @click="publish()">通过原始type发送指令</el-button>
        <el-button @click="order({order: '降落'})">通过关键字发送指令</el-button>
        <el-button @click="addCallback">添加事件回调</el-button>
        <el-button @click="removeCallback">移除事件回调</el-button>
      </el-form-item>
      <el-form-item label="支持的指令">{{ orders }}</el-form-item>
    </el-form>
    <div>{{ text }}</div>
    <div>{{ callbackText }}</div>
  </div>
</template>

<script>
import { Base64 } from "js-base64"

export default {
  name: "GroundStation",
  data() {
    return {
      account: "wjc",
      password: "123456",
      deviceHardId: "",
      userInfo: {
        username: "",
        // token: "5e93559e5d00ed4dda7d75f9502ea9d83b8c15cb54672b4262dc85d0669ee53d",
        appId: "40003",
        // 'task-id': 1448
      },
      callbackText: "",
      url: "wss://test.tmj.mmcuav.cn/websocket"
    };
  },
  computed: {
    text() {
      return this.$store.state.MMCGroundStation.dataSet;
    },
    orders() {
      return this.$store.state.MMCGroundStation.orders;
    },
  },
  async created() {},
  methods: {
    async login() {
      let formData = new FormData();
      formData.append("userAccount", this.account);
      formData.append("password", Base64.encode(this.password));
      let res1 = await fetch("/crm/login", {
        method: "post",
        headers: {
          // "Content-Type": "multipart/form-data",
        },
        body: formData,
      });
      let data1 = await res1.json();

      if (data1.code == 200) {
        this.userInfo.username = data1.data.userName;
        this.userInfo.token = data1.data.token;
      }
    },
    async connect() {
      try {
        await this.$store.dispatch("MMCGroundStation/init", {
          url: this.url,
          userInfo: this.userInfo,
        });
      } catch (e) {
        console.log("地面站连接失败", e);
      }
      console.log("地面站连接成功");
    },
    subscribe() {
      this.$store.dispatch("MMCGroundStation/subscribe", this.deviceHardId);
    },
    unsubscribe() {
      this.$store.dispatch("MMCGroundStation/unsubscribe", this.deviceHardId);
    },
    publish() {
      this.$store.dispatch("MMCGroundStation/publish", {
        type: 200,
        cmdFunction: 9001,
        data: {
          cmdControlType: 900,
        },
        deviceHardId: this.deviceHardId,
      });
    },
    order({ order }) {
      this.$store.dispatch("MMCGroundStation/order", {
        order,
        data: {
          cmdControlType: 900,
        },
        deviceHardId: this.deviceHardId,
      });
    },
    callback(data) {
      console.log("callback data", data);
      this.callbackText += "收到事件，调试窗口查看         ";
    },
    addCallback() {
      this.$store.dispatch("MMCGroundStation/addCallback", this.callback);
    },
    removeCallback() {
      this.callbackText = "";
      this.$store.dispatch("MMCGroundStation/removeCallback", this.callback);
    },
  },
};
</script>
`;