import Vue from "vue";
import VueClipBoard from "vue-clipboard2";
import interact from "./src/directives/interact";
import "./src/style/index.css";

import MMCCodeDemo from "./src/components/MMCCodeDemo";
import MMCDataTransferPanel from "./src/components/MMCDataTransferPanel";
import MMCPlayer from "./src/components/MMCPlayer";
import MMCUavList from "./src/components/MMCUavList";
import MMCMQTT from './src/plugins/MMCMQTT';
import MMCGroundStation from "./src/plugins/MMCGroundStation";
import MMCFlightControlCenter from './src/components/MMCFlightControlCenter';
import MMCFlightControlCenterPlugin from './src/components/MMCFlightControlCenter/plugin';
// import MMCFlightControlCenter from './dist';
import SymbolIcon from './src/components/symbol-icon';


const components = [
  MMCCodeDemo,
  MMCDataTransferPanel,
  MMCPlayer,
  MMCUavList,
  MMCFlightControlCenter,
  SymbolIcon
];
const plugins = [MMCMQTT, MMCGroundStation, MMCFlightControlCenterPlugin];

export default {
  install: function (Vue, options) {
    Vue.use(VueClipBoard);
    Vue.directive(interact.name, interact.directive);
    components.forEach((component) => {
      Vue.component(component.name, component);
    });
    plugins.forEach((plugin) => {
      Vue.use(plugin);
    });
  },
  ...components,
  ...plugins
};

export { default as MMCFlightControlCenterMain } from './src/components/MMCFlightControlCenter/main';