// 无人机实时数据各链路融合
export default {
  computed: {
    // mqtt实时数据
    mqttDataSet() {
      return this.$store.state.MMCMQTT?.dataSet?.[this.hangar?.hardId];
    },
    mqttUrl() {
      return this.$store.getters["MMCFlightControlCenter/mqttUrl"];
    },
  },
  watch: {
    mqttDataSet(newVal) {
      if (newVal) {
        this.$store.dispatch(
          "MMCFlightControlCenter/hangar/updateByMQTT",
          newVal
        );
      }
    },
  },
  async created() {
    // 启动mqtt服务
    try {
      this.$store
        .dispatch("MMCMQTT/init", {
          url: this.mqttUrl,
        })
        .then(() => {
          console.log("mqtt连接成功");
        });
    } catch (e) {
      console.log("mqtt失败", e);
    }
  },
};
