const vuePlugin = require("rollup-plugin-vue");
const { terser } = require("rollup-plugin-terser");
const resolve = require("@rollup/plugin-node-resolve");
const url = require("@rollup/plugin-url");
const commonjs = require("@rollup/plugin-commonjs");
const babel = require("@rollup/plugin-babel");
const scss = require("rollup-plugin-scss");
const copy = require("rollup-plugin-copy");
const getBabelOutputPlugin =
  require("@rollup/plugin-babel").getBabelOutputPlugin;
const image = require("@rollup/plugin-image");
// const postcss = require("rollup-plugin-postcss");

module.exports = {
  input: "./index.js",
  output: {
    dir: "dist",
    format: "esm",
    sourcemap: false,
  },
  plugins: [
    vuePlugin(),
    copy({
      targets: [{ src: "src/style", dest: "dist" }],
    }),
    resolve({
      preferBuiltins: false,
      extensions: [".js", ".vue"], // 添加你要解析的扩展名
    }),
    // url({
    //   include: ["**/*.png", "**/*.svg", "**/*.jpg"], // 包括所有的 PNG 文件
    //   limit: 0, // 将所有文件复制到输出目录中
    //   emitFiles: true, // 发布文件到输出目录
    //   publicPath: '/assets/'
    // }),
    
    commonjs({
      requireReturnsDefault: (id) => {
        // console.log('id', id);
        return true;
      }, // <---- this solves default issue
    }),/* 
    postcss({
      extract: true, // 生成单独的 CSS 文件
      plugins: [
        require('postcss-import'),
        require('postcss-url')({
          url: 'inline', // 内联图片
          maxSize: 10000, // 图片大小限制
          fallback: 'rebase', // 对于大于限制的图片，使用相对路径引入
        }),
      ],
    }), */
    image(),
    scss({
      // transformers: [(css) => css.replace(/url\(|\.png|\.jpg/g, "")],
    }),
   
    getBabelOutputPlugin({
      presets: ["@babel/preset-env"],
    }),
    terser(),
  ],
  external: (...args) => {
    // console.log('args', args);
    // node_modules下的库都不打包进去
    if (
      args[0].includes("node_modules") &&
      !args[0].includes("vue-runtime-helpers")
    ) {
      return true;
    }
  },
};
