import Vue from "vue";
import Vuex from "vuex";
import App from "./App.vue";
import ElementUI from "element-ui";
import "element-ui/lib/theme-chalk/index.css";
/* import MMCSTL from '../../dist/index';
import '../../dist/style/index.css'; */
import MMCSTL from "../../index";
import "./styles/reset.css";
import i18n from './i18n'; // 引入i18n配置
import Bus from "@/assets/ligature.js";
window.$Bus = Bus;
Vue.config.productionTip = false;

Vue.use(Vuex);
Vue.use(ElementUI);
Vue.use(MMCSTL);

let router = null;
let instance = null;
function render(props = {}) {
  const { container } = props;

  instance = new Vue({
    i18n, // 添加i18n实例
    render: (h) => h(App),
    store: new Vuex.Store({}),
  }).$mount(container ? container.querySelector("#app") : "#app");
}

// 独立运行时
if (!window.__POWERED_BY_QIANKUN__) {
  render();
}

export async function bootstrap() {
  console.log("[vue] vue app bootstraped");
}
export async function mount(props) {
  console.log("[vue] props from main framework", props);
  render(props);
}
export async function unmount() {
  instance.$destroy();
  instance.$el.innerHTML = "";
  instance = null;
  router = null;
}
