import request from "../request";

// 创建视图数据
export default class ViewLibrary {
  // 视图库中创建文件
  static create(data) {
    return request({
      url: "/admin-api/data/view-library/create",
      method: "post",
      data,
    });
  }

  //上传文件
  static uploadFile(data) {
    return request({
      url: "/admin-api/infra/file/upload",
      method: "post",
      data,
    });
  }

  static page(params) {
    return request({
      url: "/admin-api/data/view-library/page",
      method: "get",
      params,
    });
  }

  static delete(params) {
    return request({
      url: "/admin-api/data/view-library/delete",
      method: "delete",
      params,
    });
  }
}
