import Vue from "vue";
import './index.scss';

const Bus = new Vue();
let confirm = null; //外部传进来的confirm方法
let alert = null;
/**
 * 处理canvas错误
 */
export default function handlerCanvasError(options) {
  confirm = options.confirm;
  alert = options.alert;
  //每X秒检查webgl是否停止工作
  let handle = setInterval(() => {
    let errEl = document.querySelector(`.cesium-widget-errorPanel`);
    //错误提示的元素被创建, 说明cesium已经停止渲染
    if (errEl) {
      console.info("Cesium已停止渲染");
      alert("Cesium已停止渲染");
      //将webgl崩溃的事件广播出去, 让各个组件自已做恢复
      Bus.$emit("webglStop");
      errorAlert();
      clearInterval(handle);
    }
  }, 2000);
}

function errorAlert() {
  if (alert) {
    alert(
      "由于浏览器压力过大，地图停止展示，请手动刷新，若未解决，请重启浏览器。",
      "警告",
      {
        confirmButtonText: "确定",
        callback: (action) => {},
      }
    );
  } else {
    let instance = confirm(
      "由于浏览器压力过大，地图停止展示，请手动刷新，若未解决，请重启浏览器。",
      "警告",
      {
        confirmButtonText: "刷新",
        cancelButtonText: "关闭",
        type: "warning",
      }
    )
      .then(() => {
        window.location.reload(true);
      })
      .catch(() => {
        instance.close();
      });
  }
}

// 测试效果
/* setTimeout(() => {
  errorAlert();
}, 3000); */
