import AreaDraw from "./AreaDraw"
import LineDraw from "./LineDraw"
import PointDraw from "./PointDraw"
import { DRAW_TYPE } from "./AbstractDraw";

class DrawFactory {
    static getFactory(type, options) {
        switch (type) {
            case DRAW_TYPE.POINT:
                return new PointDraw(options)
            case DRAW_TYPE.LINE:
                return new LineDraw(options)
            case DRAW_TYPE.AREA:
                return new AreaDraw(options)
            default:
                throw new Error("类型错误")
        }
    }
}

export default DrawFactory