export default `
<template>
  <div>
    <el-form>
      <el-form-item label="无人机id">
        <el-input v-model="deviceHardId"></el-input>
        <el-button @click="onSubscribe">订阅</el-button>
        <el-button @click="unsubscribe">取消</el-button>
      </el-form-item>
    </el-form>
    <div>
      {{ text }}
    </div>
  </div>
</template>

<script>
export default {
  name: 'MQTT',
  data(){
    return {
      deviceHardId: ''
    }
  },
  computed: {
    text(){
      return this.$store.state.MMCMQTT.dataSet;
    }
  },
  async created(){
    try{
      await this.$store.dispatch('MMCMQTT/init', {  
        url: 'mqtts://jianzai.mmcuav.cn/mqtt'
      })
    }catch(e){
      console.log('mqtt失败', e)
    }
    console.log('mqtt连接成功');
  },
  methods: {
    onSubscribe(){
      this.$store.dispatch('MMCMQTT/subscribe', {
        topic: \`PX4/RECEIVE/\${this.deviceHardId}\`,
        callback(){
          console.log('订阅成功')
        }
      })  
    },
    unsubscribe(){
      this.$store.dispatch('MMCMQTT/unsubscribe', {
        topic: \`PX4/RECEIVE/\${this.deviceHardId}\`
      })  
    }
  }
}
</script>
`;