export default `
<template>
  <div>
    <el-form>
      <el-form-item label="无人机id">
        <el-input v-model="deviceHardId"></el-input>
      </el-form-item>
      <el-form-item label="操作">
        <el-button @click="subscribe">订阅</el-button>
        <el-button @click="unsubscribe">取消订阅</el-button>
        <el-button @click="publish()">通过原始type发送指令</el-button>
        <el-button @click="order({order: '降落'})">通过关键字发送指令</el-button>
        <el-button @click="addCallback">添加事件回调</el-button>
        <el-button @click="removeCallback">移除事件回调</el-button>
      </el-form-item>
      <el-form-item label="支持的指令">
        {{ orders }}
      </el-form-item>
    </el-form>
    <div>
      {{ text }}
    </div>
    <div>
      {{ callbackText }}
    </div>
  </div>
</template>

<script>
export default {
  name: 'GroundStation',
  data(){
    return {
      deviceHardId: '',
      userInfo: {
        username: 'admin',
        token: 'cbe85bcd114cfb00a8547c86cac5460ad7942a1ab531094cd53e55a1e67617d9',
        appId: 87878
      },
      callbackText: ''
    }
  },
  computed: {
    text(){
      return this.$store.state.MMCGroundStation.dataSet;
    },
    orders(){
      return this.$store.state.MMCGroundStation.orders;
    },
  },
  async created(){
    try{
      await this.$store.dispatch('MMCGroundStation/init', {  
        url: 'ws://116.62.122.225:30103',
        userInfo: this.userInfo
      })
    }catch(e){
      console.log('地面站连接失败', e)
    }
    console.log('地面站连接成功');
  },
  methods: {
    subscribe(){
      this.$store.dispatch('MMCGroundStation/subscribe', this.deviceHardId)  
    },
    unsubscribe(){
      this.$store.dispatch('MMCGroundStation/unsubscribe', this.deviceHardId)  
    },
    publish(){
      this.$store.dispatch('MMCGroundStation/publish', {
        type: 200,
        cmdFunction: 9001,
        data: {
          cmdControlType: 900,
        },
        deviceHardId: this.deviceHardId
      })
    },
    order( { order } ){
      this.$store.dispatch('MMCGroundStation/order', {
        order,
        data: {
          cmdControlType: 900,
        }, 
        deviceHardId: this.deviceHardId
      })
    },
    callback(data){
      console.log('callback data', data)
      this.callbackText += '收到事件，调试窗口查看         ';
    },
    addCallback(){
      this.$store.dispatch('MMCGroundStation/addCallback', this.callback)
    },
    removeCallback(){
      this.callbackText = '';
      this.$store.dispatch('MMCGroundStation/removeCallback', this.callback)
    }
  }
}
</script>
`;