const vuePlugin = require("rollup-plugin-vue");
const { terser } = require("rollup-plugin-terser");
const resolve = require("@rollup/plugin-node-resolve");
const url = require("@rollup/plugin-url");
const commonjs = require("@rollup/plugin-commonjs");
const babel = require("@rollup/plugin-babel");
const scss = require("rollup-plugin-scss");

module.exports = {
  input: "./index.js",
  output: {
    dir: "dist",
    format: "es",
  },
  plugins: [
    vuePlugin(),

    resolve({
      preferBuiltins: false,
      extensions: [".js", ".vue"], // 添加你要解析的扩展名
    }),
    url({
      include: ["**/*.png", "**/*.svg"], // 包括所有的 PNG 文件
      limit: 0, // 将所有文件复制到输出目录中
      emitFiles: true, // 发布文件到输出目录
    }),
    commonjs({
      requireReturnsDefault: (id) => {
        // console.log('id', id);
        return true;
      }, // <---- this solves default issue
    }),
    babel({
      exclude: "node_modules/**",
    }),
    scss(),
    terser(),
  ],
  external: (...args) => {
    // console.log('args', args);
    // node_modules下的库都不打包进去
    if (args[0].includes("node_modules")) {
      return true;
    }
  },
};
