var ktb_isLoad = false;
var ktb_isFirst = true; //是否第一次, 由于同时多个清流实例调用初始化方法会导致无法正常返回，需要做间隔
var initQueue = [];
function kbt_sdk_load() {
  return new Promise(function (resolve, reject) {
    if (ktb_isLoad) {
      return resolve();
    }
    let timeout = 0;
    if (!ktb_isFirst) {
      timeout = 5000;
    } else {
      ktb_isFirst = false;
    }

    setTimeout(() => {
      console.log("qingliu ktb_isFirst", Date.now(), ktb_isFirst);
      if (ktb_isLoad) {
        return resolve();
      }

      PIMediaPlayer_init(function (e) {
        // console.log('PIMediaPlayer_init', e)
        if (PIMediaPlayer_msg_handler(e) == 1) {
          return;
        }

        switch (e.data["user_cmd"]) {
          case "player_ready":
            ktb_isLoad = true;
            resolve();
            break;

          case "qoeinfo":
            /* console.log(
              "qoeinfo",
              e.data["media_name"],
              e.data["stream_name"],
              JSON.parse(e.data["qoeinfo"])
            ); */
            window.postMessage({
              type: "qoeinfo",
              media_name: e.data["media_name"],
              stream_name: e.data["stream_name"],
              data: JSON.parse(e.data["qoeinfo"]),
            });
            break;
          case "raw_msg":
            window.postMessage({
              type: 'raw_msg',
              media_name: e.data["media_name"],
              stream_name: e.data["stream_name"],
              data: e.data["arg1"],
            });
            break;
        }
      }, 48);
    }, timeout);
  });
}

var kbt_instances = [];
function kbt_player_create(name, url, width, height, parentEle) {
  console.log("kbt_player_create", name);
  kbt_instances.push(name);
  let canvas_obj = document.createElement("canvas");
  canvas_obj.setAttribute("id", "sdk_canvas_" + name);
  canvas_obj.setAttribute("width", width);
  canvas_obj.setAttribute("height", height);
  parentEle.appendChild(canvas_obj);
  let offscreen = canvas_obj.transferControlToOffscreen();
  let layer_name = "sdk_layer_" + name;
  canvas_list = [{ name: layer_name, offscreen: offscreen }];
  canvas_obj.addEventListener("dblclick", function () {
    if (document.fullscreenElement) {
      document.exitFullscreen();
    } else {
      let canvas_obj = document.getElementById("sdk_canvas_" + name);
      canvas_obj.requestFullscreen();
      g_player_process.postMessage({
        user_cmd: "fullscreen",
        layer_name: layer_name,
        width: window.screen.width,
        height: window.screen.height,
      });
    }
  });
  let dis_name = "sdk_dis_" + name;
  let layerinfo = [
    {
      name: layer_name,
      width: width,
      height: height,
      districts: [
        {
          name: "sdk_dis_" + name,
          position_x: "0px",
          position_y: "0px",
          width: width,
          height: height,
        },
      ],
    },
  ];
  PIMediaPlayer_add_canvas(canvas_list, layerinfo);
  let bindinfo = {};
  bindinfo[name] = { video0: [{ layer: layer_name, district: dis_name }] };
  PIMediaPlayer_update_binds(bindinfo);
  PIMediaPlayer_create(name, url);
}
function kbt_player_destroy(name) {
  console.log("kbt_player_destroy", name);
  kbt_instances = kbt_instances.filter((item) => {
    return item != name;
  });
  console.log("kbt_instances", kbt_instances);
  PIMediaPlayer_destroy(name);
  PIMediaPlayer_del_canvas(["sdk_canvas_" + name]);
  let canvas_obj = document.getElementById("sdk_canvas_" + name);
  if (canvas_obj) {
    canvas_obj.remove();
  }
}
