export default `
<template>
  <div>
    <MMCDataTransferPanel
      :device="device"
      :wsShow="wsShow"
      :throttleValue="throttleValue"
      :uav-battery="battery"
      :uav-data="uavData"
    ></MMCDataTransferPanel>
  </div>
</template>

<script>

export default {
  data(){
    return {
      device: {             
        cateName: 'px4'
      },
      wsShow: false,        //是否为地面站连接
      throttleValue: 500,   //油门值0-1000，中位500
      battery: {            //电池电量
        voltage: 0,
        id: ''
      },
      uavData: {
        attitude: 0,        //海拔高度
        flyDistance: 0,     //飞行里程
        flyTime: 0,         //飞行时间
        groundSpeed: 0,     //飞行速度
        velocityX: 0,
        velocityY: 0,
        velocityZ: 0,       //爬升率
      }
    }
  }
}
</script>

<style>

</style>
`;