// 无人机实时数据各链路融合
export default {
  computed: {
    // mqtt实时数据
    mqttDataSet() {
      return this.$store.state.MMCMQTT?.dataSet?.[this.uav?.deviceId];
    },
    // 地面站实时数据
    gsDataSet() {
      return this.$store.state.MMCGroundStation?.dataSet?.[this.uav?.deviceId];
    },
    mqttUrl() {
      return this.$store.getters["MMCFlightControlCenter/mqttUrl"];
    },
  },
  watch: {
    mqttDataSet(newVal) {
      if (this.uav?.network === 2) {
        if (newVal) {
          this.$store.dispatch(
            "MMCFlightControlCenter/uav/updateByMQTT",
            newVal
          );
        }
      }
    },
    gsDataSet(newVal) {
      if (this.uav?.network == 0) {
        if (newVal) {
          this.$store.dispatch(
            "MMCFlightControlCenter/uav/updateByMQTT",
            newVal
          );
        }
      }
    },
  },
  async mounted() {
    // 模拟飞机数据上报
    // this.$store.dispatch("MMCFlightControlCenter/uav/test", { open: true });
    // 启动mqtt服务
    try {
      this.$store
        .dispatch("MMCMQTT/init", {
          url: this.mqttUrl,
        })
        .then(() => {
          console.log("mqtt连接成功");
        });
    } catch (e) {
      console.log("mqtt失败", e);
    }

    // 由于地面站是广播形式的数据传输, 非常消耗性能, 把连接地面站ws的操作挪到了订阅中去, 取消订阅时就断开ws
  },
  beforeDestroy(){
    console.log('断开mqtt与ws连接');
    if(this.uav){
      this.$store.dispatch('MMCFlightControlCenter/uav/unsubscribe');
    }
    this.$store.dispatch('MMCFlightControlCenter/uav/end');
  }
};
