import request from "../request";
import request_uav from "../request_uav";

class Control_API {
  /**
   * 无人机接管更新状态
   * @param {*} id //设备id
   * @returns
   */

  static updateTakeOver(id) {
    return request({
      url: `/dms/uav/updateTakeOver/${id}`,
      method: "put",
    });
  }
  // 获取无人机树结构列表
  static getUavTree(params) {
    return request({
      url: "/admin-api/uas/drive/getDeptTree",
      // url: "/admin-api/uas/drive/getTree",
      // url: '/crm/personalCenter/list?id=4',
      method: "get",
      params,
    });
  }

  // 获取无人机列表
  static getUavDataList(params) {
    return request({
      url: "/dms/uav/page",
      method: "get",
      params,
    });
  }

  // 获取航线列表
  static getUavRouteList(params) {
    return request({
      // url: "/dms/route/page",
      url: "/admin-api/uas/flight-line/page",
      method: "get",
      params,
    });
  }

  // 获取架次号
  static getFlightSortic({ taskId, deviceHardId }) {
    return request({
      url: `/tss/task/getFlightSortic/${taskId}/${deviceHardId}`,
      method: "get",
    });
  }

  // 无人机详情
  static uavDetail(params) {
    return request({
      url: `/dms/uav/detail/${params.id}`,
      method: "get",
    });
  }

  // 飞行日志
  static getFlightLog(data) {
    return request({
      url: `/dms/sortie/flightLog`,
      method: "post",
      data,
    });
  }

  // 保存图片
  static addPhoto(data) {
    return request({
      url: `/dms/sortie-image/add`,
      method: "post",
      data,
    });
  }

  static uploadFile(data){
    return request({
      url: `/admin-api/infra/file/upload`,
      method: "post",
      data,
    });
  }
  // 保存AI图片
  // static addAiPhoto(data) {
  //   return request({
  //     url: `/dms/sortie-image/addAi`,
  //     method: "post",
  //     data
  //   });
  // }
  // 获取所有机构列表
  static getAllOrg() {
    return request({
      url: `/crm/organization/tree`,
      method: "get",
    });
  }
  // 获取所有无人机操作日志
  static getUavAllLog(params) {
    return request_uav({
      url: `/api/log/selectUavCmdLikeList`,
      method: "get",
      params,
    });
  }
  // 获取1小时短时天气预报
  static getUavShortForEcast(params) {
    return request_uav({
      url: `/whapi/json/aliweather/shortforecast`,
      method: "post",
      params,
    });
  }
  // 获取24小时短时天气预报(详细)包含风向等等...
  static getUavShortForEcast24(params) {
    return request_uav({
      url: `/whapi/json/aliweather/forecast24hours`,
      method: "post",
      params,
    });
  }
  // 获取树结构-鹰巢
  static getUavNestList(params) {
    return request({
      url: `/dms/nest/getNestList`,
      method: "get",
      params,
    });
  }
  // 获取任务库列表
  static getTaskList(data) {
    return request({
      url: `/tss/task/list`,
      method: "post",
      data,
    });
  }
  // 获取任务库内的任务详情
  static getTaskDetails(params) {
    return request({
      url: `/tss/task/${params.id}`,
      method: "get",
    });
  }
  // 鹰巢-定时，周期自启动
  static startUavNest = (data) =>
    request({
      url: "/tss/task/start",
      method: "POST",
      data,
    });
  //   鹰巢-运行日志
  static getUavNestLog = (params) =>
    request_uav({
      url: `api/log/selectProcessLikeList`,
      method: "get",
      params,
    });

  // 获取架次列表
  static getSortie(params) {
    return request({
      url: "/dms/sortie/page",
      method: "get",
      params,
    });
  }
  // 获取架次图片列表
  static getSortieImage(params) {
    return request({
      url: "/dms/sortie-image/page",
      method: "get",
      params,
    });
  }
  // 获取架次视频列表
  static getSortieVideo(params) {
    return request({
      url: "/dms/sortie/history-video",
      method: "get",
      params,
    });
  }
  // 导出成果
  static getExportToWordForSortie(params) {
    return request({
      headers: {
        "Content-Type": "application/x-www-form-urlencoded",
      },
      responseType: "blob",
      url: `/dms/sortie/export-word`,
      method: "GET",
      params,
    });
  }
  // 接管无人机
  static setUavControlOn(params) {
    return request({
      // url: `/dms/uav/takeOver/${params.id}`,
      url: `/admin-api/uas/device/controlUav`,
      method: 'post',
      params
    });
  }
  // 强制接管无人机
  static setUavControlOnForce(params) {
    return request({
      url: `/admin-api/uas/device/forceControlUav`,
      method: 'post',
      params
    });
  }
  // 解除无人机控制
  static setUavControlOff(params) {
    return request({
      url: `/admin-api/uas/device/quitControlUav`,
      method: 'post',
      params
    });
  }
  // 获取设备视频流
  static getDeviceStream(params) {
    return request({
      url: `/admin-api/uas/device-stream/page`,
      method: "get",
      params
    });
  }
  // 设备详情详情
  static getDeviceDetail(params) {
    return request({
      url: `/admin-api/uas/device/get`,
      method: "get",
      params
    });
  }

}

export default Control_API;
