//下载文件
export default function downFile(url) {
  fetch(url, {
    method: "GET",
    responseType: "blob",
  })
    .then((res) => res.blob())
    .then((res) => {
      var fileName = getFileName(url)+'.jpg'; //获取文件名
      saveFile(res, fileName);
    });
}
//保存文件
function saveFile(data, fileName) {
  var export_blob = new Blob([data]);
  var save_link = document.createElement("a");
  document.body.appendChild(save_link);
  save_link.style.display = "none";
  var urlObject = window.URL.createObjectURL(export_blob);
  save_link.href = urlObject;
  save_link.download = fileName;
  save_link.click();
  document.body.removeChild(save_link);
}
//根据url获取文件名
function getFileName(url) {
  var num = url.lastIndexOf("/") + 1;
  var fileName = url.substring(num);
  fileName = decodeURI(fileName.split("?")[0]);
  return fileName;
}
