

// Support for growable heap + pthreads, where the buffer may change, so JS views
// must be updated.
function GROWABLE_HEAP_I8() {
  if (wasmMemory.buffer != buffer) {
    updateGlobalBufferAndViews(wasmMemory.buffer);
  }
  return HEAP8;
}
function GROWABLE_HEAP_U8() {
  if (wasmMemory.buffer != buffer) {
    updateGlobalBufferAndViews(wasmMemory.buffer);
  }
  return HEAPU8;
}
function GROWABLE_HEAP_I16() {
  if (wasmMemory.buffer != buffer) {
    updateGlobalBufferAndViews(wasmMemory.buffer);
  }
  return HEAP16;
}
function GROWABLE_HEAP_U16() {
  if (wasmMemory.buffer != buffer) {
    updateGlobalBufferAndViews(wasmMemory.buffer);
  }
  return HEAPU16;
}
function GROWABLE_HEAP_I32() {
  if (wasmMemory.buffer != buffer) {
    updateGlobalBufferAndViews(wasmMemory.buffer);
  }
  return HEAP32;
}
function GROWABLE_HEAP_U32() {
  if (wasmMemory.buffer != buffer) {
    updateGlobalBufferAndViews(wasmMemory.buffer);
  }
  return HEAPU32;
}
function GROWABLE_HEAP_F32() {
  if (wasmMemory.buffer != buffer) {
    updateGlobalBufferAndViews(wasmMemory.buffer);
  }
  return HEAPF32;
}
function GROWABLE_HEAP_F64() {
  if (wasmMemory.buffer != buffer) {
    updateGlobalBufferAndViews(wasmMemory.buffer);
  }
  return HEAPF64;
}

var Module = typeof Module != "undefined" ? Module : {};

if (!Module.expectedDataFileDownloads) {
 Module.expectedDataFileDownloads = 0;
}

Module.expectedDataFileDownloads++;

(function() {
 if (Module["ENVIRONMENT_IS_PTHREAD"]) return;
 var loadPackage = function(metadata) {
  var PACKAGE_PATH = "";
  if (typeof window === "object") {
   PACKAGE_PATH = window["encodeURIComponent"](window.location.pathname.toString().substring(0, window.location.pathname.toString().lastIndexOf("/")) + "/");
  } else if (typeof process === "undefined" && typeof location !== "undefined") {
   PACKAGE_PATH = encodeURIComponent(location.pathname.toString().substring(0, location.pathname.toString().lastIndexOf("/")) + "/");
  }
  var PACKAGE_NAME = "libplayer.data";
  var REMOTE_PACKAGE_BASE = "libplayer.data";
  if (typeof Module["locateFilePackage"] === "function" && !Module["locateFile"]) {
   Module["locateFile"] = Module["locateFilePackage"];
   err("warning: you defined Module.locateFilePackage, that has been renamed to Module.locateFile (using your locateFilePackage for now)");
  }
  var REMOTE_PACKAGE_NAME = Module["locateFile"] ? Module["locateFile"](REMOTE_PACKAGE_BASE, "") : REMOTE_PACKAGE_BASE;
  var REMOTE_PACKAGE_SIZE = metadata["remote_package_size"];
  var PACKAGE_UUID = metadata["package_uuid"];
  function fetchRemotePackage(packageName, packageSize, callback, errback) {
   if (typeof process === "object" && typeof process.versions === "object" && typeof process.versions.node === "string") {
    require("fs").readFile(packageName, function(err, contents) {
     if (err) {
      errback(err);
     } else {
      callback(contents.buffer);
     }
    });
    return;
   }
   var xhr = new XMLHttpRequest();
   xhr.open("GET", packageName, true);
   xhr.responseType = "arraybuffer";
   xhr.onprogress = function(event) {
    var url = packageName;
    var size = packageSize;
    if (event.total) size = event.total;
    if (event.loaded) {
     if (!xhr.addedTotal) {
      xhr.addedTotal = true;
      if (!Module.dataFileDownloads) Module.dataFileDownloads = {};
      Module.dataFileDownloads[url] = {
       loaded: event.loaded,
       total: size
      };
     } else {
      Module.dataFileDownloads[url].loaded = event.loaded;
     }
     var total = 0;
     var loaded = 0;
     var num = 0;
     for (var download in Module.dataFileDownloads) {
      var data = Module.dataFileDownloads[download];
      total += data.total;
      loaded += data.loaded;
      num++;
     }
     total = Math.ceil(total * Module.expectedDataFileDownloads / num);
     if (Module["setStatus"]) Module["setStatus"]("Downloading data... (" + loaded + "/" + total + ")");
    } else if (!Module.dataFileDownloads) {
     if (Module["setStatus"]) Module["setStatus"]("Downloading data...");
    }
   };
   xhr.onerror = function(event) {
    throw new Error("NetworkError for: " + packageName);
   };
   xhr.onload = function(event) {
    if (xhr.status == 200 || xhr.status == 304 || xhr.status == 206 || xhr.status == 0 && xhr.response) {
     var packageData = xhr.response;
     callback(packageData);
    } else {
     throw new Error(xhr.statusText + " : " + xhr.responseURL);
    }
   };
   xhr.send(null);
  }
  function handleError(error) {
   console.error("package error:", error);
  }
  var fetchedCallback = null;
  var fetched = Module["getPreloadedPackage"] ? Module["getPreloadedPackage"](REMOTE_PACKAGE_NAME, REMOTE_PACKAGE_SIZE) : null;
  if (!fetched) fetchRemotePackage(REMOTE_PACKAGE_NAME, REMOTE_PACKAGE_SIZE, function(data) {
   if (fetchedCallback) {
    fetchedCallback(data);
    fetchedCallback = null;
   } else {
    fetched = data;
   }
  }, handleError);
  function runWithFS() {
   function assert(check, msg) {
    if (!check) throw msg + new Error().stack;
   }
   function DataRequest(start, end, audio) {
    this.start = start;
    this.end = end;
    this.audio = audio;
   }
   DataRequest.prototype = {
    requests: {},
    open: function(mode, name) {
     this.name = name;
     this.requests[name] = this;
     Module["addRunDependency"]("fp " + this.name);
    },
    send: function() {},
    onload: function() {
     var byteArray = this.byteArray.subarray(this.start, this.end);
     this.finish(byteArray);
    },
    finish: function(byteArray) {
     var that = this;
     Module["FS_createDataFile"](this.name, null, byteArray, true, true, true);
     Module["removeRunDependency"]("fp " + that.name);
     this.requests[this.name] = null;
    }
   };
   var files = metadata["files"];
   for (var i = 0; i < files.length; ++i) {
    new DataRequest(files[i]["start"], files[i]["end"], files[i]["audio"] || 0).open("GET", files[i]["filename"]);
   }
   function processPackageData(arrayBuffer) {
    assert(arrayBuffer, "Loading data file failed.");
    assert(arrayBuffer instanceof ArrayBuffer, "bad input to processPackageData");
    var byteArray = new Uint8Array(arrayBuffer);
    var curr;
    DataRequest.prototype.byteArray = byteArray;
    var files = metadata["files"];
    for (var i = 0; i < files.length; ++i) {
     DataRequest.prototype.requests[files[i].filename].onload();
    }
    Module["removeRunDependency"]("datafile_libplayer.data");
   }
   Module["addRunDependency"]("datafile_libplayer.data");
   if (!Module.preloadResults) Module.preloadResults = {};
   Module.preloadResults[PACKAGE_NAME] = {
    fromCache: false
   };
   if (fetched) {
    processPackageData(fetched);
    fetched = null;
   } else {
    fetchedCallback = processPackageData;
   }
  }
  if (Module["calledRun"]) {
   runWithFS();
  } else {
   if (!Module["preRun"]) Module["preRun"] = [];
   Module["preRun"].push(runWithFS);
  }
 };
 loadPackage({
  "files": [ {
   "filename": "/iLivePlayer.ini",
   "start": 0,
   "end": 154
  } ],
  "remote_package_size": 154,
  "package_uuid": "3370b129-6942-4977-93ec-f9cce1dce5ed"
 });
})();

if (Module["ENVIRONMENT_IS_PTHREAD"]) Module["preRun"] = [];

var necessaryPreJSTasks = Module["preRun"].slice();

if (!Module["preRun"]) throw "Module.preRun should exist because file support used it; did a pre-js delete it?";

necessaryPreJSTasks.forEach(function(task) {
 if (Module["preRun"].indexOf(task) < 0) throw "All preRun tasks that exist before user pre-js code should remain after; did you replace Module or modify Module.preRun?";
});

var moduleOverrides = Object.assign({}, Module);

var arguments_ = [];

var thisProgram = "./this.program";

var quit_ = (status, toThrow) => {
 throw toThrow;
};

var ENVIRONMENT_IS_WEB = typeof window == "object";

var ENVIRONMENT_IS_WORKER = typeof importScripts == "function";

var ENVIRONMENT_IS_NODE = typeof process == "object" && typeof process.versions == "object" && typeof process.versions.node == "string";

var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;

if (Module["ENVIRONMENT"]) {
 throw new Error("Module.ENVIRONMENT has been deprecated. To force the environment, use the ENVIRONMENT compile-time option (for example, -s ENVIRONMENT=web or -s ENVIRONMENT=node)");
}

var ENVIRONMENT_IS_PTHREAD = Module["ENVIRONMENT_IS_PTHREAD"] || false;

var _scriptDir = typeof document != "undefined" && document.currentScript ? document.currentScript.src : undefined;

if (ENVIRONMENT_IS_WORKER) {
 _scriptDir = self.location.href;
} else if (ENVIRONMENT_IS_NODE) {
 _scriptDir = __filename;
}

var scriptDirectory = "";

function locateFile(path) {
 if (Module["locateFile"]) {
  return Module["locateFile"](path, scriptDirectory);
 }
 return scriptDirectory + path;
}

var read_, readAsync, readBinary, setWindowTitle;

function logExceptionOnExit(e) {
 if (e instanceof ExitStatus) return;
 let toLog = e;
 if (e && typeof e == "object" && e.stack) {
  toLog = [ e, e.stack ];
 }
 err("exiting due to exception: " + toLog);
}

var fs;

var nodePath;

var requireNodeFS;

if (ENVIRONMENT_IS_NODE) {
 if (!(typeof process == "object" && typeof require == "function")) throw new Error("not compiled for this environment (did you build to HTML and try to run it not on the web, or set ENVIRONMENT to something - like node - and run it someplace else - like on the web?)");
 if (ENVIRONMENT_IS_WORKER) {
  scriptDirectory = require("path").dirname(scriptDirectory) + "/";
 } else {
  scriptDirectory = __dirname + "/";
 }
 requireNodeFS = (() => {
  if (!nodePath) {
   fs = require("fs");
   nodePath = require("path");
  }
 });
 read_ = function shell_read(filename, binary) {
  requireNodeFS();
  filename = nodePath["normalize"](filename);
  return fs.readFileSync(filename, binary ? undefined : "utf8");
 };
 readBinary = (filename => {
  var ret = read_(filename, true);
  if (!ret.buffer) {
   ret = new Uint8Array(ret);
  }
  assert(ret.buffer);
  return ret;
 });
 readAsync = ((filename, onload, onerror) => {
  requireNodeFS();
  filename = nodePath["normalize"](filename);
  fs.readFile(filename, function(err, data) {
   if (err) onerror(err); else onload(data.buffer);
  });
 });
 if (process["argv"].length > 1) {
  thisProgram = process["argv"][1].replace(/\\/g, "/");
 }
 arguments_ = process["argv"].slice(2);
 if (typeof module != "undefined") {
  module["exports"] = Module;
 }
 process["on"]("uncaughtException", function(ex) {
  if (!(ex instanceof ExitStatus)) {
   throw ex;
  }
 });
 process["on"]("unhandledRejection", function(reason) {
  throw reason;
 });
 quit_ = ((status, toThrow) => {
  if (keepRuntimeAlive()) {
   process["exitCode"] = status;
   throw toThrow;
  }
  logExceptionOnExit(toThrow);
  process["exit"](status);
 });
 Module["inspect"] = function() {
  return "[Emscripten Module object]";
 };
 let nodeWorkerThreads;
 try {
  nodeWorkerThreads = require("worker_threads");
 } catch (e) {
  console.error('The "worker_threads" module is not supported in this node.js build - perhaps a newer version is needed?');
  throw e;
 }
 global.Worker = nodeWorkerThreads.Worker;
} else if (ENVIRONMENT_IS_SHELL) {
 if (typeof process == "object" && typeof require === "function" || typeof window == "object" || typeof importScripts == "function") throw new Error("not compiled for this environment (did you build to HTML and try to run it not on the web, or set ENVIRONMENT to something - like node - and run it someplace else - like on the web?)");
 if (typeof read != "undefined") {
  read_ = function shell_read(f) {
   return read(f);
  };
 }
 readBinary = function readBinary(f) {
  let data;
  if (typeof readbuffer == "function") {
   return new Uint8Array(readbuffer(f));
  }
  data = read(f, "binary");
  assert(typeof data == "object");
  return data;
 };
 readAsync = function readAsync(f, onload, onerror) {
  setTimeout(() => onload(readBinary(f)), 0);
 };
 if (typeof scriptArgs != "undefined") {
  arguments_ = scriptArgs;
 } else if (typeof arguments != "undefined") {
  arguments_ = arguments;
 }
 if (typeof quit == "function") {
  quit_ = ((status, toThrow) => {
   if (runtimeKeepaliveCounter) {
    throw toThrow;
   }
   logExceptionOnExit(toThrow);
   quit(status);
  });
 }
 if (typeof print != "undefined") {
  if (typeof console == "undefined") console = {};
  console.log = print;
  console.warn = console.error = typeof printErr != "undefined" ? printErr : print;
 }
} else if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
 if (ENVIRONMENT_IS_WORKER) {
  scriptDirectory = self.location.href;
 } else if (typeof document != "undefined" && document.currentScript) {
  scriptDirectory = document.currentScript.src;
 }
 if (scriptDirectory.indexOf("blob:") !== 0) {
  scriptDirectory = scriptDirectory.substr(0, scriptDirectory.replace(/[?#].*/, "").lastIndexOf("/") + 1);
 } else {
  scriptDirectory = "";
 }
 if (!(typeof window == "object" || typeof importScripts == "function")) throw new Error("not compiled for this environment (did you build to HTML and try to run it not on the web, or set ENVIRONMENT to something - like node - and run it someplace else - like on the web?)");
 if (!ENVIRONMENT_IS_NODE) {
  read_ = (url => {
   var xhr = new XMLHttpRequest();
   xhr.open("GET", url, false);
   xhr.send(null);
   return xhr.responseText;
  });
  if (ENVIRONMENT_IS_WORKER) {
   readBinary = (url => {
    var xhr = new XMLHttpRequest();
    xhr.open("GET", url, false);
    xhr.responseType = "arraybuffer";
    xhr.send(null);
    return new Uint8Array(xhr.response);
   });
  }
  readAsync = ((url, onload, onerror) => {
   var xhr = new XMLHttpRequest();
   xhr.open("GET", url, true);
   xhr.responseType = "arraybuffer";
   xhr.onload = (() => {
    if (xhr.status == 200 || xhr.status == 0 && xhr.response) {
     onload(xhr.response);
     return;
    }
    onerror();
   });
   xhr.onerror = onerror;
   xhr.send(null);
  });
 }
 setWindowTitle = (title => document.title = title);
} else {
 throw new Error("environment detection error");
}

if (ENVIRONMENT_IS_NODE) {
 if (typeof performance == "undefined") {
  global.performance = require("perf_hooks").performance;
 }
}

var defaultPrint = console.log.bind(console);

var defaultPrintErr = console.warn.bind(console);

if (ENVIRONMENT_IS_NODE) {
 requireNodeFS();
 defaultPrint = (str => fs.writeSync(1, str + "\n"));
 defaultPrintErr = (str => fs.writeSync(2, str + "\n"));
}

var out = Module["print"] || defaultPrint;

var err = Module["printErr"] || defaultPrintErr;

Object.assign(Module, moduleOverrides);

moduleOverrides = null;

checkIncomingModuleAPI();

if (Module["arguments"]) arguments_ = Module["arguments"];

legacyModuleProp("arguments", "arguments_");

if (Module["thisProgram"]) thisProgram = Module["thisProgram"];

legacyModuleProp("thisProgram", "thisProgram");

if (Module["quit"]) quit_ = Module["quit"];

legacyModuleProp("quit", "quit_");

assert(typeof Module["memoryInitializerPrefixURL"] == "undefined", "Module.memoryInitializerPrefixURL option was removed, use Module.locateFile instead");

assert(typeof Module["pthreadMainPrefixURL"] == "undefined", "Module.pthreadMainPrefixURL option was removed, use Module.locateFile instead");

assert(typeof Module["cdInitializerPrefixURL"] == "undefined", "Module.cdInitializerPrefixURL option was removed, use Module.locateFile instead");

assert(typeof Module["filePackagePrefixURL"] == "undefined", "Module.filePackagePrefixURL option was removed, use Module.locateFile instead");

assert(typeof Module["read"] == "undefined", "Module.read option was removed (modify read_ in JS)");

assert(typeof Module["readAsync"] == "undefined", "Module.readAsync option was removed (modify readAsync in JS)");

assert(typeof Module["readBinary"] == "undefined", "Module.readBinary option was removed (modify readBinary in JS)");

assert(typeof Module["setWindowTitle"] == "undefined", "Module.setWindowTitle option was removed (modify setWindowTitle in JS)");

assert(typeof Module["TOTAL_MEMORY"] == "undefined", "Module.TOTAL_MEMORY has been renamed Module.INITIAL_MEMORY");

legacyModuleProp("read", "read_");

legacyModuleProp("readAsync", "readAsync");

legacyModuleProp("readBinary", "readBinary");

legacyModuleProp("setWindowTitle", "setWindowTitle");

var IDBFS = "IDBFS is no longer included by default; build with -lidbfs.js";

var PROXYFS = "PROXYFS is no longer included by default; build with -lproxyfs.js";

var WORKERFS = "WORKERFS is no longer included by default; build with -lworkerfs.js";

var NODEFS = "NODEFS is no longer included by default; build with -lnodefs.js";

assert(ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER || ENVIRONMENT_IS_NODE, "Pthreads do not work in this environment yet (need Web Workers, or an alternative to them)");

assert(!ENVIRONMENT_IS_SHELL, "shell environment detected but not enabled at build time.  Add 'shell' to `-s ENVIRONMENT` to enable.");

var STACK_ALIGN = 16;

var POINTER_SIZE = 4;

function getNativeTypeSize(type) {
 switch (type) {
 case "i1":
 case "i8":
  return 1;

 case "i16":
  return 2;

 case "i32":
  return 4;

 case "i64":
  return 8;

 case "float":
  return 4;

 case "double":
  return 8;

 default:
  {
   if (type[type.length - 1] === "*") {
    return POINTER_SIZE;
   } else if (type[0] === "i") {
    const bits = Number(type.substr(1));
    assert(bits % 8 === 0, "getNativeTypeSize invalid bits " + bits + ", type " + type);
    return bits / 8;
   } else {
    return 0;
   }
  }
 }
}

function warnOnce(text) {
 if (!warnOnce.shown) warnOnce.shown = {};
 if (!warnOnce.shown[text]) {
  warnOnce.shown[text] = 1;
  err(text);
 }
}

function convertJsFunctionToWasm(func, sig) {
 if (typeof WebAssembly.Function == "function") {
  var typeNames = {
   "i": "i32",
   "j": "i64",
   "f": "f32",
   "d": "f64"
  };
  var type = {
   parameters: [],
   results: sig[0] == "v" ? [] : [ typeNames[sig[0]] ]
  };
  for (var i = 1; i < sig.length; ++i) {
   type.parameters.push(typeNames[sig[i]]);
  }
  return new WebAssembly.Function(type, func);
 }
 var typeSection = [ 1, 0, 1, 96 ];
 var sigRet = sig.slice(0, 1);
 var sigParam = sig.slice(1);
 var typeCodes = {
  "i": 127,
  "j": 126,
  "f": 125,
  "d": 124
 };
 typeSection.push(sigParam.length);
 for (var i = 0; i < sigParam.length; ++i) {
  typeSection.push(typeCodes[sigParam[i]]);
 }
 if (sigRet == "v") {
  typeSection.push(0);
 } else {
  typeSection = typeSection.concat([ 1, typeCodes[sigRet] ]);
 }
 typeSection[1] = typeSection.length - 2;
 var bytes = new Uint8Array([ 0, 97, 115, 109, 1, 0, 0, 0 ].concat(typeSection, [ 2, 7, 1, 1, 101, 1, 102, 0, 0, 7, 5, 1, 1, 102, 0, 0 ]));
 var module = new WebAssembly.Module(bytes);
 var instance = new WebAssembly.Instance(module, {
  "e": {
   "f": func
  }
 });
 var wrappedFunc = instance.exports["f"];
 return wrappedFunc;
}

var freeTableIndexes = [];

var functionsInTableMap;

function getEmptyTableSlot() {
 if (freeTableIndexes.length) {
  return freeTableIndexes.pop();
 }
 try {
  wasmTable.grow(1);
 } catch (err) {
  if (!(err instanceof RangeError)) {
   throw err;
  }
  throw "Unable to grow wasm table. Set ALLOW_TABLE_GROWTH.";
 }
 return wasmTable.length - 1;
}

function updateTableMap(offset, count) {
 for (var i = offset; i < offset + count; i++) {
  var item = getWasmTableEntry(i);
  if (item) {
   functionsInTableMap.set(item, i);
  }
 }
}

function addFunction(func, sig) {
 assert(typeof func != "undefined");
 if (!functionsInTableMap) {
  functionsInTableMap = new WeakMap();
  updateTableMap(0, wasmTable.length);
 }
 if (functionsInTableMap.has(func)) {
  return functionsInTableMap.get(func);
 }
 var ret = getEmptyTableSlot();
 try {
  setWasmTableEntry(ret, func);
 } catch (err) {
  if (!(err instanceof TypeError)) {
   throw err;
  }
  assert(typeof sig != "undefined", "Missing signature argument to addFunction: " + func);
  var wrapped = convertJsFunctionToWasm(func, sig);
  setWasmTableEntry(ret, wrapped);
 }
 functionsInTableMap.set(func, ret);
 return ret;
}

function removeFunction(index) {
 functionsInTableMap.delete(getWasmTableEntry(index));
 freeTableIndexes.push(index);
}

function legacyModuleProp(prop, newName) {
 if (!Object.getOwnPropertyDescriptor(Module, prop)) {
  Object.defineProperty(Module, prop, {
   configurable: true,
   get: function() {
    abort("Module." + prop + " has been replaced with plain " + newName + " (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)");
   }
  });
 }
}

function ignoredModuleProp(prop) {
 if (Object.getOwnPropertyDescriptor(Module, prop)) {
  abort("`Module." + prop + "` was supplied but `" + prop + "` not included in INCOMING_MODULE_JS_API");
 }
}

function unexportedMessage(sym, isFSSybol) {
 var msg = "'" + sym + "' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)";
 if (isFSSybol) {
  msg += ". Alternatively, forcing filesystem support (-s FORCE_FILESYSTEM=1) can export this for you";
 }
 return msg;
}

function unexportedRuntimeSymbol(sym, isFSSybol) {
 if (!Object.getOwnPropertyDescriptor(Module, sym)) {
  Object.defineProperty(Module, sym, {
   configurable: true,
   get: function() {
    abort(unexportedMessage(sym, isFSSybol));
   }
  });
 }
}

function unexportedRuntimeFunction(sym, isFSSybol) {
 if (!Object.getOwnPropertyDescriptor(Module, sym)) {
  Module[sym] = (() => abort(unexportedMessage(sym, isFSSybol)));
 }
}

var tempRet0 = 0;

var setTempRet0 = value => {
 tempRet0 = value;
};

var getTempRet0 = () => tempRet0;

var Atomics_load = Atomics.load;

var Atomics_store = Atomics.store;

var Atomics_compareExchange = Atomics.compareExchange;

var wasmBinary;

if (Module["wasmBinary"]) wasmBinary = Module["wasmBinary"];

legacyModuleProp("wasmBinary", "wasmBinary");

var noExitRuntime = Module["noExitRuntime"] || true;

legacyModuleProp("noExitRuntime", "noExitRuntime");

if (typeof WebAssembly != "object") {
 abort("no native wasm support detected");
}

function setValue(ptr, value, type = "i8", noSafe) {
 if (type.charAt(type.length - 1) === "*") type = "i32";
 switch (type) {
 case "i1":
  GROWABLE_HEAP_I8()[ptr >> 0] = value;
  break;

 case "i8":
  GROWABLE_HEAP_I8()[ptr >> 0] = value;
  break;

 case "i16":
  GROWABLE_HEAP_I16()[ptr >> 1] = value;
  break;

 case "i32":
  GROWABLE_HEAP_I32()[ptr >> 2] = value;
  break;

 case "i64":
  tempI64 = [ value >>> 0, (tempDouble = value, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? (Math.min(+Math.floor(tempDouble / 4294967296), 4294967295) | 0) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0) ], 
  GROWABLE_HEAP_I32()[ptr >> 2] = tempI64[0], GROWABLE_HEAP_I32()[ptr + 4 >> 2] = tempI64[1];
  break;

 case "float":
  GROWABLE_HEAP_F32()[ptr >> 2] = value;
  break;

 case "double":
  GROWABLE_HEAP_F64()[ptr >> 3] = value;
  break;

 default:
  abort("invalid type for setValue: " + type);
 }
}

function getValue(ptr, type = "i8", noSafe) {
 if (type.charAt(type.length - 1) === "*") type = "i32";
 switch (type) {
 case "i1":
  return GROWABLE_HEAP_I8()[ptr >> 0];

 case "i8":
  return GROWABLE_HEAP_I8()[ptr >> 0];

 case "i16":
  return GROWABLE_HEAP_I16()[ptr >> 1];

 case "i32":
  return GROWABLE_HEAP_I32()[ptr >> 2];

 case "i64":
  return GROWABLE_HEAP_I32()[ptr >> 2];

 case "float":
  return GROWABLE_HEAP_F32()[ptr >> 2];

 case "double":
  return Number(GROWABLE_HEAP_F64()[ptr >> 3]);

 default:
  abort("invalid type for getValue: " + type);
 }
 return null;
}

var wasmMemory;

var wasmModule;

var ABORT = false;

var EXITSTATUS;

function assert(condition, text) {
 if (!condition) {
  abort("Assertion failed" + (text ? ": " + text : ""));
 }
}

function getCFunc(ident) {
 var func = Module["_" + ident];
 assert(func, "Cannot call unknown function " + ident + ", make sure it is exported");
 return func;
}

function ccall(ident, returnType, argTypes, args, opts) {
 var toC = {
  "string": function(str) {
   var ret = 0;
   if (str !== null && str !== undefined && str !== 0) {
    var len = (str.length << 2) + 1;
    ret = stackAlloc(len);
    stringToUTF8(str, ret, len);
   }
   return ret;
  },
  "array": function(arr) {
   var ret = stackAlloc(arr.length);
   writeArrayToMemory(arr, ret);
   return ret;
  }
 };
 function convertReturnValue(ret) {
  if (returnType === "string") return UTF8ToString(ret);
  if (returnType === "boolean") return Boolean(ret);
  return ret;
 }
 var func = getCFunc(ident);
 var cArgs = [];
 var stack = 0;
 assert(returnType !== "array", 'Return type should not be "array".');
 if (args) {
  for (var i = 0; i < args.length; i++) {
   var converter = toC[argTypes[i]];
   if (converter) {
    if (stack === 0) stack = stackSave();
    cArgs[i] = converter(args[i]);
   } else {
    cArgs[i] = args[i];
   }
  }
 }
 var ret = func.apply(null, cArgs);
 function onDone(ret) {
  if (stack !== 0) stackRestore(stack);
  return convertReturnValue(ret);
 }
 ret = onDone(ret);
 return ret;
}

function cwrap(ident, returnType, argTypes, opts) {
 return function() {
  return ccall(ident, returnType, argTypes, arguments, opts);
 };
}

var ALLOC_NORMAL = 0;

var ALLOC_STACK = 1;

function allocate(slab, allocator) {
 var ret;
 assert(typeof allocator == "number", "allocate no longer takes a type argument");
 assert(typeof slab != "number", "allocate no longer takes a number as arg0");
 if (allocator == ALLOC_STACK) {
  ret = stackAlloc(slab.length);
 } else {
  ret = _malloc(slab.length);
 }
 if (!slab.subarray && !slab.slice) {
  slab = new Uint8Array(slab);
 }
 GROWABLE_HEAP_U8().set(slab, ret);
 return ret;
}

function TextDecoderWrapper(encoding) {
 var textDecoder = new TextDecoder(encoding);
 this.decode = (data => {
  assert(data instanceof Uint8Array);
  if (data.buffer instanceof SharedArrayBuffer) {
   data = new Uint8Array(data);
  }
  return textDecoder.decode.call(textDecoder, data);
 });
}

var UTF8Decoder = typeof TextDecoder != "undefined" ? new TextDecoderWrapper("utf8") : undefined;

function UTF8ArrayToString(heap, idx, maxBytesToRead) {
 var endIdx = idx + maxBytesToRead;
 var endPtr = idx;
 while (heap[endPtr] && !(endPtr >= endIdx)) ++endPtr;
 if (endPtr - idx > 16 && heap.subarray && UTF8Decoder) {
  return UTF8Decoder.decode(heap.subarray(idx, endPtr));
 } else {
  var str = "";
  while (idx < endPtr) {
   var u0 = heap[idx++];
   if (!(u0 & 128)) {
    str += String.fromCharCode(u0);
    continue;
   }
   var u1 = heap[idx++] & 63;
   if ((u0 & 224) == 192) {
    str += String.fromCharCode((u0 & 31) << 6 | u1);
    continue;
   }
   var u2 = heap[idx++] & 63;
   if ((u0 & 240) == 224) {
    u0 = (u0 & 15) << 12 | u1 << 6 | u2;
   } else {
    if ((u0 & 248) != 240) warnOnce("Invalid UTF-8 leading byte 0x" + u0.toString(16) + " encountered when deserializing a UTF-8 string in wasm memory to a JS string!");
    u0 = (u0 & 7) << 18 | u1 << 12 | u2 << 6 | heap[idx++] & 63;
   }
   if (u0 < 65536) {
    str += String.fromCharCode(u0);
   } else {
    var ch = u0 - 65536;
    str += String.fromCharCode(55296 | ch >> 10, 56320 | ch & 1023);
   }
  }
 }
 return str;
}

function UTF8ToString(ptr, maxBytesToRead) {
 return ptr ? UTF8ArrayToString(GROWABLE_HEAP_U8(), ptr, maxBytesToRead) : "";
}

function stringToUTF8Array(str, heap, outIdx, maxBytesToWrite) {
 if (!(maxBytesToWrite > 0)) return 0;
 var startIdx = outIdx;
 var endIdx = outIdx + maxBytesToWrite - 1;
 for (var i = 0; i < str.length; ++i) {
  var u = str.charCodeAt(i);
  if (u >= 55296 && u <= 57343) {
   var u1 = str.charCodeAt(++i);
   u = 65536 + ((u & 1023) << 10) | u1 & 1023;
  }
  if (u <= 127) {
   if (outIdx >= endIdx) break;
   heap[outIdx++] = u;
  } else if (u <= 2047) {
   if (outIdx + 1 >= endIdx) break;
   heap[outIdx++] = 192 | u >> 6;
   heap[outIdx++] = 128 | u & 63;
  } else if (u <= 65535) {
   if (outIdx + 2 >= endIdx) break;
   heap[outIdx++] = 224 | u >> 12;
   heap[outIdx++] = 128 | u >> 6 & 63;
   heap[outIdx++] = 128 | u & 63;
  } else {
   if (outIdx + 3 >= endIdx) break;
   if (u > 1114111) warnOnce("Invalid Unicode code point 0x" + u.toString(16) + " encountered when serializing a JS string to a UTF-8 string in wasm memory! (Valid unicode code points should be in range 0-0x10FFFF).");
   heap[outIdx++] = 240 | u >> 18;
   heap[outIdx++] = 128 | u >> 12 & 63;
   heap[outIdx++] = 128 | u >> 6 & 63;
   heap[outIdx++] = 128 | u & 63;
  }
 }
 heap[outIdx] = 0;
 return outIdx - startIdx;
}

function stringToUTF8(str, outPtr, maxBytesToWrite) {
 assert(typeof maxBytesToWrite == "number", "stringToUTF8(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!");
 return stringToUTF8Array(str, GROWABLE_HEAP_U8(), outPtr, maxBytesToWrite);
}

function lengthBytesUTF8(str) {
 var len = 0;
 for (var i = 0; i < str.length; ++i) {
  var u = str.charCodeAt(i);
  if (u >= 55296 && u <= 57343) u = 65536 + ((u & 1023) << 10) | str.charCodeAt(++i) & 1023;
  if (u <= 127) ++len; else if (u <= 2047) len += 2; else if (u <= 65535) len += 3; else len += 4;
 }
 return len;
}

function AsciiToString(ptr) {
 var str = "";
 while (1) {
  var ch = GROWABLE_HEAP_U8()[ptr++ >> 0];
  if (!ch) return str;
  str += String.fromCharCode(ch);
 }
}

function stringToAscii(str, outPtr) {
 return writeAsciiToMemory(str, outPtr, false);
}

var UTF16Decoder = typeof TextDecoder != "undefined" ? new TextDecoderWrapper("utf-16le") : undefined;

function UTF16ToString(ptr, maxBytesToRead) {
 assert(ptr % 2 == 0, "Pointer passed to UTF16ToString must be aligned to two bytes!");
 var endPtr = ptr;
 var idx = endPtr >> 1;
 var maxIdx = idx + maxBytesToRead / 2;
 while (!(idx >= maxIdx) && GROWABLE_HEAP_U16()[idx]) ++idx;
 endPtr = idx << 1;
 if (endPtr - ptr > 32 && UTF16Decoder) {
  return UTF16Decoder.decode(GROWABLE_HEAP_U8().subarray(ptr, endPtr));
 } else {
  var str = "";
  for (var i = 0; !(i >= maxBytesToRead / 2); ++i) {
   var codeUnit = GROWABLE_HEAP_I16()[ptr + i * 2 >> 1];
   if (codeUnit == 0) break;
   str += String.fromCharCode(codeUnit);
  }
  return str;
 }
}

function stringToUTF16(str, outPtr, maxBytesToWrite) {
 assert(outPtr % 2 == 0, "Pointer passed to stringToUTF16 must be aligned to two bytes!");
 assert(typeof maxBytesToWrite == "number", "stringToUTF16(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!");
 if (maxBytesToWrite === undefined) {
  maxBytesToWrite = 2147483647;
 }
 if (maxBytesToWrite < 2) return 0;
 maxBytesToWrite -= 2;
 var startPtr = outPtr;
 var numCharsToWrite = maxBytesToWrite < str.length * 2 ? maxBytesToWrite / 2 : str.length;
 for (var i = 0; i < numCharsToWrite; ++i) {
  var codeUnit = str.charCodeAt(i);
  GROWABLE_HEAP_I16()[outPtr >> 1] = codeUnit;
  outPtr += 2;
 }
 GROWABLE_HEAP_I16()[outPtr >> 1] = 0;
 return outPtr - startPtr;
}

function lengthBytesUTF16(str) {
 return str.length * 2;
}

function UTF32ToString(ptr, maxBytesToRead) {
 assert(ptr % 4 == 0, "Pointer passed to UTF32ToString must be aligned to four bytes!");
 var i = 0;
 var str = "";
 while (!(i >= maxBytesToRead / 4)) {
  var utf32 = GROWABLE_HEAP_I32()[ptr + i * 4 >> 2];
  if (utf32 == 0) break;
  ++i;
  if (utf32 >= 65536) {
   var ch = utf32 - 65536;
   str += String.fromCharCode(55296 | ch >> 10, 56320 | ch & 1023);
  } else {
   str += String.fromCharCode(utf32);
  }
 }
 return str;
}

function stringToUTF32(str, outPtr, maxBytesToWrite) {
 assert(outPtr % 4 == 0, "Pointer passed to stringToUTF32 must be aligned to four bytes!");
 assert(typeof maxBytesToWrite == "number", "stringToUTF32(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!");
 if (maxBytesToWrite === undefined) {
  maxBytesToWrite = 2147483647;
 }
 if (maxBytesToWrite < 4) return 0;
 var startPtr = outPtr;
 var endPtr = startPtr + maxBytesToWrite - 4;
 for (var i = 0; i < str.length; ++i) {
  var codeUnit = str.charCodeAt(i);
  if (codeUnit >= 55296 && codeUnit <= 57343) {
   var trailSurrogate = str.charCodeAt(++i);
   codeUnit = 65536 + ((codeUnit & 1023) << 10) | trailSurrogate & 1023;
  }
  GROWABLE_HEAP_I32()[outPtr >> 2] = codeUnit;
  outPtr += 4;
  if (outPtr + 4 > endPtr) break;
 }
 GROWABLE_HEAP_I32()[outPtr >> 2] = 0;
 return outPtr - startPtr;
}

function lengthBytesUTF32(str) {
 var len = 0;
 for (var i = 0; i < str.length; ++i) {
  var codeUnit = str.charCodeAt(i);
  if (codeUnit >= 55296 && codeUnit <= 57343) ++i;
  len += 4;
 }
 return len;
}

function allocateUTF8(str) {
 var size = lengthBytesUTF8(str) + 1;
 var ret = _malloc(size);
 if (ret) stringToUTF8Array(str, GROWABLE_HEAP_I8(), ret, size);
 return ret;
}

function allocateUTF8OnStack(str) {
 var size = lengthBytesUTF8(str) + 1;
 var ret = stackAlloc(size);
 stringToUTF8Array(str, GROWABLE_HEAP_I8(), ret, size);
 return ret;
}

function writeStringToMemory(string, buffer, dontAddNull) {
 warnOnce("writeStringToMemory is deprecated and should not be called! Use stringToUTF8() instead!");
 var lastChar, end;
 if (dontAddNull) {
  end = buffer + lengthBytesUTF8(string);
  lastChar = GROWABLE_HEAP_I8()[end];
 }
 stringToUTF8(string, buffer, Infinity);
 if (dontAddNull) GROWABLE_HEAP_I8()[end] = lastChar;
}

function writeArrayToMemory(array, buffer) {
 assert(array.length >= 0, "writeArrayToMemory array must have a length (should be an array or typed array)");
 GROWABLE_HEAP_I8().set(array, buffer);
}

function writeAsciiToMemory(str, buffer, dontAddNull) {
 for (var i = 0; i < str.length; ++i) {
  assert(str.charCodeAt(i) === (str.charCodeAt(i) & 255));
  GROWABLE_HEAP_I8()[buffer++ >> 0] = str.charCodeAt(i);
 }
 if (!dontAddNull) GROWABLE_HEAP_I8()[buffer >> 0] = 0;
}

var HEAP, buffer, HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;

if (ENVIRONMENT_IS_PTHREAD) {
 buffer = Module["buffer"];
}

function updateGlobalBufferAndViews(buf) {
 buffer = buf;
 Module["HEAP8"] = HEAP8 = new Int8Array(buf);
 Module["HEAP16"] = HEAP16 = new Int16Array(buf);
 Module["HEAP32"] = HEAP32 = new Int32Array(buf);
 Module["HEAPU8"] = HEAPU8 = new Uint8Array(buf);
 Module["HEAPU16"] = HEAPU16 = new Uint16Array(buf);
 Module["HEAPU32"] = HEAPU32 = new Uint32Array(buf);
 Module["HEAPF32"] = HEAPF32 = new Float32Array(buf);
 Module["HEAPF64"] = HEAPF64 = new Float64Array(buf);
}

var TOTAL_STACK = 5242880;

if (Module["TOTAL_STACK"]) assert(TOTAL_STACK === Module["TOTAL_STACK"], "the stack size can no longer be determined at runtime");

var INITIAL_MEMORY = Module["INITIAL_MEMORY"] || 134217728;

legacyModuleProp("INITIAL_MEMORY", "INITIAL_MEMORY");

assert(INITIAL_MEMORY >= TOTAL_STACK, "INITIAL_MEMORY should be larger than TOTAL_STACK, was " + INITIAL_MEMORY + "! (TOTAL_STACK=" + TOTAL_STACK + ")");

assert(typeof Int32Array != "undefined" && typeof Float64Array !== "undefined" && Int32Array.prototype.subarray != undefined && Int32Array.prototype.set != undefined, "JS engine does not provide full typed array support");

if (ENVIRONMENT_IS_PTHREAD) {
 wasmMemory = Module["wasmMemory"];
 buffer = Module["buffer"];
} else {
 if (Module["wasmMemory"]) {
  wasmMemory = Module["wasmMemory"];
 } else {
  wasmMemory = new WebAssembly.Memory({
   "initial": INITIAL_MEMORY / 65536,
   "maximum": 2147483648 / 65536,
   "shared": true
  });
  if (!(wasmMemory.buffer instanceof SharedArrayBuffer)) {
   err("requested a shared WebAssembly.Memory but the returned buffer is not a SharedArrayBuffer, indicating that while the browser has SharedArrayBuffer it does not have WebAssembly threads support - you may need to set a flag");
   if (ENVIRONMENT_IS_NODE) {
    console.log("(on node you may need: --experimental-wasm-threads --experimental-wasm-bulk-memory and also use a recent version)");
   }
   throw Error("bad memory");
  }
 }
}

if (wasmMemory) {
 buffer = wasmMemory.buffer;
}

INITIAL_MEMORY = buffer.byteLength;

assert(INITIAL_MEMORY % 65536 === 0);

updateGlobalBufferAndViews(buffer);

var wasmTable;

function writeStackCookie() {
 var max = _emscripten_stack_get_end();
 assert((max & 3) == 0);
 GROWABLE_HEAP_I32()[max >> 2] = 34821223;
 GROWABLE_HEAP_I32()[max + 4 >> 2] = 2310721022;
 GROWABLE_HEAP_I32()[0] = 1668509029;
}

function checkStackCookie() {
 if (ABORT) return;
 var max = _emscripten_stack_get_end();
 var cookie1 = GROWABLE_HEAP_U32()[max >> 2];
 var cookie2 = GROWABLE_HEAP_U32()[max + 4 >> 2];
 if (cookie1 != 34821223 || cookie2 != 2310721022) {
  abort("Stack overflow! Stack cookie has been overwritten, expected hex dwords 0x89BACDFE and 0x2135467, but received 0x" + cookie2.toString(16) + " 0x" + cookie1.toString(16));
 }
 if (GROWABLE_HEAP_I32()[0] !== 1668509029) abort("Runtime error: The application has corrupted its heap memory area (address zero)!");
}

(function() {
 var h16 = new Int16Array(1);
 var h8 = new Int8Array(h16.buffer);
 h16[0] = 25459;
 if (h8[0] !== 115 || h8[1] !== 99) throw "Runtime error: expected the system to be little-endian! (Run with -s SUPPORT_BIG_ENDIAN=1 to bypass)";
})();

var __ATPRERUN__ = [];

var __ATINIT__ = [];

var __ATEXIT__ = [];

var __ATPOSTRUN__ = [];

var runtimeInitialized = false;

var runtimeExited = false;

var runtimeKeepaliveCounter = 0;

function keepRuntimeAlive() {
 return noExitRuntime || runtimeKeepaliveCounter > 0;
}

function preRun() {
 assert(!ENVIRONMENT_IS_PTHREAD);
 if (Module["preRun"]) {
  if (typeof Module["preRun"] == "function") Module["preRun"] = [ Module["preRun"] ];
  while (Module["preRun"].length) {
   addOnPreRun(Module["preRun"].shift());
  }
 }
 callRuntimeCallbacks(__ATPRERUN__);
}

function initRuntime() {
 checkStackCookie();
 assert(!runtimeInitialized);
 runtimeInitialized = true;
 if (ENVIRONMENT_IS_PTHREAD) return;
 if (!Module["noFSInit"] && !FS.init.initialized) FS.init();
 FS.ignorePermissions = false;
 TTY.init();
 SOCKFS.root = FS.mount(SOCKFS, {}, null);
 callRuntimeCallbacks(__ATINIT__);
}

function exitRuntime() {
 checkStackCookie();
 if (ENVIRONMENT_IS_PTHREAD) return;
 PThread.terminateAllThreads();
 runtimeExited = true;
}

function postRun() {
 checkStackCookie();
 if (ENVIRONMENT_IS_PTHREAD) return;
 if (Module["postRun"]) {
  if (typeof Module["postRun"] == "function") Module["postRun"] = [ Module["postRun"] ];
  while (Module["postRun"].length) {
   addOnPostRun(Module["postRun"].shift());
  }
 }
 callRuntimeCallbacks(__ATPOSTRUN__);
}

function addOnPreRun(cb) {
 __ATPRERUN__.unshift(cb);
}

function addOnInit(cb) {
 __ATINIT__.unshift(cb);
}

function addOnExit(cb) {}

function addOnPostRun(cb) {
 __ATPOSTRUN__.unshift(cb);
}

assert(Math.imul, "This browser does not support Math.imul(), build with LEGACY_VM_SUPPORT or POLYFILL_OLD_MATH_FUNCTIONS to add in a polyfill");

assert(Math.fround, "This browser does not support Math.fround(), build with LEGACY_VM_SUPPORT or POLYFILL_OLD_MATH_FUNCTIONS to add in a polyfill");

assert(Math.clz32, "This browser does not support Math.clz32(), build with LEGACY_VM_SUPPORT or POLYFILL_OLD_MATH_FUNCTIONS to add in a polyfill");

assert(Math.trunc, "This browser does not support Math.trunc(), build with LEGACY_VM_SUPPORT or POLYFILL_OLD_MATH_FUNCTIONS to add in a polyfill");

var runDependencies = 0;

var runDependencyWatcher = null;

var dependenciesFulfilled = null;

var runDependencyTracking = {};

function getUniqueRunDependency(id) {
 var orig = id;
 while (1) {
  if (!runDependencyTracking[id]) return id;
  id = orig + Math.random();
 }
}

function addRunDependency(id) {
 runDependencies++;
 if (Module["monitorRunDependencies"]) {
  Module["monitorRunDependencies"](runDependencies);
 }
 if (id) {
  assert(!runDependencyTracking[id]);
  runDependencyTracking[id] = 1;
  if (runDependencyWatcher === null && typeof setInterval != "undefined") {
   runDependencyWatcher = setInterval(function() {
    if (ABORT) {
     clearInterval(runDependencyWatcher);
     runDependencyWatcher = null;
     return;
    }
    var shown = false;
    for (var dep in runDependencyTracking) {
     if (!shown) {
      shown = true;
      err("still waiting on run dependencies:");
     }
     err("dependency: " + dep);
    }
    if (shown) {
     err("(end of list)");
    }
   }, 1e4);
  }
 } else {
  err("warning: run dependency added without ID");
 }
}

function removeRunDependency(id) {
 runDependencies--;
 if (Module["monitorRunDependencies"]) {
  Module["monitorRunDependencies"](runDependencies);
 }
 if (id) {
  assert(runDependencyTracking[id]);
  delete runDependencyTracking[id];
 } else {
  err("warning: run dependency removed without ID");
 }
 if (runDependencies == 0) {
  if (runDependencyWatcher !== null) {
   clearInterval(runDependencyWatcher);
   runDependencyWatcher = null;
  }
  if (dependenciesFulfilled) {
   var callback = dependenciesFulfilled;
   dependenciesFulfilled = null;
   callback();
  }
 }
}

Module["preloadedImages"] = {};

Module["preloadedAudios"] = {};

function abort(what) {
 if (ENVIRONMENT_IS_PTHREAD) {
  postMessage({
   "cmd": "onAbort",
   "arg": what
  });
 } else {
  if (Module["onAbort"]) {
   Module["onAbort"](what);
  }
 }
 what = "Aborted(" + what + ")";
 err(what);
 ABORT = true;
 EXITSTATUS = 1;
 var e = new WebAssembly.RuntimeError(what);
 throw e;
}

var dataURIPrefix = "data:application/octet-stream;base64,";

function isDataURI(filename) {
 return filename.startsWith(dataURIPrefix);
}

function isFileURI(filename) {
 return filename.startsWith("file://");
}

function createExportWrapper(name, fixedasm) {
 return function() {
  var displayName = name;
  var asm = fixedasm;
  if (!fixedasm) {
   asm = Module["asm"];
  }
  assert(runtimeInitialized, "native function `" + displayName + "` called before runtime initialization");
  assert(!runtimeExited, "native function `" + displayName + "` called after runtime exit (use NO_EXIT_RUNTIME to keep it alive after main() exits)");
  if (!asm[name]) {
   assert(asm[name], "exported native function `" + displayName + "` not found");
  }
  return asm[name].apply(null, arguments);
 };
}

var wasmBinaryFile;

wasmBinaryFile = "libplayer.wasm";

if (!isDataURI(wasmBinaryFile)) {
 wasmBinaryFile = locateFile(wasmBinaryFile);
}

function getBinary(file) {
 try {
  if (file == wasmBinaryFile && wasmBinary) {
   return new Uint8Array(wasmBinary);
  }
  if (readBinary) {
   return readBinary(file);
  } else {
   throw "both async and sync fetching of the wasm failed";
  }
 } catch (err) {
  abort(err);
 }
}

function getBinaryPromise() {
 if (!wasmBinary && (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER)) {
  if (typeof fetch == "function" && !isFileURI(wasmBinaryFile)) {
   return fetch(wasmBinaryFile, {
    credentials: "same-origin"
   }).then(function(response) {
    if (!response["ok"]) {
     throw "failed to load wasm binary file at '" + wasmBinaryFile + "'";
    }
    return response["arrayBuffer"]();
   }).catch(function() {
    return getBinary(wasmBinaryFile);
   });
  } else {
   if (readAsync) {
    return new Promise(function(resolve, reject) {
     readAsync(wasmBinaryFile, function(response) {
      resolve(new Uint8Array(response));
     }, reject);
    });
   }
  }
 }
 return Promise.resolve().then(function() {
  return getBinary(wasmBinaryFile);
 });
}

function createWasm() {
 var info = {
  "env": asmLibraryArg,
  "wasi_snapshot_preview1": asmLibraryArg
 };
 function receiveInstance(instance, module) {
  var exports = instance.exports;
  Module["asm"] = exports;
  registerTlsInit(Module["asm"]["emscripten_tls_init"]);
  wasmTable = Module["asm"]["__indirect_function_table"];
  assert(wasmTable, "table not found in wasm exports");
  addOnInit(Module["asm"]["__wasm_call_ctors"]);
  wasmModule = module;
  if (!ENVIRONMENT_IS_PTHREAD) {
   var numWorkersToLoad = PThread.unusedWorkers.length;
   PThread.unusedWorkers.forEach(function(w) {
    PThread.loadWasmModuleToWorker(w, function() {});
   });
   removeRunDependency("wasm-instantiate");
  }
 }
 if (!ENVIRONMENT_IS_PTHREAD) {
  addRunDependency("wasm-instantiate");
 }
 var trueModule = Module;
 function receiveInstantiationResult(result) {
  assert(Module === trueModule, "the Module object should not be replaced during async compilation - perhaps the order of HTML elements is wrong?");
  trueModule = null;
  receiveInstance(result["instance"], result["module"]);
 }
 function instantiateArrayBuffer(receiver) {
  return getBinaryPromise().then(function(binary) {
   return WebAssembly.instantiate(binary, info);
  }).then(function(instance) {
   return instance;
  }).then(receiver, function(reason) {
   err("failed to asynchronously prepare wasm: " + reason);
   if (isFileURI(wasmBinaryFile)) {
    err("warning: Loading from a file URI (" + wasmBinaryFile + ") is not supported in most browsers. See https://emscripten.org/docs/getting_started/FAQ.html#how-do-i-run-a-local-webserver-for-testing-why-does-my-program-stall-in-downloading-or-preparing");
   }
   abort(reason);
  });
 }
 function instantiateAsync() {
  if (!wasmBinary && typeof WebAssembly.instantiateStreaming == "function" && !isDataURI(wasmBinaryFile) && !isFileURI(wasmBinaryFile) && typeof fetch == "function") {
   return fetch(wasmBinaryFile, {
    credentials: "same-origin"
   }).then(function(response) {
    var result = WebAssembly.instantiateStreaming(response, info);
    return result.then(receiveInstantiationResult, function(reason) {
     err("wasm streaming compile failed: " + reason);
     err("falling back to ArrayBuffer instantiation");
     return instantiateArrayBuffer(receiveInstantiationResult);
    });
   });
  } else {
   return instantiateArrayBuffer(receiveInstantiationResult);
  }
 }
 if (Module["instantiateWasm"]) {
  try {
   var exports = Module["instantiateWasm"](info, receiveInstance);
   return exports;
  } catch (e) {
   err("Module.instantiateWasm callback failed with error: " + e);
   return false;
  }
 }
 instantiateAsync();
 return {};
}

var tempDouble;

var tempI64;

var ASM_CONSTS = {
 612080: function($0, $1, $2, $3, $4, $5, $6, $7, $8) {
  return web_init_videodecoder($0, $1, $2, $3, $4, $5, $6, $7, $8);
 },
 612150: function($0, $1) {
  return web_destroy_videodecoder($0, $1);
 },
 612195: function($0, $1, $2, $3, $4, $5, $6, $7, $8, $9, $10) {
  return web_push_video_pkt($0, $1, $2, $3, $4, $5, $6, $7, $8, $9, $10);
 },
 612271: function($0, $1) {
  return web_get_videodecoder_queue_size($0, $1);
 },
 612323: function($0, $1) {
  return web_videodecoder_flush($0, $1);
 },
 612366: function($0, $1, $2) {
  return web_video_frame_detach($0, $1, $2);
 },
 612413: function($0, $1, $2, $3, $4, $5) {
  return web_video_play($0, $1, $2, $3, $4, $5);
 },
 612464: function($0, $1, $2, $3, $4, $5, $6, $7) {
  return web_video_display_yuv($0, $1, $2, $3, $4, $5, $6, $7);
 },
 612530: function($0, $1, $2, $3, $4, $5, $6, $7, $8) {
  return web_init_audiodecoder($0, $1, $2, $3, $4, $5, $6, $7, $8);
 },
 612600: function($0, $1) {
  return web_destroy_audiodecoder($0, $1);
 },
 612645: function($0, $1, $2, $3, $4, $5, $6) {
  return web_push_audio_pkt($0, $1, $2, $3, $4, $5, $6);
 },
 612704: function($0, $1) {
  return web_get_audiodecoder_queue_size($0, $1);
 },
 612756: function($0, $1) {
  return web_audiodecoder_flush($0, $1);
 },
 612799: function($0) {
  return web_set_audio_play_sample_rate($0);
 },
 612846: function($0, $1) {
  return web_media_play_control($0, $1);
 },
 612889: function($0, $1) {
  return web_get_device_info($0, $1);
 },
 612929: function($0) {
  return web_backtrace($0);
 },
 612959: function($0, $1, $2, $3, $4, $5) {
  web_raw_msg($0, $1, $2, $3, $4, $5);
 },
 613e3: function($0, $1, $2, $3) {
  let ws = null;
  try {
   ws = create_PI_socket($0, $1, $2, $3);
   if (ws) return 0; else return -1;
  } catch (err) {
   console.log(err);
   return -2;
  }
 },
 613144: function($0) {
  let ret = WS[$0].close();
  WS[$0] = null;
  return ret;
 },
 613201: function($0, $1, $2) {
  if (WS[$0]) {
   return WS[$0].send($1, $2);
  } else return -1;
 },
 613265: function($0) {
  if (WS[$0]) {
   return WS[$0].state();
  } else return WebSocket.CLOSED;
 }
};

function callRuntimeCallbacks(callbacks) {
 while (callbacks.length > 0) {
  var callback = callbacks.shift();
  if (typeof callback == "function") {
   callback(Module);
   continue;
  }
  var func = callback.func;
  if (typeof func == "number") {
   if (callback.arg === undefined) {
    getWasmTableEntry(func)();
   } else {
    getWasmTableEntry(func)(callback.arg);
   }
  } else {
   func(callback.arg === undefined ? null : callback.arg);
  }
 }
}

function withStackSave(f) {
 var stack = stackSave();
 var ret = f();
 stackRestore(stack);
 return ret;
}

function demangle(func) {
 warnOnce("warning: build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling");
 return func;
}

function demangleAll(text) {
 var regex = /\b_Z[\w\d_]+/g;
 return text.replace(regex, function(x) {
  var y = demangle(x);
  return x === y ? x : y + " [" + x + "]";
 });
}

function killThread(pthread_ptr) {
 assert(!ENVIRONMENT_IS_PTHREAD, "Internal Error! killThread() can only ever be called from main application thread!");
 assert(pthread_ptr, "Internal Error! Null pthread_ptr in killThread!");
 GROWABLE_HEAP_I32()[pthread_ptr >> 2] = 0;
 var pthread = PThread.pthreads[pthread_ptr];
 delete PThread.pthreads[pthread_ptr];
 pthread.worker.terminate();
 __emscripten_thread_free_data(pthread_ptr);
 PThread.runningWorkers.splice(PThread.runningWorkers.indexOf(pthread.worker), 1);
 pthread.worker.pthread = undefined;
}

function cancelThread(pthread_ptr) {
 assert(!ENVIRONMENT_IS_PTHREAD, "Internal Error! cancelThread() can only ever be called from main application thread!");
 assert(pthread_ptr, "Internal Error! Null pthread_ptr in cancelThread!");
 var pthread = PThread.pthreads[pthread_ptr];
 pthread.worker.postMessage({
  "cmd": "cancel"
 });
}

function cleanupThread(pthread_ptr) {
 assert(!ENVIRONMENT_IS_PTHREAD, "Internal Error! cleanupThread() can only ever be called from main application thread!");
 assert(pthread_ptr, "Internal Error! Null pthread_ptr in cleanupThread!");
 var pthread = PThread.pthreads[pthread_ptr];
 if (pthread) {
  GROWABLE_HEAP_I32()[pthread_ptr >> 2] = 0;
  var worker = pthread.worker;
  PThread.returnWorkerToPool(worker);
 }
}

function zeroMemory(address, size) {
 GROWABLE_HEAP_U8().fill(0, address, address + size);
}

function ptrToString(ptr) {
 return "0x" + ptr.toString(16).padStart(8, "0");
}

function _exit(status) {
 exit(status);
}

function handleException(e) {
 if (e instanceof ExitStatus || e == "unwind") {
  return EXITSTATUS;
 }
 quit_(1, e);
}

var PThread = {
 unusedWorkers: [],
 runningWorkers: [],
 tlsInitFunctions: [],
 init: function() {
  if (ENVIRONMENT_IS_PTHREAD) {
   PThread.initWorker();
  } else {
   PThread.initMainThread();
  }
 },
 initMainThread: function() {
  var pthreadPoolSize = userdefined();
  for (var i = 0; i < pthreadPoolSize; ++i) {
   PThread.allocateUnusedWorker();
  }
 },
 initWorker: function() {
  noExitRuntime = false;
 },
 pthreads: {},
 setExitStatus: function(status) {
  EXITSTATUS = status;
 },
 terminateAllThreads: function() {
  assert(!ENVIRONMENT_IS_PTHREAD, "Internal Error! terminateAllThreads() can only ever be called from main application thread!");
  for (var t in PThread.pthreads) {
   var pthread = PThread.pthreads[t];
   if (pthread && pthread.worker) {
    PThread.returnWorkerToPool(pthread.worker);
   }
  }
  assert(Object.keys(PThread.pthreads).length === 0);
  assert(PThread.runningWorkers.length === 0);
  for (var i = 0; i < PThread.unusedWorkers.length; ++i) {
   var worker = PThread.unusedWorkers[i];
   assert(!worker.pthread);
   worker.terminate();
  }
  PThread.unusedWorkers = [];
 },
 returnWorkerToPool: function(worker) {
  PThread.runWithoutMainThreadQueuedCalls(function() {
   delete PThread.pthreads[worker.pthread.threadInfoStruct];
   PThread.unusedWorkers.push(worker);
   PThread.runningWorkers.splice(PThread.runningWorkers.indexOf(worker), 1);
   __emscripten_thread_free_data(worker.pthread.threadInfoStruct);
   worker.pthread = undefined;
  });
 },
 runWithoutMainThreadQueuedCalls: function(func) {
  assert(PThread.mainRuntimeThread, "runWithoutMainThreadQueuedCalls must be done on the main runtime thread");
  assert(__emscripten_allow_main_runtime_queued_calls);
  GROWABLE_HEAP_I32()[__emscripten_allow_main_runtime_queued_calls >> 2] = 0;
  try {
   func();
  } finally {
   GROWABLE_HEAP_I32()[__emscripten_allow_main_runtime_queued_calls >> 2] = 1;
  }
 },
 receiveObjectTransfer: function(data) {},
 threadInit: function() {
  for (var i in PThread.tlsInitFunctions) {
   if (PThread.tlsInitFunctions.hasOwnProperty(i)) PThread.tlsInitFunctions[i]();
  }
 },
 loadWasmModuleToWorker: function(worker, onFinishedLoading) {
  worker.onmessage = (e => {
   var d = e["data"];
   var cmd = d["cmd"];
   if (worker.pthread) PThread.currentProxiedOperationCallerThread = worker.pthread.threadInfoStruct;
   if (d["targetThread"] && d["targetThread"] != _pthread_self()) {
    var thread = PThread.pthreads[d.targetThread];
    if (thread) {
     thread.worker.postMessage(d, d["transferList"]);
    } else {
     err('Internal error! Worker sent a message "' + cmd + '" to target pthread ' + d["targetThread"] + ", but that thread no longer exists!");
    }
    PThread.currentProxiedOperationCallerThread = undefined;
    return;
   }
   if (cmd === "processQueuedMainThreadWork") {
    _emscripten_main_thread_process_queued_calls();
   } else if (cmd === "spawnThread") {
    spawnThread(d);
   } else if (cmd === "cleanupThread") {
    cleanupThread(d["thread"]);
   } else if (cmd === "killThread") {
    killThread(d["thread"]);
   } else if (cmd === "cancelThread") {
    cancelThread(d["thread"]);
   } else if (cmd === "loaded") {
    worker.loaded = true;
    if (onFinishedLoading) onFinishedLoading(worker);
    if (worker.runPthread) {
     worker.runPthread();
     delete worker.runPthread;
    }
   } else if (cmd === "print") {
    out("Thread " + d["threadId"] + ": " + d["text"]);
   } else if (cmd === "printErr") {
    err("Thread " + d["threadId"] + ": " + d["text"]);
   } else if (cmd === "alert") {
    alert("Thread " + d["threadId"] + ": " + d["text"]);
   } else if (d.target === "setimmediate") {
    worker.postMessage(d);
   } else if (cmd === "onAbort") {
    if (Module["onAbort"]) {
     Module["onAbort"](d["arg"]);
    }
   } else {
    err("worker sent an unknown command " + cmd);
   }
   PThread.currentProxiedOperationCallerThread = undefined;
  });
  worker.onerror = (e => {
   var message = "worker sent an error!";
   if (worker.pthread) {
    var pthread_ptr = worker.pthread.threadInfoStruct;
    if (pthread_ptr) {
     message = "Pthread " + ptrToString(pthread_ptr) + " sent an error!";
    }
   }
   err(message + " " + e.filename + ":" + e.lineno + ": " + e.message);
   throw e;
  });
  if (ENVIRONMENT_IS_NODE) {
   worker.on("message", function(data) {
    worker.onmessage({
     data: data
    });
   });
   worker.on("error", function(e) {
    worker.onerror(e);
   });
   worker.on("detachedExit", function() {});
  }
  assert(wasmMemory instanceof WebAssembly.Memory, "WebAssembly memory should have been loaded by now!");
  assert(wasmModule instanceof WebAssembly.Module, "WebAssembly Module should have been loaded by now!");
  worker.postMessage({
   "cmd": "load",
   "urlOrBlob": Module["mainScriptUrlOrBlob"] || _scriptDir,
   "wasmMemory": wasmMemory,
   "wasmModule": wasmModule
  });
 },
 allocateUnusedWorker: function() {
  var pthreadMainJs = locateFile("libplayer.worker.js");
  PThread.unusedWorkers.push(new Worker(pthreadMainJs));
 },
 getNewWorker: function() {
  if (PThread.unusedWorkers.length == 0) {
   err("Tried to spawn a new thread, but the thread pool is exhausted.\n" + "This might result in a deadlock unless some threads eventually exit or the code explicitly breaks out to the event loop.\n" + "If you want to increase the pool size, use setting `-s PTHREAD_POOL_SIZE=...`." + "\nIf you want to throw an explicit error instead of the risk of deadlocking in those cases, use setting `-s PTHREAD_POOL_SIZE_STRICT=2`.");
   PThread.allocateUnusedWorker();
   PThread.loadWasmModuleToWorker(PThread.unusedWorkers[0]);
  }
  return PThread.unusedWorkers.pop();
 }
};

function establishStackSpace() {
 var pthread_ptr = _pthread_self();
 var stackTop = GROWABLE_HEAP_I32()[pthread_ptr + 44 >> 2];
 var stackSize = GROWABLE_HEAP_I32()[pthread_ptr + 48 >> 2];
 var stackMax = stackTop - stackSize;
 assert(stackTop != 0);
 assert(stackMax != 0);
 assert(stackTop > stackMax);
 _emscripten_stack_set_limits(stackTop, stackMax);
 stackRestore(stackTop);
 writeStackCookie();
}

Module["establishStackSpace"] = establishStackSpace;

function exitOnMainThread(returnCode) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(1, 0, returnCode);
 try {
  _exit(returnCode);
 } catch (e) {
  handleException(e);
 }
}

var wasmTableMirror = [];

function getWasmTableEntry(funcPtr) {
 var func = wasmTableMirror[funcPtr];
 if (!func) {
  if (funcPtr >= wasmTableMirror.length) wasmTableMirror.length = funcPtr + 1;
  wasmTableMirror[funcPtr] = func = wasmTable.get(funcPtr);
 }
 assert(wasmTable.get(funcPtr) == func, "JavaScript-side Wasm function table mirror is out of date!");
 return func;
}

function invokeEntryPoint(ptr, arg) {
 return getWasmTableEntry(ptr)(arg);
}

Module["invokeEntryPoint"] = invokeEntryPoint;

function jsStackTrace() {
 var error = new Error();
 if (!error.stack) {
  try {
   throw new Error();
  } catch (e) {
   error = e;
  }
  if (!error.stack) {
   return "(no stack trace available)";
  }
 }
 return error.stack.toString();
}

function registerTlsInit(tlsInitFunc) {
 PThread.tlsInitFunctions.push(tlsInitFunc);
}

function setWasmTableEntry(idx, func) {
 wasmTable.set(idx, func);
 wasmTableMirror[idx] = func;
}

function stackTrace() {
 var js = jsStackTrace();
 if (Module["extraStackTrace"]) js += "\n" + Module["extraStackTrace"]();
 return demangleAll(js);
}

function ___assert_fail(condition, filename, line, func) {
 abort("Assertion failed: " + UTF8ToString(condition) + ", at: " + [ filename ? UTF8ToString(filename) : "unknown filename", line, func ? UTF8ToString(func) : "unknown function" ]);
}

var _emscripten_get_now;

if (ENVIRONMENT_IS_NODE) {
 _emscripten_get_now = (() => {
  var t = process["hrtime"]();
  return t[0] * 1e3 + t[1] / 1e6;
 });
} else if (ENVIRONMENT_IS_PTHREAD) {
 _emscripten_get_now = (() => performance.now() - Module["__performance_now_clock_drift"]);
} else _emscripten_get_now = (() => performance.now());

var _emscripten_get_now_is_monotonic = true;

function setErrNo(value) {
 GROWABLE_HEAP_I32()[___errno_location() >> 2] = value;
 return value;
}

function _clock_gettime(clk_id, tp) {
 var now;
 if (clk_id === 0) {
  now = Date.now();
 } else if ((clk_id === 1 || clk_id === 4) && _emscripten_get_now_is_monotonic) {
  now = _emscripten_get_now();
 } else {
  setErrNo(28);
  return -1;
 }
 GROWABLE_HEAP_I32()[tp >> 2] = now / 1e3 | 0;
 GROWABLE_HEAP_I32()[tp + 4 >> 2] = now % 1e3 * 1e3 * 1e3 | 0;
 return 0;
}

function ___clock_gettime(a0, a1) {
 return _clock_gettime(a0, a1);
}

function ___emscripten_init_main_thread_js(tb) {
 __emscripten_thread_init(tb, !ENVIRONMENT_IS_WORKER, 1, !ENVIRONMENT_IS_WEB);
 PThread.mainRuntimeThread = true;
 PThread.threadInit();
}

function ___emscripten_thread_cleanup(thread) {
 if (!ENVIRONMENT_IS_PTHREAD) cleanupThread(thread); else postMessage({
  "cmd": "cleanupThread",
  "thread": thread
 });
}

function spawnThread(threadParams) {
 assert(!ENVIRONMENT_IS_PTHREAD, "Internal Error! spawnThread() can only ever be called from main application thread!");
 assert(threadParams.pthread_ptr, "Internal error, no pthread ptr!");
 var worker = PThread.getNewWorker();
 if (!worker) {
  return 6;
 }
 assert(!worker.pthread, "Internal error!");
 PThread.runningWorkers.push(worker);
 var pthread = PThread.pthreads[threadParams.pthread_ptr] = {
  worker: worker,
  threadInfoStruct: threadParams.pthread_ptr
 };
 worker.pthread = pthread;
 var msg = {
  "cmd": "run",
  "start_routine": threadParams.startRoutine,
  "arg": threadParams.arg,
  "threadInfoStruct": threadParams.pthread_ptr
 };
 worker.runPthread = (() => {
  msg.time = performance.now();
  worker.postMessage(msg, threadParams.transferList);
 });
 if (worker.loaded) {
  worker.runPthread();
  delete worker.runPthread;
 }
 return 0;
}

function ___pthread_create_js(pthread_ptr, attr, start_routine, arg) {
 if (typeof SharedArrayBuffer == "undefined") {
  err("Current environment does not support SharedArrayBuffer, pthreads are not available!");
  return 6;
 }
 var transferList = [];
 var error = 0;
 if (ENVIRONMENT_IS_PTHREAD && (transferList.length === 0 || error)) {
  return _emscripten_sync_run_in_main_thread_4(687865856, pthread_ptr, attr, start_routine, arg);
 }
 if (error) return error;
 var threadParams = {
  startRoutine: start_routine,
  pthread_ptr: pthread_ptr,
  arg: arg,
  transferList: transferList
 };
 if (ENVIRONMENT_IS_PTHREAD) {
  threadParams.cmd = "spawnThread";
  postMessage(threadParams, transferList);
  return 0;
 }
 return spawnThread(threadParams);
}

var PATH = {
 splitPath: function(filename) {
  var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
  return splitPathRe.exec(filename).slice(1);
 },
 normalizeArray: function(parts, allowAboveRoot) {
  var up = 0;
  for (var i = parts.length - 1; i >= 0; i--) {
   var last = parts[i];
   if (last === ".") {
    parts.splice(i, 1);
   } else if (last === "..") {
    parts.splice(i, 1);
    up++;
   } else if (up) {
    parts.splice(i, 1);
    up--;
   }
  }
  if (allowAboveRoot) {
   for (;up; up--) {
    parts.unshift("..");
   }
  }
  return parts;
 },
 normalize: function(path) {
  var isAbsolute = path.charAt(0) === "/", trailingSlash = path.substr(-1) === "/";
  path = PATH.normalizeArray(path.split("/").filter(function(p) {
   return !!p;
  }), !isAbsolute).join("/");
  if (!path && !isAbsolute) {
   path = ".";
  }
  if (path && trailingSlash) {
   path += "/";
  }
  return (isAbsolute ? "/" : "") + path;
 },
 dirname: function(path) {
  var result = PATH.splitPath(path), root = result[0], dir = result[1];
  if (!root && !dir) {
   return ".";
  }
  if (dir) {
   dir = dir.substr(0, dir.length - 1);
  }
  return root + dir;
 },
 basename: function(path) {
  if (path === "/") return "/";
  path = PATH.normalize(path);
  path = path.replace(/\/$/, "");
  var lastSlash = path.lastIndexOf("/");
  if (lastSlash === -1) return path;
  return path.substr(lastSlash + 1);
 },
 extname: function(path) {
  return PATH.splitPath(path)[3];
 },
 join: function() {
  var paths = Array.prototype.slice.call(arguments, 0);
  return PATH.normalize(paths.join("/"));
 },
 join2: function(l, r) {
  return PATH.normalize(l + "/" + r);
 }
};

function getRandomDevice() {
 if (typeof crypto == "object" && typeof crypto["getRandomValues"] == "function") {
  var randomBuffer = new Uint8Array(1);
  return function() {
   crypto.getRandomValues(randomBuffer);
   return randomBuffer[0];
  };
 } else if (ENVIRONMENT_IS_NODE) {
  try {
   var crypto_module = require("crypto");
   return function() {
    return crypto_module["randomBytes"](1)[0];
   };
  } catch (e) {}
 }
 return function() {
  abort("no cryptographic support found for randomDevice. consider polyfilling it if you want to use something insecure like Math.random(), e.g. put this in a --pre-js: var crypto = { getRandomValues: function(array) { for (var i = 0; i < array.length; i++) array[i] = (Math.random()*256)|0 } };");
 };
}

var PATH_FS = {
 resolve: function() {
  var resolvedPath = "", resolvedAbsolute = false;
  for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
   var path = i >= 0 ? arguments[i] : FS.cwd();
   if (typeof path != "string") {
    throw new TypeError("Arguments to path.resolve must be strings");
   } else if (!path) {
    return "";
   }
   resolvedPath = path + "/" + resolvedPath;
   resolvedAbsolute = path.charAt(0) === "/";
  }
  resolvedPath = PATH.normalizeArray(resolvedPath.split("/").filter(function(p) {
   return !!p;
  }), !resolvedAbsolute).join("/");
  return (resolvedAbsolute ? "/" : "") + resolvedPath || ".";
 },
 relative: function(from, to) {
  from = PATH_FS.resolve(from).substr(1);
  to = PATH_FS.resolve(to).substr(1);
  function trim(arr) {
   var start = 0;
   for (;start < arr.length; start++) {
    if (arr[start] !== "") break;
   }
   var end = arr.length - 1;
   for (;end >= 0; end--) {
    if (arr[end] !== "") break;
   }
   if (start > end) return [];
   return arr.slice(start, end - start + 1);
  }
  var fromParts = trim(from.split("/"));
  var toParts = trim(to.split("/"));
  var length = Math.min(fromParts.length, toParts.length);
  var samePartsLength = length;
  for (var i = 0; i < length; i++) {
   if (fromParts[i] !== toParts[i]) {
    samePartsLength = i;
    break;
   }
  }
  var outputParts = [];
  for (var i = samePartsLength; i < fromParts.length; i++) {
   outputParts.push("..");
  }
  outputParts = outputParts.concat(toParts.slice(samePartsLength));
  return outputParts.join("/");
 }
};

var TTY = {
 ttys: [],
 init: function() {},
 shutdown: function() {},
 register: function(dev, ops) {
  TTY.ttys[dev] = {
   input: [],
   output: [],
   ops: ops
  };
  FS.registerDevice(dev, TTY.stream_ops);
 },
 stream_ops: {
  open: function(stream) {
   var tty = TTY.ttys[stream.node.rdev];
   if (!tty) {
    throw new FS.ErrnoError(43);
   }
   stream.tty = tty;
   stream.seekable = false;
  },
  close: function(stream) {
   stream.tty.ops.flush(stream.tty);
  },
  flush: function(stream) {
   stream.tty.ops.flush(stream.tty);
  },
  read: function(stream, buffer, offset, length, pos) {
   if (!stream.tty || !stream.tty.ops.get_char) {
    throw new FS.ErrnoError(60);
   }
   var bytesRead = 0;
   for (var i = 0; i < length; i++) {
    var result;
    try {
     result = stream.tty.ops.get_char(stream.tty);
    } catch (e) {
     throw new FS.ErrnoError(29);
    }
    if (result === undefined && bytesRead === 0) {
     throw new FS.ErrnoError(6);
    }
    if (result === null || result === undefined) break;
    bytesRead++;
    buffer[offset + i] = result;
   }
   if (bytesRead) {
    stream.node.timestamp = Date.now();
   }
   return bytesRead;
  },
  write: function(stream, buffer, offset, length, pos) {
   if (!stream.tty || !stream.tty.ops.put_char) {
    throw new FS.ErrnoError(60);
   }
   try {
    for (var i = 0; i < length; i++) {
     stream.tty.ops.put_char(stream.tty, buffer[offset + i]);
    }
   } catch (e) {
    throw new FS.ErrnoError(29);
   }
   if (length) {
    stream.node.timestamp = Date.now();
   }
   return i;
  }
 },
 default_tty_ops: {
  get_char: function(tty) {
   if (!tty.input.length) {
    var result = null;
    if (ENVIRONMENT_IS_NODE) {
     var BUFSIZE = 256;
     var buf = Buffer.alloc(BUFSIZE);
     var bytesRead = 0;
     try {
      bytesRead = fs.readSync(process.stdin.fd, buf, 0, BUFSIZE, -1);
     } catch (e) {
      if (e.toString().includes("EOF")) bytesRead = 0; else throw e;
     }
     if (bytesRead > 0) {
      result = buf.slice(0, bytesRead).toString("utf-8");
     } else {
      result = null;
     }
    } else if (typeof window != "undefined" && typeof window.prompt == "function") {
     result = window.prompt("Input: ");
     if (result !== null) {
      result += "\n";
     }
    } else if (typeof readline == "function") {
     result = readline();
     if (result !== null) {
      result += "\n";
     }
    }
    if (!result) {
     return null;
    }
    tty.input = intArrayFromString(result, true);
   }
   return tty.input.shift();
  },
  put_char: function(tty, val) {
   if (val === null || val === 10) {
    out(UTF8ArrayToString(tty.output, 0));
    tty.output = [];
   } else {
    if (val != 0) tty.output.push(val);
   }
  },
  flush: function(tty) {
   if (tty.output && tty.output.length > 0) {
    out(UTF8ArrayToString(tty.output, 0));
    tty.output = [];
   }
  }
 },
 default_tty1_ops: {
  put_char: function(tty, val) {
   if (val === null || val === 10) {
    err(UTF8ArrayToString(tty.output, 0));
    tty.output = [];
   } else {
    if (val != 0) tty.output.push(val);
   }
  },
  flush: function(tty) {
   if (tty.output && tty.output.length > 0) {
    err(UTF8ArrayToString(tty.output, 0));
    tty.output = [];
   }
  }
 }
};

function alignMemory(size, alignment) {
 assert(alignment, "alignment argument is required");
 return Math.ceil(size / alignment) * alignment;
}

function mmapAlloc(size) {
 size = alignMemory(size, 65536);
 var ptr = _emscripten_builtin_memalign(65536, size);
 if (!ptr) return 0;
 zeroMemory(ptr, size);
 return ptr;
}

var MEMFS = {
 ops_table: null,
 mount: function(mount) {
  return MEMFS.createNode(null, "/", 16384 | 511, 0);
 },
 createNode: function(parent, name, mode, dev) {
  if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
   throw new FS.ErrnoError(63);
  }
  if (!MEMFS.ops_table) {
   MEMFS.ops_table = {
    dir: {
     node: {
      getattr: MEMFS.node_ops.getattr,
      setattr: MEMFS.node_ops.setattr,
      lookup: MEMFS.node_ops.lookup,
      mknod: MEMFS.node_ops.mknod,
      rename: MEMFS.node_ops.rename,
      unlink: MEMFS.node_ops.unlink,
      rmdir: MEMFS.node_ops.rmdir,
      readdir: MEMFS.node_ops.readdir,
      symlink: MEMFS.node_ops.symlink
     },
     stream: {
      llseek: MEMFS.stream_ops.llseek
     }
    },
    file: {
     node: {
      getattr: MEMFS.node_ops.getattr,
      setattr: MEMFS.node_ops.setattr
     },
     stream: {
      llseek: MEMFS.stream_ops.llseek,
      read: MEMFS.stream_ops.read,
      write: MEMFS.stream_ops.write,
      allocate: MEMFS.stream_ops.allocate,
      mmap: MEMFS.stream_ops.mmap,
      msync: MEMFS.stream_ops.msync
     }
    },
    link: {
     node: {
      getattr: MEMFS.node_ops.getattr,
      setattr: MEMFS.node_ops.setattr,
      readlink: MEMFS.node_ops.readlink
     },
     stream: {}
    },
    chrdev: {
     node: {
      getattr: MEMFS.node_ops.getattr,
      setattr: MEMFS.node_ops.setattr
     },
     stream: FS.chrdev_stream_ops
    }
   };
  }
  var node = FS.createNode(parent, name, mode, dev);
  if (FS.isDir(node.mode)) {
   node.node_ops = MEMFS.ops_table.dir.node;
   node.stream_ops = MEMFS.ops_table.dir.stream;
   node.contents = {};
  } else if (FS.isFile(node.mode)) {
   node.node_ops = MEMFS.ops_table.file.node;
   node.stream_ops = MEMFS.ops_table.file.stream;
   node.usedBytes = 0;
   node.contents = null;
  } else if (FS.isLink(node.mode)) {
   node.node_ops = MEMFS.ops_table.link.node;
   node.stream_ops = MEMFS.ops_table.link.stream;
  } else if (FS.isChrdev(node.mode)) {
   node.node_ops = MEMFS.ops_table.chrdev.node;
   node.stream_ops = MEMFS.ops_table.chrdev.stream;
  }
  node.timestamp = Date.now();
  if (parent) {
   parent.contents[name] = node;
   parent.timestamp = node.timestamp;
  }
  return node;
 },
 getFileDataAsTypedArray: function(node) {
  if (!node.contents) return new Uint8Array(0);
  if (node.contents.subarray) return node.contents.subarray(0, node.usedBytes);
  return new Uint8Array(node.contents);
 },
 expandFileStorage: function(node, newCapacity) {
  var prevCapacity = node.contents ? node.contents.length : 0;
  if (prevCapacity >= newCapacity) return;
  var CAPACITY_DOUBLING_MAX = 1024 * 1024;
  newCapacity = Math.max(newCapacity, prevCapacity * (prevCapacity < CAPACITY_DOUBLING_MAX ? 2 : 1.125) >>> 0);
  if (prevCapacity != 0) newCapacity = Math.max(newCapacity, 256);
  var oldContents = node.contents;
  node.contents = new Uint8Array(newCapacity);
  if (node.usedBytes > 0) node.contents.set(oldContents.subarray(0, node.usedBytes), 0);
 },
 resizeFileStorage: function(node, newSize) {
  if (node.usedBytes == newSize) return;
  if (newSize == 0) {
   node.contents = null;
   node.usedBytes = 0;
  } else {
   var oldContents = node.contents;
   node.contents = new Uint8Array(newSize);
   if (oldContents) {
    node.contents.set(oldContents.subarray(0, Math.min(newSize, node.usedBytes)));
   }
   node.usedBytes = newSize;
  }
 },
 node_ops: {
  getattr: function(node) {
   var attr = {};
   attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
   attr.ino = node.id;
   attr.mode = node.mode;
   attr.nlink = 1;
   attr.uid = 0;
   attr.gid = 0;
   attr.rdev = node.rdev;
   if (FS.isDir(node.mode)) {
    attr.size = 4096;
   } else if (FS.isFile(node.mode)) {
    attr.size = node.usedBytes;
   } else if (FS.isLink(node.mode)) {
    attr.size = node.link.length;
   } else {
    attr.size = 0;
   }
   attr.atime = new Date(node.timestamp);
   attr.mtime = new Date(node.timestamp);
   attr.ctime = new Date(node.timestamp);
   attr.blksize = 4096;
   attr.blocks = Math.ceil(attr.size / attr.blksize);
   return attr;
  },
  setattr: function(node, attr) {
   if (attr.mode !== undefined) {
    node.mode = attr.mode;
   }
   if (attr.timestamp !== undefined) {
    node.timestamp = attr.timestamp;
   }
   if (attr.size !== undefined) {
    MEMFS.resizeFileStorage(node, attr.size);
   }
  },
  lookup: function(parent, name) {
   throw FS.genericErrors[44];
  },
  mknod: function(parent, name, mode, dev) {
   return MEMFS.createNode(parent, name, mode, dev);
  },
  rename: function(old_node, new_dir, new_name) {
   if (FS.isDir(old_node.mode)) {
    var new_node;
    try {
     new_node = FS.lookupNode(new_dir, new_name);
    } catch (e) {}
    if (new_node) {
     for (var i in new_node.contents) {
      throw new FS.ErrnoError(55);
     }
    }
   }
   delete old_node.parent.contents[old_node.name];
   old_node.parent.timestamp = Date.now();
   old_node.name = new_name;
   new_dir.contents[new_name] = old_node;
   new_dir.timestamp = old_node.parent.timestamp;
   old_node.parent = new_dir;
  },
  unlink: function(parent, name) {
   delete parent.contents[name];
   parent.timestamp = Date.now();
  },
  rmdir: function(parent, name) {
   var node = FS.lookupNode(parent, name);
   for (var i in node.contents) {
    throw new FS.ErrnoError(55);
   }
   delete parent.contents[name];
   parent.timestamp = Date.now();
  },
  readdir: function(node) {
   var entries = [ ".", ".." ];
   for (var key in node.contents) {
    if (!node.contents.hasOwnProperty(key)) {
     continue;
    }
    entries.push(key);
   }
   return entries;
  },
  symlink: function(parent, newname, oldpath) {
   var node = MEMFS.createNode(parent, newname, 511 | 40960, 0);
   node.link = oldpath;
   return node;
  },
  readlink: function(node) {
   if (!FS.isLink(node.mode)) {
    throw new FS.ErrnoError(28);
   }
   return node.link;
  }
 },
 stream_ops: {
  read: function(stream, buffer, offset, length, position) {
   var contents = stream.node.contents;
   if (position >= stream.node.usedBytes) return 0;
   var size = Math.min(stream.node.usedBytes - position, length);
   assert(size >= 0);
   if (size > 8 && contents.subarray) {
    buffer.set(contents.subarray(position, position + size), offset);
   } else {
    for (var i = 0; i < size; i++) buffer[offset + i] = contents[position + i];
   }
   return size;
  },
  write: function(stream, buffer, offset, length, position, canOwn) {
   assert(!(buffer instanceof ArrayBuffer));
   if (buffer.buffer === GROWABLE_HEAP_I8().buffer) {
    canOwn = false;
   }
   if (!length) return 0;
   var node = stream.node;
   node.timestamp = Date.now();
   if (buffer.subarray && (!node.contents || node.contents.subarray)) {
    if (canOwn) {
     assert(position === 0, "canOwn must imply no weird position inside the file");
     node.contents = buffer.subarray(offset, offset + length);
     node.usedBytes = length;
     return length;
    } else if (node.usedBytes === 0 && position === 0) {
     node.contents = buffer.slice(offset, offset + length);
     node.usedBytes = length;
     return length;
    } else if (position + length <= node.usedBytes) {
     node.contents.set(buffer.subarray(offset, offset + length), position);
     return length;
    }
   }
   MEMFS.expandFileStorage(node, position + length);
   if (node.contents.subarray && buffer.subarray) {
    node.contents.set(buffer.subarray(offset, offset + length), position);
   } else {
    for (var i = 0; i < length; i++) {
     node.contents[position + i] = buffer[offset + i];
    }
   }
   node.usedBytes = Math.max(node.usedBytes, position + length);
   return length;
  },
  llseek: function(stream, offset, whence) {
   var position = offset;
   if (whence === 1) {
    position += stream.position;
   } else if (whence === 2) {
    if (FS.isFile(stream.node.mode)) {
     position += stream.node.usedBytes;
    }
   }
   if (position < 0) {
    throw new FS.ErrnoError(28);
   }
   return position;
  },
  allocate: function(stream, offset, length) {
   MEMFS.expandFileStorage(stream.node, offset + length);
   stream.node.usedBytes = Math.max(stream.node.usedBytes, offset + length);
  },
  mmap: function(stream, address, length, position, prot, flags) {
   if (address !== 0) {
    throw new FS.ErrnoError(28);
   }
   if (!FS.isFile(stream.node.mode)) {
    throw new FS.ErrnoError(43);
   }
   var ptr;
   var allocated;
   var contents = stream.node.contents;
   if (!(flags & 2) && contents.buffer === buffer) {
    allocated = false;
    ptr = contents.byteOffset;
   } else {
    if (position > 0 || position + length < contents.length) {
     if (contents.subarray) {
      contents = contents.subarray(position, position + length);
     } else {
      contents = Array.prototype.slice.call(contents, position, position + length);
     }
    }
    allocated = true;
    ptr = mmapAlloc(length);
    if (!ptr) {
     throw new FS.ErrnoError(48);
    }
    GROWABLE_HEAP_I8().set(contents, ptr);
   }
   return {
    ptr: ptr,
    allocated: allocated
   };
  },
  msync: function(stream, buffer, offset, length, mmapFlags) {
   if (!FS.isFile(stream.node.mode)) {
    throw new FS.ErrnoError(43);
   }
   if (mmapFlags & 2) {
    return 0;
   }
   var bytesWritten = MEMFS.stream_ops.write(stream, buffer, 0, length, offset, false);
   return 0;
  }
 }
};

function asyncLoad(url, onload, onerror, noRunDep) {
 var dep = !noRunDep ? getUniqueRunDependency("al " + url) : "";
 readAsync(url, function(arrayBuffer) {
  assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
  onload(new Uint8Array(arrayBuffer));
  if (dep) removeRunDependency(dep);
 }, function(event) {
  if (onerror) {
   onerror();
  } else {
   throw 'Loading data file "' + url + '" failed.';
  }
 });
 if (dep) addRunDependency(dep);
}

var ERRNO_MESSAGES = {
 0: "Success",
 1: "Arg list too long",
 2: "Permission denied",
 3: "Address already in use",
 4: "Address not available",
 5: "Address family not supported by protocol family",
 6: "No more processes",
 7: "Socket already connected",
 8: "Bad file number",
 9: "Trying to read unreadable message",
 10: "Mount device busy",
 11: "Operation canceled",
 12: "No children",
 13: "Connection aborted",
 14: "Connection refused",
 15: "Connection reset by peer",
 16: "File locking deadlock error",
 17: "Destination address required",
 18: "Math arg out of domain of func",
 19: "Quota exceeded",
 20: "File exists",
 21: "Bad address",
 22: "File too large",
 23: "Host is unreachable",
 24: "Identifier removed",
 25: "Illegal byte sequence",
 26: "Connection already in progress",
 27: "Interrupted system call",
 28: "Invalid argument",
 29: "I/O error",
 30: "Socket is already connected",
 31: "Is a directory",
 32: "Too many symbolic links",
 33: "Too many open files",
 34: "Too many links",
 35: "Message too long",
 36: "Multihop attempted",
 37: "File or path name too long",
 38: "Network interface is not configured",
 39: "Connection reset by network",
 40: "Network is unreachable",
 41: "Too many open files in system",
 42: "No buffer space available",
 43: "No such device",
 44: "No such file or directory",
 45: "Exec format error",
 46: "No record locks available",
 47: "The link has been severed",
 48: "Not enough core",
 49: "No message of desired type",
 50: "Protocol not available",
 51: "No space left on device",
 52: "Function not implemented",
 53: "Socket is not connected",
 54: "Not a directory",
 55: "Directory not empty",
 56: "State not recoverable",
 57: "Socket operation on non-socket",
 59: "Not a typewriter",
 60: "No such device or address",
 61: "Value too large for defined data type",
 62: "Previous owner died",
 63: "Not super-user",
 64: "Broken pipe",
 65: "Protocol error",
 66: "Unknown protocol",
 67: "Protocol wrong type for socket",
 68: "Math result not representable",
 69: "Read only file system",
 70: "Illegal seek",
 71: "No such process",
 72: "Stale file handle",
 73: "Connection timed out",
 74: "Text file busy",
 75: "Cross-device link",
 100: "Device not a stream",
 101: "Bad font file fmt",
 102: "Invalid slot",
 103: "Invalid request code",
 104: "No anode",
 105: "Block device required",
 106: "Channel number out of range",
 107: "Level 3 halted",
 108: "Level 3 reset",
 109: "Link number out of range",
 110: "Protocol driver not attached",
 111: "No CSI structure available",
 112: "Level 2 halted",
 113: "Invalid exchange",
 114: "Invalid request descriptor",
 115: "Exchange full",
 116: "No data (for no delay io)",
 117: "Timer expired",
 118: "Out of streams resources",
 119: "Machine is not on the network",
 120: "Package not installed",
 121: "The object is remote",
 122: "Advertise error",
 123: "Srmount error",
 124: "Communication error on send",
 125: "Cross mount point (not really error)",
 126: "Given log. name not unique",
 127: "f.d. invalid for this operation",
 128: "Remote address changed",
 129: "Can   access a needed shared lib",
 130: "Accessing a corrupted shared lib",
 131: ".lib section in a.out corrupted",
 132: "Attempting to link in too many libs",
 133: "Attempting to exec a shared library",
 135: "Streams pipe error",
 136: "Too many users",
 137: "Socket type not supported",
 138: "Not supported",
 139: "Protocol family not supported",
 140: "Can't send after socket shutdown",
 141: "Too many references",
 142: "Host is down",
 148: "No medium (in tape drive)",
 156: "Level 2 not synchronized"
};

var ERRNO_CODES = {};

var FS = {
 root: null,
 mounts: [],
 devices: {},
 streams: [],
 nextInode: 1,
 nameTable: null,
 currentPath: "/",
 initialized: false,
 ignorePermissions: true,
 ErrnoError: null,
 genericErrors: {},
 filesystems: null,
 syncFSRequests: 0,
 lookupPath: (path, opts = {}) => {
  path = PATH_FS.resolve(FS.cwd(), path);
  if (!path) return {
   path: "",
   node: null
  };
  var defaults = {
   follow_mount: true,
   recurse_count: 0
  };
  opts = Object.assign(defaults, opts);
  if (opts.recurse_count > 8) {
   throw new FS.ErrnoError(32);
  }
  var parts = PATH.normalizeArray(path.split("/").filter(p => !!p), false);
  var current = FS.root;
  var current_path = "/";
  for (var i = 0; i < parts.length; i++) {
   var islast = i === parts.length - 1;
   if (islast && opts.parent) {
    break;
   }
   current = FS.lookupNode(current, parts[i]);
   current_path = PATH.join2(current_path, parts[i]);
   if (FS.isMountpoint(current)) {
    if (!islast || islast && opts.follow_mount) {
     current = current.mounted.root;
    }
   }
   if (!islast || opts.follow) {
    var count = 0;
    while (FS.isLink(current.mode)) {
     var link = FS.readlink(current_path);
     current_path = PATH_FS.resolve(PATH.dirname(current_path), link);
     var lookup = FS.lookupPath(current_path, {
      recurse_count: opts.recurse_count + 1
     });
     current = lookup.node;
     if (count++ > 40) {
      throw new FS.ErrnoError(32);
     }
    }
   }
  }
  return {
   path: current_path,
   node: current
  };
 },
 getPath: node => {
  var path;
  while (true) {
   if (FS.isRoot(node)) {
    var mount = node.mount.mountpoint;
    if (!path) return mount;
    return mount[mount.length - 1] !== "/" ? mount + "/" + path : mount + path;
   }
   path = path ? node.name + "/" + path : node.name;
   node = node.parent;
  }
 },
 hashName: (parentid, name) => {
  var hash = 0;
  for (var i = 0; i < name.length; i++) {
   hash = (hash << 5) - hash + name.charCodeAt(i) | 0;
  }
  return (parentid + hash >>> 0) % FS.nameTable.length;
 },
 hashAddNode: node => {
  var hash = FS.hashName(node.parent.id, node.name);
  node.name_next = FS.nameTable[hash];
  FS.nameTable[hash] = node;
 },
 hashRemoveNode: node => {
  var hash = FS.hashName(node.parent.id, node.name);
  if (FS.nameTable[hash] === node) {
   FS.nameTable[hash] = node.name_next;
  } else {
   var current = FS.nameTable[hash];
   while (current) {
    if (current.name_next === node) {
     current.name_next = node.name_next;
     break;
    }
    current = current.name_next;
   }
  }
 },
 lookupNode: (parent, name) => {
  var errCode = FS.mayLookup(parent);
  if (errCode) {
   throw new FS.ErrnoError(errCode, parent);
  }
  var hash = FS.hashName(parent.id, name);
  for (var node = FS.nameTable[hash]; node; node = node.name_next) {
   var nodeName = node.name;
   if (node.parent.id === parent.id && nodeName === name) {
    return node;
   }
  }
  return FS.lookup(parent, name);
 },
 createNode: (parent, name, mode, rdev) => {
  assert(typeof parent == "object");
  var node = new FS.FSNode(parent, name, mode, rdev);
  FS.hashAddNode(node);
  return node;
 },
 destroyNode: node => {
  FS.hashRemoveNode(node);
 },
 isRoot: node => {
  return node === node.parent;
 },
 isMountpoint: node => {
  return !!node.mounted;
 },
 isFile: mode => {
  return (mode & 61440) === 32768;
 },
 isDir: mode => {
  return (mode & 61440) === 16384;
 },
 isLink: mode => {
  return (mode & 61440) === 40960;
 },
 isChrdev: mode => {
  return (mode & 61440) === 8192;
 },
 isBlkdev: mode => {
  return (mode & 61440) === 24576;
 },
 isFIFO: mode => {
  return (mode & 61440) === 4096;
 },
 isSocket: mode => {
  return (mode & 49152) === 49152;
 },
 flagModes: {
  "r": 0,
  "r+": 2,
  "w": 577,
  "w+": 578,
  "a": 1089,
  "a+": 1090
 },
 modeStringToFlags: str => {
  var flags = FS.flagModes[str];
  if (typeof flags == "undefined") {
   throw new Error("Unknown file open mode: " + str);
  }
  return flags;
 },
 flagsToPermissionString: flag => {
  var perms = [ "r", "w", "rw" ][flag & 3];
  if (flag & 512) {
   perms += "w";
  }
  return perms;
 },
 nodePermissions: (node, perms) => {
  if (FS.ignorePermissions) {
   return 0;
  }
  if (perms.includes("r") && !(node.mode & 292)) {
   return 2;
  } else if (perms.includes("w") && !(node.mode & 146)) {
   return 2;
  } else if (perms.includes("x") && !(node.mode & 73)) {
   return 2;
  }
  return 0;
 },
 mayLookup: dir => {
  var errCode = FS.nodePermissions(dir, "x");
  if (errCode) return errCode;
  if (!dir.node_ops.lookup) return 2;
  return 0;
 },
 mayCreate: (dir, name) => {
  try {
   var node = FS.lookupNode(dir, name);
   return 20;
  } catch (e) {}
  return FS.nodePermissions(dir, "wx");
 },
 mayDelete: (dir, name, isdir) => {
  var node;
  try {
   node = FS.lookupNode(dir, name);
  } catch (e) {
   return e.errno;
  }
  var errCode = FS.nodePermissions(dir, "wx");
  if (errCode) {
   return errCode;
  }
  if (isdir) {
   if (!FS.isDir(node.mode)) {
    return 54;
   }
   if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
    return 10;
   }
  } else {
   if (FS.isDir(node.mode)) {
    return 31;
   }
  }
  return 0;
 },
 mayOpen: (node, flags) => {
  if (!node) {
   return 44;
  }
  if (FS.isLink(node.mode)) {
   return 32;
  } else if (FS.isDir(node.mode)) {
   if (FS.flagsToPermissionString(flags) !== "r" || flags & 512) {
    return 31;
   }
  }
  return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
 },
 MAX_OPEN_FDS: 4096,
 nextfd: (fd_start = 0, fd_end = FS.MAX_OPEN_FDS) => {
  for (var fd = fd_start; fd <= fd_end; fd++) {
   if (!FS.streams[fd]) {
    return fd;
   }
  }
  throw new FS.ErrnoError(33);
 },
 getStream: fd => FS.streams[fd],
 createStream: (stream, fd_start, fd_end) => {
  if (!FS.FSStream) {
   FS.FSStream = function() {};
   FS.FSStream.prototype = {
    object: {
     get: function() {
      return this.node;
     },
     set: function(val) {
      this.node = val;
     }
    },
    isRead: {
     get: function() {
      return (this.flags & 2097155) !== 1;
     }
    },
    isWrite: {
     get: function() {
      return (this.flags & 2097155) !== 0;
     }
    },
    isAppend: {
     get: function() {
      return this.flags & 1024;
     }
    }
   };
  }
  stream = Object.assign(new FS.FSStream(), stream);
  var fd = FS.nextfd(fd_start, fd_end);
  stream.fd = fd;
  FS.streams[fd] = stream;
  return stream;
 },
 closeStream: fd => {
  FS.streams[fd] = null;
 },
 chrdev_stream_ops: {
  open: stream => {
   var device = FS.getDevice(stream.node.rdev);
   stream.stream_ops = device.stream_ops;
   if (stream.stream_ops.open) {
    stream.stream_ops.open(stream);
   }
  },
  llseek: () => {
   throw new FS.ErrnoError(70);
  }
 },
 major: dev => dev >> 8,
 minor: dev => dev & 255,
 makedev: (ma, mi) => ma << 8 | mi,
 registerDevice: (dev, ops) => {
  FS.devices[dev] = {
   stream_ops: ops
  };
 },
 getDevice: dev => FS.devices[dev],
 getMounts: mount => {
  var mounts = [];
  var check = [ mount ];
  while (check.length) {
   var m = check.pop();
   mounts.push(m);
   check.push.apply(check, m.mounts);
  }
  return mounts;
 },
 syncfs: (populate, callback) => {
  if (typeof populate == "function") {
   callback = populate;
   populate = false;
  }
  FS.syncFSRequests++;
  if (FS.syncFSRequests > 1) {
   err("warning: " + FS.syncFSRequests + " FS.syncfs operations in flight at once, probably just doing extra work");
  }
  var mounts = FS.getMounts(FS.root.mount);
  var completed = 0;
  function doCallback(errCode) {
   assert(FS.syncFSRequests > 0);
   FS.syncFSRequests--;
   return callback(errCode);
  }
  function done(errCode) {
   if (errCode) {
    if (!done.errored) {
     done.errored = true;
     return doCallback(errCode);
    }
    return;
   }
   if (++completed >= mounts.length) {
    doCallback(null);
   }
  }
  mounts.forEach(mount => {
   if (!mount.type.syncfs) {
    return done(null);
   }
   mount.type.syncfs(mount, populate, done);
  });
 },
 mount: (type, opts, mountpoint) => {
  if (typeof type == "string") {
   throw type;
  }
  var root = mountpoint === "/";
  var pseudo = !mountpoint;
  var node;
  if (root && FS.root) {
   throw new FS.ErrnoError(10);
  } else if (!root && !pseudo) {
   var lookup = FS.lookupPath(mountpoint, {
    follow_mount: false
   });
   mountpoint = lookup.path;
   node = lookup.node;
   if (FS.isMountpoint(node)) {
    throw new FS.ErrnoError(10);
   }
   if (!FS.isDir(node.mode)) {
    throw new FS.ErrnoError(54);
   }
  }
  var mount = {
   type: type,
   opts: opts,
   mountpoint: mountpoint,
   mounts: []
  };
  var mountRoot = type.mount(mount);
  mountRoot.mount = mount;
  mount.root = mountRoot;
  if (root) {
   FS.root = mountRoot;
  } else if (node) {
   node.mounted = mount;
   if (node.mount) {
    node.mount.mounts.push(mount);
   }
  }
  return mountRoot;
 },
 unmount: mountpoint => {
  var lookup = FS.lookupPath(mountpoint, {
   follow_mount: false
  });
  if (!FS.isMountpoint(lookup.node)) {
   throw new FS.ErrnoError(28);
  }
  var node = lookup.node;
  var mount = node.mounted;
  var mounts = FS.getMounts(mount);
  Object.keys(FS.nameTable).forEach(hash => {
   var current = FS.nameTable[hash];
   while (current) {
    var next = current.name_next;
    if (mounts.includes(current.mount)) {
     FS.destroyNode(current);
    }
    current = next;
   }
  });
  node.mounted = null;
  var idx = node.mount.mounts.indexOf(mount);
  assert(idx !== -1);
  node.mount.mounts.splice(idx, 1);
 },
 lookup: (parent, name) => {
  return parent.node_ops.lookup(parent, name);
 },
 mknod: (path, mode, dev) => {
  var lookup = FS.lookupPath(path, {
   parent: true
  });
  var parent = lookup.node;
  var name = PATH.basename(path);
  if (!name || name === "." || name === "..") {
   throw new FS.ErrnoError(28);
  }
  var errCode = FS.mayCreate(parent, name);
  if (errCode) {
   throw new FS.ErrnoError(errCode);
  }
  if (!parent.node_ops.mknod) {
   throw new FS.ErrnoError(63);
  }
  return parent.node_ops.mknod(parent, name, mode, dev);
 },
 create: (path, mode) => {
  mode = mode !== undefined ? mode : 438;
  mode &= 4095;
  mode |= 32768;
  return FS.mknod(path, mode, 0);
 },
 mkdir: (path, mode) => {
  mode = mode !== undefined ? mode : 511;
  mode &= 511 | 512;
  mode |= 16384;
  return FS.mknod(path, mode, 0);
 },
 mkdirTree: (path, mode) => {
  var dirs = path.split("/");
  var d = "";
  for (var i = 0; i < dirs.length; ++i) {
   if (!dirs[i]) continue;
   d += "/" + dirs[i];
   try {
    FS.mkdir(d, mode);
   } catch (e) {
    if (e.errno != 20) throw e;
   }
  }
 },
 mkdev: (path, mode, dev) => {
  if (typeof dev == "undefined") {
   dev = mode;
   mode = 438;
  }
  mode |= 8192;
  return FS.mknod(path, mode, dev);
 },
 symlink: (oldpath, newpath) => {
  if (!PATH_FS.resolve(oldpath)) {
   throw new FS.ErrnoError(44);
  }
  var lookup = FS.lookupPath(newpath, {
   parent: true
  });
  var parent = lookup.node;
  if (!parent) {
   throw new FS.ErrnoError(44);
  }
  var newname = PATH.basename(newpath);
  var errCode = FS.mayCreate(parent, newname);
  if (errCode) {
   throw new FS.ErrnoError(errCode);
  }
  if (!parent.node_ops.symlink) {
   throw new FS.ErrnoError(63);
  }
  return parent.node_ops.symlink(parent, newname, oldpath);
 },
 rename: (old_path, new_path) => {
  var old_dirname = PATH.dirname(old_path);
  var new_dirname = PATH.dirname(new_path);
  var old_name = PATH.basename(old_path);
  var new_name = PATH.basename(new_path);
  var lookup, old_dir, new_dir;
  lookup = FS.lookupPath(old_path, {
   parent: true
  });
  old_dir = lookup.node;
  lookup = FS.lookupPath(new_path, {
   parent: true
  });
  new_dir = lookup.node;
  if (!old_dir || !new_dir) throw new FS.ErrnoError(44);
  if (old_dir.mount !== new_dir.mount) {
   throw new FS.ErrnoError(75);
  }
  var old_node = FS.lookupNode(old_dir, old_name);
  var relative = PATH_FS.relative(old_path, new_dirname);
  if (relative.charAt(0) !== ".") {
   throw new FS.ErrnoError(28);
  }
  relative = PATH_FS.relative(new_path, old_dirname);
  if (relative.charAt(0) !== ".") {
   throw new FS.ErrnoError(55);
  }
  var new_node;
  try {
   new_node = FS.lookupNode(new_dir, new_name);
  } catch (e) {}
  if (old_node === new_node) {
   return;
  }
  var isdir = FS.isDir(old_node.mode);
  var errCode = FS.mayDelete(old_dir, old_name, isdir);
  if (errCode) {
   throw new FS.ErrnoError(errCode);
  }
  errCode = new_node ? FS.mayDelete(new_dir, new_name, isdir) : FS.mayCreate(new_dir, new_name);
  if (errCode) {
   throw new FS.ErrnoError(errCode);
  }
  if (!old_dir.node_ops.rename) {
   throw new FS.ErrnoError(63);
  }
  if (FS.isMountpoint(old_node) || new_node && FS.isMountpoint(new_node)) {
   throw new FS.ErrnoError(10);
  }
  if (new_dir !== old_dir) {
   errCode = FS.nodePermissions(old_dir, "w");
   if (errCode) {
    throw new FS.ErrnoError(errCode);
   }
  }
  FS.hashRemoveNode(old_node);
  try {
   old_dir.node_ops.rename(old_node, new_dir, new_name);
  } catch (e) {
   throw e;
  } finally {
   FS.hashAddNode(old_node);
  }
 },
 rmdir: path => {
  var lookup = FS.lookupPath(path, {
   parent: true
  });
  var parent = lookup.node;
  var name = PATH.basename(path);
  var node = FS.lookupNode(parent, name);
  var errCode = FS.mayDelete(parent, name, true);
  if (errCode) {
   throw new FS.ErrnoError(errCode);
  }
  if (!parent.node_ops.rmdir) {
   throw new FS.ErrnoError(63);
  }
  if (FS.isMountpoint(node)) {
   throw new FS.ErrnoError(10);
  }
  parent.node_ops.rmdir(parent, name);
  FS.destroyNode(node);
 },
 readdir: path => {
  var lookup = FS.lookupPath(path, {
   follow: true
  });
  var node = lookup.node;
  if (!node.node_ops.readdir) {
   throw new FS.ErrnoError(54);
  }
  return node.node_ops.readdir(node);
 },
 unlink: path => {
  var lookup = FS.lookupPath(path, {
   parent: true
  });
  var parent = lookup.node;
  if (!parent) {
   throw new FS.ErrnoError(44);
  }
  var name = PATH.basename(path);
  var node = FS.lookupNode(parent, name);
  var errCode = FS.mayDelete(parent, name, false);
  if (errCode) {
   throw new FS.ErrnoError(errCode);
  }
  if (!parent.node_ops.unlink) {
   throw new FS.ErrnoError(63);
  }
  if (FS.isMountpoint(node)) {
   throw new FS.ErrnoError(10);
  }
  parent.node_ops.unlink(parent, name);
  FS.destroyNode(node);
 },
 readlink: path => {
  var lookup = FS.lookupPath(path);
  var link = lookup.node;
  if (!link) {
   throw new FS.ErrnoError(44);
  }
  if (!link.node_ops.readlink) {
   throw new FS.ErrnoError(28);
  }
  return PATH_FS.resolve(FS.getPath(link.parent), link.node_ops.readlink(link));
 },
 stat: (path, dontFollow) => {
  var lookup = FS.lookupPath(path, {
   follow: !dontFollow
  });
  var node = lookup.node;
  if (!node) {
   throw new FS.ErrnoError(44);
  }
  if (!node.node_ops.getattr) {
   throw new FS.ErrnoError(63);
  }
  return node.node_ops.getattr(node);
 },
 lstat: path => {
  return FS.stat(path, true);
 },
 chmod: (path, mode, dontFollow) => {
  var node;
  if (typeof path == "string") {
   var lookup = FS.lookupPath(path, {
    follow: !dontFollow
   });
   node = lookup.node;
  } else {
   node = path;
  }
  if (!node.node_ops.setattr) {
   throw new FS.ErrnoError(63);
  }
  node.node_ops.setattr(node, {
   mode: mode & 4095 | node.mode & ~4095,
   timestamp: Date.now()
  });
 },
 lchmod: (path, mode) => {
  FS.chmod(path, mode, true);
 },
 fchmod: (fd, mode) => {
  var stream = FS.getStream(fd);
  if (!stream) {
   throw new FS.ErrnoError(8);
  }
  FS.chmod(stream.node, mode);
 },
 chown: (path, uid, gid, dontFollow) => {
  var node;
  if (typeof path == "string") {
   var lookup = FS.lookupPath(path, {
    follow: !dontFollow
   });
   node = lookup.node;
  } else {
   node = path;
  }
  if (!node.node_ops.setattr) {
   throw new FS.ErrnoError(63);
  }
  node.node_ops.setattr(node, {
   timestamp: Date.now()
  });
 },
 lchown: (path, uid, gid) => {
  FS.chown(path, uid, gid, true);
 },
 fchown: (fd, uid, gid) => {
  var stream = FS.getStream(fd);
  if (!stream) {
   throw new FS.ErrnoError(8);
  }
  FS.chown(stream.node, uid, gid);
 },
 truncate: (path, len) => {
  if (len < 0) {
   throw new FS.ErrnoError(28);
  }
  var node;
  if (typeof path == "string") {
   var lookup = FS.lookupPath(path, {
    follow: true
   });
   node = lookup.node;
  } else {
   node = path;
  }
  if (!node.node_ops.setattr) {
   throw new FS.ErrnoError(63);
  }
  if (FS.isDir(node.mode)) {
   throw new FS.ErrnoError(31);
  }
  if (!FS.isFile(node.mode)) {
   throw new FS.ErrnoError(28);
  }
  var errCode = FS.nodePermissions(node, "w");
  if (errCode) {
   throw new FS.ErrnoError(errCode);
  }
  node.node_ops.setattr(node, {
   size: len,
   timestamp: Date.now()
  });
 },
 ftruncate: (fd, len) => {
  var stream = FS.getStream(fd);
  if (!stream) {
   throw new FS.ErrnoError(8);
  }
  if ((stream.flags & 2097155) === 0) {
   throw new FS.ErrnoError(28);
  }
  FS.truncate(stream.node, len);
 },
 utime: (path, atime, mtime) => {
  var lookup = FS.lookupPath(path, {
   follow: true
  });
  var node = lookup.node;
  node.node_ops.setattr(node, {
   timestamp: Math.max(atime, mtime)
  });
 },
 open: (path, flags, mode, fd_start, fd_end) => {
  if (path === "") {
   throw new FS.ErrnoError(44);
  }
  flags = typeof flags == "string" ? FS.modeStringToFlags(flags) : flags;
  mode = typeof mode == "undefined" ? 438 : mode;
  if (flags & 64) {
   mode = mode & 4095 | 32768;
  } else {
   mode = 0;
  }
  var node;
  if (typeof path == "object") {
   node = path;
  } else {
   path = PATH.normalize(path);
   try {
    var lookup = FS.lookupPath(path, {
     follow: !(flags & 131072)
    });
    node = lookup.node;
   } catch (e) {}
  }
  var created = false;
  if (flags & 64) {
   if (node) {
    if (flags & 128) {
     throw new FS.ErrnoError(20);
    }
   } else {
    node = FS.mknod(path, mode, 0);
    created = true;
   }
  }
  if (!node) {
   throw new FS.ErrnoError(44);
  }
  if (FS.isChrdev(node.mode)) {
   flags &= ~512;
  }
  if (flags & 65536 && !FS.isDir(node.mode)) {
   throw new FS.ErrnoError(54);
  }
  if (!created) {
   var errCode = FS.mayOpen(node, flags);
   if (errCode) {
    throw new FS.ErrnoError(errCode);
   }
  }
  if (flags & 512) {
   FS.truncate(node, 0);
  }
  flags &= ~(128 | 512 | 131072);
  var stream = FS.createStream({
   node: node,
   path: FS.getPath(node),
   flags: flags,
   seekable: true,
   position: 0,
   stream_ops: node.stream_ops,
   ungotten: [],
   error: false
  }, fd_start, fd_end);
  if (stream.stream_ops.open) {
   stream.stream_ops.open(stream);
  }
  if (Module["logReadFiles"] && !(flags & 1)) {
   if (!FS.readFiles) FS.readFiles = {};
   if (!(path in FS.readFiles)) {
    FS.readFiles[path] = 1;
   }
  }
  return stream;
 },
 close: stream => {
  if (FS.isClosed(stream)) {
   throw new FS.ErrnoError(8);
  }
  if (stream.getdents) stream.getdents = null;
  try {
   if (stream.stream_ops.close) {
    stream.stream_ops.close(stream);
   }
  } catch (e) {
   throw e;
  } finally {
   FS.closeStream(stream.fd);
  }
  stream.fd = null;
 },
 isClosed: stream => {
  return stream.fd === null;
 },
 llseek: (stream, offset, whence) => {
  if (FS.isClosed(stream)) {
   throw new FS.ErrnoError(8);
  }
  if (!stream.seekable || !stream.stream_ops.llseek) {
   throw new FS.ErrnoError(70);
  }
  if (whence != 0 && whence != 1 && whence != 2) {
   throw new FS.ErrnoError(28);
  }
  stream.position = stream.stream_ops.llseek(stream, offset, whence);
  stream.ungotten = [];
  return stream.position;
 },
 read: (stream, buffer, offset, length, position) => {
  if (length < 0 || position < 0) {
   throw new FS.ErrnoError(28);
  }
  if (FS.isClosed(stream)) {
   throw new FS.ErrnoError(8);
  }
  if ((stream.flags & 2097155) === 1) {
   throw new FS.ErrnoError(8);
  }
  if (FS.isDir(stream.node.mode)) {
   throw new FS.ErrnoError(31);
  }
  if (!stream.stream_ops.read) {
   throw new FS.ErrnoError(28);
  }
  var seeking = typeof position != "undefined";
  if (!seeking) {
   position = stream.position;
  } else if (!stream.seekable) {
   throw new FS.ErrnoError(70);
  }
  var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
  if (!seeking) stream.position += bytesRead;
  return bytesRead;
 },
 write: (stream, buffer, offset, length, position, canOwn) => {
  if (length < 0 || position < 0) {
   throw new FS.ErrnoError(28);
  }
  if (FS.isClosed(stream)) {
   throw new FS.ErrnoError(8);
  }
  if ((stream.flags & 2097155) === 0) {
   throw new FS.ErrnoError(8);
  }
  if (FS.isDir(stream.node.mode)) {
   throw new FS.ErrnoError(31);
  }
  if (!stream.stream_ops.write) {
   throw new FS.ErrnoError(28);
  }
  if (stream.seekable && stream.flags & 1024) {
   FS.llseek(stream, 0, 2);
  }
  var seeking = typeof position != "undefined";
  if (!seeking) {
   position = stream.position;
  } else if (!stream.seekable) {
   throw new FS.ErrnoError(70);
  }
  var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
  if (!seeking) stream.position += bytesWritten;
  return bytesWritten;
 },
 allocate: (stream, offset, length) => {
  if (FS.isClosed(stream)) {
   throw new FS.ErrnoError(8);
  }
  if (offset < 0 || length <= 0) {
   throw new FS.ErrnoError(28);
  }
  if ((stream.flags & 2097155) === 0) {
   throw new FS.ErrnoError(8);
  }
  if (!FS.isFile(stream.node.mode) && !FS.isDir(stream.node.mode)) {
   throw new FS.ErrnoError(43);
  }
  if (!stream.stream_ops.allocate) {
   throw new FS.ErrnoError(138);
  }
  stream.stream_ops.allocate(stream, offset, length);
 },
 mmap: (stream, address, length, position, prot, flags) => {
  if ((prot & 2) !== 0 && (flags & 2) === 0 && (stream.flags & 2097155) !== 2) {
   throw new FS.ErrnoError(2);
  }
  if ((stream.flags & 2097155) === 1) {
   throw new FS.ErrnoError(2);
  }
  if (!stream.stream_ops.mmap) {
   throw new FS.ErrnoError(43);
  }
  return stream.stream_ops.mmap(stream, address, length, position, prot, flags);
 },
 msync: (stream, buffer, offset, length, mmapFlags) => {
  if (!stream || !stream.stream_ops.msync) {
   return 0;
  }
  return stream.stream_ops.msync(stream, buffer, offset, length, mmapFlags);
 },
 munmap: stream => 0,
 ioctl: (stream, cmd, arg) => {
  if (!stream.stream_ops.ioctl) {
   throw new FS.ErrnoError(59);
  }
  return stream.stream_ops.ioctl(stream, cmd, arg);
 },
 readFile: (path, opts = {}) => {
  opts.flags = opts.flags || 0;
  opts.encoding = opts.encoding || "binary";
  if (opts.encoding !== "utf8" && opts.encoding !== "binary") {
   throw new Error('Invalid encoding type "' + opts.encoding + '"');
  }
  var ret;
  var stream = FS.open(path, opts.flags);
  var stat = FS.stat(path);
  var length = stat.size;
  var buf = new Uint8Array(length);
  FS.read(stream, buf, 0, length, 0);
  if (opts.encoding === "utf8") {
   ret = UTF8ArrayToString(buf, 0);
  } else if (opts.encoding === "binary") {
   ret = buf;
  }
  FS.close(stream);
  return ret;
 },
 writeFile: (path, data, opts = {}) => {
  opts.flags = opts.flags || 577;
  var stream = FS.open(path, opts.flags, opts.mode);
  if (typeof data == "string") {
   var buf = new Uint8Array(lengthBytesUTF8(data) + 1);
   var actualNumBytes = stringToUTF8Array(data, buf, 0, buf.length);
   FS.write(stream, buf, 0, actualNumBytes, undefined, opts.canOwn);
  } else if (ArrayBuffer.isView(data)) {
   FS.write(stream, data, 0, data.byteLength, undefined, opts.canOwn);
  } else {
   throw new Error("Unsupported data type");
  }
  FS.close(stream);
 },
 cwd: () => FS.currentPath,
 chdir: path => {
  var lookup = FS.lookupPath(path, {
   follow: true
  });
  if (lookup.node === null) {
   throw new FS.ErrnoError(44);
  }
  if (!FS.isDir(lookup.node.mode)) {
   throw new FS.ErrnoError(54);
  }
  var errCode = FS.nodePermissions(lookup.node, "x");
  if (errCode) {
   throw new FS.ErrnoError(errCode);
  }
  FS.currentPath = lookup.path;
 },
 createDefaultDirectories: () => {
  FS.mkdir("/tmp");
  FS.mkdir("/home");
  FS.mkdir("/home/web_user");
 },
 createDefaultDevices: () => {
  FS.mkdir("/dev");
  FS.registerDevice(FS.makedev(1, 3), {
   read: () => 0,
   write: (stream, buffer, offset, length, pos) => length
  });
  FS.mkdev("/dev/null", FS.makedev(1, 3));
  TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
  TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
  FS.mkdev("/dev/tty", FS.makedev(5, 0));
  FS.mkdev("/dev/tty1", FS.makedev(6, 0));
  var random_device = getRandomDevice();
  FS.createDevice("/dev", "random", random_device);
  FS.createDevice("/dev", "urandom", random_device);
  FS.mkdir("/dev/shm");
  FS.mkdir("/dev/shm/tmp");
 },
 createSpecialDirectories: () => {
  FS.mkdir("/proc");
  var proc_self = FS.mkdir("/proc/self");
  FS.mkdir("/proc/self/fd");
  FS.mount({
   mount: () => {
    var node = FS.createNode(proc_self, "fd", 16384 | 511, 73);
    node.node_ops = {
     lookup: (parent, name) => {
      var fd = +name;
      var stream = FS.getStream(fd);
      if (!stream) throw new FS.ErrnoError(8);
      var ret = {
       parent: null,
       mount: {
        mountpoint: "fake"
       },
       node_ops: {
        readlink: () => stream.path
       }
      };
      ret.parent = ret;
      return ret;
     }
    };
    return node;
   }
  }, {}, "/proc/self/fd");
 },
 createStandardStreams: () => {
  if (Module["stdin"]) {
   FS.createDevice("/dev", "stdin", Module["stdin"]);
  } else {
   FS.symlink("/dev/tty", "/dev/stdin");
  }
  if (Module["stdout"]) {
   FS.createDevice("/dev", "stdout", null, Module["stdout"]);
  } else {
   FS.symlink("/dev/tty", "/dev/stdout");
  }
  if (Module["stderr"]) {
   FS.createDevice("/dev", "stderr", null, Module["stderr"]);
  } else {
   FS.symlink("/dev/tty1", "/dev/stderr");
  }
  var stdin = FS.open("/dev/stdin", 0);
  var stdout = FS.open("/dev/stdout", 1);
  var stderr = FS.open("/dev/stderr", 1);
  assert(stdin.fd === 0, "invalid handle for stdin (" + stdin.fd + ")");
  assert(stdout.fd === 1, "invalid handle for stdout (" + stdout.fd + ")");
  assert(stderr.fd === 2, "invalid handle for stderr (" + stderr.fd + ")");
 },
 ensureErrnoError: () => {
  if (FS.ErrnoError) return;
  FS.ErrnoError = function ErrnoError(errno, node) {
   this.node = node;
   this.setErrno = function(errno) {
    this.errno = errno;
    for (var key in ERRNO_CODES) {
     if (ERRNO_CODES[key] === errno) {
      this.code = key;
      break;
     }
    }
   };
   this.setErrno(errno);
   this.message = ERRNO_MESSAGES[errno];
   if (this.stack) {
    Object.defineProperty(this, "stack", {
     value: new Error().stack,
     writable: true
    });
    this.stack = demangleAll(this.stack);
   }
  };
  FS.ErrnoError.prototype = new Error();
  FS.ErrnoError.prototype.constructor = FS.ErrnoError;
  [ 44 ].forEach(code => {
   FS.genericErrors[code] = new FS.ErrnoError(code);
   FS.genericErrors[code].stack = "<generic error, no stack>";
  });
 },
 staticInit: () => {
  FS.ensureErrnoError();
  FS.nameTable = new Array(4096);
  FS.mount(MEMFS, {}, "/");
  FS.createDefaultDirectories();
  FS.createDefaultDevices();
  FS.createSpecialDirectories();
  FS.filesystems = {
   "MEMFS": MEMFS
  };
 },
 init: (input, output, error) => {
  assert(!FS.init.initialized, "FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)");
  FS.init.initialized = true;
  FS.ensureErrnoError();
  Module["stdin"] = input || Module["stdin"];
  Module["stdout"] = output || Module["stdout"];
  Module["stderr"] = error || Module["stderr"];
  FS.createStandardStreams();
 },
 quit: () => {
  FS.init.initialized = false;
  ___stdio_exit();
  for (var i = 0; i < FS.streams.length; i++) {
   var stream = FS.streams[i];
   if (!stream) {
    continue;
   }
   FS.close(stream);
  }
 },
 getMode: (canRead, canWrite) => {
  var mode = 0;
  if (canRead) mode |= 292 | 73;
  if (canWrite) mode |= 146;
  return mode;
 },
 findObject: (path, dontResolveLastLink) => {
  var ret = FS.analyzePath(path, dontResolveLastLink);
  if (ret.exists) {
   return ret.object;
  } else {
   return null;
  }
 },
 analyzePath: (path, dontResolveLastLink) => {
  try {
   var lookup = FS.lookupPath(path, {
    follow: !dontResolveLastLink
   });
   path = lookup.path;
  } catch (e) {}
  var ret = {
   isRoot: false,
   exists: false,
   error: 0,
   name: null,
   path: null,
   object: null,
   parentExists: false,
   parentPath: null,
   parentObject: null
  };
  try {
   var lookup = FS.lookupPath(path, {
    parent: true
   });
   ret.parentExists = true;
   ret.parentPath = lookup.path;
   ret.parentObject = lookup.node;
   ret.name = PATH.basename(path);
   lookup = FS.lookupPath(path, {
    follow: !dontResolveLastLink
   });
   ret.exists = true;
   ret.path = lookup.path;
   ret.object = lookup.node;
   ret.name = lookup.node.name;
   ret.isRoot = lookup.path === "/";
  } catch (e) {
   ret.error = e.errno;
  }
  return ret;
 },
 createPath: (parent, path, canRead, canWrite) => {
  parent = typeof parent == "string" ? parent : FS.getPath(parent);
  var parts = path.split("/").reverse();
  while (parts.length) {
   var part = parts.pop();
   if (!part) continue;
   var current = PATH.join2(parent, part);
   try {
    FS.mkdir(current);
   } catch (e) {}
   parent = current;
  }
  return current;
 },
 createFile: (parent, name, properties, canRead, canWrite) => {
  var path = PATH.join2(typeof parent == "string" ? parent : FS.getPath(parent), name);
  var mode = FS.getMode(canRead, canWrite);
  return FS.create(path, mode);
 },
 createDataFile: (parent, name, data, canRead, canWrite, canOwn) => {
  var path = name;
  if (parent) {
   parent = typeof parent == "string" ? parent : FS.getPath(parent);
   path = name ? PATH.join2(parent, name) : parent;
  }
  var mode = FS.getMode(canRead, canWrite);
  var node = FS.create(path, mode);
  if (data) {
   if (typeof data == "string") {
    var arr = new Array(data.length);
    for (var i = 0, len = data.length; i < len; ++i) arr[i] = data.charCodeAt(i);
    data = arr;
   }
   FS.chmod(node, mode | 146);
   var stream = FS.open(node, 577);
   FS.write(stream, data, 0, data.length, 0, canOwn);
   FS.close(stream);
   FS.chmod(node, mode);
  }
  return node;
 },
 createDevice: (parent, name, input, output) => {
  var path = PATH.join2(typeof parent == "string" ? parent : FS.getPath(parent), name);
  var mode = FS.getMode(!!input, !!output);
  if (!FS.createDevice.major) FS.createDevice.major = 64;
  var dev = FS.makedev(FS.createDevice.major++, 0);
  FS.registerDevice(dev, {
   open: stream => {
    stream.seekable = false;
   },
   close: stream => {
    if (output && output.buffer && output.buffer.length) {
     output(10);
    }
   },
   read: (stream, buffer, offset, length, pos) => {
    var bytesRead = 0;
    for (var i = 0; i < length; i++) {
     var result;
     try {
      result = input();
     } catch (e) {
      throw new FS.ErrnoError(29);
     }
     if (result === undefined && bytesRead === 0) {
      throw new FS.ErrnoError(6);
     }
     if (result === null || result === undefined) break;
     bytesRead++;
     buffer[offset + i] = result;
    }
    if (bytesRead) {
     stream.node.timestamp = Date.now();
    }
    return bytesRead;
   },
   write: (stream, buffer, offset, length, pos) => {
    for (var i = 0; i < length; i++) {
     try {
      output(buffer[offset + i]);
     } catch (e) {
      throw new FS.ErrnoError(29);
     }
    }
    if (length) {
     stream.node.timestamp = Date.now();
    }
    return i;
   }
  });
  return FS.mkdev(path, mode, dev);
 },
 forceLoadFile: obj => {
  if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
  if (typeof XMLHttpRequest != "undefined") {
   throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
  } else if (read_) {
   try {
    obj.contents = intArrayFromString(read_(obj.url), true);
    obj.usedBytes = obj.contents.length;
   } catch (e) {
    throw new FS.ErrnoError(29);
   }
  } else {
   throw new Error("Cannot load without read() or XMLHttpRequest.");
  }
 },
 createLazyFile: (parent, name, url, canRead, canWrite) => {
  function LazyUint8Array() {
   this.lengthKnown = false;
   this.chunks = [];
  }
  LazyUint8Array.prototype.get = function LazyUint8Array_get(idx) {
   if (idx > this.length - 1 || idx < 0) {
    return undefined;
   }
   var chunkOffset = idx % this.chunkSize;
   var chunkNum = idx / this.chunkSize | 0;
   return this.getter(chunkNum)[chunkOffset];
  };
  LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(getter) {
   this.getter = getter;
  };
  LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
   var xhr = new XMLHttpRequest();
   xhr.open("HEAD", url, false);
   xhr.send(null);
   if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
   var datalength = Number(xhr.getResponseHeader("Content-length"));
   var header;
   var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
   var usesGzip = (header = xhr.getResponseHeader("Content-Encoding")) && header === "gzip";
   var chunkSize = 1024 * 1024;
   if (!hasByteServing) chunkSize = datalength;
   var doXHR = (from, to) => {
    if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
    if (to > datalength - 1) throw new Error("only " + datalength + " bytes available! programmer error!");
    var xhr = new XMLHttpRequest();
    xhr.open("GET", url, false);
    if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
    xhr.responseType = "arraybuffer";
    if (xhr.overrideMimeType) {
     xhr.overrideMimeType("text/plain; charset=x-user-defined");
    }
    xhr.send(null);
    if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
    if (xhr.response !== undefined) {
     return new Uint8Array(xhr.response || []);
    } else {
     return intArrayFromString(xhr.responseText || "", true);
    }
   };
   var lazyArray = this;
   lazyArray.setDataGetter(chunkNum => {
    var start = chunkNum * chunkSize;
    var end = (chunkNum + 1) * chunkSize - 1;
    end = Math.min(end, datalength - 1);
    if (typeof lazyArray.chunks[chunkNum] == "undefined") {
     lazyArray.chunks[chunkNum] = doXHR(start, end);
    }
    if (typeof lazyArray.chunks[chunkNum] == "undefined") throw new Error("doXHR failed!");
    return lazyArray.chunks[chunkNum];
   });
   if (usesGzip || !datalength) {
    chunkSize = datalength = 1;
    datalength = this.getter(0).length;
    chunkSize = datalength;
    out("LazyFiles on gzip forces download of the whole file when length is accessed");
   }
   this._length = datalength;
   this._chunkSize = chunkSize;
   this.lengthKnown = true;
  };
  if (typeof XMLHttpRequest != "undefined") {
   if (!ENVIRONMENT_IS_WORKER) throw "Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";
   var lazyArray = new LazyUint8Array();
   Object.defineProperties(lazyArray, {
    length: {
     get: function() {
      if (!this.lengthKnown) {
       this.cacheLength();
      }
      return this._length;
     }
    },
    chunkSize: {
     get: function() {
      if (!this.lengthKnown) {
       this.cacheLength();
      }
      return this._chunkSize;
     }
    }
   });
   var properties = {
    isDevice: false,
    contents: lazyArray
   };
  } else {
   var properties = {
    isDevice: false,
    url: url
   };
  }
  var node = FS.createFile(parent, name, properties, canRead, canWrite);
  if (properties.contents) {
   node.contents = properties.contents;
  } else if (properties.url) {
   node.contents = null;
   node.url = properties.url;
  }
  Object.defineProperties(node, {
   usedBytes: {
    get: function() {
     return this.contents.length;
    }
   }
  });
  var stream_ops = {};
  var keys = Object.keys(node.stream_ops);
  keys.forEach(key => {
   var fn = node.stream_ops[key];
   stream_ops[key] = function forceLoadLazyFile() {
    FS.forceLoadFile(node);
    return fn.apply(null, arguments);
   };
  });
  stream_ops.read = ((stream, buffer, offset, length, position) => {
   FS.forceLoadFile(node);
   var contents = stream.node.contents;
   if (position >= contents.length) return 0;
   var size = Math.min(contents.length - position, length);
   assert(size >= 0);
   if (contents.slice) {
    for (var i = 0; i < size; i++) {
     buffer[offset + i] = contents[position + i];
    }
   } else {
    for (var i = 0; i < size; i++) {
     buffer[offset + i] = contents.get(position + i);
    }
   }
   return size;
  });
  node.stream_ops = stream_ops;
  return node;
 },
 createPreloadedFile: (parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn, preFinish) => {
  var fullname = name ? PATH_FS.resolve(PATH.join2(parent, name)) : parent;
  var dep = getUniqueRunDependency("cp " + fullname);
  function processData(byteArray) {
   function finish(byteArray) {
    if (preFinish) preFinish();
    if (!dontCreateFile) {
     FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn);
    }
    if (onload) onload();
    removeRunDependency(dep);
   }
   if (Browser.handledByPreloadPlugin(byteArray, fullname, finish, () => {
    if (onerror) onerror();
    removeRunDependency(dep);
   })) {
    return;
   }
   finish(byteArray);
  }
  addRunDependency(dep);
  if (typeof url == "string") {
   asyncLoad(url, byteArray => processData(byteArray), onerror);
  } else {
   processData(url);
  }
 },
 indexedDB: () => {
  return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
 },
 DB_NAME: () => {
  return "EM_FS_" + window.location.pathname;
 },
 DB_VERSION: 20,
 DB_STORE_NAME: "FILE_DATA",
 saveFilesToDB: (paths, onload, onerror) => {
  onload = onload || (() => {});
  onerror = onerror || (() => {});
  var indexedDB = FS.indexedDB();
  try {
   var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
  } catch (e) {
   return onerror(e);
  }
  openRequest.onupgradeneeded = (() => {
   out("creating db");
   var db = openRequest.result;
   db.createObjectStore(FS.DB_STORE_NAME);
  });
  openRequest.onsuccess = (() => {
   var db = openRequest.result;
   var transaction = db.transaction([ FS.DB_STORE_NAME ], "readwrite");
   var files = transaction.objectStore(FS.DB_STORE_NAME);
   var ok = 0, fail = 0, total = paths.length;
   function finish() {
    if (fail == 0) onload(); else onerror();
   }
   paths.forEach(path => {
    var putRequest = files.put(FS.analyzePath(path).object.contents, path);
    putRequest.onsuccess = (() => {
     ok++;
     if (ok + fail == total) finish();
    });
    putRequest.onerror = (() => {
     fail++;
     if (ok + fail == total) finish();
    });
   });
   transaction.onerror = onerror;
  });
  openRequest.onerror = onerror;
 },
 loadFilesFromDB: (paths, onload, onerror) => {
  onload = onload || (() => {});
  onerror = onerror || (() => {});
  var indexedDB = FS.indexedDB();
  try {
   var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
  } catch (e) {
   return onerror(e);
  }
  openRequest.onupgradeneeded = onerror;
  openRequest.onsuccess = (() => {
   var db = openRequest.result;
   try {
    var transaction = db.transaction([ FS.DB_STORE_NAME ], "readonly");
   } catch (e) {
    onerror(e);
    return;
   }
   var files = transaction.objectStore(FS.DB_STORE_NAME);
   var ok = 0, fail = 0, total = paths.length;
   function finish() {
    if (fail == 0) onload(); else onerror();
   }
   paths.forEach(path => {
    var getRequest = files.get(path);
    getRequest.onsuccess = (() => {
     if (FS.analyzePath(path).exists) {
      FS.unlink(path);
     }
     FS.createDataFile(PATH.dirname(path), PATH.basename(path), getRequest.result, true, true, true);
     ok++;
     if (ok + fail == total) finish();
    });
    getRequest.onerror = (() => {
     fail++;
     if (ok + fail == total) finish();
    });
   });
   transaction.onerror = onerror;
  });
  openRequest.onerror = onerror;
 },
 absolutePath: () => {
  abort("FS.absolutePath has been removed; use PATH_FS.resolve instead");
 },
 createFolder: () => {
  abort("FS.createFolder has been removed; use FS.mkdir instead");
 },
 createLink: () => {
  abort("FS.createLink has been removed; use FS.symlink instead");
 },
 joinPath: () => {
  abort("FS.joinPath has been removed; use PATH.join instead");
 },
 mmapAlloc: () => {
  abort("FS.mmapAlloc has been replaced by the top level function mmapAlloc");
 },
 standardizePath: () => {
  abort("FS.standardizePath has been removed; use PATH.normalize instead");
 }
};

var SYSCALLS = {
 DEFAULT_POLLMASK: 5,
 calculateAt: function(dirfd, path, allowEmpty) {
  if (path[0] === "/") {
   return path;
  }
  var dir;
  if (dirfd === -100) {
   dir = FS.cwd();
  } else {
   var dirstream = FS.getStream(dirfd);
   if (!dirstream) throw new FS.ErrnoError(8);
   dir = dirstream.path;
  }
  if (path.length == 0) {
   if (!allowEmpty) {
    throw new FS.ErrnoError(44);
   }
   return dir;
  }
  return PATH.join2(dir, path);
 },
 doStat: function(func, path, buf) {
  try {
   var stat = func(path);
  } catch (e) {
   if (e && e.node && PATH.normalize(path) !== PATH.normalize(FS.getPath(e.node))) {
    return -54;
   }
   throw e;
  }
  GROWABLE_HEAP_I32()[buf >> 2] = stat.dev;
  GROWABLE_HEAP_I32()[buf + 4 >> 2] = 0;
  GROWABLE_HEAP_I32()[buf + 8 >> 2] = stat.ino;
  GROWABLE_HEAP_I32()[buf + 12 >> 2] = stat.mode;
  GROWABLE_HEAP_I32()[buf + 16 >> 2] = stat.nlink;
  GROWABLE_HEAP_I32()[buf + 20 >> 2] = stat.uid;
  GROWABLE_HEAP_I32()[buf + 24 >> 2] = stat.gid;
  GROWABLE_HEAP_I32()[buf + 28 >> 2] = stat.rdev;
  GROWABLE_HEAP_I32()[buf + 32 >> 2] = 0;
  tempI64 = [ stat.size >>> 0, (tempDouble = stat.size, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? (Math.min(+Math.floor(tempDouble / 4294967296), 4294967295) | 0) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0) ], 
  GROWABLE_HEAP_I32()[buf + 40 >> 2] = tempI64[0], GROWABLE_HEAP_I32()[buf + 44 >> 2] = tempI64[1];
  GROWABLE_HEAP_I32()[buf + 48 >> 2] = 4096;
  GROWABLE_HEAP_I32()[buf + 52 >> 2] = stat.blocks;
  GROWABLE_HEAP_I32()[buf + 56 >> 2] = stat.atime.getTime() / 1e3 | 0;
  GROWABLE_HEAP_I32()[buf + 60 >> 2] = 0;
  GROWABLE_HEAP_I32()[buf + 64 >> 2] = stat.mtime.getTime() / 1e3 | 0;
  GROWABLE_HEAP_I32()[buf + 68 >> 2] = 0;
  GROWABLE_HEAP_I32()[buf + 72 >> 2] = stat.ctime.getTime() / 1e3 | 0;
  GROWABLE_HEAP_I32()[buf + 76 >> 2] = 0;
  tempI64 = [ stat.ino >>> 0, (tempDouble = stat.ino, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? (Math.min(+Math.floor(tempDouble / 4294967296), 4294967295) | 0) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0) ], 
  GROWABLE_HEAP_I32()[buf + 80 >> 2] = tempI64[0], GROWABLE_HEAP_I32()[buf + 84 >> 2] = tempI64[1];
  return 0;
 },
 doMsync: function(addr, stream, len, flags, offset) {
  var buffer = GROWABLE_HEAP_U8().slice(addr, addr + len);
  FS.msync(stream, buffer, offset, len, flags);
 },
 doMkdir: function(path, mode) {
  path = PATH.normalize(path);
  if (path[path.length - 1] === "/") path = path.substr(0, path.length - 1);
  FS.mkdir(path, mode, 0);
  return 0;
 },
 doMknod: function(path, mode, dev) {
  switch (mode & 61440) {
  case 32768:
  case 8192:
  case 24576:
  case 4096:
  case 49152:
   break;

  default:
   return -28;
  }
  FS.mknod(path, mode, dev);
  return 0;
 },
 doReadlink: function(path, buf, bufsize) {
  if (bufsize <= 0) return -28;
  var ret = FS.readlink(path);
  var len = Math.min(bufsize, lengthBytesUTF8(ret));
  var endChar = GROWABLE_HEAP_I8()[buf + len];
  stringToUTF8(ret, buf, bufsize + 1);
  GROWABLE_HEAP_I8()[buf + len] = endChar;
  return len;
 },
 doAccess: function(path, amode) {
  if (amode & ~7) {
   return -28;
  }
  var lookup = FS.lookupPath(path, {
   follow: true
  });
  var node = lookup.node;
  if (!node) {
   return -44;
  }
  var perms = "";
  if (amode & 4) perms += "r";
  if (amode & 2) perms += "w";
  if (amode & 1) perms += "x";
  if (perms && FS.nodePermissions(node, perms)) {
   return -2;
  }
  return 0;
 },
 doDup: function(path, flags, suggestFD) {
  var suggest = FS.getStream(suggestFD);
  if (suggest) FS.close(suggest);
  return FS.open(path, flags, 0, suggestFD, suggestFD).fd;
 },
 doReadv: function(stream, iov, iovcnt, offset) {
  var ret = 0;
  for (var i = 0; i < iovcnt; i++) {
   var ptr = GROWABLE_HEAP_I32()[iov + i * 8 >> 2];
   var len = GROWABLE_HEAP_I32()[iov + (i * 8 + 4) >> 2];
   var curr = FS.read(stream, GROWABLE_HEAP_I8(), ptr, len, offset);
   if (curr < 0) return -1;
   ret += curr;
   if (curr < len) break;
  }
  return ret;
 },
 doWritev: function(stream, iov, iovcnt, offset) {
  var ret = 0;
  for (var i = 0; i < iovcnt; i++) {
   var ptr = GROWABLE_HEAP_I32()[iov + i * 8 >> 2];
   var len = GROWABLE_HEAP_I32()[iov + (i * 8 + 4) >> 2];
   var curr = FS.write(stream, GROWABLE_HEAP_I8(), ptr, len, offset);
   if (curr < 0) return -1;
   ret += curr;
  }
  return ret;
 },
 varargs: undefined,
 get: function() {
  assert(SYSCALLS.varargs != undefined);
  SYSCALLS.varargs += 4;
  var ret = GROWABLE_HEAP_I32()[SYSCALLS.varargs - 4 >> 2];
  return ret;
 },
 getStr: function(ptr) {
  var ret = UTF8ToString(ptr);
  return ret;
 },
 getStreamFromFD: function(fd) {
  var stream = FS.getStream(fd);
  if (!stream) throw new FS.ErrnoError(8);
  return stream;
 },
 get64: function(low, high) {
  if (low >= 0) assert(high === 0); else assert(high === -1);
  return low;
 }
};

function ___syscall__newselect(nfds, readfds, writefds, exceptfds, timeout) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(2, 1, nfds, readfds, writefds, exceptfds, timeout);
 try {
  assert(nfds <= 64, "nfds must be less than or equal to 64");
  assert(!exceptfds, "exceptfds not supported");
  var total = 0;
  var srcReadLow = readfds ? GROWABLE_HEAP_I32()[readfds >> 2] : 0, srcReadHigh = readfds ? GROWABLE_HEAP_I32()[readfds + 4 >> 2] : 0;
  var srcWriteLow = writefds ? GROWABLE_HEAP_I32()[writefds >> 2] : 0, srcWriteHigh = writefds ? GROWABLE_HEAP_I32()[writefds + 4 >> 2] : 0;
  var srcExceptLow = exceptfds ? GROWABLE_HEAP_I32()[exceptfds >> 2] : 0, srcExceptHigh = exceptfds ? GROWABLE_HEAP_I32()[exceptfds + 4 >> 2] : 0;
  var dstReadLow = 0, dstReadHigh = 0;
  var dstWriteLow = 0, dstWriteHigh = 0;
  var dstExceptLow = 0, dstExceptHigh = 0;
  var allLow = (readfds ? GROWABLE_HEAP_I32()[readfds >> 2] : 0) | (writefds ? GROWABLE_HEAP_I32()[writefds >> 2] : 0) | (exceptfds ? GROWABLE_HEAP_I32()[exceptfds >> 2] : 0);
  var allHigh = (readfds ? GROWABLE_HEAP_I32()[readfds + 4 >> 2] : 0) | (writefds ? GROWABLE_HEAP_I32()[writefds + 4 >> 2] : 0) | (exceptfds ? GROWABLE_HEAP_I32()[exceptfds + 4 >> 2] : 0);
  var check = function(fd, low, high, val) {
   return fd < 32 ? low & val : high & val;
  };
  for (var fd = 0; fd < nfds; fd++) {
   var mask = 1 << fd % 32;
   if (!check(fd, allLow, allHigh, mask)) {
    continue;
   }
   var stream = FS.getStream(fd);
   if (!stream) throw new FS.ErrnoError(8);
   var flags = SYSCALLS.DEFAULT_POLLMASK;
   if (stream.stream_ops.poll) {
    flags = stream.stream_ops.poll(stream);
   }
   if (flags & 1 && check(fd, srcReadLow, srcReadHigh, mask)) {
    fd < 32 ? dstReadLow = dstReadLow | mask : dstReadHigh = dstReadHigh | mask;
    total++;
   }
   if (flags & 4 && check(fd, srcWriteLow, srcWriteHigh, mask)) {
    fd < 32 ? dstWriteLow = dstWriteLow | mask : dstWriteHigh = dstWriteHigh | mask;
    total++;
   }
   if (flags & 2 && check(fd, srcExceptLow, srcExceptHigh, mask)) {
    fd < 32 ? dstExceptLow = dstExceptLow | mask : dstExceptHigh = dstExceptHigh | mask;
    total++;
   }
  }
  if (readfds) {
   GROWABLE_HEAP_I32()[readfds >> 2] = dstReadLow;
   GROWABLE_HEAP_I32()[readfds + 4 >> 2] = dstReadHigh;
  }
  if (writefds) {
   GROWABLE_HEAP_I32()[writefds >> 2] = dstWriteLow;
   GROWABLE_HEAP_I32()[writefds + 4 >> 2] = dstWriteHigh;
  }
  if (exceptfds) {
   GROWABLE_HEAP_I32()[exceptfds >> 2] = dstExceptLow;
   GROWABLE_HEAP_I32()[exceptfds + 4 >> 2] = dstExceptHigh;
  }
  return total;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

var SOCKFS = {
 mount: function(mount) {
  Module["websocket"] = Module["websocket"] && "object" === typeof Module["websocket"] ? Module["websocket"] : {};
  Module["websocket"]._callbacks = {};
  Module["websocket"]["on"] = function(event, callback) {
   if ("function" === typeof callback) {
    this._callbacks[event] = callback;
   }
   return this;
  };
  Module["websocket"].emit = function(event, param) {
   if ("function" === typeof this._callbacks[event]) {
    this._callbacks[event].call(this, param);
   }
  };
  return FS.createNode(null, "/", 16384 | 511, 0);
 },
 createSocket: function(family, type, protocol) {
  type &= ~526336;
  var streaming = type == 1;
  if (protocol) {
   assert(streaming == (protocol == 6));
  }
  var sock = {
   family: family,
   type: type,
   protocol: protocol,
   server: null,
   error: null,
   peers: {},
   pending: [],
   recv_queue: [],
   sock_ops: SOCKFS.websocket_sock_ops
  };
  var name = SOCKFS.nextname();
  var node = FS.createNode(SOCKFS.root, name, 49152, 0);
  node.sock = sock;
  var stream = FS.createStream({
   path: name,
   node: node,
   flags: 2,
   seekable: false,
   stream_ops: SOCKFS.stream_ops
  });
  sock.stream = stream;
  return sock;
 },
 getSocket: function(fd) {
  var stream = FS.getStream(fd);
  if (!stream || !FS.isSocket(stream.node.mode)) {
   return null;
  }
  return stream.node.sock;
 },
 stream_ops: {
  poll: function(stream) {
   var sock = stream.node.sock;
   return sock.sock_ops.poll(sock);
  },
  ioctl: function(stream, request, varargs) {
   var sock = stream.node.sock;
   return sock.sock_ops.ioctl(sock, request, varargs);
  },
  read: function(stream, buffer, offset, length, position) {
   var sock = stream.node.sock;
   var msg = sock.sock_ops.recvmsg(sock, length);
   if (!msg) {
    return 0;
   }
   buffer.set(msg.buffer, offset);
   return msg.buffer.length;
  },
  write: function(stream, buffer, offset, length, position) {
   var sock = stream.node.sock;
   return sock.sock_ops.sendmsg(sock, buffer, offset, length);
  },
  close: function(stream) {
   var sock = stream.node.sock;
   sock.sock_ops.close(sock);
  }
 },
 nextname: function() {
  if (!SOCKFS.nextname.current) {
   SOCKFS.nextname.current = 0;
  }
  return "socket[" + SOCKFS.nextname.current++ + "]";
 },
 websocket_sock_ops: {
  createPeer: function(sock, addr, port) {
   var ws;
   if (typeof addr == "object") {
    ws = addr;
    addr = null;
    port = null;
   }
   if (ws) {
    if (ws._socket) {
     addr = ws._socket.remoteAddress;
     port = ws._socket.remotePort;
    } else {
     var result = /ws[s]?:\/\/([^:]+):(\d+)/.exec(ws.url);
     if (!result) {
      throw new Error("WebSocket URL must be in the format ws(s)://address:port");
     }
     addr = result[1];
     port = parseInt(result[2], 10);
    }
   } else {
    try {
     var runtimeConfig = Module["websocket"] && "object" === typeof Module["websocket"];
     var url = "ws:#".replace("#", "//");
     if (runtimeConfig) {
      if ("string" === typeof Module["websocket"]["url"]) {
       url = Module["websocket"]["url"];
      }
     }
     if (url === "ws://" || url === "wss://") {
      var parts = addr.split("/");
      url = url + parts[0] + ":" + port + "/" + parts.slice(1).join("/");
     }
     var subProtocols = "binary";
     if (runtimeConfig) {
      if ("string" === typeof Module["websocket"]["subprotocol"]) {
       subProtocols = Module["websocket"]["subprotocol"];
      }
     }
     var opts = undefined;
     if (subProtocols !== "null") {
      subProtocols = subProtocols.replace(/^ +| +$/g, "").split(/ *, */);
      opts = ENVIRONMENT_IS_NODE ? {
       "protocol": subProtocols.toString()
      } : subProtocols;
     }
     if (runtimeConfig && null === Module["websocket"]["subprotocol"]) {
      subProtocols = "null";
      opts = undefined;
     }
     var WebSocketConstructor;
     if (ENVIRONMENT_IS_NODE) {
      WebSocketConstructor = require("ws");
     } else {
      WebSocketConstructor = WebSocket;
     }
     ws = new WebSocketConstructor(url, opts);
     ws.binaryType = "arraybuffer";
    } catch (e) {
     throw new FS.ErrnoError(23);
    }
   }
   var peer = {
    addr: addr,
    port: port,
    socket: ws,
    dgram_send_queue: []
   };
   SOCKFS.websocket_sock_ops.addPeer(sock, peer);
   SOCKFS.websocket_sock_ops.handlePeerEvents(sock, peer);
   if (sock.type === 2 && typeof sock.sport != "undefined") {
    peer.dgram_send_queue.push(new Uint8Array([ 255, 255, 255, 255, "p".charCodeAt(0), "o".charCodeAt(0), "r".charCodeAt(0), "t".charCodeAt(0), (sock.sport & 65280) >> 8, sock.sport & 255 ]));
   }
   return peer;
  },
  getPeer: function(sock, addr, port) {
   return sock.peers[addr + ":" + port];
  },
  addPeer: function(sock, peer) {
   sock.peers[peer.addr + ":" + peer.port] = peer;
  },
  removePeer: function(sock, peer) {
   delete sock.peers[peer.addr + ":" + peer.port];
  },
  handlePeerEvents: function(sock, peer) {
   var first = true;
   var handleOpen = function() {
    Module["websocket"].emit("open", sock.stream.fd);
    try {
     var queued = peer.dgram_send_queue.shift();
     while (queued) {
      peer.socket.send(queued);
      queued = peer.dgram_send_queue.shift();
     }
    } catch (e) {
     peer.socket.close();
    }
   };
   function handleMessage(data) {
    if (typeof data == "string") {
     var encoder = new TextEncoder();
     data = encoder.encode(data);
    } else {
     assert(data.byteLength !== undefined);
     if (data.byteLength == 0) {
      return;
     } else {
      data = new Uint8Array(data);
     }
    }
    var wasfirst = first;
    first = false;
    if (wasfirst && data.length === 10 && data[0] === 255 && data[1] === 255 && data[2] === 255 && data[3] === 255 && data[4] === "p".charCodeAt(0) && data[5] === "o".charCodeAt(0) && data[6] === "r".charCodeAt(0) && data[7] === "t".charCodeAt(0)) {
     var newport = data[8] << 8 | data[9];
     SOCKFS.websocket_sock_ops.removePeer(sock, peer);
     peer.port = newport;
     SOCKFS.websocket_sock_ops.addPeer(sock, peer);
     return;
    }
    sock.recv_queue.push({
     addr: peer.addr,
     port: peer.port,
     data: data
    });
    Module["websocket"].emit("message", sock.stream.fd);
   }
   if (ENVIRONMENT_IS_NODE) {
    peer.socket.on("open", handleOpen);
    peer.socket.on("message", function(data, flags) {
     if (!flags.binary) {
      return;
     }
     handleMessage(new Uint8Array(data).buffer);
    });
    peer.socket.on("close", function() {
     Module["websocket"].emit("close", sock.stream.fd);
    });
    peer.socket.on("error", function(error) {
     sock.error = 14;
     Module["websocket"].emit("error", [ sock.stream.fd, sock.error, "ECONNREFUSED: Connection refused" ]);
    });
   } else {
    peer.socket.onopen = handleOpen;
    peer.socket.onclose = function() {
     Module["websocket"].emit("close", sock.stream.fd);
    };
    peer.socket.onmessage = function peer_socket_onmessage(event) {
     handleMessage(event.data);
    };
    peer.socket.onerror = function(error) {
     sock.error = 14;
     Module["websocket"].emit("error", [ sock.stream.fd, sock.error, "ECONNREFUSED: Connection refused" ]);
    };
   }
  },
  poll: function(sock) {
   if (sock.type === 1 && sock.server) {
    return sock.pending.length ? 64 | 1 : 0;
   }
   var mask = 0;
   var dest = sock.type === 1 ? SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport) : null;
   if (sock.recv_queue.length || !dest || dest && dest.socket.readyState === dest.socket.CLOSING || dest && dest.socket.readyState === dest.socket.CLOSED) {
    mask |= 64 | 1;
   }
   if (!dest || dest && dest.socket.readyState === dest.socket.OPEN) {
    mask |= 4;
   }
   if (dest && dest.socket.readyState === dest.socket.CLOSING || dest && dest.socket.readyState === dest.socket.CLOSED) {
    mask |= 16;
   }
   return mask;
  },
  ioctl: function(sock, request, arg) {
   switch (request) {
   case 21531:
    var bytes = 0;
    if (sock.recv_queue.length) {
     bytes = sock.recv_queue[0].data.length;
    }
    GROWABLE_HEAP_I32()[arg >> 2] = bytes;
    return 0;

   default:
    return 28;
   }
  },
  close: function(sock) {
   if (sock.server) {
    try {
     sock.server.close();
    } catch (e) {}
    sock.server = null;
   }
   var peers = Object.keys(sock.peers);
   for (var i = 0; i < peers.length; i++) {
    var peer = sock.peers[peers[i]];
    try {
     peer.socket.close();
    } catch (e) {}
    SOCKFS.websocket_sock_ops.removePeer(sock, peer);
   }
   return 0;
  },
  bind: function(sock, addr, port) {
   if (typeof sock.saddr != "undefined" || typeof sock.sport != "undefined") {
    throw new FS.ErrnoError(28);
   }
   sock.saddr = addr;
   sock.sport = port;
   if (sock.type === 2) {
    if (sock.server) {
     sock.server.close();
     sock.server = null;
    }
    try {
     sock.sock_ops.listen(sock, 0);
    } catch (e) {
     if (!(e instanceof FS.ErrnoError)) throw e;
     if (e.errno !== 138) throw e;
    }
   }
  },
  connect: function(sock, addr, port) {
   if (sock.server) {
    throw new FS.ErrnoError(138);
   }
   if (typeof sock.daddr != "undefined" && typeof sock.dport != "undefined") {
    var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
    if (dest) {
     if (dest.socket.readyState === dest.socket.CONNECTING) {
      throw new FS.ErrnoError(7);
     } else {
      throw new FS.ErrnoError(30);
     }
    }
   }
   var peer = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
   sock.daddr = peer.addr;
   sock.dport = peer.port;
   throw new FS.ErrnoError(26);
  },
  listen: function(sock, backlog) {
   if (!ENVIRONMENT_IS_NODE) {
    throw new FS.ErrnoError(138);
   }
   if (sock.server) {
    throw new FS.ErrnoError(28);
   }
   var WebSocketServer = require("ws").Server;
   var host = sock.saddr;
   sock.server = new WebSocketServer({
    host: host,
    port: sock.sport
   });
   Module["websocket"].emit("listen", sock.stream.fd);
   sock.server.on("connection", function(ws) {
    if (sock.type === 1) {
     var newsock = SOCKFS.createSocket(sock.family, sock.type, sock.protocol);
     var peer = SOCKFS.websocket_sock_ops.createPeer(newsock, ws);
     newsock.daddr = peer.addr;
     newsock.dport = peer.port;
     sock.pending.push(newsock);
     Module["websocket"].emit("connection", newsock.stream.fd);
    } else {
     SOCKFS.websocket_sock_ops.createPeer(sock, ws);
     Module["websocket"].emit("connection", sock.stream.fd);
    }
   });
   sock.server.on("closed", function() {
    Module["websocket"].emit("close", sock.stream.fd);
    sock.server = null;
   });
   sock.server.on("error", function(error) {
    sock.error = 23;
    Module["websocket"].emit("error", [ sock.stream.fd, sock.error, "EHOSTUNREACH: Host is unreachable" ]);
   });
  },
  accept: function(listensock) {
   if (!listensock.server) {
    throw new FS.ErrnoError(28);
   }
   var newsock = listensock.pending.shift();
   newsock.stream.flags = listensock.stream.flags;
   return newsock;
  },
  getname: function(sock, peer) {
   var addr, port;
   if (peer) {
    if (sock.daddr === undefined || sock.dport === undefined) {
     throw new FS.ErrnoError(53);
    }
    addr = sock.daddr;
    port = sock.dport;
   } else {
    addr = sock.saddr || 0;
    port = sock.sport || 0;
   }
   return {
    addr: addr,
    port: port
   };
  },
  sendmsg: function(sock, buffer, offset, length, addr, port) {
   if (sock.type === 2) {
    if (addr === undefined || port === undefined) {
     addr = sock.daddr;
     port = sock.dport;
    }
    if (addr === undefined || port === undefined) {
     throw new FS.ErrnoError(17);
    }
   } else {
    addr = sock.daddr;
    port = sock.dport;
   }
   var dest = SOCKFS.websocket_sock_ops.getPeer(sock, addr, port);
   if (sock.type === 1) {
    if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
     throw new FS.ErrnoError(53);
    } else if (dest.socket.readyState === dest.socket.CONNECTING) {
     throw new FS.ErrnoError(6);
    }
   }
   if (ArrayBuffer.isView(buffer)) {
    offset += buffer.byteOffset;
    buffer = buffer.buffer;
   }
   var data;
   if (buffer instanceof SharedArrayBuffer) {
    data = new Uint8Array(new Uint8Array(buffer.slice(offset, offset + length))).buffer;
   } else {
    data = buffer.slice(offset, offset + length);
   }
   if (sock.type === 2) {
    if (!dest || dest.socket.readyState !== dest.socket.OPEN) {
     if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
      dest = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
     }
     dest.dgram_send_queue.push(data);
     return length;
    }
   }
   try {
    dest.socket.send(data);
    return length;
   } catch (e) {
    throw new FS.ErrnoError(28);
   }
  },
  recvmsg: function(sock, length) {
   if (sock.type === 1 && sock.server) {
    throw new FS.ErrnoError(53);
   }
   var queued = sock.recv_queue.shift();
   if (!queued) {
    if (sock.type === 1) {
     var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
     if (!dest) {
      throw new FS.ErrnoError(53);
     } else if (dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
      return null;
     } else {
      throw new FS.ErrnoError(6);
     }
    } else {
     throw new FS.ErrnoError(6);
    }
   }
   var queuedLength = queued.data.byteLength || queued.data.length;
   var queuedOffset = queued.data.byteOffset || 0;
   var queuedBuffer = queued.data.buffer || queued.data;
   var bytesRead = Math.min(length, queuedLength);
   var res = {
    buffer: new Uint8Array(queuedBuffer, queuedOffset, bytesRead),
    addr: queued.addr,
    port: queued.port
   };
   if (sock.type === 1 && bytesRead < queuedLength) {
    var bytesRemaining = queuedLength - bytesRead;
    queued.data = new Uint8Array(queuedBuffer, queuedOffset + bytesRead, bytesRemaining);
    sock.recv_queue.unshift(queued);
   }
   return res;
  }
 }
};

function getSocketFromFD(fd) {
 var socket = SOCKFS.getSocket(fd);
 if (!socket) throw new FS.ErrnoError(8);
 return socket;
}

var Sockets = {
 BUFFER_SIZE: 10240,
 MAX_BUFFER_SIZE: 10485760,
 nextFd: 1,
 fds: {},
 nextport: 1,
 maxport: 65535,
 peer: null,
 connections: {},
 portmap: {},
 localAddr: 4261412874,
 addrPool: [ 33554442, 50331658, 67108874, 83886090, 100663306, 117440522, 134217738, 150994954, 167772170, 184549386, 201326602, 218103818, 234881034 ]
};

function inetPton4(str) {
 var b = str.split(".");
 for (var i = 0; i < 4; i++) {
  var tmp = Number(b[i]);
  if (isNaN(tmp)) return null;
  b[i] = tmp;
 }
 return (b[0] | b[1] << 8 | b[2] << 16 | b[3] << 24) >>> 0;
}

function jstoi_q(str) {
 return parseInt(str);
}

function inetPton6(str) {
 var words;
 var w, offset, z, i;
 var valid6regx = /^((?=.*::)(?!.*::.+::)(::)?([\dA-F]{1,4}:(:|\b)|){5}|([\dA-F]{1,4}:){6})((([\dA-F]{1,4}((?!\3)::|:\b|$))|(?!\2\3)){2}|(((2[0-4]|1\d|[1-9])?\d|25[0-5])\.?\b){4})$/i;
 var parts = [];
 if (!valid6regx.test(str)) {
  return null;
 }
 if (str === "::") {
  return [ 0, 0, 0, 0, 0, 0, 0, 0 ];
 }
 if (str.startsWith("::")) {
  str = str.replace("::", "Z:");
 } else {
  str = str.replace("::", ":Z:");
 }
 if (str.indexOf(".") > 0) {
  str = str.replace(new RegExp("[.]", "g"), ":");
  words = str.split(":");
  words[words.length - 4] = jstoi_q(words[words.length - 4]) + jstoi_q(words[words.length - 3]) * 256;
  words[words.length - 3] = jstoi_q(words[words.length - 2]) + jstoi_q(words[words.length - 1]) * 256;
  words = words.slice(0, words.length - 2);
 } else {
  words = str.split(":");
 }
 offset = 0;
 z = 0;
 for (w = 0; w < words.length; w++) {
  if (typeof words[w] == "string") {
   if (words[w] === "Z") {
    for (z = 0; z < 8 - words.length + 1; z++) {
     parts[w + z] = 0;
    }
    offset = z - 1;
   } else {
    parts[w + offset] = _htons(parseInt(words[w], 16));
   }
  } else {
   parts[w + offset] = words[w];
  }
 }
 return [ parts[1] << 16 | parts[0], parts[3] << 16 | parts[2], parts[5] << 16 | parts[4], parts[7] << 16 | parts[6] ];
}

function writeSockaddr(sa, family, addr, port, addrlen) {
 switch (family) {
 case 2:
  addr = inetPton4(addr);
  zeroMemory(sa, 16);
  if (addrlen) {
   GROWABLE_HEAP_I32()[addrlen >> 2] = 16;
  }
  GROWABLE_HEAP_I16()[sa >> 1] = family;
  GROWABLE_HEAP_I32()[sa + 4 >> 2] = addr;
  GROWABLE_HEAP_I16()[sa + 2 >> 1] = _htons(port);
  break;

 case 10:
  addr = inetPton6(addr);
  zeroMemory(sa, 28);
  if (addrlen) {
   GROWABLE_HEAP_I32()[addrlen >> 2] = 28;
  }
  GROWABLE_HEAP_I32()[sa >> 2] = family;
  GROWABLE_HEAP_I32()[sa + 8 >> 2] = addr[0];
  GROWABLE_HEAP_I32()[sa + 12 >> 2] = addr[1];
  GROWABLE_HEAP_I32()[sa + 16 >> 2] = addr[2];
  GROWABLE_HEAP_I32()[sa + 20 >> 2] = addr[3];
  GROWABLE_HEAP_I16()[sa + 2 >> 1] = _htons(port);
  break;

 default:
  return 5;
 }
 return 0;
}

var DNS = {
 address_map: {
  id: 1,
  addrs: {},
  names: {}
 },
 lookup_name: function(name) {
  var res = inetPton4(name);
  if (res !== null) {
   return name;
  }
  res = inetPton6(name);
  if (res !== null) {
   return name;
  }
  var addr;
  if (DNS.address_map.addrs[name]) {
   addr = DNS.address_map.addrs[name];
  } else {
   var id = DNS.address_map.id++;
   assert(id < 65535, "exceeded max address mappings of 65535");
   addr = "172.29." + (id & 255) + "." + (id & 65280);
   DNS.address_map.names[addr] = name;
   DNS.address_map.addrs[name] = addr;
  }
  return addr;
 },
 lookup_addr: function(addr) {
  if (DNS.address_map.names[addr]) {
   return DNS.address_map.names[addr];
  }
  return null;
 }
};

function ___syscall_accept4(fd, addr, addrlen, flags) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(3, 1, fd, addr, addrlen, flags);
 try {
  var sock = getSocketFromFD(fd);
  var newsock = sock.sock_ops.accept(sock);
  if (addr) {
   var errno = writeSockaddr(addr, newsock.family, DNS.lookup_name(newsock.daddr), newsock.dport, addrlen);
   assert(!errno);
  }
  return newsock.stream.fd;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function inetNtop4(addr) {
 return (addr & 255) + "." + (addr >> 8 & 255) + "." + (addr >> 16 & 255) + "." + (addr >> 24 & 255);
}

function inetNtop6(ints) {
 var str = "";
 var word = 0;
 var longest = 0;
 var lastzero = 0;
 var zstart = 0;
 var len = 0;
 var i = 0;
 var parts = [ ints[0] & 65535, ints[0] >> 16, ints[1] & 65535, ints[1] >> 16, ints[2] & 65535, ints[2] >> 16, ints[3] & 65535, ints[3] >> 16 ];
 var hasipv4 = true;
 var v4part = "";
 for (i = 0; i < 5; i++) {
  if (parts[i] !== 0) {
   hasipv4 = false;
   break;
  }
 }
 if (hasipv4) {
  v4part = inetNtop4(parts[6] | parts[7] << 16);
  if (parts[5] === -1) {
   str = "::ffff:";
   str += v4part;
   return str;
  }
  if (parts[5] === 0) {
   str = "::";
   if (v4part === "0.0.0.0") v4part = "";
   if (v4part === "0.0.0.1") v4part = "1";
   str += v4part;
   return str;
  }
 }
 for (word = 0; word < 8; word++) {
  if (parts[word] === 0) {
   if (word - lastzero > 1) {
    len = 0;
   }
   lastzero = word;
   len++;
  }
  if (len > longest) {
   longest = len;
   zstart = word - longest + 1;
  }
 }
 for (word = 0; word < 8; word++) {
  if (longest > 1) {
   if (parts[word] === 0 && word >= zstart && word < zstart + longest) {
    if (word === zstart) {
     str += ":";
     if (zstart === 0) str += ":";
    }
    continue;
   }
  }
  str += Number(_ntohs(parts[word] & 65535)).toString(16);
  str += word < 7 ? ":" : "";
 }
 return str;
}

function readSockaddr(sa, salen) {
 var family = GROWABLE_HEAP_I16()[sa >> 1];
 var port = _ntohs(GROWABLE_HEAP_U16()[sa + 2 >> 1]);
 var addr;
 switch (family) {
 case 2:
  if (salen !== 16) {
   return {
    errno: 28
   };
  }
  addr = GROWABLE_HEAP_I32()[sa + 4 >> 2];
  addr = inetNtop4(addr);
  break;

 case 10:
  if (salen !== 28) {
   return {
    errno: 28
   };
  }
  addr = [ GROWABLE_HEAP_I32()[sa + 8 >> 2], GROWABLE_HEAP_I32()[sa + 12 >> 2], GROWABLE_HEAP_I32()[sa + 16 >> 2], GROWABLE_HEAP_I32()[sa + 20 >> 2] ];
  addr = inetNtop6(addr);
  break;

 default:
  return {
   errno: 5
  };
 }
 return {
  family: family,
  addr: addr,
  port: port
 };
}

function getSocketAddress(addrp, addrlen, allowNull) {
 if (allowNull && addrp === 0) return null;
 var info = readSockaddr(addrp, addrlen);
 if (info.errno) throw new FS.ErrnoError(info.errno);
 info.addr = DNS.lookup_addr(info.addr) || info.addr;
 return info;
}

function ___syscall_bind(fd, addr, addrlen) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(4, 1, fd, addr, addrlen);
 try {
  var sock = getSocketFromFD(fd);
  var info = getSocketAddress(addr, addrlen);
  sock.sock_ops.bind(sock, info.addr, info.port);
  return 0;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_connect(fd, addr, addrlen) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(5, 1, fd, addr, addrlen);
 try {
  var sock = getSocketFromFD(fd);
  var info = getSocketAddress(addr, addrlen);
  sock.sock_ops.connect(sock, info.addr, info.port);
  return 0;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_faccessat(dirfd, path, amode, flags) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(6, 1, dirfd, path, amode, flags);
 try {
  path = SYSCALLS.getStr(path);
  assert(flags === 0);
  path = SYSCALLS.calculateAt(dirfd, path);
  return SYSCALLS.doAccess(path, amode);
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_fcntl64(fd, cmd, varargs) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(7, 1, fd, cmd, varargs);
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD(fd);
  switch (cmd) {
  case 0:
   {
    var arg = SYSCALLS.get();
    if (arg < 0) {
     return -28;
    }
    var newStream;
    newStream = FS.open(stream.path, stream.flags, 0, arg);
    return newStream.fd;
   }

  case 1:
  case 2:
   return 0;

  case 3:
   return stream.flags;

  case 4:
   {
    var arg = SYSCALLS.get();
    stream.flags |= arg;
    return 0;
   }

  case 5:
   {
    var arg = SYSCALLS.get();
    var offset = 0;
    GROWABLE_HEAP_I16()[arg + offset >> 1] = 2;
    return 0;
   }

  case 6:
  case 7:
   return 0;

  case 16:
  case 8:
   return -28;

  case 9:
   setErrNo(28);
   return -1;

  default:
   {
    return -28;
   }
  }
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_fstat64(fd, buf) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(8, 1, fd, buf);
 try {
  var stream = SYSCALLS.getStreamFromFD(fd);
  return SYSCALLS.doStat(FS.stat, stream.path, buf);
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_fstatat64(dirfd, path, buf, flags) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(9, 1, dirfd, path, buf, flags);
 try {
  path = SYSCALLS.getStr(path);
  var nofollow = flags & 256;
  var allowEmpty = flags & 4096;
  flags = flags & ~4352;
  assert(!flags, flags);
  path = SYSCALLS.calculateAt(dirfd, path, allowEmpty);
  return SYSCALLS.doStat(nofollow ? FS.lstat : FS.stat, path, buf);
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_getdents64(fd, dirp, count) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(10, 1, fd, dirp, count);
 try {
  var stream = SYSCALLS.getStreamFromFD(fd);
  if (!stream.getdents) {
   stream.getdents = FS.readdir(stream.path);
  }
  var struct_size = 280;
  var pos = 0;
  var off = FS.llseek(stream, 0, 1);
  var idx = Math.floor(off / struct_size);
  while (idx < stream.getdents.length && pos + struct_size <= count) {
   var id;
   var type;
   var name = stream.getdents[idx];
   if (name === ".") {
    id = stream.node.id;
    type = 4;
   } else if (name === "..") {
    var lookup = FS.lookupPath(stream.path, {
     parent: true
    });
    id = lookup.node.id;
    type = 4;
   } else {
    var child = FS.lookupNode(stream.node, name);
    id = child.id;
    type = FS.isChrdev(child.mode) ? 2 : FS.isDir(child.mode) ? 4 : FS.isLink(child.mode) ? 10 : 8;
   }
   assert(id);
   tempI64 = [ id >>> 0, (tempDouble = id, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? (Math.min(+Math.floor(tempDouble / 4294967296), 4294967295) | 0) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0) ], 
   GROWABLE_HEAP_I32()[dirp + pos >> 2] = tempI64[0], GROWABLE_HEAP_I32()[dirp + pos + 4 >> 2] = tempI64[1];
   tempI64 = [ (idx + 1) * struct_size >>> 0, (tempDouble = (idx + 1) * struct_size, 
   +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? (Math.min(+Math.floor(tempDouble / 4294967296), 4294967295) | 0) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0) ], 
   GROWABLE_HEAP_I32()[dirp + pos + 8 >> 2] = tempI64[0], GROWABLE_HEAP_I32()[dirp + pos + 12 >> 2] = tempI64[1];
   GROWABLE_HEAP_I16()[dirp + pos + 16 >> 1] = 280;
   GROWABLE_HEAP_I8()[dirp + pos + 18 >> 0] = type;
   stringToUTF8(name, dirp + pos + 19, 256);
   pos += struct_size;
   idx += 1;
  }
  FS.llseek(stream, idx * struct_size, 0);
  return pos;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_getpeername(fd, addr, addrlen) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(11, 1, fd, addr, addrlen);
 try {
  var sock = getSocketFromFD(fd);
  if (!sock.daddr) {
   return -53;
  }
  var errno = writeSockaddr(addr, sock.family, DNS.lookup_name(sock.daddr), sock.dport, addrlen);
  assert(!errno);
  return 0;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_getsockname(fd, addr, addrlen) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(12, 1, fd, addr, addrlen);
 try {
  err("__syscall_getsockname " + fd);
  var sock = getSocketFromFD(fd);
  var errno = writeSockaddr(addr, sock.family, DNS.lookup_name(sock.saddr || "0.0.0.0"), sock.sport, addrlen);
  assert(!errno);
  return 0;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_getsockopt(fd, level, optname, optval, optlen) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(13, 1, fd, level, optname, optval, optlen);
 try {
  var sock = getSocketFromFD(fd);
  if (level === 1) {
   if (optname === 4) {
    GROWABLE_HEAP_I32()[optval >> 2] = sock.error;
    GROWABLE_HEAP_I32()[optlen >> 2] = 4;
    sock.error = null;
    return 0;
   }
  }
  return -50;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_ioctl(fd, op, varargs) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(14, 1, fd, op, varargs);
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD(fd);
  switch (op) {
  case 21509:
  case 21505:
   {
    if (!stream.tty) return -59;
    return 0;
   }

  case 21510:
  case 21511:
  case 21512:
  case 21506:
  case 21507:
  case 21508:
   {
    if (!stream.tty) return -59;
    return 0;
   }

  case 21519:
   {
    if (!stream.tty) return -59;
    var argp = SYSCALLS.get();
    GROWABLE_HEAP_I32()[argp >> 2] = 0;
    return 0;
   }

  case 21520:
   {
    if (!stream.tty) return -59;
    return -28;
   }

  case 21531:
   {
    var argp = SYSCALLS.get();
    return FS.ioctl(stream, op, argp);
   }

  case 21523:
   {
    if (!stream.tty) return -59;
    return 0;
   }

  case 21524:
   {
    if (!stream.tty) return -59;
    return 0;
   }

  default:
   abort("bad ioctl syscall " + op);
  }
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_listen(fd, backlog) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(15, 1, fd, backlog);
 try {
  var sock = getSocketFromFD(fd);
  sock.sock_ops.listen(sock, backlog);
  return 0;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_lstat64(path, buf) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(16, 1, path, buf);
 try {
  path = SYSCALLS.getStr(path);
  return SYSCALLS.doStat(FS.lstat, path, buf);
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_open(path, flags, varargs) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(17, 1, path, flags, varargs);
 SYSCALLS.varargs = varargs;
 try {
  var pathname = SYSCALLS.getStr(path);
  var mode = varargs ? SYSCALLS.get() : 0;
  var stream = FS.open(pathname, flags, mode);
  return stream.fd;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_poll(fds, nfds, timeout) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(18, 1, fds, nfds, timeout);
 try {
  var nonzero = 0;
  for (var i = 0; i < nfds; i++) {
   var pollfd = fds + 8 * i;
   var fd = GROWABLE_HEAP_I32()[pollfd >> 2];
   var events = GROWABLE_HEAP_I16()[pollfd + 4 >> 1];
   var mask = 32;
   var stream = FS.getStream(fd);
   if (stream) {
    mask = SYSCALLS.DEFAULT_POLLMASK;
    if (stream.stream_ops.poll) {
     mask = stream.stream_ops.poll(stream);
    }
   }
   mask &= events | 8 | 16;
   if (mask) nonzero++;
   GROWABLE_HEAP_I16()[pollfd + 6 >> 1] = mask;
  }
  return nonzero;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_recvfrom(fd, buf, len, flags, addr, addrlen) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(19, 1, fd, buf, len, flags, addr, addrlen);
 try {
  var sock = getSocketFromFD(fd);
  var msg = sock.sock_ops.recvmsg(sock, len);
  if (!msg) return 0;
  if (addr) {
   var errno = writeSockaddr(addr, sock.family, DNS.lookup_name(msg.addr), msg.port, addrlen);
   assert(!errno);
  }
  GROWABLE_HEAP_U8().set(msg.buffer, buf);
  return msg.buffer.byteLength;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_recvmsg(fd, message, flags) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(20, 1, fd, message, flags);
 try {
  var sock = getSocketFromFD(fd);
  var iov = GROWABLE_HEAP_I32()[message + 8 >> 2];
  var num = GROWABLE_HEAP_I32()[message + 12 >> 2];
  var total = 0;
  for (var i = 0; i < num; i++) {
   total += GROWABLE_HEAP_I32()[iov + (8 * i + 4) >> 2];
  }
  var msg = sock.sock_ops.recvmsg(sock, total);
  if (!msg) return 0;
  var name = GROWABLE_HEAP_I32()[message >> 2];
  if (name) {
   var errno = writeSockaddr(name, sock.family, DNS.lookup_name(msg.addr), msg.port);
   assert(!errno);
  }
  var bytesRead = 0;
  var bytesRemaining = msg.buffer.byteLength;
  for (var i = 0; bytesRemaining > 0 && i < num; i++) {
   var iovbase = GROWABLE_HEAP_I32()[iov + (8 * i + 0) >> 2];
   var iovlen = GROWABLE_HEAP_I32()[iov + (8 * i + 4) >> 2];
   if (!iovlen) {
    continue;
   }
   var length = Math.min(iovlen, bytesRemaining);
   var buf = msg.buffer.subarray(bytesRead, bytesRead + length);
   GROWABLE_HEAP_U8().set(buf, iovbase + bytesRead);
   bytesRead += length;
   bytesRemaining -= length;
  }
  return bytesRead;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_rename(old_path, new_path) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(21, 1, old_path, new_path);
 try {
  old_path = SYSCALLS.getStr(old_path);
  new_path = SYSCALLS.getStr(new_path);
  FS.rename(old_path, new_path);
  return 0;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_rmdir(path) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(22, 1, path);
 try {
  path = SYSCALLS.getStr(path);
  FS.rmdir(path);
  return 0;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_sendmsg(fd, message, flags) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(23, 1, fd, message, flags);
 try {
  var sock = getSocketFromFD(fd);
  var iov = GROWABLE_HEAP_I32()[message + 8 >> 2];
  var num = GROWABLE_HEAP_I32()[message + 12 >> 2];
  var addr, port;
  var name = GROWABLE_HEAP_I32()[message >> 2];
  var namelen = GROWABLE_HEAP_I32()[message + 4 >> 2];
  if (name) {
   var info = readSockaddr(name, namelen);
   if (info.errno) return -info.errno;
   port = info.port;
   addr = DNS.lookup_addr(info.addr) || info.addr;
  }
  var total = 0;
  for (var i = 0; i < num; i++) {
   total += GROWABLE_HEAP_I32()[iov + (8 * i + 4) >> 2];
  }
  var view = new Uint8Array(total);
  var offset = 0;
  for (var i = 0; i < num; i++) {
   var iovbase = GROWABLE_HEAP_I32()[iov + (8 * i + 0) >> 2];
   var iovlen = GROWABLE_HEAP_I32()[iov + (8 * i + 4) >> 2];
   for (var j = 0; j < iovlen; j++) {
    view[offset++] = GROWABLE_HEAP_I8()[iovbase + j >> 0];
   }
  }
  return sock.sock_ops.sendmsg(sock, view, 0, total, addr, port);
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_sendto(fd, message, length, flags, addr, addr_len) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(24, 1, fd, message, length, flags, addr, addr_len);
 try {
  var sock = getSocketFromFD(fd);
  var dest = getSocketAddress(addr, addr_len, true);
  if (!dest) {
   return FS.write(sock.stream, GROWABLE_HEAP_I8(), message, length);
  } else {
   return sock.sock_ops.sendmsg(sock, GROWABLE_HEAP_I8(), message, length, dest.addr, dest.port);
  }
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_socket(domain, type, protocol) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(25, 1, domain, type, protocol);
 try {
  var sock = SOCKFS.createSocket(domain, type, protocol);
  assert(sock.stream.fd < 64);
  return sock.stream.fd;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_stat64(path, buf) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(26, 1, path, buf);
 try {
  path = SYSCALLS.getStr(path);
  return SYSCALLS.doStat(FS.stat, path, buf);
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function ___syscall_unlink(path) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(27, 1, path);
 try {
  path = SYSCALLS.getStr(path);
  FS.unlink(path);
  return 0;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return -e.errno;
 }
}

function __dlopen_js(filename, flag) {
 abort("To use dlopen, you need to use Emscripten's linking support, see https://github.com/emscripten-core/emscripten/wiki/Linking");
}

function __dlsym_js(handle, symbol) {
 abort("To use dlopen, you need to use Emscripten's linking support, see https://github.com/emscripten-core/emscripten/wiki/Linking");
}

function __emscripten_default_pthread_stack_size() {
 return 2097152;
}

function __emscripten_fetch_free(id) {
 delete Fetch.xhrs[id - 1];
}

function __emscripten_notify_thread_queue(targetThreadId, mainThreadId) {
 if (targetThreadId == mainThreadId) {
  postMessage({
   "cmd": "processQueuedMainThreadWork"
  });
 } else if (ENVIRONMENT_IS_PTHREAD) {
  postMessage({
   "targetThread": targetThreadId,
   "cmd": "processThreadQueue"
  });
 } else {
  var pthread = PThread.pthreads[targetThreadId];
  var worker = pthread && pthread.worker;
  if (!worker) {
   err("Cannot send message to thread with ID " + targetThreadId + ", unknown thread ID!");
   return;
  }
  worker.postMessage({
   "cmd": "processThreadQueue"
  });
 }
 return 1;
}

function __gmtime_js(time, tmPtr) {
 var date = new Date(GROWABLE_HEAP_I32()[time >> 2] * 1e3);
 GROWABLE_HEAP_I32()[tmPtr >> 2] = date.getUTCSeconds();
 GROWABLE_HEAP_I32()[tmPtr + 4 >> 2] = date.getUTCMinutes();
 GROWABLE_HEAP_I32()[tmPtr + 8 >> 2] = date.getUTCHours();
 GROWABLE_HEAP_I32()[tmPtr + 12 >> 2] = date.getUTCDate();
 GROWABLE_HEAP_I32()[tmPtr + 16 >> 2] = date.getUTCMonth();
 GROWABLE_HEAP_I32()[tmPtr + 20 >> 2] = date.getUTCFullYear() - 1900;
 GROWABLE_HEAP_I32()[tmPtr + 24 >> 2] = date.getUTCDay();
 var start = Date.UTC(date.getUTCFullYear(), 0, 1, 0, 0, 0, 0);
 var yday = (date.getTime() - start) / (1e3 * 60 * 60 * 24) | 0;
 GROWABLE_HEAP_I32()[tmPtr + 28 >> 2] = yday;
}

function __localtime_js(time, tmPtr) {
 var date = new Date(GROWABLE_HEAP_I32()[time >> 2] * 1e3);
 GROWABLE_HEAP_I32()[tmPtr >> 2] = date.getSeconds();
 GROWABLE_HEAP_I32()[tmPtr + 4 >> 2] = date.getMinutes();
 GROWABLE_HEAP_I32()[tmPtr + 8 >> 2] = date.getHours();
 GROWABLE_HEAP_I32()[tmPtr + 12 >> 2] = date.getDate();
 GROWABLE_HEAP_I32()[tmPtr + 16 >> 2] = date.getMonth();
 GROWABLE_HEAP_I32()[tmPtr + 20 >> 2] = date.getFullYear() - 1900;
 GROWABLE_HEAP_I32()[tmPtr + 24 >> 2] = date.getDay();
 var start = new Date(date.getFullYear(), 0, 1);
 var yday = (date.getTime() - start.getTime()) / (1e3 * 60 * 60 * 24) | 0;
 GROWABLE_HEAP_I32()[tmPtr + 28 >> 2] = yday;
 GROWABLE_HEAP_I32()[tmPtr + 36 >> 2] = -(date.getTimezoneOffset() * 60);
 var summerOffset = new Date(date.getFullYear(), 6, 1).getTimezoneOffset();
 var winterOffset = start.getTimezoneOffset();
 var dst = (summerOffset != winterOffset && date.getTimezoneOffset() == Math.min(winterOffset, summerOffset)) | 0;
 GROWABLE_HEAP_I32()[tmPtr + 32 >> 2] = dst;
}

function __mktime_js(tmPtr) {
 var date = new Date(GROWABLE_HEAP_I32()[tmPtr + 20 >> 2] + 1900, GROWABLE_HEAP_I32()[tmPtr + 16 >> 2], GROWABLE_HEAP_I32()[tmPtr + 12 >> 2], GROWABLE_HEAP_I32()[tmPtr + 8 >> 2], GROWABLE_HEAP_I32()[tmPtr + 4 >> 2], GROWABLE_HEAP_I32()[tmPtr >> 2], 0);
 var dst = GROWABLE_HEAP_I32()[tmPtr + 32 >> 2];
 var guessedOffset = date.getTimezoneOffset();
 var start = new Date(date.getFullYear(), 0, 1);
 var summerOffset = new Date(date.getFullYear(), 6, 1).getTimezoneOffset();
 var winterOffset = start.getTimezoneOffset();
 var dstOffset = Math.min(winterOffset, summerOffset);
 if (dst < 0) {
  GROWABLE_HEAP_I32()[tmPtr + 32 >> 2] = Number(summerOffset != winterOffset && dstOffset == guessedOffset);
 } else if (dst > 0 != (dstOffset == guessedOffset)) {
  var nonDstOffset = Math.max(winterOffset, summerOffset);
  var trueOffset = dst > 0 ? dstOffset : nonDstOffset;
  date.setTime(date.getTime() + (trueOffset - guessedOffset) * 6e4);
 }
 GROWABLE_HEAP_I32()[tmPtr + 24 >> 2] = date.getDay();
 var yday = (date.getTime() - start.getTime()) / (1e3 * 60 * 60 * 24) | 0;
 GROWABLE_HEAP_I32()[tmPtr + 28 >> 2] = yday;
 GROWABLE_HEAP_I32()[tmPtr >> 2] = date.getSeconds();
 GROWABLE_HEAP_I32()[tmPtr + 4 >> 2] = date.getMinutes();
 GROWABLE_HEAP_I32()[tmPtr + 8 >> 2] = date.getHours();
 GROWABLE_HEAP_I32()[tmPtr + 12 >> 2] = date.getDate();
 GROWABLE_HEAP_I32()[tmPtr + 16 >> 2] = date.getMonth();
 return date.getTime() / 1e3 | 0;
}

function _tzset_impl(timezone, daylight, tzname) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(28, 1, timezone, daylight, tzname);
 var currentYear = new Date().getFullYear();
 var winter = new Date(currentYear, 0, 1);
 var summer = new Date(currentYear, 6, 1);
 var winterOffset = winter.getTimezoneOffset();
 var summerOffset = summer.getTimezoneOffset();
 var stdTimezoneOffset = Math.max(winterOffset, summerOffset);
 GROWABLE_HEAP_I32()[timezone >> 2] = stdTimezoneOffset * 60;
 GROWABLE_HEAP_I32()[daylight >> 2] = Number(winterOffset != summerOffset);
 function extractZone(date) {
  var match = date.toTimeString().match(/\(([A-Za-z ]+)\)$/);
  return match ? match[1] : "GMT";
 }
 var winterName = extractZone(winter);
 var summerName = extractZone(summer);
 var winterNamePtr = allocateUTF8(winterName);
 var summerNamePtr = allocateUTF8(summerName);
 if (summerOffset < winterOffset) {
  GROWABLE_HEAP_I32()[tzname >> 2] = winterNamePtr;
  GROWABLE_HEAP_I32()[tzname + 4 >> 2] = summerNamePtr;
 } else {
  GROWABLE_HEAP_I32()[tzname >> 2] = summerNamePtr;
  GROWABLE_HEAP_I32()[tzname + 4 >> 2] = winterNamePtr;
 }
}

function __tzset_js(timezone, daylight, tzname) {
 if (__tzset_js.called) return;
 __tzset_js.called = true;
 _tzset_impl(timezone, daylight, tzname);
}

function _abort() {
 abort("native code called abort()");
}

function _clock() {
 if (_clock.start === undefined) _clock.start = Date.now();
 return (Date.now() - _clock.start) * (1e6 / 1e3) | 0;
}

var readAsmConstArgsArray = [];

function readAsmConstArgs(sigPtr, buf) {
 assert(Array.isArray(readAsmConstArgsArray));
 assert(buf % 16 == 0);
 readAsmConstArgsArray.length = 0;
 var ch;
 buf >>= 2;
 while (ch = GROWABLE_HEAP_U8()[sigPtr++]) {
  assert(ch === 100 || ch === 102 || ch === 105, "Invalid character " + ch + '("' + String.fromCharCode(ch) + '") in readAsmConstArgs! Use only "d", "f" or "i", and do not specify "v" for void return argument.');
  var readAsmConstArgsDouble = ch < 105;
  if (readAsmConstArgsDouble && buf & 1) buf++;
  readAsmConstArgsArray.push(readAsmConstArgsDouble ? GROWABLE_HEAP_F64()[buf++ >> 1] : GROWABLE_HEAP_I32()[buf]);
  ++buf;
 }
 return readAsmConstArgsArray;
}

function mainThreadEM_ASM(code, sigPtr, argbuf, sync) {
 var args = readAsmConstArgs(sigPtr, argbuf);
 if (ENVIRONMENT_IS_PTHREAD) {
  return _emscripten_proxy_to_main_thread_js.apply(null, [ -1 - code, sync ].concat(args));
 }
 if (!ASM_CONSTS.hasOwnProperty(code)) abort("No EM_ASM constant found at address " + code);
 return ASM_CONSTS[code].apply(null, args);
}

function _emscripten_asm_const_int_sync_on_main_thread(code, sigPtr, argbuf) {
 return mainThreadEM_ASM(code, sigPtr, argbuf, 1);
}

function _emscripten_check_blocking_allowed() {
 if (ENVIRONMENT_IS_NODE) return;
 if (ENVIRONMENT_IS_WORKER) return;
 warnOnce("Blocking on the main thread is very dangerous, see https://emscripten.org/docs/porting/pthreads.html#blocking-on-the-main-browser-thread");
}

function _emscripten_console_error(str) {
 assert(typeof str == "number");
 console.error(UTF8ToString(str));
}

function _emscripten_get_heap_max() {
 return 2147483648;
}

function _emscripten_memcpy_big(dest, src, num) {
 GROWABLE_HEAP_U8().copyWithin(dest, src, src + num);
}

function _emscripten_num_logical_cores() {
 if (ENVIRONMENT_IS_NODE) return require("os").cpus().length;
 return navigator["hardwareConcurrency"];
}

function _emscripten_proxy_to_main_thread_js(index, sync) {
 var numCallArgs = arguments.length - 2;
 var outerArgs = arguments;
 if (numCallArgs > 20 - 1) throw "emscripten_proxy_to_main_thread_js: Too many arguments " + numCallArgs + " to proxied function idx=" + index + ", maximum supported is " + (20 - 1) + "!";
 return withStackSave(function() {
  var serializedNumCallArgs = numCallArgs;
  var args = stackAlloc(serializedNumCallArgs * 8);
  var b = args >> 3;
  for (var i = 0; i < numCallArgs; i++) {
   var arg = outerArgs[2 + i];
   GROWABLE_HEAP_F64()[b + i] = arg;
  }
  return _emscripten_run_in_main_runtime_thread_js(index, serializedNumCallArgs, args, sync);
 });
}

var _emscripten_receive_on_main_thread_js_callArgs = [];

function _emscripten_receive_on_main_thread_js(index, numCallArgs, args) {
 _emscripten_receive_on_main_thread_js_callArgs.length = numCallArgs;
 var b = args >> 3;
 for (var i = 0; i < numCallArgs; i++) {
  _emscripten_receive_on_main_thread_js_callArgs[i] = GROWABLE_HEAP_F64()[b + i];
 }
 var isEmAsmConst = index < 0;
 var func = !isEmAsmConst ? proxiedFunctionTable[index] : ASM_CONSTS[-index - 1];
 assert(func.length == numCallArgs, "Call args mismatch in emscripten_receive_on_main_thread_js");
 return func.apply(null, _emscripten_receive_on_main_thread_js_callArgs);
}

function emscripten_realloc_buffer(size) {
 try {
  wasmMemory.grow(size - buffer.byteLength + 65535 >>> 16);
  updateGlobalBufferAndViews(wasmMemory.buffer);
  return 1;
 } catch (e) {
  err("emscripten_realloc_buffer: Attempted to grow heap from " + buffer.byteLength + " bytes to " + size + " bytes, but got error: " + e);
 }
}

function _emscripten_resize_heap(requestedSize) {
 var oldSize = GROWABLE_HEAP_U8().length;
 requestedSize = requestedSize >>> 0;
 if (requestedSize <= oldSize) {
  return false;
 }
 var maxHeapSize = _emscripten_get_heap_max();
 if (requestedSize > maxHeapSize) {
  err("Cannot enlarge memory, asked to go up to " + requestedSize + " bytes, but the limit is " + maxHeapSize + " bytes!");
  return false;
 }
 let alignUp = (x, multiple) => x + (multiple - x % multiple) % multiple;
 for (var cutDown = 1; cutDown <= 4; cutDown *= 2) {
  var overGrownHeapSize = oldSize * (1 + .2 / cutDown);
  overGrownHeapSize = Math.min(overGrownHeapSize, requestedSize + 100663296);
  var newSize = Math.min(maxHeapSize, alignUp(Math.max(requestedSize, overGrownHeapSize), 65536));
  var replacement = emscripten_realloc_buffer(newSize);
  if (replacement) {
   return true;
  }
 }
 err("Failed to grow the heap from " + oldSize + " bytes to " + newSize + " bytes, not enough memory!");
 return false;
}

var JSEvents = {
 inEventHandler: 0,
 removeAllEventListeners: function() {
  for (var i = JSEvents.eventHandlers.length - 1; i >= 0; --i) {
   JSEvents._removeHandler(i);
  }
  JSEvents.eventHandlers = [];
  JSEvents.deferredCalls = [];
 },
 registerRemoveEventListeners: function() {
  if (!JSEvents.removeEventListenersRegistered) {
   __ATEXIT__.push(JSEvents.removeAllEventListeners);
   JSEvents.removeEventListenersRegistered = true;
  }
 },
 deferredCalls: [],
 deferCall: function(targetFunction, precedence, argsList) {
  function arraysHaveEqualContent(arrA, arrB) {
   if (arrA.length != arrB.length) return false;
   for (var i in arrA) {
    if (arrA[i] != arrB[i]) return false;
   }
   return true;
  }
  for (var i in JSEvents.deferredCalls) {
   var call = JSEvents.deferredCalls[i];
   if (call.targetFunction == targetFunction && arraysHaveEqualContent(call.argsList, argsList)) {
    return;
   }
  }
  JSEvents.deferredCalls.push({
   targetFunction: targetFunction,
   precedence: precedence,
   argsList: argsList
  });
  JSEvents.deferredCalls.sort(function(x, y) {
   return x.precedence < y.precedence;
  });
 },
 removeDeferredCalls: function(targetFunction) {
  for (var i = 0; i < JSEvents.deferredCalls.length; ++i) {
   if (JSEvents.deferredCalls[i].targetFunction == targetFunction) {
    JSEvents.deferredCalls.splice(i, 1);
    --i;
   }
  }
 },
 canPerformEventHandlerRequests: function() {
  return JSEvents.inEventHandler && JSEvents.currentEventHandler.allowsDeferredCalls;
 },
 runDeferredCalls: function() {
  if (!JSEvents.canPerformEventHandlerRequests()) {
   return;
  }
  for (var i = 0; i < JSEvents.deferredCalls.length; ++i) {
   var call = JSEvents.deferredCalls[i];
   JSEvents.deferredCalls.splice(i, 1);
   --i;
   call.targetFunction.apply(null, call.argsList);
  }
 },
 eventHandlers: [],
 removeAllHandlersOnTarget: function(target, eventTypeString) {
  for (var i = 0; i < JSEvents.eventHandlers.length; ++i) {
   if (JSEvents.eventHandlers[i].target == target && (!eventTypeString || eventTypeString == JSEvents.eventHandlers[i].eventTypeString)) {
    JSEvents._removeHandler(i--);
   }
  }
 },
 _removeHandler: function(i) {
  var h = JSEvents.eventHandlers[i];
  h.target.removeEventListener(h.eventTypeString, h.eventListenerFunc, h.useCapture);
  JSEvents.eventHandlers.splice(i, 1);
 },
 registerOrRemoveHandler: function(eventHandler) {
  var jsEventHandler = function jsEventHandler(event) {
   ++JSEvents.inEventHandler;
   JSEvents.currentEventHandler = eventHandler;
   JSEvents.runDeferredCalls();
   eventHandler.handlerFunc(event);
   JSEvents.runDeferredCalls();
   --JSEvents.inEventHandler;
  };
  if (eventHandler.callbackfunc) {
   eventHandler.eventListenerFunc = jsEventHandler;
   eventHandler.target.addEventListener(eventHandler.eventTypeString, jsEventHandler, eventHandler.useCapture);
   JSEvents.eventHandlers.push(eventHandler);
   JSEvents.registerRemoveEventListeners();
  } else {
   for (var i = 0; i < JSEvents.eventHandlers.length; ++i) {
    if (JSEvents.eventHandlers[i].target == eventHandler.target && JSEvents.eventHandlers[i].eventTypeString == eventHandler.eventTypeString) {
     JSEvents._removeHandler(i--);
    }
   }
  }
 },
 queueEventHandlerOnThread_iiii: function(targetThread, eventHandlerFunc, eventTypeId, eventData, userData) {
  withStackSave(function() {
   var varargs = stackAlloc(12);
   GROWABLE_HEAP_I32()[varargs >> 2] = eventTypeId;
   GROWABLE_HEAP_I32()[varargs + 4 >> 2] = eventData;
   GROWABLE_HEAP_I32()[varargs + 8 >> 2] = userData;
   _emscripten_dispatch_to_thread_(targetThread, 637534208, eventHandlerFunc, eventData, varargs);
  });
 },
 getTargetThreadForEventCallback: function(targetThread) {
  switch (targetThread) {
  case 1:
   return 0;

  case 2:
   return PThread.currentProxiedOperationCallerThread;

  default:
   return targetThread;
  }
 },
 getNodeNameForTarget: function(target) {
  if (!target) return "";
  if (target == window) return "#window";
  if (target == screen) return "#screen";
  return target && target.nodeName ? target.nodeName : "";
 },
 fullscreenEnabled: function() {
  return document.fullscreenEnabled || document.webkitFullscreenEnabled;
 }
};

function stringToNewUTF8(jsString) {
 var length = lengthBytesUTF8(jsString) + 1;
 var cString = _malloc(length);
 stringToUTF8(jsString, cString, length);
 return cString;
}

function _emscripten_set_offscreencanvas_size_on_target_thread_js(targetThread, targetCanvas, width, height) {
 withStackSave(function() {
  var varargs = stackAlloc(12);
  var targetCanvasPtr = 0;
  if (targetCanvas) {
   targetCanvasPtr = stringToNewUTF8(targetCanvas);
  }
  GROWABLE_HEAP_I32()[varargs >> 2] = targetCanvasPtr;
  GROWABLE_HEAP_I32()[varargs + 4 >> 2] = width;
  GROWABLE_HEAP_I32()[varargs + 8 >> 2] = height;
  _emscripten_dispatch_to_thread_(targetThread, 657457152, 0, targetCanvasPtr, varargs);
 });
}

function _emscripten_set_offscreencanvas_size_on_target_thread(targetThread, targetCanvas, width, height) {
 targetCanvas = targetCanvas ? UTF8ToString(targetCanvas) : "";
 _emscripten_set_offscreencanvas_size_on_target_thread_js(targetThread, targetCanvas, width, height);
}

function maybeCStringToJsString(cString) {
 return cString > 2 ? UTF8ToString(cString) : cString;
}

var specialHTMLTargets = [ 0, typeof document != "undefined" ? document : 0, typeof window != "undefined" ? window : 0 ];

function findEventTarget(target) {
 target = maybeCStringToJsString(target);
 var domElement = specialHTMLTargets[target] || (typeof document != "undefined" ? document.querySelector(target) : undefined);
 return domElement;
}

function findCanvasEventTarget(target) {
 return findEventTarget(target);
}

function _emscripten_set_canvas_element_size_calling_thread(target, width, height) {
 var canvas = findCanvasEventTarget(target);
 if (!canvas) return -4;
 if (canvas.canvasSharedPtr) {
  GROWABLE_HEAP_I32()[canvas.canvasSharedPtr >> 2] = width;
  GROWABLE_HEAP_I32()[canvas.canvasSharedPtr + 4 >> 2] = height;
 }
 if (canvas.offscreenCanvas || !canvas.controlTransferredOffscreen) {
  if (canvas.offscreenCanvas) canvas = canvas.offscreenCanvas;
  var autoResizeViewport = false;
  if (canvas.GLctxObject && canvas.GLctxObject.GLctx) {
   var prevViewport = canvas.GLctxObject.GLctx.getParameter(2978);
   autoResizeViewport = prevViewport[0] === 0 && prevViewport[1] === 0 && prevViewport[2] === canvas.width && prevViewport[3] === canvas.height;
  }
  canvas.width = width;
  canvas.height = height;
  if (autoResizeViewport) {
   canvas.GLctxObject.GLctx.viewport(0, 0, width, height);
  }
 } else if (canvas.canvasSharedPtr) {
  var targetThread = GROWABLE_HEAP_I32()[canvas.canvasSharedPtr + 8 >> 2];
  _emscripten_set_offscreencanvas_size_on_target_thread(targetThread, target, width, height);
  return 1;
 } else {
  return -4;
 }
 return 0;
}

function _emscripten_set_canvas_element_size_main_thread(target, width, height) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(29, 1, target, width, height);
 return _emscripten_set_canvas_element_size_calling_thread(target, width, height);
}

function _emscripten_set_canvas_element_size(target, width, height) {
 var canvas = findCanvasEventTarget(target);
 if (canvas) {
  return _emscripten_set_canvas_element_size_calling_thread(target, width, height);
 } else {
  return _emscripten_set_canvas_element_size_main_thread(target, width, height);
 }
}

function _emscripten_sleep() {
 throw "Please compile your program with async support in order to use asynchronous operations like emscripten_sleep";
}

var Fetch = {
 xhrs: [],
 setu64: function(addr, val) {
  GROWABLE_HEAP_U32()[addr >> 2] = val;
  GROWABLE_HEAP_U32()[addr + 4 >> 2] = val / 4294967296 | 0;
 },
 openDatabase: function(dbname, dbversion, onsuccess, onerror) {
  try {
   var openRequest = indexedDB.open(dbname, dbversion);
  } catch (e) {
   return onerror(e);
  }
  openRequest.onupgradeneeded = (event => {
   var db = event.target.result;
   if (db.objectStoreNames.contains("FILES")) {
    db.deleteObjectStore("FILES");
   }
   db.createObjectStore("FILES");
  });
  openRequest.onsuccess = (event => onsuccess(event.target.result));
  openRequest.onerror = (error => onerror(error));
 },
 staticInit: function() {
  var isMainThread = true;
  var onsuccess = db => {
   Fetch.dbInstance = db;
   if (isMainThread) {
    removeRunDependency("library_fetch_init");
   }
  };
  var onerror = () => {
   Fetch.dbInstance = false;
   if (isMainThread) {
    removeRunDependency("library_fetch_init");
   }
  };
  Fetch.openDatabase("emscripten_filesystem", 1, onsuccess, onerror);
  if (typeof ENVIRONMENT_IS_FETCH_WORKER == "undefined" || !ENVIRONMENT_IS_FETCH_WORKER) addRunDependency("library_fetch_init");
 }
};

function fetchXHR(fetch, onsuccess, onerror, onprogress, onreadystatechange) {
 var url = GROWABLE_HEAP_U32()[fetch + 8 >> 2];
 if (!url) {
  onerror(fetch, 0, "no url specified!");
  return;
 }
 var url_ = UTF8ToString(url);
 var fetch_attr = fetch + 112;
 var requestMethod = UTF8ToString(fetch_attr);
 if (!requestMethod) requestMethod = "GET";
 var userData = GROWABLE_HEAP_U32()[fetch + 4 >> 2];
 var fetchAttributes = GROWABLE_HEAP_U32()[fetch_attr + 52 >> 2];
 var timeoutMsecs = GROWABLE_HEAP_U32()[fetch_attr + 56 >> 2];
 var withCredentials = !!GROWABLE_HEAP_U32()[fetch_attr + 60 >> 2];
 var destinationPath = GROWABLE_HEAP_U32()[fetch_attr + 64 >> 2];
 var userName = GROWABLE_HEAP_U32()[fetch_attr + 68 >> 2];
 var password = GROWABLE_HEAP_U32()[fetch_attr + 72 >> 2];
 var requestHeaders = GROWABLE_HEAP_U32()[fetch_attr + 76 >> 2];
 var overriddenMimeType = GROWABLE_HEAP_U32()[fetch_attr + 80 >> 2];
 var dataPtr = GROWABLE_HEAP_U32()[fetch_attr + 84 >> 2];
 var dataLength = GROWABLE_HEAP_U32()[fetch_attr + 88 >> 2];
 var fetchAttrLoadToMemory = !!(fetchAttributes & 1);
 var fetchAttrStreamData = !!(fetchAttributes & 2);
 var fetchAttrPersistFile = !!(fetchAttributes & 4);
 var fetchAttrAppend = !!(fetchAttributes & 8);
 var fetchAttrReplace = !!(fetchAttributes & 16);
 var fetchAttrSynchronous = !!(fetchAttributes & 64);
 var fetchAttrWaitable = !!(fetchAttributes & 128);
 var userNameStr = userName ? UTF8ToString(userName) : undefined;
 var passwordStr = password ? UTF8ToString(password) : undefined;
 var xhr = new XMLHttpRequest();
 xhr.withCredentials = withCredentials;
 xhr.open(requestMethod, url_, !fetchAttrSynchronous, userNameStr, passwordStr);
 if (!fetchAttrSynchronous) xhr.timeout = timeoutMsecs;
 xhr.url_ = url_;
 assert(!fetchAttrStreamData, "streaming uses moz-chunked-arraybuffer which is no longer supported; TODO: rewrite using fetch()");
 xhr.responseType = "arraybuffer";
 if (overriddenMimeType) {
  var overriddenMimeTypeStr = UTF8ToString(overriddenMimeType);
  xhr.overrideMimeType(overriddenMimeTypeStr);
 }
 if (requestHeaders) {
  for (;;) {
   var key = GROWABLE_HEAP_U32()[requestHeaders >> 2];
   if (!key) break;
   var value = GROWABLE_HEAP_U32()[requestHeaders + 4 >> 2];
   if (!value) break;
   requestHeaders += 8;
   var keyStr = UTF8ToString(key);
   var valueStr = UTF8ToString(value);
   xhr.setRequestHeader(keyStr, valueStr);
  }
 }
 Fetch.xhrs.push(xhr);
 var id = Fetch.xhrs.length;
 GROWABLE_HEAP_U32()[fetch + 0 >> 2] = id;
 var data = dataPtr && dataLength ? GROWABLE_HEAP_U8().slice(dataPtr, dataPtr + dataLength) : null;
 function saveResponse(condition) {
  var ptr = 0;
  var ptrLen = 0;
  if (condition) {
   ptrLen = xhr.response ? xhr.response.byteLength : 0;
   ptr = _malloc(ptrLen);
   GROWABLE_HEAP_U8().set(new Uint8Array(xhr.response), ptr);
  }
  GROWABLE_HEAP_U32()[fetch + 12 >> 2] = ptr;
  Fetch.setu64(fetch + 16, ptrLen);
 }
 xhr.onload = (e => {
  saveResponse(fetchAttrLoadToMemory && !fetchAttrStreamData);
  var len = xhr.response ? xhr.response.byteLength : 0;
  Fetch.setu64(fetch + 24, 0);
  if (len) {
   Fetch.setu64(fetch + 32, len);
  }
  GROWABLE_HEAP_U16()[fetch + 40 >> 1] = xhr.readyState;
  GROWABLE_HEAP_U16()[fetch + 42 >> 1] = xhr.status;
  if (xhr.statusText) stringToUTF8(xhr.statusText, fetch + 44, 64);
  if (xhr.status >= 200 && xhr.status < 300) {
   if (onsuccess) onsuccess(fetch, xhr, e);
  } else {
   if (onerror) onerror(fetch, xhr, e);
  }
 });
 xhr.onerror = (e => {
  saveResponse(fetchAttrLoadToMemory);
  var status = xhr.status;
  Fetch.setu64(fetch + 24, 0);
  Fetch.setu64(fetch + 32, xhr.response ? xhr.response.byteLength : 0);
  GROWABLE_HEAP_U16()[fetch + 40 >> 1] = xhr.readyState;
  GROWABLE_HEAP_U16()[fetch + 42 >> 1] = status;
  if (onerror) onerror(fetch, xhr, e);
 });
 xhr.ontimeout = (e => {
  if (onerror) onerror(fetch, xhr, e);
 });
 xhr.onprogress = (e => {
  var ptrLen = fetchAttrLoadToMemory && fetchAttrStreamData && xhr.response ? xhr.response.byteLength : 0;
  var ptr = 0;
  if (fetchAttrLoadToMemory && fetchAttrStreamData) {
   assert(onprogress, "When doing a streaming fetch, you should have an onprogress handler registered to receive the chunks!");
   ptr = _malloc(ptrLen);
   GROWABLE_HEAP_U8().set(new Uint8Array(xhr.response), ptr);
  }
  GROWABLE_HEAP_U32()[fetch + 12 >> 2] = ptr;
  Fetch.setu64(fetch + 16, ptrLen);
  Fetch.setu64(fetch + 24, e.loaded - ptrLen);
  Fetch.setu64(fetch + 32, e.total);
  GROWABLE_HEAP_U16()[fetch + 40 >> 1] = xhr.readyState;
  if (xhr.readyState >= 3 && xhr.status === 0 && e.loaded > 0) xhr.status = 200;
  GROWABLE_HEAP_U16()[fetch + 42 >> 1] = xhr.status;
  if (xhr.statusText) stringToUTF8(xhr.statusText, fetch + 44, 64);
  if (onprogress) onprogress(fetch, xhr, e);
  if (ptr) {
   _free(ptr);
  }
 });
 xhr.onreadystatechange = (e => {
  GROWABLE_HEAP_U16()[fetch + 40 >> 1] = xhr.readyState;
  if (xhr.readyState >= 2) {
   GROWABLE_HEAP_U16()[fetch + 42 >> 1] = xhr.status;
  }
  if (onreadystatechange) onreadystatechange(fetch, xhr, e);
 });
 try {
  xhr.send(data);
 } catch (e) {
  if (onerror) onerror(fetch, xhr, e);
 }
}

function maybeExit() {
 if (!keepRuntimeAlive()) {
  try {
   if (ENVIRONMENT_IS_PTHREAD) __emscripten_thread_exit(EXITSTATUS); else _exit(EXITSTATUS);
  } catch (e) {
   handleException(e);
  }
 }
}

function callUserCallback(func, synchronous) {
 if (runtimeExited || ABORT) {
  err("user callback triggered after runtime exited or application aborted.  Ignoring.");
  return;
 }
 if (synchronous) {
  func();
  return;
 }
 try {
  func();
  if (ENVIRONMENT_IS_PTHREAD) maybeExit();
 } catch (e) {
  handleException(e);
 }
}

function runtimeKeepalivePush() {
 runtimeKeepaliveCounter += 1;
}

function runtimeKeepalivePop() {
 assert(runtimeKeepaliveCounter > 0);
 runtimeKeepaliveCounter -= 1;
}

function fetchCacheData(db, fetch, data, onsuccess, onerror) {
 if (!db) {
  onerror(fetch, 0, "IndexedDB not available!");
  return;
 }
 var fetch_attr = fetch + 112;
 var destinationPath = GROWABLE_HEAP_U32()[fetch_attr + 64 >> 2];
 if (!destinationPath) destinationPath = GROWABLE_HEAP_U32()[fetch + 8 >> 2];
 var destinationPathStr = UTF8ToString(destinationPath);
 try {
  var transaction = db.transaction([ "FILES" ], "readwrite");
  var packages = transaction.objectStore("FILES");
  var putRequest = packages.put(data, destinationPathStr);
  putRequest.onsuccess = (event => {
   GROWABLE_HEAP_U16()[fetch + 40 >> 1] = 4;
   GROWABLE_HEAP_U16()[fetch + 42 >> 1] = 200;
   stringToUTF8("OK", fetch + 44, 64);
   onsuccess(fetch, 0, destinationPathStr);
  });
  putRequest.onerror = (error => {
   GROWABLE_HEAP_U16()[fetch + 40 >> 1] = 4;
   GROWABLE_HEAP_U16()[fetch + 42 >> 1] = 413;
   stringToUTF8("Payload Too Large", fetch + 44, 64);
   onerror(fetch, 0, error);
  });
 } catch (e) {
  onerror(fetch, 0, e);
 }
}

function fetchLoadCachedData(db, fetch, onsuccess, onerror) {
 if (!db) {
  onerror(fetch, 0, "IndexedDB not available!");
  return;
 }
 var fetch_attr = fetch + 112;
 var path = GROWABLE_HEAP_U32()[fetch_attr + 64 >> 2];
 if (!path) path = GROWABLE_HEAP_U32()[fetch + 8 >> 2];
 var pathStr = UTF8ToString(path);
 try {
  var transaction = db.transaction([ "FILES" ], "readonly");
  var packages = transaction.objectStore("FILES");
  var getRequest = packages.get(pathStr);
  getRequest.onsuccess = (event => {
   if (event.target.result) {
    var value = event.target.result;
    var len = value.byteLength || value.length;
    var ptr = _malloc(len);
    GROWABLE_HEAP_U8().set(new Uint8Array(value), ptr);
    GROWABLE_HEAP_U32()[fetch + 12 >> 2] = ptr;
    Fetch.setu64(fetch + 16, len);
    Fetch.setu64(fetch + 24, 0);
    Fetch.setu64(fetch + 32, len);
    GROWABLE_HEAP_U16()[fetch + 40 >> 1] = 4;
    GROWABLE_HEAP_U16()[fetch + 42 >> 1] = 200;
    stringToUTF8("OK", fetch + 44, 64);
    onsuccess(fetch, 0, value);
   } else {
    GROWABLE_HEAP_U16()[fetch + 40 >> 1] = 4;
    GROWABLE_HEAP_U16()[fetch + 42 >> 1] = 404;
    stringToUTF8("Not Found", fetch + 44, 64);
    onerror(fetch, 0, "no data");
   }
  });
  getRequest.onerror = (error => {
   GROWABLE_HEAP_U16()[fetch + 40 >> 1] = 4;
   GROWABLE_HEAP_U16()[fetch + 42 >> 1] = 404;
   stringToUTF8("Not Found", fetch + 44, 64);
   onerror(fetch, 0, error);
  });
 } catch (e) {
  onerror(fetch, 0, e);
 }
}

function fetchDeleteCachedData(db, fetch, onsuccess, onerror) {
 if (!db) {
  onerror(fetch, 0, "IndexedDB not available!");
  return;
 }
 var fetch_attr = fetch + 112;
 var path = GROWABLE_HEAP_U32()[fetch_attr + 64 >> 2];
 if (!path) path = GROWABLE_HEAP_U32()[fetch + 8 >> 2];
 var pathStr = UTF8ToString(path);
 try {
  var transaction = db.transaction([ "FILES" ], "readwrite");
  var packages = transaction.objectStore("FILES");
  var request = packages.delete(pathStr);
  request.onsuccess = (event => {
   var value = event.target.result;
   GROWABLE_HEAP_U32()[fetch + 12 >> 2] = 0;
   Fetch.setu64(fetch + 16, 0);
   Fetch.setu64(fetch + 24, 0);
   Fetch.setu64(fetch + 32, 0);
   GROWABLE_HEAP_U16()[fetch + 40 >> 1] = 4;
   GROWABLE_HEAP_U16()[fetch + 42 >> 1] = 200;
   stringToUTF8("OK", fetch + 44, 64);
   onsuccess(fetch, 0, value);
  });
  request.onerror = (error => {
   GROWABLE_HEAP_U16()[fetch + 40 >> 1] = 4;
   GROWABLE_HEAP_U16()[fetch + 42 >> 1] = 404;
   stringToUTF8("Not Found", fetch + 44, 64);
   onerror(fetch, 0, error);
  });
 } catch (e) {
  onerror(fetch, 0, e);
 }
}

function _emscripten_start_fetch(fetch, successcb, errorcb, progresscb, readystatechangecb) {
 runtimeKeepalivePush();
 var fetch_attr = fetch + 112;
 var requestMethod = UTF8ToString(fetch_attr);
 var onsuccess = GROWABLE_HEAP_U32()[fetch_attr + 36 >> 2];
 var onerror = GROWABLE_HEAP_U32()[fetch_attr + 40 >> 2];
 var onprogress = GROWABLE_HEAP_U32()[fetch_attr + 44 >> 2];
 var onreadystatechange = GROWABLE_HEAP_U32()[fetch_attr + 48 >> 2];
 var fetchAttributes = GROWABLE_HEAP_U32()[fetch_attr + 52 >> 2];
 var fetchAttrLoadToMemory = !!(fetchAttributes & 1);
 var fetchAttrStreamData = !!(fetchAttributes & 2);
 var fetchAttrPersistFile = !!(fetchAttributes & 4);
 var fetchAttrNoDownload = !!(fetchAttributes & 32);
 var fetchAttrAppend = !!(fetchAttributes & 8);
 var fetchAttrReplace = !!(fetchAttributes & 16);
 var fetchAttrSynchronous = !!(fetchAttributes & 64);
 var reportSuccess = (fetch, xhr, e) => {
  runtimeKeepalivePop();
  callUserCallback(() => {
   if (onsuccess) getWasmTableEntry(onsuccess)(fetch); else if (successcb) successcb(fetch);
  }, fetchAttrSynchronous);
 };
 var reportProgress = (fetch, xhr, e) => {
  callUserCallback(() => {
   if (onprogress) getWasmTableEntry(onprogress)(fetch); else if (progresscb) progresscb(fetch);
  }, fetchAttrSynchronous);
 };
 var reportError = (fetch, xhr, e) => {
  runtimeKeepalivePop();
  callUserCallback(() => {
   if (onerror) getWasmTableEntry(onerror)(fetch); else if (errorcb) errorcb(fetch);
  }, fetchAttrSynchronous);
 };
 var reportReadyStateChange = (fetch, xhr, e) => {
  callUserCallback(() => {
   if (onreadystatechange) getWasmTableEntry(onreadystatechange)(fetch); else if (readystatechangecb) readystatechangecb(fetch);
  }, fetchAttrSynchronous);
 };
 var performUncachedXhr = (fetch, xhr, e) => {
  fetchXHR(fetch, reportSuccess, reportError, reportProgress, reportReadyStateChange);
 };
 var cacheResultAndReportSuccess = (fetch, xhr, e) => {
  var storeSuccess = (fetch, xhr, e) => {
   runtimeKeepalivePop();
   callUserCallback(() => {
    if (onsuccess) getWasmTableEntry(onsuccess)(fetch); else if (successcb) successcb(fetch);
   }, fetchAttrSynchronous);
  };
  var storeError = (fetch, xhr, e) => {
   runtimeKeepalivePop();
   callUserCallback(() => {
    if (onsuccess) getWasmTableEntry(onsuccess)(fetch); else if (successcb) successcb(fetch);
   }, fetchAttrSynchronous);
  };
  fetchCacheData(Fetch.dbInstance, fetch, xhr.response, storeSuccess, storeError);
 };
 var performCachedXhr = (fetch, xhr, e) => {
  fetchXHR(fetch, cacheResultAndReportSuccess, reportError, reportProgress, reportReadyStateChange);
 };
 if (requestMethod === "EM_IDB_STORE") {
  var ptr = GROWABLE_HEAP_U32()[fetch_attr + 84 >> 2];
  fetchCacheData(Fetch.dbInstance, fetch, GROWABLE_HEAP_U8().slice(ptr, ptr + GROWABLE_HEAP_U32()[fetch_attr + 88 >> 2]), reportSuccess, reportError);
 } else if (requestMethod === "EM_IDB_DELETE") {
  fetchDeleteCachedData(Fetch.dbInstance, fetch, reportSuccess, reportError);
 } else if (!fetchAttrReplace) {
  fetchLoadCachedData(Fetch.dbInstance, fetch, reportSuccess, fetchAttrNoDownload ? reportError : fetchAttrPersistFile ? performCachedXhr : performUncachedXhr);
 } else if (!fetchAttrNoDownload) {
  fetchXHR(fetch, fetchAttrPersistFile ? cacheResultAndReportSuccess : reportSuccess, reportError, reportProgress, reportReadyStateChange);
 } else {
  return 0;
 }
 return fetch;
}

function _emscripten_unwind_to_js_event_loop() {
 throw "unwind";
}

function __webgl_enable_ANGLE_instanced_arrays(ctx) {
 var ext = ctx.getExtension("ANGLE_instanced_arrays");
 if (ext) {
  ctx["vertexAttribDivisor"] = function(index, divisor) {
   ext["vertexAttribDivisorANGLE"](index, divisor);
  };
  ctx["drawArraysInstanced"] = function(mode, first, count, primcount) {
   ext["drawArraysInstancedANGLE"](mode, first, count, primcount);
  };
  ctx["drawElementsInstanced"] = function(mode, count, type, indices, primcount) {
   ext["drawElementsInstancedANGLE"](mode, count, type, indices, primcount);
  };
  return 1;
 }
}

function __webgl_enable_OES_vertex_array_object(ctx) {
 var ext = ctx.getExtension("OES_vertex_array_object");
 if (ext) {
  ctx["createVertexArray"] = function() {
   return ext["createVertexArrayOES"]();
  };
  ctx["deleteVertexArray"] = function(vao) {
   ext["deleteVertexArrayOES"](vao);
  };
  ctx["bindVertexArray"] = function(vao) {
   ext["bindVertexArrayOES"](vao);
  };
  ctx["isVertexArray"] = function(vao) {
   return ext["isVertexArrayOES"](vao);
  };
  return 1;
 }
}

function __webgl_enable_WEBGL_draw_buffers(ctx) {
 var ext = ctx.getExtension("WEBGL_draw_buffers");
 if (ext) {
  ctx["drawBuffers"] = function(n, bufs) {
   ext["drawBuffersWEBGL"](n, bufs);
  };
  return 1;
 }
}

function __webgl_enable_WEBGL_multi_draw(ctx) {
 return !!(ctx.multiDrawWebgl = ctx.getExtension("WEBGL_multi_draw"));
}

var GL = {
 counter: 1,
 buffers: [],
 programs: [],
 framebuffers: [],
 renderbuffers: [],
 textures: [],
 shaders: [],
 vaos: [],
 contexts: {},
 offscreenCanvases: {},
 queries: [],
 stringCache: {},
 unpackAlignment: 4,
 recordError: function recordError(errorCode) {
  if (!GL.lastError) {
   GL.lastError = errorCode;
  }
 },
 getNewId: function(table) {
  var ret = GL.counter++;
  for (var i = table.length; i < ret; i++) {
   table[i] = null;
  }
  return ret;
 },
 getSource: function(shader, count, string, length) {
  var source = "";
  for (var i = 0; i < count; ++i) {
   var len = length ? GROWABLE_HEAP_I32()[length + i * 4 >> 2] : -1;
   source += UTF8ToString(GROWABLE_HEAP_I32()[string + i * 4 >> 2], len < 0 ? undefined : len);
  }
  return source;
 },
 createContext: function(canvas, webGLContextAttributes) {
  if (!canvas.getContextSafariWebGL2Fixed) {
   canvas.getContextSafariWebGL2Fixed = canvas.getContext;
   function fixedGetContext(ver, attrs) {
    var gl = canvas.getContextSafariWebGL2Fixed(ver, attrs);
    return ver == "webgl" == gl instanceof WebGLRenderingContext ? gl : null;
   }
   canvas.getContext = fixedGetContext;
  }
  var ctx = canvas.getContext("webgl", webGLContextAttributes);
  if (!ctx) return 0;
  var handle = GL.registerContext(ctx, webGLContextAttributes);
  return handle;
 },
 registerContext: function(ctx, webGLContextAttributes) {
  var handle = _malloc(8);
  GROWABLE_HEAP_I32()[handle + 4 >> 2] = _pthread_self();
  var context = {
   handle: handle,
   attributes: webGLContextAttributes,
   version: webGLContextAttributes.majorVersion,
   GLctx: ctx
  };
  if (ctx.canvas) ctx.canvas.GLctxObject = context;
  GL.contexts[handle] = context;
  if (typeof webGLContextAttributes.enableExtensionsByDefault == "undefined" || webGLContextAttributes.enableExtensionsByDefault) {
   GL.initExtensions(context);
  }
  return handle;
 },
 makeContextCurrent: function(contextHandle) {
  GL.currentContext = GL.contexts[contextHandle];
  Module.ctx = GLctx = GL.currentContext && GL.currentContext.GLctx;
  return !(contextHandle && !GLctx);
 },
 getContext: function(contextHandle) {
  return GL.contexts[contextHandle];
 },
 deleteContext: function(contextHandle) {
  if (GL.currentContext === GL.contexts[contextHandle]) GL.currentContext = null;
  if (typeof JSEvents == "object") JSEvents.removeAllHandlersOnTarget(GL.contexts[contextHandle].GLctx.canvas);
  if (GL.contexts[contextHandle] && GL.contexts[contextHandle].GLctx.canvas) GL.contexts[contextHandle].GLctx.canvas.GLctxObject = undefined;
  _free(GL.contexts[contextHandle].handle);
  GL.contexts[contextHandle] = null;
 },
 initExtensions: function(context) {
  if (!context) context = GL.currentContext;
  if (context.initExtensionsDone) return;
  context.initExtensionsDone = true;
  var GLctx = context.GLctx;
  __webgl_enable_ANGLE_instanced_arrays(GLctx);
  __webgl_enable_OES_vertex_array_object(GLctx);
  __webgl_enable_WEBGL_draw_buffers(GLctx);
  {
   GLctx.disjointTimerQueryExt = GLctx.getExtension("EXT_disjoint_timer_query");
  }
  __webgl_enable_WEBGL_multi_draw(GLctx);
  var exts = GLctx.getSupportedExtensions() || [];
  exts.forEach(function(ext) {
   if (!ext.includes("lose_context") && !ext.includes("debug")) {
    GLctx.getExtension(ext);
   }
  });
 }
};

var __emscripten_webgl_power_preferences = [ "default", "low-power", "high-performance" ];

function _emscripten_webgl_do_create_context(target, attributes) {
 assert(attributes);
 var a = attributes >> 2;
 var powerPreference = GROWABLE_HEAP_I32()[a + (24 >> 2)];
 var contextAttributes = {
  "alpha": !!GROWABLE_HEAP_I32()[a + (0 >> 2)],
  "depth": !!GROWABLE_HEAP_I32()[a + (4 >> 2)],
  "stencil": !!GROWABLE_HEAP_I32()[a + (8 >> 2)],
  "antialias": !!GROWABLE_HEAP_I32()[a + (12 >> 2)],
  "premultipliedAlpha": !!GROWABLE_HEAP_I32()[a + (16 >> 2)],
  "preserveDrawingBuffer": !!GROWABLE_HEAP_I32()[a + (20 >> 2)],
  "powerPreference": __emscripten_webgl_power_preferences[powerPreference],
  "failIfMajorPerformanceCaveat": !!GROWABLE_HEAP_I32()[a + (28 >> 2)],
  majorVersion: GROWABLE_HEAP_I32()[a + (32 >> 2)],
  minorVersion: GROWABLE_HEAP_I32()[a + (36 >> 2)],
  enableExtensionsByDefault: GROWABLE_HEAP_I32()[a + (40 >> 2)],
  explicitSwapControl: GROWABLE_HEAP_I32()[a + (44 >> 2)],
  proxyContextToMainThread: GROWABLE_HEAP_I32()[a + (48 >> 2)],
  renderViaOffscreenBackBuffer: GROWABLE_HEAP_I32()[a + (52 >> 2)]
 };
 var canvas = findCanvasEventTarget(target);
 if (!canvas) {
  return 0;
 }
 if (contextAttributes.explicitSwapControl) {
  return 0;
 }
 var contextHandle = GL.createContext(canvas, contextAttributes);
 return contextHandle;
}

function _emscripten_webgl_create_context(a0, a1) {
 return _emscripten_webgl_do_create_context(a0, a1);
}

var ENV = {};

function getExecutableName() {
 return thisProgram || "./this.program";
}

function getEnvStrings() {
 if (!getEnvStrings.strings) {
  var lang = (typeof navigator == "object" && navigator.languages && navigator.languages[0] || "C").replace("-", "_") + ".UTF-8";
  var env = {
   "USER": "web_user",
   "LOGNAME": "web_user",
   "PATH": "/",
   "PWD": "/",
   "HOME": "/home/web_user",
   "LANG": lang,
   "_": getExecutableName()
  };
  for (var x in ENV) {
   if (ENV[x] === undefined) delete env[x]; else env[x] = ENV[x];
  }
  var strings = [];
  for (var x in env) {
   strings.push(x + "=" + env[x]);
  }
  getEnvStrings.strings = strings;
 }
 return getEnvStrings.strings;
}

function _environ_get(__environ, environ_buf) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(30, 1, __environ, environ_buf);
 var bufSize = 0;
 getEnvStrings().forEach(function(string, i) {
  var ptr = environ_buf + bufSize;
  GROWABLE_HEAP_I32()[__environ + i * 4 >> 2] = ptr;
  writeAsciiToMemory(string, ptr);
  bufSize += string.length + 1;
 });
 return 0;
}

function _environ_sizes_get(penviron_count, penviron_buf_size) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(31, 1, penviron_count, penviron_buf_size);
 var strings = getEnvStrings();
 GROWABLE_HEAP_I32()[penviron_count >> 2] = strings.length;
 var bufSize = 0;
 strings.forEach(function(string) {
  bufSize += string.length + 1;
 });
 GROWABLE_HEAP_I32()[penviron_buf_size >> 2] = bufSize;
 return 0;
}

function _fd_close(fd) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(32, 1, fd);
 try {
  var stream = SYSCALLS.getStreamFromFD(fd);
  FS.close(stream);
  return 0;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return e.errno;
 }
}

function _fd_fdstat_get(fd, pbuf) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(33, 1, fd, pbuf);
 try {
  var stream = SYSCALLS.getStreamFromFD(fd);
  var type = stream.tty ? 2 : FS.isDir(stream.mode) ? 3 : FS.isLink(stream.mode) ? 7 : 4;
  GROWABLE_HEAP_I8()[pbuf >> 0] = type;
  return 0;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return e.errno;
 }
}

function _fd_read(fd, iov, iovcnt, pnum) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(34, 1, fd, iov, iovcnt, pnum);
 try {
  var stream = SYSCALLS.getStreamFromFD(fd);
  var num = SYSCALLS.doReadv(stream, iov, iovcnt);
  GROWABLE_HEAP_I32()[pnum >> 2] = num;
  return 0;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return e.errno;
 }
}

function _fd_seek(fd, offset_low, offset_high, whence, newOffset) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(35, 1, fd, offset_low, offset_high, whence, newOffset);
 try {
  var stream = SYSCALLS.getStreamFromFD(fd);
  var HIGH_OFFSET = 4294967296;
  var offset = offset_high * HIGH_OFFSET + (offset_low >>> 0);
  var DOUBLE_LIMIT = 9007199254740992;
  if (offset <= -DOUBLE_LIMIT || offset >= DOUBLE_LIMIT) {
   return -61;
  }
  FS.llseek(stream, offset, whence);
  tempI64 = [ stream.position >>> 0, (tempDouble = stream.position, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? (Math.min(+Math.floor(tempDouble / 4294967296), 4294967295) | 0) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0) ], 
  GROWABLE_HEAP_I32()[newOffset >> 2] = tempI64[0], GROWABLE_HEAP_I32()[newOffset + 4 >> 2] = tempI64[1];
  if (stream.getdents && offset === 0 && whence === 0) stream.getdents = null;
  return 0;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return e.errno;
 }
}

function _fd_write(fd, iov, iovcnt, pnum) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(36, 1, fd, iov, iovcnt, pnum);
 try {
  var stream = SYSCALLS.getStreamFromFD(fd);
  var num = SYSCALLS.doWritev(stream, iov, iovcnt);
  GROWABLE_HEAP_I32()[pnum >> 2] = num;
  return 0;
 } catch (e) {
  if (typeof FS == "undefined" || !(e instanceof FS.ErrnoError)) throw e;
  return e.errno;
 }
}

function _getaddrinfo(node, service, hint, out) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(37, 1, node, service, hint, out);
 var addrs = [];
 var canon = null;
 var addr = 0;
 var port = 0;
 var flags = 0;
 var family = 0;
 var type = 0;
 var proto = 0;
 var ai, last;
 function allocaddrinfo(family, type, proto, canon, addr, port) {
  var sa, salen, ai;
  var errno;
  salen = family === 10 ? 28 : 16;
  addr = family === 10 ? inetNtop6(addr) : inetNtop4(addr);
  sa = _malloc(salen);
  errno = writeSockaddr(sa, family, addr, port);
  assert(!errno);
  ai = _malloc(32);
  GROWABLE_HEAP_I32()[ai + 4 >> 2] = family;
  GROWABLE_HEAP_I32()[ai + 8 >> 2] = type;
  GROWABLE_HEAP_I32()[ai + 12 >> 2] = proto;
  GROWABLE_HEAP_I32()[ai + 24 >> 2] = canon;
  GROWABLE_HEAP_I32()[ai + 20 >> 2] = sa;
  if (family === 10) {
   GROWABLE_HEAP_I32()[ai + 16 >> 2] = 28;
  } else {
   GROWABLE_HEAP_I32()[ai + 16 >> 2] = 16;
  }
  GROWABLE_HEAP_I32()[ai + 28 >> 2] = 0;
  return ai;
 }
 if (hint) {
  flags = GROWABLE_HEAP_I32()[hint >> 2];
  family = GROWABLE_HEAP_I32()[hint + 4 >> 2];
  type = GROWABLE_HEAP_I32()[hint + 8 >> 2];
  proto = GROWABLE_HEAP_I32()[hint + 12 >> 2];
 }
 if (type && !proto) {
  proto = type === 2 ? 17 : 6;
 }
 if (!type && proto) {
  type = proto === 17 ? 2 : 1;
 }
 if (proto === 0) {
  proto = 6;
 }
 if (type === 0) {
  type = 1;
 }
 if (!node && !service) {
  return -2;
 }
 if (flags & ~(1 | 2 | 4 | 1024 | 8 | 16 | 32)) {
  return -1;
 }
 if (hint !== 0 && GROWABLE_HEAP_I32()[hint >> 2] & 2 && !node) {
  return -1;
 }
 if (flags & 32) {
  return -2;
 }
 if (type !== 0 && type !== 1 && type !== 2) {
  return -7;
 }
 if (family !== 0 && family !== 2 && family !== 10) {
  return -6;
 }
 if (service) {
  service = UTF8ToString(service);
  port = parseInt(service, 10);
  if (isNaN(port)) {
   if (flags & 1024) {
    return -2;
   }
   return -8;
  }
 }
 if (!node) {
  if (family === 0) {
   family = 2;
  }
  if ((flags & 1) === 0) {
   if (family === 2) {
    addr = _htonl(2130706433);
   } else {
    addr = [ 0, 0, 0, 1 ];
   }
  }
  ai = allocaddrinfo(family, type, proto, null, addr, port);
  GROWABLE_HEAP_I32()[out >> 2] = ai;
  return 0;
 }
 node = UTF8ToString(node);
 addr = inetPton4(node);
 if (addr !== null) {
  if (family === 0 || family === 2) {
   family = 2;
  } else if (family === 10 && flags & 8) {
   addr = [ 0, 0, _htonl(65535), addr ];
   family = 10;
  } else {
   return -2;
  }
 } else {
  addr = inetPton6(node);
  if (addr !== null) {
   if (family === 0 || family === 10) {
    family = 10;
   } else {
    return -2;
   }
  }
 }
 if (addr != null) {
  ai = allocaddrinfo(family, type, proto, node, addr, port);
  GROWABLE_HEAP_I32()[out >> 2] = ai;
  return 0;
 }
 if (flags & 4) {
  return -2;
 }
 node = DNS.lookup_name(node);
 addr = inetPton4(node);
 if (family === 0) {
  family = 2;
 } else if (family === 10) {
  addr = [ 0, 0, _htonl(65535), addr ];
 }
 ai = allocaddrinfo(family, type, proto, null, addr, port);
 GROWABLE_HEAP_I32()[out >> 2] = ai;
 return 0;
}

function getHostByName(name) {
 var ret = _malloc(20);
 var nameBuf = _malloc(name.length + 1);
 stringToUTF8(name, nameBuf, name.length + 1);
 GROWABLE_HEAP_I32()[ret >> 2] = nameBuf;
 var aliasesBuf = _malloc(4);
 GROWABLE_HEAP_I32()[aliasesBuf >> 2] = 0;
 GROWABLE_HEAP_I32()[ret + 4 >> 2] = aliasesBuf;
 var afinet = 2;
 GROWABLE_HEAP_I32()[ret + 8 >> 2] = afinet;
 GROWABLE_HEAP_I32()[ret + 12 >> 2] = 4;
 var addrListBuf = _malloc(12);
 GROWABLE_HEAP_I32()[addrListBuf >> 2] = addrListBuf + 8;
 GROWABLE_HEAP_I32()[addrListBuf + 4 >> 2] = 0;
 GROWABLE_HEAP_I32()[addrListBuf + 8 >> 2] = inetPton4(DNS.lookup_name(name));
 GROWABLE_HEAP_I32()[ret + 16 >> 2] = addrListBuf;
 return ret;
}

function _gethostbyname(name) {
 if (ENVIRONMENT_IS_PTHREAD) return _emscripten_proxy_to_main_thread_js(38, 1, name);
 return getHostByName(UTF8ToString(name));
}

function _getnameinfo(sa, salen, node, nodelen, serv, servlen, flags) {
 var info = readSockaddr(sa, salen);
 if (info.errno) {
  return -6;
 }
 var port = info.port;
 var addr = info.addr;
 var overflowed = false;
 if (node && nodelen) {
  var lookup;
  if (flags & 1 || !(lookup = DNS.lookup_addr(addr))) {
   if (flags & 8) {
    return -2;
   }
  } else {
   addr = lookup;
  }
  var numBytesWrittenExclNull = stringToUTF8(addr, node, nodelen);
  if (numBytesWrittenExclNull + 1 >= nodelen) {
   overflowed = true;
  }
 }
 if (serv && servlen) {
  port = "" + port;
  var numBytesWrittenExclNull = stringToUTF8(port, serv, servlen);
  if (numBytesWrittenExclNull + 1 >= servlen) {
   overflowed = true;
  }
 }
 if (overflowed) {
  return -12;
 }
 return 0;
}

function _gettimeofday(ptr) {
 var now = Date.now();
 GROWABLE_HEAP_I32()[ptr >> 2] = now / 1e3 | 0;
 GROWABLE_HEAP_I32()[ptr + 4 >> 2] = now % 1e3 * 1e3 | 0;
 return 0;
}

function _pthread_kill(thread, signal) {
 if (signal < 0 || signal >= 65) return 28;
 if (thread === _emscripten_main_browser_thread_id()) {
  if (signal == 0) return 0;
  err("Main thread (id=" + ptrToString(thread) + ") cannot be killed with pthread_kill!");
  return 71;
 }
 if (!thread) {
  err("pthread_kill attempted on a null thread pointer!");
  return 71;
 }
 var self = GROWABLE_HEAP_I32()[thread >> 2];
 if (self !== thread) {
  err("pthread_kill attempted on thread " + ptrToString(thread) + ", which does not point to a valid thread, or does not exist anymore!");
  return 71;
 }
 if (signal === 33) {
  if (!ENVIRONMENT_IS_PTHREAD) cancelThread(thread); else postMessage({
   "cmd": "cancelThread",
   "thread": thread
  });
 } else if (signal != 0) {
  if (!ENVIRONMENT_IS_PTHREAD) killThread(thread); else postMessage({
   "cmd": "killThread",
   "thread": thread
  });
 }
 return 0;
}

function _setTempRet0(val) {
 setTempRet0(val);
}

function __isLeapYear(year) {
 return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
}

function __arraySum(array, index) {
 var sum = 0;
 for (var i = 0; i <= index; sum += array[i++]) {}
 return sum;
}

var __MONTH_DAYS_LEAP = [ 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 ];

var __MONTH_DAYS_REGULAR = [ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 ];

function __addDays(date, days) {
 var newDate = new Date(date.getTime());
 while (days > 0) {
  var leap = __isLeapYear(newDate.getFullYear());
  var currentMonth = newDate.getMonth();
  var daysInCurrentMonth = (leap ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR)[currentMonth];
  if (days > daysInCurrentMonth - newDate.getDate()) {
   days -= daysInCurrentMonth - newDate.getDate() + 1;
   newDate.setDate(1);
   if (currentMonth < 11) {
    newDate.setMonth(currentMonth + 1);
   } else {
    newDate.setMonth(0);
    newDate.setFullYear(newDate.getFullYear() + 1);
   }
  } else {
   newDate.setDate(newDate.getDate() + days);
   return newDate;
  }
 }
 return newDate;
}

function _strftime(s, maxsize, format, tm) {
 var tm_zone = GROWABLE_HEAP_I32()[tm + 40 >> 2];
 var date = {
  tm_sec: GROWABLE_HEAP_I32()[tm >> 2],
  tm_min: GROWABLE_HEAP_I32()[tm + 4 >> 2],
  tm_hour: GROWABLE_HEAP_I32()[tm + 8 >> 2],
  tm_mday: GROWABLE_HEAP_I32()[tm + 12 >> 2],
  tm_mon: GROWABLE_HEAP_I32()[tm + 16 >> 2],
  tm_year: GROWABLE_HEAP_I32()[tm + 20 >> 2],
  tm_wday: GROWABLE_HEAP_I32()[tm + 24 >> 2],
  tm_yday: GROWABLE_HEAP_I32()[tm + 28 >> 2],
  tm_isdst: GROWABLE_HEAP_I32()[tm + 32 >> 2],
  tm_gmtoff: GROWABLE_HEAP_I32()[tm + 36 >> 2],
  tm_zone: tm_zone ? UTF8ToString(tm_zone) : ""
 };
 var pattern = UTF8ToString(format);
 var EXPANSION_RULES_1 = {
  "%c": "%a %b %d %H:%M:%S %Y",
  "%D": "%m/%d/%y",
  "%F": "%Y-%m-%d",
  "%h": "%b",
  "%r": "%I:%M:%S %p",
  "%R": "%H:%M",
  "%T": "%H:%M:%S",
  "%x": "%m/%d/%y",
  "%X": "%H:%M:%S",
  "%Ec": "%c",
  "%EC": "%C",
  "%Ex": "%m/%d/%y",
  "%EX": "%H:%M:%S",
  "%Ey": "%y",
  "%EY": "%Y",
  "%Od": "%d",
  "%Oe": "%e",
  "%OH": "%H",
  "%OI": "%I",
  "%Om": "%m",
  "%OM": "%M",
  "%OS": "%S",
  "%Ou": "%u",
  "%OU": "%U",
  "%OV": "%V",
  "%Ow": "%w",
  "%OW": "%W",
  "%Oy": "%y"
 };
 for (var rule in EXPANSION_RULES_1) {
  pattern = pattern.replace(new RegExp(rule, "g"), EXPANSION_RULES_1[rule]);
 }
 var WEEKDAYS = [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ];
 var MONTHS = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
 function leadingSomething(value, digits, character) {
  var str = typeof value == "number" ? value.toString() : value || "";
  while (str.length < digits) {
   str = character[0] + str;
  }
  return str;
 }
 function leadingNulls(value, digits) {
  return leadingSomething(value, digits, "0");
 }
 function compareByDay(date1, date2) {
  function sgn(value) {
   return value < 0 ? -1 : value > 0 ? 1 : 0;
  }
  var compare;
  if ((compare = sgn(date1.getFullYear() - date2.getFullYear())) === 0) {
   if ((compare = sgn(date1.getMonth() - date2.getMonth())) === 0) {
    compare = sgn(date1.getDate() - date2.getDate());
   }
  }
  return compare;
 }
 function getFirstWeekStartDate(janFourth) {
  switch (janFourth.getDay()) {
  case 0:
   return new Date(janFourth.getFullYear() - 1, 11, 29);

  case 1:
   return janFourth;

  case 2:
   return new Date(janFourth.getFullYear(), 0, 3);

  case 3:
   return new Date(janFourth.getFullYear(), 0, 2);

  case 4:
   return new Date(janFourth.getFullYear(), 0, 1);

  case 5:
   return new Date(janFourth.getFullYear() - 1, 11, 31);

  case 6:
   return new Date(janFourth.getFullYear() - 1, 11, 30);
  }
 }
 function getWeekBasedYear(date) {
  var thisDate = __addDays(new Date(date.tm_year + 1900, 0, 1), date.tm_yday);
  var janFourthThisYear = new Date(thisDate.getFullYear(), 0, 4);
  var janFourthNextYear = new Date(thisDate.getFullYear() + 1, 0, 4);
  var firstWeekStartThisYear = getFirstWeekStartDate(janFourthThisYear);
  var firstWeekStartNextYear = getFirstWeekStartDate(janFourthNextYear);
  if (compareByDay(firstWeekStartThisYear, thisDate) <= 0) {
   if (compareByDay(firstWeekStartNextYear, thisDate) <= 0) {
    return thisDate.getFullYear() + 1;
   } else {
    return thisDate.getFullYear();
   }
  } else {
   return thisDate.getFullYear() - 1;
  }
 }
 var EXPANSION_RULES_2 = {
  "%a": function(date) {
   return WEEKDAYS[date.tm_wday].substring(0, 3);
  },
  "%A": function(date) {
   return WEEKDAYS[date.tm_wday];
  },
  "%b": function(date) {
   return MONTHS[date.tm_mon].substring(0, 3);
  },
  "%B": function(date) {
   return MONTHS[date.tm_mon];
  },
  "%C": function(date) {
   var year = date.tm_year + 1900;
   return leadingNulls(year / 100 | 0, 2);
  },
  "%d": function(date) {
   return leadingNulls(date.tm_mday, 2);
  },
  "%e": function(date) {
   return leadingSomething(date.tm_mday, 2, " ");
  },
  "%g": function(date) {
   return getWeekBasedYear(date).toString().substring(2);
  },
  "%G": function(date) {
   return getWeekBasedYear(date);
  },
  "%H": function(date) {
   return leadingNulls(date.tm_hour, 2);
  },
  "%I": function(date) {
   var twelveHour = date.tm_hour;
   if (twelveHour == 0) twelveHour = 12; else if (twelveHour > 12) twelveHour -= 12;
   return leadingNulls(twelveHour, 2);
  },
  "%j": function(date) {
   return leadingNulls(date.tm_mday + __arraySum(__isLeapYear(date.tm_year + 1900) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, date.tm_mon - 1), 3);
  },
  "%m": function(date) {
   return leadingNulls(date.tm_mon + 1, 2);
  },
  "%M": function(date) {
   return leadingNulls(date.tm_min, 2);
  },
  "%n": function() {
   return "\n";
  },
  "%p": function(date) {
   if (date.tm_hour >= 0 && date.tm_hour < 12) {
    return "AM";
   } else {
    return "PM";
   }
  },
  "%S": function(date) {
   return leadingNulls(date.tm_sec, 2);
  },
  "%t": function() {
   return "\t";
  },
  "%u": function(date) {
   return date.tm_wday || 7;
  },
  "%U": function(date) {
   var janFirst = new Date(date.tm_year + 1900, 0, 1);
   var firstSunday = janFirst.getDay() === 0 ? janFirst : __addDays(janFirst, 7 - janFirst.getDay());
   var endDate = new Date(date.tm_year + 1900, date.tm_mon, date.tm_mday);
   if (compareByDay(firstSunday, endDate) < 0) {
    var februaryFirstUntilEndMonth = __arraySum(__isLeapYear(endDate.getFullYear()) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, endDate.getMonth() - 1) - 31;
    var firstSundayUntilEndJanuary = 31 - firstSunday.getDate();
    var days = firstSundayUntilEndJanuary + februaryFirstUntilEndMonth + endDate.getDate();
    return leadingNulls(Math.ceil(days / 7), 2);
   }
   return compareByDay(firstSunday, janFirst) === 0 ? "01" : "00";
  },
  "%V": function(date) {
   var janFourthThisYear = new Date(date.tm_year + 1900, 0, 4);
   var janFourthNextYear = new Date(date.tm_year + 1901, 0, 4);
   var firstWeekStartThisYear = getFirstWeekStartDate(janFourthThisYear);
   var firstWeekStartNextYear = getFirstWeekStartDate(janFourthNextYear);
   var endDate = __addDays(new Date(date.tm_year + 1900, 0, 1), date.tm_yday);
   if (compareByDay(endDate, firstWeekStartThisYear) < 0) {
    return "53";
   }
   if (compareByDay(firstWeekStartNextYear, endDate) <= 0) {
    return "01";
   }
   var daysDifference;
   if (firstWeekStartThisYear.getFullYear() < date.tm_year + 1900) {
    daysDifference = date.tm_yday + 32 - firstWeekStartThisYear.getDate();
   } else {
    daysDifference = date.tm_yday + 1 - firstWeekStartThisYear.getDate();
   }
   return leadingNulls(Math.ceil(daysDifference / 7), 2);
  },
  "%w": function(date) {
   return date.tm_wday;
  },
  "%W": function(date) {
   var janFirst = new Date(date.tm_year, 0, 1);
   var firstMonday = janFirst.getDay() === 1 ? janFirst : __addDays(janFirst, janFirst.getDay() === 0 ? 1 : 7 - janFirst.getDay() + 1);
   var endDate = new Date(date.tm_year + 1900, date.tm_mon, date.tm_mday);
   if (compareByDay(firstMonday, endDate) < 0) {
    var februaryFirstUntilEndMonth = __arraySum(__isLeapYear(endDate.getFullYear()) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, endDate.getMonth() - 1) - 31;
    var firstMondayUntilEndJanuary = 31 - firstMonday.getDate();
    var days = firstMondayUntilEndJanuary + februaryFirstUntilEndMonth + endDate.getDate();
    return leadingNulls(Math.ceil(days / 7), 2);
   }
   return compareByDay(firstMonday, janFirst) === 0 ? "01" : "00";
  },
  "%y": function(date) {
   return (date.tm_year + 1900).toString().substring(2);
  },
  "%Y": function(date) {
   return date.tm_year + 1900;
  },
  "%z": function(date) {
   var off = date.tm_gmtoff;
   var ahead = off >= 0;
   off = Math.abs(off) / 60;
   off = off / 60 * 100 + off % 60;
   return (ahead ? "+" : "-") + String("0000" + off).slice(-4);
  },
  "%Z": function(date) {
   return date.tm_zone;
  },
  "%%": function() {
   return "%";
  }
 };
 pattern = pattern.replace(/%%/g, "\0\0");
 for (var rule in EXPANSION_RULES_2) {
  if (pattern.includes(rule)) {
   pattern = pattern.replace(new RegExp(rule, "g"), EXPANSION_RULES_2[rule](date));
  }
 }
 pattern = pattern.replace(/\0\0/g, "%");
 var bytes = intArrayFromString(pattern, false);
 if (bytes.length > maxsize) {
  return 0;
 }
 writeArrayToMemory(bytes, s);
 return bytes.length - 1;
}

function _strftime_l(s, maxsize, format, tm) {
 return _strftime(s, maxsize, format, tm);
}

function _time(ptr) {
 var ret = Date.now() / 1e3 | 0;
 if (ptr) {
  GROWABLE_HEAP_I32()[ptr >> 2] = ret;
 }
 return ret;
}

PThread.init();

var FSNode = function(parent, name, mode, rdev) {
 if (!parent) {
  parent = this;
 }
 this.parent = parent;
 this.mount = parent.mount;
 this.mounted = null;
 this.id = FS.nextInode++;
 this.name = name;
 this.mode = mode;
 this.node_ops = {};
 this.stream_ops = {};
 this.rdev = rdev;
};

var readMode = 292 | 73;

var writeMode = 146;

Object.defineProperties(FSNode.prototype, {
 read: {
  get: function() {
   return (this.mode & readMode) === readMode;
  },
  set: function(val) {
   val ? this.mode |= readMode : this.mode &= ~readMode;
  }
 },
 write: {
  get: function() {
   return (this.mode & writeMode) === writeMode;
  },
  set: function(val) {
   val ? this.mode |= writeMode : this.mode &= ~writeMode;
  }
 },
 isFolder: {
  get: function() {
   return FS.isDir(this.mode);
  }
 },
 isDevice: {
  get: function() {
   return FS.isChrdev(this.mode);
  }
 }
});

FS.FSNode = FSNode;

FS.staticInit();

Module["FS_createPath"] = FS.createPath;

Module["FS_createDataFile"] = FS.createDataFile;

Module["FS_createPreloadedFile"] = FS.createPreloadedFile;

Module["FS_createLazyFile"] = FS.createLazyFile;

Module["FS_createDevice"] = FS.createDevice;

Module["FS_unlink"] = FS.unlink;

ERRNO_CODES = {
 "EPERM": 63,
 "ENOENT": 44,
 "ESRCH": 71,
 "EINTR": 27,
 "EIO": 29,
 "ENXIO": 60,
 "E2BIG": 1,
 "ENOEXEC": 45,
 "EBADF": 8,
 "ECHILD": 12,
 "EAGAIN": 6,
 "EWOULDBLOCK": 6,
 "ENOMEM": 48,
 "EACCES": 2,
 "EFAULT": 21,
 "ENOTBLK": 105,
 "EBUSY": 10,
 "EEXIST": 20,
 "EXDEV": 75,
 "ENODEV": 43,
 "ENOTDIR": 54,
 "EISDIR": 31,
 "EINVAL": 28,
 "ENFILE": 41,
 "EMFILE": 33,
 "ENOTTY": 59,
 "ETXTBSY": 74,
 "EFBIG": 22,
 "ENOSPC": 51,
 "ESPIPE": 70,
 "EROFS": 69,
 "EMLINK": 34,
 "EPIPE": 64,
 "EDOM": 18,
 "ERANGE": 68,
 "ENOMSG": 49,
 "EIDRM": 24,
 "ECHRNG": 106,
 "EL2NSYNC": 156,
 "EL3HLT": 107,
 "EL3RST": 108,
 "ELNRNG": 109,
 "EUNATCH": 110,
 "ENOCSI": 111,
 "EL2HLT": 112,
 "EDEADLK": 16,
 "ENOLCK": 46,
 "EBADE": 113,
 "EBADR": 114,
 "EXFULL": 115,
 "ENOANO": 104,
 "EBADRQC": 103,
 "EBADSLT": 102,
 "EDEADLOCK": 16,
 "EBFONT": 101,
 "ENOSTR": 100,
 "ENODATA": 116,
 "ETIME": 117,
 "ENOSR": 118,
 "ENONET": 119,
 "ENOPKG": 120,
 "EREMOTE": 121,
 "ENOLINK": 47,
 "EADV": 122,
 "ESRMNT": 123,
 "ECOMM": 124,
 "EPROTO": 65,
 "EMULTIHOP": 36,
 "EDOTDOT": 125,
 "EBADMSG": 9,
 "ENOTUNIQ": 126,
 "EBADFD": 127,
 "EREMCHG": 128,
 "ELIBACC": 129,
 "ELIBBAD": 130,
 "ELIBSCN": 131,
 "ELIBMAX": 132,
 "ELIBEXEC": 133,
 "ENOSYS": 52,
 "ENOTEMPTY": 55,
 "ENAMETOOLONG": 37,
 "ELOOP": 32,
 "EOPNOTSUPP": 138,
 "EPFNOSUPPORT": 139,
 "ECONNRESET": 15,
 "ENOBUFS": 42,
 "EAFNOSUPPORT": 5,
 "EPROTOTYPE": 67,
 "ENOTSOCK": 57,
 "ENOPROTOOPT": 50,
 "ESHUTDOWN": 140,
 "ECONNREFUSED": 14,
 "EADDRINUSE": 3,
 "ECONNABORTED": 13,
 "ENETUNREACH": 40,
 "ENETDOWN": 38,
 "ETIMEDOUT": 73,
 "EHOSTDOWN": 142,
 "EHOSTUNREACH": 23,
 "EINPROGRESS": 26,
 "EALREADY": 7,
 "EDESTADDRREQ": 17,
 "EMSGSIZE": 35,
 "EPROTONOSUPPORT": 66,
 "ESOCKTNOSUPPORT": 137,
 "EADDRNOTAVAIL": 4,
 "ENETRESET": 39,
 "EISCONN": 30,
 "ENOTCONN": 53,
 "ETOOMANYREFS": 141,
 "EUSERS": 136,
 "EDQUOT": 19,
 "ESTALE": 72,
 "ENOTSUP": 138,
 "ENOMEDIUM": 148,
 "EILSEQ": 25,
 "EOVERFLOW": 61,
 "ECANCELED": 11,
 "ENOTRECOVERABLE": 56,
 "EOWNERDEAD": 62,
 "ESTRPIPE": 135
};

if (!ENVIRONMENT_IS_PTHREAD) Fetch.staticInit();

var GLctx;

var proxiedFunctionTable = [ null, exitOnMainThread, ___syscall__newselect, ___syscall_accept4, ___syscall_bind, ___syscall_connect, ___syscall_faccessat, ___syscall_fcntl64, ___syscall_fstat64, ___syscall_fstatat64, ___syscall_getdents64, ___syscall_getpeername, ___syscall_getsockname, ___syscall_getsockopt, ___syscall_ioctl, ___syscall_listen, ___syscall_lstat64, ___syscall_open, ___syscall_poll, ___syscall_recvfrom, ___syscall_recvmsg, ___syscall_rename, ___syscall_rmdir, ___syscall_sendmsg, ___syscall_sendto, ___syscall_socket, ___syscall_stat64, ___syscall_unlink, _tzset_impl, _emscripten_set_canvas_element_size_main_thread, _environ_get, _environ_sizes_get, _fd_close, _fd_fdstat_get, _fd_read, _fd_seek, _fd_write, _getaddrinfo, _gethostbyname ];

var ASSERTIONS = true;

function intArrayFromString(stringy, dontAddNull, length) {
 var len = length > 0 ? length : lengthBytesUTF8(stringy) + 1;
 var u8array = new Array(len);
 var numBytesWritten = stringToUTF8Array(stringy, u8array, 0, u8array.length);
 if (dontAddNull) u8array.length = numBytesWritten;
 return u8array;
}

function intArrayToString(array) {
 var ret = [];
 for (var i = 0; i < array.length; i++) {
  var chr = array[i];
  if (chr > 255) {
   if (ASSERTIONS) {
    assert(false, "Character code " + chr + " (" + String.fromCharCode(chr) + ")  at offset " + i + " not in 0x00-0xFF.");
   }
   chr &= 255;
  }
  ret.push(String.fromCharCode(chr));
 }
 return ret.join("");
}

var decodeBase64 = typeof atob == "function" ? atob : function(input) {
 var keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
 var output = "";
 var chr1, chr2, chr3;
 var enc1, enc2, enc3, enc4;
 var i = 0;
 input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
 do {
  enc1 = keyStr.indexOf(input.charAt(i++));
  enc2 = keyStr.indexOf(input.charAt(i++));
  enc3 = keyStr.indexOf(input.charAt(i++));
  enc4 = keyStr.indexOf(input.charAt(i++));
  chr1 = enc1 << 2 | enc2 >> 4;
  chr2 = (enc2 & 15) << 4 | enc3 >> 2;
  chr3 = (enc3 & 3) << 6 | enc4;
  output = output + String.fromCharCode(chr1);
  if (enc3 !== 64) {
   output = output + String.fromCharCode(chr2);
  }
  if (enc4 !== 64) {
   output = output + String.fromCharCode(chr3);
  }
 } while (i < input.length);
 return output;
};

function intArrayFromBase64(s) {
 if (typeof ENVIRONMENT_IS_NODE == "boolean" && ENVIRONMENT_IS_NODE) {
  var buf = Buffer.from(s, "base64");
  return new Uint8Array(buf["buffer"], buf["byteOffset"], buf["byteLength"]);
 }
 try {
  var decoded = decodeBase64(s);
  var bytes = new Uint8Array(decoded.length);
  for (var i = 0; i < decoded.length; ++i) {
   bytes[i] = decoded.charCodeAt(i);
  }
  return bytes;
 } catch (_) {
  throw new Error("Converting base64 string to bytes failed.");
 }
}

function tryParseAsDataURI(filename) {
 if (!isDataURI(filename)) {
  return;
 }
 return intArrayFromBase64(filename.slice(dataURIPrefix.length));
}

function checkIncomingModuleAPI() {
 ignoredModuleProp("fetchSettings");
}

var asmLibraryArg = {
 "__assert_fail": ___assert_fail,
 "__clock_gettime": ___clock_gettime,
 "__emscripten_init_main_thread_js": ___emscripten_init_main_thread_js,
 "__emscripten_thread_cleanup": ___emscripten_thread_cleanup,
 "__pthread_create_js": ___pthread_create_js,
 "__syscall__newselect": ___syscall__newselect,
 "__syscall_accept4": ___syscall_accept4,
 "__syscall_bind": ___syscall_bind,
 "__syscall_connect": ___syscall_connect,
 "__syscall_faccessat": ___syscall_faccessat,
 "__syscall_fcntl64": ___syscall_fcntl64,
 "__syscall_fstat64": ___syscall_fstat64,
 "__syscall_fstatat64": ___syscall_fstatat64,
 "__syscall_getdents64": ___syscall_getdents64,
 "__syscall_getpeername": ___syscall_getpeername,
 "__syscall_getsockname": ___syscall_getsockname,
 "__syscall_getsockopt": ___syscall_getsockopt,
 "__syscall_ioctl": ___syscall_ioctl,
 "__syscall_listen": ___syscall_listen,
 "__syscall_lstat64": ___syscall_lstat64,
 "__syscall_open": ___syscall_open,
 "__syscall_poll": ___syscall_poll,
 "__syscall_recvfrom": ___syscall_recvfrom,
 "__syscall_recvmsg": ___syscall_recvmsg,
 "__syscall_rename": ___syscall_rename,
 "__syscall_rmdir": ___syscall_rmdir,
 "__syscall_sendmsg": ___syscall_sendmsg,
 "__syscall_sendto": ___syscall_sendto,
 "__syscall_socket": ___syscall_socket,
 "__syscall_stat64": ___syscall_stat64,
 "__syscall_unlink": ___syscall_unlink,
 "_dlopen_js": __dlopen_js,
 "_dlsym_js": __dlsym_js,
 "_emscripten_default_pthread_stack_size": __emscripten_default_pthread_stack_size,
 "_emscripten_fetch_free": __emscripten_fetch_free,
 "_emscripten_notify_thread_queue": __emscripten_notify_thread_queue,
 "_gmtime_js": __gmtime_js,
 "_localtime_js": __localtime_js,
 "_mktime_js": __mktime_js,
 "_tzset_js": __tzset_js,
 "abort": _abort,
 "clock": _clock,
 "clock_gettime": _clock_gettime,
 "emscripten_asm_const_int_sync_on_main_thread": _emscripten_asm_const_int_sync_on_main_thread,
 "emscripten_check_blocking_allowed": _emscripten_check_blocking_allowed,
 "emscripten_console_error": _emscripten_console_error,
 "emscripten_get_heap_max": _emscripten_get_heap_max,
 "emscripten_get_now": _emscripten_get_now,
 "emscripten_memcpy_big": _emscripten_memcpy_big,
 "emscripten_num_logical_cores": _emscripten_num_logical_cores,
 "emscripten_receive_on_main_thread_js": _emscripten_receive_on_main_thread_js,
 "emscripten_resize_heap": _emscripten_resize_heap,
 "emscripten_set_canvas_element_size": _emscripten_set_canvas_element_size,
 "emscripten_sleep": _emscripten_sleep,
 "emscripten_start_fetch": _emscripten_start_fetch,
 "emscripten_unwind_to_js_event_loop": _emscripten_unwind_to_js_event_loop,
 "emscripten_webgl_create_context": _emscripten_webgl_create_context,
 "environ_get": _environ_get,
 "environ_sizes_get": _environ_sizes_get,
 "exit": _exit,
 "fd_close": _fd_close,
 "fd_fdstat_get": _fd_fdstat_get,
 "fd_read": _fd_read,
 "fd_seek": _fd_seek,
 "fd_write": _fd_write,
 "getaddrinfo": _getaddrinfo,
 "gethostbyname": _gethostbyname,
 "getnameinfo": _getnameinfo,
 "gettimeofday": _gettimeofday,
 "memory": wasmMemory,
 "pthread_kill": _pthread_kill,
 "setTempRet0": _setTempRet0,
 "strftime": _strftime,
 "strftime_l": _strftime_l,
 "time": _time
};

var asm = createWasm();

var ___wasm_call_ctors = Module["___wasm_call_ctors"] = createExportWrapper("__wasm_call_ctors");

var _web_audio_play_process = Module["_web_audio_play_process"] = createExportWrapper("web_audio_play_process");

var _show_version = Module["_show_version"] = createExportWrapper("show_version");

var _printf = Module["_printf"] = createExportWrapper("printf");

var _global_init = Module["_global_init"] = createExportWrapper("global_init");

var _set_device_info = Module["_set_device_info"] = createExportWrapper("set_device_info");

var __Z18PI_set_device_infoPKcS0_S0_ = Module["__Z18PI_set_device_infoPKcS0_S0_"] = createExportWrapper("_Z18PI_set_device_infoPKcS0_S0_");

var _player_create = Module["_player_create"] = createExportWrapper("player_create");

var _player_destroy = Module["_player_destroy"] = createExportWrapper("player_destroy");

var _free = Module["_free"] = createExportWrapper("free");

var _set_ptcp_log_level = Module["_set_ptcp_log_level"] = createExportWrapper("set_ptcp_log_level");

var _set_pslstreaming_log_level = Module["_set_pslstreaming_log_level"] = createExportWrapper("set_pslstreaming_log_level");

var _set_psdemux_log_level = Module["_set_psdemux_log_level"] = createExportWrapper("set_psdemux_log_level");

var _set_dbgopt = Module["_set_dbgopt"] = createExportWrapper("set_dbgopt");

var _create_file = Module["_create_file"] = createExportWrapper("create_file");

var _show_file = Module["_show_file"] = createExportWrapper("show_file");

var _rm_filetype = Module["_rm_filetype"] = createExportWrapper("rm_filetype");

var _rm_file = Module["_rm_file"] = createExportWrapper("rm_file");

var _mv_file = Module["_mv_file"] = createExportWrapper("mv_file");

var _get_file = Module["_get_file"] = createExportWrapper("get_file");

var _malloc = Module["_malloc"] = createExportWrapper("malloc");

var _htonl = Module["_htonl"] = createExportWrapper("htonl");

var _PI_set_device_info_C = Module["_PI_set_device_info_C"] = createExportWrapper("PI_set_device_info_C");

var _web_video_decode_handler_wrap = Module["_web_video_decode_handler_wrap"] = createExportWrapper("web_video_decode_handler_wrap");

var _web_audio_decode_handler_wrap = Module["_web_audio_decode_handler_wrap"] = createExportWrapper("web_audio_decode_handler_wrap");

var _pthread_self = Module["_pthread_self"] = createExportWrapper("pthread_self");

var ___errno_location = Module["___errno_location"] = createExportWrapper("__errno_location");

var _htons = Module["_htons"] = createExportWrapper("htons");

var _ntohs = Module["_ntohs"] = createExportWrapper("ntohs");

var __Z18PI_get_device_infoPci = Module["__Z18PI_get_device_infoPci"] = createExportWrapper("_Z18PI_get_device_infoPci");

var __Z7MD5InitP7MD5_CTX = Module["__Z7MD5InitP7MD5_CTX"] = createExportWrapper("_Z7MD5InitP7MD5_CTX");

var __Z9MD5UpdateP7MD5_CTXPhj = Module["__Z9MD5UpdateP7MD5_CTXPhj"] = createExportWrapper("_Z9MD5UpdateP7MD5_CTXPhj");

var __Z8MD5FinalP7MD5_CTXPh = Module["__Z8MD5FinalP7MD5_CTXPh"] = createExportWrapper("_Z8MD5FinalP7MD5_CTXPh");

var __Z22checknetwork_ipv4_ipv6v = Module["__Z22checknetwork_ipv4_ipv6v"] = createExportWrapper("_Z22checknetwork_ipv4_ipv6v");

var __Z12pzb_parseurlPKcPciPjS1_iPii = Module["__Z12pzb_parseurlPKcPciPjS1_iPii"] = createExportWrapper("_Z12pzb_parseurlPKcPciPjS1_iPii");

var _pi_jsws_send = Module["_pi_jsws_send"] = createExportWrapper("pi_jsws_send");

var _pi_jsws_recv = Module["_pi_jsws_recv"] = createExportWrapper("pi_jsws_recv");

var _pi_jsws_close = Module["_pi_jsws_close"] = createExportWrapper("pi_jsws_close");

var _ws_create = Module["_ws_create"] = createExportWrapper("ws_create");

var _pi_jsws_url_connect = Module["_pi_jsws_url_connect"] = createExportWrapper("pi_jsws_url_connect");

var _pi_handle_callback = Module["_pi_handle_callback"] = createExportWrapper("pi_handle_callback");

var __Z11C_PZBC_InitPv = Module["__Z11C_PZBC_InitPv"] = createExportWrapper("_Z11C_PZBC_InitPv");

var __Z10C_PZBC_GetPvPcjS0_jjS0_PjS1_S0_S0_S1_S1_ = Module["__Z10C_PZBC_GetPvPcjS0_jjS0_PjS1_S0_S0_S1_S1_"] = createExportWrapper("_Z10C_PZBC_GetPvPcjS0_jjS0_PjS1_S0_S0_S1_S1_");

var __Z10C_PZBC_GetPvPcjS0_jjS0_PjS1_S0_S0_S1_S1_S1_S0_S1_ = Module["__Z10C_PZBC_GetPvPcjS0_jjS0_PjS1_S0_S0_S1_S1_S1_S0_S1_"] = createExportWrapper("_Z10C_PZBC_GetPvPcjS0_jjS0_PjS1_S0_S0_S1_S1_S1_S0_S1_");

var __Z14C_PZBC_PreloadPvPcjS0_jjPj = Module["__Z14C_PZBC_PreloadPvPcjS0_jjPj"] = createExportWrapper("_Z14C_PZBC_PreloadPvPcjS0_jjPj");

var __Z33C_Get_Info_From_PZB_With_StopflagPvjPcS0_PjS0_jS1_ = Module["__Z33C_Get_Info_From_PZB_With_StopflagPvjPcS0_PjS0_jS1_"] = createExportWrapper("_Z33C_Get_Info_From_PZB_With_StopflagPvjPcS0_PjS0_jS1_");

var __Z21DeleteReturnedContentPc = Module["__Z21DeleteReturnedContentPc"] = createExportWrapper("_Z21DeleteReturnedContentPc");

var __Z19C_PZBC_AddInfoToPZBPvPcS0_S0_jjj = Module["__Z19C_PZBC_AddInfoToPZBPvPcS0_S0_jjj"] = createExportWrapper("_Z19C_PZBC_AddInfoToPZBPvPcS0_S0_jjj");

var __Z16Room_Server_PostjPKcS0_PcPjj = Module["__Z16Room_Server_PostjPKcS0_PcPjj"] = createExportWrapper("_Z16Room_Server_PostjPKcS0_PcPjj");

var __Z28Room_Server_Post_With_HeaderjPKcS0_S0_PPcPjj = Module["__Z28Room_Server_Post_With_HeaderjPKcS0_S0_PPcPjj"] = createExportWrapper("_Z28Room_Server_Post_With_HeaderjPKcS0_S0_PPcPjj");

var __Z17Room_Server_Post2jPKcS0_PPcPjj = Module["__Z17Room_Server_Post2jPKcS0_PPcPjj"] = createExportWrapper("_Z17Room_Server_Post2jPKcS0_PPcPjj");

var __Z13BaseSetDomainPc = Module["__Z13BaseSetDomainPc"] = createExportWrapper("_Z13BaseSetDomainPc");

var _C_BaseGlobalInit = Module["_C_BaseGlobalInit"] = createExportWrapper("C_BaseGlobalInit");

var __Z14BaseGlobalInitiiii = Module["__Z14BaseGlobalInitiiii"] = createExportWrapper("_Z14BaseGlobalInitiiii");

var _C_BaseGlobalInitSimple = Module["_C_BaseGlobalInitSimple"] = createExportWrapper("C_BaseGlobalInitSimple");

var __Z14BaseGlobalInitPcii = Module["__Z14BaseGlobalInitPcii"] = createExportWrapper("_Z14BaseGlobalInitPcii");

var _C_BaseGlobalInitEx = Module["_C_BaseGlobalInitEx"] = createExportWrapper("C_BaseGlobalInitEx");

var __Z16BaseGlobalInitExiPcii = Module["__Z16BaseGlobalInitExiPcii"] = createExportWrapper("_Z16BaseGlobalInitExiPcii");

var _PZBC_Global_Set_LID = Module["_PZBC_Global_Set_LID"] = createExportWrapper("PZBC_Global_Set_LID");

var __Z23C_psSetForegroundStatusi = Module["__Z23C_psSetForegroundStatusi"] = createExportWrapper("_Z23C_psSetForegroundStatusi");

var __Z23C_psGetForegroundStatusv = Module["__Z23C_psGetForegroundStatusv"] = createExportWrapper("_Z23C_psGetForegroundStatusv");

var __Z24checkPZBDataAvailabilityPKci = Module["__Z24checkPZBDataAvailabilityPKci"] = createExportWrapper("_Z24checkPZBDataAvailabilityPKci");

var __Z16forceNetworkIpv6i = Module["__Z16forceNetworkIpv6i"] = createExportWrapper("_Z16forceNetworkIpv6i");

var __Z16PI_GetSDKVersionPc = Module["__Z16PI_GetSDKVersionPc"] = createExportWrapper("_Z16PI_GetSDKVersionPc");

var _C_Base_Global_Perf_Create = Module["_C_Base_Global_Perf_Create"] = createExportWrapper("C_Base_Global_Perf_Create");

var _C_Base_Global_Perf_Read = Module["_C_Base_Global_Perf_Read"] = createExportWrapper("C_Base_Global_Perf_Read");

var _C_Base_Global_Perf_Destroy = Module["_C_Base_Global_Perf_Destroy"] = createExportWrapper("C_Base_Global_Perf_Destroy");

var __Z16PZBC_Global_InitPv = Module["__Z16PZBC_Global_InitPv"] = createExportWrapper("_Z16PZBC_Global_InitPv");

var __Z21psSetForegroundStatusi = Module["__Z21psSetForegroundStatusi"] = createExportWrapper("_Z21psSetForegroundStatusi");

var __Z21psGetForegroundStatusv = Module["__Z21psGetForegroundStatusv"] = createExportWrapper("_Z21psGetForegroundStatusv");

var __Z19PI_set_device_info2PKcS0_S0_i = Module["__Z19PI_set_device_info2PKcS0_S0_i"] = createExportWrapper("_Z19PI_set_device_info2PKcS0_S0_i");

var __Z22converter_ipv4_to_ipv6iPvPci = Module["__Z22converter_ipv4_to_ipv6iPvPci"] = createExportWrapper("_Z22converter_ipv4_to_ipv6iPvPci");

var __Z20getnetwork_ipv4_ipv6v = Module["__Z20getnetwork_ipv4_ipv6v"] = createExportWrapper("_Z20getnetwork_ipv4_ipv6v");

var __Z20setnetwork_ipv4_ipv6i = Module["__Z20setnetwork_ipv4_ipv6i"] = createExportWrapper("_Z20setnetwork_ipv4_ipv6i");

var __Z25checknetworkipvx_setflushv = Module["__Z25checknetworkipvx_setflushv"] = createExportWrapper("_Z25checknetworkipvx_setflushv");

var __Z15xdns_setlogfuncPFviPKczE = Module["__Z15xdns_setlogfuncPFviPKczE"] = createExportWrapper("_Z15xdns_setlogfuncPFviPKczE");

var __Z15xdns_getlogfuncv = Module["__Z15xdns_getlogfuncv"] = createExportWrapper("_Z15xdns_getlogfuncv");

var __Z12MD5TransformPjPh = Module["__Z12MD5TransformPjPh"] = createExportWrapper("_Z12MD5TransformPjPh");

var __Z9MD5EncodePhPjj = Module["__Z9MD5EncodePhPjj"] = createExportWrapper("_Z9MD5EncodePhPjj");

var __Z9MD5DecodePjPhj = Module["__Z9MD5DecodePjPhj"] = createExportWrapper("_Z9MD5DecodePjPhj");

var _emscripten_tls_init = Module["_emscripten_tls_init"] = createExportWrapper("emscripten_tls_init");

var _emscripten_builtin_memalign = Module["_emscripten_builtin_memalign"] = createExportWrapper("emscripten_builtin_memalign");

var ___stdio_exit = Module["___stdio_exit"] = createExportWrapper("__stdio_exit");

var ___dl_seterr = Module["___dl_seterr"] = createExportWrapper("__dl_seterr");

var __emscripten_thread_crashed = Module["__emscripten_thread_crashed"] = createExportWrapper("_emscripten_thread_crashed");

var _emscripten_main_thread_process_queued_calls = Module["_emscripten_main_thread_process_queued_calls"] = createExportWrapper("emscripten_main_thread_process_queued_calls");

var __emscripten_thread_init = Module["__emscripten_thread_init"] = createExportWrapper("_emscripten_thread_init");

var _emscripten_current_thread_process_queued_calls = Module["_emscripten_current_thread_process_queued_calls"] = createExportWrapper("emscripten_current_thread_process_queued_calls");

var _emscripten_main_browser_thread_id = Module["_emscripten_main_browser_thread_id"] = createExportWrapper("emscripten_main_browser_thread_id");

var _emscripten_sync_run_in_main_thread_2 = Module["_emscripten_sync_run_in_main_thread_2"] = createExportWrapper("emscripten_sync_run_in_main_thread_2");

var _emscripten_sync_run_in_main_thread_4 = Module["_emscripten_sync_run_in_main_thread_4"] = createExportWrapper("emscripten_sync_run_in_main_thread_4");

var _emscripten_run_in_main_runtime_thread_js = Module["_emscripten_run_in_main_runtime_thread_js"] = createExportWrapper("emscripten_run_in_main_runtime_thread_js");

var _emscripten_dispatch_to_thread_ = Module["_emscripten_dispatch_to_thread_"] = createExportWrapper("emscripten_dispatch_to_thread_");

var _emscripten_stack_get_base = Module["_emscripten_stack_get_base"] = function() {
 return (_emscripten_stack_get_base = Module["_emscripten_stack_get_base"] = Module["asm"]["emscripten_stack_get_base"]).apply(null, arguments);
};

var _emscripten_stack_get_end = Module["_emscripten_stack_get_end"] = function() {
 return (_emscripten_stack_get_end = Module["_emscripten_stack_get_end"] = Module["asm"]["emscripten_stack_get_end"]).apply(null, arguments);
};

var __emscripten_thread_free_data = Module["__emscripten_thread_free_data"] = createExportWrapper("_emscripten_thread_free_data");

var __emscripten_thread_exit = Module["__emscripten_thread_exit"] = createExportWrapper("_emscripten_thread_exit");

var _emscripten_stack_init = Module["_emscripten_stack_init"] = function() {
 return (_emscripten_stack_init = Module["_emscripten_stack_init"] = Module["asm"]["emscripten_stack_init"]).apply(null, arguments);
};

var _emscripten_stack_set_limits = Module["_emscripten_stack_set_limits"] = function() {
 return (_emscripten_stack_set_limits = Module["_emscripten_stack_set_limits"] = Module["asm"]["emscripten_stack_set_limits"]).apply(null, arguments);
};

var _emscripten_stack_get_free = Module["_emscripten_stack_get_free"] = function() {
 return (_emscripten_stack_get_free = Module["_emscripten_stack_get_free"] = Module["asm"]["emscripten_stack_get_free"]).apply(null, arguments);
};

var stackSave = Module["stackSave"] = createExportWrapper("stackSave");

var stackRestore = Module["stackRestore"] = createExportWrapper("stackRestore");

var stackAlloc = Module["stackAlloc"] = createExportWrapper("stackAlloc");

var dynCall_iiiiiij = Module["dynCall_iiiiiij"] = createExportWrapper("dynCall_iiiiiij");

var dynCall_iiiijjji = Module["dynCall_iiiijjji"] = createExportWrapper("dynCall_iiiijjji");

var dynCall_ijiii = Module["dynCall_ijiii"] = createExportWrapper("dynCall_ijiii");

var dynCall_iiiji = Module["dynCall_iiiji"] = createExportWrapper("dynCall_iiiji");

var dynCall_jiiij = Module["dynCall_jiiij"] = createExportWrapper("dynCall_jiiij");

var dynCall_jiji = Module["dynCall_jiji"] = createExportWrapper("dynCall_jiji");

var dynCall_jiiji = Module["dynCall_jiiji"] = createExportWrapper("dynCall_jiiji");

var dynCall_iiijjji = Module["dynCall_iiijjji"] = createExportWrapper("dynCall_iiijjji");

var dynCall_iiiiij = Module["dynCall_iiiiij"] = createExportWrapper("dynCall_iiiiij");

var dynCall_viiijj = Module["dynCall_viiijj"] = createExportWrapper("dynCall_viiijj");

var dynCall_jij = Module["dynCall_jij"] = createExportWrapper("dynCall_jij");

var dynCall_jii = Module["dynCall_jii"] = createExportWrapper("dynCall_jii");

var dynCall_ji = Module["dynCall_ji"] = createExportWrapper("dynCall_ji");

var dynCall_viijii = Module["dynCall_viijii"] = createExportWrapper("dynCall_viijii");

var dynCall_iiiiijj = Module["dynCall_iiiiijj"] = createExportWrapper("dynCall_iiiiijj");

var dynCall_iiiiiijj = Module["dynCall_iiiiiijj"] = createExportWrapper("dynCall_iiiiiijj");

var __emscripten_allow_main_runtime_queued_calls = Module["__emscripten_allow_main_runtime_queued_calls"] = 611620;

unexportedRuntimeFunction("intArrayFromString", false);

unexportedRuntimeFunction("intArrayToString", false);

Module["ccall"] = ccall;

Module["cwrap"] = cwrap;

unexportedRuntimeFunction("setValue", false);

unexportedRuntimeFunction("getValue", false);

unexportedRuntimeFunction("allocate", false);

unexportedRuntimeFunction("UTF8ArrayToString", false);

Module["UTF8ToString"] = UTF8ToString;

unexportedRuntimeFunction("stringToUTF8Array", false);

unexportedRuntimeFunction("stringToUTF8", false);

unexportedRuntimeFunction("lengthBytesUTF8", false);

unexportedRuntimeFunction("stackTrace", false);

unexportedRuntimeFunction("addOnPreRun", false);

unexportedRuntimeFunction("addOnInit", false);

unexportedRuntimeFunction("addOnPreMain", false);

unexportedRuntimeFunction("addOnExit", false);

unexportedRuntimeFunction("addOnPostRun", false);

unexportedRuntimeFunction("writeStringToMemory", false);

Module["writeArrayToMemory"] = writeArrayToMemory;

Module["writeAsciiToMemory"] = writeAsciiToMemory;

Module["addRunDependency"] = addRunDependency;

Module["removeRunDependency"] = removeRunDependency;

unexportedRuntimeFunction("FS_createFolder", false);

Module["FS_createPath"] = FS.createPath;

Module["FS_createDataFile"] = FS.createDataFile;

Module["FS_createPreloadedFile"] = FS.createPreloadedFile;

Module["FS_createLazyFile"] = FS.createLazyFile;

unexportedRuntimeFunction("FS_createLink", false);

Module["FS_createDevice"] = FS.createDevice;

Module["FS_unlink"] = FS.unlink;

unexportedRuntimeFunction("getLEB", false);

unexportedRuntimeFunction("getFunctionTables", false);

unexportedRuntimeFunction("alignFunctionTables", false);

unexportedRuntimeFunction("registerFunctions", false);

Module["addFunction"] = addFunction;

Module["removeFunction"] = removeFunction;

unexportedRuntimeFunction("getFuncWrapper", false);

unexportedRuntimeFunction("prettyPrint", false);

unexportedRuntimeFunction("dynCall", false);

unexportedRuntimeFunction("getCompilerSetting", false);

unexportedRuntimeFunction("print", false);

unexportedRuntimeFunction("printErr", false);

unexportedRuntimeFunction("getTempRet0", false);

unexportedRuntimeFunction("setTempRet0", false);

unexportedRuntimeFunction("callMain", false);

unexportedRuntimeFunction("abort", false);

Module["keepRuntimeAlive"] = keepRuntimeAlive;

unexportedRuntimeFunction("zeroMemory", false);

unexportedRuntimeFunction("stringToNewUTF8", false);

unexportedRuntimeFunction("emscripten_realloc_buffer", false);

unexportedRuntimeFunction("ENV", false);

unexportedRuntimeFunction("withStackSave", false);

unexportedRuntimeFunction("ERRNO_CODES", false);

unexportedRuntimeFunction("ERRNO_MESSAGES", false);

unexportedRuntimeFunction("setErrNo", false);

unexportedRuntimeFunction("inetPton4", false);

unexportedRuntimeFunction("inetNtop4", false);

unexportedRuntimeFunction("inetPton6", false);

unexportedRuntimeFunction("inetNtop6", false);

unexportedRuntimeFunction("readSockaddr", false);

unexportedRuntimeFunction("writeSockaddr", false);

unexportedRuntimeFunction("DNS", false);

unexportedRuntimeFunction("getHostByName", false);

unexportedRuntimeFunction("Protocols", false);

unexportedRuntimeFunction("Sockets", false);

unexportedRuntimeFunction("getRandomDevice", false);

unexportedRuntimeFunction("traverseStack", false);

unexportedRuntimeFunction("convertFrameToPC", false);

unexportedRuntimeFunction("UNWIND_CACHE", false);

unexportedRuntimeFunction("saveInUnwindCache", false);

unexportedRuntimeFunction("convertPCtoSourceLocation", false);

unexportedRuntimeFunction("readAsmConstArgsArray", false);

unexportedRuntimeFunction("readAsmConstArgs", false);

unexportedRuntimeFunction("mainThreadEM_ASM", false);

unexportedRuntimeFunction("jstoi_q", false);

unexportedRuntimeFunction("jstoi_s", false);

unexportedRuntimeFunction("getExecutableName", false);

unexportedRuntimeFunction("listenOnce", false);

unexportedRuntimeFunction("autoResumeAudioContext", false);

unexportedRuntimeFunction("dynCallLegacy", false);

unexportedRuntimeFunction("getDynCaller", false);

unexportedRuntimeFunction("dynCall", false);

unexportedRuntimeFunction("callRuntimeCallbacks", false);

unexportedRuntimeFunction("wasmTableMirror", false);

unexportedRuntimeFunction("setWasmTableEntry", false);

unexportedRuntimeFunction("getWasmTableEntry", false);

unexportedRuntimeFunction("handleException", false);

unexportedRuntimeFunction("runtimeKeepalivePush", false);

unexportedRuntimeFunction("runtimeKeepalivePop", false);

unexportedRuntimeFunction("callUserCallback", false);

unexportedRuntimeFunction("maybeExit", false);

unexportedRuntimeFunction("safeSetTimeout", false);

unexportedRuntimeFunction("asmjsMangle", false);

unexportedRuntimeFunction("asyncLoad", false);

unexportedRuntimeFunction("alignMemory", false);

unexportedRuntimeFunction("mmapAlloc", false);

unexportedRuntimeFunction("reallyNegative", false);

unexportedRuntimeFunction("unSign", false);

unexportedRuntimeFunction("reSign", false);

unexportedRuntimeFunction("formatString", false);

unexportedRuntimeFunction("PATH", false);

unexportedRuntimeFunction("PATH_FS", false);

unexportedRuntimeFunction("SYSCALLS", false);

unexportedRuntimeFunction("getSocketFromFD", false);

unexportedRuntimeFunction("getSocketAddress", false);

unexportedRuntimeFunction("JSEvents", false);

unexportedRuntimeFunction("registerKeyEventCallback", false);

unexportedRuntimeFunction("specialHTMLTargets", false);

unexportedRuntimeFunction("maybeCStringToJsString", false);

unexportedRuntimeFunction("findEventTarget", false);

unexportedRuntimeFunction("findCanvasEventTarget", false);

unexportedRuntimeFunction("getBoundingClientRect", false);

unexportedRuntimeFunction("fillMouseEventData", false);

unexportedRuntimeFunction("registerMouseEventCallback", false);

unexportedRuntimeFunction("registerWheelEventCallback", false);

unexportedRuntimeFunction("registerUiEventCallback", false);

unexportedRuntimeFunction("registerFocusEventCallback", false);

unexportedRuntimeFunction("fillDeviceOrientationEventData", false);

unexportedRuntimeFunction("registerDeviceOrientationEventCallback", false);

unexportedRuntimeFunction("fillDeviceMotionEventData", false);

unexportedRuntimeFunction("registerDeviceMotionEventCallback", false);

unexportedRuntimeFunction("screenOrientation", false);

unexportedRuntimeFunction("fillOrientationChangeEventData", false);

unexportedRuntimeFunction("registerOrientationChangeEventCallback", false);

unexportedRuntimeFunction("fillFullscreenChangeEventData", false);

unexportedRuntimeFunction("registerFullscreenChangeEventCallback", false);

unexportedRuntimeFunction("registerRestoreOldStyle", false);

unexportedRuntimeFunction("hideEverythingExceptGivenElement", false);

unexportedRuntimeFunction("restoreHiddenElements", false);

unexportedRuntimeFunction("setLetterbox", false);

unexportedRuntimeFunction("currentFullscreenStrategy", false);

unexportedRuntimeFunction("restoreOldWindowedStyle", false);

unexportedRuntimeFunction("softFullscreenResizeWebGLRenderTarget", false);

unexportedRuntimeFunction("doRequestFullscreen", false);

unexportedRuntimeFunction("fillPointerlockChangeEventData", false);

unexportedRuntimeFunction("registerPointerlockChangeEventCallback", false);

unexportedRuntimeFunction("registerPointerlockErrorEventCallback", false);

unexportedRuntimeFunction("requestPointerLock", false);

unexportedRuntimeFunction("fillVisibilityChangeEventData", false);

unexportedRuntimeFunction("registerVisibilityChangeEventCallback", false);

unexportedRuntimeFunction("registerTouchEventCallback", false);

unexportedRuntimeFunction("fillGamepadEventData", false);

unexportedRuntimeFunction("registerGamepadEventCallback", false);

unexportedRuntimeFunction("registerBeforeUnloadEventCallback", false);

unexportedRuntimeFunction("fillBatteryEventData", false);

unexportedRuntimeFunction("battery", false);

unexportedRuntimeFunction("registerBatteryEventCallback", false);

unexportedRuntimeFunction("setCanvasElementSize", false);

unexportedRuntimeFunction("getCanvasElementSize", false);

unexportedRuntimeFunction("demangle", false);

unexportedRuntimeFunction("demangleAll", false);

unexportedRuntimeFunction("jsStackTrace", false);

unexportedRuntimeFunction("stackTrace", false);

unexportedRuntimeFunction("getEnvStrings", false);

unexportedRuntimeFunction("checkWasiClock", false);

unexportedRuntimeFunction("writeI53ToI64", false);

unexportedRuntimeFunction("writeI53ToI64Clamped", false);

unexportedRuntimeFunction("writeI53ToI64Signaling", false);

unexportedRuntimeFunction("writeI53ToU64Clamped", false);

unexportedRuntimeFunction("writeI53ToU64Signaling", false);

unexportedRuntimeFunction("readI53FromI64", false);

unexportedRuntimeFunction("readI53FromU64", false);

unexportedRuntimeFunction("convertI32PairToI53", false);

unexportedRuntimeFunction("convertU32PairToI53", false);

unexportedRuntimeFunction("setImmediateWrapped", false);

unexportedRuntimeFunction("clearImmediateWrapped", false);

unexportedRuntimeFunction("polyfillSetImmediate", false);

unexportedRuntimeFunction("uncaughtExceptionCount", false);

unexportedRuntimeFunction("exceptionLast", false);

unexportedRuntimeFunction("exceptionCaught", false);

unexportedRuntimeFunction("ExceptionInfo", false);

unexportedRuntimeFunction("CatchInfo", false);

unexportedRuntimeFunction("exception_addRef", false);

unexportedRuntimeFunction("exception_decRef", false);

unexportedRuntimeFunction("Browser", false);

unexportedRuntimeFunction("funcWrappers", false);

unexportedRuntimeFunction("getFuncWrapper", false);

unexportedRuntimeFunction("setMainLoop", false);

unexportedRuntimeFunction("wget", false);

unexportedRuntimeFunction("tempFixedLengthArray", false);

unexportedRuntimeFunction("miniTempWebGLFloatBuffers", false);

unexportedRuntimeFunction("heapObjectForWebGLType", false);

unexportedRuntimeFunction("heapAccessShiftForWebGLHeap", false);

unexportedRuntimeFunction("GL", false);

unexportedRuntimeFunction("emscriptenWebGLGet", false);

unexportedRuntimeFunction("computeUnpackAlignedImageSize", false);

unexportedRuntimeFunction("emscriptenWebGLGetTexPixelData", false);

unexportedRuntimeFunction("emscriptenWebGLGetUniform", false);

unexportedRuntimeFunction("webglGetUniformLocation", false);

unexportedRuntimeFunction("webglPrepareUniformLocationsBeforeFirstUse", false);

unexportedRuntimeFunction("webglGetLeftBracePos", false);

unexportedRuntimeFunction("emscriptenWebGLGetVertexAttrib", false);

unexportedRuntimeFunction("writeGLArray", false);

unexportedRuntimeFunction("FS", false);

unexportedRuntimeFunction("MEMFS", false);

unexportedRuntimeFunction("TTY", false);

unexportedRuntimeFunction("PIPEFS", false);

unexportedRuntimeFunction("SOCKFS", false);

unexportedRuntimeFunction("_setNetworkCallback", false);

unexportedRuntimeFunction("AL", false);

unexportedRuntimeFunction("SDL_unicode", false);

unexportedRuntimeFunction("SDL_ttfContext", false);

unexportedRuntimeFunction("SDL_audio", false);

unexportedRuntimeFunction("SDL", false);

unexportedRuntimeFunction("SDL_gfx", false);

unexportedRuntimeFunction("GLUT", false);

unexportedRuntimeFunction("EGL", false);

unexportedRuntimeFunction("GLFW_Window", false);

unexportedRuntimeFunction("GLFW", false);

unexportedRuntimeFunction("GLEW", false);

unexportedRuntimeFunction("IDBStore", false);

unexportedRuntimeFunction("runAndAbortIfError", false);

unexportedRuntimeFunction("Fetch", false);

unexportedRuntimeFunction("fetchDeleteCachedData", false);

unexportedRuntimeFunction("fetchLoadCachedData", false);

unexportedRuntimeFunction("fetchCacheData", false);

unexportedRuntimeFunction("fetchXHR", false);

Module["PThread"] = PThread;

unexportedRuntimeFunction("ptrToString", false);

unexportedRuntimeFunction("killThread", false);

unexportedRuntimeFunction("cleanupThread", false);

unexportedRuntimeFunction("registerTlsInit", false);

unexportedRuntimeFunction("cancelThread", false);

unexportedRuntimeFunction("spawnThread", false);

unexportedRuntimeFunction("exitOnMainThread", false);

unexportedRuntimeFunction("establishStackSpace", false);

unexportedRuntimeFunction("invokeEntryPoint", false);

unexportedRuntimeFunction("warnOnce", false);

unexportedRuntimeFunction("stackSave", false);

unexportedRuntimeFunction("stackRestore", false);

unexportedRuntimeFunction("stackAlloc", false);

unexportedRuntimeFunction("AsciiToString", false);

unexportedRuntimeFunction("stringToAscii", false);

unexportedRuntimeFunction("UTF16ToString", false);

unexportedRuntimeFunction("stringToUTF16", false);

unexportedRuntimeFunction("lengthBytesUTF16", false);

unexportedRuntimeFunction("UTF32ToString", false);

unexportedRuntimeFunction("stringToUTF32", false);

unexportedRuntimeFunction("lengthBytesUTF32", false);

unexportedRuntimeFunction("allocateUTF8", false);

unexportedRuntimeFunction("allocateUTF8OnStack", false);

Module["writeStackCookie"] = writeStackCookie;

Module["checkStackCookie"] = checkStackCookie;

Module["PThread"] = PThread;

Module["wasmMemory"] = wasmMemory;

Module["ExitStatus"] = ExitStatus;

unexportedRuntimeSymbol("ALLOC_NORMAL", false);

unexportedRuntimeSymbol("ALLOC_STACK", false);

var calledRun;

function ExitStatus(status) {
 this.name = "ExitStatus";
 this.message = "Program terminated with exit(" + status + ")";
 this.status = status;
}

var calledMain = false;

dependenciesFulfilled = function runCaller() {
 if (!calledRun) run();
 if (!calledRun) dependenciesFulfilled = runCaller;
};

function stackCheckInit() {
 _emscripten_stack_init();
 writeStackCookie();
}

function run(args) {
 args = args || arguments_;
 if (runDependencies > 0) {
  return;
 }
 stackCheckInit();
 if (ENVIRONMENT_IS_PTHREAD) {
  initRuntime();
  postMessage({
   "cmd": "loaded"
  });
  return;
 }
 preRun();
 if (runDependencies > 0) {
  return;
 }
 function doRun() {
  if (calledRun) return;
  calledRun = true;
  Module["calledRun"] = true;
  if (ABORT) return;
  initRuntime();
  if (Module["onRuntimeInitialized"]) Module["onRuntimeInitialized"]();
  assert(!Module["_main"], 'compiled without a main, but one is present. if you added it from JS, use Module["onRuntimeInitialized"]');
  postRun();
 }
 if (Module["setStatus"]) {
  Module["setStatus"]("Running...");
  setTimeout(function() {
   setTimeout(function() {
    Module["setStatus"]("");
   }, 1);
   doRun();
  }, 1);
 } else {
  doRun();
 }
 checkStackCookie();
}

Module["run"] = run;

function checkUnflushedContent() {
 var oldOut = out;
 var oldErr = err;
 var has = false;
 out = err = (x => {
  has = true;
 });
 try {
  ___stdio_exit();
  [ "stdout", "stderr" ].forEach(function(name) {
   var info = FS.analyzePath("/dev/" + name);
   if (!info) return;
   var stream = info.object;
   var rdev = stream.rdev;
   var tty = TTY.ttys[rdev];
   if (tty && tty.output && tty.output.length) {
    has = true;
   }
  });
 } catch (e) {}
 out = oldOut;
 err = oldErr;
 if (has) {
  warnOnce("stdio streams had content in them that was not flushed. you should set EXIT_RUNTIME to 1 (see the FAQ), or make sure to emit a newline when you printf etc.");
 }
}

function exit(status, implicit) {
 EXITSTATUS = status;
 if (!runtimeKeepaliveCounter) {
  checkUnflushedContent();
 }
 if (!implicit) {
  if (ENVIRONMENT_IS_PTHREAD) {
   exitOnMainThread(status);
   throw "unwind";
  } else {}
 }
 if (keepRuntimeAlive()) {
  if (!implicit) {
   var msg = "program exited (with status: " + status + "), but EXIT_RUNTIME is not set, so halting execution but not exiting the runtime or preventing further async execution (build with EXIT_RUNTIME=1, if you want a true shutdown)";
   err(msg);
  }
 } else {
  exitRuntime();
 }
 procExit(status);
}

function procExit(code) {
 EXITSTATUS = code;
 if (!keepRuntimeAlive()) {
  PThread.terminateAllThreads();
  if (Module["onExit"]) Module["onExit"](code);
  ABORT = true;
 }
 quit_(code, new ExitStatus(code));
}

if (Module["preInit"]) {
 if (typeof Module["preInit"] == "function") Module["preInit"] = [ Module["preInit"] ];
 while (Module["preInit"].length > 0) {
  Module["preInit"].pop()();
 }
}

run();

let WS = {};

const WS_OPCODE_TEXT = 1;

const WS_OPCODE_BINARY = 2;

const PI_STATE_CONNECTING = 0, PI_STATE_OPEN = 1, PI_STATE_CLOSING = 2, PI_STATE_CLOSED = 3, PI_EVENT_NULL = 0, PI_EVENT_OPEN = 1, PI_EVENT_RECEIVE_MESSAGE = 2, PI_EVENT_ERROR = 3, PI_EVENT_CLOSE = 4, PI_DATA_NULL = 0, PI_DATA_MESSAGE = 1, PI_PROTOCOL_NULL = 0, PI_WEBSOCKET = 1, PI_WEBTRANSPORT = 2;

const jsws_malloc = Module.cwrap("malloc", "number", [ "number" ]);

const jsws_free = Module.cwrap("free", "null", [ "number" ]);

const pi_event_handler = Module.cwrap("pi_handle_callback", "number", [ "number", "number", "number", "number" ]);

function stringToCString(input_str) {
 let c_buffer = jsws_malloc(input_str.length + 4);
 stringToUTF8(input_str, c_buffer, input_str.length + 4);
 return c_buffer;
}

function create_PI_socket(e_protocol) {
 if (e_protocol === PI_WEBSOCKET) return new PIWebSocket(arguments[1], arguments[2], arguments[3]); else if (e_protocol === PI_WEBTRANSPORT) return new PIWebTransport(arguments[1], arguments[2]); else console.error("invalid protocol: ", e_protocol);
 return null;
}

function PI_on_message(p_socket, data) {
 let typed_array = new Int8Array(data);
 let c_buffer = jsws_malloc(typed_array.length);
 writeArrayToMemory(typed_array, c_buffer);
 pi_event_handler(p_socket, PI_EVENT_RECEIVE_MESSAGE, c_buffer, typed_array.length);
}

class PIWebTransport {
 constructor(c_ptr, url) {
  let url_str = UTF8ToString(url);
  this.wt = new WebTransport(url_str);
  this.c_ptr = c_ptr;
  WS[c_ptr] = this;
  this.readyState = PI_STATE_CONNECTING;
  this.wt.ready.then(() => {
   this.datagram_writer = this.wt.datagrams.writable.getWriter();
   let dr = this.datagram_reader = this.wt.datagrams.readable.getReader();
   let c_ptr = this.c_ptr;
   this.datagram_reader.read().then(function processData({value: value, done: done}) {
    if (done) {
     return null;
    }
    PI_on_message(c_ptr, value);
    return dr.read().then(processData).catch(e => {
     console.log(e);
    });
   }).catch(e => {
    console.log(e);
   });
   this.readyState = PI_STATE_OPEN;
   console.info("connection " + c_ptr + " succeed");
   return true;
  }).catch(e => {
   this.readyState = PI_STATE_CLOSED;
   console.warn("connection " + c_ptr + " failed");
   return false;
  });
  this.wt.closed.then(close_info => {
   pi_event_handler(this.c_ptr, PI_EVENT_CLOSE, 0, 0);
   this.readyState = PI_STATE_CLOSED;
   console.info("WebTransport " + c_ptr + " closed normally: ", close_info.reason);
  }).catch(error => {
   pi_event_handler(this.c_ptr, PI_EVENT_CLOSE, 0, 0);
   this.readyState = PI_STATE_CLOSED;
   console.warn("WebTransport " + c_ptr + " closed with error: ", error);
  });
 }
 send(p_content, length) {
  let data = Module.HEAPU8.slice(p_content, p_content + length);
  if (this.readyState !== PI_STATE_OPEN) return -1;
  this.datagram_writer.write(data).then(() => {});
  return length;
 }
 close() {
  if (this.readyState === PI_STATE_CLOSED) return;
  this.wt.close({
   "closeCode": 0,
   "reason": "close called by upstream application"
  });
  return 0;
 }
 state() {
  return this.readyState;
 }
}

class PIWebSocket {
 constructor(c_ptr, url, protocol) {
  let url_str = UTF8ToString(url);
  let protocol_str = UTF8ToString(protocol);
  this.c_ptr = c_ptr;
  this.url = url_str;
  this.protocol = protocol_str;
  this.ws_obj = new WebSocket(url_str, protocol_str);
  this.ws_obj.onopen = this._open_handler.bind(this);
  this.ws_obj.onclose = this._close_handler.bind(this);
  this.ws_obj.onmessage = this._message_handler.bind(this);
  this.ws_obj.onerror = this._error_handler.bind(this);
  WS[this.c_ptr] = this;
 }
 _open_handler(evt) {
  console.info(evt);
  pi_event_handler(this.c_ptr, PI_EVENT_OPEN, 0, 0);
 }
 _close_handler(evt) {
  console.info(evt);
  pi_event_handler(this.c_ptr, PI_EVENT_CLOSE, 0, 0);
 }
 _message_handler(evt) {
  if (Object.prototype.toString.call(evt.data) === "[object Blob]") {
   evt.data.arrayBuffer().then(value => {
    PI_on_message(this.c_ptr, value);
   }).catch(e => {
    console.error(e);
   });
  } else if (Object.prototype.toString.call(evt.data) === "[object String]") {
   let p_data = stringToCString(evt.data);
   pi_event_handler(this.c_ptr, PI_EVENT_RECEIVE_MESSAGE, p_data, evt.data.length);
  }
 }
 _error_handler(evt) {
  console.warn(evt);
  pi_event_handler(this.c_ptr, PI_EVENT_ERROR, 0, 0);
 }
 send(p_content, length) {
  let data = Module.HEAPU8.slice(p_content, p_content + length);
  if (this.ws_obj.readyState !== WebSocket.OPEN) {
   let errmsg = "WebSocket is in CLOSING or CLOSED state.";
   console.warn(errmsg);
   return -1;
  }
  try {
   this.ws_obj.send(data);
  } catch (err) {
   console.warn(err);
   return -1;
  }
  return 0;
 }
 close() {
  this.c_ptr = null;
  this.ws_obj.onopen = null;
  this.ws_obj.onclose = null;
  this.ws_obj.onmessage = null;
  this.ws_obj.onerror = null;
  this.ws_obj.close();
  if (this.state() === WebSocket.OPEN) {
   return 0;
  } else {
   console.info("close() called on a websocket in " + this.state() + " state.");
   return -1;
  }
 }
 state() {
  return this.ws_obj.readyState;
 }
}

function add_text_by_id(id, text) {
 let dom = document.getElementById(id);
 dom.value = dom.value + text.toString();
}

let ws_handle;

function connect_button_onclick() {
 let url = document.getElementById("websocket_url_input").value;
 let subprotocol = document.getElementById("websocket_protocol_input").value;
 let protocol = document.getElementById("select_protocol").value;
 let e_protocol;
 if (protocol === "websocket") {
  e_protocol = PI_WEBSOCKET;
 } else {
  e_protocol = PI_WEBTRANSPORT;
 }
 ws_handle = Module.ccall("pi_jsws_url_connect", "number", [ "string", "number" ], [ url, e_protocol ]);
 document.getElementById("receive_textarea").value = "";
}

function send_button_onclick() {
 let content = document.getElementById("websocket_content_input").value + "\0";
 let bytes_sent = Module.ccall("pi_jsws_send", "number", [ "number", "string", "number" ], [ ws_handle, content, content.length ]);
}

function recv_button_onclick() {
 let buffer_length = 2048;
 let content = jsws_malloc(buffer_length);
 let bytes_received = Module.ccall("pi_jsws_recv", "number", [ "number", "number", "number", "number" ], [ ws_handle, content, buffer_length, 0 ]);
 if (bytes_received) {
  let textarea = document.getElementById("receive_textarea");
  setValue(content + bytes_received, 0, "i8");
  textarea.value = textarea.value + UTF8ToString(content) + "\n";
 }
 jsws_free(content);
}

function close_button_onclick() {
 Module.ccall("pi_jsws_close", "number", [ "number" ], [ ws_handle ]);
}

function custom_button_work() {
 console.log("custom_button_work");
 Module.ccall("custom_test", "int", [], []);
}

function socket_test_button_work() {
 let url = document.getElementById("server_url_input").value;
 console.log("socket test starts");
 Module.ccall("socket_test", "int", [ "string" ], [ url ]);
}

var g_show_draw = 0;

var g_dump264 = 0;

var g_display_cnt = {};

var g_medias = [];

var g_modules = [];

var g_webgl_render = null;

var g_screenshot_ctx = null;

var g_yuvbuffer = null;

var g_yuvbuffer_size = -1;

const SIZEOF_POINT = 4;

const POINT_TYPE = "i";

const SIZEOF_FLOAT32 = 4;

const SIZEOF_FLOAT64 = 8;

const SIZEOF_INT32 = 4;

const SIZEOF_UINT32 = 4;

const SIZEOF_INT64 = 8;

const SIZEOF_UINT64 = 8;

const malloc = Module.cwrap("malloc", "number", [ "number" ]);

const free = Module.cwrap("free", "null", [ "number" ]);

const c_web_audio_play_process = Module.cwrap("web_audio_play_process", "number", [ "number", "number", "number" ]);

const web_video_decode_handler_wrap = Module.cwrap("web_video_decode_handler_wrap", "number", [ "number", "string", "string", "number", "number", "number", "number", "number", "number", "number", "number" ]);

const web_audio_decode_handler_wrap = Module.cwrap("web_audio_decode_handler_wrap", "number", [ "number", "string", "string", "number", "number", "number", "number", "number", "number" ]);

const global_init = Module.cwrap("global_init", "null");

const set_device_info = Module.cwrap("set_device_info", "number", [ "string", "string", "string" ]);

const PIMediaPlayer_set_ptcp_log_level = Module.cwrap("set_ptcp_log_level", "number", [ "number" ]);

const PIMediaPlayer_set_pslstreaming_log_level = Module.cwrap("set_pslstreaming_log_level", "number", [ "number" ]);

const PIMediaPlayer_set_psdemux_log_level = Module.cwrap("set_psdemux_log_level", "number", [ "number" ]);

const PIMediaPlayer_create = Module.cwrap("player_create", "number", [ "string", "string", "string" ]);

const PIMediaPlayer_destroy = Module.cwrap("player_destroy", "number", [ "string" ]);

const set_dbgopt = Module.cwrap("set_dbgopt", "number", [ "number" ]);

const show_version = Module.cwrap("show_version", "null");

const create_file = Module.cwrap("create_file", "null", [ "string", "number", "number" ]);

const show_file = Module.cwrap("show_file", "null");

const rm_file = Module.cwrap("rm_file", "null", [ "string" ]);

const mv_file = Module.cwrap("mv_file", "null", [ "string", "string" ]);

const c_get_file = Module.cwrap("get_file", "number", [ "string" ]);

const rm_filetype = Module.cwrap("rm_filetype", "null", [ "number", "number" ]);

const set_save_all_pkt = Module.cwrap("set_save_all_pkt", "null", [ "number" ]);

const set_save_all_yuv = Module.cwrap("set_save_all_yuv", "null", [ "number" ]);

function now() {
 var cur_tm = new Date();
 return "[" + cur_tm.toLocaleString() + "." + String(cur_tm.getMilliseconds() + 1e3).substring(1, 4) + "]";
}

function num2str(num) {
 var str = String(Math.floor(num * 1e3));
 while (str.length <= 3) {
  str = "0" + str;
 }
 return str.substring(0, str.length - 3) + "." + str.substring(str.length - 3);
}

function cStringToString(pointer) {
 var str_length = 0;
 while (true) {
  if (Module.HEAPU8.subarray(pointer + str_length, pointer + str_length + 1)[0] == 0) {
   break;
  }
  str_length += 1;
 }
 var u8arr = new Uint8Array(Module.HEAPU8.subarray(pointer, pointer + str_length), str_length);
 var tmpstr_list = [];
 for (var i = 0; i < u8arr.length; i++) {
  tmpstr_list.push(String.fromCharCode(u8arr[i]));
 }
 return tmpstr_list.join("");
}

function u32sToI64(u32_l, u32_h) {
 if (u32_l < 0) {
  u32_l += Math.pow(2, 32);
 }
 if (u32_h < 0) {
  u32_h += Math.pow(2, 32);
 }
 var i64 = (BigInt(u32_h) << BigInt(32)) + BigInt(u32_l);
 if (i64 > (BigInt(1) << BigInt(63)) - BigInt(1)) {
  i64 -= BigInt(1) << BigInt(64);
 }
 return i64;
}

function find_video_stream(media_name, stream_name) {
 var media_index = -1;
 for (var i = 0; i < g_medias.length; i++) {
  if (g_medias[i].name == media_name) {
   media_index = i;
   break;
  }
 }
 if (media_index == -1) {
  return [ -1, -1 ];
 }
 var media = g_medias[media_index];
 var stream_index = -1;
 for (var i = 0; i < media.videos.length; i++) {
  if (media.videos[i].name == stream_name) {
   stream_index = i;
   break;
  }
 }
 return [ media_index, stream_index ];
}

function find_audio_stream(media_name, stream_name) {
 var media_index = -1;
 for (var i = 0; i < g_medias.length; i++) {
  if (g_medias[i].name == media_name) {
   media_index = i;
   break;
  }
 }
 if (media_index == -1) {
  return [ -1, -1 ];
 }
 var media = g_medias[media_index];
 var stream_index = -1;
 for (var i = 0; i < media.audios.length; i++) {
  if (media.audios[i].name == stream_name) {
   stream_index = i;
   break;
  }
 }
 if (stream_index == -1) {
  return [ -1, -1 ];
 }
 return [ media_index, stream_index ];
}

class PIVideoFrame {
 constructor(media_name, stream_name, tag, videoFrame) {
  this.media_name = media_name;
  this.stream_name = stream_name;
  this.tag = tag;
  this.frame = videoFrame;
 }
}

class FInfo {
 constructor(pts, pos, duration) {
  this.pts = pts;
  this.pos = pos;
  this.duration = duration;
 }
}

class PIDump {
 constructor(wsurl) {
  this.cache_queue = [];
  this.ws_obj = new WebSocket(wsurl);
  this.ws_obj.onopen = this.on_open.bind(this);
  this.ws_obj.onclose = this.on_close.bind(this);
  this.ws_obj.onerror = this.on_error.bind(this);
  this.state = "inited";
 }
 on_open() {
  console.log("dump opened");
  console.log(this);
  this.state = "opened";
  while (this.cache_queue.length != 0) {
   this.ws_obj.send(this.cache_queue.shift());
  }
 }
 on_close() {
  this.state = "closed";
 }
 on_error() {
  this.state = "closed";
 }
 media_info(width, height, codec, desc) {
  this.send("--videoinfo\r\n" + "width: " + String(width) + "\r\n" + "height: " + String(height) + "\r\n" + "codec: " + String(codec) + "\r\n" + "desc_size: " + String(desc.byteLength) + "\r\n" + "--description\r\n");
  this.send(desc);
  this.send("\r\n--description--\r\n" + "--videoinfo--\r\n\r\n");
 }
 add_packet(pts, duration, pos, data) {
  this.send("--pkt\r\n" + "pts: " + String(pts) + "\r\n" + "duration: " + String(duration) + "\r\n" + "pos: " + String(pos) + "\r\n" + "size: " + String(data.byteLength) + "\r\n" + "--data\r\n");
  this.send(data);
  this.send("\r\n--data--\r\n" + "--pkt--\r\n\r\n");
 }
 send(data) {
  if (this.state == "opened") {
   console.log("send by ws");
   this.ws_obj.send(data);
  } else {
   console.log("add to cache");
   this.cache_queue.push(data);
  }
 }
 close() {
  this.ws_obj.close();
 }
}

class PIVideoStream {
 constructor(media_name, stream_name, hwdec, codec, width, height, desc, callback, cb_arg) {
  console.log(media_name, stream_name, hwdec, codec, width, height, desc, callback, cb_arg);
  var stream_pos = find_video_stream(media_name, stream_name);
  if (stream_pos[0] == -1) {
   throw ReferenceError('media "' + media_name + '" not found.');
  } else {
   this.media = g_medias[stream_pos[0]];
  }
  if (stream_pos[1] != -1) {
   throw ReferenceError('video stream "' + stream_name + '" already exists in media "' + media_name + '".');
  }
  this.name = stream_name;
  this.rotate = 0;
  this.video_callback = null;
  this.codec = codec;
  this.width = width;
  this.height = height;
  this.desc = desc;
  this.callback = callback;
  this.cb_arg = cb_arg;
  this.frameTag = 0;
  this.buffedFrames = [];
  this.decoder = null;
  this.pts_finfo_map = {};
  this.lastframe = null;
  this.lastyuv = null;
  this.dump = null;
  if (hwdec) {
   if (g_dump264) {
    this.dump = new PIDump("wss://bj.pi.tec:20443/ws/dump?name=" + media_name + ".data");
    this.dump.media_info(width, height, codec, desc);
   }
   this.decoder = new VideoDecoder({
    output: videoFrame => this.decode_callback(videoFrame),
    error: err => console.error(err)
   });
   var config = {
    codec: codec,
    width: width,
    height: height
   };
   if (desc != null) {
    config["description"] = desc;
   }
   this.decoder.configure(config);
  }
  this.media.videos.push(this);
 }
 close_decoder() {
  if (this.decoder != null) {
   this.decoder.close();
   this.decoder = null;
   for (var i = 0; i < this.buffedFrames.length; i++) {
    this.buffedFrames[i].frame.close();
   }
  }
  this.pts_finfo_map = {};
 }
 decode_callback(videoFrame) {
  var media_name = this.media.name;
  var stream_name = this.name;
  var tag = this.frameTag++;
  var scale_32bit = BigInt("4294967296");
  var frame_pos = 0;
  var frame_duration = 0;
  if (this.pts_finfo_map.hasOwnProperty(BigInt(videoFrame.timestamp))) {
   var finfo = this.pts_finfo_map[BigInt(videoFrame.timestamp)];
   frame_pos = finfo.pos;
   frame_duration = finfo.duration;
   delete this.pts_finfo_map[BigInt(videoFrame.timestamp)];
  }
  var ret = web_video_decode_handler_wrap(this.callback, media_name, stream_name, tag, Number(BigInt(videoFrame.timestamp) % scale_32bit), Number(BigInt(videoFrame.timestamp) / scale_32bit), Number(BigInt(frame_duration) % scale_32bit), Number(BigInt(frame_duration) / scale_32bit), Number(BigInt(frame_pos) % scale_32bit), Number(BigInt(frame_pos) / scale_32bit), this.cb_arg);
  if (ret == 0) {
   if (this.buffedFrames.length >= 15) {
    var garbage_frame = this.buffedFrames.shift();
    garbage_frame.frame.close();
   }
   this.buffedFrames.push(new PIVideoFrame(media_name, stream_name, tag, videoFrame));
  } else {
   videoFrame.close();
  }
 }
}

class PIAudioStream {
 constructor(media_name, stream_name, codec, sample_rate, channel_cnt, desc, callback, cb_arg) {
  console.log(media_name, stream_name, codec, sample_rate, channel_cnt, desc, callback, cb_arg);
  var media_index = -1;
  for (var i = 0; i < g_medias.length; i++) {
   if (g_medias[i].name == media_name) {
    media_index = i;
    break;
   }
  }
  if (media_index == -1) {
   throw ReferenceError('media "' + media_name + '" not found.');
  } else {
   this.media = g_medias[media_index];
  }
  for (var i = 0; i < this.media.audios.length; i++) {
   if (this.media.audios[i].name == stream_name) {
    throw ReferenceError('audio stream "' + stream_name + '" already exists in media "' + media_name + '".');
   }
  }
  this.name = stream_name;
  this.codec = codec;
  this.sample_rate = sample_rate;
  this.channel_cnt = channel_cnt;
  this.desc = desc;
  this.callback = callback;
  this.cb_arg = cb_arg;
  this.decoder = new AudioDecoder({
   output: audioFrame => this.decode_callback(audioFrame),
   error: err => console.error(err)
  });
  var config = {
   codec: codec,
   sampleRate: sample_rate,
   numberOfChannels: channel_cnt
  };
  if (desc != null) {
   config["description"] = desc;
  }
  this.decoder.configure(config);
  this.media.audios.push(this);
 }
 close_decoder() {
  if (this.decoder != null) {
   this.decoder.close();
   this.decoder = null;
   for (var i = 0; i < this.buffedFrames.length; i++) {
    this.buffedFrames[i].frame.close();
   }
  }
 }
 free_wave(wave, channel_cnt) {
  if (wave != 0) {
   for (var i = 0; i < this.channel_cnt; i++) {
    if (wave[i] != 0) {
     free(wave[i]);
    }
   }
   free(wave);
  }
 }
 decode_callback(audioFrame) {
  var media_name = this.media.name;
  var stream_name = this.name;
  var wave = malloc(SIZEOF_POINT * this.channel_cnt);
  if (wave == 0) {
   throw ReferenceError("malloc exec failed.");
  }
  if (audioFrame.buffer.numberOfChannels != this.channel_cnt) {
   throw ReferenceError("Number of channels dismatch.");
  }
  for (var i = 0; i < this.channel_cnt; i++) {
   var chn_addr = malloc(SIZEOF_FLOAT32 * audioFrame.buffer.length);
   if (chn_addr == 0) {
    this.free_wave(wave, this.channel_cnt);
    throw ReferenceError("malloc exec failed.");
   }
   Module.HEAPU32[(wave >> 2) + i] = chn_addr;
   var f32arr = audioFrame.buffer.getChannelData(i);
   Module.HEAPF32.set(f32arr, chn_addr >> 2);
  }
  var scale_32bit = BigInt("4294967296");
  web_audio_decode_handler_wrap(this.callback, media_name, stream_name, wave, this.channel_cnt, audioFrame.buffer.length, Number(BigInt(audioFrame.timestamp) % scale_32bit), Number(BigInt(audioFrame.timestamp) / scale_32bit), this.cb_arg);
  this.free_wave(wave, this.channel_cnt);
 }
}

class PIMedia {
 constructor(name) {
  this.name = name;
  this.videos = [];
  this.audios = [];
 }
}

class PIDistrict {
 constructor(width, height) {
  this.use_gl = false;
  this._2d_obj = new OffscreenCanvas(width, height);
  this._2d_ctx = this._2d_obj.getContext("2d");
 }
}

class PICanvasCtx {
 constructor(offscreen, width, height) {
  this.width = width;
  this.height = height;
  this.r_width = width;
  this.r_height = height;
  this.isfullscreen = 0;
  this.offscreen = offscreen;
  this.offscreen.width = width;
  this.offscreen.height = height;
  this.ctx = offscreen.getContext("2d");
  this.districts = {};
 }
}

function remove_media(media_name) {
 var media_index = -1;
 for (var i = 0; i < g_medias.length; i++) {
  if (g_medias[i].name == media_name) {
   media_index = i;
   break;
  }
 }
 if (media_index == -1) {
  return;
 }
 var media = g_medias[media_index];
 var stream_index = -1;
 for (var i = 0; i < media.videos.length; i++) {
  var stream = media.videos[i];
  stream.close_decoder();
 }
 for (var i = 0; i < media.audios.length; i++) {
  var stream = media.audios[i];
  stream.close_decoder();
 }
 g_medias.splice(media_index, 1);
}

function web_init_videodecoder(c_media_name, c_stream_name, c_codec, width, height, desc, desc_size, callback, cb_arg) {
 var media_name = cStringToString(c_media_name);
 var stream_name = cStringToString(c_stream_name);
 var codec = cStringToString(c_codec);
 var u8desc = null;
 if (desc != 0 && desc_size != 0) {
  u8desc = new ArrayBuffer(desc_size);
  var u8desc_view = new Uint8Array(u8desc);
  u8desc_view.set(Module.HEAPU8.subarray(desc, desc + desc_size));
 }
 try {
  new PIVideoStream(media_name, stream_name, true, codec, width, height, u8desc, callback, cb_arg);
 } catch (error) {
  console.error(error);
  return -1;
 }
 return 0;
}

function web_destroy_videodecoder(c_media_name, c_stream_name) {
 var media_name = cStringToString(c_media_name);
 var stream_name = cStringToString(c_stream_name);
 var stream_pos = find_video_stream(media_name, stream_name);
 if (stream_pos[0] == -1 || stream_pos[1] == -1) {
  return -1;
 }
 var media = g_medias[stream_pos[0]];
 var stream = media.videos.splice(stream_pos[1], 1)[0];
 stream.close_decoder();
 return 0;
}

function web_push_video_pkt(c_media_name, c_stream_name, buf, len, c_type, pts_l, pts_h, duration_l, duration_h, pos_l, pos_h) {
 var media_name = cStringToString(c_media_name);
 var stream_name = cStringToString(c_stream_name);
 var type = cStringToString(c_type);
 var pts = u32sToI64(pts_l, pts_h);
 var duration = u32sToI64(duration_l, duration_h);
 var pos = u32sToI64(pos_l, pos_h);
 var stream_pos = find_video_stream(media_name, stream_name);
 if (stream_pos[0] == -1 || stream_pos[1] == -1) {
  return -1;
 }
 var media = g_medias[stream_pos[0]];
 var stream = media.videos[stream_pos[1]];
 var u8buf = new ArrayBuffer(len);
 var u8buf_view = new Uint8Array(u8buf);
 u8buf_view.set(Module.HEAPU8.subarray(buf, buf + len));
 var enc_video = new EncodedVideoChunk({
  type: type,
  timestamp: Number(pts),
  duration: Number(duration),
  data: u8buf
 });
 if (stream.decoder != null) {
  stream.decoder.decode(enc_video);
  stream.pts_finfo_map[pts] = new FInfo(pts, pos, duration);
  if (g_dump264) {
   stream.dump.add_packet(pts, duration, pos, u8buf);
  }
 }
 return 0;
}

function web_get_videodecoder_queue_size(c_media_name, c_stream_name) {
 var media_name = cStringToString(c_media_name);
 var stream_name = cStringToString(c_stream_name);
 var stream_pos = find_video_stream(media_name, stream_name);
 if (stream_pos[0] == -1 || stream_pos[1] == -1) {
  return -1;
 }
 var media = g_medias[stream_pos[0]];
 var stream = media.videos[stream_pos[1]];
 if (stream.decoder) {
  return stream.decoder.decodeQueueSize;
 } else {
  return -1;
 }
}

function web_videodecoder_flush(c_media_name, c_stream_name) {
 var media_name = cStringToString(c_media_name);
 var stream_name = cStringToString(c_stream_name);
 var stream_pos = find_video_stream(media_name, stream_name);
 if (stream_pos[0] == -1 || stream_pos[1] == -1) {
  return -1;
 }
 var media = g_medias[stream_pos[0]];
 var stream = media.videos[stream_pos[1]];
 if (stream.decoder) {
  stream.decoder.flush();
 } else {
  return -1;
 }
 return 0;
}

function get_infos_from_config(media_name, stream_name) {
 var bindinfos;
 var stream_pos = find_video_stream(media_name, stream_name);
 if (stream_pos[0] == -1 || stream_pos[1] == -1) {
  return null;
 }
 var media = g_medias[stream_pos[0]];
 var stream = media.videos[stream_pos[1]];
 if (!self.g_binds.hasOwnProperty(media_name)) {
  console.error('media name "' + media_name + '" not found in root::g_binds');
  return null;
 }
 if (!self.g_binds[media_name].hasOwnProperty(stream_name)) {
  console.error('stream name "' + stream_name + '" not found in root::g_binds::' + media_name);
  return null;
 }
 bindinfos = self.g_binds[media_name][stream_name];
 return {
  bindinfos: bindinfos,
  stream: stream
 };
}

function draw_district(cvs_ctx, img, pos_x, pos_y, view_width, view_height, imgwidth, imgheight, canvas_width, canvas_height, rotate) {
 cvs_ctx.clearRect(0, 0, canvas_width, canvas_height);
 if (rotate == 90 || rotate == 270) {
  var tmp = view_height;
  view_height = view_width;
  view_width = tmp;
 }
 var scale_ratio = imgwidth / imgheight > view_width / view_height ? view_width / imgwidth : view_height / imgheight;
 var draw_width = imgwidth * scale_ratio;
 var draw_height = imgheight * scale_ratio;
 var offset_x = (view_width - draw_width) / 2;
 var offset_y = (view_height - draw_height) / 2;
 cvs_ctx.rotate(rotate * (Math.PI / 180));
 if (rotate == 90) {
  cvs_ctx.translate(0, -canvas_width);
  var new_y = canvas_width - pos_x - view_height;
  var new_x = pos_y;
  pos_x = new_x;
  pos_y = new_y;
 } else if (rotate == 180) {
  cvs_ctx.translate(-canvas_width, -canvas_height);
  pos_x = canvas_width - pos_x - view_width;
  pos_y = canvas_height - pos_y - view_height;
 } else if (rotate == 270) {
  cvs_ctx.translate(-canvas_height, 0);
  var new_y = pos_x;
  var new_x = canvas_height - pos_y - view_width;
  pos_x = new_x;
  pos_y = new_y;
 }
 if (Object.prototype.toString.call(img) == "[object VideoFrame]") {
  cvs_ctx.drawImage(img, offset_x, offset_y, draw_width, draw_height);
 } else if (Object.prototype.toString.call(img) == "[object Uint8Array]") {
  var gl = g_webgl_render.gl;
  var u_offset = imgwidth * imgheight;
  var u_size = imgwidth * imgheight >> 2;
  var v_offset = u_offset + u_size;
  var v_size = u_size;
  gl.canvas.width = view_width;
  gl.canvas.height = view_height;
  gl.viewport(offset_x, offset_y, draw_width, draw_height);
  if (offset_x != this.offset_x || offset_y != this.offset_y || draw_width != this.draw_w || draw_height != this.draw_h) {
   gl.clearColor(0, 0, 0, 0);
   gl.clear(gl.COLOR_BUFFER_BIT);
   g_webgl_render.offset_x = offset_x;
   g_webgl_render.offset_y = offset_y;
   g_webgl_render.draw_w = draw_width;
   g_webgl_render.draw_h = draw_height;
  }
  gl.y.fill(imgwidth, imgheight, img.subarray(0, u_offset));
  gl.u.fill(imgwidth >> 1, imgheight >> 1, img.subarray(u_offset, u_offset + u_size));
  gl.v.fill(imgwidth >> 1, imgheight >> 1, img.subarray(v_offset, v_offset + v_size));
  gl.drawArrays(gl.TRIANGLE_STRIP, 0, 4);
  cvs_ctx.drawImage(g_webgl_render.gl.canvas, pos_x, pos_y, view_width, view_height);
 }
 if (rotate == 90) {
  cvs_ctx.translate(0, canvas_width);
 } else if (rotate == 180) {
  cvs_ctx.translate(canvas_width, canvas_height);
 } else if (rotate == 270) {
  cvs_ctx.translate(canvas_height, 0);
 }
 cvs_ctx.rotate(-rotate * (Math.PI / 180));
}

function web_video_play_js(media_name, stream_name, tag, close_only) {
 var infos = get_infos_from_config(media_name, stream_name);
 if (!Boolean(infos)) {
  return -1;
 }
 var bindinfos = infos["bindinfos"];
 var stream = infos["stream"];
 var piframe_index = -1;
 for (var j = 0; j < stream.buffedFrames.length; j++) {
  if (stream.buffedFrames[j].tag == tag) {
   piframe_index = j;
   break;
  }
 }
 if (piframe_index == -1) {
  console.log("video player ignored because frame is expires");
  return -1;
 }
 var frame = stream.buffedFrames[piframe_index].frame;
 if (stream.lastframe != null) {
  stream.lastframe.close();
 }
 stream.lastframe = frame;
 for (var i = 0; i < bindinfos.length; i++) {
  var bindinfo = bindinfos[i];
  var pos_x, pos_y, view_width, view_height;
  var layer;
  for (var j = 0; j < self.g_layers.length; j++) {
   var cur_layer = self.g_layers[j];
   if (cur_layer["name"] == bindinfo["layer"]) {
    layer = cur_layer;
    break;
   }
  }
  if (!self.g_canvas.hasOwnProperty(bindinfo["layer"])) {
   continue;
  }
  var cvs_ctx = self.g_canvas[bindinfo["layer"]];
  var canvas_width = cvs_ctx.offscreen.width;
  var canvas_height = cvs_ctx.offscreen.height;
  var scale_ratio_w = cvs_ctx.offscreen.width / cvs_ctx.width;
  var scale_ratio_h = cvs_ctx.offscreen.height / cvs_ctx.height;
  var scale_ratio = scale_ratio_w < scale_ratio_h ? scale_ratio_w : scale_ratio_h;
  var x_offset = (cvs_ctx.offscreen.width - cvs_ctx.width * scale_ratio) / 2;
  var y_offset = (cvs_ctx.offscreen.height - cvs_ctx.height * scale_ratio) / 2;
  for (var j = 0; j < layer["districts"].length; j++) {
   var district = layer["districts"][j];
   if (district["name"] != bindinfo["district"]) {
    continue;
   }
   pos_x = parseInt(district["position_x"]);
   pos_y = parseInt(district["position_y"]);
   view_width = parseInt(district["width"]);
   view_height = parseInt(district["height"]);
   pos_x = x_offset + pos_x * scale_ratio;
   pos_y = y_offset + pos_y * scale_ratio;
   view_width *= scale_ratio;
   view_height *= scale_ratio;
   var canvas_district = self.g_canvas[bindinfo["layer"]].districts[bindinfo["district"]];
   if (!close_only) {
    canvas_district.use_gl = false;
    draw_district(canvas_district._2d_ctx, frame, pos_x, pos_y, view_width, view_height, stream.width, stream.height, canvas_width, canvas_height, stream.rotate);
   }
  }
  if (!close_only) {
   self.g_canvas[bindinfo["layer"]].ctx.clearRect(0, 0, parseInt(layer["width"]), parseInt(layer["height"]));
   for (var j = layer["districts"].length - 1; j >= 0; j--) {
    var district = layer["districts"][j];
    district = self.g_canvas[bindinfo["layer"]].districts[district["name"]];
    if (district.use_gl) {
     self.g_canvas[bindinfo["layer"]].ctx.drawImage(district.gl_obj, 0, 0);
    } else {
     self.g_canvas[bindinfo["layer"]].ctx.drawImage(district._2d_obj, 0, 0);
    }
   }
  }
 }
 for (var k = 0; k < piframe_index; k++) {
  var garbage_frame = stream.buffedFrames.shift();
  garbage_frame.frame.close();
 }
 return 0;
}

function web_video_display_yuv(c_media_name, c_stream_name, c_yuvdata, yuvwidth, yuvheight, pts_l, pts_h, extrainfo) {
 var ret = 0;
 var media_name = cStringToString(c_media_name);
 var stream_name = cStringToString(c_stream_name);
 var pts = u32sToI64(pts_l, pts_h);
 var orig_stamp_l = Module.HEAPU32[extrainfo >> 2];
 var orig_stamp_h = Module.HEAPU32[(extrainfo >> 2) + 1];
 var orig_stamp = u32sToI64(orig_stamp_l, orig_stamp_h);
 if (g_show_draw > 0) {
  if (g_display_cnt.hasOwnProperty(media_name)) {
   g_display_cnt[media_name]++;
   if (g_display_cnt[media_name] % g_show_draw == 0) {
    console.log(now() + "draw_video %s %dx%d cnt:%d pts:%d orig_stamp:%d", media_name, yuvwidth, yuvheight, g_display_cnt[media_name], pts, orig_stamp);
   }
  } else {
   g_display_cnt[media_name] = 1;
  }
 }
 var len = yuvwidth * yuvheight * 1.5;
 if (g_yuvbuffer_size < len) {
  g_yuvbuffer_size = len;
  g_yuvbuffer = new Uint8Array(len);
 }
 var yuvdata = g_yuvbuffer;
 yuvdata.set(Module.HEAPU8.subarray(c_yuvdata, c_yuvdata + len));
 var stream;
 var bindinfos;
 var infos = get_infos_from_config(media_name, stream_name);
 if (Boolean(infos)) {
  stream = infos["stream"];
  bindinfos = infos["bindinfos"];
  ret = 0;
 } else {
  try {
   stream = new PIVideoStream(media_name, stream_name, false);
  } catch (e) {
   console.log("ignore because no media_name");
   return;
  }
  infos = get_infos_from_config(media_name, stream_name);
  bindinfos = infos["bindinfos"];
  ret = 1;
 }
 if (stream.video_callback != null) {
  postMessage({
   user_cmd: "video_callback",
   media_name: media_name,
   stream_name: stream_name,
   yuvdata: yuvdata,
   width: yuvwidth,
   height: yuvheight,
   pts: pts,
   orig_stamp: orig_stamp
  });
 }
 stream.lastyuv = yuvdata;
 stream.width = yuvwidth;
 stream.height = yuvheight;
 if (bindinfos.length == 0) {
  ret = -1;
 }
 for (var i = 0; i < bindinfos.length; i++) {
  var bindinfo = bindinfos[i];
  var pos_x, pos_y, view_width, view_height;
  var layer;
  for (var j = 0; j < self.g_layers.length; j++) {
   var cur_layer = self.g_layers[j];
   if (cur_layer["name"] == bindinfo["layer"]) {
    layer = cur_layer;
    break;
   }
  }
  if (!self.g_canvas.hasOwnProperty(bindinfo["layer"])) {
   continue;
  }
  var cvs_ctx = self.g_canvas[bindinfo["layer"]];
  var canvas_width = cvs_ctx.offscreen.width;
  var canvas_height = cvs_ctx.offscreen.height;
  var scale_ratio_w = cvs_ctx.offscreen.width / cvs_ctx.width;
  var scale_ratio_h = cvs_ctx.offscreen.height / cvs_ctx.height;
  var scale_ratio = scale_ratio_w < scale_ratio_h ? scale_ratio_w : scale_ratio_h;
  var x_offset = (cvs_ctx.offscreen.width - cvs_ctx.width * scale_ratio) / 2;
  var y_offset = (cvs_ctx.offscreen.height - cvs_ctx.height * scale_ratio) / 2;
  for (var j = 0; j < layer["districts"].length; j++) {
   var district = layer["districts"][j];
   if (district["name"] != bindinfo["district"]) {
    continue;
   }
   pos_x = parseInt(district["position_x"]);
   pos_y = parseInt(district["position_y"]);
   view_width = parseInt(district["width"]);
   view_height = parseInt(district["height"]);
   pos_x = x_offset + pos_x * scale_ratio;
   pos_y = y_offset + pos_y * scale_ratio;
   view_width *= scale_ratio;
   view_height *= scale_ratio;
   var canvas_district = self.g_canvas[bindinfo["layer"]].districts[bindinfo["district"]];
   draw_district(canvas_district._2d_ctx, yuvdata, pos_x, pos_y, view_width, view_height, yuvwidth, yuvheight, canvas_width, canvas_height, stream.rotate);
  }
  self.g_canvas[bindinfo["layer"]].ctx.clearRect(0, 0, canvas_width, canvas_height);
  for (var j = layer["districts"].length - 1; j >= 0; j--) {
   var district = layer["districts"][j];
   var district_obj = self.g_canvas[bindinfo["layer"]].districts[district["name"]];
   if (district_obj.use_gl) {
    self.g_canvas[bindinfo["layer"]].ctx.drawImage(district_obj.gl_obj, 0, 0);
   } else {
    self.g_canvas[bindinfo["layer"]].ctx.drawImage(district_obj._2d_obj, 0, 0);
   }
  }
 }
 return ret;
}

function web_show_delay(c_media_name, c_stream_name, delay_ms) {}

function web_video_frame_detach(c_media_name, c_stream_name, tag) {
 var media_name = cStringToString(c_media_name);
 var stream_name = cStringToString(c_stream_name);
 console.log("web_video_frame_detach", media_name, stream_name, tag);
 web_video_play_js(media_name, stream_name, tag, true);
}

function web_video_play(c_media_name, c_stream_name, tag, pts_l, pts_h, extrainfo) {
 var media_name = cStringToString(c_media_name);
 var stream_name = cStringToString(c_stream_name);
 var pts = u32sToI64(pts_l, pts_h);
 var orig_stamp_l = Module.HEAPU32[extrainfo >> 2];
 var orig_stamp_h = Module.HEAPU32[(extrainfo >> 2) + 1];
 var orig_stamp = u32sToI64(orig_stamp_l, orig_stamp_h);
 if (g_show_draw > 0) {
  if (g_display_cnt.hasOwnProperty(media_name)) {
   g_display_cnt[media_name]++;
   if (g_display_cnt[media_name] % g_show_draw == 0) {
    console.log(now() + "draw_video %s hwdec%d cnt:%d pts:%d orig_stamp:%d", media_name, tag, g_display_cnt[media_name], pts, orig_stamp);
   }
  } else {
   g_display_cnt[media_name] = 1;
  }
 }
 web_video_play_js(media_name, stream_name, tag, false);
}

function web_init_audiodecoder(c_media_name, c_stream_name, c_codec, sample_rate, channel_cnt, desc, desc_size, callback, cb_arg) {
 var media_name = cStringToString(c_media_name);
 var stream_name = cStringToString(c_stream_name);
 var codec = cStringToString(c_codec);
 var u8desc = null;
 if (desc != 0 && desc_size != 0) {
  u8desc = new ArrayBuffer(desc_size);
  var u8desc_view = new Uint8Array(u8desc);
  u8desc_view.set(Module.HEAPU8.subarray(desc, desc + desc_size));
 }
 try {
  new PIAudioStream(media_name, stream_name, codec, sample_rate, channel_cnt, u8desc, callback, cb_arg);
 } catch (error) {
  console.log(error);
  return -1;
 }
 return 0;
}

function web_destroy_audiodecoder(c_media_name, c_stream_name) {
 var media_name = cStringToString(c_media_name);
 var stream_name = cStringToString(c_stream_name);
 var stream_pos = find_audio_stream(media_name, stream_name);
 if (stream_pos[0] == -1 || stream_pos[1] == -1) {
  return -1;
 }
 var media = g_medias[stream_pos[0]];
 var stream = media.audios.splice(stream_pos[1], 1)[0];
 stream.close_decoder();
 return 0;
}

function web_set_audio_play_sample_rate(sample_rate) {
 postMessage({
  user_cmd: "set_audio_play_sample_rate",
  sample_rate: sample_rate
 });
 return 0;
}

function web_push_audio_pkt(c_media_name, c_stream_name, buf, len, c_type, pts_l, pts_h) {
 var media_name = cStringToString(c_media_name);
 var stream_name = cStringToString(c_stream_name);
 var type = cStringToString(c_type);
 var pts = u32sToI64(pts_l, pts_h);
 var stream_pos = find_audio_stream(media_name, stream_name);
 if (stream_pos[0] == -1 || stream_pos[1] == -1) {
  return -1;
 }
 var media = g_medias[stream_pos[0]];
 var stream = media.audios[stream_pos[1]];
 var u8buf = new ArrayBuffer(len);
 var u8buf_view = new Uint8Array(u8buf);
 u8buf_view.set(Module.HEAPU8.subarray(buf, buf + len));
 var enc_audio = new EncodedAudioChunk({
  type: type,
  timestamp: Number(pts),
  data: u8buf
 });
 stream.decoder.decode(enc_audio);
 return 0;
}

function web_get_audiodecoder_queue_size(media_name, stream_name) {
 var media_name = cStringToString(c_media_name);
 var stream_name = cStringToString(c_stream_name);
 var stream_pos = find_audio_stream(media_name, stream_name);
 if (stream_pos[0] == -1 || stream_pos[1] == -1) {
  return -1;
 }
 var media = g_medias[stream_pos[0]];
 var stream = media.audios[stream_pos[1]];
 var queue_size = stream.decoder.decodeQueueSize;
 return queue_size;
}

function web_audiodecoder_flush(c_media_name, c_stream_name) {
 var media_name = cStringToString(c_media_name);
 var stream_name = cStringToString(c_stream_name);
 var stream_pos = find_audio_stream(media_name, stream_name);
 if (stream_pos[0] == -1 || stream_pos[1] == -1) {
  return -1;
 }
 var media = g_medias[stream_pos[0]];
 var stream = media.audios[stream_pos[1]];
 stream.decoder.flush();
 return 0;
}

function web_audio_play_process(length) {
 var p_len = malloc(SIZEOF_UINT32);
 var p_wave = malloc(SIZEOF_POINT);
 var p_chn_cnt = malloc(SIZEOF_UINT32);
 if (p_len == 0 || p_wave == 0 || p_chn_cnt == 0) {
  console.error("malloc failed");
  if (p_len != 0) {
   free(p_len);
  }
  if (p_wave != 0) {
   free(p_wave);
  }
  if (p_chn_cnt != 0) {
   free(p_chn_cnt);
  }
  return [];
 }
 Module.HEAPU32[p_len >> 2] = length;
 var ret = c_web_audio_play_process(p_len, p_wave, p_chn_cnt);
 if (ret != 0) {
  free(p_len);
  free(p_wave);
  free(p_chn_cnt);
  return [];
 }
 var len = Module.HEAPU32[p_len >> 2];
 var waves = Module.HEAPU32[p_wave >> 2];
 var chn_cnt = Module.HEAPU32[p_chn_cnt >> 2];
 var channels = [];
 for (var i = 0; i < chn_cnt; i++) {
  var f32arr = new Float32Array(len);
  var wave_addr = Module.HEAPU32[(waves >> 2) + i];
  f32arr.set(Module.HEAPF32.subarray(wave_addr >> 2, (wave_addr >> 2) + len));
  channels.push(f32arr);
  free(wave_addr);
 }
 free(p_len);
 free(waves);
 free(p_wave);
 free(p_chn_cnt);
 return channels;
}

function web_media_play_control(c_command, arg) {
 var command = cStringToString(c_command);
 postMessage({
  user_cmd: "media_play_control",
  command: command,
  arg: arg
 });
}

function get_file(filename) {
 var p_data = malloc(SIZEOF_POINT);
 var p_size = malloc(SIZEOF_UINT32);
 var ret = c_get_file(filename, p_data, p_size);
 if (ret != 0) {
  console.log("failed.");
  return;
 }
 var size = Module.HEAPU32[p_size >> 2];
 var abuff = new ArrayBuffer(size);
 var data_v = new Uint8Array(abuff);
 var data_addr = Module.HEAPU32[p_data >> 2];
 data_v.set(Module.HEAPU8.subarray(data_addr, data_addr + size));
 free(data_addr);
 free(p_data);
 free(p_size);
 postMessage({
  user_cmd: "save_file",
  filename: filename,
  content: abuff
 }, [ abuff ]);
}

function browser_version() {
 var sOS = navigator.platform;
 if (sOS == "Win32") {
  if (navigator.userAgent.match("Win64")) {
   sOS = "Win64";
  }
 }
 var browser = {};
 var userAgent = navigator.userAgent.toLowerCase();
 var s;
 (s = userAgent.match(/msie ([\d.]+)/)) ? browser.ie = s[1] : (s = userAgent.match(/edg\/([\d.]+)/)) ? browser.edge = s[1] : (s = userAgent.match(/firefox\/([\d.]+)/)) ? browser.firefox = s[1] : (s = userAgent.match(/chrome\/([\d.]+)/)) ? browser.chrome = s[1] : (s = userAgent.match(/opera.([\d.]+)/)) ? browser.opera = s[1] : (s = userAgent.match(/version\/([\d.]+).*safari/)) ? browser.safari = s[1] : 0;
 var version = "";
 if (browser.ie) {
  version = "IE " + browser.ie;
 } else if (browser.edge) {
  version = "Edge " + browser.edge;
 } else if (browser.firefox) {
  version = "Firefox " + browser.firefox;
 } else if (browser.chrome) {
  version = "Chrome " + browser.chrome;
 } else if (browser.opera) {
  version = "Opera " + browser.opera;
 } else if (browser.safari) {
  version = "Safari " + browser.safari;
 } else {
  version = "Unknown";
 }
 return "WASM, " + sOS + ", " + version;
}

function web_get_device_info(c_addr, max_len) {
 var bver = browser_version();
 var i = 0;
 for (i = 0; i < max_len - 1 && i < bver.length; i++) {
  Module.HEAPU8[c_addr + i] = bver.charCodeAt(i);
 }
 Module.HEAPU8[c_addr + i] = 0;
 return 0;
}

function array_sum(array) {
 var sum = 0;
 for (var i = 0; i < array.length; i++) {
  sum += array[i];
 }
 return sum;
}

function web_backtrace(trace_addr) {
 var btrace = new Error().stack.toString();
 var i = 0;
 var c_addr = malloc(btrace.length + 1);
 for (i = 0; i < btrace.length; i++) {
  Module.HEAPU8[c_addr + i] = btrace.charCodeAt(i);
 }
 Module.HEAPU8[c_addr + i] = 0;
 Module.HEAPU32[trace_addr >> 2] = c_addr;
 return 0;
}

function array_avg(array) {
 return array_sum(array) / array.length;
}

function calc_delay(qoeinfo) {
 var push_rtt_avgs = qoeinfo["pushrtt_avg"].slice(0, qoeinfo["push_path"]).map(x => Math.round(x / 1e3));
 var push_rtt_lasts = qoeinfo["pushrtt_last"].slice(0, qoeinfo["push_path"]).map(x => Math.round(x / 1e3));
 var recv_rtt_avgs = qoeinfo["recvrtt_avg"].slice(0, qoeinfo["recv_path"]).map(x => Math.round(x / 1e3));
 var recv_rtt_lasts = qoeinfo["recvrtt_last"].slice(0, qoeinfo["recv_path"]).map(x => Math.round(x / 1e3));
 var delay_ms = qoeinfo["venc_last"] / 1e3 + array_avg(push_rtt_lasts) + array_avg(recv_rtt_lasts) + qoeinfo["vdec"] / 1e3 + qoeinfo["vbuffer"] / 1e3;
 return delay_ms;
}

function web_raw_msg(c_media_name, c_stream_name, what, arg1, arg2, extra) {
 var media_name = cStringToString(c_media_name);
 var stream_name = cStringToString(c_stream_name);
 switch (what) {
 case 901:
  var qoeinfo = this.struct.load_struct("QOEInfo", this.struct.get_struct_data("QOEInfo", extra));
  if (qoeinfo["recv_path"] != 0) {
   postMessage({
    user_cmd: "qoeinfo",
    media_name: media_name,
    stream_name: stream_name,
    qoeinfo: JSON.stringify(qoeinfo)
   });
   postMessage({
    user_cmd: "delay_callback",
    media_name: media_name,
    stream_name: stream_name,
    delay_ms: calc_delay(qoeinfo)
   });
  }
  break;

 case 100008:
  postMessage({
   user_cmd: "rcmsg",
   media_name: media_name,
   stream_name: stream_name,
   code: arg1,
   message: cStringToString(extra)
  });
  break;

 default:
  postMessage({
   user_cmd: "raw_msg",
   media_name: media_name,
   stream_name: stream_name,
   what: what,
   arg1: arg1,
   arg2: arg2
  });
 }
}

function ready_handler(e) {
 self.g_canvas = {};
 self.g_layers = [];
 self.g_binds = {};
 global_init();
 self.ready = true;
 self.struct = new StructParser(c_struct_define);
 var webgl_obj = new OffscreenCanvas(100, 100);
 var webgl_ctx = webgl_obj.getContext("webgl");
 g_webgl_render = new WebGLRender(webgl_ctx);
 postMessage({
  user_cmd: "player_ready"
 });
}

function message_handler(e) {
 var ret = 0;
 switch (e.data["user_cmd"]) {
 case "audio_process":
  var length = e.data["length"];
  var waves = web_audio_play_process(length);
  if (waves.length != 0) {
   postMessage({
    user_cmd: "audio_process_resp",
    waves: waves
   });
  }
  break;

 case "add_canvas":
  self.g_layers = self.g_layers.concat(e.data["layers"]);
  for (var i = 0; i < e.data["canvas_list"].length; i++) {
   var canvas = e.data["canvas_list"][i];
   var layer;
   for (var j = 0; j < e.data["layers"].length; j++) {
    if (canvas["name"] == e.data["layers"][j]["name"]) {
     layer = e.data["layers"][j];
     break;
    }
   }
   var cvs_ctx = new PICanvasCtx(canvas["offscreen"], parseInt(layer["width"]), parseInt(layer["height"]));
   for (var j = 0; j < layer["districts"].length; j++) {
    cvs_ctx.districts[layer["districts"][j]["name"]] = new PIDistrict(parseInt(layer["width"]), parseInt(layer["height"]));
   }
   self.g_canvas[layer["name"]] = cvs_ctx;
  }
  break;

 case "del_canvas":
  for (var i = 0; i < e.data["layers"].length; i++) {
   var layer_name = e.data["layers"][i];
   for (var j = 0; j < self.g_layers.length; j++) {
    if (layer_name == self.g_layers[j]["name"]) {
     self.g_layers.splice(j, 1);
     break;
    }
   }
   delete self.g_canvas[layer_name];
  }
  break;

 case "update_binds":
  for (var media_name in e.data["binds"]) {
   if (!g_binds.hasOwnProperty(media_name)) {
    g_binds[media_name] = {};
   }
   var media_bind = e.data["binds"][media_name];
   for (var stream_name in media_bind) {
    g_binds[media_name][stream_name] = media_bind[stream_name];
   }
  }
  break;

 case "create":
  var module_url = e.data["module_url"];
  if (module_url) {
   var module_fname = md5(module_url) + ".so";
   if (g_modules.indexOf(module_fname) < 0) {
    fetch(module_url).then(resp => resp.arrayBuffer()).then(function(buf) {
     g_modules.push(module_fname);
     var data_v = new Uint8Array(buf);
     var c_addr = malloc(buf.byteLength);
     Module.HEAPU8.set(data_v, c_addr);
     create_file(module_fname, c_addr, buf.byteLength);
     free(c_addr);
     PIMediaPlayer_create(e.data["media_name"], e.data["url"], module_fname);
    });
   } else {
    PIMediaPlayer_create(e.data["media_name"], e.data["url"], module_fname);
   }
  } else {
   PIMediaPlayer_create(e.data["media_name"], e.data["url"], null);
  }
  g_medias.push(new PIMedia(e.data["media_name"]));
  break;

 case "destroy":
  var need_reload = false;
  if (Module.PThread.unusedWorkers.length < 5) {
   need_reload = true;
  }
  PIMediaPlayer_destroy(e.data["media_name"]);
  if (need_reload) {
   postMessage({
    user_cmd: "reload"
   });
  }
  remove_media(e.data["media_name"]);
  break;

 case "set_ptcp_log_level":
  if (self.ready) {
   PIMediaPlayer_set_ptcp_log_level(e.data["level"]);
  }
  break;

 case "set_pslstreaming_log_level":
  if (self.ready) {
   PIMediaPlayer_set_pslstreaming_log_level(e.data["level"]);
  }
  break;

 case "set_psdemux_log_level":
  if (self.ready) {
   PIMediaPlayer_set_psdemux_log_level(e.data["level"]);
  }
  break;

 case "set_display_rotate":
  set_display_rotate(e.data["media_name"], e.data["stream_name"], e.data["degree"]);
  break;

 case "save_screenshot":
  save_screenshot(e.data["fname"], e.data["media_name"], e.data["stream_name"], e.data["width"], e.data["height"], e.data["degree"]);
  break;

 case "set_video_callback":
  set_video_callback(e.data["media_name"], e.data["stream_name"], e.data["value"]);
  break;

 case "fullscreen":
  if (self.ready) {
   set_display_fullscreen(e.data["layer_name"], e.data["width"], e.data["height"]);
  }
  break;

 case "exitfullscreen":
  if (self.ready) {
   set_display_exitfullscreen();
  }
  break;

 case "resize":
  if (self.ready) {
   set_display_resize(e.data["layer_name"], e.data["width"], e.data["height"]);
  }
  break;

 case "show_ability":
  console.log("ArrayBuffer: " + self.hasOwnProperty("ArrayBuffer"));
  console.log("SharedArrayBuffer: " + self.hasOwnProperty("SharedArrayBuffer"));
  console.log("OffscreenCanvas: " + self.hasOwnProperty("OffscreenCanvas"));
  console.log("VideoDecoder: " + self.hasOwnProperty("VideoDecoder"));
  console.log("VideoEncoder: " + self.hasOwnProperty("VideoEncoder"));
  console.log("AudioDecoder: " + self.hasOwnProperty("AudioDecoder"));
  console.log("AudioEncoder: " + self.hasOwnProperty("AudioEncoder"));
  console.log("AudioContext: " + self.hasOwnProperty("AudioContext"));
  console.log("Worker: " + self.hasOwnProperty("Worker"));
  console.log("SharedWorker: " + self.hasOwnProperty("SharedWorker"));
  console.log("sessionStorage: " + self.hasOwnProperty("sessionStorage"));
  console.log("localStorage: " + self.hasOwnProperty("localStorage"));
  console.log("indexedDB: " + self.hasOwnProperty("indexedDB"));
  break;

 case "get_file":
  get_file(e.data["filename"]);
  break;

 case "set_dbgopt":
  set_dbgopt(e.data["opt"]);
  break;

 default:
  console.log("no case", e);
  break;
 }
}

if (!ENVIRONMENT_IS_PTHREAD) {
 self.addEventListener("message", message_handler);
 Module.onRuntimeInitialized = ready_handler;
}

function Texture(gl) {
 this.gl = gl;
 this.texture = gl.createTexture();
 gl.bindTexture(gl.TEXTURE_2D, this.texture);
 gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.LINEAR);
 gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
 gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
 gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
}

Texture.prototype.bind = function(n, program, name) {
 var gl = this.gl;
 gl.activeTexture([ gl.TEXTURE0, gl.TEXTURE1, gl.TEXTURE2 ][n]);
 gl.bindTexture(gl.TEXTURE_2D, this.texture);
 gl.uniform1i(gl.getUniformLocation(program, name), n);
};

Texture.prototype.fill = function(width, height, data) {
 var gl = this.gl;
 gl.bindTexture(gl.TEXTURE_2D, this.texture);
 gl.texImage2D(gl.TEXTURE_2D, 0, gl.LUMINANCE, width, height, 0, gl.LUMINANCE, gl.UNSIGNED_BYTE, data);
};

function WebGLRender(canvas_ctx) {
 this.gl = canvas_ctx;
 var gl = this.gl;
 gl.pixelStorei(gl.UNPACK_ALIGNMENT, 1);
 var program = gl.createProgram();
 var vertexShaderSource = [ "attribute highp vec4 aVertexPosition;", "attribute vec2 aTextureCoord;", "varying highp vec2 vTextureCoord;", "void main(void) {", " gl_Position = aVertexPosition;", " vTextureCoord = aTextureCoord;", "}" ].join("\n");
 var vertexShader = gl.createShader(gl.VERTEX_SHADER);
 gl.shaderSource(vertexShader, vertexShaderSource);
 gl.compileShader(vertexShader);
 var fragmentShaderSource = [ "precision highp float;", "varying lowp vec2 vTextureCoord;", "uniform sampler2D YTexture;", "uniform sampler2D UTexture;", "uniform sampler2D VTexture;", "const mat4 YUV2RGB = mat4", "(", " 1.1643828125, 0, 1.59602734375, -.87078515625,", " 1.1643828125, -.39176171875, -.81296875, .52959375,", " 1.1643828125, 2.017234375, 0, -1.081390625,", " 0, 0, 0, 1", ");", "void main(void) {", " gl_FragColor = vec4( texture2D(YTexture, vTextureCoord).x, texture2D(UTexture, vTextureCoord).x, texture2D(VTexture, vTextureCoord).x, 1) * YUV2RGB;", "}" ].join("\n");
 var fragmentShader = gl.createShader(gl.FRAGMENT_SHADER);
 gl.shaderSource(fragmentShader, fragmentShaderSource);
 gl.compileShader(fragmentShader);
 gl.attachShader(program, vertexShader);
 gl.attachShader(program, fragmentShader);
 gl.linkProgram(program);
 gl.useProgram(program);
 if (!gl.getProgramParameter(program, gl.LINK_STATUS)) {
  console.log("[ER] Shader link failed.");
 }
 var vertexPositionAttribute = gl.getAttribLocation(program, "aVertexPosition");
 gl.enableVertexAttribArray(vertexPositionAttribute);
 var textureCoordAttribute = gl.getAttribLocation(program, "aTextureCoord");
 gl.enableVertexAttribArray(textureCoordAttribute);
 var verticesBuffer = gl.createBuffer();
 gl.bindBuffer(gl.ARRAY_BUFFER, verticesBuffer);
 gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([ 1, 1, 0, -1, 1, 0, 1, -1, 0, -1, -1, 0 ]), gl.STATIC_DRAW);
 gl.vertexAttribPointer(vertexPositionAttribute, 3, gl.FLOAT, false, 0, 0);
 var texCoordBuffer = gl.createBuffer();
 gl.bindBuffer(gl.ARRAY_BUFFER, texCoordBuffer);
 gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([ 1, 0, 0, 0, 1, 1, 0, 1 ]), gl.STATIC_DRAW);
 gl.vertexAttribPointer(textureCoordAttribute, 2, gl.FLOAT, false, 0, 0);
 gl.y = new Texture(gl);
 gl.u = new Texture(gl);
 gl.v = new Texture(gl);
 gl.y.bind(0, program, "YTexture");
 gl.u.bind(1, program, "UTexture");
 gl.v.bind(2, program, "VTexture");
 this.offset_x = 0;
 this.offset_y = 0;
 this.draw_w = 0;
 this.draw_h = 0;
}

WebGLRender.prototype.renderFrame = function(cvs_ctx, yuvdata, pos_x, pos_y, view_width, view_height, yuvwidth, yuvheight, canvas_width, canvas_height, rotate) {
 if (!this.gl) {
  console.log("[ER] Render frame failed due to WebGL not supported.");
  return;
 }
};

function set_display_rotate(media_name, stream_name, degree) {
 var stream;
 degree = degree % 360;
 if (degree != 0 && degree != 90 && degree != 180 && degree != 270) {
  return -1;
 }
 var infos = get_infos_from_config(media_name, stream_name);
 if (Boolean(infos)) {
  stream = infos["stream"];
  ret = 0;
 } else {
  stream = new PIVideoStream(media_name, stream_name, false);
  infos = get_infos_from_config(media_name, stream_name);
  ret = 1;
 }
 stream.rotate = degree;
 return ret;
}

function set_video_callback(media_name, stream_name, value) {
 var stream;
 var infos = get_infos_from_config(media_name, stream_name);
 if (Boolean(infos)) {
  stream = infos["stream"];
  ret = 0;
 } else {
  stream = new PIVideoStream(media_name, stream_name, false);
  infos = get_infos_from_config(media_name, stream_name);
  ret = 1;
 }
 stream.video_callback = value;
 return ret;
}

function set_display_fullscreen(layer_name, screen_width, screen_height) {
 if (!self.g_canvas.hasOwnProperty(layer_name)) {
  return;
 }
 var layer;
 for (var j = 0; j < self.g_layers.length; j++) {
  if (layer_name == self.g_layers[j]["name"]) {
   layer = self.g_layers[j];
   break;
  }
 }
 var cvs_ctx = self.g_canvas[layer_name];
 cvs_ctx.offscreen.width = screen_width;
 cvs_ctx.offscreen.height = screen_height;
 for (var dis_name in cvs_ctx.districts) {
  cvs_ctx.districts[dis_name]._2d_obj.width = screen_width;
  cvs_ctx.districts[dis_name]._2d_obj.height = screen_height;
 }
 cvs_ctx.isfullscreen = 1;
 self.g_fullscreen_layer = layer_name;
 return 0;
}

function set_display_resize(layer_name, width, height) {
 if (!self.g_canvas.hasOwnProperty(layer_name)) {
  return;
 }
 var layer;
 for (var j = 0; j < self.g_layers.length; j++) {
  if (layer_name == self.g_layers[j]["name"]) {
   layer = self.g_layers[j];
   break;
  }
 }
 var cvs_ctx = self.g_canvas[layer_name];
 cvs_ctx.r_width = width;
 cvs_ctx.r_height = height;
 cvs_ctx.offscreen.width = width;
 cvs_ctx.offscreen.height = height;
 for (var dis_name in cvs_ctx.districts) {
  cvs_ctx.districts[dis_name]._2d_obj.width = width;
  cvs_ctx.districts[dis_name]._2d_obj.height = height;
 }
 return 0;
}

function set_display_exitfullscreen() {
 var layer;
 for (var i = 0; i < self.g_layers.length; i++) {
  var layer = self.g_layers[i];
  var layer_name = layer["name"];
  if (!self.g_canvas.hasOwnProperty(layer_name)) {
   continue;
  }
  if (self.g_fullscreen_layer != layer_name) {
   continue;
  }
  var cvs_ctx = self.g_canvas[layer_name];
  cvs_ctx.offscreen.width = cvs_ctx.r_width;
  cvs_ctx.offscreen.height = cvs_ctx.r_height;
  for (var dis_name in cvs_ctx.districts) {
   cvs_ctx.districts[dis_name]._2d_obj.width = cvs_ctx.r_width;
   cvs_ctx.districts[dis_name]._2d_obj.height = cvs_ctx.r_height;
  }
  self.g_canvas[layer_name].isfullscreen = 0;
  break;
 }
}

function save_screenshot(fname, media_name, stream_name, width = 0, height = 0, rotate = 0) {
 var stream_pos = find_video_stream(media_name, stream_name);
 if (stream_pos[0] == -1 || stream_pos[1] == -1) {
  return -1;
 }
 var media = g_medias[stream_pos[0]];
 var stream = media.videos[stream_pos[1]];
 if (stream.width == 0 || stream.height == 0) {
  return -1;
 }
 if (width == 0 || height == 0) {
  width = stream.width;
  height = stream.height;
 }
 if (rotate == 90 || rotate == 270) {
  var tmp = height;
  height = width;
  width = tmp;
 }
 if (!g_screenshot_ctx) {
  var cvs_obj = new OffscreenCanvas(100, 100);
  g_screenshot_ctx = cvs_obj.getContext("2d");
 }
 g_screenshot_ctx.canvas.width = width;
 g_screenshot_ctx.canvas.height = height;
 if (stream.decoder != null) {
  if (stream.lastframe == null) {
   return -1;
  }
  draw_district(g_screenshot_ctx, stream.lastframe, 0, 0, width, height, stream.width, stream.height, width, height, rotate);
 } else {
  if (stream.lastyuv == null) {
   return -1;
  }
  draw_district(g_screenshot_ctx, stream.lastyuv, 0, 0, width, height, stream.width, stream.height, width, height, rotate);
 }
 var bitmap = g_screenshot_ctx.canvas.transferToImageBitmap();
 postMessage({
  user_cmd: "save_bitmap",
  fname: fname,
  bitmap: bitmap
 }, [ bitmap ]);
}

function userdefined() {
 if (!self.name) {
  return 24;
 }
 return parseInt(self.name.match(/\[pool=(\d+)\]/)[1]);
}

var c_struct_define = "typedef struct QOEInfo" + "{" + "    int16_t ver;" + "    int16_t venc_avg;" + "    int16_t venc_last;" + "    uint8_t push_path;" + "    uint8_t recv_path;" + "    int64_t pushrtt_avg[8];" + "    int64_t pushrtt_last[8];" + "    int64_t recvrtt_avg[8];" + "    int64_t recvrtt_last[8];" + "    int32_t pushretrans_avg[8];" + "    int32_t pushretrans_last[8];" + "    int32_t recvretrans_avg[8];" + "    int32_t recvretrans_last[8];" + "    int64_t pzvtdelay;" + "    int64_t vdec;" + "    int64_t vbuffer;" + "    int64_t abuffer;" + "} QOEInfo;";

function get_value(dataview, info, arr_index) {
 var byte_pos = info["offset"] + info["bit"] / 8 * arr_index;
 var little_endian = true;
 if (info["signed"]) {
  switch (info["bit"]) {
  case 8:
   return dataview.getInt8(byte_pos, little_endian);

  case 16:
   return dataview.getInt16(byte_pos, little_endian);

  case 32:
   return dataview.getInt32(byte_pos, little_endian);

  case 64:
   return Number(dataview.getBigInt64(byte_pos, little_endian));

  default:
   console.error("invalid bit %d", info["bit"]);
  }
 } else {
  switch (info.bit) {
  case 8:
   return dataview.getUint8(byte_pos, little_endian);

  case 16:
   return dataview.getUint16(byte_pos, little_endian);

  case 32:
   return dataview.getUint32(byte_pos, little_endian);

  case 64:
   return Number(dataview.getBigUint64(byte_pos, little_endian));

  default:
   console.error("invalid bit %d", info["bit"]);
  }
 }
}

class StructParser {
 constructor(c_def, align = 32) {
  this.offset = 0;
  this.c_def = c_def;
  this.align = align;
  this.size_pointer = 32;
  this.found_typedef = false;
  this.found_struct = false;
  this.found_struct_name = false;
  this.parsing_names = [];
  this.parsing_members = [];
  this.parsed_struct = {};
  this.parse_struct_definition();
 }
 save_struct_definition(names, members) {
  var i = 0;
  var parsed_members = {};
  var parsed_member_names = [];
  var mem_byte_offset = 0;
  for (i = 0; i < members.length; i++) {
   var basic_type = false;
   var bit = 0;
   var signed = false;
   var is_pointer = false;
   var is_arr = typeof members[i]["arr"] != "undefined";
   var arr_size = is_arr ? Number(members[i]["arr"]) : 1;
   if (members[i]["type"].endsWith("*")) {
    is_pointer = true;
    signed = false;
    bit = this.size_pointer;
   } else {
    is_pointer = false;
    var type_match = members[i]["type"].match(/(?<signed>u?)int(?<bit>\d+)_t/);
    if (type_match) {
     signed = Boolean(type_match.groups["signed"] == "");
     bit = parseInt(type_match.groups["bit"]);
    } else {
     console.log("not a basic type: %s", members[i]["type"]);
     return -1;
    }
   }
   if (bit < this.align) {
    if (mem_byte_offset % (bit / 8)) {
     mem_byte_offset += bit / 8 - mem_byte_offset % (bit / 8);
    }
   } else {
    if (mem_byte_offset % (this.align / 8)) {
     mem_byte_offset += this.align / 8 - mem_byte_offset % (this.align / 8);
    }
   }
   parsed_member_names.push(members[i]["name"]);
   parsed_members[members[i]["name"]] = {
    "signed": signed,
    "bit": bit,
    "offset": mem_byte_offset,
    "is_pointer": is_pointer,
    "is_arr": is_arr,
    "arr_size": arr_size
   };
   mem_byte_offset += bit / 8 * arr_size;
  }
  for (i = 0; i < names.length; i++) {
   this.parsed_struct[names[i]] = {
    "size": mem_byte_offset,
    "names": parsed_member_names,
    "infos": parsed_members
   };
  }
  return 0;
 }
 parse_struct_definition() {
  while (this.offset < this.c_def.length) {
   this.offset += this.c_def.substring(this.offset).match(/^\s*/)[0].length;
   var key_match = this.c_def.substring(this.offset).match(/^(?<key>[a-zA-Z_][a-zA-Z0-9_]*)/);
   if (!this.found_struct) {
    if (!key_match) {
     console.log("expect a keyword:");
     this.print_error_pos(this.offset);
     break;
    }
    if (key_match[0] == "typedef") {
     this.found_typedef = true;
    } else if (key_match[0] == "struct") {
     this.found_struct = true;
    }
    this.offset += key_match[0].length;
    continue;
   }
   if (!key_match) {
    var brace_match = this.c_def.substring(this.offset).match(/^{/);
    if (!brace_match) {
     console.log("expect a keyword or {:");
     this.print_error_pos(this.offset);
     break;
    }
    var brace_match_end = this.c_def.substring(this.offset + 1).match(/}/);
    if (!brace_match_end) {
     console.log("mismatch } for {:");
     this.print_error_pos(this.offset);
     break;
    }
    if (0 != this.parse_struct_member(brace_match_end.index)) {
     break;
    }
    this.offset += brace_match_end.index + 2;
    if (this.found_typedef) {
     this.offset += this.c_def.substring(this.offset).match(/^\s*/)[0].length;
     var alias_match = this.c_def.substring(this.offset).match(/^(?<alias>[a-zA-Z_][a-zA-Z0-9_]*);/);
     if (!alias_match) {
      console.log("expect struct name:");
      this.print_error_pos(this.offset);
      break;
     }
     this.parsing_names.push(alias_match.groups["alias"]);
     this.offset += alias_match[0].length;
    } else {
     this.offset += this.c_def.substring(this.offset).match(/^\s*/)[0].length;
     var semicolon_match = this.c_def.substring(this.offset).match(/^;/);
     if (!semicolon_match) {
      console.log("expect struct name:");
      this.print_error_pos(this.offset);
      break;
     }
     this.offset += semicolon_match[0].length;
    }
    this.save_struct_definition(this.parsing_names, this.parsing_members);
    this.found_typedef = false;
    this.found_struct = false;
    this.parsing_names = [];
    this.parsing_members = [];
    continue;
   } else {
    this.parsing_names.push((this.found_struct ? "struct " : "") + key_match[0]);
    this.offset += key_match[0].length;
   }
  }
 }
 parse_struct_member(size) {
  var mem_code = this.c_def.substring(this.offset + 1, this.offset + 1 + size);
  var mem_offset = 0;
  while (mem_offset < mem_code.length) {
   mem_offset += mem_code.substring(mem_offset).match(/^\s*/)[0].length;
   var mem_match = mem_code.substring(mem_offset).match(/^(?<type>[^;]+?)\s+(?<name>[a-zA-Z_][a-zA-Z0-9_]*)(?:\[(?<arr>\d+)\])?;/);
   if (!mem_match) {
    mem_match = mem_code.substring(mem_offset).match(/^(?<type>[^;]+?\s+\*+)\s*(?<name>[a-zA-Z_][a-zA-Z0-9_]*)(?:\[(?<arr>\d+)\])?;/);
   }
   if (!mem_match) {
    console.log("parse_member failed");
    this.print_error_pos(this.offset + 1 + mem_offset);
    return -1;
   }
   mem_match.groups["type"].match(/(?<signed>u?)int(?<bitsize>\d+)_t/);
   this.parsing_members.push(mem_match.groups);
   mem_offset += mem_match[0].length;
  }
  return 0;
 }
 print_error_pos(offset) {
  if (offset >= 20) {
   console.log(this.c_def.substring(offset - 20, offset + 40) + "\n" + "                    ^");
  } else {
   var spaces = [];
   for (var i = 0; i < offset; i++) {
    spaces.push(" ");
   }
   console.log(this.c_def.substring(0, offset + 40) + "\n" + spaces.join("") + "^");
  }
 }
 get_struct_data(struct_name, data) {
  if (!this.parsed_struct.hasOwnProperty(struct_name)) {
   console.log('"%s" not defined\n');
   return {};
  }
  var struct_def = this.parsed_struct[struct_name];
  var arr_buf = new ArrayBuffer(struct_def["size"]);
  var arr_view = new Uint8Array(arr_buf);
  arr_view.set(Module.HEAPU8.subarray(data, data + arr_buf.byteLength));
  return arr_buf;
 }
 load_struct(struct_name, arr_buf) {
  var result = {};
  if (!this.parsed_struct.hasOwnProperty(struct_name)) {
   console.log('"%s" not defined\n');
   return {};
  }
  var struct_def = this.parsed_struct[struct_name];
  var dataview = new DataView(arr_buf);
  for (var i = 0; i < struct_def["names"].length; i++) {
   var mem_name = struct_def["names"][i];
   var mem_info = struct_def["infos"][mem_name];
   if (mem_info["is_arr"]) {
    result[mem_name] = [];
    for (var j = 0; j < mem_info["arr_size"]; j++) {
     var value = get_value(dataview, mem_info, j);
     result[mem_name].push(value);
    }
   } else {
    var value = get_value(dataview, mem_info, 0);
    result[mem_name] = value;
   }
  }
  return result;
 }
}

!function(n) {
 "use strict";
 function d(n, t) {
  var r = (65535 & n) + (65535 & t);
  return (n >> 16) + (t >> 16) + (r >> 16) << 16 | 65535 & r;
 }
 function f(n, t, r, e, o, u) {
  return d((u = d(d(t, n), d(e, u))) << o | u >>> 32 - o, r);
 }
 function l(n, t, r, e, o, u, c) {
  return f(t & r | ~t & e, n, t, o, u, c);
 }
 function g(n, t, r, e, o, u, c) {
  return f(t & e | r & ~e, n, t, o, u, c);
 }
 function v(n, t, r, e, o, u, c) {
  return f(t ^ r ^ e, n, t, o, u, c);
 }
 function m(n, t, r, e, o, u, c) {
  return f(r ^ (t | ~e), n, t, o, u, c);
 }
 function c(n, t) {
  var r, e, o, u;
  n[t >> 5] |= 128 << t % 32, n[14 + (t + 64 >>> 9 << 4)] = t;
  for (var c = 1732584193, f = -271733879, i = -1732584194, a = 271733878, h = 0; h < n.length; h += 16) c = l(r = c, e = f, o = i, u = a, n[h], 7, -680876936), 
  a = l(a, c, f, i, n[h + 1], 12, -389564586), i = l(i, a, c, f, n[h + 2], 17, 606105819), 
  f = l(f, i, a, c, n[h + 3], 22, -1044525330), c = l(c, f, i, a, n[h + 4], 7, -176418897), 
  a = l(a, c, f, i, n[h + 5], 12, 1200080426), i = l(i, a, c, f, n[h + 6], 17, -1473231341), 
  f = l(f, i, a, c, n[h + 7], 22, -45705983), c = l(c, f, i, a, n[h + 8], 7, 1770035416), 
  a = l(a, c, f, i, n[h + 9], 12, -1958414417), i = l(i, a, c, f, n[h + 10], 17, -42063), 
  f = l(f, i, a, c, n[h + 11], 22, -1990404162), c = l(c, f, i, a, n[h + 12], 7, 1804603682), 
  a = l(a, c, f, i, n[h + 13], 12, -40341101), i = l(i, a, c, f, n[h + 14], 17, -1502002290), 
  c = g(c, f = l(f, i, a, c, n[h + 15], 22, 1236535329), i, a, n[h + 1], 5, -165796510), 
  a = g(a, c, f, i, n[h + 6], 9, -1069501632), i = g(i, a, c, f, n[h + 11], 14, 643717713), 
  f = g(f, i, a, c, n[h], 20, -373897302), c = g(c, f, i, a, n[h + 5], 5, -701558691), 
  a = g(a, c, f, i, n[h + 10], 9, 38016083), i = g(i, a, c, f, n[h + 15], 14, -660478335), 
  f = g(f, i, a, c, n[h + 4], 20, -405537848), c = g(c, f, i, a, n[h + 9], 5, 568446438), 
  a = g(a, c, f, i, n[h + 14], 9, -1019803690), i = g(i, a, c, f, n[h + 3], 14, -187363961), 
  f = g(f, i, a, c, n[h + 8], 20, 1163531501), c = g(c, f, i, a, n[h + 13], 5, -1444681467), 
  a = g(a, c, f, i, n[h + 2], 9, -51403784), i = g(i, a, c, f, n[h + 7], 14, 1735328473), 
  c = v(c, f = g(f, i, a, c, n[h + 12], 20, -1926607734), i, a, n[h + 5], 4, -378558), 
  a = v(a, c, f, i, n[h + 8], 11, -2022574463), i = v(i, a, c, f, n[h + 11], 16, 1839030562), 
  f = v(f, i, a, c, n[h + 14], 23, -35309556), c = v(c, f, i, a, n[h + 1], 4, -1530992060), 
  a = v(a, c, f, i, n[h + 4], 11, 1272893353), i = v(i, a, c, f, n[h + 7], 16, -155497632), 
  f = v(f, i, a, c, n[h + 10], 23, -1094730640), c = v(c, f, i, a, n[h + 13], 4, 681279174), 
  a = v(a, c, f, i, n[h], 11, -358537222), i = v(i, a, c, f, n[h + 3], 16, -722521979), 
  f = v(f, i, a, c, n[h + 6], 23, 76029189), c = v(c, f, i, a, n[h + 9], 4, -640364487), 
  a = v(a, c, f, i, n[h + 12], 11, -421815835), i = v(i, a, c, f, n[h + 15], 16, 530742520), 
  c = m(c, f = v(f, i, a, c, n[h + 2], 23, -995338651), i, a, n[h], 6, -198630844), 
  a = m(a, c, f, i, n[h + 7], 10, 1126891415), i = m(i, a, c, f, n[h + 14], 15, -1416354905), 
  f = m(f, i, a, c, n[h + 5], 21, -57434055), c = m(c, f, i, a, n[h + 12], 6, 1700485571), 
  a = m(a, c, f, i, n[h + 3], 10, -1894986606), i = m(i, a, c, f, n[h + 10], 15, -1051523), 
  f = m(f, i, a, c, n[h + 1], 21, -2054922799), c = m(c, f, i, a, n[h + 8], 6, 1873313359), 
  a = m(a, c, f, i, n[h + 15], 10, -30611744), i = m(i, a, c, f, n[h + 6], 15, -1560198380), 
  f = m(f, i, a, c, n[h + 13], 21, 1309151649), c = m(c, f, i, a, n[h + 4], 6, -145523070), 
  a = m(a, c, f, i, n[h + 11], 10, -1120210379), i = m(i, a, c, f, n[h + 2], 15, 718787259), 
  f = m(f, i, a, c, n[h + 9], 21, -343485551), c = d(c, r), f = d(f, e), i = d(i, o), 
  a = d(a, u);
  return [ c, f, i, a ];
 }
 function i(n) {
  for (var t = "", r = 32 * n.length, e = 0; e < r; e += 8) t += String.fromCharCode(n[e >> 5] >>> e % 32 & 255);
  return t;
 }
 function a(n) {
  var t = [];
  for (t[(n.length >> 2) - 1] = void 0, e = 0; e < t.length; e += 1) t[e] = 0;
  for (var r = 8 * n.length, e = 0; e < r; e += 8) t[e >> 5] |= (255 & n.charCodeAt(e / 8)) << e % 32;
  return t;
 }
 function e(n) {
  for (var t, r = "0123456789abcdef", e = "", o = 0; o < n.length; o += 1) t = n.charCodeAt(o), 
  e += r.charAt(t >>> 4 & 15) + r.charAt(15 & t);
  return e;
 }
 function r(n) {
  return unescape(encodeURIComponent(n));
 }
 function o(n) {
  return i(c(a(n = r(n)), 8 * n.length));
 }
 function u(n, t) {
  return function(n, t) {
   var r, e = a(n), o = [], u = [];
   for (o[15] = u[15] = void 0, 16 < e.length && (e = c(e, 8 * n.length)), r = 0; r < 16; r += 1) o[r] = 909522486 ^ e[r], 
   u[r] = 1549556828 ^ e[r];
   return t = c(o.concat(a(t)), 512 + 8 * t.length), i(c(u.concat(t), 640));
  }(r(n), r(t));
 }
 function t(n, t, r) {
  return t ? r ? u(t, n) : e(u(t, n)) : r ? o(n) : e(o(n));
 }
 "function" == typeof define && define.amd ? define(function() {
  return t;
 }) : "object" == typeof module && module.exports ? module.exports = t : n.md5 = t;
}(this);
