import request from "../request";
import qs from 'qs';

// 创建视图数据
export default class TaskInfo {
  // 生成架次号
  static flightSortieId(data) {
    return request({
      url: `/admin-api/bpm/task-info/flightsortieid`,
      method: "post",
      data
    });
  }

  // 通过任务生成架次号
  static createTaskRecord(data) {
    return request({
      url: `/admin-api/bpm/task-info-record/createTaskRecord`,
      method: "post",
      data
    });
  }
  

  // 获取航线
  static getRoute(data) {
    return request({
      url: `/admin-api/bpm/task-info/getreoute`,
      method: "post",
      data
    });
  }

  // 获取任务信息
  static getTaskInfoRecord(data) {
    return request({
      url: `/admin-api/bpm/task-info/getTaskInfoRecord`,
      method: "post",
      data
    });
  }

  /**
   * 全部单位
   * @param {*} params 
   * @returns 
   */
  static listAll(params) {
    return request({
      url: '/admin-api/system/dept/simple-list',
      method: 'get',
      params,
    });
  }
}