import AbstractDraw, { DRAW_TYPE } from "./AbstractDraw";
import { getCartesian3FromPX } from "../utils"

class AreaDraw extends AbstractDraw {

    positions = []
    entity = null

    constructor(options) {
        super({
            ...options,
            drawType: DRAW_TYPE.AREA
        })
        this.init()
    }

    init() {
        this.positions = []
        this.initEventHandler()
    }

    initEventHandler() {
        this.$onStart.addEventListener(this.onStart.bind(this))
        this.$onMove.addEventListener(this.onMove.bind(this))
        this.$onEnd.addEventListener(this.onEnd.bind(this))
    }

    onStart(moment) {
        let cartesian = getCartesian3FromPX(this.$viewer, moment.position)
        if (cartesian) {
            if (!this.positions.length) {
                this.positions.push(cartesian)
                let entity = this.entity = this.$createDrawPolygon(new Cesium.CallbackProperty(() => {
                    return new Cesium.PolygonHierarchy(this.positions)
                }, false))
                this.$entities.add(entity)
            }
            this.positions.push(cartesian)
            this.$options.start && this.$options.start({
                entity: this.entity,
                positions: this.positions
            })
        }
    }

    onMove(moment) {
        let cartesian = getCartesian3FromPX(this.$viewer, moment.endPosition)
        if (cartesian) {
            this.positions.pop()
            this.positions.push(cartesian)
        }
    }

    async onEnd(moment) {
        this.positions.pop()
        this.$entities.remove(this.entity)
        this.entity = null

        let entity = await this.createClampedPolygon(this.$viewer, this.positions.map(item => Cesium.Cartesian3.clone(item)))
        this.$entities.add(entity)

        //给中心点添加 label
        this.$addLabelOnEntityByCenter(DRAW_TYPE.AREA, entity)

        this.$options.end && this.$options.end({
            entity: this.entity,
            positions: this.positions,
        })
    }

    createClampedPolygon(viewer, positions, options) {
        return new Promise((resolve, reject) => {
            viewer.scene
                .clampToHeightMostDetailed(positions)
                .then((clampedCartesians) => {
                    let entity = new Cesium.Entity()
                    entity.polygon = {
                        hierarchy: new Cesium.PolygonHierarchy(clampedCartesians),
                        // material: new Cesium.ColorMaterialProperty(
                        //     Cesium.Color.YELLOWGREEN.withAlpha(0.7)
                        // ),
                        classificationType: Cesium.ClassificationType.TERRAIN,
                        show: true,
                        material: new Cesium.ColorMaterialProperty(
                            Cesium.Color.YELLOWGREEN.withAlpha(0.7)
                        ),
                        depthFailMaterial: new Cesium.ColorMaterialProperty(
                            Cesium.Color.YELLOWGREEN.withAlpha(0.7)
                        ),
                        perPositionHeight: true,
                        arcType: undefined,
                        zIndex: Number.POSITIVE_INFINITY
                    }
                    resolve(entity)
                })
        })
    }

}

export default AreaDraw