import AbstractDraw, { DRAW_TYPE } from "./AbstractDraw";
import { getCartesian3FromPX, transformCartesian2WGS84 } from "../utils"

class LineDraw extends AbstractDraw {

    positions = []
    entity = null
    
    constructor(options) {
        super({
            ...options,
            drawType: DRAW_TYPE.LINE
        })
        this.init()
    }
    init() {
        this.positions = []
        this.initEventHandler()
    }
    initEventHandler() {
        this.$onStart.addEventListener(this.onStart.bind(this))
        this.$onMove.addEventListener(this.onMove.bind(this))
        this.$onEnd.addEventListener(this.onEnd.bind(this))
    }
    onStart(moment) {
        let cartesian = getCartesian3FromPX(this.$viewer, moment.position)
        if (cartesian) {
            if (!this.positions.length) {
                this.positions.push(cartesian)
                let entity = this.entity = this.$createDrawPolyline(new Cesium.CallbackProperty(() => {
                    return this.positions
                }, false))
                this.$entities.add(entity)
            }
            this.positions.push(cartesian)
            this.$options.start && this.$options.start({
                entity: this.entity,
                positions: this.positions,
                //wgs84s: this.positions.map(item => transformCartesian2WGS84(item))
            })
        }
    }
    onMove(moment) {
        let cartesian = getCartesian3FromPX(this.$viewer, moment.endPosition)
        if (cartesian) {
            this.positions.pop()
            this.positions.push(cartesian)
        }
    }
    async onEnd(moment) {
        this.positions.pop()
        this.$entities.remove(this.entity)
        this.entity = null

        let positions = this.positions.map(item => Cesium.Cartesian3.clone(item))
        let entity = await this.createClampedPolyline(this.$viewer, positions)
        this.$entities.add(entity)

        //给 entity 添加中心点 label
        this.$addLabelOnEntityByCenter(DRAW_TYPE.LINE, entity)

        this.$options.end && this.$options.end({
            entity: entity,
            positions: positions,
        })

    }

    createClampedPolyline(viewer, positions, options) {
        return new Promise((resolve, reject) => {
            viewer.scene
                .clampToHeightMostDetailed(positions)
                .then((clampedCartesians) => {
                    let entity = new Cesium.Entity()
                    entity.polyline = {
                        positions: clampedCartesians,
                        arcType: Cesium.ArcType.NONE,
                        width: 2,
                        material: new Cesium.PolylineOutlineMaterialProperty({
                            color: Cesium.Color.YELLOW,
                        }),
                        depthFailMaterial: new Cesium.PolylineOutlineMaterialProperty({
                            color: Cesium.Color.YELLOW,
                        }),
                        ...options
                    }
                    resolve(entity)
                })
                
        })
    }
}

export default LineDraw