import request from "../request";
import request_uav from "../request_uav";

class Control_API {
  // 获取无人机树结构列表
  static getUavTree(params) {
    return request({
      url: "/admin-api/uas/drive/getDeptTree",
      // url: "/admin-api/uas/drive/getTree",
      // url: '/crm/personalCenter/list?id=4',
      method: "get",
      params,
    });
  }

  // 获取航线列表
  static getUavRouteList(params) {
    return request({
      // url: "/dms/route/page",
      url: "/admin-api/uas/flight-line/page",
      method: "get",
      params,
    });
  }

  static uploadFile(data){
    return request({
      url: `/admin-api/infra/file/upload`,
      method: "post",
      data,
    });
  }
  // 获取1小时短时天气预报
  static getUavShortForEcast(params) {
    return request_uav({
      url: `/whapi/json/aliweather/shortforecast`,
      method: "post",
      params,
    });
  }
  // 获取24小时短时天气预报(详细)包含风向等等...
  static getUavShortForEcast24(params) {
    return request_uav({
      url: `/whapi/json/aliweather/forecast24hours`,
      method: "post",
      params,
    });
  }
  // 接管无人机
  static setUavControlOn(params) {
    return request({
      url: `/admin-api/uas/device/controlUav`,
      method: 'post',
      params
    });
  }
  // 强制接管无人机
  static setUavControlOnForce(params) {
    return request({
      url: `/admin-api/uas/device/forceControlUav`,
      method: 'post',
      params
    });
  }
  // 解除无人机控制
  static setUavControlOff(params) {
    return request({
      url: `/admin-api/uas/device/quitControlUav`,
      method: 'post',
      params
    });
  }
  // 获取设备视频流
  static getDeviceStream(params) {
    return request({
      url: `/admin-api/uas/device-stream/page`,
      method: "get",
      params
    });
  }
  // 设备详情详情
  static getDeviceDetail(params) {
    return request({
      url: `/admin-api/uas/device/get`,
      method: "get",
      params
    });
  }

  // 获得接管记录
  static getTakeRecord(params){
    return request({
      url: `/admin-api/uas/device/getTakeRecord`,
      method: "get",
      params
    }); 
  }

}

export default Control_API;
