import { mapState } from 'vuex';

// 无人机实时数据各链路融合
export default {
  computed: {
    ...mapState("MMCFlightControlCenter/hangar", ["hangar"]),
    ...mapState("MMCFlightControlCenter/uav", ["uav"]),
    ...mapState("MMCFlightControlCenter", ['mqttUrlHangar', 'mqttToken']),
    // mqtt实时数据
    mqttDataSetHangar() {
      return this.$store.state.MMCMQTT?.dataSet?.[this.hangar?.deviceId];
    },
    mqttDataSetUav() {
      return this.$store.state.MMCMQTT?.dataSet?.[this.uav?.deviceId];
    },
  },
  watch: {
    mqttDataSetHangar(newVal) {
      if (newVal) {
        this.$store.dispatch(
          "MMCFlightControlCenter/hangar/updateByMQTT",
          newVal
        );
      }
    },
    mqttDataSetUav(newVal) {
      if (newVal) {
        this.$store.dispatch("MMCFlightControlCenter/uav/updateByMQTT", newVal);
      }
    },
  },
  async mounted() {
    // 启动mqtt服务
    try {
      this.$store
        .dispatch("MMCMQTT/init", {
          url: this.mqttUrlHangar,
          password: this.mqttToken
        })
        .then(() => {
          console.log("mqtt连接成功");
        });
    } catch (e) {
      console.log("mqtt失败", e);
    }
  },
  beforeDestroy() {
    console.log("断开mqtt连接");

    if (this.uav) {
      this.$store.dispatch("MMCFlightControlCenter/uav/unsubscribe");
    }
    if (this.hangar) {
      this.$store.dispatch("MMCFlightControlCenter/hangar/unsubscribe");
    }
    this.$store.dispatch("MMCFlightControlCenter/uav/end");
  },
};
