import { Base64 } from "js-base64";
/**
 * 转换流地址, 这样后端才可统计播放情况
 * @param {*} url 
 * @param {*} deviceId 
 * @returns 
 */
export function coverStreamUrl(url, deviceId) {
  if (url.includes("https://live.mmcuav.cn")) {
    const str = Base64.encode(
      JSON.stringify({
        token: localStorage.getItem("tmj_token"),
        actionId: new Date().getTime().toString(),
        deviceHardId: deviceId,
        environment: process.env.VUE_APP_ENV === "dev" ? "sit" : "prod",
      })
    );
    return `${url}?${str}`;
  } else {
    return url;
  }
}
