import mqtt from "mqtt"
const {
    VUE_APP_FCMQTT_URL
} = process.env
export default {

    uint8array2json(uint8array) {
        if (!uint8array || !uint8array.length) {
            return uint8array
        }
        let { decoder } = this.mqtt
        if (!decoder) {
            decoder = new TextDecoder("utf-8")
        }
        let content = decoder.decode(uint8array)
        return content ? JSON.parse(content) : content
    },

    json2uint8array(data) {
        if (!data) {
            return data
        }
        let { encoder } = this.mqtt
        if (!encoder) {
            encoder = new TextEncoder();
        }
        let uint8array = encoder.encode(JSON.stringify(data))
        return uint8array
    },

    init() {
        let { user_info } = this

        let url = VUE_APP_FCMQTT_URL
        this.mqtt.client = mqtt.connect(url, {
            protocol: "mqtt",
            clientId: user_info.id
        })

        this.mqtt.client.on("connect", () => {
            console.log("mqtt is connected");
        })
        this.mqtt.client.on("message", (topic, payload, packet) => {
            let data = this.mqtt_uint8array2json(payload)
            let deviceHardId = packet.topic.split("/")[2]
            window.$log('observe/fckernel/methods/mqtt.js message', data);
            if (data.type === 258) {
                // 更新无人机位置信息
                this.uav_update_location({ deviceHardId }, data.data)
                // 更新控制面板数据
                this.uav_update_control({ deviceHardId }, data.data)
            }

            if (data.type === 257) {
                // 无人机电池数据
                this.uav_update_control_battery({ deviceHardId }, data.data)
            }

            if (data.type === 514) {
                // 挂载数据
                this.uav_update_mount({ deviceHardId }, data.data)
            }
            if (data.type === 259) {
                this.uav_update_mount({ deviceHardId }, data.data)
                // 挂载数据
                // console.log(    data.data,'挂載數據');
            }
            // 无人机提示信息
            if (data.type === 260) {
                console.log(data.data,'无人机提示信息');
                this.update_control_info({ deviceHardId }, data.data)

            }
            if (data.type === 500 && data.msgnum === 4132) {
                // 设备上线
                this.uav_update_device_report_status(1, deviceHardId)
            }
            if (data.type === 500 && data.msgnum === 4121) {
                // 设备离线
                this.uav_update_device_report_status(0, deviceHardId)
            }
            if (data.type === 500 && data.msgnum === 4121) {
                // 设备离线
                this.uav_update_device_report_status(0, deviceHardId)
            }

            if (data.type === 264) {
                console.log(data.data,'航线状态');
                // 航线上传
                this.airway_upload_message(data.data, packet.topic)
            }

        })

        /**
         * 订阅无人机上线下线消息
         */
        this.mqtt_subscribe(`on_and_off_broker`, (e) => {
            console.log("subscribe on_and_off_broker");
        });
    },

    /**
     * 订阅
     * @param {*} topic 
     * @param {*} callback 
     */
    subscribe(topic, callback) {
        if (!topic) {
            return topic
        }
        let { client } = this.mqtt
        if (client) {
            client.subscribe(topic, callback)
        }
    },

    /**
     * 取消订阅
     * @param {*} topic 
     * @returns 
     */
    unsubscribe(topic) {
        if (!topic) {
            return topic
        }
        let { client } = this.mqtt
        if (client) {
            client.unsubscribe(topic)
        }
    },

    /**
     * 发布
     * QoS 0：消息最多传递一次，如果当时客户端不可用，则会丢失该消息。
     * QoS 1：消息传递至少 1 次。
     * QoS 2：消息仅传送一次。
     * @param {*} publication 
     * @param {*} callback 
     * @param {*} options 
     */
    publish(topic, message, callback, options = { qos: 0 }) {
        let { client } = this.mqtt
        if (client) {
            client.publish(topic, this.mqtt_json2uint8array(message), options, callback)
        }
    },

}