import AbstractDraw, { DRAW_TYPE } from "./AbstractDraw";
import { getCartesian3FromPX, transformCartesian2WGS84 } from "../utils"

class PointDraw extends AbstractDraw {

    positions = []
    entity = null

    constructor(options){
        super({
            ...options,
            drawType: DRAW_TYPE.POINT
        })
        this.init()
    }

    init(){
        this.initEventHandler()
    }

    initEventHandler(){
        this.$onStart.addEventListener(this.onStart.bind(this))
        this.$onEnd.addEventListener(this.onEnd.bind(this))
    }

    onStart(moment){
        let cartesian = getCartesian3FromPX(this.$viewer, moment.position)
        if(cartesian){
            let point = this.entity = this.$createDrawPoint(cartesian)
            this.$entities.add(point)
            this.positions.push(point)
            this.$addLabelOnDrawEntity(point, {
                text: "默认点标注"
            })
            this.$options.start && this.$options.start({
                entity: point,
                wgs84: transformCartesian2WGS84(cartesian)
            })
        }
    }
    // onMove(moment){
    //     this.$options.move && this.$options.move(this.positions)
    // }
    onEnd(moment){
        this.$options.end && this.$options.end({
            entity: this.entity,
            positions: this.positions
        })
    }

}

export default PointDraw