import axios from "axios";
import request from "../request";

// const gddaiapi = 'https://hawk.mmcuav.cn/gddaiapi';

export default class AI_API {
  // 获取当前的ai配置
  static getAiconfig(data) {
    return request({
      url: `/admin-api/system/ai-config/getconfig`,
      method: "post",
      data,
    });
  }
  // 人脸
  static face(data) {
    return axios.post(
      "https://hawk.mmcuav.cn/faceaiapi/detect/imageface",
      data
    );
  }
  // 车牌
  static plate(data) {
    return axios.post(
      "/gddaiapi/api/inflet/v1/tasks/e01d1d01-52e2-4883-a5de-0ae268764db0/predict",
      data
    ); // 共达地
  }

  // 人流
  static crowd(data) {
    return axios.post(
      "/gddaiapi/api/inflet/v1/tasks/18493235-4dd0-4f54-ab55-c1856ca7e3a5/predict",
      data
    );
  }

  // 烟雾
  static smoke(data) {
    return axios.post(
      "/gddaiapi/api/inflet/v1/tasks/fca2eb65-8b99-4109-9f9e-a9f7fd06ac1f/predict",
      data
    );
  }

  // 漏油识别
  static oilLeak(data) {
    return axios.post("https://hawk.mmcuav.cn/oilaiapi/detect/image", data);
  }

  // 裸土识别
  static bareSoil(data) {
    return axios.post(
      "/gddaiapi/api/inflet/v1/tasks/05a9d657-8339-4575-bced-04b60b74c690/predict",
      data
    );
  }
  // 其余ai
  static kbtAi(data) {
    return axios.post("https://hawk.mmcuav.cn/detect/image", data);
  }
}
