import axios from "axios";

const key = "ced06243e56f41f5b7180f08731026da";
const appKey = "30c6030f6e144f08b51f7781699276c3";

export default class Map {
  static Regeo(params) {
    return new Promise((resolve, reject) => {
      // 开发者模式
      axios
        .get("https://api.tianditu.gov.cn/geocoder", {
          params: {
            tk: key,
            postStr: JSON.stringify(params),
            type: "geocode",
          },
        })
        .then((res) => {
          if (
            res.data &&
            res.data.result &&
            res.data.result.formatted_address
          ) {
            resolve(res.data.result.formatted_address);
          } else {
            reject(null);
          }
        })
        .catch((e) => reject(e));
    });
  }

  static AiRegeo(params) {
    return new Promise((resolve, reject) => {
      // 开发者模式
      axios
        .get("https://api.tianditu.gov.cn/geocoder", {
          params: {
            tk: key,
            postStr: JSON.stringify(params),
            type: "geocode",
          },
        })
        .then((res) => {
          if (res.data && res.data.result) {
            resolve(res.data.result);
          } else {
            reject(null);
          }
        })
        .catch((e) => reject(e));
    });
  }
  //天地图编码查询
  static Geo(params) {
    let promise = axios
      .get("https://api.tianditu.gov.cn/v2/search", {
        params: {
          tk: key,
          postStr: JSON.stringify(params),
          type: "query",
        },
      })
      .then((res) => {
        res.data.data = {
          rows: [],
        };
        if (res.data.count > 0) {
          res.data.data.rows = res.data.pois;
        } else {
          res.data.data.rows = [];
        }

        return res;
      });
    return promise;
  }

  static Driv(params) {
    let promise = axios.get(
      "http://32.128.12.138:21009/service/lbs/coder/geocoding2",
      {
        params: {
          appKey,
          city: "全国",
          page_size: 20,
          ...params,
        },
      }
    );
    return promise;
  }
}
