import request from "../request";
import store from "../../store";

class Control_API {
  // 获取无人机树结构列表
  static getUavTree(params) {
    return request({
      url: "/admin-api/uas/drive/getDeptTree",
      // url: "/admin-api/uas/drive/getTree",
      // url: '/crm/personalCenter/list?id=4',
      method: "get",
      params,
    });
  }

  // 获取航线列表
  static getUavRouteList(params) {
    return request({
      // url: "/dms/route/page",
      url: "/admin-api/uas/flight-line/page",
      method: "get",
      params,
    });
  }

  static uploadFile(data){
    return request({
      url: `/admin-api/infra/file/upload`,
      method: "post",
      data,
    });
  }
  // 是否同意接管
  static updateControlUav(data) {
    return request({
      url: `/admin-api/uas/device-take/updateControlUav`,
      method: 'post',
      data
    });
  }
  // 录入设备操控人
  static updateCurrentOperator(params) {
    return request({
      url: `/admin-api/uas/device-take/updateCurrentOperator`,
      method: 'post',
      params
    });
  }
  // 申请接管无人机
  static applyControlUav(params) {
    return request({
      url: `/admin-api/uas/device-take/updateCurrentOperator`,
      method: 'post',
      params
    });
  }
  // 强制接管无人机
  static setUavControlOnForce(params) {
    return request({
      url: `/admin-api/uas/device-take/forceControlUav`,
      method: 'post',
      params
    });
  }
  // 解除无人机控制
  static setUavControlOff(params) {
    return request({
      url: `/admin-api/uas/device-take/quitControlUav`,
      method: 'post',
      params
    });
  }
  // 获取设备视频流
  static getDeviceStream(params) {
    return request({
      url: `/admin-api/uas/device-stream/page`,
      method: "get",
      params
    });
  }
  // 设备详情详情
  static getDeviceDetail(params) {
    return request({
      url: `/admin-api/uas/device/get`,
      method: "get",
      params
    });
  }

  // 获得接管记录
  static getTakeRecord(params){
    return request({
      url: `/admin-api/uas/device-take/getTakeRecord`,
      method: "get",
      params
    }); 
  }

  /**
   * 获取websocket连接地址
   * @returns 
   */
  static getWebsocketUrl(){
    return `/infra/ws?token=${store.state.token}`;
  }
}

export default Control_API;
