const state = {
  throttleValue: 0, //油门值
  manualControlStatus: false, //是否手动控制
  onInfieldControlFn:null, //状态改变时摇杆会切换为手动模式并抢权限
};

const mutations = {
  /**
   * 单纯的给state赋值
   * @param {*} param0
   * @param {*} data {key: '', value}
   */
  setState(state, data) {
    try {
      state[data.key] = data.value;
    } catch (e) {
      console.log("setDate err", e);
    }
  },
};

const actions = {};

const getters = {
  /**
   * //油门是否置中
   * @param {*} state 
   * @returns 
   */
  isThrottleCenter(state) {
    if (state.throttleValue >= 470 && state.throttleValue <= 530) {
      return true;
    } else {
      return false;
    }
  }
};

export default {
  namespaced: true,
  name: "uav",
  state,
  mutations,
  actions,
  getters,
};
