const { defineConfig } = require("@vue/cli-service");
const NodePolyfillPlugin = require("node-polyfill-webpack-plugin"); // 引入
const packageName = require('./package.json').name;
const publicPath = process.env.NODE_ENV === 'production' ? '/tmj_fkzx_v4/' : `//localhost:9000`;

module.exports = defineConfig({
  // publicPath: "./",
  publicPath: publicPath,
  transpileDependencies: true,
  productionSourceMap: false,
  configureWebpack: {
    plugins: [new NodePolyfillPlugin()],
    output: {
      library: `${packageName}-[name]`,
      libraryTarget: 'umd',
      chunkLoadingGlobal: `webpackJsonp_${packageName}`,
    },
    
  },
  devServer: {
    https: false,
    port: 9000,
    client: {
      overlay: false,
    },
    headers: {
      "Access-Control-Allow-Origin": "*",
      "X-Frame-Options": "ALLOWALL",
      "Cross-Origin-Opener-Policy": "same-origin",
      "Cross-Origin-Embedder-Policy": "require-corp",
      "Cross-Origin-Resource-Policy": "cross-origin",
    },
    /* proxy: {
      "/": {
        target: "http://localhost:9000",
        changeOrigin: true,
      }
    } */
  },
});
