const { defineConfig } = require("@vue/cli-service");
const webpack = require("webpack");
const NodePolyfillPlugin = require("node-polyfill-webpack-plugin");

module.exports = defineConfig({
  publicPath: "./",
  transpileDependencies: true,
  configureWebpack: {
    plugins: [
      new NodePolyfillPlugin(),
      new webpack.ProvidePlugin({
        process: "process/browser",
        Buffer: ["buffer", "Buffer"],
      }),
    ],
  },
  devServer: {
    https: false,
    client: {
      overlay: false,
    },
   /*  headers: {
      "Cross-Origin-Opener-Policy": "cross-origin",
      "Cross-Origin-Embedder-Policy": "require-corp",
    }, */

    proxy: {
      "/crm": {
        target: "https://test.tmj.mmcuav.cn/",
        // target: "http://47.106.147.192/", //测试
        // target: "http://120.79.102.66",
        // target: "http://120.77.219.153:80", //v3正式
        // target: "http://39.108.188.237:10009", //推广平台
        ws: false,
        changeOrigin: true,
        pathRewrite: {},
      },
    },
  },
});
