/**
 * Cesium - https://github.com/CesiumGS/cesium
 *
 * Copyright 2011-2020 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/master/LICENSE.md for full licensing details.
 */

var DracoDecoderModule = (function() {
  var _scriptDir = typeof document !== 'undefined' && document.currentScript ? document.currentScript.src : undefined;
  if (typeof __filename !== 'undefined') _scriptDir = _scriptDir || __filename;
  return (
function(DracoDecoderModule) {
  DracoDecoderModule = DracoDecoderModule || {};

var Module=typeof DracoDecoderModule!=="undefined"?DracoDecoderModule:{};var isRuntimeInitialized=false;var isModuleParsed=false;Module["onRuntimeInitialized"]=function(){isRuntimeInitialized=true;if(isModuleParsed){if(typeof Module["onModuleLoaded"]==="function"){Module["onModuleLoaded"](Module)}}};Module["onModuleParsed"]=function(){isModuleParsed=true;if(isRuntimeInitialized){if(typeof Module["onModuleLoaded"]==="function"){Module["onModuleLoaded"](Module)}}};function isVersionSupported(versionString){if(typeof versionString!=="string")return false;const version=versionString.split(".");if(version.length<2||version.length>3)return false;if(version[0]==1&&version[1]>=0&&version[1]<=3)return true;if(version[0]!=0||version[1]>10)return false;return true}Module["isVersionSupported"]=isVersionSupported;var moduleOverrides={};var key;for(key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var arguments_=[];var thisProgram="./this.program";var quit_=function(status,toThrow){throw toThrow};var ENVIRONMENT_IS_WEB=false;var ENVIRONMENT_IS_WORKER=false;var ENVIRONMENT_IS_NODE=false;var ENVIRONMENT_HAS_NODE=false;var ENVIRONMENT_IS_SHELL=false;ENVIRONMENT_IS_WEB=typeof window==="object";ENVIRONMENT_IS_WORKER=typeof importScripts==="function";ENVIRONMENT_HAS_NODE=typeof process==="object"&&typeof process.versions==="object"&&typeof process.versions.node==="string";ENVIRONMENT_IS_NODE=ENVIRONMENT_HAS_NODE&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;var scriptDirectory="";function locateFile(path){if(Module["locateFile"]){return Module["locateFile"](path,scriptDirectory)}return scriptDirectory+path}var read_,readAsync,readBinary,setWindowTitle;var nodeFS;var nodePath;if(ENVIRONMENT_IS_NODE){scriptDirectory=__dirname+"/";read_=function shell_read(filename,binary){var ret=tryParseAsDataURI(filename);if(ret){return binary?ret:ret.toString()}if(!nodeFS)nodeFS=require("fs");if(!nodePath)nodePath=require("path");filename=nodePath["normalize"](filename);return nodeFS["readFileSync"](filename,binary?null:"utf8")};readBinary=function readBinary(filename){var ret=read_(filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};if(process["argv"].length>1){thisProgram=process["argv"][1].replace(/\\/g,"/")}arguments_=process["argv"].slice(2);process["on"]("uncaughtException",function(ex){if(!(ex instanceof ExitStatus)){throw ex}});process["on"]("unhandledRejection",abort);quit_=function(status){process["exit"](status)};Module["inspect"]=function(){return"[Emscripten Module object]"}}else if(ENVIRONMENT_IS_SHELL){if(typeof read!="undefined"){read_=function shell_read(f){var data=tryParseAsDataURI(f);if(data){return intArrayToString(data)}return read(f)}}readBinary=function readBinary(f){var data;data=tryParseAsDataURI(f);if(data){return data}if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){arguments_=scriptArgs}else if(typeof arguments!="undefined"){arguments_=arguments}if(typeof quit==="function"){quit_=function(status){quit(status)}}if(typeof print!=="undefined"){if(typeof console==="undefined")console={};console.log=print;console.warn=console.error=typeof printErr!=="undefined"?printErr:print}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){if(ENVIRONMENT_IS_WORKER){scriptDirectory=self.location.href}else if(document.currentScript){scriptDirectory=document.currentScript.src}if(_scriptDir){scriptDirectory=_scriptDir}if(scriptDirectory.indexOf("blob:")!==0){scriptDirectory=scriptDirectory.substr(0,scriptDirectory.lastIndexOf("/")+1)}else{scriptDirectory=""}{read_=function shell_read(url){try{var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText}catch(err){var data=tryParseAsDataURI(url);if(data){return intArrayToString(data)}throw err}};if(ENVIRONMENT_IS_WORKER){readBinary=function readBinary(url){try{var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.responseType="arraybuffer";xhr.send(null);return new Uint8Array(xhr.response)}catch(err){var data=tryParseAsDataURI(url);if(data){return data}throw err}}}readAsync=function readAsync(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response);return}var data=tryParseAsDataURI(url);if(data){onload(data.buffer);return}onerror()};xhr.onerror=onerror;xhr.send(null)}}setWindowTitle=function(title){document.title=title}}else{}var out=Module["print"]||console.log.bind(console);var err=Module["printErr"]||console.warn.bind(console);for(key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}moduleOverrides=null;if(Module["arguments"])arguments_=Module["arguments"];if(Module["thisProgram"])thisProgram=Module["thisProgram"];if(Module["quit"])quit_=Module["quit"];var STACK_ALIGN=16;function dynamicAlloc(size){var ret=HEAP32[DYNAMICTOP_PTR>>2];var end=ret+size+15&-16;if(end>_emscripten_get_heap_size()){abort()}HEAP32[DYNAMICTOP_PTR>>2]=end;return ret}function getNativeTypeSize(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return 4}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0,"getNativeTypeSize invalid bits "+bits+", type "+type);return bits/8}else{return 0}}}}function warnOnce(text){if(!warnOnce.shown)warnOnce.shown={};if(!warnOnce.shown[text]){warnOnce.shown[text]=1;err(text)}}function convertJsFunctionToWasm(func,sig){return func}function addFunctionWasm(func,sig){var table=wasmTable;var ret=table.length;try{table.grow(1)}catch(err){if(!err instanceof RangeError){throw err}throw"Unable to grow wasm table. Use a higher value for RESERVED_FUNCTION_POINTERS or set ALLOW_TABLE_GROWTH."}try{table.set(ret,func)}catch(err){if(!err instanceof TypeError){throw err}assert(typeof sig!=="undefined","Missing signature argument to addFunction");var wrapped=convertJsFunctionToWasm(func,sig);table.set(ret,wrapped)}return ret}function removeFunctionWasm(index){}var funcWrappers={};function dynCall(sig,ptr,args){if(args&&args.length){return Module["dynCall_"+sig].apply(null,[ptr].concat(args))}else{return Module["dynCall_"+sig].call(null,ptr)}}var tempRet0=0;var setTempRet0=function(value){tempRet0=value};var getTempRet0=function(){return tempRet0};var wasmBinary;if(Module["wasmBinary"])wasmBinary=Module["wasmBinary"];var noExitRuntime;if(Module["noExitRuntime"])noExitRuntime=Module["noExitRuntime"];var WebAssembly={Memory:function(opts){return{buffer:new ArrayBuffer(opts["initial"]*65536),grow:function(amount){var ret=__growWasmMemory(amount);return ret}}},Table:function(opts){var ret=new Array(opts["initial"]);ret.grow=function(by){if(ret.length>=381+0){abort("Unable to grow wasm table. Use a higher value for RESERVED_FUNCTION_POINTERS or set ALLOW_TABLE_GROWTH.")}ret.push(null)};ret.set=function(i,func){ret[i]=func};ret.get=function(i){return ret[i]};return ret},Module:function(binary){return{}},Instance:function(module,info){var decodeBase64=typeof atob==="function"?atob:function(input){var keyStr="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";var output="";var chr1,chr2,chr3;var enc1,enc2,enc3,enc4;var i=0;input=input.replace(/[^A-Za-z0-9\+\/\=]/g,"");do{enc1=keyStr.indexOf(input.charAt(i++));enc2=keyStr.indexOf(input.charAt(i++));enc3=keyStr.indexOf(input.charAt(i++));enc4=keyStr.indexOf(input.charAt(i++));chr1=enc1<<2|enc2>>4;chr2=(enc2&15)<<4|enc3>>2;chr3=(enc3&3)<<6|enc4;output=output+String.fromCharCode(chr1);if(enc3!==64){output=output+String.fromCharCode(chr2)}if(enc4!==64){output=output+String.fromCharCode(chr3)}}while(i<input.length);return output};function intArrayFromBase64(s){if(typeof ENVIRONMENT_IS_NODE==="boolean"&&ENVIRONMENT_IS_NODE){var buf;try{buf=Buffer.from(s,"base64")}catch(_){buf=new Buffer(s,"base64")}return new Uint8Array(buf.buffer,buf.byteOffset,buf.byteLength)}try{var decoded=decodeBase64(s);var bytes=new Uint8Array(decoded.length);for(var i=0;i<decoded.length;++i){bytes[i]=decoded.charCodeAt(i)}return bytes}catch(_){throw new Error("Converting base64 string to bytes failed.")}}var atob=decodeBase64;var exports=(
// EMSCRIPTEN_START_ASM
function a(/** @suppress {uselessCode} */asmLibraryArg,wasmMemory,wasmTable){var scratchBuffer=new ArrayBuffer(8);var b=new Int32Array(scratchBuffer);var c=new Float32Array(scratchBuffer);var d=new Float64Array(scratchBuffer);function e(index){return b[index]}function f(index,value){b[index]=value}function g(){return d[0]}function h(value){d[0]=value}function i(low,high){b[0]=low;b[1]=high}function j(){return c[0]}function k(value){c[0]=value}function l(global,env,buffer){var m=env.memory;var n=wasmTable;var o=new global.Int8Array(buffer);var p=new global.Int16Array(buffer);var q=new global.Int32Array(buffer);var r=new global.Uint8Array(buffer);var s=new global.Uint16Array(buffer);var t=new global.Uint32Array(buffer);var u=new global.Float32Array(buffer);var v=new global.Float64Array(buffer);var w=global.Math.imul;var x=global.Math.fround;var y=global.Math.abs;var z=global.Math.clz32;var A=global.Math.min;var B=global.Math.max;var C=global.Math.floor;var D=global.Math.ceil;var E=global.Math.sqrt;var F=env.abort;var G=global.NaN;var H=global.Infinity;var I=env.__cxa_allocate_exception;var J=env.__cxa_throw;var K=env.fd_write;var L=env.fd_close;var M=env.environ_sizes_get;var N=env.environ_get;var O=env.abort;var P=env.emscripten_resize_heap;var Q=env.emscripten_memcpy_big;var R=env.setTempRet0;var S=env.fd_seek;var T=5261296;var U=18412;var V=0;
// EMSCRIPTEN_START_FUNCS
function ea(){tm()}function fa(a,b){var c=0,d=0,e=0,f=0;c=T-16|0;T=c;q[c+8>>2]=0;q[c>>2]=0;q[c+4>>2]=0;d=dm(b);if(d>>>0<4294967280){a:{b:{if(d>>>0>=11){f=d+16&-16;e=Mm(f);q[c+8>>2]=f|-2147483648;q[c>>2]=e;q[c+4>>2]=d;break b}o[c+11|0]=d;e=c;if(!d){break a}}Cn(e,b,d)}o[d+e|0]=0;a=ga(a,c);if(o[c+11|0]<=-1){An(q[c>>2])}T=c+16|0;return(a|0)!=0}Pm();F()}function ga(a,b){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;a=q[a+4>>2];if(a){h=r[b+11|0];i=h<<24>>24<0;h=i?q[b+4>>2]:h;l=i?q[b>>2]:b;while(1){b=a+16|0;g=r[a+27|0];i=g<<24>>24<0;j=i?q[a+20>>2]:g;m=j>>>0<h>>>0;a:{b:{c:{d:{e:{f:{g=m?j:h;if(g){k=i?q[b>>2]:b;n=cm(l,k,g);if(n){break f}}if(h>>>0<j>>>0){break a}if(!g){break d}k=i?q[b>>2]:b;break e}if((n|0)<=-1){break a}}b=cm(k,l,g);if(b){break c}}if(m){break b}return 1}if((b|0)<=-1){break b}return 1}a=a+4|0}a=q[a>>2];if(a){continue}break}}return 0}function ha(a,b){var p=0,r=0,s=0,t=0;p=T-16|0;T=p;q[p+12>>2]=0;q[p+8>>2]=0;q[p>>2]=0;q[p+4>>2]=0;r=dm(b);if(r>>>0<4294967280){a:{b:{if(r>>>0>=11){t=r+16&-16;s=Mm(t);q[p+8>>2]=t|-2147483648;q[p>>2]=s;q[p+4>>2]=r;break b}o[p+11|0]=r;s=p;if(!r){break a}}Cn(s,b,r)}o[r+s|0]=0;Vk(a,p,p+12|0);a=q[p+12>>2];if(o[p+11|0]<=-1){An(q[p>>2])}T=p+16|0;return a}Pm();F()}function ia(a,b,u){var v=0,w=0,x=0,y=0;v=T-32|0;T=v;q[v+24>>2]=0;q[v+16>>2]=0;q[v+20>>2]=0;w=dm(b);if(w>>>0<4294967280){a:{b:{if(w>>>0>=11){y=w+16&-16;x=Mm(y);q[v+24>>2]=y|-2147483648;q[v+16>>2]=x;q[v+20>>2]=w;break b}o[v+27|0]=w;x=v+16|0;if(!w){break a}}Cn(x,b,w)}o[w+x|0]=0;q[v+8>>2]=0;q[v>>2]=0;q[v+4>>2]=0;Wk(a,v+16|0,v);a=q[u>>2];if(a){q[u+4>>2]=a;An(a);q[u+8>>2]=0;q[u>>2]=0;q[u+4>>2]=0}q[u>>2]=q[v>>2];q[u+4>>2]=q[v+4>>2];q[u+8>>2]=q[v+8>>2];if(o[v+27|0]<=-1){An(q[v+16>>2])}T=v+32|0;return}Pm();F()}function ja(a,b){var u=0,z=0,A=0,B=0,C=0;u=T-32|0;T=u;q[u+24>>2]=0;q[u+28>>2]=0;q[u+16>>2]=0;q[u+8>>2]=0;q[u+12>>2]=0;z=dm(b);if(z>>>0<4294967280){a:{b:{if(z>>>0>=11){B=z+16&-16;A=Mm(B);q[u+16>>2]=B|-2147483648;q[u+8>>2]=A;q[u+12>>2]=z;break b}o[u+19|0]=z;A=u+8|0;if(!z){break a}}Cn(A,b,z)}o[z+A|0]=0;Xk(a,u+8|0,u+24|0);C=v[u+24>>3];if(o[u+19|0]<=-1){An(q[u+8>>2])}T=u+32|0;return C}Pm();F()}function ka(a,b,D){var E=0,G=0,H=0,I=0;E=T-16|0;T=E;q[E+8>>2]=0;q[E>>2]=0;q[E+4>>2]=0;G=dm(D);if(G>>>0<4294967280){a:{b:{if(G>>>0>=11){I=G+16&-16;H=Mm(I);q[E+8>>2]=I|-2147483648;q[E>>2]=H;q[E+4>>2]=G;break b}o[E+11|0]=G;H=E;if(!G){break a}}Cn(H,D,G)}o[G+H|0]=0;a=a+16|0;D=0;c:{if(!Yk(b,E,a)){break c}D=q[a>>2];if(o[a+11|0]<=-1){break c}D=a}if(o[E+11|0]<=-1){An(q[E>>2])}T=E+16|0;return D}Pm();F()}function la(a,b,D){var F=0,J=0,K=0,L=0;a:{if(q[a+12>>2]==(b|0)){break a}F=q[a>>2];K=a+4|0;J=q[K>>2];if((F|0)!=(J|0)){while(1){L=J+ -12|0;if(o[J+ -1|0]<=-1){An(q[L>>2])}J=L;if((J|0)!=(F|0)){continue}break}}q[a+12>>2]=b;q[K>>2]=F;J=q[b>>2];K=b+4|0;if((J|0)==(K|0)){break a}L=a+8|0;while(1){b=J+16|0;b:{if(q[L>>2]!=(F|0)){Rm(F,b);b=a+4|0;q[b>>2]=q[b>>2]+12;break b}ma(a,b)}F=q[J+4>>2];c:{if(!F){b=q[J+8>>2];if(q[b>>2]==(J|0)){break c}J=J+8|0;while(1){F=q[J>>2];J=F+8|0;b=q[F+8>>2];if((F|0)!=q[b>>2]){continue}break}break c}while(1){b=F;F=q[F>>2];if(F){continue}break}}if((b|0)==(K|0)){break a}F=q[a+4>>2];J=b;continue}}F=0;d:{if((D|0)<0){break d}b=q[a+4>>2];a=q[a>>2];if((b-a|0)/12>>>0<=D>>>0){break d}F=a+w(D,12)|0;if(o[F+11|0]>-1){break d}F=q[F>>2]}return F}function ma(a,b){var D=0,M=0,N=0,O=0,P=0;a:{b:{c:{N=q[a>>2];P=(q[a+4>>2]-N|0)/12|0;D=P+1|0;if(D>>>0<357913942){N=(q[a+8>>2]-N|0)/12|0;O=N<<1;D=N>>>0<178956970?O>>>0<D>>>0?D:O:357913941;M=0;d:{if(!D){break d}if(D>>>0>=357913942){break c}M=Mm(w(D,12))}N=M+w(D,12)|0;b=Rm(M+w(P,12)|0,b);P=b+12|0;D=q[a+4>>2];M=q[a>>2];if((D|0)==(M|0)){break b}while(1){D=D+ -12|0;O=q[D+4>>2];b=b+ -12|0;q[b>>2]=q[D>>2];q[b+4>>2]=O;O=D+8|0;q[b+8>>2]=q[O>>2];q[D>>2]=0;q[D+4>>2]=0;q[O>>2]=0;if((D|0)!=(M|0)){continue}break}M=q[a+4>>2];D=q[a>>2];break a}bn();F()}ab(1040);F()}D=M}q[a>>2]=b;q[a+8>>2]=N;q[a+4>>2]=P;if((D|0)!=(M|0)){while(1){a=M+ -12|0;if(o[M+ -1|0]<=-1){An(q[a>>2])}M=a;if((a|0)!=(D|0)){continue}break}}if(D){An(D)}}function na(a){var b=0;ck(a);b=a+16|0;q[b>>2]=0;q[b+4>>2]=0;q[a+24>>2]=0;q[a+28>>2]=0;q[a+12>>2]=b;q[a+32>>2]=0;q[a+36>>2]=0;return a}function oa(a){var Q=0;Q=T-32|0;T=Q;hh(Q+8|0,a);a=q[Q+24>>2];if(o[Q+23|0]<=-1){An(q[Q+12>>2])}T=Q+32|0;return a}function pa(a,R,S){var U=0;U=T-16|0;T=U;ih(U,a,R,S);q[a+24>>2]=q[U>>2];Tm(a+28|0,U|4);a=a+24|0;if(o[U+15|0]<=-1){An(q[U+4>>2])}T=U+16|0;return a}function qa(a,R,S){var V=0;V=T-16|0;T=V;jh(V,a,R,S);q[a+24>>2]=q[V>>2];Tm(a+28|0,V|4);a=a+24|0;if(o[V+15|0]<=-1){An(q[V+4>>2])}T=V+16|0;return a}function ra(a,R){var S=0,W=0,X=0,Y=0;S=T-32|0;T=S;q[S+24>>2]=0;q[S+16>>2]=0;q[S+20>>2]=0;W=dm(R);if(W>>>0<4294967280){a:{b:{if(W>>>0>=11){Y=W+16&-16;X=Mm(Y);q[S+24>>2]=Y|-2147483648;q[S+16>>2]=X;q[S+20>>2]=W;break b}o[S+27|0]=W;X=S+16|0;if(!W){break a}}Cn(X,R,W)}o[W+X|0]=0;q[S+8>>2]=67108864;q[S>>2]=0;q[S+4>>2]=0;o[S+4|0]=0;q[S>>2]=1701667182;W=q[a+4>>2];R=-1;c:{if(!W){break c}W=Pk(W,S,S+16|0);R=-1;if(!W){break c}R=el(a,q[W+24>>2])}if(o[S+11|0]<=-1){An(q[S>>2])}if(o[S+27|0]<=-1){An(q[S+16>>2])}T=S+32|0;return R}Pm();F()}function sa(a,R,Z){var _=0,$=0,aa=0,ba=0;_=T-32|0;T=_;q[_+24>>2]=0;q[_+16>>2]=0;q[_+20>>2]=0;a:{ba=dm(R);if(ba>>>0<4294967280){b:{c:{if(ba>>>0>=11){$=ba+16&-16;aa=Mm($);q[_+24>>2]=$|-2147483648;q[_+16>>2]=aa;q[_+20>>2]=ba;break c}o[_+27|0]=ba;aa=_+16|0;if(!ba){break b}}Cn(aa,R,ba)}o[aa+ba|0]=0;q[_+8>>2]=0;q[_>>2]=0;q[_+4>>2]=0;$=dm(Z);if($>>>0>=4294967280){break a}d:{e:{if($>>>0>=11){R=$+16&-16;aa=Mm(R);q[_+8>>2]=R|-2147483648;q[_>>2]=aa;q[_+4>>2]=$;break e}o[_+11|0]=$;aa=_;if(!$){break d}}Cn(aa,Z,$)}o[$+aa|0]=0;Z=q[a+4>>2];R=-1;f:{if(!Z){break f}Z=Pk(Z,_+16|0,_);R=-1;if(!Z){break f}R=el(a,q[Z+24>>2])}a=R;if(o[_+11|0]<=-1){An(q[_>>2])}if(o[_+27|0]<=-1){An(q[_+16>>2])}T=_+32|0;return a}Pm();F()}Pm();F()}function ta(a,o,R){var Z=0,ca=0,da=0;Z=T-16|0;T=Z;ca=q[a+96>>2];q[Z+8>>2]=0;q[Z>>2]=0;q[Z+4>>2]=0;a=Mm(12);q[Z>>2]=a;q[Z+4>>2]=a;da=a+12|0;q[Z+8>>2]=da;ca=Cn(a,ca+w(o,12)|0,12)+12|0;q[Z+4>>2]=ca;o=q[R>>2];if(o){q[R+4>>2]=o;An(o);q[R+8>>2]=0;q[R>>2]=0;q[R+4>>2]=0}q[R>>2]=a;q[R+8>>2]=da;q[R+4>>2]=ca;T=Z+16|0;return 1}function ua(a,o){var R=0,ea=0;R=T-96|0;T=R;Dn(R+16|0,0,76);q[R+92>>2]=-1;q[R+8>>2]=0;q[R>>2]=0;q[R+4>>2]=0;a:{if(va(R+16|0,a,R)){a=q[o>>2];if(a){q[o+4>>2]=a;An(a);q[o+8>>2]=0;q[o>>2]=0;q[o+4>>2]=0}q[o>>2]=q[R>>2];q[o+4>>2]=q[R+4>>2];q[o+8>>2]=q[R+8>>2];q[R+8>>2]=0;q[R>>2]=0;q[R+4>>2]=0;ea=q[R+84>>2];break a}a=q[R>>2];if(!a){break a}q[R+4>>2]=a;An(a)}a=q[R+72>>2];if(a){An(a)}a=q[R+48>>2];if(a){q[R+52>>2]=a;An(a)}a=q[R+36>>2];if(a){q[R+40>>2]=a;An(a)}a=q[R+24>>2];if(a){q[R+28>>2]=a;An(a)}a=q[R+20>>2];q[R+20>>2]=0;if(a){wa(R+16|4,a)}T=R+96|0;return ea}function va(a,o,fa){var ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0;ja=T-16|0;T=ja;a:{if(!xa(a,o)){break a}ia=1;ha=q[o+96>>2];oa=o+100|0;ga=q[oa>>2];if((ha|0)==(ga|0)){break a}pa=a+12|0;qa=a+24|0;ra=a+36|0;na=fa+8|0;la=fa+4|0;while(1){if(!(q[q[a+56>>2]+(ma>>>3&536870908)>>2]>>>(ma&31)&1)){ia=w(ma,3);Jk(a,0,ia);sa=q[pa>>2];ka=q[a+8>>2];Jk(a,1,ia+1|0);ha=q[qa>>2];ga=q[a+20>>2];Jk(a,2,ia+2|0);ia=ha-ga>>2;ha=sa-ka|0;ga=ha>>2;ka=ia>>>0>ga>>>0;ka=q[ra>>2]-q[a+32>>2]>>2>>>0>(ka?ia:ga)>>>0?2:ka?1:ha?0:-1;b:{if(q[a+68>>2]<1){break b}ga=q[a+76>>2];q[ja+12>>2]=ga;ha=q[la>>2];c:{if(ha>>>0<t[na>>2]){q[ha>>2]=ga;q[la>>2]=ha+4;break c}ya(fa,ja+12|0)}ga=ja;ia=q[((ka<<2)+a|0)+44>>2];ha=-1;d:{if((ia|0)<0){break d}ha=(ia>>>0)/3|0;ha=q[(q[q[a>>2]+96>>2]+w(ha,12)|0)+(ia-w(ha,3)<<2)>>2]}q[ga+8>>2]=ha;ga=q[la>>2];e:{if(ga>>>0<t[na>>2]){q[ga>>2]=ha;q[la>>2]=ga+4;break e}ya(fa,ja+8|0)}ga=q[a+72>>2]+2|0;q[a+72>>2]=ga;if(!(ga&1)){break b}q[ja+4>>2]=ha;ga=q[la>>2];f:{if(ga>>>0<t[na>>2]){q[ga>>2]=ha;q[la>>2]=ga+4;break f}ya(fa,ja+4|0)}q[a+72>>2]=q[a+72>>2]+1}za(a,ka,fa);ha=q[o+96>>2];ga=q[oa>>2]}ia=1;ma=ma+1|0;if(ma>>>0<(ga-ha|0)/12>>>0){continue}break}}T=ja+16|0;return ia}function wa(a,o){if(o){a=q[o+76>>2];if(a){q[o+80>>2]=a;An(a)}a=q[o- -64>>2];if(a){q[o+68>>2]=a;An(a)}a=q[o+48>>2];if(a){q[o+52>>2]=a;An(a)}a=q[o+24>>2];if(a){q[o+28>>2]=a;An(a)}a=q[o+12>>2];if(a){q[o+16>>2]=a;An(a)}a=q[o>>2];if(a){q[o+4>>2]=a;An(a)}An(o)}}function xa(a,fa){var ta=0,ua=0,va=0;ta=T-16|0;T=ta;q[a+68>>2]=0;q[a+72>>2]=0;q[a>>2]=fa;Ik(ta+8|0,fa);ua=q[ta+8>>2];q[ta+8>>2]=0;va=q[a+4>>2];q[a+4>>2]=ua;a:{if(!va){q[ta+8>>2]=0;break a}ua=a+4|0;wa(ua,va);va=q[ta+8>>2];q[ta+8>>2]=0;if(va){wa(ta+8|0,va)}ua=q[ua>>2]}if(ua){ua=q[fa+100>>2];fa=q[fa+96>>2];o[ta+7|0]=0;bb(a+56|0,(ua-fa|0)/12|0,ta+7|0);a=1}else{a=0}T=ta+16|0;return a}function ya(a,o){var T=0,fa=0,wa=0,xa=0,ya=0,za=0;a:{wa=q[a>>2];ya=q[a+4>>2]-wa|0;T=ya>>2;fa=T+1|0;if(fa>>>0<1073741824){za=T<<2;T=q[a+8>>2]-wa|0;xa=T>>1;fa=T>>2>>>0<536870911?xa>>>0<fa>>>0?fa:xa:1073741823;T=0;b:{if(!fa){break b}if(fa>>>0>=1073741824){break a}T=Mm(fa<<2)}xa=za+T|0;q[xa>>2]=q[o>>2];o=T+(fa<<2)|0;fa=xa+4|0;if((ya|0)>=1){Cn(T,wa,ya)}q[a>>2]=T;q[a+8>>2]=o;q[a+4>>2]=fa;if(wa){An(wa)}return}bn();F()}ab(1040);F()}function za(a,o,Aa){var Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0;Da=T-16|0;T=Da;q[a+68>>2]=q[a+68>>2]+1;Ba=w(o,12)+a|0;Ba=q[Ba+12>>2]-q[Ba+8>>2]|0;if((Ba|0)>=1){Ia=Ba>>2;Ba=q[((o<<2)+a|0)+44>>2];Ga=Aa+8|0;Ea=Aa+4|0;while(1){o=Ba;Fa=(Ba>>>0)/3|0;Ba=(Ba|0)==-1?-1:Fa;Ca=q[a+56>>2]+(Ba>>>3&536870908)|0;q[Ca>>2]=q[Ca>>2]|1<<(Ba&31);q[a+72>>2]=q[a+72>>2]+1;a:{b:{if(!Ha){Ba=(o|0)<0?-1:q[(q[q[a>>2]+96>>2]+w(Fa,12)|0)+((o>>>0)%3<<2)>>2];q[Da+12>>2]=Ba;Ca=q[Ea>>2];c:{if(Ca>>>0<t[Ga>>2]){q[Ca>>2]=Ba;q[Ea>>2]=Ca+4;break c}ya(Aa,Da+12|0)}Ba=-1;d:{if((o|0)==-1){break d}Ca=o+1|0;Ca=(Ca>>>0)%3|0?Ca:o+ -2|0;if((Ca|0)<0){break d}Ba=(Ca>>>0)/3|0;Ba=q[(q[q[a>>2]+96>>2]+w(Ba,12)|0)+(Ca-w(Ba,3)<<2)>>2]}q[Da+12>>2]=Ba;Ca=q[Ea>>2];e:{if(Ca>>>0<t[Ga>>2]){q[Ca>>2]=Ba;q[Ea>>2]=Ca+4;break e}ya(Aa,Da+12|0)}Ca=a;Ba=-1;f:{if((o|0)==-1){break f}Fa=((o>>>0)%3|0?-1:2)+o|0;Ba=-1;if((Fa|0)<0){break f}Ba=(Fa>>>0)/3|0;Ba=q[(q[q[a>>2]+96>>2]+w(Ba,12)|0)+(Fa-w(Ba,3)<<2)>>2]}q[Ca+76>>2]=Ba;q[Da+12>>2]=Ba;Ca=q[Ea>>2];if(Ca>>>0<t[Ga>>2]){q[Ca>>2]=Ba;q[Ea>>2]=Ca+4;break b}ya(Aa,Da+12|0);break b}Ba=(o|0)<0?-1:q[(q[q[a>>2]+96>>2]+w(Fa,12)|0)+((o>>>0)%3<<2)>>2];q[a+76>>2]=Ba;q[Da+12>>2]=Ba;Ca=q[Ea>>2];g:{if(Ca>>>0<t[Ga>>2]){q[Ca>>2]=Ba;q[Ea>>2]=Ca+4;break g}ya(Aa,Da+12|0)}if(Ha&1){Ba=-1;if((o|0)==-1){break a}if(o-w(Fa,3)){o=o+ -1|0;break b}o=o+2|0;break b}Ba=-1;if((o|0)==-1){break a}Ba=o+1|0;o=(Ba>>>0)%3|0?Ba:o+ -2|0}Ba=-1;if((o|0)==-1){break a}Ba=q[q[q[a+4>>2]+12>>2]+(o<<2)>>2]}Ha=Ha+1|0;if((Ha|0)<(Ia|0)){continue}break}}T=Da+16|0}function Aa(a,o,Aa){var Ja=0,Ka=0,La=0;a:{if(t[a+80>>2]>65535){break a}Ka=q[a+96>>2];a=q[a+100>>2]-Ka|0;La=(a|0)/12|0;if((w(La,6)|0)!=(o|0)){break a}if(!a){return 1}a=0;while(1){o=w(a,6)+Aa|0;Ja=w(a,12)+Ka|0;p[o>>1]=q[Ja>>2];p[o+2>>1]=q[Ja+4>>2];p[o+4>>1]=q[Ja+8>>2];Ja=1;a=a+1|0;if(a>>>0<La>>>0){continue}break}}return Ja}function Ba(a,o,Aa){var Ma=0,Na=0,Oa=0;Na=q[a+96>>2];a=q[a+100>>2]-Na|0;Oa=(a|0)/12|0;if((a|0)==(o|0)){if(!o){return 1}a=0;while(1){Ma=w(a,12);o=Ma+Aa|0;Ma=Ma+Na|0;q[o>>2]=q[Ma>>2];q[o+4>>2]=q[Ma+4>>2];q[o+8>>2]=q[Ma+8>>2];Ma=1;a=a+1|0;if(a>>>0<Oa>>>0){continue}break}}return Ma}function Ca(a,Aa,Pa){var Qa=0,Ra=0,Sa=0,Ta=0;Qa=T-32|0;T=Qa;Ra=o[a+24|0];Ta=q[259];q[Qa+24>>2]=q[258];q[Qa+28>>2]=Ta;Ta=q[257];q[Qa+16>>2]=q[256];q[Qa+20>>2]=Ta;a:{if(Da(a,Aa,Ra,Qa+16|0)){a=0;q[Qa+8>>2]=0;q[Qa>>2]=0;q[Qa+4>>2]=0;Aa=0;if(Ra){if((Ra|0)<=-1){break a}Aa=Ra<<2;Sa=Mm(Aa);q[Qa>>2]=Sa;a=(Ra<<2)+Sa|0;q[Qa+8>>2]=a;Cn(Sa,Qa+16|0,Aa);q[Qa+4>>2]=a;Aa=a}Ra=q[Pa>>2];if(Ra){q[Pa+4>>2]=Ra;An(Ra);q[Pa+8>>2]=0;q[Pa>>2]=0;q[Pa+4>>2]=0;Aa=q[Qa+4>>2];Sa=q[Qa>>2];a=q[Qa+8>>2]}q[Pa>>2]=Sa;q[Pa+8>>2]=a;q[Pa+4>>2]=Aa;Sa=1}T=Qa+32|0;return Sa}bn();F()}function Da(a,Aa,Pa,Ua){var Va=0,Wa=0,Xa=x(0),Ya=0,Za=0;a:{b:{if(!Ua){break b}Va=q[a+28>>2]+ -1|0;if(Va>>>0>10){break b}c:{switch(Va-1|0){default:Za=1;Va=o[a+24|0];if(((Va|0)>(Pa|0)?Pa:Va)<<24>>24>=1){Va=q[q[a>>2]>>2];Aa=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],Aa,0)|0;Aa=Va+Aa|0;Ya=r[a+32|0];while(1){Xa=x(o[Aa|0]);u[(Wa<<2)+Ua>>2]=Ya?x(Xa/x(127)):Xa;Aa=Aa+1|0;Wa=Wa+1|0;Va=o[a+24|0];if((Wa|0)<((Va|0)>(Pa|0)?Pa:Va)<<24>>24){continue}break}}if((Va|0)>=(Pa|0)){break b}break a;case 0:Za=1;Va=o[a+24|0];if(((Va|0)>(Pa|0)?Pa:Va)<<24>>24>=1){Va=q[q[a>>2]>>2];Aa=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],Aa,0)|0;Aa=Va+Aa|0;Ya=r[a+32|0];while(1){Xa=x(r[Aa|0]);u[(Wa<<2)+Ua>>2]=Ya?x(Xa/x(255)):Xa;Aa=Aa+1|0;Wa=Wa+1|0;Va=o[a+24|0];if((Wa|0)<((Va|0)>(Pa|0)?Pa:Va)<<24>>24){continue}break}}if((Va|0)>=(Pa|0)){break b}break a;case 1:Za=1;Va=o[a+24|0];if(((Va|0)>(Pa|0)?Pa:Va)<<24>>24>=1){Va=q[q[a>>2]>>2];Aa=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],Aa,0)|0;Aa=Va+Aa|0;Ya=r[a+32|0];while(1){Xa=x(p[Aa>>1]);u[(Wa<<2)+Ua>>2]=Ya?x(Xa/x(32767)):Xa;Aa=Aa+2|0;Wa=Wa+1|0;Va=o[a+24|0];if((Wa|0)<((Va|0)>(Pa|0)?Pa:Va)<<24>>24){continue}break}}if((Va|0)>=(Pa|0)){break b}break a;case 2:Za=1;Va=o[a+24|0];if(((Va|0)>(Pa|0)?Pa:Va)<<24>>24>=1){Va=q[q[a>>2]>>2];Aa=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],Aa,0)|0;Aa=Va+Aa|0;Ya=r[a+32|0];while(1){Xa=x(s[Aa>>1]);u[(Wa<<2)+Ua>>2]=Ya?x(Xa/x(65535)):Xa;Aa=Aa+2|0;Wa=Wa+1|0;Va=o[a+24|0];if((Wa|0)<((Va|0)>(Pa|0)?Pa:Va)<<24>>24){continue}break}}if((Va|0)>=(Pa|0)){break b}break a;case 3:Za=1;Va=o[a+24|0];if(((Va|0)>(Pa|0)?Pa:Va)<<24>>24>=1){Va=q[q[a>>2]>>2];Aa=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],Aa,0)|0;Aa=Va+Aa|0;Ya=r[a+32|0];while(1){Xa=x(q[Aa>>2]);u[(Wa<<2)+Ua>>2]=Ya?x(Xa*x(4.656612873077393e-10)):Xa;Aa=Aa+4|0;Wa=Wa+1|0;Va=o[a+24|0];if((Wa|0)<((Va|0)>(Pa|0)?Pa:Va)<<24>>24){continue}break}}if((Va|0)>=(Pa|0)){break b}break a;case 4:Za=1;Va=o[a+24|0];if(((Va|0)>(Pa|0)?Pa:Va)<<24>>24>=1){Va=q[q[a>>2]>>2];Aa=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],Aa,0)|0;Aa=Va+Aa|0;Ya=r[a+32|0];while(1){Xa=x(t[Aa>>2]);u[(Wa<<2)+Ua>>2]=Ya?x(Xa*x(2.3283064365386963e-10)):Xa;Aa=Aa+4|0;Wa=Wa+1|0;Va=o[a+24|0];if((Wa|0)<((Va|0)>(Pa|0)?Pa:Va)<<24>>24){continue}break}}if((Va|0)>=(Pa|0)){break b}break a;case 5:Za=1;Va=o[a+24|0];if(((Va|0)>(Pa|0)?Pa:Va)<<24>>24>=1){Va=q[q[a>>2]>>2];Aa=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],Aa,0)|0;Aa=Va+Aa|0;Ya=r[a+32|0];while(1){Xa=x(+t[Aa>>2]+4294967296*+q[Aa+4>>2]);u[(Wa<<2)+Ua>>2]=Ya?x(Xa*x(1.0842021724855044e-19)):Xa;Aa=Aa+8|0;Wa=Wa+1|0;Va=o[a+24|0];if((Wa|0)<((Va|0)>(Pa|0)?Pa:Va)<<24>>24){continue}break}}if((Va|0)>=(Pa|0)){break b}break a;case 6:Za=1;Va=o[a+24|0];if(((Va|0)>(Pa|0)?Pa:Va)<<24>>24>=1){Va=q[q[a>>2]>>2];Aa=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],Aa,0)|0;Aa=Va+Aa|0;Ya=r[a+32|0];while(1){Xa=x(+t[Aa>>2]+4294967296*+t[Aa+4>>2]);u[(Wa<<2)+Ua>>2]=Ya?x(Xa*x(5.421010862427522e-20)):Xa;Aa=Aa+8|0;Wa=Wa+1|0;Va=o[a+24|0];if((Wa|0)<((Va|0)>(Pa|0)?Pa:Va)<<24>>24){continue}break}}if((Va|0)>=(Pa|0)){break b}break a;case 7:Za=1;Va=o[a+24|0];if(((Va|0)>(Pa|0)?Pa:Va)<<24>>24>=1){Va=q[q[a>>2]>>2];Aa=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],Aa,0)|0;Aa=Va+Aa|0;while(1){q[(Wa<<2)+Ua>>2]=q[Aa>>2];Aa=Aa+4|0;Wa=Wa+1|0;Va=o[a+24|0];if((Wa|0)<((Va|0)>(Pa|0)?Pa:Va)<<24>>24){continue}break}}if((Va|0)>=(Pa|0)){break b}break a;case 8:Za=1;Va=o[a+24|0];if(((Va|0)>(Pa|0)?Pa:Va)<<24>>24>=1){Va=q[q[a>>2]>>2];Aa=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],Aa,0)|0;Aa=Va+Aa|0;while(1){u[(Wa<<2)+Ua>>2]=v[Aa>>3];Aa=Aa+8|0;Wa=Wa+1|0;Va=o[a+24|0];if((Wa|0)<((Va|0)>(Pa|0)?Pa:Va)<<24>>24){continue}break}}if((Va|0)>=(Pa|0)){break b}break a;case 9:break c}}Za=1;Va=o[a+24|0];if(((Va|0)>(Pa|0)?Pa:Va)<<24>>24>=1){Va=q[q[a>>2]>>2];Aa=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],Aa,0)|0;Aa=Va+Aa|0;while(1){u[(Wa<<2)+Ua>>2]=r[Aa|0]?x(1):x(0);Aa=Aa+1|0;Wa=Wa+1|0;Va=o[a+24|0];if((Wa|0)<((Va|0)>(Pa|0)?Pa:Va)<<24>>24){continue}break}}if((Va|0)>=(Pa|0)){break b}Dn((Va<<2)+Ua|0,0,Pa-Va<<2)}return Za}Dn((Va<<2)+Ua|0,0,Pa-Va<<2);return 1}function Ea(a,Aa,Pa){var Ua=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0;Ua=T-16|0;T=Ua;bb=q[a+80>>2];cb=o[Aa+24|0];a=q[259];q[Ua+8>>2]=q[258];q[Ua+12>>2]=a;a=q[257];q[Ua>>2]=q[256];q[Ua+4>>2]=a;a=w(bb,cb);$a=q[Pa>>2];_a=q[Pa+4>>2]-$a>>2;a:{if(a>>>0>_a>>>0){Fa(Pa,a-_a|0);break a}if(a>>>0>=_a>>>0){break a}q[Pa+4>>2]=$a+(a<<2)}b:{if(!bb){a=1;break b}$a=0;db=Aa+68|0;eb=(cb|0)<1;while(1){a=ab;_a=Aa;if(!r[_a+84|0]){a=q[q[db>>2]+(ab<<2)>>2]}if(!Da(_a,a,o[Aa+24|0],Ua)){a=0;break b}if(!eb){_a=q[Pa>>2];a=0;while(1){q[_a+($a<<2)>>2]=q[(a<<2)+Ua>>2];$a=$a+1|0;a=a+1|0;if((cb|0)!=(a|0)){continue}break}}a=1;ab=ab+1|0;if((bb|0)!=(ab|0)){continue}break}}T=Ua+16|0;return a}function Fa(a,o){var Aa=0,Pa=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0;Pa=q[a+8>>2];fb=a+4|0;Aa=q[fb>>2];if(Pa-Aa>>2>>>0>=o>>>0){a=o<<2;kb=fb,lb=Dn(Aa,0,a)+a|0,q[kb>>2]=lb;return}a:{fb=q[a>>2];hb=Aa-fb|0;Aa=hb>>2;gb=Aa+o|0;if(gb>>>0<1073741824){jb=Aa<<2;Pa=Pa-fb|0;Aa=Pa>>1;Pa=Pa>>2>>>0<536870911?Aa>>>0<gb>>>0?gb:Aa:1073741823;Aa=0;b:{if(!Pa){break b}if(Pa>>>0>=1073741824){break a}ib=Mm(Pa<<2);Aa=ib}Dn(jb+Aa|0,0,o<<2);o=Aa+(gb<<2)|0;gb=Aa+(Pa<<2)|0;if((hb|0)>=1){Cn(ib,fb,hb)}q[a>>2]=Aa;q[a+8>>2]=gb;q[a+4>>2]=o;if(fb){An(fb)}return}bn();F()}ab(1040);F()}function Ga(a,mb,nb){var ob=0,pb=0,qb=0,rb=0,sb=0,tb=0,ub=0,vb=0;pb=T-16|0;T=pb;sb=q[a+80>>2];rb=o[mb+24|0];qb=w(sb,rb);a:{a=q[mb+28>>2];b:{if(!(!r[mb+84|0]|((a|0)!=2?(a|0)!=1:0))){rb=q[mb+48>>2];mb=q[q[mb>>2]>>2];q[pb+8>>2]=0;q[pb>>2]=0;q[pb+4>>2]=0;a=0;if(qb){if((qb|0)<=-1){break a}a=Mm(qb);q[pb>>2]=a;ob=a+qb|0;q[pb+8>>2]=ob;Cn(a,mb+rb|0,qb);q[pb+4>>2]=ob}mb=q[nb>>2];if(mb){q[nb+4>>2]=mb;An(mb);q[nb+8>>2]=0;q[nb>>2]=0;q[nb+4>>2]=0}q[nb>>2]=a;q[nb+8>>2]=ob;q[nb+4>>2]=ob;ob=1;break b}q[pb+8>>2]=0;q[pb>>2]=0;q[pb+4>>2]=0;if(rb){if((rb|0)<=-1){break a}ob=Mm(rb);q[pb>>2]=ob;q[pb+4>>2]=ob;q[pb+8>>2]=ob+rb;a=rb;while(1){o[ob|0]=0;ob=q[pb+4>>2]+1|0;q[pb+4>>2]=ob;a=a+ -1|0;if(a){continue}break}}ob=q[nb>>2];a=q[nb+4>>2]-ob|0;c:{if(qb>>>0>a>>>0){Ha(nb,qb-a|0);break c}if(qb>>>0>=a>>>0){break c}q[nb+4>>2]=ob+qb}d:{if(!sb){ob=1;break d}a=0;tb=mb+68|0;ub=(rb|0)<1;qb=0;while(1){ob=qb;vb=mb;if(!r[mb+84|0]){ob=q[q[tb>>2]+(qb<<2)>>2]}if(!Ia(vb,ob,o[mb+24|0],q[pb>>2])){ob=0;break d}ob=0;if(!ub){while(1){o[q[nb>>2]+a|0]=r[q[pb>>2]+ob|0];a=a+1|0;ob=ob+1|0;if((rb|0)!=(ob|0)){continue}break}}ob=1;qb=qb+1|0;if((sb|0)!=(qb|0)){continue}break}}a=q[pb>>2];if(!a){break b}q[pb+4>>2]=a;An(a)}T=pb+16|0;return ob}bn();F()}function Ha(a,mb){var nb=0,wb=0,xb=0,yb=0,zb=0,Ab=0;a:{wb=q[a+8>>2];xb=a+4|0;nb=q[xb>>2];b:{if(wb-nb>>>0>=mb>>>0){while(1){o[nb|0]=0;nb=q[xb>>2]+1|0;q[xb>>2]=nb;mb=mb+ -1|0;if(mb){continue}break b}}yb=q[a>>2];zb=nb-yb|0;nb=zb+mb|0;if((nb|0)<=-1){break a}xb=0;wb=wb-yb|0;Ab=wb<<1;wb=wb>>>0<1073741823?Ab>>>0<nb>>>0?nb:Ab:2147483647;if(wb){xb=Mm(wb)}nb=xb+zb|0;Dn(nb,0,mb);wb=wb+xb|0;while(1){nb=nb+1|0;mb=mb+ -1|0;if(mb){continue}break}if((zb|0)>=1){Cn(xb,yb,zb)}q[a>>2]=xb;q[a+8>>2]=wb;q[a+4>>2]=nb;if(!yb){break b}An(yb)}return}bn();F()}function Ia(a,mb,Bb,Cb){var Db=0,Eb=0,Fb=0,Gb=0,Hb=x(0),Ib=0;a:{b:{if(!Cb){break b}Db=q[a+28>>2]+ -1|0;if(Db>>>0>10){break b}c:{d:{e:{switch(Db-1|0){default:Fb=1;Db=o[a+24|0];if(((Db|0)>(Bb|0)?Bb:Db)<<24>>24>=1){Db=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Db+mb|0;while(1){o[Cb+Eb|0]=r[mb|0];mb=mb+1|0;Eb=Eb+1|0;Db=o[a+24|0];if((Eb|0)<((Db|0)>(Bb|0)?Bb:Db)<<24>>24){continue}break}}if((Db|0)>=(Bb|0)){break b}break a;case 0:Fb=1;Db=o[a+24|0];if(((Db|0)>(Bb|0)?Bb:Db)<<24>>24>=1){Db=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Db+mb|0;while(1){o[Cb+Eb|0]=r[mb|0];mb=mb+1|0;Eb=Eb+1|0;Db=o[a+24|0];if((Eb|0)<((Db|0)>(Bb|0)?Bb:Db)<<24>>24){continue}break}}if((Db|0)>=(Bb|0)){break b}break a;case 1:Fb=1;Db=o[a+24|0];if(((Db|0)>(Bb|0)?Bb:Db)<<24>>24>=1){Db=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Db+mb|0;while(1){o[Cb+Eb|0]=r[mb|0];mb=mb+2|0;Eb=Eb+1|0;Db=o[a+24|0];if((Eb|0)<((Db|0)>(Bb|0)?Bb:Db)<<24>>24){continue}break}}if((Db|0)>=(Bb|0)){break b}break a;case 2:Fb=1;Db=o[a+24|0];if(((Db|0)>(Bb|0)?Bb:Db)<<24>>24>=1){Db=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Db+mb|0;while(1){o[Cb+Eb|0]=r[mb|0];mb=mb+2|0;Eb=Eb+1|0;Db=o[a+24|0];if((Eb|0)<((Db|0)>(Bb|0)?Bb:Db)<<24>>24){continue}break}}if((Db|0)>=(Bb|0)){break b}break a;case 3:Fb=1;Db=o[a+24|0];if(((Db|0)>(Bb|0)?Bb:Db)<<24>>24>=1){Db=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Db+mb|0;while(1){o[Cb+Eb|0]=q[mb>>2];mb=mb+4|0;Eb=Eb+1|0;Db=o[a+24|0];if((Eb|0)<((Db|0)>(Bb|0)?Bb:Db)<<24>>24){continue}break}}if((Db|0)>=(Bb|0)){break b}break a;case 4:Fb=1;Db=o[a+24|0];if(((Db|0)>(Bb|0)?Bb:Db)<<24>>24>=1){Db=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Db+mb|0;while(1){o[Cb+Eb|0]=q[mb>>2];mb=mb+4|0;Eb=Eb+1|0;Db=o[a+24|0];if((Eb|0)<((Db|0)>(Bb|0)?Bb:Db)<<24>>24){continue}break}}if((Db|0)>=(Bb|0)){break b}break a;case 5:Fb=1;Db=o[a+24|0];if(((Db|0)>(Bb|0)?Bb:Db)<<24>>24>=1){Db=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Db+mb|0;while(1){o[Cb+Eb|0]=q[mb>>2];mb=mb+8|0;Eb=Eb+1|0;Db=o[a+24|0];if((Eb|0)<((Db|0)>(Bb|0)?Bb:Db)<<24>>24){continue}break}}if((Db|0)>=(Bb|0)){break b}break a;case 6:Fb=1;Db=o[a+24|0];if(((Db|0)>(Bb|0)?Bb:Db)<<24>>24>=1){Db=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Db+mb|0;while(1){o[Cb+Eb|0]=q[mb>>2];mb=mb+8|0;Eb=Eb+1|0;Db=o[a+24|0];if((Eb|0)<((Db|0)>(Bb|0)?Bb:Db)<<24>>24){continue}break}}if((Db|0)>=(Bb|0)){break b}break a;case 7:Fb=1;Db=o[a+24|0];if(((Db|0)>(Bb|0)?Bb:Db)<<24>>24<1){break c}Db=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Db+mb|0;while(1){Db=Cb+Eb|0;Hb=u[mb>>2];f:{if(x(y(Hb))<x(2147483648)){Gb=~~Hb;break f}Gb=-2147483648}o[Db|0]=Gb;mb=mb+4|0;Eb=Eb+1|0;Db=o[a+24|0];if((Eb|0)<((Db|0)>(Bb|0)?Bb:Db)<<24>>24){continue}break}break c;case 8:Fb=1;Db=o[a+24|0];if(((Db|0)>(Bb|0)?Bb:Db)<<24>>24<1){break d}Db=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Db+mb|0;while(1){Db=Cb+Eb|0;Ib=v[mb>>3];g:{if(y(Ib)<2147483648){Gb=~~Ib;break g}Gb=-2147483648}o[Db|0]=Gb;mb=mb+8|0;Eb=Eb+1|0;Db=o[a+24|0];if((Eb|0)<((Db|0)>(Bb|0)?Bb:Db)<<24>>24){continue}break}break d;case 9:break e}}Fb=1;Db=o[a+24|0];if(((Db|0)>(Bb|0)?Bb:Db)<<24>>24>=1){Db=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Db+mb|0;while(1){o[Cb+Eb|0]=r[mb|0];mb=mb+1|0;Eb=Eb+1|0;Db=o[a+24|0];if((Eb|0)<((Db|0)>(Bb|0)?Bb:Db)<<24>>24){continue}break}}if((Db|0)>=(Bb|0)){break b}Dn(Cb+Db|0,0,Bb-Db|0);break b}if((Db|0)>=(Bb|0)){break b}break a}if((Db|0)>=(Bb|0)){break b}break a}return Fb}Dn(Cb+Db|0,0,Bb-Db|0);return 1}function Ja(a,mb,Bb){var Cb=0,Jb=0,Kb=0,Lb=0,Mb=0,Nb=0,Ob=0,Pb=0;Jb=T-16|0;T=Jb;Mb=q[a+80>>2];Lb=o[mb+24|0];Kb=w(Mb,Lb);a:{a=q[mb+28>>2];b:{if(!(!r[mb+84|0]|((a|0)!=2?(a|0)!=1:0))){Lb=q[mb+48>>2];mb=q[q[mb>>2]>>2];q[Jb+8>>2]=0;q[Jb>>2]=0;q[Jb+4>>2]=0;a=0;if(Kb){if((Kb|0)<=-1){break a}a=Mm(Kb);q[Jb>>2]=a;Cb=a+Kb|0;q[Jb+8>>2]=Cb;Cn(a,mb+Lb|0,Kb);q[Jb+4>>2]=Cb}mb=q[Bb>>2];if(mb){q[Bb+4>>2]=mb;An(mb);q[Bb+8>>2]=0;q[Bb>>2]=0;q[Bb+4>>2]=0}q[Bb>>2]=a;q[Bb+8>>2]=Cb;q[Bb+4>>2]=Cb;Cb=1;break b}q[Jb+8>>2]=0;q[Jb>>2]=0;q[Jb+4>>2]=0;if(Lb){if((Lb|0)<=-1){break a}Cb=Mm(Lb);q[Jb>>2]=Cb;q[Jb+4>>2]=Cb;q[Jb+8>>2]=Cb+Lb;a=Lb;while(1){o[Cb|0]=0;Cb=q[Jb+4>>2]+1|0;q[Jb+4>>2]=Cb;a=a+ -1|0;if(a){continue}break}}Cb=q[Bb>>2];a=q[Bb+4>>2]-Cb|0;c:{if(Kb>>>0>a>>>0){Ha(Bb,Kb-a|0);break c}if(Kb>>>0>=a>>>0){break c}q[Bb+4>>2]=Cb+Kb}d:{if(!Mb){Cb=1;break d}a=0;Nb=mb+68|0;Ob=(Lb|0)<1;Kb=0;while(1){Cb=Kb;Pb=mb;if(!r[mb+84|0]){Cb=q[q[Nb>>2]+(Kb<<2)>>2]}if(!Ka(Pb,Cb,o[mb+24|0],q[Jb>>2])){Cb=0;break d}Cb=0;if(!Ob){while(1){o[q[Bb>>2]+a|0]=r[q[Jb>>2]+Cb|0];a=a+1|0;Cb=Cb+1|0;if((Lb|0)!=(Cb|0)){continue}break}}Cb=1;Kb=Kb+1|0;if((Mb|0)!=(Kb|0)){continue}break}}a=q[Jb>>2];if(!a){break b}q[Jb+4>>2]=a;An(a)}T=Jb+16|0;return Cb}bn();F()}function Ka(a,mb,Bb,Qb){var Rb=0,Sb=0,Tb=0,Ub=0,Vb=x(0),Wb=0;a:{b:{if(!Qb){break b}Rb=q[a+28>>2]+ -1|0;if(Rb>>>0>10){break b}c:{d:{e:{switch(Rb-1|0){default:Tb=1;Rb=o[a+24|0];if(((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24>=1){Rb=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Rb+mb|0;while(1){o[Qb+Sb|0]=r[mb|0];mb=mb+1|0;Sb=Sb+1|0;Rb=o[a+24|0];if((Sb|0)<((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24){continue}break}}if((Rb|0)>=(Bb|0)){break b}break a;case 0:Tb=1;Rb=o[a+24|0];if(((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24>=1){Rb=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Rb+mb|0;while(1){o[Qb+Sb|0]=r[mb|0];mb=mb+1|0;Sb=Sb+1|0;Rb=o[a+24|0];if((Sb|0)<((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24){continue}break}}if((Rb|0)>=(Bb|0)){break b}break a;case 1:Tb=1;Rb=o[a+24|0];if(((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24>=1){Rb=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Rb+mb|0;while(1){o[Qb+Sb|0]=r[mb|0];mb=mb+2|0;Sb=Sb+1|0;Rb=o[a+24|0];if((Sb|0)<((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24){continue}break}}if((Rb|0)>=(Bb|0)){break b}break a;case 2:Tb=1;Rb=o[a+24|0];if(((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24>=1){Rb=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Rb+mb|0;while(1){o[Qb+Sb|0]=r[mb|0];mb=mb+2|0;Sb=Sb+1|0;Rb=o[a+24|0];if((Sb|0)<((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24){continue}break}}if((Rb|0)>=(Bb|0)){break b}break a;case 3:Tb=1;Rb=o[a+24|0];if(((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24>=1){Rb=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Rb+mb|0;while(1){o[Qb+Sb|0]=q[mb>>2];mb=mb+4|0;Sb=Sb+1|0;Rb=o[a+24|0];if((Sb|0)<((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24){continue}break}}if((Rb|0)>=(Bb|0)){break b}break a;case 4:Tb=1;Rb=o[a+24|0];if(((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24>=1){Rb=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Rb+mb|0;while(1){o[Qb+Sb|0]=q[mb>>2];mb=mb+4|0;Sb=Sb+1|0;Rb=o[a+24|0];if((Sb|0)<((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24){continue}break}}if((Rb|0)>=(Bb|0)){break b}break a;case 5:Tb=1;Rb=o[a+24|0];if(((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24>=1){Rb=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Rb+mb|0;while(1){o[Qb+Sb|0]=q[mb>>2];mb=mb+8|0;Sb=Sb+1|0;Rb=o[a+24|0];if((Sb|0)<((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24){continue}break}}if((Rb|0)>=(Bb|0)){break b}break a;case 6:Tb=1;Rb=o[a+24|0];if(((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24>=1){Rb=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Rb+mb|0;while(1){o[Qb+Sb|0]=q[mb>>2];mb=mb+8|0;Sb=Sb+1|0;Rb=o[a+24|0];if((Sb|0)<((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24){continue}break}}if((Rb|0)>=(Bb|0)){break b}break a;case 7:Tb=1;Rb=o[a+24|0];if(((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24<1){break c}Rb=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Rb+mb|0;while(1){Rb=Qb+Sb|0;Vb=u[mb>>2];f:{if(Vb<x(4294967296)&Vb>=x(0)){Ub=~~Vb>>>0;break f}Ub=0}o[Rb|0]=Ub;mb=mb+4|0;Sb=Sb+1|0;Rb=o[a+24|0];if((Sb|0)<((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24){continue}break}break c;case 8:Tb=1;Rb=o[a+24|0];if(((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24<1){break d}Rb=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Rb+mb|0;while(1){Rb=Qb+Sb|0;Wb=v[mb>>3];g:{if(Wb<4294967296&Wb>=0){Ub=~~Wb>>>0;break g}Ub=0}o[Rb|0]=Ub;mb=mb+8|0;Sb=Sb+1|0;Rb=o[a+24|0];if((Sb|0)<((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24){continue}break}break d;case 9:break e}}Tb=1;Rb=o[a+24|0];if(((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24>=1){Rb=q[q[a>>2]>>2];mb=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],mb,0)|0;mb=Rb+mb|0;while(1){o[Qb+Sb|0]=r[mb|0];mb=mb+1|0;Sb=Sb+1|0;Rb=o[a+24|0];if((Sb|0)<((Rb|0)>(Bb|0)?Bb:Rb)<<24>>24){continue}break}}if((Rb|0)>=(Bb|0)){break b}Dn(Qb+Rb|0,0,Bb-Rb|0);break b}if((Rb|0)>=(Bb|0)){break b}break a}if((Rb|0)>=(Bb|0)){break b}break a}return Tb}Dn(Qb+Rb|0,0,Bb-Rb|0);return 1}function La(a,mb,Bb){var Qb=0,Xb=0,Yb=0,Zb=0,_b=0,$b=0,ac=0,bc=0,cc=0;Qb=T-16|0;T=Qb;ac=q[a+80>>2];_b=o[mb+24|0];a=w(ac,_b);a:{Xb=q[mb+28>>2];b:{if(!(!r[mb+84|0]|((Xb|0)!=4?(Xb|0)!=3:0))){$b=q[mb+48>>2];Xb=q[q[mb>>2]>>2];q[Qb+8>>2]=0;q[Qb>>2]=0;q[Qb+4>>2]=0;mb=0;a=a<<1;if(a){if((a|0)<=-1){break a}Yb=Mm(a);q[Qb>>2]=Yb;Zb=(a>>1<<1)+Yb|0;q[Qb+8>>2]=Zb;mb=Cn(Yb,Xb+$b|0,a)+a|0;q[Qb+4>>2]=mb}a=q[Bb>>2];if(a){q[Bb+4>>2]=a;An(a);q[Bb+8>>2]=0;q[Bb>>2]=0;q[Bb+4>>2]=0}q[Bb>>2]=Yb;q[Bb+8>>2]=Zb;q[Bb+4>>2]=mb;a=1;break b}q[Qb+8>>2]=0;q[Qb>>2]=0;q[Qb+4>>2]=0;if(_b){if((_b|0)<=-1){break a}Xb=_b<<1;Yb=Mm(Xb);q[Qb>>2]=Yb;Zb=Xb+Yb|0;q[Qb+8>>2]=Zb;Dn(Yb,0,Xb);q[Qb+4>>2]=Zb}Yb=q[Bb>>2];Xb=q[Bb+4>>2]-Yb>>1;c:{if(a>>>0>Xb>>>0){Ma(Bb,a-Xb|0);break c}if(a>>>0>=Xb>>>0){break c}q[Bb+4>>2]=Yb+(a<<1)}d:{if(!ac){a=1;break d}Yb=0;Zb=mb+68|0;bc=(_b|0)<1;while(1){a=$b;Xb=mb;if(!r[mb+84|0]){a=q[q[Zb>>2]+($b<<2)>>2]}if(!Na(Xb,a,o[mb+24|0],q[Qb>>2])){a=0;break d}if(!bc){Xb=q[Bb>>2];a=0;cc=q[Qb>>2];while(1){p[Xb+(Yb<<1)>>1]=s[cc+(a<<1)>>1];Yb=Yb+1|0;a=a+1|0;if((_b|0)!=(a|0)){continue}break}}a=1;$b=$b+1|0;if((ac|0)!=($b|0)){continue}break}}mb=q[Qb>>2];if(!mb){break b}q[Qb+4>>2]=mb;An(mb)}T=Qb+16|0;return a}bn();F()}function Ma(a,o){var mb=0,Bb=0,dc=0,ec=0,fc=0,gc=0,hc=0,ic=0,jc=0;Bb=q[a+8>>2];dc=a+4|0;mb=q[dc>>2];if(Bb-mb>>1>>>0>=o>>>0){a=o<<1;ic=dc,jc=Dn(mb,0,a)+a|0,q[ic>>2]=jc;return}a:{dc=q[a>>2];fc=mb-dc|0;mb=fc>>1;ec=mb+o|0;if((ec|0)>-1){hc=mb<<1;Bb=Bb-dc|0;Bb=Bb>>1>>>0<1073741823?Bb>>>0<ec>>>0?ec:Bb:2147483647;mb=0;b:{if(!Bb){break b}if((Bb|0)<=-1){break a}gc=Mm(Bb<<1);mb=gc}Dn(hc+mb|0,0,o<<1);o=mb+(ec<<1)|0;ec=mb+(Bb<<1)|0;if((fc|0)>=1){Cn(gc,dc,fc)}q[a>>2]=mb;q[a+8>>2]=ec;q[a+4>>2]=o;if(dc){An(dc)}return}bn();F()}ab(1040);F()}function Na(a,kc,lc,mc){var nc=0,oc=0,pc=0,qc=0,rc=x(0),sc=0;a:{b:{if(!mc){break b}nc=q[a+28>>2]+ -1|0;if(nc>>>0>10){break b}c:{d:{e:{switch(nc-1|0){default:pc=1;nc=o[a+24|0];if(((nc|0)>(lc|0)?lc:nc)<<24>>24>=1){nc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=nc+kc|0;while(1){p[(oc<<1)+mc>>1]=o[kc|0];kc=kc+1|0;oc=oc+1|0;nc=o[a+24|0];if((oc|0)<((nc|0)>(lc|0)?lc:nc)<<24>>24){continue}break}}if((nc|0)>=(lc|0)){break b}break a;case 0:pc=1;nc=o[a+24|0];if(((nc|0)>(lc|0)?lc:nc)<<24>>24>=1){nc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=nc+kc|0;while(1){p[(oc<<1)+mc>>1]=r[kc|0];kc=kc+1|0;oc=oc+1|0;nc=o[a+24|0];if((oc|0)<((nc|0)>(lc|0)?lc:nc)<<24>>24){continue}break}}if((nc|0)>=(lc|0)){break b}break a;case 1:pc=1;nc=o[a+24|0];if(((nc|0)>(lc|0)?lc:nc)<<24>>24>=1){nc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=nc+kc|0;while(1){p[(oc<<1)+mc>>1]=s[kc>>1];kc=kc+2|0;oc=oc+1|0;nc=o[a+24|0];if((oc|0)<((nc|0)>(lc|0)?lc:nc)<<24>>24){continue}break}}if((nc|0)>=(lc|0)){break b}break a;case 2:pc=1;nc=o[a+24|0];if(((nc|0)>(lc|0)?lc:nc)<<24>>24>=1){nc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=nc+kc|0;while(1){p[(oc<<1)+mc>>1]=s[kc>>1];kc=kc+2|0;oc=oc+1|0;nc=o[a+24|0];if((oc|0)<((nc|0)>(lc|0)?lc:nc)<<24>>24){continue}break}}if((nc|0)>=(lc|0)){break b}break a;case 3:pc=1;nc=o[a+24|0];if(((nc|0)>(lc|0)?lc:nc)<<24>>24>=1){nc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=nc+kc|0;while(1){p[(oc<<1)+mc>>1]=q[kc>>2];kc=kc+4|0;oc=oc+1|0;nc=o[a+24|0];if((oc|0)<((nc|0)>(lc|0)?lc:nc)<<24>>24){continue}break}}if((nc|0)>=(lc|0)){break b}break a;case 4:pc=1;nc=o[a+24|0];if(((nc|0)>(lc|0)?lc:nc)<<24>>24>=1){nc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=nc+kc|0;while(1){p[(oc<<1)+mc>>1]=q[kc>>2];kc=kc+4|0;oc=oc+1|0;nc=o[a+24|0];if((oc|0)<((nc|0)>(lc|0)?lc:nc)<<24>>24){continue}break}}if((nc|0)>=(lc|0)){break b}break a;case 5:pc=1;nc=o[a+24|0];if(((nc|0)>(lc|0)?lc:nc)<<24>>24>=1){nc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=nc+kc|0;while(1){p[(oc<<1)+mc>>1]=q[kc>>2];kc=kc+8|0;oc=oc+1|0;nc=o[a+24|0];if((oc|0)<((nc|0)>(lc|0)?lc:nc)<<24>>24){continue}break}}if((nc|0)>=(lc|0)){break b}break a;case 6:pc=1;nc=o[a+24|0];if(((nc|0)>(lc|0)?lc:nc)<<24>>24>=1){nc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=nc+kc|0;while(1){p[(oc<<1)+mc>>1]=q[kc>>2];kc=kc+8|0;oc=oc+1|0;nc=o[a+24|0];if((oc|0)<((nc|0)>(lc|0)?lc:nc)<<24>>24){continue}break}}if((nc|0)>=(lc|0)){break b}break a;case 7:pc=1;nc=o[a+24|0];if(((nc|0)>(lc|0)?lc:nc)<<24>>24<1){break c}nc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=nc+kc|0;while(1){nc=(oc<<1)+mc|0;rc=u[kc>>2];f:{if(x(y(rc))<x(2147483648)){qc=~~rc;break f}qc=-2147483648}p[nc>>1]=qc;kc=kc+4|0;oc=oc+1|0;nc=o[a+24|0];if((oc|0)<((nc|0)>(lc|0)?lc:nc)<<24>>24){continue}break}break c;case 8:pc=1;nc=o[a+24|0];if(((nc|0)>(lc|0)?lc:nc)<<24>>24<1){break d}nc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=nc+kc|0;while(1){nc=(oc<<1)+mc|0;sc=v[kc>>3];g:{if(y(sc)<2147483648){qc=~~sc;break g}qc=-2147483648}p[nc>>1]=qc;kc=kc+8|0;oc=oc+1|0;nc=o[a+24|0];if((oc|0)<((nc|0)>(lc|0)?lc:nc)<<24>>24){continue}break}break d;case 9:break e}}pc=1;nc=o[a+24|0];if(((nc|0)>(lc|0)?lc:nc)<<24>>24>=1){nc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=nc+kc|0;while(1){p[(oc<<1)+mc>>1]=r[kc|0];kc=kc+1|0;oc=oc+1|0;nc=o[a+24|0];if((oc|0)<((nc|0)>(lc|0)?lc:nc)<<24>>24){continue}break}}if((nc|0)>=(lc|0)){break b}Dn((nc<<1)+mc|0,0,lc-nc<<1);break b}if((nc|0)>=(lc|0)){break b}break a}if((nc|0)>=(lc|0)){break b}break a}return pc}Dn((nc<<1)+mc|0,0,lc-nc<<1);return 1}function Oa(a,kc,lc){var mc=0,tc=0,uc=0,vc=0,wc=0,xc=0,yc=0,zc=0,Ac=0;mc=T-16|0;T=mc;yc=q[a+80>>2];wc=o[kc+24|0];a=w(yc,wc);a:{tc=q[kc+28>>2];b:{if(!(!r[kc+84|0]|((tc|0)!=4?(tc|0)!=3:0))){xc=q[kc+48>>2];tc=q[q[kc>>2]>>2];q[mc+8>>2]=0;q[mc>>2]=0;q[mc+4>>2]=0;kc=0;a=a<<1;if(a){if((a|0)<=-1){break a}uc=Mm(a);q[mc>>2]=uc;vc=(a>>1<<1)+uc|0;q[mc+8>>2]=vc;kc=Cn(uc,tc+xc|0,a)+a|0;q[mc+4>>2]=kc}a=q[lc>>2];if(a){q[lc+4>>2]=a;An(a);q[lc+8>>2]=0;q[lc>>2]=0;q[lc+4>>2]=0}q[lc>>2]=uc;q[lc+8>>2]=vc;q[lc+4>>2]=kc;a=1;break b}q[mc+8>>2]=0;q[mc>>2]=0;q[mc+4>>2]=0;if(wc){if((wc|0)<=-1){break a}tc=wc<<1;uc=Mm(tc);q[mc>>2]=uc;vc=tc+uc|0;q[mc+8>>2]=vc;Dn(uc,0,tc);q[mc+4>>2]=vc}uc=q[lc>>2];tc=q[lc+4>>2]-uc>>1;c:{if(a>>>0>tc>>>0){Ma(lc,a-tc|0);break c}if(a>>>0>=tc>>>0){break c}q[lc+4>>2]=uc+(a<<1)}d:{if(!yc){a=1;break d}uc=0;vc=kc+68|0;zc=(wc|0)<1;while(1){a=xc;tc=kc;if(!r[kc+84|0]){a=q[q[vc>>2]+(xc<<2)>>2]}if(!Pa(tc,a,o[kc+24|0],q[mc>>2])){a=0;break d}if(!zc){tc=q[lc>>2];a=0;Ac=q[mc>>2];while(1){p[tc+(uc<<1)>>1]=s[Ac+(a<<1)>>1];uc=uc+1|0;a=a+1|0;if((wc|0)!=(a|0)){continue}break}}a=1;xc=xc+1|0;if((yc|0)!=(xc|0)){continue}break}}kc=q[mc>>2];if(!kc){break b}q[mc+4>>2]=kc;An(kc)}T=mc+16|0;return a}bn();F()}function Pa(a,kc,lc,Bc){var Cc=0,Dc=0,Ec=0,Fc=0,Gc=x(0),Hc=0;a:{b:{if(!Bc){break b}Cc=q[a+28>>2]+ -1|0;if(Cc>>>0>10){break b}c:{d:{e:{switch(Cc-1|0){default:Ec=1;Cc=o[a+24|0];if(((Cc|0)>(lc|0)?lc:Cc)<<24>>24>=1){Cc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Cc+kc|0;while(1){p[(Dc<<1)+Bc>>1]=o[kc|0];kc=kc+1|0;Dc=Dc+1|0;Cc=o[a+24|0];if((Dc|0)<((Cc|0)>(lc|0)?lc:Cc)<<24>>24){continue}break}}if((Cc|0)>=(lc|0)){break b}break a;case 0:Ec=1;Cc=o[a+24|0];if(((Cc|0)>(lc|0)?lc:Cc)<<24>>24>=1){Cc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Cc+kc|0;while(1){p[(Dc<<1)+Bc>>1]=r[kc|0];kc=kc+1|0;Dc=Dc+1|0;Cc=o[a+24|0];if((Dc|0)<((Cc|0)>(lc|0)?lc:Cc)<<24>>24){continue}break}}if((Cc|0)>=(lc|0)){break b}break a;case 1:Ec=1;Cc=o[a+24|0];if(((Cc|0)>(lc|0)?lc:Cc)<<24>>24>=1){Cc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Cc+kc|0;while(1){p[(Dc<<1)+Bc>>1]=s[kc>>1];kc=kc+2|0;Dc=Dc+1|0;Cc=o[a+24|0];if((Dc|0)<((Cc|0)>(lc|0)?lc:Cc)<<24>>24){continue}break}}if((Cc|0)>=(lc|0)){break b}break a;case 2:Ec=1;Cc=o[a+24|0];if(((Cc|0)>(lc|0)?lc:Cc)<<24>>24>=1){Cc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Cc+kc|0;while(1){p[(Dc<<1)+Bc>>1]=s[kc>>1];kc=kc+2|0;Dc=Dc+1|0;Cc=o[a+24|0];if((Dc|0)<((Cc|0)>(lc|0)?lc:Cc)<<24>>24){continue}break}}if((Cc|0)>=(lc|0)){break b}break a;case 3:Ec=1;Cc=o[a+24|0];if(((Cc|0)>(lc|0)?lc:Cc)<<24>>24>=1){Cc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Cc+kc|0;while(1){p[(Dc<<1)+Bc>>1]=q[kc>>2];kc=kc+4|0;Dc=Dc+1|0;Cc=o[a+24|0];if((Dc|0)<((Cc|0)>(lc|0)?lc:Cc)<<24>>24){continue}break}}if((Cc|0)>=(lc|0)){break b}break a;case 4:Ec=1;Cc=o[a+24|0];if(((Cc|0)>(lc|0)?lc:Cc)<<24>>24>=1){Cc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Cc+kc|0;while(1){p[(Dc<<1)+Bc>>1]=q[kc>>2];kc=kc+4|0;Dc=Dc+1|0;Cc=o[a+24|0];if((Dc|0)<((Cc|0)>(lc|0)?lc:Cc)<<24>>24){continue}break}}if((Cc|0)>=(lc|0)){break b}break a;case 5:Ec=1;Cc=o[a+24|0];if(((Cc|0)>(lc|0)?lc:Cc)<<24>>24>=1){Cc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Cc+kc|0;while(1){p[(Dc<<1)+Bc>>1]=q[kc>>2];kc=kc+8|0;Dc=Dc+1|0;Cc=o[a+24|0];if((Dc|0)<((Cc|0)>(lc|0)?lc:Cc)<<24>>24){continue}break}}if((Cc|0)>=(lc|0)){break b}break a;case 6:Ec=1;Cc=o[a+24|0];if(((Cc|0)>(lc|0)?lc:Cc)<<24>>24>=1){Cc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Cc+kc|0;while(1){p[(Dc<<1)+Bc>>1]=q[kc>>2];kc=kc+8|0;Dc=Dc+1|0;Cc=o[a+24|0];if((Dc|0)<((Cc|0)>(lc|0)?lc:Cc)<<24>>24){continue}break}}if((Cc|0)>=(lc|0)){break b}break a;case 7:Ec=1;Cc=o[a+24|0];if(((Cc|0)>(lc|0)?lc:Cc)<<24>>24<1){break c}Cc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Cc+kc|0;while(1){Cc=(Dc<<1)+Bc|0;Gc=u[kc>>2];f:{if(Gc<x(4294967296)&Gc>=x(0)){Fc=~~Gc>>>0;break f}Fc=0}p[Cc>>1]=Fc;kc=kc+4|0;Dc=Dc+1|0;Cc=o[a+24|0];if((Dc|0)<((Cc|0)>(lc|0)?lc:Cc)<<24>>24){continue}break}break c;case 8:Ec=1;Cc=o[a+24|0];if(((Cc|0)>(lc|0)?lc:Cc)<<24>>24<1){break d}Cc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Cc+kc|0;while(1){Cc=(Dc<<1)+Bc|0;Hc=v[kc>>3];g:{if(Hc<4294967296&Hc>=0){Fc=~~Hc>>>0;break g}Fc=0}p[Cc>>1]=Fc;kc=kc+8|0;Dc=Dc+1|0;Cc=o[a+24|0];if((Dc|0)<((Cc|0)>(lc|0)?lc:Cc)<<24>>24){continue}break}break d;case 9:break e}}Ec=1;Cc=o[a+24|0];if(((Cc|0)>(lc|0)?lc:Cc)<<24>>24>=1){Cc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Cc+kc|0;while(1){p[(Dc<<1)+Bc>>1]=r[kc|0];kc=kc+1|0;Dc=Dc+1|0;Cc=o[a+24|0];if((Dc|0)<((Cc|0)>(lc|0)?lc:Cc)<<24>>24){continue}break}}if((Cc|0)>=(lc|0)){break b}Dn((Cc<<1)+Bc|0,0,lc-Cc<<1);break b}if((Cc|0)>=(lc|0)){break b}break a}if((Cc|0)>=(lc|0)){break b}break a}return Ec}Dn((Cc<<1)+Bc|0,0,lc-Cc<<1);return 1}function Qa(a,kc,lc){var Bc=0,Ic=0,Jc=0,Kc=0,Lc=0,Mc=0,Nc=0,Oc=0,Pc=0;Bc=T-16|0;T=Bc;Nc=q[a+80>>2];Kc=o[kc+24|0];Jc=w(Nc,Kc);a:{a=q[kc+28>>2];b:{if(!(!r[kc+84|0]|((a|0)!=6?(a|0)!=5:0))){Mc=q[kc+48>>2];Kc=q[q[kc>>2]>>2];q[Bc+8>>2]=0;q[Bc>>2]=0;q[Bc+4>>2]=0;a=0;kc=Jc<<2;c:{if(!kc){break c}a=kc>>2;if(a>>>0>=1073741824){break a}Ic=Mm(kc);q[Bc>>2]=Ic;q[Bc+4>>2]=Ic;Lc=(a<<2)+Ic|0;q[Bc+8>>2]=Lc;if((kc|0)<1){a=Ic;break c}a=Cn(Ic,Kc+Mc|0,kc)+kc|0;q[Bc+4>>2]=a}kc=q[lc>>2];if(kc){q[lc+4>>2]=kc;An(kc);q[lc+8>>2]=0;q[lc>>2]=0;q[lc+4>>2]=0}q[lc>>2]=Ic;q[lc+8>>2]=Lc;q[lc+4>>2]=a;a=1;break b}q[Bc+8>>2]=0;q[Bc>>2]=0;q[Bc+4>>2]=0;if(Kc){if((Kc|0)<=-1){break a}a=Kc<<2;Ic=Mm(a);q[Bc>>2]=Ic;Lc=a+Ic|0;q[Bc+8>>2]=Lc;Dn(Ic,0,a);q[Bc+4>>2]=Lc}Ic=q[lc>>2];a=q[lc+4>>2]-Ic>>2;d:{if(Jc>>>0>a>>>0){Fa(lc,Jc-a|0);break d}if(Jc>>>0>=a>>>0){break d}q[lc+4>>2]=Ic+(Jc<<2)}e:{if(!Nc){a=1;break e}Ic=0;Lc=kc+68|0;Oc=(Kc|0)<1;while(1){a=Mc;Jc=kc;if(!r[kc+84|0]){a=q[q[Lc>>2]+(Mc<<2)>>2]}if(!Ra(Jc,a,o[kc+24|0],q[Bc>>2])){a=0;break e}if(!Oc){Jc=q[lc>>2];a=0;Pc=q[Bc>>2];while(1){q[Jc+(Ic<<2)>>2]=q[Pc+(a<<2)>>2];Ic=Ic+1|0;a=a+1|0;if((Kc|0)!=(a|0)){continue}break}}a=1;Mc=Mc+1|0;if((Nc|0)!=(Mc|0)){continue}break}}kc=q[Bc>>2];if(!kc){break b}q[Bc+4>>2]=kc;An(kc)}T=Bc+16|0;return a}bn();F()}function Ra(a,kc,lc,Qc){var Rc=0,Sc=0,Tc=0,Uc=0,Vc=x(0),Wc=0;a:{b:{if(!Qc){break b}Rc=q[a+28>>2]+ -1|0;if(Rc>>>0>10){break b}c:{d:{e:{switch(Rc-1|0){default:Tc=1;Rc=o[a+24|0];if(((Rc|0)>(lc|0)?lc:Rc)<<24>>24>=1){Rc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Rc+kc|0;while(1){q[(Sc<<2)+Qc>>2]=o[kc|0];kc=kc+1|0;Sc=Sc+1|0;Rc=o[a+24|0];if((Sc|0)<((Rc|0)>(lc|0)?lc:Rc)<<24>>24){continue}break}}if((Rc|0)>=(lc|0)){break b}break a;case 0:Tc=1;Rc=o[a+24|0];if(((Rc|0)>(lc|0)?lc:Rc)<<24>>24>=1){Rc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Rc+kc|0;while(1){q[(Sc<<2)+Qc>>2]=r[kc|0];kc=kc+1|0;Sc=Sc+1|0;Rc=o[a+24|0];if((Sc|0)<((Rc|0)>(lc|0)?lc:Rc)<<24>>24){continue}break}}if((Rc|0)>=(lc|0)){break b}break a;case 1:Tc=1;Rc=o[a+24|0];if(((Rc|0)>(lc|0)?lc:Rc)<<24>>24>=1){Rc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Rc+kc|0;while(1){q[(Sc<<2)+Qc>>2]=p[kc>>1];kc=kc+2|0;Sc=Sc+1|0;Rc=o[a+24|0];if((Sc|0)<((Rc|0)>(lc|0)?lc:Rc)<<24>>24){continue}break}}if((Rc|0)>=(lc|0)){break b}break a;case 2:Tc=1;Rc=o[a+24|0];if(((Rc|0)>(lc|0)?lc:Rc)<<24>>24>=1){Rc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Rc+kc|0;while(1){q[(Sc<<2)+Qc>>2]=s[kc>>1];kc=kc+2|0;Sc=Sc+1|0;Rc=o[a+24|0];if((Sc|0)<((Rc|0)>(lc|0)?lc:Rc)<<24>>24){continue}break}}if((Rc|0)>=(lc|0)){break b}break a;case 3:Tc=1;Rc=o[a+24|0];if(((Rc|0)>(lc|0)?lc:Rc)<<24>>24>=1){Rc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Rc+kc|0;while(1){q[(Sc<<2)+Qc>>2]=q[kc>>2];kc=kc+4|0;Sc=Sc+1|0;Rc=o[a+24|0];if((Sc|0)<((Rc|0)>(lc|0)?lc:Rc)<<24>>24){continue}break}}if((Rc|0)>=(lc|0)){break b}break a;case 4:Tc=1;Rc=o[a+24|0];if(((Rc|0)>(lc|0)?lc:Rc)<<24>>24>=1){Rc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Rc+kc|0;while(1){q[(Sc<<2)+Qc>>2]=q[kc>>2];kc=kc+4|0;Sc=Sc+1|0;Rc=o[a+24|0];if((Sc|0)<((Rc|0)>(lc|0)?lc:Rc)<<24>>24){continue}break}}if((Rc|0)>=(lc|0)){break b}break a;case 5:Tc=1;Rc=o[a+24|0];if(((Rc|0)>(lc|0)?lc:Rc)<<24>>24>=1){Rc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Rc+kc|0;while(1){q[(Sc<<2)+Qc>>2]=q[kc>>2];kc=kc+8|0;Sc=Sc+1|0;Rc=o[a+24|0];if((Sc|0)<((Rc|0)>(lc|0)?lc:Rc)<<24>>24){continue}break}}if((Rc|0)>=(lc|0)){break b}break a;case 6:Tc=1;Rc=o[a+24|0];if(((Rc|0)>(lc|0)?lc:Rc)<<24>>24>=1){Rc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Rc+kc|0;while(1){q[(Sc<<2)+Qc>>2]=q[kc>>2];kc=kc+8|0;Sc=Sc+1|0;Rc=o[a+24|0];if((Sc|0)<((Rc|0)>(lc|0)?lc:Rc)<<24>>24){continue}break}}if((Rc|0)>=(lc|0)){break b}break a;case 7:Tc=1;Rc=o[a+24|0];if(((Rc|0)>(lc|0)?lc:Rc)<<24>>24<1){break c}Rc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Rc+kc|0;while(1){Rc=(Sc<<2)+Qc|0;Vc=u[kc>>2];f:{if(x(y(Vc))<x(2147483648)){Uc=~~Vc;break f}Uc=-2147483648}q[Rc>>2]=Uc;kc=kc+4|0;Sc=Sc+1|0;Rc=o[a+24|0];if((Sc|0)<((Rc|0)>(lc|0)?lc:Rc)<<24>>24){continue}break}break c;case 8:Tc=1;Rc=o[a+24|0];if(((Rc|0)>(lc|0)?lc:Rc)<<24>>24<1){break d}Rc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Rc+kc|0;while(1){Rc=(Sc<<2)+Qc|0;Wc=v[kc>>3];g:{if(y(Wc)<2147483648){Uc=~~Wc;break g}Uc=-2147483648}q[Rc>>2]=Uc;kc=kc+8|0;Sc=Sc+1|0;Rc=o[a+24|0];if((Sc|0)<((Rc|0)>(lc|0)?lc:Rc)<<24>>24){continue}break}break d;case 9:break e}}Tc=1;Rc=o[a+24|0];if(((Rc|0)>(lc|0)?lc:Rc)<<24>>24>=1){Rc=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=Rc+kc|0;while(1){q[(Sc<<2)+Qc>>2]=r[kc|0];kc=kc+1|0;Sc=Sc+1|0;Rc=o[a+24|0];if((Sc|0)<((Rc|0)>(lc|0)?lc:Rc)<<24>>24){continue}break}}if((Rc|0)>=(lc|0)){break b}Dn((Rc<<2)+Qc|0,0,lc-Rc<<2);break b}if((Rc|0)>=(lc|0)){break b}break a}if((Rc|0)>=(lc|0)){break b}break a}return Tc}Dn((Rc<<2)+Qc|0,0,lc-Rc<<2);return 1}function Sa(a,kc,lc){var Qc=0,Xc=0,Yc=0,Zc=0,_c=0,$c=0,ad=0,bd=0,cd=0;Qc=T-16|0;T=Qc;ad=q[a+80>>2];Zc=o[kc+24|0];Yc=w(ad,Zc);a:{a=q[kc+28>>2];b:{if(!(!r[kc+84|0]|((a|0)!=6?(a|0)!=5:0))){$c=q[kc+48>>2];Zc=q[q[kc>>2]>>2];q[Qc+8>>2]=0;q[Qc>>2]=0;q[Qc+4>>2]=0;a=0;kc=Yc<<2;c:{if(!kc){break c}a=kc>>2;if(a>>>0>=1073741824){break a}Xc=Mm(kc);q[Qc>>2]=Xc;q[Qc+4>>2]=Xc;_c=(a<<2)+Xc|0;q[Qc+8>>2]=_c;if((kc|0)<1){a=Xc;break c}a=Cn(Xc,Zc+$c|0,kc)+kc|0;q[Qc+4>>2]=a}kc=q[lc>>2];if(kc){q[lc+4>>2]=kc;An(kc);q[lc+8>>2]=0;q[lc>>2]=0;q[lc+4>>2]=0}q[lc>>2]=Xc;q[lc+8>>2]=_c;q[lc+4>>2]=a;a=1;break b}q[Qc+8>>2]=0;q[Qc>>2]=0;q[Qc+4>>2]=0;if(Zc){if((Zc|0)<=-1){break a}a=Zc<<2;Xc=Mm(a);q[Qc>>2]=Xc;_c=a+Xc|0;q[Qc+8>>2]=_c;Dn(Xc,0,a);q[Qc+4>>2]=_c}Xc=q[lc>>2];a=q[lc+4>>2]-Xc>>2;d:{if(Yc>>>0>a>>>0){Fa(lc,Yc-a|0);break d}if(Yc>>>0>=a>>>0){break d}q[lc+4>>2]=Xc+(Yc<<2)}e:{if(!ad){a=1;break e}Xc=0;_c=kc+68|0;bd=(Zc|0)<1;while(1){a=$c;Yc=kc;if(!r[kc+84|0]){a=q[q[_c>>2]+($c<<2)>>2]}if(!Ta(Yc,a,o[kc+24|0],q[Qc>>2])){a=0;break e}if(!bd){Yc=q[lc>>2];a=0;cd=q[Qc>>2];while(1){q[Yc+(Xc<<2)>>2]=q[cd+(a<<2)>>2];Xc=Xc+1|0;a=a+1|0;if((Zc|0)!=(a|0)){continue}break}}a=1;$c=$c+1|0;if((ad|0)!=($c|0)){continue}break}}kc=q[Qc>>2];if(!kc){break b}q[Qc+4>>2]=kc;An(kc)}T=Qc+16|0;return a}bn();F()}function Ta(a,kc,lc,dd){var ed=0,fd=0,gd=0,hd=0,id=x(0),jd=0;a:{b:{if(!dd){break b}ed=q[a+28>>2]+ -1|0;if(ed>>>0>10){break b}c:{d:{e:{switch(ed-1|0){default:gd=1;ed=o[a+24|0];if(((ed|0)>(lc|0)?lc:ed)<<24>>24>=1){ed=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=ed+kc|0;while(1){q[(fd<<2)+dd>>2]=o[kc|0];kc=kc+1|0;fd=fd+1|0;ed=o[a+24|0];if((fd|0)<((ed|0)>(lc|0)?lc:ed)<<24>>24){continue}break}}if((ed|0)>=(lc|0)){break b}break a;case 0:gd=1;ed=o[a+24|0];if(((ed|0)>(lc|0)?lc:ed)<<24>>24>=1){ed=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=ed+kc|0;while(1){q[(fd<<2)+dd>>2]=r[kc|0];kc=kc+1|0;fd=fd+1|0;ed=o[a+24|0];if((fd|0)<((ed|0)>(lc|0)?lc:ed)<<24>>24){continue}break}}if((ed|0)>=(lc|0)){break b}break a;case 1:gd=1;ed=o[a+24|0];if(((ed|0)>(lc|0)?lc:ed)<<24>>24>=1){ed=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=ed+kc|0;while(1){q[(fd<<2)+dd>>2]=p[kc>>1];kc=kc+2|0;fd=fd+1|0;ed=o[a+24|0];if((fd|0)<((ed|0)>(lc|0)?lc:ed)<<24>>24){continue}break}}if((ed|0)>=(lc|0)){break b}break a;case 2:gd=1;ed=o[a+24|0];if(((ed|0)>(lc|0)?lc:ed)<<24>>24>=1){ed=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=ed+kc|0;while(1){q[(fd<<2)+dd>>2]=s[kc>>1];kc=kc+2|0;fd=fd+1|0;ed=o[a+24|0];if((fd|0)<((ed|0)>(lc|0)?lc:ed)<<24>>24){continue}break}}if((ed|0)>=(lc|0)){break b}break a;case 3:gd=1;ed=o[a+24|0];if(((ed|0)>(lc|0)?lc:ed)<<24>>24>=1){ed=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=ed+kc|0;while(1){q[(fd<<2)+dd>>2]=q[kc>>2];kc=kc+4|0;fd=fd+1|0;ed=o[a+24|0];if((fd|0)<((ed|0)>(lc|0)?lc:ed)<<24>>24){continue}break}}if((ed|0)>=(lc|0)){break b}break a;case 4:gd=1;ed=o[a+24|0];if(((ed|0)>(lc|0)?lc:ed)<<24>>24>=1){ed=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=ed+kc|0;while(1){q[(fd<<2)+dd>>2]=q[kc>>2];kc=kc+4|0;fd=fd+1|0;ed=o[a+24|0];if((fd|0)<((ed|0)>(lc|0)?lc:ed)<<24>>24){continue}break}}if((ed|0)>=(lc|0)){break b}break a;case 5:gd=1;ed=o[a+24|0];if(((ed|0)>(lc|0)?lc:ed)<<24>>24>=1){ed=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=ed+kc|0;while(1){q[(fd<<2)+dd>>2]=q[kc>>2];kc=kc+8|0;fd=fd+1|0;ed=o[a+24|0];if((fd|0)<((ed|0)>(lc|0)?lc:ed)<<24>>24){continue}break}}if((ed|0)>=(lc|0)){break b}break a;case 6:gd=1;ed=o[a+24|0];if(((ed|0)>(lc|0)?lc:ed)<<24>>24>=1){ed=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=ed+kc|0;while(1){q[(fd<<2)+dd>>2]=q[kc>>2];kc=kc+8|0;fd=fd+1|0;ed=o[a+24|0];if((fd|0)<((ed|0)>(lc|0)?lc:ed)<<24>>24){continue}break}}if((ed|0)>=(lc|0)){break b}break a;case 7:gd=1;ed=o[a+24|0];if(((ed|0)>(lc|0)?lc:ed)<<24>>24<1){break c}ed=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=ed+kc|0;while(1){ed=(fd<<2)+dd|0;id=u[kc>>2];f:{if(id<x(4294967296)&id>=x(0)){hd=~~id>>>0;break f}hd=0}q[ed>>2]=hd;kc=kc+4|0;fd=fd+1|0;ed=o[a+24|0];if((fd|0)<((ed|0)>(lc|0)?lc:ed)<<24>>24){continue}break}break c;case 8:gd=1;ed=o[a+24|0];if(((ed|0)>(lc|0)?lc:ed)<<24>>24<1){break d}ed=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=ed+kc|0;while(1){ed=(fd<<2)+dd|0;jd=v[kc>>3];g:{if(jd<4294967296&jd>=0){hd=~~jd>>>0;break g}hd=0}q[ed>>2]=hd;kc=kc+8|0;fd=fd+1|0;ed=o[a+24|0];if((fd|0)<((ed|0)>(lc|0)?lc:ed)<<24>>24){continue}break}break d;case 9:break e}}gd=1;ed=o[a+24|0];if(((ed|0)>(lc|0)?lc:ed)<<24>>24>=1){ed=q[q[a>>2]>>2];kc=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],kc,0)|0;kc=ed+kc|0;while(1){q[(fd<<2)+dd>>2]=r[kc|0];kc=kc+1|0;fd=fd+1|0;ed=o[a+24|0];if((fd|0)<((ed|0)>(lc|0)?lc:ed)<<24>>24){continue}break}}if((ed|0)>=(lc|0)){break b}Dn((ed<<2)+dd|0,0,lc-ed<<2);break b}if((ed|0)>=(lc|0)){break b}break a}if((ed|0)>=(lc|0)){break b}break a}return gd}Dn((ed<<2)+dd|0,0,lc-ed<<2);return 1}function Ua(a,kc,lc,dd,kd){var ld=0,md=0,nd=0,od=0,pd=0,qd=0,rd=0;md=T-16|0;T=md;lc=lc+ -1|0;a:{if(lc>>>0>8){break a}b:{switch(lc-1|0){default:ld=Va(a,kc,dd,kd);break a;case 1:ld=Wa(a,kc,dd,kd);break a;case 3:ld=Xa(a,kc,dd,kd);break a;case 0:ld=Ya(a,kc,dd,kd);break a;case 2:ld=Za(a,kc,dd,kd);break a;case 4:ld=_a(a,kc,dd,kd);break a;case 5:case 6:break a;case 7:break b}}nd=q[a+80>>2];od=o[kc+24|0];pd=od<<2;if((w(nd,pd)|0)!=(dd|0)){break a}a=0;lc=q[259];q[md+8>>2]=q[258];q[md+12>>2]=lc;lc=q[257];q[md>>2]=q[256];q[md+4>>2]=lc;if(!nd){ld=1;break a}qd=kc+68|0;rd=(od|0)<1;lc=0;while(1){dd=lc;ld=kc;if(!r[kc+84|0]){dd=q[q[qd>>2]+(lc<<2)>>2]}if(!Da(ld,dd,o[kc+24|0],md)){ld=0;break a}if(!rd){Cn((a<<2)+kd|0,md,pd);a=a+od|0}ld=1;lc=lc+1|0;if((nd|0)!=(lc|0)){continue}break}}T=md+16|0;return ld}function Va(a,kc,lc,dd){var kd=0,sd=0,td=0,ud=0,vd=0,wd=0,xd=0;sd=T-16|0;T=sd;a:{vd=q[a+80>>2];td=o[kc+24|0];b:{if((w(vd,td)|0)!=(lc|0)){break b}if(!(!r[kc+84|0]|q[kc+28>>2]!=1)){Cn(dd,q[q[kc>>2]>>2]+q[kc+48>>2]|0,lc);kd=1;break b}q[sd+8>>2]=0;q[sd>>2]=0;q[sd+4>>2]=0;if(td){if((td|0)<=-1){break a}kd=Mm(td);q[sd>>2]=kd;q[sd+4>>2]=kd;q[sd+8>>2]=kd+td;lc=td;while(1){o[kd|0]=0;kd=q[sd+4>>2]+1|0;q[sd+4>>2]=kd;lc=lc+ -1|0;if(lc){continue}break}}c:{if(!vd){kd=1;break c}lc=0;wd=kc+68|0;xd=(td|0)<1;while(1){a=ud;kd=kc;if(!r[kd+84|0]){a=q[q[wd>>2]+(ud<<2)>>2]}if(!Ia(kd,a,o[kc+24|0],q[sd>>2])){kd=0;break c}if(!xd){kd=0;a=q[sd>>2];while(1){o[lc+dd|0]=r[a+kd|0];lc=lc+1|0;kd=kd+1|0;if((td|0)!=(kd|0)){continue}break}}kd=1;ud=ud+1|0;if((vd|0)!=(ud|0)){continue}break}}a=q[sd>>2];if(!a){break b}q[sd+4>>2]=a;An(a)}T=sd+16|0;return kd}bn();F()}function Wa(a,kc,lc,dd){var yd=0,zd=0,Ad=0,Bd=0,Cd=0,Dd=0,Ed=0,Fd=0,Gd=0;yd=T-16|0;T=yd;a:{Cd=q[a+80>>2];Ad=o[kc+24|0];a=Ad<<1;b:{if((w(Cd,a)|0)!=(lc|0)){break b}if(!(!r[kc+84|0]|q[kc+28>>2]!=3)){Cn(dd,q[q[kc>>2]>>2]+q[kc+48>>2]|0,lc);zd=1;break b}lc=0;q[yd+8>>2]=0;q[yd>>2]=0;q[yd+4>>2]=0;if(Ad){if((Ad|0)<=-1){break a}lc=Mm(a);q[yd>>2]=lc;q[yd+8>>2]=(Ad<<1)+lc;Fd=yd,Gd=Dn(lc,0,a)+a|0,q[Fd+4>>2]=Gd}c:{if(!Cd){zd=1;break c}lc=0;Dd=kc+68|0;Ed=(Ad|0)<1;while(1){a=Bd;zd=kc;if(!r[kc+84|0]){a=q[q[Dd>>2]+(Bd<<2)>>2]}d:{if(!Na(zd,a,o[kc+24|0],q[yd>>2])){zd=0;break d}if(!Ed){zd=0;a=q[yd>>2];while(1){p[(lc<<1)+dd>>1]=s[a+(zd<<1)>>1];lc=lc+1|0;zd=zd+1|0;if((Ad|0)!=(zd|0)){continue}break}}zd=1;Bd=Bd+1|0;if((Cd|0)!=(Bd|0)){continue}}break}lc=q[yd>>2]}if(!lc){break b}q[yd+4>>2]=lc;An(lc)}T=yd+16|0;return zd}bn();F()}function Xa(a,kc,lc,dd){var Hd=0,Id=0,Jd=0,Kd=0,Ld=0,Md=0,Nd=0,Od=0,Pd=0;Hd=T-16|0;T=Hd;a:{Ld=q[a+80>>2];Jd=o[kc+24|0];a=Jd<<2;b:{if((w(Ld,a)|0)!=(lc|0)){break b}if(!(!r[kc+84|0]|q[kc+28>>2]!=5)){Cn(dd,q[q[kc>>2]>>2]+q[kc+48>>2]|0,lc);Id=1;break b}lc=0;q[Hd+8>>2]=0;q[Hd>>2]=0;q[Hd+4>>2]=0;if(Jd){if((Jd|0)<=-1){break a}lc=Mm(a);q[Hd>>2]=lc;q[Hd+8>>2]=(Jd<<2)+lc;Od=Hd,Pd=Dn(lc,0,a)+a|0,q[Od+4>>2]=Pd}c:{if(!Ld){Id=1;break c}lc=0;Md=kc+68|0;Nd=(Jd|0)<1;while(1){a=Kd;Id=kc;if(!r[kc+84|0]){a=q[q[Md>>2]+(Kd<<2)>>2]}d:{if(!Ra(Id,a,o[kc+24|0],q[Hd>>2])){Id=0;break d}if(!Nd){Id=0;a=q[Hd>>2];while(1){q[(lc<<2)+dd>>2]=q[a+(Id<<2)>>2];lc=lc+1|0;Id=Id+1|0;if((Jd|0)!=(Id|0)){continue}break}}Id=1;Kd=Kd+1|0;if((Ld|0)!=(Kd|0)){continue}}break}lc=q[Hd>>2]}if(!lc){break b}q[Hd+4>>2]=lc;An(lc)}T=Hd+16|0;return Id}bn();F()}function Ya(a,kc,lc,dd){var Qd=0,Rd=0,Sd=0,Td=0,Ud=0,Vd=0,Wd=0;Rd=T-16|0;T=Rd;a:{Ud=q[a+80>>2];Sd=o[kc+24|0];b:{if((w(Ud,Sd)|0)!=(lc|0)){break b}if(!(!r[kc+84|0]|q[kc+28>>2]!=2)){Cn(dd,q[q[kc>>2]>>2]+q[kc+48>>2]|0,lc);Qd=1;break b}q[Rd+8>>2]=0;q[Rd>>2]=0;q[Rd+4>>2]=0;if(Sd){if((Sd|0)<=-1){break a}Qd=Mm(Sd);q[Rd>>2]=Qd;q[Rd+4>>2]=Qd;q[Rd+8>>2]=Qd+Sd;lc=Sd;while(1){o[Qd|0]=0;Qd=q[Rd+4>>2]+1|0;q[Rd+4>>2]=Qd;lc=lc+ -1|0;if(lc){continue}break}}c:{if(!Ud){Qd=1;break c}lc=0;Vd=kc+68|0;Wd=(Sd|0)<1;while(1){a=Td;Qd=kc;if(!r[Qd+84|0]){a=q[q[Vd>>2]+(Td<<2)>>2]}if(!Ka(Qd,a,o[kc+24|0],q[Rd>>2])){Qd=0;break c}if(!Wd){Qd=0;a=q[Rd>>2];while(1){o[lc+dd|0]=r[a+Qd|0];lc=lc+1|0;Qd=Qd+1|0;if((Sd|0)!=(Qd|0)){continue}break}}Qd=1;Td=Td+1|0;if((Ud|0)!=(Td|0)){continue}break}}a=q[Rd>>2];if(!a){break b}q[Rd+4>>2]=a;An(a)}T=Rd+16|0;return Qd}bn();F()}function Za(a,kc,lc,dd){var Xd=0,Yd=0,Zd=0,_d=0,$d=0,ae=0,be=0,ce=0,de=0;Xd=T-16|0;T=Xd;a:{$d=q[a+80>>2];Zd=o[kc+24|0];a=Zd<<1;b:{if((w($d,a)|0)!=(lc|0)){break b}if(!(!r[kc+84|0]|q[kc+28>>2]!=4)){Cn(dd,q[q[kc>>2]>>2]+q[kc+48>>2]|0,lc);Yd=1;break b}lc=0;q[Xd+8>>2]=0;q[Xd>>2]=0;q[Xd+4>>2]=0;if(Zd){if((Zd|0)<=-1){break a}lc=Mm(a);q[Xd>>2]=lc;q[Xd+8>>2]=(Zd<<1)+lc;ce=Xd,de=Dn(lc,0,a)+a|0,q[ce+4>>2]=de}c:{if(!$d){Yd=1;break c}lc=0;ae=kc+68|0;be=(Zd|0)<1;while(1){a=_d;Yd=kc;if(!r[kc+84|0]){a=q[q[ae>>2]+(_d<<2)>>2]}d:{if(!Pa(Yd,a,o[kc+24|0],q[Xd>>2])){Yd=0;break d}if(!be){Yd=0;a=q[Xd>>2];while(1){p[(lc<<1)+dd>>1]=s[a+(Yd<<1)>>1];lc=lc+1|0;Yd=Yd+1|0;if((Zd|0)!=(Yd|0)){continue}break}}Yd=1;_d=_d+1|0;if(($d|0)!=(_d|0)){continue}}break}lc=q[Xd>>2]}if(!lc){break b}q[Xd+4>>2]=lc;An(lc)}T=Xd+16|0;return Yd}bn();F()}function _a(a,kc,lc,dd){var ee=0,fe=0,ge=0,he=0,ie=0,je=0,ke=0,le=0,me=0;ee=T-16|0;T=ee;a:{ie=q[a+80>>2];ge=o[kc+24|0];a=ge<<2;b:{if((w(ie,a)|0)!=(lc|0)){break b}if(!(!r[kc+84|0]|q[kc+28>>2]!=6)){Cn(dd,q[q[kc>>2]>>2]+q[kc+48>>2]|0,lc);fe=1;break b}lc=0;q[ee+8>>2]=0;q[ee>>2]=0;q[ee+4>>2]=0;if(ge){if((ge|0)<=-1){break a}lc=Mm(a);q[ee>>2]=lc;q[ee+8>>2]=(ge<<2)+lc;le=ee,me=Dn(lc,0,a)+a|0,q[le+4>>2]=me}c:{if(!ie){fe=1;break c}lc=0;je=kc+68|0;ke=(ge|0)<1;while(1){a=he;fe=kc;if(!r[kc+84|0]){a=q[q[je>>2]+(he<<2)>>2]}d:{if(!Ta(fe,a,o[kc+24|0],q[ee>>2])){fe=0;break d}if(!ke){fe=0;a=q[ee>>2];while(1){q[(lc<<2)+dd>>2]=q[a+(fe<<2)>>2];lc=lc+1|0;fe=fe+1|0;if((ge|0)!=(fe|0)){continue}break}}fe=1;he=he+1|0;if((ie|0)!=(he|0)){continue}}break}lc=q[ee>>2]}if(!lc){break b}q[ee+4>>2]=lc;An(lc)}T=ee+16|0;return fe}bn();F()}function $a(a,o){var kc=0,lc=0;kc=q[a+4>>2];if(!kc){return 0}o=q[q[q[a+8>>2]+(o<<2)>>2]+60>>2];if((o|0)<0){return 0}a=q[kc+24>>2];kc=q[kc+28>>2];if((a|0)==(kc|0)){return 0}a:{while(1){lc=q[a>>2];if((o|0)==q[lc+24>>2]){break a}a=a+4|0;if((kc|0)!=(a|0)){continue}break}return 0}return lc}function ab(a){var o=0;o=I(8)|0;q[o>>2]=15856;q[o>>2]=15900;Nm(o+4|0,a);q[o>>2]=15948;J(o|0,15980,1);F()}function bb(a,dd,ne){var oe=0,pe=0,qe=0,re=0,se=0;pe=T-16|0;T=pe;q[a+4>>2]=0;a:{b:{if(!dd){break b}qe=q[a+8>>2];oe=qe<<5;c:{if(oe>>>0>=dd>>>0){q[a+4>>2]=dd;break c}q[pe+8>>2]=0;q[pe>>2]=0;q[pe+4>>2]=0;if((dd|0)<=-1){break a}se=pe;if(oe>>>0<=1073741822){re=dd+31&-32;oe=qe<<6;re=oe>>>0<re>>>0?re:oe}else{re=2147483647}cb(se,re);re=q[a>>2];q[a>>2]=q[pe>>2];q[pe>>2]=re;qe=q[a+4>>2];q[a+4>>2]=dd;q[pe+4>>2]=qe;oe=a+8|0;qe=q[oe>>2];q[oe>>2]=q[pe+8>>2];q[pe+8>>2]=qe;if(!re){break c}An(re)}oe=dd>>>5;qe=oe<<2;a=q[a>>2];if(r[ne|0]){a=Dn(a,255,qe);dd=dd&31;if(!dd){break b}a=a+(oe<<2)|0;q[a>>2]=q[a>>2]|-1>>>32-dd;break b}a=Dn(a,0,qe);dd=dd&31;if(!dd){break b}a=a+(oe<<2)|0;q[a>>2]=q[a>>2]&(-1>>>32-dd^-1)}T=pe+16|0;return}bn();F()}function cb(a,dd){var ne=0,te=0;ne=T-32|0;T=ne;a:{b:{if(q[a+8>>2]<<5>>>0>=dd>>>0){break b}q[ne+24>>2]=0;q[ne+16>>2]=0;q[ne+20>>2]=0;if((dd|0)<=-1){break a}dd=(dd+ -1>>>5)+1|0;te=Mm(dd<<2);q[ne+24>>2]=dd;q[ne+20>>2]=0;q[ne+16>>2]=te;dd=q[a>>2];q[ne+12>>2]=0;q[ne+8>>2]=dd;te=q[a+4>>2];q[ne+4>>2]=te&31;q[ne>>2]=dd+(te>>>3&536870908);db(ne+16|0,ne+8|0,ne);dd=q[a>>2];q[a>>2]=q[ne+16>>2];q[ne+16>>2]=dd;te=q[a+4>>2];q[a+4>>2]=q[ne+20>>2];q[ne+20>>2]=te;a=a+8|0;te=q[a>>2];q[a>>2]=q[ne+24>>2];q[ne+24>>2]=te;if(!dd){break b}An(dd)}T=ne+32|0;return}bn();F()}function db(a,dd,ue){var ve=0,we=0,xe=0,ye=0,ze=0,Ae=0;xe=T-32|0;T=xe;ze=q[ue+4>>2];ve=q[dd+4>>2];Ae=q[ue>>2];ye=q[dd>>2];dd=(ze-ve|0)+(Ae-ye<<3)|0;ue=q[a+4>>2];we=dd+ue|0;q[a+4>>2]=we;a:{if(!(!ue|(we+ -1^ue+ -1)>>>0>31)){a=q[a>>2];break a}a=q[a>>2];if(we>>>0<=32){q[a>>2]=0;break a}q[(we+ -1>>>3&536870908)+a>>2]=0}a=(ue>>>3&536870908)+a|0;ue=ue&31;b:{if((ue|0)==(ve|0)){c:{if((dd|0)<1){break c}d:{if(!ve){ue=0;break d}we=32-ve|0;ue=(dd|0)<(we|0)?dd:we;we=-1<<ve&-1>>>we-ue;q[a>>2]=q[a>>2]&(we^-1)|we&q[ye>>2];dd=dd-ue|0;ve=ue+ve|0;ue=ve&31;a=(ve>>>3&536870908)+a|0;ye=ye+4|0}ve=(dd|0)/32|0;we=ve<<2;a=En(a,ye,we)+we|0;ve=dd-(ve<<5)|0;if((ve|0)<1){ve=ue;break c}dd=-1>>>32-ve;q[a>>2]=q[a>>2]&(dd^-1)|dd&q[we+ye>>2]}q[xe+4>>2]=ve;q[xe>>2]=a;break b}q[xe+28>>2]=ve;q[xe+24>>2]=ye;q[xe+20>>2]=ze;q[xe+16>>2]=Ae;q[xe+12>>2]=ue;q[xe+8>>2]=a;eb(xe,xe+24|0,xe+16|0,xe+8|0)}T=xe+32|0}function eb(a,dd,ue,Be){var Ce=0,De=0,Ee=0,Fe=0,Ge=0,He=0,Ie=0,Je=0;De=q[dd>>2];Ce=q[ue+4>>2]+(q[ue>>2]-De<<3)|0;ue=q[dd+4>>2];Ee=Ce-ue|0;a:{if((Ee|0)<=0){ue=q[Be+4>>2];break a}b:{if(!ue){ue=q[Be+4>>2];break b}Ce=q[Be+4>>2];He=32-Ce|0;Ie=32-ue|0;Fe=(Ee|0)<(Ie|0)?Ee:Ie;Ge=He>>>0<Fe>>>0?He:Fe;Je=q[Be>>2];De=q[De>>2]&(-1<<ue&-1>>>Ie-Fe);q[Je>>2]=q[Je>>2]&(-1<<Ce&-1>>>He-Ge^-1)|(Ce>>>0>ue>>>0?De<<Ce-ue:De>>>ue-Ce);Ce=Ce+Ge|0;ue=Ce&31;q[Be+4>>2]=ue;He=Je+(Ce>>>3&536870908)|0;q[Be>>2]=He;Ce=Fe-Ge|0;if((Ce|0)>=1){q[He>>2]=q[He>>2]&(-1>>>32-Ce^-1)|De>>>Ge+q[dd+4>>2];q[Be+4>>2]=Ce;ue=Ce}Ee=Ee-Fe|0;De=q[dd>>2]+4|0;q[dd>>2]=De}Ge=-1<<ue;Fe=32-ue|0;c:{if((Ee|0)<32){Ce=Ee;break c}He=Ge^-1;while(1){Ce=q[Be>>2];De=q[De>>2];q[Ce>>2]=He&q[Ce>>2]|De<<ue;q[Be>>2]=Ce+4;q[Ce+4>>2]=Ge&q[Ce+4>>2]|De>>>Fe;De=q[dd>>2]+4|0;q[dd>>2]=De;Ie=(Ee|0)>63;Ce=Ee+ -32|0;Ee=Ce;if(Ie){continue}break}}if((Ce|0)<1){break a}dd=q[Be>>2];Ee=(Fe|0)<(Ce|0)?Fe:Ce;Ge=q[dd>>2]&(Ge&-1>>>Fe-Ee^-1);Fe=q[De>>2]&-1>>>32-Ce;q[dd>>2]=Ge|Fe<<ue;De=ue+Ee|0;ue=De&31;q[Be+4>>2]=ue;De=dd+(De>>>3&536870908)|0;q[Be>>2]=De;dd=Ce-Ee|0;if((dd|0)<1){break a}q[De>>2]=q[De>>2]&(-1>>>32-dd^-1)|Fe>>>Ee;q[Be+4>>2]=dd;ue=dd}dd=q[Be>>2];q[a+4>>2]=ue;q[a>>2]=dd}function fb(a){a=a|0;return q[a>>2]}function gb(a){a=a|0;return!q[a>>2]|0}function hb(a){a=a|0;var dd=0;dd=a+4|0;if(o[a+15|0]<=-1){dd=q[dd>>2]}return dd|0}function ib(a){a=a|0;if(a){if(o[a+15|0]<=-1){An(q[a+4>>2])}An(a)}}function jb(){var a=0;a=Mm(12);q[a>>2]=0;q[a+4>>2]=0;q[a+8>>2]=0;return a|0}function kb(ue,Be){ue=ue|0;Be=Be|0;return s[q[ue>>2]+(Be<<1)>>1]}function lb(ue){ue=ue|0;return q[ue+4>>2]-q[ue>>2]>>1}function mb(ue){ue=ue|0;var Be=0;if(ue){Be=q[ue>>2];if(Be){q[ue+4>>2]=Be;An(Be)}An(ue)}}function nb(){return al(Mm(84))|0}function ob(ue){ue=ue|0;return q[ue+12>>2]-q[ue+8>>2]>>2}function pb(ue){ue=ue|0;return q[ue+80>>2]}function qb(ue){ue=ue|0;if(ue){n[q[q[ue>>2]+4>>2]](ue)}}function rb(ue,Ke){ue=ue|0;Ke=Ke|0;return r[q[ue>>2]+Ke|0]}function sb(ue){ue=ue|0;return q[ue+4>>2]-q[ue>>2]|0}function tb(ue,Ke){ue=ue|0;Ke=Ke|0;return q[q[ue>>2]+(Ke<<2)>>2]}function ub(ue){ue=ue|0;return q[ue+4>>2]-q[ue>>2]>>2}function vb(){var ue=0;ue=Mm(8);q[ue+4>>2]=-1;q[ue>>2]=1116;return ue|0}function wb(Ke,Le){Ke=Ke|0;Le=Le|0;return n[q[q[Ke>>2]+12>>2]](Ke,Le)|0}function xb(Ke){Ke=Ke|0;return q[Ke+4>>2]}function yb(){return rd(Mm(96))|0}function zb(Ke){Ke=Ke|0;return q[Ke+88>>2]}function Ab(Ke){Ke=Ke|0;return q[Ke+56>>2]}function Bb(Ke){Ke=Ke|0;return q[Ke+28>>2]}function Cb(q){q=q|0;return o[q+24|0]}function Db(q){q=q|0;return r[q+32|0]}function Eb(Ke){Ke=Ke|0;return q[Ke+40>>2]}function Fb(Ke){Ke=Ke|0;return q[Ke+48>>2]}function Gb(Ke){Ke=Ke|0;return q[Ke+60>>2]}function Hb(Ke){Ke=Ke|0;var Le=0,Me=0;if(Ke){Le=Ke+88|0;Me=q[Le>>2];q[Le>>2]=0;if(Me){Le=q[Me+8>>2];if(Le){q[Me+12>>2]=Le;An(Le)}An(Me)}Me=q[Ke+68>>2];if(Me){q[Ke+72>>2]=Me;An(Me)}Le=Ke- -64|0;Me=q[Le>>2];q[Le>>2]=0;if(Me){Le=q[Me>>2];if(Le){q[Me+4>>2]=Le;An(Le)}An(Me)}An(Ke)}}function Ib(){var Ke=0;Ke=Mm(40);q[Ke>>2]=-1;Uj(Ke+8|0);return Ke|0}function Jb(Ne){Ne=Ne|0;var Oe=0;if(Ne){Oe=q[Ne+8>>2];if(Oe){q[Ne+12>>2]=Oe;An(Oe)}An(Ne)}}function Kb(){var Ne=0;Ne=Mm(24);q[Ne+4>>2]=-1;q[Ne>>2]=1232;q[Ne+8>>2]=0;q[Ne+12>>2]=0;q[Ne+16>>2]=0;q[Ne+20>>2]=0;return Ne|0}function Lb(Pe,Qe){Pe=Pe|0;Qe=Qe|0;return x(u[q[Pe+8>>2]+(Qe<<2)>>2])}function Mb(q){q=q|0;return x(u[q+20>>2])}function Nb(Pe,Qe){Pe=Pe|0;Qe=Qe|0;return o[q[Pe>>2]+Qe|0]}function Ob(){var Pe=0;Pe=Mm(28);q[Pe>>2]=0;q[Pe+4>>2]=0;q[Pe+24>>2]=0;q[Pe+16>>2]=0;q[Pe+20>>2]=0;q[Pe+8>>2]=0;q[Pe+12>>2]=0;return Pe|0}function Pb(q,Qe,Re){q=q|0;Qe=Qe|0;Re=Re|0;return fa(Qe,Re)|0}function Qb(q,Qe,Re){q=q|0;Qe=Qe|0;Re=Re|0;return ha(Qe,Re)|0}function Rb(q,Qe,Re,Se){q=q|0;Qe=Qe|0;Re=Re|0;Se=Se|0;ia(Qe,Re,Se)}function Sb(q,Qe,Re){q=q|0;Qe=Qe|0;Re=Re|0;return+ja(Qe,Re)}function Tb(q,Qe,Re){q=q|0;Qe=Qe|0;Re=Re|0;return ka(q,Qe,Re)|0}function Ub(Qe,Re){Qe=Qe|0;Re=Re|0;return q[Re+8>>2]}function Vb(q,Qe,Re){q=q|0;Qe=Qe|0;Re=Re|0;return la(q,Qe,Re)|0}function Wb(Qe){Qe=Qe|0;var Re=0,Se=0,Te=0,Ue=0,Ve=0;if(Qe){if(o[Qe+27|0]<=-1){An(q[Qe+16>>2])}Se=q[Qe>>2];if(Se){Re=Se;Ve=Qe+4|0;Te=q[Ve>>2];Ue=Re;a:{if((Te|0)==(Re|0)){break a}while(1){Re=Te+ -12|0;if(o[Te+ -1|0]<=-1){An(q[Re>>2])}Te=Re;if((Re|0)!=(Se|0)){continue}break}Ue=q[Qe>>2]}Re=Ue;q[Ve>>2]=Se;An(Re)}An(Qe)}}function Xb(Qe,We){Qe=Qe|0;We=We|0;return p[q[Qe>>2]+(We<<1)>>1]}function Yb(Qe,We){Qe=Qe|0;We=We|0;return x(u[q[Qe>>2]+(We<<2)>>2])}function Zb(){return nd(Mm(64))|0}function _b(q){q=q|0;if(q){An(q)}}function $b(){return Yj(Mm(40))|0}function ac(Qe,We,Xe){Qe=Qe|0;We=We|0;Xe=Xe|0;q[Qe+16>>2]=0;q[Qe+20>>2]=0;q[Qe>>2]=We;q[Qe+8>>2]=Xe;q[Qe+12>>2]=0}function bc(){return na(Mm(40))|0}function cc(q,Qe){q=q|0;Qe=Qe|0;return oa(Qe)|0}function dc(q,Qe,We){q=q|0;Qe=Qe|0;We=We|0;return pa(q,Qe,We)|0}function ec(q,Qe,We){q=q|0;Qe=Qe|0;We=We|0;return qa(q,Qe,We)|0}function fc(q,Qe,We){q=q|0;Qe=Qe|0;We=We|0;return bl(Qe,We)|0}function gc(q,Qe,We){q=q|0;Qe=Qe|0;We=We|0;return ra(Qe,We)|0}function hc(q,Qe,We,Xe){q=q|0;Qe=Qe|0;We=We|0;Xe=Xe|0;return sa(Qe,We,Xe)|0}function ic(Qe,We,Xe){Qe=Qe|0;We=We|0;Xe=Xe|0;return q[q[We+8>>2]+(Xe<<2)>>2]}function jc(q,Qe,We){q=q|0;Qe=Qe|0;We=We|0;return dl(Qe,We)|0}function kc(Qe,We){Qe=Qe|0;We=We|0;return q[We+4>>2]}function lc(q,Qe,We){q=q|0;Qe=Qe|0;We=We|0;return $a(Qe,We)|0}function mc(q,Qe,We,Xe){q=q|0;Qe=Qe|0;We=We|0;Xe=Xe|0;return ta(Qe,We,Xe)|0}function nc(q,Qe,We){q=q|0;Qe=Qe|0;We=We|0;return ua(Qe,We)|0}function oc(q,Qe,We,Xe){q=q|0;Qe=Qe|0;We=We|0;Xe=Xe|0;return Aa(Qe,We,Xe)|0}function pc(q,Qe,We,Xe){q=q|0;Qe=Qe|0;We=We|0;Xe=Xe|0;return Ba(Qe,We,Xe)|0}function qc(q,Qe,We,Xe){q=q|0;Qe=Qe|0;We=We|0;Xe=Xe|0;return Ca(Qe,We,Xe)|0}function rc(q,Qe,We,Xe){q=q|0;Qe=Qe|0;We=We|0;Xe=Xe|0;return Ea(Qe,We,Xe)|0}function sc(q,Qe,We,Xe){q=q|0;Qe=Qe|0;We=We|0;Xe=Xe|0;return Qa(Qe,We,Xe)|0}function tc(q,Qe,We,Xe){q=q|0;Qe=Qe|0;We=We|0;Xe=Xe|0;return Ga(Qe,We,Xe)|0}function uc(q,Qe,We,Xe){q=q|0;Qe=Qe|0;We=We|0;Xe=Xe|0;return Ja(Qe,We,Xe)|0}function vc(q,Qe,We,Xe){q=q|0;Qe=Qe|0;We=We|0;Xe=Xe|0;return La(Qe,We,Xe)|0}function wc(q,Qe,We,Xe){q=q|0;Qe=Qe|0;We=We|0;Xe=Xe|0;return Oa(Qe,We,Xe)|0}function xc(q,Qe,We,Xe){q=q|0;Qe=Qe|0;We=We|0;Xe=Xe|0;return Sa(Qe,We,Xe)|0}function yc(q,Qe,We,Xe,Ye,Ze){q=q|0;Qe=Qe|0;We=We|0;Xe=Xe|0;Ye=Ye|0;Ze=Ze|0;return Ua(Qe,We,Xe,Ye,Ze)|0}function zc(q,Qe){q=q|0;Qe=Qe|0;kh(q,Qe)}function Ac(Qe){Qe=Qe|0;if(Qe){if(o[Qe+39|0]<=-1){An(q[Qe+28>>2])}Bc(Qe+12|0,q[Qe+16>>2]);Cc(Qe,q[Qe+4>>2]);An(Qe)}}function Bc(Qe,We){if(We){Bc(Qe,q[We>>2]);Bc(Qe,q[We+4>>2]);Cc(We+20|0,q[We+24>>2]);An(We)}}function Cc(Qe,We){if(We){Cc(Qe,q[We>>2]);Cc(Qe,q[We+4>>2]);if(o[We+39|0]<=-1){An(q[We+28>>2])}if(o[We+27|0]<=-1){An(q[We+16>>2])}An(We)}}function Dc(){return vk(Mm(108))|0}function Ec(Qe){Qe=Qe|0;return(q[Qe+100>>2]-q[Qe+96>>2]|0)/12|0}function Fc(){var Qe=0,We=0,Xe=0;We=Mm(24);Xe=We+4|0;Qe=Xe;q[Qe>>2]=0;q[Qe+4>>2]=0;Qe=We+16|0;q[Qe>>2]=0;q[Qe+4>>2]=0;q[We>>2]=Xe;q[We+12>>2]=Qe;return We|0}function Gc(Ye){Ye=Ye|0;if(Ye){Hc(Ye+12|0,q[Ye+16>>2]);Ic(Ye,q[Ye+4>>2]);An(Ye)}}function Hc(Ye,Ze){var _e=0;if(Ze){Hc(Ye,q[Ze>>2]);Hc(Ye,q[Ze+4>>2]);_e=Ze+28|0;Ye=q[_e>>2];q[_e>>2]=0;if(Ye){Hc(Ye+12|0,q[Ye+16>>2]);Ic(Ye,q[Ye+4>>2]);An(Ye)}if(o[Ze+27|0]<=-1){An(q[Ze+16>>2])}An(Ze)}}function Ic(Ye,Ze){if(Ze){Ic(Ye,q[Ze>>2]);Ic(Ye,q[Ze+4>>2]);Ye=q[Ze+28>>2];if(Ye){q[Ze+32>>2]=Ye;An(Ye)}if(o[Ze+27|0]<=-1){An(q[Ze+16>>2])}An(Ze)}}function Jc(){return 0}function Kc(){return-1}function Lc(){return-2}function Mc(){return-3}function Nc(){return-4}function Oc(){return-5}function Pc(){return 1}function Qc(){return 2}function Rc(){return 3}function Sc(){return 4}function Tc(){return 5}function Uc(){return 6}function Vc(){return 7}function Wc(){return 8}function Xc(){return 9}function Yc(){return 10}function Zc(){return 11}function _c(){return 12}function $c(Ye,Ze){Ye=Ye|0;Ze=Ze|0;var $e=0;Ze=q[Ze+88>>2];if(!(!Ze|q[Ze>>2]!=2)){$e=Ye;Ye=q[Ze+8>>2];q[$e+4>>2]=r[Ye|0]|r[Ye+1|0]<<8|(r[Ye+2|0]<<16|r[Ye+3|0]<<24);$e=1}return $e|0}function ad(Ye,Ze){Ye=Ye|0;Ze=Ze|0;var af=0,bf=0;q[Ze>>2]=2;af=q[Ze+8>>2];bf=q[Ze+12>>2]-af|0;if(bf>>>0<=4294967291){Ze=Ze+8|0;Xj(Ze,bf+4|0);af=q[Ze>>2]}Ze=af+bf|0;Ye=r[Ye+4|0]|r[Ye+5|0]<<8|(r[Ye+6|0]<<16|r[Ye+7|0]<<24);o[Ze|0]=Ye;o[Ze+1|0]=Ye>>>8;o[Ze+2|0]=Ye>>>16;o[Ze+3|0]=Ye>>>24}function bd(q){q=q|0;return q|0}function cd(q){q=q|0;An(q)}function dd(q){q=q|0;return 2}function ed(Ye,Ze){Ye=Ye|0;Ze=Ze|0;var cf=0,df=0,ef=0,ff=0,gf=0,hf=0;ef=q[Ze+88>>2];if(!(!ef|q[ef>>2]!=1)){ff=ef+8|0;ef=q[ff>>2];cf=ef;q[Ye+4>>2]=r[cf|0]|r[cf+1|0]<<8|(r[cf+2|0]<<16|r[cf+3|0]<<24);gf=Ye+8|0;hf=q[Ye+8>>2];df=q[Ye+12>>2]-hf>>2;cf=o[Ze+24|0];a:{if(df>>>0<cf>>>0){Fa(gf,cf-df|0);ef=q[ff>>2];cf=r[Ze+24|0];break a}if(df>>>0<=cf>>>0){break a}q[Ye+12>>2]=hf+(cf<<2)}ff=1;Ze=ef;df=r[Ze+4|0]|r[Ze+5|0]<<8|(r[Ze+6|0]<<16|r[Ze+7|0]<<24);if(cf<<24>>24>=1){hf=cf&255;gf=q[gf>>2];Ze=0;cf=4;while(1){q[gf+(Ze<<2)>>2]=df;cf=cf+4|0;df=ef+cf|0;df=r[df|0]|r[df+1|0]<<8|(r[df+2|0]<<16|r[df+3|0]<<24);Ze=Ze+1|0;if(Ze>>>0<hf>>>0){continue}break}}q[Ye+20>>2]=df}return ff|0}function fd(Ye,Ze){Ye=Ye|0;Ze=Ze|0;var jf=0,kf=0,lf=0,mf=0,nf=0,of=0;q[Ze>>2]=1;mf=Ze+8|0;jf=q[Ze+8>>2];kf=q[Ze+12>>2]-jf|0;if(kf>>>0<=4294967291){Xj(mf,kf+4|0);jf=q[mf>>2]}kf=jf+kf|0;jf=r[Ye+4|0]|r[Ye+5|0]<<8|(r[Ye+6|0]<<16|r[Ye+7|0]<<24);o[kf|0]=jf;o[kf+1|0]=jf>>>8;o[kf+2|0]=jf>>>16;o[kf+3|0]=jf>>>24;jf=q[Ye+8>>2];if((jf|0)!=q[Ye+12>>2]){of=Ze+12|0;while(1){kf=(nf<<2)+jf|0;jf=q[Ze+8>>2];lf=q[of>>2]-jf|0;if(lf>>>0<=4294967291){Xj(mf,lf+4|0);jf=q[mf>>2]}lf=jf+lf|0;jf=r[kf|0]|r[kf+1|0]<<8|(r[kf+2|0]<<16|r[kf+3|0]<<24);o[lf|0]=jf;o[lf+1|0]=jf>>>8;o[lf+2|0]=jf>>>16;o[lf+3|0]=jf>>>24;nf=nf+1|0;jf=q[Ye+8>>2];if(nf>>>0<q[Ye+12>>2]-jf>>2>>>0){continue}break}}jf=q[Ze+12>>2];Ze=q[Ze+8>>2];jf=jf-Ze|0;if(jf>>>0<=4294967291){Xj(mf,jf+4|0);Ze=q[mf>>2]}Ze=Ze+jf|0;Ye=r[Ye+20|0]|r[Ye+21|0]<<8|(r[Ye+22|0]<<16|r[Ye+23|0]<<24);o[Ze|0]=Ye;o[Ze+1|0]=Ye>>>8;o[Ze+2|0]=Ye>>>16;o[Ze+3|0]=Ye>>>24}function gd(Ye,Ze,pf,qf,rf){q[Ye+4>>2]=Ze;hd(Ye+8|0,pf,(qf<<2)+pf|0);u[Ye+20>>2]=rf}function hd(Ye,Ze,pf){var qf=0,rf=0,sf=0,tf=0,uf=0,vf=0,wf=0;a:{tf=pf-Ze|0;sf=tf>>2;qf=q[Ye+8>>2];rf=q[Ye>>2];b:{if(sf>>>0<=qf-rf>>2>>>0){qf=q[Ye+4>>2]-rf|0;tf=qf>>2;qf=sf>>>0>tf>>>0?Ze+qf|0:pf;uf=qf-Ze|0;if(uf){En(rf,Ze,uf)}if(sf>>>0>tf>>>0){Ze=pf-qf|0;if((Ze|0)<1){break b}Ye=Ye+4|0;Cn(q[Ye>>2],qf,Ze);q[Ye>>2]=Ze+q[Ye>>2];return}q[Ye+4>>2]=rf+(uf>>2<<2);return}if(rf){q[Ye+4>>2]=rf;An(rf);q[Ye+8>>2]=0;q[Ye>>2]=0;q[Ye+4>>2]=0;qf=0}if(sf>>>0>=1073741824){break a}pf=qf>>1;pf=qf>>2>>>0<536870911?pf>>>0<sf>>>0?sf:pf:1073741823;if(pf>>>0>=1073741824){break a}rf=pf<<2;pf=Mm(rf);q[Ye>>2]=pf;sf=Ye+4|0;q[sf>>2]=pf;q[Ye+8>>2]=pf+rf;if((tf|0)<1){break b}vf=sf,wf=Cn(pf,Ze,tf)+tf|0,q[vf>>2]=wf}return}bn();F()}function id(Ye){Ye=Ye|0;var Ze=0;q[Ye>>2]=1232;Ze=q[Ye+8>>2];if(Ze){q[Ye+12>>2]=Ze;An(Ze)}return Ye|0}function jd(Ye){Ye=Ye|0;var pf=0;q[Ye>>2]=1232;pf=q[Ye+8>>2];if(pf){q[Ye+12>>2]=pf;An(pf)}An(Ye)}function kd(q){q=q|0;return 1}function ld(Ye,xf){var yf=0;yf=Mm(40);q[yf>>2]=-1;Uj(yf+8|0);n[q[q[Ye>>2]+16>>2]](Ye,yf);Ye=q[xf+88>>2];q[xf+88>>2]=yf;if(Ye){xf=q[Ye+8>>2];if(xf){q[Ye+12>>2]=xf;An(xf)}An(Ye)}return 1}function md(Ye,xf,zf){var Af=0,Bf=0,Cf=0,Df=0,Ef=0,Ff=0;Cf=q[Ye+8>>2];Af=q[Ye+4>>2];if(Cf-Af>>2>>>0>=xf>>>0){while(1){q[Af>>2]=q[zf>>2];Af=Af+4|0;xf=xf+ -1|0;if(xf){continue}break}q[Ye+4>>2]=Af;return}a:{Df=q[Ye>>2];Ef=Af-Df|0;Ff=Ef>>2;Af=Ff+xf|0;if(Af>>>0<1073741824){Cf=Cf-Df|0;Bf=Cf>>1;Af=Cf>>2>>>0<536870911?Bf>>>0<Af>>>0?Af:Bf:1073741823;Bf=0;b:{if(!Af){break b}if(Af>>>0>=1073741824){break a}Bf=Mm(Af<<2)}Cf=Bf+(Af<<2)|0;Af=Bf+(Ff<<2)|0;while(1){q[Af>>2]=q[zf>>2];Af=Af+4|0;xf=xf+ -1|0;if(xf){continue}break}if((Ef|0)>=1){Cn(Bf,Df,Ef)}q[Ye>>2]=Bf;q[Ye+8>>2]=Cf;q[Ye+4>>2]=Af;if(Df){An(Df)}return}bn();F()}ab(1308);F()}function nd(Ye){q[Ye+8>>2]=0;q[Ye+12>>2]=0;q[Ye>>2]=0;q[Ye+40>>2]=0;q[Ye+44>>2]=0;q[Ye+28>>2]=9;o[Ye+24|0]=1;q[Ye+56>>2]=-1;q[Ye+60>>2]=0;q[Ye+16>>2]=0;q[Ye+20>>2]=0;q[Ye+48>>2]=0;q[Ye+52>>2]=0;return Ye}function od(Ye,xf,zf,Gf,Hf,If,Jf){q[Ye>>2]=0;q[Ye+56>>2]=xf;q[Ye+48>>2]=0;q[Ye+52>>2]=0;q[Ye+40>>2]=If;q[Ye+44>>2]=Jf;o[Ye+32|0]=Hf;q[Ye+28>>2]=Gf;o[Ye+24|0]=zf}function pd(Ye,xf){var zf=0,Gf=0,Hf=0;Gf=q[Ye>>2];a:{if(!Gf){break a}zf=q[xf>>2];if(!zf){break a}Hf=Gf;Gf=q[zf>>2];Vj(Hf,Gf,q[zf+4>>2]-Gf|0,0);o[Ye+24|0]=r[xf+24|0];q[Ye+28>>2]=q[xf+28>>2];o[Ye+32|0]=r[xf+32|0];zf=q[xf+44>>2];q[Ye+40>>2]=q[xf+40>>2];q[Ye+44>>2]=zf;zf=q[xf+52>>2];q[Ye+48>>2]=q[xf+48>>2];q[Ye+52>>2]=zf;q[Ye+56>>2]=q[xf+56>>2];zf=q[xf+12>>2];q[Ye+8>>2]=q[xf+8>>2];q[Ye+12>>2]=zf;zf=q[xf+20>>2];q[Ye+16>>2]=q[xf+16>>2];q[Ye+20>>2]=zf;q[Ye+60>>2]=q[xf+60>>2];Hf=1}return Hf}function qd(Ye,xf,If,Jf){var Kf=0;q[Ye>>2]=xf;Kf=q[xf+20>>2];q[Ye+8>>2]=q[xf+16>>2];q[Ye+12>>2]=Kf;Kf=q[xf+24>>2];xf=q[xf+28>>2];q[Ye+48>>2]=0;q[Ye+52>>2]=0;q[Ye+40>>2]=If;q[Ye+44>>2]=Jf;q[Ye+16>>2]=Kf;q[Ye+20>>2]=xf}function rd(Ye){nd(Ye);q[Ye+64>>2]=0;q[Ye+68>>2]=0;q[Ye+88>>2]=0;q[Ye+72>>2]=0;q[Ye+76>>2]=0;o[Ye+77|0]=0;o[Ye+78|0]=0;o[Ye+79|0]=0;o[Ye+80|0]=0;o[Ye+81|0]=0;o[Ye+82|0]=0;o[Ye+83|0]=0;o[Ye+84|0]=0;return Ye}function sd(Ye,xf){var If=0;If=q[xf+4>>2];q[Ye>>2]=q[xf>>2];q[Ye+4>>2]=If;If=q[xf+60>>2];q[Ye+56>>2]=q[xf+56>>2];q[Ye+60>>2]=If;If=q[xf+52>>2];q[Ye+48>>2]=q[xf+48>>2];q[Ye+52>>2]=If;If=q[xf+44>>2];q[Ye+40>>2]=q[xf+40>>2];q[Ye+44>>2]=If;If=q[xf+36>>2];q[Ye+32>>2]=q[xf+32>>2];q[Ye+36>>2]=If;If=q[xf+28>>2];q[Ye+24>>2]=q[xf+24>>2];q[Ye+28>>2]=If;If=q[xf+20>>2];q[Ye+16>>2]=q[xf+16>>2];q[Ye+20>>2]=If;If=q[xf+12>>2];q[Ye+8>>2]=q[xf+8>>2];q[Ye+12>>2]=If;q[Ye+88>>2]=0;q[Ye+64>>2]=0;q[Ye+68>>2]=0;q[Ye+72>>2]=0;q[Ye+76>>2]=0;o[Ye+77|0]=0;o[Ye+78|0]=0;o[Ye+79|0]=0;o[Ye+80|0]=0;o[Ye+81|0]=0;o[Ye+82|0]=0;o[Ye+83|0]=0;o[Ye+84|0]=0}function td(Ye,xf){var Jf=0,Lf=0;a:{if(q[Ye+64>>2]){break a}Lf=Mm(32);Uj(Lf);Jf=q[Ye+64>>2];q[Ye+64>>2]=Lf;if(!Jf){break a}Lf=q[Jf>>2];if(Lf){q[Jf+4>>2]=Lf;An(Lf)}An(Jf)}Jf=bk(q[Ye+28>>2]);Jf=w(Jf,o[Ye+24|0]);Lf=Jf;Jf=Jf>>31;if(Vj(q[Ye+64>>2],0,$n(Lf,Jf,xf,0),V)){qd(Ye,q[Ye+64>>2],Lf,Jf);q[Ye+80>>2]=xf;Ye=1}else{Ye=0}return Ye}function ud(Ye,xf){var Mf=0,Nf=0,Of=0,Pf=0,Qf=0,Rf=0,Sf=0;if(!q[Ye- -64>>2]){Mf=Mm(32);Uj(Mf);Of=q[Ye+64>>2];q[Ye+64>>2]=Mf;Nf=Ye;if(Of){Mf=q[Of>>2];if(Mf){q[Of+4>>2]=Mf;An(Mf)}An(Of);Mf=q[Ye+64>>2]}qd(Nf,Mf,0,0)}a:{b:{if(!pd(Ye,xf)){break b}o[Ye+84|0]=r[xf+84|0];q[Ye+80>>2]=q[xf+80>>2];if((Ye|0)!=(xf|0)){vd(Ye+68|0,q[xf+68>>2],q[xf+72>>2])}Mf=q[xf+88>>2];if(Mf){xf=Mm(40);Nf=q[Mf>>2];q[xf+16>>2]=0;q[xf+8>>2]=0;q[xf+12>>2]=0;q[xf>>2]=Nf;Nf=q[Mf+12>>2]-q[Mf+8>>2]|0;c:{if(!Nf){break c}if((Nf|0)<=-1){break a}Of=Mm(Nf);q[xf+8>>2]=Of;Pf=xf+12|0;q[Pf>>2]=Of;q[xf+16>>2]=Nf+Of;Qf=q[Mf+8>>2];Nf=q[Mf+12>>2]-Qf|0;if((Nf|0)<1){break c}Rf=Pf,Sf=Cn(Of,Qf,Nf)+Nf|0,q[Rf>>2]=Sf}Nf=q[Mf+36>>2];q[xf+32>>2]=q[Mf+32>>2];q[xf+36>>2]=Nf;Nf=q[Mf+28>>2];q[xf+24>>2]=q[Mf+24>>2];q[xf+28>>2]=Nf;Mf=q[Ye+88>>2];q[Ye+88>>2]=xf;if(!Mf){break b}Ye=q[Mf+8>>2];if(Ye){q[Mf+12>>2]=Ye;An(Ye)}An(Mf);return}xf=Ye+88|0;Ye=q[xf>>2];q[xf>>2]=0;if(!Ye){break b}xf=q[Ye+8>>2];if(xf){q[Ye+12>>2]=xf;An(xf)}An(Ye)}return}bn();F()}function vd(Ye,xf,Tf){var Uf=0,Vf=0,Wf=0,Xf=0,Yf=0,Zf=0,_f=0;a:{Uf=Tf-xf|0;Wf=Uf>>2;Xf=q[Ye+8>>2];Vf=q[Ye>>2];b:{if(Wf>>>0<=Xf-Vf>>2>>>0){Yf=q[Ye+4>>2];Uf=Yf-Vf|0;Xf=Uf>>2;Uf=Wf>>>0>Xf>>>0?xf+Uf|0:Tf;if((Uf|0)!=(xf|0)){while(1){q[Vf>>2]=q[xf>>2];Vf=Vf+4|0;xf=xf+4|0;if((Uf|0)!=(xf|0)){continue}break}}if(Wf>>>0>Xf>>>0){xf=Tf-Uf|0;if((xf|0)<1){break b}Cn(Yf,Uf,xf);Ye=Ye+4|0;q[Ye>>2]=xf+q[Ye>>2];return}q[Ye+4>>2]=Vf;return}if(Vf){q[Ye+4>>2]=Vf;An(Vf);q[Ye+8>>2]=0;q[Ye>>2]=0;q[Ye+4>>2]=0;Xf=0}if(Wf>>>0>=1073741824){break a}Tf=Xf>>1;Tf=Xf>>2>>>0<536870911?Tf>>>0<Wf>>>0?Wf:Tf:1073741823;if(Tf>>>0>=1073741824){break a}Vf=Tf<<2;Tf=Mm(Vf);q[Ye>>2]=Tf;Wf=Ye+4|0;q[Wf>>2]=Tf;q[Ye+8>>2]=Tf+Vf;if((Uf|0)<1){break b}Zf=Wf,_f=Cn(Tf,xf,Uf)+Uf|0,q[Zf>>2]=_f}return}bn();F()}function wd(Ye){q[Ye>>2]=1384;q[Ye+4>>2]=0;q[Ye+8>>2]=0;q[Ye+12>>2]=0;q[Ye+16>>2]=0;q[Ye+20>>2]=0;q[Ye+24>>2]=0;q[Ye+28>>2]=0;q[Ye+32>>2]=0}function xd(Ye,xf,Tf){Ye=Ye|0;xf=xf|0;Tf=Tf|0;q[Ye+32>>2]=Tf;q[Ye+28>>2]=xf;return 1}function yd(Ye,xf){Ye=Ye|0;xf=xf|0;var Tf=0,$f=0,ag=0,bg=0,cg=0,dg=0,eg=0,fg=0,gg=0,hg=0,ig=0,jg=0,kg=0,lg=0,mg=0,ng=0,og=0;cg=T-96|0;T=cg;a:{b:{if(r[q[Ye+28>>2]+36|0]<=1){eg=q[xf+12>>2];Tf=q[xf+20>>2];bg=q[xf+16>>2];$f=bg+4|0;if($f>>>0<4){Tf=Tf+1|0}dg=$f;$f=Tf;if((eg|0)<(Tf|0)?1:(eg|0)<=(Tf|0)?t[xf+8>>2]>=dg>>>0?0:1:0){break a}Tf=bg+q[xf>>2]|0;eg=r[Tf|0]|r[Tf+1|0]<<8|(r[Tf+2|0]<<16|r[Tf+3|0]<<24);q[cg+92>>2]=eg;q[xf+16>>2]=dg;q[xf+20>>2]=$f;break b}if(!zd(1,cg+92|0,xf)){break a}eg=q[cg+92>>2]}if(!eg){break a}$f=q[Ye+4>>2];Tf=q[Ye+8>>2]-$f>>2;c:{if(eg>>>0>Tf>>>0){Fa(Ye+4|0,eg-Tf|0);break c}if(eg>>>0>=Tf>>>0){break c}q[Ye+8>>2]=$f+(eg<<2)}lg=Ye+16|0;mg=q[Ye+32>>2];ng=Ye+20|0;while(1){gg=q[xf+8>>2];dg=q[xf+16>>2];bg=q[xf+12>>2];$f=bg;Tf=q[xf+20>>2];if(($f|0)<(Tf|0)?1:($f|0)<=(Tf|0)?gg>>>0>dg>>>0?0:1:0){ag=0;break a}ig=q[xf>>2];og=r[ig+dg|0];$f=Tf;fg=dg+1|0;if(fg>>>0<1){$f=$f+1|0}ag=xf;q[xf+16>>2]=fg;q[xf+20>>2]=$f;if((bg|0)<($f|0)?1:(bg|0)<=($f|0)?gg>>>0>fg>>>0?0:1:0){ag=0;break a}fg=r[fg+ig|0];$f=Tf;hg=dg+2|0;if(hg>>>0<2){$f=$f+1|0}q[xf+16>>2]=hg;q[ag+20>>2]=$f;if((bg|0)<($f|0)?1:(bg|0)<=($f|0)?gg>>>0>hg>>>0?0:1:0){ag=0;break a}hg=r[hg+ig|0];$f=Tf;jg=dg+3|0;if(jg>>>0<3){$f=$f+1|0}q[xf+16>>2]=jg;q[ag+20>>2]=$f;if((bg|0)<($f|0)?1:(bg|0)<=($f|0)?gg>>>0>jg>>>0?0:1:0){ag=0;break a}bg=r[jg+ig|0];$f=Tf;Tf=dg+4|0;if(Tf>>>0<4){$f=$f+1|0}q[xf+16>>2]=Tf;q[ag+20>>2]=$f;if(og>>>0>4){ag=0;break a}if((fg+ -1&255)>>>0>10){ag=0;break a}dg=nd(cg+24|0);Tf=w(bk(fg),hg);od(dg,og,hg<<24>>24,fg,(bg|0)!=0,Tf,Tf>>31);d:{Tf=s[q[Ye+28>>2]+36>>1];e:{if((Tf<<24|Tf<<8&16711680)>>>16>>>0<=258){ag=q[xf+12>>2];$f=q[xf+20>>2];bg=q[xf+16>>2];Tf=bg+2|0;if(Tf>>>0<2){$f=$f+1|0}gg=Tf;Tf=$f;if((ag|0)<(Tf|0)?1:(ag|0)<=(Tf|0)?t[xf+8>>2]>=gg>>>0?0:1:0){break d}$f=bg+q[xf>>2]|0;$f=r[$f|0]|r[$f+1|0]<<8;q[xf+16>>2]=gg;q[xf+20>>2]=Tf;q[cg+20>>2]=$f;break e}zd(1,cg+20|0,xf);$f=q[cg+20>>2]}q[cg+84>>2]=$f;Tf=Mm(96);sd(Tf,dg);q[cg+16>>2]=Tf;Tf=fl(mg,cg+16|0);ag=q[cg+16>>2];q[cg+16>>2]=0;if(ag){Hb(ag)}bg=Tf<<2;q[q[bg+q[mg+8>>2]>>2]+60>>2]=$f;q[q[Ye+4>>2]+(kg<<2)>>2]=Tf;$f=q[Ye+16>>2];ag=q[ng>>2]-$f>>2;f:{if((Tf|0)<(ag|0)){break f}q[cg+12>>2]=-1;Tf=Tf+1|0;if(Tf>>>0>ag>>>0){Ad(lg,Tf-ag|0,cg+12|0);$f=q[lg>>2];break f}if(Tf>>>0>=ag>>>0){break f}q[ng>>2]=(Tf<<2)+$f}q[$f+bg>>2]=kg;ag=1;kg=kg+1|0;if((kg|0)!=(eg|0)){continue}break a}break}ag=0}T=cg+96|0;return ag|0}function zd(Ye,xf,pg){var qg=0,rg=0,sg=0,tg=0;a:{if(Ye>>>0>5){break a}sg=q[pg+16>>2];qg=q[pg+12>>2];rg=q[pg+20>>2];if((qg|0)<(rg|0)?1:(qg|0)<=(rg|0)?t[pg+8>>2]>sg>>>0?0:1:0){break a}qg=r[sg+q[pg>>2]|0];sg=sg+1|0;if(sg>>>0<1){rg=rg+1|0}q[pg+16>>2]=sg;q[pg+20>>2]=rg;rg=xf;if(qg&128){if(!zd(Ye+1|0,xf,pg)){break a}Ye=q[xf>>2]<<7;q[xf>>2]=Ye;qg=Ye|qg&127}q[rg>>2]=qg;tg=1}return tg}function Ad(Ye,xf,pg){var ug=0,vg=0,wg=0,xg=0,yg=0,zg=0;wg=q[Ye+8>>2];ug=q[Ye+4>>2];if(wg-ug>>2>>>0>=xf>>>0){while(1){q[ug>>2]=q[pg>>2];ug=ug+4|0;xf=xf+ -1|0;if(xf){continue}break}q[Ye+4>>2]=ug;return}a:{xg=q[Ye>>2];yg=ug-xg|0;zg=yg>>2;ug=zg+xf|0;if(ug>>>0<1073741824){wg=wg-xg|0;vg=wg>>1;ug=wg>>2>>>0<536870911?vg>>>0<ug>>>0?ug:vg:1073741823;vg=0;b:{if(!ug){break b}if(ug>>>0>=1073741824){break a}vg=Mm(ug<<2)}wg=vg+(ug<<2)|0;ug=vg+(zg<<2)|0;while(1){q[ug>>2]=q[pg>>2];ug=ug+4|0;xf=xf+ -1|0;if(xf){continue}break}if((yg|0)>=1){Cn(vg,xg,yg)}q[Ye>>2]=vg;q[Ye+8>>2]=wg;q[Ye+4>>2]=ug;if(xg){An(xg)}return}bn();F()}ab(1520);F()}function Bd(Ye){Ye=Ye|0;var xf=0;q[Ye>>2]=1384;xf=q[Ye+16>>2];if(xf){q[Ye+20>>2]=xf;An(xf)}xf=q[Ye+4>>2];if(xf){q[Ye+8>>2]=xf;An(xf)}return Ye|0}function Cd(q){q=q|0;F()}function Dd(Ye,pg){Ye=Ye|0;pg=pg|0;var Ag=0;a:{if(!n[q[q[Ye>>2]+36>>2]](Ye,pg)){break a}if(!n[q[q[Ye>>2]+40>>2]](Ye,pg)){break a}Ag=n[q[q[Ye>>2]+44>>2]](Ye)|0}return Ag|0}function Ed(Ye,pg){Ye=Ye|0;pg=pg|0;return q[q[Ye+4>>2]+(pg<<2)>>2]}function Fd(Ye){Ye=Ye|0;return q[Ye+8>>2]-q[Ye+4>>2]>>2}function Gd(q,Ye){q=q|0;Ye=Ye|0;return 0}function Hd(q,Ye){q=q|0;Ye=Ye|0;return 1}function Id(Ye){wd(Ye);q[Ye+36>>2]=0;q[Ye+40>>2]=0;q[Ye>>2]=1596;q[Ye+44>>2]=0;q[Ye+48>>2]=0;q[Ye+52>>2]=0;q[Ye+56>>2]=0;q[Ye+60>>2]=0;q[Ye+64>>2]=0;q[Ye+68>>2]=0}function Jd(Ye,pg){Ye=Ye|0;pg=pg|0;var Bg=0,Cg=0,Dg=0,Eg=0,Fg=0,Gg=0,Hg=0,Ig=0,Jg=0,Kg=0,Lg=0,Mg=0,Ng=0,Og=0,Pg=0,Qg=0;Cg=T-704|0;T=Cg;Dg=1;a:{b:{if(s[pg+38>>1]<515){break b}Dg=0;Eg=q[pg+16>>2];Hg=q[pg+12>>2];Bg=q[pg+20>>2];if((Hg|0)<(Bg|0)?1:(Hg|0)<=(Bg|0)?t[pg+8>>2]>Eg>>>0?0:1:0){break b}Jg=r[Eg+q[pg>>2]|0];Eg=Eg+1|0;if(Eg>>>0<1){Bg=Bg+1|0}q[pg+16>>2]=Eg;q[pg+20>>2]=Bg;Kg=q[q[(n[q[q[Ye>>2]+28>>2]](Ye)|0)+4>>2]+80>>2];Bg=n[q[q[Ye>>2]+24>>2]](Ye)|0;q[Cg+696>>2]=0;q[Cg+688>>2]=0;q[Cg+692>>2]=0;if(Bg){if(Bg>>>0>=214748365){break a}Eg=w(Bg,20);Dg=Mm(Eg);q[Cg+688>>2]=Dg;q[Cg+692>>2]=Dg;q[Cg+696>>2]=Dg+Eg;Dn(Dg,0,Eg);while(1){Dg=Dg+20|0;Bg=Bg+ -1|0;if(Bg){continue}break}q[Cg+692>>2]=Dg}Ng=Ye+48|0;Og=Ye+60|0;Pg=Ye+56|0;Lg=Ye+52|0;Qg=Ye+68|0;Hg=Ye- -64|0;c:{while(1){if((Ig|0)<(n[q[q[Ye>>2]+24>>2]](Ye)|0)){Bg=n[q[q[Ye>>2]+20>>2]](Ye,Ig)|0;Eg=q[q[q[(n[q[q[Ye>>2]+28>>2]](Ye)|0)+4>>2]+8>>2]+(Bg<<2)>>2];td(Eg,Kg);o[Eg+84|0]=1;q[Eg+72>>2]=q[Eg+68>>2];Dg=0;Bg=q[Eg+28>>2];if(Bg>>>0>9){break c}d:{e:{f:{Fg=1<<Bg;if(!(Fg&42)){if(Fg&84){break d}if((Bg|0)!=9){break c}Bg=o[Eg+24|0];Dg=nd(Cg);Fg=q[Eg+56>>2];Eg=Bg;Bg=w(bk(6),Bg);od(Dg,Fg,Eg,6,0,Bg,Bg>>31);Bg=Mm(96);sd(Bg,Dg);q[Cg+656>>2]=Bg;o[Bg+84|0]=1;q[Bg+72>>2]=q[Bg+68>>2];td(Bg,Kg);Bg=q[Hg>>2];if(Bg>>>0>=t[Qg>>2]){break f}Dg=q[Cg+656>>2];q[Cg+656>>2]=0;q[Bg>>2]=Dg;Bg=Bg+4|0;q[Hg>>2]=Bg;break e}Bg=0;Fg=Eg+24|0;if(o[Fg|0]<=0){break d}while(1){q[Cg>>2]=0;Dg=q[Lg>>2];g:{if(Dg>>>0<t[Pg>>2]){q[Dg>>2]=0;q[Lg>>2]=Dg+4;break g}ya(Ng,Cg)}Bg=Bg+1|0;if((Bg|0)<o[Fg|0]){continue}break}break d}Kd(Og,Cg+656|0);Bg=q[Hg>>2]}Eg=q[Bg+ -4>>2];Bg=q[Cg+656>>2];q[Cg+656>>2]=0;if(!Bg){break d}Hb(Bg)}Fg=q[Eg+28>>2];Dg=bk(Fg);Bg=q[Cg+688>>2]+w(Ig,20)|0;Mg=o[Eg+24|0];q[Bg+16>>2]=Mg;q[Bg+12>>2]=(Dg|0)>0?Dg:0;q[Bg+8>>2]=Fg;q[Bg+4>>2]=Gg;q[Bg>>2]=Eg;Ig=Ig+1|0;Gg=Gg+Mg|0;continue}break}Dg=0;Ye=Ld(Cg+656|0,Cg+688|0);h:{if(Jg>>>0>6){break h}i:{j:{switch(Jg-1|0){default:Bg=Od(Cg,Gg);pg=Md(Bg,pg,Ye);Nd(Bg);if(pg){break i}break h;case 0:Bg=Od(Cg,Gg);pg=Pd(Bg,pg,Ye);Nd(Bg);if(pg){break i}break h;case 1:Bg=Sd(Cg,Gg);pg=Qd(Bg,pg,Ye);Rd(Bg);if(pg){break i}break h;case 2:Bg=Sd(Cg,Gg);pg=Td(Bg,pg,Ye);Rd(Bg);if(pg){break i}break h;case 3:Bg=Wd(Cg,Gg);pg=Ud(Bg,pg,Ye);Vd(Bg);if(pg){break i}break h;case 4:Bg=Wd(Cg,Gg);pg=Xd(Bg,pg,Ye);Vd(Bg);if(pg){break i}break h;case 5:break j}}Bg=Wd(Cg,Gg);pg=Yd(Bg,pg,Ye);Vd(Bg);if(!pg){break h}}Dg=1}pg=q[Ye+16>>2];if(pg){q[Ye+20>>2]=pg;An(pg)}pg=q[Ye>>2];if(!pg){break c}q[Ye+4>>2]=pg;An(pg)}Ye=q[Cg+688>>2];if(!Ye){break b}q[Cg+692>>2]=Ye;An(Ye)}T=Cg+704|0;return Dg|0}bn();F()}function Kd(Ye,pg){var Rg=0,Sg=0,Tg=0,Ug=0,Vg=0;a:{b:{c:{Tg=q[Ye>>2];Ug=q[Ye+4>>2]-Tg>>2;Rg=Ug+1|0;if(Rg>>>0<1073741824){Tg=q[Ye+8>>2]-Tg|0;Vg=Tg>>1;Rg=Tg>>2>>>0<536870911?Vg>>>0<Rg>>>0?Rg:Vg:1073741823;if(Rg){if(Rg>>>0>=1073741824){break c}Sg=Mm(Rg<<2)}Tg=q[pg>>2];q[pg>>2]=0;pg=(Ug<<2)+Sg|0;q[pg>>2]=Tg;Tg=(Rg<<2)+Sg|0;Ug=pg+4|0;Rg=q[Ye+4>>2];Sg=q[Ye>>2];if((Rg|0)==(Sg|0)){break b}while(1){Rg=Rg+ -4|0;Vg=q[Rg>>2];q[Rg>>2]=0;pg=pg+ -4|0;q[pg>>2]=Vg;if((Rg|0)!=(Sg|0)){continue}break}Sg=q[Ye+4>>2];Rg=q[Ye>>2];break a}bn();F()}ab(1780);F()}Rg=Sg}q[Ye>>2]=pg;q[Ye+8>>2]=Tg;q[Ye+4>>2]=Ug;if((Rg|0)!=(Sg|0)){while(1){Sg=Sg+ -4|0;Ye=q[Sg>>2];q[Sg>>2]=0;if(Ye){Hb(Ye)}if((Rg|0)!=(Sg|0)){continue}break}}if(Rg){An(Rg)}}function Ld(Ye,pg){var Wg=0,Xg=0,Yg=0,Zg=0,_g=0;q[Ye+16>>2]=0;q[Ye+20>>2]=0;q[Ye>>2]=0;q[Ye+4>>2]=0;q[Ye+24>>2]=0;q[Ye+8>>2]=0;Wg=q[pg+4>>2]-q[pg>>2]|0;Yg=(Wg|0)/20|0;a:{b:{if(Wg){if(Yg>>>0>=214748365){break a}Wg=Mm(Wg);q[Ye+16>>2]=Wg;Xg=Ye+20|0;q[Xg>>2]=Wg;q[Ye+24>>2]=Wg+w(Yg,20);Yg=q[pg>>2];pg=q[pg+4>>2]-Yg|0;if((pg|0)>0){break b}}q[Ye+28>>2]=0;q[Ye+12>>2]=0;return Ye}Yg=Cn(Wg,Yg,pg);q[Ye+28>>2]=0;_g=Xg;Xg=w((pg>>>0)/20|0,20);Wg=Xg+Yg|0;q[_g>>2]=Wg;pg=0;_g=Ye;if(Xg){Wg=(Wg-Yg|0)/20|0;Xg=0;while(1){Zg=w(Xg,20)+Yg|0;Zg=w(q[Zg+16>>2],q[Zg+12>>2]);pg=pg>>>0<Zg>>>0?Zg:pg;Xg=Xg+1|0;if(Xg>>>0<Wg>>>0){continue}break}if(!pg){q[Ye+12>>2]=0;return Ye}Ha(Ye,pg);pg=q[Ye>>2]}else{pg=0}q[_g+12>>2]=pg;return Ye}bn();F()}function Md(Ye,pg,ah){var bh=0,ch=0,dh=0,eh=0,fh=0,gh=0;ch=q[pg+12>>2];a:{dh=q[pg+20>>2];eh=q[pg+16>>2];bh=eh+4|0;if(bh>>>0<4){dh=dh+1|0}if((ch|0)<(dh|0)?1:(ch|0)<=(dh|0)?t[pg+8>>2]>=bh>>>0?0:1:0){break a}bh=eh+q[pg>>2]|0;bh=r[bh|0]|r[bh+1|0]<<8|(r[bh+2|0]<<16|r[bh+3|0]<<24);q[Ye>>2]=bh;ch=q[pg+20>>2];eh=ch;fh=q[pg+16>>2];dh=fh+4|0;if(dh>>>0<4){ch=ch+1|0}q[pg+16>>2]=dh;q[pg+20>>2]=ch;if(bh>>>0>32){break a}ch=q[pg+12>>2];bh=fh+8|0;if(bh>>>0<8){eh=eh+1|0}if((ch|0)<(eh|0)?1:(ch|0)<=(eh|0)?t[pg+8>>2]>=bh>>>0?0:1:0){break a}bh=dh+q[pg>>2]|0;ch=r[bh|0]|r[bh+1|0]<<8|(r[bh+2|0]<<16|r[bh+3|0]<<24);q[Ye+4>>2]=ch;dh=q[pg+20>>2];eh=q[pg+16>>2]+4|0;if(eh>>>0<4){dh=dh+1|0}q[pg+16>>2]=eh;q[pg+20>>2]=dh;if(!ch){gh=1;break a}q[Ye+8>>2]=0;if(!$g(Ye+16|0,pg)){break a}if(!$g(Ye+36|0,pg)){break a}if(!$g(Ye+56|0,pg)){break a}if(!$g(Ye+76|0,pg)){break a}return Zd(Ye,q[Ye+4>>2],ah)}return gh}function Nd(Ye){var pg=0,$g=0,ah=0,hh=0,ih=0;ah=q[Ye+132>>2];if(ah){ih=Ye+136|0;pg=q[ih>>2];$g=ah;a:{if((ah|0)==(pg|0)){break a}while(1){$g=pg+ -12|0;hh=q[$g>>2];if(hh){q[pg+ -8>>2]=hh;An(hh)}pg=$g;if((pg|0)!=(ah|0)){continue}break}$g=q[Ye+132>>2]}q[ih>>2]=ah;An($g)}ah=q[Ye+120>>2];if(ah){ih=Ye+124|0;pg=q[ih>>2];$g=ah;b:{if((ah|0)==(pg|0)){break b}while(1){$g=pg+ -12|0;hh=q[$g>>2];if(hh){q[pg+ -8>>2]=hh;An(hh)}pg=$g;if((pg|0)!=(ah|0)){continue}break}$g=q[Ye+120>>2]}q[ih>>2]=ah;An($g)}pg=q[Ye+108>>2];if(pg){q[Ye+112>>2]=pg;An(pg)}pg=q[Ye+96>>2];if(pg){q[Ye+100>>2]=pg;An(pg)}_g(Ye+76|0);_g(Ye+56|0);_g(Ye+36|0);_g(Ye+16|0)}function Od(Ye,jh){var kh=0,lh=0,mh=0,nh=0;mh=T-16|0;T=mh;q[Ye+12>>2]=jh;q[Ye+8>>2]=0;q[Ye>>2]=0;q[Ye+4>>2]=0;Zg(Ye+16|0);Zg(Ye+36|0);Zg(Ye+56|0);Zg(Ye+76|0);q[Ye+104>>2]=0;q[Ye+96>>2]=0;q[Ye+100>>2]=0;a:{b:{c:{if(jh){if(jh>>>0>=1073741824){break c}kh=jh<<2;lh=Mm(kh);q[Ye+96>>2]=lh;q[Ye+100>>2]=lh;q[Ye+104>>2]=lh+kh;Dn(lh,0,kh);kh=jh;while(1){lh=lh+4|0;kh=kh+ -1|0;if(kh){continue}break}q[Ye+100>>2]=lh}q[Ye+108>>2]=0;q[Ye+112>>2]=0;q[Ye+116>>2]=0;if(jh){if(jh>>>0>=1073741824){break b}kh=jh<<2;lh=Mm(kh);q[Ye+108>>2]=lh;q[Ye+112>>2]=lh;q[Ye+116>>2]=lh+kh;Dn(lh,0,kh);kh=jh;while(1){lh=lh+4|0;kh=kh+ -1|0;if(kh){continue}break}q[Ye+112>>2]=lh}q[mh+8>>2]=0;q[mh>>2]=0;q[mh+4>>2]=0;if(jh){if(jh>>>0>=1073741824){break a}kh=jh<<2;lh=Mm(kh);q[mh>>2]=lh;q[mh+4>>2]=lh;q[mh+8>>2]=lh+kh;Dn(lh,0,kh);kh=jh;while(1){lh=lh+4|0;kh=kh+ -1|0;if(kh){continue}break}q[mh+4>>2]=lh}nh=jh<<5|1;_d(Ye+120|0,nh,mh);kh=q[mh>>2];if(kh){q[mh+4>>2]=kh;An(kh)}q[mh+8>>2]=0;q[mh>>2]=0;q[mh+4>>2]=0;if(jh){if(jh>>>0>=1073741824){break a}kh=jh<<2;lh=Mm(kh);q[mh>>2]=lh;q[mh+4>>2]=lh;q[mh+8>>2]=lh+kh;Dn(lh,0,kh);while(1){lh=lh+4|0;jh=jh+ -1|0;if(jh){continue}break}q[mh+4>>2]=lh}_d(Ye+132|0,nh,mh);jh=q[mh>>2];if(jh){q[mh+4>>2]=jh;An(jh)}T=mh+16|0;return Ye}bn();F()}bn();F()}bn();F()}function Pd(Ye,jh,oh){var ph=0,qh=0,rh=0,sh=0,th=0,uh=0;qh=q[jh+12>>2];a:{rh=q[jh+20>>2];sh=q[jh+16>>2];ph=sh+4|0;if(ph>>>0<4){rh=rh+1|0}if((qh|0)<(rh|0)?1:(qh|0)<=(rh|0)?t[jh+8>>2]>=ph>>>0?0:1:0){break a}ph=sh+q[jh>>2]|0;ph=r[ph|0]|r[ph+1|0]<<8|(r[ph+2|0]<<16|r[ph+3|0]<<24);q[Ye>>2]=ph;qh=q[jh+20>>2];sh=qh;th=q[jh+16>>2];rh=th+4|0;if(rh>>>0<4){qh=qh+1|0}q[jh+16>>2]=rh;q[jh+20>>2]=qh;if(ph>>>0>32){break a}qh=q[jh+12>>2];ph=th+8|0;if(ph>>>0<8){sh=sh+1|0}if((qh|0)<(sh|0)?1:(qh|0)<=(sh|0)?t[jh+8>>2]>=ph>>>0?0:1:0){break a}ph=rh+q[jh>>2]|0;qh=r[ph|0]|r[ph+1|0]<<8|(r[ph+2|0]<<16|r[ph+3|0]<<24);q[Ye+4>>2]=qh;rh=q[jh+20>>2];sh=q[jh+16>>2]+4|0;if(sh>>>0<4){rh=rh+1|0}q[jh+16>>2]=sh;q[jh+20>>2]=rh;if(!qh){uh=1;break a}q[Ye+8>>2]=0;if(!$g(Ye+16|0,jh)){break a}if(!$g(Ye+36|0,jh)){break a}if(!$g(Ye+56|0,jh)){break a}if(!$g(Ye+76|0,jh)){break a}return $d(Ye,q[Ye+4>>2],oh)}return uh}function Qd(Ye,jh,oh){var vh=0,wh=0,xh=0,yh=0,zh=0,Ah=0;wh=q[jh+12>>2];a:{xh=q[jh+20>>2];yh=q[jh+16>>2];vh=yh+4|0;if(vh>>>0<4){xh=xh+1|0}if((wh|0)<(xh|0)?1:(wh|0)<=(xh|0)?t[jh+8>>2]>=vh>>>0?0:1:0){break a}vh=yh+q[jh>>2]|0;vh=r[vh|0]|r[vh+1|0]<<8|(r[vh+2|0]<<16|r[vh+3|0]<<24);q[Ye>>2]=vh;wh=q[jh+20>>2];yh=wh;zh=q[jh+16>>2];xh=zh+4|0;if(xh>>>0<4){wh=wh+1|0}q[jh+16>>2]=xh;q[jh+20>>2]=wh;if(vh>>>0>32){break a}wh=q[jh+12>>2];vh=zh+8|0;if(vh>>>0<8){yh=yh+1|0}if((wh|0)<(yh|0)?1:(wh|0)<=(yh|0)?t[jh+8>>2]>=vh>>>0?0:1:0){break a}vh=xh+q[jh>>2]|0;wh=r[vh|0]|r[vh+1|0]<<8|(r[vh+2|0]<<16|r[vh+3|0]<<24);q[Ye+4>>2]=wh;xh=q[jh+20>>2];yh=q[jh+16>>2]+4|0;if(yh>>>0<4){xh=xh+1|0}q[jh+16>>2]=yh;q[jh+20>>2]=xh;if(!wh){Ah=1;break a}q[Ye+8>>2]=0;if(!bh(Ye+16|0,jh)){break a}if(!$g(Ye+32|0,jh)){break a}if(!$g(Ye+52|0,jh)){break a}if(!$g(Ye+72|0,jh)){break a}return ae(Ye,q[Ye+4>>2],oh)}return Ah}function Rd(Ye){var jh=0,oh=0,Bh=0,Ch=0,Dh=0;Bh=q[Ye+128>>2];if(Bh){Dh=Ye+132|0;jh=q[Dh>>2];oh=Bh;a:{if((Bh|0)==(jh|0)){break a}while(1){oh=jh+ -12|0;Ch=q[oh>>2];if(Ch){q[jh+ -8>>2]=Ch;An(Ch)}jh=oh;if((jh|0)!=(Bh|0)){continue}break}oh=q[Ye+128>>2]}q[Dh>>2]=Bh;An(oh)}Bh=q[Ye+116>>2];if(Bh){Dh=Ye+120|0;jh=q[Dh>>2];oh=Bh;b:{if((Bh|0)==(jh|0)){break b}while(1){oh=jh+ -12|0;Ch=q[oh>>2];if(Ch){q[jh+ -8>>2]=Ch;An(Ch)}jh=oh;if((jh|0)!=(Bh|0)){continue}break}oh=q[Ye+116>>2]}q[Dh>>2]=Bh;An(oh)}jh=q[Ye+104>>2];if(jh){q[Ye+108>>2]=jh;An(jh)}jh=q[Ye+92>>2];if(jh){q[Ye+96>>2]=jh;An(jh)}_g(Ye+72|0);_g(Ye+52|0);_g(Ye+32|0)}function Sd(Ye,Eh){var Fh=0,Gh=0,Hh=0,Ih=0;Hh=T-16|0;T=Hh;q[Ye+12>>2]=Eh;q[Ye+8>>2]=0;q[Ye>>2]=0;q[Ye+4>>2]=0;ah(Ye+16|0);Zg(Ye+32|0);Zg(Ye+52|0);Zg(Ye+72|0);q[Ye+100>>2]=0;q[Ye+92>>2]=0;q[Ye+96>>2]=0;a:{b:{c:{if(Eh){if(Eh>>>0>=1073741824){break c}Fh=Eh<<2;Gh=Mm(Fh);q[Ye+92>>2]=Gh;q[Ye+96>>2]=Gh;q[Ye+100>>2]=Gh+Fh;Dn(Gh,0,Fh);Fh=Eh;while(1){Gh=Gh+4|0;Fh=Fh+ -1|0;if(Fh){continue}break}q[Ye+96>>2]=Gh}q[Ye+104>>2]=0;q[Ye+108>>2]=0;q[Ye+112>>2]=0;if(Eh){if(Eh>>>0>=1073741824){break b}Fh=Eh<<2;Gh=Mm(Fh);q[Ye+104>>2]=Gh;q[Ye+108>>2]=Gh;q[Ye+112>>2]=Gh+Fh;Dn(Gh,0,Fh);Fh=Eh;while(1){Gh=Gh+4|0;Fh=Fh+ -1|0;if(Fh){continue}break}q[Ye+108>>2]=Gh}q[Hh+8>>2]=0;q[Hh>>2]=0;q[Hh+4>>2]=0;if(Eh){if(Eh>>>0>=1073741824){break a}Fh=Eh<<2;Gh=Mm(Fh);q[Hh>>2]=Gh;q[Hh+4>>2]=Gh;q[Hh+8>>2]=Gh+Fh;Dn(Gh,0,Fh);Fh=Eh;while(1){Gh=Gh+4|0;Fh=Fh+ -1|0;if(Fh){continue}break}q[Hh+4>>2]=Gh}Ih=Eh<<5|1;_d(Ye+116|0,Ih,Hh);Fh=q[Hh>>2];if(Fh){q[Hh+4>>2]=Fh;An(Fh)}q[Hh+8>>2]=0;q[Hh>>2]=0;q[Hh+4>>2]=0;if(Eh){if(Eh>>>0>=1073741824){break a}Fh=Eh<<2;Gh=Mm(Fh);q[Hh>>2]=Gh;q[Hh+4>>2]=Gh;q[Hh+8>>2]=Gh+Fh;Dn(Gh,0,Fh);while(1){Gh=Gh+4|0;Eh=Eh+ -1|0;if(Eh){continue}break}q[Hh+4>>2]=Gh}_d(Ye+128|0,Ih,Hh);Eh=q[Hh>>2];if(Eh){q[Hh+4>>2]=Eh;An(Eh)}T=Hh+16|0;return Ye}bn();F()}bn();F()}bn();F()}function Td(Ye,Eh,Jh){var Kh=0,Lh=0,Mh=0,Nh=0,Oh=0,Ph=0;Lh=q[Eh+12>>2];a:{Mh=q[Eh+20>>2];Nh=q[Eh+16>>2];Kh=Nh+4|0;if(Kh>>>0<4){Mh=Mh+1|0}if((Lh|0)<(Mh|0)?1:(Lh|0)<=(Mh|0)?t[Eh+8>>2]>=Kh>>>0?0:1:0){break a}Kh=Nh+q[Eh>>2]|0;Kh=r[Kh|0]|r[Kh+1|0]<<8|(r[Kh+2|0]<<16|r[Kh+3|0]<<24);q[Ye>>2]=Kh;Lh=q[Eh+20>>2];Nh=Lh;Oh=q[Eh+16>>2];Mh=Oh+4|0;if(Mh>>>0<4){Lh=Lh+1|0}q[Eh+16>>2]=Mh;q[Eh+20>>2]=Lh;if(Kh>>>0>32){break a}Lh=q[Eh+12>>2];Kh=Oh+8|0;if(Kh>>>0<8){Nh=Nh+1|0}if((Lh|0)<(Nh|0)?1:(Lh|0)<=(Nh|0)?t[Eh+8>>2]>=Kh>>>0?0:1:0){break a}Kh=Mh+q[Eh>>2]|0;Lh=r[Kh|0]|r[Kh+1|0]<<8|(r[Kh+2|0]<<16|r[Kh+3|0]<<24);q[Ye+4>>2]=Lh;Mh=q[Eh+20>>2];Nh=q[Eh+16>>2]+4|0;if(Nh>>>0<4){Mh=Mh+1|0}q[Eh+16>>2]=Nh;q[Eh+20>>2]=Mh;if(!Lh){Ph=1;break a}q[Ye+8>>2]=0;if(!bh(Ye+16|0,Eh)){break a}if(!$g(Ye+32|0,Eh)){break a}if(!$g(Ye+52|0,Eh)){break a}if(!$g(Ye+72|0,Eh)){break a}return be(Ye,q[Ye+4>>2],Jh)}return Ph}function Ud(Ye,Eh,Jh){var Qh=0,Rh=0,Sh=0,Th=0,Uh=0,Vh=0;Rh=q[Eh+12>>2];a:{Sh=q[Eh+20>>2];Th=q[Eh+16>>2];Qh=Th+4|0;if(Qh>>>0<4){Sh=Sh+1|0}if((Rh|0)<(Sh|0)?1:(Rh|0)<=(Sh|0)?t[Eh+8>>2]>=Qh>>>0?0:1:0){break a}Qh=Th+q[Eh>>2]|0;Qh=r[Qh|0]|r[Qh+1|0]<<8|(r[Qh+2|0]<<16|r[Qh+3|0]<<24);q[Ye>>2]=Qh;Rh=q[Eh+20>>2];Th=Rh;Uh=q[Eh+16>>2];Sh=Uh+4|0;if(Sh>>>0<4){Rh=Rh+1|0}q[Eh+16>>2]=Sh;q[Eh+20>>2]=Rh;if(Qh>>>0>32){break a}Rh=q[Eh+12>>2];Qh=Uh+8|0;if(Qh>>>0<8){Th=Th+1|0}if((Rh|0)<(Th|0)?1:(Rh|0)<=(Th|0)?t[Eh+8>>2]>=Qh>>>0?0:1:0){break a}Qh=Sh+q[Eh>>2]|0;Rh=r[Qh|0]|r[Qh+1|0]<<8|(r[Qh+2|0]<<16|r[Qh+3|0]<<24);q[Ye+4>>2]=Rh;Sh=q[Eh+20>>2];Th=q[Eh+16>>2]+4|0;if(Th>>>0<4){Sh=Sh+1|0}q[Eh+16>>2]=Th;q[Eh+20>>2]=Sh;if(!Rh){Vh=1;break a}q[Ye+8>>2]=0;Qh=0;while(1){if(!bh(((Qh<<4)+Ye|0)+16|0,Eh)){break a}Qh=Qh+1|0;if((Qh|0)!=32){continue}break}if(!bh(Ye+528|0,Eh)){break a}if(!$g(Ye+544|0,Eh)){break a}if(!$g(Ye+564|0,Eh)){break a}if(!$g(Ye+584|0,Eh)){break a}return ce(Ye,q[Ye+4>>2],Jh)}return Vh}function Vd(Ye){var Eh=0,Jh=0,Wh=0,Xh=0,Yh=0;Wh=q[Ye+640>>2];if(Wh){Yh=Ye+644|0;Eh=q[Yh>>2];Jh=Wh;a:{if((Wh|0)==(Eh|0)){break a}while(1){Jh=Eh+ -12|0;Xh=q[Jh>>2];if(Xh){q[Eh+ -8>>2]=Xh;An(Xh)}Eh=Jh;if((Eh|0)!=(Wh|0)){continue}break}Jh=q[Ye+640>>2]}q[Yh>>2]=Wh;An(Jh)}Wh=q[Ye+628>>2];if(Wh){Yh=Ye+632|0;Eh=q[Yh>>2];Jh=Wh;b:{if((Wh|0)==(Eh|0)){break b}while(1){Jh=Eh+ -12|0;Xh=q[Jh>>2];if(Xh){q[Eh+ -8>>2]=Xh;An(Xh)}Eh=Jh;if((Eh|0)!=(Wh|0)){continue}break}Jh=q[Ye+628>>2]}q[Yh>>2]=Wh;An(Jh)}Eh=q[Ye+616>>2];if(Eh){q[Ye+620>>2]=Eh;An(Eh)}Eh=q[Ye+604>>2];if(Eh){q[Ye+608>>2]=Eh;An(Eh)}_g(Ye+584|0);_g(Ye+564|0);_g(Ye+544|0)}function Wd(Ye,Zh){var _h=0,$h=0,ai=0,bi=0;ai=T-16|0;T=ai;q[Ye+12>>2]=Zh;q[Ye+8>>2]=0;q[Ye>>2]=0;q[Ye+4>>2]=0;de(Ye+16|0);ah(Ye+528|0);Zg(Ye+544|0);Zg(Ye+564|0);Zg(Ye+584|0);q[Ye+612>>2]=0;q[Ye+604>>2]=0;q[Ye+608>>2]=0;a:{b:{c:{if(Zh){if(Zh>>>0>=1073741824){break c}_h=Zh<<2;$h=Mm(_h);q[Ye+604>>2]=$h;q[Ye+608>>2]=$h;q[Ye+612>>2]=$h+_h;Dn($h,0,_h);_h=Zh;while(1){$h=$h+4|0;_h=_h+ -1|0;if(_h){continue}break}q[Ye+608>>2]=$h}q[Ye+616>>2]=0;q[Ye+620>>2]=0;q[Ye+624>>2]=0;if(Zh){if(Zh>>>0>=1073741824){break b}_h=Zh<<2;$h=Mm(_h);q[Ye+616>>2]=$h;q[Ye+620>>2]=$h;q[Ye+624>>2]=$h+_h;Dn($h,0,_h);_h=Zh;while(1){$h=$h+4|0;_h=_h+ -1|0;if(_h){continue}break}q[Ye+620>>2]=$h}q[ai+8>>2]=0;q[ai>>2]=0;q[ai+4>>2]=0;if(Zh){if(Zh>>>0>=1073741824){break a}_h=Zh<<2;$h=Mm(_h);q[ai>>2]=$h;q[ai+4>>2]=$h;q[ai+8>>2]=$h+_h;Dn($h,0,_h);_h=Zh;while(1){$h=$h+4|0;_h=_h+ -1|0;if(_h){continue}break}q[ai+4>>2]=$h}bi=Zh<<5|1;_d(Ye+628|0,bi,ai);_h=q[ai>>2];if(_h){q[ai+4>>2]=_h;An(_h)}q[ai+8>>2]=0;q[ai>>2]=0;q[ai+4>>2]=0;if(Zh){if(Zh>>>0>=1073741824){break a}_h=Zh<<2;$h=Mm(_h);q[ai>>2]=$h;q[ai+4>>2]=$h;q[ai+8>>2]=$h+_h;Dn($h,0,_h);while(1){$h=$h+4|0;Zh=Zh+ -1|0;if(Zh){continue}break}q[ai+4>>2]=$h}_d(Ye+640|0,bi,ai);Zh=q[ai>>2];if(Zh){q[ai+4>>2]=Zh;An(Zh)}T=ai+16|0;return Ye}bn();F()}bn();F()}bn();F()}function Xd(Ye,Zh,ci){var di=0,ei=0,fi=0,gi=0,hi=0,ii=0;ei=q[Zh+12>>2];a:{fi=q[Zh+20>>2];gi=q[Zh+16>>2];di=gi+4|0;if(di>>>0<4){fi=fi+1|0}if((ei|0)<(fi|0)?1:(ei|0)<=(fi|0)?t[Zh+8>>2]>=di>>>0?0:1:0){break a}di=gi+q[Zh>>2]|0;di=r[di|0]|r[di+1|0]<<8|(r[di+2|0]<<16|r[di+3|0]<<24);q[Ye>>2]=di;ei=q[Zh+20>>2];gi=ei;hi=q[Zh+16>>2];fi=hi+4|0;if(fi>>>0<4){ei=ei+1|0}q[Zh+16>>2]=fi;q[Zh+20>>2]=ei;if(di>>>0>32){break a}ei=q[Zh+12>>2];di=hi+8|0;if(di>>>0<8){gi=gi+1|0}if((ei|0)<(gi|0)?1:(ei|0)<=(gi|0)?t[Zh+8>>2]>=di>>>0?0:1:0){break a}di=fi+q[Zh>>2]|0;ei=r[di|0]|r[di+1|0]<<8|(r[di+2|0]<<16|r[di+3|0]<<24);q[Ye+4>>2]=ei;fi=q[Zh+20>>2];gi=q[Zh+16>>2]+4|0;if(gi>>>0<4){fi=fi+1|0}q[Zh+16>>2]=gi;q[Zh+20>>2]=fi;if(!ei){ii=1;break a}q[Ye+8>>2]=0;di=0;while(1){if(!bh(((di<<4)+Ye|0)+16|0,Zh)){break a}di=di+1|0;if((di|0)!=32){continue}break}if(!bh(Ye+528|0,Zh)){break a}if(!$g(Ye+544|0,Zh)){break a}if(!$g(Ye+564|0,Zh)){break a}if(!$g(Ye+584|0,Zh)){break a}return ee(Ye,q[Ye+4>>2],ci)}return ii}function Yd(Ye,Zh,ci){var ji=0,ki=0,li=0,mi=0,ni=0,oi=0;ki=q[Zh+12>>2];a:{li=q[Zh+20>>2];mi=q[Zh+16>>2];ji=mi+4|0;if(ji>>>0<4){li=li+1|0}if((ki|0)<(li|0)?1:(ki|0)<=(li|0)?t[Zh+8>>2]>=ji>>>0?0:1:0){break a}ji=mi+q[Zh>>2]|0;ji=r[ji|0]|r[ji+1|0]<<8|(r[ji+2|0]<<16|r[ji+3|0]<<24);q[Ye>>2]=ji;ki=q[Zh+20>>2];mi=ki;ni=q[Zh+16>>2];li=ni+4|0;if(li>>>0<4){ki=ki+1|0}q[Zh+16>>2]=li;q[Zh+20>>2]=ki;if(ji>>>0>32){break a}ki=q[Zh+12>>2];ji=ni+8|0;if(ji>>>0<8){mi=mi+1|0}if((ki|0)<(mi|0)?1:(ki|0)<=(mi|0)?t[Zh+8>>2]>=ji>>>0?0:1:0){break a}ji=li+q[Zh>>2]|0;ki=r[ji|0]|r[ji+1|0]<<8|(r[ji+2|0]<<16|r[ji+3|0]<<24);q[Ye+4>>2]=ki;li=q[Zh+20>>2];mi=q[Zh+16>>2]+4|0;if(mi>>>0<4){li=li+1|0}q[Zh+16>>2]=mi;q[Zh+20>>2]=li;if(!ki){oi=1;break a}q[Ye+8>>2]=0;ji=0;while(1){if(!bh(((ji<<4)+Ye|0)+16|0,Zh)){break a}ji=ji+1|0;if((ji|0)!=32){continue}break}if(!bh(Ye+528|0,Zh)){break a}if(!$g(Ye+544|0,Zh)){break a}if(!$g(Ye+564|0,Zh)){break a}if(!$g(Ye+584|0,Zh)){break a}return fe(Ye,q[Ye+4>>2],ci)}return oi}function Zd(Ye,Zh,ci){var pi=0,qi=0,ri=0,si=0,ti=0,ui=0,vi=0,wi=0,xi=0,yi=0,zi=0,Ai=0,Bi=0,Ci=0,Di=0,Ei=0,Fi=0,Gi=0,Hi=0,Ii=0,Ji=0,Ki=0,Li=0,Mi=0,Ni=0,Oi=0;si=T-32|0;T=si;qi=q[Ye+12>>2];q[si+16>>2]=0;q[si+8>>2]=0;q[si+12>>2]=0;a:{if(qi){if(qi>>>0>=1073741824){break a}pi=qi<<2;ri=Mm(pi);q[si+8>>2]=ri;q[si+12>>2]=ri;q[si+16>>2]=pi+ri;ui=Dn(ri,0,pi);pi=qi;while(1){ui=ui+4|0;pi=pi+ -1|0;if(pi){continue}break}q[si+12>>2]=ui}ti=q[Ye+120>>2];pi=q[ti>>2];if(pi){q[ti+4>>2]=pi;An(pi);q[ti+8>>2]=0;q[ti>>2]=0;q[ti+4>>2]=0;qi=q[Ye+12>>2];ui=q[si+12>>2];ri=q[si+8>>2]}q[ti>>2]=ri;q[ti+4>>2]=ui;q[ti+8>>2]=q[si+16>>2];ui=0;q[si+16>>2]=0;q[si+8>>2]=0;q[si+12>>2]=0;pi=0;b:{if(qi){if(qi>>>0>=1073741824){break b}ri=qi<<2;pi=Mm(ri);q[si+8>>2]=pi;q[si+12>>2]=pi;q[si+16>>2]=pi+ri;ui=Dn(pi,0,ri);while(1){ui=ui+4|0;qi=qi+ -1|0;if(qi){continue}break}q[si+12>>2]=ui}ti=q[Ye+132>>2];ri=q[ti>>2];if(ri){q[ti+4>>2]=ri;An(ri);q[ti+8>>2]=0;q[ti>>2]=0;q[ti+4>>2]=0;ui=q[si+12>>2];pi=q[si+8>>2]}q[ti>>2]=pi;q[ti+4>>2]=ui;q[ti+8>>2]=q[si+16>>2];qi=si+24|0;q[qi>>2]=0;q[qi+4>>2]=0;ri=si+16|0;q[ri>>2]=0;q[ri+4>>2]=0;q[si+8>>2]=0;q[si+12>>2]=0;re(si+8|0);ti=q[si+12>>2];pi=0;c:{if((ti|0)==q[ri>>2]){break c}ri=q[qi>>2]+q[si+28>>2]|0;pi=(ri>>>0)/341|0;pi=q[ti+(pi<<2)>>2]+w(ri-w(pi,341)|0,12)|0}q[pi+4>>2]=0;q[pi+8>>2]=0;q[pi>>2]=Zh;pi=1;ri=q[si+28>>2];qi=ri+1|0;q[si+28>>2]=qi;d:{if(qi>>>0<ri>>>0){break d}Li=Ye+132|0;Ki=Ye+120|0;Gi=ci+20|0;Mi=Ye+108|0;Ni=Ye+96|0;Hi=Ye+48|0;Ii=Ye+28|0;Oi=Ye+80|0;while(1){pi=q[si+12>>2];vi=q[si+24>>2];wi=qi+ -1|0;ti=vi+wi|0;ri=(ti>>>0)/341|0;ri=q[pi+(ri<<2)>>2]+w(ti-w(ri,341)|0,12)|0;Ai=q[ri+8>>2];ti=q[ri+4>>2];zi=q[ri>>2];q[si+28>>2]=wi;ri=q[si+16>>2];pi=ri-pi|0;if(((pi?w(pi>>2,341)+ -1|0:0)-(qi+vi|0)|0)+1>>>0>=682){An(q[ri+ -4>>2]);q[si+16>>2]=q[si+16>>2]+ -4}pi=0;if(zi>>>0>Zh>>>0){break d}ri=q[Ki>>2];Bi=w(Ai,12);Ei=Bi+q[Li>>2]|0;ui=ml(Ye,Ei,ti);if(ui>>>0>=t[Ye+12>>2]){break d}Fi=ri+Bi|0;e:{f:{Ci=ui<<2;ti=q[Ye>>2]-q[Ci+q[Ei>>2]>>2]|0;if(!ti){if(!zi){break f}xi=0;while(1){ti=0;qi=q[ci+16>>2];g:{if((qi|0)==q[Gi>>2]){break g}while(1){qi=w(ti,20)+qi|0;ri=q[Fi>>2]+(q[qi+4>>2]<<2)|0;yi=q[qi>>2];ui=q[qi+12>>2];h:{if(ui>>>0>3){break h}pi=q[ci+12>>2];vi=qi+16|0;if(!q[vi>>2]){ri=pi;break h}wi=qi+12|0;qi=0;while(1){pi=Cn(pi,(qi<<2)+ri|0,ui);ui=q[wi>>2];pi=pi+ui|0;qi=qi+1|0;if(qi>>>0<t[vi>>2]){continue}break}ri=q[ci+12>>2]}qi=q[ci+28>>2];qi=r[yi+84|0]?qi:q[q[yi+68>>2]+(qi<<2)>>2];if(qi>>>0>=t[yi+80>>2]){break g}pi=q[yi+40>>2];Cn(q[q[yi>>2]>>2]+w(pi,qi)|0,ri,pi);ti=ti+1|0;qi=q[ci+16>>2];if(ti>>>0<(q[Gi>>2]-qi|0)/20>>>0){continue}break}}q[ci+28>>2]=q[ci+28>>2]+1;q[Ye+8>>2]=q[Ye+8>>2]+1;xi=xi+1|0;if((zi|0)!=(xi|0)){continue}break}break f}i:{j:{k:{l:{if(zi>>>0<=2){ri=q[Mi>>2];q[ri>>2]=ui;pi=1;qi=q[Ye+12>>2];if(qi>>>0>1){break l}break i}if(t[Ye+8>>2]>t[Ye+4>>2]){break d}pi=q[Ki>>2];xi=Ai+1|0;yi=w(xi,12);ri=pi+yi|0;if((ri|0)!=(Fi|0)){hd(ri,q[Fi>>2],q[Fi+4>>2]);pi=q[Ki>>2]}pi=Ci+q[pi+yi>>2]|0;q[pi>>2]=q[pi>>2]+(1<<ti+ -1);vi=z(zi)^31;wi=q[Ye+32>>2];ti=32-wi|0;m:{if((vi|0)<=(ti|0)){ti=q[Ii>>2];if((ti|0)==q[Ye+20>>2]){pi=0;break m}pi=q[ti>>2];ri=vi+wi|0;q[Ye+32>>2]=ri;pi=pi<<wi>>>32-vi;if((ri|0)!=32){break m}q[Ye+32>>2]=0;q[Ii>>2]=ti+4;break m}qi=q[Ii>>2];pi=qi+4|0;if((pi|0)==q[Ye+20>>2]){pi=0;break m}ri=q[qi>>2];q[Ii>>2]=pi;pi=vi-ti|0;q[Ye+32>>2]=pi;pi=q[qi+4>>2]>>>32-pi|ri<<wi>>>32-vi}ri=(zi>>>1)-pi|0;pi=zi-ri|0;n:{if((pi|0)==(ri|0)){pi=ri;break n}vi=q[Ye+88>>2];if((vi|0)==q[Oi>>2]){break k}wi=q[vi>>2];qi=q[Ye+92>>2];ti=qi+1|0;q[Ye+92>>2]=ti;qi=wi&-2147483648>>>qi;o:{if((ti|0)==32){q[Ye+92>>2]=0;q[Ye+88>>2]=vi+4;if(qi){break o}break k}if(!qi){break k}}}ti=pi;pi=ri;break j}while(1){ui=(qi+ -1|0)==(ui|0)?0:ui+1|0;q[ri+(pi<<2)>>2]=ui;pi=pi+1|0;qi=q[Ye+12>>2];if(pi>>>0<qi>>>0){continue}break}break i}ti=ri}vi=q[Li>>2];wi=vi+Bi|0;qi=q[wi>>2];ri=qi+Ci|0;q[ri>>2]=q[ri>>2]+1;hd(vi+yi|0,qi,q[wi+4>>2]);if(pi){ri=q[si+28>>2]+q[si+24>>2]|0;vi=q[si+16>>2];qi=q[si+12>>2];wi=vi-qi|0;if((ri|0)==((wi?w(wi>>2,341)+ -1|0:0)|0)){re(si+8|0);qi=q[si+12>>2];vi=q[si+16>>2];ri=q[si+24>>2]+q[si+28>>2]|0}if((qi|0)==(vi|0)){ri=0}else{Ei=qi;qi=(ri>>>0)/341|0;ri=q[Ei+(qi<<2)>>2]+w(ri-w(qi,341)|0,12)|0}q[ri+8>>2]=Ai;q[ri+4>>2]=ui;q[ri>>2]=pi;q[si+28>>2]=q[si+28>>2]+1}if(!ti){break f}pi=q[si+28>>2]+q[si+24>>2]|0;ri=q[si+16>>2];qi=q[si+12>>2];wi=ri-qi|0;if((pi|0)==((wi?w(wi>>2,341)+ -1|0:0)|0)){re(si+8|0);ri=q[si+16>>2];qi=q[si+12>>2];pi=q[si+24>>2]+q[si+28>>2]|0}if((qi|0)==(ri|0)){pi=0}else{ri=(pi>>>0)/341|0;pi=q[(ri<<2)+qi>>2]+w(pi-w(ri,341)|0,12)|0}q[pi+8>>2]=xi;q[pi+4>>2]=ui;q[pi>>2]=ti;qi=q[si+28>>2]+1|0;q[si+28>>2]=qi;break e}if(!zi){break f}Ai=0;while(1){if(qi){ui=q[Ni>>2];xi=q[Mi>>2];vi=q[Fi>>2];wi=q[Ei>>2];qi=0;while(1){Bi=xi+(qi<<2)|0;q[ui+(q[Bi>>2]<<2)>>2]=0;pi=q[Bi>>2]<<2;Di=q[Ye>>2]-q[pi+wi>>2]|0;p:{if(!Di){break p}Ji=pi+ui|0;Ci=q[Ye+52>>2];ti=32-Ci|0;if((Di|0)<=(ti|0)){ri=q[Hi>>2];if((ri|0)==q[Ye+40>>2]){q[Ji>>2]=0;break p}q[Ji>>2]=q[ri>>2]<<Ci>>>32-Di;pi=Di+q[Ye+52>>2]|0;q[Ye+52>>2]=pi;if((pi|0)!=32){break p}q[Ye+52>>2]=0;q[Hi>>2]=ri+4;break p}yi=q[Hi>>2];pi=yi+4|0;if((pi|0)==q[Ye+40>>2]){q[Ji>>2]=0;break p}ri=q[yi>>2];q[Hi>>2]=pi;pi=Di-ti|0;q[Ye+52>>2]=pi;q[Ji>>2]=q[yi+4>>2]>>>32-pi|ri<<Ci>>>32-Di}ri=q[Bi>>2]<<2;pi=ri+ui|0;q[pi>>2]=q[pi>>2]|q[ri+vi>>2];qi=qi+1|0;if(qi>>>0<t[Ye+12>>2]){continue}break}}ti=0;qi=q[ci+16>>2];q:{if((qi|0)==q[Gi>>2]){break q}while(1){qi=w(ti,20)+qi|0;ri=q[Ni>>2]+(q[qi+4>>2]<<2)|0;xi=q[qi>>2];ui=q[qi+12>>2];r:{if(ui>>>0>3){break r}pi=q[ci+12>>2];vi=qi+16|0;if(!q[vi>>2]){ri=pi;break r}wi=qi+12|0;qi=0;while(1){pi=Cn(pi,(qi<<2)+ri|0,ui);ui=q[wi>>2];pi=pi+ui|0;qi=qi+1|0;if(qi>>>0<t[vi>>2]){continue}break}ri=q[ci+12>>2]}qi=q[ci+28>>2];qi=r[xi+84|0]?qi:q[q[xi+68>>2]+(qi<<2)>>2];if(qi>>>0>=t[xi+80>>2]){break q}pi=q[xi+40>>2];Cn(q[q[xi>>2]>>2]+w(pi,qi)|0,ri,pi);ti=ti+1|0;qi=q[ci+16>>2];if(ti>>>0<(q[Gi>>2]-qi|0)/20>>>0){continue}break}}q[ci+28>>2]=q[ci+28>>2]+1;q[Ye+8>>2]=q[Ye+8>>2]+1;Ai=Ai+1|0;if((Ai|0)==(zi|0)){break f}qi=q[Ye+12>>2];continue}}qi=q[si+28>>2]}if(qi){continue}break}pi=1}se(si+8|0);qi=q[si+12>>2];Ye=q[si+16>>2];s:{if((qi|0)==(Ye|0)){break s}while(1){An(q[qi>>2]);qi=qi+4|0;if((Ye|0)!=(qi|0)){continue}break}Zh=q[si+16>>2];Ye=q[si+12>>2];if((Zh|0)==(Ye|0)){break s}q[si+16>>2]=Zh+(((Zh-Ye|0)+ -4>>>2^-1)<<2)}Ye=q[si+8>>2];if(Ye){An(Ye)}T=si+32|0;return pi}bn();F()}bn();F()}function _d(Ye,Zh,ci){var Pi=0,Qi=0,Ri=0,Si=0,Ti=0,Ui=0,Vi=0,Wi=0;q[Ye>>2]=0;q[Ye+4>>2]=0;q[Ye+8>>2]=0;a:{b:{if(Zh){if(Zh>>>0>=357913942){break b}Qi=w(Zh,12);Pi=Mm(Qi);q[Ye>>2]=Pi;Ri=Ye+4|0;q[Ri>>2]=Pi;q[Ye+8>>2]=Pi+Qi;while(1){q[Pi>>2]=0;q[Pi+4>>2]=0;Qi=Pi+8|0;q[Qi>>2]=0;Si=ci+4|0;Ye=q[Si>>2]-q[ci>>2]|0;c:{if(!Ye){break c}Ti=Ye>>2;if(Ti>>>0>=1073741824){break a}Ye=Mm(Ye);q[Pi>>2]=Ye;Ui=Pi+4|0;q[Ui>>2]=Ye;q[Qi>>2]=Ye+(Ti<<2);Qi=q[ci>>2];Pi=q[Si>>2]-Qi|0;if((Pi|0)<1){break c}Vi=Ui,Wi=Cn(Ye,Qi,Pi)+Pi|0,q[Vi>>2]=Wi}Pi=q[Ri>>2]+12|0;q[Ri>>2]=Pi;Zh=Zh+ -1|0;if(Zh){continue}break}}return}bn();F()}bn();F()}function $d(Ye,Zh,ci){var Xi=0,Yi=0,Zi=0,_i=0,$i=0,aj=0,bj=0,cj=0,dj=0,ej=0,fj=0,gj=0,hj=0,ij=0,jj=0,kj=0,lj=0,mj=0,nj=0,oj=0,pj=0,qj=0,rj=0,sj=0,tj=0,uj=0;_i=T-32|0;T=_i;Yi=q[Ye+12>>2];q[_i+16>>2]=0;q[_i+8>>2]=0;q[_i+12>>2]=0;a:{if(Yi){if(Yi>>>0>=1073741824){break a}Xi=Yi<<2;Zi=Mm(Xi);q[_i+8>>2]=Zi;q[_i+12>>2]=Zi;q[_i+16>>2]=Xi+Zi;$i=Dn(Zi,0,Xi);Xi=Yi;while(1){$i=$i+4|0;Xi=Xi+ -1|0;if(Xi){continue}break}q[_i+12>>2]=$i}Xi=q[Ye+120>>2];aj=q[Xi>>2];if(aj){q[Xi+4>>2]=aj;An(aj);q[Xi+8>>2]=0;q[Xi>>2]=0;q[Xi+4>>2]=0;Yi=q[Ye+12>>2];$i=q[_i+12>>2];Zi=q[_i+8>>2]}q[Xi>>2]=Zi;q[Xi+4>>2]=$i;q[Xi+8>>2]=q[_i+16>>2];$i=0;q[_i+16>>2]=0;q[_i+8>>2]=0;q[_i+12>>2]=0;Xi=0;b:{if(Yi){if(Yi>>>0>=1073741824){break b}Zi=Yi<<2;Xi=Mm(Zi);q[_i+8>>2]=Xi;q[_i+12>>2]=Xi;q[_i+16>>2]=Xi+Zi;$i=Dn(Xi,0,Zi);while(1){$i=$i+4|0;Yi=Yi+ -1|0;if(Yi){continue}break}q[_i+12>>2]=$i}Zi=q[Ye+132>>2];aj=q[Zi>>2];if(aj){q[Zi+4>>2]=aj;An(aj);q[Zi+8>>2]=0;q[Zi>>2]=0;q[Zi+4>>2]=0;$i=q[_i+12>>2];Xi=q[_i+8>>2]}q[Zi>>2]=Xi;q[Zi+4>>2]=$i;q[Zi+8>>2]=q[_i+16>>2];Zi=_i+24|0;q[Zi>>2]=0;q[Zi+4>>2]=0;aj=_i+16|0;q[aj>>2]=0;q[aj+4>>2]=0;q[_i+8>>2]=0;q[_i+12>>2]=0;re(_i+8|0);Yi=q[aj>>2];aj=q[_i+12>>2];Xi=0;c:{if((Yi|0)==(aj|0)){break c}Xi=q[Zi>>2]+q[_i+28>>2]|0;Zi=(Xi>>>0)/341|0;Xi=q[aj+(Zi<<2)>>2]+w(Xi-w(Zi,341)|0,12)|0}q[Xi+4>>2]=0;q[Xi+8>>2]=0;q[Xi>>2]=Zh;Zi=1;Xi=q[_i+28>>2];Yi=Xi+1|0;q[_i+28>>2]=Yi;d:{if(Yi>>>0<Xi>>>0){break d}nj=Ye+120|0;oj=Ye+132|0;jj=ci+20|0;pj=Ye+108|0;qj=Ye+96|0;kj=Ye+48|0;lj=Ye+28|0;sj=Ye+80|0;while(1){fj=q[_i+12>>2];Zi=q[_i+24>>2];bj=Yi+ -1|0;Xi=Zi+bj|0;aj=(Xi>>>0)/341|0;Xi=q[fj+(aj<<2)>>2]+w(Xi-w(aj,341)|0,12)|0;ej=q[Xi+8>>2];$i=q[Xi+4>>2];aj=q[Xi>>2];q[_i+28>>2]=bj;Xi=q[_i+16>>2];bj=Xi-fj|0;if(((bj?w(bj>>2,341)+ -1|0:0)-(Yi+Zi|0)|0)+1>>>0>=682){An(q[Xi+ -4>>2]);q[_i+16>>2]=q[_i+16>>2]+ -4}if(aj>>>0>Zh>>>0){Zi=0;break d}Zi=0;Xi=q[Ye+12>>2];$i=($i|0)==(Xi+ -1|0)?0:$i+1|0;if($i>>>0>=Xi>>>0){break d}Xi=q[nj>>2];Yi=w(ej,12);fj=Xi+Yi|0;e:{f:{bj=$i<<2;gj=Yi+q[oj>>2]|0;cj=q[Ye>>2]-q[bj+q[gj>>2]>>2]|0;if(!cj){if(!aj){break f}cj=0;while(1){ej=0;Yi=q[ci+16>>2];g:{if((Yi|0)==q[jj>>2]){break g}while(1){Yi=w(ej,20)+Yi|0;Zi=q[fj>>2]+(q[Yi+4>>2]<<2)|0;bj=q[Yi>>2];$i=q[Yi+12>>2];h:{if($i>>>0>3){break h}Xi=q[ci+12>>2];dj=Yi+16|0;if(!q[dj>>2]){Zi=Xi;break h}gj=Yi+12|0;Yi=0;while(1){Xi=Cn(Xi,(Yi<<2)+Zi|0,$i);$i=q[gj>>2];Xi=Xi+$i|0;Yi=Yi+1|0;if(Yi>>>0<t[dj>>2]){continue}break}Zi=q[ci+12>>2]}Yi=q[ci+28>>2];Yi=r[bj+84|0]?Yi:q[q[bj+68>>2]+(Yi<<2)>>2];if(Yi>>>0>=t[bj+80>>2]){break g}Xi=q[bj+40>>2];Cn(q[q[bj>>2]>>2]+w(Xi,Yi)|0,Zi,Xi);ej=ej+1|0;Yi=q[ci+16>>2];if(ej>>>0<(q[jj>>2]-Yi|0)/20>>>0){continue}break}}q[ci+28>>2]=q[ci+28>>2]+1;q[Ye+8>>2]=q[Ye+8>>2]+1;cj=cj+1|0;if((aj|0)!=(cj|0)){continue}break}break f}i:{j:{k:{l:{if(aj>>>0<=2){Zi=q[pj>>2];q[Zi>>2]=$i;Xi=1;Yi=q[Ye+12>>2];if(Yi>>>0>1){break l}break i}if(t[Ye+8>>2]>t[Ye+4>>2]){break d}Zi=Xi;Xi=Yi+12|0;hd(Zi+Xi|0,q[fj>>2],q[fj+4>>2]);Xi=bj+q[Xi+q[nj>>2]>>2]|0;q[Xi>>2]=q[Xi>>2]+(1<<cj+ -1);Xi=z(aj)^31;Zi=q[Ye+32>>2];cj=32-Zi|0;m:{if((Xi|0)<=(cj|0)){fj=q[lj>>2];if((fj|0)==q[Ye+20>>2]){Zi=0;break m}cj=q[fj>>2];dj=Xi+Zi|0;q[Ye+32>>2]=dj;Zi=cj<<Zi>>>32-Xi;if((dj|0)!=32){break m}q[Ye+32>>2]=0;q[lj>>2]=fj+4;break m}fj=q[lj>>2];dj=fj+4|0;if((dj|0)==q[Ye+20>>2]){Zi=0;break m}gj=q[fj>>2];q[lj>>2]=dj;cj=Xi-cj|0;q[Ye+32>>2]=cj;Zi=q[fj+4>>2]>>>32-cj|gj<<Zi>>>32-Xi}fj=ej+1|0;Xi=(aj>>>1)-Zi|0;Zi=aj-Xi|0;n:{if((Zi|0)==(Xi|0)){Zi=Xi;break n}aj=q[Ye+88>>2];if((aj|0)==q[sj>>2]){break k}cj=q[aj>>2];dj=q[Ye+92>>2];gj=dj+1|0;q[Ye+92>>2]=gj;cj=cj&-2147483648>>>dj;o:{if((gj|0)==32){q[Ye+92>>2]=0;q[Ye+88>>2]=aj+4;if(cj){break o}break k}if(!cj){break k}}}aj=Zi;Zi=Xi;break j}while(1){$i=(Yi+ -1|0)==($i|0)?0:$i+1|0;q[Zi+(Xi<<2)>>2]=$i;Xi=Xi+1|0;Yi=q[Ye+12>>2];if(Xi>>>0<Yi>>>0){continue}break}break i}aj=Xi}hj=bj;Xi=q[oj>>2];Yi=Xi+Yi|0;bj=q[Yi>>2];cj=hj+bj|0;q[cj>>2]=q[cj>>2]+1;hd(Xi+w(fj,12)|0,bj,q[Yi+4>>2]);if(Zi){Xi=q[_i+28>>2]+q[_i+24>>2]|0;bj=q[_i+16>>2];Yi=q[_i+12>>2];cj=bj-Yi|0;if((Xi|0)==((cj?w(cj>>2,341)+ -1|0:0)|0)){re(_i+8|0);bj=q[_i+16>>2];Yi=q[_i+12>>2];Xi=q[_i+24>>2]+q[_i+28>>2]|0}if((Yi|0)==(bj|0)){Xi=0}else{hj=Yi;Yi=(Xi>>>0)/341|0;Xi=q[hj+(Yi<<2)>>2]+w(Xi-w(Yi,341)|0,12)|0}q[Xi+8>>2]=ej;q[Xi+4>>2]=$i;q[Xi>>2]=Zi;q[_i+28>>2]=q[_i+28>>2]+1}if(!aj){break f}Xi=q[_i+28>>2]+q[_i+24>>2]|0;Zi=q[_i+16>>2];Yi=q[_i+12>>2];ej=Zi-Yi|0;if((Xi|0)==((ej?w(ej>>2,341)+ -1|0:0)|0)){re(_i+8|0);Zi=q[_i+16>>2];Yi=q[_i+12>>2];Xi=q[_i+24>>2]+q[_i+28>>2]|0}if((Yi|0)==(Zi|0)){Xi=0}else{Zi=(Xi>>>0)/341|0;Xi=q[(Zi<<2)+Yi>>2]+w(Xi-w(Zi,341)|0,12)|0}q[Xi+8>>2]=fj;q[Xi+4>>2]=$i;q[Xi>>2]=aj;Yi=q[_i+28>>2]+1|0;q[_i+28>>2]=Yi;break e}if(!aj){break f}cj=0;while(1){if(Yi){$i=q[qj>>2];mj=q[pj>>2];tj=q[fj>>2];uj=q[gj>>2];Yi=0;while(1){ej=mj+(Yi<<2)|0;q[$i+(q[ej>>2]<<2)>>2]=0;Zi=q[ej>>2]<<2;Xi=q[Ye>>2]-q[Zi+uj>>2]|0;p:{if(!Xi){break p}Zi=Zi+$i|0;bj=q[Ye+52>>2];ij=32-bj|0;if((Xi|0)<=(ij|0)){dj=q[kj>>2];if((dj|0)==q[Ye+40>>2]){q[Zi>>2]=0;break p}q[Zi>>2]=q[dj>>2]<<bj>>>32-Xi;Xi=Xi+q[Ye+52>>2]|0;q[Ye+52>>2]=Xi;if((Xi|0)!=32){break p}q[Ye+52>>2]=0;q[kj>>2]=dj+4;break p}dj=q[kj>>2];rj=dj+4|0;if((rj|0)==q[Ye+40>>2]){q[Zi>>2]=0;break p}hj=q[dj>>2];q[kj>>2]=rj;ij=Xi-ij|0;q[Ye+52>>2]=ij;q[Zi>>2]=q[dj+4>>2]>>>32-ij|hj<<bj>>>32-Xi}Xi=q[ej>>2]<<2;Zi=Xi+$i|0;q[Zi>>2]=q[Zi>>2]|q[Xi+tj>>2];Yi=Yi+1|0;if(Yi>>>0<t[Ye+12>>2]){continue}break}}ej=0;Yi=q[ci+16>>2];q:{if((Yi|0)==q[jj>>2]){break q}while(1){Yi=w(ej,20)+Yi|0;Zi=q[qj>>2]+(q[Yi+4>>2]<<2)|0;bj=q[Yi>>2];$i=q[Yi+12>>2];r:{if($i>>>0>3){break r}Xi=q[ci+12>>2];dj=Yi+16|0;if(!q[dj>>2]){Zi=Xi;break r}mj=Yi+12|0;Yi=0;while(1){Xi=Cn(Xi,(Yi<<2)+Zi|0,$i);$i=q[mj>>2];Xi=Xi+$i|0;Yi=Yi+1|0;if(Yi>>>0<t[dj>>2]){continue}break}Zi=q[ci+12>>2]}Yi=q[ci+28>>2];Yi=r[bj+84|0]?Yi:q[q[bj+68>>2]+(Yi<<2)>>2];if(Yi>>>0>=t[bj+80>>2]){break q}Xi=q[bj+40>>2];Cn(q[q[bj>>2]>>2]+w(Xi,Yi)|0,Zi,Xi);ej=ej+1|0;Yi=q[ci+16>>2];if(ej>>>0<(q[jj>>2]-Yi|0)/20>>>0){continue}break}}q[ci+28>>2]=q[ci+28>>2]+1;q[Ye+8>>2]=q[Ye+8>>2]+1;cj=cj+1|0;if((cj|0)==(aj|0)){break f}Yi=q[Ye+12>>2];continue}}Yi=q[_i+28>>2]}if(Yi){continue}break}Zi=1}se(_i+8|0);Yi=q[_i+12>>2];Ye=q[_i+16>>2];s:{if((Yi|0)==(Ye|0)){break s}while(1){An(q[Yi>>2]);Yi=Yi+4|0;if((Ye|0)!=(Yi|0)){continue}break}Ye=q[_i+16>>2];Zh=q[_i+12>>2];if((Ye|0)==(Zh|0)){break s}q[_i+16>>2]=Ye+(((Ye-Zh|0)+ -4>>>2^-1)<<2)}Ye=q[_i+8>>2];if(Ye){An(Ye)}T=_i+32|0;return Zi}bn();F()}bn();F()}function ae(Ye,Zh,ci){var vj=0,wj=0,xj=0,yj=0,zj=0,Aj=0,Bj=0,Cj=0,Dj=0,Ej=0,Fj=0,Gj=0,Hj=0,Ij=0,Jj=0,Kj=0,Lj=0,Mj=0,Nj=0,Oj=0,Pj=0,Qj=0,Rj=0,Sj=0,Tj=0,Uj=0,Vj=0;yj=T-32|0;T=yj;vj=q[Ye+12>>2];q[yj+16>>2]=0;q[yj+8>>2]=0;q[yj+12>>2]=0;a:{if(vj){if(vj>>>0>=1073741824){break a}wj=vj<<2;xj=Mm(wj);q[yj+8>>2]=xj;q[yj+12>>2]=xj;q[yj+16>>2]=wj+xj;Aj=Dn(xj,0,wj);wj=vj;while(1){Aj=Aj+4|0;wj=wj+ -1|0;if(wj){continue}break}q[yj+12>>2]=Aj}zj=q[Ye+116>>2];wj=q[zj>>2];if(wj){q[zj+4>>2]=wj;An(wj);q[zj+8>>2]=0;q[zj>>2]=0;q[zj+4>>2]=0;vj=q[Ye+12>>2];Aj=q[yj+12>>2];xj=q[yj+8>>2]}q[zj>>2]=xj;q[zj+4>>2]=Aj;q[zj+8>>2]=q[yj+16>>2];Aj=0;q[yj+16>>2]=0;q[yj+8>>2]=0;q[yj+12>>2]=0;wj=0;b:{if(vj){if(vj>>>0>=1073741824){break b}xj=vj<<2;wj=Mm(xj);q[yj+8>>2]=wj;q[yj+12>>2]=wj;q[yj+16>>2]=wj+xj;Aj=Dn(wj,0,xj);while(1){Aj=Aj+4|0;vj=vj+ -1|0;if(vj){continue}break}q[yj+12>>2]=Aj}zj=q[Ye+128>>2];xj=q[zj>>2];if(xj){q[zj+4>>2]=xj;An(xj);q[zj+8>>2]=0;q[zj>>2]=0;q[zj+4>>2]=0;Aj=q[yj+12>>2];wj=q[yj+8>>2]}q[zj>>2]=wj;q[zj+4>>2]=Aj;q[zj+8>>2]=q[yj+16>>2];vj=yj+24|0;q[vj>>2]=0;q[vj+4>>2]=0;xj=yj+16|0;q[xj>>2]=0;q[xj+4>>2]=0;q[yj+8>>2]=0;q[yj+12>>2]=0;re(yj+8|0);zj=q[yj+12>>2];wj=0;c:{if((zj|0)==q[xj>>2]){break c}xj=q[vj>>2]+q[yj+28>>2]|0;wj=(xj>>>0)/341|0;wj=q[zj+(wj<<2)>>2]+w(xj-w(wj,341)|0,12)|0}q[wj+4>>2]=0;q[wj+8>>2]=0;q[wj>>2]=Zh;wj=1;xj=q[yj+28>>2];vj=xj+1|0;q[yj+28>>2]=vj;d:{if(vj>>>0<xj>>>0){break d}Uj=Ye+16|0;Qj=Ye+128|0;Oj=Ye+116|0;Lj=ci+20|0;Rj=Ye+104|0;Sj=Ye+92|0;Mj=Ye+44|0;Tj=Ye+36|0;Vj=Ye+76|0;while(1){wj=q[yj+12>>2];Bj=q[yj+24>>2];Cj=vj+ -1|0;zj=Bj+Cj|0;xj=(zj>>>0)/341|0;xj=q[wj+(xj<<2)>>2]+w(zj-w(xj,341)|0,12)|0;Gj=q[xj+8>>2];zj=q[xj+4>>2];Fj=q[xj>>2];q[yj+28>>2]=Cj;xj=q[yj+16>>2];wj=xj-wj|0;if(((wj?w(wj>>2,341)+ -1|0:0)-(vj+Bj|0)|0)+1>>>0>=682){An(q[xj+ -4>>2]);q[yj+16>>2]=q[yj+16>>2]+ -4}wj=0;if(Fj>>>0>Zh>>>0){break d}xj=q[Oj>>2];Hj=w(Gj,12);Pj=Hj+q[Qj>>2]|0;Aj=ml(Ye,Pj,zj);if(Aj>>>0>=t[Ye+12>>2]){break d}Kj=xj+Hj|0;e:{Ij=Aj<<2;zj=q[Ye>>2]-q[Ij+q[Pj>>2]>>2]|0;if(!zj){if(!Fj){break e}Dj=0;while(1){zj=0;vj=q[ci+16>>2];f:{if((vj|0)==q[Lj>>2]){break f}while(1){vj=w(zj,20)+vj|0;xj=q[Kj>>2]+(q[vj+4>>2]<<2)|0;Ej=q[vj>>2];Aj=q[vj+12>>2];g:{if(Aj>>>0>3){break g}wj=q[ci+12>>2];Bj=vj+16|0;if(!q[Bj>>2]){xj=wj;break g}Cj=vj+12|0;vj=0;while(1){wj=Cn(wj,(vj<<2)+xj|0,Aj);Aj=q[Cj>>2];wj=wj+Aj|0;vj=vj+1|0;if(vj>>>0<t[Bj>>2]){continue}break}xj=q[ci+12>>2]}vj=q[ci+28>>2];vj=r[Ej+84|0]?vj:q[q[Ej+68>>2]+(vj<<2)>>2];if(vj>>>0>=t[Ej+80>>2]){break f}wj=q[Ej+40>>2];Cn(q[q[Ej>>2]>>2]+w(wj,vj)|0,xj,wj);zj=zj+1|0;vj=q[ci+16>>2];if(zj>>>0<(q[Lj>>2]-vj|0)/20>>>0){continue}break}}q[ci+28>>2]=q[ci+28>>2]+1;q[Ye+8>>2]=q[Ye+8>>2]+1;Dj=Dj+1|0;if((Fj|0)!=(Dj|0)){continue}break}break e}h:{i:{j:{k:{if(Fj>>>0<=2){xj=q[Rj>>2];q[xj>>2]=Aj;wj=1;vj=q[Ye+12>>2];if(vj>>>0>1){break k}break h}if(t[Ye+8>>2]>t[Ye+4>>2]){break d}wj=q[Oj>>2];Dj=Gj+1|0;Ej=w(Dj,12);xj=wj+Ej|0;if((xj|0)!=(Kj|0)){hd(xj,q[Kj>>2],q[Kj+4>>2]);wj=q[Oj>>2]}wj=Ij+q[wj+Ej>>2]|0;q[wj>>2]=q[wj>>2]+(1<<zj+ -1);q[yj+4>>2]=0;eh(Uj,z(Fj)^31,yj+4|0);xj=(Fj>>>1)-q[yj+4>>2]|0;wj=Fj-xj|0;l:{if((wj|0)==(xj|0)){wj=xj;break l}Bj=q[Ye+84>>2];if((Bj|0)==q[Vj>>2]){break j}Cj=q[Bj>>2];vj=q[Ye+88>>2];zj=vj+1|0;q[Ye+88>>2]=zj;vj=Cj&-2147483648>>>vj;m:{if((zj|0)==32){q[Ye+88>>2]=0;q[Ye+84>>2]=Bj+4;if(vj){break m}break j}if(!vj){break j}}}zj=wj;wj=xj;break i}while(1){Aj=(vj+ -1|0)==(Aj|0)?0:Aj+1|0;q[xj+(wj<<2)>>2]=Aj;wj=wj+1|0;vj=q[Ye+12>>2];if(wj>>>0<vj>>>0){continue}break}break h}zj=xj}Bj=q[Qj>>2];Cj=Bj+Hj|0;vj=q[Cj>>2];xj=vj+Ij|0;q[xj>>2]=q[xj>>2]+1;hd(Bj+Ej|0,vj,q[Cj+4>>2]);if(wj){xj=q[yj+28>>2]+q[yj+24>>2]|0;Bj=q[yj+16>>2];vj=q[yj+12>>2];Cj=Bj-vj|0;if((xj|0)==((Cj?w(Cj>>2,341)+ -1|0:0)|0)){re(yj+8|0);vj=q[yj+12>>2];Bj=q[yj+16>>2];xj=q[yj+24>>2]+q[yj+28>>2]|0}if((vj|0)==(Bj|0)){xj=0}else{Bj=vj;vj=(xj>>>0)/341|0;xj=q[Bj+(vj<<2)>>2]+w(xj-w(vj,341)|0,12)|0}q[xj+8>>2]=Gj;q[xj+4>>2]=Aj;q[xj>>2]=wj;q[yj+28>>2]=q[yj+28>>2]+1}if(!zj){break e}wj=q[yj+28>>2]+q[yj+24>>2]|0;xj=q[yj+16>>2];vj=q[yj+12>>2];Cj=xj-vj|0;if((wj|0)==((Cj?w(Cj>>2,341)+ -1|0:0)|0)){re(yj+8|0);xj=q[yj+16>>2];vj=q[yj+12>>2];wj=q[yj+24>>2]+q[yj+28>>2]|0}if((vj|0)==(xj|0)){wj=0}else{xj=(wj>>>0)/341|0;wj=q[(xj<<2)+vj>>2]+w(wj-w(xj,341)|0,12)|0}q[wj+8>>2]=Dj;q[wj+4>>2]=Aj;q[wj>>2]=zj;q[yj+28>>2]=q[yj+28>>2]+1;break e}if(!Fj){break e}Gj=0;while(1){if(vj){Aj=q[Sj>>2];Dj=q[Rj>>2];Bj=q[Kj>>2];Cj=q[Pj>>2];vj=0;while(1){Hj=Dj+(vj<<2)|0;q[Aj+(q[Hj>>2]<<2)>>2]=0;wj=q[Hj>>2]<<2;Jj=q[Ye>>2]-q[wj+Cj>>2]|0;n:{if(!Jj){break n}Nj=wj+Aj|0;Ij=q[Ye+48>>2];zj=32-Ij|0;if((Jj|0)<=(zj|0)){xj=q[Mj>>2];if((xj|0)==q[Tj>>2]){q[Nj>>2]=0;break n}q[Nj>>2]=q[xj>>2]<<Ij>>>32-Jj;wj=Jj+q[Ye+48>>2]|0;q[Ye+48>>2]=wj;if((wj|0)!=32){break n}q[Ye+48>>2]=0;q[Mj>>2]=xj+4;break n}Ej=q[Mj>>2];wj=Ej+4|0;if((wj|0)==q[Tj>>2]){q[Nj>>2]=0;break n}xj=q[Ej>>2];q[Mj>>2]=wj;wj=Jj-zj|0;q[Ye+48>>2]=wj;q[Nj>>2]=q[Ej+4>>2]>>>32-wj|xj<<Ij>>>32-Jj}xj=q[Hj>>2]<<2;wj=xj+Aj|0;q[wj>>2]=q[wj>>2]|q[xj+Bj>>2];vj=vj+1|0;if(vj>>>0<t[Ye+12>>2]){continue}break}}zj=0;vj=q[ci+16>>2];o:{if((vj|0)==q[Lj>>2]){break o}while(1){vj=w(zj,20)+vj|0;xj=q[Sj>>2]+(q[vj+4>>2]<<2)|0;Dj=q[vj>>2];Aj=q[vj+12>>2];p:{if(Aj>>>0>3){break p}wj=q[ci+12>>2];Bj=vj+16|0;if(!q[Bj>>2]){xj=wj;break p}Cj=vj+12|0;vj=0;while(1){wj=Cn(wj,(vj<<2)+xj|0,Aj);Aj=q[Cj>>2];wj=wj+Aj|0;vj=vj+1|0;if(vj>>>0<t[Bj>>2]){continue}break}xj=q[ci+12>>2]}vj=q[ci+28>>2];vj=r[Dj+84|0]?vj:q[q[Dj+68>>2]+(vj<<2)>>2];if(vj>>>0>=t[Dj+80>>2]){break o}wj=q[Dj+40>>2];Cn(q[q[Dj>>2]>>2]+w(wj,vj)|0,xj,wj);zj=zj+1|0;vj=q[ci+16>>2];if(zj>>>0<(q[Lj>>2]-vj|0)/20>>>0){continue}break}}q[ci+28>>2]=q[ci+28>>2]+1;q[Ye+8>>2]=q[Ye+8>>2]+1;Gj=Gj+1|0;if((Gj|0)==(Fj|0)){break e}vj=q[Ye+12>>2];continue}}vj=q[yj+28>>2];if(vj){continue}break}wj=1}se(yj+8|0);vj=q[yj+12>>2];Ye=q[yj+16>>2];q:{if((vj|0)==(Ye|0)){break q}while(1){An(q[vj>>2]);vj=vj+4|0;if((Ye|0)!=(vj|0)){continue}break}Zh=q[yj+16>>2];Ye=q[yj+12>>2];if((Zh|0)==(Ye|0)){break q}q[yj+16>>2]=Zh+(((Zh-Ye|0)+ -4>>>2^-1)<<2)}Ye=q[yj+8>>2];if(Ye){An(Ye)}T=yj+32|0;return wj}bn();F()}bn();F()}function be(Ye,Zh,ci){var Wj=0,Xj=0,Yj=0,Zj=0,_j=0,$j=0,ak=0,bk=0,ck=0,dk=0,ek=0,fk=0,gk=0,hk=0,ik=0,jk=0,kk=0,lk=0,mk=0,nk=0,ok=0,pk=0,qk=0,rk=0,sk=0,tk=0,uk=0;Zj=T-32|0;T=Zj;Xj=q[Ye+12>>2];q[Zj+16>>2]=0;q[Zj+8>>2]=0;q[Zj+12>>2]=0;a:{if(Xj){if(Xj>>>0>=1073741824){break a}Wj=Xj<<2;Yj=Mm(Wj);q[Zj+8>>2]=Yj;q[Zj+12>>2]=Yj;q[Zj+16>>2]=Wj+Yj;_j=Dn(Yj,0,Wj);Wj=Xj;while(1){_j=_j+4|0;Wj=Wj+ -1|0;if(Wj){continue}break}q[Zj+12>>2]=_j}Wj=q[Ye+116>>2];$j=q[Wj>>2];if($j){q[Wj+4>>2]=$j;An($j);q[Wj+8>>2]=0;q[Wj>>2]=0;q[Wj+4>>2]=0;Xj=q[Ye+12>>2];_j=q[Zj+12>>2];Yj=q[Zj+8>>2]}q[Wj>>2]=Yj;q[Wj+4>>2]=_j;q[Wj+8>>2]=q[Zj+16>>2];_j=0;q[Zj+16>>2]=0;q[Zj+8>>2]=0;q[Zj+12>>2]=0;Wj=0;b:{if(Xj){if(Xj>>>0>=1073741824){break b}Yj=Xj<<2;Wj=Mm(Yj);q[Zj+8>>2]=Wj;q[Zj+12>>2]=Wj;q[Zj+16>>2]=Wj+Yj;_j=Dn(Wj,0,Yj);while(1){_j=_j+4|0;Xj=Xj+ -1|0;if(Xj){continue}break}q[Zj+12>>2]=_j}Yj=q[Ye+128>>2];$j=q[Yj>>2];if($j){q[Yj+4>>2]=$j;An($j);q[Yj+8>>2]=0;q[Yj>>2]=0;q[Yj+4>>2]=0;_j=q[Zj+12>>2];Wj=q[Zj+8>>2]}q[Yj>>2]=Wj;q[Yj+4>>2]=_j;q[Yj+8>>2]=q[Zj+16>>2];Yj=Zj+24|0;q[Yj>>2]=0;q[Yj+4>>2]=0;$j=Zj+16|0;q[$j>>2]=0;q[$j+4>>2]=0;q[Zj+8>>2]=0;q[Zj+12>>2]=0;re(Zj+8|0);Xj=q[$j>>2];$j=q[Zj+12>>2];Wj=0;c:{if((Xj|0)==($j|0)){break c}Wj=q[Yj>>2]+q[Zj+28>>2]|0;Yj=(Wj>>>0)/341|0;Wj=q[$j+(Yj<<2)>>2]+w(Wj-w(Yj,341)|0,12)|0}q[Wj+4>>2]=0;q[Wj+8>>2]=0;q[Wj>>2]=Zh;Yj=1;Wj=q[Zj+28>>2];Xj=Wj+1|0;q[Zj+28>>2]=Xj;d:{if(Xj>>>0<Wj>>>0){break d}qk=Ye+16|0;kk=Ye+116|0;lk=Ye+128|0;hk=ci+20|0;mk=Ye+104|0;nk=Ye+92|0;ik=Ye+44|0;ok=Ye+36|0;rk=Ye+76|0;while(1){ek=q[Zj+12>>2];Yj=q[Zj+24>>2];ak=Xj+ -1|0;Wj=Yj+ak|0;$j=(Wj>>>0)/341|0;Wj=q[ek+($j<<2)>>2]+w(Wj-w($j,341)|0,12)|0;ck=q[Wj+8>>2];_j=q[Wj+4>>2];$j=q[Wj>>2];q[Zj+28>>2]=ak;Wj=q[Zj+16>>2];ak=Wj-ek|0;if(((ak?w(ak>>2,341)+ -1|0:0)-(Xj+Yj|0)|0)+1>>>0>=682){An(q[Wj+ -4>>2]);q[Zj+16>>2]=q[Zj+16>>2]+ -4}if($j>>>0>Zh>>>0){Yj=0;break d}Yj=0;Wj=q[Ye+12>>2];_j=(_j|0)==(Wj+ -1|0)?0:_j+1|0;if(_j>>>0>=Wj>>>0){break d}Wj=q[kk>>2];Xj=w(ck,12);ek=Wj+Xj|0;e:{ak=_j<<2;fk=Xj+q[lk>>2]|0;bk=q[Ye>>2]-q[ak+q[fk>>2]>>2]|0;if(!bk){if(!$j){break e}bk=0;while(1){ck=0;Xj=q[ci+16>>2];f:{if((Xj|0)==q[hk>>2]){break f}while(1){Xj=w(ck,20)+Xj|0;Yj=q[ek>>2]+(q[Xj+4>>2]<<2)|0;ak=q[Xj>>2];_j=q[Xj+12>>2];g:{if(_j>>>0>3){break g}Wj=q[ci+12>>2];dk=Xj+16|0;if(!q[dk>>2]){Yj=Wj;break g}fk=Xj+12|0;Xj=0;while(1){Wj=Cn(Wj,(Xj<<2)+Yj|0,_j);_j=q[fk>>2];Wj=Wj+_j|0;Xj=Xj+1|0;if(Xj>>>0<t[dk>>2]){continue}break}Yj=q[ci+12>>2]}Xj=q[ci+28>>2];Xj=r[ak+84|0]?Xj:q[q[ak+68>>2]+(Xj<<2)>>2];if(Xj>>>0>=t[ak+80>>2]){break f}Wj=q[ak+40>>2];Cn(q[q[ak>>2]>>2]+w(Wj,Xj)|0,Yj,Wj);ck=ck+1|0;Xj=q[ci+16>>2];if(ck>>>0<(q[hk>>2]-Xj|0)/20>>>0){continue}break}}q[ci+28>>2]=q[ci+28>>2]+1;q[Ye+8>>2]=q[Ye+8>>2]+1;bk=bk+1|0;if(($j|0)!=(bk|0)){continue}break}break e}h:{i:{j:{k:{if($j>>>0<=2){Yj=q[mk>>2];q[Yj>>2]=_j;Wj=1;Xj=q[Ye+12>>2];if(Xj>>>0>1){break k}break h}if(t[Ye+8>>2]>t[Ye+4>>2]){break d}Yj=Wj;Wj=Xj+12|0;hd(Yj+Wj|0,q[ek>>2],q[ek+4>>2]);Wj=ak+q[Wj+q[kk>>2]>>2]|0;q[Wj>>2]=q[Wj>>2]+(1<<bk+ -1);q[Zj+4>>2]=0;eh(qk,z($j)^31,Zj+4|0);ek=ck+1|0;Wj=($j>>>1)-q[Zj+4>>2]|0;Yj=$j-Wj|0;l:{if((Yj|0)==(Wj|0)){Yj=Wj;break l}$j=q[Ye+84>>2];if(($j|0)==q[rk>>2]){break j}bk=q[$j>>2];dk=q[Ye+88>>2];fk=dk+1|0;q[Ye+88>>2]=fk;bk=bk&-2147483648>>>dk;m:{if((fk|0)==32){q[Ye+88>>2]=0;q[Ye+84>>2]=$j+4;if(bk){break m}break j}if(!bk){break j}}}$j=Yj;Yj=Wj;break i}while(1){_j=(Xj+ -1|0)==(_j|0)?0:_j+1|0;q[Yj+(Wj<<2)>>2]=_j;Wj=Wj+1|0;Xj=q[Ye+12>>2];if(Wj>>>0<Xj>>>0){continue}break}break h}$j=Wj}bk=ak;Wj=q[lk>>2];Xj=Wj+Xj|0;ak=q[Xj>>2];bk=bk+ak|0;q[bk>>2]=q[bk>>2]+1;hd(Wj+w(ek,12)|0,ak,q[Xj+4>>2]);if(Yj){Wj=q[Zj+28>>2]+q[Zj+24>>2]|0;ak=q[Zj+16>>2];Xj=q[Zj+12>>2];bk=ak-Xj|0;if((Wj|0)==((bk?w(bk>>2,341)+ -1|0:0)|0)){re(Zj+8|0);ak=q[Zj+16>>2];Xj=q[Zj+12>>2];Wj=q[Zj+24>>2]+q[Zj+28>>2]|0}if((Xj|0)==(ak|0)){Wj=0}else{ak=Xj;Xj=(Wj>>>0)/341|0;Wj=q[ak+(Xj<<2)>>2]+w(Wj-w(Xj,341)|0,12)|0}q[Wj+8>>2]=ck;q[Wj+4>>2]=_j;q[Wj>>2]=Yj;q[Zj+28>>2]=q[Zj+28>>2]+1}if(!$j){break e}Wj=q[Zj+28>>2]+q[Zj+24>>2]|0;Yj=q[Zj+16>>2];Xj=q[Zj+12>>2];ck=Yj-Xj|0;if((Wj|0)==((ck?w(ck>>2,341)+ -1|0:0)|0)){re(Zj+8|0);Yj=q[Zj+16>>2];Xj=q[Zj+12>>2];Wj=q[Zj+24>>2]+q[Zj+28>>2]|0}if((Xj|0)==(Yj|0)){Wj=0}else{Yj=(Wj>>>0)/341|0;Wj=q[(Yj<<2)+Xj>>2]+w(Wj-w(Yj,341)|0,12)|0}q[Wj+8>>2]=ek;q[Wj+4>>2]=_j;q[Wj>>2]=$j;q[Zj+28>>2]=q[Zj+28>>2]+1;break e}if(!$j){break e}bk=0;while(1){if(Xj){_j=q[nk>>2];jk=q[mk>>2];sk=q[ek>>2];tk=q[fk>>2];Xj=0;while(1){ck=jk+(Xj<<2)|0;q[_j+(q[ck>>2]<<2)>>2]=0;Yj=q[ck>>2]<<2;Wj=q[Ye>>2]-q[Yj+tk>>2]|0;n:{if(!Wj){break n}Yj=Yj+_j|0;ak=q[Ye+48>>2];gk=32-ak|0;if((Wj|0)<=(gk|0)){dk=q[ik>>2];if((dk|0)==q[ok>>2]){q[Yj>>2]=0;break n}q[Yj>>2]=q[dk>>2]<<ak>>>32-Wj;Wj=Wj+q[Ye+48>>2]|0;q[Ye+48>>2]=Wj;if((Wj|0)!=32){break n}q[Ye+48>>2]=0;q[ik>>2]=dk+4;break n}dk=q[ik>>2];pk=dk+4|0;if((pk|0)==q[ok>>2]){q[Yj>>2]=0;break n}uk=q[dk>>2];q[ik>>2]=pk;gk=Wj-gk|0;q[Ye+48>>2]=gk;q[Yj>>2]=q[dk+4>>2]>>>32-gk|uk<<ak>>>32-Wj}Wj=q[ck>>2]<<2;Yj=Wj+_j|0;q[Yj>>2]=q[Yj>>2]|q[Wj+sk>>2];Xj=Xj+1|0;if(Xj>>>0<t[Ye+12>>2]){continue}break}}ck=0;Xj=q[ci+16>>2];o:{if((Xj|0)==q[hk>>2]){break o}while(1){Xj=w(ck,20)+Xj|0;Yj=q[nk>>2]+(q[Xj+4>>2]<<2)|0;ak=q[Xj>>2];_j=q[Xj+12>>2];p:{if(_j>>>0>3){break p}Wj=q[ci+12>>2];dk=Xj+16|0;if(!q[dk>>2]){Yj=Wj;break p}jk=Xj+12|0;Xj=0;while(1){Wj=Cn(Wj,(Xj<<2)+Yj|0,_j);_j=q[jk>>2];Wj=Wj+_j|0;Xj=Xj+1|0;if(Xj>>>0<t[dk>>2]){continue}break}Yj=q[ci+12>>2]}Xj=q[ci+28>>2];Xj=r[ak+84|0]?Xj:q[q[ak+68>>2]+(Xj<<2)>>2];if(Xj>>>0>=t[ak+80>>2]){break o}Wj=q[ak+40>>2];Cn(q[q[ak>>2]>>2]+w(Wj,Xj)|0,Yj,Wj);ck=ck+1|0;Xj=q[ci+16>>2];if(ck>>>0<(q[hk>>2]-Xj|0)/20>>>0){continue}break}}q[ci+28>>2]=q[ci+28>>2]+1;q[Ye+8>>2]=q[Ye+8>>2]+1;bk=bk+1|0;if((bk|0)==($j|0)){break e}Xj=q[Ye+12>>2];continue}}Xj=q[Zj+28>>2];if(Xj){continue}break}Yj=1}se(Zj+8|0);Xj=q[Zj+12>>2];Ye=q[Zj+16>>2];q:{if((Xj|0)==(Ye|0)){break q}while(1){An(q[Xj>>2]);Xj=Xj+4|0;if((Ye|0)!=(Xj|0)){continue}break}Ye=q[Zj+16>>2];Zh=q[Zj+12>>2];if((Ye|0)==(Zh|0)){break q}q[Zj+16>>2]=Ye+(((Ye-Zh|0)+ -4>>>2^-1)<<2)}Ye=q[Zj+8>>2];if(Ye){An(Ye)}T=Zj+32|0;return Yj}bn();F()}bn();F()}function ce(Ye,Zh,ci){var vk=0,wk=0,xk=0,yk=0,zk=0,Ak=0,Bk=0,Ck=0,Dk=0,Ek=0,Fk=0,Gk=0,Hk=0,Ik=0,Jk=0,Kk=0,Lk=0,Mk=0,Nk=0,Ok=0,Pk=0,Qk=0,Rk=0,Sk=0,Tk=0,Uk=0;yk=T-32|0;T=yk;vk=q[Ye+12>>2];q[yk+16>>2]=0;q[yk+8>>2]=0;q[yk+12>>2]=0;a:{if(vk){if(vk>>>0>=1073741824){break a}wk=vk<<2;xk=Mm(wk);q[yk+8>>2]=xk;q[yk+12>>2]=xk;q[yk+16>>2]=wk+xk;Ak=Dn(xk,0,wk);wk=vk;while(1){Ak=Ak+4|0;wk=wk+ -1|0;if(wk){continue}break}q[yk+12>>2]=Ak}wk=q[Ye+628>>2];zk=q[wk>>2];if(zk){q[wk+4>>2]=zk;An(zk);q[wk+8>>2]=0;q[wk>>2]=0;q[wk+4>>2]=0;vk=q[Ye+12>>2];Ak=q[yk+12>>2];xk=q[yk+8>>2]}q[wk>>2]=xk;q[wk+4>>2]=Ak;q[wk+8>>2]=q[yk+16>>2];Ak=0;q[yk+16>>2]=0;q[yk+8>>2]=0;q[yk+12>>2]=0;wk=0;b:{if(vk){if(vk>>>0>=1073741824){break b}xk=vk<<2;wk=Mm(xk);q[yk+8>>2]=wk;q[yk+12>>2]=wk;q[yk+16>>2]=wk+xk;Ak=Dn(wk,0,xk);while(1){Ak=Ak+4|0;vk=vk+ -1|0;if(vk){continue}break}q[yk+12>>2]=Ak}xk=q[Ye+640>>2];vk=q[xk>>2];if(vk){q[xk+4>>2]=vk;An(vk);q[xk+8>>2]=0;q[xk>>2]=0;q[xk+4>>2]=0;Ak=q[yk+12>>2];wk=q[yk+8>>2]}q[xk>>2]=wk;q[xk+4>>2]=Ak;q[xk+8>>2]=q[yk+16>>2];vk=yk+24|0;q[vk>>2]=0;q[vk+4>>2]=0;wk=yk+16|0;q[wk>>2]=0;q[wk+4>>2]=0;q[yk+8>>2]=0;q[yk+12>>2]=0;re(yk+8|0);zk=q[wk>>2];wk=q[yk+12>>2];xk=0;c:{if((zk|0)==(wk|0)){break c}xk=q[vk>>2]+q[yk+28>>2]|0;vk=(xk>>>0)/341|0;xk=q[wk+(vk<<2)>>2]+w(xk-w(vk,341)|0,12)|0}q[xk+4>>2]=0;q[xk+8>>2]=0;q[xk>>2]=Zh;wk=1;xk=q[yk+28>>2];vk=xk+1|0;q[yk+28>>2]=vk;d:{if(vk>>>0<xk>>>0){break d}Mk=Ye+640|0;Lk=Ye+628|0;Jk=ci+20|0;Nk=Ye+616|0;Ok=Ye+604|0;Kk=Ye+556|0;Pk=Ye+548|0;Rk=Ye+588|0;while(1){Dk=q[yk+12>>2];wk=q[yk+24>>2];Ak=vk+ -1|0;xk=wk+Ak|0;zk=(xk>>>0)/341|0;xk=q[Dk+(zk<<2)>>2]+w(xk-w(zk,341)|0,12)|0;Ck=q[xk+8>>2];Fk=q[xk+4>>2];zk=q[xk>>2];q[yk+28>>2]=Ak;xk=q[yk+16>>2];Ak=xk-Dk|0;if(((Ak?w(Ak>>2,341)+ -1|0:0)-(vk+wk|0)|0)+1>>>0>=682){An(q[xk+ -4>>2]);q[yk+16>>2]=q[yk+16>>2]+ -4}wk=0;if(zk>>>0>Zh>>>0){break d}xk=q[Lk>>2];Bk=w(Ck,12);Gk=Bk+q[Mk>>2]|0;Ak=ml(Ye,Gk,Fk);if(Ak>>>0>=t[Ye+12>>2]){break d}Dk=xk+Bk|0;e:{f:{Fk=Ak<<2;vk=q[Ye>>2]-q[Fk+q[Gk>>2]>>2]|0;if(!vk){if(!zk){break f}Gk=0;while(1){Ck=0;vk=q[ci+16>>2];g:{if((vk|0)==q[Jk>>2]){break g}while(1){vk=w(Ck,20)+vk|0;xk=q[Dk>>2]+(q[vk+4>>2]<<2)|0;Bk=q[vk>>2];Ak=q[vk+12>>2];h:{if(Ak>>>0>3){break h}wk=q[ci+12>>2];Fk=vk+16|0;if(!q[Fk>>2]){xk=wk;break h}Ek=vk+12|0;vk=0;while(1){wk=Cn(wk,(vk<<2)+xk|0,Ak);Ak=q[Ek>>2];wk=wk+Ak|0;vk=vk+1|0;if(vk>>>0<t[Fk>>2]){continue}break}xk=q[ci+12>>2]}vk=q[ci+28>>2];vk=r[Bk+84|0]?vk:q[q[Bk+68>>2]+(vk<<2)>>2];if(vk>>>0>=t[Bk+80>>2]){break g}wk=vk;vk=q[Bk+40>>2];Cn(q[q[Bk>>2]>>2]+w(wk,vk)|0,xk,vk);Ck=Ck+1|0;vk=q[ci+16>>2];if(Ck>>>0<(q[Jk>>2]-vk|0)/20>>>0){continue}break}}q[ci+28>>2]=q[ci+28>>2]+1;q[Ye+8>>2]=q[Ye+8>>2]+1;Gk=Gk+1|0;if((zk|0)!=(Gk|0)){continue}break}break f}i:{j:{k:{l:{if(zk>>>0<=2){xk=q[Nk>>2];q[xk>>2]=Ak;wk=1;vk=q[Ye+12>>2];if(vk>>>0>1){break l}break i}if(t[Ye+8>>2]>t[Ye+4>>2]){break d}xk=q[Lk>>2];Ek=Ck+1|0;Gk=w(Ek,12);wk=xk+Gk|0;if((wk|0)!=(Dk|0)){hd(wk,q[Dk>>2],q[Dk+4>>2]);xk=q[Lk>>2]}xk=Fk+q[xk+Gk>>2]|0;q[xk>>2]=q[xk>>2]+(1<<vk+ -1);wk=0;vk=0;xk=z(zk)^31;if(xk){while(1){wk=dh(((vk<<4)+Ye|0)+16|0)|wk<<1;vk=vk+1|0;if((xk|0)!=(vk|0)){continue}break}}wk=(zk>>>1)-wk|0;vk=zk-wk|0;m:{if((vk|0)==(wk|0)){vk=wk;break m}xk=q[Ye+596>>2];if((xk|0)==q[Rk>>2]){break k}zk=q[xk>>2];Dk=q[Ye+600>>2];Hk=Dk+1|0;q[Ye+600>>2]=Hk;zk=zk&-2147483648>>>Dk;n:{if((Hk|0)==32){q[Ye+600>>2]=0;q[Ye+596>>2]=xk+4;if(zk){break n}break k}if(!zk){break k}}}xk=vk;vk=wk;break j}while(1){Ak=(vk+ -1|0)==(Ak|0)?0:Ak+1|0;q[xk+(wk<<2)>>2]=Ak;wk=wk+1|0;vk=q[Ye+12>>2];if(wk>>>0<vk>>>0){continue}break}break i}xk=wk}wk=q[Mk>>2];zk=wk+Bk|0;Dk=q[zk>>2];Bk=Dk+Fk|0;q[Bk>>2]=q[Bk>>2]+1;hd(wk+Gk|0,Dk,q[zk+4>>2]);if(vk){Dk=q[yk+28>>2]+q[yk+24>>2]|0;Bk=q[yk+16>>2];wk=q[yk+12>>2];zk=Bk-wk|0;if((Dk|0)==((zk?w(zk>>2,341)+ -1|0:0)|0)){re(yk+8|0);Dk=q[yk+24>>2]+q[yk+28>>2]|0;Bk=q[yk+16>>2];wk=q[yk+12>>2]}zk=0;o:{if((wk|0)==(Bk|0)){break o}zk=wk;wk=(Dk>>>0)/341|0;zk=q[zk+(wk<<2)>>2]+w(Dk-w(wk,341)|0,12)|0}q[zk+8>>2]=Ck;q[zk+4>>2]=Ak;q[zk>>2]=vk;q[yk+28>>2]=q[yk+28>>2]+1}if(!xk){break f}wk=q[yk+28>>2]+q[yk+24>>2]|0;zk=q[yk+16>>2];vk=q[yk+12>>2];Ck=zk-vk|0;if((wk|0)==((Ck?w(Ck>>2,341)+ -1|0:0)|0)){re(yk+8|0);zk=q[yk+16>>2];wk=q[yk+24>>2]+q[yk+28>>2]|0;vk=q[yk+12>>2]}if((vk|0)==(zk|0)){vk=0}else{zk=vk;vk=(wk>>>0)/341|0;vk=q[zk+(vk<<2)>>2]+w(wk-w(vk,341)|0,12)|0}q[vk+8>>2]=Ek;q[vk+4>>2]=Ak;q[vk>>2]=xk;vk=q[yk+28>>2]+1|0;q[yk+28>>2]=vk;break e}if(!zk){break f}Fk=0;while(1){if(vk){Ak=q[Ok>>2];Hk=q[Nk>>2];Sk=q[Dk>>2];Tk=q[Gk>>2];vk=0;while(1){Ck=Hk+(vk<<2)|0;q[Ak+(q[Ck>>2]<<2)>>2]=0;wk=q[Ck>>2]<<2;xk=q[Ye>>2]-q[wk+Tk>>2]|0;p:{if(!xk){break p}wk=wk+Ak|0;Bk=q[Ye+560>>2];Ik=32-Bk|0;if((xk|0)<=(Ik|0)){Ek=q[Kk>>2];if((Ek|0)==q[Pk>>2]){q[wk>>2]=0;break p}q[wk>>2]=q[Ek>>2]<<Bk>>>32-xk;xk=xk+q[Ye+560>>2]|0;q[Ye+560>>2]=xk;if((xk|0)!=32){break p}q[Ye+560>>2]=0;q[Kk>>2]=Ek+4;break p}Ek=q[Kk>>2];Qk=Ek+4|0;if((Qk|0)==q[Pk>>2]){q[wk>>2]=0;break p}Uk=q[Ek>>2];q[Kk>>2]=Qk;Ik=xk-Ik|0;q[Ye+560>>2]=Ik;q[wk>>2]=q[Ek+4>>2]>>>32-Ik|Uk<<Bk>>>32-xk}xk=q[Ck>>2]<<2;wk=xk+Ak|0;q[wk>>2]=q[wk>>2]|q[xk+Sk>>2];vk=vk+1|0;if(vk>>>0<t[Ye+12>>2]){continue}break}}Ck=0;vk=q[ci+16>>2];q:{if((vk|0)==q[Jk>>2]){break q}while(1){vk=w(Ck,20)+vk|0;xk=q[Ok>>2]+(q[vk+4>>2]<<2)|0;Bk=q[vk>>2];Ak=q[vk+12>>2];r:{if(Ak>>>0>3){break r}wk=q[ci+12>>2];Ek=vk+16|0;if(!q[Ek>>2]){xk=wk;break r}Hk=vk+12|0;vk=0;while(1){wk=Cn(wk,(vk<<2)+xk|0,Ak);Ak=q[Hk>>2];wk=wk+Ak|0;vk=vk+1|0;if(vk>>>0<t[Ek>>2]){continue}break}xk=q[ci+12>>2]}vk=q[ci+28>>2];vk=r[Bk+84|0]?vk:q[q[Bk+68>>2]+(vk<<2)>>2];if(vk>>>0>=t[Bk+80>>2]){break q}wk=vk;vk=q[Bk+40>>2];Cn(q[q[Bk>>2]>>2]+w(wk,vk)|0,xk,vk);Ck=Ck+1|0;vk=q[ci+16>>2];if(Ck>>>0<(q[Jk>>2]-vk|0)/20>>>0){continue}break}}q[ci+28>>2]=q[ci+28>>2]+1;q[Ye+8>>2]=q[Ye+8>>2]+1;Fk=Fk+1|0;if((Fk|0)==(zk|0)){break f}vk=q[Ye+12>>2];continue}}vk=q[yk+28>>2]}if(vk){continue}break}wk=1}se(yk+8|0);vk=q[yk+12>>2];Ye=q[yk+16>>2];s:{if((vk|0)==(Ye|0)){break s}while(1){An(q[vk>>2]);vk=vk+4|0;if((Ye|0)!=(vk|0)){continue}break}Ye=q[yk+16>>2];Zh=q[yk+12>>2];if((Ye|0)==(Zh|0)){break s}q[yk+16>>2]=Ye+(((Ye-Zh|0)+ -4>>>2^-1)<<2)}Ye=q[yk+8>>2];if(Ye){An(Ye)}T=yk+32|0;return wk}bn();F()}bn();F()}function de(q){ah(q);ah(q+16|0);ah(q+32|0);ah(q+48|0);ah(q- -64|0);ah(q+80|0);ah(q+96|0);ah(q+112|0);ah(q+128|0);ah(q+144|0);ah(q+160|0);ah(q+176|0);ah(q+192|0);ah(q+208|0);ah(q+224|0);ah(q+240|0);ah(q+256|0);ah(q+272|0);ah(q+288|0);ah(q+304|0);ah(q+320|0);ah(q+336|0);ah(q+352|0);ah(q+368|0);ah(q+384|0);ah(q+400|0);ah(q+416|0);ah(q+432|0);ah(q+448|0);ah(q+464|0);ah(q+480|0);ah(q+496|0)}function ee(Ye,Zh,ci){var Vk=0,Wk=0,Xk=0,Yk=0,Zk=0,_k=0,$k=0,al=0,bl=0,cl=0,dl=0,el=0,fl=0,gl=0,hl=0,il=0,jl=0,kl=0,ll=0,ml=0,nl=0,ol=0,pl=0,ql=0,rl=0,sl=0;Yk=T-32|0;T=Yk;Vk=q[Ye+12>>2];q[Yk+16>>2]=0;q[Yk+8>>2]=0;q[Yk+12>>2]=0;a:{if(Vk){if(Vk>>>0>=1073741824){break a}Wk=Vk<<2;Xk=Mm(Wk);q[Yk+8>>2]=Xk;q[Yk+12>>2]=Xk;q[Yk+16>>2]=Wk+Xk;Zk=Dn(Xk,0,Wk);Wk=Vk;while(1){Zk=Zk+4|0;Wk=Wk+ -1|0;if(Wk){continue}break}q[Yk+12>>2]=Zk}Wk=q[Ye+628>>2];_k=q[Wk>>2];if(_k){q[Wk+4>>2]=_k;An(_k);q[Wk+8>>2]=0;q[Wk>>2]=0;q[Wk+4>>2]=0;Vk=q[Ye+12>>2];Zk=q[Yk+12>>2];Xk=q[Yk+8>>2]}q[Wk>>2]=Xk;q[Wk+4>>2]=Zk;q[Wk+8>>2]=q[Yk+16>>2];Zk=0;q[Yk+16>>2]=0;q[Yk+8>>2]=0;q[Yk+12>>2]=0;Wk=0;b:{if(Vk){if(Vk>>>0>=1073741824){break b}Xk=Vk<<2;Wk=Mm(Xk);q[Yk+8>>2]=Wk;q[Yk+12>>2]=Wk;q[Yk+16>>2]=Wk+Xk;Zk=Dn(Wk,0,Xk);while(1){Zk=Zk+4|0;Vk=Vk+ -1|0;if(Vk){continue}break}q[Yk+12>>2]=Zk}Xk=q[Ye+640>>2];Vk=q[Xk>>2];if(Vk){q[Xk+4>>2]=Vk;An(Vk);q[Xk+8>>2]=0;q[Xk>>2]=0;q[Xk+4>>2]=0;Zk=q[Yk+12>>2];Wk=q[Yk+8>>2]}q[Xk>>2]=Wk;q[Xk+4>>2]=Zk;q[Xk+8>>2]=q[Yk+16>>2];Vk=Yk+24|0;q[Vk>>2]=0;q[Vk+4>>2]=0;Wk=Yk+16|0;q[Wk>>2]=0;q[Wk+4>>2]=0;q[Yk+8>>2]=0;q[Yk+12>>2]=0;re(Yk+8|0);_k=q[Wk>>2];Wk=q[Yk+12>>2];Xk=0;c:{if((_k|0)==(Wk|0)){break c}Xk=q[Vk>>2]+q[Yk+28>>2]|0;Vk=(Xk>>>0)/341|0;Xk=q[Wk+(Vk<<2)>>2]+w(Xk-w(Vk,341)|0,12)|0}q[Xk+4>>2]=0;q[Xk+8>>2]=0;q[Xk>>2]=Zh;Xk=1;Wk=q[Yk+28>>2];Vk=Wk+1|0;q[Yk+28>>2]=Vk;d:{if(Vk>>>0<Wk>>>0){break d}jl=Ye+628|0;kl=Ye+640|0;gl=ci+20|0;ll=Ye+616|0;ml=Ye+604|0;hl=Ye+556|0;nl=Ye+548|0;pl=Ye+588|0;while(1){dl=q[Yk+12>>2];Zk=q[Yk+24>>2];$k=Vk+ -1|0;Xk=Zk+$k|0;Wk=(Xk>>>0)/341|0;Xk=q[dl+(Wk<<2)>>2]+w(Xk-w(Wk,341)|0,12)|0;al=q[Xk+8>>2];Wk=q[Xk+4>>2];_k=q[Xk>>2];q[Yk+28>>2]=$k;Xk=q[Yk+16>>2];$k=Xk-dl|0;if((($k?w($k>>2,341)+ -1|0:0)-(Vk+Zk|0)|0)+1>>>0>=682){An(q[Xk+ -4>>2]);q[Yk+16>>2]=q[Yk+16>>2]+ -4}if(_k>>>0>Zh>>>0){Xk=0;break d}Xk=0;Vk=q[Ye+12>>2];Zk=(Wk|0)==(Vk+ -1|0)?0:Wk+1|0;if(Zk>>>0>=Vk>>>0){break d}Vk=q[jl>>2];$k=w(al,12);dl=Vk+$k|0;e:{f:{bl=Zk<<2;el=$k+q[kl>>2]|0;Wk=q[Ye>>2]-q[bl+q[el>>2]>>2]|0;if(!Wk){if(!_k){break f}bl=0;while(1){$k=0;Vk=q[ci+16>>2];g:{if((Vk|0)==q[gl>>2]){break g}while(1){Vk=w($k,20)+Vk|0;Xk=q[dl>>2]+(q[Vk+4>>2]<<2)|0;al=q[Vk>>2];Zk=q[Vk+12>>2];h:{if(Zk>>>0>3){break h}Wk=q[ci+12>>2];cl=Vk+16|0;if(!q[cl>>2]){Xk=Wk;break h}el=Vk+12|0;Vk=0;while(1){Wk=Cn(Wk,(Vk<<2)+Xk|0,Zk);Zk=q[el>>2];Wk=Wk+Zk|0;Vk=Vk+1|0;if(Vk>>>0<t[cl>>2]){continue}break}Xk=q[ci+12>>2]}Vk=q[ci+28>>2];Vk=r[al+84|0]?Vk:q[q[al+68>>2]+(Vk<<2)>>2];if(Vk>>>0>=t[al+80>>2]){break g}Wk=Vk;Vk=q[al+40>>2];Cn(q[q[al>>2]>>2]+w(Wk,Vk)|0,Xk,Vk);$k=$k+1|0;Vk=q[ci+16>>2];if($k>>>0<(q[gl>>2]-Vk|0)/20>>>0){continue}break}}q[ci+28>>2]=q[ci+28>>2]+1;q[Ye+8>>2]=q[Ye+8>>2]+1;bl=bl+1|0;if((_k|0)!=(bl|0)){continue}break}break f}i:{j:{k:{l:{if(_k>>>0<=2){Xk=q[ll>>2];q[Xk>>2]=Zk;Wk=1;Vk=q[Ye+12>>2];if(Vk>>>0>1){break l}break i}if(t[Ye+8>>2]>t[Ye+4>>2]){break d}Xk=$k+12|0;hd(Xk+Vk|0,q[dl>>2],q[dl+4>>2]);Xk=bl+q[Xk+q[jl>>2]>>2]|0;q[Xk>>2]=q[Xk>>2]+(1<<Wk+ -1);Wk=0;Vk=0;Xk=z(_k)^31;if(Xk){while(1){Wk=dh(((Vk<<4)+Ye|0)+16|0)|Wk<<1;Vk=Vk+1|0;if((Xk|0)!=(Vk|0)){continue}break}}dl=al+1|0;Wk=(_k>>>1)-Wk|0;Vk=_k-Wk|0;m:{if((Vk|0)==(Wk|0)){Vk=Wk;break m}Xk=q[Ye+596>>2];if((Xk|0)==q[pl>>2]){break k}_k=q[Xk>>2];cl=q[Ye+600>>2];el=cl+1|0;q[Ye+600>>2]=el;_k=_k&-2147483648>>>cl;n:{if((el|0)==32){q[Ye+600>>2]=0;q[Ye+596>>2]=Xk+4;if(_k){break n}break k}if(!_k){break k}}}Xk=Vk;Vk=Wk;break j}while(1){Zk=(Vk+ -1|0)==(Zk|0)?0:Zk+1|0;q[Xk+(Wk<<2)>>2]=Zk;Wk=Wk+1|0;Vk=q[Ye+12>>2];if(Wk>>>0<Vk>>>0){continue}break}break i}Xk=Wk}Wk=q[kl>>2];_k=Wk+$k|0;$k=q[_k>>2];bl=$k+bl|0;q[bl>>2]=q[bl>>2]+1;hd(Wk+w(dl,12)|0,$k,q[_k+4>>2]);if(Vk){$k=q[Yk+28>>2]+q[Yk+24>>2]|0;bl=q[Yk+16>>2];Wk=q[Yk+12>>2];_k=bl-Wk|0;if(($k|0)==((_k?w(_k>>2,341)+ -1|0:0)|0)){re(Yk+8|0);$k=q[Yk+24>>2]+q[Yk+28>>2]|0;bl=q[Yk+16>>2];Wk=q[Yk+12>>2]}_k=0;o:{if((Wk|0)==(bl|0)){break o}_k=Wk;Wk=($k>>>0)/341|0;_k=q[_k+(Wk<<2)>>2]+w($k-w(Wk,341)|0,12)|0}q[_k+8>>2]=al;q[_k+4>>2]=Zk;q[_k>>2]=Vk;q[Yk+28>>2]=q[Yk+28>>2]+1}if(!Xk){break f}Wk=q[Yk+28>>2]+q[Yk+24>>2]|0;$k=q[Yk+16>>2];Vk=q[Yk+12>>2];_k=$k-Vk|0;if((Wk|0)==((_k?w(_k>>2,341)+ -1|0:0)|0)){re(Yk+8|0);$k=q[Yk+16>>2];Wk=q[Yk+24>>2]+q[Yk+28>>2]|0;Vk=q[Yk+12>>2]}if((Vk|0)==($k|0)){Vk=0}else{_k=Vk;Vk=(Wk>>>0)/341|0;Vk=q[_k+(Vk<<2)>>2]+w(Wk-w(Vk,341)|0,12)|0}q[Vk+8>>2]=dl;q[Vk+4>>2]=Zk;q[Vk>>2]=Xk;Vk=q[Yk+28>>2]+1|0;q[Yk+28>>2]=Vk;break e}if(!_k){break f}bl=0;while(1){if(Vk){Zk=q[ml>>2];il=q[ll>>2];ql=q[dl>>2];rl=q[el>>2];Vk=0;while(1){$k=il+(Vk<<2)|0;q[Zk+(q[$k>>2]<<2)>>2]=0;Wk=q[$k>>2]<<2;Xk=q[Ye>>2]-q[Wk+rl>>2]|0;p:{if(!Xk){break p}Wk=Wk+Zk|0;al=q[Ye+560>>2];fl=32-al|0;if((Xk|0)<=(fl|0)){cl=q[hl>>2];if((cl|0)==q[nl>>2]){q[Wk>>2]=0;break p}q[Wk>>2]=q[cl>>2]<<al>>>32-Xk;Xk=Xk+q[Ye+560>>2]|0;q[Ye+560>>2]=Xk;if((Xk|0)!=32){break p}q[Ye+560>>2]=0;q[hl>>2]=cl+4;break p}cl=q[hl>>2];ol=cl+4|0;if((ol|0)==q[nl>>2]){q[Wk>>2]=0;break p}sl=q[cl>>2];q[hl>>2]=ol;fl=Xk-fl|0;q[Ye+560>>2]=fl;q[Wk>>2]=q[cl+4>>2]>>>32-fl|sl<<al>>>32-Xk}Xk=q[$k>>2]<<2;Wk=Xk+Zk|0;q[Wk>>2]=q[Wk>>2]|q[Xk+ql>>2];Vk=Vk+1|0;if(Vk>>>0<t[Ye+12>>2]){continue}break}}$k=0;Vk=q[ci+16>>2];q:{if((Vk|0)==q[gl>>2]){break q}while(1){Vk=w($k,20)+Vk|0;Xk=q[ml>>2]+(q[Vk+4>>2]<<2)|0;al=q[Vk>>2];Zk=q[Vk+12>>2];r:{if(Zk>>>0>3){break r}Wk=q[ci+12>>2];cl=Vk+16|0;if(!q[cl>>2]){Xk=Wk;break r}il=Vk+12|0;Vk=0;while(1){Wk=Cn(Wk,(Vk<<2)+Xk|0,Zk);Zk=q[il>>2];Wk=Wk+Zk|0;Vk=Vk+1|0;if(Vk>>>0<t[cl>>2]){continue}break}Xk=q[ci+12>>2]}Vk=q[ci+28>>2];Vk=r[al+84|0]?Vk:q[q[al+68>>2]+(Vk<<2)>>2];if(Vk>>>0>=t[al+80>>2]){break q}Wk=Vk;Vk=q[al+40>>2];Cn(q[q[al>>2]>>2]+w(Wk,Vk)|0,Xk,Vk);$k=$k+1|0;Vk=q[ci+16>>2];if($k>>>0<(q[gl>>2]-Vk|0)/20>>>0){continue}break}}q[ci+28>>2]=q[ci+28>>2]+1;q[Ye+8>>2]=q[Ye+8>>2]+1;bl=bl+1|0;if((bl|0)==(_k|0)){break f}Vk=q[Ye+12>>2];continue}}Vk=q[Yk+28>>2]}if(Vk){continue}break}Xk=1}se(Yk+8|0);Vk=q[Yk+12>>2];Ye=q[Yk+16>>2];s:{if((Vk|0)==(Ye|0)){break s}while(1){An(q[Vk>>2]);Vk=Vk+4|0;if((Ye|0)!=(Vk|0)){continue}break}Ye=q[Yk+16>>2];Zh=q[Yk+12>>2];if((Ye|0)==(Zh|0)){break s}q[Yk+16>>2]=Ye+(((Ye-Zh|0)+ -4>>>2^-1)<<2)}Ye=q[Yk+8>>2];if(Ye){An(Ye)}T=Yk+32|0;return Xk}bn();F()}bn();F()}function fe(Ye,Zh,ci){var tl=0,ul=0,vl=0,wl=0,xl=0,yl=0,zl=0,Al=0,Bl=0,Cl=0,Dl=0,El=0,Fl=0,Gl=0,Hl=0,Il=0,Jl=0,Kl=0,Ll=0,Ml=0,Nl=0,Ol=0,Pl=0,Ql=0,Rl=0,Sl=0;wl=T-32|0;T=wl;tl=q[Ye+12>>2];q[wl+16>>2]=0;q[wl+8>>2]=0;q[wl+12>>2]=0;a:{if(tl){if(tl>>>0>=1073741824){break a}ul=tl<<2;vl=Mm(ul);q[wl+8>>2]=vl;q[wl+12>>2]=vl;q[wl+16>>2]=ul+vl;yl=Dn(vl,0,ul);ul=tl;while(1){yl=yl+4|0;ul=ul+ -1|0;if(ul){continue}break}q[wl+12>>2]=yl}ul=q[Ye+628>>2];xl=q[ul>>2];if(xl){q[ul+4>>2]=xl;An(xl);q[ul+8>>2]=0;q[ul>>2]=0;q[ul+4>>2]=0;tl=q[Ye+12>>2];yl=q[wl+12>>2];vl=q[wl+8>>2]}q[ul>>2]=vl;q[ul+4>>2]=yl;q[ul+8>>2]=q[wl+16>>2];yl=0;q[wl+16>>2]=0;q[wl+8>>2]=0;q[wl+12>>2]=0;ul=0;b:{if(tl){if(tl>>>0>=1073741824){break b}vl=tl<<2;ul=Mm(vl);q[wl+8>>2]=ul;q[wl+12>>2]=ul;q[wl+16>>2]=ul+vl;yl=Dn(ul,0,vl);while(1){yl=yl+4|0;tl=tl+ -1|0;if(tl){continue}break}q[wl+12>>2]=yl}vl=q[Ye+640>>2];tl=q[vl>>2];if(tl){q[vl+4>>2]=tl;An(tl);q[vl+8>>2]=0;q[vl>>2]=0;q[vl+4>>2]=0;yl=q[wl+12>>2];ul=q[wl+8>>2]}q[vl>>2]=ul;q[vl+4>>2]=yl;q[vl+8>>2]=q[wl+16>>2];tl=wl+24|0;q[tl>>2]=0;q[tl+4>>2]=0;ul=wl+16|0;q[ul>>2]=0;q[ul+4>>2]=0;q[wl+8>>2]=0;q[wl+12>>2]=0;re(wl+8|0);xl=q[ul>>2];ul=q[wl+12>>2];vl=0;c:{if((xl|0)==(ul|0)){break c}vl=q[tl>>2]+q[wl+28>>2]|0;tl=(vl>>>0)/341|0;vl=q[ul+(tl<<2)>>2]+w(vl-w(tl,341)|0,12)|0}q[vl+4>>2]=0;q[vl+8>>2]=0;q[vl>>2]=Zh;ul=1;vl=q[wl+28>>2];tl=vl+1|0;q[wl+28>>2]=tl;d:{if(tl>>>0<vl>>>0){break d}Kl=Ye+640|0;Jl=Ye+628|0;Hl=ci+20|0;Ll=Ye+616|0;Ml=Ye+604|0;Il=Ye+556|0;Nl=Ye+548|0;Pl=Ye+588|0;while(1){Bl=q[wl+12>>2];ul=q[wl+24>>2];yl=tl+ -1|0;vl=ul+yl|0;xl=(vl>>>0)/341|0;vl=q[Bl+(xl<<2)>>2]+w(vl-w(xl,341)|0,12)|0;Al=q[vl+8>>2];xl=q[vl>>2];q[wl+28>>2]=yl;vl=q[wl+16>>2];yl=vl-Bl|0;if(((yl?w(yl>>2,341)+ -1|0:0)-(tl+ul|0)|0)+1>>>0>=682){An(q[vl+ -4>>2]);q[wl+16>>2]=q[wl+16>>2]+ -4}ul=0;if(xl>>>0>Zh>>>0){break d}vl=q[Jl>>2];zl=w(Al,12);Dl=zl+q[Kl>>2]|0;yl=nl(Ye,xl,Dl);if(yl>>>0>=t[Ye+12>>2]){break d}Bl=vl+zl|0;e:{f:{El=yl<<2;tl=q[Ye>>2]-q[El+q[Dl>>2]>>2]|0;if(!tl){if(!xl){break f}Dl=0;while(1){Al=0;tl=q[ci+16>>2];g:{if((tl|0)==q[Hl>>2]){break g}while(1){tl=w(Al,20)+tl|0;vl=q[Bl>>2]+(q[tl+4>>2]<<2)|0;zl=q[tl>>2];yl=q[tl+12>>2];h:{if(yl>>>0>3){break h}ul=q[ci+12>>2];El=tl+16|0;if(!q[El>>2]){vl=ul;break h}Cl=tl+12|0;tl=0;while(1){ul=Cn(ul,(tl<<2)+vl|0,yl);yl=q[Cl>>2];ul=ul+yl|0;tl=tl+1|0;if(tl>>>0<t[El>>2]){continue}break}vl=q[ci+12>>2]}tl=q[ci+28>>2];tl=r[zl+84|0]?tl:q[q[zl+68>>2]+(tl<<2)>>2];if(tl>>>0>=t[zl+80>>2]){break g}ul=tl;tl=q[zl+40>>2];Cn(q[q[zl>>2]>>2]+w(ul,tl)|0,vl,tl);Al=Al+1|0;tl=q[ci+16>>2];if(Al>>>0<(q[Hl>>2]-tl|0)/20>>>0){continue}break}}q[ci+28>>2]=q[ci+28>>2]+1;q[Ye+8>>2]=q[Ye+8>>2]+1;Dl=Dl+1|0;if((xl|0)!=(Dl|0)){continue}break}break f}i:{j:{k:{l:{if(xl>>>0<=2){vl=q[Ll>>2];q[vl>>2]=yl;ul=1;tl=q[Ye+12>>2];if(tl>>>0>1){break l}break i}if(t[Ye+8>>2]>t[Ye+4>>2]){break d}vl=q[Jl>>2];Cl=Al+1|0;Dl=w(Cl,12);ul=vl+Dl|0;if((ul|0)!=(Bl|0)){hd(ul,q[Bl>>2],q[Bl+4>>2]);vl=q[Jl>>2]}vl=El+q[vl+Dl>>2]|0;q[vl>>2]=q[vl>>2]+(1<<tl+ -1);ul=0;tl=0;vl=z(xl)^31;if(vl){while(1){ul=dh(((tl<<4)+Ye|0)+16|0)|ul<<1;tl=tl+1|0;if((vl|0)!=(tl|0)){continue}break}}ul=(xl>>>1)-ul|0;tl=xl-ul|0;m:{if((tl|0)==(ul|0)){tl=ul;break m}vl=q[Ye+596>>2];if((vl|0)==q[Pl>>2]){break k}xl=q[vl>>2];Bl=q[Ye+600>>2];Fl=Bl+1|0;q[Ye+600>>2]=Fl;xl=xl&-2147483648>>>Bl;n:{if((Fl|0)==32){q[Ye+600>>2]=0;q[Ye+596>>2]=vl+4;if(xl){break n}break k}if(!xl){break k}}}vl=tl;tl=ul;break j}while(1){yl=(tl+ -1|0)==(yl|0)?0:yl+1|0;q[vl+(ul<<2)>>2]=yl;ul=ul+1|0;tl=q[Ye+12>>2];if(ul>>>0<tl>>>0){continue}break}break i}vl=ul}ul=q[Kl>>2];xl=ul+zl|0;Bl=q[xl>>2];zl=Bl+El|0;q[zl>>2]=q[zl>>2]+1;hd(ul+Dl|0,Bl,q[xl+4>>2]);if(tl){Bl=q[wl+28>>2]+q[wl+24>>2]|0;zl=q[wl+16>>2];ul=q[wl+12>>2];xl=zl-ul|0;if((Bl|0)==((xl?w(xl>>2,341)+ -1|0:0)|0)){re(wl+8|0);Bl=q[wl+24>>2]+q[wl+28>>2]|0;zl=q[wl+16>>2];ul=q[wl+12>>2]}xl=0;o:{if((ul|0)==(zl|0)){break o}xl=ul;ul=(Bl>>>0)/341|0;xl=q[xl+(ul<<2)>>2]+w(Bl-w(ul,341)|0,12)|0}q[xl+8>>2]=Al;q[xl+4>>2]=yl;q[xl>>2]=tl;q[wl+28>>2]=q[wl+28>>2]+1}if(!vl){break f}ul=q[wl+28>>2]+q[wl+24>>2]|0;xl=q[wl+16>>2];tl=q[wl+12>>2];Al=xl-tl|0;if((ul|0)==((Al?w(Al>>2,341)+ -1|0:0)|0)){re(wl+8|0);xl=q[wl+16>>2];ul=q[wl+24>>2]+q[wl+28>>2]|0;tl=q[wl+12>>2]}if((tl|0)==(xl|0)){tl=0}else{xl=tl;tl=(ul>>>0)/341|0;tl=q[xl+(tl<<2)>>2]+w(ul-w(tl,341)|0,12)|0}q[tl+8>>2]=Cl;q[tl+4>>2]=yl;q[tl>>2]=vl;tl=q[wl+28>>2]+1|0;q[wl+28>>2]=tl;break e}if(!xl){break f}El=0;while(1){if(tl){yl=q[Ml>>2];Fl=q[Ll>>2];Ql=q[Bl>>2];Rl=q[Dl>>2];tl=0;while(1){Al=Fl+(tl<<2)|0;q[yl+(q[Al>>2]<<2)>>2]=0;ul=q[Al>>2]<<2;vl=q[Ye>>2]-q[ul+Rl>>2]|0;p:{if(!vl){break p}ul=ul+yl|0;zl=q[Ye+560>>2];Gl=32-zl|0;if((vl|0)<=(Gl|0)){Cl=q[Il>>2];if((Cl|0)==q[Nl>>2]){q[ul>>2]=0;break p}q[ul>>2]=q[Cl>>2]<<zl>>>32-vl;vl=vl+q[Ye+560>>2]|0;q[Ye+560>>2]=vl;if((vl|0)!=32){break p}q[Ye+560>>2]=0;q[Il>>2]=Cl+4;break p}Cl=q[Il>>2];Ol=Cl+4|0;if((Ol|0)==q[Nl>>2]){q[ul>>2]=0;break p}Sl=q[Cl>>2];q[Il>>2]=Ol;Gl=vl-Gl|0;q[Ye+560>>2]=Gl;q[ul>>2]=q[Cl+4>>2]>>>32-Gl|Sl<<zl>>>32-vl}vl=q[Al>>2]<<2;ul=vl+yl|0;q[ul>>2]=q[ul>>2]|q[vl+Ql>>2];tl=tl+1|0;if(tl>>>0<t[Ye+12>>2]){continue}break}}Al=0;tl=q[ci+16>>2];q:{if((tl|0)==q[Hl>>2]){break q}while(1){tl=w(Al,20)+tl|0;vl=q[Ml>>2]+(q[tl+4>>2]<<2)|0;zl=q[tl>>2];yl=q[tl+12>>2];r:{if(yl>>>0>3){break r}ul=q[ci+12>>2];Cl=tl+16|0;if(!q[Cl>>2]){vl=ul;break r}Fl=tl+12|0;tl=0;while(1){ul=Cn(ul,(tl<<2)+vl|0,yl);yl=q[Fl>>2];ul=ul+yl|0;tl=tl+1|0;if(tl>>>0<t[Cl>>2]){continue}break}vl=q[ci+12>>2]}tl=q[ci+28>>2];tl=r[zl+84|0]?tl:q[q[zl+68>>2]+(tl<<2)>>2];if(tl>>>0>=t[zl+80>>2]){break q}ul=tl;tl=q[zl+40>>2];Cn(q[q[zl>>2]>>2]+w(ul,tl)|0,vl,tl);Al=Al+1|0;tl=q[ci+16>>2];if(Al>>>0<(q[Hl>>2]-tl|0)/20>>>0){continue}break}}q[ci+28>>2]=q[ci+28>>2]+1;q[Ye+8>>2]=q[Ye+8>>2]+1;El=El+1|0;if((El|0)==(xl|0)){break f}tl=q[Ye+12>>2];continue}}tl=q[wl+28>>2]}if(tl){continue}break}ul=1}se(wl+8|0);tl=q[wl+12>>2];Ye=q[wl+16>>2];s:{if((tl|0)==(Ye|0)){break s}while(1){An(q[tl>>2]);tl=tl+4|0;if((Ye|0)!=(tl|0)){continue}break}Ye=q[wl+16>>2];Zh=q[wl+12>>2];if((Ye|0)==(Zh|0)){break s}q[wl+16>>2]=Ye+(((Ye-Zh|0)+ -4>>>2^-1)<<2)}Ye=q[wl+8>>2];if(Ye){An(Ye)}T=wl+32|0;return ul}bn();F()}bn();F()}function ge(Ye,Zh){Ye=Ye|0;Zh=Zh|0;var ci=0,Tl=0,Ul=0,Vl=0,Wl=0,Xl=0,Zl=0,_l=0,$l=0,am=0,bm=0,cm=0,dm=0,em=0,fm=0,gm=0,hm=0,im=0,jm=0;Ul=T-720|0;T=Ul;a:{b:{c:{d:{if(s[Zh+38>>1]>=515){q[Ul+680>>2]=0;q[Ul+672>>2]=0;q[Ul+676>>2]=0;cm=Ye+36|0;am=Ul+24|0;$l=Ye+40|0;dm=Ye+60|0;fm=Ye+44|0;while(1){if((Wl|0)>=(n[q[q[Ye>>2]+24>>2]](Ye)|0)){gm=1;ci=Ye+52|0;if(q[ci>>2]==q[Ye+48>>2]){break b}Wl=0;while(1){if(he(1,Ul+16|0,Zh)){Tl=q[Ul+16>>2];Xl=0-(Tl&1)^Tl>>>1}Tl=q[Ye+48>>2];q[Tl+(Wl<<2)>>2]=Xl;Wl=Wl+1|0;if(Wl>>>0<q[ci>>2]-Tl>>2>>>0){continue}break}break b}ci=n[q[q[Ye>>2]+20>>2]](Ye,Wl)|0;Tl=q[q[q[(n[q[q[Ye>>2]+28>>2]](Ye)|0)+4>>2]+8>>2]+(ci<<2)>>2];if(q[Tl+28>>2]==9){Vl=q[Ul+672>>2];ci=q[Ul+676>>2]-Vl>>2;Zl=o[Tl+24|0];e:{if(ci>>>0<Zl>>>0){Fa(Ul+672|0,Zl-ci|0);break e}if(ci>>>0<=Zl>>>0){break e}q[Ul+676>>2]=Vl+(Zl<<2)}ci=q[Zh+12>>2];Tl=q[Zh+20>>2];Xl=q[Zh+16>>2];_l=Zl<<2;Vl=_l;em=Xl+Vl|0;if(em>>>0<Vl>>>0){Tl=Tl+1|0}if((ci|0)<(Tl|0)?1:(ci|0)<=(Tl|0)?t[Zh+8>>2]>=em>>>0?0:1:0){break b}Cn(q[Ul+672>>2],Xl+q[Zh>>2]|0,_l);ci=q[Zh+20>>2];Xl=Vl+q[Zh+16>>2]|0;if(Xl>>>0<Vl>>>0){ci=ci+1|0}q[Zh+16>>2]=Xl;q[Zh+20>>2]=ci;Vl=q[Zh+12>>2];bm=Vl;Tl=ci;_l=Xl+4|0;if(_l>>>0<4){Tl=Tl+1|0}em=q[Zh+8>>2];if((Vl|0)<(Tl|0)?1:(Vl|0)<=(Tl|0)?em>>>0>=_l>>>0?0:1:0){break b}hm=q[Zh>>2];Vl=hm+Xl|0;Vl=r[Vl|0]|r[Vl+1|0]<<8|(r[Vl+2|0]<<16|r[Vl+3|0]<<24);q[Zh+16>>2]=_l;q[Zh+20>>2]=Tl;if((bm|0)<(Tl|0)?1:(bm|0)<=(Tl|0)?em>>>0>_l>>>0?0:1:0){break b}_l=r[_l+hm|0];Tl=ci;ci=Xl+5|0;if(ci>>>0<5){Tl=Tl+1|0}q[Zh+16>>2]=ci;q[Zh+20>>2]=Tl;if(_l>>>0>31){break b}q[Ul+20>>2]=-1;q[Ul+16>>2]=1232;ci=am;q[ci+8>>2]=0;q[ci+12>>2]=0;q[ci>>2]=0;q[ci+4>>2]=0;gd(Ul+16|0,_l,q[Ul+672>>2],Zl,(f(0,Vl),j()));ci=1;if(ld(Ul+16|0,q[q[dm>>2]+((q[$l>>2]-q[Ye+36>>2]|0)/24<<2)>>2])){ci=q[$l>>2];f:{if((ci|0)!=q[fm>>2]){q[ci>>2]=1232;Tl=q[Ul+20>>2];Vl=ci+16|0;q[Vl>>2]=0;q[ci+8>>2]=0;q[ci+12>>2]=0;q[ci+4>>2]=Tl;Tl=q[Ul+28>>2]-q[Ul+24>>2]|0;g:{if(!Tl){break g}Zl=Tl>>2;if(Zl>>>0>=1073741824){break d}Tl=Mm(Tl);q[ci+8>>2]=Tl;Xl=ci+12|0;q[Xl>>2]=Tl;q[Vl>>2]=Tl+(Zl<<2);Zl=q[Ul+24>>2];Vl=q[Ul+28>>2]-Zl|0;if((Vl|0)<1){break g}im=Xl,jm=Cn(Tl,Zl,Vl)+Vl|0,q[im>>2]=jm}q[ci+20>>2]=q[Ul+36>>2];q[$l>>2]=q[$l>>2]+24;break f}ie(cm,Ul+16|0)}ci=0}q[Ul+16>>2]=1232;Xl=q[Ul+24>>2];if(Xl){q[Ul+28>>2]=Xl;An(Xl)}if(ci){break b}}Wl=Wl+1|0;continue}}am=n[q[q[Ye>>2]+24>>2]](Ye)|0;q[Ul+712>>2]=0;q[Ul+704>>2]=0;q[Ul+708>>2]=0;h:{i:{if(!am){Wl=q[q[Ye>>2]+20>>2];break i}if(am>>>0>=214748365){break c}ci=w(am,20);Wl=Mm(ci);q[Ul+704>>2]=Wl;q[Ul+708>>2]=Wl;q[Ul+712>>2]=ci+Wl;Dn(Wl,0,ci);ci=am;while(1){Wl=Wl+20|0;ci=ci+ -1|0;if(ci){continue}break}q[Ul+708>>2]=Wl;Wl=q[q[Ye>>2]+20>>2];if(!am){break i}ci=0;while(1){Tl=n[Wl](Ye,ci)|0;Vl=q[q[q[(n[q[q[Ye>>2]+28>>2]](Ye)|0)+4>>2]+8>>2]+(Tl<<2)>>2];Wl=q[Vl+28>>2];Tl=bk(Wl);Zl=(Tl|0)>0?Tl:0;if(Zl>>>0>4){break h}Tl=q[Ul+704>>2]+w(ci,20)|0;$l=o[Vl+24|0];q[Tl+16>>2]=$l;q[Tl+12>>2]=Zl;q[Tl+8>>2]=Wl;q[Tl+4>>2]=Xl;q[Tl>>2]=Vl;Xl=Xl+$l|0;Wl=q[q[Ye>>2]+20>>2];ci=ci+1|0;if((am|0)!=(ci|0)){continue}break}}ci=n[Wl](Ye,0)|0;cm=q[q[q[(n[q[q[Ye>>2]+28>>2]](Ye)|0)+4>>2]+8>>2]+(ci<<2)>>2];o[cm+84|0]=1;q[cm+72>>2]=q[cm+68>>2];_l=q[Zh+8>>2];$l=q[Zh+16>>2];Vl=q[Zh+12>>2];ci=Vl;Tl=q[Zh+20>>2];if((ci|0)<(Tl|0)?1:(ci|0)<=(Tl|0)?_l>>>0>$l>>>0?0:1:0){break h}dm=q[Zh>>2];fm=r[dm+$l|0];Zl=Zh;ci=Tl;Wl=$l+1|0;if(Wl>>>0<1){ci=ci+1|0}bm=Wl;Wl=ci;q[Zl+16>>2]=bm;q[Zl+20>>2]=ci;if(fm>>>0>1){break h}j:{if(fm-1){if((Vl|0)<(Wl|0)?1:(Vl|0)<=(Wl|0)?_l>>>0>bm>>>0?0:1:0){break h}Ye=Tl;am=$l+2|0;if(am>>>0<2){Ye=Ye+1|0}ci=Zh;q[ci+16>>2]=am;q[ci+20>>2]=Ye;Ye=$l+6|0;if(Ye>>>0<6){Tl=Tl+1|0}Wl=Ye;Ye=Tl;if((Vl|0)<(Ye|0)?1:(Vl|0)<=(Ye|0)?_l>>>0>=Wl>>>0?0:1:0){break h}ci=am+dm|0;ci=r[ci|0]|r[ci+1|0]<<8|(r[ci+2|0]<<16|r[ci+3|0]<<24);q[Zh+16>>2]=Wl;q[Zh+20>>2]=Ye;td(cm,ci);Ye=Ul+672|0;q[Ye+20>>2]=0;q[Ye+12>>2]=0;q[Ye+16>>2]=0;q[Ye>>2]=0;q[Ye+4>>2]=0;q[Ye+20>>2]=ci;ci=Ye;Ye=Ld(Ul+16|0,Ul+704|0);ci=je(ci,Zh,Ye);Zh=q[Ye+16>>2];if(Zh){q[Ye+20>>2]=Zh;An(Zh)}Zh=q[Ye>>2];if(Zh){q[Ye+4>>2]=Zh;An(Zh)}if(ci){break j}break h}if((Vl|0)<(Wl|0)?1:(Vl|0)<=(Wl|0)?_l>>>0>bm>>>0?0:1:0){break h}Zl=r[bm+dm|0];ci=Tl;bm=$l+2|0;if(bm>>>0<2){ci=ci+1|0}q[Zh+16>>2]=bm;q[Zh+20>>2]=ci;if(Zl>>>0>=7){q[Ul>>2]=Zl;Yl(1644,Ul);break h}ci=$l+6|0;if(ci>>>0<6){Tl=Tl+1|0}Wl=ci;ci=Tl;if((Vl|0)<(ci|0)?1:(Vl|0)<=(ci|0)?_l>>>0>=Wl>>>0?0:1:0){break h}Tl=bm+dm|0;Vl=r[Tl|0]|r[Tl+1|0]<<8|(r[Tl+2|0]<<16|r[Tl+3|0]<<24);q[Zh+16>>2]=Wl;q[Zh+20>>2]=ci;if(am){ci=0;while(1){Tl=n[q[q[Ye>>2]+20>>2]](Ye,ci)|0;Tl=q[q[q[(n[q[q[Ye>>2]+28>>2]](Ye)|0)+4>>2]+8>>2]+(Tl<<2)>>2];td(Tl,Vl);o[Tl+84|0]=1;q[Tl+72>>2]=q[Tl+68>>2];ci=ci+1|0;if((am|0)!=(ci|0)){continue}break}}Wl=1;Ye=Ld(Ul+672|0,Ul+704|0);k:{if(Zl>>>0>6){break k}l:{m:{switch(Zl-1|0){default:ci=Od(Ul+16|0,Xl);Zh=Md(ci,Zh,Ye);Nd(ci);if(Zh){break l}break k;case 0:ci=Od(Ul+16|0,Xl);Zh=Pd(ci,Zh,Ye);Nd(ci);if(Zh){break l}break k;case 1:ci=Sd(Ul+16|0,Xl);Zh=Qd(ci,Zh,Ye);Rd(ci);if(Zh){break l}break k;case 2:ci=Sd(Ul+16|0,Xl);Zh=Td(ci,Zh,Ye);Rd(ci);if(Zh){break l}break k;case 3:ci=Wd(Ul+16|0,Xl);Zh=Ud(ci,Zh,Ye);Vd(ci);if(Zh){break l}break k;case 4:ci=Wd(Ul+16|0,Xl);Zh=Xd(ci,Zh,Ye);Vd(ci);if(Zh){break l}break k;case 5:break m}}ci=Wd(Ul+16|0,Xl);Zh=Yd(ci,Zh,Ye);Vd(ci);if(!Zh){break k}}Wl=0}Zh=q[Ye+16>>2];if(Zh){q[Ye+20>>2]=Zh;An(Zh)}Zh=q[Ye>>2];if(Zh){q[Ye+4>>2]=Zh;An(Zh)}if(Wl){break h}}gm=1}Ye=q[Ul+704>>2];if(!Ye){break a}q[Ul+708>>2]=Ye;An(Ye);break a}bn();F()}bn();F()}Ye=q[Ul+672>>2];if(!Ye){break a}q[Ul+676>>2]=Ye;An(Ye)}T=Ul+720|0;return gm|0}function he(Ye,Zh,Yl){var km=0,lm=0,mm=0,nm=0;a:{if(Ye>>>0>5){break a}mm=q[Yl+16>>2];km=q[Yl+12>>2];lm=q[Yl+20>>2];if((km|0)<(lm|0)?1:(km|0)<=(lm|0)?t[Yl+8>>2]>mm>>>0?0:1:0){break a}km=r[mm+q[Yl>>2]|0];mm=mm+1|0;if(mm>>>0<1){lm=lm+1|0}q[Yl+16>>2]=mm;q[Yl+20>>2]=lm;lm=Zh;if(km&128){if(!he(Ye+1|0,Zh,Yl)){break a}Ye=q[Zh>>2]<<7;q[Zh>>2]=Ye;km=Ye|km&127}q[lm>>2]=km;nm=1}return nm}function ie(Ye,Zh){var Yl=0,om=0,pm=0,qm=0,rm=0,sm=0,tm=0;a:{b:{c:{om=q[Ye>>2];rm=(q[Ye+4>>2]-om|0)/24|0;Yl=rm+1|0;if(Yl>>>0<178956971){om=(q[Ye+8>>2]-om|0)/24|0;sm=om<<1;om=om>>>0<89478485?sm>>>0<Yl>>>0?Yl:sm:178956970;pm=0;d:{if(!om){break d}if(om>>>0>=178956971){break c}pm=Mm(w(om,24))}Yl=pm+w(rm,24)|0;ve(Yl,Zh);rm=pm+w(om,24)|0;sm=Yl+24|0;Zh=q[Ye+4>>2];pm=q[Ye>>2];if((Zh|0)==(pm|0)){break b}while(1){Yl=Yl+ -24|0;q[Yl>>2]=1232;om=q[Zh+ -20>>2];qm=Yl+16|0;q[qm>>2]=0;q[Yl+8>>2]=0;q[Yl+12>>2]=0;q[Yl+4>>2]=om;om=Zh+ -16|0;q[Yl+8>>2]=q[om>>2];q[Yl+12>>2]=q[Zh+ -12>>2];tm=qm;qm=Zh+ -8|0;q[tm>>2]=q[qm>>2];q[qm>>2]=0;q[om>>2]=0;q[om+4>>2]=0;q[Yl+20>>2]=q[Zh+ -4>>2];Zh=Zh+ -24|0;if((pm|0)!=(Zh|0)){continue}break}pm=q[Ye+4>>2];Zh=q[Ye>>2];break a}bn();F()}ab(1780);F()}Zh=pm}q[Ye>>2]=Yl;q[Ye+8>>2]=rm;q[Ye+4>>2]=sm;if((Zh|0)!=(pm|0)){while(1){pm=pm+ -24|0;n[q[q[pm>>2]>>2]](pm)|0;if((Zh|0)!=(pm|0)){continue}break}}if(Zh){An(Zh)}}function je(Ye,Zh,um){var vm=0,wm=0,xm=0,ym=0,zm=0,Am=0,Bm=0,Cm=0,Dm=0,Em=0;wm=T-32|0;T=wm;q[wm+24>>2]=0;q[wm+16>>2]=0;q[wm+20>>2]=0;zm=q[Zh+12>>2];xm=zm;ym=q[Zh+20>>2];Am=ym;Bm=q[Zh+16>>2];vm=Bm+4|0;if(vm>>>0<4){ym=ym+1|0}Dm=q[Zh+8>>2];Cm=vm;a:{if((xm|0)<(ym|0)?1:(xm|0)<=(ym|0)?Dm>>>0>=vm>>>0?0:1:0){break a}xm=q[Zh>>2];vm=Bm+xm|0;vm=r[vm|0]|r[vm+1|0]<<8|(r[vm+2|0]<<16|r[vm+3|0]<<24);q[Zh+16>>2]=Cm;q[Zh+20>>2]=ym;b:{c:{vm=vm+ -2|0;if(vm>>>0<=1){if(vm-1){break c}if((zm|0)<(ym|0)?1:(zm|0)<=(ym|0)?Dm>>>0>Cm>>>0?0:1:0){break a}xm=o[xm+Cm|0];vm=Bm+5|0;if(vm>>>0<5){Am=Am+1|0}q[Zh+16>>2]=vm;q[Zh+20>>2]=Am;q[Ye+8>>2]=xm;if((xm|0)==1){if(ol(Ye,Zh,wm+16|0)){break b}break a}Gl(1848,23,q[3794]);break a}Gl(1872,24,q[3794]);break a}if(!ol(Ye,Zh,wm+16|0)){break a}}q[wm+8>>2]=q[wm+16>>2];q[wm>>2]=q[wm+20>>2];ke(wm+8|0,wm,Ye,um);Em=1}Ye=q[wm+16>>2];if(Ye){q[wm+20>>2]=Ye;An(Ye)}T=wm+32|0;return Em}function ke(Ye,Zh,um,Fm){var Gm=0,Hm=0,Im=0,Jm=x(0),Km=0,Lm=0,Mm=0,Nm=0;Gm=T-32|0;T=Gm;Hm=q[um>>2];Jm=u[um+4>>2];Lm=hk(Gm+24|0);Hm=-1<<Hm^-1;ik(Lm,Jm,Hm);um=q[Ye>>2];if((um|0)!=q[Zh>>2]){Ye=q[Fm+28>>2];Mm=Fm+16|0;while(1){Im=q[um>>2];Km=q[um+4>>2];Jm=u[Lm>>2];u[Gm+16>>2]=Jm*x(q[um+8>>2]-Hm|0);u[Gm+12>>2]=Jm*x(Km-Hm|0);u[Gm+8>>2]=Jm*x(Im-Hm|0);Km=q[Mm>>2];Im=q[Km>>2];if(!r[Im+84|0]){Ye=q[q[Im+68>>2]+(Ye<<2)>>2]}Nm=Ye;Ye=q[Im+40>>2];Cn(q[q[Im>>2]>>2]+w(Nm,Ye)|0,(Gm+8|0)+(q[Km+4>>2]<<2)|0,Ye);Ye=q[Fm+28>>2]+1|0;q[Fm+28>>2]=Ye;um=um+12|0;if((um|0)!=q[Zh>>2]){continue}break}}T=Gm+32|0}function le(Ye){Ye=Ye|0;var Zh=0,um=0,Fm=0,Om=0,Pm=0,Qm=0,Rm=0,Sm=0,Tm=0,Um=0,Vm=0,Wm=0,Xm=0,Ym=0,Zm=0,_m=0,$m=0,an=0,cn=0,dn=x(0);Om=T-32|0;T=Om;a:{b:{c:{if(!(q[Ye+60>>2]!=q[Ye- -64>>2]|q[Ye+48>>2]!=q[Ye+52>>2])){Zh=1;break c}Zh=1;if((n[q[q[Ye>>2]+24>>2]](Ye)|0)<1){break c}Zm=Ye+60|0;_m=Ye+36|0;d:{while(1){e:{Zh=n[q[q[Ye>>2]+20>>2]](Ye,Xm)|0;Qm=q[q[q[(n[q[q[Ye>>2]+28>>2]](Ye)|0)+4>>2]+8>>2]+(Zh<<2)>>2];Sm=Qm+28|0;Zh=q[Sm>>2]+ -1|0;f:{if(Zh>>>0>8){break f}g:{switch(Zh-1|0){default:Fm=Qm+24|0;Zh=o[Fm|0];um=0;q[Om+24>>2]=0;q[Om+16>>2]=0;q[Om+20>>2]=0;if(Zh){if((Zh|0)<=-1){break b}Zh=Zh<<2;um=Mm(Zh);q[Om+16>>2]=um;Pm=Zh+um|0;q[Om+24>>2]=Pm;Dn(um,0,Zh);q[Om+20>>2]=Pm;um=r[Fm|0]}q[Om+8>>2]=0;q[Om>>2]=0;q[Om+4>>2]=0;if(um&255){Zh=um<<24>>24;if((Zh|0)<=-1){break a}Zh=Zh<<2;um=Mm(Zh);q[Om>>2]=um;Pm=Zh+um|0;q[Om+8>>2]=Pm;Dn(um,0,Zh);q[Om+4>>2]=Pm}Zh=q[Sm>>2]+ -1|0;h:{i:{if(Zh>>>0>4){break i}j:{switch(Zh-1|0){case 3:Zh=1;if(me(Ye,Qm,Wm)){break i}break h;case 1:Zh=1;if(ne(Ye,Qm,Wm)){break i}break h;case 0:case 2:break i;default:break j}}Zh=1;if(!oe(Ye,Qm,Wm)){break h}}Wm=o[Fm|0]+Wm|0;Zh=0}Fm=q[Om>>2];if(Fm){q[Om+4>>2]=Fm;An(Fm)}Fm=q[Om+16>>2];if(Fm){q[Om+20>>2]=Fm;An(Fm)}if(!Zh){break f}break d;case 0:case 2:case 4:case 5:case 6:break f;case 7:break g}}Sm=q[q[Zm>>2]+(Rm<<2)>>2];Vm=q[_m>>2];Zh=n[q[q[Ye>>2]+28>>2]](Ye)|0;Pm=q[Qm+56>>2];Tm=q[Zh+40>>2];Zh=Mm(32);q[Om+16>>2]=Zh;q[Om+20>>2]=24;q[Om+24>>2]=-2147483616;o[Zh+24|0]=0;Fm=r[1726]|r[1727]<<8|(r[1728]<<16|r[1729]<<24);um=r[1722]|r[1723]<<8|(r[1724]<<16|r[1725]<<24);o[Zh+16|0]=um;o[Zh+17|0]=um>>>8;o[Zh+18|0]=um>>>16;o[Zh+19|0]=um>>>24;o[Zh+20|0]=Fm;o[Zh+21|0]=Fm>>>8;o[Zh+22|0]=Fm>>>16;o[Zh+23|0]=Fm>>>24;Fm=r[1718]|r[1719]<<8|(r[1720]<<16|r[1721]<<24);um=r[1714]|r[1715]<<8|(r[1716]<<16|r[1717]<<24);o[Zh+8|0]=um;o[Zh+9|0]=um>>>8;o[Zh+10|0]=um>>>16;o[Zh+11|0]=um>>>24;o[Zh+12|0]=Fm;o[Zh+13|0]=Fm>>>8;o[Zh+14|0]=Fm>>>16;o[Zh+15|0]=Fm>>>24;Fm=r[1710]|r[1711]<<8|(r[1712]<<16|r[1713]<<24);um=r[1706]|r[1707]<<8|(r[1708]<<16|r[1709]<<24);o[Zh|0]=um;o[Zh+1|0]=um>>>8;o[Zh+2|0]=um>>>16;o[Zh+3|0]=um>>>24;o[Zh+4|0]=Fm;o[Zh+5|0]=Fm>>>8;o[Zh+6|0]=Fm>>>16;o[Zh+7|0]=Fm>>>24;k:{l:{Fm=Tm+16|0;um=Fm;Zh=q[um>>2];if(!Zh){break l}while(1){Um=q[Zh+16>>2]<(Pm|0);um=Um?um:Zh;Zh=q[(Um<<2)+Zh>>2];if(Zh){continue}break}if((um|0)==(Fm|0)|(Pm|0)<q[um+16>>2]){break l}Zh=um+20|0;if(!ga(Zh,Om+16|0)){break l}Zh=gk(Zh,Om+16|0);break k}Zh=gk(Tm,Om+16|0)}if(o[Om+27|0]<=-1){An(q[Om+16>>2])}Fm=Rm+1|0;m:{if(Zh){ud(Qm,Sm);break m}Zh=Vm+w(Rm,24)|0;um=q[Zh+4>>2];Rm=o[Qm+24|0];Vm=Rm<<2;Pm=Mm((Rm|0)!=(Rm&1073741823)?-1:Vm);if(!ik(hk(Om+16|0),u[Zh+20>>2],-1<<um^-1)){break e}if(q[Sm+80>>2]){$m=q[q[Sm>>2]>>2]+q[Sm+48>>2]|0;an=Zh+8|0;Um=0;Tm=0;um=0;while(1){if((Rm|0)>=1){cn=q[an>>2];Zh=0;dn=u[Om+16>>2];while(1){Ym=Zh<<2;u[Ym+Pm>>2]=x(dn*x(q[$m+(um<<2)>>2]))+u[cn+Ym>>2];um=um+1|0;Zh=Zh+1|0;if((Rm|0)!=(Zh|0)){continue}break}}Cn(q[q[Qm- -64>>2]>>2]+Tm|0,Pm,Vm);Tm=Tm+Vm|0;Um=Um+1|0;if(Um>>>0<t[Sm+80>>2]){continue}break}}An(Pm)}Rm=Fm}Zh=1;Xm=Xm+1|0;if((Xm|0)<(n[q[q[Ye>>2]+24>>2]](Ye)|0)){continue}break c}break}An(Pm)}Zh=0}T=Om+32|0;return Zh|0}bn();F()}bn();F()}function me(Ye,en,fn){var gn=0,hn=0,jn=0,kn=0,ln=0,mn=0,nn=0,on=0,pn=0,qn=0,rn=0,sn=0,tn=0,un=0,vn=0;hn=T-16|0;T=hn;gn=o[en+24|0];q[hn+8>>2]=0;q[hn>>2]=0;q[hn+4>>2]=0;a:{b:{if(gn){if((gn|0)<=-1){break b}jn=gn<<2;kn=Mm(jn);q[hn>>2]=kn;ln=jn+kn|0;q[hn+8>>2]=ln;Dn(kn,0,jn);q[hn+4>>2]=ln;pn=Mm(jn);jn=Dn(pn,0,jn)}else{jn=0}if(!q[en+80>>2]){break a}sn=en+40|0;un=en+48|0;vn=Ye+48|0;while(1){tn=q[en>>2];mn=q[tn>>2];qn=q[un>>2];Ye=q[sn>>2];ln=$n(Ye,q[sn+4>>2],rn,nn);on=mn;mn=ln+qn|0;ln=Cn(kn,on+mn|0,Ye);if(gn<<24>>24>=1){mn=gn&255;qn=q[vn>>2];gn=0;while(1){on=gn<<2;q[on+jn>>2]=q[(fn+gn<<2)+qn>>2]+q[ln+on>>2];gn=gn+1|0;if(gn>>>0<mn>>>0){continue}break}}Cn(q[tn>>2]+w(Ye,rn)|0,pn,Ye);Ye=rn+1|0;if(Ye>>>0<1){nn=nn+1|0}rn=Ye;if(!nn&Ye>>>0>=t[en+80>>2]|nn>>>0>0){break a}gn=r[en+24|0];continue}}bn();F()}if(jn){An(pn)}if(kn){q[hn+4>>2]=kn;An(kn)}T=hn+16|0;return 1}function ne(Ye,en,fn){var wn=0,xn=0,yn=0,zn=0,Bn=0,En=0,Fn=0,Gn=0,Hn=0,In=0,Jn=0,Kn=0,Ln=0,Mn=0,Nn=0;xn=T-16|0;T=xn;wn=o[en+24|0];q[xn+8>>2]=0;q[xn>>2]=0;q[xn+4>>2]=0;a:{b:{if(wn){if((wn|0)<=-1){break b}yn=wn<<1;zn=Mm(yn);q[xn>>2]=zn;Bn=yn+zn|0;q[xn+8>>2]=Bn;Dn(zn,0,yn);q[xn+4>>2]=Bn;Hn=Mm(yn);yn=Dn(Hn,0,yn)}else{yn=0}if(!q[en+80>>2]){break a}Kn=en+40|0;Mn=en+48|0;Nn=Ye+48|0;while(1){Ln=q[en>>2];En=q[Ln>>2];In=q[Mn>>2];Ye=q[Kn>>2];Bn=$n(Ye,q[Kn+4>>2],Jn,Fn);Gn=En;En=Bn+In|0;Bn=Cn(zn,Gn+En|0,Ye);if(wn<<24>>24>=1){En=wn&255;In=q[Nn>>2];wn=0;while(1){Gn=wn<<1;p[Gn+yn>>1]=s[Bn+Gn>>1]+s[(fn+wn<<2)+In>>1];wn=wn+1|0;if(wn>>>0<En>>>0){continue}break}}Cn(q[Ln>>2]+w(Ye,Jn)|0,Hn,Ye);Ye=Jn+1|0;if(Ye>>>0<1){Fn=Fn+1|0}Jn=Ye;if(!Fn&Ye>>>0>=t[en+80>>2]|Fn>>>0>0){break a}wn=r[en+24|0];continue}}bn();F()}if(yn){An(Hn)}if(zn){q[xn+4>>2]=zn;An(zn)}T=xn+16|0;return 1}function oe(Ye,en,fn){var Dn=0,On=0,Pn=0,Qn=0,Rn=0,Sn=0,Tn=0,Un=0,Vn=0,Wn=0;On=T-32|0;T=On;Dn=o[en+24|0];q[On+24>>2]=0;q[On+16>>2]=0;q[On+20>>2]=0;a:{b:{c:{if(Dn){if((Dn|0)<=-1){break c}Pn=Mm(Dn);q[On+16>>2]=Pn;q[On+20>>2]=Pn;q[On+24>>2]=Dn+Pn;while(1){o[Pn|0]=0;Pn=q[On+20>>2]+1|0;q[On+20>>2]=Pn;Dn=Dn+ -1|0;if(Dn){continue}break}Pn=r[en+24|0]}q[On+8>>2]=0;q[On>>2]=0;q[On+4>>2]=0;if(Pn&255){if(Pn<<24>>24<=-1){break b}Pn=Pn<<24>>24;Dn=Mm(Pn);q[On>>2]=Dn;q[On+4>>2]=Dn;q[On+8>>2]=Dn+Pn;while(1){o[Dn|0]=0;Dn=q[On+4>>2]+1|0;q[On+4>>2]=Dn;Pn=Pn+ -1|0;if(Pn){continue}break}}if(!q[en+80>>2]){Dn=q[On>>2];break a}Pn=en+40|0;Un=en+48|0;Tn=en+24|0;while(1){Vn=q[On+16>>2];Wn=q[q[en>>2]>>2];Dn=q[Pn>>2];Qn=q[Un>>2]+$n(Dn,q[Pn+4>>2],Rn,Sn)|0;Dn=Cn(Vn,Wn+Qn|0,Dn);d:{if(o[Tn|0]<1){break d}Qn=Ye+48|0;o[q[On>>2]]=r[Dn|0]+r[q[Qn>>2]+(fn<<2)|0];Dn=1;if(o[Tn|0]<2){break d}while(1){o[q[On>>2]+Dn|0]=r[q[On+16>>2]+Dn|0]+r[q[Qn>>2]+(fn+Dn<<2)|0];Dn=Dn+1|0;if((Dn|0)<o[Tn|0]){continue}break}}Qn=q[Pn>>2];Dn=q[On>>2];Cn(q[q[en>>2]>>2]+w(Qn,Rn)|0,Dn,Qn);Rn=Rn+1|0;if(Rn>>>0<1){Sn=Sn+1|0}Qn=Rn;if(!Sn&Qn>>>0<t[en+80>>2]|Sn>>>0<0){continue}break}break a}bn();F()}bn();F()}if(Dn){q[On+4>>2]=Dn;An(Dn)}Ye=q[On+16>>2];if(Ye){q[On+20>>2]=Ye;An(Ye)}T=On+32|0;return 1}function pe(Ye){Ye=Ye|0;var bn=0,en=0,fn=0,Cn=0;q[Ye>>2]=1596;bn=q[Ye+60>>2];if(bn){Cn=Ye- -64|0;en=q[Cn>>2];fn=bn;a:{if((bn|0)==(en|0)){break a}while(1){en=en+ -4|0;fn=q[en>>2];q[en>>2]=0;if(fn){Hb(fn)}if((bn|0)!=(en|0)){continue}break}fn=q[Ye+60>>2]}q[Cn>>2]=bn;An(fn)}bn=q[Ye+48>>2];if(bn){q[Ye+52>>2]=bn;An(bn)}bn=q[Ye+36>>2];if(bn){Cn=Ye+40|0;en=q[Cn>>2];fn=bn;b:{if((bn|0)==(en|0)){break b}while(1){en=en+ -24|0;n[q[q[en>>2]>>2]](en)|0;if((bn|0)!=(en|0)){continue}break}fn=q[Ye+36>>2]}q[Cn>>2]=bn;An(fn)}q[Ye>>2]=1384;bn=q[Ye+16>>2];if(bn){q[Ye+20>>2]=bn;An(bn)}bn=q[Ye+4>>2];if(bn){q[Ye+8>>2]=bn;An(bn)}return Ye|0}function qe(q){q=q|0;An(pe(q))}function re(Ye){var Xn=0,Yn=0,Zn=0,_n=0,$n=0,ao=0,bo=0,co=0,eo=0,fo=0,go=0,ho=0;ao=T-32|0;T=ao;a:{b:{Xn=Ye+16|0;Yn=q[Xn>>2];if(Yn>>>0>=341){q[Xn>>2]=Yn+ -341;Xn=Ye+4|0;Yn=q[Xn>>2];eo=q[Yn>>2];Yn=Yn+4|0;q[Xn>>2]=Yn;co=Ye+8|0;Zn=q[co>>2];Xn=q[Ye+12>>2];c:{if((Zn|0)!=(Xn|0)){break c}_n=q[Ye>>2];if(Yn>>>0>_n>>>0){Zn=Zn-Yn|0;bo=Zn>>2;_n=((Yn-_n>>2)+1|0)/-2<<2;$n=_n+Yn|0;Xn=Ye;if(Zn){En($n,Yn,Zn);Yn=q[Ye+4>>2]}q[Xn+4>>2]=Yn+_n;Zn=$n+(bo<<2)|0;q[Ye+8>>2]=Zn;break c}Xn=Xn-_n|0;Xn=Xn?Xn>>1:1;if(Xn>>>0>=1073741824){break b}$n=Xn<<2;bo=Mm($n);fo=$n+bo|0;$n=bo+(Xn&-4)|0;Xn=$n;if((Yn|0)!=(Zn|0)){Xn=$n;while(1){q[Xn>>2]=q[Yn>>2];Xn=Xn+4|0;Yn=Yn+4|0;if((Zn|0)!=(Yn|0)){continue}break}_n=q[Ye>>2]}q[Ye>>2]=bo;q[Ye+12>>2]=fo;Yn=Ye+8|0;q[Yn>>2]=Xn;q[Ye+4>>2]=$n;if(!_n){Zn=Xn;break c}An(_n);Zn=q[Yn>>2]}q[Zn>>2]=eo;q[co>>2]=q[co>>2]+4;break a}d:{Yn=q[Ye+8>>2];Zn=Yn-q[Ye+4>>2]>>2;$n=Ye+12|0;_n=q[$n>>2];Xn=_n-q[Ye>>2]|0;if(Zn>>>0<Xn>>2>>>0){if((Yn|0)!=(_n|0)){go=ao,ho=Mm(4092),q[go+8>>2]=ho;te(Ye,ao+8|0);break a}go=ao,ho=Mm(4092),q[go+8>>2]=ho;ue(Ye,ao+8|0);Xn=Ye+4|0;Yn=q[Xn>>2];eo=q[Yn>>2];Yn=Yn+4|0;q[Xn>>2]=Yn;co=Ye+8|0;Zn=q[co>>2];Xn=q[Ye+12>>2];e:{if((Zn|0)!=(Xn|0)){break e}_n=q[Ye>>2];if(Yn>>>0>_n>>>0){Zn=Zn-Yn|0;bo=Zn>>2;_n=((Yn-_n>>2)+1|0)/-2<<2;$n=_n+Yn|0;Xn=Ye;if(Zn){En($n,Yn,Zn);Yn=q[Ye+4>>2]}q[Xn+4>>2]=Yn+_n;Zn=$n+(bo<<2)|0;q[Ye+8>>2]=Zn;break e}Xn=Xn-_n|0;Xn=Xn?Xn>>1:1;if(Xn>>>0>=1073741824){break d}$n=Xn<<2;bo=Mm($n);fo=$n+bo|0;$n=bo+(Xn&-4)|0;Xn=$n;if((Yn|0)!=(Zn|0)){Xn=$n;while(1){q[Xn>>2]=q[Yn>>2];Xn=Xn+4|0;Yn=Yn+4|0;if((Zn|0)!=(Yn|0)){continue}break}_n=q[Ye>>2]}q[Ye>>2]=bo;q[Ye+12>>2]=fo;Yn=Ye+8|0;q[Yn>>2]=Xn;q[Ye+4>>2]=$n;if(!_n){Zn=Xn;break e}An(_n);Zn=q[Yn>>2]}q[Zn>>2]=eo;q[co>>2]=q[co>>2]+4;break a}q[ao+24>>2]=$n;q[ao+20>>2]=0;Xn=Xn?Xn>>1:1;if(Xn>>>0<1073741824){Yn=Xn<<2;Xn=Mm(Yn);q[ao+8>>2]=Xn;Zn=Xn+(Zn<<2)|0;q[ao+16>>2]=Zn;q[ao+20>>2]=Xn+Yn;q[ao+12>>2]=Zn;go=ao,ho=Mm(4092),q[go+4>>2]=ho;te(ao+8|0,ao+4|0);Yn=q[Ye+8>>2];Xn=Ye+4|0;while(1){$n=q[Xn>>2];if(($n|0)==(Yn|0)){Zn=q[Ye>>2];q[Ye>>2]=q[ao+8>>2];q[ao+8>>2]=Zn;q[Ye+4>>2]=q[ao+12>>2];q[ao+12>>2]=$n;_n=Ye+8|0;Xn=q[_n>>2];q[_n>>2]=q[ao+16>>2];q[ao+16>>2]=Xn;Ye=Ye+12|0;_n=q[Ye>>2];q[Ye>>2]=q[ao+20>>2];q[ao+20>>2]=_n;if((Xn|0)!=(Yn|0)){q[ao+16>>2]=Xn+(((Xn-$n|0)+ -4>>>2^-1)<<2)}if(!Zn){break a}An(Zn);break a}else{Yn=Yn+ -4|0;ue(ao+8|0,Yn);continue}}}ab(1780);F()}ab(1780);F()}ab(1780);F()}T=ao+32|0}function se(Ye){var io=0,jo=0,ko=0,lo=0,mo=0,no=0,oo=0;jo=q[Ye+16>>2];io=(jo>>>0)/341|0;ko=q[Ye+4>>2];no=q[Ye+8>>2];a:{if((ko|0)==(no|0)){mo=Ye+20|0;break a}lo=(io<<2)+ko|0;io=q[lo>>2]+w(jo-w(io,341)|0,12)|0;mo=Ye+20|0;jo=jo+q[mo>>2]|0;oo=(jo>>>0)/341|0;jo=q[(oo<<2)+ko>>2]+w(jo-w(oo,341)|0,12)|0;if((io|0)==(jo|0)){break a}while(1){io=io+12|0;if((io-q[lo>>2]|0)==4092){io=q[lo+4>>2];lo=lo+4|0}if((io|0)!=(jo|0)){continue}break}}q[mo>>2]=0;io=no-ko>>2;if(io>>>0>2){while(1){An(q[ko>>2]);ko=q[Ye+4>>2]+4|0;q[Ye+4>>2]=ko;io=q[Ye+8>>2]-ko>>2;if(io>>>0>2){continue}break}}io=io+ -1|0;if(io>>>0<=1){q[Ye+16>>2]=io-1|0?170:341}}function te(Ye,po){var qo=0,ro=0,so=0,to=0,uo=0,vo=0,wo=0;a:{so=q[Ye+8>>2];qo=q[Ye+12>>2];b:{if((so|0)!=(qo|0)){qo=so;break b}ro=q[Ye+4>>2];to=q[Ye>>2];if(ro>>>0>to>>>0){so=so-ro|0;vo=so>>2;to=((ro-to>>2)+1|0)/-2<<2;uo=to+ro|0;qo=Ye;if(so){En(uo,ro,so);ro=q[Ye+4>>2]}q[qo+4>>2]=ro+to;qo=uo+(vo<<2)|0;q[Ye+8>>2]=qo;break b}qo=qo-to|0;qo=qo?qo>>1:1;if(qo>>>0>=1073741824){break a}uo=qo<<2;vo=Mm(uo);wo=uo+vo|0;uo=vo+(qo&-4)|0;qo=uo;if((ro|0)!=(so|0)){qo=uo;while(1){q[qo>>2]=q[ro>>2];qo=qo+4|0;ro=ro+4|0;if((so|0)!=(ro|0)){continue}break}to=q[Ye>>2]}q[Ye+8>>2]=qo;q[Ye+4>>2]=uo;q[Ye>>2]=vo;q[Ye+12>>2]=wo;if(!to){break b}An(to);qo=q[Ye+8>>2]}q[qo>>2]=q[po>>2];q[Ye+8>>2]=q[Ye+8>>2]+4;return}ab(1780);F()}function ue(Ye,po){var xo=0,yo=0,zo=0,Ao=0,Bo=0,Co=0;a:{zo=q[Ye+4>>2];yo=q[Ye>>2];b:{if((zo|0)!=(yo|0)){xo=zo;break b}Ao=q[Ye+8>>2];xo=q[Ye+12>>2];if(Ao>>>0<xo>>>0){Bo=((xo-Ao>>2)+1|0)/2<<2;xo=Bo+Ao|0;yo=Ao-zo|0;if(yo){xo=xo-yo|0;En(xo,zo,yo);Ao=q[Ye+8>>2]}q[Ye+4>>2]=xo;q[Ye+8>>2]=Ao+Bo;break b}xo=xo-yo|0;xo=xo?xo>>1:1;if(xo>>>0>=1073741824){break a}yo=xo<<2;Bo=Mm(yo);Co=yo+Bo|0;xo=Bo+(xo+3&-4)|0;c:{if((zo|0)==(Ao|0)){yo=xo;break c}yo=xo;while(1){q[yo>>2]=q[zo>>2];yo=yo+4|0;zo=zo+4|0;if((Ao|0)!=(zo|0)){continue}break}zo=q[Ye>>2]}q[Ye+8>>2]=yo;q[Ye+4>>2]=xo;q[Ye>>2]=Bo;q[Ye+12>>2]=Co;if(!zo){break b}An(zo);xo=q[Ye+4>>2]}q[xo+ -4>>2]=q[po>>2];q[Ye+4>>2]=q[Ye+4>>2]+ -4;return}ab(1780);F()}function ve(Ye,An){var po=0,Do=0,Eo=0,Fo=0,Go=0,Ho=0;q[Ye>>2]=1232;po=q[An+4>>2];q[Ye+16>>2]=0;q[Ye+8>>2]=0;q[Ye+12>>2]=0;q[Ye+4>>2]=po;a:{po=q[An+12>>2]-q[An+8>>2]|0;b:{if(!po){break b}Do=po>>2;if(Do>>>0>=1073741824){break a}po=Mm(po);q[Ye+8>>2]=po;Eo=Ye+12|0;q[Eo>>2]=po;q[Ye+16>>2]=po+(Do<<2);Fo=q[An+8>>2];Do=q[An+12>>2]-Fo|0;if((Do|0)<1){break b}Go=Eo,Ho=Cn(po,Fo,Do)+Do|0,q[Go>>2]=Ho}q[Ye+20>>2]=q[An+20>>2];return}bn();F()}function we(Ye){q[Ye+12>>2]=-1;q[Ye+16>>2]=0;q[Ye+4>>2]=0;q[Ye+8>>2]=0;q[Ye>>2]=1908}function xe(Ye,An,Io){Ye=Ye|0;An=An|0;Io=Io|0;q[Ye+4>>2]=An;An=q[q[q[An+4>>2]+8>>2]+(Io<<2)>>2];q[Ye+12>>2]=Io;q[Ye+8>>2]=An;return 1}function ye(Ye,An){Ye=Ye|0;An=An|0;q[Ye+12>>2]=-1;q[Ye+8>>2]=An;return 1}function ze(Ye,An,Io){Ye=Ye|0;An=An|0;Io=Io|0;var Jo=0,Ko=0;Jo=q[Ye+8>>2];a:{if(o[Jo+24|0]<1){break a}if(!td(Jo,q[An+4>>2]-q[An>>2]>>2)){break a}Ko=n[q[q[Ye>>2]+32>>2]](Ye,An,Io)|0}return Ko|0}function Ae(q,Ye,An){q=q|0;Ye=Ye|0;An=An|0;return 1}function Be(Ye){var An=0,Io=0,Lo=0,Mo=0,No=0,Oo=0,Po=0,Qo=0;a:{Lo=q[Ye+8>>2];if(r[Lo+84|0]){break a}An=q[Ye+16>>2];if(!An|!r[An+84|0]){break a}Io=q[Lo+72>>2];Mo=q[Lo+68>>2];o[An+84|0]=0;Io=Io-Mo>>2;No=q[An+68>>2];Mo=q[An+72>>2]-No>>2;b:{if(Io>>>0>Mo>>>0){md(An+68|0,Io-Mo|0,1992);Lo=q[Ye+8>>2];break b}if(Io>>>0>=Mo>>>0){break b}q[An+72>>2]=No+(Io<<2)}An=0;Mo=r[Lo+84|0];Oo=Lo+72|0;Po=Ye+16|0;Qo=Lo+68|0;while(1){if(An>>>0>=(Mo?0:q[Oo>>2]-q[Lo+68>>2]>>2)>>>0){break a}Io=An;No=q[q[Po>>2]+68>>2]+(An<<2)|0;if(!Mo){Io=q[q[Qo>>2]+(An<<2)>>2]}q[No>>2]=Io;An=An+1|0;continue}}return q[Ye+16>>2]}function Ce(Ye,Ro){Ye=Ye|0;Ro=Ro|0;var So=0,To=0,Uo=0;if((n[q[q[Ro>>2]+20>>2]](Ro)|0)>=1){while(1){So=bl(q[q[Ye+4>>2]+4>>2],n[q[q[Ro>>2]+24>>2]](Ro,To)|0);if((So|0)==-1){return 0}a:{Uo=q[Ye+4>>2];if(r[Uo+36|0]<=1){if(n[q[q[Ro>>2]+28>>2]](Ro,q[q[q[Uo+4>>2]+8>>2]+(So<<2)>>2])){break a}return 0}So=Pj(Uo,So);if(!So){return 0}if(n[q[q[Ro>>2]+28>>2]](Ro,So)){break a}return 0}To=To+1|0;if((To|0)<(n[q[q[Ro>>2]+20>>2]](Ro)|0)){continue}break}}return 1}function De(Ye,Ro,Vo){Ye=Ye|0;Ro=Ro|0;Vo=Vo|0;var Wo=0,Xo=0,Yo=0,Zo=0,_o=0,$o=0,ap=0,bp=0,cp=0,dp=0,ep=0;Wo=q[Ro+4>>2];Xo=q[Ro>>2];Ro=q[q[Ye+8>>2]+40>>2];Yo=Ro;Zo=Mm((Ro|0)>-1?Ro:-1);Wo=Wo-Xo|0;if((Wo|0)>=1){dp=Wo>>2;while(1){$o=q[Vo+12>>2];Wo=ep+q[Vo+20>>2]|0;ap=q[Vo+16>>2];_o=Ro+ap|0;if(_o>>>0<Ro>>>0){Wo=Wo+1|0}Xo=Wo;if(($o|0)<(Wo|0)?1:($o|0)<=(Wo|0)?t[Vo+8>>2]>=_o>>>0?0:1:0){An(Zo);return 0}Wo=Cn(Zo,ap+q[Vo>>2]|0,Yo);q[Vo+16>>2]=_o;q[Vo+20>>2]=Xo;Cn(q[q[q[Ye+8>>2]- -64>>2]>>2]+bp|0,Wo,Yo);bp=Yo+bp|0;cp=cp+1|0;if((cp|0)<(dp|0)){continue}break}}An(Zo);return 1}function Ee(Ye){Ye=Ye|0;var Ro=0;q[Ye>>2]=1908;Ro=q[Ye+16>>2];q[Ye+16>>2]=0;if(Ro){Hb(Ro)}return Ye|0}function Fe(Ye){Ye=Ye|0;var Vo=0;q[Ye>>2]=1908;Vo=q[Ye+16>>2];q[Ye+16>>2]=0;if(Vo){Hb(Vo)}An(Ye)}function Ge(Ye,fp){var gp=0;wd(Ye);q[Ye+36>>2]=0;q[Ye+40>>2]=0;q[Ye>>2]=2004;q[Ye+44>>2]=0;q[Ye+48>>2]=0;q[Ye+52>>2]=0;q[Ye+56>>2]=0;gp=q[fp>>2];q[fp>>2]=0;q[Ye+60>>2]=gp}function He(Ye,fp){Ye=Ye|0;fp=fp|0;var hp=0,ip=0,jp=0,kp=0,lp=0,mp=0,np=0,op=0,pp=0,qp=0,rp=0,sp=0,tp=0;lp=T-16|0;T=lp;a:{if(!yd(Ye,fp)){break a}pp=Ye+36|0;mp=n[q[q[Ye>>2]+24>>2]](Ye)|0;jp=q[Ye+40>>2];ip=q[Ye+36>>2];hp=jp-ip>>2;b:{if(mp>>>0>hp>>>0){Ie(pp,mp-hp|0);break b}if(mp>>>0>=hp>>>0){break b}ip=ip+(mp<<2)|0;if((ip|0)!=(jp|0)){while(1){jp=jp+ -4|0;hp=q[jp>>2];q[jp>>2]=0;if(hp){n[q[q[hp>>2]+4>>2]](hp)}if((jp|0)!=(ip|0)){continue}break}}q[Ye+40>>2]=ip}op=1;if((mp|0)<1){break a}op=0;jp=0;while(1){kp=q[fp+16>>2];ip=q[fp+12>>2];hp=q[fp+20>>2];if((ip|0)<(hp|0)?1:(ip|0)<=(hp|0)?t[fp+8>>2]>kp>>>0?0:1:0){break a}np=r[kp+q[fp>>2]|0];kp=kp+1|0;if(kp>>>0<1){hp=hp+1|0}ip=fp;q[ip+16>>2]=kp;q[ip+20>>2]=hp;n[q[q[Ye>>2]+48>>2]](lp+8|0,Ye,np);hp=q[Ye+36>>2];ip=q[lp+8>>2];q[lp+8>>2]=0;kp=jp<<2;np=hp+kp|0;hp=q[np>>2];q[np>>2]=ip;if(hp){n[q[q[hp>>2]+4>>2]](hp)}hp=q[lp+8>>2];q[lp+8>>2]=0;if(hp){n[q[q[hp>>2]+4>>2]](hp)}hp=q[q[pp>>2]+kp>>2];if(!hp){break a}if(!(rp=hp,sp=n[q[q[Ye>>2]+28>>2]](Ye)|0,tp=n[q[q[Ye>>2]+20>>2]](Ye,jp)|0,qp=q[q[hp>>2]+8>>2],n[qp](rp|0,sp|0,tp|0)|0)){break a}jp=jp+1|0;if((mp|0)!=(jp|0)){continue}break}op=1}T=lp+16|0;return op|0}function Ie(Ye,fp){var up=0,vp=0,wp=0,xp=0,yp=0,zp=0,Ap=0,Bp=0,Cp=0;vp=q[Ye+8>>2];wp=Ye+4|0;up=q[wp>>2];if(vp-up>>2>>>0>=fp>>>0){Ye=fp<<2;Bp=wp,Cp=Dn(up,0,Ye)+Ye|0,q[Bp>>2]=Cp;return}a:{wp=q[Ye>>2];xp=up-wp>>2;yp=xp+fp|0;if(yp>>>0<1073741824){xp=xp<<2;vp=vp-wp|0;Ap=vp>>1;vp=vp>>2>>>0<536870911?Ap>>>0<yp>>>0?yp:Ap:1073741823;if(vp){if(vp>>>0>=1073741824){break a}zp=Mm(vp<<2)}xp=xp+zp|0;Dn(xp,0,fp<<2);fp=(yp<<2)+zp|0;yp=(vp<<2)+zp|0;if((up|0)!=(wp|0)){while(1){up=up+ -4|0;vp=q[up>>2];q[up>>2]=0;xp=xp+ -4|0;q[xp>>2]=vp;if((up|0)!=(wp|0)){continue}break}wp=q[Ye>>2];up=q[Ye+4>>2]}q[Ye>>2]=xp;q[Ye+8>>2]=yp;q[Ye+4>>2]=fp;if((up|0)!=(wp|0)){while(1){up=up+ -4|0;Ye=q[up>>2];q[up>>2]=0;if(Ye){n[q[q[Ye>>2]+4>>2]](Ye)}if((up|0)!=(wp|0)){continue}break}}if(wp){An(wp)}return}bn();F()}ab(2144);F()}function Je(Ye,fp){Ye=Ye|0;fp=fp|0;var Dp=0,Ep=0,Fp=0,Gp=0,Hp=0,Ip=0,Jp=0;Dp=q[Ye+60>>2];a:{if(!Dp){break a}q[Dp+4>>2]=Ye+48;if(!n[q[q[Dp>>2]+12>>2]](Dp)){break a}b:{Ep=n[q[q[Ye>>2]+24>>2]](Ye)|0;if((Ep|0)<1){break b}Gp=Ye+60|0;Dp=0;while(1){c:{Hp=q[(n[q[q[Ye>>2]+28>>2]](Ye)|0)+4>>2];Ip=n[q[q[Ye>>2]+20>>2]](Ye,Dp)|0;Fp=q[Gp>>2];if(!n[q[q[Fp>>2]+8>>2]](Fp,q[q[Hp+8>>2]+(Ip<<2)>>2])){break c}Dp=Dp+1|0;if((Ep|0)!=(Dp|0)){continue}break b}break}return 0}if(!n[q[q[Ye>>2]+36>>2]](Ye,fp)){break a}if(!n[q[q[Ye>>2]+40>>2]](Ye,fp)){break a}Jp=n[q[q[Ye>>2]+44>>2]](Ye)|0}return Jp|0}function Ke(Ye,fp){Ye=Ye|0;fp=fp|0;var Kp=0,Lp=0,Mp=0,Np=0,Op=0;Kp=1;Lp=n[q[q[Ye>>2]+24>>2]](Ye)|0;a:{if((Lp|0)<1){break a}Np=Ye+48|0;Kp=0;Op=Ye+36|0;Ye=0;while(1){Mp=q[q[Op>>2]+(Ye<<2)>>2];if(!n[q[q[Mp>>2]+16>>2]](Mp,Np,fp)){break a}Ye=Ye+1|0;if((Lp|0)!=(Ye|0)){continue}break}Kp=1}return Kp|0}function Le(Ye,fp){Ye=Ye|0;fp=fp|0;var Pp=0,Qp=0,Rp=0,Sp=0,Tp=0;Pp=1;Qp=n[q[q[Ye>>2]+24>>2]](Ye)|0;a:{if((Qp|0)<1){break a}Sp=Ye+48|0;Pp=0;Tp=Ye+36|0;Ye=0;while(1){Rp=q[q[Tp>>2]+(Ye<<2)>>2];if(!n[q[q[Rp>>2]+20>>2]](Rp,Sp,fp)){break a}Ye=Ye+1|0;if((Qp|0)!=(Ye|0)){continue}break}Pp=1}return Pp|0}function Me(Ye){Ye=Ye|0;var fp=0,Up=0,Vp=0,Wp=0,Xp=0,Yp=0,Zp=0,_p=0,$p=0,aq=0,bq=0,cq=0,dq=0;Wp=T-16|0;T=Wp;fp=1;Zp=n[q[q[Ye>>2]+24>>2]](Ye)|0;a:{if((Zp|0)<1){break a}dq=Ye+48|0;Yp=Ye+36|0;while(1){b:{c:{if(!q[(n[q[q[Ye>>2]+28>>2]](Ye)|0)+40>>2]){break c}_p=Xp<<2;fp=q[_p+q[Yp>>2]>>2];Up=q[fp+8>>2];$p=Be(fp);if(!$p){break c}fp=n[q[q[Ye>>2]+28>>2]](Ye)|0;aq=q[Up+56>>2];bq=q[fp+40>>2];fp=Mm(32);q[Wp>>2]=fp;q[Wp+4>>2]=24;q[Wp+8>>2]=-2147483616;o[fp+24|0]=0;Up=r[2076]|r[2077]<<8|(r[2078]<<16|r[2079]<<24);Vp=r[2072]|r[2073]<<8|(r[2074]<<16|r[2075]<<24);o[fp+16|0]=Vp;o[fp+17|0]=Vp>>>8;o[fp+18|0]=Vp>>>16;o[fp+19|0]=Vp>>>24;o[fp+20|0]=Up;o[fp+21|0]=Up>>>8;o[fp+22|0]=Up>>>16;o[fp+23|0]=Up>>>24;Up=r[2068]|r[2069]<<8|(r[2070]<<16|r[2071]<<24);Vp=r[2064]|r[2065]<<8|(r[2066]<<16|r[2067]<<24);o[fp+8|0]=Vp;o[fp+9|0]=Vp>>>8;o[fp+10|0]=Vp>>>16;o[fp+11|0]=Vp>>>24;o[fp+12|0]=Up;o[fp+13|0]=Up>>>8;o[fp+14|0]=Up>>>16;o[fp+15|0]=Up>>>24;Up=r[2060]|r[2061]<<8|(r[2062]<<16|r[2063]<<24);Vp=r[2056]|r[2057]<<8|(r[2058]<<16|r[2059]<<24);o[fp|0]=Vp;o[fp+1|0]=Vp>>>8;o[fp+2|0]=Vp>>>16;o[fp+3|0]=Vp>>>24;o[fp+4|0]=Up;o[fp+5|0]=Up>>>8;o[fp+6|0]=Up>>>16;o[fp+7|0]=Up>>>24;d:{e:{Vp=bq+16|0;Up=Vp;fp=q[Up>>2];if(!fp){break e}while(1){cq=q[fp+16>>2]<(aq|0);Up=cq?Up:fp;fp=q[(cq<<2)+fp>>2];if(fp){continue}break}if((Up|0)==(Vp|0)|(aq|0)<q[Up+16>>2]){break e}fp=Up+20|0;if(!ga(fp,Wp)){break e}fp=gk(fp,Wp);break d}fp=gk(bq,Wp)}if(o[Wp+11|0]<=-1){An(q[Wp>>2])}if(!fp){break c}ud(q[q[q[Yp>>2]+_p>>2]+8>>2],$p);break b}fp=q[q[Yp>>2]+(Xp<<2)>>2];if(n[q[q[fp>>2]+24>>2]](fp,dq)){break b}fp=0;break a}fp=1;Xp=Xp+1|0;if((Zp|0)!=(Xp|0)){continue}break}}T=Wp+16|0;return fp|0}function Ne(Ye,eq,fq){Ye=Ye|0;eq=eq|0;fq=fq|0;if(fq>>>0>3){q[Ye>>2]=0;return}a:{b:{switch(fq-1|0){default:eq=Mm(20);we(eq);break a;case 0:eq=Mm(24);Re(eq);break a;case 1:eq=Mm(36);Re(eq);q[eq+32>>2]=0;q[eq+24>>2]=-1;q[eq+28>>2]=0;q[eq>>2]=10764;break a;case 2:break b}}eq=Mm(28);Re(eq);q[eq+24>>2]=-1;q[eq>>2]=6744;q[Ye>>2]=eq;return}q[Ye>>2]=eq}function Oe(Ye){Ye=Ye|0;var eq=0,fq=0,gq=0,hq=0,iq=0;q[Ye>>2]=2004;eq=Ye+60|0;fq=q[eq>>2];q[eq>>2]=0;if(fq){n[q[q[fq>>2]+4>>2]](fq)}eq=q[Ye+48>>2];if(eq){q[Ye+52>>2]=eq;An(eq)}fq=q[Ye+36>>2];if(fq){eq=fq;iq=Ye+40|0;gq=q[iq>>2];hq=eq;a:{if((eq|0)==(gq|0)){break a}while(1){gq=gq+ -4|0;eq=q[gq>>2];q[gq>>2]=0;if(eq){n[q[q[eq>>2]+4>>2]](eq)}if((fq|0)!=(gq|0)){continue}break}hq=q[Ye+36>>2]}eq=hq;q[iq>>2]=fq;An(eq)}q[Ye>>2]=1384;eq=q[Ye+16>>2];if(eq){q[Ye+20>>2]=eq;An(eq)}eq=q[Ye+4>>2];if(eq){q[Ye+8>>2]=eq;An(eq)}return Ye|0}function Pe(Ye){Ye=Ye|0;var jq=0,kq=0,lq=0,mq=0,nq=0;q[Ye>>2]=2004;jq=Ye+60|0;kq=q[jq>>2];q[jq>>2]=0;if(kq){n[q[q[kq>>2]+4>>2]](kq)}jq=q[Ye+48>>2];if(jq){q[Ye+52>>2]=jq;An(jq)}kq=q[Ye+36>>2];if(kq){jq=kq;nq=Ye+40|0;lq=q[nq>>2];mq=jq;a:{if((jq|0)==(lq|0)){break a}while(1){lq=lq+ -4|0;jq=q[lq>>2];q[lq>>2]=0;if(jq){n[q[q[jq>>2]+4>>2]](jq)}if((kq|0)!=(lq|0)){continue}break}mq=q[Ye+36>>2]}jq=mq;q[nq>>2]=kq;An(jq)}q[Ye>>2]=1384;jq=q[Ye+16>>2];if(jq){q[Ye+20>>2]=jq;An(jq)}jq=q[Ye+4>>2];if(jq){q[Ye+8>>2]=jq;An(jq)}An(Ye)}function Qe(Ye,oq){Ye=Ye|0;oq=oq|0;var pq=0,qq=0;qq=q[Ye+16>>2];pq=0;a:{if(q[Ye+20>>2]-qq>>2<=(oq|0)){break a}oq=q[(oq<<2)+qq>>2];pq=0;if((oq|0)<0){break a}pq=Be(q[q[Ye+36>>2]+(oq<<2)>>2])}return pq|0}function Re(Ye){we(Ye);q[Ye+20>>2]=0;q[Ye>>2]=2220}function Se(q,Ye,oq){q=q|0;Ye=Ye|0;oq=oq|0;return xe(q,Ye,oq)|0}function Te(Ye,oq){Ye=Ye|0;oq=oq|0;var rq=0,sq=0;sq=q[Ye+4>>2];a:{if(sq){rq=1;if(r[sq+36|0]<2){break a}}rq=n[q[q[Ye>>2]+48>>2]](Ye,q[oq+4>>2]-q[oq>>2]>>2)|0}return rq|0}function Ue(Ye,oq,tq){Ye=Ye|0;oq=oq|0;tq=tq|0;var uq=0,vq=0,wq=0,xq=0,yq=0,zq=0,Aq=0,Bq=0,Cq=0,Dq=0;wq=T-16|0;T=wq;Aq=q[tq+8>>2];xq=q[tq+16>>2];yq=q[tq+12>>2];uq=yq;vq=q[tq+20>>2];a:{if((uq|0)<(vq|0)?1:(uq|0)<=(vq|0)?Aq>>>0>xq>>>0?0:1:0){break a}Bq=q[tq>>2];Cq=o[Bq+xq|0];uq=vq;zq=xq+1|0;if(zq>>>0<1){uq=uq+1|0}q[tq+16>>2]=zq;q[tq+20>>2]=uq;b:{if((Cq|0)==-2){break b}if((yq|0)<(uq|0)?1:(yq|0)<=(uq|0)?Aq>>>0>zq>>>0?0:1:0){break a}yq=o[zq+Bq|0];xq=xq+2|0;if(xq>>>0<2){vq=vq+1|0}uq=tq;q[uq+16>>2]=xq;q[uq+20>>2]=vq;n[q[q[Ye>>2]+40>>2]](wq+8|0,Ye,Cq,yq);vq=q[wq+8>>2];q[wq+8>>2]=0;uq=q[Ye+20>>2];q[Ye+20>>2]=vq;if(!uq){q[wq+8>>2]=0;break b}n[q[q[uq>>2]+4>>2]](uq);uq=q[wq+8>>2];q[wq+8>>2]=0;if(!uq){break b}n[q[q[uq>>2]+4>>2]](uq)}uq=q[Ye+20>>2];if(uq){if(!n[q[q[Ye>>2]+28>>2]](Ye,uq)){break a}}if(!n[q[q[Ye>>2]+36>>2]](Ye,oq,tq)){break a}tq=q[Ye+4>>2];if(!(!tq|r[tq+36|0]>1)){if(!n[q[q[Ye>>2]+48>>2]](Ye,q[oq+4>>2]-q[oq>>2]>>2)){break a}}Dq=1}T=wq+16|0;return Dq|0}function Ve(Ye,oq,tq,Eq){Ye=Ye|0;oq=oq|0;tq=tq|0;Eq=Eq|0;var Fq=0,Gq=0;Fq=T-48|0;T=Fq;a:{if((Eq|0)!=1){q[Ye>>2]=0;break a}Eq=q[oq+4>>2];oq=q[oq+12>>2];q[Fq+40>>2]=0;Gq=Fq+32|0;q[Gq>>2]=0;q[Gq+4>>2]=0;q[Fq+24>>2]=0;q[Fq+28>>2]=0;q[Fq+16>>2]=0;q[Fq+20>>2]=0;q[Fq+8>>2]=0;q[Fq+12>>2]=0;We(Fq,tq,oq,Eq,Fq+8|0);oq=q[Gq>>2];if(oq){q[Fq+36>>2]=oq;An(oq)}q[Ye>>2]=q[Fq>>2]}T=Fq+48|0}function We(Ye,oq,tq,Eq,Hq){var Iq=0,Jq=0;a:{if((oq|0)!=-2){Jq=q[q[q[Eq+4>>2]+8>>2]+(tq<<2)>>2];if((n[q[q[Eq>>2]+8>>2]](Eq)|0)==1){Iq=oq;oq=s[Eq+36>>1];bf(Ye,Eq,Iq,tq,Hq,(oq<<24|oq<<8&16711680)>>>16);if(q[Ye>>2]){break a}q[Ye>>2]=0}Iq=Mm(44);cf(Iq,Jq,Hq)}q[Ye>>2]=Iq}}function Xe(oq,tq,Eq){oq=oq|0;tq=tq|0;Eq=Eq|0;var Hq=0,Kq=0,Lq=0,Mq=0,Nq=0,Oq=0,Pq=0,Qq=0,Rq=0,Sq=0,Tq=0,Uq=0,Vq=0;a:{Tq=n[q[q[oq>>2]+44>>2]](oq)|0;if((Tq|0)<1){break a}Nq=q[tq+4>>2]-q[tq>>2]>>2;Ye(oq,Nq,Tq);Hq=q[oq+16>>2];if(!q[Hq+80>>2]){break a}Lq=q[q[Hq>>2]>>2];if(!Lq){break a}Pq=q[Eq+8>>2];Oq=q[Eq+16>>2];Mq=q[Eq+12>>2];Qq=Mq;Kq=q[Eq+20>>2];if((Qq|0)<(Kq|0)?1:(Qq|0)<=(Kq|0)?Pq>>>0>Oq>>>0?0:1:0){break a}Qq=w(Nq,Tq);Sq=Lq+q[Hq+48>>2]|0;Uq=q[Eq>>2];Vq=r[Uq+Oq|0];Nq=Eq;Hq=Kq;Lq=Oq+1|0;if(Lq>>>0<1){Hq=Hq+1|0}Rq=Lq;Lq=Hq;q[Nq+16>>2]=Rq;q[Nq+20>>2]=Hq;b:{c:{d:{if(Vq){if(qh(Qq,Tq,Eq,Sq)){break d}break a}if((Mq|0)<(Lq|0)?1:(Mq|0)<=(Lq|0)?Pq>>>0>Rq>>>0?0:1:0){break a}Nq=r[Rq+Uq|0];Hq=Kq;Kq=Oq+2|0;if(Kq>>>0<2){Hq=Hq+1|0}q[Eq+16>>2]=Kq;q[Eq+20>>2]=Hq;Hq=bk(5);Kq=q[q[oq+16>>2]- -64>>2];Kq=q[Kq+4>>2]-q[Kq>>2]|0;e:{if((Hq|0)==(Nq|0)){Nq=Qq<<2;if(Kq>>>0<Nq>>>0){break a}Lq=q[Eq+12>>2];Hq=q[Eq+20>>2];Oq=q[Eq+16>>2];Kq=Nq;Mq=Oq+Kq|0;if(Mq>>>0<Kq>>>0){Hq=Hq+1|0}if((Lq|0)>(Hq|0)?1:(Lq|0)>=(Hq|0)?t[Eq+8>>2]<Mq>>>0?0:1:0){break e}break a}if(Kq>>>0<w(Nq,Qq)>>>0){break a}Oq=q[Eq+12>>2];Hq=q[Eq+20>>2];Pq=q[Eq+8>>2];Lq=Pq;Rq=q[Eq+16>>2];Mq=Rq;Kq=Nq;Vq=Lq-Mq>>>0>=$n(Kq,0,Qq,0)>>>0?0:1;Lq=Oq-(Hq+(Lq>>>0<Mq>>>0)|0)|0;Mq=V;if((Lq|0)<(Mq|0)?1:(Lq|0)<=(Mq|0)?Vq:0){break a}Lq=0;if(!Qq){break c}Mq=0;Lq=Pq;Pq=Kq+Rq|0;if(Pq>>>0<Kq>>>0){Hq=Hq+1|0}if((Oq|0)<(Hq|0)?1:(Oq|0)<=(Hq|0)?Lq>>>0>=Pq>>>0?0:1:0){break b}Pq=0;while(1){Cn(Sq+(Pq<<2)|0,Rq+q[Eq>>2]|0,Nq);Hq=q[Eq+20>>2];Rq=Kq+q[Eq+16>>2]|0;if(Rq>>>0<Kq>>>0){Hq=Hq+1|0}q[Eq+16>>2]=Rq;q[Eq+20>>2]=Hq;Pq=Pq+1|0;if((Qq|0)==(Pq|0)){break d}Oq=q[Eq+12>>2];Uq=Kq+Rq|0;if(Uq>>>0<Kq>>>0){Hq=Hq+1|0}if((Oq|0)>(Hq|0)?1:(Oq|0)>=(Hq|0)?t[Eq+8>>2]<Uq>>>0?0:1:0){continue}break}break b}Cn(Sq,Oq+q[Eq>>2]|0,Nq);Hq=q[Eq+20>>2];Lq=Kq+q[Eq+16>>2]|0;if(Lq>>>0<Kq>>>0){Hq=Hq+1|0}q[Eq+16>>2]=Lq;q[Eq+20>>2]=Hq}Lq=0;if(!Qq){break c}Kq=q[oq+20>>2];if(Kq){Lq=1;if(n[q[q[Kq>>2]+32>>2]](Kq)){break c}}Tj(Sq,Qq,Sq);Lq=1}Kq=q[oq+20>>2];f:{if(!Kq){break f}if(!n[q[q[Kq>>2]+40>>2]](Kq,Eq)){break a}if(!Lq){break f}Mq=0;oq=q[oq+20>>2];if(!n[q[q[oq>>2]+44>>2]](oq,Sq,Sq,Qq,Tq,q[tq>>2])){break b}}Mq=1}return Mq|0}return 0}function Ye(Ye,oq,tq){var Eq=0,Wq=0,Xq=0,Yq=0;Eq=T-80|0;T=Eq;Wq=nd(Eq+16|0);Xq=q[q[Ye+8>>2]+56>>2];Yq=tq<<24>>24;tq=w(bk(5),tq);od(Wq,Xq,Yq,5,0,tq,tq>>31);tq=Mm(96);sd(tq,Wq);q[Eq+8>>2]=tq;o[tq+84|0]=1;q[tq+72>>2]=q[tq+68>>2];td(tq,oq);q[Eq>>2]=0;oq=q[Eq+8>>2];q[Eq+8>>2]=0;tq=Ye+16|0;Ye=q[tq>>2];q[tq>>2]=oq;a:{if(!Ye){q[Eq>>2]=0;break a}Hb(Ye);Ye=q[Eq>>2];q[Eq>>2]=0;if(!Ye){break a}Hb(Ye)}Ye=q[Eq+8>>2];q[Eq+8>>2]=0;if(Ye){Hb(Ye)}T=Eq+80|0}function Ze(Ye,oq){Ye=Ye|0;oq=oq|0;var tq=0,Zq=0,_q=0,$q=0,ar=0,br=0,cr=0,dr=0,er=0;Zq=q[Ye+8>>2];tq=q[Zq+28>>2]+ -1|0;if(tq>>>0>5){return 0}a:{b:{switch(tq-1|0){case 0:$q=o[Zq+24|0];ar=Mm(($q|0)>-1?$q:-1);tq=q[Ye+16>>2];Zq=0;c:{if(!q[tq+80>>2]){break c}Zq=q[q[tq>>2]>>2]+q[tq+48>>2]|0}if(!oq){break a}br=($q|0)<1;dr=Ye+8|0;tq=0;while(1){Ye=0;if(!br){while(1){o[Ye+ar|0]=q[Zq+(tq<<2)>>2];tq=tq+1|0;Ye=Ye+1|0;if(($q|0)!=(Ye|0)){continue}break}}Cn(q[q[q[dr>>2]- -64>>2]>>2]+cr|0,ar,$q);cr=$q+cr|0;_q=_q+1|0;if((_q|0)!=(oq|0)){continue}break}break a;default:$q=o[Zq+24|0];ar=Mm(($q|0)>-1?$q:-1);tq=q[Ye+16>>2];Zq=0;d:{if(!q[tq+80>>2]){break d}Zq=q[q[tq>>2]>>2]+q[tq+48>>2]|0}if(!oq){break a}br=($q|0)<1;dr=Ye+8|0;tq=0;while(1){Ye=0;if(!br){while(1){o[Ye+ar|0]=q[Zq+(tq<<2)>>2];tq=tq+1|0;Ye=Ye+1|0;if(($q|0)!=(Ye|0)){continue}break}}Cn(q[q[q[dr>>2]- -64>>2]>>2]+cr|0,ar,$q);cr=$q+cr|0;_q=_q+1|0;if((_q|0)!=(oq|0)){continue}break}break a;case 2:_q=o[Zq+24|0];Zq=_q+_q|0;ar=Mm(Zq>>>0<_q>>>0?-1:Zq);tq=q[Ye+16>>2];Zq=0;e:{if(!q[tq+80>>2]){break e}Zq=q[q[tq>>2]>>2]+q[tq+48>>2]|0}if(!oq){break a}br=_q<<1;dr=(_q|0)<1;er=Ye+8|0;tq=0;while(1){Ye=0;if(!dr){while(1){p[(Ye<<1)+ar>>1]=q[Zq+(tq<<2)>>2];tq=tq+1|0;Ye=Ye+1|0;if((_q|0)!=(Ye|0)){continue}break}}Cn(q[q[q[er>>2]- -64>>2]>>2]+cr|0,ar,br);cr=cr+br|0;$q=$q+1|0;if(($q|0)!=(oq|0)){continue}break}break a;case 1:_q=o[Zq+24|0];Zq=_q+_q|0;ar=Mm(Zq>>>0<_q>>>0?-1:Zq);tq=q[Ye+16>>2];Zq=0;f:{if(!q[tq+80>>2]){break f}Zq=q[q[tq>>2]>>2]+q[tq+48>>2]|0}if(!oq){break a}br=_q<<1;dr=(_q|0)<1;er=Ye+8|0;tq=0;while(1){Ye=0;if(!dr){while(1){p[(Ye<<1)+ar>>1]=q[Zq+(tq<<2)>>2];tq=tq+1|0;Ye=Ye+1|0;if((_q|0)!=(Ye|0)){continue}break}}Cn(q[q[q[er>>2]- -64>>2]>>2]+cr|0,ar,br);cr=cr+br|0;$q=$q+1|0;if(($q|0)!=(oq|0)){continue}break}break a;case 4:_q=o[Zq+24|0];br=_q<<2;ar=Mm((_q|0)!=(_q&1073741823)?-1:br);tq=q[Ye+16>>2];Zq=0;g:{if(!q[tq+80>>2]){break g}Zq=q[q[tq>>2]>>2]+q[tq+48>>2]|0}if(!oq){break a}dr=(_q|0)<1;er=Ye+8|0;tq=0;while(1){Ye=0;if(!dr){while(1){q[(Ye<<2)+ar>>2]=q[Zq+(tq<<2)>>2];tq=tq+1|0;Ye=Ye+1|0;if((_q|0)!=(Ye|0)){continue}break}}Cn(q[q[q[er>>2]- -64>>2]>>2]+cr|0,ar,br);cr=cr+br|0;$q=$q+1|0;if(($q|0)!=(oq|0)){continue}break}break a;case 3:break b}}_q=o[Zq+24|0];br=_q<<2;ar=Mm((_q|0)!=(_q&1073741823)?-1:br);tq=q[Ye+16>>2];Zq=0;h:{if(!q[tq+80>>2]){break h}Zq=q[q[tq>>2]>>2]+q[tq+48>>2]|0}if(!oq){break a}dr=(_q|0)<1;er=Ye+8|0;tq=0;while(1){Ye=0;if(!dr){while(1){q[(Ye<<2)+ar>>2]=q[Zq+(tq<<2)>>2];tq=tq+1|0;Ye=Ye+1|0;if((_q|0)!=(Ye|0)){continue}break}}Cn(q[q[q[er>>2]- -64>>2]>>2]+cr|0,ar,br);cr=cr+br|0;$q=$q+1|0;if(($q|0)!=(oq|0)){continue}break}}An(ar);return 1}function _e(Ye){Ye=Ye|0;var oq=0,fr=0;q[Ye>>2]=2220;fr=Ye+20|0;oq=q[fr>>2];q[fr>>2]=0;if(oq){n[q[q[oq>>2]+4>>2]](oq)}q[Ye>>2]=1908;fr=Ye+16|0;oq=q[fr>>2];q[fr>>2]=0;if(oq){Hb(oq)}return Ye|0}function $e(Ye){Ye=Ye|0;var gr=0,hr=0;q[Ye>>2]=2220;hr=Ye+20|0;gr=q[hr>>2];q[hr>>2]=0;if(gr){n[q[q[gr>>2]+4>>2]](gr)}q[Ye>>2]=1908;hr=Ye+16|0;gr=q[hr>>2];q[hr>>2]=0;if(gr){Hb(gr)}An(Ye)}function af(Ye){Ye=Ye|0;return o[q[Ye+8>>2]+24|0]}function bf(Ye,ir,jr,kr,lr,mr){var nr=0,or=0,pr=0,qr=0;nr=T-32|0;T=nr;pr=q[q[q[ir+4>>2]+8>>2]+(kr<<2)>>2];a:{b:{if((n[q[q[ir>>2]+8>>2]](ir)|0)!=1|jr+ -1>>>0>5){break b}qr=n[q[q[ir>>2]+36>>2]](ir)|0;or=n[q[q[ir>>2]+44>>2]](ir,kr)|0;if(!(or?qr:0)){q[Ye>>2]=0;break a}kr=n[q[q[ir>>2]+40>>2]](ir,kr)|0;if(kr){ir=q[ir+44>>2];q[nr+12>>2]=kr;q[nr+8>>2]=ir;q[nr+20>>2]=or;q[nr+16>>2]=or+12;df(Ye,jr,pr,lr,nr+8|0,mr);if(q[Ye>>2]){break a}q[Ye>>2]=0;break b}ir=q[ir+44>>2];q[nr+12>>2]=qr;q[nr+8>>2]=ir;q[nr+20>>2]=or;q[nr+16>>2]=or+12;ef(Ye,jr,pr,lr,nr+8|0,mr);if(q[Ye>>2]){break a}q[Ye>>2]=0}q[Ye>>2]=0}T=nr+32|0}function cf(Ye,ir,jr){var kr=0,lr=0,mr=0,rr=0,sr=0,tr=0,ur=0,vr=0;q[Ye>>2]=3044;q[Ye+4>>2]=ir;ir=q[jr+8>>2];kr=q[jr+12>>2];lr=q[jr+16>>2];rr=q[jr+20>>2];sr=q[jr>>2];tr=q[jr+4>>2];q[Ye+40>>2]=0;mr=Ye+32|0;q[mr>>2]=0;q[mr+4>>2]=0;q[Ye+24>>2]=lr;q[Ye+28>>2]=rr;q[Ye+16>>2]=ir;q[Ye+20>>2]=kr;q[Ye+8>>2]=sr;q[Ye+12>>2]=tr;a:{ir=q[jr+28>>2]-q[jr+24>>2]|0;b:{if(!ir){break b}kr=ir>>2;if(kr>>>0>=1073741824){break a}ir=Mm(ir);q[Ye+32>>2]=ir;lr=Ye+36|0;q[lr>>2]=ir;q[Ye+40>>2]=ir+(kr<<2);kr=q[jr+24>>2];jr=q[jr+28>>2]-kr|0;if((jr|0)<1){break b}ur=lr,vr=Cn(ir,kr,jr)+jr|0,q[ur>>2]=vr}q[Ye>>2]=6584;return}bn();F()}function df(Ye,ir,jr,wr,xr,yr){ir=ir+ -1|0;if(ir>>>0>5){q[Ye>>2]=0;return}a:{b:{switch(ir-1|0){default:ir=Mm(60);ff(ir,jr,wr,xr);q[ir>>2]=2336;break a;case 0:ir=Mm(60);ff(ir,jr,wr,xr);q[ir>>2]=3100;break a;case 2:ir=Mm(112);ff(ir,jr,wr,xr);q[ir>>2]=3336;q[ir+60>>2]=0;q[ir+64>>2]=0;q[ir+68>>2]=0;q[ir+72>>2]=0;q[ir+76>>2]=0;q[ir+80>>2]=0;q[ir+84>>2]=0;q[ir+88>>2]=0;q[ir+92>>2]=0;q[ir+96>>2]=0;q[ir+100>>2]=0;q[ir+104>>2]=0;q[ir+108>>2]=0;break a;case 1:ir=Mm(92);ff(ir,jr,wr,xr);q[ir+60>>2]=0;q[ir+64>>2]=0;q[ir>>2]=3584;q[ir+88>>2]=yr;q[ir+68>>2]=0;q[ir+72>>2]=0;q[ir+76>>2]=0;q[ir+80>>2]=0;q[ir+84>>2]=0;break a;case 3:ir=Mm(104);ff(ir,jr,wr,xr);q[ir+76>>2]=0;q[ir+80>>2]=0;q[ir+60>>2]=0;q[ir+64>>2]=0;q[ir>>2]=3812;q[ir+84>>2]=0;jr=q[xr+4>>2];q[ir+88>>2]=q[xr>>2];q[ir+92>>2]=jr;jr=q[xr+12>>2];q[ir+96>>2]=q[xr+8>>2];q[ir+100>>2]=jr;break a;case 4:break b}}ir=Mm(124);ff(ir,jr,wr,xr);q[ir>>2]=4048;jr=ir- -64|0;q[jr>>2]=0;q[jr+4>>2]=0;jr=q[xr+4>>2];q[ir+72>>2]=q[xr>>2];q[ir+76>>2]=jr;jr=q[xr+12>>2];q[ir+80>>2]=q[xr+8>>2];q[ir+84>>2]=jr;q[ir+92>>2]=-1;q[ir+96>>2]=-1;q[ir+88>>2]=1;q[ir+60>>2]=4284;q[ir+100>>2]=-1;q[ir+104>>2]=-1;ah(ir+108|0);q[Ye>>2]=ir;return}q[Ye>>2]=ir}function ef(Ye,ir,jr,wr,xr,yr){ir=ir+ -1|0;if(ir>>>0>5){q[Ye>>2]=0;return}a:{b:{switch(ir-1|0){default:ir=Mm(60);Vf(ir,jr,wr,xr);q[ir>>2]=4676;break a;case 0:ir=Mm(60);Vf(ir,jr,wr,xr);q[ir>>2]=5100;break a;case 2:ir=Mm(112);Vf(ir,jr,wr,xr);q[ir>>2]=5324;q[ir+60>>2]=0;q[ir+64>>2]=0;q[ir+68>>2]=0;q[ir+72>>2]=0;q[ir+76>>2]=0;q[ir+80>>2]=0;q[ir+84>>2]=0;q[ir+88>>2]=0;q[ir+92>>2]=0;q[ir+96>>2]=0;q[ir+100>>2]=0;q[ir+104>>2]=0;q[ir+108>>2]=0;break a;case 1:ir=Mm(92);Vf(ir,jr,wr,xr);q[ir+60>>2]=0;q[ir+64>>2]=0;q[ir>>2]=5560;q[ir+88>>2]=yr;q[ir+68>>2]=0;q[ir+72>>2]=0;q[ir+76>>2]=0;q[ir+80>>2]=0;q[ir+84>>2]=0;break a;case 3:ir=Mm(104);Vf(ir,jr,wr,xr);q[ir+76>>2]=0;q[ir+80>>2]=0;q[ir+60>>2]=0;q[ir+64>>2]=0;q[ir>>2]=5776;q[ir+84>>2]=0;jr=q[xr+4>>2];q[ir+88>>2]=q[xr>>2];q[ir+92>>2]=jr;jr=q[xr+12>>2];q[ir+96>>2]=q[xr+8>>2];q[ir+100>>2]=jr;break a;case 4:break b}}ir=Mm(124);Vf(ir,jr,wr,xr);q[ir>>2]=6e3;jr=ir- -64|0;q[jr>>2]=0;q[jr+4>>2]=0;jr=q[xr+4>>2];q[ir+72>>2]=q[xr>>2];q[ir+76>>2]=jr;jr=q[xr+12>>2];q[ir+80>>2]=q[xr+8>>2];q[ir+84>>2]=jr;q[ir+92>>2]=-1;q[ir+96>>2]=-1;q[ir+88>>2]=1;q[ir+60>>2]=6220;q[ir+100>>2]=-1;q[ir+104>>2]=-1;ah(ir+108|0);q[Ye>>2]=ir;return}q[Ye>>2]=ir}function ff(Ye,ir,jr,wr){var xr=0,yr=0,zr=0,Ar=0,Br=0,Cr=0,Dr=0,Er=0;q[Ye>>2]=3044;q[Ye+4>>2]=ir;ir=q[jr+8>>2];xr=q[jr+12>>2];yr=q[jr+16>>2];Ar=q[jr+20>>2];Br=q[jr>>2];Cr=q[jr+4>>2];q[Ye+40>>2]=0;zr=Ye+32|0;q[zr>>2]=0;q[zr+4>>2]=0;q[Ye+24>>2]=yr;q[Ye+28>>2]=Ar;q[Ye+16>>2]=ir;q[Ye+20>>2]=xr;q[Ye+8>>2]=Br;q[Ye+12>>2]=Cr;a:{ir=q[jr+28>>2]-q[jr+24>>2]|0;b:{if(!ir){break b}xr=ir>>2;if(xr>>>0>=1073741824){break a}ir=Mm(ir);q[Ye+32>>2]=ir;yr=Ye+36|0;q[yr>>2]=ir;q[Ye+40>>2]=ir+(xr<<2);xr=q[jr+24>>2];jr=q[jr+28>>2]-xr|0;if((jr|0)<1){break b}Dr=yr,Er=Cn(ir,xr,jr)+jr|0,q[Dr>>2]=Er}q[Ye>>2]=2988;ir=q[wr+4>>2];q[Ye+44>>2]=q[wr>>2];q[Ye+48>>2]=ir;ir=q[wr+12>>2];q[Ye+52>>2]=q[wr+8>>2];q[Ye+56>>2]=ir;return}bn();F()}function gf(Ye){Ye=Ye|0;var ir=0;q[Ye>>2]=3044;ir=q[Ye+32>>2];if(ir){q[Ye+36>>2]=ir;An(ir)}An(Ye)}function hf(Ye){Ye=Ye|0;var jr=0;if(!(!q[Ye+52>>2]|(!q[Ye+44>>2]|!q[Ye+48>>2]))){jr=q[Ye+56>>2]!=0}return jr|0}function jf(q){q=q|0;return 0}function kf(q,Ye){q=q|0;Ye=Ye|0;return-1}function lf(Ye,wr){Ye=Ye|0;wr=wr|0;var Fr=0,Gr=0,Hr=0,Ir=0,Jr=0,Kr=0,Lr=0,Mr=0,Nr=0,Or=0;Gr=q[wr+12>>2];Lr=Gr;Fr=q[wr+20>>2];Ir=Fr;Jr=q[wr+16>>2];Hr=Jr+4|0;if(Hr>>>0<4){Fr=Fr+1|0}Mr=q[wr+8>>2];Kr=Hr;Hr=Fr;a:{if((Gr|0)<(Fr|0)?1:(Gr|0)<=(Fr|0)?Mr>>>0>=Kr>>>0?0:1:0){break a}Nr=q[wr>>2];Fr=Nr+Jr|0;Gr=r[Fr|0]|r[Fr+1|0]<<8|(r[Fr+2|0]<<16|r[Fr+3|0]<<24);q[wr+16>>2]=Kr;q[wr+20>>2]=Hr;Fr=Ir;Ir=Jr+8|0;if(Ir>>>0<8){Fr=Fr+1|0}Hr=Ir;Ir=Fr;if((Lr|0)<(Fr|0)?1:(Lr|0)<=(Fr|0)?Mr>>>0>=Hr>>>0?0:1:0){break a}Fr=Kr+Nr|0;Fr=r[Fr|0]|r[Fr+1|0]<<8|(r[Fr+2|0]<<16|r[Fr+3|0]<<24);q[wr+16>>2]=Hr;q[wr+20>>2]=Ir;if((Gr|0)>(Fr|0)){break a}q[Ye+16>>2]=Fr;q[Ye+12>>2]=Gr;wr=Gr;Gr=(Fr>>31)-((Fr>>>0<wr>>>0)+(wr>>31)|0)|0;wr=Fr-wr|0;if(!Gr&wr>>>0>2147483646|Gr>>>0>0){break a}Or=1;wr=wr+1|0;q[Ye+20>>2]=wr;Gr=Ye+24|0;Fr=(wr|0)/2|0;q[Gr>>2]=Fr;q[Ye+28>>2]=0-Fr;if(wr&1){break a}q[Gr>>2]=Fr+ -1}return Or|0}function mf(Ye,wr,Pr,Qr,Rr,Sr){Ye=Ye|0;wr=wr|0;Pr=Pr|0;Qr=Qr|0;Rr=Rr|0;Sr=Sr|0;var Tr=0,Ur=0,Vr=0,Wr=0,Xr=0,Yr=0,Zr=0,_r=0,$r=0,as=0,bs=0,cs=0,ds=0,es=0,fs=0,gs=0;q[Ye+8>>2]=Rr;Sr=Ye+32|0;Tr=q[Sr>>2];Qr=q[Ye+36>>2]-Tr>>2;a:{if(Qr>>>0<Rr>>>0){Fa(Sr,Rr-Qr|0);break a}if(Qr>>>0<=Rr>>>0){break a}q[Ye+36>>2]=Tr+(Rr<<2)}fs=q[Ye+52>>2];cs=q[Ye+48>>2];Qr=0;Sr=(Rr&1073741823)!=(Rr|0)?-1:Rr<<2;as=Dn(Mm(Sr),0,Sr);Yr=Ye+8|0;Sr=q[Yr>>2];b:{if((Sr|0)<1){break b}Zr=Ye+16|0;Tr=Ye+32|0;_r=Ye+12|0;while(1){Sr=Qr<<2;Vr=q[Sr+as>>2];Xr=q[Zr>>2];c:{if((Vr|0)>(Xr|0)){Ur=q[Tr>>2];q[Sr+Ur>>2]=Xr;break c}Ur=q[Tr>>2];Sr=Sr+Ur|0;Xr=q[_r>>2];if((Vr|0)<(Xr|0)){q[Sr>>2]=Xr;break c}q[Sr>>2]=Vr}Qr=Qr+1|0;Sr=q[Yr>>2];if((Qr|0)<(Sr|0)){continue}break}if((Sr|0)<1){break b}Tr=0;Yr=Ye+16|0;Vr=Ye+20|0;Zr=Ye+8|0;_r=Ye+12|0;while(1){Sr=Tr<<2;Qr=Sr+Pr|0;Sr=q[wr+Sr>>2]+q[Sr+Ur>>2]|0;q[Qr>>2]=Sr;d:{if((Sr|0)>q[Yr>>2]){Sr=Sr-q[Vr>>2]|0}else{if((Sr|0)>=q[_r>>2]){break d}Sr=Sr+q[Vr>>2]|0}q[Qr>>2]=Sr}Tr=Tr+1|0;Sr=q[Zr>>2];if((Tr|0)<(Sr|0)){continue}break}}Qr=q[Ye+56>>2];ds=q[Qr>>2];Qr=q[Qr+4>>2]-ds|0;if((Qr|0)>=5){es=Qr>>2;Yr=Ye+16|0;Zr=Ye+32|0;_r=Ye+8|0;Xr=Ye+20|0;bs=Ye+12|0;gs=cs+28|0;Vr=1;while(1){e:{f:{if(es>>>0>Vr>>>0){$r=w(Rr,Vr);Ye=q[(Vr<<2)+ds>>2];if((Ye|0)==-1|q[q[cs>>2]+(Ye>>>3&536870908)>>2]>>>(Ye&31)&1){break f}Ye=q[q[q[cs+64>>2]+12>>2]+(Ye<<2)>>2];if((Ye|0)==-1){break f}Tr=q[fs>>2];Qr=q[gs>>2];Ur=q[Tr+(q[Qr+(Ye<<2)>>2]<<2)>>2];if((Ur|0)>=(Vr|0)){break f}Wr=Ye+1|0;Wr=q[Tr+(q[Qr+(((Wr>>>0)%3|0?Wr:Ye+ -2|0)<<2)>>2]<<2)>>2];if((Wr|0)>=(Vr|0)){break f}Ye=q[Tr+(q[Qr+(Ye+((Ye>>>0)%3|0?-1:2)<<2)>>2]<<2)>>2];if((Ye|0)>=(Vr|0)){break f}if((Rr|0)>=1){Ye=w(Ye,Rr);Tr=w(Rr,Wr);Ur=w(Rr,Ur);Qr=0;while(1){q[(Qr<<2)+as>>2]=(q[(Ye+Qr<<2)+Pr>>2]+q[(Qr+Tr<<2)+Pr>>2]|0)-q[(Qr+Ur<<2)+Pr>>2];Qr=Qr+1|0;if((Rr|0)!=(Qr|0)){continue}break}}if((Sr|0)<1){break e}Qr=0;while(1){Ye=Qr<<2;Sr=q[Ye+as>>2];Tr=q[Yr>>2];g:{if((Sr|0)>(Tr|0)){Ur=q[Zr>>2];q[Ye+Ur>>2]=Tr;break g}Ur=q[Zr>>2];Ye=Ye+Ur|0;Tr=q[bs>>2];if((Sr|0)<(Tr|0)){q[Ye>>2]=Tr;break g}q[Ye>>2]=Sr}Qr=Qr+1|0;Sr=q[_r>>2];if((Qr|0)<(Sr|0)){continue}break}Tr=0;if((Sr|0)<1){break e}Ye=$r<<2;$r=Ye+Pr|0;Wr=Ye+wr|0;while(1){Qr=Tr<<2;Ye=Qr+$r|0;Qr=q[Qr+Wr>>2]+q[Qr+Ur>>2]|0;q[Ye>>2]=Qr;h:{if((Qr|0)>q[Yr>>2]){Qr=Qr-q[Xr>>2]|0}else{if((Qr|0)>=q[bs>>2]){break h}Qr=Qr+q[Xr>>2]|0}q[Ye>>2]=Qr}Tr=Tr+1|0;Sr=q[_r>>2];if((Tr|0)<(Sr|0)){continue}break}break e}cn();F()}if((Sr|0)<1){break e}Tr=(w(Vr+ -1|0,Rr)<<2)+Pr|0;Qr=0;while(1){Ye=Qr<<2;Sr=q[Ye+Tr>>2];Wr=q[Yr>>2];i:{if((Sr|0)>(Wr|0)){Ur=q[Zr>>2];q[Ye+Ur>>2]=Wr;break i}Ur=q[Zr>>2];Ye=Ye+Ur|0;Wr=q[bs>>2];if((Sr|0)<(Wr|0)){q[Ye>>2]=Wr;break i}q[Ye>>2]=Sr}Qr=Qr+1|0;Sr=q[_r>>2];if((Qr|0)<(Sr|0)){continue}break}Tr=0;if((Sr|0)<1){break e}Ye=$r<<2;$r=Ye+Pr|0;Wr=Ye+wr|0;while(1){Qr=Tr<<2;Ye=Qr+$r|0;Qr=q[Qr+Wr>>2]+q[Qr+Ur>>2]|0;q[Ye>>2]=Qr;j:{if((Qr|0)>q[Yr>>2]){Qr=Qr-q[Xr>>2]|0}else{if((Qr|0)>=q[bs>>2]){break j}Qr=Qr+q[Xr>>2]|0}q[Ye>>2]=Qr}Tr=Tr+1|0;Sr=q[_r>>2];if((Tr|0)<(Sr|0)){continue}break}}Vr=Vr+1|0;if((Vr|0)<(es|0)){continue}break}}An(as);return 1}function nf(Ye){Ye=Ye|0;var wr=0;q[Ye>>2]=3044;wr=q[Ye+32>>2];if(wr){q[Ye+36>>2]=wr;An(wr)}return Ye|0}function of(Ye,Pr,Qr,Rr,Sr,hs){Ye=Ye|0;Pr=Pr|0;Qr=Qr|0;Rr=Rr|0;Sr=Sr|0;hs=hs|0;var is=0,js=0,ks=0,ls=0,ms=0,ns=0,os=0,ps=0,qs=0,rs=0,ss=0,ts=0,us=0,vs=0,ws=0,xs=0,ys=0,zs=0,As=0,Bs=0,Cs=0,Ds=0;q[Ye+8>>2]=Sr;hs=Ye+32|0;is=q[hs>>2];Rr=q[Ye+36>>2]-is>>2;a:{if(Rr>>>0<Sr>>>0){Fa(hs,Sr-Rr|0);break a}if(Rr>>>0<=Sr>>>0){break a}q[Ye+36>>2]=is+(Sr<<2)}hs=0;Rr=(Sr&1073741823)!=(Sr|0)?-1:Sr<<2;rs=Dn(Mm(Rr),0,Rr);ws=Dn(Mm(Rr),0,Rr);os=Ye+8|0;is=q[os>>2];b:{if((is|0)<1){break b}ps=Ye+16|0;Rr=Ye+32|0;qs=Ye+12|0;while(1){is=hs<<2;ls=q[is+rs>>2];ns=q[ps>>2];c:{if((ls|0)>(ns|0)){ks=q[Rr>>2];q[is+ks>>2]=ns;break c}ks=q[Rr>>2];is=is+ks|0;ns=q[qs>>2];if((ls|0)<(ns|0)){q[is>>2]=ns;break c}q[is>>2]=ls}hs=hs+1|0;is=q[os>>2];if((hs|0)<(is|0)){continue}break}if((is|0)<1){break b}Rr=0;os=Ye+16|0;ls=Ye+20|0;ps=Ye+8|0;qs=Ye+12|0;while(1){is=Rr<<2;hs=is+Qr|0;is=q[Pr+is>>2]+q[is+ks>>2]|0;q[hs>>2]=is;d:{if((is|0)>q[os>>2]){is=is-q[ls>>2]|0}else{if((is|0)>=q[qs>>2]){break d}is=is+q[ls>>2]|0}q[hs>>2]=is}Rr=Rr+1|0;is=q[ps>>2];if((Rr|0)<(is|0)){continue}break}}Rr=q[Ye+56>>2];xs=q[Rr>>2];Rr=q[Rr+4>>2]-xs|0;if((Rr|0)>=5){ys=Rr>>2;As=Sr<<2;Bs=q[Ye+52>>2];os=Ye+16|0;ps=Ye+32|0;qs=Ye+8|0;ns=Ye+20|0;us=Ye+12|0;ss=q[Ye+48>>2];Cs=ss+28|0;ls=1;while(1){e:{f:{g:{if(ys>>>0>ls>>>0){Ye=q[(ls<<2)+xs>>2];zs=(Sr|0)<1;if(!zs){Dn(rs,0,As)}if((Ye|0)==-1){Ye=w(Sr,ls);break f}Ds=q[ss>>2];ks=0;Rr=Ye;while(1){h:{if(q[Ds+(Rr>>>3&536870908)>>2]>>>(Rr&31)&1){break h}hs=q[q[q[ss+64>>2]+12>>2]+(Rr<<2)>>2];if((hs|0)==-1){break h}ms=q[Bs>>2];js=q[Cs>>2];vs=q[ms+(q[js+(hs<<2)>>2]<<2)>>2];if((vs|0)>=(ls|0)){break h}ts=hs+1|0;ts=q[ms+(q[js+(((ts>>>0)%3|0?ts:hs+ -2|0)<<2)>>2]<<2)>>2];if((ts|0)>=(ls|0)){break h}hs=q[ms+(q[js+(hs+((hs>>>0)%3|0?-1:2)<<2)>>2]<<2)>>2];if((hs|0)>=(ls|0)){break h}i:{if(zs){break i}js=w(Sr,hs);ms=w(Sr,ts);vs=w(Sr,vs);hs=0;while(1){q[ws+(hs<<2)>>2]=(q[(hs+js<<2)+Qr>>2]+q[(hs+ms<<2)+Qr>>2]|0)-q[(hs+vs<<2)+Qr>>2];hs=hs+1|0;if((hs|0)!=(Sr|0)){continue}break}hs=0;if((Sr|0)<=0){break i}while(1){js=hs<<2;ms=js+rs|0;q[ms>>2]=q[ms>>2]+q[js+ws>>2];hs=hs+1|0;if((hs|0)!=(Sr|0)){continue}break}}ks=ks+1|0}hs=-1;Rr=((Rr>>>0)%3|0?-1:2)+Rr|0;j:{if((Rr|0)==-1|q[q[ss>>2]+(Rr>>>3&536870908)>>2]>>>(Rr&31)&1){break j}Rr=q[q[q[ss+64>>2]+12>>2]+(Rr<<2)>>2];if((Rr|0)==-1){break j}if((Rr>>>0)%3){hs=Rr+ -1|0;break j}hs=Rr+2|0}Rr=(Ye|0)==(hs|0)?-1:hs;if((Rr|0)!=-1){continue}break}Ye=w(Sr,ls);if(!ks){break f}hs=0;if((Sr|0)<=0){break g}while(1){Rr=(hs<<2)+rs|0;q[Rr>>2]=q[Rr>>2]/(ks|0);hs=hs+1|0;if((hs|0)!=(Sr|0)){continue}break}break g}cn();F()}if((is|0)<1){break e}hs=0;while(1){Rr=hs<<2;is=q[Rr+rs>>2];js=q[os>>2];k:{if((is|0)>(js|0)){ks=q[ps>>2];q[Rr+ks>>2]=js;break k}ks=q[ps>>2];Rr=Rr+ks|0;js=q[us>>2];if((is|0)<(js|0)){q[Rr>>2]=js;break k}q[Rr>>2]=is}hs=hs+1|0;is=q[qs>>2];if((hs|0)<(is|0)){continue}break}Rr=0;if((is|0)<1){break e}Ye=Ye<<2;js=Ye+Qr|0;ms=Ye+Pr|0;while(1){hs=Rr<<2;Ye=hs+js|0;hs=q[hs+ms>>2]+q[hs+ks>>2]|0;q[Ye>>2]=hs;l:{if((hs|0)>q[os>>2]){hs=hs-q[ns>>2]|0}else{if((hs|0)>=q[us>>2]){break l}hs=hs+q[ns>>2]|0}q[Ye>>2]=hs}Rr=Rr+1|0;is=q[qs>>2];if((Rr|0)<(is|0)){continue}break}break e}if((is|0)<1){break e}js=(w(ls+ -1|0,Sr)<<2)+Qr|0;hs=0;while(1){Rr=hs<<2;is=q[Rr+js>>2];ms=q[os>>2];m:{if((is|0)>(ms|0)){ks=q[ps>>2];q[Rr+ks>>2]=ms;break m}ks=q[ps>>2];Rr=Rr+ks|0;ms=q[us>>2];if((is|0)<(ms|0)){q[Rr>>2]=ms;break m}q[Rr>>2]=is}hs=hs+1|0;is=q[qs>>2];if((hs|0)<(is|0)){continue}break}Rr=0;if((is|0)<1){break e}Ye=Ye<<2;js=Ye+Qr|0;ms=Ye+Pr|0;while(1){hs=Rr<<2;Ye=hs+js|0;hs=q[hs+ms>>2]+q[hs+ks>>2]|0;q[Ye>>2]=hs;n:{if((hs|0)>q[os>>2]){hs=hs-q[ns>>2]|0}else{if((hs|0)>=q[us>>2]){break n}hs=hs+q[ns>>2]|0}q[Ye>>2]=hs}Rr=Rr+1|0;is=q[qs>>2];if((Rr|0)<(is|0)){continue}break}}ls=ls+1|0;if((ls|0)<(ys|0)){continue}break}}An(ws);An(rs);return 1}function pf(Ye){Ye=Ye|0;var Pr=0;q[Ye>>2]=3336;Pr=q[Ye+96>>2];if(Pr){An(Pr)}Pr=q[Ye+84>>2];if(Pr){An(Pr)}Pr=q[Ye+72>>2];if(Pr){An(Pr)}Pr=q[Ye+60>>2];if(Pr){An(Pr)}q[Ye>>2]=3044;Pr=q[Ye+32>>2];if(Pr){q[Ye+36>>2]=Pr;An(Pr)}return Ye|0}function qf(Ye){Ye=Ye|0;var Qr=0;q[Ye>>2]=3336;Qr=q[Ye+96>>2];if(Qr){An(Qr)}Qr=q[Ye+84>>2];if(Qr){An(Qr)}Qr=q[Ye+72>>2];if(Qr){An(Qr)}Qr=q[Ye+60>>2];if(Qr){An(Qr)}q[Ye>>2]=3044;Qr=q[Ye+32>>2];if(Qr){q[Ye+36>>2]=Qr;An(Qr)}An(Ye)}function rf(q){q=q|0;return 4}function sf(Ye,Rr){Ye=Ye|0;Rr=Rr|0;var Sr=0,hs=0,Es=0,Fs=0,Gs=0,Hs=0,Is=0,Js=0,Ks=0,Ls=0,Ms=0;Js=T-32|0;T=Js;a:{if(s[Rr+38>>1]<=513){Es=q[Rr+16>>2];hs=q[Rr+12>>2];Sr=q[Rr+20>>2];if((hs|0)<(Sr|0)?1:(hs|0)<=(Sr|0)?t[Rr+8>>2]>Es>>>0?0:1:0){break a}Fs=r[Es+q[Rr>>2]|0];Es=Es+1|0;if(Es>>>0<1){Sr=Sr+1|0}q[Rr+16>>2]=Es;q[Rr+20>>2]=Sr;if(Fs){break a}}b:{while(1){if(!tf(1,Js+28|0,Rr)){break b}Sr=q[Js+28>>2];if(Sr){Fs=(w(Gs,12)+Ye|0)+60|0;uf(Fs,Sr);Is=ah(Js+8|0);if(!bh(Is,Rr)){break b}Hs=0;while(1){hs=1<<(Hs&31);Ks=dh(Is);Es=q[Fs>>2]+(Hs>>>3&536870908)|0;Ls=Es;if(Ks){hs=hs|q[Es>>2]}else{hs=q[Es>>2]&(hs^-1)}q[Ls>>2]=hs;Hs=Hs+1|0;if((Sr|0)!=(Hs|0)){continue}break}}Gs=Gs+1|0;if((Gs|0)!=4){continue}break}Hs=0;hs=q[Rr+12>>2];Es=hs;Sr=q[Rr+20>>2];Gs=Sr;Is=q[Rr+16>>2];Fs=Is+4|0;if(Fs>>>0<4){Sr=Sr+1|0}Ls=q[Rr+8>>2];Ks=Fs;Fs=Sr;if((hs|0)<(Sr|0)?1:(hs|0)<=(Sr|0)?Ls>>>0>=Ks>>>0?0:1:0){break a}Ms=q[Rr>>2];Sr=Ms+Is|0;hs=r[Sr|0]|r[Sr+1|0]<<8|(r[Sr+2|0]<<16|r[Sr+3|0]<<24);q[Rr+16>>2]=Ks;q[Rr+20>>2]=Fs;Sr=Gs;Gs=Is+8|0;if(Gs>>>0<8){Sr=Sr+1|0}Fs=Gs;Gs=Sr;if((Es|0)<(Sr|0)?1:(Es|0)<=(Sr|0)?Ls>>>0>=Fs>>>0?0:1:0){break a}Sr=Ks+Ms|0;Sr=r[Sr|0]|r[Sr+1|0]<<8|(r[Sr+2|0]<<16|r[Sr+3|0]<<24);q[Rr+16>>2]=Fs;q[Rr+20>>2]=Gs;if((hs|0)>(Sr|0)){break a}q[Ye+16>>2]=Sr;q[Ye+12>>2]=hs;Rr=hs;hs=(Sr>>31)-((Sr>>>0<Rr>>>0)+(Rr>>31)|0)|0;Rr=Sr-Rr|0;if(!hs&Rr>>>0>2147483646|hs>>>0>0){break a}Hs=1;Rr=Rr+1|0;q[Ye+20>>2]=Rr;hs=Ye+24|0;Sr=(Rr|0)/2|0;q[hs>>2]=Sr;q[Ye+28>>2]=0-Sr;if(Rr&1){break a}q[hs>>2]=Sr+ -1;break a}Hs=0}T=Js+32|0;return Hs|0}function tf(Ye,Rr,Ns){var Os=0,Ps=0,Qs=0,Rs=0;a:{if(Ye>>>0>5){break a}Qs=q[Ns+16>>2];Os=q[Ns+12>>2];Ps=q[Ns+20>>2];if((Os|0)<(Ps|0)?1:(Os|0)<=(Ps|0)?t[Ns+8>>2]>Qs>>>0?0:1:0){break a}Os=r[Qs+q[Ns>>2]|0];Qs=Qs+1|0;if(Qs>>>0<1){Ps=Ps+1|0}q[Ns+16>>2]=Qs;q[Ns+20>>2]=Ps;Ps=Rr;if(Os&128){if(!tf(Ye+1|0,Rr,Ns)){break a}Ye=q[Rr>>2]<<7;q[Rr>>2]=Ye;Os=Ye|Os&127}q[Ps>>2]=Os;Rs=1}return Rs}function uf(Ye,Rr){var Ns=0,Ss=0,Ts=0,Us=0,Vs=0,Ws=0;Ss=T-32|0;T=Ss;a:{Ns=q[Ye+4>>2];b:{if(Ns>>>0<Rr>>>0){Vs=q[Ye+8>>2];Ts=Vs<<5;Us=Rr-Ns|0;c:{if(!(Ts>>>0<Us>>>0|Ns>>>0>Ts-Us>>>0)){q[Ye+4>>2]=Rr;Rr=Ns&31;Ye=q[Ye>>2]+(Ns>>>3&536870908)|0;break c}q[Ss+24>>2]=0;q[Ss+16>>2]=0;q[Ss+20>>2]=0;if((Rr|0)<=-1){break a}Ns=Ss+16|0;if(Ts>>>0<=1073741822){Rr=Rr+31&-32;Ts=Vs<<6;Rr=Ts>>>0<Rr>>>0?Rr:Ts}else{Rr=2147483647}cb(Ns,Rr);Ns=q[Ye+4>>2];q[Ss+20>>2]=Ns+Us;Rr=q[Ss+16>>2];d:{if((Ns|0)<1){Ns=0;break d}Vs=q[Ye>>2];Ts=Ns>>>5<<2;Rr=En(Rr,Vs,Ts)+Ts|0;Ns=Ns&31;if(!Ns){Ns=0;break d}Ws=-1>>>32-Ns;q[Rr>>2]=q[Rr>>2]&(Ws^-1)|q[Ts+Vs>>2]&Ws}q[Ss+12>>2]=Ns;q[Ss+8>>2]=Rr;Ns=q[Ss+8>>2];Rr=q[Ss+12>>2];Ts=q[Ye>>2];q[Ye>>2]=q[Ss+16>>2];q[Ss+16>>2]=Ts;Vs=q[Ye+4>>2];q[Ye+4>>2]=q[Ss+20>>2];q[Ss+20>>2]=Vs;Ye=Ye+8|0;Vs=q[Ye>>2];q[Ye>>2]=q[Ss+24>>2];q[Ss+24>>2]=Vs;if(Ts){An(Ts)}Ye=Ns}if(!Us){break b}if(Rr){Ns=32-Rr|0;Ts=Ns>>>0>Us>>>0?Us:Ns;q[Ye>>2]=q[Ye>>2]&(-1<<Rr&-1>>>Ns-Ts^-1);Us=Us-Ts|0;Ye=Ye+4|0}Rr=Ye;Ye=Us>>>5<<2;Rr=Dn(Rr,0,Ye);Ns=Us&31;if(!Ns){break b}Ye=Ye+Rr|0;q[Ye>>2]=q[Ye>>2]&(-1>>>32-Ns^-1);break b}q[Ye+4>>2]=Rr}T=Ss+32|0;return}bn();F()}function vf(Ye,Rr,Xs,Ys,Zs,_s){Ye=Ye|0;Rr=Rr|0;Xs=Xs|0;Ys=Ys|0;Zs=Zs|0;_s=_s|0;var $s=0,at=0,bt=0,ct=0,dt=0,et=0,ft=0,gt=0,ht=0,it=0,jt=0,kt=0,lt=0,mt=0,nt=0,ot=0,pt=0,qt=0,rt=0,st=0,tt=0,ut=0,vt=0,wt=0,xt=0,yt=0;bt=T+ -64|0;T=bt;q[Ye+8>>2]=Zs;_s=Ye+32|0;ct=q[_s>>2];Ys=q[Ye+36>>2]-ct>>2;a:{if(Ys>>>0<Zs>>>0){Fa(_s,Zs-Ys|0);break a}if(Ys>>>0<=Zs>>>0){break a}q[Ye+36>>2]=ct+(Zs<<2)}q[bt+56>>2]=0;q[bt+60>>2]=0;q[bt+48>>2]=0;q[bt+52>>2]=0;q[bt+40>>2]=0;q[bt+44>>2]=0;_s=bt+32|0;q[_s>>2]=0;q[_s+4>>2]=0;q[bt+24>>2]=0;q[bt+28>>2]=0;q[bt+16>>2]=0;q[bt+20>>2]=0;q[bt>>2]=0;Ys=0;if(Zs){Ad(bt+16|0,Zs,bt);at=q[bt+28>>2];Ys=q[_s>>2]}q[bt>>2]=0;Ys=Ys-at>>2;b:{if(Ys>>>0>=Zs>>>0){if(Ys>>>0<=Zs>>>0){break b}q[bt+32>>2]=(Zs<<2)+at;break b}Ad(bt+16|12,Zs-Ys|0,bt)}q[bt>>2]=0;_s=q[bt+40>>2];Ys=q[bt+44>>2]-_s>>2;c:{if(Ys>>>0>=Zs>>>0){if(Ys>>>0<=Zs>>>0){break c}q[bt+44>>2]=_s+(Zs<<2);break c}Ad(bt+40|0,Zs-Ys|0,bt)}q[bt>>2]=0;_s=q[bt+52>>2];Ys=q[bt+56>>2]-_s>>2;d:{if(Ys>>>0>=Zs>>>0){if(Ys>>>0<=Zs>>>0){break d}q[bt+56>>2]=_s+(Zs<<2);break d}Ad(bt+52|0,Zs-Ys|0,bt)}et=Ye+8|0;e:{if(q[et>>2]<=0){break e}ft=q[bt+16>>2];at=0;ht=Ye+16|0;Ys=Ye+32|0;dt=Ye+12|0;while(1){_s=at<<2;$s=q[_s+ft>>2];it=q[ht>>2];f:{if(($s|0)>(it|0)){ct=q[Ys>>2];q[_s+ct>>2]=it;break f}ct=q[Ys>>2];_s=_s+ct|0;it=q[dt>>2];if(($s|0)<(it|0)){q[_s>>2]=it;break f}q[_s>>2]=$s}at=at+1|0;_s=q[et>>2];if((at|0)<(_s|0)){continue}break}if((_s|0)<1){break e}Ys=0;et=Ye+16|0;at=Ye+20|0;ft=Ye+8|0;ht=Ye+12|0;while(1){$s=Ys<<2;_s=$s+Xs|0;$s=q[Rr+$s>>2]+q[$s+ct>>2]|0;q[_s>>2]=$s;g:{if(($s|0)>q[et>>2]){$s=$s-q[at>>2]|0}else{if(($s|0)>=q[ht>>2]){break g}$s=$s+q[at>>2]|0}q[_s>>2]=$s}Ys=Ys+1|0;if((Ys|0)<q[ft>>2]){continue}break}}wt=q[Ye+52>>2];ft=q[Ye+48>>2];qt=Mm(16);Ys=qt;q[Ys>>2]=0;q[Ys+4>>2]=0;q[Ys+8>>2]=0;q[Ys+12>>2]=0;q[bt+8>>2]=0;q[bt>>2]=0;q[bt+4>>2]=0;h:{if(Zs){if(Zs>>>0>=1073741824){break h}Ys=Zs<<2;mt=Mm(Ys);q[bt>>2]=mt;_s=Ys+mt|0;q[bt+8>>2]=_s;Dn(mt,0,Ys);q[bt+4>>2]=_s}Ys=1;_s=q[Ye+56>>2];ut=q[_s>>2];_s=q[_s+4>>2]-ut|0;i:{if((_s|0)<5){break i}vt=_s>>2;xt=Zs<<2;ht=Ye+8|0;it=Ye+16|0;nt=Ye+32|0;ot=Ye+20|0;pt=Ye+12|0;yt=ft+28|0;et=1;while(1){j:{k:{l:{if(vt>>>0>et>>>0){m:{n:{ct=q[(et<<2)+ut>>2];if((ct|0)==-1){break n}gt=ct+((ct>>>0)%3|0?-1:2)|0;rt=gt>>>5;dt=1;st=1<<(gt&31);tt=q[ft>>2];_s=0;Ys=ct;o:{while(1){p:{if(q[tt+(Ys>>>3&536870908)>>2]>>>(Ys&31)&1){break p}$s=q[q[q[ft+64>>2]+12>>2]+(Ys<<2)>>2];if(($s|0)==-1){break p}kt=q[wt>>2];at=q[yt>>2];lt=q[kt+(q[at+($s<<2)>>2]<<2)>>2];if((lt|0)>=(et|0)){break p}jt=$s+1|0;jt=q[kt+(q[at+(((jt>>>0)%3|0?jt:$s+ -2|0)<<2)>>2]<<2)>>2];if((jt|0)>=(et|0)){break p}$s=q[kt+(q[at+($s+(($s>>>0)%3|0?-1:2)<<2)>>2]<<2)>>2];if(($s|0)>=(et|0)){break p}if((Zs|0)>=1){kt=q[(bt+16|0)+w(_s,12)>>2];$s=w(Zs,$s);jt=w(Zs,jt);lt=w(Zs,lt);at=0;while(1){q[kt+(at<<2)>>2]=(q[($s+at<<2)+Xs>>2]+q[(at+jt<<2)+Xs>>2]|0)-q[(at+lt<<2)+Xs>>2];at=at+1|0;if((at|0)!=(Zs|0)){continue}break}}$s=4;_s=_s+1|0;if((_s|0)==4){break o}}q:{if(dt&1){at=-1;$s=Ys+1|0;Ys=($s>>>0)%3|0?$s:Ys+ -2|0;if((Ys|0)==-1|q[q[ft>>2]+(Ys>>>3&536870908)>>2]>>>(Ys&31)&1){break q}Ys=q[q[q[ft+64>>2]+12>>2]+(Ys<<2)>>2];if((Ys|0)==-1){break q}$s=Ys+1|0;at=($s>>>0)%3|0?$s:Ys+ -2|0;break q}at=-1;Ys=((Ys>>>0)%3|0?-1:2)+Ys|0;if((Ys|0)==-1|q[q[ft>>2]+(Ys>>>3&536870908)>>2]>>>(Ys&31)&1){break q}Ys=q[q[q[ft+64>>2]+12>>2]+(Ys<<2)>>2];if((Ys|0)==-1){break q}if((Ys>>>0)%3){at=Ys+ -1|0;break q}at=Ys+2|0}r:{if((at|0)==(ct|0)){break r}Ys=at;$s=(at|0)!=-1;at=($s|dt^-1)&1;Ys=at?Ys:-1;dt=$s&dt;if(!((gt|0)==-1|at)){if(q[q[ft>>2]+(rt<<2)>>2]&st){break r}$s=q[q[q[ft+64>>2]+12>>2]+(gt<<2)>>2];if(($s|0)==-1){break r}dt=0;if(($s>>>0)%3){Ys=$s+ -1|0}else{Ys=$s+2|0}}if((Ys|0)!=-1){continue}}break}$s=_s;if(($s|0)<1){break n}}gt=(Zs|0)<1;if(!gt){Dn(mt,0,xt)}Ys=$s+ -1|0;dt=(Ys<<2)+qt|0;Ys=w(Ys,12)+Ye|0;kt=Ys+60|0;rt=q[Ys- -64>>2];Ys=0;st=q[bt>>2];ct=0;_s=0;while(1){at=q[dt>>2];q[dt>>2]=at+1;if(rt>>>0<=at>>>0){break i}s:{if(q[q[kt>>2]+(at>>>3&536870908)>>2]>>>(at&31)&1){break s}_s=_s+1|0;if(gt){break s}tt=q[(bt+16|0)+w(ct,12)>>2];at=0;while(1){lt=at<<2;jt=lt+st|0;q[jt>>2]=q[jt>>2]+q[lt+tt>>2];at=at+1|0;if((at|0)!=(Zs|0)){continue}break}}ct=ct+1|0;if(($s|0)!=(ct|0)){continue}break}dt=w(Zs,et);$s=dt;if(!_s){break m}at=0;if((Zs|0)>0){break l}break k}$s=w(Zs,et)}if(q[ht>>2]<1){break j}dt=(w(et+ -1|0,Zs)<<2)+Xs|0;at=0;while(1){Ys=at<<2;_s=q[Ys+dt>>2];gt=q[it>>2];t:{if((_s|0)>(gt|0)){ct=q[nt>>2];q[Ys+ct>>2]=gt;break t}ct=q[nt>>2];Ys=Ys+ct|0;gt=q[pt>>2];if((_s|0)<(gt|0)){q[Ys>>2]=gt;break t}q[Ys>>2]=_s}at=at+1|0;_s=q[ht>>2];if((at|0)<(_s|0)){continue}break}Ys=0;if((_s|0)<1){break j}_s=$s<<2;at=_s+Xs|0;dt=Rr+_s|0;while(1){$s=Ys<<2;_s=$s+at|0;$s=q[$s+dt>>2]+q[$s+ct>>2]|0;q[_s>>2]=$s;u:{if(($s|0)>q[it>>2]){$s=$s-q[ot>>2]|0}else{if(($s|0)>=q[pt>>2]){break u}$s=$s+q[ot>>2]|0}q[_s>>2]=$s}Ys=Ys+1|0;if((Ys|0)<q[ht>>2]){continue}break}break j}cn();F()}while(1){Ys=(at<<2)+mt|0;q[Ys>>2]=q[Ys>>2]/(_s|0);at=at+1|0;if((at|0)!=(Zs|0)){continue}break}}if(q[ht>>2]<1){break j}at=0;while(1){Ys=at<<2;_s=q[Ys+mt>>2];$s=q[it>>2];v:{if((_s|0)>($s|0)){ct=q[nt>>2];q[Ys+ct>>2]=$s;break v}ct=q[nt>>2];Ys=Ys+ct|0;$s=q[pt>>2];if((_s|0)<($s|0)){q[Ys>>2]=$s;break v}q[Ys>>2]=_s}at=at+1|0;_s=q[ht>>2];if((at|0)<(_s|0)){continue}break}Ys=0;if((_s|0)<1){break j}_s=dt<<2;at=_s+Xs|0;dt=Rr+_s|0;while(1){$s=Ys<<2;_s=$s+at|0;$s=q[$s+dt>>2]+q[$s+ct>>2]|0;q[_s>>2]=$s;w:{if(($s|0)>q[it>>2]){$s=$s-q[ot>>2]|0}else{if(($s|0)>=q[pt>>2]){break w}$s=$s+q[ot>>2]|0}q[_s>>2]=$s}Ys=Ys+1|0;if((Ys|0)<q[ht>>2]){continue}break}}Ys=1;et=et+1|0;if((et|0)<(vt|0)){continue}break}}Ye=q[bt>>2];if(Ye){q[bt+4>>2]=Ye;An(Ye)}An(qt);Ye=q[bt+52>>2];if(Ye){q[bt+56>>2]=Ye;An(Ye)}Ye=q[bt+40>>2];if(Ye){q[bt+44>>2]=Ye;An(Ye)}Ye=q[bt+28>>2];if(Ye){q[bt+32>>2]=Ye;An(Ye)}Ye=q[bt+16>>2];if(Ye){q[bt+20>>2]=Ye;An(Ye)}T=bt- -64|0;return Ys|0}bn();F()}function wf(Ye){Ye=Ye|0;var Rr=0,Xs=0;q[Ye>>2]=3584;Rr=q[Ye+76>>2];if(Rr){An(Rr)}Xs=Ye+68|0;Rr=q[Xs>>2];q[Xs>>2]=0;if(Rr){An(Rr)}q[Ye>>2]=3044;Rr=q[Ye+32>>2];if(Rr){q[Ye+36>>2]=Rr;An(Rr)}return Ye|0}function xf(Ye){Ye=Ye|0;var Ys=0,Zs=0;q[Ye>>2]=3584;Ys=q[Ye+76>>2];if(Ys){An(Ys)}Zs=Ye+68|0;Ys=q[Zs>>2];q[Zs>>2]=0;if(Ys){An(Ys)}q[Ye>>2]=3044;Ys=q[Ye+32>>2];if(Ys){q[Ye+36>>2]=Ys;An(Ys)}An(Ye)}function yf(q){q=q|0;return 3}function zf(Ye){Ye=Ye|0;if(!(!q[Ye+60>>2]|!q[Ye+44>>2]|(!q[Ye+48>>2]|!q[Ye+52>>2]))){return q[Ye+56>>2]!=0|0}return 0}function Af(Ye,_s){Ye=Ye|0;_s=_s|0;var zt=0;if(!(q[_s+56>>2]|!_s|r[_s+24|0]!=3)){q[Ye+60>>2]=_s;zt=1}return zt|0}function Bf(Ye,_s){Ye=Ye|0;_s=_s|0;var At=0,Bt=0,Ct=0,Dt=0,Et=0,Ft=0,Gt=0,Ht=0,It=0,Jt=0,Kt=0;Gt=T-32|0;T=Gt;q[Gt+28>>2]=0;a:{b:{if(s[_s+38>>1]<=513){Et=q[_s+12>>2];At=q[_s+20>>2];Ct=q[_s+16>>2];Bt=Ct+4|0;if(Bt>>>0<4){At=At+1|0}Dt=Bt;Bt=At;if((Et|0)<(At|0)?1:(Et|0)<=(At|0)?t[_s+8>>2]>=Dt>>>0?0:1:0){break a}At=Ct+q[_s>>2]|0;At=r[At|0]|r[At+1|0]<<8|(r[At+2|0]<<16|r[At+3|0]<<24);q[Gt+28>>2]=At;q[_s+16>>2]=Dt;q[_s+20>>2]=Bt;break b}if(!tf(1,Gt+28|0,_s)){break a}At=q[Gt+28>>2]}if(!At){break a}Dt=Ye+76|0;uf(Dt,At);It=ah(Gt+8|0);c:{if(!bh(It,_s)){break c}Et=1;while(1){Ct=1<<(Ht&31);Ft=dh(It);Bt=q[Dt>>2]+(Ht>>>3&536870908)|0;Et=Et^Ft;Ft=q[Bt>>2]|Ct;d:{if(!(Et&1)){break d}Ft=q[Bt>>2]&(Ct^-1)}Ct=Ft;Et=Et^1;q[Bt>>2]=Ct;Ht=Ht+1|0;if((At|0)!=(Ht|0)){continue}break}Ht=0;Bt=q[_s+12>>2];Et=Bt;At=q[_s+20>>2];Ct=At;It=q[_s+16>>2];Dt=It+4|0;if(Dt>>>0<4){At=At+1|0}Jt=q[_s+8>>2];Ft=Dt;Dt=At;if((Bt|0)<(At|0)?1:(Bt|0)<=(At|0)?Jt>>>0>=Ft>>>0?0:1:0){break c}Kt=q[_s>>2];At=Kt+It|0;Bt=r[At|0]|r[At+1|0]<<8|(r[At+2|0]<<16|r[At+3|0]<<24);q[_s+16>>2]=Ft;q[_s+20>>2]=Dt;At=Ct;Ct=It+8|0;if(Ct>>>0<8){At=At+1|0}Dt=Ct;Ct=At;if((Et|0)<(At|0)?1:(Et|0)<=(At|0)?Jt>>>0>=Dt>>>0?0:1:0){break c}At=Ft+Kt|0;At=r[At|0]|r[At+1|0]<<8|(r[At+2|0]<<16|r[At+3|0]<<24);q[_s+16>>2]=Dt;q[_s+20>>2]=Ct;if((Bt|0)>(At|0)){break c}q[Ye+16>>2]=At;q[Ye+12>>2]=Bt;_s=Bt;Bt=(At>>31)-((At>>>0<_s>>>0)+(_s>>31)|0)|0;_s=At-_s|0;if(!Bt&_s>>>0>2147483646|Bt>>>0>0){break c}Ht=1;_s=_s+1|0;q[Ye+20>>2]=_s;Bt=Ye+24|0;At=(_s|0)/2|0;q[Bt>>2]=At;q[Ye+28>>2]=0-At;if(_s&1){break c}q[Bt>>2]=At+ -1}}T=Gt+32|0;return Ht|0}function Cf(Ye,_s,Lt,Mt,Nt,Ot){Ye=Ye|0;_s=_s|0;Lt=Lt|0;Mt=Mt|0;Nt=Nt|0;Ot=Ot|0;var Pt=0,Qt=0,Rt=0,St=0,Tt=0,Ut=0,Vt=0,Wt=0,Xt=0,Yt=0,Zt=0,_t=0;q[Ye+64>>2]=Ot;q[Ye+72>>2]=Nt;Ot=Mm((Nt&1073741823)!=(Nt|0)?-1:Nt<<2);Mt=q[Ye+68>>2];q[Ye+68>>2]=Ot;if(Mt){An(Mt)}q[Ye+8>>2]=Nt;Ot=Ye+32|0;Pt=q[Ot>>2];Mt=q[Ye+36>>2]-Pt>>2;a:{if(Mt>>>0<Nt>>>0){Fa(Ot,Nt-Mt|0);break a}if(Mt>>>0<=Nt>>>0){break a}q[Ye+36>>2]=Pt+(Nt<<2)}b:{Mt=q[Ye+56>>2];Pt=q[Mt+4>>2];Ot=q[Mt>>2];Mt=Pt-Ot|0;if((Mt|0)<1){break b}if((Ot|0)!=(Pt|0)){Zt=Mt>>2;Tt=Ye+8|0;Vt=Ye+16|0;Wt=Ye+32|0;Xt=Ye+20|0;Yt=Ye+12|0;_t=Ye+56|0;while(1){Df(Ye,q[(Rt<<2)+Ot>>2],Lt,Rt);c:{if(q[Tt>>2]<1){break c}Ut=q[Ye+68>>2];Ot=0;while(1){Mt=Ot<<2;Pt=q[Mt+Ut>>2];Qt=q[Vt>>2];d:{if((Pt|0)>(Qt|0)){St=q[Wt>>2];q[Mt+St>>2]=Qt;break d}St=q[Wt>>2];Mt=Mt+St|0;Qt=q[Yt>>2];if((Pt|0)<(Qt|0)){q[Mt>>2]=Qt;break d}q[Mt>>2]=Pt}Ot=Ot+1|0;Pt=q[Tt>>2];if((Ot|0)<(Pt|0)){continue}break}Mt=0;if((Pt|0)<1){break c}Ot=w(Nt,Rt)<<2;Ut=Ot+Lt|0;Qt=_s+Ot|0;while(1){Pt=Mt<<2;Ot=Pt+Ut|0;Pt=q[Pt+Qt>>2]+q[Pt+St>>2]|0;q[Ot>>2]=Pt;e:{if((Pt|0)>q[Vt>>2]){Pt=Pt-q[Xt>>2]|0}else{if((Pt|0)>=q[Yt>>2]){break e}Pt=Pt+q[Xt>>2]|0}q[Ot>>2]=Pt}Mt=Mt+1|0;if((Mt|0)<q[Tt>>2]){continue}break}}Rt=Rt+1|0;if((Rt|0)>=(Zt|0)){break b}Mt=q[_t>>2];Ot=q[Mt>>2];if(q[Mt+4>>2]-Ot>>2>>>0>Rt>>>0){continue}break}}cn();F()}return 1}function Df(Ye,_s,Lt,Mt){var Nt=0,Ot=0,$t=0,au=x(0),bu=x(0),cu=x(0),du=0,eu=x(0),fu=x(0),gu=x(0),hu=x(0),iu=x(0),ju=0,ku=0,lu=x(0),mu=x(0),nu=x(0),ou=x(0),pu=x(0),qu=x(0),ru=x(0),su=x(0),tu=0;Nt=T-48|0;T=Nt;du=-1;Ot=-1;a:{if((_s|0)==-1){break a}Ot=_s+1|0;du=(Ot>>>0)%3|0?Ot:_s+ -2|0;Ot=_s+ -1|0;if((_s>>>0)%3){break a}Ot=_s+2|0}$t=q[Ye+52>>2];_s=q[$t>>2];b:{$t=q[$t+4>>2]-_s>>2;ju=q[q[Ye+48>>2]+28>>2];du=q[ju+(du<<2)>>2];if($t>>>0<=du>>>0){break b}tu=$t;$t=q[(Ot<<2)+ju>>2];if(tu>>>0<=$t>>>0){break b}c:{d:{Ot=q[_s+(du<<2)>>2];ju=(Ot|0)>=(Mt|0);if(ju){break d}du=q[_s+($t<<2)>>2];if((du|0)>=(Mt|0)){break d}_s=q[Ye+72>>2];$t=(w(_s,du)<<2)+Lt|0;bu=x(q[$t+4>>2]);_s=(w(_s,Ot)<<2)+Lt|0;iu=x(q[_s+4>>2]);lu=x(q[$t>>2]);ou=x(q[_s>>2]);if(!(lu!=ou|bu!=iu)){Ye=q[Ye+68>>2];_s=Ye;if(x(y(bu))<x(2147483648)){Lt=~~bu}else{Lt=-2147483648}q[_s+4>>2]=Lt;if(x(y(lu))<x(2147483648)){q[Ye>>2]=~~lu;break c}q[Ye>>2]=-2147483648;break c}Mt=q[q[Ye+64>>2]+(Mt<<2)>>2];q[Nt+40>>2]=0;q[Nt+32>>2]=0;q[Nt+36>>2]=0;_s=q[Ye+60>>2];if(!r[_s+84|0]){Mt=q[q[_s+68>>2]+(Mt<<2)>>2]}Da(_s,Mt,o[_s+24|0],Nt+32|0);Mt=q[q[Ye+64>>2]+(Ot<<2)>>2];q[Nt+24>>2]=0;q[Nt+16>>2]=0;q[Nt+20>>2]=0;_s=q[Ye+60>>2];if(!r[_s+84|0]){Mt=q[q[_s+68>>2]+(Mt<<2)>>2]}Da(_s,Mt,o[_s+24|0],Nt+16|0);Lt=q[q[Ye+64>>2]+(du<<2)>>2];q[Nt+8>>2]=0;q[Nt>>2]=0;q[Nt+4>>2]=0;_s=q[Ye+60>>2];if(!r[_s+84|0]){Lt=q[q[_s+68>>2]+(Lt<<2)>>2]}Da(_s,Lt,o[_s+24|0],Nt);mu=u[Nt+40>>2];nu=u[Nt+36>>2];eu=u[Nt+32>>2];qu=u[Nt+16>>2];cu=x(u[Nt>>2]-qu);ru=u[Nt+20>>2];fu=x(u[Nt+4>>2]-ru);su=u[Nt+24>>2];gu=x(u[Nt+8>>2]-su);pu=x(x(x(x(cu*cu)+x(0))+x(fu*fu))+x(gu*gu));e:{if(!(pu>x(0))){hu=x(0);if(q[Ye+88>>2]>257){break e}}eu=x(eu-qu);nu=x(nu-ru);mu=x(mu-su);au=x(x(x(x(x(cu*eu)+x(0))+x(fu*nu))+x(gu*mu))/pu);gu=x(mu-x(gu*au));fu=x(nu-x(fu*au));cu=x(eu-x(cu*au));hu=x(E(x(x(x(gu*gu)+x(x(fu*fu)+x(x(cu*cu)+x(0))))/pu)))}eu=hu;Lt=Ye+80|0;_s=q[Lt>>2]+ -1|0;Mt=q[q[Ye+76>>2]+(_s>>>3&536870908)>>2];q[Lt>>2]=_s;cu=x(bu-iu);hu=x(x(cu*au)+iu);iu=x(lu-ou);bu=x(iu*eu);_s=Mt>>>(_s&31)&1;bu=x(hu+(_s?bu:x(-bu)));hu=x(x(iu*au)+ou);au=x(cu*eu);au=x(hu+(_s?x(-au):au));f:{if(((k(au),e(0))&2147483647)>>>0>=2139095041){_s=q[Ye+68>>2];q[_s>>2]=-2147483648;break f}_s=q[Ye+68>>2];Ye=_s;ku=C(+au+.5);g:{if(y(ku)<2147483648){Lt=~~ku;break g}Lt=-2147483648}q[Ye>>2]=Lt}Lt=((k(bu),e(0))&2147483647)>>>0>2139095040;ku=C(+bu+.5);h:{if(y(ku)<2147483648){Ye=~~ku;break h}Ye=-2147483648}q[_s+4>>2]=Lt?-2147483648:Ye;break c}i:{if(!ju){_s=q[Ye+72>>2];Mt=w(Ot,_s);break i}if((Mt|0)<=0){if(q[Ye+72>>2]<1){break c}Lt=q[Ye+68>>2];_s=0;while(1){q[Lt+(_s<<2)>>2]=0;_s=_s+1|0;if((_s|0)<q[Ye+72>>2]){continue}break}break c}_s=q[Ye+72>>2];Mt=w(_s,Mt+ -1|0)}if((_s|0)<1){break c}Ot=q[Ye+68>>2];_s=0;while(1){q[Ot+(_s<<2)>>2]=q[(_s+Mt<<2)+Lt>>2];_s=_s+1|0;if((_s|0)<q[Ye+72>>2]){continue}break}}T=Nt+48|0;return}cn();F()}function Ef(Ye){Ye=Ye|0;var _s=0;q[Ye>>2]=3812;_s=q[Ye+76>>2];if(_s){An(_s)}q[Ye>>2]=3044;_s=q[Ye+32>>2];if(_s){q[Ye+36>>2]=_s;An(_s)}return Ye|0}function Ff(Ye){Ye=Ye|0;var Lt=0;q[Ye>>2]=3812;Lt=q[Ye+76>>2];if(Lt){An(Lt)}q[Ye>>2]=3044;Lt=q[Ye+32>>2];if(Lt){q[Ye+36>>2]=Lt;An(Lt)}An(Ye)}function Gf(q){q=q|0;return 5}function Hf(Ye,Mt){Ye=Ye|0;Mt=Mt|0;var uu=0,vu=0,wu=0,xu=0,yu=0,zu=0,Au=0,Bu=0,Cu=0,Du=0,Eu=0;Bu=T-16|0;T=Bu;wu=q[Mt+12>>2];uu=q[Mt+20>>2];xu=q[Mt+16>>2];vu=xu+4|0;if(vu>>>0<4){uu=uu+1|0}yu=vu;vu=uu;a:{if((wu|0)<(uu|0)?1:(wu|0)<=(uu|0)?t[Mt+8>>2]>=yu>>>0?0:1:0){break a}uu=xu+q[Mt>>2]|0;uu=r[uu|0]|r[uu+1|0]<<8|(r[uu+2|0]<<16|r[uu+3|0]<<24);q[Mt+16>>2]=yu;q[Mt+20>>2]=vu;if((uu|0)<0){break a}uf(Ye+76|0,uu);yu=ah(Bu);b:{if(!bh(yu,Mt)){break b}if((uu|0)>=1){wu=1;while(1){xu=1<<(Au&31);zu=dh(yu);vu=q[Ye+76>>2]+(Au>>>3&536870908)|0;wu=wu^zu;zu=q[vu>>2]|xu;c:{if(!(wu&1)){break c}zu=q[vu>>2]&(xu^-1)}xu=zu;wu=wu^1;q[vu>>2]=xu;Au=Au+1|0;if((uu|0)!=(Au|0)){continue}break}}vu=q[Mt+12>>2];Au=vu;uu=q[Mt+20>>2];wu=uu;yu=q[Mt+16>>2];xu=yu+4|0;if(xu>>>0<4){uu=uu+1|0}Cu=q[Mt+8>>2];zu=xu;xu=uu;if((vu|0)<(uu|0)?1:(vu|0)<=(uu|0)?Cu>>>0>=zu>>>0?0:1:0){break b}Du=q[Mt>>2];uu=Du+yu|0;vu=r[uu|0]|r[uu+1|0]<<8|(r[uu+2|0]<<16|r[uu+3|0]<<24);q[Mt+16>>2]=zu;q[Mt+20>>2]=xu;uu=wu;wu=yu+8|0;if(wu>>>0<8){uu=uu+1|0}xu=wu;wu=uu;if((Au|0)<(uu|0)?1:(Au|0)<=(uu|0)?Cu>>>0>=xu>>>0?0:1:0){break b}uu=zu+Du|0;uu=r[uu|0]|r[uu+1|0]<<8|(r[uu+2|0]<<16|r[uu+3|0]<<24);q[Mt+16>>2]=xu;q[Mt+20>>2]=wu;if((vu|0)>(uu|0)){break b}q[Ye+16>>2]=uu;q[Ye+12>>2]=vu;Mt=vu;vu=(uu>>31)-((uu>>>0<Mt>>>0)+(Mt>>31)|0)|0;Mt=uu-Mt|0;if(!vu&Mt>>>0>2147483646|vu>>>0>0){break b}Eu=1;Mt=Mt+1|0;q[Ye+20>>2]=Mt;vu=Ye+24|0;uu=(Mt|0)/2|0;q[vu>>2]=uu;q[Ye+28>>2]=0-uu;if(Mt&1){break b}q[vu>>2]=uu+ -1}}T=Bu+16|0;return Eu|0}function If(Ye,Mt,Fu,Gu,Hu,Iu){Ye=Ye|0;Mt=Mt|0;Fu=Fu|0;Gu=Gu|0;Hu=Hu|0;Iu=Iu|0;var Ju=0,Ku=0,Lu=0,Mu=0,Nu=0,Ou=0,Pu=0,Qu=0,Ru=0,Su=0,Tu=0,Uu=0;Gu=0;a:{if((Hu|0)!=2){break a}q[Ye+8>>2]=2;q[Ye- -64>>2]=Iu;Gu=Ye+32|0;Hu=q[Gu>>2];Iu=q[Ye+36>>2]-Hu|0;Ju=Iu>>2;b:{if(Ju>>>0<=1){Fa(Gu,2-Ju|0);break b}if((Iu|0)==8){break b}q[Ye+36>>2]=Hu+8}Gu=1;Hu=q[Ye+56>>2];Iu=q[Hu+4>>2];Hu=q[Hu>>2];Ju=Iu-Hu|0;if((Ju|0)<1){break a}if((Hu|0)!=(Iu|0)){Ru=Ye+60|0;Su=Ju>>2;Ju=Ye+8|0;Nu=Ye+16|0;Ou=Ye+32|0;Pu=Ye+20|0;Qu=Ye+12|0;Tu=Ye+56|0;while(1){if(!Jf(Ru,q[(Lu<<2)+Hu>>2],Fu,Lu)){Gu=0;break a}c:{if(q[Ju>>2]<1){break c}Hu=0;while(1){Gu=Hu<<2;Iu=q[(Gu+Ye|0)+68>>2];Ku=q[Nu>>2];d:{if((Iu|0)>(Ku|0)){Mu=q[Ou>>2];q[Gu+Mu>>2]=Ku;break d}Mu=q[Ou>>2];Gu=Gu+Mu|0;Ku=q[Qu>>2];if((Iu|0)<(Ku|0)){q[Gu>>2]=Ku;break d}q[Gu>>2]=Iu}Hu=Hu+1|0;Gu=q[Ju>>2];if((Hu|0)<(Gu|0)){continue}break}Iu=0;if((Gu|0)<1){break c}Gu=Lu<<3;Ku=Gu+Fu|0;Uu=Mt+Gu|0;while(1){Hu=Iu<<2;Gu=Hu+Ku|0;Hu=q[Hu+Uu>>2]+q[Hu+Mu>>2]|0;q[Gu>>2]=Hu;e:{if((Hu|0)>q[Nu>>2]){Hu=Hu-q[Pu>>2]|0}else{if((Hu|0)>=q[Qu>>2]){break e}Hu=Hu+q[Pu>>2]|0}q[Gu>>2]=Hu}Iu=Iu+1|0;if((Iu|0)<q[Ju>>2]){continue}break}}Gu=1;Lu=Lu+1|0;if((Lu|0)>=(Su|0)){break a}Gu=q[Tu>>2];Hu=q[Gu>>2];if(q[Gu+4>>2]-Hu>>2>>>0>Lu>>>0){continue}break}}cn();F()}return Gu|0}function Jf(Ye,Mt,Fu,Gu){var Hu=0,Iu=0,Vu=0,Wu=0,Xu=0,Yu=0,Zu=0,_u=0,$u=0,av=0,bv=0,cv=0,dv=0,ev=0,fv=0,gv=0,hv=0,iv=0,jv=0,kv=0,lv=0,mv=0,nv=0,ov=0,pv=0;Vu=T-80|0;T=Vu;Iu=-1;Hu=-1;a:{if((Mt|0)==-1){break a}Hu=Mt+1|0;Iu=(Hu>>>0)%3|0?Hu:Mt+ -2|0;Hu=Mt+ -1|0;if((Mt>>>0)%3){break a}Hu=Mt+2|0}Wu=q[Ye+36>>2];Mt=q[Wu>>2];b:{c:{d:{e:{f:{Wu=q[Wu+4>>2]-Mt>>2;Xu=Iu<<2;Iu=q[q[Ye+32>>2]+28>>2];Yu=q[Xu+Iu>>2];if(Wu>>>0<=Yu>>>0){break f}Hu=q[Iu+(Hu<<2)>>2];if(Wu>>>0<=Hu>>>0){break f}g:{h:{$u=q[Mt+(Yu<<2)>>2];cv=($u|0)>=(Gu|0);if(cv){break h}Iu=q[Mt+(Hu<<2)>>2];if((Iu|0)>=(Gu|0)){break h}Mt=Iu<<3;hv=q[(Mt|4)+Fu>>2];Hu=$u<<3;av=q[(Hu|4)+Fu>>2];ev=q[Mt+Fu>>2];gv=q[Fu+Hu>>2];if(!((ev|0)!=(gv|0)|(av|0)!=(hv|0))){q[Ye+8>>2]=gv;q[Ye+12>>2]=av;break g}Mt=q[q[Ye+4>>2]+(Gu<<2)>>2];q[Vu+72>>2]=0;q[Vu+76>>2]=0;Hu=Vu- -64|0;q[Hu>>2]=0;q[Hu+4>>2]=0;q[Vu+56>>2]=0;q[Vu+60>>2]=0;Hu=q[Ye>>2];if(!r[Hu+84|0]){Mt=q[q[Hu+68>>2]+(Mt<<2)>>2]}Kf(Hu,Mt,o[Hu+24|0],Vu+56|0);Mt=q[q[Ye+4>>2]+($u<<2)>>2];q[Vu+48>>2]=0;q[Vu+52>>2]=0;q[Vu+40>>2]=0;q[Vu+44>>2]=0;q[Vu+32>>2]=0;q[Vu+36>>2]=0;Hu=q[Ye>>2];if(!r[Hu+84|0]){Mt=q[q[Hu+68>>2]+(Mt<<2)>>2]}Kf(Hu,Mt,o[Hu+24|0],Vu+32|0);Mt=q[q[Ye+4>>2]+(Iu<<2)>>2];q[Vu+24>>2]=0;q[Vu+28>>2]=0;q[Vu+16>>2]=0;q[Vu+20>>2]=0;q[Vu+8>>2]=0;q[Vu+12>>2]=0;Hu=q[Ye>>2];if(!r[Hu+84|0]){Mt=q[q[Hu+68>>2]+(Mt<<2)>>2]}Kf(Hu,Mt,o[Hu+24|0],Vu+8|0);iv=q[Vu+44>>2];Mt=q[Vu+16>>2];Xu=q[Vu+40>>2];Hu=Xu;Iu=q[Vu+20>>2]-(iv+(Mt>>>0<Hu>>>0)|0)|0;kv=Mt-Hu|0;Mt=$n(kv,Iu,kv,Iu);Hu=V;_u=Mt;jv=q[Vu+36>>2];Mt=q[Vu+8>>2];Zu=q[Vu+32>>2];Yu=Zu;Wu=q[Vu+12>>2]-(jv+(Mt>>>0<Yu>>>0)|0)|0;lv=Mt-Yu|0;Yu=$n(lv,Wu,lv,Wu);Mt=_u+Yu|0;Hu=V+Hu|0;Hu=Mt>>>0<Yu>>>0?Hu+1|0:Hu;dv=Mt;nv=q[Vu+52>>2];Mt=q[Vu+24>>2];_u=q[Vu+48>>2];Yu=_u;bv=q[Vu+28>>2]-(nv+(Mt>>>0<Yu>>>0)|0)|0;mv=Mt-Yu|0;Yu=$n(mv,bv,mv,bv);Mt=dv+Yu|0;Hu=V+Hu|0;fv=Mt;Yu=Mt>>>0<Yu>>>0?Hu+1|0:Hu;if(!(Mt|Yu)){break h}Gu=1;Mt=0;Hu=q[Vu+64>>2];Fu=q[Vu+68>>2]-((Hu>>>0<Xu>>>0)+iv|0)|0;Hu=Hu-Xu|0;$u=Hu;cv=Fu;Fu=$n(kv,Iu,Hu,Fu);Hu=V;dv=Fu;Xu=q[Vu+56>>2];Fu=Xu-Zu|0;iv=q[Vu+60>>2]-((Xu>>>0<Zu>>>0)+jv|0)|0;Zu=$n(Fu,iv,lv,Wu);Xu=dv+Zu|0;Hu=V+Hu|0;Hu=Xu>>>0<Zu>>>0?Hu+1|0:Hu;dv=Xu;Xu=q[Vu+72>>2];Zu=Xu-_u|0;jv=q[Vu+76>>2]-((Xu>>>0<_u>>>0)+nv|0)|0;_u=$n(Zu,jv,mv,bv);Xu=dv+_u|0;Hu=V+Hu|0;Hu=Xu>>>0<_u>>>0?Hu+1|0:Hu;_u=Xu;Xu=Hu;Iu=ao($n(_u,Hu,kv,Iu),V,fv,Yu);cv=cv-(V+($u>>>0<Iu>>>0)|0)|0;Iu=$u-Iu|0;Iu=$n(Iu,cv,Iu,cv);$u=V;dv=Iu;Hu=ao($n(lv,Wu,_u,Hu),V,fv,Yu);Iu=iv-(V+(Fu>>>0<Hu>>>0)|0)|0;Fu=Fu-Hu|0;Iu=$n(Fu,Iu,Fu,Iu);Fu=dv+Iu|0;Hu=V+$u|0;Hu=Fu>>>0<Iu>>>0?Hu+1|0:Hu;Wu=Fu;Fu=ao($n(_u,Xu,mv,bv),V,fv,Yu);Iu=jv-(V+(Zu>>>0<Fu>>>0)|0)|0;Fu=Zu-Fu|0;Iu=$n(Fu,Iu,Fu,Iu);Fu=Wu+Iu|0;Hu=V+Hu|0;Iu=$n(Fu,Fu>>>0<Iu>>>0?Hu+1|0:Hu,fv,Yu);Fu=V;Wu=Fu;if(!Fu&Iu>>>0<=1|Fu>>>0<0){break e}bv=Iu;Fu=Wu;while(1){Hu=Mt<<1|Gu>>>31;Gu=Gu<<1;Mt=Hu;Zu=!Fu&bv>>>0>7|Fu>>>0>0;bv=(Fu&3)<<30|bv>>>2;Fu=Fu>>>2;if(Zu){continue}break}break d}Hu=Ye;if(cv){if((Gu|0)<=0){q[Ye+8>>2]=0;q[Ye+12>>2]=0;break g}Mt=(Gu<<1)+ -2|0}else{Mt=$u<<1}Mt=(Mt<<2)+Fu|0;q[Hu+8>>2]=q[Mt>>2];q[Ye+12>>2]=q[Mt+4>>2]}Fu=1;break b}cn();F()}Gu=Iu;Mt=Wu;if(Iu-1){break c}}while(1){Fu=bo(Iu,Wu,Gu,Mt)+Gu|0;Hu=Mt+V|0;Hu=Fu>>>0<Gu>>>0?Hu+1|0:Hu;Gu=(Hu&1)<<31|Fu>>>1;Mt=Hu>>>1;Fu=$n(Gu,Mt,Gu,Mt);Hu=V;if((Wu|0)==(Hu|0)&Fu>>>0>Iu>>>0|Hu>>>0>Wu>>>0){continue}break}}Hu=q[Ye+20>>2];Fu=0;if(!Hu){break b}Wu=Hu+ -1|0;bv=q[q[Ye+16>>2]+(Wu>>>3&536870908)>>2];q[Ye+20>>2]=Wu;Fu=hv;Hu=av;Zu=Fu-Hu|0;av=Hu>>31;hv=(Fu>>31)-(av+(Fu>>>0<Hu>>>0)|0)|0;Fu=$n(_u,Xu,Zu,hv);Iu=V;av=$n(Hu,av,fv,Yu);Fu=av+Fu|0;Hu=V+Iu|0;Hu=Fu>>>0<av>>>0?Hu+1|0:Hu;dv=Fu;Fu=ev;Iu=gv;$u=Fu-Iu|0;gv=Iu>>31;av=(Fu>>31)-(gv+(Fu>>>0<Iu>>>0)|0)|0;Fu=$n(Gu,Mt,$u,av);ev=Fu;Fu=bv>>>(Wu&31)&1;cv=Fu?0-ev|0:ev;Wu=dv+cv|0;bv=Hu;Hu=V;Hu=bv+(Fu?0-(Hu+(0<ev>>>0)|0)|0:Hu)|0;ov=Ye,pv=ao(Wu,Wu>>>0<cv>>>0?Hu+1|0:Hu,fv,Yu),q[ov+12>>2]=pv;Hu=$n(_u,Xu,$u,av);Wu=V;ev=Ye;Iu=$n(Iu,gv,fv,Yu);Ye=Iu+Hu|0;Hu=V+Wu|0;Hu=Ye>>>0<Iu>>>0?Hu+1|0:Hu;Xu=Ye;Ye=$n(Gu,Mt,Zu,hv);Gu=Fu?Ye:0-Ye|0;Mt=Xu+Gu|0;Xu=Hu;Hu=V;Ye=Xu+(Fu?Hu:0-((0<Ye>>>0)+Hu|0)|0)|0;ov=ev,pv=ao(Mt,Mt>>>0<Gu>>>0?Ye+1|0:Ye,fv,Yu),q[ov+8>>2]=pv;Fu=1}T=Vu+80|0;return Fu}



function Kf(a,b,c,d){var e=0,f=0,g=0,h=0,i=x(0),j=0,k=0;a:{b:{if(!d){break b}e=q[a+28>>2]+ -1|0;if(e>>>0>10){break b}c:{d:{e:{switch(e-1|0){default:e=o[a+24|0];if(((e|0)>(c|0)?c:e)<<24>>24>=1){g=q[q[a>>2]>>2];e=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],b,0)|0;b=g+e|0;while(1){e=(f<<3)+d|0;h=o[b|0];q[e>>2]=h;q[e+4>>2]=h>>31;b=b+1|0;f=f+1|0;e=o[a+24|0];if((f|0)<((e|0)>(c|0)?c:e)<<24>>24){continue}break}}if((e|0)>=(c|0)){break b}break a;case 0:e=o[a+24|0];if(((e|0)>(c|0)?c:e)<<24>>24>=1){g=q[q[a>>2]>>2];e=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],b,0)|0;b=g+e|0;while(1){e=(f<<3)+d|0;q[e>>2]=r[b|0];q[e+4>>2]=0;b=b+1|0;f=f+1|0;e=o[a+24|0];if((f|0)<((e|0)>(c|0)?c:e)<<24>>24){continue}break}}if((e|0)>=(c|0)){break b}break a;case 1:e=o[a+24|0];if(((e|0)>(c|0)?c:e)<<24>>24>=1){g=q[q[a>>2]>>2];e=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],b,0)|0;b=g+e|0;while(1){e=(f<<3)+d|0;h=p[b>>1];q[e>>2]=h;q[e+4>>2]=h>>31;b=b+2|0;f=f+1|0;e=o[a+24|0];if((f|0)<((e|0)>(c|0)?c:e)<<24>>24){continue}break}}if((e|0)>=(c|0)){break b}break a;case 2:e=o[a+24|0];if(((e|0)>(c|0)?c:e)<<24>>24>=1){g=q[q[a>>2]>>2];e=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],b,0)|0;b=g+e|0;while(1){e=(f<<3)+d|0;q[e>>2]=s[b>>1];q[e+4>>2]=0;b=b+2|0;f=f+1|0;e=o[a+24|0];if((f|0)<((e|0)>(c|0)?c:e)<<24>>24){continue}break}}if((e|0)>=(c|0)){break b}break a;case 3:e=o[a+24|0];if(((e|0)>(c|0)?c:e)<<24>>24>=1){g=q[q[a>>2]>>2];e=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],b,0)|0;b=g+e|0;while(1){e=(f<<3)+d|0;h=q[b>>2];q[e>>2]=h;q[e+4>>2]=h>>31;b=b+4|0;f=f+1|0;e=o[a+24|0];if((f|0)<((e|0)>(c|0)?c:e)<<24>>24){continue}break}}if((e|0)>=(c|0)){break b}break a;case 4:e=o[a+24|0];if(((e|0)>(c|0)?c:e)<<24>>24>=1){g=q[q[a>>2]>>2];e=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],b,0)|0;b=g+e|0;while(1){e=(f<<3)+d|0;q[e>>2]=q[b>>2];q[e+4>>2]=0;b=b+4|0;f=f+1|0;e=o[a+24|0];if((f|0)<((e|0)>(c|0)?c:e)<<24>>24){continue}break}}if((e|0)>=(c|0)){break b}break a;case 5:e=o[a+24|0];if(((e|0)>(c|0)?c:e)<<24>>24>=1){g=q[q[a>>2]>>2];e=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],b,0)|0;b=g+e|0;while(1){h=q[b+4>>2];e=(f<<3)+d|0;q[e>>2]=q[b>>2];q[e+4>>2]=h;b=b+8|0;f=f+1|0;e=o[a+24|0];if((f|0)<((e|0)>(c|0)?c:e)<<24>>24){continue}break}}if((e|0)>=(c|0)){break b}break a;case 6:e=o[a+24|0];if(((e|0)>(c|0)?c:e)<<24>>24>=1){g=q[q[a>>2]>>2];e=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],b,0)|0;b=g+e|0;while(1){h=q[b+4>>2];e=(f<<3)+d|0;q[e>>2]=q[b>>2];q[e+4>>2]=h;b=b+8|0;f=f+1|0;e=o[a+24|0];if((f|0)<((e|0)>(c|0)?c:e)<<24>>24){continue}break}}if((e|0)>=(c|0)){break b}break a;case 7:e=o[a+24|0];if(((e|0)>(c|0)?c:e)<<24>>24<1){break c}g=q[q[a>>2]>>2];e=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],b,0)|0;b=g+e|0;while(1){e=(f<<3)+d|0;g=e;i=u[b>>2];f:{if(x(y(i))<x(0x8000000000000000)){h=x(y(i))>=x(1)?i>x(0)?~~x(A(x(C(x(i/x(4294967296)))),x(4294967296)))>>>0:~~x(D(x(x(i-x(~~i>>>0>>>0))/x(4294967296))))>>>0:0;k=~~i>>>0;break f}h=-2147483648;k=0}q[g>>2]=k;q[e+4>>2]=h;b=b+4|0;f=f+1|0;e=o[a+24|0];if((f|0)<((e|0)>(c|0)?c:e)<<24>>24){continue}break}break c;case 8:e=o[a+24|0];if(((e|0)>(c|0)?c:e)<<24>>24<1){break d}g=q[q[a>>2]>>2];e=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],b,0)|0;b=g+e|0;while(1){e=(f<<3)+d|0;g=e;j=v[b>>3];g:{if(y(j)<0x8000000000000000){h=y(j)>=1?j>0?~~A(C(j/4294967296),4294967295)>>>0:~~D((j- +(~~j>>>0>>>0))/4294967296)>>>0:0;k=~~j>>>0;break g}h=-2147483648;k=0}q[g>>2]=k;q[e+4>>2]=h;b=b+8|0;f=f+1|0;e=o[a+24|0];if((f|0)<((e|0)>(c|0)?c:e)<<24>>24){continue}break}break d;case 9:break e}}e=o[a+24|0];if(((e|0)>(c|0)?c:e)<<24>>24>=1){g=q[q[a>>2]>>2];e=q[a+48>>2]+$n(q[a+40>>2],q[a+44>>2],b,0)|0;b=g+e|0;while(1){e=(f<<3)+d|0;q[e>>2]=r[b|0];q[e+4>>2]=0;b=b+1|0;f=f+1|0;e=o[a+24|0];if((f|0)<((e|0)>(c|0)?c:e)<<24>>24){continue}break}}if((e|0)>=(c|0)){break b}Dn((e<<3)+d|0,0,c-e<<3);break b}if((e|0)>=(c|0)){break b}break a}if((e|0)>=(c|0)){break b}Dn((e<<3)+d|0,0,c-e<<3)}return}Dn((e<<3)+d|0,0,c-e<<3)}function Lf(a){a=a|0;var b=0;q[a>>2]=4048;q[a>>2]=3044;b=q[a+32>>2];if(b){q[a+36>>2]=b;An(b)}return a|0}function Mf(a){a=a|0;var c=0;q[a>>2]=4048;q[a>>2]=3044;c=q[a+32>>2];if(c){q[a+36>>2]=c;An(c)}An(a)}function Nf(a){a=a|0;return 6}function Of(a){a=a|0;var d=0;a:{if(!q[a- -64>>2]|!q[a+68>>2]|(!q[a+44>>2]|!q[a+48>>2])){break a}if(!q[a+52>>2]|!q[a+56>>2]){break a}d=q[a+92>>2]!=-1}return d|0}function Pf(a,l){a=a|0;l=l|0;var m=0;if(!(q[l+56>>2]|r[l+24|0]!=3)){q[a- -64>>2]=l;m=1}return m|0}function Qf(a,l){a=a|0;l=l|0;var n=0,o=0,p=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;w=q[l+12>>2];p=w;o=q[l+20>>2];u=o;x=q[l+16>>2];n=x+4|0;if(n>>>0<4){o=o+1|0}y=q[l+8>>2];t=n;n=o;a:{if((p|0)<(n|0)?1:(p|0)<=(n|0)?y>>>0>=t>>>0?0:1:0){break a}z=q[l>>2];o=x+z|0;p=r[o|0]|r[o+1|0]<<8|(r[o+2|0]<<16|r[o+3|0]<<24);q[l+16>>2]=t;q[l+20>>2]=n;n=w;o=u;v=x+8|0;if(v>>>0<8){o=o+1|0}if((n|0)<(o|0)?1:(n|0)<=(o|0)?y>>>0>=v>>>0?0:1:0){break a}n=t+z|0;n=r[n|0]|r[n+1|0]<<8|(r[n+2|0]<<16|r[n+3|0]<<24);q[l+16>>2]=v;q[l+20>>2]=o;if((p|0)>(n|0)){break a}q[a+16>>2]=n;q[a+12>>2]=p;t=p;p=(n>>31)-((p>>31)+(n>>>0<p>>>0)|0)|0;n=n-t|0;if(!p&n>>>0>2147483646|p>>>0>0){break a}p=n+1|0;q[a+20>>2]=p;t=a+24|0;n=(p|0)/2|0;q[t>>2]=n;q[a+28>>2]=0-n;if(!(p&1)){q[t>>2]=n+ -1}if(s[l+38>>1]<=513){if((w|0)<(o|0)?1:(w|0)<=(o|0)?y>>>0>v>>>0?0:1:0){break a}n=r[v+z|0];o=u;u=x+9|0;if(u>>>0<9){o=o+1|0}p=l;q[p+16>>2]=u;q[p+20>>2]=o;if(n>>>0>1){break a}q[a+88>>2]=n-1|0?0:1}A=bh(a+108|0,l)}return A|0}function Rf(a,l,r,s,B,C){a=a|0;l=l|0;r=r|0;s=s|0;B=B|0;C=C|0;var D=0,E=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0;E=T-32|0;T=E;q[a+68>>2]=C;s=q[a+56>>2];B=q[s>>2];C=s+4|0;D=q[C>>2];q[E+24>>2]=0;q[E+16>>2]=0;q[E+20>>2]=0;a:{B=D-B|0;if((B|0)<1){break a}s=q[s>>2];if((s|0)!=q[C>>2]){P=B>>2;Q=a+60|0;R=a+108|0;K=a+8|0;L=a+16|0;M=a+32|0;N=a+20|0;O=a+12|0;S=a+56|0;while(1){Sf(Q,q[(I<<2)+s>>2],E+16|0);B=q[E+20>>2];D=B>>31;C=q[E+16>>2];G=C>>31;J=q[E+24>>2];H=J>>31;s=0;H=H^H+J;D=H+((D^B+D)+(G^C+G)|0)|0;if(D>>>0<H>>>0){s=1}b:{if(!(s|D)){q[E+16>>2]=q[a+104>>2];break b}G=q[a+104>>2];H=G>>31;B=ao($n(G,H,B,B>>31),V,D,s);q[E+20>>2]=B;s=ao($n(G,H,C,C>>31),V,D,s);q[E+16>>2]=s;C=s;s=s>>31;s=(G-(C+s^s)|0)+((B|0)<0?B:0-B|0)|0;if((J|0)>=0){q[E+24>>2]=s;break b}q[E+24>>2]=0-s}s=dh(R);C=q[E+16>>2];c:{if(!s){B=q[E+20>>2];break c}q[E+24>>2]=0-q[E+24>>2];B=0-q[E+20>>2]|0;q[E+20>>2]=B;C=0-C|0;q[E+16>>2]=C}d:{if((C|0)>=0){s=q[a+104>>2];C=s+q[E+24>>2]|0;s=s+B|0;break d}e:{if((B|0)<=-1){C=q[E+24>>2];s=C>>31;s=s^s+C;break e}C=q[E+24>>2];s=C>>31;s=q[a+100>>2]-(s^s+C)|0}if((C|0)<=-1){C=B;B=B>>31;C=C+B^B;break d}C=B;B=B>>31;C=q[a+100>>2]-(C+B^B)|0}B=q[a+100>>2];f:{if(!(s|C)){C=B;s=B;break f}if(!((B|0)!=(C|0)|s)){s=C;break f}if(!((s|0)!=(B|0)|C)){C=s;break f}g:{if(s){break g}D=q[a+104>>2];if((D|0)>=(C|0)){break g}C=(D<<1)-C|0;s=0;break f}h:{if((s|0)!=(B|0)){break h}D=q[a+104>>2];if((D|0)<=(C|0)){break h}C=(D<<1)-C|0;break f}i:{if((B|0)!=(C|0)){break i}B=q[a+104>>2];if((B|0)<=(s|0)){break i}s=(B<<1)-s|0;break f}if(C){break f}C=0;B=q[a+104>>2];if((B|0)>=(s|0)){break f}s=(B<<1)-s|0}q[E+12>>2]=C;q[E+8>>2]=s;j:{if(q[K>>2]<1){break j}C=0;while(1){D=q[L>>2];k:{if((s|0)>(D|0)){B=q[M>>2];q[B+(C<<2)>>2]=D;break k}B=q[M>>2];D=B+(C<<2)|0;G=q[O>>2];if((s|0)<(G|0)){q[D>>2]=G;break k}q[D>>2]=s}C=C+1|0;D=q[K>>2];if((C|0)<(D|0)){s=q[(E+8|0)+(C<<2)>>2];continue}break}s=0;if((D|0)<1){break j}C=I<<3;G=C+r|0;J=l+C|0;while(1){D=s<<2;C=D+G|0;D=q[D+J>>2]+q[B+D>>2]|0;q[C>>2]=D;l:{if((D|0)>q[L>>2]){H=D-q[N>>2]|0}else{if((D|0)>=q[O>>2]){break l}H=D+q[N>>2]|0}q[C>>2]=H}s=s+1|0;if((s|0)<q[K>>2]){continue}break}}I=I+1|0;if((I|0)>=(P|0)){break a}B=q[S>>2];s=q[B>>2];if(q[B+4>>2]-s>>2>>>0>I>>>0){continue}break}}cn();F()}T=E+32|0;return 1}function Sf(a,l,s){a=a|0;l=l|0;s=s|0;var B=0,C=0,U=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0;C=T-96|0;T=C;B=q[a+16>>2];o[C+92|0]=1;q[C+88>>2]=l;q[C+84>>2]=l;q[C+80>>2]=B;W=q[a+20>>2];U=q[W>>2];a:{b:{c:{d:{B=q[q[B+28>>2]+(l<<2)>>2];if(q[W+4>>2]-U>>2>>>0>B>>>0){B=q[q[a+8>>2]+(q[U+(B<<2)>>2]<<2)>>2];U=q[a+4>>2];if(!r[U+84|0]){B=q[q[U+68>>2]+(B<<2)>>2]}q[C+72>>2]=0;q[C+76>>2]=0;W=C- -64|0;q[W>>2]=0;q[W+4>>2]=0;q[C+56>>2]=0;q[C+60>>2]=0;Kf(U,B,o[U+24|0],C+56|0);if((l|0)==-1){break a}B=l+1|0;W=(B>>>0)%3|0?B:l+ -2|0;ea=((l>>>0)%3|0?-1:2)+l|0;la=a+28|0;X=!q[la>>2];ma=a+20|0;na=a+16|0;oa=a+8|0;while(1){U=W;B=ea;e:{if(X){break e}B=l+1|0;U=(B>>>0)%3|0?B:l+ -2|0;B=l+ -1|0;if((l>>>0)%3){break e}B=l+2|0}X=q[ma>>2];l=q[X>>2];U=q[q[q[na>>2]+28>>2]+(U<<2)>>2];if(q[X+4>>2]-l>>2>>>0<=U>>>0){break d}U=q[q[oa>>2]+(q[l+(U<<2)>>2]<<2)>>2];X=a+4|0;l=q[X>>2];if(!r[l+84|0]){U=q[q[l+68>>2]+(U<<2)>>2]}q[C+48>>2]=0;q[C+52>>2]=0;q[C+40>>2]=0;q[C+44>>2]=0;q[C+32>>2]=0;q[C+36>>2]=0;Kf(l,U,o[l+24|0],C+32|0);U=q[ma>>2];l=q[U>>2];B=q[q[q[na>>2]+28>>2]+(B<<2)>>2];if(q[U+4>>2]-l>>2>>>0<=B>>>0){break c}U=q[q[oa>>2]+(q[l+(B<<2)>>2]<<2)>>2];l=q[X>>2];if(!r[l+84|0]){U=q[q[l+68>>2]+(U<<2)>>2]}X=C+24|0;B=X;q[B>>2]=0;q[B+4>>2]=0;_=C+16|0;B=_;q[B>>2]=0;q[B+4>>2]=0;q[C+8>>2]=0;q[C+12>>2]=0;Kf(l,U,o[l+24|0],C+8|0);B=q[C+8>>2];l=q[C+56>>2];fa=B-l|0;ga=q[C+60>>2];U=q[C+12>>2]-(ga+(B>>>0<l>>>0)|0)|0;ha=q[C+40>>2];B=q[C+64>>2];pa=ha-B|0;ia=q[C+68>>2];ha=q[C+44>>2]-(ia+(ha>>>0<B>>>0)|0)|0;ja=$n(fa,U,pa,ha);ka=Y-ja|0;$=$-(V+(Y>>>0<ja>>>0)|0)|0;Y=q[_>>2];ja=Y-B|0;_=q[_+4>>2]-((Y>>>0<B>>>0)+ia|0)|0;Y=q[C+32>>2];ia=Y-l|0;ga=q[C+36>>2]-((Y>>>0<l>>>0)+ga|0)|0;B=$n(ja,_,ia,ga);Y=B+ka|0;l=V+$|0;l=Y>>>0<B>>>0?l+1|0:l;$=l;B=Z;ba=fa;qa=U;Z=q[C+48>>2];l=q[C+72>>2];U=Z-l|0;fa=q[C+76>>2];ka=q[C+52>>2]-(fa+(Z>>>0<l>>>0)|0)|0;ba=$n(ba,qa,U,ka);Z=B+ba|0;B=V+ca|0;B=Z>>>0<ba>>>0?B+1|0:B;ca=Z;Z=q[X>>2];ba=Z-l|0;l=q[X+4>>2]-((Z>>>0<l>>>0)+fa|0)|0;X=$n(ba,l,ia,ga);Z=ca-X|0;ca=B-(V+(ca>>>0<X>>>0)|0)|0;B=$n(ja,_,U,ka);U=aa-B|0;da=da-(V+(aa>>>0<B>>>0)|0)|0;B=$n(ba,l,pa,ha);aa=B+U|0;l=V+da|0;l=aa>>>0<B>>>0?l+1|0:l;da=l;Uf(C+80|0);_=q[la>>2];X=!_;l=q[C+88>>2];if((l|0)!=-1){continue}break}l=ca;B=l>>31;a=l>>31;l=a+l|0;W=B+Z|0;if(W>>>0<B>>>0){l=l+1|0}B=B^W;X=a^l;l=da;a=l>>31;l=l>>31;W=a;ea=da+a|0;U=l+aa|0;if(U>>>0<l>>>0){ea=ea+1|0}a=l^U;U=W^ea;f:{if(($|0)<-1?1:($|0)<=-1?Y>>>0>4294967295?0:1:0){l=Y;W=a+(B-l|0)|0;l=U+(X-((B>>>0<l>>>0)+$|0)|0)|0;B=W;a=B>>>0<a>>>0?l+1|0:l;if(!_){break f}break b}l=X+$|0;W=B;B=Y;W=W+B|0;if(W>>>0<B>>>0){l=l+1|0}B=a;W=B+W|0;a=l+U|0;a=W>>>0<B>>>0?a+1|0:a;B=W;if(_){break b}}if((B|0)<536870913){break a}a=((a&536870911)<<3|B>>>29)&7;l=0;Y=ao(Y,$,a,l);Z=ao(Z,ca,a,l);aa=ao(aa,da,a,l);break a}cn();F()}cn();F()}cn();F()}if((a|0)<0?1:(a|0)<=0?B>>>0>=536870913?0:1:0){break a}l=a>>>29;a=(a&536870911)<<3|B>>>29;Y=ao(Y,$,a,l);Z=ao(Z,ca,a,l);aa=ao(aa,da,a,l)}q[s+8>>2]=Y;q[s+4>>2]=Z;q[s>>2]=aa;T=C+96|0}function Tf(a,l){a=a|0;l=l|0;if(l>>>0<=1){q[a+28>>2]=l;a=1}else{a=0}return a|0}function Uf(a){var l=0,s=0,F=0;l=q[a+8>>2];F=q[a>>2];a:{if(r[a+12|0]){b:{c:{d:{e:{if((l|0)==-1){break e}s=l+1|0;l=(s>>>0)%3|0?s:l+ -2|0;if((l|0)==-1|q[q[F>>2]+(l>>>3&536870908)>>2]>>>(l&31)&1){break e}l=q[q[q[F+64>>2]+12>>2]+(l<<2)>>2];if((l|0)!=-1){break d}}q[a+8>>2]=-1;break c}s=l+1|0;l=(s>>>0)%3|0?s:l+ -2|0;q[a+8>>2]=l;if((l|0)!=-1){break b}}l=-1;s=q[a+4>>2];f:{if((s|0)==-1){break f}s=s+((s>>>0)%3|0?-1:2)|0;if((s|0)==-1|q[q[F>>2]+(s>>>3&536870908)>>2]>>>(s&31)&1){break f}F=q[q[q[F+64>>2]+12>>2]+(s<<2)>>2];if((F|0)==-1){break f}if((F>>>0)%3){l=F+ -1|0;break f}l=F+2|0}o[a+12|0]=0;q[a+8>>2]=l;return}if((l|0)!=q[a+4>>2]){break a}q[a+8>>2]=-1;return}s=-1;g:{if((l|0)==-1){break g}l=l+((l>>>0)%3|0?-1:2)|0;if((l|0)==-1|q[q[F>>2]+(l>>>3&536870908)>>2]>>>(l&31)&1){break g}l=q[q[q[F+64>>2]+12>>2]+(l<<2)>>2];if((l|0)==-1){break g}if((l>>>0)%3){s=l+ -1|0;break g}s=l+2|0}q[a+8>>2]=s}}function Vf(a,r,T,V){var ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0;q[a>>2]=3044;q[a+4>>2]=r;r=q[T+8>>2];ra=q[T+12>>2];sa=q[T+16>>2];ua=q[T+20>>2];va=q[T>>2];wa=q[T+4>>2];q[a+40>>2]=0;ta=a+32|0;q[ta>>2]=0;q[ta+4>>2]=0;q[a+24>>2]=sa;q[a+28>>2]=ua;q[a+16>>2]=r;q[a+20>>2]=ra;q[a+8>>2]=va;q[a+12>>2]=wa;a:{r=q[T+28>>2]-q[T+24>>2]|0;b:{if(!r){break b}ra=r>>2;if(ra>>>0>=1073741824){break a}r=Mm(r);q[a+32>>2]=r;sa=a+36|0;q[sa>>2]=r;q[a+40>>2]=r+(ra<<2);ra=q[T+24>>2];T=q[T+28>>2]-ra|0;if((T|0)<1){break b}xa=sa,ya=Cn(r,ra,T)+T|0,q[xa>>2]=ya}q[a>>2]=5044;r=q[V+4>>2];q[a+44>>2]=q[V>>2];q[a+48>>2]=r;r=q[V+12>>2];q[a+52>>2]=q[V+8>>2];q[a+56>>2]=r;return}bn();F()}function Wf(a,r,T,V,za,Aa){a=a|0;r=r|0;T=T|0;V=V|0;za=za|0;Aa=Aa|0;var Ba=0,Ca=0,Da=0,Ea=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0;q[a+8>>2]=za;Aa=a+32|0;Ca=q[Aa>>2];V=q[a+36>>2]-Ca>>2;a:{if(V>>>0<za>>>0){Fa(Aa,za-V|0);break a}if(V>>>0<=za>>>0){break a}q[a+36>>2]=Ca+(za<<2)}Ra=q[a+52>>2];Oa=q[a+48>>2];V=0;Aa=(za&1073741823)!=(za|0)?-1:za<<2;Na=Dn(Mm(Aa),0,Aa);Ga=a+8|0;Aa=q[Ga>>2];b:{if((Aa|0)<1){break b}Ia=a+16|0;Ca=a+32|0;Ja=a+12|0;while(1){Aa=V<<2;Ba=q[Aa+Na>>2];Ea=q[Ia>>2];c:{if((Ba|0)>(Ea|0)){Ha=q[Ca>>2];q[Aa+Ha>>2]=Ea;break c}Ha=q[Ca>>2];Aa=Aa+Ha|0;Ea=q[Ja>>2];if((Ba|0)<(Ea|0)){q[Aa>>2]=Ea;break c}q[Aa>>2]=Ba}V=V+1|0;Aa=q[Ga>>2];if((V|0)<(Aa|0)){continue}break}if((Aa|0)<1){break b}Ca=0;Ga=a+16|0;Ba=a+20|0;Ia=a+8|0;Ja=a+12|0;while(1){Aa=Ca<<2;V=Aa+T|0;Aa=q[r+Aa>>2]+q[Aa+Ha>>2]|0;q[V>>2]=Aa;d:{if((Aa|0)>q[Ga>>2]){Aa=Aa-q[Ba>>2]|0}else{if((Aa|0)>=q[Ja>>2]){break d}Aa=Aa+q[Ba>>2]|0}q[V>>2]=Aa}Ca=Ca+1|0;Aa=q[Ia>>2];if((Ca|0)<(Aa|0)){continue}break}}V=q[a+56>>2];Pa=q[V>>2];V=q[V+4>>2]-Pa|0;if((V|0)>=5){Qa=V>>2;Ha=a+16|0;Ga=a+32|0;Ia=a+8|0;Ja=a+20|0;Ea=a+12|0;Ca=1;while(1){e:{f:{if(Qa>>>0>Ca>>>0){Ma=w(za,Ca);a=q[(Ca<<2)+Pa>>2];if((a|0)==-1){break f}a=q[q[Oa+12>>2]+(a<<2)>>2];if((a|0)==-1){break f}V=-1;Da=q[Ra>>2];Ba=q[Oa>>2];Ka=q[Da+(q[Ba+(a<<2)>>2]<<2)>>2];La=a+1|0;La=(La>>>0)%3|0?La:a+ -2|0;if((La|0)!=-1){La=q[Ba+(La<<2)>>2]}else{La=-1}a=a+((a>>>0)%3|0?-1:2)|0;if((a|0)!=-1){V=q[Ba+(a<<2)>>2]}if((Ka|0)>=(Ca|0)){break f}a=q[(La<<2)+Da>>2];if((a|0)>=(Ca|0)){break f}V=q[Da+(V<<2)>>2];if((V|0)>=(Ca|0)){break f}if((za|0)>=1){Ba=w(V,za);a=w(a,za);Da=w(za,Ka);V=0;while(1){q[(V<<2)+Na>>2]=(q[(V+Ba<<2)+T>>2]+q[(a+V<<2)+T>>2]|0)-q[(V+Da<<2)+T>>2];V=V+1|0;if((za|0)!=(V|0)){continue}break}}if((Aa|0)<1){break e}V=0;while(1){a=V<<2;Aa=q[a+Na>>2];Da=q[Ha>>2];g:{if((Aa|0)>(Da|0)){Ba=q[Ga>>2];q[a+Ba>>2]=Da;break g}Ba=q[Ga>>2];a=a+Ba|0;Da=q[Ea>>2];if((Aa|0)<(Da|0)){q[a>>2]=Da;break g}q[a>>2]=Aa}V=V+1|0;Aa=q[Ia>>2];if((V|0)<(Aa|0)){continue}break}V=0;if((Aa|0)<1){break e}a=Ma<<2;Ma=a+T|0;Da=a+r|0;while(1){Aa=V<<2;a=Aa+Ma|0;Aa=q[Aa+Da>>2]+q[Aa+Ba>>2]|0;q[a>>2]=Aa;h:{if((Aa|0)>q[Ha>>2]){Aa=Aa-q[Ja>>2]|0}else{if((Aa|0)>=q[Ea>>2]){break h}Aa=Aa+q[Ja>>2]|0}q[a>>2]=Aa}V=V+1|0;Aa=q[Ia>>2];if((V|0)<(Aa|0)){continue}break}break e}cn();F()}if((Aa|0)<1){break e}Da=(w(Ca+ -1|0,za)<<2)+T|0;V=0;while(1){a=V<<2;Aa=q[a+Da>>2];Ka=q[Ha>>2];i:{if((Aa|0)>(Ka|0)){Ba=q[Ga>>2];q[a+Ba>>2]=Ka;break i}Ba=q[Ga>>2];a=a+Ba|0;Ka=q[Ea>>2];if((Aa|0)<(Ka|0)){q[a>>2]=Ka;break i}q[a>>2]=Aa}V=V+1|0;Aa=q[Ia>>2];if((V|0)<(Aa|0)){continue}break}V=0;if((Aa|0)<1){break e}a=Ma<<2;Ma=a+T|0;Da=a+r|0;while(1){Aa=V<<2;a=Aa+Ma|0;Aa=q[Aa+Da>>2]+q[Aa+Ba>>2]|0;q[a>>2]=Aa;j:{if((Aa|0)>q[Ha>>2]){Aa=Aa-q[Ja>>2]|0}else{if((Aa|0)>=q[Ea>>2]){break j}Aa=Aa+q[Ja>>2]|0}q[a>>2]=Aa}V=V+1|0;Aa=q[Ia>>2];if((V|0)<(Aa|0)){continue}break}}Ca=Ca+1|0;if((Ca|0)<(Qa|0)){continue}break}}An(Na);return 1}function Xf(a,r,T,V,za,Aa){a=a|0;r=r|0;T=T|0;V=V|0;za=za|0;Aa=Aa|0;var Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0;q[a+8>>2]=za;Aa=a+32|0;Sa=q[Aa>>2];V=q[a+36>>2]-Sa>>2;a:{if(V>>>0<za>>>0){Fa(Aa,za-V|0);break a}if(V>>>0<=za>>>0){break a}q[a+36>>2]=Sa+(za<<2)}Sa=0;V=(za&1073741823)!=(za|0)?-1:za<<2;$a=Dn(Mm(V),0,V);db=Dn(Mm(V),0,V);Va=a+8|0;Ta=q[Va>>2];b:{if((Ta|0)<1){break b}Za=a+16|0;V=a+32|0;_a=a+12|0;while(1){Aa=Sa<<2;Ta=q[Aa+$a>>2];Wa=q[Za>>2];c:{if((Ta|0)>(Wa|0)){Ua=q[V>>2];q[Aa+Ua>>2]=Wa;break c}Ua=q[V>>2];Aa=Aa+Ua|0;Wa=q[_a>>2];if((Ta|0)<(Wa|0)){q[Aa>>2]=Wa;break c}q[Aa>>2]=Ta}Sa=Sa+1|0;Ta=q[Va>>2];if((Sa|0)<(Ta|0)){continue}break}if((Ta|0)<1){break b}Aa=0;Za=a+16|0;Va=a+20|0;_a=a+8|0;Wa=a+12|0;while(1){Sa=Aa<<2;V=Sa+T|0;Sa=q[r+Sa>>2]+q[Sa+Ua>>2]|0;q[V>>2]=Sa;d:{if((Sa|0)>q[Za>>2]){Xa=Sa-q[Va>>2]|0}else{if((Sa|0)>=q[Wa>>2]){break d}Xa=Sa+q[Va>>2]|0}q[V>>2]=Xa}Aa=Aa+1|0;Ta=q[_a>>2];if((Aa|0)<(Ta|0)){continue}break}}V=q[a+56>>2];eb=q[V>>2];V=q[V+4>>2]-eb|0;if((V|0)>=5){fb=V>>2;gb=q[a+48>>2];kb=za<<2;lb=q[a+52>>2];Za=a+16|0;_a=a+32|0;Wa=a+8|0;bb=a+20|0;cb=a+12|0;Va=1;while(1){e:{f:{g:{if(fb>>>0>Va>>>0){Aa=q[(Va<<2)+eb>>2];hb=(za|0)<1;if(!hb){Dn($a,0,kb)}if((Aa|0)==-1){a=w(za,Va);break f}ib=q[gb+12>>2];Ya=0;V=Aa;while(1){a=q[ib+(V<<2)>>2];h:{if((a|0)==-1){break h}Ua=-1;ab=q[lb>>2];Sa=q[gb>>2];jb=q[ab+(q[Sa+(a<<2)>>2]<<2)>>2];Xa=a+1|0;Xa=(Xa>>>0)%3|0?Xa:a+ -2|0;if((Xa|0)!=-1){Xa=q[Sa+(Xa<<2)>>2]}else{Xa=-1}a=a+((a>>>0)%3|0?-1:2)|0;if((a|0)!=-1){Ua=q[Sa+(a<<2)>>2]}if((jb|0)>=(Va|0)){break h}a=q[(Xa<<2)+ab>>2];if((a|0)>=(Va|0)){break h}Sa=q[ab+(Ua<<2)>>2];if((Sa|0)>=(Va|0)){break h}i:{if(hb){break i}Ua=w(za,Sa);a=w(a,za);ab=w(za,jb);Sa=0;while(1){q[db+(Sa<<2)>>2]=(q[(Sa+Ua<<2)+T>>2]+q[(a+Sa<<2)+T>>2]|0)-q[(Sa+ab<<2)+T>>2];Sa=Sa+1|0;if((Sa|0)!=(za|0)){continue}break}Sa=0;if((za|0)<=0){break i}while(1){a=Sa<<2;Ua=a+$a|0;q[Ua>>2]=q[Ua>>2]+q[a+db>>2];Sa=Sa+1|0;if((Sa|0)!=(za|0)){continue}break}}Ya=Ya+1|0}V=((V>>>0)%3|0?-1:2)+V|0;a=-1;j:{if((V|0)==-1){break j}V=q[ib+(V<<2)>>2];a=-1;if((V|0)==-1){break j}a=V+ -1|0;if((V>>>0)%3){break j}a=V+2|0}V=(a|0)==(Aa|0)?-1:a;if((V|0)!=-1){continue}break}a=w(za,Va);if(!Ya){break f}Sa=0;if((za|0)<=0){break g}while(1){V=(Sa<<2)+$a|0;q[V>>2]=q[V>>2]/(Ya|0);Sa=Sa+1|0;if((Sa|0)!=(za|0)){continue}break}break g}cn();F()}if((Ta|0)<1){break e}Sa=0;while(1){V=Sa<<2;Aa=q[V+$a>>2];Ta=q[Za>>2];k:{if((Aa|0)>(Ta|0)){Ua=q[_a>>2];q[V+Ua>>2]=Ta;break k}Ua=q[_a>>2];V=V+Ua|0;Ta=q[cb>>2];if((Aa|0)<(Ta|0)){q[V>>2]=Ta;break k}q[V>>2]=Aa}Sa=Sa+1|0;Ta=q[Wa>>2];if((Sa|0)<(Ta|0)){continue}break}Aa=0;if((Ta|0)<1){break e}a=a<<2;Sa=a+T|0;Ya=a+r|0;while(1){V=Aa<<2;a=V+Sa|0;V=q[V+Ya>>2]+q[V+Ua>>2]|0;q[a>>2]=V;l:{if((V|0)>q[Za>>2]){V=V-q[bb>>2]|0}else{if((V|0)>=q[cb>>2]){break l}V=V+q[bb>>2]|0}q[a>>2]=V}Aa=Aa+1|0;Ta=q[Wa>>2];if((Aa|0)<(Ta|0)){continue}break}break e}if((Ta|0)<1){break e}Ya=(w(Va+ -1|0,za)<<2)+T|0;Sa=0;while(1){V=Sa<<2;Aa=q[V+Ya>>2];Ta=q[Za>>2];m:{if((Aa|0)>(Ta|0)){Ua=q[_a>>2];q[V+Ua>>2]=Ta;break m}Ua=q[_a>>2];V=V+Ua|0;Ta=q[cb>>2];if((Aa|0)<(Ta|0)){q[V>>2]=Ta;break m}q[V>>2]=Aa}Sa=Sa+1|0;Ta=q[Wa>>2];if((Sa|0)<(Ta|0)){continue}break}Aa=0;if((Ta|0)<1){break e}a=a<<2;Sa=a+T|0;Ya=a+r|0;while(1){V=Aa<<2;a=V+Sa|0;V=q[V+Ya>>2]+q[V+Ua>>2]|0;q[a>>2]=V;n:{if((V|0)>q[Za>>2]){V=V-q[bb>>2]|0}else{if((V|0)>=q[cb>>2]){break n}V=V+q[bb>>2]|0}q[a>>2]=V}Aa=Aa+1|0;Ta=q[Wa>>2];if((Aa|0)<(Ta|0)){continue}break}}Va=Va+1|0;if((Va|0)<(fb|0)){continue}break}}An(db);An($a);return 1}function Yf(a){a=a|0;var r=0;q[a>>2]=5324;r=q[a+96>>2];if(r){An(r)}r=q[a+84>>2];if(r){An(r)}r=q[a+72>>2];if(r){An(r)}r=q[a+60>>2];if(r){An(r)}q[a>>2]=3044;r=q[a+32>>2];if(r){q[a+36>>2]=r;An(r)}return a|0}function Zf(a){a=a|0;var T=0;q[a>>2]=5324;T=q[a+96>>2];if(T){An(T)}T=q[a+84>>2];if(T){An(T)}T=q[a+72>>2];if(T){An(T)}T=q[a+60>>2];if(T){An(T)}q[a>>2]=3044;T=q[a+32>>2];if(T){q[a+36>>2]=T;An(T)}An(a)}function _f(a,V,za,Aa,mb,nb){a=a|0;V=V|0;za=za|0;Aa=Aa|0;mb=mb|0;nb=nb|0;var ob=0,pb=0,qb=0,rb=0,sb=0,tb=0,ub=0,vb=0,wb=0,xb=0,yb=0,zb=0,Ab=0,Bb=0,Cb=0,Db=0,Eb=0,Fb=0,Gb=0,Hb=0,Ib=0,Jb=0,Kb=0,Lb=0,Mb=0;qb=T+ -64|0;T=qb;q[a+8>>2]=mb;nb=a+32|0;rb=q[nb>>2];Aa=q[a+36>>2]-rb>>2;a:{if(Aa>>>0<mb>>>0){Fa(nb,mb-Aa|0);break a}if(Aa>>>0<=mb>>>0){break a}q[a+36>>2]=rb+(mb<<2)}q[qb+56>>2]=0;q[qb+60>>2]=0;q[qb+48>>2]=0;q[qb+52>>2]=0;q[qb+40>>2]=0;q[qb+44>>2]=0;Aa=qb+32|0;q[Aa>>2]=0;q[Aa+4>>2]=0;q[qb+24>>2]=0;q[qb+28>>2]=0;q[qb+16>>2]=0;q[qb+20>>2]=0;q[qb>>2]=0;nb=0;if(mb){Ad(qb+16|0,mb,qb);pb=q[qb+28>>2];nb=q[Aa>>2]}q[qb>>2]=0;Aa=nb-pb>>2;b:{if(Aa>>>0>=mb>>>0){if(Aa>>>0<=mb>>>0){break b}q[qb+32>>2]=(mb<<2)+pb;break b}Ad(qb+16|12,mb-Aa|0,qb)}q[qb>>2]=0;nb=q[qb+40>>2];Aa=q[qb+44>>2]-nb>>2;c:{if(Aa>>>0>=mb>>>0){if(Aa>>>0<=mb>>>0){break c}q[qb+44>>2]=nb+(mb<<2);break c}Ad(qb+40|0,mb-Aa|0,qb)}q[qb>>2]=0;nb=q[qb+52>>2];Aa=q[qb+56>>2]-nb>>2;d:{if(Aa>>>0>=mb>>>0){if(Aa>>>0<=mb>>>0){break d}q[qb+56>>2]=nb+(mb<<2);break d}Ad(qb+52|0,mb-Aa|0,qb)}tb=a+8|0;e:{if(q[tb>>2]<=0){break e}vb=q[qb+16>>2];pb=0;sb=a+16|0;Aa=a+32|0;Ab=a+12|0;while(1){nb=pb<<2;ob=q[nb+vb>>2];wb=q[sb>>2];f:{if((ob|0)>(wb|0)){rb=q[Aa>>2];q[nb+rb>>2]=wb;break f}rb=q[Aa>>2];nb=nb+rb|0;wb=q[Ab>>2];if((ob|0)<(wb|0)){q[nb>>2]=wb;break f}q[nb>>2]=ob}pb=pb+1|0;nb=q[tb>>2];if((pb|0)<(nb|0)){continue}break}if((nb|0)<1){break e}nb=0;tb=a+16|0;pb=a+20|0;vb=a+8|0;sb=a+12|0;while(1){ob=nb<<2;Aa=ob+za|0;ob=q[V+ob>>2]+q[ob+rb>>2]|0;q[Aa>>2]=ob;g:{if((ob|0)>q[tb>>2]){ob=ob-q[pb>>2]|0}else{if((ob|0)>=q[sb>>2]){break g}ob=ob+q[pb>>2]|0}q[Aa>>2]=ob}nb=nb+1|0;if((nb|0)<q[vb>>2]){continue}break}}Lb=q[a+52>>2];Ib=q[a+48>>2];Hb=Mm(16);Aa=Hb;q[Aa>>2]=0;q[Aa+4>>2]=0;q[Aa+8>>2]=0;q[Aa+12>>2]=0;q[qb+8>>2]=0;q[qb>>2]=0;q[qb+4>>2]=0;h:{if(mb){if(mb>>>0>=1073741824){break h}Aa=mb<<2;Bb=Mm(Aa);q[qb>>2]=Bb;nb=Aa+Bb|0;q[qb+8>>2]=nb;Dn(Bb,0,Aa);q[qb+4>>2]=nb}rb=1;Aa=q[a+56>>2];Jb=q[Aa>>2];Aa=q[Aa+4>>2]-Jb|0;i:{if((Aa|0)<5){break i}Kb=Aa>>2;Mb=mb<<2;vb=a+8|0;Ab=a+16|0;wb=a+32|0;Eb=a+20|0;Fb=a+12|0;tb=1;while(1){j:{k:{l:{if(Kb>>>0>tb>>>0){m:{n:{rb=q[(tb<<2)+Jb>>2];if((rb|0)==-1){break n}ub=q[Ib+12>>2];Db=rb+((rb>>>0)%3|0?-1:2)|0;Gb=ub+(Db<<2)|0;sb=1;nb=0;Aa=rb;o:{while(1){ob=q[ub+(Aa<<2)>>2];p:{if((ob|0)==-1){break p}pb=-1;zb=q[Lb>>2];xb=q[Ib>>2];Cb=q[zb+(q[xb+(ob<<2)>>2]<<2)>>2];yb=ob+1|0;yb=(yb>>>0)%3|0?yb:ob+ -2|0;if((yb|0)!=-1){yb=q[xb+(yb<<2)>>2]}else{yb=-1}ob=ob+((ob>>>0)%3|0?-1:2)|0;if((ob|0)!=-1){pb=q[xb+(ob<<2)>>2]}if((Cb|0)>=(tb|0)){break p}ob=q[(yb<<2)+zb>>2];if((ob|0)>=(tb|0)){break p}pb=q[zb+(pb<<2)>>2];if((pb|0)>=(tb|0)){break p}xb=q[(qb+16|0)+w(nb,12)>>2];if((mb|0)>=1){zb=w(mb,pb);ob=w(mb,ob);Cb=w(mb,Cb);pb=0;while(1){q[xb+(pb<<2)>>2]=(q[(pb+zb<<2)+za>>2]+q[(ob+pb<<2)+za>>2]|0)-q[(pb+Cb<<2)+za>>2];pb=pb+1|0;if((pb|0)!=(mb|0)){continue}break}}ob=4;nb=nb+1|0;if((nb|0)==4){break o}}q:{if(sb&1){xb=Aa+1|0;Aa=(xb>>>0)%3|0?xb:Aa+ -2|0;ob=-1;if((Aa|0)==-1){break q}Aa=q[ub+(Aa<<2)>>2];ob=-1;if((Aa|0)==-1){break q}ob=Aa+1|0;ob=(ob>>>0)%3|0?ob:Aa+ -2|0;break q}Aa=((Aa>>>0)%3|0?-1:2)+Aa|0;ob=-1;if((Aa|0)==-1){break q}Aa=q[ub+(Aa<<2)>>2];ob=-1;if((Aa|0)==-1){break q}ob=Aa+ -1|0;if((Aa>>>0)%3){break q}ob=Aa+2|0}r:{if((ob|0)==(rb|0)){break r}Aa=ob;ob=(ob|0)!=-1;pb=(ob|sb^-1)&1;Aa=pb?Aa:-1;sb=ob&sb;if(!((Db|0)==-1|pb)){ob=q[Gb>>2];if((ob|0)==-1){break r}sb=0;if((ob>>>0)%3){Aa=ob+ -1|0}else{Aa=ob+2|0}}if((Aa|0)!=-1){continue}}break}ob=nb;if((ob|0)<1){break n}}ub=(mb|0)<1;if(!ub){Dn(Bb,0,Mb)}Aa=ob+ -1|0;sb=(Aa<<2)+Hb|0;Aa=w(Aa,12)+a|0;xb=Aa+60|0;zb=q[Aa- -64>>2];rb=0;Cb=q[qb>>2];Aa=0;nb=0;while(1){pb=q[sb>>2];q[sb>>2]=pb+1;if(zb>>>0<=pb>>>0){break i}s:{if(q[q[xb>>2]+(pb>>>3&536870908)>>2]>>>(pb&31)&1){break s}nb=nb+1|0;if(ub){break s}yb=q[(qb+16|0)+w(Aa,12)>>2];pb=0;while(1){Db=pb<<2;Gb=Db+Cb|0;q[Gb>>2]=q[Gb>>2]+q[yb+Db>>2];pb=pb+1|0;if((pb|0)!=(mb|0)){continue}break}}Aa=Aa+1|0;if((ob|0)!=(Aa|0)){continue}break}ob=w(mb,tb);Aa=ob;if(!nb){break m}pb=0;if((mb|0)>0){break l}break k}Aa=w(mb,tb)}if(q[vb>>2]<1){break j}sb=(w(tb+ -1|0,mb)<<2)+za|0;pb=0;while(1){nb=pb<<2;ob=q[nb+sb>>2];ub=q[Ab>>2];t:{if((ob|0)>(ub|0)){rb=q[wb>>2];q[nb+rb>>2]=ub;break t}rb=q[wb>>2];nb=nb+rb|0;ub=q[Fb>>2];if((ob|0)<(ub|0)){q[nb>>2]=ub;break t}q[nb>>2]=ob}pb=pb+1|0;ob=q[vb>>2];if((pb|0)<(ob|0)){continue}break}nb=0;if((ob|0)<1){break j}Aa=Aa<<2;pb=Aa+za|0;sb=V+Aa|0;while(1){ob=nb<<2;Aa=ob+pb|0;ob=q[ob+sb>>2]+q[ob+rb>>2]|0;q[Aa>>2]=ob;u:{if((ob|0)>q[Ab>>2]){ob=ob-q[Eb>>2]|0}else{if((ob|0)>=q[Fb>>2]){break u}ob=ob+q[Eb>>2]|0}q[Aa>>2]=ob}nb=nb+1|0;if((nb|0)<q[vb>>2]){continue}break}break j}cn();F()}while(1){Aa=(pb<<2)+Bb|0;q[Aa>>2]=q[Aa>>2]/(nb|0);pb=pb+1|0;if((pb|0)!=(mb|0)){continue}break}}if(q[vb>>2]<1){break j}pb=0;while(1){Aa=pb<<2;nb=q[Aa+Bb>>2];sb=q[Ab>>2];v:{if((nb|0)>(sb|0)){rb=q[wb>>2];q[Aa+rb>>2]=sb;break v}rb=q[wb>>2];Aa=Aa+rb|0;sb=q[Fb>>2];if((nb|0)<(sb|0)){q[Aa>>2]=sb;break v}q[Aa>>2]=nb}pb=pb+1|0;Aa=q[vb>>2];if((pb|0)<(Aa|0)){continue}break}nb=0;if((Aa|0)<1){break j}Aa=ob<<2;pb=Aa+za|0;sb=V+Aa|0;while(1){ob=nb<<2;Aa=ob+pb|0;ob=q[ob+sb>>2]+q[ob+rb>>2]|0;q[Aa>>2]=ob;w:{if((ob|0)>q[Ab>>2]){ob=ob-q[Eb>>2]|0}else{if((ob|0)>=q[Fb>>2]){break w}ob=ob+q[Eb>>2]|0}q[Aa>>2]=ob}nb=nb+1|0;if((nb|0)<q[vb>>2]){continue}break}}rb=1;tb=tb+1|0;if((tb|0)<(Kb|0)){continue}break}}a=q[qb>>2];if(a){q[qb+4>>2]=a;An(a)}An(Hb);a=q[qb+52>>2];if(a){q[qb+56>>2]=a;An(a)}a=q[qb+40>>2];if(a){q[qb+44>>2]=a;An(a)}a=q[qb+28>>2];if(a){q[qb+32>>2]=a;An(a)}a=q[qb+16>>2];if(a){q[qb+20>>2]=a;An(a)}T=qb- -64|0;return rb|0}bn();F()}function $f(a){a=a|0;var V=0,za=0;q[a>>2]=5560;V=q[a+76>>2];if(V){An(V)}za=a+68|0;V=q[za>>2];q[za>>2]=0;if(V){An(V)}q[a>>2]=3044;V=q[a+32>>2];if(V){q[a+36>>2]=V;An(V)}return a|0}function ag(a){a=a|0;var Aa=0,Fa=0;q[a>>2]=5560;Aa=q[a+76>>2];if(Aa){An(Aa)}Fa=a+68|0;Aa=q[Fa>>2];q[Fa>>2]=0;if(Aa){An(Aa)}q[a>>2]=3044;Aa=q[a+32>>2];if(Aa){q[a+36>>2]=Aa;An(Aa)}An(a)}function bg(a,mb,nb,Nb,Ob,Pb){a=a|0;mb=mb|0;nb=nb|0;Nb=Nb|0;Ob=Ob|0;Pb=Pb|0;var Qb=0,Rb=0,Sb=0,Tb=0,Ub=0,Vb=0,Wb=0,Xb=0,Yb=0,Zb=0,_b=0,$b=0;q[a+64>>2]=Pb;q[a+72>>2]=Ob;Pb=Mm((Ob&1073741823)!=(Ob|0)?-1:Ob<<2);Nb=q[a+68>>2];q[a+68>>2]=Pb;if(Nb){An(Nb)}q[a+8>>2]=Ob;Pb=a+32|0;Qb=q[Pb>>2];Nb=q[a+36>>2]-Qb>>2;a:{if(Nb>>>0<Ob>>>0){Fa(Pb,Ob-Nb|0);break a}if(Nb>>>0<=Ob>>>0){break a}q[a+36>>2]=Qb+(Ob<<2)}b:{Nb=q[a+56>>2];Qb=q[Nb+4>>2];Pb=q[Nb>>2];Nb=Qb-Pb|0;if((Nb|0)<1){break b}if((Pb|0)!=(Qb|0)){_b=Nb>>2;Ub=a+8|0;Wb=a+16|0;Xb=a+32|0;Yb=a+20|0;Zb=a+12|0;$b=a+56|0;while(1){cg(a,q[(Sb<<2)+Pb>>2],nb,Sb);c:{if(q[Ub>>2]<1){break c}Vb=q[a+68>>2];Pb=0;while(1){Nb=Pb<<2;Qb=q[Nb+Vb>>2];Rb=q[Wb>>2];d:{if((Qb|0)>(Rb|0)){Tb=q[Xb>>2];q[Nb+Tb>>2]=Rb;break d}Tb=q[Xb>>2];Nb=Nb+Tb|0;Rb=q[Zb>>2];if((Qb|0)<(Rb|0)){q[Nb>>2]=Rb;break d}q[Nb>>2]=Qb}Pb=Pb+1|0;Qb=q[Ub>>2];if((Pb|0)<(Qb|0)){continue}break}Nb=0;if((Qb|0)<1){break c}Pb=w(Ob,Sb)<<2;Vb=Pb+nb|0;Rb=mb+Pb|0;while(1){Qb=Nb<<2;Pb=Qb+Vb|0;Qb=q[Qb+Rb>>2]+q[Qb+Tb>>2]|0;q[Pb>>2]=Qb;e:{if((Qb|0)>q[Wb>>2]){Qb=Qb-q[Yb>>2]|0}else{if((Qb|0)>=q[Zb>>2]){break e}Qb=Qb+q[Yb>>2]|0}q[Pb>>2]=Qb}Nb=Nb+1|0;if((Nb|0)<q[Ub>>2]){continue}break}}Sb=Sb+1|0;if((Sb|0)>=(_b|0)){break b}Nb=q[$b>>2];Pb=q[Nb>>2];if(q[Nb+4>>2]-Pb>>2>>>0>Sb>>>0){continue}break}}cn();F()}return 1}function cg(a,mb,nb,Nb){var Ob=0,Pb=0,ac=0,bc=x(0),cc=0,dc=x(0),ec=x(0),fc=x(0),gc=x(0),hc=x(0),ic=x(0),jc=x(0),kc=0,lc=0,mc=x(0),nc=x(0),oc=x(0),pc=x(0),qc=x(0),rc=0,sc=x(0),tc=x(0),uc=x(0);Ob=T-48|0;T=Ob;Pb=-1;cc=-1;a:{if((mb|0)==-1){break a}ac=((mb>>>0)%3|0?-1:2)+mb|0;kc=q[a+48>>2];rc=mb+1|0;mb=(rc>>>0)%3|0?rc:mb+ -2|0;if((mb|0)!=-1){Pb=q[q[kc>>2]+(mb<<2)>>2]}if((ac|0)==-1){break a}cc=q[q[kc>>2]+(ac<<2)>>2]}ac=q[a+52>>2];mb=q[ac>>2];ac=q[ac+4>>2]-mb>>2;if(!(ac>>>0<=Pb>>>0|ac>>>0<=cc>>>0)){b:{c:{Pb=q[mb+(Pb<<2)>>2];kc=(Pb|0)>=(Nb|0);if(kc){break c}ac=q[mb+(cc<<2)>>2];if((ac|0)>=(Nb|0)){break c}mb=q[a+72>>2];cc=(w(mb,ac)<<2)+nb|0;dc=x(q[cc+4>>2]);mb=(w(mb,Pb)<<2)+nb|0;jc=x(q[mb+4>>2]);mc=x(q[cc>>2]);pc=x(q[mb>>2]);if(!(mc!=pc|dc!=jc)){a=q[a+68>>2];mb=a;if(x(y(dc))<x(2147483648)){nb=~~dc}else{nb=-2147483648}q[mb+4>>2]=nb;if(x(y(mc))<x(2147483648)){q[a>>2]=~~mc;break b}q[a>>2]=-2147483648;break b}cc=q[q[a+64>>2]+(Nb<<2)>>2];q[Ob+40>>2]=0;q[Ob+32>>2]=0;q[Ob+36>>2]=0;mb=q[a+60>>2];if(!r[mb+84|0]){cc=q[q[mb+68>>2]+(cc<<2)>>2]}Da(mb,cc,o[mb+24|0],Ob+32|0);Pb=q[q[a+64>>2]+(Pb<<2)>>2];q[Ob+24>>2]=0;q[Ob+16>>2]=0;q[Ob+20>>2]=0;mb=q[a+60>>2];if(!r[mb+84|0]){Pb=q[q[mb+68>>2]+(Pb<<2)>>2]}Da(mb,Pb,o[mb+24|0],Ob+16|0);nb=q[q[a+64>>2]+(ac<<2)>>2];q[Ob+8>>2]=0;q[Ob>>2]=0;q[Ob+4>>2]=0;mb=q[a+60>>2];if(!r[mb+84|0]){nb=q[q[mb+68>>2]+(nb<<2)>>2]}Da(mb,nb,o[mb+24|0],Ob);nc=u[Ob+40>>2];oc=u[Ob+36>>2];fc=u[Ob+32>>2];sc=u[Ob+16>>2];ec=x(u[Ob>>2]-sc);tc=u[Ob+20>>2];gc=x(u[Ob+4>>2]-tc);uc=u[Ob+24>>2];hc=x(u[Ob+8>>2]-uc);qc=x(x(x(x(ec*ec)+x(0))+x(gc*gc))+x(hc*hc));d:{if(!(qc>x(0))){ic=x(0);if(q[a+88>>2]>257){break d}}fc=x(fc-sc);oc=x(oc-tc);nc=x(nc-uc);bc=x(x(x(x(x(ec*fc)+x(0))+x(gc*oc))+x(hc*nc))/qc);hc=x(nc-x(hc*bc));gc=x(oc-x(gc*bc));ec=x(fc-x(ec*bc));ic=x(E(x(x(x(hc*hc)+x(x(gc*gc)+x(x(ec*ec)+x(0))))/qc)))}fc=ic;nb=a+80|0;mb=q[nb>>2]+ -1|0;Nb=q[q[a+76>>2]+(mb>>>3&536870908)>>2];q[nb>>2]=mb;ec=x(dc-jc);ic=x(x(ec*bc)+jc);jc=x(mc-pc);dc=x(jc*fc);mb=Nb>>>(mb&31)&1;dc=x(ic+(mb?dc:x(-dc)));ic=x(x(jc*bc)+pc);bc=x(ec*fc);bc=x(ic+(mb?x(-bc):bc));e:{if(((k(bc),e(0))&2147483647)>>>0>=2139095041){mb=q[a+68>>2];q[mb>>2]=-2147483648;break e}mb=q[a+68>>2];a=mb;lc=C(+bc+.5);f:{if(y(lc)<2147483648){nb=~~lc;break f}nb=-2147483648}q[a>>2]=nb}nb=((k(dc),e(0))&2147483647)>>>0>2139095040;lc=C(+dc+.5);g:{if(y(lc)<2147483648){a=~~lc;break g}a=-2147483648}q[mb+4>>2]=nb?-2147483648:a;break b}h:{if(!kc){mb=q[a+72>>2];Nb=w(Pb,mb);break h}if((Nb|0)<=0){if(q[a+72>>2]<1){break b}nb=q[a+68>>2];mb=0;while(1){q[nb+(mb<<2)>>2]=0;mb=mb+1|0;if((mb|0)<q[a+72>>2]){continue}break}break b}mb=q[a+72>>2];Nb=w(mb,Nb+ -1|0)}if((mb|0)<1){break b}Pb=q[a+68>>2];mb=0;while(1){q[Pb+(mb<<2)>>2]=q[(mb+Nb<<2)+nb>>2];mb=mb+1|0;if((mb|0)<q[a+72>>2]){continue}break}}T=Ob+48|0;return}cn();F()}function dg(a){a=a|0;var mb=0;q[a>>2]=5776;mb=q[a+76>>2];if(mb){An(mb)}q[a>>2]=3044;mb=q[a+32>>2];if(mb){q[a+36>>2]=mb;An(mb)}return a|0}function eg(a){a=a|0;var nb=0;q[a>>2]=5776;nb=q[a+76>>2];if(nb){An(nb)}q[a>>2]=3044;nb=q[a+32>>2];if(nb){q[a+36>>2]=nb;An(nb)}An(a)}function fg(a,Nb,vc,wc,xc,yc){a=a|0;Nb=Nb|0;vc=vc|0;wc=wc|0;xc=xc|0;yc=yc|0;var zc=0,Ac=0,Bc=0,Cc=0,Dc=0,Ec=0,Fc=0,Gc=0,Hc=0,Ic=0,Jc=0,Kc=0;wc=0;a:{if((xc|0)!=2){break a}q[a+8>>2]=2;q[a- -64>>2]=yc;wc=a+32|0;xc=q[wc>>2];yc=q[a+36>>2]-xc|0;zc=yc>>2;b:{if(zc>>>0<=1){Fa(wc,2-zc|0);break b}if((yc|0)==8){break b}q[a+36>>2]=xc+8}wc=1;xc=q[a+56>>2];yc=q[xc+4>>2];xc=q[xc>>2];zc=yc-xc|0;if((zc|0)<1){break a}if((xc|0)!=(yc|0)){Hc=a+60|0;Ic=zc>>2;zc=a+8|0;Dc=a+16|0;Ec=a+32|0;Fc=a+20|0;Gc=a+12|0;Jc=a+56|0;while(1){if(!gg(Hc,q[(Bc<<2)+xc>>2],vc,Bc)){wc=0;break a}c:{if(q[zc>>2]<1){break c}xc=0;while(1){wc=xc<<2;yc=q[(wc+a|0)+68>>2];Ac=q[Dc>>2];d:{if((yc|0)>(Ac|0)){Cc=q[Ec>>2];q[wc+Cc>>2]=Ac;break d}Cc=q[Ec>>2];wc=wc+Cc|0;Ac=q[Gc>>2];if((yc|0)<(Ac|0)){q[wc>>2]=Ac;break d}q[wc>>2]=yc}xc=xc+1|0;wc=q[zc>>2];if((xc|0)<(wc|0)){continue}break}yc=0;if((wc|0)<1){break c}wc=Bc<<3;Ac=wc+vc|0;Kc=Nb+wc|0;while(1){xc=yc<<2;wc=xc+Ac|0;xc=q[xc+Kc>>2]+q[xc+Cc>>2]|0;q[wc>>2]=xc;e:{if((xc|0)>q[Dc>>2]){xc=xc-q[Fc>>2]|0}else{if((xc|0)>=q[Gc>>2]){break e}xc=xc+q[Fc>>2]|0}q[wc>>2]=xc}yc=yc+1|0;if((yc|0)<q[zc>>2]){continue}break}}wc=1;Bc=Bc+1|0;if((Bc|0)>=(Ic|0)){break a}wc=q[Jc>>2];xc=q[wc>>2];if(q[wc+4>>2]-xc>>2>>>0>Bc>>>0){continue}break}}cn();F()}return wc|0}function gg(a,Nb,vc,wc){var xc=0,yc=0,Lc=0,Mc=0,Nc=0,Oc=0,Pc=0,Qc=0,Rc=0,Sc=0,Tc=0,Uc=0,Vc=0,Wc=0,Xc=0,Yc=0,Zc=0,_c=0,$c=0,ad=0,bd=0,cd=0,dd=0,ed=0,fd=0;Lc=T-80|0;T=Lc;xc=-1;yc=-1;a:{if((Nb|0)==-1){break a}Mc=((Nb>>>0)%3|0?-1:2)+Nb|0;Nc=q[a+32>>2];Pc=Nb+1|0;Nb=(Pc>>>0)%3|0?Pc:Nb+ -2|0;if((Nb|0)!=-1){xc=q[q[Nc>>2]+(Nb<<2)>>2]}if((Mc|0)==-1){break a}yc=q[q[Nc>>2]+(Mc<<2)>>2]}Mc=q[a+36>>2];Nb=q[Mc>>2];b:{c:{d:{e:{Mc=q[Mc+4>>2]-Nb>>2;if(!(Mc>>>0<=xc>>>0|Mc>>>0<=yc>>>0)){f:{g:{Sc=q[Nb+(xc<<2)>>2];Uc=(Sc|0)>=(wc|0);if(Uc){break g}yc=q[Nb+(yc<<2)>>2];if((yc|0)>=(wc|0)){break g}Nb=yc<<3;Zc=q[(Nb|4)+vc>>2];xc=Sc<<3;Pc=q[(xc|4)+vc>>2];Wc=q[Nb+vc>>2];Yc=q[vc+xc>>2];if(!((Wc|0)!=(Yc|0)|(Pc|0)!=(Zc|0))){q[a+8>>2]=Yc;q[a+12>>2]=Pc;break f}Nb=q[q[a+4>>2]+(wc<<2)>>2];q[Lc+72>>2]=0;q[Lc+76>>2]=0;xc=Lc- -64|0;q[xc>>2]=0;q[xc+4>>2]=0;q[Lc+56>>2]=0;q[Lc+60>>2]=0;xc=q[a>>2];if(!r[xc+84|0]){Nb=q[q[xc+68>>2]+(Nb<<2)>>2]}Kf(xc,Nb,o[xc+24|0],Lc+56|0);Nb=q[q[a+4>>2]+(Sc<<2)>>2];q[Lc+48>>2]=0;q[Lc+52>>2]=0;q[Lc+40>>2]=0;q[Lc+44>>2]=0;q[Lc+32>>2]=0;q[Lc+36>>2]=0;xc=q[a>>2];if(!r[xc+84|0]){Nb=q[q[xc+68>>2]+(Nb<<2)>>2]}Kf(xc,Nb,o[xc+24|0],Lc+32|0);Nb=q[q[a+4>>2]+(yc<<2)>>2];q[Lc+24>>2]=0;q[Lc+28>>2]=0;q[Lc+16>>2]=0;q[Lc+20>>2]=0;q[Lc+8>>2]=0;q[Lc+12>>2]=0;xc=q[a>>2];if(!r[xc+84|0]){Nb=q[q[xc+68>>2]+(Nb<<2)>>2]}Kf(xc,Nb,o[xc+24|0],Lc+8|0);_c=q[Lc+44>>2];Nb=q[Lc+16>>2];Oc=q[Lc+40>>2];xc=Oc;yc=q[Lc+20>>2]-(_c+(Nb>>>0<xc>>>0)|0)|0;ad=Nb-xc|0;Nb=$n(ad,yc,ad,yc);xc=V;Rc=Nb;$c=q[Lc+36>>2];Nb=q[Lc+8>>2];Qc=q[Lc+32>>2];Nc=Qc;Mc=q[Lc+12>>2]-($c+(Nb>>>0<Nc>>>0)|0)|0;bd=Nb-Nc|0;Nc=$n(bd,Mc,bd,Mc);Nb=Rc+Nc|0;xc=V+xc|0;xc=Nb>>>0<Nc>>>0?xc+1|0:xc;Vc=Nb;dd=q[Lc+52>>2];Nb=q[Lc+24>>2];Rc=q[Lc+48>>2];Nc=Rc;Tc=q[Lc+28>>2]-(dd+(Nb>>>0<Nc>>>0)|0)|0;cd=Nb-Nc|0;Nc=$n(cd,Tc,cd,Tc);Nb=Vc+Nc|0;xc=V+xc|0;Xc=Nb;Nc=Nb>>>0<Nc>>>0?xc+1|0:xc;if(!(Nb|Nc)){break g}wc=1;Nb=0;xc=q[Lc+64>>2];vc=q[Lc+68>>2]-((xc>>>0<Oc>>>0)+_c|0)|0;xc=xc-Oc|0;Sc=xc;Uc=vc;vc=$n(ad,yc,xc,vc);xc=V;Vc=vc;Oc=q[Lc+56>>2];vc=Oc-Qc|0;_c=q[Lc+60>>2]-((Oc>>>0<Qc>>>0)+$c|0)|0;Qc=$n(vc,_c,bd,Mc);Oc=Vc+Qc|0;xc=V+xc|0;xc=Oc>>>0<Qc>>>0?xc+1|0:xc;Vc=Oc;Oc=q[Lc+72>>2];Qc=Oc-Rc|0;$c=q[Lc+76>>2]-((Oc>>>0<Rc>>>0)+dd|0)|0;Rc=$n(Qc,$c,cd,Tc);Oc=Vc+Rc|0;xc=V+xc|0;xc=Oc>>>0<Rc>>>0?xc+1|0:xc;Rc=Oc;Oc=xc;yc=ao($n(Rc,xc,ad,yc),V,Xc,Nc);Uc=Uc-(V+(Sc>>>0<yc>>>0)|0)|0;yc=Sc-yc|0;yc=$n(yc,Uc,yc,Uc);Sc=V;Vc=yc;xc=ao($n(bd,Mc,Rc,xc),V,Xc,Nc);yc=_c-(V+(vc>>>0<xc>>>0)|0)|0;vc=vc-xc|0;yc=$n(vc,yc,vc,yc);vc=Vc+yc|0;xc=V+Sc|0;xc=vc>>>0<yc>>>0?xc+1|0:xc;Mc=vc;vc=ao($n(Rc,Oc,cd,Tc),V,Xc,Nc);yc=$c-(V+(Qc>>>0<vc>>>0)|0)|0;vc=Qc-vc|0;yc=$n(vc,yc,vc,yc);vc=Mc+yc|0;xc=V+xc|0;yc=$n(vc,vc>>>0<yc>>>0?xc+1|0:xc,Xc,Nc);vc=V;Mc=vc;if(!vc&yc>>>0<=1|vc>>>0<0){break e}Tc=yc;vc=Mc;while(1){xc=Nb<<1|wc>>>31;wc=wc<<1;Nb=xc;Qc=!vc&Tc>>>0>7|vc>>>0>0;Tc=(vc&3)<<30|Tc>>>2;vc=vc>>>2;if(Qc){continue}break}break d}xc=a;if(Uc){if((wc|0)<=0){q[a+8>>2]=0;q[a+12>>2]=0;break f}Nb=(wc<<1)+ -2|0}else{Nb=Sc<<1}Nb=(Nb<<2)+vc|0;q[xc+8>>2]=q[Nb>>2];q[a+12>>2]=q[Nb+4>>2]}vc=1;break b}cn();F()}wc=yc;Nb=Mc;if(yc-1){break c}}while(1){vc=bo(yc,Mc,wc,Nb)+wc|0;xc=Nb+V|0;xc=vc>>>0<wc>>>0?xc+1|0:xc;wc=(xc&1)<<31|vc>>>1;Nb=xc>>>1;vc=$n(wc,Nb,wc,Nb);xc=V;if((Mc|0)==(xc|0)&vc>>>0>yc>>>0|xc>>>0>Mc>>>0){continue}break}}xc=q[a+20>>2];vc=0;if(!xc){break b}Mc=xc+ -1|0;Tc=q[q[a+16>>2]+(Mc>>>3&536870908)>>2];q[a+20>>2]=Mc;vc=Zc;xc=Pc;Qc=vc-xc|0;Pc=xc>>31;Zc=(vc>>31)-(Pc+(vc>>>0<xc>>>0)|0)|0;vc=$n(Rc,Oc,Qc,Zc);yc=V;Pc=$n(xc,Pc,Xc,Nc);vc=Pc+vc|0;xc=V+yc|0;xc=vc>>>0<Pc>>>0?xc+1|0:xc;Vc=vc;vc=Wc;yc=Yc;Sc=vc-yc|0;Yc=yc>>31;Pc=(vc>>31)-(Yc+(vc>>>0<yc>>>0)|0)|0;vc=$n(wc,Nb,Sc,Pc);Wc=vc;vc=Tc>>>(Mc&31)&1;Uc=vc?0-Wc|0:Wc;Mc=Vc+Uc|0;Tc=xc;xc=V;xc=Tc+(vc?0-(xc+(0<Wc>>>0)|0)|0:xc)|0;ed=a,fd=ao(Mc,Mc>>>0<Uc>>>0?xc+1|0:xc,Xc,Nc),q[ed+12>>2]=fd;xc=$n(Rc,Oc,Sc,Pc);Mc=V;Wc=a;yc=$n(yc,Yc,Xc,Nc);a=yc+xc|0;xc=V+Mc|0;xc=a>>>0<yc>>>0?xc+1|0:xc;Oc=a;a=$n(wc,Nb,Qc,Zc);wc=vc?a:0-a|0;Nb=Oc+wc|0;Oc=xc;xc=V;a=Oc+(vc?xc:0-((0<a>>>0)+xc|0)|0)|0;ed=Wc,fd=ao(Nb,Nb>>>0<wc>>>0?a+1|0:a,Xc,Nc),q[ed+8>>2]=fd;vc=1}T=Lc+80|0;return vc}function hg(a){a=a|0;var Nb=0;q[a>>2]=6e3;q[a>>2]=3044;Nb=q[a+32>>2];if(Nb){q[a+36>>2]=Nb;An(Nb)}return a|0}function ig(a){a=a|0;var vc=0;q[a>>2]=6e3;q[a>>2]=3044;vc=q[a+32>>2];if(vc){q[a+36>>2]=vc;An(vc)}An(a)}function jg(a,wc,gd,hd,id,jd){a=a|0;wc=wc|0;gd=gd|0;hd=hd|0;id=id|0;jd=jd|0;var kd=0,ld=0,md=0,nd=0,od=0,pd=0,qd=0,rd=0,sd=0,td=0,ud=0,vd=0,wd=0,xd=0,yd=0;ld=T-32|0;T=ld;q[a+68>>2]=jd;hd=q[a+56>>2];id=q[hd>>2];jd=hd+4|0;kd=q[jd>>2];q[ld+24>>2]=0;q[ld+16>>2]=0;q[ld+20>>2]=0;a:{id=kd-id|0;if((id|0)<1){break a}hd=q[hd>>2];if((hd|0)!=q[jd>>2]){vd=id>>2;wd=a+60|0;xd=a+108|0;qd=a+8|0;rd=a+16|0;sd=a+32|0;td=a+20|0;ud=a+12|0;yd=a+56|0;while(1){kg(wd,q[(od<<2)+hd>>2],ld+16|0);id=q[ld+20>>2];kd=id>>31;jd=q[ld+16>>2];md=jd>>31;pd=q[ld+24>>2];nd=pd>>31;hd=0;nd=nd^nd+pd;kd=nd+((kd^id+kd)+(md^jd+md)|0)|0;if(kd>>>0<nd>>>0){hd=1}b:{if(!(hd|kd)){q[ld+16>>2]=q[a+104>>2];break b}md=q[a+104>>2];nd=md>>31;id=ao($n(md,nd,id,id>>31),V,kd,hd);q[ld+20>>2]=id;hd=ao($n(md,nd,jd,jd>>31),V,kd,hd);q[ld+16>>2]=hd;jd=hd;hd=hd>>31;hd=(md-(jd+hd^hd)|0)+((id|0)<0?id:0-id|0)|0;if((pd|0)>=0){q[ld+24>>2]=hd;break b}q[ld+24>>2]=0-hd}hd=dh(xd);jd=q[ld+16>>2];c:{if(!hd){id=q[ld+20>>2];break c}q[ld+24>>2]=0-q[ld+24>>2];id=0-q[ld+20>>2]|0;q[ld+20>>2]=id;jd=0-jd|0;q[ld+16>>2]=jd}d:{if((jd|0)>=0){hd=q[a+104>>2];jd=hd+q[ld+24>>2]|0;hd=hd+id|0;break d}e:{if((id|0)<=-1){jd=q[ld+24>>2];hd=jd>>31;hd=hd^hd+jd;break e}jd=q[ld+24>>2];hd=jd>>31;hd=q[a+100>>2]-(hd^hd+jd)|0}if((jd|0)<=-1){jd=id;id=id>>31;jd=jd+id^id;break d}jd=id;id=id>>31;jd=q[a+100>>2]-(jd+id^id)|0}id=q[a+100>>2];f:{if(!(hd|jd)){jd=id;hd=id;break f}if(!((id|0)!=(jd|0)|hd)){hd=jd;break f}if(!((hd|0)!=(id|0)|jd)){jd=hd;break f}g:{if(hd){break g}kd=q[a+104>>2];if((kd|0)>=(jd|0)){break g}jd=(kd<<1)-jd|0;hd=0;break f}h:{if((hd|0)!=(id|0)){break h}kd=q[a+104>>2];if((kd|0)<=(jd|0)){break h}jd=(kd<<1)-jd|0;break f}i:{if((id|0)!=(jd|0)){break i}id=q[a+104>>2];if((id|0)<=(hd|0)){break i}hd=(id<<1)-hd|0;break f}if(jd){break f}jd=0;id=q[a+104>>2];if((id|0)>=(hd|0)){break f}hd=(id<<1)-hd|0}q[ld+12>>2]=jd;q[ld+8>>2]=hd;j:{if(q[qd>>2]<1){break j}jd=0;while(1){kd=q[rd>>2];k:{if((hd|0)>(kd|0)){id=q[sd>>2];q[id+(jd<<2)>>2]=kd;break k}id=q[sd>>2];kd=id+(jd<<2)|0;md=q[ud>>2];if((hd|0)<(md|0)){q[kd>>2]=md;break k}q[kd>>2]=hd}jd=jd+1|0;kd=q[qd>>2];if((jd|0)<(kd|0)){hd=q[(ld+8|0)+(jd<<2)>>2];continue}break}hd=0;if((kd|0)<1){break j}jd=od<<3;md=jd+gd|0;pd=wc+jd|0;while(1){kd=hd<<2;jd=kd+md|0;kd=q[kd+pd>>2]+q[id+kd>>2]|0;q[jd>>2]=kd;l:{if((kd|0)>q[rd>>2]){nd=kd-q[td>>2]|0}else{if((kd|0)>=q[ud>>2]){break l}nd=kd+q[td>>2]|0}q[jd>>2]=nd}hd=hd+1|0;if((hd|0)<q[qd>>2]){continue}break}}od=od+1|0;if((od|0)>=(vd|0)){break a}id=q[yd>>2];hd=q[id>>2];if(q[id+4>>2]-hd>>2>>>0>od>>>0){continue}break}}cn();F()}T=ld+32|0;return 1}function kg(a,wc,gd){a=a|0;wc=wc|0;gd=gd|0;var hd=0,id=0,jd=0,zd=0,Ad=0,Bd=0,Cd=0,Dd=0,Ed=0,Fd=0,Gd=0,Hd=0,Id=0,Jd=0,Kd=0,Ld=0,Md=0,Nd=0,Od=0,Pd=0,Qd=0,Rd=0,Sd=0,Td=0,Ud=0,Vd=0;jd=T-96|0;T=jd;id=q[a+16>>2];o[jd+92|0]=1;q[jd+88>>2]=wc;q[jd+84>>2]=wc;q[jd+80>>2]=id;hd=-1;hd=(wc|0)!=-1?q[q[id>>2]+(wc<<2)>>2]:hd;zd=q[a+20>>2];id=q[zd>>2];a:{b:{c:{d:{if(q[zd+4>>2]-id>>2>>>0>hd>>>0){id=q[q[a+8>>2]+(q[id+(hd<<2)>>2]<<2)>>2];hd=q[a+4>>2];if(!r[hd+84|0]){id=q[q[hd+68>>2]+(id<<2)>>2]}q[jd+72>>2]=0;q[jd+76>>2]=0;zd=jd- -64|0;q[zd>>2]=0;q[zd+4>>2]=0;q[jd+56>>2]=0;q[jd+60>>2]=0;Kf(hd,id,o[hd+24|0],jd+56|0);if((wc|0)==-1){break a}hd=wc+1|0;zd=(hd>>>0)%3|0?hd:wc+ -2|0;Jd=((wc>>>0)%3|0?-1:2)+wc|0;Qd=a+28|0;Ad=!q[Qd>>2];Rd=a+20|0;Sd=a+8|0;Td=jd+48|0;while(1){id=zd;hd=Jd;e:{if(Ad){break e}hd=wc+1|0;id=(hd>>>0)%3|0?hd:wc+ -2|0;hd=wc+ -1|0;if((wc>>>0)%3){break e}hd=wc+2|0}wc=-1;wc=(id|0)!=-1?q[q[q[a+16>>2]>>2]+(id<<2)>>2]:wc;Ad=q[Rd>>2];id=q[Ad>>2];if(q[Ad+4>>2]-id>>2>>>0<=wc>>>0){break d}id=q[q[Sd>>2]+(q[id+(wc<<2)>>2]<<2)>>2];Ad=a+4|0;wc=q[Ad>>2];if(!r[wc+84|0]){id=q[q[wc+68>>2]+(id<<2)>>2]}q[Td>>2]=0;q[Td+4>>2]=0;q[jd+40>>2]=0;q[jd+44>>2]=0;q[jd+32>>2]=0;q[jd+36>>2]=0;Kf(wc,id,o[wc+24|0],jd+32|0);wc=-1;wc=(hd|0)!=-1?q[q[q[a+16>>2]>>2]+(hd<<2)>>2]:wc;id=q[Rd>>2];hd=q[id>>2];if(q[id+4>>2]-hd>>2>>>0<=wc>>>0){break c}hd=q[q[Sd>>2]+(q[hd+(wc<<2)>>2]<<2)>>2];wc=q[Ad>>2];if(!r[wc+84|0]){hd=q[q[wc+68>>2]+(hd<<2)>>2]}id=jd+24|0;q[id>>2]=0;q[id+4>>2]=0;Ad=jd+16|0;q[Ad>>2]=0;q[Ad+4>>2]=0;q[jd+8>>2]=0;q[jd+12>>2]=0;Kf(wc,hd,o[wc+24|0],jd+8|0);hd=q[jd+8>>2];wc=q[jd+56>>2];Kd=hd-wc|0;Ld=q[jd+60>>2];Dd=q[jd+12>>2]-(Ld+(hd>>>0<wc>>>0)|0)|0;Md=q[jd+40>>2];hd=q[jd+64>>2];Ud=Md-hd|0;Nd=q[jd+68>>2];Md=q[jd+44>>2]-(Nd+(Md>>>0<hd>>>0)|0)|0;Od=$n(Kd,Dd,Ud,Md);Pd=Bd-Od|0;Ed=Ed-(V+(Bd>>>0<Od>>>0)|0)|0;Bd=q[Ad>>2];Od=Bd-hd|0;Ad=q[Ad+4>>2]-((Bd>>>0<hd>>>0)+Nd|0)|0;Bd=q[jd+32>>2];Nd=Bd-wc|0;Ld=q[jd+36>>2]-((Bd>>>0<wc>>>0)+Ld|0)|0;hd=$n(Od,Ad,Nd,Ld);Bd=hd+Pd|0;wc=V+Ed|0;wc=Bd>>>0<hd>>>0?wc+1|0:wc;Ed=wc;hd=Cd;Gd=Kd;Vd=Dd;Cd=q[jd+48>>2];wc=q[jd+72>>2];Dd=Cd-wc|0;Kd=q[jd+76>>2];Pd=q[jd+52>>2]-(Kd+(Cd>>>0<wc>>>0)|0)|0;Gd=$n(Gd,Vd,Dd,Pd);Cd=hd+Gd|0;hd=V+Hd|0;hd=Cd>>>0<Gd>>>0?hd+1|0:hd;Hd=Cd;Cd=q[id>>2];Gd=Cd-wc|0;wc=q[id+4>>2]-((Cd>>>0<wc>>>0)+Kd|0)|0;id=$n(Gd,wc,Nd,Ld);Cd=Hd-id|0;Hd=hd-(V+(Hd>>>0<id>>>0)|0)|0;hd=$n(Od,Ad,Dd,Pd);id=Fd-hd|0;Id=Id-(V+(Fd>>>0<hd>>>0)|0)|0;hd=$n(Gd,wc,Ud,Md);Fd=hd+id|0;wc=V+Id|0;wc=Fd>>>0<hd>>>0?wc+1|0:wc;Id=wc;lg(jd+80|0);Dd=q[Qd>>2];Ad=!Dd;wc=q[jd+88>>2];if((wc|0)!=-1){continue}break}wc=Hd;hd=wc>>31;a=wc>>31;wc=a+wc|0;zd=hd+Cd|0;if(zd>>>0<hd>>>0){wc=wc+1|0}hd=hd^zd;Ad=a^wc;wc=Id;a=wc>>31;wc=wc>>31;zd=a;Jd=Id+a|0;id=wc+Fd|0;if(id>>>0<wc>>>0){Jd=Jd+1|0}a=wc^id;id=zd^Jd;f:{if((Ed|0)<-1?1:(Ed|0)<=-1?Bd>>>0>4294967295?0:1:0){wc=Bd;zd=a+(hd-wc|0)|0;wc=id+(Ad-((hd>>>0<wc>>>0)+Ed|0)|0)|0;hd=zd;a=hd>>>0<a>>>0?wc+1|0:wc;if(!Dd){break f}break b}wc=Ad+Ed|0;zd=hd;hd=Bd;zd=zd+hd|0;if(zd>>>0<hd>>>0){wc=wc+1|0}hd=a;zd=hd+zd|0;a=wc+id|0;a=zd>>>0<hd>>>0?a+1|0:a;hd=zd;if(Dd){break b}}if((hd|0)<536870913){break a}a=((a&536870911)<<3|hd>>>29)&7;wc=0;Bd=ao(Bd,Ed,a,wc);Cd=ao(Cd,Hd,a,wc);Fd=ao(Fd,Id,a,wc);break a}cn();F()}cn();F()}cn();F()}if((a|0)<0?1:(a|0)<=0?hd>>>0>=536870913?0:1:0){break a}wc=a>>>29;a=(a&536870911)<<3|hd>>>29;Bd=ao(Bd,Ed,a,wc);Cd=ao(Cd,Hd,a,wc);Fd=ao(Fd,Id,a,wc)}q[gd+8>>2]=Bd;q[gd+4>>2]=Cd;q[gd>>2]=Fd;T=jd+96|0}function lg(a){var wc=0,gd=0,Wd=0;wc=q[a+8>>2];Wd=q[a>>2];a:{if(r[a+12|0]){b:{c:{d:{e:{if((wc|0)==-1){break e}gd=wc+1|0;wc=(gd>>>0)%3|0?gd:wc+ -2|0;if((wc|0)==-1){break e}wc=q[q[Wd+12>>2]+(wc<<2)>>2];if((wc|0)!=-1){break d}}q[a+8>>2]=-1;break c}gd=wc+1|0;wc=(gd>>>0)%3|0?gd:wc+ -2|0;q[a+8>>2]=wc;if((wc|0)!=-1){break b}}gd=q[a+4>>2];wc=-1;f:{if((gd|0)==-1){break f}gd=gd+((gd>>>0)%3|0?-1:2)|0;wc=-1;if((gd|0)==-1){break f}gd=q[q[Wd+12>>2]+(gd<<2)>>2];wc=-1;if((gd|0)==-1){break f}wc=gd+ -1|0;if((gd>>>0)%3){break f}wc=gd+2|0}o[a+12|0]=0;q[a+8>>2]=wc;return}if((wc|0)!=q[a+4>>2]){break a}q[a+8>>2]=-1;return}gd=-1;g:{if((wc|0)==-1){break g}wc=wc+((wc>>>0)%3|0?-1:2)|0;gd=-1;if((wc|0)==-1){break g}wc=q[q[Wd+12>>2]+(wc<<2)>>2];gd=-1;if((wc|0)==-1){break g}gd=wc+ -1|0;if((wc>>>0)%3){break g}gd=wc+2|0}q[a+8>>2]=gd}}function mg(a,Xd,Yd,Zd,_d,$d){a=a|0;Xd=Xd|0;Yd=Yd|0;Zd=Zd|0;_d=_d|0;$d=$d|0;var ae=0,be=0,ce=0,de=0,ee=0,fe=0,ge=0,he=0,ie=0,je=0,ke=0,le=0,me=0,ne=0;q[a+8>>2]=_d;be=a+32|0;ae=q[be>>2];$d=q[a+36>>2]-ae>>2;a:{if($d>>>0<_d>>>0){Fa(be,_d-$d|0);break a}if($d>>>0<=_d>>>0){break a}q[a+36>>2]=ae+(_d<<2)}be=0;$d=(_d&1073741823)!=(_d|0)?-1:_d<<2;ke=Dn(Mm($d),0,$d);ee=a+8|0;ae=q[ee>>2];b:{if((ae|0)<1){break b}ge=a+16|0;$d=a+32|0;he=a+12|0;while(1){ae=be<<2;de=q[ae+ke>>2];ce=q[ge>>2];c:{if((de|0)>(ce|0)){fe=q[$d>>2];q[ae+fe>>2]=ce;break c}fe=q[$d>>2];ae=ae+fe|0;ce=q[he>>2];if((de|0)<(ce|0)){q[ae>>2]=ce;break c}q[ae>>2]=de}be=be+1|0;ae=q[ee>>2];if((be|0)<(ae|0)){continue}break}if((ae|0)<1){break b}be=0;ee=a+16|0;de=a+20|0;ge=a+8|0;he=a+12|0;while(1){ae=be<<2;$d=ae+Yd|0;ae=q[Xd+ae>>2]+q[ae+fe>>2]|0;q[$d>>2]=ae;d:{if((ae|0)>q[ee>>2]){ae=ae-q[de>>2]|0}else{if((ae|0)>=q[he>>2]){break d}ae=ae+q[de>>2]|0}q[$d>>2]=ae}be=be+1|0;ae=q[ge>>2];if((be|0)<(ae|0)){continue}break}}if((_d|0)<(Zd|0)){me=0-_d<<2;de=a+16|0;fe=a+32|0;ee=a+8|0;ge=a+20|0;he=a+12|0;$d=_d;while(1){e:{if((ae|0)<1){break e}je=$d<<2;le=je+Yd|0;ne=le+me|0;be=0;while(1){a=be<<2;ae=q[a+ne>>2];ie=q[de>>2];f:{if((ae|0)>(ie|0)){ce=q[fe>>2];q[a+ce>>2]=ie;break f}ce=q[fe>>2];a=a+ce|0;ie=q[he>>2];if((ae|0)<(ie|0)){q[a>>2]=ie;break f}q[a>>2]=ae}be=be+1|0;ae=q[ee>>2];if((be|0)<(ae|0)){continue}break}be=0;if((ae|0)<1){break e}je=Xd+je|0;while(1){ae=be<<2;a=ae+le|0;ae=q[ae+je>>2]+q[ae+ce>>2]|0;q[a>>2]=ae;g:{if((ae|0)>q[de>>2]){ae=ae-q[ge>>2]|0}else{if((ae|0)>=q[he>>2]){break g}ae=ae+q[ge>>2]|0}q[a>>2]=ae}be=be+1|0;ae=q[ee>>2];if((be|0)<(ae|0)){continue}break}}$d=_d+$d|0;if(($d|0)<(Zd|0)){continue}break}}An(ke);return 1}function ng(a,Xd,Yd){a=a|0;Xd=Xd|0;Yd=Yd|0;var Zd=0;a:{if(!Se(a,Xd,Yd)){break a}a=q[a+8>>2];if(r[a+24|0]!=3){break a}Zd=q[a+28>>2]==9}return Zd|0}function og(a,Xd,Yd){a=a|0;Xd=Xd|0;Yd=Yd|0;var _d=0,$d=0,oe=0,pe=0,qe=0;a:{if(r[q[a+4>>2]+36|0]<=1){_d=q[Yd+16>>2];$d=q[Yd+12>>2];oe=q[Yd+20>>2];qe=oe;pe=0;if(($d|0)<(qe|0)?1:($d|0)<=(qe|0)?t[Yd+8>>2]>_d>>>0?0:1:0){break a}$d=r[_d+q[Yd>>2]|0];_d=_d+1|0;if(_d>>>0<1){oe=oe+1|0}q[Yd+16>>2]=_d;q[Yd+20>>2]=oe;q[a+24>>2]=$d}pe=Xe(a,Xd,Yd)}return pe|0}function pg(a,Xd,Yd){a=a|0;Xd=Xd|0;Yd=Yd|0;var re=0,se=0,te=0,ue=0,ve=0;re=T-16|0;T=re;a:{b:{if(r[q[a+4>>2]+36|0]<=1){Xd=q[a+24>>2];break b}ue=q[Yd+16>>2];se=q[Yd+12>>2];te=q[Yd+20>>2];Xd=te;ve=0;if((se|0)<(Xd|0)?1:(se|0)<=(Xd|0)?t[Yd+8>>2]>ue>>>0?0:1:0){break a}Xd=r[ue+q[Yd>>2]|0];se=ue+1|0;if(se>>>0<1){te=te+1|0}q[Yd+16>>2]=se;q[Yd+20>>2]=te;q[a+24>>2]=Xd}q[re+12>>2]=-1;q[re+8>>2]=1116;q[(re+8|0)+4>>2]=Xd;ve=ld(re+8|0,q[a+16>>2])}a=ve;T=re+16|0;return a|0}function qg(a,Xd){a=a|0;Xd=Xd|0;var Yd=0,we=0,xe=0,ye=0,ze=0,Ae=x(0),Be=0,Ce=0;we=T-32|0;T=we;ye=o[q[a+8>>2]+24|0];Yd=q[a+16>>2];if(q[Yd+80>>2]){ze=q[q[Yd>>2]>>2]+q[Yd+48>>2]|0}q[we+8>>2]=-1;q[we+12>>2]=-1;q[we>>2]=-1;q[we+4>>2]=-1;a:{Yd=q[a+24>>2];if(Yd+ -2>>>0>28){break a}q[we>>2]=Yd;Yd=-1<<Yd;xe=-2-Yd|0;q[we+8>>2]=xe;q[we+4>>2]=Yd^-1;q[we+12>>2]=(xe|0)/2;if(!Xd){xe=1;break a}ye=ye<<2;Yd=0;Ce=a+8|0;a=0;while(1){Ae=x(x(1)/x(xe|0));xe=Yd<<2;rg(x(Ae*x(q[xe+ze>>2])),x(Ae*x(q[(xe|4)+ze>>2])),we+20|0);Cn(q[q[q[Ce>>2]- -64>>2]>>2]+a|0,we+20|0,ye);xe=1;Be=Be+1|0;if((Be|0)==(Xd|0)){break a}Yd=Yd+2|0;a=a+ye|0;xe=q[we+8>>2];continue}}T=we+32|0;return xe|0}function rg(a,Xd,De){var Ee=0,Fe=0,Ge=x(0),He=x(0),Ie=x(0),Je=0,Ke=0;Ge=x(a+Xd);a:{b:{Ie=x(a-Xd);if(Ie<=x(.5)^1|Ie>=x(-.5)^1|Ge>=x(.5)^1){break b}Fe=1;if(!(Ge<=x(1.5))){break b}He=Xd;break a}c:{if(!!(Ge<=x(.5))){He=x(x(.5)-a);a=x(x(.5)-Xd);break c}if(!!(Ge>=x(1.5))){He=x(x(1.5)-a);a=x(x(1.5)-Xd);break c}if(!!(Ie<=x(-.5))){He=x(a+x(.5));a=x(Xd+x(-.5));break c}He=x(a+x(-.5));a=x(Xd+x(.5))}Ie=x(a-He);Ge=x(He+a);Fe=-1}Ee=+He;Xd=x(Ee+Ee+ -1);Ee=+a;a=x(Ee+Ee+ -1);Ke=Fe;Fe=+Ie;Fe=Fe+Fe;Ee=1-Fe;Fe=Fe+1;Fe=Ee<Fe?Ee:Fe;Ee=+Ge;Ee=Ee+Ee;Je=3-Ee;Ee=Ee+ -1;Ee=Je<Ee?Je:Ee;He=x(Ke*(Fe<Ee?Fe:Ee));Ge=x(x(Xd*Xd)+x(x(a*a)+x(He*He)));d:{if(!!(+Ge<1e-6)){q[De>>2]=0;Ge=x(0);a=x(0);break d}Ie=x(x(1)/x(E(Ge)));u[De>>2]=Ie*He;Ge=x(Ie*Xd);a=x(Ie*a)}u[De+8>>2]=Ge;u[De+4>>2]=a}function sg(a,Xd,De,Le){a=a|0;Xd=Xd|0;De=De|0;Le=Le|0;var Me=0,Ne=0,Oe=0;Me=T-32|0;T=Me;Le=Le+ -2|0;a:{if(Le>>>0<=1){if(Le-1){Le=q[Xd+4>>2];Xd=q[Xd+12>>2];q[Me+24>>2]=-1;q[Me+28>>2]=-1;q[Me+16>>2]=-1;q[Me+20>>2]=-1;if((De|0)==-2){q[Me+8>>2]=0;q[a>>2]=0;break a}Ne=q[q[q[Le+4>>2]+8>>2]+(Xd<<2)>>2];if((n[q[q[Le>>2]+8>>2]](Le)|0)==1){Oe=Xd;Xd=s[Le+36>>1];tg(Me+8|0,Le,De,Oe,Me+16|0,(Xd<<24|Xd<<8&16711680)>>>16);Xd=q[Me+8>>2];if(Xd){q[a>>2]=Xd;break a}q[Me+8>>2]=0}Xd=Mm(24);q[Xd+4>>2]=Ne;De=q[Me+20>>2];q[Xd+8>>2]=q[Me+16>>2];q[Xd+12>>2]=De;De=q[Me+28>>2];q[Xd+16>>2]=q[Me+24>>2];q[Xd+20>>2]=De;q[Xd>>2]=8576;q[Me+8>>2]=Xd;q[a>>2]=Xd;break a}Le=q[Xd+4>>2];Xd=q[Xd+12>>2];q[Me+24>>2]=-1;q[Me+28>>2]=-1;q[Me+16>>2]=-1;q[Me+20>>2]=-1;if((De|0)==-2){q[Me+8>>2]=0;q[a>>2]=0;break a}Ne=q[q[q[Le+4>>2]+8>>2]+(Xd<<2)>>2];if((n[q[q[Le>>2]+8>>2]](Le)|0)==1){Oe=Xd;Xd=s[Le+36>>1];ug(Me+8|0,Le,De,Oe,Me+16|0,(Xd<<24|Xd<<8&16711680)>>>16);Xd=q[Me+8>>2];if(Xd){q[a>>2]=Xd;break a}q[Me+8>>2]=0}Xd=Mm(24);q[Xd+4>>2]=Ne;De=q[Me+20>>2];q[Xd+8>>2]=q[Me+16>>2];q[Xd+12>>2]=De;De=q[Me+28>>2];q[Xd+16>>2]=q[Me+24>>2];q[Xd+20>>2]=De;q[Xd>>2]=10580;q[Me+8>>2]=Xd;q[a>>2]=Xd;break a}q[a>>2]=0}T=Me+32|0}function tg(a,Xd,De,Le,Pe,Qe){var Re=0,Se=0,Te=0,Ue=0;Ue=q[q[q[Xd+4>>2]+8>>2]+(Le<<2)>>2];a:{b:{if((n[q[q[Xd>>2]+8>>2]](Xd)|0)!=1|De+ -1>>>0>5){break b}Se=n[q[q[Xd>>2]+36>>2]](Xd)|0;Qe=n[q[q[Xd>>2]+44>>2]](Xd,Le)|0;if(!Se|!Qe){break b}Te=n[q[q[Xd>>2]+40>>2]](Xd,Le)|0;Le=Qe+12|0;Re=q[Xd+44>>2];c:{if(Te){if((De|0)!=6){break c}Xd=Mm(104);q[Xd+4>>2]=Ue;De=q[Pe+4>>2];q[Xd+8>>2]=q[Pe>>2];q[Xd+12>>2]=De;De=q[Pe+12>>2];q[Xd+16>>2]=q[Pe+8>>2];q[Xd+20>>2]=De;q[Xd+36>>2]=Qe;q[Xd+32>>2]=Le;q[Xd+28>>2]=Te;q[Xd+24>>2]=Re;q[Xd+64>>2]=Qe;q[Xd+60>>2]=Le;q[Xd+56>>2]=Te;q[Xd+52>>2]=Re;q[Xd+44>>2]=0;q[Xd+48>>2]=0;q[Xd>>2]=6860;q[Xd+72>>2]=-1;q[Xd+76>>2]=-1;q[Xd+68>>2]=1;q[Xd+40>>2]=7384;break a}if((De|0)!=6){break c}Xd=Mm(104);q[Xd+4>>2]=Ue;De=q[Pe+4>>2];q[Xd+8>>2]=q[Pe>>2];q[Xd+12>>2]=De;De=q[Pe+12>>2];q[Xd+16>>2]=q[Pe+8>>2];q[Xd+20>>2]=De;q[Xd+36>>2]=Qe;q[Xd+32>>2]=Le;q[Xd+28>>2]=Se;q[Xd+24>>2]=Re;q[Xd+64>>2]=Qe;q[Xd+60>>2]=Le;q[Xd+56>>2]=Se;q[Xd+52>>2]=Re;q[Xd+44>>2]=0;q[Xd+48>>2]=0;q[Xd>>2]=7796;q[Xd+72>>2]=-1;q[Xd+76>>2]=-1;q[Xd+68>>2]=1;q[Xd+40>>2]=8188;break a}q[a>>2]=0}q[a>>2]=0;return}q[Xd+80>>2]=-1;q[Xd+84>>2]=-1;ah(Xd+88|0);q[a>>2]=Xd}function ug(a,Xd,De,Le,Pe,Qe){var Ve=0,We=0,Xe=0,Ye=0;Ye=q[q[q[Xd+4>>2]+8>>2]+(Le<<2)>>2];a:{b:{if((n[q[q[Xd>>2]+8>>2]](Xd)|0)!=1|De+ -1>>>0>5){break b}We=n[q[q[Xd>>2]+36>>2]](Xd)|0;Qe=n[q[q[Xd>>2]+44>>2]](Xd,Le)|0;if(!We|!Qe){break b}Xe=n[q[q[Xd>>2]+40>>2]](Xd,Le)|0;Le=Qe+12|0;Ve=q[Xd+44>>2];c:{if(Xe){if((De|0)!=6){break c}Xd=Mm(104);q[Xd+4>>2]=Ye;De=q[Pe+4>>2];q[Xd+8>>2]=q[Pe>>2];q[Xd+12>>2]=De;De=q[Pe+12>>2];q[Xd+16>>2]=q[Pe+8>>2];q[Xd+20>>2]=De;q[Xd+36>>2]=Qe;q[Xd+32>>2]=Le;q[Xd+28>>2]=Xe;q[Xd+24>>2]=Ve;q[Xd+64>>2]=Qe;q[Xd+60>>2]=Le;q[Xd+56>>2]=Xe;q[Xd+52>>2]=Ve;q[Xd+44>>2]=0;q[Xd+48>>2]=0;q[Xd>>2]=8744;q[Xd+72>>2]=-1;q[Xd+76>>2]=-1;q[Xd+68>>2]=1;q[Xd+40>>2]=9308;break a}if((De|0)!=6){break c}Xd=Mm(104);q[Xd+4>>2]=Ye;De=q[Pe+4>>2];q[Xd+8>>2]=q[Pe>>2];q[Xd+12>>2]=De;De=q[Pe+12>>2];q[Xd+16>>2]=q[Pe+8>>2];q[Xd+20>>2]=De;q[Xd+36>>2]=Qe;q[Xd+32>>2]=Le;q[Xd+28>>2]=We;q[Xd+24>>2]=Ve;q[Xd+64>>2]=Qe;q[Xd+60>>2]=Le;q[Xd+56>>2]=We;q[Xd+52>>2]=Ve;q[Xd+44>>2]=0;q[Xd+48>>2]=0;q[Xd>>2]=9748;q[Xd+72>>2]=-1;q[Xd+76>>2]=-1;q[Xd+68>>2]=1;q[Xd+40>>2]=10168;break a}q[a>>2]=0}q[a>>2]=0;return}q[Xd+80>>2]=-1;q[Xd+84>>2]=-1;ah(Xd+88|0);q[a>>2]=Xd}function vg(a){a=a|0;q[a>>2]=6860;return a|0}function wg(a){a=a|0;q[a>>2]=6860;An(a)}function xg(a){a=a|0;var Xd=0;a:{if(!q[a+44>>2]|!q[a+48>>2]|(!q[a+24>>2]|!q[a+28>>2])){break a}if(!q[a+32>>2]|!q[a+36>>2]){break a}Xd=q[a+72>>2]!=-1}return Xd|0}function yg(a,De){a=a|0;De=De|0;var Le=0;if(!(q[De+56>>2]|r[De+24|0]!=3)){q[a+44>>2]=De;Le=1}return Le|0}function zg(a,De){a=a|0;De=De|0;var Pe=0,Qe=0,Ze=0,_e=0,$e=0,af=0,bf=0,cf=0,df=0,ef=0,ff=0;$e=q[De+12>>2];Pe=$e;Qe=q[De+20>>2];Ze=Qe;af=q[De+16>>2];_e=af+4|0;if(_e>>>0<4){Qe=Qe+1|0}bf=q[De+8>>2];a:{if((Pe|0)<(Qe|0)?1:(Pe|0)<=(Qe|0)?bf>>>0>=_e>>>0?0:1:0){break a}cf=q[De>>2];Pe=af+cf|0;df=r[Pe|0]|r[Pe+1|0]<<8|(r[Pe+2|0]<<16|r[Pe+3|0]<<24);q[De+16>>2]=_e;q[De+20>>2]=Qe;ef=s[De+38>>1];if(ef>>>0<=513){Pe=$e;Qe=Ze;Ze=af+8|0;if(Ze>>>0<8){Qe=Qe+1|0}_e=Ze;if((Pe|0)<(Qe|0)?1:(Pe|0)<=(Qe|0)?bf>>>0>=_e>>>0?0:1:0){break a}q[De+16>>2]=_e;q[De+20>>2]=Qe}if(!(df&1)){break a}Pe=z(df)^31;if(Pe+ -1>>>0>28){break a}q[a+8>>2]=Pe+1;Pe=-2<<Pe;Ze=-2-Pe|0;q[a+16>>2]=Ze;q[a+12>>2]=Pe^-1;q[a+20>>2]=(Ze|0)/2;if(ef>>>0<=513){if(($e|0)<(Qe|0)?1:($e|0)<=(Qe|0)?bf>>>0>_e>>>0?0:1:0){break a}Pe=r[_e+cf|0];Ze=_e+1|0;if(Ze>>>0<1){Qe=Qe+1|0}q[De+16>>2]=Ze;q[De+20>>2]=Qe;if(Pe>>>0>1){break a}q[a+68>>2]=Pe-1|0?0:1}ff=bh(a+88|0,De)}return ff|0}function Ag(a,De,gf,hf,jf,kf){a=a|0;De=De|0;gf=gf|0;hf=hf|0;jf=jf|0;kf=kf|0;var lf=0,mf=0,nf=0,of=0,pf=0,qf=0,rf=0,sf=0,tf=0,uf=0,vf=0;lf=T-48|0;T=lf;rf=a+8|0;hf=q[rf>>2];if(hf+ -2>>>0<=28){q[a+72>>2]=hf;hf=-1<<hf;jf=-2-hf|0;q[a+80>>2]=jf;q[a+76>>2]=hf^-1;q[a+84>>2]=(jf|0)/2}q[a+48>>2]=kf;hf=q[a+36>>2];jf=q[hf>>2];kf=hf+4|0;mf=q[kf>>2];q[lf+16>>2]=0;q[lf+8>>2]=0;q[lf+12>>2]=0;a:{jf=mf-jf|0;if((jf|0)<1){break a}hf=q[hf>>2];if((hf|0)!=q[kf>>2]){sf=jf>>2;tf=a+40|0;uf=a+88|0;vf=a+36|0;while(1){Sf(tf,q[(pf<<2)+hf>>2],lf+8|0);jf=q[lf+12>>2];mf=jf>>31;kf=q[lf+8>>2];of=kf>>31;qf=q[lf+16>>2];nf=qf>>31;hf=0;nf=nf^nf+qf;mf=nf+((mf^jf+mf)+(of^kf+of)|0)|0;if(mf>>>0<nf>>>0){hf=1}b:{if(!(hf|mf)){q[lf+8>>2]=q[a+84>>2];break b}of=q[a+84>>2];nf=of;nf=nf>>31;jf=ao($n(of,nf,jf,jf>>31),V,mf,hf);q[lf+12>>2]=jf;hf=ao($n(of,nf,kf,kf>>31),V,mf,hf);q[lf+8>>2]=hf;kf=hf;hf=hf>>31;hf=(of-(kf+hf^hf)|0)+((jf|0)<0?jf:0-jf|0)|0;if((qf|0)>=0){q[lf+16>>2]=hf;break b}q[lf+16>>2]=0-hf}hf=dh(uf);kf=q[lf+8>>2];c:{if(!hf){jf=q[lf+12>>2];break c}q[lf+16>>2]=0-q[lf+16>>2];jf=0-q[lf+12>>2]|0;q[lf+12>>2]=jf;kf=0-kf|0;q[lf+8>>2]=kf}d:{if((kf|0)>=0){kf=q[a+84>>2];hf=kf+q[lf+16>>2]|0;kf=jf+kf|0;break d}e:{if((jf|0)<=-1){hf=q[lf+16>>2];kf=hf>>31;kf=kf^hf+kf;break e}hf=q[lf+16>>2];kf=hf>>31;kf=q[a+80>>2]-(kf^hf+kf)|0}if((hf|0)<=-1){hf=jf>>31;hf=hf+jf^hf;break d}hf=jf>>31;hf=q[a+80>>2]-(hf+jf^hf)|0}jf=q[a+80>>2];f:{if(!(hf|kf)){hf=jf;kf=hf;break f}if(!((hf|0)!=(jf|0)|kf)){kf=hf;break f}if(!((jf|0)!=(kf|0)|hf)){hf=kf;break f}g:{if(kf){break g}mf=q[a+84>>2];if((mf|0)>=(hf|0)){break g}hf=(mf<<1)-hf|0;kf=0;break f}h:{if((jf|0)!=(kf|0)){break h}mf=q[a+84>>2];if((mf|0)<=(hf|0)){break h}hf=(mf<<1)-hf|0;break f}i:{if((hf|0)!=(jf|0)){break i}jf=q[a+84>>2];if((jf|0)<=(kf|0)){break i}kf=(jf<<1)-kf|0;break f}if(hf){break f}hf=0;jf=q[a+84>>2];if((jf|0)>=(kf|0)){break f}kf=(jf<<1)-kf|0}jf=pf<<3;mf=jf+De|0;of=q[mf+4>>2];q[lf+40>>2]=q[mf>>2];q[lf+44>>2]=of;q[lf+28>>2]=hf;q[lf+24>>2]=kf;Bg(lf+32|0,rf,lf+24|0,lf+40|0);hf=gf+jf|0;q[hf>>2]=q[lf+32>>2];q[hf+4>>2]=q[lf+36>>2];pf=pf+1|0;if((pf|0)>=(sf|0)){break a}jf=q[vf>>2];hf=q[jf>>2];if(q[jf+4>>2]-hf>>2>>>0>pf>>>0){continue}break}}cn();F()}T=lf+48|0;return 1}function Bg(a,De,gf,hf){var jf=0,kf=0,wf=0,xf=0,yf=0,zf=0,Af=0,Bf=0;xf=De+12|0;Af=q[xf>>2];kf=q[gf+4>>2]-Af|0;jf=q[gf>>2]-Af|0;q[gf>>2]=jf;q[gf+4>>2]=kf;wf=kf>>31;yf=wf+kf^wf;wf=jf>>31;xf=q[xf>>2];Bf=(yf+(wf+jf^wf)|0)<=(xf|0);if(!Bf){a:{b:{if((jf|0)>=0){zf=1;yf=1;if((kf|0)>-1){break a}wf=1;zf=-1;yf=-1;if((jf|0)>=1){break b}break a}wf=-1;zf=-1;yf=-1;if((kf|0)<1){break a}}zf=(kf|0)<1?-1:1;yf=wf}wf=kf<<1;kf=w(xf,zf);wf=wf-kf|0;q[gf+4>>2]=wf;xf=w(xf,yf);jf=(jf<<1)-xf|0;q[gf>>2]=jf;c:{if((w(yf,zf)|0)>=0){wf=0-wf|0;q[gf>>2]=wf;jf=0-jf|0;break c}q[gf>>2]=wf}kf=(jf+kf|0)/2|0;q[gf+4>>2]=kf;jf=(xf+wf|0)/2|0;q[gf>>2]=jf;xf=q[De+12>>2]}jf=q[hf>>2]+jf|0;q[a>>2]=jf;gf=q[hf+4>>2]+kf|0;q[a+4>>2]=gf;d:{if((xf|0)<(jf|0)){jf=jf-q[De+4>>2]|0;break d}if((jf|0)>=(0-xf|0)){break d}jf=q[De+4>>2]+jf|0}q[a>>2]=jf;e:{if((xf|0)<(gf|0)){gf=gf-q[De+4>>2]|0;break e}if((gf|0)>=(0-xf|0)){break e}gf=q[De+4>>2]+gf|0}q[a+4>>2]=gf;if(!Bf){f:{g:{if((jf|0)>=0){De=1;hf=1;if((gf|0)>-1){break f}kf=1;De=-1;hf=-1;if((jf|0)>=1){break g}break f}kf=-1;De=-1;hf=-1;if((gf|0)<1){break f}}De=(gf|0)<1?-1:1;hf=kf}wf=w(De,xf);kf=(gf<<1)-wf|0;q[a+4>>2]=kf;yf=w(hf,xf);gf=(jf<<1)-yf|0;q[a>>2]=gf;h:{if((w(De,hf)|0)>=0){kf=0-kf|0;q[a>>2]=kf;gf=0-gf|0;break h}q[a>>2]=kf}gf=(gf+wf|0)/2|0;q[a+4>>2]=gf;jf=(kf+yf|0)/2|0;q[a>>2]=jf}q[a>>2]=jf+Af;q[a+4>>2]=gf+Af}function Cg(a,De){a=a|0;De=De|0;var gf=0,hf=0,Cf=0,Df=0,Ef=0,Ff=0,Gf=0,Hf=0,If=0;gf=q[De+12>>2];Ff=gf;Cf=gf;gf=q[De+20>>2];Df=gf;Ef=q[De+16>>2];hf=Ef+4|0;if(hf>>>0<4){gf=gf+1|0}Gf=q[De+8>>2];Hf=hf;hf=gf;a:{if((Cf|0)<(gf|0)?1:(Cf|0)<=(gf|0)?Gf>>>0>=Hf>>>0?0:1:0){break a}gf=Ef+q[De>>2]|0;Cf=r[gf|0]|r[gf+1|0]<<8|(r[gf+2|0]<<16|r[gf+3|0]<<24);q[De+16>>2]=Hf;q[De+20>>2]=hf;if(s[De+38>>1]<=513){gf=Df;hf=Ef+8|0;if(hf>>>0<8){gf=gf+1|0}Df=hf;hf=gf;if((Ff|0)<(gf|0)?1:(Ff|0)<=(gf|0)?Gf>>>0>=Df>>>0?0:1:0){break a}q[De+16>>2]=Df;q[De+20>>2]=hf}if(!(Cf&1)){break a}De=z(Cf)^31;if(De+ -1>>>0>28){break a}If=1;q[a+8>>2]=De+1;gf=-2<<De;De=-2-gf|0;q[a+16>>2]=De;q[a+12>>2]=gf^-1;q[a+20>>2]=(De|0)/2}return If|0}function Dg(a){a=a|0;q[a>>2]=7796;return a|0}function Eg(a){a=a|0;q[a>>2]=7796;An(a)}function Fg(a,De,Jf,Kf,Lf,Mf){a=a|0;De=De|0;Jf=Jf|0;Kf=Kf|0;Lf=Lf|0;Mf=Mf|0;var Nf=0,Of=0,Pf=0,Qf=0,Rf=0,Sf=0,Tf=0,Uf=0,Vf=0,Wf=0,Xf=0;Nf=T-48|0;T=Nf;Tf=a+8|0;Kf=q[Tf>>2];if(Kf+ -2>>>0<=28){q[a+72>>2]=Kf;Kf=-1<<Kf;Lf=-2-Kf|0;q[a+80>>2]=Lf;q[a+76>>2]=Kf^-1;q[a+84>>2]=(Lf|0)/2}q[a+48>>2]=Mf;Kf=q[a+36>>2];Lf=q[Kf>>2];Mf=Kf+4|0;Of=q[Mf>>2];q[Nf+16>>2]=0;q[Nf+8>>2]=0;q[Nf+12>>2]=0;a:{Lf=Of-Lf|0;if((Lf|0)<1){break a}Kf=q[Kf>>2];if((Kf|0)!=q[Mf>>2]){Uf=Lf>>2;Vf=a+40|0;Wf=a+88|0;Xf=a+36|0;while(1){kg(Vf,q[(Rf<<2)+Kf>>2],Nf+8|0);Lf=q[Nf+12>>2];Of=Lf>>31;Mf=q[Nf+8>>2];Qf=Mf>>31;Sf=q[Nf+16>>2];Pf=Sf>>31;Kf=0;Pf=Pf^Pf+Sf;Of=Pf+((Of^Lf+Of)+(Qf^Mf+Qf)|0)|0;if(Of>>>0<Pf>>>0){Kf=1}b:{if(!(Kf|Of)){q[Nf+8>>2]=q[a+84>>2];break b}Qf=q[a+84>>2];Pf=Qf;Pf=Pf>>31;Lf=ao($n(Qf,Pf,Lf,Lf>>31),V,Of,Kf);q[Nf+12>>2]=Lf;Kf=ao($n(Qf,Pf,Mf,Mf>>31),V,Of,Kf);q[Nf+8>>2]=Kf;Mf=Kf;Kf=Kf>>31;Kf=(Qf-(Mf+Kf^Kf)|0)+((Lf|0)<0?Lf:0-Lf|0)|0;if((Sf|0)>=0){q[Nf+16>>2]=Kf;break b}q[Nf+16>>2]=0-Kf}Kf=dh(Wf);Mf=q[Nf+8>>2];c:{if(!Kf){Lf=q[Nf+12>>2];break c}q[Nf+16>>2]=0-q[Nf+16>>2];Lf=0-q[Nf+12>>2]|0;q[Nf+12>>2]=Lf;Mf=0-Mf|0;q[Nf+8>>2]=Mf}d:{if((Mf|0)>=0){Mf=q[a+84>>2];Kf=Mf+q[Nf+16>>2]|0;Mf=Lf+Mf|0;break d}e:{if((Lf|0)<=-1){Kf=q[Nf+16>>2];Mf=Kf>>31;Mf=Mf^Kf+Mf;break e}Kf=q[Nf+16>>2];Mf=Kf>>31;Mf=q[a+80>>2]-(Mf^Kf+Mf)|0}if((Kf|0)<=-1){Kf=Lf>>31;Kf=Kf+Lf^Kf;break d}Kf=Lf>>31;Kf=q[a+80>>2]-(Kf+Lf^Kf)|0}Lf=q[a+80>>2];f:{if(!(Kf|Mf)){Kf=Lf;Mf=Kf;break f}if(!((Kf|0)!=(Lf|0)|Mf)){Mf=Kf;break f}if(!((Lf|0)!=(Mf|0)|Kf)){Kf=Mf;break f}g:{if(Mf){break g}Of=q[a+84>>2];if((Of|0)>=(Kf|0)){break g}Kf=(Of<<1)-Kf|0;Mf=0;break f}h:{if((Lf|0)!=(Mf|0)){break h}Of=q[a+84>>2];if((Of|0)<=(Kf|0)){break h}Kf=(Of<<1)-Kf|0;break f}i:{if((Kf|0)!=(Lf|0)){break i}Lf=q[a+84>>2];if((Lf|0)<=(Mf|0)){break i}Mf=(Lf<<1)-Mf|0;break f}if(Kf){break f}Kf=0;Lf=q[a+84>>2];if((Lf|0)>=(Mf|0)){break f}Mf=(Lf<<1)-Mf|0}Lf=Rf<<3;Of=Lf+De|0;Qf=q[Of+4>>2];q[Nf+40>>2]=q[Of>>2];q[Nf+44>>2]=Qf;q[Nf+28>>2]=Kf;q[Nf+24>>2]=Mf;Bg(Nf+32|0,Tf,Nf+24|0,Nf+40|0);Kf=Jf+Lf|0;q[Kf>>2]=q[Nf+32>>2];q[Kf+4>>2]=q[Nf+36>>2];Rf=Rf+1|0;if((Rf|0)>=(Uf|0)){break a}Lf=q[Xf>>2];Kf=q[Lf>>2];if(q[Lf+4>>2]-Kf>>2>>>0>Rf>>>0){continue}break}}cn();F()}T=Nf+48|0;return 1}function Gg(a,De,Jf,Kf,Lf,Mf){a=a|0;De=De|0;Jf=Jf|0;Kf=Kf|0;Lf=Lf|0;Mf=Mf|0;var Yf=0,Zf=0,_f=0,$f=0,ag=0,bg=0,cg=0,dg=0;Mf=T-32|0;T=Mf;Yf=(Lf&1073741823)!=(Lf|0)?-1:Lf<<2;bg=Dn(Mm(Yf),0,Yf);Yf=bg;_f=q[Yf>>2];Yf=q[Yf+4>>2];ag=q[De+4>>2];q[Mf+24>>2]=q[De>>2];q[Mf+28>>2]=ag;q[Mf+8>>2]=_f;q[Mf+12>>2]=Yf;_f=a+8|0;Bg(Mf+16|0,_f,Mf+8|0,Mf+24|0);q[Jf>>2]=q[Mf+16>>2];q[Jf+4>>2]=q[Mf+20>>2];if((Lf|0)<(Kf|0)){ag=0-Lf<<2;a=Lf;while(1){Zf=a<<2;Yf=Zf+Jf|0;$f=Yf+ag|0;cg=q[$f>>2];$f=q[$f+4>>2];Zf=De+Zf|0;dg=q[Zf+4>>2];q[Mf+24>>2]=q[Zf>>2];q[Mf+28>>2]=dg;q[Mf+8>>2]=cg;q[Mf+12>>2]=$f;Bg(Mf+16|0,_f,Mf+8|0,Mf+24|0);q[Yf>>2]=q[Mf+16>>2];q[Yf+4>>2]=q[Mf+20>>2];a=a+Lf|0;if((a|0)<(Kf|0)){continue}break}}An(bg);T=Mf+32|0;return 1}function Hg(a){a=a|0;q[a>>2]=8744;return a|0}function Ig(a){a=a|0;q[a>>2]=8744;An(a)}function Jg(a,De){a=a|0;De=De|0;var Jf=0,Kf=0,Lf=0,Mf=0,eg=0,fg=0,gg=0,hg=0,ig=0,jg=0,kg=0;Mf=q[De+12>>2];eg=Mf;Jf=q[De+20>>2];fg=Jf;gg=q[De+16>>2];Kf=gg+4|0;if(Kf>>>0<4){Jf=Jf+1|0}hg=q[De+8>>2];Lf=Kf;Kf=Jf;a:{if((eg|0)<(Jf|0)?1:(eg|0)<=(Jf|0)?hg>>>0>=Lf>>>0?0:1:0){break a}eg=q[De>>2];Jf=gg+eg|0;jg=r[Jf|0]|r[Jf+1|0]<<8|(r[Jf+2|0]<<16|r[Jf+3|0]<<24);q[De+16>>2]=Lf;q[De+20>>2]=Kf;Kf=Mf;Jf=fg;Lf=gg+8|0;if(Lf>>>0<8){Jf=Jf+1|0}ig=Lf;if((Kf|0)<(Jf|0)?1:(Kf|0)<=(Jf|0)?hg>>>0>=Lf>>>0?0:1:0){break a}q[De+16>>2]=ig;q[De+20>>2]=Jf;if(!(jg&1)){break a}Kf=z(jg)^31;if(Kf+ -1>>>0>28){break a}q[a+8>>2]=Kf+1;Lf=-2<<Kf;Kf=-2-Lf|0;q[a+16>>2]=Kf;q[a+12>>2]=Lf^-1;q[a+20>>2]=(Kf|0)/2;if(s[De+38>>1]<=513){if((Mf|0)<(Jf|0)?1:(Mf|0)<=(Jf|0)?hg>>>0>ig>>>0?0:1:0){break a}Mf=r[eg+ig|0];Kf=gg+9|0;if(Kf>>>0<9){fg=fg+1|0}Jf=De;q[Jf+16>>2]=Kf;q[Jf+20>>2]=fg;if(Mf>>>0>1){break a}q[a+68>>2]=Mf-1|0?0:1}kg=bh(a+88|0,De)}return kg|0}function Kg(a,De,lg,mg,ng,og){a=a|0;De=De|0;lg=lg|0;mg=mg|0;ng=ng|0;og=og|0;var pg=0,qg=0,rg=0,sg=0,tg=0,ug=0,vg=0,wg=0,xg=0,yg=0,zg=0;pg=T-48|0;T=pg;vg=a+8|0;mg=q[vg>>2];if(mg+ -2>>>0<=28){q[a+72>>2]=mg;mg=-1<<mg;ng=-2-mg|0;q[a+80>>2]=ng;q[a+76>>2]=mg^-1;q[a+84>>2]=(ng|0)/2}q[a+48>>2]=og;mg=q[a+36>>2];ng=q[mg>>2];og=mg+4|0;qg=q[og>>2];q[pg+16>>2]=0;q[pg+8>>2]=0;q[pg+12>>2]=0;a:{ng=qg-ng|0;if((ng|0)<1){break a}mg=q[mg>>2];if((mg|0)!=q[og>>2]){wg=ng>>2;xg=a+40|0;yg=a+88|0;zg=a+36|0;while(1){Sf(xg,q[(tg<<2)+mg>>2],pg+8|0);ng=q[pg+12>>2];qg=ng>>31;og=q[pg+8>>2];sg=og>>31;ug=q[pg+16>>2];rg=ug>>31;mg=0;rg=rg^rg+ug;qg=rg+((qg^ng+qg)+(sg^og+sg)|0)|0;if(qg>>>0<rg>>>0){mg=1}b:{if(!(mg|qg)){q[pg+8>>2]=q[a+84>>2];break b}sg=q[a+84>>2];rg=sg;rg=rg>>31;ng=ao($n(sg,rg,ng,ng>>31),V,qg,mg);q[pg+12>>2]=ng;mg=ao($n(sg,rg,og,og>>31),V,qg,mg);q[pg+8>>2]=mg;og=mg;mg=mg>>31;mg=(sg-(og+mg^mg)|0)+((ng|0)<0?ng:0-ng|0)|0;if((ug|0)>=0){q[pg+16>>2]=mg;break b}q[pg+16>>2]=0-mg}mg=dh(yg);og=q[pg+8>>2];c:{if(!mg){ng=q[pg+12>>2];break c}q[pg+16>>2]=0-q[pg+16>>2];ng=0-q[pg+12>>2]|0;q[pg+12>>2]=ng;og=0-og|0;q[pg+8>>2]=og}d:{if((og|0)>=0){og=q[a+84>>2];mg=og+q[pg+16>>2]|0;og=ng+og|0;break d}e:{if((ng|0)<=-1){mg=q[pg+16>>2];og=mg>>31;og=og^mg+og;break e}mg=q[pg+16>>2];og=mg>>31;og=q[a+80>>2]-(og^mg+og)|0}if((mg|0)<=-1){mg=ng>>31;mg=mg+ng^mg;break d}mg=ng>>31;mg=q[a+80>>2]-(mg+ng^mg)|0}ng=q[a+80>>2];f:{if(!(mg|og)){mg=ng;og=mg;break f}if(!((mg|0)!=(ng|0)|og)){og=mg;break f}if(!((ng|0)!=(og|0)|mg)){mg=og;break f}g:{if(og){break g}qg=q[a+84>>2];if((qg|0)>=(mg|0)){break g}mg=(qg<<1)-mg|0;og=0;break f}h:{if((ng|0)!=(og|0)){break h}qg=q[a+84>>2];if((qg|0)<=(mg|0)){break h}mg=(qg<<1)-mg|0;break f}i:{if((mg|0)!=(ng|0)){break i}ng=q[a+84>>2];if((ng|0)<=(og|0)){break i}og=(ng<<1)-og|0;break f}if(mg){break f}mg=0;ng=q[a+84>>2];if((ng|0)>=(og|0)){break f}og=(ng<<1)-og|0}ng=tg<<3;qg=ng+De|0;sg=q[qg+4>>2];qg=q[qg>>2];q[pg+36>>2]=mg;q[pg+32>>2]=og;q[pg+24>>2]=qg;q[pg+28>>2]=sg;Lg(pg+40|0,vg,pg+32|0,pg+24|0);mg=lg+ng|0;q[mg>>2]=q[pg+40>>2];q[mg+4>>2]=q[pg+44>>2];tg=tg+1|0;if((tg|0)>=(wg|0)){break a}ng=q[zg>>2];mg=q[ng>>2];if(q[ng+4>>2]-mg>>2>>>0>tg>>>0){continue}break}}cn();F()}T=pg+48|0;return 1}function Lg(a,De,lg,mg){var ng=0,og=0,Ag=0,Bg=0,Cg=0,Dg=0,Eg=0,Fg=0;Bg=De+12|0;Eg=q[Bg>>2];og=q[lg+4>>2]-Eg|0;ng=q[lg>>2]-Eg|0;q[lg>>2]=ng;q[lg+4>>2]=og;Ag=og>>31;Cg=Ag+og^Ag;Ag=ng>>31;Bg=q[Bg>>2];Fg=(Cg+(Ag+ng^Ag)|0)<=(Bg|0);if(!Fg){a:{b:{if((ng|0)>=0){Ag=1;Dg=1;if((og|0)>-1){break a}Cg=1;Ag=-1;Dg=-1;if((ng|0)>=1){break b}break a}Cg=-1;Ag=-1;Dg=-1;if((og|0)<1){break a}}Ag=(og|0)<1?-1:1;Dg=Cg}Cg=og<<1;og=w(Ag,Bg);Cg=Cg-og|0;q[lg+4>>2]=Cg;Bg=w(Bg,Dg);ng=(ng<<1)-Bg|0;q[lg>>2]=ng;c:{if((w(Ag,Dg)|0)>=0){Cg=0-Cg|0;q[lg>>2]=Cg;ng=0-ng|0;break c}q[lg>>2]=Cg}og=(ng+og|0)/2|0;q[lg+4>>2]=og;ng=(Bg+Cg|0)/2|0;q[lg>>2]=ng}d:{e:{f:{g:{h:{i:{j:{k:{if(!ng){if(og){break j}Bg=1;Dg=0;break k}Bg=1;Ag=(ng|0)<0&(og|0)<1;if((ng|0)>=1){Dg=(og|0)>-1?2:1;if(Ag){break k}break i}Dg=(og|0)>0?3:0;if(!Ag){break i}}Ag=og;Cg=ng;break d}if((og|0)>=1){break f}break h}Ag=Dg+ -1|0;if(Ag>>>0>2){Ag=og;og=ng;Dg=0;break e}switch(Ag-1|0){case 0:break g;case 1:break f;default:break h}}Ag=0-ng|0;Dg=1;break e}Ag=0-og|0;og=0-ng|0;Dg=2;break e}Ag=ng;og=0-og|0;Dg=3}ng=lg;Cg=og;q[ng>>2]=og;q[ng+4>>2]=Ag;Bg=0}og=q[mg>>2]+Cg|0;q[a>>2]=og;ng=q[mg+4>>2]+Ag|0;q[a+4>>2]=ng;Ag=q[De+12>>2];l:{if((Ag|0)<(og|0)){og=og-q[De+4>>2]|0;break l}if((og|0)>=(0-Ag|0)){break l}og=q[De+4>>2]+og|0}q[a>>2]=og;m:{if((Ag|0)<(ng|0)){ng=ng-q[De+4>>2]|0;break m}if((ng|0)>=(0-Ag|0)){break m}ng=q[De+4>>2]+ng|0}q[a+4>>2]=ng;n:{if(Bg){lg=ng;ng=og;break n}De=(4-Dg&3)+ -1|0;o:{if(De>>>0>2){lg=ng;ng=og;break o}p:{switch(De-1|0){default:lg=0-og|0;break o;case 0:lg=0-ng|0;ng=0-og|0;break o;case 1:break p}}ng=0-ng|0;lg=og}q[a>>2]=ng;q[a+4>>2]=lg}if(!Fg){q:{r:{if((ng|0)>=0){De=1;Bg=1;if((lg|0)>-1){break q}og=1;De=-1;Bg=-1;if((ng|0)>=1){break r}break q}og=-1;De=-1;Bg=-1;if((lg|0)<1){break q}}De=(lg|0)<1?-1:1;Bg=og}mg=lg<<1;lg=w(De,Ag);og=mg-lg|0;q[a+4>>2]=og;mg=w(Ag,Bg);ng=(ng<<1)-mg|0;q[a>>2]=ng;s:{if((w(De,Bg)|0)>=0){og=0-og|0;q[a>>2]=og;ng=0-ng|0;break s}q[a>>2]=og}lg=(lg+ng|0)/2|0;q[a+4>>2]=lg;ng=(mg+og|0)/2|0;q[a>>2]=ng}q[a>>2]=ng+Eg;q[a+4>>2]=lg+Eg}function Mg(a,De){a=a|0;De=De|0;var lg=0,mg=0,Gg=0,Hg=0,Ig=0,Jg=0,Kg=0,Lg=0,Mg=0;lg=q[De+12>>2];Jg=lg;Gg=lg;lg=q[De+20>>2];Hg=lg;Ig=q[De+16>>2];mg=Ig+4|0;if(mg>>>0<4){lg=lg+1|0}Kg=q[De+8>>2];Lg=mg;mg=lg;a:{if((Gg|0)<(lg|0)?1:(Gg|0)<=(lg|0)?Kg>>>0>=Lg>>>0?0:1:0){break a}lg=Ig+q[De>>2]|0;Gg=r[lg|0]|r[lg+1|0]<<8|(r[lg+2|0]<<16|r[lg+3|0]<<24);q[De+16>>2]=Lg;q[De+20>>2]=mg;lg=Hg;mg=Ig+8|0;if(mg>>>0<8){lg=lg+1|0}Hg=mg;mg=lg;if((Jg|0)<(lg|0)?1:(Jg|0)<=(lg|0)?Kg>>>0>=Hg>>>0?0:1:0){break a}q[De+16>>2]=Hg;q[De+20>>2]=mg;if(!(Gg&1)){break a}De=z(Gg)^31;if(De+ -1>>>0>28){break a}Mg=1;q[a+8>>2]=De+1;lg=-2<<De;De=-2-lg|0;q[a+16>>2]=De;q[a+12>>2]=lg^-1;q[a+20>>2]=(De|0)/2}return Mg|0}function Ng(a){a=a|0;q[a>>2]=9748;return a|0}function Og(a){a=a|0;q[a>>2]=9748;An(a)}function Pg(a,De,Ng,Og,Pg,Qg){a=a|0;De=De|0;Ng=Ng|0;Og=Og|0;Pg=Pg|0;Qg=Qg|0;var Rg=0,Sg=0,Tg=0,Ug=0,Vg=0,Wg=0,Xg=0,Yg=0,Zg=0,_g=0,$g=0;Rg=T-48|0;T=Rg;Xg=a+8|0;Og=q[Xg>>2];if(Og+ -2>>>0<=28){q[a+72>>2]=Og;Og=-1<<Og;Pg=-2-Og|0;q[a+80>>2]=Pg;q[a+76>>2]=Og^-1;q[a+84>>2]=(Pg|0)/2}q[a+48>>2]=Qg;Og=q[a+36>>2];Pg=q[Og>>2];Qg=Og+4|0;Sg=q[Qg>>2];q[Rg+16>>2]=0;q[Rg+8>>2]=0;q[Rg+12>>2]=0;a:{Pg=Sg-Pg|0;if((Pg|0)<1){break a}Og=q[Og>>2];if((Og|0)!=q[Qg>>2]){Yg=Pg>>2;Zg=a+40|0;_g=a+88|0;$g=a+36|0;while(1){kg(Zg,q[(Vg<<2)+Og>>2],Rg+8|0);Pg=q[Rg+12>>2];Sg=Pg>>31;Qg=q[Rg+8>>2];Ug=Qg>>31;Wg=q[Rg+16>>2];Tg=Wg>>31;Og=0;Tg=Tg^Tg+Wg;Sg=Tg+((Sg^Pg+Sg)+(Ug^Qg+Ug)|0)|0;if(Sg>>>0<Tg>>>0){Og=1}b:{if(!(Og|Sg)){q[Rg+8>>2]=q[a+84>>2];break b}Ug=q[a+84>>2];Tg=Ug;Tg=Tg>>31;Pg=ao($n(Ug,Tg,Pg,Pg>>31),V,Sg,Og);q[Rg+12>>2]=Pg;Og=ao($n(Ug,Tg,Qg,Qg>>31),V,Sg,Og);q[Rg+8>>2]=Og;Qg=Og;Og=Og>>31;Og=(Ug-(Qg+Og^Og)|0)+((Pg|0)<0?Pg:0-Pg|0)|0;if((Wg|0)>=0){q[Rg+16>>2]=Og;break b}q[Rg+16>>2]=0-Og}Og=dh(_g);Qg=q[Rg+8>>2];c:{if(!Og){Pg=q[Rg+12>>2];break c}q[Rg+16>>2]=0-q[Rg+16>>2];Pg=0-q[Rg+12>>2]|0;q[Rg+12>>2]=Pg;Qg=0-Qg|0;q[Rg+8>>2]=Qg}d:{if((Qg|0)>=0){Qg=q[a+84>>2];Og=Qg+q[Rg+16>>2]|0;Qg=Pg+Qg|0;break d}e:{if((Pg|0)<=-1){Og=q[Rg+16>>2];Qg=Og>>31;Qg=Qg^Og+Qg;break e}Og=q[Rg+16>>2];Qg=Og>>31;Qg=q[a+80>>2]-(Qg^Og+Qg)|0}if((Og|0)<=-1){Og=Pg>>31;Og=Og+Pg^Og;break d}Og=Pg>>31;Og=q[a+80>>2]-(Og+Pg^Og)|0}Pg=q[a+80>>2];f:{if(!(Og|Qg)){Og=Pg;Qg=Og;break f}if(!((Og|0)!=(Pg|0)|Qg)){Qg=Og;break f}if(!((Pg|0)!=(Qg|0)|Og)){Og=Qg;break f}g:{if(Qg){break g}Sg=q[a+84>>2];if((Sg|0)>=(Og|0)){break g}Og=(Sg<<1)-Og|0;Qg=0;break f}h:{if((Pg|0)!=(Qg|0)){break h}Sg=q[a+84>>2];if((Sg|0)<=(Og|0)){break h}Og=(Sg<<1)-Og|0;break f}i:{if((Og|0)!=(Pg|0)){break i}Pg=q[a+84>>2];if((Pg|0)<=(Qg|0)){break i}Qg=(Pg<<1)-Qg|0;break f}if(Og){break f}Og=0;Pg=q[a+84>>2];if((Pg|0)>=(Qg|0)){break f}Qg=(Pg<<1)-Qg|0}Pg=Vg<<3;Sg=Pg+De|0;Ug=q[Sg+4>>2];Sg=q[Sg>>2];q[Rg+36>>2]=Og;q[Rg+32>>2]=Qg;q[Rg+24>>2]=Sg;q[Rg+28>>2]=Ug;Lg(Rg+40|0,Xg,Rg+32|0,Rg+24|0);Og=Ng+Pg|0;q[Og>>2]=q[Rg+40>>2];q[Og+4>>2]=q[Rg+44>>2];Vg=Vg+1|0;if((Vg|0)>=(Yg|0)){break a}Pg=q[$g>>2];Og=q[Pg>>2];if(q[Pg+4>>2]-Og>>2>>>0>Vg>>>0){continue}break}}cn();F()}T=Rg+48|0;return 1}function Qg(a,De,Ng,Og,Pg,Qg){a=a|0;De=De|0;Ng=Ng|0;Og=Og|0;Pg=Pg|0;Qg=Qg|0;var ah=0,bh=0,ch=0,dh=0,eh=0,fh=0,gh=0,hh=0;Qg=T-32|0;T=Qg;bh=(Pg&1073741823)!=(Pg|0)?-1:Pg<<2;bh=Dn(Mm(bh),0,bh);ah=q[De>>2];ch=q[De+4>>2];eh=q[bh+4>>2];q[Qg+16>>2]=q[bh>>2];q[Qg+20>>2]=eh;q[Qg+8>>2]=ah;q[Qg+12>>2]=ch;ch=a+8|0;Lg(Qg+24|0,ch,Qg+16|0,Qg+8|0);q[Ng>>2]=q[Qg+24>>2];q[Ng+4>>2]=q[Qg+28>>2];if((Pg|0)<(Og|0)){eh=0-Pg<<2;a=Pg;while(1){ah=a<<2;dh=ah+De|0;gh=q[dh>>2];dh=q[dh+4>>2];ah=Ng+ah|0;fh=ah+eh|0;hh=q[fh+4>>2];q[Qg+16>>2]=q[fh>>2];q[Qg+20>>2]=hh;q[Qg+8>>2]=gh;q[Qg+12>>2]=dh;Lg(Qg+24|0,ch,Qg+16|0,Qg+8|0);q[ah>>2]=q[Qg+24>>2];q[ah+4>>2]=q[Qg+28>>2];a=a+Pg|0;if((a|0)<(Og|0)){continue}break}}An(bh);T=Qg+32|0;return 1}function Rg(a,De,Ng){a=a|0;De=De|0;Ng=Ng|0;if(Se(a,De,Ng)){a=q[q[q[q[De+4>>2]+8>>2]+(Ng<<2)>>2]+28>>2]==9}else{a=0}return a|0}function Sg(a,De,Ng){a=a|0;De=De|0;Ng=Ng|0;var Og=0;a:{if(r[q[a+4>>2]+36|0]<=1){Og=0;if(!n[q[q[a>>2]+52>>2]](a)){break a}}Og=Xe(a,De,Ng)}return Og|0}function Tg(a,De,Ng){a=a|0;De=De|0;Ng=Ng|0;De=T-32|0;T=De;a:{if(r[q[a+4>>2]+36|0]>=2){Ng=0;if(!n[q[q[a>>2]+52>>2]](a)){break a}}q[De+24>>2]=0;q[De+28>>2]=0;q[De+16>>2]=0;q[De+20>>2]=0;q[De+12>>2]=-1;q[De+8>>2]=1232;gd(De+8|0,q[a+24>>2],q[a+28>>2],o[q[a+8>>2]+24|0],u[a+32>>2]);Ng=ld(De+8|0,q[a+16>>2]);q[De+8>>2]=1232;a=q[De+16>>2];if(!a){break a}q[De+20>>2]=a;An(a)}T=De+32|0;return Ng|0}function Ug(a,De){a=a|0;De=De|0;return n[q[q[a>>2]+56>>2]](a,De)|0}function Vg(a){a=a|0;var De=0,Ng=0,Pg=0,Qg=0,ih=0,jh=0,kh=0,lh=0,mh=0,nh=0;De=o[q[a+8>>2]+24|0];Pg=De<<2;De=Mm((De|0)!=(De&1073741823)?-1:Pg);Ng=q[a+28>>2];q[a+28>>2]=De;if(Ng){An(Ng)}lh=a+4|0;Ng=q[q[lh>>2]+32>>2];De=q[Ng+8>>2];mh=q[Ng+12>>2];jh=De;ih=q[Ng+20>>2];kh=q[Ng+16>>2];De=Pg;Qg=kh+De|0;if(Qg>>>0<De>>>0){ih=ih+1|0}a:{if((mh|0)<(ih|0)?1:(mh|0)<=(ih|0)?jh>>>0>=Qg>>>0?0:1:0){break a}Cn(q[a+28>>2],kh+q[Ng>>2]|0,Pg);Pg=Ng;jh=Ng;Qg=q[Ng+20>>2];Ng=De+q[Ng+16>>2]|0;if(Ng>>>0<De>>>0){Qg=Qg+1|0}q[jh+16>>2]=Ng;q[Pg+20>>2]=Qg;Qg=q[lh>>2];Pg=q[Qg+32>>2];De=q[Pg+8>>2];ih=q[Pg+12>>2];jh=De;kh=q[Pg+20>>2];Ng=q[Pg+16>>2];De=Ng+4|0;if(De>>>0<4){kh=kh+1|0}if((ih|0)<(kh|0)?1:(ih|0)<=(kh|0)?jh>>>0>=De>>>0?0:1:0){break a}De=Ng+q[Pg>>2]|0;q[a+32>>2]=r[De|0]|r[De+1|0]<<8|(r[De+2|0]<<16|r[De+3|0]<<24);De=Pg;jh=De;Ng=q[De+20>>2];Pg=q[De+16>>2]+4|0;if(Pg>>>0<4){Ng=Ng+1|0}q[jh+16>>2]=Pg;q[De+20>>2]=Ng;De=q[Qg+32>>2];ih=q[De+16>>2];Qg=q[De+12>>2];Pg=q[De+20>>2];Ng=Pg;if((Qg|0)<(Ng|0)?1:(Qg|0)<=(Ng|0)?t[De+8>>2]>ih>>>0?0:1:0){break a}Qg=r[ih+q[De>>2]|0];Ng=ih+1|0;if(Ng>>>0<1){Pg=Pg+1|0}q[De+16>>2]=Ng;q[De+20>>2]=Pg;if(Qg>>>0>31){break a}q[a+24>>2]=Qg;nh=1}return nh|0}function Wg(a,oh){a=a|0;oh=oh|0;var ph=0,qh=0,rh=0,sh=0,th=0,uh=0,vh=0,wh=0,xh=0,yh=0,zh=0,Ah=0,Bh=0,Ch=0,Dh=x(0);sh=T-16|0;T=sh;qh=q[a+24>>2];rh=o[q[a+8>>2]+24|0];th=rh<<2;uh=Mm((rh&1073741823)!=(rh|0)?-1:th);vh=hk(sh+8|0);a:{if(!ik(vh,u[a+32>>2],-1<<qh^-1)){break a}ph=q[a+16>>2];qh=0;b:{if(!q[ph+80>>2]){break b}qh=q[q[ph>>2]>>2]+q[ph+48>>2]|0}if(!oh){ph=1;break a}zh=(rh|0)<1;Ah=a+28|0;Bh=a+8|0;a=0;while(1){if(!zh){Ch=q[Ah>>2];Dh=u[vh>>2];ph=0;while(1){wh=ph<<2;u[wh+uh>>2]=x(Dh*x(q[(a<<2)+qh>>2]))+u[Ch+wh>>2];a=a+1|0;ph=ph+1|0;if((rh|0)!=(ph|0)){continue}break}}Cn(q[q[q[Bh>>2]- -64>>2]>>2]+xh|0,uh,th);xh=th+xh|0;ph=1;yh=yh+1|0;if((yh|0)!=(oh|0)){continue}break}}An(uh);T=sh+16|0;return ph|0}function Xg(a){a=a|0;var oh=0,Eh=0;q[a>>2]=10764;Eh=a+28|0;oh=q[Eh>>2];q[Eh>>2]=0;if(oh){An(oh)}q[a>>2]=2220;Eh=a+20|0;oh=q[Eh>>2];q[Eh>>2]=0;if(oh){n[q[q[oh>>2]+4>>2]](oh)}q[a>>2]=1908;Eh=a+16|0;oh=q[Eh>>2];q[Eh>>2]=0;if(oh){Hb(oh)}return a|0}function Yg(a){a=a|0;var Fh=0,Gh=0;q[a>>2]=10764;Gh=a+28|0;Fh=q[Gh>>2];q[Gh>>2]=0;if(Fh){An(Fh)}q[a>>2]=2220;Gh=a+20|0;Fh=q[Gh>>2];q[Gh>>2]=0;if(Fh){n[q[q[Fh>>2]+4>>2]](Fh)}q[a>>2]=1908;Gh=a+16|0;Fh=q[Gh>>2];q[Gh>>2]=0;if(Fh){Hb(Fh)}An(a)}function Zg(a){q[a>>2]=0;q[a+4>>2]=0;q[a+16>>2]=0;q[a+8>>2]=0;q[a+12>>2]=0}function _g(a){var Hh=0,Ih=0;q[a+16>>2]=0;Ih=a+4|0;Hh=q[a>>2];q[Ih>>2]=Hh;q[a+12>>2]=Hh;if(Hh){q[Ih>>2]=Hh;An(Hh)}}function $g(a,Jh){var Kh=0,Lh=0,Mh=0,Nh=0,Oh=0,Ph=0,Qh=0,Rh=0,Sh=0;q[a+16>>2]=0;Kh=q[a>>2];q[a+4>>2]=Kh;q[a+12>>2]=Kh;Qh=q[Jh+12>>2];Kh=Qh;Lh=q[Jh+20>>2];Mh=q[Jh+16>>2];Nh=Mh+4|0;if(Nh>>>0<4){Lh=Lh+1|0}Ph=q[Jh+8>>2];Oh=Nh;Nh=Lh;a:{if((Kh|0)<(Lh|0)?1:(Kh|0)<=(Lh|0)?Ph>>>0>=Oh>>>0?0:1:0){break a}Kh=Mh+q[Jh>>2]|0;Lh=r[Kh|0]|r[Kh+1|0]<<8|(r[Kh+2|0]<<16|r[Kh+3|0]<<24);q[Jh+16>>2]=Oh;q[Jh+20>>2]=Nh;if(!Lh|Lh&3){break a}Mh=Ph;Kh=Lh;Rh=Mh-Oh>>>0>=Kh>>>0?0:1;Mh=Qh-(Nh+(Mh>>>0<Oh>>>0)|0)|0;if((Mh|0)<0?1:(Mh|0)<=0?Rh:0){break a}Mh=Lh>>>2;if(Mh){Fa(a,Mh);Ph=q[Jh+8>>2];Qh=q[Jh+12>>2];Oh=q[Jh+16>>2];Nh=q[Jh+20>>2]}Mh=Kh+Oh|0;if(Mh>>>0<Kh>>>0){Nh=Nh+1|0}if((Qh|0)<(Nh|0)?1:(Qh|0)<=(Nh|0)?Ph>>>0>=Mh>>>0?0:1:0){break a}Cn(q[a>>2],Oh+q[Jh>>2]|0,Lh);Nh=Jh;Ph=Jh;Lh=q[Jh+20>>2];Jh=Kh+q[Jh+16>>2]|0;if(Jh>>>0<Kh>>>0){Lh=Lh+1|0}q[Ph+16>>2]=Jh;q[Nh+20>>2]=Lh;q[a+16>>2]=0;q[a+12>>2]=q[a>>2];Sh=1}return Sh}function ah(a){q[a>>2]=0;q[a+4>>2]=0;o[a+5|0]=0;o[a+6|0]=0;o[a+7|0]=0;o[a+8|0]=0;o[a+9|0]=0;o[a+10|0]=0;o[a+11|0]=0;o[a+12|0]=0;return a}function bh(a,Jh){var Th=0,Uh=0,Vh=0,Wh=0,Xh=0,Yh=0,Zh=0,_h=0,$h=0,ai=0,bi=0;_h=T-16|0;T=_h;Wh=q[Jh+16>>2];Th=q[Jh+12>>2];Uh=q[Jh+20>>2];a:{if((Th|0)<(Uh|0)?1:(Th|0)<=(Uh|0)?t[Jh+8>>2]>Wh>>>0?0:1:0){break a}o[a+12|0]=r[Wh+q[Jh>>2]|0];Th=q[Jh+20>>2];Wh=Th;Xh=q[Jh+16>>2];Yh=Xh+1|0;if(Yh>>>0<1){Th=Th+1|0}Vh=Yh;q[Jh+16>>2]=Vh;q[Jh+20>>2]=Th;b:{if(s[Jh+38>>1]<=513){Zh=q[Jh+12>>2];$h=Zh;Uh=Wh;Th=Xh+5|0;if(Th>>>0<5){Uh=Uh+1|0}Yh=q[Jh+8>>2];Xh=Th;Th=Uh;if(($h|0)<(Th|0)?1:($h|0)<=(Th|0)?Yh>>>0>=Xh>>>0?0:1:0){break a}Uh=Vh+q[Jh>>2]|0;Vh=r[Uh|0]|r[Uh+1|0]<<8|(r[Uh+2|0]<<16|r[Uh+3|0]<<24);q[_h+12>>2]=Vh;q[Jh+16>>2]=Xh;q[Jh+20>>2]=Th;break b}if(!ch(1,_h+12|0,Jh)){break a}Xh=q[Jh+16>>2];Th=q[Jh+20>>2];Yh=q[Jh+8>>2];Zh=q[Jh+12>>2];Vh=q[_h+12>>2]}Uh=Vh;Wh=Zh-(Th+(Yh>>>0<Xh>>>0)|0)|0;if(((Wh|0)<0?1:(Wh|0)<=0?Yh-Xh>>>0>=Uh>>>0?0:1:0)|(Uh|0)<1){break a}Wh=Xh+q[Jh>>2]|0;q[a>>2]=Wh;Zh=Vh+ -1|0;$h=Zh+Wh|0;Yh=r[$h|0]>>>6;if((Yh|0)==3){break a}ai=a;c:{d:{switch(Yh-1|0){default:q[a+4>>2]=Zh;a=r[$h|0]&63;break c;case 0:if((Vh|0)<2){break a}q[a+4>>2]=Vh+ -2;a=(Vh+Wh|0)+ -2|0;a=r[a+1|0]<<8&16128|r[a|0];break c;case 1:break d}}if((Vh|0)<3){break a}q[a+4>>2]=Vh+ -3;a=(Vh+Wh|0)+ -3|0;a=r[a+1|0]<<8|r[a+2|0]<<16&4128768|r[a|0]}a=a+4096|0;q[ai+8>>2]=a;if(a>>>0>1048575){break a}a=Uh+Xh|0;if(a>>>0<Uh>>>0){Th=Th+1|0}q[Jh+16>>2]=a;q[Jh+20>>2]=Th;bi=1}T=_h+16|0;return bi}function ch(a,Jh,ci){var di=0,ei=0,fi=0,gi=0;a:{if(a>>>0>5){break a}fi=q[ci+16>>2];di=q[ci+12>>2];ei=q[ci+20>>2];if((di|0)<(ei|0)?1:(di|0)<=(ei|0)?t[ci+8>>2]>fi>>>0?0:1:0){break a}di=r[fi+q[ci>>2]|0];fi=fi+1|0;if(fi>>>0<1){ei=ei+1|0}q[ci+16>>2]=fi;q[ci+20>>2]=ei;ei=Jh;if(di&128){if(!ch(a+1|0,Jh,ci)){break a}a=q[Jh>>2]<<7;q[Jh>>2]=a;di=a|di&127}q[ei>>2]=di;gi=1}return gi}function dh(a){var Jh=0,ci=0,hi=0,ii=0,ji=0;hi=0-r[a+12|0]|0;ci=q[a+8>>2];a:{if(ci>>>0>4095){break a}Jh=q[a+4>>2];if((Jh|0)<1){break a}Jh=Jh+ -1|0;q[a+4>>2]=Jh;ci=r[Jh+q[a>>2]|0]|ci<<8;q[a+8>>2]=ci}hi=hi&255;Jh=w(hi,ci>>>8);ii=ci&255;ji=ii>>>0<hi>>>0;q[a+8>>2]=ji?Jh+ii|0:(ci-hi|0)-Jh|0;return ji}function eh(a,ki,li){var mi=0,ni=0,oi=0,pi=0,qi=0,ri=0;if(!ki){q[li>>2]=0;return}pi=0-r[a+12|0]&255;ni=q[a+8>>2];while(1){qi=mi<<1;a:{if(ni>>>0>4095){break a}mi=q[a+4>>2];if((mi|0)<1){break a}mi=mi+ -1|0;q[a+4>>2]=mi;ni=r[mi+q[a>>2]|0]|ni<<8;q[a+8>>2]=ni}oi=ni&255;mi=oi>>>0<pi>>>0;ri=oi;oi=w(ni>>>8,pi);ni=mi?ri+oi|0:(ni-pi|0)-oi|0;q[a+8>>2]=ni;mi=mi|qi;ki=ki+ -1|0;if(ki){continue}break}q[li>>2]=mi}function fh(a,ki){var li=0,si=0,ti=0;ti=T-32|0;T=ti;a:{if(ki>>>0<=1){if(ki-1){li=Mm(44);ki=li;q[ki>>2]=0;q[ki+4>>2]=0;q[ki+40>>2]=0;q[ki+32>>2]=0;q[ki+36>>2]=0;q[ki+24>>2]=0;q[ki+28>>2]=0;q[ki+16>>2]=0;q[ki+20>>2]=0;q[ki+8>>2]=0;q[ki+12>>2]=0;Ij(ki);q[ki>>2]=13760;q[a+8>>2]=0;q[a+12>>2]=0;q[a>>2]=0;q[a+4>>2]=0;q[a+16>>2]=ki;break a}li=Mm(44);ki=li;q[ki>>2]=0;q[ki+4>>2]=0;q[ki+40>>2]=0;q[ki+32>>2]=0;q[ki+36>>2]=0;q[ki+24>>2]=0;q[ki+28>>2]=0;q[ki+16>>2]=0;q[ki+20>>2]=0;q[ki+8>>2]=0;q[ki+12>>2]=0;Ij(ki);q[ki>>2]=13668;q[a+8>>2]=0;q[a+12>>2]=0;q[a>>2]=0;q[a+4>>2]=0;q[a+16>>2]=ki;break a}ki=Mm(32);q[ti>>2]=ki;q[ti+4>>2]=28;q[ti+8>>2]=-2147483616;o[ki+28|0]=0;li=r[10912]|r[10913]<<8|(r[10914]<<16|r[10915]<<24);o[ki+24|0]=li;o[ki+25|0]=li>>>8;o[ki+26|0]=li>>>16;o[ki+27|0]=li>>>24;li=r[10908]|r[10909]<<8|(r[10910]<<16|r[10911]<<24);si=r[10904]|r[10905]<<8|(r[10906]<<16|r[10907]<<24);o[ki+16|0]=si;o[ki+17|0]=si>>>8;o[ki+18|0]=si>>>16;o[ki+19|0]=si>>>24;o[ki+20|0]=li;o[ki+21|0]=li>>>8;o[ki+22|0]=li>>>16;o[ki+23|0]=li>>>24;li=r[10900]|r[10901]<<8|(r[10902]<<16|r[10903]<<24);si=r[10896]|r[10897]<<8|(r[10898]<<16|r[10899]<<24);o[ki+8|0]=si;o[ki+9|0]=si>>>8;o[ki+10|0]=si>>>16;o[ki+11|0]=si>>>24;o[ki+12|0]=li;o[ki+13|0]=li>>>8;o[ki+14|0]=li>>>16;o[ki+15|0]=li>>>24;li=r[10892]|r[10893]<<8|(r[10894]<<16|r[10895]<<24);si=r[10888]|r[10889]<<8|(r[10890]<<16|r[10891]<<24);o[ki|0]=si;o[ki+1|0]=si>>>8;o[ki+2|0]=si>>>16;o[ki+3|0]=si>>>24;o[ki+4|0]=li;o[ki+5|0]=li>>>8;o[ki+6|0]=li>>>16;o[ki+7|0]=li>>>24;q[ti+16>>2]=-1;ki=Rm(ti+16|4,ti);q[a>>2]=q[ti+16>>2];Rm(a+4|0,ki);q[a+16>>2]=0;if(o[ki+11|0]<=-1){An(q[ki>>2])}if(o[ti+11|0]>-1){break a}An(q[ti>>2])}T=ti+32|0}function gh(a,ki){var ui=0,vi=0,wi=0;wi=T-32|0;T=wi;a:{if(ki>>>0<=1){if(ki-1){ki=Mm(48);Rh(ki);q[ki>>2]=13064;q[a+8>>2]=0;q[a+12>>2]=0;q[a>>2]=0;q[a+4>>2]=0;q[a+16>>2]=ki;break a}ki=Mm(52);Rh(ki);q[ki+48>>2]=0;q[ki>>2]=11164;q[a+8>>2]=0;q[a+12>>2]=0;q[a>>2]=0;q[a+4>>2]=0;q[a+16>>2]=ki;break a}ki=Mm(32);q[wi>>2]=ki;q[wi+4>>2]=28;q[wi+8>>2]=-2147483616;o[ki+28|0]=0;ui=r[10912]|r[10913]<<8|(r[10914]<<16|r[10915]<<24);o[ki+24|0]=ui;o[ki+25|0]=ui>>>8;o[ki+26|0]=ui>>>16;o[ki+27|0]=ui>>>24;ui=r[10908]|r[10909]<<8|(r[10910]<<16|r[10911]<<24);vi=r[10904]|r[10905]<<8|(r[10906]<<16|r[10907]<<24);o[ki+16|0]=vi;o[ki+17|0]=vi>>>8;o[ki+18|0]=vi>>>16;o[ki+19|0]=vi>>>24;o[ki+20|0]=ui;o[ki+21|0]=ui>>>8;o[ki+22|0]=ui>>>16;o[ki+23|0]=ui>>>24;ui=r[10900]|r[10901]<<8|(r[10902]<<16|r[10903]<<24);vi=r[10896]|r[10897]<<8|(r[10898]<<16|r[10899]<<24);o[ki+8|0]=vi;o[ki+9|0]=vi>>>8;o[ki+10|0]=vi>>>16;o[ki+11|0]=vi>>>24;o[ki+12|0]=ui;o[ki+13|0]=ui>>>8;o[ki+14|0]=ui>>>16;o[ki+15|0]=ui>>>24;ui=r[10892]|r[10893]<<8|(r[10894]<<16|r[10895]<<24);vi=r[10888]|r[10889]<<8|(r[10890]<<16|r[10891]<<24);o[ki|0]=vi;o[ki+1|0]=vi>>>8;o[ki+2|0]=vi>>>16;o[ki+3|0]=vi>>>24;o[ki+4|0]=ui;o[ki+5|0]=ui>>>8;o[ki+6|0]=ui>>>16;o[ki+7|0]=ui>>>24;q[wi+16>>2]=-1;ki=Rm(wi+16|4,wi);q[a>>2]=q[wi+16>>2];Rm(a+4|0,ki);q[a+16>>2]=0;if(o[ki+11|0]<=-1){An(q[ki>>2])}if(o[wi+11|0]>-1){break a}An(q[wi>>2])}T=wi+32|0}function hh(a,ki){var xi=0,yi=0,zi=0;xi=T-80|0;T=xi;yi=q[ki+36>>2];q[xi+72>>2]=q[ki+32>>2];q[xi+76>>2]=yi;zi=q[ki+28>>2];yi=xi- -64|0;q[yi>>2]=q[ki+24>>2];q[yi+4>>2]=zi;yi=q[ki+20>>2];q[xi+56>>2]=q[ki+16>>2];q[xi+60>>2]=yi;yi=q[ki+12>>2];q[xi+48>>2]=q[ki+8>>2];q[xi+52>>2]=yi;yi=q[ki+4>>2];q[xi+40>>2]=q[ki>>2];q[xi+44>>2]=yi;Jj(xi+8|0,xi+40|0,xi+24|0);ki=q[xi+8>>2];a:{if(ki){q[a>>2]=ki;Rm(a+4|0,xi+8|4);if(o[xi+23|0]>=0){break a}An(q[xi+12>>2]);break a}if(o[xi+23|0]<=-1){An(q[xi+12>>2])}ki=r[xi+31|0];q[a>>2]=0;q[a+4>>2]=0;q[a+16>>2]=ki;q[a+8>>2]=0;q[a+12>>2]=0}T=xi+80|0}function ih(a,ki,Ai,Bi){var Ci=0,Di=0,Ei=0;Ci=T-80|0;T=Ci;Di=q[Ai+36>>2];q[Ci+72>>2]=q[Ai+32>>2];q[Ci+76>>2]=Di;Ei=q[Ai+28>>2];Di=Ci- -64|0;q[Di>>2]=q[Ai+24>>2];q[Di+4>>2]=Ei;Di=q[Ai+20>>2];q[Ci+56>>2]=q[Ai+16>>2];q[Ci+60>>2]=Di;Di=q[Ai+12>>2];q[Ci+48>>2]=q[Ai+8>>2];q[Ci+52>>2]=Di;Di=q[Ai+4>>2];q[Ci+40>>2]=q[Ai>>2];q[Ci+44>>2]=Di;Jj(a,Ci+40|0,Ci+24|0);a:{if(q[a>>2]){break a}Ei=a+4|0;if(o[a+15|0]<=-1){An(q[Ei>>2])}if(r[Ci+31|0]){q[Ci+8>>2]=0;q[Ci>>2]=0;q[Ci+4>>2]=0;ki=Mm(32);q[Ci>>2]=ki;q[Ci+4>>2]=27;q[Ci+8>>2]=-2147483616;o[ki+27|0]=0;Ai=r[10940]|r[10941]<<8|(r[10942]<<16|r[10943]<<24);o[ki+23|0]=Ai;o[ki+24|0]=Ai>>>8;o[ki+25|0]=Ai>>>16;o[ki+26|0]=Ai>>>24;Ai=r[10937]|r[10938]<<8|(r[10939]<<16|r[10940]<<24);Bi=r[10933]|r[10934]<<8|(r[10935]<<16|r[10936]<<24);o[ki+16|0]=Bi;o[ki+17|0]=Bi>>>8;o[ki+18|0]=Bi>>>16;o[ki+19|0]=Bi>>>24;o[ki+20|0]=Ai;o[ki+21|0]=Ai>>>8;o[ki+22|0]=Ai>>>16;o[ki+23|0]=Ai>>>24;Ai=r[10929]|r[10930]<<8|(r[10931]<<16|r[10932]<<24);Bi=r[10925]|r[10926]<<8|(r[10927]<<16|r[10928]<<24);o[ki+8|0]=Bi;o[ki+9|0]=Bi>>>8;o[ki+10|0]=Bi>>>16;o[ki+11|0]=Bi>>>24;o[ki+12|0]=Ai;o[ki+13|0]=Ai>>>8;o[ki+14|0]=Ai>>>16;o[ki+15|0]=Ai>>>24;Ai=r[10921]|r[10922]<<8|(r[10923]<<16|r[10924]<<24);Bi=r[10917]|r[10918]<<8|(r[10919]<<16|r[10920]<<24);o[ki|0]=Bi;o[ki+1|0]=Bi>>>8;o[ki+2|0]=Bi>>>16;o[ki+3|0]=Bi>>>24;o[ki+4|0]=Ai;o[ki+5|0]=Ai>>>8;o[ki+6|0]=Ai>>>16;o[ki+7|0]=Ai>>>24;q[a>>2]=-1;Rm(Ei,Ci);if(o[Ci+11|0]>-1){break a}An(q[Ci>>2]);break a}fh(Ci,o[Ci+32|0]);Di=q[Ci>>2];b:{if(Di){q[a>>2]=Di;Rm(Ei,Ci|4);break b}Di=q[Ci+16>>2];q[Ci+16>>2]=0;Mj(a,Di,ki,Ai,Bi);if(!q[a>>2]){if(o[Ei+11|0]<=-1){An(q[Ei>>2])}q[a>>2]=0;q[a+4>>2]=0;q[a+8>>2]=0;q[a+12>>2]=0}if(!Di){break b}n[q[q[Di>>2]+4>>2]](Di)}a=q[Ci+16>>2];q[Ci+16>>2]=0;if(a){n[q[q[a>>2]+4>>2]](a)}if(o[Ci+15|0]>-1){break a}An(q[Ci+4>>2])}T=Ci+80|0}function jh(a,ki,Ai,Bi){var Fi=0,Gi=0,Hi=0;Fi=T-80|0;T=Fi;Gi=q[Ai+36>>2];q[Fi+72>>2]=q[Ai+32>>2];q[Fi+76>>2]=Gi;Hi=q[Ai+28>>2];Gi=Fi- -64|0;q[Gi>>2]=q[Ai+24>>2];q[Gi+4>>2]=Hi;Gi=q[Ai+20>>2];q[Fi+56>>2]=q[Ai+16>>2];q[Fi+60>>2]=Gi;Gi=q[Ai+12>>2];q[Fi+48>>2]=q[Ai+8>>2];q[Fi+52>>2]=Gi;Gi=q[Ai+4>>2];q[Fi+40>>2]=q[Ai>>2];q[Fi+44>>2]=Gi;Jj(a,Fi+40|0,Fi+24|0);a:{if(q[a>>2]){break a}Gi=a+4|0;if(o[a+15|0]<=-1){An(q[Gi>>2])}if(r[Fi+31|0]!=1){q[Fi+8>>2]=0;q[Fi>>2]=0;q[Fi+4>>2]=0;ki=Mm(32);q[Fi>>2]=ki;q[Fi+4>>2]=20;q[Fi+8>>2]=-2147483616;o[ki+20|0]=0;Ai=r[10961]|r[10962]<<8|(r[10963]<<16|r[10964]<<24);o[ki+16|0]=Ai;o[ki+17|0]=Ai>>>8;o[ki+18|0]=Ai>>>16;o[ki+19|0]=Ai>>>24;Ai=r[10957]|r[10958]<<8|(r[10959]<<16|r[10960]<<24);Bi=r[10953]|r[10954]<<8|(r[10955]<<16|r[10956]<<24);o[ki+8|0]=Bi;o[ki+9|0]=Bi>>>8;o[ki+10|0]=Bi>>>16;o[ki+11|0]=Bi>>>24;o[ki+12|0]=Ai;o[ki+13|0]=Ai>>>8;o[ki+14|0]=Ai>>>16;o[ki+15|0]=Ai>>>24;Ai=r[10949]|r[10950]<<8|(r[10951]<<16|r[10952]<<24);Bi=r[10945]|r[10946]<<8|(r[10947]<<16|r[10948]<<24);o[ki|0]=Bi;o[ki+1|0]=Bi>>>8;o[ki+2|0]=Bi>>>16;o[ki+3|0]=Bi>>>24;o[ki+4|0]=Ai;o[ki+5|0]=Ai>>>8;o[ki+6|0]=Ai>>>16;o[ki+7|0]=Ai>>>24;q[a>>2]=-1;Rm(Gi,Fi);if(o[Fi+11|0]>-1){break a}An(q[Fi>>2]);break a}gh(Fi,r[Fi+32|0]);Hi=q[Fi>>2];b:{if(Hi){q[a>>2]=Hi;Rm(Gi,Fi|4);break b}Hi=q[Fi+16>>2];q[Fi+16>>2]=0;q[Hi+44>>2]=Bi;Mj(a,Hi,ki,Ai,Bi);if(!q[a>>2]){if(o[Gi+11|0]<=-1){An(q[Gi>>2])}q[a>>2]=0;q[a+4>>2]=0;q[a+8>>2]=0;q[a+12>>2]=0}if(!Hi){break b}n[q[q[Hi>>2]+4>>2]](Hi)}a=q[Fi+16>>2];q[Fi+16>>2]=0;if(a){n[q[q[a>>2]+4>>2]](a)}if(o[Fi+15|0]>-1){break a}An(q[Fi+4>>2])}T=Fi+80|0}function kh(a,ki){var Ai=0,Bi=0,Ii=0;Ii=T-16|0;T=Ii;q[Ii+12>>2]=ki;ki=Mm(32);q[Ii>>2]=ki;q[Ii+4>>2]=24;q[Ii+8>>2]=-2147483616;o[ki+24|0]=0;Ai=r[10986]|r[10987]<<8|(r[10988]<<16|r[10989]<<24);Bi=r[10982]|r[10983]<<8|(r[10984]<<16|r[10985]<<24);o[ki+16|0]=Bi;o[ki+17|0]=Bi>>>8;o[ki+18|0]=Bi>>>16;o[ki+19|0]=Bi>>>24;o[ki+20|0]=Ai;o[ki+21|0]=Ai>>>8;o[ki+22|0]=Ai>>>16;o[ki+23|0]=Ai>>>24;Ai=r[10978]|r[10979]<<8|(r[10980]<<16|r[10981]<<24);Bi=r[10974]|r[10975]<<8|(r[10976]<<16|r[10977]<<24);o[ki+8|0]=Bi;o[ki+9|0]=Bi>>>8;o[ki+10|0]=Bi>>>16;o[ki+11|0]=Bi>>>24;o[ki+12|0]=Ai;o[ki+13|0]=Ai>>>8;o[ki+14|0]=Ai>>>16;o[ki+15|0]=Ai>>>24;Ai=r[10970]|r[10971]<<8|(r[10972]<<16|r[10973]<<24);Bi=r[10966]|r[10967]<<8|(r[10968]<<16|r[10969]<<24);o[ki|0]=Bi;o[ki+1|0]=Bi>>>8;o[ki+2|0]=Bi>>>16;o[ki+3|0]=Bi>>>24;o[ki+4|0]=Ai;o[ki+5|0]=Ai>>>8;o[ki+6|0]=Ai>>>16;o[ki+7|0]=Ai>>>24;ek(lh(a,Ii+12|0),Ii);if(o[Ii+11|0]<=-1){An(q[Ii>>2])}T=Ii+16|0}function lh(a,ki){var Ji=0,Ki=0,Li=0,Mi=0,Ni=0,Oi=0,Pi=0,Qi=0;Li=T-32|0;T=Li;Mi=a+16|0;Ki=q[Mi>>2];a:{b:{if(!Ki){break b}Oi=q[ki>>2];Ji=Mi;while(1){Ni=q[Ki+16>>2]<(Oi|0);Ji=Ni?Ji:Ki;Ki=q[(Ni<<2)+Ki>>2];if(Ki){continue}break}if((Ji|0)==(Mi|0)){break b}if((Oi|0)>=q[Ji+16>>2]){break a}}Oi=ck(Li+16|0);ki=q[ki>>2];Ni=Li+8|0;q[Ni>>2]=0;q[Ni+4>>2]=0;q[Li>>2]=ki;q[Li+4>>2]=Ni;Ji=q[Oi>>2];Pi=Oi+4|0;if((Ji|0)!=(Pi|0)){Qi=Li|4;while(1){ki=Ji;Ki=Ji+16|0;mh(Qi,Ni,Ki,Ki);Ki=q[Ji+4>>2];c:{if(!Ki){Ji=q[ki+8>>2];if((ki|0)==q[Ji>>2]){break c}ki=ki+8|0;while(1){Ki=q[ki>>2];ki=Ki+8|0;Ji=q[Ki+8>>2];if((Ki|0)!=q[Ji>>2]){continue}break}break c}while(1){Ji=Ki;Ki=q[Ji>>2];if(Ki){continue}break}}if((Ji|0)!=(Pi|0)){continue}break}}ki=a+16|0;Ki=q[ki>>2];d:{if(Ki){Mi=q[Li>>2];while(1){Ji=q[Ki+16>>2];e:{if((Mi|0)<(Ji|0)){Ji=q[Ki>>2];if(Ji){break e}ki=Ki;break d}if((Ji|0)>=(Mi|0)){break d}ki=Ki+4|0;Ji=q[Ki+4>>2];if(!Ji){break d}Ki=ki}ki=Ki;Ki=Ji;continue}}Ki=Mi;ki=Ki}Ji=q[ki>>2];if(!Ji){Ji=Mm(32);q[Ji+16>>2]=q[Li>>2];q[Ji+20>>2]=q[Li+4>>2];Mi=Ji+24|0;Pi=q[Li+8>>2];q[Mi>>2]=Pi;Qi=q[Li+12>>2];q[Ji+28>>2]=Qi;f:{if(!Qi){q[Ji+20>>2]=Mi;break f}q[Pi+8>>2]=Mi;q[Li+8>>2]=0;q[Li+12>>2]=0;q[Li+4>>2]=Ni}q[Ji+8>>2]=Ki;q[Ji>>2]=0;q[Ji+4>>2]=0;q[ki>>2]=Ji;Mi=q[q[a+12>>2]>>2];Ki=Ji;g:{if(!Mi){break g}q[a+12>>2]=Mi;Ki=q[ki>>2]}nh(q[a+16>>2],Ki);a=a+20|0;q[a>>2]=q[a>>2]+1}Cc(Li|4,q[Li+8>>2]);Cc(Oi,q[Oi+4>>2])}T=Li+32|0;return Ji+20|0}function mh(a,ki,Ri,Si){var Ti=0;Ti=T-16|0;T=Ti;Ri=oh(a,ki,Ti+12|0,Ti+8|0,Ri);if(!q[Ri>>2]){ki=Mm(40);Rm(ki+16|0,Si);Rm(ki+28|0,Si+12|0);q[ki+8>>2]=q[Ti+12>>2];q[ki>>2]=0;q[ki+4>>2]=0;q[Ri>>2]=ki;Si=ki;ki=q[q[a>>2]>>2];if(ki){q[a>>2]=ki;Si=q[Ri>>2]}nh(q[a+4>>2],Si);a=a+8|0;q[a>>2]=q[a>>2]+1}T=Ti+16|0}function nh(a,ki){var Ri=0,Si=0,Ui=0;Ri=(a|0)==(ki|0);o[ki+12|0]=Ri;a:{if(Ri){break a}while(1){Si=q[ki+8>>2];if(r[Si+12|0]){break a}b:{Ri=q[Si+8>>2];Ui=q[Ri>>2];if((Ui|0)==(Si|0)){Ui=q[Ri+4>>2];if(!(!Ui|r[Ui+12|0])){break b}c:{if(q[Si>>2]==(ki|0)){ki=Si;break c}ki=q[Si+4>>2];Ui=q[ki>>2];q[Si+4>>2]=Ui;a=ki;if(Ui){q[Ui+8>>2]=Si;Ri=q[Si+8>>2]}q[a+8>>2]=Ri;a=q[Si+8>>2];q[((Si|0)==q[a>>2]?a:a+4|0)>>2]=ki;q[ki>>2]=Si;q[Si+8>>2]=ki;Ri=q[ki+8>>2]}o[ki+12|0]=1;o[Ri+12|0]=0;a=q[Ri>>2];ki=q[a+4>>2];q[Ri>>2]=ki;if(ki){q[ki+8>>2]=Ri}q[a+8>>2]=q[Ri+8>>2];ki=q[Ri+8>>2];q[(q[ki>>2]==(Ri|0)?ki:ki+4|0)>>2]=a;q[a+4>>2]=Ri;q[Ri+8>>2]=a;return}if(!(r[Ui+12|0]|!Ui)){break b}d:{if(q[Si>>2]!=(ki|0)){ki=Si;break d}Ui=q[ki+4>>2];q[Si>>2]=Ui;a=ki;if(Ui){q[Ui+8>>2]=Si;Ri=q[Si+8>>2]}q[a+8>>2]=Ri;a=q[Si+8>>2];q[((Si|0)==q[a>>2]?a:a+4|0)>>2]=ki;q[ki+4>>2]=Si;q[Si+8>>2]=ki;Ri=q[ki+8>>2]}o[ki+12|0]=1;o[Ri+12|0]=0;a=q[Ri+4>>2];ki=q[a>>2];q[Ri+4>>2]=ki;if(ki){q[ki+8>>2]=Ri}q[a+8>>2]=q[Ri+8>>2];ki=q[Ri+8>>2];q[(q[ki>>2]==(Ri|0)?ki:ki+4|0)>>2]=a;q[a>>2]=Ri;q[Ri+8>>2]=a;break a}ki=Ui+12|0;o[Si+12|0]=1;o[Ri+12|0]=(a|0)==(Ri|0);o[ki|0]=1;ki=Ri;if((ki|0)!=(a|0)){continue}break}}}function oh(a,ki,Vi,Wi,Xi){var Yi=0,Zi=0,_i=0,$i=0,aj=0,bj=0,cj=0,dj=0,ej=0,fj=0,gj=0;a:{b:{c:{d:{e:{ej=a+4|0;f:{if((ej|0)==(ki|0)){break f}Yi=ki+16|0;_i=r[ki+27|0];fj=_i<<24>>24;Zi=(fj|0)<0;$i=r[Xi+11|0];aj=$i<<24>>24;bj=(aj|0)<0;cj=Zi?q[ki+20>>2]:_i;$i=bj?q[Xi+4>>2]:$i;dj=cj>>>0<$i>>>0;g:{_i=dj?cj:$i;if(_i){bj=bj?q[Xi>>2]:Xi;Zi=Zi?q[Yi>>2]:Yi;gj=cm(bj,Zi,_i);if(gj){break g}}if($i>>>0<cj>>>0){break f}if(!_i){break d}bj=(aj|0)<0?q[Xi>>2]:Xi;Zi=(fj|0)<0?q[Yi>>2]:Yi;break e}if((gj|0)>-1){break e}}_i=q[ki>>2];h:{i:{if(q[a>>2]==(ki|0)){Yi=ki;break i}j:{if(!_i){Wi=ki;while(1){Yi=q[Wi+8>>2];$i=q[Yi>>2]==(Wi|0);Wi=Yi;if($i){continue}break}break j}Wi=_i;while(1){Yi=Wi;Wi=q[Yi+4>>2];if(Wi){continue}break}}Zi=r[Xi+11|0];Wi=Zi<<24>>24<0;aj=r[Yi+27|0];$i=aj<<24>>24<0;k:{Zi=Wi?q[Xi+4>>2]:Zi;aj=$i?q[Yi+20>>2]:aj;bj=Zi>>>0<aj>>>0?Zi:aj;if(bj){cj=Yi+16|0;Wi=cm($i?q[cj>>2]:cj,Wi?q[Xi>>2]:Xi,bj);if(Wi){break k}}if(aj>>>0<Zi>>>0){break i}break h}if((Wi|0)>-1){break h}}if(!_i){q[Vi>>2]=ki;return ki}q[Vi>>2]=Yi;return Yi+4|0}return ph(a,Vi,Xi)}Yi=cm(Zi,bj,_i);if(Yi){break c}}if(dj){break b}break a}if((Yi|0)>-1){break a}}bj=ki+4|0;_i=q[bj>>2];l:{if(_i){Yi=_i;while(1){Wi=Yi;Yi=q[Yi>>2];if(Yi){continue}break}break l}Wi=q[ki+8>>2];if(q[Wi>>2]==(ki|0)){break l}Yi=ki+8|0;while(1){Zi=q[Yi>>2];Yi=Zi+8|0;Wi=q[Zi+8>>2];if((Zi|0)!=q[Wi>>2]){continue}break}}m:{n:{if((Wi|0)==(ej|0)){break n}Zi=r[Wi+27|0];Yi=Zi<<24>>24<0;o:{Zi=Yi?q[Wi+20>>2]:Zi;cj=Zi>>>0<$i>>>0?Zi:$i;if(cj){dj=(aj|0)<0?q[Xi>>2]:Xi;aj=Wi+16|0;Yi=cm(dj,Yi?q[aj>>2]:aj,cj);if(Yi){break o}}if($i>>>0<Zi>>>0){break n}break m}if((Yi|0)>-1){break m}}if(!_i){q[Vi>>2]=ki;return bj}q[Vi>>2]=Wi;return Wi}return ph(a,Vi,Xi)}q[Vi>>2]=ki;q[Wi>>2]=ki;return Wi}function ph(a,ki,Vi){var Wi=0,Xi=0,hj=0,ij=0,jj=0,kj=0,lj=0,mj=0,nj=0;a:{Wi=a+4|0;a=q[Wi>>2];if(a){hj=r[Vi+11|0];ij=hj<<24>>24<0;hj=ij?q[Vi+4>>2]:hj;lj=ij?q[Vi>>2]:Vi;while(1){Vi=a+16|0;Xi=r[a+27|0];ij=Xi<<24>>24<0;jj=ij?q[a+20>>2]:Xi;mj=jj>>>0<hj>>>0;b:{c:{d:{e:{f:{g:{h:{Xi=mj?jj:hj;if(Xi){kj=ij?q[Vi>>2]:Vi;nj=cm(lj,kj,Xi);if(nj){break h}}if(hj>>>0<jj>>>0){break g}if(!Xi){break e}kj=ij?q[Vi>>2]:Vi;break f}if((nj|0)>-1){break f}}Vi=q[a>>2];if(Vi){break b}q[ki>>2]=a;return a}Vi=cm(kj,lj,Xi);if(Vi){break d}}if(mj){break c}break a}if((Vi|0)>-1){break a}}Wi=a+4|0;Vi=q[a+4>>2];if(!Vi){break a}a=Wi}Wi=a;a=Vi;continue}}q[ki>>2]=Wi;return Wi}q[ki>>2]=a;return Wi}function qh(a,ki,Vi,oj){var pj=0,qj=0,rj=0,sj=0,tj=0;if(!a){return 1}pj=q[Vi+16>>2];sj=q[Vi+12>>2];rj=q[Vi+20>>2];qj=rj;a:{if((sj|0)<(qj|0)?1:(sj|0)<=(qj|0)?t[Vi+8>>2]>pj>>>0?0:1:0){break a}qj=r[pj+q[Vi>>2]|0];pj=pj+1|0;if(pj>>>0<1){rj=rj+1|0}q[Vi+16>>2]=pj;q[Vi+20>>2]=rj;if(qj>>>0>1){break a}if(qj-1){return rh(a,ki,Vi,oj)}tj=sh(a,Vi,oj)}return tj}function rh(a,ki,Vi,oj){var uj=0,vj=0,wj=0,xj=0,yj=0,zj=0,Aj=0,Bj=0,Cj=0,Dj=0,Ej=0,Fj=0,Gj=0,Hj=0,Ij=0,Jj=0;uj=T+ -64|0;T=uj;q[uj+56>>2]=0;q[uj+48>>2]=0;q[uj+52>>2]=0;q[uj+40>>2]=0;q[uj+44>>2]=0;q[uj+32>>2]=0;q[uj+36>>2]=0;q[uj+24>>2]=0;q[uj+28>>2]=0;q[uj+16>>2]=0;q[uj+20>>2]=0;q[uj+8>>2]=0;q[uj+12>>2]=0;a:{if(!th(uj+8|0,Vi)){break a}if(!uh(uj+8|0,Vi)|(q[uj+20>>2]?0:a)){break a}_j(Vi,0,0);if(a){xj=q[uj+56>>2];Fj=q[uj+36>>2];Gj=q[uj+48>>2];Hj=q[uj+24>>2];while(1){b:{if(xj>>>0>16383){break b}vj=q[uj+52>>2];while(1){if((vj|0)<1){break b}vj=vj+ -1|0;q[uj+52>>2]=vj;xj=r[vj+Gj|0]|xj<<8;q[uj+56>>2]=xj;if(xj>>>0<16384){continue}break}}wj=xj&4095;Dj=q[(wj<<2)+Hj>>2];yj=(Dj<<3)+Fj|0;xj=(w(q[yj>>2],xj>>>12)+wj|0)-q[yj+4>>2]|0;q[uj+56>>2]=xj;if((ki|0)>=1){if(!r[Vi+36|0]){wj=0;break a}yj=ki+zj|0;while(1){c:{if((Dj|0)<1){Bj=0;break c}wj=q[Vi+32>>2];Ij=q[Vi+28>>2];Jj=q[Vi+24>>2];vj=0;Bj=0;while(1){Aj=(wj>>>3)+Jj|0;d:{if(Aj>>>0>=Ij>>>0){Cj=0;break d}Cj=r[Aj|0];Aj=wj+1|0;q[Vi+32>>2]=Aj;Cj=Cj>>>(wj&7)&1;wj=Aj}Bj=Cj<<vj|Bj;vj=vj+1|0;if((Dj|0)!=(vj|0)){continue}break}}q[(zj<<2)+oj>>2]=Bj;zj=zj+1|0;if((yj|0)!=(zj|0)){continue}break}zj=yj}Ej=ki+Ej|0;if(Ej>>>0<a>>>0){continue}break}}ak(Vi);wj=1}a=q[uj+36>>2];if(a){q[uj+40>>2]=a;An(a)}a=q[uj+24>>2];if(a){q[uj+28>>2]=a;An(a)}a=q[uj+8>>2];if(a){q[uj+12>>2]=a;An(a)}T=uj- -64|0;return wj}function sh(a,ki,Vi){var oj=0,Kj=0,Lj=0,Mj=0;a:{b:{Kj=q[ki+16>>2];Lj=q[ki+12>>2];oj=q[ki+20>>2];c:{if((Lj|0)<(oj|0)?1:(Lj|0)<=(oj|0)?t[ki+8>>2]>Kj>>>0?0:1:0){break c}Lj=r[Kj+q[ki>>2]|0];Kj=Kj+1|0;if(Kj>>>0<1){oj=oj+1|0}q[ki+16>>2]=Kj;q[ki+20>>2]=oj;oj=Lj+ -1|0;if(oj>>>0>17){break c}d:{e:{switch(oj-1|0){case 7:return wh(a,ki,Vi);case 8:return xh(a,ki,Vi);case 9:return yh(a,ki,Vi);case 10:return zh(a,ki,Vi);case 12:case 13:case 14:case 15:break a;case 16:break d;case 11:break e;default:break b}}return Ah(a,ki,Vi)}Mj=Bh(a,ki,Vi)}return Mj}return vh(a,ki,Vi)}return Bh(a,ki,Vi)}function th(a,ki){var Vi=0,Nj=0,Oj=0,Pj=0,Qj=0,Rj=0,Sj=0,Tj=0,Uj=0,Vj=0,Wj=0,Xj=0,Yj=0;a:{Vi=s[ki+38>>1];if(!Vi){break a}Sj=a+12|0;b:{if(Vi>>>0<=511){Nj=q[ki+12>>2];Vi=q[ki+20>>2];Oj=q[ki+16>>2];Qj=Oj+4|0;if(Qj>>>0<4){Vi=Vi+1|0}if((Nj|0)<(Vi|0)?1:(Nj|0)<=(Vi|0)?t[ki+8>>2]>=Qj>>>0?0:1:0){break a}Vi=Oj+q[ki>>2]|0;Oj=r[Vi|0]|r[Vi+1|0]<<8|(r[Vi+2|0]<<16|r[Vi+3|0]<<24);q[Sj>>2]=Oj;Nj=q[ki+20>>2];Qj=q[ki+16>>2]+4|0;if(Qj>>>0<4){Nj=Nj+1|0}Vi=ki;q[Vi+16>>2]=Qj;q[Vi+20>>2]=Nj;break b}if(!Ch(1,Sj,ki)){break a}Oj=q[Sj>>2]}Nj=q[a>>2];Vi=q[a+4>>2]-Nj>>2;c:{if(Oj>>>0>Vi>>>0){Fa(a,Oj-Vi|0);Oj=q[a+12>>2];break c}if(Oj>>>0>=Vi>>>0){break c}q[a+4>>2]=Nj+(Oj<<2)}if(!Oj){Yj=1;break a}Wj=q[ki+8>>2];Qj=q[ki+12>>2];while(1){Pj=q[ki+16>>2];Vi=q[ki+20>>2];if((Qj|0)<(Vi|0)?1:(Qj|0)<=(Vi|0)?Wj>>>0>Pj>>>0?0:1:0){break a}Xj=q[ki>>2];Tj=r[Xj+Pj|0];Pj=Pj+1|0;if(Pj>>>0<1){Vi=Vi+1|0}q[ki+16>>2]=Pj;q[ki+20>>2]=Vi;Uj=Tj>>>2;d:{e:{f:{Vj=Tj&3;if(Vj>>>0>3){Nj=0;break f}Nj=0;g:{switch(Vj-1|0){case 0:case 1:break f;case 2:break g;default:break e}}Vi=Rj+Uj|0;if(Vi>>>0>=Oj>>>0){return 0}Dn(q[a>>2]+(Rj<<2)|0,0,(Tj&252)+4|0);Rj=Vi;break d}while(1){if((Qj|0)<(Vi|0)?1:(Qj|0)<=(Vi|0)?Wj>>>0>Pj>>>0?0:1:0){return 0}Tj=r[Pj+Xj|0];Pj=Pj+1|0;if(Pj>>>0<1){Vi=Vi+1|0}q[ki+16>>2]=Pj;q[ki+20>>2]=Vi;Uj=Tj<<(Nj<<3|6)|Uj;Nj=Nj+1|0;if((Vj|0)!=(Nj|0)){continue}break}}q[q[a>>2]+(Rj<<2)>>2]=Uj}Rj=Rj+1|0;Oj=q[Sj>>2];if(Rj>>>0<Oj>>>0){continue}break}Rj=a+16|0;Sj=q[a>>2];ki=q[a+16>>2];Vi=q[a+20>>2]-ki|0;Nj=Vi>>2;h:{if(Nj>>>0<=4095){Fa(Rj,4096-Nj|0);break h}if((Vi|0)==16384){break h}q[a+20>>2]=ki+16384}i:{ki=a+28|0;Vi=q[ki>>2];Nj=q[a+32>>2]-Vi>>3;if(Oj>>>0>Nj>>>0){Dh(ki,Oj-Nj|0);Vi=q[ki>>2];break i}if(Oj>>>0<Nj>>>0){q[a+32>>2]=(Oj<<3)+Vi}if(Oj){break i}return 0}ki=0;Nj=0;while(1){a=Sj+(ki<<2)|0;Qj=q[a>>2];Pj=(ki<<3)+Vi|0;q[Pj+4>>2]=Nj;q[Pj>>2]=Qj;a=q[a>>2]+Nj|0;if(a>>>0>4096){break a}if(Nj>>>0<a>>>0){Qj=q[Rj>>2];while(1){q[Qj+(Nj<<2)>>2]=ki;Nj=Nj+1|0;if((a|0)!=(Nj|0)){continue}break}}Nj=a;ki=ki+1|0;if((Oj|0)!=(ki|0)){continue}break}return(a|0)==4096}return Yj}function uh(a,ki){var Zj=0,_j=0,$j=0,ak=0,bk=0,ck=0,dk=0,ek=0,fk=0;bk=T-16|0;T=bk;a:{b:{if(s[ki+38>>1]<=511){_j=q[ki+12>>2];ek=_j;Zj=q[ki+20>>2];$j=q[ki+16>>2];ak=$j+8|0;if(ak>>>0<8){Zj=Zj+1|0}ck=q[ki+8>>2];if((_j|0)<(Zj|0)?1:(_j|0)<=(Zj|0)?ck>>>0>=ak>>>0?0:1:0){break a}_j=$j+q[ki>>2]|0;$j=r[_j+4|0]|r[_j+5|0]<<8|(r[_j+6|0]<<16|r[_j+7|0]<<24);_j=r[_j|0]|r[_j+1|0]<<8|(r[_j+2|0]<<16|r[_j+3|0]<<24);q[bk+8>>2]=_j;q[bk+12>>2]=$j;q[ki+16>>2]=ak;q[ki+20>>2]=Zj;break b}if(!Eh(1,bk+8|0,ki)){break a}ak=q[ki+16>>2];Zj=q[ki+20>>2];ck=q[ki+8>>2];ek=q[ki+12>>2];_j=q[bk+8>>2];$j=q[bk+12>>2]}dk=ck-ak|0;ck=ek-(Zj+(ck>>>0<ak>>>0)|0)|0;if((ck|0)==($j|0)&_j>>>0>dk>>>0|$j>>>0>ck>>>0){break a}$j=Zj+$j|0;Zj=ak;dk=Zj+_j|0;if(dk>>>0<Zj>>>0){$j=$j+1|0}q[ki+16>>2]=dk;q[ki+20>>2]=$j;Zj=_j;if((Zj|0)<1){break a}ak=ak+q[ki>>2]|0;q[a+40>>2]=ak;ki=a;c:{d:{e:{f:{g:{_j=Zj+ -1|0;$j=ak+_j|0;switch((r[$j|0]>>>6)-1|0){case 2:break d;case 1:break e;case 0:break f;default:break g}}q[a+44>>2]=_j;a=r[$j|0]&63;break c}if((Zj|0)<2){break a}q[a+44>>2]=Zj+ -2;a=(Zj+ak|0)+ -2|0;a=r[a+1|0]<<8&16128|r[a|0];break c}if((Zj|0)<3){break a}q[a+44>>2]=Zj+ -3;a=(Zj+ak|0)+ -3|0;a=r[a+1|0]<<8|r[a+2|0]<<16&4128768|r[a|0];break c}q[a+44>>2]=Zj+ -4;a=(Zj+ak|0)+ -4|0;a=r[a+2|0]<<16|r[a+3|0]<<24&1056964608|r[a+1|0]<<8|r[a|0]}a=a+16384|0;q[ki+48>>2]=a;fk=a>>>0<4194304}T=bk+16|0;return fk}function vh(a,ki,gk){var hk=0,ik=0,jk=0,kk=0,lk=0,mk=0,nk=0,ok=0;hk=T+ -64|0;T=hk;q[hk+56>>2]=0;q[hk+48>>2]=0;q[hk+52>>2]=0;q[hk+40>>2]=0;q[hk+44>>2]=0;q[hk+32>>2]=0;q[hk+36>>2]=0;q[hk+24>>2]=0;q[hk+28>>2]=0;q[hk+16>>2]=0;q[hk+20>>2]=0;q[hk+8>>2]=0;q[hk+12>>2]=0;a:{if(!th(hk+8|0,ki)|(q[hk+20>>2]?0:a)){break a}ik=uh(hk+8|0,ki);if(!a|!ik){break a}ki=q[hk+56>>2];mk=q[hk+36>>2];nk=q[hk+48>>2];ok=q[hk+24>>2];while(1){b:{if(ki>>>0>16383){break b}ik=q[hk+52>>2];while(1){if((ik|0)<1){break b}ik=ik+ -1|0;q[hk+52>>2]=ik;ki=r[ik+nk|0]|ki<<8;q[hk+56>>2]=ki;if(ki>>>0<16384){continue}break}}ik=ki&4095;kk=q[(ik<<2)+ok>>2];lk=(kk<<3)+mk|0;ki=(w(q[lk>>2],ki>>>12)+ik|0)-q[lk+4>>2]|0;q[hk+56>>2]=ki;q[(jk<<2)+gk>>2]=kk;ik=1;jk=jk+1|0;if((jk|0)!=(a|0)){continue}break}}a=q[hk+36>>2];if(a){q[hk+40>>2]=a;An(a)}a=q[hk+24>>2];if(a){q[hk+28>>2]=a;An(a)}a=q[hk+8>>2];if(a){q[hk+12>>2]=a;An(a)}T=hk- -64|0;return ik}function wh(a,ki,gk){var pk=0,qk=0,rk=0,sk=0,tk=0,uk=0,vk=0,wk=0;pk=T+ -64|0;T=pk;q[pk+56>>2]=0;q[pk+48>>2]=0;q[pk+52>>2]=0;q[pk+40>>2]=0;q[pk+44>>2]=0;q[pk+32>>2]=0;q[pk+36>>2]=0;q[pk+24>>2]=0;q[pk+28>>2]=0;q[pk+16>>2]=0;q[pk+20>>2]=0;q[pk+8>>2]=0;q[pk+12>>2]=0;a:{if(!Fh(pk+8|0,ki)|(q[pk+20>>2]?0:a)){break a}qk=Gh(pk+8|0,ki);if(!a|!qk){break a}ki=q[pk+56>>2];uk=q[pk+36>>2];vk=q[pk+48>>2];wk=q[pk+24>>2];while(1){b:{if(ki>>>0>32767){break b}qk=q[pk+52>>2];while(1){if((qk|0)<1){break b}qk=qk+ -1|0;q[pk+52>>2]=qk;ki=r[qk+vk|0]|ki<<8;q[pk+56>>2]=ki;if(ki>>>0<32768){continue}break}}qk=ki&8191;sk=q[(qk<<2)+wk>>2];tk=(sk<<3)+uk|0;ki=(w(q[tk>>2],ki>>>13)+qk|0)-q[tk+4>>2]|0;q[pk+56>>2]=ki;q[(rk<<2)+gk>>2]=sk;qk=1;rk=rk+1|0;if((rk|0)!=(a|0)){continue}break}}a=q[pk+36>>2];if(a){q[pk+40>>2]=a;An(a)}a=q[pk+24>>2];if(a){q[pk+28>>2]=a;An(a)}a=q[pk+8>>2];if(a){q[pk+12>>2]=a;An(a)}T=pk- -64|0;return qk}function xh(a,ki,gk){var xk=0,yk=0,zk=0,Ak=0,Bk=0,Ck=0,Dk=0,Ek=0;xk=T+ -64|0;T=xk;q[xk+56>>2]=0;q[xk+48>>2]=0;q[xk+52>>2]=0;q[xk+40>>2]=0;q[xk+44>>2]=0;q[xk+32>>2]=0;q[xk+36>>2]=0;q[xk+24>>2]=0;q[xk+28>>2]=0;q[xk+16>>2]=0;q[xk+20>>2]=0;q[xk+8>>2]=0;q[xk+12>>2]=0;a:{if(!Hh(xk+8|0,ki)|(q[xk+20>>2]?0:a)){break a}yk=Ih(xk+8|0,ki);if(!a|!yk){break a}ki=q[xk+56>>2];Ck=q[xk+36>>2];Dk=q[xk+48>>2];Ek=q[xk+24>>2];while(1){b:{if(ki>>>0>131071){break b}yk=q[xk+52>>2];while(1){if((yk|0)<1){break b}yk=yk+ -1|0;q[xk+52>>2]=yk;ki=r[yk+Dk|0]|ki<<8;q[xk+56>>2]=ki;if(ki>>>0<131072){continue}break}}yk=ki&32767;Ak=q[(yk<<2)+Ek>>2];Bk=(Ak<<3)+Ck|0;ki=(w(q[Bk>>2],ki>>>15)+yk|0)-q[Bk+4>>2]|0;q[xk+56>>2]=ki;q[(zk<<2)+gk>>2]=Ak;yk=1;zk=zk+1|0;if((zk|0)!=(a|0)){continue}break}}a=q[xk+36>>2];if(a){q[xk+40>>2]=a;An(a)}a=q[xk+24>>2];if(a){q[xk+28>>2]=a;An(a)}a=q[xk+8>>2];if(a){q[xk+12>>2]=a;An(a)}T=xk- -64|0;return yk}function yh(a,ki,gk){var Fk=0,Gk=0,Hk=0,Ik=0,Jk=0,Kk=0,Lk=0,Mk=0;Fk=T+ -64|0;T=Fk;q[Fk+56>>2]=0;q[Fk+48>>2]=0;q[Fk+52>>2]=0;q[Fk+40>>2]=0;q[Fk+44>>2]=0;q[Fk+32>>2]=0;q[Fk+36>>2]=0;q[Fk+24>>2]=0;q[Fk+28>>2]=0;q[Fk+16>>2]=0;q[Fk+20>>2]=0;q[Fk+8>>2]=0;q[Fk+12>>2]=0;a:{if(!Jh(Fk+8|0,ki)|(q[Fk+20>>2]?0:a)){break a}Gk=Kh(Fk+8|0,ki);if(!a|!Gk){break a}ki=q[Fk+56>>2];Kk=q[Fk+36>>2];Lk=q[Fk+48>>2];Mk=q[Fk+24>>2];while(1){b:{if(ki>>>0>262143){break b}Gk=q[Fk+52>>2];while(1){if((Gk|0)<1){break b}Gk=Gk+ -1|0;q[Fk+52>>2]=Gk;ki=r[Gk+Lk|0]|ki<<8;q[Fk+56>>2]=ki;if(ki>>>0<262144){continue}break}}Gk=ki&65535;Ik=q[(Gk<<2)+Mk>>2];Jk=(Ik<<3)+Kk|0;ki=(w(q[Jk>>2],ki>>>16)+Gk|0)-q[Jk+4>>2]|0;q[Fk+56>>2]=ki;q[(Hk<<2)+gk>>2]=Ik;Gk=1;Hk=Hk+1|0;if((Hk|0)!=(a|0)){continue}break}}a=q[Fk+36>>2];if(a){q[Fk+40>>2]=a;An(a)}a=q[Fk+24>>2];if(a){q[Fk+28>>2]=a;An(a)}a=q[Fk+8>>2];if(a){q[Fk+12>>2]=a;An(a)}T=Fk- -64|0;return Gk}function zh(a,ki,gk){var Nk=0,Ok=0,Pk=0,Qk=0,Rk=0,Sk=0,Tk=0,Uk=0;Nk=T+ -64|0;T=Nk;q[Nk+56>>2]=0;q[Nk+48>>2]=0;q[Nk+52>>2]=0;q[Nk+40>>2]=0;q[Nk+44>>2]=0;q[Nk+32>>2]=0;q[Nk+36>>2]=0;q[Nk+24>>2]=0;q[Nk+28>>2]=0;q[Nk+16>>2]=0;q[Nk+20>>2]=0;q[Nk+8>>2]=0;q[Nk+12>>2]=0;a:{if(!Lh(Nk+8|0,ki)|(q[Nk+20>>2]?0:a)){break a}Ok=Mh(Nk+8|0,ki);if(!a|!Ok){break a}ki=q[Nk+56>>2];Sk=q[Nk+36>>2];Tk=q[Nk+48>>2];Uk=q[Nk+24>>2];while(1){b:{if(ki>>>0>1048575){break b}Ok=q[Nk+52>>2];while(1){if((Ok|0)<1){break b}Ok=Ok+ -1|0;q[Nk+52>>2]=Ok;ki=r[Ok+Tk|0]|ki<<8;q[Nk+56>>2]=ki;if(ki>>>0<1048576){continue}break}}Ok=ki&262143;Qk=q[(Ok<<2)+Uk>>2];Rk=(Qk<<3)+Sk|0;ki=(w(q[Rk>>2],ki>>>18)+Ok|0)-q[Rk+4>>2]|0;q[Nk+56>>2]=ki;q[(Pk<<2)+gk>>2]=Qk;Ok=1;Pk=Pk+1|0;if((Pk|0)!=(a|0)){continue}break}}a=q[Nk+36>>2];if(a){q[Nk+40>>2]=a;An(a)}a=q[Nk+24>>2];if(a){q[Nk+28>>2]=a;An(a)}a=q[Nk+8>>2];if(a){q[Nk+12>>2]=a;An(a)}T=Nk- -64|0;return Ok}function Ah(a,ki,gk){var Vk=0,Wk=0,Xk=0,Yk=0,Zk=0,_k=0,$k=0,al=0;Vk=T+ -64|0;T=Vk;q[Vk+56>>2]=0;q[Vk+48>>2]=0;q[Vk+52>>2]=0;q[Vk+40>>2]=0;q[Vk+44>>2]=0;q[Vk+32>>2]=0;q[Vk+36>>2]=0;q[Vk+24>>2]=0;q[Vk+28>>2]=0;q[Vk+16>>2]=0;q[Vk+20>>2]=0;q[Vk+8>>2]=0;q[Vk+12>>2]=0;a:{if(!Nh(Vk+8|0,ki)|(q[Vk+20>>2]?0:a)){break a}Wk=Oh(Vk+8|0,ki);if(!a|!Wk){break a}ki=q[Vk+56>>2];_k=q[Vk+36>>2];$k=q[Vk+48>>2];al=q[Vk+24>>2];while(1){b:{if(ki>>>0>2097151){break b}Wk=q[Vk+52>>2];while(1){if((Wk|0)<1){break b}Wk=Wk+ -1|0;q[Vk+52>>2]=Wk;ki=r[Wk+$k|0]|ki<<8;q[Vk+56>>2]=ki;if(ki>>>0<2097152){continue}break}}Wk=ki&524287;Yk=q[(Wk<<2)+al>>2];Zk=(Yk<<3)+_k|0;ki=(w(q[Zk>>2],ki>>>19)+Wk|0)-q[Zk+4>>2]|0;q[Vk+56>>2]=ki;q[(Xk<<2)+gk>>2]=Yk;Wk=1;Xk=Xk+1|0;if((Xk|0)!=(a|0)){continue}break}}a=q[Vk+36>>2];if(a){q[Vk+40>>2]=a;An(a)}a=q[Vk+24>>2];if(a){q[Vk+28>>2]=a;An(a)}a=q[Vk+8>>2];if(a){q[Vk+12>>2]=a;An(a)}T=Vk- -64|0;return Wk}function Bh(a,ki,gk){var bl=0,cl=0,dl=0,el=0,fl=0,gl=0,hl=0,il=0;bl=T+ -64|0;T=bl;q[bl+56>>2]=0;q[bl+48>>2]=0;q[bl+52>>2]=0;q[bl+40>>2]=0;q[bl+44>>2]=0;q[bl+32>>2]=0;q[bl+36>>2]=0;q[bl+24>>2]=0;q[bl+28>>2]=0;q[bl+16>>2]=0;q[bl+20>>2]=0;q[bl+8>>2]=0;q[bl+12>>2]=0;a:{if(!Ph(bl+8|0,ki)|(q[bl+20>>2]?0:a)){break a}cl=Qh(bl+8|0,ki);if(!a|!cl){break a}ki=q[bl+56>>2];gl=q[bl+36>>2];hl=q[bl+48>>2];il=q[bl+24>>2];while(1){b:{if(ki>>>0>4194303){break b}cl=q[bl+52>>2];while(1){if((cl|0)<1){break b}cl=cl+ -1|0;q[bl+52>>2]=cl;ki=r[cl+hl|0]|ki<<8;q[bl+56>>2]=ki;if(ki>>>0<4194304){continue}break}}cl=ki&1048575;el=q[(cl<<2)+il>>2];fl=(el<<3)+gl|0;ki=(w(q[fl>>2],ki>>>20)+cl|0)-q[fl+4>>2]|0;q[bl+56>>2]=ki;q[(dl<<2)+gk>>2]=el;cl=1;dl=dl+1|0;if((dl|0)!=(a|0)){continue}break}}a=q[bl+36>>2];if(a){q[bl+40>>2]=a;An(a)}a=q[bl+24>>2];if(a){q[bl+28>>2]=a;An(a)}a=q[bl+8>>2];if(a){q[bl+12>>2]=a;An(a)}T=bl- -64|0;return cl}function Ch(a,ki,gk){var jl=0,kl=0,ll=0,ml=0;a:{if(a>>>0>5){break a}ll=q[gk+16>>2];jl=q[gk+12>>2];kl=q[gk+20>>2];if((jl|0)<(kl|0)?1:(jl|0)<=(kl|0)?t[gk+8>>2]>ll>>>0?0:1:0){break a}jl=r[ll+q[gk>>2]|0];ll=ll+1|0;if(ll>>>0<1){kl=kl+1|0}q[gk+16>>2]=ll;q[gk+20>>2]=kl;kl=ki;if(jl&128){if(!Ch(a+1|0,ki,gk)){break a}a=q[ki>>2]<<7;q[ki>>2]=a;jl=a|jl&127}q[kl>>2]=jl;ml=1}return ml}function Dh(a,ki){var gk=0,nl=0,ol=0,pl=0,ql=0,rl=0,sl=0;a:{b:{ol=q[a+8>>2];gk=a+4|0;nl=q[gk>>2];c:{if(ol-nl>>3>>>0>=ki>>>0){while(1){q[nl>>2]=0;q[nl+4>>2]=0;nl=q[gk>>2]+8|0;q[gk>>2]=nl;ki=ki+ -1|0;if(ki){continue}break c}}pl=q[a>>2];ql=nl-pl|0;gk=ql>>3;nl=gk+ki|0;if(nl>>>0>=536870912){break b}sl=gk<<3;ol=ol-pl|0;gk=ol>>2;ol=ol>>3>>>0<268435455?gk>>>0<nl>>>0?nl:gk:536870911;gk=0;d:{if(!ol){break d}if(ol>>>0>=536870912){break a}rl=Mm(ol<<3);gk=rl}nl=sl+gk|0;Dn(nl,0,ki<<3);ol=gk+(ol<<3)|0;while(1){nl=nl+8|0;ki=ki+ -1|0;if(ki){continue}break}if((ql|0)>=1){Cn(rl,pl,ql)}q[a>>2]=gk;q[a+8>>2]=ol;q[a+4>>2]=nl;if(!pl){break c}An(pl)}return}bn();F()}ab(10991);F()}function Eh(a,ki,tl){var ul=0,vl=0,wl=0,xl=0,yl=0,zl=0;a:{if(a>>>0>10){break a}wl=q[tl+16>>2];ul=q[tl+12>>2];vl=q[tl+20>>2];xl=vl;if((ul|0)<(xl|0)?1:(ul|0)<=(xl|0)?t[tl+8>>2]>wl>>>0?0:1:0){break a}yl=o[wl+q[tl>>2]|0];ul=wl+1|0;if(ul>>>0<1){vl=vl+1|0}q[tl+16>>2]=ul;q[tl+20>>2]=vl;xl=ki;wl=ki;ul=yl;b:{if((ul|0)<=-1){if(!Eh(a+1|0,ki,tl)){break a}a=ki;tl=q[ki+4>>2];ki=q[ki>>2];vl=tl<<7|ki>>>25;ki=ki<<7;q[a>>2]=ki;q[a+4>>2]=vl;a=ul&127|ki;break b}vl=0;a=ul&255}q[wl>>2]=a;q[xl+4>>2]=vl;zl=1}return zl}function Fh(a,ki){var tl=0,Al=0,Bl=0,Cl=0,Dl=0,El=0,Fl=0,Gl=0,Hl=0,Il=0,Jl=0,Kl=0,Ll=0;a:{tl=s[ki+38>>1];if(!tl){break a}Fl=a+12|0;b:{if(tl>>>0<=511){Al=q[ki+12>>2];tl=q[ki+20>>2];Bl=q[ki+16>>2];Dl=Bl+4|0;if(Dl>>>0<4){tl=tl+1|0}if((Al|0)<(tl|0)?1:(Al|0)<=(tl|0)?t[ki+8>>2]>=Dl>>>0?0:1:0){break a}tl=Bl+q[ki>>2]|0;Bl=r[tl|0]|r[tl+1|0]<<8|(r[tl+2|0]<<16|r[tl+3|0]<<24);q[Fl>>2]=Bl;Al=q[ki+20>>2];Dl=q[ki+16>>2]+4|0;if(Dl>>>0<4){Al=Al+1|0}tl=ki;q[tl+16>>2]=Dl;q[tl+20>>2]=Al;break b}if(!Ch(1,Fl,ki)){break a}Bl=q[Fl>>2]}Al=q[a>>2];tl=q[a+4>>2]-Al>>2;c:{if(Bl>>>0>tl>>>0){Fa(a,Bl-tl|0);Bl=q[a+12>>2];break c}if(Bl>>>0>=tl>>>0){break c}q[a+4>>2]=Al+(Bl<<2)}if(!Bl){Ll=1;break a}Jl=q[ki+8>>2];Dl=q[ki+12>>2];while(1){Cl=q[ki+16>>2];tl=q[ki+20>>2];if((Dl|0)<(tl|0)?1:(Dl|0)<=(tl|0)?Jl>>>0>Cl>>>0?0:1:0){break a}Kl=q[ki>>2];Gl=r[Kl+Cl|0];Cl=Cl+1|0;if(Cl>>>0<1){tl=tl+1|0}q[ki+16>>2]=Cl;q[ki+20>>2]=tl;Hl=Gl>>>2;d:{e:{f:{Il=Gl&3;if(Il>>>0>3){Al=0;break f}Al=0;g:{switch(Il-1|0){case 0:case 1:break f;case 2:break g;default:break e}}tl=El+Hl|0;if(tl>>>0>=Bl>>>0){return 0}Dn(q[a>>2]+(El<<2)|0,0,(Gl&252)+4|0);El=tl;break d}while(1){if((Dl|0)<(tl|0)?1:(Dl|0)<=(tl|0)?Jl>>>0>Cl>>>0?0:1:0){return 0}Gl=r[Cl+Kl|0];Cl=Cl+1|0;if(Cl>>>0<1){tl=tl+1|0}q[ki+16>>2]=Cl;q[ki+20>>2]=tl;Hl=Gl<<(Al<<3|6)|Hl;Al=Al+1|0;if((Il|0)!=(Al|0)){continue}break}}q[q[a>>2]+(El<<2)>>2]=Hl}El=El+1|0;Bl=q[Fl>>2];if(El>>>0<Bl>>>0){continue}break}El=a+16|0;Fl=q[a>>2];ki=q[a+16>>2];tl=q[a+20>>2]-ki|0;Al=tl>>2;h:{if(Al>>>0<=8191){Fa(El,8192-Al|0);break h}if((tl|0)==32768){break h}q[a+20>>2]=ki+32768}i:{ki=a+28|0;tl=q[ki>>2];Al=q[a+32>>2]-tl>>3;if(Bl>>>0>Al>>>0){Dh(ki,Bl-Al|0);tl=q[ki>>2];break i}if(Bl>>>0<Al>>>0){q[a+32>>2]=(Bl<<3)+tl}if(Bl){break i}return 0}ki=0;Al=0;while(1){a=Fl+(ki<<2)|0;Dl=q[a>>2];Cl=(ki<<3)+tl|0;q[Cl+4>>2]=Al;q[Cl>>2]=Dl;a=q[a>>2]+Al|0;if(a>>>0>8192){break a}if(Al>>>0<a>>>0){Dl=q[El>>2];while(1){q[Dl+(Al<<2)>>2]=ki;Al=Al+1|0;if((a|0)!=(Al|0)){continue}break}}Al=a;ki=ki+1|0;if((Bl|0)!=(ki|0)){continue}break}return(a|0)==8192}return Ll}function Gh(a,ki){var Ml=0,Nl=0,Ol=0,Pl=0,Ql=0,Rl=0,Sl=0,Tl=0,Ul=0;Ql=T-16|0;T=Ql;a:{b:{if(s[ki+38>>1]<=511){Nl=q[ki+12>>2];Tl=Nl;Ml=q[ki+20>>2];Ol=q[ki+16>>2];Pl=Ol+8|0;if(Pl>>>0<8){Ml=Ml+1|0}Rl=q[ki+8>>2];if((Nl|0)<(Ml|0)?1:(Nl|0)<=(Ml|0)?Rl>>>0>=Pl>>>0?0:1:0){break a}Nl=Ol+q[ki>>2]|0;Ol=r[Nl+4|0]|r[Nl+5|0]<<8|(r[Nl+6|0]<<16|r[Nl+7|0]<<24);Nl=r[Nl|0]|r[Nl+1|0]<<8|(r[Nl+2|0]<<16|r[Nl+3|0]<<24);q[Ql+8>>2]=Nl;q[Ql+12>>2]=Ol;q[ki+16>>2]=Pl;q[ki+20>>2]=Ml;break b}if(!Eh(1,Ql+8|0,ki)){break a}Pl=q[ki+16>>2];Ml=q[ki+20>>2];Rl=q[ki+8>>2];Tl=q[ki+12>>2];Nl=q[Ql+8>>2];Ol=q[Ql+12>>2]}Sl=Rl-Pl|0;Rl=Tl-(Ml+(Rl>>>0<Pl>>>0)|0)|0;if((Rl|0)==(Ol|0)&Nl>>>0>Sl>>>0|Ol>>>0>Rl>>>0){break a}Ol=Ml+Ol|0;Ml=Pl;Sl=Ml+Nl|0;if(Sl>>>0<Ml>>>0){Ol=Ol+1|0}q[ki+16>>2]=Sl;q[ki+20>>2]=Ol;Ml=Nl;if((Ml|0)<1){break a}Pl=Pl+q[ki>>2]|0;q[a+40>>2]=Pl;ki=a;c:{d:{e:{f:{g:{Nl=Ml+ -1|0;Ol=Pl+Nl|0;switch((r[Ol|0]>>>6)-1|0){case 2:break d;case 1:break e;case 0:break f;default:break g}}q[a+44>>2]=Nl;a=r[Ol|0]&63;break c}if((Ml|0)<2){break a}q[a+44>>2]=Ml+ -2;a=(Ml+Pl|0)+ -2|0;a=r[a+1|0]<<8&16128|r[a|0];break c}if((Ml|0)<3){break a}q[a+44>>2]=Ml+ -3;a=(Ml+Pl|0)+ -3|0;a=r[a+1|0]<<8|r[a+2|0]<<16&4128768|r[a|0];break c}q[a+44>>2]=Ml+ -4;a=(Ml+Pl|0)+ -4|0;a=r[a+2|0]<<16|r[a+3|0]<<24&1056964608|r[a+1|0]<<8|r[a|0]}a=a+32768|0;q[ki+48>>2]=a;Ul=a>>>0<8388608}T=Ql+16|0;return Ul}function Hh(a,ki){var Vl=0,Wl=0,Xl=0,Yl=0,Zl=0,_l=0,$l=0,am=0,bm=0,cm=0,dm=0,em=0,fm=0;a:{Vl=s[ki+38>>1];if(!Vl){break a}$l=a+12|0;b:{if(Vl>>>0<=511){Wl=q[ki+12>>2];Vl=q[ki+20>>2];Xl=q[ki+16>>2];Zl=Xl+4|0;if(Zl>>>0<4){Vl=Vl+1|0}if((Wl|0)<(Vl|0)?1:(Wl|0)<=(Vl|0)?t[ki+8>>2]>=Zl>>>0?0:1:0){break a}Vl=Xl+q[ki>>2]|0;Xl=r[Vl|0]|r[Vl+1|0]<<8|(r[Vl+2|0]<<16|r[Vl+3|0]<<24);q[$l>>2]=Xl;Wl=q[ki+20>>2];Zl=q[ki+16>>2]+4|0;if(Zl>>>0<4){Wl=Wl+1|0}Vl=ki;q[Vl+16>>2]=Zl;q[Vl+20>>2]=Wl;break b}if(!Ch(1,$l,ki)){break a}Xl=q[$l>>2]}Wl=q[a>>2];Vl=q[a+4>>2]-Wl>>2;c:{if(Xl>>>0>Vl>>>0){Fa(a,Xl-Vl|0);Xl=q[a+12>>2];break c}if(Xl>>>0>=Vl>>>0){break c}q[a+4>>2]=Wl+(Xl<<2)}if(!Xl){fm=1;break a}dm=q[ki+8>>2];Zl=q[ki+12>>2];while(1){Yl=q[ki+16>>2];Vl=q[ki+20>>2];if((Zl|0)<(Vl|0)?1:(Zl|0)<=(Vl|0)?dm>>>0>Yl>>>0?0:1:0){break a}em=q[ki>>2];am=r[em+Yl|0];Yl=Yl+1|0;if(Yl>>>0<1){Vl=Vl+1|0}q[ki+16>>2]=Yl;q[ki+20>>2]=Vl;bm=am>>>2;d:{e:{f:{cm=am&3;if(cm>>>0>3){Wl=0;break f}Wl=0;g:{switch(cm-1|0){case 0:case 1:break f;case 2:break g;default:break e}}Vl=_l+bm|0;if(Vl>>>0>=Xl>>>0){return 0}Dn(q[a>>2]+(_l<<2)|0,0,(am&252)+4|0);_l=Vl;break d}while(1){if((Zl|0)<(Vl|0)?1:(Zl|0)<=(Vl|0)?dm>>>0>Yl>>>0?0:1:0){return 0}am=r[Yl+em|0];Yl=Yl+1|0;if(Yl>>>0<1){Vl=Vl+1|0}q[ki+16>>2]=Yl;q[ki+20>>2]=Vl;bm=am<<(Wl<<3|6)|bm;Wl=Wl+1|0;if((cm|0)!=(Wl|0)){continue}break}}q[q[a>>2]+(_l<<2)>>2]=bm}_l=_l+1|0;Xl=q[$l>>2];if(_l>>>0<Xl>>>0){continue}break}_l=a+16|0;$l=q[a>>2];ki=q[a+16>>2];Vl=q[a+20>>2]-ki|0;Wl=Vl>>2;h:{if(Wl>>>0<=32767){Fa(_l,32768-Wl|0);break h}if((Vl|0)==131072){break h}q[a+20>>2]=ki+131072}i:{ki=a+28|0;Vl=q[ki>>2];Wl=q[a+32>>2]-Vl>>3;if(Xl>>>0>Wl>>>0){Dh(ki,Xl-Wl|0);Vl=q[ki>>2];break i}if(Xl>>>0<Wl>>>0){q[a+32>>2]=(Xl<<3)+Vl}if(Xl){break i}return 0}ki=0;Wl=0;while(1){a=$l+(ki<<2)|0;Zl=q[a>>2];Yl=(ki<<3)+Vl|0;q[Yl+4>>2]=Wl;q[Yl>>2]=Zl;a=q[a>>2]+Wl|0;if(a>>>0>32768){break a}if(Wl>>>0<a>>>0){Zl=q[_l>>2];while(1){q[Zl+(Wl<<2)>>2]=ki;Wl=Wl+1|0;if((a|0)!=(Wl|0)){continue}break}}Wl=a;ki=ki+1|0;if((Xl|0)!=(ki|0)){continue}break}return(a|0)==32768}return fm}function Ih(a,ki){var gm=0,hm=0,im=0,jm=0,km=0,lm=0,mm=0,nm=0,om=0;km=T-16|0;T=km;a:{b:{if(s[ki+38>>1]<=511){hm=q[ki+12>>2];nm=hm;gm=q[ki+20>>2];im=q[ki+16>>2];jm=im+8|0;if(jm>>>0<8){gm=gm+1|0}lm=q[ki+8>>2];if((hm|0)<(gm|0)?1:(hm|0)<=(gm|0)?lm>>>0>=jm>>>0?0:1:0){break a}hm=im+q[ki>>2]|0;im=r[hm+4|0]|r[hm+5|0]<<8|(r[hm+6|0]<<16|r[hm+7|0]<<24);hm=r[hm|0]|r[hm+1|0]<<8|(r[hm+2|0]<<16|r[hm+3|0]<<24);q[km+8>>2]=hm;q[km+12>>2]=im;q[ki+16>>2]=jm;q[ki+20>>2]=gm;break b}if(!Eh(1,km+8|0,ki)){break a}jm=q[ki+16>>2];gm=q[ki+20>>2];lm=q[ki+8>>2];nm=q[ki+12>>2];hm=q[km+8>>2];im=q[km+12>>2]}mm=lm-jm|0;lm=nm-(gm+(lm>>>0<jm>>>0)|0)|0;if((lm|0)==(im|0)&hm>>>0>mm>>>0|im>>>0>lm>>>0){break a}im=gm+im|0;gm=jm;mm=gm+hm|0;if(mm>>>0<gm>>>0){im=im+1|0}q[ki+16>>2]=mm;q[ki+20>>2]=im;gm=hm;if((gm|0)<1){break a}jm=jm+q[ki>>2]|0;q[a+40>>2]=jm;ki=a;c:{d:{e:{f:{g:{hm=gm+ -1|0;im=jm+hm|0;switch((r[im|0]>>>6)-1|0){case 2:break d;case 1:break e;case 0:break f;default:break g}}q[a+44>>2]=hm;a=r[im|0]&63;break c}if((gm|0)<2){break a}q[a+44>>2]=gm+ -2;a=(gm+jm|0)+ -2|0;a=r[a+1|0]<<8&16128|r[a|0];break c}if((gm|0)<3){break a}q[a+44>>2]=gm+ -3;a=(gm+jm|0)+ -3|0;a=r[a+1|0]<<8|r[a+2|0]<<16&4128768|r[a|0];break c}q[a+44>>2]=gm+ -4;a=(gm+jm|0)+ -4|0;a=r[a+2|0]<<16|r[a+3|0]<<24&1056964608|r[a+1|0]<<8|r[a|0]}a=a+131072|0;q[ki+48>>2]=a;om=a>>>0<33554432}T=km+16|0;return om}function Jh(a,ki){var pm=0,qm=0,rm=0,sm=0,tm=0,um=0,vm=0,wm=0,xm=0,ym=0,zm=0,Am=0,Bm=0;a:{pm=s[ki+38>>1];if(!pm){break a}vm=a+12|0;b:{if(pm>>>0<=511){qm=q[ki+12>>2];pm=q[ki+20>>2];rm=q[ki+16>>2];tm=rm+4|0;if(tm>>>0<4){pm=pm+1|0}if((qm|0)<(pm|0)?1:(qm|0)<=(pm|0)?t[ki+8>>2]>=tm>>>0?0:1:0){break a}pm=rm+q[ki>>2]|0;rm=r[pm|0]|r[pm+1|0]<<8|(r[pm+2|0]<<16|r[pm+3|0]<<24);q[vm>>2]=rm;qm=q[ki+20>>2];tm=q[ki+16>>2]+4|0;if(tm>>>0<4){qm=qm+1|0}pm=ki;q[pm+16>>2]=tm;q[pm+20>>2]=qm;break b}if(!Ch(1,vm,ki)){break a}rm=q[vm>>2]}qm=q[a>>2];pm=q[a+4>>2]-qm>>2;c:{if(rm>>>0>pm>>>0){Fa(a,rm-pm|0);rm=q[a+12>>2];break c}if(rm>>>0>=pm>>>0){break c}q[a+4>>2]=qm+(rm<<2)}if(!rm){Bm=1;break a}zm=q[ki+8>>2];tm=q[ki+12>>2];while(1){sm=q[ki+16>>2];pm=q[ki+20>>2];if((tm|0)<(pm|0)?1:(tm|0)<=(pm|0)?zm>>>0>sm>>>0?0:1:0){break a}Am=q[ki>>2];wm=r[Am+sm|0];sm=sm+1|0;if(sm>>>0<1){pm=pm+1|0}q[ki+16>>2]=sm;q[ki+20>>2]=pm;xm=wm>>>2;d:{e:{f:{ym=wm&3;if(ym>>>0>3){qm=0;break f}qm=0;g:{switch(ym-1|0){case 0:case 1:break f;case 2:break g;default:break e}}pm=um+xm|0;if(pm>>>0>=rm>>>0){return 0}Dn(q[a>>2]+(um<<2)|0,0,(wm&252)+4|0);um=pm;break d}while(1){if((tm|0)<(pm|0)?1:(tm|0)<=(pm|0)?zm>>>0>sm>>>0?0:1:0){return 0}wm=r[sm+Am|0];sm=sm+1|0;if(sm>>>0<1){pm=pm+1|0}q[ki+16>>2]=sm;q[ki+20>>2]=pm;xm=wm<<(qm<<3|6)|xm;qm=qm+1|0;if((ym|0)!=(qm|0)){continue}break}}q[q[a>>2]+(um<<2)>>2]=xm}um=um+1|0;rm=q[vm>>2];if(um>>>0<rm>>>0){continue}break}um=a+16|0;vm=q[a>>2];ki=q[a+16>>2];pm=q[a+20>>2]-ki|0;qm=pm>>2;h:{if(qm>>>0<=65535){Fa(um,65536-qm|0);break h}if((pm|0)==262144){break h}q[a+20>>2]=ki+262144}i:{ki=a+28|0;pm=q[ki>>2];qm=q[a+32>>2]-pm>>3;if(rm>>>0>qm>>>0){Dh(ki,rm-qm|0);pm=q[ki>>2];break i}if(rm>>>0<qm>>>0){q[a+32>>2]=(rm<<3)+pm}if(rm){break i}return 0}ki=0;qm=0;while(1){a=vm+(ki<<2)|0;tm=q[a>>2];sm=(ki<<3)+pm|0;q[sm+4>>2]=qm;q[sm>>2]=tm;a=q[a>>2]+qm|0;if(a>>>0>65536){break a}if(qm>>>0<a>>>0){tm=q[um>>2];while(1){q[tm+(qm<<2)>>2]=ki;qm=qm+1|0;if((a|0)!=(qm|0)){continue}break}}qm=a;ki=ki+1|0;if((rm|0)!=(ki|0)){continue}break}return(a|0)==65536}return Bm}function Kh(a,ki){var Cm=0,Dm=0,Em=0,Fm=0,Gm=0,Hm=0,Im=0,Jm=0,Km=0;Gm=T-16|0;T=Gm;a:{b:{if(s[ki+38>>1]<=511){Dm=q[ki+12>>2];Jm=Dm;Cm=q[ki+20>>2];Em=q[ki+16>>2];Fm=Em+8|0;if(Fm>>>0<8){Cm=Cm+1|0}Hm=q[ki+8>>2];if((Dm|0)<(Cm|0)?1:(Dm|0)<=(Cm|0)?Hm>>>0>=Fm>>>0?0:1:0){break a}Dm=Em+q[ki>>2]|0;Em=r[Dm+4|0]|r[Dm+5|0]<<8|(r[Dm+6|0]<<16|r[Dm+7|0]<<24);Dm=r[Dm|0]|r[Dm+1|0]<<8|(r[Dm+2|0]<<16|r[Dm+3|0]<<24);q[Gm+8>>2]=Dm;q[Gm+12>>2]=Em;q[ki+16>>2]=Fm;q[ki+20>>2]=Cm;break b}if(!Eh(1,Gm+8|0,ki)){break a}Fm=q[ki+16>>2];Cm=q[ki+20>>2];Hm=q[ki+8>>2];Jm=q[ki+12>>2];Dm=q[Gm+8>>2];Em=q[Gm+12>>2]}Im=Hm-Fm|0;Hm=Jm-(Cm+(Hm>>>0<Fm>>>0)|0)|0;if((Hm|0)==(Em|0)&Dm>>>0>Im>>>0|Em>>>0>Hm>>>0){break a}Em=Cm+Em|0;Cm=Fm;Im=Cm+Dm|0;if(Im>>>0<Cm>>>0){Em=Em+1|0}q[ki+16>>2]=Im;q[ki+20>>2]=Em;Cm=Dm;if((Cm|0)<1){break a}Fm=Fm+q[ki>>2]|0;q[a+40>>2]=Fm;ki=a;c:{d:{e:{f:{g:{Dm=Cm+ -1|0;Em=Fm+Dm|0;switch((r[Em|0]>>>6)-1|0){case 2:break d;case 1:break e;case 0:break f;default:break g}}q[a+44>>2]=Dm;a=r[Em|0]&63;break c}if((Cm|0)<2){break a}q[a+44>>2]=Cm+ -2;a=(Cm+Fm|0)+ -2|0;a=r[a+1|0]<<8&16128|r[a|0];break c}if((Cm|0)<3){break a}q[a+44>>2]=Cm+ -3;a=(Cm+Fm|0)+ -3|0;a=r[a+1|0]<<8|r[a+2|0]<<16&4128768|r[a|0];break c}q[a+44>>2]=Cm+ -4;a=(Cm+Fm|0)+ -4|0;a=r[a+2|0]<<16|r[a+3|0]<<24&1056964608|r[a+1|0]<<8|r[a|0]}a=a+262144|0;q[ki+48>>2]=a;Km=a>>>0<67108864}T=Gm+16|0;return Km}function Lh(a,ki){var Lm=0,Mm=0,Nm=0,Om=0,Pm=0,Qm=0,Rm=0,Sm=0,Tm=0,Um=0,Vm=0,Wm=0,Xm=0;a:{Lm=s[ki+38>>1];if(!Lm){break a}Rm=a+12|0;b:{if(Lm>>>0<=511){Mm=q[ki+12>>2];Lm=q[ki+20>>2];Nm=q[ki+16>>2];Pm=Nm+4|0;if(Pm>>>0<4){Lm=Lm+1|0}if((Mm|0)<(Lm|0)?1:(Mm|0)<=(Lm|0)?t[ki+8>>2]>=Pm>>>0?0:1:0){break a}Lm=Nm+q[ki>>2]|0;Nm=r[Lm|0]|r[Lm+1|0]<<8|(r[Lm+2|0]<<16|r[Lm+3|0]<<24);q[Rm>>2]=Nm;Mm=q[ki+20>>2];Pm=q[ki+16>>2]+4|0;if(Pm>>>0<4){Mm=Mm+1|0}Lm=ki;q[Lm+16>>2]=Pm;q[Lm+20>>2]=Mm;break b}if(!Ch(1,Rm,ki)){break a}Nm=q[Rm>>2]}Mm=q[a>>2];Lm=q[a+4>>2]-Mm>>2;c:{if(Nm>>>0>Lm>>>0){Fa(a,Nm-Lm|0);Nm=q[a+12>>2];break c}if(Nm>>>0>=Lm>>>0){break c}q[a+4>>2]=Mm+(Nm<<2)}if(!Nm){Xm=1;break a}Vm=q[ki+8>>2];Pm=q[ki+12>>2];while(1){Om=q[ki+16>>2];Lm=q[ki+20>>2];if((Pm|0)<(Lm|0)?1:(Pm|0)<=(Lm|0)?Vm>>>0>Om>>>0?0:1:0){break a}Wm=q[ki>>2];Sm=r[Wm+Om|0];Om=Om+1|0;if(Om>>>0<1){Lm=Lm+1|0}q[ki+16>>2]=Om;q[ki+20>>2]=Lm;Tm=Sm>>>2;d:{e:{f:{Um=Sm&3;if(Um>>>0>3){Mm=0;break f}Mm=0;g:{switch(Um-1|0){case 0:case 1:break f;case 2:break g;default:break e}}Lm=Qm+Tm|0;if(Lm>>>0>=Nm>>>0){return 0}Dn(q[a>>2]+(Qm<<2)|0,0,(Sm&252)+4|0);Qm=Lm;break d}while(1){if((Pm|0)<(Lm|0)?1:(Pm|0)<=(Lm|0)?Vm>>>0>Om>>>0?0:1:0){return 0}Sm=r[Om+Wm|0];Om=Om+1|0;if(Om>>>0<1){Lm=Lm+1|0}q[ki+16>>2]=Om;q[ki+20>>2]=Lm;Tm=Sm<<(Mm<<3|6)|Tm;Mm=Mm+1|0;if((Um|0)!=(Mm|0)){continue}break}}q[q[a>>2]+(Qm<<2)>>2]=Tm}Qm=Qm+1|0;Nm=q[Rm>>2];if(Qm>>>0<Nm>>>0){continue}break}Qm=a+16|0;Rm=q[a>>2];ki=q[a+16>>2];Lm=q[a+20>>2]-ki|0;Mm=Lm>>2;h:{if(Mm>>>0<=262143){Fa(Qm,262144-Mm|0);break h}if((Lm|0)==1048576){break h}q[a+20>>2]=ki- -1048576}i:{ki=a+28|0;Lm=q[ki>>2];Mm=q[a+32>>2]-Lm>>3;if(Nm>>>0>Mm>>>0){Dh(ki,Nm-Mm|0);Lm=q[ki>>2];break i}if(Nm>>>0<Mm>>>0){q[a+32>>2]=(Nm<<3)+Lm}if(Nm){break i}return 0}ki=0;Mm=0;while(1){a=Rm+(ki<<2)|0;Pm=q[a>>2];Om=(ki<<3)+Lm|0;q[Om+4>>2]=Mm;q[Om>>2]=Pm;a=q[a>>2]+Mm|0;if(a>>>0>262144){break a}if(Mm>>>0<a>>>0){Pm=q[Qm>>2];while(1){q[Pm+(Mm<<2)>>2]=ki;Mm=Mm+1|0;if((a|0)!=(Mm|0)){continue}break}}Mm=a;ki=ki+1|0;if((Nm|0)!=(ki|0)){continue}break}return(a|0)==262144}return Xm}function Mh(a,ki){var Ym=0,Zm=0,_m=0,$m=0,an=0,bn=0,cn=0,dn=0,en=0;an=T-16|0;T=an;a:{b:{if(s[ki+38>>1]<=511){Zm=q[ki+12>>2];dn=Zm;Ym=q[ki+20>>2];_m=q[ki+16>>2];$m=_m+8|0;if($m>>>0<8){Ym=Ym+1|0}bn=q[ki+8>>2];if((Zm|0)<(Ym|0)?1:(Zm|0)<=(Ym|0)?bn>>>0>=$m>>>0?0:1:0){break a}Zm=_m+q[ki>>2]|0;_m=r[Zm+4|0]|r[Zm+5|0]<<8|(r[Zm+6|0]<<16|r[Zm+7|0]<<24);Zm=r[Zm|0]|r[Zm+1|0]<<8|(r[Zm+2|0]<<16|r[Zm+3|0]<<24);q[an+8>>2]=Zm;q[an+12>>2]=_m;q[ki+16>>2]=$m;q[ki+20>>2]=Ym;break b}if(!Eh(1,an+8|0,ki)){break a}$m=q[ki+16>>2];Ym=q[ki+20>>2];bn=q[ki+8>>2];dn=q[ki+12>>2];Zm=q[an+8>>2];_m=q[an+12>>2]}cn=bn-$m|0;bn=dn-(Ym+(bn>>>0<$m>>>0)|0)|0;if((bn|0)==(_m|0)&Zm>>>0>cn>>>0|_m>>>0>bn>>>0){break a}_m=Ym+_m|0;Ym=$m;cn=Ym+Zm|0;if(cn>>>0<Ym>>>0){_m=_m+1|0}q[ki+16>>2]=cn;q[ki+20>>2]=_m;Ym=Zm;if((Ym|0)<1){break a}$m=$m+q[ki>>2]|0;q[a+40>>2]=$m;ki=a;c:{d:{e:{f:{g:{Zm=Ym+ -1|0;_m=$m+Zm|0;switch((r[_m|0]>>>6)-1|0){case 2:break d;case 1:break e;case 0:break f;default:break g}}q[a+44>>2]=Zm;a=r[_m|0]&63;break c}if((Ym|0)<2){break a}q[a+44>>2]=Ym+ -2;a=(Ym+$m|0)+ -2|0;a=r[a+1|0]<<8&16128|r[a|0];break c}if((Ym|0)<3){break a}q[a+44>>2]=Ym+ -3;a=(Ym+$m|0)+ -3|0;a=r[a+1|0]<<8|r[a+2|0]<<16&4128768|r[a|0];break c}q[a+44>>2]=Ym+ -4;a=(Ym+$m|0)+ -4|0;a=r[a+2|0]<<16|r[a+3|0]<<24&1056964608|r[a+1|0]<<8|r[a|0]}a=a- -1048576|0;q[ki+48>>2]=a;en=a>>>0<268435456}T=an+16|0;return en}function Nh(a,ki){var fn=0,gn=0,hn=0,jn=0,kn=0,ln=0,mn=0,nn=0,on=0,pn=0,qn=0,rn=0,sn=0;a:{fn=s[ki+38>>1];if(!fn){break a}mn=a+12|0;b:{if(fn>>>0<=511){gn=q[ki+12>>2];fn=q[ki+20>>2];hn=q[ki+16>>2];kn=hn+4|0;if(kn>>>0<4){fn=fn+1|0}if((gn|0)<(fn|0)?1:(gn|0)<=(fn|0)?t[ki+8>>2]>=kn>>>0?0:1:0){break a}fn=hn+q[ki>>2]|0;hn=r[fn|0]|r[fn+1|0]<<8|(r[fn+2|0]<<16|r[fn+3|0]<<24);q[mn>>2]=hn;gn=q[ki+20>>2];kn=q[ki+16>>2]+4|0;if(kn>>>0<4){gn=gn+1|0}fn=ki;q[fn+16>>2]=kn;q[fn+20>>2]=gn;break b}if(!Ch(1,mn,ki)){break a}hn=q[mn>>2]}gn=q[a>>2];fn=q[a+4>>2]-gn>>2;c:{if(hn>>>0>fn>>>0){Fa(a,hn-fn|0);hn=q[a+12>>2];break c}if(hn>>>0>=fn>>>0){break c}q[a+4>>2]=gn+(hn<<2)}if(!hn){sn=1;break a}qn=q[ki+8>>2];kn=q[ki+12>>2];while(1){jn=q[ki+16>>2];fn=q[ki+20>>2];if((kn|0)<(fn|0)?1:(kn|0)<=(fn|0)?qn>>>0>jn>>>0?0:1:0){break a}rn=q[ki>>2];nn=r[rn+jn|0];jn=jn+1|0;if(jn>>>0<1){fn=fn+1|0}q[ki+16>>2]=jn;q[ki+20>>2]=fn;on=nn>>>2;d:{e:{f:{pn=nn&3;if(pn>>>0>3){gn=0;break f}gn=0;g:{switch(pn-1|0){case 0:case 1:break f;case 2:break g;default:break e}}fn=ln+on|0;if(fn>>>0>=hn>>>0){return 0}Dn(q[a>>2]+(ln<<2)|0,0,(nn&252)+4|0);ln=fn;break d}while(1){if((kn|0)<(fn|0)?1:(kn|0)<=(fn|0)?qn>>>0>jn>>>0?0:1:0){return 0}nn=r[jn+rn|0];jn=jn+1|0;if(jn>>>0<1){fn=fn+1|0}q[ki+16>>2]=jn;q[ki+20>>2]=fn;on=nn<<(gn<<3|6)|on;gn=gn+1|0;if((pn|0)!=(gn|0)){continue}break}}q[q[a>>2]+(ln<<2)>>2]=on}ln=ln+1|0;hn=q[mn>>2];if(ln>>>0<hn>>>0){continue}break}ln=a+16|0;mn=q[a>>2];ki=q[a+16>>2];fn=q[a+20>>2]-ki|0;gn=fn>>2;h:{if(gn>>>0<=524287){Fa(ln,524288-gn|0);break h}if((fn|0)==2097152){break h}q[a+20>>2]=ki+2097152}i:{ki=a+28|0;fn=q[ki>>2];gn=q[a+32>>2]-fn>>3;if(hn>>>0>gn>>>0){Dh(ki,hn-gn|0);fn=q[ki>>2];break i}if(hn>>>0<gn>>>0){q[a+32>>2]=(hn<<3)+fn}if(hn){break i}return 0}ki=0;gn=0;while(1){a=mn+(ki<<2)|0;kn=q[a>>2];jn=(ki<<3)+fn|0;q[jn+4>>2]=gn;q[jn>>2]=kn;a=q[a>>2]+gn|0;if(a>>>0>524288){break a}if(gn>>>0<a>>>0){kn=q[ln>>2];while(1){q[kn+(gn<<2)>>2]=ki;gn=gn+1|0;if((a|0)!=(gn|0)){continue}break}}gn=a;ki=ki+1|0;if((hn|0)!=(ki|0)){continue}break}return(a|0)==524288}return sn}function Oh(a,ki){var tn=0,un=0,vn=0,wn=0,xn=0,yn=0,zn=0,An=0,Bn=0;xn=T-16|0;T=xn;a:{b:{if(s[ki+38>>1]<=511){un=q[ki+12>>2];An=un;tn=q[ki+20>>2];vn=q[ki+16>>2];wn=vn+8|0;if(wn>>>0<8){tn=tn+1|0}yn=q[ki+8>>2];if((un|0)<(tn|0)?1:(un|0)<=(tn|0)?yn>>>0>=wn>>>0?0:1:0){break a}un=vn+q[ki>>2]|0;vn=r[un+4|0]|r[un+5|0]<<8|(r[un+6|0]<<16|r[un+7|0]<<24);un=r[un|0]|r[un+1|0]<<8|(r[un+2|0]<<16|r[un+3|0]<<24);q[xn+8>>2]=un;q[xn+12>>2]=vn;q[ki+16>>2]=wn;q[ki+20>>2]=tn;break b}if(!Eh(1,xn+8|0,ki)){break a}wn=q[ki+16>>2];tn=q[ki+20>>2];yn=q[ki+8>>2];An=q[ki+12>>2];un=q[xn+8>>2];vn=q[xn+12>>2]}zn=yn-wn|0;yn=An-(tn+(yn>>>0<wn>>>0)|0)|0;if((yn|0)==(vn|0)&un>>>0>zn>>>0|vn>>>0>yn>>>0){break a}vn=tn+vn|0;tn=wn;zn=tn+un|0;if(zn>>>0<tn>>>0){vn=vn+1|0}q[ki+16>>2]=zn;q[ki+20>>2]=vn;tn=un;if((tn|0)<1){break a}wn=wn+q[ki>>2]|0;q[a+40>>2]=wn;ki=a;c:{d:{e:{f:{g:{un=tn+ -1|0;vn=wn+un|0;switch((r[vn|0]>>>6)-1|0){case 2:break d;case 1:break e;case 0:break f;default:break g}}q[a+44>>2]=un;a=r[vn|0]&63;break c}if((tn|0)<2){break a}q[a+44>>2]=tn+ -2;a=(tn+wn|0)+ -2|0;a=r[a+1|0]<<8&16128|r[a|0];break c}if((tn|0)<3){break a}q[a+44>>2]=tn+ -3;a=(tn+wn|0)+ -3|0;a=r[a+1|0]<<8|r[a+2|0]<<16&4128768|r[a|0];break c}q[a+44>>2]=tn+ -4;a=(tn+wn|0)+ -4|0;a=r[a+2|0]<<16|r[a+3|0]<<24&1056964608|r[a+1|0]<<8|r[a|0]}a=a+2097152|0;q[ki+48>>2]=a;Bn=a>>>0<536870912}T=xn+16|0;return Bn}function Ph(a,ki){var Cn=0,En=0,Fn=0,Gn=0,Hn=0,In=0,Jn=0,Kn=0,Ln=0,Mn=0,Nn=0,On=0,Pn=0;a:{Cn=s[ki+38>>1];if(!Cn){break a}Jn=a+12|0;b:{if(Cn>>>0<=511){En=q[ki+12>>2];Cn=q[ki+20>>2];Fn=q[ki+16>>2];Hn=Fn+4|0;if(Hn>>>0<4){Cn=Cn+1|0}if((En|0)<(Cn|0)?1:(En|0)<=(Cn|0)?t[ki+8>>2]>=Hn>>>0?0:1:0){break a}Cn=Fn+q[ki>>2]|0;Fn=r[Cn|0]|r[Cn+1|0]<<8|(r[Cn+2|0]<<16|r[Cn+3|0]<<24);q[Jn>>2]=Fn;En=q[ki+20>>2];Hn=q[ki+16>>2]+4|0;if(Hn>>>0<4){En=En+1|0}Cn=ki;q[Cn+16>>2]=Hn;q[Cn+20>>2]=En;break b}if(!Ch(1,Jn,ki)){break a}Fn=q[Jn>>2]}En=q[a>>2];Cn=q[a+4>>2]-En>>2;c:{if(Fn>>>0>Cn>>>0){Fa(a,Fn-Cn|0);Fn=q[a+12>>2];break c}if(Fn>>>0>=Cn>>>0){break c}q[a+4>>2]=En+(Fn<<2)}if(!Fn){Pn=1;break a}Nn=q[ki+8>>2];Hn=q[ki+12>>2];while(1){Gn=q[ki+16>>2];Cn=q[ki+20>>2];if((Hn|0)<(Cn|0)?1:(Hn|0)<=(Cn|0)?Nn>>>0>Gn>>>0?0:1:0){break a}On=q[ki>>2];Kn=r[On+Gn|0];Gn=Gn+1|0;if(Gn>>>0<1){Cn=Cn+1|0}q[ki+16>>2]=Gn;q[ki+20>>2]=Cn;Ln=Kn>>>2;d:{e:{f:{Mn=Kn&3;if(Mn>>>0>3){En=0;break f}En=0;g:{switch(Mn-1|0){case 0:case 1:break f;case 2:break g;default:break e}}Cn=In+Ln|0;if(Cn>>>0>=Fn>>>0){return 0}Dn(q[a>>2]+(In<<2)|0,0,(Kn&252)+4|0);In=Cn;break d}while(1){if((Hn|0)<(Cn|0)?1:(Hn|0)<=(Cn|0)?Nn>>>0>Gn>>>0?0:1:0){return 0}Kn=r[Gn+On|0];Gn=Gn+1|0;if(Gn>>>0<1){Cn=Cn+1|0}q[ki+16>>2]=Gn;q[ki+20>>2]=Cn;Ln=Kn<<(En<<3|6)|Ln;En=En+1|0;if((Mn|0)!=(En|0)){continue}break}}q[q[a>>2]+(In<<2)>>2]=Ln}In=In+1|0;Fn=q[Jn>>2];if(In>>>0<Fn>>>0){continue}break}In=a+16|0;Jn=q[a>>2];ki=q[a+16>>2];Cn=q[a+20>>2]-ki|0;En=Cn>>2;h:{if(En>>>0<=1048575){Fa(In,1048576-En|0);break h}if((Cn|0)==4194304){break h}q[a+20>>2]=ki+4194304}i:{ki=a+28|0;Cn=q[ki>>2];En=q[a+32>>2]-Cn>>3;if(Fn>>>0>En>>>0){Dh(ki,Fn-En|0);Cn=q[ki>>2];break i}if(Fn>>>0<En>>>0){q[a+32>>2]=(Fn<<3)+Cn}if(Fn){break i}return 0}ki=0;En=0;while(1){a=Jn+(ki<<2)|0;Hn=q[a>>2];Gn=(ki<<3)+Cn|0;q[Gn+4>>2]=En;q[Gn>>2]=Hn;a=q[a>>2]+En|0;if(a>>>0>1048576){break a}if(En>>>0<a>>>0){Hn=q[In>>2];while(1){q[Hn+(En<<2)>>2]=ki;En=En+1|0;if((a|0)!=(En|0)){continue}break}}En=a;ki=ki+1|0;if((Fn|0)!=(ki|0)){continue}break}return(a|0)==1048576}return Pn}function Qh(a,ki){var Dn=0,Qn=0,Rn=0,Sn=0,Tn=0,Un=0,Vn=0,Wn=0,Xn=0;Tn=T-16|0;T=Tn;a:{b:{if(s[ki+38>>1]<=511){Qn=q[ki+12>>2];Wn=Qn;Dn=q[ki+20>>2];Rn=q[ki+16>>2];Sn=Rn+8|0;if(Sn>>>0<8){Dn=Dn+1|0}Un=q[ki+8>>2];if((Qn|0)<(Dn|0)?1:(Qn|0)<=(Dn|0)?Un>>>0>=Sn>>>0?0:1:0){break a}Qn=Rn+q[ki>>2]|0;Rn=r[Qn+4|0]|r[Qn+5|0]<<8|(r[Qn+6|0]<<16|r[Qn+7|0]<<24);Qn=r[Qn|0]|r[Qn+1|0]<<8|(r[Qn+2|0]<<16|r[Qn+3|0]<<24);q[Tn+8>>2]=Qn;q[Tn+12>>2]=Rn;q[ki+16>>2]=Sn;q[ki+20>>2]=Dn;break b}if(!Eh(1,Tn+8|0,ki)){break a}Sn=q[ki+16>>2];Dn=q[ki+20>>2];Un=q[ki+8>>2];Wn=q[ki+12>>2];Qn=q[Tn+8>>2];Rn=q[Tn+12>>2]}Vn=Un-Sn|0;Un=Wn-(Dn+(Un>>>0<Sn>>>0)|0)|0;if((Un|0)==(Rn|0)&Qn>>>0>Vn>>>0|Rn>>>0>Un>>>0){break a}Rn=Dn+Rn|0;Dn=Sn;Vn=Dn+Qn|0;if(Vn>>>0<Dn>>>0){Rn=Rn+1|0}q[ki+16>>2]=Vn;q[ki+20>>2]=Rn;Dn=Qn;if((Dn|0)<1){break a}Sn=Sn+q[ki>>2]|0;q[a+40>>2]=Sn;ki=a;c:{d:{e:{f:{g:{Qn=Dn+ -1|0;Rn=Sn+Qn|0;switch((r[Rn|0]>>>6)-1|0){case 2:break d;case 1:break e;case 0:break f;default:break g}}q[a+44>>2]=Qn;a=r[Rn|0]&63;break c}if((Dn|0)<2){break a}q[a+44>>2]=Dn+ -2;a=(Dn+Sn|0)+ -2|0;a=r[a+1|0]<<8&16128|r[a|0];break c}if((Dn|0)<3){break a}q[a+44>>2]=Dn+ -3;a=(Dn+Sn|0)+ -3|0;a=r[a+1|0]<<8|r[a+2|0]<<16&4128768|r[a|0];break c}q[a+44>>2]=Dn+ -4;a=(Dn+Sn|0)+ -4|0;a=r[a+2|0]<<16|r[a+3|0]<<24&1056964608|r[a+1|0]<<8|r[a|0]}a=a+4194304|0;q[ki+48>>2]=a;Xn=a>>>0<1073741824}T=Tn+16|0;return Xn}function Rh(a){Ij(a);q[a+44>>2]=0;q[a>>2]=11068}function Sh(a){a=a|0;if(q[a+44>>2]){return n[q[q[a>>2]+48>>2]](a)|0}return 0}function Th(a){a=a|0;var ki=0,Yn=0,Zn=0,_n=0,$n=0;q[a>>2]=13300;ki=q[a+20>>2];if(ki){q[a+24>>2]=ki;An(ki)}Zn=q[a+8>>2];if(Zn){ki=Zn;$n=a+12|0;Yn=q[$n>>2];_n=ki;a:{if((ki|0)==(Yn|0)){break a}while(1){Yn=Yn+ -4|0;ki=q[Yn>>2];q[Yn>>2]=0;if(ki){n[q[q[ki>>2]+4>>2]](ki)}if((Yn|0)!=(Zn|0)){continue}break}_n=q[a+8>>2]}ki=_n;q[$n>>2]=Zn;An(ki)}return a|0}function Uh(a,ao){a=a|0;ao=ao|0;a=q[a+48>>2];return n[q[q[a>>2]+20>>2]](a,ao)|0}function Vh(a){a=a|0;var ao=0,bo=0,co=0,eo=0;ao=q[a+32>>2];co=q[ao+16>>2];eo=q[ao+12>>2];bo=q[ao+20>>2];if((eo|0)>(bo|0)?1:(eo|0)>=(bo|0)?t[ao+8>>2]<=co>>>0?0:1:0){eo=r[co+q[ao>>2]|0];co=co+1|0;if(co>>>0<1){bo=bo+1|0}q[ao+16>>2]=co;q[ao+20>>2]=bo;ao=q[a+48>>2];q[a+48>>2]=0;if(ao){n[q[q[ao>>2]+4>>2]](ao)}a:{b:{if(eo>>>0>2){break b}c:{switch(eo-1|0){default:bo=Mm(384);bi(bo);ao=q[a+48>>2];q[a+48>>2]=bo;if(!ao){break a}n[q[q[ao>>2]+4>>2]](ao);break b;case 0:bo=Mm(424);Ei(bo);ao=q[a+48>>2];q[a+48>>2]=bo;if(!ao){break a}n[q[q[ao>>2]+4>>2]](ao);break b;case 1:break c}}bo=Mm(440);Ji(bo);ao=q[a+48>>2];q[a+48>>2]=bo;if(!ao){break a}n[q[q[ao>>2]+4>>2]](ao)}bo=q[a+48>>2];if(bo){break a}return 0}a=n[q[q[bo>>2]+8>>2]](bo,a)|0}else{a=0}return a|0}function Wh(a){a=a|0;a=q[a+48>>2];return n[q[q[a>>2]+24>>2]](a)|0}function Xh(a){a=a|0;a=q[a+48>>2];return n[q[q[a>>2]+28>>2]](a)|0}function Yh(a){a=a|0;var fo=0,go=0,ho=0,io=0,jo=0;q[a>>2]=11164;fo=a+48|0;go=q[fo>>2];q[fo>>2]=0;if(go){n[q[q[go>>2]+4>>2]](go)}q[a>>2]=13300;fo=q[a+20>>2];if(fo){q[a+24>>2]=fo;An(fo)}go=q[a+8>>2];if(go){fo=go;jo=a+12|0;ho=q[jo>>2];io=fo;a:{if((fo|0)==(ho|0)){break a}while(1){ho=ho+ -4|0;fo=q[ho>>2];q[ho>>2]=0;if(fo){n[q[q[fo>>2]+4>>2]](fo)}if((go|0)!=(ho|0)){continue}break}io=q[a+8>>2]}fo=io;q[jo>>2]=go;An(fo)}return a|0}function Zh(a){a=a|0;var ko=0,lo=0,mo=0,no=0,oo=0;q[a>>2]=11164;ko=a+48|0;lo=q[ko>>2];q[ko>>2]=0;if(lo){n[q[q[lo>>2]+4>>2]](lo)}q[a>>2]=13300;ko=q[a+20>>2];if(ko){q[a+24>>2]=ko;An(ko)}lo=q[a+8>>2];if(lo){ko=lo;oo=a+12|0;mo=q[oo>>2];no=ko;a:{if((ko|0)==(mo|0)){break a}while(1){mo=mo+ -4|0;ko=q[mo>>2];q[mo>>2]=0;if(ko){n[q[q[ko>>2]+4>>2]](ko)}if((lo|0)!=(mo|0)){continue}break}no=q[a+8>>2]}ko=no;q[oo>>2]=lo;An(ko)}An(a)}function _h(a){a=a|0;a=q[a+48>>2];return n[q[q[a>>2]+36>>2]](a)|0}function $h(a,po){a=a|0;po=po|0;a=q[a+48>>2];return n[q[q[a>>2]+12>>2]](a,po)|0}function ai(a,po){a=a|0;po=po|0;a=q[a+48>>2];return n[q[q[a>>2]+16>>2]](a,po)|0}function bi(a){q[a>>2]=11272;Dn(a+4|0,0,80);q[a+96>>2]=0;q[a+100>>2]=0;q[a+92>>2]=-1;q[a+84>>2]=-1;q[a+88>>2]=-1;q[a+104>>2]=0;q[a+108>>2]=0;q[a+112>>2]=0;q[a+116>>2]=0;q[a+120>>2]=0;q[a+124>>2]=0;q[a+128>>2]=0;q[a+132>>2]=0;q[a+136>>2]=0;q[a+140>>2]=0;q[a+144>>2]=0;q[a+148>>2]=0;q[a+156>>2]=0;q[a+160>>2]=0;q[a+152>>2]=1065353216;q[a+164>>2]=0;q[a+168>>2]=0;q[a+172>>2]=0;q[a+176>>2]=0;q[a+180>>2]=0;q[a+184>>2]=0;q[a+188>>2]=0;q[a+192>>2]=0;q[a+196>>2]=0;q[a+200>>2]=0;q[a+204>>2]=0;q[a+208>>2]=0;q[a+212>>2]=-1;q[a+216>>2]=0;q[a+220>>2]=0;q[a+224>>2]=0;ci(a+232|0)}function ci(a){Yj(a);Yj(a+40|0);ah(a+80|0);Yj(a+96|0);q[a+144>>2]=0;q[a+136>>2]=0;q[a+140>>2]=0}function di(a,po){a=a|0;po=po|0;q[a+4>>2]=po;return 1}function ei(a,po){a=a|0;po=po|0;var qo=0,ro=0,so=0,to=0,uo=0;qo=q[a+216>>2];to=a+220|0;if((qo|0)!=q[to>>2]){while(1){a:{qo=q[w(so,144)+qo>>2];if((qo|0)<0){break a}uo=q[a+4>>2];ro=q[uo+8>>2];if((qo|0)>=q[uo+12>>2]-ro>>2){break a}qo=q[ro+(qo<<2)>>2];if((n[q[q[qo>>2]+24>>2]](qo)|0)<1){break a}ro=0;while(1){if((n[q[q[qo>>2]+20>>2]](qo,ro)|0)!=(po|0)){ro=ro+1|0;if((ro|0)<(n[q[q[qo>>2]+24>>2]](qo)|0)){continue}break a}break}a=q[a+216>>2]+w(so,144)|0;return(r[a+100|0]?a+4|0:0)|0}so=so+1|0;qo=q[a+216>>2];if(so>>>0<(q[to>>2]-qo|0)/144>>>0){continue}break}}return 0}function fi(a,po){a=a|0;po=po|0;var vo=0,wo=0,xo=0,yo=0,zo=0;vo=q[a+216>>2];yo=a+220|0;if((vo|0)!=q[yo>>2]){while(1){a:{vo=q[w(xo,144)+vo>>2];if((vo|0)<0){break a}zo=q[a+4>>2];wo=q[zo+8>>2];if((vo|0)>=q[zo+12>>2]-wo>>2){break a}vo=q[wo+(vo<<2)>>2];if((n[q[q[vo>>2]+24>>2]](vo)|0)<1){break a}wo=0;while(1){if((n[q[q[vo>>2]+20>>2]](vo,wo)|0)!=(po|0)){wo=wo+1|0;if((wo|0)<(n[q[q[vo>>2]+24>>2]](vo)|0)){continue}break a}break}return(q[a+216>>2]+w(xo,144)|0)+104|0}xo=xo+1|0;vo=q[a+216>>2];if(xo>>>0<(q[yo>>2]-vo|0)/144>>>0){continue}break}}return a+184|0}function gi(a,po){a=a|0;po=po|0;var Ao=0,Bo=0,Co=0,Do=0,Eo=0,Fo=0,Go=0,Ho=0,Io=0,Jo=0,Ko=0,Lo=0,Mo=0,No=0,Oo=0;Do=T-80|0;T=Do;a:{b:{Mo=q[a+4>>2];Ao=q[Mo+32>>2];Io=q[Ao+8>>2];Ho=q[Ao+16>>2];Ko=q[Ao+12>>2];Bo=Ko;Fo=q[Ao+20>>2];Eo=Fo;c:{if((Bo|0)<(Eo|0)?1:(Bo|0)<=(Eo|0)?Io>>>0>Ho>>>0?0:1:0){break c}No=q[Ao>>2];Jo=r[No+Ho|0];Bo=Fo;Go=Ho+1|0;if(Go>>>0<1){Bo=Bo+1|0}Eo=Ao;q[Ao+16>>2]=Go;q[Ao+20>>2]=Bo;if((Ko|0)<(Bo|0)?1:(Ko|0)<=(Bo|0)?Io>>>0>Go>>>0?0:1:0){break c}Oo=r[Go+No|0];Bo=Fo;Go=Ho+2|0;if(Go>>>0<2){Bo=Bo+1|0}q[Ao+16>>2]=Go;q[Eo+20>>2]=Bo;Lo=Jo<<24>>24;d:{if((Lo|0)>=0){Eo=q[a+216>>2];if((q[a+220>>2]-Eo|0)/144>>>0<=Jo>>>0){break c}Eo=Eo+w(Jo,144)|0;if(q[Eo>>2]<=-1){break d}break c}if(q[a+212>>2]>-1){break c}Eo=a+212|0}q[Eo>>2]=po;Eo=0;Co=s[Mo+36>>1];if((Co<<24|Co<<8&16711680)>>>16>>>0>=258){Co=0;if((Ko|0)<(Bo|0)?1:(Ko|0)<=(Bo|0)?Io>>>0>Go>>>0?0:1:0){break c}Eo=r[Go+No|0];Bo=Ho+3|0;if(Bo>>>0<3){Fo=Fo+1|0}q[Ao+16>>2]=Bo;q[Ao+20>>2]=Fo}e:{f:{g:{if(!Oo){if((Lo|0)<=-1){Ao=a+184|0}else{Ao=q[a+216>>2]+w(Jo,144)|0;o[Ao+100|0]=0;Ao=Ao+104|0}Co=0;if(Eo>>>0>1){break c}if(!(Eo-1)){break g}hi(Do+16|0,a,Ao);break f}Co=0;if(Eo|(Lo|0)<0){break c}Fo=q[Mo+44>>2];Co=q[a+216>>2];Ao=Mm(80);q[Ao>>2]=12884;q[Ao+76>>2]=0;q[Ao+68>>2]=Fo;Bo=Ao+12|0;q[Bo>>2]=0;q[Bo+4>>2]=0;q[Ao+4>>2]=0;Eo=Ao+20|0;q[Eo>>2]=0;q[Eo+4>>2]=0;Ko=Ao+28|0;Ho=Ko;q[Ho>>2]=0;q[Ho+4>>2]=0;q[Ao+36>>2]=0;q[Ao+40>>2]=0;Ho=Ao+44|0;q[Ho>>2]=0;q[Ho+4>>2]=0;q[Ao+52>>2]=0;Co=Co+w(Jo,144)|0;Jo=Co+104|0;q[Ao+72>>2]=Jo;q[Ao- -64>>2]=0;Mo=Ao+56|0;Io=Mo;q[Io>>2]=0;q[Io+4>>2]=0;q[Ao+8>>2]=11760;Io=Do+56|0;q[Io>>2]=0;q[Io+4>>2]=0;q[Do+48>>2]=0;q[Do+52>>2]=0;No=Do+32|0;Go=No;q[Go>>2]=0;q[Go+4>>2]=0;q[Do+72>>2]=0;q[Do+40>>2]=0;q[Do+44>>2]=0;q[Do+24>>2]=0;q[Do+28>>2]=0;q[Do+64>>2]=0;q[Do+68>>2]=0;q[Do+16>>2]=11760;Go=Co+4|0;q[Do+20>>2]=Go;Co=q[Co+68>>2];Lo=q[Co>>2];Co=q[Co+4>>2];o[Do+79|0]=0;bb(Do+40|0,(Co-Lo>>2>>>0)/3|0,Do+79|0);Co=q[Do+20>>2];Lo=q[Co+56>>2];Co=q[Co+52>>2];o[Do+79|0]=0;bb(Do+52|0,Lo-Co>>2,Do+79|0);q[Do+36>>2]=Ao;q[No>>2]=Fo;Fo=Do+28|0;q[Fo>>2]=Jo;q[Do+24>>2]=Go;q[Ko>>2]=Ao;Co=q[Fo+4>>2];q[Eo>>2]=q[Fo>>2];q[Eo+4>>2]=Co;Fo=q[Do+24>>2];q[Bo>>2]=q[Do+20>>2];q[Bo+4>>2]=Fo;Fo=Ao;Co=q[Do+44>>2];if(Co){Bo=Ao+32|0;h:{if(Co>>>0<=q[Ao+40>>2]<<5>>>0){Eo=Co+ -1>>>5;Co=q[Bo>>2];break h}Bo=q[Bo>>2];if(Bo){An(Bo);q[Ao+40>>2]=0;q[Ao+32>>2]=0;q[Ao+36>>2]=0;Co=q[Do+44>>2]}if((Co|0)<=-1){break b}Eo=Co+ -1>>>5;Bo=Eo+1|0;Co=Mm(Bo<<2);q[Ao+40>>2]=Bo;q[Ao+36>>2]=0;q[Ao+32>>2]=Co}En(Co,q[Do+40>>2],(Eo<<2)+4|0);Bo=q[Do+44>>2]}else{Bo=0}q[Fo+36>>2]=Bo;Fo=Ao;Co=q[Io>>2];if(Co){i:{if(Co>>>0<=q[Ao+52>>2]<<5>>>0){Bo=Co+ -1>>>5;Co=q[Ho>>2];break i}Bo=q[Ho>>2];if(Bo){An(Bo);q[Ao+52>>2]=0;q[Ao+44>>2]=0;q[Ao+48>>2]=0;Co=q[Do+56>>2]}if((Co|0)<=-1){break a}Bo=Co+ -1>>>5;Eo=Bo+1|0;Co=Mm(Eo<<2);q[Ao+52>>2]=Eo;q[Ao+48>>2]=0;q[Ao+44>>2]=Co}En(Co,q[Do+52>>2],(Bo<<2)+4|0);Bo=q[Do+56>>2]}else{Bo=0}q[Fo+48>>2]=Bo;vd(Mo,q[Do+64>>2],q[Do+68>>2]);q[Do+16>>2]=11760;Fo=q[Do+64>>2];if(Fo){q[Do+68>>2]=Fo;An(Fo)}q[Do+16>>2]=12012;Fo=q[Do+52>>2];if(Fo){An(Fo)}Fo=q[Do+40>>2];if(!Fo){break e}An(Fo);break e}ii(Do+16|0,a,Ao)}Ao=q[Do+16>>2];if(!Ao){break c}}Fo=Mm(64);q[Do+8>>2]=Ao;Ge(Fo,Do+8|0);Ao=q[Do+8>>2];q[Do+8>>2]=0;if(Ao){n[q[q[Ao>>2]+4>>2]](Ao)}if((po|0)>=0){a=q[a+4>>2];Co=a+8|0;Ao=q[a+12>>2];Jo=q[a+8>>2];Bo=Ao-Jo>>2;j:{if((Bo|0)>(po|0)){break j}Eo=po+1|0;if(Bo>>>0<=po>>>0){ji(Co,Eo-Bo|0);break j}if(Eo>>>0>=Bo>>>0){break j}Eo=Jo+(Eo<<2)|0;if((Eo|0)!=(Ao|0)){while(1){Ao=Ao+ -4|0;Bo=q[Ao>>2];q[Ao>>2]=0;if(Bo){n[q[q[Bo>>2]+4>>2]](Bo)}if((Ao|0)!=(Eo|0)){continue}break}}q[a+12>>2]=Eo}po=q[Co>>2]+(po<<2)|0;a=q[po>>2];q[po>>2]=Fo;Co=1;if(!a){break c}n[q[q[a>>2]+4>>2]](a);break c}n[q[q[Fo>>2]+4>>2]](Fo);Co=0}T=Do+80|0;return Co|0}bn();F()}bn();F()}function hi(a,po,Po){var Qo=0,Ro=0,So=0,To=0,Uo=0,Vo=0,Wo=0,Xo=0,Yo=0,Zo=0,_o=0,$o=0;Qo=T+ -64|0;T=Qo;So=q[q[po+4>>2]+44>>2];Ro=Mm(80);q[Ro>>2]=12592;q[Ro+76>>2]=0;q[Ro+72>>2]=Po;q[Ro+68>>2]=So;To=Ro+12|0;q[To>>2]=0;q[To+4>>2]=0;q[Ro+4>>2]=0;Xo=Ro+20|0;Uo=Xo;q[Uo>>2]=0;q[Uo+4>>2]=0;Zo=Ro+28|0;Uo=Zo;q[Uo>>2]=0;q[Uo+4>>2]=0;q[Ro+36>>2]=0;q[Ro+40>>2]=0;Uo=Ro+44|0;q[Uo>>2]=0;q[Uo+4>>2]=0;q[Ro+52>>2]=0;q[Ro- -64>>2]=0;_o=Ro+56|0;Wo=_o;q[Wo>>2]=0;q[Wo+4>>2]=0;q[Ro+8>>2]=12756;po=q[po+8>>2];Wo=Qo+40|0;q[Wo>>2]=0;q[Wo+4>>2]=0;q[Qo+32>>2]=0;q[Qo+36>>2]=0;$o=Qo+16|0;Vo=$o;q[Vo>>2]=0;q[Vo+4>>2]=0;q[Qo+56>>2]=0;q[Qo+24>>2]=0;q[Qo+28>>2]=0;q[Qo+8>>2]=0;q[Qo+12>>2]=0;q[Qo+48>>2]=0;q[Qo+52>>2]=0;q[Qo>>2]=12756;q[Qo+4>>2]=po;Vo=q[po>>2];Yo=q[po+4>>2];o[Qo+63|0]=0;bb(Qo+24|0,(Yo-Vo>>2>>>0)/3|0,Qo+63|0);Vo=q[Qo+4>>2];Yo=q[Vo+28>>2];Vo=q[Vo+24>>2];o[Qo+63|0]=0;bb(Qo+36|0,Yo-Vo>>2,Qo+63|0);q[Qo+20>>2]=Ro;q[$o>>2]=So;So=Qo+12|0;q[So>>2]=Po;q[Qo+8>>2]=po;q[Zo>>2]=Ro;po=q[So+4>>2];q[Xo>>2]=q[So>>2];q[Xo+4>>2]=po;po=q[Qo+8>>2];q[To>>2]=q[Qo+4>>2];q[To+4>>2]=po;a:{b:{Po=Ro;po=q[Qo+28>>2];if(po){So=Ro+32|0;c:{if(po>>>0<=q[Ro+40>>2]<<5>>>0){To=po+ -1>>>5;po=q[So>>2];break c}So=q[So>>2];if(So){An(So);q[Ro+40>>2]=0;q[Ro+32>>2]=0;q[Ro+36>>2]=0;po=q[Qo+28>>2]}if((po|0)<=-1){break b}To=po+ -1>>>5;So=To+1|0;po=Mm(So<<2);q[Ro+40>>2]=So;q[Ro+36>>2]=0;q[Ro+32>>2]=po}En(po,q[Qo+24>>2],(To<<2)+4|0);po=q[Qo+28>>2]}else{po=0}q[Po+36>>2]=po;Xo=Ro;po=q[Wo>>2];if(po){d:{if(po>>>0<=q[Ro+52>>2]<<5>>>0){Po=po+ -1>>>5;po=q[Uo>>2];break d}Po=q[Uo>>2];if(Po){An(Po);q[Ro+52>>2]=0;q[Ro+44>>2]=0;q[Ro+48>>2]=0;po=q[Qo+40>>2]}if((po|0)<=-1){break a}Po=po+ -1>>>5;To=Po+1|0;po=Mm(To<<2);q[Ro+52>>2]=To;q[Ro+48>>2]=0;q[Ro+44>>2]=po}En(po,q[Qo+36>>2],(Po<<2)+4|0);po=q[Qo+40>>2]}else{po=0}q[Xo+48>>2]=po;vd(_o,q[Qo+48>>2],q[Qo+52>>2]);q[a>>2]=Ro;q[Qo>>2]=12756;a=q[Qo+48>>2];if(a){q[Qo+52>>2]=a;An(a)}q[Qo>>2]=12572;a=q[Qo+36>>2];if(a){An(a)}a=q[Qo+24>>2];if(a){An(a)}T=Qo- -64|0;return}bn();F()}bn();F()}function ii(a,po,Po){var ap=0,bp=0,cp=0,dp=0,ep=0,fp=0,gp=0;ap=T-112|0;T=ap;gp=q[q[po+4>>2]+44>>2];bp=Mm(120);q[bp>>2]=12124;q[bp+116>>2]=0;q[bp+112>>2]=Po;q[bp+108>>2]=gp;q[bp+12>>2]=0;q[bp+16>>2]=0;q[bp+4>>2]=0;q[bp+20>>2]=0;q[bp+24>>2]=0;q[bp+28>>2]=0;q[bp+32>>2]=0;q[bp+36>>2]=0;q[bp+40>>2]=0;q[bp+44>>2]=0;q[bp+48>>2]=0;q[bp+52>>2]=0;q[bp+56>>2]=0;q[bp+60>>2]=0;q[bp+8>>2]=12336;ep=bp- -64|0;q[ep>>2]=0;q[ep+4>>2]=0;q[bp+72>>2]=0;q[bp+76>>2]=0;q[bp+80>>2]=0;q[bp+84>>2]=0;q[bp+88>>2]=0;q[bp+104>>2]=0;q[bp+96>>2]=0;q[bp+100>>2]=0;po=q[po+8>>2];q[ap+48>>2]=0;q[ap+52>>2]=0;q[ap+40>>2]=0;q[ap+44>>2]=0;ep=ap+24|0;cp=ep;q[cp>>2]=0;q[cp+4>>2]=0;cp=ap- -64|0;q[cp>>2]=0;q[cp+4>>2]=0;q[ap+72>>2]=0;q[ap+76>>2]=0;cp=ap+80|0;q[cp>>2]=0;q[cp+4>>2]=0;q[ap+88>>2]=0;q[ap+104>>2]=0;q[ap+32>>2]=0;q[ap+36>>2]=0;q[ap+16>>2]=0;q[ap+20>>2]=0;q[ap+56>>2]=0;q[ap+60>>2]=0;q[ap+8>>2]=12336;q[ap+96>>2]=0;q[ap+100>>2]=0;q[ap+12>>2]=po;dp=q[po>>2];fp=q[po+4>>2];o[ap+111|0]=0;bb(ap+32|0,(fp-dp>>2>>>0)/3|0,ap+111|0);dp=q[ap+12>>2];fp=q[dp+28>>2];dp=q[dp+24>>2];o[ap+111|0]=0;bb(ap+44|0,fp-dp>>2,ap+111|0);q[ap+28>>2]=bp;q[ep>>2]=gp;q[ap+20>>2]=Po;q[ap+16>>2]=po;ki(bp,ap+8|0);q[a>>2]=bp;q[ap+8>>2]=12336;a=q[ap+96>>2];if(a){q[ap+100>>2]=a;An(a)}a=q[cp>>2];if(a){q[ap+84>>2]=a;An(a)}a=q[ap+68>>2];if(a){q[ap+72>>2]=a;An(a)}a=q[ap+56>>2];if(a){q[ap+60>>2]=a;An(a)}q[ap+8>>2]=12572;a=q[ap+44>>2];if(a){An(a)}a=q[ap+32>>2];if(a){An(a)}T=ap+112|0}function ji(a,po){var Po=0,hp=0,ip=0,jp=0,kp=0,lp=0,mp=0,np=0,op=0;hp=q[a+8>>2];ip=a+4|0;Po=q[ip>>2];if(hp-Po>>2>>>0>=po>>>0){a=po<<2;np=ip,op=Dn(Po,0,a)+a|0,q[np>>2]=op;return}a:{ip=q[a>>2];jp=Po-ip>>2;kp=jp+po|0;if(kp>>>0<1073741824){jp=jp<<2;hp=hp-ip|0;mp=hp>>1;hp=hp>>2>>>0<536870911?mp>>>0<kp>>>0?kp:mp:1073741823;if(hp){if(hp>>>0>=1073741824){break a}lp=Mm(hp<<2)}jp=jp+lp|0;Dn(jp,0,po<<2);po=(kp<<2)+lp|0;kp=(hp<<2)+lp|0;if((Po|0)!=(ip|0)){while(1){Po=Po+ -4|0;hp=q[Po>>2];q[Po>>2]=0;jp=jp+ -4|0;q[jp>>2]=hp;if((Po|0)!=(ip|0)){continue}break}ip=q[a>>2];Po=q[a+4>>2]}q[a>>2]=jp;q[a+8>>2]=kp;q[a+4>>2]=po;if((Po|0)!=(ip|0)){while(1){Po=Po+ -4|0;a=q[Po>>2];q[Po>>2]=0;if(a){n[q[q[a>>2]+4>>2]](a)}if((Po|0)!=(ip|0)){continue}break}}if(ip){An(ip)}return}bn();F()}ab(12024);F()}function ki(a,po){var pp=0;pp=q[po+8>>2];q[a+12>>2]=q[po+4>>2];q[a+16>>2]=pp;q[a+28>>2]=q[po+20>>2];pp=q[po+16>>2];q[a+20>>2]=q[po+12>>2];q[a+24>>2]=pp;$i(a+32|0,po+24|0);$i(a+44|0,po+36|0);if((a+8|0)==(po|0)){q[a+92>>2]=q[po+84>>2];return}vd(a+56|0,q[po+48>>2],q[po+52>>2]);vd(a+68|0,q[po+60>>2],q[po- -64>>2]);vd(a+80|0,q[po+72>>2],q[po+76>>2]);q[a+92>>2]=q[po+84>>2];hd(a+96|0,q[po+88>>2],q[po+92>>2])}function li(a,po,qp){a=a|0;po=po|0;qp=qp|0;var rp=0,sp=0;rp=T-16|0;T=rp;q[a+4>>2]=po;po=q[po+64>>2];sp=q[po+4>>2];po=q[po>>2];o[rp+15|0]=0;bb(a+24|0,(sp-po>>2>>>0)/3|0,rp+15|0);po=q[a+4>>2];sp=q[po+56>>2];po=q[po+52>>2];o[rp+14|0]=0;bb(a+36|0,sp-po>>2,rp+14|0);po=q[qp+12>>2];q[a+16>>2]=q[qp+8>>2];q[a+20>>2]=po;po=q[qp+4>>2];q[a+8>>2]=q[qp>>2];q[a+12>>2]=po;T=rp+16|0}function mi(a){a=a|0;var po=0;q[a>>2]=11760;po=q[a+48>>2];if(po){q[a+52>>2]=po;An(po)}q[a>>2]=12012;po=q[a+36>>2];if(po){An(po)}po=q[a+24>>2];if(po){An(po)}return a|0}function ni(a){a=a|0;var qp=0,tp=0,up=0,vp=0,wp=0,xp=0,yp=0,zp=0,Ap=0,Bp=0,Cp=0,Dp=0,Ep=0,Fp=0,Gp=0;zp=T+ -64|0;T=zp;q[a+132>>2]=0;if(q[a+148>>2]){up=a+144|0;tp=q[up>>2];if(tp){while(1){qp=q[tp>>2];An(tp);tp=qp;if(qp){continue}break}}q[up>>2]=0;qp=q[a+140>>2];if(qp){up=a+136|0;tp=0;while(1){q[q[up>>2]+(tp<<2)>>2]=0;tp=tp+1|0;if((qp|0)!=(tp|0)){continue}break}}q[a+148>>2]=0}a:{b:{c:{d:{e:{f:{tp=q[a+4>>2];up=r[tp+36|0];qp=up<<8|r[tp+37|0];g:{if(qp>>>0>513){break g}xp=q[tp+32>>2];if(qp>>>0<=511){wp=q[xp+12>>2];qp=q[xp+20>>2];yp=q[xp+16>>2];vp=yp+4|0;if(vp>>>0<4){qp=qp+1|0}Ap=vp;vp=qp;if((wp|0)<(qp|0)?1:(wp|0)<=(qp|0)?t[xp+8>>2]>=Ap>>>0?0:1:0){break f}qp=yp+q[xp>>2]|0;qp=r[qp|0]|r[qp+1|0]<<8|(r[qp+2|0]<<16|r[qp+3|0]<<24);q[zp>>2]=qp;q[xp+16>>2]=Ap;q[xp+20>>2]=vp;q[a+132>>2]=qp;break g}if(!oi(1,zp,xp)){break f}tp=q[a+4>>2];up=r[tp+36|0];q[a+132>>2]=q[zp>>2]}tp=q[tp+32>>2];h:{i:{j:{if((up&255)>>>0<=1){up=0;xp=q[tp+12>>2];qp=q[tp+20>>2];wp=q[tp+16>>2];vp=wp+4|0;if(vp>>>0<4){qp=qp+1|0}yp=vp;vp=qp;if((xp|0)<(qp|0)?1:(xp|0)<=(qp|0)?t[tp+8>>2]>=yp>>>0?0:1:0){break a}qp=wp+q[tp>>2]|0;qp=r[qp|0]|r[qp+1|0]<<8|(r[qp+2|0]<<16|r[qp+3|0]<<24);q[zp+60>>2]=qp;q[tp+16>>2]=yp;q[tp+20>>2]=vp;q[a+156>>2]=qp;Dp=a+156|0;break j}up=0;if(!oi(1,zp+60|0,tp)){break a}qp=q[a+4>>2];tp=q[qp+32>>2];qp=r[qp+36|0];q[a+156>>2]=q[zp+60>>2];Dp=a+156|0;if(qp>>>0>1){break i}}xp=q[tp+12>>2];qp=q[tp+20>>2];wp=q[tp+16>>2];vp=wp+4|0;if(vp>>>0<4){qp=qp+1|0}Ap=vp;vp=qp;if((xp|0)<(qp|0)?1:(xp|0)<=(qp|0)?t[tp+8>>2]>=Ap>>>0?0:1:0){break a}qp=wp+q[tp>>2]|0;yp=r[qp|0]|r[qp+1|0]<<8|(r[qp+2|0]<<16|r[qp+3|0]<<24);q[zp+56>>2]=yp;q[tp+16>>2]=Ap;q[tp+20>>2]=vp;break h}if(!oi(1,zp+56|0,tp)){break a}yp=q[zp+56>>2]}if(yp>>>0>1431655765|t[Dp>>2]>w(yp,3)>>>0){break a}Bp=q[a+4>>2];vp=q[Bp+32>>2];Fp=q[vp+8>>2];Cp=q[vp+16>>2];xp=q[vp+12>>2];qp=xp;tp=q[vp+20>>2];if((qp|0)<(tp|0)?1:(qp|0)<=(tp|0)?Fp>>>0>Cp>>>0?0:1:0){break a}Gp=q[vp>>2];Ap=r[Gp+Cp|0];qp=tp;Ep=Cp+1|0;if(Ep>>>0<1){qp=qp+1|0}q[vp+16>>2]=Ep;q[vp+20>>2]=qp;k:{if(r[Bp+36|0]<=1){qp=tp;tp=Cp+5|0;if(tp>>>0<5){qp=qp+1|0}wp=tp;tp=qp;if((xp|0)<(qp|0)?1:(xp|0)<=(qp|0)?Fp>>>0>=wp>>>0?0:1:0){break a}qp=Ep+Gp|0;xp=r[qp|0]|r[qp+1|0]<<8|(r[qp+2|0]<<16|r[qp+3|0]<<24);q[zp+52>>2]=xp;q[vp+16>>2]=wp;q[vp+20>>2]=tp;break k}if(!oi(1,zp+52|0,vp)){break a}xp=q[zp+52>>2]}if(yp>>>0<xp>>>0|yp>>>0>((xp>>>0)/3|0)+xp>>>0){break a}qp=q[a+4>>2];vp=q[qp+32>>2];l:{if(r[qp+36|0]<=1){wp=q[vp+12>>2];qp=q[vp+20>>2];Cp=q[vp+16>>2];tp=Cp+4|0;if(tp>>>0<4){qp=qp+1|0}Bp=tp;tp=qp;if((wp|0)<(qp|0)?1:(wp|0)<=(qp|0)?t[vp+8>>2]>=Bp>>>0?0:1:0){break a}qp=Cp+q[vp>>2]|0;wp=r[qp|0]|r[qp+1|0]<<8|(r[qp+2|0]<<16|r[qp+3|0]<<24);q[zp+48>>2]=wp;q[vp+16>>2]=Bp;q[vp+20>>2]=tp;break l}if(!oi(1,zp+48|0,vp)){break a}wp=q[zp+48>>2]}if(wp>>>0>xp>>>0){break a}q[a+28>>2]=q[a+24>>2];tp=Mm(88);jk(tp);qp=q[a+8>>2];q[a+8>>2]=tp;vp=a+8|0;if(qp){wa(vp,qp);if(!q[vp>>2]){break a}}qp=q[a+160>>2];q[a+164>>2]=qp;m:{if(q[a+168>>2]-qp>>2>>>0>=yp>>>0){break m}if(yp>>>0>=1073741824){break e}up=yp<<2;tp=Mm(up);q[a+164>>2]=tp;q[a+160>>2]=tp;q[a+168>>2]=tp+up;if(!qp){break m}An(qp)}qp=q[a+172>>2];q[a+176>>2]=qp;n:{if(q[a+180>>2]-qp>>2>>>0>=yp>>>0){break n}if(yp>>>0>=1073741824){break d}up=yp<<2;tp=Mm(up);q[a+176>>2]=tp;q[a+172>>2]=tp;q[a+180>>2]=tp+up;if(!qp){break n}An(qp)}q[a+92>>2]=-1;q[a+84>>2]=-1;q[a+88>>2]=-1;q[a+40>>2]=q[a+36>>2];q[a- -64>>2]=0;q[a+52>>2]=q[a+48>>2];q[a+76>>2]=q[a+72>>2];Cp=a+216|0;tp=q[a+220>>2];up=q[a+216>>2];if((tp|0)==(up|0)){break c}while(1){qp=q[tp+ -12>>2];if(qp){q[tp+ -8>>2]=qp;An(qp)}qp=q[tp+ -28>>2];if(qp){q[tp+ -24>>2]=qp;An(qp)}qp=tp+ -144|0;Bp=q[tp+ -40>>2];if(Bp){q[tp+ -36>>2]=Bp;An(Bp)}pi(tp+ -140|0);tp=qp;if((up|0)!=(qp|0)){continue}break}qp=q[Cp>>2];break b}up=0;break a}ab(12024);F()}ab(12024);F()}qp=up}q[a+220>>2]=up;tp=(up-qp|0)/144|0;o:{if(tp>>>0<Ap>>>0){qi(Cp,Ap-tp|0);break o}if(tp>>>0<=Ap>>>0){break o}tp=qp+w(Ap,144)|0;if((tp|0)!=(up|0)){while(1){qp=q[up+ -12>>2];if(qp){q[up+ -8>>2]=qp;An(qp)}qp=q[up+ -28>>2];if(qp){q[up+ -24>>2]=qp;An(qp)}qp=up+ -144|0;Bp=q[up+ -40>>2];if(Bp){q[up+ -36>>2]=Bp;An(Bp)}pi(up+ -140|0);up=qp;if((qp|0)!=(tp|0)){continue}break}}q[a+220>>2]=tp}up=0;if(!tk(q[vp>>2],yp,q[Dp>>2]+wp|0)){break a}qp=q[a+156>>2];o[zp|0]=1;bb(a+120|0,qp+wp|0,zp);tp=q[a+4>>2];qp=s[tp+36>>1];qp=(qp<<24|qp<<8&16711680)>>>16;p:{if(qp>>>0<=513){wp=q[tp+32>>2];q:{if(qp>>>0<=511){yp=q[wp+12>>2];qp=q[wp+20>>2];Dp=q[wp+16>>2];tp=Dp+4|0;if(tp>>>0<4){qp=qp+1|0}Bp=tp;tp=qp;if((yp|0)<(qp|0)?1:(yp|0)<=(qp|0)?t[wp+8>>2]>=Bp>>>0?0:1:0){break a}qp=Dp+q[wp>>2]|0;yp=r[qp|0]|r[qp+1|0]<<8|(r[qp+2|0]<<16|r[qp+3|0]<<24);q[zp+44>>2]=yp;q[wp+16>>2]=Bp;q[wp+20>>2]=tp;break q}if(!oi(1,zp+44|0,wp)){break a}yp=q[zp+44>>2]}if(!yp){break a}qp=q[q[a+4>>2]+32>>2];tp=q[qp+8>>2];wp=q[qp+16>>2];qp=q[qp+12>>2]-(q[qp+20>>2]+(tp>>>0<wp>>>0)|0)|0;if((qp|0)<0?1:(qp|0)<=0?tp-wp>>>0>=yp>>>0?0:1:0){break a}wp=Yj(zp);tp=q[q[a+4>>2]+32>>2];qp=q[tp+16>>2];Dp=q[tp+8>>2];Zj(wp,(qp+q[tp>>2]|0)+yp|0,(Dp-qp|0)-yp|0,s[tp+38>>1]);tp=ri(a,wp);if((tp|0)==-1){break a}qp=tp;wp=qp>>31;break p}qp=-1;wp=-1;if((ri(a,q[tp+32>>2])|0)==-1){break a}}q[a+376>>2]=a;Dp=a+232|0;tp=q[(n[q[q[a>>2]+32>>2]](a)|0)+32>>2];Bp=q[tp>>2]+q[tp+16>>2]|0;yp=q[(n[q[q[a>>2]+32>>2]](a)|0)+32>>2];tp=q[yp+8>>2];up=q[yp+16>>2];Zj(Dp,Bp,tp-up|0,s[q[(n[q[q[a>>2]+32>>2]](a)|0)+32>>2]+38>>1]);q[a+372>>2]=Ap;up=0;tp=Yj(zp);r:{if(!si(Dp,tp)){break r}yp=ti(a,xp);if((yp|0)==-1){break r}xp=q[q[a+4>>2]+32>>2];up=q[tp+16>>2];Ap=up+q[tp>>2]|0;tp=q[tp+8>>2];Zj(xp,Ap,tp-up|0,s[xp+38>>1]);tp=q[a+4>>2];up=s[tp+36>>1];xp=(up<<24|up<<8&16711680)>>>16;if(xp>>>0<=513){up=q[tp+32>>2];Ap=up;Bp=up;tp=wp+q[up+20>>2]|0;up=qp+q[up+16>>2]|0;if(up>>>0<qp>>>0){tp=tp+1|0}q[Bp+16>>2]=up;q[Ap+20>>2]=tp}s:{if(q[a+220>>2]==q[a+216>>2]){break s}tp=q[vp>>2];qp=q[tp+4>>2];tp=q[tp>>2];t:{if(xp>>>0>=513){if((qp|0)==(tp|0)){break s}tp=0;break t}if((qp|0)==(tp|0)){break s}tp=0;while(1){if(ui(a,tp)){tp=tp+3|0;qp=q[vp>>2];if(tp>>>0<q[qp+4>>2]-q[qp>>2]>>2>>>0){continue}break s}break}up=0;break r}while(1){if(vi(a,tp)){tp=tp+3|0;qp=q[vp>>2];if(tp>>>0<q[qp+4>>2]-q[qp>>2]>>2>>>0){continue}break s}break}up=0;break r}if(r[a+308|0]){ak(a+272|0)}if(s[a+270>>1]<=513){ak(a+328|0)}tp=q[a+216>>2];wp=a+220|0;if((tp|0)!=q[wp>>2]){xp=0;while(1){qp=w(xp,144);Ek((qp+tp|0)+4|0,q[vp>>2]);up=q[Cp>>2];Ap=qp+up|0;tp=q[Ap+132>>2];Ap=q[Ap+136>>2];if((tp|0)!=(Ap|0)){while(1){Gk((qp+up|0)+4|0,q[tp>>2]);up=q[Cp>>2];tp=tp+4|0;if((Ap|0)!=(tp|0)){continue}break}}Fk((qp+up|0)+4|0);xp=xp+1|0;tp=q[a+216>>2];if(xp>>>0<(q[wp>>2]-tp|0)/144>>>0){continue}break}}qp=q[a+8>>2];wi(a+184|0,q[qp+28>>2]-q[qp+24>>2]>>2);up=q[a+216>>2];if((up|0)!=q[wp>>2]){tp=0;xp=a+220|0;while(1){qp=w(tp,144)+up|0;up=q[qp+60>>2]-q[qp+56>>2]>>2;Ap=qp+104|0;qp=q[vp>>2];qp=q[qp+28>>2]-q[qp+24>>2]>>2;wi(Ap,(up|0)<(qp|0)?qp:up);tp=tp+1|0;up=q[a+216>>2];if(tp>>>0<(q[xp>>2]-up|0)/144>>>0){continue}break}}up=xi(a,yp)}}T=zp- -64|0;return up|0}function oi(a,Hp,Ip){var Jp=0,Kp=0,Lp=0,Mp=0;a:{if(a>>>0>5){break a}Lp=q[Ip+16>>2];Jp=q[Ip+12>>2];Kp=q[Ip+20>>2];if((Jp|0)<(Kp|0)?1:(Jp|0)<=(Kp|0)?t[Ip+8>>2]>Lp>>>0?0:1:0){break a}Jp=r[Lp+q[Ip>>2]|0];Lp=Lp+1|0;if(Lp>>>0<1){Kp=Kp+1|0}q[Ip+16>>2]=Lp;q[Ip+20>>2]=Kp;Kp=Hp;if(Jp&128){if(!oi(a+1|0,Hp,Ip)){break a}a=q[Hp>>2]<<7;q[Hp>>2]=a;Jp=a|Jp&127}q[Kp>>2]=Jp;Mp=1}return Mp}function pi(a){var Hp=0;Hp=q[a+84>>2];if(Hp){q[a+88>>2]=Hp;An(Hp)}Hp=q[a+72>>2];if(Hp){q[a+76>>2]=Hp;An(Hp)}Hp=q[a+52>>2];if(Hp){q[a+56>>2]=Hp;An(Hp)}Hp=q[a+40>>2];if(Hp){q[a+44>>2]=Hp;An(Hp)}Hp=q[a+28>>2];if(Hp){q[a+32>>2]=Hp;An(Hp)}Hp=q[a+12>>2];if(Hp){An(Hp)}a=q[a>>2];if(a){An(a)}}function qi(a,Ip){var Np=0,Op=0,Pp=0,Qp=0,Rp=0,Sp=0;Op=T-32|0;T=Op;a:{b:{Pp=q[a+8>>2];Qp=a+4|0;Np=q[Qp>>2];c:{if((Pp-Np|0)/144>>>0>=Ip>>>0){while(1){q[Np>>2]=-1;Dk(Np+4|0);q[Np+104>>2]=0;q[Np+108>>2]=0;o[Np+100|0]=1;q[Np+112>>2]=0;q[Np+116>>2]=0;q[Np+120>>2]=0;q[Np+124>>2]=0;q[Np+128>>2]=0;q[Np+132>>2]=0;q[Np+136>>2]=0;q[Np+140>>2]=0;Np=q[Qp>>2]+144|0;q[Qp>>2]=Np;Ip=Ip+ -1|0;if(Ip){continue}break c}}Rp=q[a>>2];Sp=(Np-Rp|0)/144|0;Np=Sp+Ip|0;if(Np>>>0>=29826162){break b}q[Op+24>>2]=a+8;Qp=0;q[Op+20>>2]=0;Pp=(Pp-Rp|0)/144|0;Rp=Pp<<1;Pp=Pp>>>0<14913080?Rp>>>0<Np>>>0?Np:Rp:29826161;if(Pp){if(Pp>>>0>=29826162){break a}Qp=Mm(w(Pp,144))}q[Op+8>>2]=Qp;Np=w(Sp,144)+Qp|0;q[Op+16>>2]=Np;q[Op+20>>2]=w(Pp,144)+Qp;q[Op+12>>2]=Np;while(1){q[Np>>2]=-1;Dk(Np+4|0);q[Np+104>>2]=0;q[Np+108>>2]=0;o[Np+100|0]=1;q[Np+112>>2]=0;q[Np+116>>2]=0;q[Np+120>>2]=0;q[Np+124>>2]=0;q[Np+128>>2]=0;q[Np+132>>2]=0;q[Np+136>>2]=0;q[Np+140>>2]=0;Np=q[Op+16>>2]+144|0;q[Op+16>>2]=Np;Ip=Ip+ -1|0;if(Ip){continue}break}Ip=q[a+4>>2];Pp=q[a>>2];d:{if((Ip|0)==(Pp|0)){Qp=q[Op+12>>2];break d}Qp=q[Op+12>>2];while(1){Ip=Ip+ -144|0;Qp=vj(Qp+ -144|0,Ip);if((Ip|0)!=(Pp|0)){continue}break}q[Op+12>>2]=Qp;Ip=q[a+4>>2];Pp=q[a>>2]}q[a>>2]=Qp;q[Op+12>>2]=Pp;q[a+4>>2]=Np;q[Op+16>>2]=Ip;a=a+8|0;Ip=q[a>>2];q[a>>2]=q[Op+20>>2];q[Op+8>>2]=Pp;q[Op+20>>2]=Ip;wj(Op+8|0)}T=Op+32|0;return}bn();F()}ab(12024);F()}function ri(a,Ip){var Tp=0,Up=0,Vp=0,Wp=0,Xp=0,Yp=0,Zp=0,_p=0,$p=0,aq=0,bq=0,cq=0,dq=0,eq=0,fq=0,gq=0;Vp=T-32|0;T=Vp;a:{b:{if(r[q[a+4>>2]+36|0]<=1){Zp=-1;Xp=q[Ip+12>>2];Tp=q[Ip+20>>2];Wp=q[Ip+16>>2];Up=Wp+4|0;if(Up>>>0<4){Tp=Tp+1|0}Yp=Up;Up=Tp;if((Xp|0)<(Tp|0)?1:(Xp|0)<=(Tp|0)?t[Ip+8>>2]>=Yp>>>0?0:1:0){break a}Tp=Wp+q[Ip>>2]|0;$p=r[Tp|0]|r[Tp+1|0]<<8|(r[Tp+2|0]<<16|r[Tp+3|0]<<24);q[Vp+28>>2]=$p;q[Ip+16>>2]=Yp;q[Ip+20>>2]=Up;break b}Zp=-1;if(!oi(1,Vp+28|0,Ip)){break a}$p=q[Vp+28>>2]}c:{if(!$p){break c}Tp=q[a+8>>2];if($p>>>0>(q[Tp+4>>2]-q[Tp>>2]>>2>>>0)/3>>>0){break a}Tp=s[q[a+4>>2]+36>>1];if((Tp<<24|Tp<<8&16711680)>>>16>>>0>=258){Wp=a+36|0;Yp=a+44|0;Up=a+40|0;Xp=0;while(1){oi(1,Vp+8|0,Ip);q[Vp+20>>2]=q[Vp+8>>2]+Xp;oi(1,Vp+8|0,Ip);Xp=q[Vp+20>>2];Tp=q[Vp+8>>2];if(Xp>>>0<Tp>>>0){break a}q[Vp+16>>2]=Xp-Tp;Tp=q[Up>>2];d:{if((Tp|0)!=q[Yp>>2]){aq=q[Vp+20>>2];q[Tp>>2]=q[Vp+16>>2];q[Tp+4>>2]=aq;q[Tp+8>>2]=q[Vp+24>>2];q[Up>>2]=q[Up>>2]+12;break d}yi(Wp,Vp+16|0)}_p=_p+1|0;if((_p|0)!=($p|0)){continue}break}Xp=0;_j(Ip,0,0);Yp=a+36|0;while(1){Tp=r[Ip+36|0];Up=s[q[a+4>>2]+36>>1];e:{if((Up<<24|Up<<8&16711680)>>>16>>>0<=513){if(!Tp){break e}Zp=0;Tp=q[Ip+32>>2];Wp=Tp>>>3;aq=q[Ip+24>>2];Up=Wp+aq|0;_p=q[Ip+28>>2];f:{if(Up>>>0>=_p>>>0){Up=Tp;break f}Zp=r[Up|0];Up=Tp+1|0;q[Ip+32>>2]=Up;Wp=Up>>>3;Zp=Zp>>>(Tp&7)&1}if(Wp+aq>>>0>=_p>>>0){break e}q[Ip+32>>2]=Up+1;break e}if(!Tp){break e}Zp=0;Tp=q[Ip+32>>2];Up=q[Ip+24>>2]+(Tp>>>3)|0;if(Up>>>0>=t[Ip+28>>2]){break e}Up=r[Up|0];q[Ip+32>>2]=Tp+1;Zp=Up>>>(Tp&7)&1}Tp=q[Yp>>2]+w(Xp,12)|0;o[Tp+8|0]=r[Tp+8|0]&254|Zp&1;Xp=Xp+1|0;if(($p|0)!=(Xp|0)){continue}break}ak(Ip);break c}fq=a+36|0;gq=a+44|0;aq=a+40|0;while(1){Wp=q[Ip+12>>2];Xp=Wp;Tp=q[Ip+20>>2];Up=Tp;_p=q[Ip+16>>2];Yp=_p+4|0;if(Yp>>>0<4){Tp=Tp+1|0}bq=q[Ip+8>>2];cq=Yp;Yp=Tp;if((Wp|0)<(Tp|0)?1:(Wp|0)<=(Tp|0)?bq>>>0>=cq>>>0?0:1:0){break a}dq=q[Ip>>2];Tp=dq+_p|0;q[Vp+16>>2]=r[Tp|0]|r[Tp+1|0]<<8|(r[Tp+2|0]<<16|r[Tp+3|0]<<24);q[Ip+16>>2]=cq;q[Ip+20>>2]=Yp;Wp=Xp;Tp=Up;Yp=_p+8|0;if(Yp>>>0<8){Tp=Tp+1|0}if((Wp|0)<(Tp|0)?1:(Wp|0)<=(Tp|0)?bq>>>0>=Yp>>>0?0:1:0){break a}Wp=cq+dq|0;q[Vp+20>>2]=r[Wp|0]|r[Wp+1|0]<<8|(r[Wp+2|0]<<16|r[Wp+3|0]<<24);q[Ip+16>>2]=Yp;q[Ip+20>>2]=Tp;if((Xp|0)<(Tp|0)?1:(Xp|0)<=(Tp|0)?bq>>>0>Yp>>>0?0:1:0){break a}Xp=r[Yp+dq|0];Wp=_p+9|0;if(Wp>>>0<9){Up=Up+1|0}Tp=Ip;q[Tp+16>>2]=Wp;q[Tp+20>>2]=Up;o[Vp+24|0]=r[Vp+24|0]&254|Xp&1;Tp=q[aq>>2];g:{if((Tp|0)!=q[gq>>2]){Up=q[Vp+20>>2];q[Tp>>2]=q[Vp+16>>2];q[Tp+4>>2]=Up;q[Tp+8>>2]=q[Vp+24>>2];q[aq>>2]=q[aq>>2]+12;break g}yi(fq,Vp+16|0)}eq=eq+1|0;if(($p|0)!=(eq|0)){continue}break}}q[Vp+16>>2]=0;h:{Tp=s[q[a+4>>2]+36>>1];Tp=(Tp<<24|Tp<<8&16711680)>>>16;i:{if(Tp>>>0<=511){Zp=-1;Xp=q[Ip+12>>2];Tp=q[Ip+20>>2];Wp=q[Ip+16>>2];Up=Wp+4|0;if(Up>>>0<4){Tp=Tp+1|0}Yp=Up;Up=Tp;if((Xp|0)<(Tp|0)?1:(Xp|0)<=(Tp|0)?t[Ip+8>>2]>=Yp>>>0?0:1:0){break a}Tp=Wp+q[Ip>>2]|0;Wp=r[Tp|0]|r[Tp+1|0]<<8|(r[Tp+2|0]<<16|r[Tp+3|0]<<24);q[Vp+16>>2]=Wp;q[Ip+16>>2]=Yp;q[Ip+20>>2]=Up;break i}if((Tp|0)!=512){break h}Zp=-1;if(!oi(1,Vp+16|0,Ip)){break a}Wp=q[Vp+16>>2]}if(!Wp){break h}Tp=s[q[a+4>>2]+36>>1];if((Tp<<24|Tp<<8&16711680)>>>16>>>0>=258){Yp=a+48|0;Zp=a+56|0;Tp=a+52|0;Xp=0;a=0;while(1){q[Vp+8>>2]=0;oi(1,Vp+4|0,Ip);a=q[Vp+4>>2]+a|0;q[Vp+8>>2]=a;Up=q[Tp>>2];j:{if((Up|0)!=q[Zp>>2]){q[Up>>2]=a;q[Tp>>2]=Up+4;break j}zi(Yp,Vp+8|0)}Xp=Xp+1|0;if((Wp|0)!=(Xp|0)){continue}break}break h}Yp=a+48|0;Zp=a+56|0;Up=a+52|0;$p=0;while(1){k:{q[Vp+8>>2]=0;Xp=q[Ip+12>>2];Tp=q[Ip+20>>2];aq=q[Ip+16>>2];a=aq+4|0;if(a>>>0<4){Tp=Tp+1|0}_p=a;a=Tp;if((Xp|0)<(Tp|0)?1:(Xp|0)<=(Tp|0)?t[Ip+8>>2]>=_p>>>0?0:1:0){break k}Tp=aq+q[Ip>>2]|0;Tp=r[Tp|0]|r[Tp+1|0]<<8|(r[Tp+2|0]<<16|r[Tp+3|0]<<24);q[Vp+8>>2]=Tp;q[Ip+16>>2]=_p;q[Ip+20>>2]=a;a=q[Up>>2];l:{if((a|0)!=q[Zp>>2]){q[a>>2]=Tp;q[Up>>2]=a+4;break l}zi(Yp,Vp+8|0)}$p=$p+1|0;if(($p|0)!=(Wp|0)){continue}break h}break}Zp=-1;break a}Zp=q[Ip+16>>2]}T=Vp+32|0;return Zp}function si(a,Ip){var hq=0,iq=0,jq=0,kq=0,lq=0,mq=0,nq=0,oq=0;nq=T-16|0;T=nq;hq=q[a+4>>2];q[a+40>>2]=q[a>>2];q[a+44>>2]=hq;jq=a+32|0;hq=jq;iq=q[hq+4>>2];q[a+72>>2]=q[hq>>2];q[a+76>>2]=iq;iq=a+24|0;lq=q[iq+4>>2];hq=a- -64|0;q[hq>>2]=q[iq>>2];q[hq+4>>2]=lq;kq=a+16|0;hq=kq;lq=q[hq+4>>2];q[a+56>>2]=q[hq>>2];q[a+60>>2]=lq;lq=a+8|0;hq=lq;mq=q[hq+4>>2];q[a+48>>2]=q[hq>>2];q[a+52>>2]=mq;a:{b:{hq=a+40|0;if(_j(hq,1,nq+8|0)){mq=q[hq+4>>2];q[a>>2]=q[hq>>2];q[a+4>>2]=mq;mq=q[hq+36>>2];q[jq>>2]=q[hq+32>>2];q[jq+4>>2]=mq;jq=q[hq+28>>2];q[iq>>2]=q[hq+24>>2];q[iq+4>>2]=jq;iq=q[hq+20>>2];mq=iq;jq=q[hq+16>>2];q[kq>>2]=jq;q[kq+4>>2]=iq;iq=q[hq+12>>2];kq=iq;hq=q[hq+8>>2];q[lq>>2]=hq;q[lq+4>>2]=iq;iq=jq;lq=hq-iq|0;oq=q[nq+12>>2];iq=kq-((hq>>>0<iq>>>0)+mq|0)|0;hq=q[nq+8>>2];if((oq|0)==(iq|0)&hq>>>0<=lq>>>0|oq>>>0<iq>>>0){break b}}hq=0;break a}kq=mq+oq|0;jq=hq+jq|0;if(jq>>>0<hq>>>0){kq=kq+1|0}q[a+16>>2]=jq;q[a+20>>2]=kq;c:{if(s[a+38>>1]<=513){hq=q[a+4>>2];q[a+96>>2]=q[a>>2];q[a+100>>2]=hq;jq=a+32|0;hq=jq;iq=q[hq+4>>2];q[a+128>>2]=q[hq>>2];q[a+132>>2]=iq;iq=a+24|0;hq=iq;kq=q[hq+4>>2];q[a+120>>2]=q[hq>>2];q[a+124>>2]=kq;kq=a+16|0;hq=kq;lq=q[hq+4>>2];q[a+112>>2]=q[hq>>2];q[a+116>>2]=lq;lq=a+8|0;hq=lq;mq=q[hq+4>>2];q[a+104>>2]=q[hq>>2];q[a+108>>2]=mq;d:{hq=a+96|0;if(_j(hq,1,nq+8|0)){mq=q[hq+4>>2];q[a>>2]=q[hq>>2];q[a+4>>2]=mq;mq=q[hq+36>>2];q[jq>>2]=q[hq+32>>2];q[jq+4>>2]=mq;jq=q[hq+28>>2];q[iq>>2]=q[hq+24>>2];q[iq+4>>2]=jq;iq=q[hq+20>>2];mq=iq;jq=q[hq+16>>2];q[kq>>2]=jq;q[kq+4>>2]=iq;iq=q[hq+12>>2];kq=iq;hq=q[hq+8>>2];q[lq>>2]=hq;q[lq+4>>2]=iq;iq=jq;lq=hq-iq|0;oq=q[nq+12>>2];iq=kq-((hq>>>0<iq>>>0)+mq|0)|0;hq=q[nq+8>>2];if((oq|0)==(iq|0)&hq>>>0<=lq>>>0|oq>>>0<iq>>>0){break d}}hq=0;break a}kq=mq+oq|0;jq=hq+jq|0;if(jq>>>0<hq>>>0){kq=kq+1|0}q[a+16>>2]=jq;q[a+20>>2]=kq;break c}hq=0;if(!bh(a+80|0,a)){break a}}hq=0;if(!Ai(a)){break a}hq=q[a+4>>2];q[Ip>>2]=q[a>>2];q[Ip+4>>2]=hq;hq=q[a+36>>2];q[Ip+32>>2]=q[a+32>>2];q[Ip+36>>2]=hq;hq=q[a+28>>2];q[Ip+24>>2]=q[a+24>>2];q[Ip+28>>2]=hq;hq=q[a+20>>2];q[Ip+16>>2]=q[a+16>>2];q[Ip+20>>2]=hq;hq=q[a+12>>2];q[Ip+8>>2]=q[a+8>>2];q[Ip+12>>2]=hq;hq=1}T=nq+16|0;return hq}function ti(a,Ip){var pq=0,qq=0,rq=0,sq=0,tq=0,uq=0,vq=0,wq=0,xq=0,yq=0,zq=0,Aq=0,Bq=0,Cq=0,Dq=0,Eq=0,Fq=0,Gq=0,Hq=0,Iq=0,Jq=0,Kq=0,Lq=0;sq=T-96|0;T=sq;q[sq+72>>2]=0;q[sq+64>>2]=0;q[sq+68>>2]=0;q[sq+48>>2]=0;q[sq+52>>2]=0;q[sq+40>>2]=0;q[sq+44>>2]=0;q[sq+56>>2]=1065353216;q[sq+32>>2]=0;q[sq+24>>2]=0;q[sq+28>>2]=0;Jq=q[a+124>>2];a:{b:{c:{d:{if((Ip|0)>=1){Iq=a+8|0;Fq=q[a+216>>2]!=q[a+220>>2];Gq=a+40|0;while(1){e:{f:{g:{h:{i:{j:{k:{if(!r[a+308|0]){break k}l:{m:{wq=q[a+296>>2];yq=q[a+304>>2];pq=wq+(yq>>>3)|0;uq=q[a+300>>2];if(pq>>>0>=uq>>>0){break m}pq=r[pq|0];qq=yq+1|0;q[a+304>>2]=qq;if(!(pq>>>(yq&7)&1)){break m}pq=qq>>>3;rq=wq+pq|0;n:{if(rq>>>0>=uq>>>0){rq=qq;qq=0;break n}vq=r[rq|0];rq=yq+2|0;q[a+304>>2]=rq;pq=rq>>>3;qq=vq>>>(qq&7)&1}pq=pq+wq|0;if(pq>>>0<uq>>>0){pq=r[pq|0];q[a+304>>2]=rq+1;pq=pq>>>(rq&7)<<1&2}else{pq=0}pq=(qq|pq)<<1|1;switch(pq+ -2|0){case 0:case 2:case 4:break h;case 5:break j;case 1:case 3:break l;default:break k}}qq=q[sq+68>>2];if((qq|0)==q[sq+64>>2]){break d}wq=-1;Aq=q[Iq>>2];uq=q[Aq+24>>2];rq=uq;vq=qq+ -4|0;Dq=q[vq>>2];pq=-1;o:{if((Dq|0)==-1){break o}qq=Dq+1|0;qq=(qq>>>0)%3|0?qq:Dq+ -2|0;pq=-1;if((qq|0)==-1){break o}pq=q[q[Aq>>2]+(qq<<2)>>2]}rq=q[rq+(pq<<2)>>2];if((rq|0)!=-1){qq=rq+1|0;wq=(qq>>>0)%3|0?qq:rq+ -2|0}rq=q[Aq+12>>2];Bq=w(tq,3);qq=Bq+1|0;q[rq+(Dq<<2)>>2]=qq;qq=qq<<2;q[qq+rq>>2]=Dq;zq=Bq+2|0;q[rq+(wq<<2)>>2]=zq;yq=zq<<2;q[yq+rq>>2]=wq;Cq=q[Aq>>2];q[Cq+(Bq<<2)>>2]=pq;rq=qq+Cq|0;xq=-1;p:{if((wq|0)==-1){break p}qq=wq+1|0;qq=(qq>>>0)%3|0?qq:wq+ -2|0;xq=-1;if((qq|0)==-1){break p}xq=q[Cq+(qq<<2)>>2]}q[rq>>2]=xq;q:{r:{if((Dq|0)!=-1){qq=Dq+((Dq>>>0)%3|0?-1:2)|0;if((qq|0)!=-1){break r}}q[yq+Cq>>2]=-1;break q}qq=q[Cq+(qq<<2)>>2];q[yq+Cq>>2]=qq;if((qq|0)==-1){break q}q[uq+(qq<<2)>>2]=zq}rq=q[a+120>>2]+(pq>>>3&536870908)|0;qq=q[rq>>2];Kq=rq,Lq=eo(pq)&qq,q[Kq>>2]=Lq;q[vq>>2]=Bq;break e}rq=q[sq+68>>2];if((rq|0)==q[sq+64>>2]){break d}yq=q[Iq>>2];qq=q[yq+12>>2];zq=w(tq,3);wq=(pq|0)==5;uq=zq+(wq?2:1)|0;pq=uq<<2;Cq=q[rq+ -4>>2];q[qq+pq>>2]=Cq;q[qq+(Cq<<2)>>2]=uq;vq=yq+24|0;rq=yq+28|0;qq=q[rq>>2];s:{if((qq|0)!=q[yq+32>>2]){q[qq>>2]=-1;Aq=qq+4|0;q[rq>>2]=Aq;break s}zi(vq,11312);Aq=q[rq>>2]}rq=-1;qq=q[Iq>>2];yq=q[qq+24>>2];if(q[qq+28>>2]-yq>>2>(Jq|0)){break c}rq=zq+2|0;Bq=q[qq>>2];xq=Bq+pq|0;qq=Aq-q[vq>>2]|0;pq=(qq>>2)+ -1|0;q[xq>>2]=pq;if(qq){q[yq+(pq<<2)>>2]=uq}rq=wq?zq:rq;qq=Bq+(wq+zq<<2)|0;t:{u:{v:{if((Cq|0)!=-1){pq=Cq+((Cq>>>0)%3|0?-1:2)|0;if((pq|0)==-1){break v}pq=q[Bq+(pq<<2)>>2];q[Bq+(rq<<2)>>2]=pq;if((pq|0)==-1){break u}q[yq+(pq<<2)>>2]=rq;break u}q[Bq+(rq<<2)>>2]=-1;rq=-1;break t}q[Bq+(rq<<2)>>2]=-1}pq=Cq+1|0;pq=(pq>>>0)%3|0?pq:Cq+ -2|0;rq=-1;if((pq|0)==-1){break t}rq=q[Bq+(pq<<2)>>2]}q[qq>>2]=rq;q[q[sq+68>>2]+ -4>>2]=zq;break i}rq=-1;pq=q[sq+68>>2];Aq=q[sq+64>>2];if((pq|0)==(Aq|0)){break c}qq=pq+ -4|0;Eq=q[qq>>2];q[sq+68>>2]=qq;zq=q[sq+44>>2];w:{if(!zq){pq=qq;break w}uq=q[sq+40>>2];yq=co(zq)>>>0>1;vq=zq+2147483647&tq;x:{if(!yq){break x}vq=tq;if(tq>>>0<zq>>>0){break x}vq=(tq>>>0)%(zq>>>0)|0}uq=q[uq+(vq<<2)>>2];if(!uq){pq=qq;break w}xq=q[uq>>2];if(!xq){pq=qq;break w}uq=zq+ -1|0;y:{while(1){wq=q[xq+4>>2];z:{if((wq|0)!=(tq|0)){A:{if(!yq){wq=wq&uq;break A}if(wq>>>0<zq>>>0){break A}wq=(wq>>>0)%(zq>>>0)|0}if((wq|0)==(vq|0)){break z}pq=qq;break w}if(q[xq+8>>2]==(tq|0)){break y}}xq=q[xq>>2];if(xq){continue}break}pq=qq;break w}vq=xq+12|0;if((qq|0)!=q[sq+72>>2]){q[qq>>2]=q[vq>>2];q[sq+68>>2]=pq;break w}zi(sq- -64|0,vq);pq=q[sq+68>>2];Aq=q[sq+64>>2]}if((pq|0)==(Aq|0)){break c}Dq=q[pq+ -4>>2];vq=(Dq|0)==-1;Hq=q[Iq>>2];if(q[q[Hq+12>>2]+(Dq<<2)>>2]!=-1?!vq:0){break c}yq=(Eq|0)==-1;zq=Hq+12|0;uq=q[zq>>2];if(q[uq+(Eq<<2)>>2]!=-1?!yq:0){break c}Cq=w(tq,3);Aq=Cq+2|0;q[uq+(Dq<<2)>>2]=Aq;Bq=Aq<<2;q[Bq+uq>>2]=Dq;qq=Cq+1|0;q[uq+(Eq<<2)>>2]=qq;wq=uq;uq=qq<<2;q[wq+uq>>2]=Eq;if(vq){break g}wq=-1;vq=q[Hq>>2];xq=vq+(Cq<<2)|0;qq=Dq+((Dq>>>0)%3|0?-1:2)|0;if((qq|0)!=-1){wq=q[(qq<<2)+vq>>2]}q[xq>>2]=wq;qq=Dq+1|0;qq=(qq>>>0)%3|0?qq:Dq+ -2|0;if((qq|0)==-1){break f}rq=q[(qq<<2)+vq>>2];break f}q[sq>>2]=w(tq,3);pq=q[Iq>>2];rq=pq+24|0;uq=q[pq+32>>2];qq=pq+28|0;pq=q[qq>>2];B:{if((uq|0)!=(pq|0)){q[pq>>2]=-1;pq=pq+4|0;q[qq>>2]=pq;break B}zi(rq,11312);pq=q[qq>>2]}Aq=q[Iq>>2];wq=q[Aq>>2];qq=q[sq>>2];yq=pq-q[rq>>2]|0;zq=yq>>2;rq=zq+ -1|0;q[wq+(qq<<2)>>2]=rq;qq=qq+1|0;uq=Aq+24|0;vq=Aq+28|0;pq=q[vq>>2];C:{if((pq|0)!=q[Aq+32>>2]){q[pq>>2]=-1;pq=pq+4|0;q[vq>>2]=pq;break C}zi(uq,11312);pq=q[vq>>2];wq=q[Aq>>2]}q[(qq<<2)+wq>>2]=(pq-q[uq>>2]>>2)+ -1;pq=q[sq>>2]+2|0;uq=q[Iq>>2];qq=uq+28|0;vq=q[qq>>2];D:{if((vq|0)!=q[uq+32>>2]){q[vq>>2]=-1;wq=vq+4|0;q[qq>>2]=wq;break D}zi(uq+24|0,11312);wq=q[qq>>2]}q[q[uq>>2]+(pq<<2)>>2]=(wq-q[uq+24>>2]>>2)+ -1;pq=q[Iq>>2];qq=q[pq+24>>2];if(q[pq+28>>2]-qq>>2>(Jq|0)){break d}pq=q[sq>>2];E:{F:{if(!yq){wq=1;q[qq+(zq<<2)>>2]=pq+1;break F}q[qq+(rq<<2)>>2]=pq;wq=0;if((yq|0)==-4){break F}q[qq+(zq<<2)>>2]=q[sq>>2]+1;wq=zq+1|0;if((wq|0)==-1){break E}}q[qq+(wq<<2)>>2]=q[sq>>2]+2}pq=q[sq+68>>2];if((pq|0)!=q[sq+72>>2]){q[pq>>2]=q[sq>>2];q[sq+68>>2]=pq+4;break i}zi(sq- -64|0,sq)}xq=q[Gq>>2];if((xq|0)==q[a+36>>2]){break e}uq=(tq^-1)+Ip|0;while(1){rq=-1;pq=q[xq+ -8>>2];if(pq>>>0>uq>>>0){break c}if((pq|0)!=(uq|0)){break e}qq=r[xq+ -4|0];pq=xq+ -12|0;vq=q[pq>>2];q[Gq>>2]=pq;if((vq|0)<0){break c}rq=q[q[sq+68>>2]+ -4>>2];q[sq+20>>2]=(vq^-1)+Ip;q[sq+88>>2]=sq+20;Bi(sq,sq+40|0,sq+20|0,sq+88|0);vq=q[sq>>2];G:{if(qq&1){pq=-1;if((rq|0)==-1){break G}pq=rq+1|0;pq=(pq>>>0)%3|0?pq:rq+ -2|0;break G}pq=-1;if((rq|0)==-1){break G}pq=rq+ -1|0;if((rq>>>0)%3){break G}pq=rq+2|0}q[vq+12>>2]=pq;xq=q[Gq>>2];if((xq|0)!=q[a+36>>2]){continue}break}break e}F()}wq=-1;vq=q[Hq>>2];q[vq+(Cq<<2)>>2]=-1}q[uq+vq>>2]=rq;H:{I:{J:{if(!yq){qq=Eq+((Eq>>>0)%3|0?-1:2)|0;if((qq|0)==-1){break J}qq=q[(qq<<2)+vq>>2];q[vq+Bq>>2]=qq;if((qq|0)==-1){break I}q[q[Hq+24>>2]+(qq<<2)>>2]=Aq;break I}q[vq+Bq>>2]=-1;xq=-1;rq=-1;break H}q[vq+Bq>>2]=-1}xq=-1;qq=Eq+1|0;qq=(qq>>>0)%3|0?qq:Eq+ -2|0;rq=-1;if((qq|0)==-1){break H}xq=q[(qq<<2)+vq>>2];rq=qq}q[sq>>2]=xq;uq=q[Hq+24>>2];if((wq|0)!=-1){q[uq+(wq<<2)>>2]=q[uq+(xq<<2)>>2]}K:{if((rq|0)==-1){break K}vq=q[Hq>>2];while(1){q[vq+(rq<<2)>>2]=wq;qq=rq+1|0;qq=(qq>>>0)%3|0?qq:rq+ -2|0;if((qq|0)==-1){break K}rq=q[q[zq>>2]+(qq<<2)>>2];if((rq|0)==-1){break K}qq=rq+1|0;rq=(qq>>>0)%3|0?qq:rq+ -2|0;if((rq|0)!=-1){continue}break}}q[uq+(q[sq>>2]<<2)>>2]=-1;L:{if(Fq){break L}qq=q[sq+28>>2];if((qq|0)!=q[sq+32>>2]){q[qq>>2]=q[sq>>2];q[sq+28>>2]=qq+4;break L}zi(sq+24|0,sq);pq=q[sq+68>>2]}q[pq+ -4>>2]=Cq}tq=tq+1|0;if((tq|0)!=(Ip|0)){continue}break}wq=Ip}rq=-1;xq=q[a+8>>2];if(q[xq+28>>2]-q[xq+24>>2]>>2>(Jq|0)){break c}tq=q[sq+68>>2];if((tq|0)!=q[sq+64>>2]){Dq=a+72|0;qq=a+60|0;Aq=a+312|0;Fq=a+8|0;Cq=a+68|0;Jq=a+80|0;Hq=a+76|0;while(1){pq=tq+ -4|0;Ip=q[pq>>2];q[sq+68>>2]=pq;q[sq>>2]=Ip;M:{N:{O:{P:{if(s[a+270>>1]<=513){if(!r[a+364|0]){break O}pq=q[a+360>>2];Ip=q[a+352>>2]+(pq>>>3)|0;if(Ip>>>0>=t[a+356>>2]){break N}Ip=r[Ip|0];q[a+360>>2]=pq+1;Ip=Ip>>>(pq&7)&1;break P}Ip=dh(Aq)}if(!Ip){break N}}zq=q[Fq>>2];Eq=q[zq>>2];if((wq|0)>=((q[zq+4>>2]-Eq>>2>>>0)/3|0)){break d}pq=-1;xq=-1;tq=q[zq+24>>2];uq=tq;Gq=q[sq>>2];vq=-1;Q:{if((Gq|0)==-1){break Q}Ip=Gq+1|0;Ip=(Ip>>>0)%3|0?Ip:Gq+ -2|0;vq=-1;if((Ip|0)==-1){break Q}vq=q[Eq+(Ip<<2)>>2]}uq=q[uq+(vq<<2)>>2];R:{if((uq|0)==-1){break R}Ip=uq+1|0;Ip=(Ip>>>0)%3|0?Ip:uq+ -2|0;if((Ip|0)==-1){break R}pq=Ip+1|0;pq=(pq>>>0)%3|0?pq:Ip+ -2|0;if((pq|0)!=-1){xq=q[Eq+(pq<<2)>>2]}pq=Ip}Ip=-1;Bq=-1;yq=q[tq+(xq<<2)>>2];uq=-1;S:{if((yq|0)==-1){break S}tq=yq+1|0;tq=(tq>>>0)%3|0?tq:yq+ -2|0;uq=-1;if((tq|0)==-1){break S}uq=tq+1|0;uq=(uq>>>0)%3|0?uq:tq+ -2|0;if((uq|0)!=-1){Bq=q[Eq+(uq<<2)>>2]}uq=tq}tq=w(wq,3);q[sq+88>>2]=tq;yq=q[zq+12>>2];q[yq+(tq<<2)>>2]=Gq;q[yq+(Gq<<2)>>2]=tq;tq=q[sq+88>>2]+1|0;q[yq+(tq<<2)>>2]=pq;q[yq+(pq<<2)>>2]=tq;pq=q[sq+88>>2]+2|0;q[yq+(pq<<2)>>2]=uq;q[yq+(uq<<2)>>2]=pq;pq=q[sq+88>>2];q[Eq+(pq<<2)>>2]=xq;Gq=pq+1|0;zq=Eq+(Gq<<2)|0;q[zq>>2]=Bq;yq=pq+2|0;uq=Eq+(yq<<2)|0;q[uq>>2]=vq;Bq=q[a+120>>2];tq=Gq>>>0<pq>>>0?-1:xq;vq=Bq+(tq>>>3&536870908)|0;pq=q[vq>>2];Kq=vq,Lq=eo(tq)&pq,q[Kq>>2]=Lq;Ip=(Gq|0)!=-1?q[zq>>2]:Ip;vq=Bq+(Ip>>>3&536870908)|0;pq=q[vq>>2];Kq=vq,Lq=eo(Ip)&pq,q[Kq>>2]=Lq;tq=-1;tq=(yq|0)!=-1?q[uq>>2]:tq;pq=Bq+(tq>>>3&536870908)|0;Ip=q[pq>>2];Kq=pq,Lq=eo(tq)&Ip,q[Kq>>2]=Lq;tq=q[a+64>>2];pq=q[Cq>>2];if((tq|0)==pq<<5){if((tq+1|0)<=-1){break a}Ip=qq;if(tq>>>0<=1073741822){vq=tq+32&-32;pq=pq<<6;pq=pq>>>0<vq>>>0?vq:pq}else{pq=2147483647}cb(Ip,pq);tq=q[a+64>>2]}wq=wq+1|0;q[a+64>>2]=tq+1;Ip=q[a+60>>2]+(tq>>>3&536870908)|0;q[Ip>>2]=q[Ip>>2]|1<<(tq&31);Ip=q[Hq>>2];if((Ip|0)!=q[Jq>>2]){q[Ip>>2]=q[sq+88>>2];q[Hq>>2]=Ip+4;break M}zi(Dq,sq+88|0);break M}tq=q[a+64>>2];pq=q[Cq>>2];if((tq|0)==pq<<5){if((tq+1|0)<=-1){break a}Ip=qq;if(tq>>>0<=1073741822){vq=tq+32&-32;pq=pq<<6;pq=pq>>>0<vq>>>0?vq:pq}else{pq=2147483647}cb(Ip,pq);tq=q[a+64>>2]}q[a+64>>2]=tq+1;pq=q[a+60>>2]+(tq>>>3&536870908)|0;Ip=q[pq>>2];Kq=pq,Lq=eo(tq)&Ip,q[Kq>>2]=Lq;Ip=q[Hq>>2];if((Ip|0)!=q[Jq>>2]){q[Ip>>2]=q[sq>>2];q[Hq>>2]=Ip+4;break M}zi(Dq,sq)}tq=q[sq+68>>2];if((tq|0)!=q[sq+64>>2]){continue}break}xq=q[a+8>>2]}if(((q[xq+4>>2]-q[xq>>2]>>2>>>0)/3|0)!=(wq|0)){break c}rq=q[xq+28>>2]-q[xq+24>>2]>>2;Fq=q[sq+24>>2];uq=q[sq+28>>2];if((Fq|0)==(uq|0)){break b}vq=a+8|0;while(1){zq=q[Fq>>2];wq=q[xq+24>>2];tq=rq+ -1|0;T:{if(q[wq+(tq<<2)>>2]!=-1){pq=rq;break T}wq=q[xq+24>>2];while(1){tq=rq+ -2|0;pq=rq+ -1|0;rq=pq;if(q[(tq<<2)+wq>>2]==-1){continue}break}}if(!(tq>>>0<zq>>>0)){q[sq>>2]=xq;Ip=tq<<2;rq=q[Ip+wq>>2];o[sq+12|0]=1;q[sq+8>>2]=rq;q[sq+4>>2]=rq;if((rq|0)!=-1){while(1){q[q[xq>>2]+(rq<<2)>>2]=zq;lg(sq);xq=q[vq>>2];rq=q[sq+8>>2];if((rq|0)!=-1){continue}break}}qq=Ip;Ip=q[xq+24>>2];qq=qq+Ip|0;if((zq|0)!=-1){q[Ip+(zq<<2)>>2]=q[qq>>2]}q[qq>>2]=-1;yq=1<<(zq&31);Ip=q[a+120>>2];rq=Ip+(zq>>>3&536870908)|0;qq=rq;wq=Ip+(tq>>>3&536870908)|0;Ip=1<<(tq&31);tq=yq|q[rq>>2];U:{if(q[wq>>2]&Ip){break U}tq=q[rq>>2]&(yq^-1)}q[qq>>2]=tq;q[wq>>2]=q[wq>>2]&(Ip^-1);pq=pq+ -1|0}rq=pq;Fq=Fq+4|0;if((uq|0)!=(Fq|0)){continue}break}break c}rq=-1}Fq=q[sq+24>>2]}if(Fq){q[sq+28>>2]=Fq;An(Fq)}tq=q[sq+48>>2];if(tq){while(1){a=q[tq>>2];An(tq);tq=a;if(tq){continue}break}}a=q[sq+40>>2];q[sq+40>>2]=0;if(a){An(a)}a=q[sq+64>>2];if(a){q[sq+68>>2]=a;An(a)}T=sq+96|0;return rq}bn();F()}function ui(a,Ip){var Mq=0,Nq=0,Oq=0,Pq=0,Qq=0,Rq=0,Sq=0,Tq=0,Uq=0,Vq=0,Wq=0;Nq=T-32|0;T=Nq;q[Nq+16>>2]=Ip;Mq=-1;a:{if((Ip|0)==-1){q[Nq+20>>2]=-1;break a}Mq=Ip+1|0;q[Nq+20>>2]=(Mq>>>0)%3|0?Mq:Ip+ -2|0;if((Ip>>>0)%3){Mq=Ip+ -1|0;break a}Mq=Ip+2|0}q[Nq+24>>2]=Mq;Rq=a+220|0;Vq=a+8|0;Wq=a+368|0;while(1){b:{if(!((Ip|0)==-1|q[q[q[Vq>>2]+12>>2]+(Ip<<2)>>2]==-1)){Mq=0;if(q[Rq>>2]==q[a+216>>2]){break b}while(1){c:{if(!dh(q[Wq>>2]+(Mq<<4)|0)){break c}Oq=q[a+216>>2];q[Nq+12>>2]=Ip;Oq=Oq+w(Mq,144)|0;Qq=Oq+136|0;Pq=q[Qq>>2];if(Pq>>>0<t[Oq+140>>2]){q[Pq>>2]=Ip;q[Qq>>2]=Pq+4;break c}ya(Oq+132|0,Nq+12|0)}Mq=Mq+1|0;if(Mq>>>0<(q[Rq>>2]-q[a+216>>2]|0)/144>>>0){continue}break}break b}Mq=0;Oq=q[a+216>>2];Pq=q[Rq>>2];if((Oq|0)==(Pq|0)){break b}while(1){q[Nq+12>>2]=Ip;Qq=w(Mq,144)+Oq|0;Uq=Qq+136|0;Sq=q[Uq>>2];d:{if(Sq>>>0<t[Qq+140>>2]){q[Sq>>2]=Ip;q[Uq>>2]=Sq+4;break d}ya(Qq+132|0,Nq+12|0);Pq=q[Rq>>2];Oq=q[a+216>>2]}Mq=Mq+1|0;if(Mq>>>0<(Pq-Oq|0)/144>>>0){continue}break}}Tq=Tq+1|0;if((Tq|0)!=3){Ip=q[(Nq+16|0)+(Tq<<2)>>2];continue}break}T=Nq+32|0;return 1}function vi(a,Ip){var Xq=0,Yq=0,Zq=0,_q=0,$q=0,ar=0,br=0,cr=0,dr=0,er=0,fr=0,gr=0;Yq=T-32|0;T=Yq;q[Yq+16>>2]=Ip;Xq=-1;a:{if((Ip|0)==-1){q[Yq+20>>2]=-1;break a}Xq=Ip+1|0;q[Yq+20>>2]=(Xq>>>0)%3|0?Xq:Ip+ -2|0;if((Ip>>>0)%3){Xq=Ip+ -1|0;break a}Xq=Ip+2|0}q[Yq+24>>2]=Xq;er=(Ip|0)==-1?-1:(Ip>>>0)/3|0;ar=a+220|0;fr=a+8|0;gr=a+368|0;while(1){b:{c:{if((Ip|0)!=-1){Xq=q[q[q[fr>>2]+12>>2]+(Ip<<2)>>2];if((Xq|0)!=-1){break c}}Xq=0;Zq=q[a+216>>2];_q=q[ar>>2];if((Zq|0)==(_q|0)){break b}while(1){q[Yq+12>>2]=Ip;$q=w(Xq,144)+Zq|0;dr=$q+136|0;br=q[dr>>2];d:{if(br>>>0<t[$q+140>>2]){q[br>>2]=Ip;q[dr>>2]=br+4;break d}ya($q+132|0,Yq+12|0);_q=q[ar>>2];Zq=q[a+216>>2]}Xq=Xq+1|0;if(Xq>>>0<(_q-Zq|0)/144>>>0){continue}break}break b}if((Xq>>>0)/3>>>0<er>>>0){break b}Xq=0;if(q[ar>>2]==q[a+216>>2]){break b}while(1){e:{if(!dh(q[gr>>2]+(Xq<<4)|0)){break e}Zq=q[a+216>>2];q[Yq+12>>2]=Ip;Zq=Zq+w(Xq,144)|0;$q=Zq+136|0;_q=q[$q>>2];if(_q>>>0<t[Zq+140>>2]){q[_q>>2]=Ip;q[$q>>2]=_q+4;break e}ya(Zq+132|0,Yq+12|0)}Xq=Xq+1|0;if(Xq>>>0<(q[ar>>2]-q[a+216>>2]|0)/144>>>0){continue}break}}cr=cr+1|0;if((cr|0)!=3){Ip=q[(Yq+16|0)+(cr<<2)>>2];continue}break}T=Yq+32|0;return 1}function wi(a,Ip){var hr=0,ir=0,jr=0,kr=0,lr=0;ir=q[a+12>>2];hr=q[a+16>>2]-ir>>2;a:{if(hr>>>0<Ip>>>0){Fa(a+12|0,Ip-hr|0);break a}if(hr>>>0<=Ip>>>0){break a}q[a+16>>2]=ir+(Ip<<2)}b:{hr=q[a>>2];c:{if(q[a+8>>2]-hr>>2>>>0>=Ip>>>0){break c}if(Ip>>>0>=1073741824){break b}kr=a+4|0;ir=q[kr>>2];jr=Ip<<2;Ip=Mm(jr);jr=Ip+jr|0;ir=ir-hr|0;lr=ir+Ip|0;if((ir|0)>=1){Cn(Ip,hr,ir)}q[a>>2]=Ip;q[a+8>>2]=jr;q[kr>>2]=lr;if(!hr){break c}An(hr)}return}ab(12024);F()}function xi(a,Ip){var mr=0,nr=0,or=0,pr=0,qr=0,rr=0,sr=0,tr=0,ur=0,vr=0,wr=0,xr=0,yr=0,zr=0,Ar=0,Br=0;nr=T-48|0;T=nr;mr=q[a+8>>2];or=q[mr>>2];qr=q[mr+4>>2];mr=q[q[a+4>>2]+44>>2];q[nr+40>>2]=0;q[nr+32>>2]=0;q[nr+36>>2]=0;or=(qr-or>>2>>>0)/3|0;pr=q[mr+96>>2];qr=(q[mr+100>>2]-pr|0)/12|0;a:{if(or>>>0>qr>>>0){Ci(mr+96|0,or-qr|0,nr+32|0);break a}if(or>>>0>=qr>>>0){break a}q[mr+100>>2]=pr+w(or,12)}b:{if(q[a+216>>2]==q[a+220>>2]){ur=q[a+4>>2];mr=q[ur+44>>2];or=q[mr+100>>2];sr=q[mr+96>>2];if((or|0)!=(sr|0)){vr=(or-sr|0)/12|0;wr=nr+40|0;mr=0;while(1){q[wr>>2]=0;q[nr+32>>2]=0;q[nr+36>>2]=0;qr=nr;c:{d:{e:{pr=w(mr,3);if((pr|0)==-1){or=-1;q[nr+32>>2]=-1;rr=0;break e}or=q[q[q[a+8>>2]>>2]+(pr<<2)>>2];q[nr+32>>2]=or;rr=pr+1|0;if((rr|0)!=-1){break e}q[nr+36>>2]=-1;pr=0;break d}q[nr+36>>2]=q[q[q[a+8>>2]>>2]+(rr<<2)>>2];pr=pr+2|0;xr=-1;if((pr|0)==-1){break c}}xr=q[q[q[a+8>>2]>>2]+(pr<<2)>>2]}q[qr+40>>2]=xr;qr=sr+w(mr,12)|0;q[qr>>2]=or;q[qr+4>>2]=q[nr+36>>2];q[qr+8>>2]=q[nr+40>>2];mr=mr+1|0;if(mr>>>0<vr>>>0){continue}break}}q[q[ur+4>>2]+80>>2]=Ip;mr=1;break b}q[nr+40>>2]=0;q[nr+32>>2]=0;q[nr+36>>2]=0;pr=q[a+8>>2];Ip=q[pr>>2];mr=q[pr+4>>2];q[nr+24>>2]=0;q[nr+16>>2]=0;q[nr+20>>2]=0;f:{g:{h:{Ip=mr-Ip|0;if(Ip){or=Ip>>2;if(or>>>0>=1073741824){break h}mr=Mm(Ip);q[nr+16>>2]=mr;q[nr+24>>2]=mr+(or<<2);Ar=nr,Br=Dn(mr,0,Ip)+Ip|0,q[Ar+20>>2]=Br}if((q[pr+28>>2]-q[pr+24>>2]|0)<1){break g}ur=a+220|0;vr=a+8|0;while(1){or=q[q[pr+24>>2]+(sr<<2)>>2];i:{if((or|0)==-1){break i}j:{if(q[q[a+120>>2]+(sr>>>3&536870908)>>2]>>>(sr&31)&1){break j}Ip=q[ur>>2];wr=q[a+216>>2];if((Ip|0)==(wr|0)){break j}xr=(Ip-wr|0)/144|0;yr=((or>>>0)%3|0?-1:2)+or|0;rr=0;while(1){zr=or<<2;tr=wr+w(rr,144)|0;Ip=q[zr+q[q[tr+68>>2]>>2]>>2];k:{if(!(q[q[tr+16>>2]+(Ip>>>3&536870908)>>2]>>>(Ip&31)&1)){break k}Ip=or;mr=-1;l:{if((yr|0)==-1){break l}qr=q[q[pr+12>>2]+(yr<<2)>>2];mr=-1;if((qr|0)==-1){break l}mr=qr+ -1|0;if((qr>>>0)%3){break l}mr=qr+2|0}if((Ip|0)==(mr|0)){break k}tr=q[tr+32>>2];zr=q[tr+zr>>2];while(1){Ip=0;if((mr|0)==-1){break f}if((zr|0)!=q[tr+(mr<<2)>>2]){or=mr;break j}qr=or;mr=((mr>>>0)%3|0?-1:2)+mr|0;Ip=-1;m:{if((mr|0)==-1){break m}mr=q[q[pr+12>>2]+(mr<<2)>>2];Ip=-1;if((mr|0)==-1){break m}Ip=mr+ -1|0;if((mr>>>0)%3){break m}Ip=mr+2|0}mr=Ip;if((qr|0)!=(mr|0)){continue}break}}rr=rr+1|0;if(rr>>>0<xr>>>0){continue}break}}Ip=q[nr+36>>2];q[q[nr+16>>2]+(or<<2)>>2]=Ip-q[nr+32>>2]>>2;q[nr>>2]=or;n:{if(t[nr+40>>2]>Ip>>>0){q[Ip>>2]=or;q[nr+36>>2]=Ip+4;break n}ya(nr+32|0,nr);pr=q[vr>>2]}if((or|0)==-1){break i}Ip=((or>>>0)%3|0?-1:2)+or|0;if((Ip|0)==-1){break i}Ip=q[q[pr+12>>2]+(Ip<<2)>>2];if((Ip|0)==-1){break i}mr=Ip+((Ip>>>0)%3|0?-1:2)|0;if((mr|0)==-1){break i}qr=or;if((mr|0)==(or|0)){break i}while(1){Ip=mr;o:{p:{mr=q[ur>>2];rr=q[a+216>>2];if((mr|0)==(rr|0)){break p}wr=(mr-rr|0)/144|0;mr=0;while(1){yr=q[(rr+w(mr,144)|0)+32>>2];tr=Ip<<2;if(q[yr+tr>>2]==q[yr+(qr<<2)>>2]){mr=mr+1|0;if(mr>>>0<wr>>>0){continue}break p}break}mr=q[nr+36>>2];q[tr+q[nr+16>>2]>>2]=mr-q[nr+32>>2]>>2;q[nr>>2]=Ip;if(t[nr+40>>2]>mr>>>0){q[mr>>2]=Ip;q[nr+36>>2]=mr+4;break o}ya(nr+32|0,nr);pr=q[vr>>2];break o}mr=q[nr+16>>2];q[mr+(Ip<<2)>>2]=q[mr+(qr<<2)>>2]}if((Ip|0)==-1){break i}mr=Ip+((Ip>>>0)%3|0?-1:2)|0;if((mr|0)==-1){break i}mr=q[q[pr+12>>2]+(mr<<2)>>2];if((mr|0)==-1){break i}mr=mr+((mr>>>0)%3|0?-1:2)|0;if((mr|0)==-1){break i}qr=Ip;if((mr|0)!=(or|0)){continue}break}}sr=sr+1|0;if((sr|0)<q[pr+28>>2]-q[pr+24>>2]>>2){continue}break}break g}bn();F()}or=q[a+4>>2];a=q[or+44>>2];Ip=q[a+100>>2];a=q[a+96>>2];if((Ip|0)!=(a|0)){qr=(Ip-a|0)/12|0;mr=0;pr=q[nr+16>>2];while(1){sr=nr+8|0;rr=w(mr,12);Ip=rr+pr|0;q[sr>>2]=q[Ip+8>>2];ur=q[Ip+4>>2];vr=q[Ip>>2];q[nr>>2]=vr;q[nr+4>>2]=ur;Ip=a+rr|0;q[Ip>>2]=vr;q[Ip+4>>2]=q[nr+4>>2];q[Ip+8>>2]=q[sr>>2];mr=mr+1|0;if(mr>>>0<qr>>>0){continue}break}}q[q[or+4>>2]+80>>2]=q[nr+36>>2]-q[nr+32>>2]>>2;Ip=1}mr=Ip;a=q[nr+16>>2];if(a){q[nr+20>>2]=a;An(a)}a=q[nr+32>>2];if(!a){break b}q[nr+36>>2]=a;An(a)}T=nr+48|0;return mr}function yi(a,Ip){var Cr=0,Dr=0,Er=0,Fr=0,Gr=0,Hr=0;a:{Fr=q[a>>2];Gr=q[a+4>>2]-Fr|0;Cr=(Gr|0)/12|0;Dr=Cr+1|0;if(Dr>>>0<357913942){Hr=w(Cr,12);Er=(q[a+8>>2]-Fr|0)/12|0;Cr=Er<<1;Er=Er>>>0<178956970?Cr>>>0<Dr>>>0?Dr:Cr:357913941;Cr=0;b:{if(!Er){break b}if(Er>>>0>=357913942){break a}Cr=Mm(w(Er,12))}Dr=Hr+Cr|0;Hr=q[Ip+4>>2];q[Dr>>2]=q[Ip>>2];q[Dr+4>>2]=Hr;q[Dr+8>>2]=q[Ip+8>>2];Ip=Dr+w((Gr|0)/-12|0,12)|0;Cr=Cr+w(Er,12)|0;Dr=Dr+12|0;if((Gr|0)>=1){Cn(Ip,Fr,Gr)}q[a>>2]=Ip;q[a+8>>2]=Cr;q[a+4>>2]=Dr;if(Fr){An(Fr)}return}bn();F()}ab(12024);F()}function zi(a,Ip){var Ir=0,Jr=0,Kr=0,Lr=0,Mr=0,Nr=0;a:{Kr=q[a>>2];Mr=q[a+4>>2]-Kr|0;Ir=Mr>>2;Jr=Ir+1|0;if(Jr>>>0<1073741824){Nr=Ir<<2;Ir=q[a+8>>2]-Kr|0;Lr=Ir>>1;Jr=Ir>>2>>>0<536870911?Lr>>>0<Jr>>>0?Jr:Lr:1073741823;Ir=0;b:{if(!Jr){break b}if(Jr>>>0>=1073741824){break a}Ir=Mm(Jr<<2)}Lr=Nr+Ir|0;q[Lr>>2]=q[Ip>>2];Ip=Ir+(Jr<<2)|0;Jr=Lr+4|0;if((Mr|0)>=1){Cn(Ir,Kr,Mr)}q[a>>2]=Ir;q[a+8>>2]=Ip;q[a+4>>2]=Jr;if(Kr){An(Kr)}return}bn();F()}ab(12024);F()}function Ai(a){var Ip=0,Or=0,Pr=0,Qr=0;Or=1;Pr=q[a+140>>2];a:{if((Pr|0)<1){break a}Ip=Pr<<4;Or=Mm((Pr|0)!=(Pr&268435455)?-1:Ip|4);q[Or>>2]=Pr;Or=Or+4|0;Pr=Or+Ip|0;Ip=Or;while(1){Ip=ah(Ip)+16|0;if((Pr|0)!=(Ip|0)){continue}break}Qr=q[a+136>>2];q[a+136>>2]=Or;if(Qr){Pr=Qr+ -4|0;Or=q[Pr>>2];if(Or){Ip=Qr+(Or<<4)|0;while(1){Ip=Ip+ -16|0;if((Qr|0)!=(Ip|0)){continue}break}}An(Pr)}Or=1;if(q[a+140>>2]<1){break a}Or=0;Ip=0;while(1){if(!bh(q[a+136>>2]+(Ip<<4)|0,a)){break a}Ip=Ip+1|0;if((Ip|0)<q[a+140>>2]){continue}break}Or=1}return Or}function Bi(a,Rr,Sr,Tr){var Ur=0,Vr=0,Wr=0,Xr=0,Yr=0,Zr=x(0),_r=0,$r=x(0),as=0;Ur=q[Sr>>2];as=a;a:{b:{Vr=q[Rr+4>>2];if(!Vr){break b}_r=q[Rr>>2];Xr=co(Vr);Sr=Vr+ -1&Ur;c:{if(Xr>>>0<=1){break c}Sr=Ur;if(Ur>>>0<Vr>>>0){break c}Sr=(Ur>>>0)%(Vr>>>0)|0}Wr=Sr;Sr=q[(Sr<<2)+_r>>2];if(!Sr){break b}_r=Vr+ -1|0;Xr=Xr>>>0>1;while(1){Sr=q[Sr>>2];if(!Sr){break b}Yr=q[Sr+4>>2];if((Yr|0)!=(Ur|0)){d:{if(!Xr){Yr=Yr&_r;break d}if(Yr>>>0<Vr>>>0){break d}Yr=(Yr>>>0)%(Vr>>>0)|0}if((Wr|0)!=(Yr|0)){break b}}if(q[Sr+8>>2]!=(Ur|0)){continue}break}Rr=0;break a}Sr=Mm(16);Tr=q[q[Tr>>2]>>2];q[Sr+12>>2]=0;q[Sr+8>>2]=Tr;q[Sr+4>>2]=Ur;q[Sr>>2]=0;$r=u[Rr+16>>2];Zr=x(q[Rr+12>>2]+1>>>0);e:{if(!(!Vr|!!(x($r*x(Vr>>>0))<Zr))){Ur=Wr;break e}Wr=(Vr+ -1&Vr)!=0|Vr>>>0<3|Vr<<1;Tr=Rr;Zr=x(D(x(Zr/$r)));f:{if(Zr<x(4294967296)&Zr>=x(0)){Xr=~~Zr>>>0;break f}Xr=0}xj(Tr,Wr>>>0<Xr>>>0?Xr:Wr);Vr=q[Rr+4>>2];if(!(Vr&Vr+ -1)){Ur=Vr+ -1&Ur;break e}if(Ur>>>0<Vr>>>0){break e}Ur=(Ur>>>0)%(Vr>>>0)|0}Tr=q[Rr>>2]+(Ur<<2)|0;Ur=q[Tr>>2];g:{h:{if(!Ur){Wr=Rr+8|0;q[Sr>>2]=q[Wr>>2];q[Wr>>2]=Sr;q[Tr>>2]=Wr;Tr=q[Sr>>2];if(!Tr){break g}Ur=q[Tr+4>>2];Tr=Vr+ -1|0;i:{if(!(Tr&Vr)){Ur=Tr&Ur;break i}if(Ur>>>0<Vr>>>0){break i}Ur=(Ur>>>0)%(Vr>>>0)|0}Ur=q[Rr>>2]+(Ur<<2)|0;break h}q[Sr>>2]=q[Ur>>2]}q[Ur>>2]=Sr}Rr=Rr+12|0;q[Rr>>2]=q[Rr>>2]+1;Rr=1}o[as+4|0]=Rr;q[a>>2]=Sr}function Ci(a,Rr,Sr){var Tr=0,bs=0,cs=0,ds=0,es=0;a:{b:{ds=q[a+8>>2];bs=a+4|0;Tr=q[bs>>2];c:{if((ds-Tr|0)/12>>>0>=Rr>>>0){while(1){a=q[Sr+4>>2];q[Tr>>2]=q[Sr>>2];q[Tr+4>>2]=a;q[Tr+8>>2]=q[Sr+8>>2];Tr=q[bs>>2]+12|0;q[bs>>2]=Tr;Rr=Rr+ -1|0;if(Rr){continue}break c}}cs=q[a>>2];es=(Tr-cs|0)/12|0;bs=es+Rr|0;if(bs>>>0>=357913942){break b}ds=(ds-cs|0)/12|0;cs=ds<<1;bs=ds>>>0<178956970?cs>>>0<bs>>>0?bs:cs:357913941;Tr=0;d:{if(!bs){break d}if(bs>>>0>=357913942){break a}Tr=Mm(w(bs,12))}ds=Tr+w(bs,12)|0;bs=Tr+w(es,12)|0;Tr=bs;while(1){cs=q[Sr+4>>2];q[Tr>>2]=q[Sr>>2];q[Tr+4>>2]=cs;q[Tr+8>>2]=q[Sr+8>>2];Tr=Tr+12|0;Rr=Rr+ -1|0;if(Rr){continue}break}cs=a+4|0;Rr=q[a>>2];Sr=q[cs>>2]-Rr|0;bs=bs+w((Sr|0)/-12|0,12)|0;if((Sr|0)>=1){Cn(bs,Rr,Sr)}q[a>>2]=bs;q[a+8>>2]=ds;q[cs>>2]=Tr;if(!Rr){break c}An(Rr)}return}bn();F()}ab(12024);F()}function Di(a){a=a|0;return q[a+8>>2]}function Ei(a){q[a>>2]=11324;Dn(a+4|0,0,80);q[a+96>>2]=0;q[a+100>>2]=0;q[a+92>>2]=-1;q[a+84>>2]=-1;q[a+88>>2]=-1;q[a+104>>2]=0;q[a+108>>2]=0;q[a+112>>2]=0;q[a+116>>2]=0;q[a+120>>2]=0;q[a+124>>2]=0;q[a+128>>2]=0;q[a+132>>2]=0;q[a+136>>2]=0;q[a+140>>2]=0;q[a+144>>2]=0;q[a+148>>2]=0;q[a+156>>2]=0;q[a+160>>2]=0;q[a+152>>2]=1065353216;q[a+164>>2]=0;q[a+168>>2]=0;q[a+172>>2]=0;q[a+176>>2]=0;q[a+180>>2]=0;q[a+184>>2]=0;q[a+188>>2]=0;q[a+192>>2]=0;q[a+196>>2]=0;q[a+200>>2]=0;q[a+204>>2]=0;q[a+208>>2]=0;q[a+212>>2]=-1;q[a+216>>2]=0;q[a+220>>2]=0;q[a+224>>2]=0;ci(a+232|0);q[a+396>>2]=0;q[a+388>>2]=0;q[a+392>>2]=0;q[a+380>>2]=0;q[a+384>>2]=0;ah(a+400|0);q[a+416>>2]=-1;q[a+420>>2]=-1}function Fi(a){a=a|0;var Rr=0,Sr=0,fs=0,gs=0,hs=0,is=0,js=0,ks=0,ls=0,ms=0,ns=0,os=0,ps=0,qs=0,rs=0,ss=0,ts=0;ks=T+ -64|0;T=ks;q[a+132>>2]=0;if(q[a+148>>2]){fs=a+144|0;Sr=q[fs>>2];if(Sr){while(1){Rr=q[Sr>>2];An(Sr);Sr=Rr;if(Rr){continue}break}}q[fs>>2]=0;Rr=q[a+140>>2];if(Rr){fs=a+136|0;Sr=0;while(1){q[q[fs>>2]+(Sr<<2)>>2]=0;Sr=Sr+1|0;if((Rr|0)!=(Sr|0)){continue}break}}q[a+148>>2]=0}a:{b:{c:{d:{e:{f:{Sr=q[a+4>>2];fs=r[Sr+36|0];Rr=fs<<8|r[Sr+37|0];g:{if(Rr>>>0>513){break g}is=q[Sr+32>>2];if(Rr>>>0<=511){gs=q[is+12>>2];Rr=q[is+20>>2];js=q[is+16>>2];hs=js+4|0;if(hs>>>0<4){Rr=Rr+1|0}ls=hs;hs=Rr;if((gs|0)<(Rr|0)?1:(gs|0)<=(Rr|0)?t[is+8>>2]>=ls>>>0?0:1:0){break f}Rr=js+q[is>>2]|0;Rr=r[Rr|0]|r[Rr+1|0]<<8|(r[Rr+2|0]<<16|r[Rr+3|0]<<24);q[ks>>2]=Rr;q[is+16>>2]=ls;q[is+20>>2]=hs;q[a+132>>2]=Rr;break g}if(!oi(1,ks,is)){break f}Sr=q[a+4>>2];fs=r[Sr+36|0];q[a+132>>2]=q[ks>>2]}Sr=q[Sr+32>>2];h:{i:{j:{if((fs&255)>>>0<=1){fs=0;is=q[Sr+12>>2];Rr=q[Sr+20>>2];gs=q[Sr+16>>2];hs=gs+4|0;if(hs>>>0<4){Rr=Rr+1|0}js=hs;hs=Rr;if((is|0)<(Rr|0)?1:(is|0)<=(Rr|0)?t[Sr+8>>2]>=js>>>0?0:1:0){break a}Rr=gs+q[Sr>>2]|0;Rr=r[Rr|0]|r[Rr+1|0]<<8|(r[Rr+2|0]<<16|r[Rr+3|0]<<24);q[ks+60>>2]=Rr;q[Sr+16>>2]=js;q[Sr+20>>2]=hs;q[a+156>>2]=Rr;ns=a+156|0;break j}fs=0;if(!oi(1,ks+60|0,Sr)){break a}Rr=q[a+4>>2];Sr=q[Rr+32>>2];Rr=r[Rr+36|0];q[a+156>>2]=q[ks+60>>2];ns=a+156|0;if(Rr>>>0>1){break i}}is=q[Sr+12>>2];Rr=q[Sr+20>>2];gs=q[Sr+16>>2];hs=gs+4|0;if(hs>>>0<4){Rr=Rr+1|0}ls=hs;hs=Rr;if((is|0)<(Rr|0)?1:(is|0)<=(Rr|0)?t[Sr+8>>2]>=ls>>>0?0:1:0){break a}Rr=gs+q[Sr>>2]|0;js=r[Rr|0]|r[Rr+1|0]<<8|(r[Rr+2|0]<<16|r[Rr+3|0]<<24);q[ks+56>>2]=js;q[Sr+16>>2]=ls;q[Sr+20>>2]=hs;break h}if(!oi(1,ks+56|0,Sr)){break a}js=q[ks+56>>2]}if(js>>>0>1431655765|t[ns>>2]>w(js,3)>>>0){break a}os=q[a+4>>2];hs=q[os+32>>2];ps=q[hs+8>>2];ms=q[hs+16>>2];is=q[hs+12>>2];Rr=is;Sr=q[hs+20>>2];if((Rr|0)<(Sr|0)?1:(Rr|0)<=(Sr|0)?ps>>>0>ms>>>0?0:1:0){break a}rs=q[hs>>2];ls=r[rs+ms|0];Rr=Sr;qs=ms+1|0;if(qs>>>0<1){Rr=Rr+1|0}q[hs+16>>2]=qs;q[hs+20>>2]=Rr;k:{if(r[os+36|0]<=1){Rr=Sr;Sr=ms+5|0;if(Sr>>>0<5){Rr=Rr+1|0}gs=Sr;Sr=Rr;if((is|0)<(Rr|0)?1:(is|0)<=(Rr|0)?ps>>>0>=gs>>>0?0:1:0){break a}Rr=qs+rs|0;is=r[Rr|0]|r[Rr+1|0]<<8|(r[Rr+2|0]<<16|r[Rr+3|0]<<24);q[ks+52>>2]=is;q[hs+16>>2]=gs;q[hs+20>>2]=Sr;break k}if(!oi(1,ks+52|0,hs)){break a}is=q[ks+52>>2]}if(js>>>0<is>>>0|js>>>0>((is>>>0)/3|0)+is>>>0){break a}Rr=q[a+4>>2];hs=q[Rr+32>>2];l:{if(r[Rr+36|0]<=1){gs=q[hs+12>>2];Rr=q[hs+20>>2];ms=q[hs+16>>2];Sr=ms+4|0;if(Sr>>>0<4){Rr=Rr+1|0}os=Sr;Sr=Rr;if((gs|0)<(Rr|0)?1:(gs|0)<=(Rr|0)?t[hs+8>>2]>=os>>>0?0:1:0){break a}Rr=ms+q[hs>>2]|0;ms=r[Rr|0]|r[Rr+1|0]<<8|(r[Rr+2|0]<<16|r[Rr+3|0]<<24);q[ks+48>>2]=ms;q[hs+16>>2]=os;q[hs+20>>2]=Sr;break l}if(!oi(1,ks+48|0,hs)){break a}ms=q[ks+48>>2]}if(ms>>>0>is>>>0){break a}q[a+28>>2]=q[a+24>>2];Sr=Mm(88);jk(Sr);Rr=q[a+8>>2];q[a+8>>2]=Sr;hs=a+8|0;if(Rr){wa(hs,Rr);if(!q[hs>>2]){break a}}Rr=q[a+160>>2];q[a+164>>2]=Rr;m:{if(q[a+168>>2]-Rr>>2>>>0>=js>>>0){break m}if(js>>>0>=1073741824){break e}fs=js<<2;Sr=Mm(fs);q[a+164>>2]=Sr;q[a+160>>2]=Sr;q[a+168>>2]=Sr+fs;if(!Rr){break m}An(Rr)}Rr=q[a+172>>2];q[a+176>>2]=Rr;n:{if(q[a+180>>2]-Rr>>2>>>0>=js>>>0){break n}if(js>>>0>=1073741824){break d}fs=js<<2;Sr=Mm(fs);q[a+176>>2]=Sr;q[a+172>>2]=Sr;q[a+180>>2]=Sr+fs;if(!Rr){break n}An(Rr)}q[a+92>>2]=-1;q[a+84>>2]=-1;q[a+88>>2]=-1;q[a+40>>2]=q[a+36>>2];q[a- -64>>2]=0;q[a+52>>2]=q[a+48>>2];q[a+76>>2]=q[a+72>>2];os=a+216|0;Sr=q[a+220>>2];fs=q[a+216>>2];if((Sr|0)==(fs|0)){break c}while(1){Rr=q[Sr+ -12>>2];if(Rr){q[Sr+ -8>>2]=Rr;An(Rr)}Rr=q[Sr+ -28>>2];if(Rr){q[Sr+ -24>>2]=Rr;An(Rr)}Rr=Sr+ -144|0;gs=q[Sr+ -40>>2];if(gs){q[Sr+ -36>>2]=gs;An(gs)}pi(Sr+ -140|0);Sr=Rr;if((fs|0)!=(Rr|0)){continue}break}Rr=q[os>>2];break b}fs=0;break a}ab(12024);F()}ab(12024);F()}Rr=fs}q[a+220>>2]=fs;Sr=(fs-Rr|0)/144|0;o:{if(Sr>>>0<ls>>>0){qi(os,ls-Sr|0);break o}if(Sr>>>0<=ls>>>0){break o}Sr=Rr+w(ls,144)|0;if((Sr|0)!=(fs|0)){while(1){Rr=q[fs+ -12>>2];if(Rr){q[fs+ -8>>2]=Rr;An(Rr)}Rr=q[fs+ -28>>2];if(Rr){q[fs+ -24>>2]=Rr;An(Rr)}Rr=fs+ -144|0;gs=q[fs+ -40>>2];if(gs){q[fs+ -36>>2]=gs;An(gs)}pi(fs+ -140|0);fs=Rr;if((Rr|0)!=(Sr|0)){continue}break}}q[a+220>>2]=Sr}fs=0;if(!tk(q[hs>>2],js,q[ns>>2]+ms|0)){break a}Rr=q[a+156>>2];o[ks|0]=1;bb(a+120|0,Rr+ms|0,ks);Sr=q[a+4>>2];Rr=s[Sr+36>>1];Rr=(Rr<<24|Rr<<8&16711680)>>>16;p:{if(Rr>>>0<=513){gs=q[Sr+32>>2];q:{if(Rr>>>0<=511){js=q[gs+12>>2];Rr=q[gs+20>>2];ns=q[gs+16>>2];Sr=ns+4|0;if(Sr>>>0<4){Rr=Rr+1|0}ps=Sr;Sr=Rr;if((js|0)<(Rr|0)?1:(js|0)<=(Rr|0)?t[gs+8>>2]>=ps>>>0?0:1:0){break a}Rr=ns+q[gs>>2]|0;js=r[Rr|0]|r[Rr+1|0]<<8|(r[Rr+2|0]<<16|r[Rr+3|0]<<24);q[ks+44>>2]=js;q[gs+16>>2]=ps;q[gs+20>>2]=Sr;break q}if(!oi(1,ks+44|0,gs)){break a}js=q[ks+44>>2]}if(!js){break a}Rr=q[q[a+4>>2]+32>>2];Sr=q[Rr+8>>2];gs=q[Rr+16>>2];Rr=q[Rr+12>>2]-(q[Rr+20>>2]+(Sr>>>0<gs>>>0)|0)|0;if((Rr|0)<0?1:(Rr|0)<=0?Sr-gs>>>0>=js>>>0?0:1:0){break a}gs=Yj(ks);Sr=q[q[a+4>>2]+32>>2];Rr=q[Sr+16>>2];ns=q[Sr+8>>2];Zj(gs,(Rr+q[Sr>>2]|0)+js|0,(ns-Rr|0)-js|0,s[Sr+38>>1]);Sr=ri(a,gs);if((Sr|0)==-1){break a}Rr=Sr;gs=Rr>>31;break p}Rr=-1;gs=-1;if((ri(a,q[Sr+32>>2])|0)==-1){break a}}q[a+376>>2]=a;ns=a+232|0;Sr=q[(n[q[q[a>>2]+32>>2]](a)|0)+32>>2];ps=q[Sr>>2]+q[Sr+16>>2]|0;js=q[(n[q[q[a>>2]+32>>2]](a)|0)+32>>2];Sr=q[js+8>>2];fs=q[js+16>>2];Zj(ns,ps,Sr-fs|0,s[q[(n[q[q[a>>2]+32>>2]](a)|0)+32>>2]+38>>1]);ss=a,ts=n[q[q[a>>2]+36>>2]](a)|0,q[ss+380>>2]=ts;q[a+372>>2]=ls;q[a+384>>2]=q[a+156>>2]+ms;fs=0;Sr=Yj(ks);r:{if(!Gi(ns,Sr)){break r}js=Hi(a,is);if((js|0)==-1){break r}is=q[q[a+4>>2]+32>>2];fs=q[Sr+16>>2];ls=fs+q[Sr>>2]|0;Sr=q[Sr+8>>2];Zj(is,ls,Sr-fs|0,s[is+38>>1]);Sr=q[a+4>>2];fs=s[Sr+36>>1];is=(fs<<24|fs<<8&16711680)>>>16;if(is>>>0<=513){fs=q[Sr+32>>2];ls=fs;ps=fs;Sr=gs+q[fs+20>>2]|0;fs=Rr+q[fs+16>>2]|0;if(fs>>>0<Rr>>>0){Sr=Sr+1|0}q[ps+16>>2]=fs;q[ls+20>>2]=Sr}s:{if(q[a+220>>2]==q[a+216>>2]){break s}Sr=q[hs>>2];Rr=q[Sr+4>>2];Sr=q[Sr>>2];t:{if(is>>>0>=513){if((Rr|0)==(Sr|0)){break s}Sr=0;break t}if((Rr|0)==(Sr|0)){break s}Sr=0;while(1){if(ui(a,Sr)){Sr=Sr+3|0;Rr=q[hs>>2];if(Sr>>>0<q[Rr+4>>2]-q[Rr>>2]>>2>>>0){continue}break s}break}fs=0;break r}while(1){if(vi(a,Sr)){Sr=Sr+3|0;Rr=q[hs>>2];if(Sr>>>0<q[Rr+4>>2]-q[Rr>>2]>>2>>>0){continue}break s}break}fs=0;break r}if(r[a+308|0]){ak(a+272|0)}if(s[a+270>>1]<=513){ak(a+328|0)}Sr=q[a+216>>2];gs=a+220|0;if((Sr|0)!=q[gs>>2]){is=0;while(1){Rr=w(is,144);Ek((Rr+Sr|0)+4|0,q[hs>>2]);fs=q[os>>2];ls=Rr+fs|0;Sr=q[ls+132>>2];ls=q[ls+136>>2];if((Sr|0)!=(ls|0)){while(1){Gk((Rr+fs|0)+4|0,q[Sr>>2]);fs=q[os>>2];Sr=Sr+4|0;if((ls|0)!=(Sr|0)){continue}break}}Fk((Rr+fs|0)+4|0);is=is+1|0;Sr=q[a+216>>2];if(is>>>0<(q[gs>>2]-Sr|0)/144>>>0){continue}break}}Rr=q[a+8>>2];wi(a+184|0,q[Rr+28>>2]-q[Rr+24>>2]>>2);fs=q[a+216>>2];if((fs|0)!=q[gs>>2]){Sr=0;is=a+220|0;while(1){Rr=w(Sr,144)+fs|0;fs=q[Rr+60>>2]-q[Rr+56>>2]>>2;ls=Rr+104|0;Rr=q[hs>>2];Rr=q[Rr+28>>2]-q[Rr+24>>2]>>2;wi(ls,(fs|0)<(Rr|0)?Rr:fs);Sr=Sr+1|0;fs=q[a+216>>2];if(Sr>>>0<(q[is>>2]-fs|0)/144>>>0){continue}break}}fs=xi(a,js)}}T=ks- -64|0;return fs|0}function Gi(a,us){var vs=0,ws=0,xs=0,ys=0,zs=0,As=0,Bs=0;ys=T-16|0;T=ys;a:{if(!si(a,us)){break a}zs=q[us+12>>2];vs=q[us+20>>2];As=q[us+16>>2];xs=As+4|0;if(xs>>>0<4){vs=vs+1|0}ws=xs;xs=vs;if((zs|0)<(vs|0)?1:(zs|0)<=(vs|0)?t[us+8>>2]>=ws>>>0?0:1:0){break a}vs=As+q[us>>2]|0;vs=r[vs|0]|r[vs+1|0]<<8|(r[vs+2|0]<<16|r[vs+3|0]<<24);q[us+16>>2]=ws;q[us+20>>2]=xs;if((vs|0)<0){break a}ws=q[a+152>>2];if((vs|0)>=(ws|0)){break a}q[ys+12>>2]=0;xs=q[a+156>>2];vs=q[a+160>>2]-xs>>2;b:{if(ws>>>0>vs>>>0){Ad(a+156|0,ws-vs|0,ys+12|0);break b}if(ws>>>0>=vs>>>0){break b}q[a+160>>2]=xs+(ws<<2)}Bs=bh(a+168|0,us)}T=ys+16|0;return Bs}function Hi(a,us){var Cs=0,Ds=0,Es=0,Fs=0,Gs=0,Hs=0,Is=0,Js=0,Ks=0,Ls=0,Ms=0,Ns=0,Os=0,Ps=0,Qs=0,Rs=0,Ss=0,Ts=0,Us=0,Vs=0,Ws=0,Xs=0,Ys=0,Zs=0,_s=0,$s=0,at=0;Gs=T-96|0;T=Gs;q[Gs+72>>2]=0;q[Gs+64>>2]=0;q[Gs+68>>2]=0;q[Gs+48>>2]=0;q[Gs+52>>2]=0;q[Gs+40>>2]=0;q[Gs+44>>2]=0;q[Gs+56>>2]=1065353216;q[Gs+32>>2]=0;q[Gs+24>>2]=0;q[Gs+28>>2]=0;Ss=q[a+124>>2];a:{b:{c:{if((us|0)>=1){Ts=a+400|0;Us=a+232|0;Zs=a+296|0;Vs=a+8|0;_s=a+388|0;Ys=q[a+216>>2]!=q[a+220>>2];Ws=a+40|0;while(1){d:{e:{f:{g:{h:{if(q[a+420>>2]!=-1){if(dh(Ts)){break h}}Cs=a;Js=Cs;if(r[Cs+308|0]){Ks=q[Zs>>2];Is=q[a+304>>2];Ds=Ks+(Is>>>3)|0;Hs=q[a+300>>2];if(Ds>>>0>=Hs>>>0){break g}Es=r[Ds|0];Ds=Is+1|0;q[a+304>>2]=Ds;if(!(Es>>>(Is&7)&1)){break g}Ms=Ds>>>3;Es=Ks+Ms|0;i:{if(Es>>>0>=Hs>>>0){Es=Ds;Cs=0;break i}Fs=r[Es|0];Es=Is+2|0;q[a+304>>2]=Es;Ms=Es>>>3;Cs=Fs>>>(Ds&7)&1}Fs=Ks+Ms|0;if(Fs>>>0<Hs>>>0){Fs=r[Fs|0];q[a+304>>2]=Es+1;Ds=Fs>>>(Es&7)<<1&2}else{Ds=0}Ds=(Cs|Ds)<<1|1}else{Ds=1}q[Js+416>>2]=Ds;break e}Ds=q[a+420>>2];q[a+416>>2]=Ds;if(Ds){break e}break f}q[a+416>>2]=0}Ds=q[Gs+68>>2];if((Ds|0)==q[Gs+64>>2]){Es=-1;break c}Ns=-1;Os=q[Vs>>2];Ks=q[Os+24>>2];Fs=Ks;Hs=Ds+ -4|0;Rs=q[Hs>>2];Cs=-1;j:{if((Rs|0)==-1){break j}Es=Rs+1|0;Es=(Es>>>0)%3|0?Es:Rs+ -2|0;Cs=-1;if((Es|0)==-1){break j}Cs=q[q[Os>>2]+(Es<<2)>>2]}Fs=q[Fs+(Cs<<2)>>2];if((Fs|0)!=-1){Es=Fs+1|0;Ns=(Es>>>0)%3|0?Es:Fs+ -2|0}Fs=q[Os+12>>2];Ps=w(Ls,3);Es=Ps+1|0;q[Fs+(Rs<<2)>>2]=Es;Es=Es<<2;q[Es+Fs>>2]=Rs;Qs=Ps+2|0;q[Fs+(Ns<<2)>>2]=Qs;Is=Qs<<2;q[Is+Fs>>2]=Ns;Ms=q[Os>>2];q[Ms+(Ps<<2)>>2]=Cs;Js=Es+Ms|0;Fs=-1;k:{if((Ns|0)==-1){break k}Es=Ns+1|0;Es=(Es>>>0)%3|0?Es:Ns+ -2|0;Fs=-1;if((Es|0)==-1){break k}Fs=q[Ms+(Es<<2)>>2]}q[Js>>2]=Fs;l:{m:{if((Rs|0)!=-1){Es=Rs+((Rs>>>0)%3|0?-1:2)|0;if((Es|0)!=-1){break m}}q[Is+Ms>>2]=-1;break l}Es=q[Ms+(Es<<2)>>2];q[Is+Ms>>2]=Es;if((Es|0)==-1){break l}q[Ks+(Es<<2)>>2]=Qs}Fs=q[a+120>>2]+(Cs>>>3&536870908)|0;Es=q[Fs>>2];$s=Fs,at=eo(Cs)&Es,q[$s>>2]=at;q[Hs>>2]=Ps;Cs=0;break d}Es=-1;Cs=Ds+ -1|0;if(Cs>>>0>6){break c}n:{o:{p:{q:{switch(Cs-1|0){case 1:case 3:Fs=q[Gs+68>>2];if((Fs|0)==q[Gs+64>>2]){break c}Es=q[Vs>>2];Cs=q[Es+12>>2];Qs=w(Ls,3);Ks=(Ds|0)==5;Hs=Qs+(Ks?2:1)|0;Ds=Hs<<2;Ms=q[Fs+ -4>>2];q[Cs+Ds>>2]=Ms;q[Cs+(Ms<<2)>>2]=Hs;Fs=Es+24|0;Js=q[Es+32>>2];Es=Es+28|0;Cs=q[Es>>2];r:{if((Js|0)!=(Cs|0)){q[Cs>>2]=-1;Os=Cs+4|0;q[Es>>2]=Os;break r}zi(Fs,11312);Os=q[Es>>2]}Es=-1;Cs=q[Vs>>2];Is=q[Cs+24>>2];if(q[Cs+28>>2]-Is>>2>(Ss|0)){break c}Es=Qs+2|0;Ps=q[Cs>>2];Js=Ps+Ds|0;Cs=Os-q[Fs>>2]|0;Ds=(Cs>>2)+ -1|0;q[Js>>2]=Ds;if(Cs){q[Is+(Ds<<2)>>2]=Hs}Es=Ks?Qs:Es;Fs=Ps+(Ks+Qs<<2)|0;s:{t:{u:{if((Ms|0)!=-1){Ds=Ms+((Ms>>>0)%3|0?-1:2)|0;if((Ds|0)==-1){break u}Ds=q[Ps+(Ds<<2)>>2];q[Ps+(Es<<2)>>2]=Ds;if((Ds|0)==-1){break t}q[Is+(Ds<<2)>>2]=Es;break t}q[Ps+(Es<<2)>>2]=-1;Cs=-1;break s}q[Ps+(Es<<2)>>2]=-1}Ds=Ms+1|0;Ds=(Ds>>>0)%3|0?Ds:Ms+ -2|0;Cs=-1;if((Ds|0)==-1){break s}Cs=q[Ps+(Ds<<2)>>2]}q[Fs>>2]=Cs;Ds=q[Gs+68>>2];q[Ds+ -4>>2]=Qs;break p;default:Ds=q[Gs+68>>2];Os=q[Gs+64>>2];if((Ds|0)==(Os|0)){break c}Cs=Ds+ -4|0;Xs=q[Cs>>2];q[Gs+68>>2]=Cs;Is=q[Gs+44>>2];v:{if(!Is){Ds=Cs;break v}Js=q[Gs+40>>2];Ks=co(Is)>>>0>1;Hs=Is+2147483647&Ls;w:{if(!Ks){break w}Fs=Ls;Hs=Fs;if(Fs>>>0<Is>>>0){break w}Hs=(Ls>>>0)%(Is>>>0)|0}Fs=Hs;Hs=q[Js+(Fs<<2)>>2];if(!Hs){Ds=Cs;break v}Js=q[Hs>>2];if(!Js){Ds=Cs;break v}Hs=Is+ -1|0;x:{while(1){Ns=q[Js+4>>2];y:{if((Ls|0)!=(Ns|0)){z:{if(!Ks){Ns=Hs&Ns;break z}if(Ns>>>0<Is>>>0){break z}Ns=(Ns>>>0)%(Is>>>0)|0}if((Fs|0)==(Ns|0)){break y}Ds=Cs;break v}if(q[Js+8>>2]==(Ls|0)){break x}}Js=q[Js>>2];if(Js){continue}break}Ds=Cs;break v}Fs=Js+12|0;if((Cs|0)!=q[Gs+72>>2]){q[Cs>>2]=q[Fs>>2];q[Gs+68>>2]=Ds;break v}zi(Gs- -64|0,Fs);Ds=q[Gs+68>>2];Os=q[Gs+64>>2]}if((Ds|0)==(Os|0)){break c}Ms=q[Ds+ -4>>2];Fs=(Ms|0)==-1;Rs=q[Vs>>2];if(q[q[Rs+12>>2]+(Ms<<2)>>2]!=-1?!Fs:0){break c}Ks=(Xs|0)==-1;Is=Rs+12|0;Hs=q[Is>>2];if(q[Hs+(Xs<<2)>>2]!=-1?!Ks:0){break c}Ps=w(Ls,3);Qs=Ps+2|0;q[Hs+(Ms<<2)>>2]=Qs;Os=Qs<<2;q[Os+Hs>>2]=Ms;Cs=Ps+1|0;q[Hs+(Xs<<2)>>2]=Cs;Js=Hs;Hs=Cs<<2;q[Js+Hs>>2]=Xs;if(Fs){break o}Ns=-1;Fs=q[Rs>>2];Js=Fs+(Ps<<2)|0;Cs=Ms+((Ms>>>0)%3|0?-1:2)|0;if((Cs|0)!=-1){Ns=q[(Cs<<2)+Fs>>2]}q[Js>>2]=Ns;Cs=Ms+1|0;Cs=(Cs>>>0)%3|0?Cs:Ms+ -2|0;if((Cs|0)==-1){break n}Es=q[(Cs<<2)+Fs>>2];break n;case 5:break q;case 0:case 2:case 4:break c}}q[Gs>>2]=w(Ls,3);Ds=q[Vs>>2];Fs=Ds+24|0;Hs=q[Ds+32>>2];Cs=Ds+28|0;Ds=q[Cs>>2];A:{if((Hs|0)!=(Ds|0)){q[Ds>>2]=-1;Ms=Ds+4|0;q[Cs>>2]=Ms;break A}zi(Fs,11312);Ms=q[Cs>>2]}Os=q[Vs>>2];Ns=q[Os>>2];Ds=q[Gs>>2];Is=Ms-q[Fs>>2]|0;Qs=Is>>2;Cs=Qs+ -1|0;q[Ns+(Ds<<2)>>2]=Cs;Ds=Ds+1|0;Ks=Os+24|0;Hs=Os+28|0;Fs=q[Hs>>2];B:{if((Fs|0)!=q[Os+32>>2]){q[Fs>>2]=-1;Ms=Fs+4|0;q[Hs>>2]=Ms;break B}zi(Ks,11312);Ms=q[Hs>>2];Ns=q[Os>>2]}q[(Ds<<2)+Ns>>2]=(Ms-q[Ks>>2]>>2)+ -1;Ds=q[Gs>>2]+2|0;Ks=q[Vs>>2];Fs=Ks+28|0;Hs=q[Fs>>2];C:{if((Hs|0)!=q[Ks+32>>2]){q[Hs>>2]=-1;Ns=Hs+4|0;q[Fs>>2]=Ns;break C}zi(Ks+24|0,11312);Ns=q[Fs>>2]}q[q[Ks>>2]+(Ds<<2)>>2]=(Ns-q[Ks+24>>2]>>2)+ -1;Ds=q[Vs>>2];Fs=q[Ds+24>>2];if(q[Ds+28>>2]-Fs>>2>(Ss|0)){break c}Ds=q[Gs>>2];D:{E:{if(!Is){Es=1;q[Fs+(Qs<<2)>>2]=Ds+1;break E}q[Fs+(Cs<<2)>>2]=Ds;Es=0;if((Is|0)==-4){break E}q[Fs+(Qs<<2)>>2]=q[Gs>>2]+1;Es=Qs+1|0;if((Es|0)==-1){break D}}q[Fs+(Es<<2)>>2]=q[Gs>>2]+2}Ds=q[Gs+68>>2];if((Ds|0)!=q[Gs+72>>2]){q[Ds>>2]=q[Gs>>2];Ds=Ds+4|0;q[Gs+68>>2]=Ds;break p}zi(Gs- -64|0,Gs);Ds=q[Gs+68>>2]}Cs=1;break d}Ns=-1;Fs=q[Rs>>2];q[Fs+(Ps<<2)>>2]=-1}q[Fs+Hs>>2]=Es;F:{G:{H:{if(!Ks){Cs=Xs+((Xs>>>0)%3|0?-1:2)|0;if((Cs|0)==-1){break H}Cs=q[(Cs<<2)+Fs>>2];q[Fs+Os>>2]=Cs;if((Cs|0)==-1){break G}q[q[Rs+24>>2]+(Cs<<2)>>2]=Qs;break G}q[Fs+Os>>2]=-1;Js=-1;Es=-1;break F}q[Fs+Os>>2]=-1}Js=-1;Cs=Xs+1|0;Cs=(Cs>>>0)%3|0?Cs:Xs+ -2|0;Es=-1;if((Cs|0)==-1){break F}Js=q[(Cs<<2)+Fs>>2];Es=Cs}q[Gs>>2]=Js;Hs=q[_s>>2];Fs=Ns<<2;Cs=Hs+Fs|0;q[Cs>>2]=q[Cs>>2]+q[Hs+(Js<<2)>>2];Hs=q[Rs+24>>2];if((Ns|0)!=-1){q[Fs+Hs>>2]=q[Hs+(q[Gs>>2]<<2)>>2]}I:{if((Es|0)==-1){break I}Fs=q[Rs>>2];while(1){q[Fs+(Es<<2)>>2]=Ns;Cs=Es+1|0;Cs=(Cs>>>0)%3|0?Cs:Es+ -2|0;if((Cs|0)==-1){break I}Es=q[q[Is>>2]+(Cs<<2)>>2];if((Es|0)==-1){break I}Cs=Es+1|0;Es=(Cs>>>0)%3|0?Cs:Es+ -2|0;if((Es|0)!=-1){continue}break}}q[Hs+(q[Gs>>2]<<2)>>2]=-1;J:{if(Ys){break J}Cs=q[Gs+28>>2];if((Cs|0)!=q[Gs+32>>2]){q[Cs>>2]=q[Gs>>2];q[Gs+28>>2]=Cs+4;break J}zi(Gs+24|0,Gs);Ds=q[Gs+68>>2]}q[Ds+ -4>>2]=Ps;Cs=0}Ii(Us,q[Ds+ -4>>2]);K:{if(!Cs){break K}Ds=q[Ws>>2];if((Ds|0)==q[a+36>>2]){break K}Hs=(Ls^-1)+us|0;while(1){Es=-1;Cs=q[Ds+ -8>>2];if(Cs>>>0>Hs>>>0){break c}if((Cs|0)!=(Hs|0)){break K}Cs=r[Ds+ -4|0];Ds=Ds+ -12|0;Fs=q[Ds>>2];q[Ws>>2]=Ds;if((Fs|0)<0){break c}Es=q[q[Gs+68>>2]+ -4>>2];q[Gs+20>>2]=(Fs^-1)+us;q[Gs+88>>2]=Gs+20;Bi(Gs,Gs+40|0,Gs+20|0,Gs+88|0);Fs=q[Gs>>2];L:{if(Cs&1){Cs=-1;if((Es|0)==-1){break L}Ds=Es+1|0;Cs=(Ds>>>0)%3|0?Ds:Es+ -2|0;break L}Cs=-1;if((Es|0)==-1){break L}Cs=Es+ -1|0;if((Es>>>0)%3){break L}Cs=Es+2|0}q[Fs+12>>2]=Cs;Ds=q[Ws>>2];if((Ds|0)!=q[a+36>>2]){continue}break}}Ls=Ls+1|0;if((Ls|0)!=(us|0)){continue}break}Hs=us}Es=-1;Js=q[a+8>>2];if(q[Js+28>>2]-q[Js+24>>2]>>2>(Ss|0)){break c}Ds=q[Gs+68>>2];if((Ds|0)!=q[Gs+64>>2]){Ps=a+72|0;us=a+60|0;Zs=a+312|0;_s=a+352|0;Ys=a+8|0;Os=a+68|0;Qs=a+80|0;Ws=a+76|0;while(1){Cs=Ds+ -4|0;Ds=q[Cs>>2];q[Gs+68>>2]=Cs;q[Gs>>2]=Ds;M:{N:{O:{P:{if(s[a+270>>1]<=513){if(!r[a+364|0]){break O}Cs=q[a+360>>2];Ds=q[_s>>2]+(Cs>>>3)|0;if(Ds>>>0>=t[a+356>>2]){break N}Ds=r[Ds|0];q[a+360>>2]=Cs+1;Cs=Ds>>>(Cs&7)&1;break P}Cs=dh(Zs)}if(!Cs){break N}}Is=q[Ys>>2];Ss=q[Is>>2];if((Hs|0)>=((q[Is+4>>2]-Ss>>2>>>0)/3|0)){break c}Ls=-1;Js=-1;Ks=q[Is+24>>2];Fs=Ks;Ts=q[Gs>>2];Ds=-1;Q:{if((Ts|0)==-1){break Q}Cs=Ts+1|0;Cs=(Cs>>>0)%3|0?Cs:Ts+ -2|0;Ds=-1;if((Cs|0)==-1){break Q}Ds=q[Ss+(Cs<<2)>>2]}Fs=q[Fs+(Ds<<2)>>2];R:{if((Fs|0)==-1){break R}Cs=Fs+1|0;Cs=(Cs>>>0)%3|0?Cs:Fs+ -2|0;if((Cs|0)==-1){break R}Ls=Cs+1|0;Ls=(Ls>>>0)%3|0?Ls:Cs+ -2|0;if((Ls|0)!=-1){Js=q[Ss+(Ls<<2)>>2]}Ls=Cs}Ms=-1;Us=-1;Ks=q[Ks+(Js<<2)>>2];Fs=-1;S:{if((Ks|0)==-1){break S}Cs=Ks+1|0;Cs=(Cs>>>0)%3|0?Cs:Ks+ -2|0;Fs=-1;if((Cs|0)==-1){break S}Fs=Cs+1|0;Fs=(Fs>>>0)%3|0?Fs:Cs+ -2|0;if((Fs|0)!=-1){Us=q[Ss+(Fs<<2)>>2]}Fs=Cs}Cs=w(Hs,3);q[Gs+88>>2]=Cs;Ks=q[Is+12>>2];q[Ks+(Cs<<2)>>2]=Ts;q[Ks+(Ts<<2)>>2]=Cs;Cs=q[Gs+88>>2]+1|0;q[Ks+(Cs<<2)>>2]=Ls;q[Ks+(Ls<<2)>>2]=Cs;Cs=q[Gs+88>>2]+2|0;q[Ks+(Cs<<2)>>2]=Fs;q[Ks+(Fs<<2)>>2]=Cs;Cs=q[Gs+88>>2];q[Ss+(Cs<<2)>>2]=Js;Ts=Cs+1|0;Is=Ss+(Ts<<2)|0;q[Is>>2]=Us;Ks=Cs+2|0;Fs=Ss+(Ks<<2)|0;q[Fs>>2]=Ds;Us=q[a+120>>2];Ls=Ts>>>0<Cs>>>0?-1:Js;Cs=Us+(Ls>>>3&536870908)|0;Ds=q[Cs>>2];$s=Cs,at=eo(Ls)&Ds,q[$s>>2]=at;Ms=(Ts|0)!=-1?q[Is>>2]:Ms;Cs=Us+(Ms>>>3&536870908)|0;Ds=q[Cs>>2];$s=Cs,at=eo(Ms)&Ds,q[$s>>2]=at;Ds=-1;Ds=(Ks|0)!=-1?q[Fs>>2]:Ds;Ls=Us+(Ds>>>3&536870908)|0;Cs=q[Ls>>2];$s=Ls,at=eo(Ds)&Cs,q[$s>>2]=at;Ds=q[a+64>>2];Fs=q[Os>>2];if((Ds|0)==Fs<<5){if((Ds+1|0)<=-1){break a}Cs=us;if(Ds>>>0<=1073741822){Ls=Ds+32&-32;Ds=Fs<<6;Ds=Ds>>>0<Ls>>>0?Ls:Ds}else{Ds=2147483647}cb(Cs,Ds);Ds=q[a+64>>2]}Hs=Hs+1|0;q[a+64>>2]=Ds+1;Cs=q[a+60>>2]+(Ds>>>3&536870908)|0;q[Cs>>2]=q[Cs>>2]|1<<(Ds&31);Ds=q[Ws>>2];if((Ds|0)!=q[Qs>>2]){q[Ds>>2]=q[Gs+88>>2];q[Ws>>2]=Ds+4;break M}zi(Ps,Gs+88|0);break M}Ds=q[a+64>>2];Fs=q[Os>>2];if((Ds|0)==Fs<<5){if((Ds+1|0)<=-1){break a}Cs=us;if(Ds>>>0<=1073741822){Ls=Ds+32&-32;Ds=Fs<<6;Ds=Ds>>>0<Ls>>>0?Ls:Ds}else{Ds=2147483647}cb(Cs,Ds);Ds=q[a+64>>2]}q[a+64>>2]=Ds+1;Ls=q[a+60>>2]+(Ds>>>3&536870908)|0;Cs=q[Ls>>2];$s=Ls,at=eo(Ds)&Cs,q[$s>>2]=at;Ds=q[Ws>>2];if((Ds|0)!=q[Qs>>2]){q[Ds>>2]=q[Gs>>2];q[Ws>>2]=Ds+4;break M}zi(Ps,Gs)}Ds=q[Gs+68>>2];if((Ds|0)!=q[Gs+64>>2]){continue}break}Js=q[a+8>>2]}if(((q[Js+4>>2]-q[Js>>2]>>2>>>0)/3|0)!=(Hs|0)){break c}Es=q[Js+28>>2]-q[Js+24>>2]>>2;us=q[Gs+24>>2];Ks=q[Gs+28>>2];if((us|0)==(Ks|0)){break b}Fs=a+8|0;while(1){Is=q[us>>2];Hs=q[Js+24>>2];Ds=Es+ -1|0;T:{if(q[Hs+(Ds<<2)>>2]!=-1){Ls=Es;break T}Hs=q[Js+24>>2];while(1){Ds=Es+ -2|0;Ls=Es+ -1|0;Es=Ls;if(q[(Ds<<2)+Hs>>2]==-1){continue}break}}if(!(Ds>>>0<Is>>>0)){q[Gs>>2]=Js;Cs=Ds<<2;Es=q[Cs+Hs>>2];o[Gs+12|0]=1;q[Gs+8>>2]=Es;q[Gs+4>>2]=Es;if((Es|0)!=-1){while(1){q[q[Js>>2]+(Es<<2)>>2]=Is;lg(Gs);Js=q[Fs>>2];Es=q[Gs+8>>2];if((Es|0)!=-1){continue}break}}Es=Cs;Cs=q[Js+24>>2];Es=Es+Cs|0;if((Is|0)!=-1){q[Cs+(Is<<2)>>2]=q[Es>>2]}q[Es>>2]=-1;Ys=1<<(Is&31);Es=q[a+120>>2];Is=Es+(Is>>>3&536870908)|0;Cs=Is;Hs=Es+(Ds>>>3&536870908)|0;Ds=1<<(Ds&31);Es=Ys|q[Is>>2];U:{if(q[Hs>>2]&Ds){break U}Es=q[Is>>2]&(Ys^-1)}q[Cs>>2]=Es;q[Hs>>2]=q[Hs>>2]&(Ds^-1);Ls=Ls+ -1|0}Es=Ls;us=us+4|0;if((Ks|0)!=(us|0)){continue}break}}us=q[Gs+24>>2]}if(us){q[Gs+28>>2]=us;An(us)}Ds=q[Gs+48>>2];if(Ds){while(1){a=q[Ds>>2];An(Ds);Ds=a;if(Ds){continue}break}}a=q[Gs+40>>2];q[Gs+40>>2]=0;if(a){An(a)}a=q[Gs+64>>2];if(a){q[Gs+68>>2]=a;An(a)}T=Gs+96|0;return Es}bn();F()}function Ii(a,us){var bt=0,ct=0,dt=0,et=0,ft=0;ct=-1;ft=-1;a:{if((us|0)==-1){break a}bt=us+1|0;ct=(bt>>>0)%3|0?bt:us+ -2|0;ft=us+ -1|0;if((us>>>0)%3){break a}ft=us+2|0}bt=q[a+184>>2];b:{if(bt>>>0>7){break b}c:{d:{switch(bt-2|0){default:dt=q[a+148>>2];bt=-1;bt=(ct|0)!=-1?q[q[dt>>2]+(ct<<2)>>2]:bt;ct=1;et=bt<<2;bt=q[a+156>>2];et=et+bt|0;q[et>>2]=q[et>>2]+1;bt=(((ft|0)!=-1?q[q[dt>>2]+(ft<<2)>>2]:-1)<<2)+bt|0;break c;case 3:et=q[a+148>>2];bt=q[a+156>>2];dt=bt+(((us|0)!=-1?q[q[et>>2]+(us<<2)>>2]:-1)<<2)|0;q[dt>>2]=q[dt>>2]+1;dt=(((ct|0)!=-1?q[q[et>>2]+(ct<<2)>>2]:-1)<<2)+bt|0;q[dt>>2]=q[dt>>2]+1;ct=2;bt=(((ft|0)!=-1?q[q[et>>2]+(ft<<2)>>2]:-1)<<2)+bt|0;break c;case 1:et=q[a+148>>2];bt=q[a+156>>2];dt=bt+(((us|0)!=-1?q[q[et>>2]+(us<<2)>>2]:-1)<<2)|0;q[dt>>2]=q[dt>>2]+1;dt=(((ct|0)!=-1?q[q[et>>2]+(ct<<2)>>2]:-1)<<2)+bt|0;q[dt>>2]=q[dt>>2]+2;ct=1;bt=(((ft|0)!=-1?q[q[et>>2]+(ft<<2)>>2]:-1)<<2)+bt|0;break c;case 0:case 2:case 4:break b;case 5:break d}}et=q[a+148>>2];bt=q[a+156>>2];dt=bt+(((us|0)!=-1?q[q[et>>2]+(us<<2)>>2]:-1)<<2)|0;q[dt>>2]=q[dt>>2]+2;dt=(((ct|0)!=-1?q[q[et>>2]+(ct<<2)>>2]:-1)<<2)+bt|0;q[dt>>2]=q[dt>>2]+2;ct=2;bt=(((ft|0)!=-1?q[q[et>>2]+(ft<<2)>>2]:-1)<<2)+bt|0}q[bt>>2]=q[bt>>2]+ct;bt=q[a+184>>2]}e:{if(bt>>>0>5){break e}f:{switch(bt-1|0){case 0:case 1:case 2:case 3:break e;default:break f}}bt=a;ft=bt;bt=q[bt+156>>2];ct=-1;g:{if((us|0)==-1){break g}ct=us+1|0;us=(ct>>>0)%3|0?ct:us+ -2|0;ct=-1;if((us|0)==-1){break g}ct=q[q[q[a+148>>2]>>2]+(us<<2)>>2]}q[ft+188>>2]=q[bt+(ct<<2)>>2]>5?0:5;return}q[a+188>>2]=-1}function Ji(a){q[a>>2]=11372;Dn(a+4|0,0,80);q[a+96>>2]=0;q[a+100>>2]=0;q[a+92>>2]=-1;q[a+84>>2]=-1;q[a+88>>2]=-1;q[a+104>>2]=0;q[a+108>>2]=0;q[a+112>>2]=0;q[a+116>>2]=0;q[a+120>>2]=0;q[a+124>>2]=0;q[a+128>>2]=0;q[a+132>>2]=0;q[a+136>>2]=0;q[a+140>>2]=0;q[a+144>>2]=0;q[a+148>>2]=0;q[a+156>>2]=0;q[a+160>>2]=0;q[a+152>>2]=1065353216;q[a+164>>2]=0;q[a+168>>2]=0;q[a+172>>2]=0;q[a+176>>2]=0;q[a+180>>2]=0;q[a+184>>2]=0;q[a+188>>2]=0;q[a+192>>2]=0;q[a+196>>2]=0;q[a+200>>2]=0;q[a+204>>2]=0;q[a+208>>2]=0;q[a+212>>2]=-1;q[a+216>>2]=0;q[a+220>>2]=0;q[a+224>>2]=0;ci(a+232|0);q[a+388>>2]=0;q[a+392>>2]=0;q[a+380>>2]=0;q[a+384>>2]=0;q[a+416>>2]=0;q[a+420>>2]=0;q[a+412>>2]=7;q[a+404>>2]=-1;q[a+408>>2]=2;q[a+396>>2]=0;q[a+400>>2]=-1;q[a+424>>2]=0;q[a+428>>2]=0;q[a+432>>2]=0;q[a+436>>2]=0}function Ki(a){a=a|0;var us=0,gt=0,ht=0,it=0,jt=0,kt=0,lt=0,mt=0,nt=0,ot=0,pt=0,qt=0,rt=0,st=0,tt=0,ut=0,vt=0;mt=T+ -64|0;T=mt;q[a+132>>2]=0;if(q[a+148>>2]){ht=a+144|0;gt=q[ht>>2];if(gt){while(1){us=q[gt>>2];An(gt);gt=us;if(us){continue}break}}q[ht>>2]=0;us=q[a+140>>2];if(us){ht=a+136|0;gt=0;while(1){q[q[ht>>2]+(gt<<2)>>2]=0;gt=gt+1|0;if((us|0)!=(gt|0)){continue}break}}q[a+148>>2]=0}a:{b:{c:{d:{e:{f:{gt=q[a+4>>2];ht=r[gt+36|0];us=ht<<8|r[gt+37|0];g:{if(us>>>0>513){break g}kt=q[gt+32>>2];if(us>>>0<=511){it=q[kt+12>>2];us=q[kt+20>>2];lt=q[kt+16>>2];jt=lt+4|0;if(jt>>>0<4){us=us+1|0}nt=jt;jt=us;if((it|0)<(us|0)?1:(it|0)<=(us|0)?t[kt+8>>2]>=nt>>>0?0:1:0){break f}us=lt+q[kt>>2]|0;us=r[us|0]|r[us+1|0]<<8|(r[us+2|0]<<16|r[us+3|0]<<24);q[mt>>2]=us;q[kt+16>>2]=nt;q[kt+20>>2]=jt;q[a+132>>2]=us;break g}if(!oi(1,mt,kt)){break f}gt=q[a+4>>2];ht=r[gt+36|0];q[a+132>>2]=q[mt>>2]}gt=q[gt+32>>2];h:{i:{j:{if((ht&255)>>>0<=1){ht=0;kt=q[gt+12>>2];us=q[gt+20>>2];it=q[gt+16>>2];jt=it+4|0;if(jt>>>0<4){us=us+1|0}lt=jt;jt=us;if((kt|0)<(us|0)?1:(kt|0)<=(us|0)?t[gt+8>>2]>=lt>>>0?0:1:0){break a}us=it+q[gt>>2]|0;us=r[us|0]|r[us+1|0]<<8|(r[us+2|0]<<16|r[us+3|0]<<24);q[mt+60>>2]=us;q[gt+16>>2]=lt;q[gt+20>>2]=jt;q[a+156>>2]=us;pt=a+156|0;break j}ht=0;if(!oi(1,mt+60|0,gt)){break a}us=q[a+4>>2];gt=q[us+32>>2];us=r[us+36|0];q[a+156>>2]=q[mt+60>>2];pt=a+156|0;if(us>>>0>1){break i}}kt=q[gt+12>>2];us=q[gt+20>>2];it=q[gt+16>>2];jt=it+4|0;if(jt>>>0<4){us=us+1|0}nt=jt;jt=us;if((kt|0)<(us|0)?1:(kt|0)<=(us|0)?t[gt+8>>2]>=nt>>>0?0:1:0){break a}us=it+q[gt>>2]|0;lt=r[us|0]|r[us+1|0]<<8|(r[us+2|0]<<16|r[us+3|0]<<24);q[mt+56>>2]=lt;q[gt+16>>2]=nt;q[gt+20>>2]=jt;break h}if(!oi(1,mt+56|0,gt)){break a}lt=q[mt+56>>2]}if(lt>>>0>1431655765|t[pt>>2]>w(lt,3)>>>0){break a}qt=q[a+4>>2];jt=q[qt+32>>2];rt=q[jt+8>>2];ot=q[jt+16>>2];kt=q[jt+12>>2];us=kt;gt=q[jt+20>>2];if((us|0)<(gt|0)?1:(us|0)<=(gt|0)?rt>>>0>ot>>>0?0:1:0){break a}tt=q[jt>>2];nt=r[tt+ot|0];us=gt;st=ot+1|0;if(st>>>0<1){us=us+1|0}q[jt+16>>2]=st;q[jt+20>>2]=us;k:{if(r[qt+36|0]<=1){us=gt;gt=ot+5|0;if(gt>>>0<5){us=us+1|0}it=gt;gt=us;if((kt|0)<(us|0)?1:(kt|0)<=(us|0)?rt>>>0>=it>>>0?0:1:0){break a}us=st+tt|0;kt=r[us|0]|r[us+1|0]<<8|(r[us+2|0]<<16|r[us+3|0]<<24);q[mt+52>>2]=kt;q[jt+16>>2]=it;q[jt+20>>2]=gt;break k}if(!oi(1,mt+52|0,jt)){break a}kt=q[mt+52>>2]}if(lt>>>0<kt>>>0|lt>>>0>((kt>>>0)/3|0)+kt>>>0){break a}us=q[a+4>>2];jt=q[us+32>>2];l:{if(r[us+36|0]<=1){it=q[jt+12>>2];us=q[jt+20>>2];ot=q[jt+16>>2];gt=ot+4|0;if(gt>>>0<4){us=us+1|0}qt=gt;gt=us;if((it|0)<(us|0)?1:(it|0)<=(us|0)?t[jt+8>>2]>=qt>>>0?0:1:0){break a}us=ot+q[jt>>2]|0;ot=r[us|0]|r[us+1|0]<<8|(r[us+2|0]<<16|r[us+3|0]<<24);q[mt+48>>2]=ot;q[jt+16>>2]=qt;q[jt+20>>2]=gt;break l}if(!oi(1,mt+48|0,jt)){break a}ot=q[mt+48>>2]}if(ot>>>0>kt>>>0){break a}q[a+28>>2]=q[a+24>>2];gt=Mm(88);jk(gt);us=q[a+8>>2];q[a+8>>2]=gt;jt=a+8|0;if(us){wa(jt,us);if(!q[jt>>2]){break a}}us=q[a+160>>2];q[a+164>>2]=us;m:{if(q[a+168>>2]-us>>2>>>0>=lt>>>0){break m}if(lt>>>0>=1073741824){break e}ht=lt<<2;gt=Mm(ht);q[a+164>>2]=gt;q[a+160>>2]=gt;q[a+168>>2]=gt+ht;if(!us){break m}An(us)}us=q[a+172>>2];q[a+176>>2]=us;n:{if(q[a+180>>2]-us>>2>>>0>=lt>>>0){break n}if(lt>>>0>=1073741824){break d}ht=lt<<2;gt=Mm(ht);q[a+176>>2]=gt;q[a+172>>2]=gt;q[a+180>>2]=gt+ht;if(!us){break n}An(us)}q[a+92>>2]=-1;q[a+84>>2]=-1;q[a+88>>2]=-1;q[a+40>>2]=q[a+36>>2];q[a- -64>>2]=0;q[a+52>>2]=q[a+48>>2];q[a+76>>2]=q[a+72>>2];qt=a+216|0;gt=q[a+220>>2];ht=q[a+216>>2];if((gt|0)==(ht|0)){break c}while(1){us=q[gt+ -12>>2];if(us){q[gt+ -8>>2]=us;An(us)}us=q[gt+ -28>>2];if(us){q[gt+ -24>>2]=us;An(us)}us=gt+ -144|0;it=q[gt+ -40>>2];if(it){q[gt+ -36>>2]=it;An(it)}pi(gt+ -140|0);gt=us;if((ht|0)!=(us|0)){continue}break}us=q[qt>>2];break b}ht=0;break a}ab(12024);F()}ab(12024);F()}us=ht}q[a+220>>2]=ht;gt=(ht-us|0)/144|0;o:{if(gt>>>0<nt>>>0){qi(qt,nt-gt|0);break o}if(gt>>>0<=nt>>>0){break o}gt=us+w(nt,144)|0;if((gt|0)!=(ht|0)){while(1){us=q[ht+ -12>>2];if(us){q[ht+ -8>>2]=us;An(us)}us=q[ht+ -28>>2];if(us){q[ht+ -24>>2]=us;An(us)}us=ht+ -144|0;it=q[ht+ -40>>2];if(it){q[ht+ -36>>2]=it;An(it)}pi(ht+ -140|0);ht=us;if((us|0)!=(gt|0)){continue}break}}q[a+220>>2]=gt}ht=0;if(!tk(q[jt>>2],lt,q[pt>>2]+ot|0)){break a}us=q[a+156>>2];o[mt|0]=1;bb(a+120|0,us+ot|0,mt);gt=q[a+4>>2];us=s[gt+36>>1];us=(us<<24|us<<8&16711680)>>>16;p:{if(us>>>0<=513){it=q[gt+32>>2];q:{if(us>>>0<=511){lt=q[it+12>>2];us=q[it+20>>2];pt=q[it+16>>2];gt=pt+4|0;if(gt>>>0<4){us=us+1|0}rt=gt;gt=us;if((lt|0)<(us|0)?1:(lt|0)<=(us|0)?t[it+8>>2]>=rt>>>0?0:1:0){break a}us=pt+q[it>>2]|0;lt=r[us|0]|r[us+1|0]<<8|(r[us+2|0]<<16|r[us+3|0]<<24);q[mt+44>>2]=lt;q[it+16>>2]=rt;q[it+20>>2]=gt;break q}if(!oi(1,mt+44|0,it)){break a}lt=q[mt+44>>2]}if(!lt){break a}us=q[q[a+4>>2]+32>>2];gt=q[us+8>>2];it=q[us+16>>2];us=q[us+12>>2]-(q[us+20>>2]+(gt>>>0<it>>>0)|0)|0;if((us|0)<0?1:(us|0)<=0?gt-it>>>0>=lt>>>0?0:1:0){break a}it=Yj(mt);gt=q[q[a+4>>2]+32>>2];us=q[gt+16>>2];pt=q[gt+8>>2];Zj(it,(us+q[gt>>2]|0)+lt|0,(pt-us|0)-lt|0,s[gt+38>>1]);gt=ri(a,it);if((gt|0)==-1){break a}us=gt;it=us>>31;break p}us=-1;it=-1;if((ri(a,q[gt+32>>2])|0)==-1){break a}}q[a+376>>2]=a;pt=a+232|0;gt=q[(n[q[q[a>>2]+32>>2]](a)|0)+32>>2];rt=q[gt>>2]+q[gt+16>>2]|0;lt=q[(n[q[q[a>>2]+32>>2]](a)|0)+32>>2];gt=q[lt+8>>2];ht=q[lt+16>>2];Zj(pt,rt,gt-ht|0,s[q[(n[q[q[a>>2]+32>>2]](a)|0)+32>>2]+38>>1]);ut=a,vt=n[q[q[a>>2]+36>>2]](a)|0,q[ut+380>>2]=vt;q[a+372>>2]=nt;q[a+384>>2]=q[a+156>>2]+ot;ht=0;gt=Yj(mt);r:{if(!Li(pt,gt)){break r}lt=Mi(a,kt);if((lt|0)==-1){break r}kt=q[q[a+4>>2]+32>>2];ht=q[gt+16>>2];nt=ht+q[gt>>2]|0;gt=q[gt+8>>2];Zj(kt,nt,gt-ht|0,s[kt+38>>1]);gt=q[a+4>>2];ht=s[gt+36>>1];kt=(ht<<24|ht<<8&16711680)>>>16;if(kt>>>0<=513){ht=q[gt+32>>2];nt=ht;rt=ht;gt=it+q[ht+20>>2]|0;ht=us+q[ht+16>>2]|0;if(ht>>>0<us>>>0){gt=gt+1|0}q[rt+16>>2]=ht;q[nt+20>>2]=gt}s:{if(q[a+220>>2]==q[a+216>>2]){break s}gt=q[jt>>2];us=q[gt+4>>2];gt=q[gt>>2];t:{if(kt>>>0>=513){if((us|0)==(gt|0)){break s}gt=0;break t}if((us|0)==(gt|0)){break s}gt=0;while(1){if(ui(a,gt)){gt=gt+3|0;us=q[jt>>2];if(gt>>>0<q[us+4>>2]-q[us>>2]>>2>>>0){continue}break s}break}ht=0;break r}while(1){if(vi(a,gt)){gt=gt+3|0;us=q[jt>>2];if(gt>>>0<q[us+4>>2]-q[us>>2]>>2>>>0){continue}break s}break}ht=0;break r}if(r[a+308|0]){ak(a+272|0)}if(s[a+270>>1]<=513){ak(a+328|0)}gt=q[a+216>>2];it=a+220|0;if((gt|0)!=q[it>>2]){kt=0;while(1){us=w(kt,144);Ek((us+gt|0)+4|0,q[jt>>2]);ht=q[qt>>2];nt=us+ht|0;gt=q[nt+132>>2];nt=q[nt+136>>2];if((gt|0)!=(nt|0)){while(1){Gk((us+ht|0)+4|0,q[gt>>2]);ht=q[qt>>2];gt=gt+4|0;if((nt|0)!=(gt|0)){continue}break}}Fk((us+ht|0)+4|0);kt=kt+1|0;gt=q[a+216>>2];if(kt>>>0<(q[it>>2]-gt|0)/144>>>0){continue}break}}us=q[a+8>>2];wi(a+184|0,q[us+28>>2]-q[us+24>>2]>>2);ht=q[a+216>>2];if((ht|0)!=q[it>>2]){gt=0;kt=a+220|0;while(1){us=w(gt,144)+ht|0;ht=q[us+60>>2]-q[us+56>>2]>>2;nt=us+104|0;us=q[jt>>2];us=q[us+28>>2]-q[us+24>>2]>>2;wi(nt,(ht|0)<(us|0)?us:ht);gt=gt+1|0;ht=q[a+216>>2];if(gt>>>0<(q[kt>>2]-ht|0)/144>>>0){continue}break}}ht=xi(a,lt)}}T=mt- -64|0;return ht|0}function Li(a,wt){var xt=0,yt=0,zt=0,At=0,Bt=0,Ct=0,Dt=0,Et=0,Ft=0,Gt=0,Ht=0,It=0;Et=T-16|0;T=Et;xt=q[a+144>>2];xt=s[(n[q[q[xt>>2]+32>>2]](xt)|0)+36>>1];a:{if((xt<<24|xt<<8&16711680)>>>16>>>0<=513){xt=q[a+4>>2];q[a+40>>2]=q[a>>2];q[a+44>>2]=xt;zt=a+32|0;xt=zt;yt=q[xt+4>>2];q[a+72>>2]=q[xt>>2];q[a+76>>2]=yt;yt=q[a+28>>2];xt=a- -64|0;q[xt>>2]=q[a+24>>2];q[xt+4>>2]=yt;xt=q[a+20>>2];q[a+56>>2]=q[a+16>>2];q[a+60>>2]=xt;xt=q[a+12>>2];q[a+48>>2]=q[a+8>>2];q[a+52>>2]=xt;b:{xt=a+40|0;if(_j(xt,1,Et+8|0)){yt=q[xt+4>>2];q[a>>2]=q[xt>>2];q[a+4>>2]=yt;yt=q[xt+36>>2];q[zt>>2]=q[xt+32>>2];q[zt+4>>2]=yt;zt=q[xt+28>>2];q[a+24>>2]=q[xt+24>>2];q[a+28>>2]=zt;yt=q[xt+20>>2];Bt=yt;zt=q[xt+16>>2];q[a+16>>2]=zt;q[a+20>>2]=yt;yt=q[xt+12>>2];xt=q[xt+8>>2];q[a+8>>2]=xt;q[a+12>>2]=yt;Ct=xt-zt|0;Dt=q[Et+12>>2];xt=yt-((xt>>>0<zt>>>0)+Bt|0)|0;yt=q[Et+8>>2];if((Dt|0)==(xt|0)&yt>>>0<=Ct>>>0|Dt>>>0<xt>>>0){break b}}At=0;break a}xt=Bt+Dt|0;zt=zt+yt|0;if(zt>>>0<yt>>>0){xt=xt+1|0}q[a+16>>2]=zt;q[a+20>>2]=xt}c:{if(s[a+38>>1]<=513){xt=q[a+4>>2];q[a+96>>2]=q[a>>2];q[a+100>>2]=xt;zt=a+32|0;xt=zt;yt=q[xt+4>>2];q[a+128>>2]=q[xt>>2];q[a+132>>2]=yt;yt=a+24|0;xt=yt;At=q[xt+4>>2];q[a+120>>2]=q[xt>>2];q[a+124>>2]=At;At=a+16|0;xt=At;Bt=q[xt+4>>2];q[a+112>>2]=q[xt>>2];q[a+116>>2]=Bt;Bt=a+8|0;xt=Bt;Ct=q[xt+4>>2];q[a+104>>2]=q[xt>>2];q[a+108>>2]=Ct;d:{xt=a+96|0;if(_j(xt,1,Et+8|0)){Ct=q[xt+4>>2];q[a>>2]=q[xt>>2];q[a+4>>2]=Ct;Ct=q[xt+36>>2];q[zt>>2]=q[xt+32>>2];q[zt+4>>2]=Ct;zt=q[xt+28>>2];q[yt>>2]=q[xt+24>>2];q[yt+4>>2]=zt;yt=q[xt+20>>2];Ct=yt;zt=q[xt+16>>2];q[At>>2]=zt;q[At+4>>2]=yt;yt=q[xt+12>>2];xt=q[xt+8>>2];q[Bt>>2]=xt;q[Bt+4>>2]=yt;Bt=xt-zt|0;Dt=q[Et+12>>2];yt=yt-((xt>>>0<zt>>>0)+Ct|0)|0;xt=q[Et+8>>2];if((Dt|0)==(yt|0)&xt>>>0<=Bt>>>0|Dt>>>0<yt>>>0){break d}}At=0;break a}At=Ct+Dt|0;zt=xt+zt|0;if(zt>>>0<xt>>>0){At=At+1|0}q[a+16>>2]=zt;q[a+20>>2]=At;break c}At=0;if(!bh(a+80|0,a)){break a}}At=0;if(!Ai(a)){break a}xt=q[a+4>>2];q[wt>>2]=q[a>>2];q[wt+4>>2]=xt;xt=q[a+36>>2];q[wt+32>>2]=q[a+32>>2];q[wt+36>>2]=xt;xt=q[a+28>>2];q[wt+24>>2]=q[a+24>>2];q[wt+28>>2]=xt;xt=q[a+20>>2];q[wt+16>>2]=q[a+16>>2];q[wt+20>>2]=xt;xt=q[a+12>>2];q[wt+8>>2]=q[a+8>>2];q[wt+12>>2]=xt;xt=q[a+144>>2];xt=s[(n[q[q[xt>>2]+32>>2]](xt)|0)+36>>1];e:{if((xt<<24|xt<<8&16711680)>>>16>>>0<=513){xt=q[a+144>>2];f:{if(r[(n[q[q[xt>>2]+32>>2]](xt)|0)+36|0]<=1){yt=q[wt+12>>2];xt=q[wt+20>>2];Bt=q[wt+16>>2];zt=Bt+4|0;if(zt>>>0<4){xt=xt+1|0}Ct=zt;zt=xt;if((yt|0)<(xt|0)?1:(yt|0)<=(xt|0)?t[wt+8>>2]>=Ct>>>0?0:1:0){break a}xt=Bt+q[wt>>2]|0;yt=r[xt|0]|r[xt+1|0]<<8|(r[xt+2|0]<<16|r[xt+3|0]<<24);q[Et+8>>2]=yt;q[wt+16>>2]=Ct;q[wt+20>>2]=zt;break f}if(!oi(1,Et+8|0,wt)){break a}yt=q[Et+8>>2]}xt=q[a+152>>2];if(yt>>>0>=xt>>>0){break a}Bt=q[wt+16>>2];yt=q[wt+12>>2];zt=q[wt+20>>2];if((yt|0)<(zt|0)?1:(yt|0)<=(zt|0)?t[wt+8>>2]>Bt>>>0?0:1:0){break a}Ct=r[Bt+q[wt>>2]|0];Bt=Bt+1|0;if(Bt>>>0<1){zt=zt+1|0}yt=wt;q[yt+16>>2]=Bt;q[yt+20>>2]=zt;if(Ct){break a}q[a+176>>2]=2;q[a+180>>2]=7;break e}q[a+176>>2]=2;q[a+180>>2]=7;xt=q[a+152>>2]}if((xt|0)<0){break a}q[Et+8>>2]=0;At=2;Bt=q[a+156>>2];yt=q[a+160>>2]-Bt>>2;g:{if(xt>>>0>yt>>>0){Ad(a+156|0,xt-yt|0,Et+8|0);At=q[a+176>>2];zt=q[a+180>>2];break g}zt=7;if(xt>>>0>=yt>>>0){break g}q[a+160>>2]=Bt+(xt<<2)}Bt=a+184|0;zt=(zt-At|0)+1|0;At=a+188|0;xt=q[At>>2];Ct=q[a+184>>2];yt=(xt-Ct|0)/12|0;h:{if(zt>>>0>yt>>>0){Ni(Bt,zt-yt|0);zt=q[At>>2];break h}if(zt>>>0>=yt>>>0){zt=xt;break h}zt=Ct+w(zt,12)|0;if((zt|0)!=(xt|0)){while(1){yt=xt+ -12|0;At=q[yt>>2];if(At){q[xt+ -8>>2]=At;An(At)}xt=yt;if((xt|0)!=(zt|0)){continue}break}}q[a+188>>2]=zt}Ct=a+196|0;xt=q[a+184>>2];yt=(zt-xt|0)/12|0;Dt=q[a+196>>2];At=q[a+200>>2]-Dt>>2;i:{if(yt>>>0>At>>>0){Fa(Ct,yt-At|0);zt=q[a+188>>2];xt=q[a+184>>2];break i}if(yt>>>0>=At>>>0){break i}q[a+200>>2]=Dt+(yt<<2)}At=1;if((xt|0)==(zt|0)){break a}xt=0;It=a+188|0;while(1){oi(1,Et+8|0,wt);zt=q[Et+8>>2];if(zt){yt=q[Bt>>2];Ft=w(xt,12);At=yt+Ft|0;Gt=At+4|0;Ht=q[At>>2];Dt=q[Gt>>2]-Ht>>2;j:{if(zt>>>0>Dt>>>0){Fa(At,zt-Dt|0);yt=q[Bt>>2];break j}if(zt>>>0>=Dt>>>0){break j}q[Gt>>2]=(zt<<2)+Ht}qh(zt,1,wt,q[yt+Ft>>2]);q[q[Ct>>2]+(xt<<2)>>2]=zt}At=1;xt=xt+1|0;if(xt>>>0<(q[It>>2]-q[a+184>>2]|0)/12>>>0){continue}break}}T=Et+16|0;return At}



function Mi(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,p=0,u=0,v=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,G=0,H=0,I=0;g=T-96|0;T=g;q[g+72>>2]=0;q[g+64>>2]=0;q[g+68>>2]=0;q[g+48>>2]=0;q[g+52>>2]=0;q[g+40>>2]=0;q[g+44>>2]=0;q[g+56>>2]=1065353216;q[g+32>>2]=0;q[g+24>>2]=0;q[g+28>>2]=0;C=q[a+124>>2];a:{b:{c:{if((b|0)>=1){A=a+232|0;B=a+8|0;D=a+40|0;G=a+388|0;E=q[a+216>>2]!=q[a+220>>2];while(1){h=Oi(A);d:{if(!h){d=q[g+68>>2];if((d|0)==q[g+64>>2]){e=-1;break c}n=-1;u=q[B>>2];i=q[u+24>>2];f=i;h=d+ -4|0;v=q[h>>2];c=-1;e:{if((v|0)==-1){break e}e=v+1|0;e=(e>>>0)%3|0?e:v+ -2|0;c=-1;if((e|0)==-1){break e}c=q[q[u>>2]+(e<<2)>>2]}f=q[f+(c<<2)>>2];if((f|0)!=-1){e=f+1|0;n=(e>>>0)%3|0?e:f+ -2|0}f=q[u+12>>2];x=w(j,3);e=x+1|0;q[f+(v<<2)>>2]=e;e=e<<2;q[e+f>>2]=v;y=x+2|0;q[f+(n<<2)>>2]=y;k=y<<2;q[k+f>>2]=n;p=q[u>>2];q[p+(x<<2)>>2]=c;m=e+p|0;f=-1;f:{if((n|0)==-1){break f}e=n+1|0;e=(e>>>0)%3|0?e:n+ -2|0;f=-1;if((e|0)==-1){break f}f=q[p+(e<<2)>>2]}q[m>>2]=f;g:{h:{if((v|0)!=-1){e=v+((v>>>0)%3|0?-1:2)|0;if((e|0)!=-1){break h}}q[k+p>>2]=-1;break g}e=q[p+(e<<2)>>2];q[k+p>>2]=e;if((e|0)==-1){break g}q[i+(e<<2)>>2]=y}f=q[a+120>>2]+(c>>>3&536870908)|0;e=q[f>>2];H=f,I=eo(c)&e,q[H>>2]=I;q[h>>2]=x;c=0;break d}e=-1;d=h+ -1|0;if(d>>>0>6){break c}i:{j:{k:{l:{switch(d-1|0){case 1:case 3:f=q[g+68>>2];if((f|0)==q[g+64>>2]){break c}e=q[B>>2];c=q[e+12>>2];y=w(j,3);i=(h|0)==5;h=y+(i?2:1)|0;d=h<<2;p=q[f+ -4>>2];q[c+d>>2]=p;q[c+(p<<2)>>2]=h;f=e+24|0;m=q[e+32>>2];e=e+28|0;c=q[e>>2];m:{if((m|0)!=(c|0)){q[c>>2]=-1;u=c+4|0;q[e>>2]=u;break m}zi(f,11312);u=q[e>>2]}e=-1;c=q[B>>2];k=q[c+24>>2];if(q[c+28>>2]-k>>2>(C|0)){break c}e=y+2|0;x=q[c>>2];m=x+d|0;c=u-q[f>>2]|0;d=(c>>2)+ -1|0;q[m>>2]=d;if(c){q[k+(d<<2)>>2]=h}e=i?y:e;f=x+(i+y<<2)|0;n:{o:{p:{if((p|0)!=-1){d=p+((p>>>0)%3|0?-1:2)|0;if((d|0)==-1){break p}d=q[x+(d<<2)>>2];q[x+(e<<2)>>2]=d;if((d|0)==-1){break o}q[k+(d<<2)>>2]=e;break o}q[x+(e<<2)>>2]=-1;c=-1;break n}q[x+(e<<2)>>2]=-1}d=p+1|0;d=(d>>>0)%3|0?d:p+ -2|0;c=-1;if((d|0)==-1){break n}c=q[x+(d<<2)>>2]}q[f>>2]=c;d=q[g+68>>2];q[d+ -4>>2]=y;break k;default:d=q[g+68>>2];u=q[g+64>>2];if((d|0)==(u|0)){break c}c=d+ -4|0;z=q[c>>2];q[g+68>>2]=c;k=q[g+44>>2];q:{if(!k){d=c;break q}i=co(k)>>>0>1;r:{if(!i){f=k+2147483647&j;break r}f=j;if(f>>>0<k>>>0){break r}f=(j>>>0)%(k>>>0)|0}h=q[q[g+40>>2]+(f<<2)>>2];if(!h){d=c;break q}l=q[h>>2];if(!l){d=c;break q}h=k+ -1|0;s:{while(1){n=q[l+4>>2];t:{if((j|0)!=(n|0)){u:{if(!i){n=h&n;break u}if(n>>>0<k>>>0){break u}n=(n>>>0)%(k>>>0)|0}if((f|0)==(n|0)){break t}d=c;break q}if(q[l+8>>2]==(j|0)){break s}}l=q[l>>2];if(l){continue}break}d=c;break q}f=l+12|0;if((c|0)!=q[g+72>>2]){q[c>>2]=q[f>>2];q[g+68>>2]=d;break q}zi(g- -64|0,f);d=q[g+68>>2];u=q[g+64>>2]}if((d|0)==(u|0)){break c}p=q[d+ -4>>2];f=(p|0)==-1;v=q[B>>2];if(q[q[v+12>>2]+(p<<2)>>2]!=-1?!f:0){break c}i=(z|0)==-1;k=v+12|0;h=q[k>>2];if(q[h+(z<<2)>>2]!=-1?!i:0){break c}x=w(j,3);y=x+2|0;q[h+(p<<2)>>2]=y;u=y<<2;q[u+h>>2]=p;c=x+1|0;q[h+(z<<2)>>2]=c;m=h;h=c<<2;q[m+h>>2]=z;if(f){break j}n=-1;m=q[v>>2];f=m+(x<<2)|0;c=p+((p>>>0)%3|0?-1:2)|0;if((c|0)!=-1){n=q[(c<<2)+m>>2]}q[f>>2]=n;c=p+1|0;c=(c>>>0)%3|0?c:p+ -2|0;if((c|0)==-1){break i}e=q[(c<<2)+m>>2];break i;case 5:break l;case 0:case 2:case 4:break c}}q[g>>2]=w(j,3);d=q[B>>2];f=d+24|0;i=q[d+32>>2];c=d+28|0;d=q[c>>2];v:{if((i|0)!=(d|0)){q[d>>2]=-1;m=d+4|0;q[c>>2]=m;break v}zi(f,11312);m=q[c>>2]}u=q[B>>2];n=q[u>>2];d=q[g>>2];k=m-q[f>>2]|0;y=k>>2;c=y+ -1|0;q[n+(d<<2)>>2]=c;d=d+1|0;i=u+24|0;h=u+28|0;f=q[h>>2];w:{if((f|0)!=q[u+32>>2]){q[f>>2]=-1;m=f+4|0;q[h>>2]=m;break w}zi(i,11312);m=q[h>>2];n=q[u>>2]}q[(d<<2)+n>>2]=(m-q[i>>2]>>2)+ -1;d=q[g>>2]+2|0;i=q[B>>2];f=i+28|0;h=q[f>>2];x:{if((h|0)!=q[i+32>>2]){q[h>>2]=-1;n=h+4|0;q[f>>2]=n;break x}zi(i+24|0,11312);n=q[f>>2]}q[q[i>>2]+(d<<2)>>2]=(n-q[i+24>>2]>>2)+ -1;d=q[B>>2];f=q[d+24>>2];if(q[d+28>>2]-f>>2>(C|0)){break c}d=q[g>>2];y:{z:{if(!k){e=1;q[f+(y<<2)>>2]=d+1;break z}q[f+(c<<2)>>2]=d;e=0;if((k|0)==-4){break z}q[f+(y<<2)>>2]=q[g>>2]+1;e=y+1|0;if((e|0)==-1){break y}}q[f+(e<<2)>>2]=q[g>>2]+2}d=q[g+68>>2];if((d|0)!=q[g+72>>2]){q[d>>2]=q[g>>2];d=d+4|0;q[g+68>>2]=d;break k}zi(g- -64|0,g);d=q[g+68>>2]}c=1;break d}n=-1;m=q[v>>2];q[m+(x<<2)>>2]=-1}q[h+m>>2]=e;A:{B:{C:{if(!i){c=z+((z>>>0)%3|0?-1:2)|0;if((c|0)==-1){break C}c=q[(c<<2)+m>>2];q[u+m>>2]=c;if((c|0)==-1){break B}q[q[v+24>>2]+(c<<2)>>2]=y;break B}q[u+m>>2]=-1;l=-1;e=-1;break A}q[u+m>>2]=-1}l=-1;c=z+1|0;c=(c>>>0)%3|0?c:z+ -2|0;e=-1;if((c|0)==-1){break A}l=q[(c<<2)+m>>2];e=c}q[g>>2]=l;h=q[G>>2];f=n<<2;c=h+f|0;q[c>>2]=q[c>>2]+q[h+(l<<2)>>2];h=q[v+24>>2];if((n|0)!=-1){q[f+h>>2]=q[h+(q[g>>2]<<2)>>2]}D:{if((e|0)==-1){break D}f=q[v>>2];while(1){q[f+(e<<2)>>2]=n;c=e+1|0;c=(c>>>0)%3|0?c:e+ -2|0;if((c|0)==-1){break D}e=q[q[k>>2]+(c<<2)>>2];if((e|0)==-1){break D}c=e+1|0;e=(c>>>0)%3|0?c:e+ -2|0;if((e|0)!=-1){continue}break}}q[h+(q[g>>2]<<2)>>2]=-1;E:{if(E){break E}c=q[g+28>>2];if((c|0)!=q[g+32>>2]){q[c>>2]=q[g>>2];q[g+28>>2]=c+4;break E}zi(g+24|0,g);d=q[g+68>>2]}q[d+ -4>>2]=x;c=0}Pi(A,q[d+ -4>>2]);F:{if(!c){break F}d=q[D>>2];if((d|0)==q[a+36>>2]){break F}h=(j^-1)+b|0;while(1){e=-1;c=q[d+ -8>>2];if(c>>>0>h>>>0){break c}if((c|0)!=(h|0)){break F}c=r[d+ -4|0];d=d+ -12|0;f=q[d>>2];q[D>>2]=d;if((f|0)<0){break c}e=q[q[g+68>>2]+ -4>>2];q[g+20>>2]=(f^-1)+b;q[g+88>>2]=g+20;Bi(g,g+40|0,g+20|0,g+88|0);f=q[g>>2];G:{if(c&1){c=-1;if((e|0)==-1){break G}d=e+1|0;c=(d>>>0)%3|0?d:e+ -2|0;break G}c=-1;if((e|0)==-1){break G}c=e+ -1|0;if((e>>>0)%3){break G}c=e+2|0}q[f+12>>2]=c;d=q[D>>2];if((d|0)!=q[a+36>>2]){continue}break}}j=j+1|0;if((j|0)!=(b|0)){continue}break}h=b}e=-1;l=q[a+8>>2];if(q[l+28>>2]-q[l+24>>2]>>2>(C|0)){break c}d=q[g+68>>2];if((d|0)!=q[g+64>>2]){C=a+72|0;b=a+60|0;y=a+312|0;G=a+352|0;E=a+8|0;D=a+68|0;x=a+80|0;v=a+76|0;while(1){c=d+ -4|0;d=q[c>>2];q[g+68>>2]=c;q[g>>2]=d;H:{I:{J:{K:{if(s[a+270>>1]<=513){if(!r[a+364|0]){break J}c=q[a+360>>2];d=q[G>>2]+(c>>>3)|0;if(d>>>0>=t[a+356>>2]){break I}d=r[d|0];q[a+360>>2]=c+1;c=d>>>(c&7)&1;break K}c=dh(y)}if(!c){break I}}k=q[E>>2];z=q[k>>2];if((h|0)>=((q[k+4>>2]-z>>2>>>0)/3|0)){break c}j=-1;l=-1;i=q[k+24>>2];f=i;A=q[g>>2];d=-1;L:{if((A|0)==-1){break L}c=A+1|0;c=(c>>>0)%3|0?c:A+ -2|0;d=-1;if((c|0)==-1){break L}d=q[z+(c<<2)>>2]}f=q[f+(d<<2)>>2];M:{if((f|0)==-1){break M}c=f+1|0;c=(c>>>0)%3|0?c:f+ -2|0;if((c|0)==-1){break M}j=c+1|0;j=(j>>>0)%3|0?j:c+ -2|0;if((j|0)!=-1){l=q[z+(j<<2)>>2]}j=c}p=-1;m=-1;i=q[i+(l<<2)>>2];f=-1;N:{if((i|0)==-1){break N}c=i+1|0;c=(c>>>0)%3|0?c:i+ -2|0;f=-1;if((c|0)==-1){break N}f=c+1|0;f=(f>>>0)%3|0?f:c+ -2|0;if((f|0)!=-1){m=q[z+(f<<2)>>2]}f=c}c=w(h,3);q[g+88>>2]=c;i=q[k+12>>2];q[i+(c<<2)>>2]=A;q[i+(A<<2)>>2]=c;c=q[g+88>>2]+1|0;q[i+(c<<2)>>2]=j;q[i+(j<<2)>>2]=c;c=q[g+88>>2]+2|0;q[i+(c<<2)>>2]=f;q[i+(f<<2)>>2]=c;c=q[g+88>>2];q[z+(c<<2)>>2]=l;u=c+1|0;k=z+(u<<2)|0;q[k>>2]=m;i=c+2|0;f=z+(i<<2)|0;q[f>>2]=d;A=q[a+120>>2];j=u>>>0<c>>>0?-1:l;c=A+(j>>>3&536870908)|0;d=q[c>>2];H=c,I=eo(j)&d,q[H>>2]=I;p=(u|0)!=-1?q[k>>2]:p;c=A+(p>>>3&536870908)|0;d=q[c>>2];H=c,I=eo(p)&d,q[H>>2]=I;d=-1;d=(i|0)!=-1?q[f>>2]:d;j=A+(d>>>3&536870908)|0;c=q[j>>2];H=j,I=eo(d)&c,q[H>>2]=I;d=q[a+64>>2];f=q[D>>2];if((d|0)==f<<5){if((d+1|0)<=-1){break a}c=b;if(d>>>0<=1073741822){j=d+32&-32;d=f<<6;d=d>>>0<j>>>0?j:d}else{d=2147483647}cb(c,d);d=q[a+64>>2]}h=h+1|0;q[a+64>>2]=d+1;c=q[a+60>>2]+(d>>>3&536870908)|0;q[c>>2]=q[c>>2]|1<<(d&31);d=q[v>>2];if((d|0)!=q[x>>2]){q[d>>2]=q[g+88>>2];q[v>>2]=d+4;break H}zi(C,g+88|0);break H}d=q[a+64>>2];f=q[D>>2];if((d|0)==f<<5){if((d+1|0)<=-1){break a}c=b;if(d>>>0<=1073741822){j=d+32&-32;d=f<<6;d=d>>>0<j>>>0?j:d}else{d=2147483647}cb(c,d);d=q[a+64>>2]}q[a+64>>2]=d+1;j=q[a+60>>2]+(d>>>3&536870908)|0;c=q[j>>2];H=j,I=eo(d)&c,q[H>>2]=I;d=q[v>>2];if((d|0)!=q[x>>2]){q[d>>2]=q[g>>2];q[v>>2]=d+4;break H}zi(C,g)}d=q[g+68>>2];if((d|0)!=q[g+64>>2]){continue}break}l=q[a+8>>2]}if(((q[l+4>>2]-q[l>>2]>>2>>>0)/3|0)!=(h|0)){break c}e=q[l+28>>2]-q[l+24>>2]>>2;b=q[g+24>>2];i=q[g+28>>2];if((b|0)==(i|0)){break b}f=a+8|0;while(1){k=q[b>>2];h=q[l+24>>2];d=e+ -1|0;O:{if(q[h+(d<<2)>>2]!=-1){j=e;break O}h=q[l+24>>2];while(1){d=e+ -2|0;j=e+ -1|0;e=j;if(q[(d<<2)+h>>2]==-1){continue}break}}if(d>>>0>=k>>>0){q[g>>2]=l;c=d<<2;e=q[c+h>>2];o[g+12|0]=1;q[g+8>>2]=e;q[g+4>>2]=e;if((e|0)!=-1){while(1){q[q[l>>2]+(e<<2)>>2]=k;lg(g);l=q[f>>2];e=q[g+8>>2];if((e|0)!=-1){continue}break}}e=c;c=q[l+24>>2];e=e+c|0;if((k|0)!=-1){q[c+(k<<2)>>2]=q[e>>2]}q[e>>2]=-1;E=1<<(k&31);e=q[a+120>>2];k=e+(k>>>3&536870908)|0;c=k;h=e+(d>>>3&536870908)|0;d=1<<(d&31);e=E|q[k>>2];P:{if(q[h>>2]&d){break P}e=q[k>>2]&(E^-1)}q[c>>2]=e;q[h>>2]=q[h>>2]&(d^-1);j=j+ -1|0}e=j;b=b+4|0;if((i|0)!=(b|0)){continue}break}}b=q[g+24>>2]}if(b){q[g+28>>2]=b;An(b)}d=q[g+48>>2];if(d){while(1){a=q[d>>2];An(d);d=a;if(d){continue}break}}a=q[g+40>>2];q[g+40>>2]=0;if(a){An(a)}a=q[g+64>>2];if(a){q[g+68>>2]=a;An(a)}T=g+96|0;return e}bn();F()}function Ni(a,b){var o=0,r=0,s=0,t=0,J=0,K=0,L=0,M=0,N=0;s=q[a+8>>2];t=a+4|0;o=q[t>>2];if((s-o|0)/12>>>0>=b>>>0){a=w(b,12);M=t,N=Dn(o,0,a)+a|0,q[M>>2]=N;return}a:{t=q[a>>2];r=(o-t|0)/12|0;J=r+b|0;if(J>>>0<357913942){L=w(r,12);s=(s-t|0)/12|0;r=s<<1;r=s>>>0<178956970?r>>>0<J>>>0?J:r:357913941;if(r){if(r>>>0>=357913942){break a}K=Mm(w(r,12))}s=K+L|0;Dn(s,0,w(b,12));b=w(J,12)+K|0;J=w(r,12)+K|0;if((o|0)!=(t|0)){while(1){s=s+ -12|0;q[s>>2]=0;q[s+4>>2]=0;r=s+8|0;q[r>>2]=0;o=o+ -12|0;q[s>>2]=q[o>>2];q[s+4>>2]=q[o+4>>2];K=r;r=o+8|0;q[K>>2]=q[r>>2];q[r>>2]=0;q[o>>2]=0;q[o+4>>2]=0;if((o|0)!=(t|0)){continue}break}t=q[a>>2];o=q[a+4>>2]}q[a>>2]=s;q[a+8>>2]=J;q[a+4>>2]=b;if((o|0)!=(t|0)){while(1){a=o+ -12|0;b=q[a>>2];if(b){q[o+ -8>>2]=b;An(b)}o=a;if((o|0)!=(t|0)){continue}break}}if(t){An(t)}return}bn();F()}ab(12024);F()}function Oi(a){var b=0,F=0,O=0,P=0,Q=0,R=0,S=0;b=q[a+172>>2];if((b|0)!=-1){F=q[a+196>>2]+(b<<2)|0;O=q[F>>2];b=O+ -1|0;q[F>>2]=b;if((O|0)<1){return 9}F=a;a=q[(q[q[q[a+184>>2]+w(q[a+172>>2],12)>>2]+(b<<2)>>2]<<2)+12096>>2];q[F+168>>2]=a;return a}b=7;F=q[a+144>>2];F=s[(n[q[q[F>>2]+32>>2]](F)|0)+36>>1];a:{if((F<<24|F<<8&16711680)>>>16>>>0>513){break a}if(!r[a+76|0]){q[a+168>>2]=1;return 1}b=0;Q=q[a- -64>>2];O=q[a+72>>2];F=Q+(O>>>3)|0;R=q[a+68>>2];if(F>>>0>=R>>>0){break a}P=r[F|0];F=O+1|0;q[a+72>>2]=F;if(!(P>>>(O&7)&1)){break a}P=F>>>3;b=Q+P|0;b:{if(b>>>0>=R>>>0){b=F;F=0;break b}S=r[b|0];b=O+2|0;q[a+72>>2]=b;P=b>>>3;F=S>>>(F&7)&1}O=P+Q|0;if(O>>>0<R>>>0){O=r[O|0];q[a+72>>2]=b+1;b=O>>>(b&7)<<1&2}else{b=0}b=(F|b)<<1|1}q[a+168>>2]=b;return b}function Pi(a,w){var T=0,U=0,V=0,W=0,X=0;W=-1;U=-1;a:{if((w|0)==-1){break a}U=w+1|0;W=(U>>>0)%3|0?U:w+ -2|0;U=w+ -1|0;if((w>>>0)%3){break a}U=w+2|0}T=q[a+168>>2];b:{if(T>>>0>7){break b}c:{d:{switch(T-2|0){default:T=q[a+148>>2];V=1;w=q[a+156>>2];X=w+(((W|0)!=-1?q[q[T>>2]+(W<<2)>>2]:-1)<<2)|0;q[X>>2]=q[X>>2]+1;w=(((U|0)!=-1?q[q[T>>2]+(U<<2)>>2]:-1)<<2)+w|0;break c;case 3:V=q[a+148>>2];T=-1;T=((w|0)!=-1?q[q[V>>2]+(w<<2)>>2]:T)<<2;w=q[a+156>>2];T=T+w|0;q[T>>2]=q[T>>2]+1;T=(((W|0)!=-1?q[q[V>>2]+(W<<2)>>2]:-1)<<2)+w|0;q[T>>2]=q[T>>2]+1;T=-1;T=(U|0)!=-1?q[q[V>>2]+(U<<2)>>2]:T;V=2;w=w+(T<<2)|0;break c;case 1:V=q[a+148>>2];T=-1;T=((w|0)!=-1?q[q[V>>2]+(w<<2)>>2]:T)<<2;w=q[a+156>>2];T=T+w|0;q[T>>2]=q[T>>2]+1;T=(((W|0)!=-1?q[q[V>>2]+(W<<2)>>2]:-1)<<2)+w|0;q[T>>2]=q[T>>2]+2;w=(((U|0)!=-1?q[q[V>>2]+(U<<2)>>2]:-1)<<2)+w|0;V=1;break c;case 0:case 2:case 4:break b;case 5:break d}}V=q[a+148>>2];T=-1;T=((w|0)!=-1?q[q[V>>2]+(w<<2)>>2]:T)<<2;w=q[a+156>>2];T=T+w|0;q[T>>2]=q[T>>2]+2;T=(((W|0)!=-1?q[q[V>>2]+(W<<2)>>2]:-1)<<2)+w|0;q[T>>2]=q[T>>2]+2;T=-1;T=(U|0)!=-1?q[q[V>>2]+(U<<2)>>2]:T;V=2;w=w+(T<<2)|0}q[w>>2]=q[w>>2]+V}T=-1;T=(W|0)!=-1?q[q[q[a+148>>2]>>2]+(W<<2)>>2]:T;W=q[a+176>>2];w=W;U=a;T=q[q[a+156>>2]+(T<<2)>>2];if((T|0)>=(w|0)){a=q[a+180>>2];w=(T|0)>(a|0)?a:T}q[U+172>>2]=w-W}function Qi(a){a=a|0;var w=0,Y=0,Z=0,_=0,$=0;q[a>>2]=11272;w=a+368|0;Z=q[w>>2];q[w>>2]=0;if(Z){Y=Z+ -4|0;w=q[Y>>2];if(w){w=Z+(w<<4)|0;while(1){w=w+ -16|0;if((Z|0)!=(w|0)){continue}break}}An(Y)}Z=q[a+216>>2];if(Z){$=a+220|0;w=q[$>>2];Y=Z;a:{if((Z|0)==(w|0)){break a}while(1){Y=q[w+ -12>>2];if(Y){q[w+ -8>>2]=Y;An(Y)}Y=q[w+ -28>>2];if(Y){q[w+ -24>>2]=Y;An(Y)}Y=w+ -144|0;_=q[w+ -40>>2];if(_){q[w+ -36>>2]=_;An(_)}pi(w+ -140|0);w=Y;if((Z|0)!=(w|0)){continue}break}Y=q[a+216>>2]}q[$>>2]=Z;An(Y)}w=q[a+196>>2];if(w){q[a+200>>2]=w;An(w)}w=q[a+184>>2];if(w){q[a+188>>2]=w;An(w)}w=q[a+172>>2];if(w){q[a+176>>2]=w;An(w)}w=q[a+160>>2];if(w){q[a+164>>2]=w;An(w)}w=q[a+144>>2];if(w){while(1){Z=q[w>>2];An(w);w=Z;if(w){continue}break}}Z=a+136|0;w=q[Z>>2];q[Z>>2]=0;if(w){An(w)}w=q[a+120>>2];if(w){An(w)}w=q[a+108>>2];if(w){An(w)}w=q[a+96>>2];if(w){An(w)}w=q[a+72>>2];if(w){q[a+76>>2]=w;An(w)}w=q[a+60>>2];if(w){An(w)}w=q[a+48>>2];if(w){q[a+52>>2]=w;An(w)}w=q[a+36>>2];if(w){q[a+40>>2]=w;An(w)}w=q[a+24>>2];if(w){q[a+28>>2]=w;An(w)}w=q[a+12>>2];if(w){q[a+16>>2]=w;An(w)}w=q[a+8>>2];q[a+8>>2]=0;if(w){wa(a+8|0,w)}return a|0}function Ri(a){a=a|0;An(Qi(a))}function Si(a){a=a|0;var aa=0,ba=0,ca=0,da=0,ea=0;q[a>>2]=11324;aa=q[a+388>>2];if(aa){q[a+392>>2]=aa;An(aa)}aa=a+368|0;ca=q[aa>>2];q[aa>>2]=0;if(ca){ba=ca+ -4|0;aa=q[ba>>2];if(aa){aa=ca+(aa<<4)|0;while(1){aa=aa+ -16|0;if((ca|0)!=(aa|0)){continue}break}}An(ba)}ca=q[a+216>>2];if(ca){ea=a+220|0;aa=q[ea>>2];ba=ca;a:{if((ca|0)==(aa|0)){break a}while(1){ba=q[aa+ -12>>2];if(ba){q[aa+ -8>>2]=ba;An(ba)}ba=q[aa+ -28>>2];if(ba){q[aa+ -24>>2]=ba;An(ba)}ba=aa+ -144|0;da=q[aa+ -40>>2];if(da){q[aa+ -36>>2]=da;An(da)}pi(aa+ -140|0);aa=ba;if((ca|0)!=(aa|0)){continue}break}ba=q[a+216>>2]}q[ea>>2]=ca;An(ba)}aa=q[a+196>>2];if(aa){q[a+200>>2]=aa;An(aa)}aa=q[a+184>>2];if(aa){q[a+188>>2]=aa;An(aa)}aa=q[a+172>>2];if(aa){q[a+176>>2]=aa;An(aa)}aa=q[a+160>>2];if(aa){q[a+164>>2]=aa;An(aa)}aa=q[a+144>>2];if(aa){while(1){ca=q[aa>>2];An(aa);aa=ca;if(aa){continue}break}}ca=a+136|0;aa=q[ca>>2];q[ca>>2]=0;if(aa){An(aa)}aa=q[a+120>>2];if(aa){An(aa)}aa=q[a+108>>2];if(aa){An(aa)}aa=q[a+96>>2];if(aa){An(aa)}aa=q[a+72>>2];if(aa){q[a+76>>2]=aa;An(aa)}aa=q[a+60>>2];if(aa){An(aa)}aa=q[a+48>>2];if(aa){q[a+52>>2]=aa;An(aa)}aa=q[a+36>>2];if(aa){q[a+40>>2]=aa;An(aa)}aa=q[a+24>>2];if(aa){q[a+28>>2]=aa;An(aa)}aa=q[a+12>>2];if(aa){q[a+16>>2]=aa;An(aa)}aa=q[a+8>>2];q[a+8>>2]=0;if(aa){wa(a+8|0,aa)}return a|0}function Ti(a){a=a|0;An(Si(a))}function Ui(a){a=a|0;var fa=0,ga=0,ha=0,ia=0,ja=0;q[a>>2]=11372;Vi(a+232|0);ia=q[a+216>>2];if(ia){ga=ia;ja=a+220|0;fa=q[ja>>2];ha=ga;a:{if((ga|0)==(fa|0)){break a}while(1){ga=q[fa+ -12>>2];if(ga){q[fa+ -8>>2]=ga;An(ga)}ga=q[fa+ -28>>2];if(ga){q[fa+ -24>>2]=ga;An(ga)}ga=fa+ -144|0;ha=q[fa+ -40>>2];if(ha){q[fa+ -36>>2]=ha;An(ha)}pi(fa+ -140|0);fa=ga;if((ia|0)!=(fa|0)){continue}break}ha=q[a+216>>2]}ga=ha;q[ja>>2]=ia;An(ga)}fa=q[a+196>>2];if(fa){q[a+200>>2]=fa;An(fa)}fa=q[a+184>>2];if(fa){q[a+188>>2]=fa;An(fa)}fa=q[a+172>>2];if(fa){q[a+176>>2]=fa;An(fa)}fa=q[a+160>>2];if(fa){q[a+164>>2]=fa;An(fa)}fa=q[a+144>>2];if(fa){while(1){ga=q[fa>>2];An(fa);fa=ga;if(fa){continue}break}}fa=a+136|0;ga=q[fa>>2];q[fa>>2]=0;if(ga){An(ga)}fa=q[a+120>>2];if(fa){An(fa)}fa=q[a+108>>2];if(fa){An(fa)}fa=q[a+96>>2];if(fa){An(fa)}fa=q[a+72>>2];if(fa){q[a+76>>2]=fa;An(fa)}fa=q[a+60>>2];if(fa){An(fa)}fa=q[a+48>>2];if(fa){q[a+52>>2]=fa;An(fa)}fa=q[a+36>>2];if(fa){q[a+40>>2]=fa;An(fa)}fa=q[a+24>>2];if(fa){q[a+28>>2]=fa;An(fa)}fa=q[a+12>>2];if(fa){q[a+16>>2]=fa;An(fa)}fa=q[a+8>>2];q[a+8>>2]=0;if(fa){wa(a+8|0,fa)}return a|0}function Vi(a){var ka=0,la=0,ma=0,na=0,oa=0;ka=q[a+196>>2];if(ka){q[a+200>>2]=ka;An(ka)}ka=q[a+184>>2];if(ka){oa=a+188|0;la=q[oa>>2];ma=ka;a:{if((ka|0)==(la|0)){break a}while(1){ma=la+ -12|0;na=q[ma>>2];if(na){q[la+ -8>>2]=na;An(na)}la=ma;if((la|0)!=(ka|0)){continue}break}ma=q[a+184>>2]}q[oa>>2]=ka;An(ma)}ka=q[a+156>>2];if(ka){q[a+160>>2]=ka;An(ka)}ka=a+136|0;a=q[ka>>2];q[ka>>2]=0;if(a){la=a+ -4|0;ka=q[la>>2];if(ka){ka=a+(ka<<4)|0;while(1){ka=ka+ -16|0;if((a|0)!=(ka|0)){continue}break}}An(la)}}function Wi(a){a=a|0;An(Ui(a))}function Xi(a){a=a|0;var pa=0;q[a>>2]=11760;pa=q[a+48>>2];if(pa){q[a+52>>2]=pa;An(pa)}q[a>>2]=12012;pa=q[a+36>>2];if(pa){An(pa)}pa=q[a+24>>2];if(pa){An(pa)}An(a)}function Yi(a){a=a|0;var qa=0;q[a>>2]=12012;qa=q[a+36>>2];if(qa){An(qa)}qa=q[a+24>>2];if(qa){An(qa)}return a|0}function Zi(a){a=a|0;var ra=0;q[a>>2]=12012;ra=q[a+36>>2];if(ra){An(ra)}ra=q[a+24>>2];if(ra){An(ra)}An(a)}function _i(a,sa,ta){a=a|0;sa=sa|0;ta=ta|0;var ua=0,va=0;ua=T-16|0;T=ua;q[a+4>>2]=sa;va=q[sa+4>>2];sa=q[sa>>2];o[ua+15|0]=0;bb(a+24|0,(va-sa>>2>>>0)/3|0,ua+15|0);sa=q[a+4>>2];va=q[sa+28>>2];sa=q[sa+24>>2];o[ua+14|0]=0;bb(a+36|0,va-sa>>2,ua+14|0);sa=q[ta+12>>2];q[a+16>>2]=q[ta+8>>2];q[a+20>>2]=sa;sa=q[ta+4>>2];q[a+8>>2]=q[ta>>2];q[a+12>>2]=sa;T=ua+16|0}function $i(a,sa){var ta=0,wa=0,xa=0;a:{if((a|0)!=(sa|0)){xa=a;ta=q[sa+4>>2];wa=0;b:{if(!ta){break b}c:{if(ta>>>0<=q[a+8>>2]<<5>>>0){wa=q[a>>2];break c}wa=q[a>>2];if(wa){An(wa);q[a+8>>2]=0;q[a>>2]=0;q[a+4>>2]=0;ta=q[sa+4>>2]}if((ta|0)<=-1){break a}ta=(ta+ -1>>>5)+1|0;wa=Mm(ta<<2);q[a+8>>2]=ta;q[a+4>>2]=0;q[a>>2]=wa;ta=q[sa+4>>2]}En(wa,q[sa>>2],(ta+ -1>>>3&536870908)+4|0);wa=q[sa+4>>2]}q[xa+4>>2]=wa}return}bn();F()}function aj(a){a=a|0;var sa=0;q[a>>2]=12336;sa=q[a+88>>2];if(sa){q[a+92>>2]=sa;An(sa)}sa=q[a+72>>2];if(sa){q[a+76>>2]=sa;An(sa)}sa=q[a+60>>2];if(sa){q[a- -64>>2]=sa;An(sa)}sa=q[a+48>>2];if(sa){q[a+52>>2]=sa;An(sa)}q[a>>2]=12572;sa=q[a+36>>2];if(sa){An(sa)}sa=q[a+24>>2];if(sa){An(sa)}return a|0}function bj(a){a=a|0;var ya=0;q[a>>2]=12124;q[a+8>>2]=12336;ya=q[a+96>>2];if(ya){q[a+100>>2]=ya;An(ya)}ya=q[a+80>>2];if(ya){q[a+84>>2]=ya;An(ya)}ya=q[a+68>>2];if(ya){q[a+72>>2]=ya;An(ya)}ya=q[a+56>>2];if(ya){q[a+60>>2]=ya;An(ya)}q[a+8>>2]=12572;ya=q[a+44>>2];if(ya){An(ya)}ya=q[a+32>>2];if(ya){An(ya)}return a|0}function cj(a){a=a|0;var za=0;q[a>>2]=12124;q[a+8>>2]=12336;za=q[a+96>>2];if(za){q[a+100>>2]=za;An(za)}za=q[a+80>>2];if(za){q[a+84>>2]=za;An(za)}za=q[a+68>>2];if(za){q[a+72>>2]=za;An(za)}za=q[a+56>>2];if(za){q[a+60>>2]=za;An(za)}q[a+8>>2]=12572;za=q[a+44>>2];if(za){An(za)}za=q[a+32>>2];if(za){An(za)}An(a)}function dj(a,Aa){a=a|0;Aa=Aa|0;var Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0;Ja=q[a+12>>2];Ba=q[a+108>>2];Ca=q[Ba+80>>2];o[Aa+84|0]=0;Fa=q[Aa+68>>2];Da=q[Aa+72>>2]-Fa>>2;a:{if(Ca>>>0>Da>>>0){md(Aa+68|0,Ca-Da|0,12324);Ba=q[a+108>>2];Ca=q[Ba+80>>2];break a}if(Ca>>>0>=Da>>>0){break a}q[Aa+72>>2]=Fa+(Ca<<2)}Ia=q[Ba+96>>2];Ba=q[Ba+100>>2]-Ia|0;Ka=(Ba|0)/12|0;if(!Ba){return 1}La=Aa+68|0;Aa=0;b:{while(1){c:{if((Aa|0)==1431655765){break c}Ba=q[Ja>>2]+(w(Aa,3)<<2)|0;Fa=q[Ba>>2];if((Fa|0)==-1){break c}Da=w(Aa,12)+Ia|0;Ga=q[Da>>2];if(Ga>>>0>=Ca>>>0){break c}Ea=Fa<<2;Fa=q[q[a+112>>2]+12>>2];Ea=q[Ea+Fa>>2];if(Ea>>>0>=Ca>>>0){break c}Ha=Ga<<2;Ga=q[La>>2];q[Ha+Ga>>2]=Ea;Ea=q[Ba+4>>2];if((Ea|0)==-1){break c}Ha=q[Da+4>>2];if(Ha>>>0>=Ca>>>0){break c}Ea=q[Fa+(Ea<<2)>>2];if(Ea>>>0>=Ca>>>0){break c}q[Ga+(Ha<<2)>>2]=Ea;Ba=q[Ba+8>>2];if((Ba|0)==-1){break c}Da=q[Da+8>>2];if(Da>>>0>=Ca>>>0){break c}Ba=q[Fa+(Ba<<2)>>2];if(Ba>>>0>=Ca>>>0){break c}q[Ga+(Da<<2)>>2]=Ba;Ba=1;Aa=Aa+1|0;if(Aa>>>0<Ka>>>0){continue}break b}break}Ba=0}return Ba|0}function ej(a){a=a|0;var Aa=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0;Pa=T-16|0;T=Pa;Ma=q[a+4>>2];Aa=q[Ma>>2];a:{Sa=a+12|0;Na=q[Sa>>2];Oa=q[Na+28>>2]-q[Na+24>>2]|0;Na=Oa>>2;b:{if(q[Ma+8>>2]-Aa>>2>>>0>=Na>>>0){break b}if(Na>>>0>=1073741824){break a}Ta=Ma+4|0;Qa=q[Ta>>2];Ra=Na<<2;Na=Mm(Oa);Ra=Ra+Na|0;Oa=Qa-Aa|0;Qa=Oa+Na|0;if((Oa|0)>=1){Cn(Na,Aa,Oa)}q[Ma>>2]=Na;q[Ma+8>>2]=Ra;q[Ta>>2]=Qa;if(!Aa){break b}An(Aa)}Aa=q[Sa>>2];Ma=q[Aa+24>>2];Aa=q[Aa+28>>2];q[Pa+12>>2]=0;Aa=Aa-Ma>>2;Na=a+96|0;Oa=q[Na>>2];Ma=q[a+100>>2]-Oa>>2;c:{if(Aa>>>0>Ma>>>0){Ad(Na,Aa-Ma|0,Pa+12|0);break c}if(Aa>>>0>=Ma>>>0){break c}q[a+100>>2]=Oa+(Aa<<2)}Oa=a+8|0;d:{e:{Aa=q[a+116>>2];if(Aa){Na=q[Aa>>2];Ma=1;if((Na|0)==q[Aa+4>>2]){break d}Aa=0;while(1){if(!fj(Oa,q[(Aa<<2)+Na>>2])){break e}Ma=q[a+116>>2];Na=q[Ma>>2];Aa=Aa+1|0;if(Aa>>>0<q[Ma+4>>2]-Na>>2>>>0){continue}break}Ma=1;break d}Aa=0;a=q[a+12>>2];a=(q[a+4>>2]-q[a>>2]>>2>>>0)/3|0;Ma=1;if((a|0)<=0){break d}while(1){if(!fj(Oa,w(Aa,3))){break e}Aa=Aa+1|0;if(Aa>>>0<a>>>0){continue}break}Ma=1;break d}Ma=0}T=Pa+16|0;return Ma|0}ab(12024);F()}function fj(a,Ua){var Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0;Ya=T-32|0;T=Ya;q[Ya+8>>2]=Ua;a:{if(q[a+92>>2]==q[a+88>>2]){break a}Xa=a+52|0;Va=q[Xa>>2];b:{if((Va|0)!=q[a+56>>2]){q[Va>>2]=Ua;q[Xa>>2]=Va+4;break b}zi(a+48|0,Ya+8|0)}q[a+84>>2]=0;Ua=-1;Xa=-1;Va=q[Ya+8>>2];c:{if((Va|0)==-1){break c}Wa=q[a+4>>2];Za=Va+1|0;Za=(Za>>>0)%3|0?Za:Va+ -2|0;if((Za|0)!=-1){Ua=q[q[Wa>>2]+(Za<<2)>>2]}Va=Va+((Va>>>0)%3|0?-1:2)|0;if((Va|0)==-1){break c}Xa=q[q[Wa>>2]+(Va<<2)>>2]}Va=q[a+36>>2];Wa=Va+(Ua>>>3&536870908)|0;Za=q[Wa>>2];$a=1<<(Ua&31);if(!(Za&$a)){q[Wa>>2]=Za|$a;Va=-1;Wa=q[Ya+8>>2];if((Wa|0)!=-1){Va=Wa+1|0;Va=(Va>>>0)%3|0?Va:Wa+ -2|0}q[Ya+16>>2]=Va;Wa=q[a+20>>2];Za=(Va>>>0)/3|0;Za=q[(q[q[a+16>>2]+96>>2]+w(Za,12)|0)+(Va-w(Za,3)<<2)>>2];q[Ya+24>>2]=Za;Wa=q[Wa+4>>2];$a=Wa+4|0;Va=q[$a>>2];d:{if((Va|0)!=q[Wa+8>>2]){q[Va>>2]=Za;q[$a>>2]=Va+4;break d}zi(Wa,Ya+24|0)}Za=a+12|0;Va=q[Za>>2];$a=Va+4|0;Wa=q[$a>>2];e:{if((Wa|0)!=q[Va+8>>2]){q[Wa>>2]=q[Ya+16>>2];q[$a>>2]=Wa+4;break e}zi(Va,Ya+16|0);Va=q[Za>>2]}q[q[Va+12>>2]+(Ua<<2)>>2]=q[Va+24>>2];q[Va+24>>2]=q[Va+24>>2]+1;Va=q[a+36>>2]}Ua=Va+(Xa>>>3&536870908)|0;Va=q[Ua>>2];Wa=1<<(Xa&31);if(!(Va&Wa)){q[Ua>>2]=Va|Wa;Ua=Ya;ab=Ua;Wa=q[Ua+8>>2];Va=-1;f:{if((Wa|0)==-1){break f}Va=Wa+ -1|0;if((Wa>>>0)%3){break f}Va=Wa+2|0}q[ab+16>>2]=Va;Ua=q[a+20>>2];Wa=(Va>>>0)/3|0;Wa=q[(q[q[a+16>>2]+96>>2]+w(Wa,12)|0)+(Va-w(Wa,3)<<2)>>2];q[Ya+24>>2]=Wa;Va=q[Ua+4>>2];Za=Va+4|0;Ua=q[Za>>2];g:{if((Ua|0)!=q[Va+8>>2]){q[Ua>>2]=Wa;q[Za>>2]=Ua+4;break g}zi(Va,Ya+24|0)}Wa=a+12|0;Ua=q[Wa>>2];Za=Ua+4|0;Va=q[Za>>2];h:{if((Va|0)!=q[Ua+8>>2]){q[Va>>2]=q[Ya+16>>2];q[Za>>2]=Va+4;break h}zi(Ua,Ya+16|0);Ua=q[Wa>>2]}q[q[Ua+12>>2]+(Xa<<2)>>2]=q[Ua+24>>2];q[Ua+24>>2]=q[Ua+24>>2]+1}Ua=-1;Va=q[Ya+8>>2];if((Va|0)!=-1){Ua=q[q[q[a+4>>2]>>2]+(Va<<2)>>2]}Va=q[a+36>>2]+(Ua>>>3&536870908)|0;Xa=q[Va>>2];Wa=1<<(Ua&31);if(!(Xa&Wa)){q[Va>>2]=Wa|Xa;Va=q[Ya+8>>2];q[Ya+16>>2]=Va;Xa=q[a+20>>2];Wa=(Va>>>0)/3|0;Wa=q[(q[q[a+16>>2]+96>>2]+w(Wa,12)|0)+(Va-w(Wa,3)<<2)>>2];q[Ya+24>>2]=Wa;Xa=q[Xa+4>>2];Za=Xa+4|0;Va=q[Za>>2];i:{if((Va|0)!=q[Xa+8>>2]){q[Va>>2]=Wa;q[Za>>2]=Va+4;break i}zi(Xa,Ya+24|0)}Wa=a+12|0;Xa=q[Wa>>2];Za=Xa+4|0;Va=q[Za>>2];j:{if((Va|0)!=q[Xa+8>>2]){q[Va>>2]=q[Ya+16>>2];q[Za>>2]=Va+4;break j}zi(Xa,Ya+16|0);Xa=q[Wa>>2]}q[q[Xa+12>>2]+(Ua<<2)>>2]=q[Xa+24>>2];q[Xa+24>>2]=q[Xa+24>>2]+1}Va=q[a+84>>2];k:{if((Va|0)>2){break k}Za=a+24|0;$a=a+36|0;eb=a+16|0;fb=a+20|0;cb=a+88|0;while(1){Xa=w(Va,12)+a|0;Wa=Xa+52|0;Ua=q[Wa>>2];if((Ua|0)==q[Xa+48>>2]){Ua=(Va|0)<2;Va=Va+1|0;if(Ua){continue}break k}Xa=Ua+ -4|0;Ua=q[Xa>>2];q[Wa>>2]=Xa;q[a+84>>2]=Va;q[Ya+8>>2]=Ua;if((Ua|0)==-1){break a}Xa=q[Za>>2];Wa=(Ua>>>0)/3|0;l:{if(q[Xa+(Wa>>>3&268435452)>>2]>>>(Wa&31)&1){break l}m:{while(1){Ua=(Ua>>>0)/3|0;Va=(Ua>>>3&268435452)+Xa|0;q[Va>>2]=q[Va>>2]|1<<(Ua&31);Ua=-1;Xa=q[Ya+8>>2];if((Xa|0)!=-1){Ua=q[q[q[a+4>>2]>>2]+(Xa<<2)>>2]}Va=q[$a>>2]+(Ua>>>3&536870908)|0;Wa=q[Va>>2];_a=1<<(Ua&31);if(!(Wa&_a)){q[Va>>2]=Wa|_a;Va=q[Ya+8>>2];q[Ya+16>>2]=Va;Xa=q[fb>>2];Wa=(Va>>>0)/3|0;Wa=q[(q[q[eb>>2]+96>>2]+w(Wa,12)|0)+(Va-w(Wa,3)<<2)>>2];q[Ya+24>>2]=Wa;Xa=q[Xa+4>>2];_a=Xa+4|0;Va=q[_a>>2];n:{if((Va|0)!=q[Xa+8>>2]){q[Va>>2]=Wa;q[_a>>2]=Va+4;break n}zi(Xa,Ya+24|0)}Wa=a+12|0;Xa=q[Wa>>2];_a=Xa+4|0;Va=q[_a>>2];o:{if((Va|0)!=q[Xa+8>>2]){q[Va>>2]=q[Ya+16>>2];q[_a>>2]=Va+4;break o}zi(Xa,Ya+16|0);Xa=q[Wa>>2]}q[q[Xa+12>>2]+(Ua<<2)>>2]=q[Xa+24>>2];q[Xa+24>>2]=q[Xa+24>>2]+1;Xa=q[Ya+8>>2]}if((Xa|0)==-1){break m}db=a+4|0;_a=q[db>>2];Ua=-1;Va=-1;Wa=Xa+1|0;Wa=(Wa>>>0)%3|0?Wa:Xa+ -2|0;if((Wa|0)!=-1){Va=q[q[_a+12>>2]+(Wa<<2)>>2]}Xa=((Xa>>>0)%3|0?-1:2)+Xa|0;if((Xa|0)!=-1){Ua=q[q[_a+12>>2]+(Xa<<2)>>2]}Wa=(Ua>>>0)/3|0;bb=(Va>>>0)/3|0;ab=(Va|0)==-1;Xa=1;p:{if(ab){break p}Xa=ab?-1:bb;Xa=q[q[Za>>2]+(Xa>>>3&536870908)>>2]>>>(Xa&31)&1}q:{r:{s:{if((Ua|0)==-1){if(!Xa){break s}break m}Wa=(Ua|0)==-1?-1:Wa;t:{if(q[q[Za>>2]+(Wa>>>3&536870908)>>2]>>>(Wa&31)&1){break t}Wa=0;ab=Xa;_a=q[q[_a>>2]+(Ua<<2)>>2];if(!(q[q[$a>>2]+(_a>>>3&536870908)>>2]>>>(_a&31)&1)){_a=q[cb>>2]+(_a<<2)|0;Wa=q[_a>>2];q[_a>>2]=Wa+1;Wa=(Wa|0)<1?2:1}if((Wa|0)<=q[a+84>>2]?ab:0){break r}q[Ya+24>>2]=Ua;bb=w(Wa,12)+a|0;ab=bb+52|0;_a=q[ab>>2];u:{if((_a|0)!=q[bb+56>>2]){q[_a>>2]=Ua;q[ab>>2]=_a+4;break u}zi(bb+48|0,Ya+24|0)}if(q[a+84>>2]<=(Wa|0)){break t}q[a+84>>2]=Wa}if(Xa){break m}}Ua=-1;Xa=0;Ua=(Va|0)!=-1?q[q[q[db>>2]>>2]+(Va<<2)>>2]:Ua;if(!(q[q[$a>>2]+(Ua>>>3&536870908)>>2]>>>(Ua&31)&1)){Xa=q[cb>>2]+(Ua<<2)|0;Ua=q[Xa>>2];q[Xa>>2]=Ua+1;Xa=(Ua|0)<1?2:1}if((Xa|0)>q[a+84>>2]){break q}Ua=Va}q[Ya+8>>2]=Ua;Xa=q[Za>>2];continue}break}q[Ya+24>>2]=Va;Wa=w(Xa,12)+a|0;_a=Wa+52|0;Ua=q[_a>>2];v:{if((Ua|0)!=q[Wa+56>>2]){q[Ua>>2]=Va;q[_a>>2]=Ua+4;break v}zi(Wa+48|0,Ya+24|0)}Va=q[a+84>>2];if((Va|0)<=(Xa|0)){break l}q[a+84>>2]=Xa;Va=Xa;break l}Va=q[a+84>>2]}if((Va|0)<3){continue}break}}q[Ya+8>>2]=-1}T=Ya+32|0;return 1}function gj(a){a=a|0;var Ua=0;q[a>>2]=12336;Ua=q[a+88>>2];if(Ua){q[a+92>>2]=Ua;An(Ua)}Ua=q[a+72>>2];if(Ua){q[a+76>>2]=Ua;An(Ua)}Ua=q[a+60>>2];if(Ua){q[a- -64>>2]=Ua;An(Ua)}Ua=q[a+48>>2];if(Ua){q[a+52>>2]=Ua;An(Ua)}q[a>>2]=12572;Ua=q[a+36>>2];if(Ua){An(Ua)}Ua=q[a+24>>2];if(Ua){An(Ua)}An(a)}function hj(a){a=a|0;var gb=0;q[a>>2]=12572;gb=q[a+36>>2];if(gb){An(gb)}gb=q[a+24>>2];if(gb){An(gb)}return a|0}function ij(a){a=a|0;var hb=0;q[a>>2]=12572;hb=q[a+36>>2];if(hb){An(hb)}hb=q[a+24>>2];if(hb){An(hb)}An(a)}function jj(a){a=a|0;var ib=0;q[a>>2]=12756;ib=q[a+48>>2];if(ib){q[a+52>>2]=ib;An(ib)}q[a>>2]=12572;ib=q[a+36>>2];if(ib){An(ib)}ib=q[a+24>>2];if(ib){An(ib)}return a|0}function kj(a){a=a|0;var jb=0,kb=0;q[a>>2]=12592;kb=a+8|0;q[kb>>2]=12756;jb=q[a+56>>2];if(jb){q[a+60>>2]=jb;An(jb)}q[kb>>2]=12572;jb=q[a+44>>2];if(jb){An(jb)}jb=q[a+32>>2];if(jb){An(jb)}return a|0}function lj(a){a=a|0;var lb=0,mb=0;q[a>>2]=12592;mb=a+8|0;q[mb>>2]=12756;lb=q[a+56>>2];if(lb){q[a+60>>2]=lb;An(lb)}q[mb>>2]=12572;lb=q[a+44>>2];if(lb){An(lb)}lb=q[a+32>>2];if(lb){An(lb)}An(a)}function mj(a,nb){a=a|0;nb=nb|0;var ob=0,pb=0,qb=0,rb=0,sb=0,tb=0,ub=0,vb=0,wb=0,xb=0,yb=0;wb=q[a+12>>2];ob=q[a+68>>2];pb=q[ob+80>>2];o[nb+84|0]=0;sb=q[nb+68>>2];qb=q[nb+72>>2]-sb>>2;a:{if(pb>>>0>qb>>>0){md(nb+68|0,pb-qb|0,12324);ob=q[a+68>>2];pb=q[ob+80>>2];break a}if(pb>>>0>=qb>>>0){break a}q[nb+72>>2]=sb+(pb<<2)}vb=q[ob+96>>2];ob=q[ob+100>>2]-vb|0;xb=(ob|0)/12|0;if(!ob){return 1}yb=nb+68|0;nb=0;b:{while(1){c:{if((nb|0)==1431655765){break c}ob=q[wb>>2]+(w(nb,3)<<2)|0;sb=q[ob>>2];if((sb|0)==-1){break c}qb=w(nb,12)+vb|0;tb=q[qb>>2];if(tb>>>0>=pb>>>0){break c}rb=sb<<2;sb=q[q[a+72>>2]+12>>2];rb=q[rb+sb>>2];if(rb>>>0>=pb>>>0){break c}ub=tb<<2;tb=q[yb>>2];q[ub+tb>>2]=rb;rb=q[ob+4>>2];if((rb|0)==-1){break c}ub=q[qb+4>>2];if(ub>>>0>=pb>>>0){break c}rb=q[sb+(rb<<2)>>2];if(rb>>>0>=pb>>>0){break c}q[tb+(ub<<2)>>2]=rb;ob=q[ob+8>>2];if((ob|0)==-1){break c}qb=q[qb+8>>2];if(qb>>>0>=pb>>>0){break c}ob=q[sb+(ob<<2)>>2];if(ob>>>0>=pb>>>0){break c}q[tb+(qb<<2)>>2]=ob;ob=1;nb=nb+1|0;if(nb>>>0<xb>>>0){continue}break b}break}ob=0}return ob|0}function nj(a){a=a|0;var nb=0,zb=0,Ab=0,Bb=0,Cb=0,Db=0,Eb=0;Bb=q[a+4>>2];nb=q[Bb>>2];a:{zb=q[a+12>>2];Ab=q[zb+28>>2]-q[zb+24>>2]|0;zb=Ab>>2;b:{if(q[Bb+8>>2]-nb>>2>>>0>=zb>>>0){break b}if(zb>>>0>=1073741824){break a}Eb=Bb+4|0;Cb=q[Eb>>2];Db=zb<<2;zb=Mm(Ab);Db=Db+zb|0;Ab=Cb-nb|0;Cb=Ab+zb|0;if((Ab|0)>=1){Cn(zb,nb,Ab)}q[Bb>>2]=zb;q[Bb+8>>2]=Db;q[Eb>>2]=Cb;if(!nb){break b}An(nb)}zb=a+8|0;c:{d:{nb=q[a+76>>2];if(nb){Bb=q[nb>>2];Ab=1;if((Bb|0)==q[nb+4>>2]){break c}nb=0;while(1){if(!oj(zb,q[(nb<<2)+Bb>>2])){break d}Ab=q[a+76>>2];Bb=q[Ab>>2];nb=nb+1|0;if(nb>>>0<q[Ab+4>>2]-Bb>>2>>>0){continue}break}return 1}nb=0;a=q[a+12>>2];a=(q[a+4>>2]-q[a>>2]>>2>>>0)/3|0;if((a|0)<=0){return 1}while(1){if(!oj(zb,w(nb,3))){break d}nb=nb+1|0;if(nb>>>0<a>>>0){continue}break}return 1}Ab=0}return Ab|0}ab(12024);F()}function oj(a,Fb){var Gb=0,Hb=0,Ib=0,Jb=0,Kb=0,Lb=0,Mb=0,Nb=0,Ob=0,Pb=0,Qb=0,Rb=0,Sb=0,Tb=0,Ub=0;Kb=T-32|0;T=Kb;q[Kb+8>>2]=Fb;a:{if((Fb|0)==-1){Jb=1;break a}Jb=1;Gb=(Fb>>>0)/3|0;if(q[q[a+24>>2]+(Gb>>>3&268435452)>>2]>>>(Gb&31)&1){break a}Gb=a+52|0;Ib=q[a+48>>2];q[Gb>>2]=Ib;Pb=a+48|0;b:{if((Ib|0)!=q[a+56>>2]){q[Ib>>2]=Fb;q[Gb>>2]=Ib+4;break b}zi(Pb,Kb+8|0)}Jb=-1;Ib=q[Kb+8>>2];if((Ib|0)==-1){Jb=0;break a}Gb=q[a+4>>2];Fb=Ib+1|0;Fb=(Fb>>>0)%3|0?Fb:Ib+ -2|0;if((Fb|0)!=-1){Jb=q[q[Gb>>2]+(Fb<<2)>>2]}Fb=Ib+((Ib>>>0)%3|0?-1:2)|0;if((Fb|0)==-1){Jb=0;break a}if((Jb|0)==-1){Jb=0;break a}Lb=q[q[Gb>>2]+(Fb<<2)>>2];if((Lb|0)==-1){Jb=0;break a}Fb=q[a+36>>2];Hb=Fb+(Jb>>>3&536870908)|0;Ib=q[Hb>>2];Gb=1<<(Jb&31);if(!(Ib&Gb)){q[Hb>>2]=Gb|Ib;Hb=-1;Gb=q[Kb+8>>2];if((Gb|0)!=-1){Fb=Gb+1|0;Hb=(Fb>>>0)%3|0?Fb:Gb+ -2|0}q[Kb+16>>2]=Hb;Ib=q[a+20>>2];Fb=(Hb>>>0)/3|0;Gb=q[(q[q[a+16>>2]+96>>2]+w(Fb,12)|0)+(Hb-w(Fb,3)<<2)>>2];q[Kb+24>>2]=Gb;Ib=q[Ib+4>>2];Fb=Ib+4|0;Hb=q[Fb>>2];c:{if((Hb|0)!=q[Ib+8>>2]){q[Hb>>2]=Gb;q[Fb>>2]=Hb+4;break c}zi(Ib,Kb+24|0)}Gb=a+12|0;Hb=q[Gb>>2];Fb=Hb+4|0;Ib=q[Fb>>2];d:{if((Ib|0)!=q[Hb+8>>2]){q[Ib>>2]=q[Kb+16>>2];q[Fb>>2]=Ib+4;break d}zi(Hb,Kb+16|0);Hb=q[Gb>>2]}q[q[Hb+12>>2]+(Jb<<2)>>2]=q[Hb+24>>2];q[Hb+24>>2]=q[Hb+24>>2]+1;Fb=q[a+36>>2]}Ib=(Lb>>>3&536870908)+Fb|0;Gb=q[Ib>>2];Fb=1<<(Lb&31);if(!(Gb&Fb)){q[Ib>>2]=Fb|Gb;Fb=Kb;Ib=Fb;Gb=q[Fb+8>>2];Hb=-1;e:{if((Gb|0)==-1){break e}Hb=Gb+ -1|0;if((Gb>>>0)%3){break e}Hb=Gb+2|0}q[Ib+16>>2]=Hb;Ib=q[a+20>>2];Fb=(Hb>>>0)/3|0;Gb=q[(q[q[a+16>>2]+96>>2]+w(Fb,12)|0)+(Hb-w(Fb,3)<<2)>>2];q[Kb+24>>2]=Gb;Ib=q[Ib+4>>2];Fb=Ib+4|0;Hb=q[Fb>>2];f:{if((Hb|0)!=q[Ib+8>>2]){q[Hb>>2]=Gb;q[Fb>>2]=Hb+4;break f}zi(Ib,Kb+24|0)}Gb=a+12|0;Jb=q[Gb>>2];Fb=Jb+4|0;Ib=q[Fb>>2];g:{if((Ib|0)!=q[Jb+8>>2]){q[Ib>>2]=q[Kb+16>>2];q[Fb>>2]=Ib+4;break g}zi(Jb,Kb+16|0);Jb=q[Gb>>2]}q[q[Jb+12>>2]+(Lb<<2)>>2]=q[Jb+24>>2];q[Jb+24>>2]=q[Jb+24>>2]+1}Nb=a+52|0;Fb=q[Nb>>2];if((Fb|0)==q[a+48>>2]){Jb=1;break a}Ob=a+24|0;Qb=a+4|0;Rb=a+36|0;Sb=a+16|0;Tb=a+20|0;Ub=a+56|0;while(1){Hb=Fb+ -4|0;Gb=q[Hb>>2];q[Kb+8>>2]=Gb;Fb=(Gb>>>0)/3|0;h:{i:{j:{if((Gb|0)==-1){break j}Ib=q[Ob>>2]+(Fb>>>3&268435452)|0;Gb=q[Ib>>2];Fb=1<<(Fb&31);if(Gb&Fb){break j}q[Ib>>2]=Fb|Gb;Fb=q[Kb+8>>2];if((Fb|0)!=-1){break i}Jb=0;break a}q[Nb>>2]=Hb;break h}k:{l:{m:{while(1){Mb=q[Qb>>2];Gb=q[q[Mb>>2]+(Fb<<2)>>2];if((Gb|0)==-1){Jb=0;break a}Lb=q[Rb>>2]+(Gb>>>3&536870908)|0;Hb=q[Lb>>2];Ib=1<<(Gb&31);n:{if(!(Hb&Ib)){Jb=Gb<<2;Gb=q[Jb+q[Mb+24>>2]>>2];o:{p:{if((Gb|0)==-1){break p}Fb=Gb+1|0;Fb=(Fb>>>0)%3|0?Fb:Gb+ -2|0;if((Fb|0)==-1){break p}Mb=q[q[Mb+12>>2]+(Fb<<2)>>2];if((Mb|0)==-1){break p}Fb=Mb+1|0;Gb=0;if((((Fb>>>0)%3|0?Fb:Mb+ -2|0)|0)!=-1){break o}}Gb=1}q[Lb>>2]=Ib|Hb;Ib=q[Kb+8>>2];q[Kb+16>>2]=Ib;Hb=q[Tb>>2];Fb=(Ib>>>0)/3|0;Ib=q[(q[q[Sb>>2]+96>>2]+w(Fb,12)|0)+(Ib-w(Fb,3)<<2)>>2];q[Kb+24>>2]=Ib;Hb=q[Hb+4>>2];Fb=Hb+4|0;Lb=q[Fb>>2];q:{if((Lb|0)!=q[Hb+8>>2]){q[Lb>>2]=Ib;q[Fb>>2]=Lb+4;break q}zi(Hb,Kb+24|0)}Hb=a+12|0;Fb=q[Hb>>2];Ib=Fb+4|0;Lb=q[Ib>>2];r:{if((Lb|0)!=q[Fb+8>>2]){q[Lb>>2]=q[Kb+16>>2];q[Ib>>2]=Lb+4;break r}zi(Fb,Kb+16|0);Fb=q[Hb>>2]}q[q[Fb+12>>2]+Jb>>2]=q[Fb+24>>2];q[Fb+24>>2]=q[Fb+24>>2]+1;Mb=q[Qb>>2];Fb=q[Kb+8>>2];if(!Gb){Gb=Kb;Hb=-1;s:{if((Fb|0)==-1){break s}Ib=Fb+1|0;Fb=(Ib>>>0)%3|0?Ib:Fb+ -2|0;Hb=-1;if((Fb|0)==-1){break s}Hb=q[q[Mb+12>>2]+(Fb<<2)>>2]}q[Gb+8>>2]=Hb;Fb=(Hb>>>0)/3|0;break n}if((Fb|0)==-1){break l}}Hb=-1;Jb=-1;Gb=Fb+1|0;Gb=(Gb>>>0)%3|0?Gb:Fb+ -2|0;if((Gb|0)!=-1){Jb=q[q[Mb+12>>2]+(Gb<<2)>>2]}q[Kb+24>>2]=Jb;Fb=((Fb>>>0)%3|0?-1:2)+Fb|0;if((Fb|0)!=-1){Hb=q[q[Mb+12>>2]+(Fb<<2)>>2]}Ib=(Hb>>>0)/3|0;Fb=(Jb>>>0)/3|0;Gb=(Jb|0)==-1;t:{if(Gb){Fb=-1;Gb=1;break t}Gb=Gb?-1:Fb;Gb=q[q[Ob>>2]+(Gb>>>3&536870908)>>2]>>>(Gb&31)&1}u:{if((Hb|0)!=-1){Lb=(Hb|0)==-1?-1:Ib;Lb=q[q[Ob>>2]+(Lb>>>3&536870908)>>2]&1<<(Lb&31);if(Gb){Jb=Hb;Fb=Ib;if(!Lb){break u}break k}if(Lb){break u}Fb=q[Nb>>2];q[Fb+ -4>>2]=Hb;if((Fb|0)==q[Ub>>2]){break m}q[Fb>>2]=q[Kb+24>>2];q[Nb>>2]=Fb+4;break h}if(Gb){break k}}q[Kb+8>>2]=Jb}Gb=q[Ob>>2]+(Fb>>>3&536870908)|0;q[Gb>>2]=q[Gb>>2]|1<<(Fb&31);Fb=q[Kb+8>>2];if((Fb|0)!=-1){continue}break}Jb=0;break a}zi(Pb,Kb+24|0);break h}q[Kb+24>>2]=-1}q[Nb>>2]=q[Nb>>2]+ -4}Jb=1;Fb=q[Nb>>2];if((Fb|0)!=q[a+48>>2]){continue}break}}T=Kb+32|0;return Jb}function pj(a){a=a|0;var Fb=0;q[a>>2]=12756;Fb=q[a+48>>2];if(Fb){q[a+52>>2]=Fb;An(Fb)}q[a>>2]=12572;Fb=q[a+36>>2];if(Fb){An(Fb)}Fb=q[a+24>>2];if(Fb){An(Fb)}An(a)}function qj(a){a=a|0;var Vb=0,Wb=0;q[a>>2]=12884;Wb=a+8|0;q[Wb>>2]=11760;Vb=q[a+56>>2];if(Vb){q[a+60>>2]=Vb;An(Vb)}q[Wb>>2]=12012;Vb=q[a+44>>2];if(Vb){An(Vb)}Vb=q[a+32>>2];if(Vb){An(Vb)}return a|0}function rj(a){a=a|0;var Xb=0,Yb=0;q[a>>2]=12884;Yb=a+8|0;q[Yb>>2]=11760;Xb=q[a+56>>2];if(Xb){q[a+60>>2]=Xb;An(Xb)}q[Yb>>2]=12012;Xb=q[a+44>>2];if(Xb){An(Xb)}Xb=q[a+32>>2];if(Xb){An(Xb)}An(a)}function sj(a,Zb){a=a|0;Zb=Zb|0;var _b=0,$b=0,ac=0,bc=0,cc=0,dc=0,ec=0,fc=0,gc=0,hc=0,ic=0;dc=q[a+12>>2];_b=q[a+68>>2];$b=q[_b+80>>2];o[Zb+84|0]=0;cc=q[Zb+68>>2];ac=q[Zb+72>>2]-cc>>2;a:{if($b>>>0>ac>>>0){md(Zb+68|0,$b-ac|0,12324);_b=q[a+68>>2];$b=q[_b+80>>2];break a}if($b>>>0>=ac>>>0){break a}q[Zb+72>>2]=cc+($b<<2)}fc=q[_b+96>>2];_b=q[_b+100>>2]-fc|0;gc=(_b|0)/12|0;if(!_b){return 1}hc=q[dc+28>>2];ic=Zb+68|0;Zb=0;b:{while(1){c:{_b=(w(Zb,3)<<2)+hc|0;dc=q[_b>>2];if((dc|0)==-1){break c}ac=w(Zb,12)+fc|0;cc=q[ac>>2];if(cc>>>0>=$b>>>0){break c}bc=dc<<2;dc=q[q[a+72>>2]+12>>2];bc=q[bc+dc>>2];if(bc>>>0>=$b>>>0){break c}ec=cc<<2;cc=q[ic>>2];q[ec+cc>>2]=bc;bc=q[_b+4>>2];if((bc|0)==-1){break c}ec=q[ac+4>>2];if(ec>>>0>=$b>>>0){break c}bc=q[dc+(bc<<2)>>2];if(bc>>>0>=$b>>>0){break c}q[cc+(ec<<2)>>2]=bc;_b=q[_b+8>>2];if((_b|0)==-1){break c}ac=q[ac+8>>2];if(ac>>>0>=$b>>>0){break c}_b=q[dc+(_b<<2)>>2];if(_b>>>0>=$b>>>0){break c}q[cc+(ac<<2)>>2]=_b;_b=1;Zb=Zb+1|0;if(Zb>>>0<gc>>>0){continue}break b}break}_b=0}return _b|0}function tj(a){a=a|0;var Zb=0,jc=0,kc=0,lc=0,mc=0,nc=0,oc=0;lc=q[a+4>>2];Zb=q[lc>>2];a:{jc=q[a+12>>2];kc=q[jc+56>>2]-q[jc+52>>2]|0;jc=kc>>2;b:{if(q[lc+8>>2]-Zb>>2>>>0>=jc>>>0){break b}if(jc>>>0>=1073741824){break a}oc=lc+4|0;mc=q[oc>>2];nc=jc<<2;jc=Mm(kc);nc=nc+jc|0;kc=mc-Zb|0;mc=kc+jc|0;if((kc|0)>=1){Cn(jc,Zb,kc)}q[lc>>2]=jc;q[lc+8>>2]=nc;q[oc>>2]=mc;if(!Zb){break b}An(Zb)}jc=a+8|0;c:{d:{Zb=q[a+76>>2];if(Zb){lc=q[Zb>>2];kc=1;if((lc|0)==q[Zb+4>>2]){break c}Zb=0;while(1){if(!uj(jc,q[(Zb<<2)+lc>>2])){break d}kc=q[a+76>>2];lc=q[kc>>2];Zb=Zb+1|0;if(Zb>>>0<q[kc+4>>2]-lc>>2>>>0){continue}break}return 1}Zb=0;a=q[q[a+12>>2]+64>>2];a=(q[a+4>>2]-q[a>>2]>>2>>>0)/3|0;if((a|0)<=0){return 1}while(1){if(!uj(jc,w(Zb,3))){break d}Zb=Zb+1|0;if(Zb>>>0<a>>>0){continue}break}return 1}kc=0}return kc|0}ab(12024);F()}function uj(a,pc){var qc=0,rc=0,sc=0,tc=0,uc=0,vc=0,wc=0,xc=0,yc=0,zc=0,Ac=0,Bc=0,Cc=0,Dc=0,Ec=0;uc=T-32|0;T=uc;q[uc+8>>2]=pc;a:{if((pc|0)==-1){qc=1;break a}qc=1;tc=(pc>>>0)/3|0;if(q[q[a+24>>2]+(tc>>>3&268435452)>>2]>>>(tc&31)&1){break a}tc=a+52|0;qc=q[a+48>>2];q[tc>>2]=qc;zc=a+48|0;b:{if((qc|0)!=q[a+56>>2]){q[qc>>2]=pc;q[tc>>2]=qc+4;break b}zi(zc,uc+8|0)}rc=-1;qc=q[a+4>>2];pc=q[uc+8>>2];c:{if((pc|0)==-1){tc=q[qc+28>>2];qc=q[tc+ -4>>2];break c}tc=q[qc+28>>2];qc=pc+1|0;qc=q[tc+(((qc>>>0)%3|0?qc:pc+ -2|0)<<2)>>2];if((pc>>>0)%3){rc=pc+ -1|0;break c}rc=pc+2|0}if((qc|0)==-1){qc=0;break a}tc=q[(rc<<2)+tc>>2];if((tc|0)==-1){qc=0;break a}pc=q[a+36>>2];sc=pc+(qc>>>3&536870908)|0;rc=q[sc>>2];vc=1<<(qc&31);if(!(rc&vc)){q[sc>>2]=rc|vc;rc=-1;pc=q[uc+8>>2];if((pc|0)!=-1){sc=pc+1|0;rc=(sc>>>0)%3|0?sc:pc+ -2|0}q[uc+16>>2]=rc;pc=q[a+20>>2];sc=(rc>>>0)/3|0;rc=q[(q[q[a+16>>2]+96>>2]+w(sc,12)|0)+(rc-w(sc,3)<<2)>>2];q[uc+24>>2]=rc;sc=q[pc+4>>2];vc=sc+4|0;pc=q[vc>>2];d:{if((pc|0)!=q[sc+8>>2]){q[pc>>2]=rc;q[vc>>2]=pc+4;break d}zi(sc,uc+24|0)}sc=a+12|0;rc=q[sc>>2];vc=rc+4|0;pc=q[vc>>2];e:{if((pc|0)!=q[rc+8>>2]){q[pc>>2]=q[uc+16>>2];q[vc>>2]=pc+4;break e}zi(rc,uc+16|0);rc=q[sc>>2]}q[q[rc+12>>2]+(qc<<2)>>2]=q[rc+24>>2];q[rc+24>>2]=q[rc+24>>2]+1;pc=q[a+36>>2]}pc=(tc>>>3&536870908)+pc|0;qc=q[pc>>2];sc=1<<(tc&31);if(!(qc&sc)){q[pc>>2]=qc|sc;pc=uc;rc=pc;sc=q[pc+8>>2];qc=-1;f:{if((sc|0)==-1){break f}qc=sc+ -1|0;if((sc>>>0)%3){break f}qc=sc+2|0}q[rc+16>>2]=qc;pc=q[a+20>>2];sc=(qc>>>0)/3|0;sc=q[(q[q[a+16>>2]+96>>2]+w(sc,12)|0)+(qc-w(sc,3)<<2)>>2];q[uc+24>>2]=sc;qc=q[pc+4>>2];rc=qc+4|0;pc=q[rc>>2];g:{if((pc|0)!=q[qc+8>>2]){q[pc>>2]=sc;q[rc>>2]=pc+4;break g}zi(qc,uc+24|0)}sc=a+12|0;qc=q[sc>>2];rc=qc+4|0;pc=q[rc>>2];h:{if((pc|0)!=q[qc+8>>2]){q[pc>>2]=q[uc+16>>2];q[rc>>2]=pc+4;break h}zi(qc,uc+16|0);qc=q[sc>>2]}q[q[qc+12>>2]+(tc<<2)>>2]=q[qc+24>>2];q[qc+24>>2]=q[qc+24>>2]+1}vc=a+52|0;pc=q[vc>>2];if((pc|0)==q[a+48>>2]){qc=1;break a}xc=a+24|0;yc=a+4|0;Bc=a+36|0;Cc=a+16|0;Dc=a+20|0;Ec=a+56|0;while(1){tc=pc+ -4|0;pc=q[tc>>2];q[uc+8>>2]=pc;qc=(pc>>>0)/3|0;i:{j:{k:{if((pc|0)==-1){break k}pc=q[xc>>2]+(qc>>>3&268435452)|0;sc=q[pc>>2];qc=1<<(qc&31);if(sc&qc){break k}q[pc>>2]=qc|sc;rc=q[yc>>2];pc=q[uc+8>>2];qc=q[q[rc+28>>2]+(pc<<2)>>2];if((qc|0)!=-1){break j}qc=0;break a}q[vc>>2]=tc;break i}l:{m:{n:{while(1){o:{p:{tc=q[Bc>>2]+(qc>>>3&536870908)|0;sc=q[tc>>2];wc=1<<(qc&31);if(sc&wc){break p}Ac=qc<<2;qc=q[Ac+q[rc+40>>2]>>2];pc=1;q:{if((qc|0)==-1){break q}pc=qc+1|0;pc=(pc>>>0)%3|0?pc:qc+ -2|0;r:{if((pc|0)==-1|q[q[rc>>2]+(pc>>>3&536870908)>>2]>>>(pc&31)&1){break r}qc=q[q[q[rc+64>>2]+12>>2]+(pc<<2)>>2];if((qc|0)==-1){break r}rc=qc+1|0;pc=0;if((((rc>>>0)%3|0?rc:qc+ -2|0)|0)!=-1){break q}}pc=1}qc=pc;q[tc>>2]=sc|wc;pc=q[uc+8>>2];q[uc+16>>2]=pc;tc=q[Dc>>2];sc=(pc>>>0)/3|0;sc=q[(q[q[Cc>>2]+96>>2]+w(sc,12)|0)+(pc-w(sc,3)<<2)>>2];q[uc+24>>2]=sc;tc=q[tc+4>>2];rc=tc+4|0;pc=q[rc>>2];s:{if((pc|0)!=q[tc+8>>2]){q[pc>>2]=sc;q[rc>>2]=pc+4;break s}zi(tc,uc+24|0)}sc=a+12|0;pc=q[sc>>2];rc=pc+4|0;tc=q[rc>>2];t:{if((tc|0)!=q[pc+8>>2]){q[tc>>2]=q[uc+16>>2];q[rc>>2]=tc+4;break t}zi(pc,uc+16|0);pc=q[sc>>2]}q[q[pc+12>>2]+Ac>>2]=q[pc+24>>2];q[pc+24>>2]=q[pc+24>>2]+1;rc=q[yc>>2];pc=q[uc+8>>2];if(qc){break p}qc=-1;u:{if((pc|0)==-1){break u}tc=pc+1|0;pc=(tc>>>0)%3|0?tc:pc+ -2|0;if((pc|0)==-1|q[q[rc>>2]+(pc>>>3&536870908)>>2]>>>(pc&31)&1){break u}qc=q[q[q[rc+64>>2]+12>>2]+(pc<<2)>>2]}q[uc+8>>2]=qc;pc=(qc>>>0)/3|0;break o}if((pc|0)==-1){break m}tc=-1;sc=uc;wc=pc+1|0;wc=(wc>>>0)%3|0?wc:pc+ -2|0;qc=-1;v:{if((wc|0)==-1){break v}qc=-1;if(q[q[rc>>2]+(wc>>>3&536870908)>>2]>>>(wc&31)&1){break v}qc=q[q[q[rc+64>>2]+12>>2]+(wc<<2)>>2]}q[sc+24>>2]=qc;pc=((pc>>>0)%3|0?-1:2)+pc|0;if(!((pc|0)==-1|q[q[rc>>2]+(pc>>>3&536870908)>>2]>>>(pc&31)&1)){tc=q[q[q[rc+64>>2]+12>>2]+(pc<<2)>>2]}sc=(tc>>>0)/3|0;pc=(qc>>>0)/3|0;rc=(qc|0)==-1;w:{if(rc){pc=-1;rc=1;break w}rc=rc?-1:pc;rc=q[q[xc>>2]+(rc>>>3&536870908)>>2]>>>(rc&31)&1}x:{if((tc|0)!=-1){wc=(tc|0)==-1?-1:sc;wc=q[q[xc>>2]+(wc>>>3&536870908)>>2]&1<<(wc&31);if(rc){qc=tc;pc=sc;if(!wc){break x}break l}if(wc){break x}pc=q[vc>>2];q[pc+ -4>>2]=tc;if((pc|0)==q[Ec>>2]){break n}q[pc>>2]=q[uc+24>>2];q[vc>>2]=pc+4;break i}if(rc){break l}}q[uc+8>>2]=qc}qc=q[xc>>2]+(pc>>>3&536870908)|0;q[qc>>2]=q[qc>>2]|1<<(pc&31);rc=q[yc>>2];pc=q[uc+8>>2];qc=q[q[rc+28>>2]+(pc<<2)>>2];if((qc|0)!=-1){continue}break}qc=0;break a}zi(zc,uc+24|0);break i}q[uc+24>>2]=-1}q[vc>>2]=q[vc>>2]+ -4}qc=1;pc=q[vc>>2];if((pc|0)!=q[a+48>>2]){continue}break}}T=uc+32|0;return qc}function vj(a,pc){var Fc=0,Gc=0,Hc=0;q[a>>2]=q[pc>>2];q[a+4>>2]=q[pc+4>>2];q[a+8>>2]=q[pc+8>>2];Fc=pc+12|0;q[a+12>>2]=q[Fc>>2];q[Fc>>2]=0;q[pc+4>>2]=0;q[pc+8>>2]=0;Fc=pc+16|0;q[a+16>>2]=q[Fc>>2];q[a+20>>2]=q[pc+20>>2];Gc=pc+24|0;q[a+24>>2]=q[Gc>>2];q[Gc>>2]=0;q[Fc>>2]=0;q[Fc+4>>2]=0;Gc=r[pc+28|0];Hc=a+40|0;q[Hc>>2]=0;Fc=a+32|0;q[Fc>>2]=0;q[Fc+4>>2]=0;o[a+28|0]=Gc;Gc=Fc;Fc=pc+32|0;q[Gc>>2]=q[Fc>>2];q[a+36>>2]=q[pc+36>>2];Gc=pc+40|0;q[Hc>>2]=q[Gc>>2];q[Gc>>2]=0;q[Fc>>2]=0;q[Fc+4>>2]=0;Gc=a+52|0;q[Gc>>2]=0;Fc=a+44|0;q[Fc>>2]=0;q[Fc+4>>2]=0;Hc=Fc;Fc=pc+44|0;q[Hc>>2]=q[Fc>>2];q[a+48>>2]=q[pc+48>>2];Hc=Gc;Gc=pc+52|0;q[Hc>>2]=q[Gc>>2];q[Gc>>2]=0;q[Fc>>2]=0;q[Fc+4>>2]=0;Gc=a- -64|0;q[Gc>>2]=0;Fc=a+56|0;q[Fc>>2]=0;q[Fc+4>>2]=0;Hc=Fc;Fc=pc+56|0;q[Hc>>2]=q[Fc>>2];q[a+60>>2]=q[pc+60>>2];Hc=Gc;Gc=pc- -64|0;q[Hc>>2]=q[Gc>>2];q[Gc>>2]=0;q[Fc>>2]=0;q[Fc+4>>2]=0;q[a+68>>2]=q[pc+68>>2];Gc=q[pc+72>>2];Hc=a+84|0;q[Hc>>2]=0;Fc=a+76|0;q[Fc>>2]=0;q[Fc+4>>2]=0;q[a+72>>2]=Gc;Gc=Fc;Fc=pc+76|0;q[Gc>>2]=q[Fc>>2];q[a+80>>2]=q[pc+80>>2];Gc=pc+84|0;q[Hc>>2]=q[Gc>>2];q[Gc>>2]=0;q[Fc>>2]=0;q[Fc+4>>2]=0;Gc=a+96|0;q[Gc>>2]=0;Fc=a+88|0;q[Fc>>2]=0;q[Fc+4>>2]=0;Hc=Fc;Fc=pc+88|0;q[Hc>>2]=q[Fc>>2];q[a+92>>2]=q[pc+92>>2];Hc=Gc;Gc=pc+96|0;q[Hc>>2]=q[Gc>>2];q[Gc>>2]=0;q[Fc>>2]=0;q[Fc+4>>2]=0;Fc=r[pc+100|0];Gc=a+112|0;q[Gc>>2]=0;q[a+104>>2]=0;q[a+108>>2]=0;o[a+100|0]=Fc;q[a+104>>2]=q[pc+104>>2];q[a+108>>2]=q[pc+108>>2];Fc=pc+112|0;q[Gc>>2]=q[Fc>>2];q[Fc>>2]=0;q[pc+104>>2]=0;q[pc+108>>2]=0;Gc=a+124|0;q[Gc>>2]=0;Fc=a+116|0;q[Fc>>2]=0;q[Fc+4>>2]=0;Hc=Fc;Fc=pc+116|0;q[Hc>>2]=q[Fc>>2];q[a+120>>2]=q[pc+120>>2];Hc=Gc;Gc=pc+124|0;q[Hc>>2]=q[Gc>>2];q[Gc>>2]=0;q[Fc>>2]=0;q[Fc+4>>2]=0;Fc=q[pc+128>>2];Gc=a+140|0;q[Gc>>2]=0;q[a+132>>2]=0;q[a+136>>2]=0;q[a+128>>2]=Fc;q[a+132>>2]=q[pc+132>>2];q[a+136>>2]=q[pc+136>>2];Fc=pc+140|0;q[Gc>>2]=q[Fc>>2];q[Fc>>2]=0;q[pc+132>>2]=0;q[pc+136>>2]=0;return a}function wj(a){var pc=0,Ic=0,Jc=0;Ic=q[a+8>>2];Jc=q[a+4>>2];if((Ic|0)!=(Jc|0)){while(1){pc=Ic+ -144|0;q[a+8>>2]=pc;pc=q[pc+132>>2];if(pc){q[Ic+ -8>>2]=pc;An(pc)}pc=q[Ic+ -28>>2];if(pc){q[Ic+ -24>>2]=pc;An(pc)}pc=q[Ic+ -40>>2];if(pc){q[Ic+ -36>>2]=pc;An(pc)}pi(Ic+ -140|0);Ic=q[a+8>>2];if((Jc|0)!=(Ic|0)){continue}break}}a=q[a>>2];if(a){An(a)}}function xj(a,Kc){var Lc=0,Mc=0,Nc=x(0);Lc=2;a:{if((Kc|0)==1){break a}Lc=Kc;if(!(Kc+ -1&Kc)){break a}Lc=jm(Kc)}Mc=q[a+4>>2];if(Lc>>>0>Mc>>>0){yj(a,Lc);return}b:{if(Lc>>>0>=Mc>>>0){break b}Nc=x(D(x(x(t[a+12>>2])/u[a+16>>2])));c:{if(Nc<x(4294967296)&Nc>=x(0)){Kc=~~Nc>>>0;break c}Kc=0}d:{e:{if(Mc>>>0<3){break e}if(co(Mc)>>>0>1){break e}Kc=Kc>>>0<2?Kc:1<<32-z(Kc+ -1|0);break d}Kc=jm(Kc)}Kc=Lc>>>0<Kc>>>0?Kc:Lc;if(Kc>>>0>=Mc>>>0){break b}yj(a,Kc)}}function yj(a,Kc){var Oc=0,Pc=0,Qc=0,Rc=0,Sc=0,Tc=0,Uc=0,Vc=0,Wc=0;a:{b:{if(Kc){if(Kc>>>0>=1073741824){break a}Oc=Mm(Kc<<2);Pc=q[a>>2];q[a>>2]=Oc;if(Pc){An(Pc)}q[a+4>>2]=Kc;Oc=0;while(1){q[q[a>>2]+(Oc<<2)>>2]=0;Oc=Oc+1|0;if((Oc|0)!=(Kc|0)){continue}break}Pc=a+8|0;Rc=q[Pc>>2];if(!Rc){break b}Sc=q[Rc+4>>2];Oc=co(Kc);c:{if(Oc>>>0<=1){Sc=Kc+ -1&Sc;break c}if(Sc>>>0<Kc>>>0){break c}Sc=(Sc>>>0)%(Kc>>>0)|0}q[q[a>>2]+(Sc<<2)>>2]=Pc;Pc=q[Rc>>2];if(!Pc){break b}Vc=Kc+ -1|0;Wc=Oc>>>0>1;while(1){Qc=q[Pc+4>>2];d:{if(!Wc){Qc=Qc&Vc;break d}if(Qc>>>0<Kc>>>0){break d}Qc=(Qc>>>0)%(Kc>>>0)|0}e:{if((Qc|0)==(Sc|0)){Rc=Pc;break e}Oc=Pc;Tc=Qc<<2;Uc=Tc+q[a>>2]|0;if(!q[Uc>>2]){q[Uc>>2]=Rc;Rc=Pc;Sc=Qc;break e}while(1){Qc=Oc;Oc=q[Oc>>2];if(q[Pc+8>>2]==q[Oc+8>>2]?Oc:0){continue}break}q[Rc>>2]=Oc;q[Qc>>2]=q[q[q[a>>2]+Tc>>2]>>2];q[q[q[a>>2]+Tc>>2]>>2]=Pc}Pc=q[Rc>>2];if(Pc){continue}break}break b}Kc=q[a>>2];q[a>>2]=0;if(Kc){An(Kc)}q[a+4>>2]=0}return}ab(12024);F()}function zj(a){a=a|0;var Kc=0,Xc=0,Yc=0,Zc=0,_c=0,$c=0,ad=0,bd=0,cd=0,dd=0,ed=0,fd=0,gd=0,hd=0,id=0,jd=0,kd=0,ld=0;Zc=T-32|0;T=Zc;$c=q[a+32>>2];Xc=s[a+36>>1];a:{b:{if((Xc<<24|Xc<<8&16711680)>>>16>>>0<=513){Xc=q[$c+12>>2];Yc=Xc;Kc=q[$c+20>>2];_c=Kc;bd=q[$c+16>>2];ad=bd+4|0;if(ad>>>0<4){Kc=Kc+1|0}gd=q[$c+8>>2];ed=ad;ad=Kc;if((Xc|0)<(Kc|0)?1:(Xc|0)<=(Kc|0)?gd>>>0>=ed>>>0?0:1:0){break a}id=q[$c>>2];Xc=id+bd|0;hd=r[Xc|0]|r[Xc+1|0]<<8|(r[Xc+2|0]<<16|r[Xc+3|0]<<24);q[Zc+28>>2]=hd;q[$c+16>>2]=ed;q[$c+20>>2]=ad;Kc=Yc;Xc=_c;Yc=bd+8|0;if(Yc>>>0<8){Xc=Xc+1|0}_c=Yc;Yc=Xc;if((Kc|0)<(Xc|0)?1:(Kc|0)<=(Xc|0)?gd>>>0>=_c>>>0?0:1:0){break a}Xc=ed+id|0;q[Zc+24>>2]=r[Xc|0]|r[Xc+1|0]<<8|(r[Xc+2|0]<<16|r[Xc+3|0]<<24);q[$c+16>>2]=_c;q[$c+20>>2]=Yc;break b}if(!Aj(1,Zc+28|0,$c)){break a}if(!Aj(1,Zc+24|0,q[a+32>>2])){break a}hd=q[Zc+28>>2]}if(hd>>>0>1431655765){break a}Xc=$n(hd,0,3,0);Kc=V;id=q[Zc+24>>2];if(!Kc&Xc>>>0<id>>>0|Kc>>>0<0){break a}Yc=q[a+32>>2];Xc=Yc;$c=q[Xc+16>>2];ad=t[Xc+8>>2]>$c>>>0?0:1;_c=q[Xc+12>>2];Kc=q[Xc+20>>2];if((_c|0)<(Kc|0)?1:(_c|0)<=(Kc|0)?ad:0){break a}ad=r[$c+q[Yc>>2]|0];Xc=Kc;bd=$c+1|0;if(bd>>>0<1){Xc=Xc+1|0}q[Yc+16>>2]=bd;q[Yc+20>>2]=Xc;c:{if(!ad){if(!Bj(a,hd)){break a}break c}d:{if(id>>>0<=255){if(!hd){break c}gd=0;$c=Zc+16|0;q[$c>>2]=0;q[Zc+8>>2]=0;q[Zc+12>>2]=0;dd=q[Yc+8>>2];_c=q[Yc+12>>2];Kc=_c;if((Kc|0)<(Xc|0)?1:(Kc|0)<=(Xc|0)?dd>>>0>bd>>>0?0:1:0){break d}fd=a+44|0;jd=a+32|0;while(1){ed=q[Yc>>2];kd=r[ed+bd|0];Kc=Xc;cd=bd+1|0;if(cd>>>0<1){Kc=Kc+1|0}ad=Yc;q[Yc+16>>2]=cd;q[Yc+20>>2]=Kc;q[Zc+8>>2]=kd;if((_c|0)<(Kc|0)?1:(_c|0)<=(Kc|0)?dd>>>0>cd>>>0?0:1:0){break d}kd=r[cd+ed|0];Kc=Xc;cd=bd+2|0;if(cd>>>0<2){Kc=Kc+1|0}q[Yc+16>>2]=cd;q[ad+20>>2]=Kc;q[Zc+12>>2]=kd;if((_c|0)<(Kc|0)?1:(_c|0)<=(Kc|0)?dd>>>0>cd>>>0?0:1:0){break d}Kc=r[cd+ed|0];_c=bd+3|0;if(_c>>>0<3){Xc=Xc+1|0}q[Yc+16>>2]=_c;q[Yc+20>>2]=Xc;q[Zc+16>>2]=Kc;Kc=q[fd>>2];Yc=Kc+100|0;Xc=q[Yc>>2];e:{if((Xc|0)==q[Kc+104>>2]){Cj(Kc+96|0,Zc+8|0);break e}Kc=q[Zc+12>>2];q[Xc>>2]=q[Zc+8>>2];q[Xc+4>>2]=Kc;q[Xc+8>>2]=q[$c>>2];q[Yc>>2]=q[Yc>>2]+12}gd=gd+1|0;if((hd|0)==(gd|0)){break c}Yc=q[jd>>2];Kc=Yc;bd=q[Kc+16>>2];Xc=q[Kc+20>>2];q[$c>>2]=0;q[Zc+8>>2]=0;q[Zc+12>>2]=0;dd=q[Kc+8>>2];_c=q[Kc+12>>2];Kc=_c;if((Kc|0)>(Xc|0)?1:(Kc|0)>=(Xc|0)?dd>>>0<=bd>>>0?0:1:0){continue}break}break d}if(id>>>0<=65535){if(!hd){break c}gd=0;cd=Zc+16|0;q[cd>>2]=0;q[Zc+8>>2]=0;q[Zc+12>>2]=0;ad=q[Yc+12>>2];fd=ad;_c=$c+3|0;if(_c>>>0<3){Kc=Kc+1|0}ed=q[Yc+8>>2];dd=_c;_c=Kc;if((fd|0)<(Kc|0)?1:(fd|0)<=(Kc|0)?ed>>>0>=dd>>>0?0:1:0){break d}kd=a+44|0;ld=a+32|0;while(1){fd=q[Yc>>2];Kc=fd+bd|0;Kc=r[Kc|0]|r[Kc+1|0]<<8;q[Yc+16>>2]=dd;q[Yc+20>>2]=_c;q[Zc+8>>2]=Kc;_c=ad;Kc=Xc;$c=bd+4|0;if($c>>>0<4){Kc=Kc+1|0}jd=$c;$c=Kc;if((_c|0)<(Kc|0)?1:(_c|0)<=(Kc|0)?ed>>>0>=jd>>>0?0:1:0){break d}Kc=dd+fd|0;Kc=r[Kc|0]|r[Kc+1|0]<<8;q[Yc+16>>2]=jd;q[Yc+20>>2]=$c;q[Zc+12>>2]=Kc;Kc=bd+6|0;if(Kc>>>0<6){Xc=Xc+1|0}_c=Kc;Kc=Xc;if((ad|0)<(Kc|0)?1:(ad|0)<=(Kc|0)?ed>>>0>=_c>>>0?0:1:0){break d}Xc=fd+jd|0;Xc=r[Xc|0]|r[Xc+1|0]<<8;q[Yc+16>>2]=_c;q[Yc+20>>2]=Kc;q[Zc+16>>2]=Xc;Kc=q[kd>>2];Yc=Kc+100|0;Xc=q[Yc>>2];f:{if((Xc|0)==q[Kc+104>>2]){Cj(Kc+96|0,Zc+8|0);break f}Kc=q[Zc+12>>2];q[Xc>>2]=q[Zc+8>>2];q[Xc+4>>2]=Kc;q[Xc+8>>2]=q[cd>>2];q[Yc>>2]=q[Yc>>2]+12}gd=gd+1|0;if((hd|0)==(gd|0)){break c}Yc=q[ld>>2];Kc=Yc;bd=q[Kc+16>>2];Xc=q[Kc+20>>2];q[cd>>2]=0;q[Zc+8>>2]=0;q[Zc+12>>2]=0;$c=q[Kc+12>>2];ad=$c;ed=q[Kc+8>>2];fd=ed;Kc=Xc;_c=bd+2|0;if(_c>>>0<2){Kc=Kc+1|0}dd=_c;_c=Kc;if(($c|0)>(Kc|0)?1:($c|0)>=(Kc|0)?fd>>>0<dd>>>0?0:1:0){continue}break}break d}g:{if(t[q[a+44>>2]+80>>2]>2097151){break g}_c=s[a+36>>1];if((_c<<24|_c<<8&16711680)>>>16>>>0<514){break g}if(!hd){break c}_c=Zc+16|0;q[_c>>2]=0;q[Zc+8>>2]=0;q[Zc+12>>2]=0;if(!Aj(1,Zc+4|0,Yc)){break d}Kc=a+32|0;$c=a+44|0;while(1){q[Zc+8>>2]=q[Zc+4>>2];if(!Aj(1,Zc+4|0,q[Kc>>2])){break d}q[Zc+12>>2]=q[Zc+4>>2];if(!Aj(1,Zc+4|0,q[Kc>>2])){break d}q[Zc+16>>2]=q[Zc+4>>2];Yc=q[$c>>2];ad=Yc+100|0;Xc=q[ad>>2];h:{if((Xc|0)==q[Yc+104>>2]){Cj(Yc+96|0,Zc+8|0);break h}Yc=q[Zc+12>>2];q[Xc>>2]=q[Zc+8>>2];q[Xc+4>>2]=Yc;q[Xc+8>>2]=q[_c>>2];q[ad>>2]=q[ad>>2]+12}cd=cd+1|0;if((cd|0)==(hd|0)){break c}Xc=q[Kc>>2];q[_c>>2]=0;q[Zc+8>>2]=0;q[Zc+12>>2]=0;if(Aj(1,Zc+4|0,Xc)){continue}break}break d}if(!hd){break c}gd=Zc+16|0;q[gd>>2]=0;q[Zc+8>>2]=0;q[Zc+12>>2]=0;ad=q[Yc+12>>2];cd=ad;_c=$c+5|0;if(_c>>>0<5){Kc=Kc+1|0}ed=q[Yc+8>>2];dd=_c;_c=Kc;if((cd|0)<(Kc|0)?1:(cd|0)<=(Kc|0)?ed>>>0>=dd>>>0?0:1:0){break d}jd=a+44|0;kd=a+32|0;while(1){cd=q[Yc>>2];Kc=cd+bd|0;Kc=r[Kc|0]|r[Kc+1|0]<<8|(r[Kc+2|0]<<16|r[Kc+3|0]<<24);q[Yc+16>>2]=dd;q[Yc+20>>2]=_c;q[Zc+8>>2]=Kc;_c=ad;Kc=Xc;$c=bd+8|0;if($c>>>0<8){Kc=Kc+1|0}fd=$c;$c=Kc;if((_c|0)<(Kc|0)?1:(_c|0)<=(Kc|0)?ed>>>0>=fd>>>0?0:1:0){break d}Kc=cd+dd|0;Kc=r[Kc|0]|r[Kc+1|0]<<8|(r[Kc+2|0]<<16|r[Kc+3|0]<<24);q[Yc+16>>2]=fd;q[Yc+20>>2]=$c;q[Zc+12>>2]=Kc;Kc=Xc;Xc=bd+12|0;if(Xc>>>0<12){Kc=Kc+1|0}_c=Xc;Xc=Kc;if((ad|0)<(Kc|0)?1:(ad|0)<=(Kc|0)?ed>>>0>=_c>>>0?0:1:0){break d}Kc=cd+fd|0;Kc=r[Kc|0]|r[Kc+1|0]<<8|(r[Kc+2|0]<<16|r[Kc+3|0]<<24);q[Yc+16>>2]=_c;q[Yc+20>>2]=Xc;q[Zc+16>>2]=Kc;Kc=q[jd>>2];Yc=Kc+100|0;Xc=q[Yc>>2];i:{if((Xc|0)==q[Kc+104>>2]){Cj(Kc+96|0,Zc+8|0);break i}Kc=q[Zc+12>>2];q[Xc>>2]=q[Zc+8>>2];q[Xc+4>>2]=Kc;q[Xc+8>>2]=q[gd>>2];q[Yc>>2]=q[Yc>>2]+12}ld=ld+1|0;if((hd|0)==(ld|0)){break c}Yc=q[kd>>2];Kc=Yc;bd=q[Kc+16>>2];Xc=q[Kc+20>>2];q[gd>>2]=0;q[Zc+8>>2]=0;q[Zc+12>>2]=0;$c=q[Kc+12>>2];ad=$c;ed=q[Kc+8>>2];fd=ed;Kc=Xc;_c=bd+4|0;if(_c>>>0<4){Kc=Kc+1|0}dd=_c;_c=Kc;if(($c|0)>(Kc|0)?1:($c|0)>=(Kc|0)?fd>>>0<dd>>>0?0:1:0){continue}break}}dd=0;break a}q[q[a+4>>2]+80>>2]=id;dd=1}T=Zc+32|0;return dd|0}function Aj(a,md,nd){var od=0,pd=0,qd=0,rd=0;a:{if(a>>>0>5){break a}qd=q[nd+16>>2];od=q[nd+12>>2];pd=q[nd+20>>2];if((od|0)<(pd|0)?1:(od|0)<=(pd|0)?t[nd+8>>2]>qd>>>0?0:1:0){break a}od=r[qd+q[nd>>2]|0];qd=qd+1|0;if(qd>>>0<1){pd=pd+1|0}q[nd+16>>2]=qd;q[nd+20>>2]=pd;pd=md;if(od&128){if(!Aj(a+1|0,md,nd)){break a}a=q[md>>2]<<7;q[md>>2]=a;od=a|od&127}q[pd>>2]=od;rd=1}return rd}function Bj(a,md){var nd=0,sd=0,td=0,ud=0,vd=0,wd=0,xd=0,yd=0,zd=0,Ad=0;nd=T-32|0;T=nd;q[nd+24>>2]=0;q[nd+16>>2]=0;q[nd+20>>2]=0;a:{ud=w(md,3);if(ud){if(ud>>>0>=1073741824){break a}sd=w(md,12);vd=Mm(sd);q[nd+16>>2]=vd;q[nd+24>>2]=(ud<<2)+vd;zd=nd,Ad=Dn(vd,0,sd)+sd|0,q[zd+20>>2]=Ad}b:{if(!qh(ud,1,q[a+32>>2],vd)){break b}td=1;if(!md){break b}yd=a+44|0;vd=0;while(1){ud=nd+8|0;q[ud>>2]=0;q[nd>>2]=0;q[nd+4>>2]=0;a=q[nd+16>>2]+(vd<<2)|0;sd=q[a>>2];td=sd>>>1;sd=(sd&1?0-td|0:td)+wd|0;q[nd>>2]=sd;td=q[a+4>>2];wd=td>>>1;sd=sd+(td&1?0-wd|0:wd)|0;q[nd+4>>2]=sd;a=q[a+8>>2];td=a>>>1;wd=sd+(a&1?0-td|0:td)|0;q[ud>>2]=wd;sd=q[yd>>2];td=sd+100|0;a=q[td>>2];c:{if((a|0)!=q[sd+104>>2]){sd=q[nd+4>>2];q[a>>2]=q[nd>>2];q[a+4>>2]=sd;q[a+8>>2]=q[ud>>2];q[td>>2]=q[td>>2]+12;break c}Cj(sd+96|0,nd)}vd=vd+3|0;td=1;xd=xd+1|0;if((xd|0)!=(md|0)){continue}break}}a=q[nd+16>>2];if(a){q[nd+20>>2]=a;An(a)}T=nd+32|0;return td}bn();F()}function Cj(a,md){var Bd=0,Cd=0,Dd=0,Ed=0,Fd=0,Gd=0;a:{Ed=q[a>>2];Fd=q[a+4>>2]-Ed|0;Bd=(Fd|0)/12|0;Cd=Bd+1|0;if(Cd>>>0<357913942){Gd=w(Bd,12);Dd=(q[a+8>>2]-Ed|0)/12|0;Bd=Dd<<1;Dd=Dd>>>0<178956970?Bd>>>0<Cd>>>0?Cd:Bd:357913941;Bd=0;b:{if(!Dd){break b}if(Dd>>>0>=357913942){break a}Bd=Mm(w(Dd,12))}Cd=Gd+Bd|0;Gd=q[md+4>>2];q[Cd>>2]=q[md>>2];q[Cd+4>>2]=Gd;q[Cd+8>>2]=q[md+8>>2];md=Cd+w((Fd|0)/-12|0,12)|0;Bd=Bd+w(Dd,12)|0;Cd=Cd+12|0;if((Fd|0)>=1){Cn(md,Ed,Fd)}q[a>>2]=md;q[a+8>>2]=Bd;q[a+4>>2]=Cd;if(Ed){An(Ed)}return}bn();F()}ab(13160);F()}function Dj(a,md){a=a|0;md=md|0;var Hd=0,Id=0,Jd=0,Kd=0,Ld=0,Md=0,Nd=0;Kd=T-16|0;T=Kd;Ld=Mm(64);Hd=Mm(12);q[Hd+8>>2]=q[q[a+4>>2]+80>>2];q[Hd>>2]=13236;q[Hd+4>>2]=0;q[Kd+8>>2]=Hd;Ge(Ld,Kd+8|0);a:{if((md|0)>=0){Hd=q[a+12>>2];Md=a+8|0;Nd=q[Md>>2];Id=Hd-Nd>>2;b:{if((Id|0)>(md|0)){break b}Jd=md+1|0;if(Id>>>0<=md>>>0){ji(Md,Jd-Id|0);break b}if(Jd>>>0>=Id>>>0){break b}Jd=Nd+(Jd<<2)|0;if((Jd|0)!=(Hd|0)){while(1){Hd=Hd+ -4|0;Id=q[Hd>>2];q[Hd>>2]=0;if(Id){n[q[q[Id>>2]+4>>2]](Id)}if((Hd|0)!=(Jd|0)){continue}break}}q[a+12>>2]=Jd}md=q[Md>>2]+(md<<2)|0;a=q[md>>2];q[md>>2]=Ld;Id=1;if(!a){break a}n[q[q[a>>2]+4>>2]](a);break a}n[q[q[Ld>>2]+4>>2]](Ld)}a=q[Kd+8>>2];q[Kd+8>>2]=0;if(a){n[q[q[a>>2]+4>>2]](a)}T=Kd+16|0;return Id|0}function Ej(a){a=a|0;var md=0,Od=0,Pd=0,Qd=0,Rd=0;q[a>>2]=13300;md=q[a+20>>2];if(md){q[a+24>>2]=md;An(md)}Pd=q[a+8>>2];if(Pd){md=Pd;Rd=a+12|0;Od=q[Rd>>2];Qd=md;a:{if((md|0)==(Od|0)){break a}while(1){Od=Od+ -4|0;md=q[Od>>2];q[Od>>2]=0;if(md){n[q[q[md>>2]+4>>2]](md)}if((Od|0)!=(Pd|0)){continue}break}Qd=q[a+8>>2]}md=Qd;q[Rd>>2]=Pd;An(md)}An(a)}function Fj(a,Sd){a=a|0;Sd=Sd|0;o[Sd+84|0]=1;q[Sd+72>>2]=q[Sd+68>>2];return 1}function Gj(a){a=a|0;var Sd=0,Td=0,Ud=0,Vd=0;a:{Sd=q[a+8>>2];b:{if((Sd|0)<0){break b}Td=q[a+4>>2];Vd=q[Td>>2];Ud=q[Td+4>>2]-Vd>>2;c:{if(Sd>>>0>Ud>>>0){Hj(Td,Sd-Ud|0);Sd=q[a+8>>2];break c}if(Sd>>>0>=Ud>>>0){break c}q[Td+4>>2]=Vd+(Sd<<2)}Vd=1;if((Sd|0)<1){break b}a=q[a+4>>2];Td=q[a>>2];Ud=q[a+4>>2]-Td>>2;a=0;while(1){if((a|0)==(Ud|0)){break a}q[Td+(a<<2)>>2]=a;a=a+1|0;if((a|0)<(Sd|0)){continue}break}}return Vd|0}cn();F()}function Hj(a,Wd){var Xd=0,Yd=0,Zd=0,_d=0,$d=0,ae=0,be=0,ce=0,de=0;Yd=q[a+8>>2];Zd=a+4|0;Xd=q[Zd>>2];if(Yd-Xd>>2>>>0>=Wd>>>0){a=Wd<<2;ce=Zd,de=Dn(Xd,0,a)+a|0,q[ce>>2]=de;return}a:{Zd=q[a>>2];$d=Xd-Zd|0;Xd=$d>>2;_d=Xd+Wd|0;if(_d>>>0<1073741824){be=Xd<<2;Yd=Yd-Zd|0;Xd=Yd>>1;Yd=Yd>>2>>>0<536870911?Xd>>>0<_d>>>0?_d:Xd:1073741823;Xd=0;b:{if(!Yd){break b}if(Yd>>>0>=1073741824){break a}ae=Mm(Yd<<2);Xd=ae}Dn(be+Xd|0,0,Wd<<2);Wd=Xd+(_d<<2)|0;_d=Xd+(Yd<<2)|0;if(($d|0)>=1){Cn(ae,Zd,$d)}q[a>>2]=Xd;q[a+8>>2]=_d;q[a+4>>2]=Wd;if(Zd){An(Zd)}return}bn();F()}ab(13160);F()}function Ij(a){q[a+40>>2]=0;q[a>>2]=13300;q[a+4>>2]=0;q[a+8>>2]=0;q[a+12>>2]=0;q[a+16>>2]=0;q[a+20>>2]=0;q[a+24>>2]=0;q[a+28>>2]=0;q[a+32>>2]=0;p[a+36>>1]=0}function Jj(a,Wd,ee){var fe=0,ge=0,he=0,ie=0,je=0,ke=0;ge=T-16|0;T=ge;ie=q[Wd+12>>2];fe=q[Wd+20>>2];he=q[Wd+16>>2];je=he+5|0;if(je>>>0<5){fe=fe+1|0}a:{if((ie|0)<(fe|0)?1:(ie|0)<=(fe|0)?t[Wd+8>>2]>=je>>>0?0:1:0){Wd=Mm(32);q[ge>>2]=Wd;q[ge+4>>2]=29;q[ge+8>>2]=-2147483616;o[Wd+29|0]=0;ee=r[13369]|r[13370]<<8|(r[13371]<<16|r[13372]<<24);fe=r[13365]|r[13366]<<8|(r[13367]<<16|r[13368]<<24);o[Wd+21|0]=fe;o[Wd+22|0]=fe>>>8;o[Wd+23|0]=fe>>>16;o[Wd+24|0]=fe>>>24;o[Wd+25|0]=ee;o[Wd+26|0]=ee>>>8;o[Wd+27|0]=ee>>>16;o[Wd+28|0]=ee>>>24;ee=q[3341];fe=q[3340];o[Wd+16|0]=fe;o[Wd+17|0]=fe>>>8;o[Wd+18|0]=fe>>>16;o[Wd+19|0]=fe>>>24;o[Wd+20|0]=ee;o[Wd+21|0]=ee>>>8;o[Wd+22|0]=ee>>>16;o[Wd+23|0]=ee>>>24;ee=q[3339];fe=q[3338];o[Wd+8|0]=fe;o[Wd+9|0]=fe>>>8;o[Wd+10|0]=fe>>>16;o[Wd+11|0]=fe>>>24;o[Wd+12|0]=ee;o[Wd+13|0]=ee>>>8;o[Wd+14|0]=ee>>>16;o[Wd+15|0]=ee>>>24;ee=q[3337];fe=q[3336];o[Wd|0]=fe;o[Wd+1|0]=fe>>>8;o[Wd+2|0]=fe>>>16;o[Wd+3|0]=fe>>>24;o[Wd+4|0]=ee;o[Wd+5|0]=ee>>>8;o[Wd+6|0]=ee>>>16;o[Wd+7|0]=ee>>>24;q[a>>2]=-2;Rm(a+4|0,ge);if(o[ge+11|0]>-1){break a}An(q[ge>>2]);break a}fe=he+q[Wd>>2]|0;ie=r[fe|0]|r[fe+1|0]<<8|(r[fe+2|0]<<16|r[fe+3|0]<<24);o[ee|0]=ie;o[ee+1|0]=ie>>>8;o[ee+2|0]=ie>>>16;o[ee+3|0]=ie>>>24;o[ee+4|0]=r[fe+4|0];ie=Wd;fe=q[Wd+20>>2];he=q[Wd+16>>2]+5|0;if(he>>>0<5){fe=fe+1|0}je=he;he=fe;q[ie+16>>2]=je;q[ie+20>>2]=fe;if(cm(ee,13374,5)){Wd=Mm(32);q[ge>>2]=Wd;q[ge+4>>2]=17;q[ge+8>>2]=-2147483616;o[Wd+17|0]=0;o[Wd+16|0]=r[13396];ee=r[13392]|r[13393]<<8|(r[13394]<<16|r[13395]<<24);fe=r[13388]|r[13389]<<8|(r[13390]<<16|r[13391]<<24);o[Wd+8|0]=fe;o[Wd+9|0]=fe>>>8;o[Wd+10|0]=fe>>>16;o[Wd+11|0]=fe>>>24;o[Wd+12|0]=ee;o[Wd+13|0]=ee>>>8;o[Wd+14|0]=ee>>>16;o[Wd+15|0]=ee>>>24;ee=r[13384]|r[13385]<<8|(r[13386]<<16|r[13387]<<24);fe=r[13380]|r[13381]<<8|(r[13382]<<16|r[13383]<<24);o[Wd|0]=fe;o[Wd+1|0]=fe>>>8;o[Wd+2|0]=fe>>>16;o[Wd+3|0]=fe>>>24;o[Wd+4|0]=ee;o[Wd+5|0]=ee>>>8;o[Wd+6|0]=ee>>>16;o[Wd+7|0]=ee>>>24;q[a>>2]=-1;Rm(a+4|0,ge);if(o[ge+11|0]>-1){break a}An(q[ge>>2]);break a}fe=q[Wd+12>>2];if((fe|0)<(he|0)?1:(fe|0)<=(he|0)?t[Wd+8>>2]>je>>>0?0:1:0){Wd=Mm(32);q[ge>>2]=Wd;q[ge+4>>2]=29;q[ge+8>>2]=-2147483616;o[Wd+29|0]=0;ee=r[13369]|r[13370]<<8|(r[13371]<<16|r[13372]<<24);fe=r[13365]|r[13366]<<8|(r[13367]<<16|r[13368]<<24);o[Wd+21|0]=fe;o[Wd+22|0]=fe>>>8;o[Wd+23|0]=fe>>>16;o[Wd+24|0]=fe>>>24;o[Wd+25|0]=ee;o[Wd+26|0]=ee>>>8;o[Wd+27|0]=ee>>>16;o[Wd+28|0]=ee>>>24;ee=q[3341];fe=q[3340];o[Wd+16|0]=fe;o[Wd+17|0]=fe>>>8;o[Wd+18|0]=fe>>>16;o[Wd+19|0]=fe>>>24;o[Wd+20|0]=ee;o[Wd+21|0]=ee>>>8;o[Wd+22|0]=ee>>>16;o[Wd+23|0]=ee>>>24;ee=q[3339];fe=q[3338];o[Wd+8|0]=fe;o[Wd+9|0]=fe>>>8;o[Wd+10|0]=fe>>>16;o[Wd+11|0]=fe>>>24;o[Wd+12|0]=ee;o[Wd+13|0]=ee>>>8;o[Wd+14|0]=ee>>>16;o[Wd+15|0]=ee>>>24;ee=q[3337];fe=q[3336];o[Wd|0]=fe;o[Wd+1|0]=fe>>>8;o[Wd+2|0]=fe>>>16;o[Wd+3|0]=fe>>>24;o[Wd+4|0]=ee;o[Wd+5|0]=ee>>>8;o[Wd+6|0]=ee>>>16;o[Wd+7|0]=ee>>>24;q[a>>2]=-2;Rm(a+4|0,ge);if(o[ge+11|0]>-1){break a}An(q[ge>>2]);break a}o[ee+5|0]=r[je+q[Wd>>2]|0];fe=q[Wd+20>>2];he=q[Wd+16>>2]+1|0;if(he>>>0<1){fe=fe+1|0}q[Wd+16>>2]=he;q[ie+20>>2]=fe;ie=q[Wd+12>>2];if((ie|0)<(fe|0)?1:(ie|0)<=(fe|0)?t[Wd+8>>2]>he>>>0?0:1:0){Wd=Mm(32);q[ge>>2]=Wd;q[ge+4>>2]=29;q[ge+8>>2]=-2147483616;o[Wd+29|0]=0;ee=r[13369]|r[13370]<<8|(r[13371]<<16|r[13372]<<24);fe=r[13365]|r[13366]<<8|(r[13367]<<16|r[13368]<<24);o[Wd+21|0]=fe;o[Wd+22|0]=fe>>>8;o[Wd+23|0]=fe>>>16;o[Wd+24|0]=fe>>>24;o[Wd+25|0]=ee;o[Wd+26|0]=ee>>>8;o[Wd+27|0]=ee>>>16;o[Wd+28|0]=ee>>>24;ee=q[3341];fe=q[3340];o[Wd+16|0]=fe;o[Wd+17|0]=fe>>>8;o[Wd+18|0]=fe>>>16;o[Wd+19|0]=fe>>>24;o[Wd+20|0]=ee;o[Wd+21|0]=ee>>>8;o[Wd+22|0]=ee>>>16;o[Wd+23|0]=ee>>>24;ee=q[3339];fe=q[3338];o[Wd+8|0]=fe;o[Wd+9|0]=fe>>>8;o[Wd+10|0]=fe>>>16;o[Wd+11|0]=fe>>>24;o[Wd+12|0]=ee;o[Wd+13|0]=ee>>>8;o[Wd+14|0]=ee>>>16;o[Wd+15|0]=ee>>>24;ee=q[3337];fe=q[3336];o[Wd|0]=fe;o[Wd+1|0]=fe>>>8;o[Wd+2|0]=fe>>>16;o[Wd+3|0]=fe>>>24;o[Wd+4|0]=ee;o[Wd+5|0]=ee>>>8;o[Wd+6|0]=ee>>>16;o[Wd+7|0]=ee>>>24;q[a>>2]=-2;Rm(a+4|0,ge);if(o[ge+11|0]>-1){break a}An(q[ge>>2]);break a}o[ee+6|0]=r[he+q[Wd>>2]|0];fe=q[Wd+20>>2];he=q[Wd+16>>2]+1|0;if(he>>>0<1){fe=fe+1|0}q[Wd+16>>2]=he;q[Wd+20>>2]=fe;ie=q[Wd+12>>2];if((ie|0)<(fe|0)?1:(ie|0)<=(fe|0)?t[Wd+8>>2]>he>>>0?0:1:0){Wd=Mm(32);q[ge>>2]=Wd;q[ge+4>>2]=29;q[ge+8>>2]=-2147483616;o[Wd+29|0]=0;ee=r[13369]|r[13370]<<8|(r[13371]<<16|r[13372]<<24);fe=r[13365]|r[13366]<<8|(r[13367]<<16|r[13368]<<24);o[Wd+21|0]=fe;o[Wd+22|0]=fe>>>8;o[Wd+23|0]=fe>>>16;o[Wd+24|0]=fe>>>24;o[Wd+25|0]=ee;o[Wd+26|0]=ee>>>8;o[Wd+27|0]=ee>>>16;o[Wd+28|0]=ee>>>24;ee=q[3341];fe=q[3340];o[Wd+16|0]=fe;o[Wd+17|0]=fe>>>8;o[Wd+18|0]=fe>>>16;o[Wd+19|0]=fe>>>24;o[Wd+20|0]=ee;o[Wd+21|0]=ee>>>8;o[Wd+22|0]=ee>>>16;o[Wd+23|0]=ee>>>24;ee=q[3339];fe=q[3338];o[Wd+8|0]=fe;o[Wd+9|0]=fe>>>8;o[Wd+10|0]=fe>>>16;o[Wd+11|0]=fe>>>24;o[Wd+12|0]=ee;o[Wd+13|0]=ee>>>8;o[Wd+14|0]=ee>>>16;o[Wd+15|0]=ee>>>24;ee=q[3337];fe=q[3336];o[Wd|0]=fe;o[Wd+1|0]=fe>>>8;o[Wd+2|0]=fe>>>16;o[Wd+3|0]=fe>>>24;o[Wd+4|0]=ee;o[Wd+5|0]=ee>>>8;o[Wd+6|0]=ee>>>16;o[Wd+7|0]=ee>>>24;q[a>>2]=-2;Rm(a+4|0,ge);if(o[ge+11|0]>-1){break a}An(q[ge>>2]);break a}o[ee+7|0]=r[he+q[Wd>>2]|0];fe=q[Wd+20>>2];he=q[Wd+16>>2]+1|0;if(he>>>0<1){fe=fe+1|0}q[Wd+16>>2]=he;q[Wd+20>>2]=fe;ie=q[Wd+12>>2];if((ie|0)<(fe|0)?1:(ie|0)<=(fe|0)?t[Wd+8>>2]>he>>>0?0:1:0){Wd=Mm(32);q[ge>>2]=Wd;q[ge+4>>2]=29;q[ge+8>>2]=-2147483616;o[Wd+29|0]=0;ee=r[13369]|r[13370]<<8|(r[13371]<<16|r[13372]<<24);fe=r[13365]|r[13366]<<8|(r[13367]<<16|r[13368]<<24);o[Wd+21|0]=fe;o[Wd+22|0]=fe>>>8;o[Wd+23|0]=fe>>>16;o[Wd+24|0]=fe>>>24;o[Wd+25|0]=ee;o[Wd+26|0]=ee>>>8;o[Wd+27|0]=ee>>>16;o[Wd+28|0]=ee>>>24;ee=q[3341];fe=q[3340];o[Wd+16|0]=fe;o[Wd+17|0]=fe>>>8;o[Wd+18|0]=fe>>>16;o[Wd+19|0]=fe>>>24;o[Wd+20|0]=ee;o[Wd+21|0]=ee>>>8;o[Wd+22|0]=ee>>>16;o[Wd+23|0]=ee>>>24;ee=q[3339];fe=q[3338];o[Wd+8|0]=fe;o[Wd+9|0]=fe>>>8;o[Wd+10|0]=fe>>>16;o[Wd+11|0]=fe>>>24;o[Wd+12|0]=ee;o[Wd+13|0]=ee>>>8;o[Wd+14|0]=ee>>>16;o[Wd+15|0]=ee>>>24;ee=q[3337];fe=q[3336];o[Wd|0]=fe;o[Wd+1|0]=fe>>>8;o[Wd+2|0]=fe>>>16;o[Wd+3|0]=fe>>>24;o[Wd+4|0]=ee;o[Wd+5|0]=ee>>>8;o[Wd+6|0]=ee>>>16;o[Wd+7|0]=ee>>>24;q[a>>2]=-2;Rm(a+4|0,ge);if(o[ge+11|0]>-1){break a}An(q[ge>>2]);break a}o[ee+8|0]=r[he+q[Wd>>2]|0];fe=q[Wd+20>>2];he=fe;ke=q[Wd+16>>2];je=ke+1|0;if(je>>>0<1){fe=fe+1|0}q[Wd+16>>2]=je;q[Wd+20>>2]=fe;ie=q[Wd+12>>2];fe=he;he=ke+3|0;if(he>>>0<3){fe=fe+1|0}if((ie|0)<(fe|0)?1:(ie|0)<=(fe|0)?t[Wd+8>>2]>=he>>>0?0:1:0){Wd=Mm(32);q[ge>>2]=Wd;q[ge+4>>2]=29;q[ge+8>>2]=-2147483616;o[Wd+29|0]=0;ee=r[13369]|r[13370]<<8|(r[13371]<<16|r[13372]<<24);fe=r[13365]|r[13366]<<8|(r[13367]<<16|r[13368]<<24);o[Wd+21|0]=fe;o[Wd+22|0]=fe>>>8;o[Wd+23|0]=fe>>>16;o[Wd+24|0]=fe>>>24;o[Wd+25|0]=ee;o[Wd+26|0]=ee>>>8;o[Wd+27|0]=ee>>>16;o[Wd+28|0]=ee>>>24;ee=q[3341];fe=q[3340];o[Wd+16|0]=fe;o[Wd+17|0]=fe>>>8;o[Wd+18|0]=fe>>>16;o[Wd+19|0]=fe>>>24;o[Wd+20|0]=ee;o[Wd+21|0]=ee>>>8;o[Wd+22|0]=ee>>>16;o[Wd+23|0]=ee>>>24;ee=q[3339];fe=q[3338];o[Wd+8|0]=fe;o[Wd+9|0]=fe>>>8;o[Wd+10|0]=fe>>>16;o[Wd+11|0]=fe>>>24;o[Wd+12|0]=ee;o[Wd+13|0]=ee>>>8;o[Wd+14|0]=ee>>>16;o[Wd+15|0]=ee>>>24;ee=q[3337];fe=q[3336];o[Wd|0]=fe;o[Wd+1|0]=fe>>>8;o[Wd+2|0]=fe>>>16;o[Wd+3|0]=fe>>>24;o[Wd+4|0]=ee;o[Wd+5|0]=ee>>>8;o[Wd+6|0]=ee>>>16;o[Wd+7|0]=ee>>>24;q[a>>2]=-2;Rm(a+4|0,ge);if(o[ge+11|0]>-1){break a}An(q[ge>>2]);break a}he=ee;ee=je+q[Wd>>2]|0;p[he+10>>1]=r[ee|0]|r[ee+1|0]<<8;ee=Wd;he=Wd;fe=q[Wd+20>>2];Wd=q[Wd+16>>2]+2|0;if(Wd>>>0<2){fe=fe+1|0}q[he+16>>2]=Wd;q[ee+20>>2]=fe;q[a+8>>2]=0;q[a+12>>2]=0;q[a>>2]=0;q[a+4>>2]=0}T=ge+16|0}function Kj(a,Wd){var ee=0,le=0,me=0,ne=0;le=T-48|0;T=le;ee=Mm(36);me=ee+4|0;q[me>>2]=0;q[me+4>>2]=0;ne=ee+16|0;q[ne>>2]=0;q[ne+4>>2]=0;q[ee>>2]=me;q[ee+32>>2]=0;q[ee+24>>2]=0;q[ee+28>>2]=0;q[ee+12>>2]=ne;q[le+40>>2]=ee;ee=le+32|0;q[ee>>2]=0;a:{if(!Ok(ee,q[Wd+32>>2],q[le+40>>2])){q[le+24>>2]=0;q[le+16>>2]=0;q[le+20>>2]=0;Wd=Mm(32);q[le+16>>2]=Wd;q[le+20>>2]=26;q[le+24>>2]=-2147483616;o[Wd+26|0]=0;ee=r[13422]|r[13423]<<8;o[Wd+24|0]=ee;o[Wd+25|0]=ee>>>8;ee=r[13418]|r[13419]<<8|(r[13420]<<16|r[13421]<<24);me=r[13414]|r[13415]<<8|(r[13416]<<16|r[13417]<<24);o[Wd+16|0]=me;o[Wd+17|0]=me>>>8;o[Wd+18|0]=me>>>16;o[Wd+19|0]=me>>>24;o[Wd+20|0]=ee;o[Wd+21|0]=ee>>>8;o[Wd+22|0]=ee>>>16;o[Wd+23|0]=ee>>>24;ee=r[13410]|r[13411]<<8|(r[13412]<<16|r[13413]<<24);me=r[13406]|r[13407]<<8|(r[13408]<<16|r[13409]<<24);o[Wd+8|0]=me;o[Wd+9|0]=me>>>8;o[Wd+10|0]=me>>>16;o[Wd+11|0]=me>>>24;o[Wd+12|0]=ee;o[Wd+13|0]=ee>>>8;o[Wd+14|0]=ee>>>16;o[Wd+15|0]=ee>>>24;ee=r[13402]|r[13403]<<8|(r[13404]<<16|r[13405]<<24);me=r[13398]|r[13399]<<8|(r[13400]<<16|r[13401]<<24);o[Wd|0]=me;o[Wd+1|0]=me>>>8;o[Wd+2|0]=me>>>16;o[Wd+3|0]=me>>>24;o[Wd+4|0]=ee;o[Wd+5|0]=ee>>>8;o[Wd+6|0]=ee>>>16;o[Wd+7|0]=ee>>>24;q[a>>2]=-1;Rm(a+4|0,le+16|0);if(o[le+27|0]>-1){break a}An(q[le+16>>2]);break a}Wd=q[Wd+4>>2];q[le+8>>2]=0;me=q[le+40>>2];q[le+40>>2]=0;ee=q[Wd+4>>2];q[Wd+4>>2]=me;b:{if(!ee){q[le+8>>2]=0;break b}Lj(ee);Wd=q[le+8>>2];q[le+8>>2]=0;if(!Wd){break b}Lj(Wd)}q[a>>2]=0;q[a+4>>2]=0;q[a+8>>2]=0;q[a+12>>2]=0}a=q[le+40>>2];q[le+40>>2]=0;if(a){Lj(a)}T=le+48|0}function Lj(a){var Wd=0,oe=0,pe=0,qe=0,re=0;if(a){pe=q[a+24>>2];if(pe){Wd=pe;re=a+28|0;oe=q[re>>2];qe=Wd;a:{if((oe|0)==(Wd|0)){break a}while(1){oe=oe+ -4|0;Wd=q[oe>>2];q[oe>>2]=0;if(Wd){Hc(Wd+12|0,q[Wd+16>>2]);Ic(Wd,q[Wd+4>>2]);An(Wd)}if((oe|0)!=(pe|0)){continue}break}qe=q[a+24>>2]}Wd=qe;q[re>>2]=pe;An(Wd)}Hc(a+12|0,q[a+16>>2]);Ic(a,q[a+4>>2]);An(a)}}function Mj(a,se,te,ue,ve){var we=0,xe=0;we=T-32|0;T=we;q[se+32>>2]=ue;q[se+40>>2]=te;q[se+4>>2]=ve;Jj(a,ue,we+16|0);a:{if(q[a>>2]){break a}te=a+4|0;if(o[a+15|0]<=-1){An(q[te>>2])}ve=r[we+23|0];if((n[q[q[se>>2]+8>>2]](se)|0)!=(ve|0)){se=Mm(64);q[we>>2]=se;q[we+4>>2]=50;q[we+8>>2]=-2147483584;o[se+50|0]=0;ue=r[13473]|r[13474]<<8;o[se+48|0]=ue;o[se+49|0]=ue>>>8;ue=r[13469]|r[13470]<<8|(r[13471]<<16|r[13472]<<24);ve=r[13465]|r[13466]<<8|(r[13467]<<16|r[13468]<<24);o[se+40|0]=ve;o[se+41|0]=ve>>>8;o[se+42|0]=ve>>>16;o[se+43|0]=ve>>>24;o[se+44|0]=ue;o[se+45|0]=ue>>>8;o[se+46|0]=ue>>>16;o[se+47|0]=ue>>>24;ue=r[13461]|r[13462]<<8|(r[13463]<<16|r[13464]<<24);ve=r[13457]|r[13458]<<8|(r[13459]<<16|r[13460]<<24);o[se+32|0]=ve;o[se+33|0]=ve>>>8;o[se+34|0]=ve>>>16;o[se+35|0]=ve>>>24;o[se+36|0]=ue;o[se+37|0]=ue>>>8;o[se+38|0]=ue>>>16;o[se+39|0]=ue>>>24;ue=r[13453]|r[13454]<<8|(r[13455]<<16|r[13456]<<24);ve=r[13449]|r[13450]<<8|(r[13451]<<16|r[13452]<<24);o[se+24|0]=ve;o[se+25|0]=ve>>>8;o[se+26|0]=ve>>>16;o[se+27|0]=ve>>>24;o[se+28|0]=ue;o[se+29|0]=ue>>>8;o[se+30|0]=ue>>>16;o[se+31|0]=ue>>>24;ue=r[13445]|r[13446]<<8|(r[13447]<<16|r[13448]<<24);ve=r[13441]|r[13442]<<8|(r[13443]<<16|r[13444]<<24);o[se+16|0]=ve;o[se+17|0]=ve>>>8;o[se+18|0]=ve>>>16;o[se+19|0]=ve>>>24;o[se+20|0]=ue;o[se+21|0]=ue>>>8;o[se+22|0]=ue>>>16;o[se+23|0]=ue>>>24;ue=r[13437]|r[13438]<<8|(r[13439]<<16|r[13440]<<24);ve=r[13433]|r[13434]<<8|(r[13435]<<16|r[13436]<<24);o[se+8|0]=ve;o[se+9|0]=ve>>>8;o[se+10|0]=ve>>>16;o[se+11|0]=ve>>>24;o[se+12|0]=ue;o[se+13|0]=ue>>>8;o[se+14|0]=ue>>>16;o[se+15|0]=ue>>>24;ue=r[13429]|r[13430]<<8|(r[13431]<<16|r[13432]<<24);ve=r[13425]|r[13426]<<8|(r[13427]<<16|r[13428]<<24);o[se|0]=ve;o[se+1|0]=ve>>>8;o[se+2|0]=ve>>>16;o[se+3|0]=ve>>>24;o[se+4|0]=ue;o[se+5|0]=ue>>>8;o[se+6|0]=ue>>>16;o[se+7|0]=ue>>>24;q[a>>2]=-1;Rm(te,we);if(o[we+11|0]>-1){break a}An(q[we>>2]);break a}ue=r[we+21|0];o[se+36|0]=ue;xe=r[we+22|0];o[se+37|0]=xe;if((ue+ -1&255)>>>0>=2){se=Mm(32);q[we>>2]=se;q[we+4>>2]=22;q[we+8>>2]=-2147483616;o[se+22|0]=0;ue=r[13494]|r[13495]<<8|(r[13496]<<16|r[13497]<<24);ve=r[13490]|r[13491]<<8|(r[13492]<<16|r[13493]<<24);o[se+14|0]=ve;o[se+15|0]=ve>>>8;o[se+16|0]=ve>>>16;o[se+17|0]=ve>>>24;o[se+18|0]=ue;o[se+19|0]=ue>>>8;o[se+20|0]=ue>>>16;o[se+21|0]=ue>>>24;ue=r[13488]|r[13489]<<8|(r[13490]<<16|r[13491]<<24);ve=r[13484]|r[13485]<<8|(r[13486]<<16|r[13487]<<24);o[se+8|0]=ve;o[se+9|0]=ve>>>8;o[se+10|0]=ve>>>16;o[se+11|0]=ve>>>24;o[se+12|0]=ue;o[se+13|0]=ue>>>8;o[se+14|0]=ue>>>16;o[se+15|0]=ue>>>24;ue=r[13480]|r[13481]<<8|(r[13482]<<16|r[13483]<<24);ve=r[13476]|r[13477]<<8|(r[13478]<<16|r[13479]<<24);o[se|0]=ve;o[se+1|0]=ve>>>8;o[se+2|0]=ve>>>16;o[se+3|0]=ve>>>24;o[se+4|0]=ue;o[se+5|0]=ue>>>8;o[se+6|0]=ue>>>16;o[se+7|0]=ue>>>24;q[a>>2]=-5;Rm(te,we);if(o[we+11|0]>-1){break a}An(q[we>>2]);break a}if(!((ue|0)!=2|(ve?2:3)>>>0>=xe>>>0)){se=Mm(32);q[we>>2]=se;q[we+4>>2]=22;q[we+8>>2]=-2147483616;o[se+22|0]=0;ue=r[13517]|r[13518]<<8|(r[13519]<<16|r[13520]<<24);ve=r[13513]|r[13514]<<8|(r[13515]<<16|r[13516]<<24);o[se+14|0]=ve;o[se+15|0]=ve>>>8;o[se+16|0]=ve>>>16;o[se+17|0]=ve>>>24;o[se+18|0]=ue;o[se+19|0]=ue>>>8;o[se+20|0]=ue>>>16;o[se+21|0]=ue>>>24;ue=r[13511]|r[13512]<<8|(r[13513]<<16|r[13514]<<24);ve=r[13507]|r[13508]<<8|(r[13509]<<16|r[13510]<<24);o[se+8|0]=ve;o[se+9|0]=ve>>>8;o[se+10|0]=ve>>>16;o[se+11|0]=ve>>>24;o[se+12|0]=ue;o[se+13|0]=ue>>>8;o[se+14|0]=ue>>>16;o[se+15|0]=ue>>>24;ue=r[13503]|r[13504]<<8|(r[13505]<<16|r[13506]<<24);ve=r[13499]|r[13500]<<8|(r[13501]<<16|r[13502]<<24);o[se|0]=ve;o[se+1|0]=ve>>>8;o[se+2|0]=ve>>>16;o[se+3|0]=ve>>>24;o[se+4|0]=ue;o[se+5|0]=ue>>>8;o[se+6|0]=ue>>>16;o[se+7|0]=ue>>>24;q[a>>2]=-5;Rm(te,we);if(o[we+11|0]>-1){break a}An(q[we>>2]);break a}ue=ue<<8|xe;p[q[se+32>>2]+38>>1]=ue;b:{if((ue&65535)>>>0<259|p[we+26>>1]>-1){break b}Kj(a,se);if(q[a>>2]){break a}if(o[te+11|0]>-1){break b}An(q[te>>2])}if(!n[q[q[se>>2]+12>>2]](se)){se=Mm(48);q[we>>2]=se;q[we+4>>2]=33;q[we+8>>2]=-2147483600;o[se+33|0]=0;o[se+32|0]=r[13554];ue=r[13550]|r[13551]<<8|(r[13552]<<16|r[13553]<<24);ve=r[13546]|r[13547]<<8|(r[13548]<<16|r[13549]<<24);o[se+24|0]=ve;o[se+25|0]=ve>>>8;o[se+26|0]=ve>>>16;o[se+27|0]=ve>>>24;o[se+28|0]=ue;o[se+29|0]=ue>>>8;o[se+30|0]=ue>>>16;o[se+31|0]=ue>>>24;ue=r[13542]|r[13543]<<8|(r[13544]<<16|r[13545]<<24);ve=r[13538]|r[13539]<<8|(r[13540]<<16|r[13541]<<24);o[se+16|0]=ve;o[se+17|0]=ve>>>8;o[se+18|0]=ve>>>16;o[se+19|0]=ve>>>24;o[se+20|0]=ue;o[se+21|0]=ue>>>8;o[se+22|0]=ue>>>16;o[se+23|0]=ue>>>24;ue=r[13534]|r[13535]<<8|(r[13536]<<16|r[13537]<<24);ve=r[13530]|r[13531]<<8|(r[13532]<<16|r[13533]<<24);o[se+8|0]=ve;o[se+9|0]=ve>>>8;o[se+10|0]=ve>>>16;o[se+11|0]=ve>>>24;o[se+12|0]=ue;o[se+13|0]=ue>>>8;o[se+14|0]=ue>>>16;o[se+15|0]=ue>>>24;ue=r[13526]|r[13527]<<8|(r[13528]<<16|r[13529]<<24);ve=r[13522]|r[13523]<<8|(r[13524]<<16|r[13525]<<24);o[se|0]=ve;o[se+1|0]=ve>>>8;o[se+2|0]=ve>>>16;o[se+3|0]=ve>>>24;o[se+4|0]=ue;o[se+5|0]=ue>>>8;o[se+6|0]=ue>>>16;o[se+7|0]=ue>>>24;q[a>>2]=-1;Rm(te,we);if(o[we+11|0]>-1){break a}An(q[we>>2]);break a}if(!n[q[q[se>>2]+20>>2]](se)){se=Mm(32);q[we>>2]=se;q[we+4>>2]=31;q[we+8>>2]=-2147483616;o[se+31|0]=0;ue=r[13583]|r[13584]<<8|(r[13585]<<16|r[13586]<<24);ve=r[13579]|r[13580]<<8|(r[13581]<<16|r[13582]<<24);o[se+23|0]=ve;o[se+24|0]=ve>>>8;o[se+25|0]=ve>>>16;o[se+26|0]=ve>>>24;o[se+27|0]=ue;o[se+28|0]=ue>>>8;o[se+29|0]=ue>>>16;o[se+30|0]=ue>>>24;ue=r[13576]|r[13577]<<8|(r[13578]<<16|r[13579]<<24);ve=r[13572]|r[13573]<<8|(r[13574]<<16|r[13575]<<24);o[se+16|0]=ve;o[se+17|0]=ve>>>8;o[se+18|0]=ve>>>16;o[se+19|0]=ve>>>24;o[se+20|0]=ue;o[se+21|0]=ue>>>8;o[se+22|0]=ue>>>16;o[se+23|0]=ue>>>24;ue=r[13568]|r[13569]<<8|(r[13570]<<16|r[13571]<<24);ve=r[13564]|r[13565]<<8|(r[13566]<<16|r[13567]<<24);o[se+8|0]=ve;o[se+9|0]=ve>>>8;o[se+10|0]=ve>>>16;o[se+11|0]=ve>>>24;o[se+12|0]=ue;o[se+13|0]=ue>>>8;o[se+14|0]=ue>>>16;o[se+15|0]=ue>>>24;ue=r[13560]|r[13561]<<8|(r[13562]<<16|r[13563]<<24);ve=r[13556]|r[13557]<<8|(r[13558]<<16|r[13559]<<24);o[se|0]=ve;o[se+1|0]=ve>>>8;o[se+2|0]=ve>>>16;o[se+3|0]=ve>>>24;o[se+4|0]=ue;o[se+5|0]=ue>>>8;o[se+6|0]=ue>>>16;o[se+7|0]=ue>>>24;q[a>>2]=-1;Rm(te,we);if(o[we+11|0]>-1){break a}An(q[we>>2]);break a}if(!n[q[q[se>>2]+24>>2]](se)){se=Mm(48);q[we>>2]=se;q[we+4>>2]=34;q[we+8>>2]=-2147483600;o[se+34|0]=0;ue=r[13620]|r[13621]<<8;o[se+32|0]=ue;o[se+33|0]=ue>>>8;ue=r[13616]|r[13617]<<8|(r[13618]<<16|r[13619]<<24);ve=r[13612]|r[13613]<<8|(r[13614]<<16|r[13615]<<24);o[se+24|0]=ve;o[se+25|0]=ve>>>8;o[se+26|0]=ve>>>16;o[se+27|0]=ve>>>24;o[se+28|0]=ue;o[se+29|0]=ue>>>8;o[se+30|0]=ue>>>16;o[se+31|0]=ue>>>24;ue=r[13608]|r[13609]<<8|(r[13610]<<16|r[13611]<<24);ve=r[13604]|r[13605]<<8|(r[13606]<<16|r[13607]<<24);o[se+16|0]=ve;o[se+17|0]=ve>>>8;o[se+18|0]=ve>>>16;o[se+19|0]=ve>>>24;o[se+20|0]=ue;o[se+21|0]=ue>>>8;o[se+22|0]=ue>>>16;o[se+23|0]=ue>>>24;ue=r[13600]|r[13601]<<8|(r[13602]<<16|r[13603]<<24);ve=r[13596]|r[13597]<<8|(r[13598]<<16|r[13599]<<24);o[se+8|0]=ve;o[se+9|0]=ve>>>8;o[se+10|0]=ve>>>16;o[se+11|0]=ve>>>24;o[se+12|0]=ue;o[se+13|0]=ue>>>8;o[se+14|0]=ue>>>16;o[se+15|0]=ue>>>24;ue=r[13592]|r[13593]<<8|(r[13594]<<16|r[13595]<<24);ve=r[13588]|r[13589]<<8|(r[13590]<<16|r[13591]<<24);o[se|0]=ve;o[se+1|0]=ve>>>8;o[se+2|0]=ve>>>16;o[se+3|0]=ve>>>24;o[se+4|0]=ue;o[se+5|0]=ue>>>8;o[se+6|0]=ue>>>16;o[se+7|0]=ue>>>24;q[a>>2]=-1;Rm(te,we);if(o[we+11|0]>-1){break a}An(q[we>>2]);break a}q[a>>2]=0;q[a+4>>2]=0;q[a+8>>2]=0;q[a+12>>2]=0}T=we+32|0}function Nj(a){a=a|0;var se=0,te=0,ue=0,ve=0,ye=0,ze=0,Ae=0,Be=0,Ce=0,De=0,Ee=0,Fe=0;a:{se=q[a+32>>2];ve=q[se+16>>2];ze=q[se+12>>2];ue=q[se+20>>2];b:{if((ze|0)<(ue|0)?1:(ze|0)<=(ue|0)?t[se+8>>2]>ve>>>0?0:1:0){break b}ye=r[ve+q[se>>2]|0];Ae=ve+1|0;if(Ae>>>0<1){ue=ue+1|0}q[se+16>>2]=Ae;q[se+20>>2]=ue;c:{if(!ye){break c}while(1){if(n[q[q[a>>2]+16>>2]](a,te)){te=te+1|0;if((ye|0)!=(te|0)){continue}break c}break}return 0}te=q[a+8>>2];ue=q[a+12>>2];if((te|0)!=(ue|0)){while(1){se=q[te>>2];if(!n[q[q[se>>2]+8>>2]](se,a,q[a+4>>2])){break b}te=te+4|0;if((ue|0)!=(te|0)){continue}break}}d:{if(!ye){break d}te=0;ue=a+8|0;while(1){se=q[q[ue>>2]+(te<<2)>>2];if(!n[q[q[se>>2]+12>>2]](se,q[a+32>>2])){break a}te=te+1|0;if((ye|0)!=(te|0)){continue}break}if(!ye){break d}ve=a+20|0;Be=a+8|0;ze=a+24|0;while(1){te=0;Ae=Ce<<2;se=q[Ae+q[Be>>2]>>2];ue=n[q[q[se>>2]+24>>2]](se)|0;if((ue|0)>0){while(1){se=q[q[Be>>2]+Ae>>2];se=n[q[q[se>>2]+20>>2]](se,te)|0;De=q[a+20>>2];Ee=q[ze>>2]-De>>2;e:{if(se>>>0<Ee>>>0){break e}Fe=se+1|0;if(Fe>>>0>Ee>>>0){Fa(ve,Fe-Ee|0);De=q[ve>>2];break e}if(Fe>>>0>=Ee>>>0){break e}q[ze>>2]=(Fe<<2)+De}q[(se<<2)+De>>2]=Ce;te=te+1|0;if((ue|0)!=(te|0)){continue}break}}Ce=Ce+1|0;if((Ce|0)!=(ye|0)){continue}break}}Be=0;if(!n[q[q[a>>2]+28>>2]](a)){break b}Be=n[q[q[a>>2]+32>>2]](a)|0}return Be|0}return 0}function Oj(a){a=a|0;var Ge=0,He=0,Ie=0,Je=0;He=1;Ge=q[a+8>>2];Ie=q[a+12>>2];a:{if((Ge|0)==(Ie|0)){break a}while(1){Je=q[Ge>>2];if(n[q[q[Je>>2]+16>>2]](Je,q[a+32>>2])){Ge=Ge+4|0;if((Ie|0)!=(Ge|0)){continue}break a}break}He=0}return He|0}function Pj(a,Ke){var Le=0,Me=0;a:{if((Ke|0)<0){break a}Le=q[a+4>>2];if(q[Le+12>>2]-q[Le+8>>2]>>2<=(Ke|0)){break a}a=q[q[a+8>>2]+(q[q[a+20>>2]+(Ke<<2)>>2]<<2)>>2];Me=n[q[q[a>>2]+32>>2]](a,Ke)|0}return Me}function Qj(a){a=a|0;var Ke=0,Ne=0,Oe=0,Pe=0,Qe=0,Re=0,Se=0,Te=0;Oe=q[a+32>>2];Ne=Oe;Pe=q[Ne+8>>2];Qe=q[Ne+12>>2];Ke=q[Ne+20>>2];Se=Pe;Pe=q[Ne+16>>2];Ne=Pe+4|0;if(Ne>>>0<4){Ke=Ke+1|0}Re=Ne;Ne=Ke;a:{if((Qe|0)<(Ke|0)?1:(Qe|0)<=(Ke|0)?Se>>>0>=Re>>>0?0:1:0){break a}Ke=Pe+q[Oe>>2]|0;Ke=r[Ke|0]|r[Ke+1|0]<<8|(r[Ke+2|0]<<16|r[Ke+3|0]<<24);q[Oe+16>>2]=Re;q[Oe+20>>2]=Ne;if((Ke|0)<0){break a}q[q[a+4>>2]+80>>2]=Ke;Te=1}return Te|0}function Rj(a,Ue){a=a|0;Ue=Ue|0;var Ve=0,We=0,Xe=0,Ye=0,Ze=0,_e=0;Ye=Mm(72);Id(Ye);a:{if((Ue|0)>=0){Ve=q[a+12>>2];Ze=a+8|0;_e=q[Ze>>2];We=Ve-_e>>2;b:{if((We|0)>(Ue|0)){break b}Xe=Ue+1|0;if(We>>>0<=Ue>>>0){ji(Ze,Xe-We|0);break b}if(Xe>>>0>=We>>>0){break b}Xe=_e+(Xe<<2)|0;if((Xe|0)!=(Ve|0)){while(1){Ve=Ve+ -4|0;We=q[Ve>>2];q[Ve>>2]=0;if(We){n[q[q[We>>2]+4>>2]](We)}if((Ve|0)!=(Xe|0)){continue}break}}q[a+12>>2]=Xe}Ue=q[Ze>>2]+(Ue<<2)|0;a=q[Ue>>2];q[Ue>>2]=Ye;Ve=1;if(!a){break a}n[q[q[a>>2]+4>>2]](a);return 1}n[q[q[Ye>>2]+4>>2]](Ye)}return Ve|0}function Sj(a){a=a|0;var Ue=0,$e=0,af=0,bf=0,cf=0,df=0,ef=0;af=q[a+32>>2];$e=af;bf=q[$e+8>>2];cf=q[$e+12>>2];Ue=q[$e+20>>2];ef=bf;bf=q[$e+16>>2];$e=bf+4|0;if($e>>>0<4){Ue=Ue+1|0}df=$e;$e=Ue;if((cf|0)>(Ue|0)?1:(cf|0)>=(Ue|0)?ef>>>0<df>>>0?0:1:0){Ue=bf+q[af>>2]|0;Ue=r[Ue|0]|r[Ue+1|0]<<8|(r[Ue+2|0]<<16|r[Ue+3|0]<<24);q[af+16>>2]=df;q[af+20>>2]=$e;q[q[a+4>>2]+80>>2]=Ue;a=1}else{a=0}return a|0}function Tj(a,ff,gf){var hf=0,jf=0,kf=0;if((ff|0)>0){while(1){jf=hf<<2;kf=q[jf+a>>2];q[gf+jf>>2]=0-(kf&1)^kf>>>1;hf=hf+1|0;if((hf|0)!=(ff|0)){continue}break}}}function Uj(a){q[a+16>>2]=0;q[a+20>>2]=0;q[a>>2]=0;q[a+4>>2]=0;q[a+8>>2]=0;q[a+24>>2]=0;q[a+28>>2]=0}function Vj(a,q,ff,gf){return Wj(a,q,ff,gf)}function Wj(a,ff,gf,lf){var mf=0,nf=0,of=0;a:{if(!ff){ff=gf;lf=ff>>>0<0?lf+1|0:lf;if((lf|0)<0?1:(lf|0)<=0?ff>>>0>=0?0:1:0){return 0}lf=q[a>>2];gf=q[a+4>>2]-lf|0;if(gf>>>0<ff>>>0){Ha(a,ff-gf|0);break a}if(gf>>>0<=ff>>>0){break a}q[a+4>>2]=ff+lf;break a}if((lf|0)<0?1:(lf|0)<=0?gf>>>0>=0?0:1:0){return 0}nf=gf;if(gf>>>0<0){lf=lf+1|0}of=q[a>>2];mf=q[a+4>>2]-of|0;b:{if((lf|0)<0?1:(lf|0)<=0?nf>>>0>mf>>>0?0:1:0){break b}lf=nf;if(mf>>>0<lf>>>0){Ha(a,lf-mf|0);break b}if(mf>>>0<=lf>>>0){break b}q[a+4>>2]=lf+of}if(!gf){break a}En(q[a>>2],ff,gf)}ff=a+24|0;gf=ff;lf=ff;a=q[ff+4>>2];ff=q[ff>>2]+1|0;if(ff>>>0<1){a=a+1|0}q[lf>>2]=ff;q[gf+4>>2]=a;return 1}function Xj(a,ff){var gf=0,lf=0;lf=q[a>>2];gf=q[a+4>>2]-lf|0;a:{if(gf>>>0<ff>>>0){Ha(a,ff-gf|0);break a}if(gf>>>0<=ff>>>0){break a}q[a+4>>2]=ff+lf}ff=a+24|0;gf=ff;lf=ff;a=q[ff+4>>2];ff=q[ff>>2]+1|0;if(ff>>>0<1){a=a+1|0}q[lf>>2]=ff;q[gf+4>>2]=a}function Yj(a){p[a+38>>1]=0;q[a>>2]=0;q[a+8>>2]=0;q[a+12>>2]=0;q[a+16>>2]=0;q[a+20>>2]=0;q[a+24>>2]=0;q[a+28>>2]=0;o[a+29|0]=0;o[a+30|0]=0;o[a+31|0]=0;o[a+32|0]=0;o[a+33|0]=0;o[a+34|0]=0;o[a+35|0]=0;o[a+36|0]=0;return a}function Zj(a,ff,pf,qf){p[a+38>>1]=qf;q[a>>2]=ff;q[a+16>>2]=0;q[a+20>>2]=0;q[a+8>>2]=pf;q[a+12>>2]=0}function _j(a,ff,pf){var qf=0,rf=0,sf=0,tf=0;a:{b:{if(!ff){break b}if(s[a+38>>1]<=513){rf=q[a+12>>2];ff=q[a+20>>2];sf=q[a+16>>2];tf=sf+8|0;if(tf>>>0<8){ff=ff+1|0}if((rf|0)<(ff|0)?1:(rf|0)<=(ff|0)?t[a+8>>2]>=tf>>>0?0:1:0){break a}ff=sf+q[a>>2]|0;qf=r[ff+4|0]|r[ff+5|0]<<8|(r[ff+6|0]<<16|r[ff+7|0]<<24);q[pf>>2]=r[ff|0]|r[ff+1|0]<<8|(r[ff+2|0]<<16|r[ff+3|0]<<24);q[pf+4>>2]=qf;pf=q[a+20>>2];qf=q[a+16>>2]+8|0;if(qf>>>0<8){pf=pf+1|0}q[a+16>>2]=qf;q[a+20>>2]=pf;break b}if(!$j(1,pf,a)){break a}}o[a+36|0]=1;q[a+32>>2]=0;ff=q[a+16>>2];pf=ff+q[a>>2]|0;q[a+24>>2]=pf;qf=a;a=q[a+8>>2];q[qf+28>>2]=pf+(a-ff|0);qf=1}return qf}function $j(a,ff,pf){var uf=0,vf=0,wf=0,xf=0,yf=0,zf=0;a:{if(a>>>0>10){break a}wf=q[pf+16>>2];uf=q[pf+12>>2];vf=q[pf+20>>2];xf=vf;if((uf|0)<(xf|0)?1:(uf|0)<=(xf|0)?t[pf+8>>2]>wf>>>0?0:1:0){break a}yf=o[wf+q[pf>>2]|0];uf=wf+1|0;if(uf>>>0<1){vf=vf+1|0}q[pf+16>>2]=uf;q[pf+20>>2]=vf;xf=ff;wf=ff;uf=yf;b:{if((uf|0)<=-1){if(!$j(a+1|0,ff,pf)){break a}a=ff;pf=q[ff+4>>2];ff=q[ff>>2];vf=pf<<7|ff>>>25;ff=ff<<7;q[a>>2]=ff;q[a+4>>2]=vf;a=uf&127|ff;break b}vf=0;a=uf&255}q[wf>>2]=a;q[xf+4>>2]=vf;zf=1}return zf}function ak(a){var ff=0,pf=0,Af=0,Bf=0,Cf=0,Df=0;o[a+36|0]=0;Af=q[a+20>>2];Bf=a;Cf=a;Df=q[a+16>>2];a=q[a+32>>2]+7|0;if(a>>>0<7){ff=1}pf=ff>>>3;a=ff<<29|a>>>3;ff=Df+a|0;pf=pf+Af|0;q[Cf+16>>2]=ff;q[Bf+20>>2]=ff>>>0<a>>>0?pf+1|0:pf}function bk(a){a=a+ -1|0;if(a>>>0<=10){return q[(a<<2)+13848>>2]}return-1}function ck(a){var Ef=0;Ef=a+4|0;q[Ef>>2]=0;q[Ef+4>>2]=0;q[a>>2]=Ef;return a}function dk(a,Ff,Gf,Hf){var If=0,Jf=0,Kf=0,Lf=0;If=T-16|0;T=If;Lf=a;Jf=ph(Ff,If+12|0,Gf);Gf=q[Jf>>2];if(Gf){Ff=0}else{Gf=Mm(40);Rm(Gf+16|0,q[Hf>>2]);q[Gf+36>>2]=0;q[Gf+28>>2]=0;q[Gf+32>>2]=0;q[Gf+8>>2]=q[If+12>>2];q[Gf>>2]=0;q[Gf+4>>2]=0;q[Jf>>2]=Gf;Hf=Gf;Kf=q[q[Ff>>2]>>2];if(Kf){q[Ff>>2]=Kf;Hf=q[Jf>>2]}nh(q[Ff+4>>2],Hf);Ff=Ff+8|0;q[Ff>>2]=q[Ff>>2]+1;Ff=1}o[Lf+4|0]=Ff;q[a>>2]=Gf;T=If+16|0}function ek(a,Ff){var Gf=0;Gf=T-48|0;T=Gf;$m(Gf+8|0);q[Gf+32>>2]=Ff;dk(Gf+40|0,a,Ff,Gf+32|0);a=q[Gf+40>>2];Ff=a+28|0;a:{if(o[a+39|0]>=0){o[Ff+11|0]=0;o[Ff|0]=0;break a}o[q[a+28>>2]]=0;q[a+32>>2]=0;if(o[a+39|0]>-1){break a}An(q[a+28>>2]);q[a+36>>2]=0}a=q[Gf+12>>2];q[Ff>>2]=q[Gf+8>>2];q[Ff+4>>2]=a;q[Ff+8>>2]=q[Gf+16>>2];T=Gf+48|0}function fk(a,Ff){var Hf=0,Mf=0,Nf=0,Of=0,Pf=0,Qf=0,Rf=0,Sf=0;Pf=a+4|0;a=q[Pf>>2];a:{b:{if(!a){break b}Hf=r[Ff+11|0];Mf=Hf<<24>>24<0;Nf=Mf?q[Ff+4>>2]:Hf;Rf=Mf?q[Ff>>2]:Ff;Hf=Pf;while(1){Ff=r[a+27|0];Sf=Ff<<24>>24<0;Qf=Sf?q[a+20>>2]:Ff;Of=Nf>>>0<Qf>>>0;Mf=Of?Nf:Qf;c:{if(Mf){Ff=a+16|0;Ff=cm(Sf?q[Ff>>2]:Ff,Rf,Mf);if(Ff){break c}}Ff=Qf>>>0<Nf>>>0?-1:Of}Hf=(Ff|0)<0?Hf:a;a=q[(Ff>>>29&4)+a>>2];if(a){continue}break}if((Hf|0)==(Pf|0)){break b}a=r[Hf+27|0];Of=a<<24>>24<0;d:{Mf=Of?q[Hf+20>>2]:a;Ff=Mf>>>0<Nf>>>0?Mf:Nf;if(Ff){a=Hf+16|0;a=cm(Rf,Of?q[a>>2]:a,Ff);if(a){break d}}if(Nf>>>0<Mf>>>0){break b}break a}if((a|0)>-1){break a}}Hf=Pf}return Hf}function gk(a,Ff){var Tf=0;Ff=fk(a,Ff);a:{if((Ff|0)==(a+4|0)){break a}a=Ff+28|0;if(o[Ff+39|0]<=-1){a=q[a>>2]}a=bm(a);if((a|0)==-1){break a}Tf=(a|0)!=0}return Tf}function hk(a){q[a>>2]=1065353216;return a}function ik(a,q,Ff){if((Ff|0)<1){return 0}u[a>>2]=q/x(Ff|0);return 1}function jk(a){var Ff=0;q[a>>2]=0;q[a+4>>2]=0;q[a+56>>2]=0;q[a+48>>2]=0;q[a+52>>2]=0;q[a+40>>2]=0;q[a+44>>2]=0;q[a+32>>2]=0;q[a+36>>2]=0;q[a+24>>2]=0;q[a+28>>2]=0;q[a+16>>2]=0;q[a+20>>2]=0;q[a+8>>2]=0;q[a+12>>2]=0;Ff=a- -64|0;q[Ff>>2]=0;q[Ff+4>>2]=0;q[a+72>>2]=0;q[a+76>>2]=0;q[a+80>>2]=0;q[a+84>>2]=0;q[a+60>>2]=a}function kk(a,Uf){var Vf=0,Wf=0,Xf=0;Xf=T-16|0;T=Xf;Wf=Mm(88);Vf=Wf;q[Vf>>2]=0;q[Vf+4>>2]=0;q[Vf+56>>2]=0;q[Vf+48>>2]=0;q[Vf+52>>2]=0;q[Vf+40>>2]=0;q[Vf+44>>2]=0;q[Vf+32>>2]=0;q[Vf+36>>2]=0;q[Vf+24>>2]=0;q[Vf+28>>2]=0;q[Vf+16>>2]=0;q[Vf+20>>2]=0;q[Vf+8>>2]=0;q[Vf+12>>2]=0;Vf=Vf- -64|0;q[Vf>>2]=0;q[Vf+4>>2]=0;q[Wf+72>>2]=0;q[Wf+76>>2]=0;q[Wf+80>>2]=0;q[Wf+84>>2]=0;q[Wf+60>>2]=Wf;q[Xf+8>>2]=Wf;a:{if(lk(Wf,Uf)){q[a>>2]=q[Xf+8>>2];q[Xf+8>>2]=0;break a}q[a>>2]=0;a=q[Xf+8>>2];q[Xf+8>>2]=0;if(!a){break a}wa(Xf+8|0,a)}T=Xf+16|0}function lk(a,Uf){var Yf=0,Zf=0,_f=0,$f=0,ag=0,bg=0,cg=0;$f=T-16|0;T=$f;q[a+80>>2]=0;q[a+84>>2]=0;Yf=a+76|0;Zf=q[Yf>>2];q[Yf>>2]=0;if(Zf){An(Zf)}q[a+68>>2]=0;q[a+72>>2]=0;Yf=a- -64|0;Zf=q[Yf>>2];q[Yf>>2]=0;if(Zf){An(Zf)}bg=Uf+4|0;Yf=q[bg>>2];Zf=q[Uf>>2];_f=w((Yf-Zf|0)/12|0,3);cg=q[a>>2];ag=q[a+4>>2]-cg>>2;a:{if(_f>>>0>ag>>>0){mk(a,_f-ag|0);Yf=q[bg>>2];Zf=q[Uf>>2];break a}if(_f>>>0>=ag>>>0){break a}q[a+4>>2]=(_f<<2)+cg}if((Yf|0)!=(Zf|0)){ag=(Yf-Zf|0)/12|0;bg=q[a>>2];Uf=0;while(1){_f=w(Uf,12);Yf=_f+bg|0;_f=Zf+_f|0;q[Yf>>2]=q[_f>>2];q[Yf+4>>2]=q[_f+4>>2];q[Yf+8>>2]=q[_f+8>>2];Uf=Uf+1|0;if(Uf>>>0<ag>>>0){continue}break}}q[$f+12>>2]=-1;Uf=0;if(nk(a,$f+12|0)){ok(a);pk(a,q[$f+12>>2]);Uf=1}T=$f+16|0;return Uf}function mk(a,Uf){var dg=0,eg=0,fg=0,gg=0,hg=0,ig=0,jg=0,kg=0,lg=0;eg=q[a+8>>2];fg=a+4|0;dg=q[fg>>2];if(eg-dg>>2>>>0>=Uf>>>0){a=Uf<<2;kg=fg,lg=Dn(dg,0,a)+a|0,q[kg>>2]=lg;return}a:{fg=q[a>>2];hg=dg-fg|0;dg=hg>>2;gg=dg+Uf|0;if(gg>>>0<1073741824){jg=dg<<2;eg=eg-fg|0;dg=eg>>1;eg=eg>>2>>>0<536870911?dg>>>0<gg>>>0?gg:dg:1073741823;dg=0;b:{if(!eg){break b}if(eg>>>0>=1073741824){break a}ig=Mm(eg<<2);dg=ig}Dn(jg+dg|0,0,Uf<<2);Uf=dg+(gg<<2)|0;gg=dg+(eg<<2)|0;if((hg|0)>=1){Cn(ig,fg,hg)}q[a>>2]=dg;q[a+8>>2]=gg;q[a+4>>2]=Uf;if(fg){An(fg)}return}bn();F()}ab(13904);F()}function nk(a,Uf){var mg=0,ng=0,og=0,pg=0,qg=0,rg=0,sg=0,tg=0,ug=0,vg=0,wg=0,xg=0,yg=0,zg=0,Ag=0,Bg=0,Cg=0,Dg=0,Eg=0,Fg=0,Gg=0;og=T-48|0;T=og;if(Uf){Dg=a+12|0;ng=a+4|0;tg=q[ng>>2];ug=q[a>>2];rg=tg-ug|0;pg=rg>>2;mg=q[a+12>>2];qg=q[a+16>>2]-mg>>2;a:{if(pg>>>0>qg>>>0){qk(Dg,pg-qg|0);tg=q[ng>>2];ug=q[a>>2];rg=tg-ug|0;pg=rg>>2;break a}if(pg>>>0>=qg>>>0){break a}q[a+16>>2]=mg+(pg<<2)}ng=0;q[og+40>>2]=0;q[og+32>>2]=0;q[og+36>>2]=0;b:{c:{d:{if(!pg){mg=0;qg=0;break d}if(pg>>>0>=1073741824){break c}mg=Mm(rg);q[og+36>>2]=mg;q[og+32>>2]=mg;q[og+40>>2]=(pg<<2)+mg;qg=mg}e:{if(!rg){break e}sg=a+4|0;ng=qg;wg=ng;rg=0;while(1){vg=q[(rg<<2)+ug>>2];wg=wg-ng>>2;if(vg>>>0>=wg>>>0){q[og+16>>2]=0;mg=vg+1|0;f:{if(mg>>>0>wg>>>0){Ad(og+32|0,mg-wg|0,og+16|0);tg=q[sg>>2];ug=q[a>>2];break f}if(mg>>>0>=wg>>>0){break f}q[og+36>>2]=(mg<<2)+ng}mg=q[og+32>>2];qg=mg}ng=(vg<<2)+mg|0;q[ng>>2]=q[ng>>2]+1;rg=rg+1|0;ng=tg-ug|0;pg=ng>>2;if(rg>>>0>=pg>>>0){break e}wg=q[og+36>>2];ng=mg;continue}}q[og+24>>2]=0;q[og+16>>2]=0;q[og+20>>2]=0;rg=0;g:{if(ng){if(pg>>>0>=536870912){break g}rg=Mm(ng<<1);q[og+16>>2]=rg;q[og+20>>2]=rg;ng=pg<<3;q[og+24>>2]=ng+rg;ng=Dn(rg,255,ng);while(1){ng=ng+8|0;pg=pg+ -1|0;if(pg){continue}break}q[og+20>>2]=ng}q[og+8>>2]=0;q[og>>2]=0;q[og+4>>2]=0;ng=q[og+36>>2]-qg|0;Ag=ng>>2;h:{if(ng){if(Ag>>>0>=1073741824){break h}xg=Mm(ng);q[og>>2]=xg;q[og+8>>2]=(Ag<<2)+xg;pg=0;sg=Dn(xg,0,ng);q[og+4>>2]=sg+ng;ng=0;while(1){qg=ng<<2;q[qg+sg>>2]=pg;pg=q[mg+qg>>2]+pg|0;ng=ng+1|0;if(ng>>>0<Ag>>>0){continue}break}}if((tg|0)==(ug|0)){break b}Gg=tg-ug>>2;sg=0;Eg=q[og+32>>2];while(1){Bg=sg<<2;wg=q[Bg+ug>>2];tg=-1;ng=sg+1|0;mg=(ng>>>0)%3|0?ng:sg+ -2|0;if((mg|0)!=-1){tg=q[(mg<<2)+ug>>2]}yg=-1;qg=(sg>>>0)%3|0;mg=(qg?-1:2)+sg|0;if((mg|0)!=-1){yg=q[(mg<<2)+ug>>2]}i:{j:{if(qg){break j}k:{if((tg|0)==(yg|0)){break k}mg=q[ug+Bg>>2];if((mg|0)==(tg|0)){break k}if((mg|0)!=(yg|0)){break j}}q[a+40>>2]=q[a+40>>2]+1;ng=sg+3|0;break i}mg=yg<<2;Cg=q[mg+Eg>>2];l:{m:{if((Cg|0)<1){break m}mg=q[mg+xg>>2];pg=0;while(1){vg=(mg<<3)+rg|0;qg=q[vg>>2];if((qg|0)==-1){break m}n:{if((qg|0)!=(tg|0)){break n}zg=q[vg+4>>2];if((zg|0)!=-1){qg=q[(zg<<2)+ug>>2]}else{qg=-1}if((qg|0)==(wg|0)){break n}while(1){qg=mg;pg=pg+1|0;o:{if((pg|0)>=(Cg|0)){break o}Fg=(qg<<3)+rg|0;mg=qg+1|0;wg=(mg<<3)+rg|0;vg=q[wg>>2];q[Fg>>2]=vg;q[Fg+4>>2]=q[wg+4>>2];if((vg|0)!=-1){continue}}break}q[(qg<<3)+rg>>2]=-1;if((zg|0)==-1){break m}mg=q[Dg>>2];q[mg+Bg>>2]=zg;q[mg+(zg<<2)>>2]=sg;break l}mg=mg+1|0;pg=pg+1|0;if((Cg|0)!=(pg|0)){continue}break}}mg=tg<<2;qg=q[mg+Eg>>2];if((qg|0)<1){break l}mg=q[mg+xg>>2];pg=0;while(1){vg=(mg<<3)+rg|0;if(q[vg>>2]==-1){q[vg>>2]=yg;q[vg+4>>2]=sg;break l}mg=mg+1|0;pg=pg+1|0;if((qg|0)!=(pg|0)){continue}break}}}sg=ng;if(sg>>>0<Gg>>>0){continue}break}break b}bn();F()}bn();F()}ab(13904);F()}q[Uf>>2]=Ag;if(xg){q[og+4>>2]=xg;An(xg)}a=q[og+16>>2];if(a){q[og+20>>2]=a;An(a)}a=q[og+32>>2];if(a){q[og+36>>2]=a;An(a)}a=1}else{a=0}T=og+48|0;return a}function ok(a){var Uf=0,Hg=0,Ig=0,Jg=0,Kg=0,Lg=0,Mg=0,Ng=0,Og=0,Pg=0,Qg=0,Rg=0,Sg=0,Tg=0,Ug=0;Ig=T-48|0;T=Ig;Qg=a+4|0;Uf=q[Qg>>2];Og=q[a>>2];o[Ig+16|0]=0;Rg=rk(Ig+32|0,Uf-Og>>2,Ig+16|0);q[Ig+24>>2]=0;q[Ig+16>>2]=0;q[Ig+20>>2]=0;Uf=q[Qg>>2];Mg=q[a>>2];Ng=a+12|0;while(1){Sg=0;Lg=0;a:{if((Uf|0)==(Mg|0)){break a}while(1){Jg=q[Rg>>2];b:{if(q[Jg+(Lg>>>3&536870908)>>2]>>>(Lg&31)&1){break b}Kg=q[Ig+16>>2];q[Ig+20>>2]=Kg;Uf=Lg;while(1){Hg=Uf+1|0;Og=Uf;Uf=(Hg>>>0)%3|0?Hg:Uf+ -2|0;c:{if((Uf|0)==-1){break c}Uf=q[q[Ng>>2]+(Uf<<2)>>2];if((Uf|0)==-1){break c}Hg=Uf+1|0;Uf=(Hg>>>0)%3|0?Hg:Uf+ -2|0;if((Lg|0)==(Uf|0)|(Uf|0)==-1){break c}if(!(q[(Uf>>>3&536870908)+Jg>>2]>>>(Uf&31)&1)){continue}}break}Uf=Kg;Hg=Og;while(1){Jg=(Hg>>>3&536870908)+Jg|0;q[Jg>>2]=q[Jg>>2]|1<<(Hg&31);Jg=Hg+1|0;Tg=(Jg>>>0)%3|0?Jg:Hg+ -2|0;Jg=((Hg>>>0)%3|0?-1:2)+Hg|0;if((Uf|0)!=(Kg|0)){Ug=q[(Tg<<2)+Mg>>2];while(1){d:{if((Ug|0)!=q[Uf>>2]){break d}Hg=-1;Pg=q[Uf+4>>2];Hg=(Jg|0)!=-1?q[q[Ng>>2]+(Jg<<2)>>2]:Hg;if((Pg|0)==(Hg|0)){break d}Kg=-1;Kg=(Pg|0)!=-1?q[q[Ng>>2]+(Pg<<2)>>2]:Kg;if((Hg|0)!=-1){q[q[Ng>>2]+(Hg<<2)>>2]=-1}Uf=q[Ng>>2];if((Kg|0)!=-1){q[Uf+(Kg<<2)>>2]=-1}q[Uf+(Jg<<2)>>2]=-1;q[Uf+(Pg<<2)>>2]=-1;Sg=1;break b}Uf=Uf+8|0;if((Kg|0)!=(Uf|0)){continue}break}}q[Ig+8>>2]=0;Uf=Jg<<2;Hg=q[Uf+Mg>>2];q[Ig+12>>2]=Tg;q[Ig+8>>2]=Hg;e:{if(q[Ig+24>>2]!=(Kg|0)){Hg=q[Ig+12>>2];q[Kg>>2]=q[Ig+8>>2];q[Kg+4>>2]=Hg;q[Ig+20>>2]=q[Ig+20>>2]+8;break e}sk(Ig+16|0,Ig+8|0)}f:{if((Jg|0)==-1){break f}Uf=q[Uf+q[Ng>>2]>>2];if((Uf|0)==-1){break f}Hg=Uf+((Uf>>>0)%3|0?-1:2)|0;if((Og|0)==(Hg|0)|(Hg|0)==-1){break f}Mg=q[a>>2];Jg=q[Rg>>2];Kg=q[Ig+20>>2];Uf=q[Ig+16>>2];continue}break}Mg=q[a>>2]}Lg=Lg+1|0;Uf=q[Qg>>2];if(Lg>>>0<Uf-Mg>>2>>>0){continue}break}if(Sg){continue}}break}a=q[Ig+16>>2];if(a){q[Ig+20>>2]=a;An(a)}a=q[Rg>>2];if(a){An(a)}T=Ig+48|0}function pk(a,Vg){var Wg=0,Xg=0,Yg=0,Zg=0,_g=0,$g=0,ah=0,bh=0,ch=0,dh=0,eh=0,fh=0,gh=0,hh=0,ih=0,jh=0,kh=0,lh=0,mh=0,nh=0,oh=0,ph=0,qh=0;$g=T-48|0;T=$g;q[a+36>>2]=Vg;fh=a+24|0;Yg=q[a+24>>2];Wg=q[a+28>>2]-Yg>>2;a:{if(Wg>>>0<Vg>>>0){qk(fh,Vg-Wg|0);break a}if(Wg>>>0<=Vg>>>0){break a}q[a+28>>2]=Yg+(Vg<<2)}o[$g+16|0]=0;ah=rk($g+32|0,Vg,$g+16|0);gh=a+4|0;Wg=q[gh>>2];Yg=q[a>>2];o[$g+8|0]=0;ch=rk($g+16|0,Wg-Yg>>2,$g+8|0);b:{Wg=q[a>>2];if(q[gh>>2]-Wg>>2>>>0<3){break b}mh=a+48|0;hh=a+12|0;nh=a+32|0;jh=a+28|0;oh=a+56|0;kh=a+52|0;while(1){dh=w(ih,3);Zg=q[(dh<<2)+Wg>>2];_g=0;Xg=-1;Yg=dh+1|0;c:{if((Yg|0)!=-1){Xg=q[(Yg<<2)+Wg>>2];_g=dh+2|0;Yg=-1;if((_g|0)==-1){break c}}Yg=q[(_g<<2)+Wg>>2]}d:{if(!((Yg|0)==(Xg|0)|(Xg|0)==(Zg|0)|(Yg|0)==(Zg|0))){bh=q[ch>>2];eh=0;while(1){Yg=dh+eh|0;e:{if(q[(Yg>>>3&536870908)+bh>>2]>>>(Yg&31)&1){break e}_g=q[q[a>>2]+(Yg<<2)>>2];q[$g+8>>2]=_g;Wg=1<<(_g&31);Xg=q[ah>>2];_g=_g>>>5;bh=q[Xg+(_g<<2)>>2];Zg=0;f:{if(!(Wg&bh)){break f}Wg=q[jh>>2];g:{if((Wg|0)!=q[nh>>2]){q[Wg>>2]=-1;q[jh>>2]=Wg+4;break g}zi(fh,13900)}Wg=q[kh>>2];h:{if((Wg|0)!=q[oh>>2]){q[Wg>>2]=q[$g+8>>2];q[kh>>2]=Wg+4;break h}zi(mh,$g+8|0)}Wg=q[ah+4>>2];Zg=q[ah+8>>2];if((Wg|0)==Zg<<5){if((Wg+1|0)<=-1){break d}Xg=ah;if(Wg>>>0<=1073741822){Wg=Wg+32&-32;Zg=Zg<<6;Wg=Zg>>>0<Wg>>>0?Wg:Zg}else{Wg=2147483647}cb(Xg,Wg);Wg=q[ah+4>>2]}q[ah+4>>2]=Wg+1;Xg=q[ah>>2];Zg=Xg+(Wg>>>3&536870908)|0;_g=q[Zg>>2];ph=Zg,qh=eo(Wg)&_g,q[ph>>2]=qh;q[$g+8>>2]=Vg;Wg=1<<(Vg&31);_g=Vg>>>5;bh=q[(_g<<2)+Xg>>2];Vg=Vg+1|0;Zg=1}q[(_g<<2)+Xg>>2]=Wg|bh;bh=q[ch>>2];Wg=Yg;i:{while(1){if((Wg|0)==-1){break i}Xg=(Wg>>>3&536870908)+bh|0;q[Xg>>2]=q[Xg>>2]|1<<(Wg&31);Xg=q[$g+8>>2];q[q[fh>>2]+(Xg<<2)>>2]=Wg;if(Zg){q[q[a>>2]+(Wg<<2)>>2]=Xg}_g=Yg;Xg=Wg+1|0;Wg=(Xg>>>0)%3|0?Xg:Wg+ -2|0;Xg=-1;j:{if((Wg|0)==-1){break j}Wg=q[q[hh>>2]+(Wg<<2)>>2];Xg=-1;if((Wg|0)==-1){break j}Xg=Wg+1|0;Xg=(Xg>>>0)%3|0?Xg:Wg+ -2|0}Wg=Xg;if((_g|0)!=(Wg|0)){continue}break}if((Yg|0)!=-1){break e}}Wg=Yg+((Yg>>>0)%3|0?-1:2)|0;if((Wg|0)==-1){break e}Wg=q[q[hh>>2]+(Wg<<2)>>2];if((Wg|0)==-1){break e}Wg=Wg+((Wg>>>0)%3|0?-1:2)|0;if((Wg|0)==-1){break e}bh=q[ch>>2];while(1){Yg=(Wg>>>3&536870908)+bh|0;q[Yg>>2]=q[Yg>>2]|1<<(Wg&31);if(Zg){q[q[a>>2]+(Wg<<2)>>2]=q[$g+8>>2]}Wg=((Wg>>>0)%3|0?-1:2)+Wg|0;if((Wg|0)==-1){break e}Wg=q[q[hh>>2]+(Wg<<2)>>2];if((Wg|0)==-1){break e}Wg=Wg+((Wg>>>0)%3|0?-1:2)|0;if((Wg|0)!=-1){continue}break}}eh=eh+1|0;if((eh|0)!=3){continue}break}}ih=ih+1|0;Wg=q[a>>2];if(ih>>>0<(q[gh>>2]-Wg>>2>>>0)/3>>>0){continue}break b}break}bn();F()}q[a+44>>2]=0;Vg=q[ah>>2];Wg=q[ah+4>>2];Yg=Wg>>>5;Zg=Wg&31;if(Yg|Zg){Yg=(Yg<<2)+Vg|0;Xg=Vg;Wg=0;while(1){if(!(q[Xg>>2]>>>Wg&1)){lh=lh+1|0;q[a+44>>2]=lh}_g=(Wg|0)==31;Wg=_g?0:Wg+1|0;Xg=_g?Xg+4|0:Xg;if((Yg|0)!=(Xg|0)|(Wg|0)!=(Zg|0)){continue}break}}a=q[ch>>2];if(a){An(a);Vg=q[ah>>2]}if(Vg){An(Vg)}T=$g+48|0}function qk(a,Vg){var rh=0,sh=0,th=0,uh=0,vh=0,wh=0;th=q[a+8>>2];rh=q[a+4>>2];if(th-rh>>2>>>0>=Vg>>>0){while(1){q[rh>>2]=q[3475];rh=rh+4|0;Vg=Vg+ -1|0;if(Vg){continue}break}q[a+4>>2]=rh;return}a:{uh=q[a>>2];vh=rh-uh|0;wh=vh>>2;rh=wh+Vg|0;if(rh>>>0<1073741824){th=th-uh|0;sh=th>>1;rh=th>>2>>>0<536870911?sh>>>0<rh>>>0?rh:sh:1073741823;sh=0;b:{if(!rh){break b}if(rh>>>0>=1073741824){break a}sh=Mm(rh<<2)}th=sh+(rh<<2)|0;rh=sh+(wh<<2)|0;while(1){q[rh>>2]=q[3475];rh=rh+4|0;Vg=Vg+ -1|0;if(Vg){continue}break}if((vh|0)>=1){Cn(sh,uh,vh)}q[a>>2]=sh;q[a+8>>2]=th;q[a+4>>2]=rh;if(uh){An(uh)}return}bn();F()}ab(13904);F()}function rk(a,Vg,xh){var yh=0,zh=0,Ah=0;q[a>>2]=0;q[a+4>>2]=0;q[a+8>>2]=0;a:{b:{if(!Vg){break b}if((Vg|0)<=-1){break a}zh=Vg+ -1>>>5;Ah=zh+1|0;yh=Mm(Ah<<2);q[a+8>>2]=Ah;q[a>>2]=yh;Ah=r[xh|0];q[a+4>>2]=Vg;q[(Vg>>>0<33?yh:yh+(zh<<2)|0)>>2]=0;xh=Vg>>>5;zh=xh<<2;if(Ah){yh=Dn(yh,255,zh);Vg=Vg&31;if(!Vg){break b}xh=yh+(xh<<2)|0;q[xh>>2]=q[xh>>2]|-1>>>32-Vg;return a}yh=Dn(yh,0,zh);Vg=Vg&31;if(!Vg){break b}xh=yh+(xh<<2)|0;q[xh>>2]=q[xh>>2]&(-1>>>32-Vg^-1)}return a}bn();F()}function sk(a,Vg){var xh=0,Bh=0,Ch=0,Dh=0,Eh=0,Fh=0;a:{Ch=q[a>>2];Fh=q[a+4>>2]-Ch|0;xh=Fh>>3;Bh=xh+1|0;if(Bh>>>0<536870912){Dh=xh<<3;Eh=q[a+8>>2]-Ch|0;xh=Eh>>2;Bh=Eh>>3>>>0<268435455?xh>>>0<Bh>>>0?Bh:xh:536870911;xh=0;b:{if(!Bh){break b}if(Bh>>>0>=536870912){break a}xh=Mm(Bh<<3)}Dh=Dh+xh|0;Eh=q[Vg+4>>2];q[Dh>>2]=q[Vg>>2];q[Dh+4>>2]=Eh;Vg=xh+(Bh<<3)|0;Bh=Dh+8|0;if((Fh|0)>=1){Cn(xh,Ch,Fh)}q[a>>2]=xh;q[a+8>>2]=Vg;q[a+4>>2]=Bh;if(Ch){An(Ch)}return}bn();F()}ab(13904);F()}function tk(a,Vg,Gh){var Hh=0,Ih=0,Jh=0,Kh=0;a:{b:{if((Vg|Gh)<0|Vg>>>0>1431655765){break b}Vg=w(Vg,3);uk(a,Vg,13896);uk(a+12|0,Vg,13900);Vg=q[a+24>>2];c:{if(q[a+32>>2]-Vg>>2>>>0>=Gh>>>0){break c}if(Gh>>>0>=1073741824){break a}Jh=a+28|0;Hh=q[Jh>>2];Ih=Gh<<2;Gh=Mm(Ih);Ih=Gh+Ih|0;Hh=Hh-Vg|0;Kh=Hh+Gh|0;if((Hh|0)>=1){Cn(Gh,Vg,Hh)}q[a+24>>2]=Gh;q[a+32>>2]=Ih;q[Jh>>2]=Kh;if(!Vg){break c}An(Vg)}q[a+80>>2]=0;q[a+84>>2]=0;Gh=a+76|0;Vg=q[Gh>>2];q[Gh>>2]=0;if(Vg){An(Vg)}q[a+68>>2]=0;q[a+72>>2]=0;Vg=a- -64|0;a=q[Vg>>2];q[Vg>>2]=0;Hh=1;if(!a){break b}An(a)}return Hh}ab(13904);F()}function uk(a,Vg,Gh){var Lh=0,Mh=0,Nh=0,Oh=0,Ph=0;Lh=q[a+8>>2];Mh=q[a>>2];if(Lh-Mh>>2>>>0>=Vg>>>0){Nh=q[a+4>>2];Oh=Nh-Mh>>2;Ph=Oh>>>0<Vg>>>0?Oh:Vg;if(Ph){Lh=Mh;while(1){q[Lh>>2]=q[Gh>>2];Lh=Lh+4|0;Ph=Ph+ -1|0;if(Ph){continue}break}}if(Oh>>>0<Vg>>>0){Lh=Vg-Oh|0;while(1){q[Nh>>2]=q[Gh>>2];Nh=Nh+4|0;Lh=Lh+ -1|0;if(Lh){continue}break}q[a+4>>2]=Nh;return}q[a+4>>2]=(Vg<<2)+Mh;return}if(Mh){q[a+4>>2]=Mh;An(Mh);q[a+8>>2]=0;q[a>>2]=0;q[a+4>>2]=0;Lh=0}a:{if(Vg>>>0>=1073741824){break a}Mh=Lh>>1;Mh=Lh>>2>>>0<536870911?Mh>>>0<Vg>>>0?Vg:Mh:1073741823;if(Mh>>>0>=1073741824){break a}Mh=Mh<<2;Lh=Mm(Mh);q[a>>2]=Lh;q[a+4>>2]=Lh;q[a+8>>2]=Lh+Mh;while(1){q[Lh>>2]=q[Gh>>2];Lh=Lh+4|0;Vg=Vg+ -1|0;if(Vg){continue}break}q[a+4>>2]=Lh;return}bn();F()}function vk(a){al(a);q[a+84>>2]=0;q[a+88>>2]=0;q[a>>2]=13980;q[a+92>>2]=0;q[a+96>>2]=0;q[a+100>>2]=0;q[a+104>>2]=0;return a}function wk(a){a=a|0;var Vg=0,Gh=0,Qh=0,Rh=0,Sh=0;q[a>>2]=14380;Vg=q[a+68>>2];if(Vg){q[a+72>>2]=Vg;An(Vg)}Vg=q[a+56>>2];if(Vg){q[a+60>>2]=Vg;An(Vg)}Vg=q[a+44>>2];if(Vg){q[a+48>>2]=Vg;An(Vg)}Vg=q[a+32>>2];if(Vg){q[a+36>>2]=Vg;An(Vg)}Vg=q[a+20>>2];if(Vg){q[a+24>>2]=Vg;An(Vg)}Qh=q[a+8>>2];if(Qh){Vg=Qh;Sh=a+12|0;Gh=q[Sh>>2];Rh=Vg;a:{if((Vg|0)==(Gh|0)){break a}while(1){Gh=Gh+ -4|0;Vg=q[Gh>>2];q[Gh>>2]=0;if(Vg){Hb(Vg)}if((Gh|0)!=(Qh|0)){continue}break}Rh=q[a+8>>2]}Vg=Rh;q[Sh>>2]=Qh;An(Vg)}Vg=q[a+4>>2];q[a+4>>2]=0;if(Vg){Lj(Vg)}return a|0}function xk(a){a=a|0;var Th=0;q[a>>2]=13980;Th=q[a+96>>2];if(Th){q[a+100>>2]=Th;An(Th)}Th=q[a+84>>2];if(Th){q[a+88>>2]=Th;An(Th)}wk(a);return a|0}function yk(a){a=a|0;var Uh=0;q[a>>2]=13980;Uh=q[a+96>>2];if(Uh){q[a+100>>2]=Uh;An(Uh)}Uh=q[a+84>>2];if(Uh){q[a+88>>2]=Uh;An(Uh)}wk(a);An(a)}function zk(a,Vh,Wh){a=a|0;Vh=Vh|0;Wh=Wh|0;var Xh=0,Yh=0;Xh=T-16|0;T=Xh;Yh=q[Wh>>2];q[Wh>>2]=0;q[Xh+8>>2]=Yh;gl(a,Vh,Xh+8|0);Wh=q[Xh+8>>2];q[Xh+8>>2]=0;if(Wh){Hb(Wh)}Yh=q[a+84>>2];Wh=q[a+88>>2]-Yh>>2;a:{if((Wh|0)>(Vh|0)){break a}Vh=Vh+1|0;if(Vh>>>0>Wh>>>0){Ak(a+84|0,Vh-Wh|0);break a}if(Vh>>>0>=Wh>>>0){break a}q[a+88>>2]=Yh+(Vh<<2)}T=Xh+16|0}function Ak(a,Vh){var Wh=0,Zh=0,_h=0,$h=0,ai=0,bi=0;_h=q[a+8>>2];Wh=q[a+4>>2];if(_h-Wh>>2>>>0>=Vh>>>0){while(1){q[Wh>>2]=1;Wh=Wh+4|0;Vh=Vh+ -1|0;if(Vh){continue}break}q[a+4>>2]=Wh;return}a:{$h=q[a>>2];ai=Wh-$h|0;bi=ai>>2;Wh=bi+Vh|0;if(Wh>>>0<1073741824){_h=_h-$h|0;Zh=_h>>1;Wh=_h>>2>>>0<536870911?Zh>>>0<Wh>>>0?Wh:Zh:1073741823;Zh=0;b:{if(!Wh){break b}if(Wh>>>0>=1073741824){break a}Zh=Mm(Wh<<2)}_h=Zh+(Wh<<2)|0;Wh=Zh+(bi<<2)|0;while(1){q[Wh>>2]=1;Wh=Wh+4|0;Vh=Vh+ -1|0;if(Vh){continue}break}if((ai|0)>=1){Cn(Zh,$h,ai)}q[a>>2]=Zh;q[a+8>>2]=_h;q[a+4>>2]=Wh;if($h){An($h)}return}bn();F()}ab(14024);F()}function Bk(a,Vh){a=a|0;Vh=Vh|0;var ci=0,di=0,ei=0;jl(a,Vh);a:{if((Vh|0)<0){break a}ci=q[a+88>>2];di=q[a+84>>2];if(ci-di>>2<=(Vh|0)){break a}Vh=di+(Vh<<2)|0;di=Vh+4|0;ci=ci-di|0;ei=ci>>2;if(ci){En(Vh,di,ci)}q[a+88>>2]=Vh+(ei<<2)}}function Ck(a,Vh){var fi=0,gi=0,hi=0,ii=0,ji=0,ki=0;a:{hi=q[a>>2];ji=q[a+4>>2]-hi|0;fi=ji>>2;gi=fi+1|0;if(gi>>>0<1073741824){ki=fi<<2;fi=q[a+8>>2]-hi|0;ii=fi>>1;gi=fi>>2>>>0<536870911?ii>>>0<gi>>>0?gi:ii:1073741823;fi=0;b:{if(!gi){break b}if(gi>>>0>=1073741824){break a}fi=Mm(gi<<2)}ii=ki+fi|0;q[ii>>2]=q[Vh>>2];Vh=fi+(gi<<2)|0;gi=ii+4|0;if((ji|0)>=1){Cn(fi,hi,ji)}q[a>>2]=fi;q[a+8>>2]=Vh;q[a+4>>2]=gi;if(hi){An(hi)}return}bn();F()}ab(14092);F()}function Dk(a){q[a>>2]=0;q[a+4>>2]=0;o[a+24|0]=1;q[a+16>>2]=0;q[a+20>>2]=0;q[a+8>>2]=0;q[a+12>>2]=0;q[a+28>>2]=0;q[a+32>>2]=0;q[a+36>>2]=0;q[a+40>>2]=0;q[a+44>>2]=0;q[a+48>>2]=0;q[a+52>>2]=0;q[a+56>>2]=0;q[a+60>>2]=0;q[a+64>>2]=0;q[a+72>>2]=0;q[a+76>>2]=0;q[a+80>>2]=0;q[a+84>>2]=0;q[a+88>>2]=0;q[a+92>>2]=0;q[a+68>>2]=a}function Ek(a,Vh){var li=0,mi=0,ni=0,oi=0,pi=0,qi=0,ri=0,si=0;qi=T-16|0;T=qi;a:{b:{if(Vh){q[a+88>>2]=0;q[a+92>>2]=0;li=a+84|0;mi=q[li>>2];q[li>>2]=0;if(mi){An(mi)}q[a+76>>2]=0;q[a+80>>2]=0;li=a+72|0;mi=q[li>>2];q[li>>2]=0;if(mi){An(mi)}mi=Vh+4|0;li=q[mi>>2];ni=q[Vh>>2];o[qi+15|0]=0;bb(a,li-ni>>2,qi+15|0);ni=Vh+28|0;li=q[ni>>2];oi=q[Vh+24>>2];o[qi+14|0]=0;bb(a+12|0,li-oi>>2,qi+14|0);uk(a+28|0,q[mi>>2]-q[Vh>>2]>>2,14160);mi=q[a+52>>2];oi=q[ni>>2]-q[Vh+24>>2]|0;li=oi>>2;c:{if(q[a+60>>2]-mi>>2>>>0>=li>>>0){break c}if(li>>>0>=1073741824){break b}ri=a+56|0;pi=q[ri>>2];si=li<<2;li=Mm(oi);si=si+li|0;oi=pi-mi|0;pi=oi+li|0;if((oi|0)>=1){Cn(li,mi,oi)}q[a+52>>2]=li;q[a+60>>2]=si;q[ri>>2]=pi;if(!mi){break c}An(mi)}mi=q[a+40>>2];ni=q[ni>>2]-q[Vh+24>>2]|0;li=ni>>2;d:{if(q[a+48>>2]-mi>>2>>>0>=li>>>0){break d}if(li>>>0>=1073741824){break a}oi=a+44|0;ri=q[oi>>2];pi=li<<2;li=Mm(ni);pi=pi+li|0;ni=ri-mi|0;ri=ni+li|0;if((ni|0)>=1){Cn(li,mi,ni)}q[a+40>>2]=li;q[a+48>>2]=pi;q[oi>>2]=ri;if(!mi){break d}An(mi)}o[a+24|0]=1;q[a+64>>2]=Vh}T=qi+16|0;return}ab(14164);F()}ab(14164);F()}function Fk(a){var Vh=0,ti=0,ui=0,vi=0,wi=0,xi=0,yi=0,Ai=0,Bi=0,Ci=0,Di=0,Ei=0,Fi=0;ui=T-32|0;T=ui;xi=a+56|0;q[xi>>2]=q[a+52>>2];yi=a+44|0;q[yi>>2]=q[a+40>>2];Vh=q[a+64>>2];if(q[Vh+28>>2]!=q[Vh+24>>2]){Bi=a+40|0;Ci=a+52|0;Di=a+60|0;Ei=a+48|0;while(1){ti=q[q[Vh+24>>2]+(Ai<<2)>>2];a:{if((ti|0)==-1){break a}q[ui+24>>2]=wi;Vh=q[xi>>2];b:{if((Vh|0)!=q[Di>>2]){q[Vh>>2]=wi;q[xi>>2]=Vh+4;break b}Hk(Ci,ui+24|0)}q[ui+16>>2]=ti;q[ui+8>>2]=0;c:{if(!(q[q[a+12>>2]+(Ai>>>3&536870908)>>2]>>>(Ai&31)&1)){break c}d:{Vh=ti+1|0;Vh=(Vh>>>0)%3|0?Vh:ti+ -2|0;if(!((Vh|0)==-1|q[q[a>>2]+(Vh>>>3&536870908)>>2]>>>(Vh&31)&1)){Vh=q[q[q[a+64>>2]+12>>2]+(Vh<<2)>>2];if((Vh|0)!=-1){break d}}q[ui+8>>2]=-1;break c}vi=Vh+1|0;Vh=(vi>>>0)%3|0?vi:Vh+ -2|0;q[ui+8>>2]=Vh;if((Vh|0)==-1){break c}while(1){q[ui+16>>2]=Vh;e:{vi=Vh+1|0;ti=Vh;Vh=(vi>>>0)%3|0?vi:Vh+ -2|0;if(!((Vh|0)==-1|q[q[a>>2]+(Vh>>>3&536870908)>>2]>>>(Vh&31)&1)){Vh=q[q[q[a+64>>2]+12>>2]+(Vh<<2)>>2];if((Vh|0)!=-1){break e}}q[ui+8>>2]=-1;break c}vi=Vh+1|0;Vh=(vi>>>0)%3|0?vi:Vh+ -2|0;q[ui+8>>2]=Vh;if((Vh|0)!=-1){continue}break}}Fi=a+28|0;q[q[Fi>>2]+(ti<<2)>>2]=q[ui+24>>2];Vh=q[yi>>2];f:{if((Vh|0)!=q[Ei>>2]){q[Vh>>2]=q[ui+16>>2];q[yi>>2]=Vh+4;break f}zi(Bi,ui+16|0)}wi=wi+1|0;Vh=q[a+64>>2];g:{vi=q[ui+16>>2];if((vi|0)==-1){break g}ti=vi+((vi>>>0)%3|0?-1:2)|0;if((ti|0)==-1){break g}ti=q[q[Vh+12>>2]+(ti<<2)>>2];if((ti|0)==-1){break g}ti=ti+((ti>>>0)%3|0?-1:2)|0;q[ui+8>>2]=ti;if((ti|0)==-1|(ti|0)==(vi|0)){break a}while(1){Vh=ti+1|0;Vh=(Vh>>>0)%3|0?Vh:ti+ -2|0;h:{if(!(q[q[a>>2]+(Vh>>>3&536870908)>>2]>>>(Vh&31)&1)){break h}q[ui+24>>2]=wi;Vh=q[xi>>2];i:{if((Vh|0)!=q[Di>>2]){q[Vh>>2]=wi;q[xi>>2]=Vh+4;break i}Hk(Ci,ui+24|0)}wi=wi+1|0;Vh=q[yi>>2];if((Vh|0)!=q[Ei>>2]){q[Vh>>2]=q[ui+8>>2];q[yi>>2]=Vh+4;break h}zi(Bi,ui+8|0)}q[q[Fi>>2]+(q[ui+8>>2]<<2)>>2]=q[ui+24>>2];Vh=q[a+64>>2];ti=q[ui+8>>2];if((ti|0)==-1){break g}ti=ti+((ti>>>0)%3|0?-1:2)|0;if((ti|0)==-1){break g}ti=q[q[Vh+12>>2]+(ti<<2)>>2];if((ti|0)==-1){break g}ti=ti+((ti>>>0)%3|0?-1:2)|0;q[ui+8>>2]=ti;if((ti|0)==-1){break a}if(q[ui+16>>2]!=(ti|0)){continue}break}break a}q[ui+8>>2]=-1}Ai=Ai+1|0;if(Ai>>>0<q[Vh+28>>2]-q[Vh+24>>2]>>2>>>0){continue}break}}T=ui+32|0}function Gk(a,zi){var Gi=0,Hi=0,Ii=0,Ji=0,Ki=0,Li=0;Ii=q[a>>2];Gi=Ii+(zi>>>3&536870908)|0;q[Gi>>2]=q[Gi>>2]|1<<(zi&31);Ki=q[a+64>>2];Ji=(zi|0)==-1;Gi=-1;a:{if(Ji){break a}Hi=zi+1|0;Hi=(Hi>>>0)%3|0?Hi:zi+ -2|0;Gi=-1;if((Hi|0)==-1){break a}Gi=q[q[Ki>>2]+(Hi<<2)>>2]}Hi=q[a+12>>2];Li=(Gi>>>3&536870908)+Hi|0;q[Li>>2]=q[Li>>2]|1<<(Gi&31);b:{c:{if(!Ji){Gi=-1;Ji=((zi>>>0)%3|0?-1:2)+zi|0;if((Ji|0)!=-1){Gi=q[q[Ki>>2]+(Ji<<2)>>2]}Ji=Hi+(Gi>>>3&536870908)|0;q[Ji>>2]=q[Ji>>2]|1<<(Gi&31);zi=q[q[Ki+12>>2]+(zi<<2)>>2];if((zi|0)==-1){break b}o[a+24|0]=0;a=(zi>>>3&536870908)+Ii|0;q[a>>2]=q[a>>2]|1<<(zi&31);a=-1;Gi=-1;Ii=zi+1|0;Ii=(Ii>>>0)%3|0?Ii:zi+ -2|0;if((Ii|0)!=-1){Gi=q[q[Ki>>2]+(Ii<<2)>>2]}Ii=Hi+(Gi>>>3&536870908)|0;q[Ii>>2]=q[Ii>>2]|1<<(Gi&31);zi=zi+((zi>>>0)%3|0?-1:2)|0;if((zi|0)!=-1){a=q[q[Ki>>2]+(zi<<2)>>2]}zi=1<<(a&31);a=Hi+(a>>>3&536870908)|0;Gi=q[a>>2];break c}a=Hi+536870908|0;zi=q[Hi+536870908>>2];Gi=-2147483648}q[a>>2]=zi|Gi}}function Hk(a,zi){var Mi=0,Ni=0,Oi=0,Pi=0,Qi=0,Ri=0;a:{Oi=q[a>>2];Qi=q[a+4>>2]-Oi|0;Mi=Qi>>2;Ni=Mi+1|0;if(Ni>>>0<1073741824){Ri=Mi<<2;Mi=q[a+8>>2]-Oi|0;Pi=Mi>>1;Ni=Mi>>2>>>0<536870911?Pi>>>0<Ni>>>0?Ni:Pi:1073741823;Mi=0;b:{if(!Ni){break b}if(Ni>>>0>=1073741824){break a}Mi=Mm(Ni<<2)}Pi=Ri+Mi|0;q[Pi>>2]=q[zi>>2];zi=Mi+(Ni<<2)|0;Ni=Pi+4|0;if((Qi|0)>=1){Cn(Mi,Oi,Qi)}q[a>>2]=Mi;q[a+8>>2]=zi;q[a+4>>2]=Ni;if(Oi){An(Oi)}return}bn();F()}ab(14164);F()}function Ik(a,zi){var Si=0,Ti=0,Ui=0,Vi=0,Wi=0,Xi=0,Yi=0,Zi=0,_i=0,$i=0,aj=0;Ti=T-16|0;T=Ti;a:{Ui=cl(zi);if(!Ui){q[a>>2]=0;break a}Vi=q[zi+100>>2];Zi=q[zi+96>>2];q[Ti+8>>2]=0;q[Ti>>2]=0;q[Ti+4>>2]=0;zi=Vi-Zi|0;Yi=(zi|0)/12|0;b:{if(zi){if(Yi>>>0>=357913942){break b}Wi=Mm(zi);q[Ti>>2]=Wi;q[Ti+4>>2]=Wi;q[Ti+8>>2]=w(Yi,12)+Wi;zi=Dn(Wi,0,zi);Si=Yi;while(1){zi=zi+12|0;Si=Si+ -1|0;if(Si){continue}break}q[Ti+4>>2]=zi}if((Vi|0)!=(Zi|0)){zi=0;$i=r[Ui+84|0];aj=Ui+68|0;while(1){_i=w(zi,12);Si=_i+Zi|0;Ui=q[Si>>2];c:{if($i){Vi=Si+8|0;Si=Si+4|0;break c}Xi=q[aj>>2];Vi=Xi+(q[Si+8>>2]<<2)|0;Ui=q[Xi+(Ui<<2)>>2];Si=Xi+(q[Si+4>>2]<<2)|0}Xi=q[Si>>2];Si=Wi+_i|0;q[Si+8>>2]=q[Vi>>2];q[Si+4>>2]=Xi;q[Si>>2]=Ui;zi=zi+1|0;if(zi>>>0<Yi>>>0){continue}break}}kk(a,Ti);a=q[Ti>>2];if(!a){break a}q[Ti+4>>2]=a;An(a);break a}bn();F()}T=Ti+16|0}function Jk(a,zi,bj){var cj=0,dj=0,ej=0,fj=0,gj=0,hj=0,ij=0,jj=0,kj=0,lj=0,mj=0,nj=0,oj=0,pj=0,qj=0,rj=0;hj=T-16|0;T=hj;gj=w(zi,12)+a|0;ij=gj+12|0;nj=gj+8|0;q[ij>>2]=q[nj>>2];q[hj+8>>2]=(bj|0)==-1?-1:(bj>>>0)/3|0;oj=gj+16|0;pj=a+4|0;ej=bj;while(1){gj=dj;jj=(dj|0)==1;a:{b:{if(!jj){dj=q[hj+8>>2];break b}if((ej|0)==-1){ej=-1;Kk(a,-1);break a}if((ej|0)==-1|(Kk(a,((ej>>>0)%3|0?-1:2)+ej|0)|0)==-1){break a}bj=ej+1|0;cj=(bj>>>0)%3|0?bj:ej+ -2|0;if((cj|0)==-1){break a}bj=cj+1|0;bj=(bj>>>0)%3|0?bj:cj+ -2|0;if((bj|0)==-1){break a}cj=q[q[q[pj>>2]+12>>2]+(bj<<2)>>2];if((cj|0)==-1){break a}bj=cj+1|0;bj=(bj>>>0)%3|0?bj:cj+ -2|0;if((bj|0)==-1){break a}dj=(bj>>>0)/3|0;q[hj+8>>2]=dj}kj=1<<(dj&31);lj=q[a+56>>2]+(dj>>>3&536870908)|0;mj=q[lj>>2];c:{if(kj&mj){break c}fj=0;while(1){q[lj>>2]=kj|mj;cj=q[ij>>2];d:{if((cj|0)!=q[oj>>2]){q[cj>>2]=dj;q[ij>>2]=cj+4;break d}Ck(nj,hj+8|0)}cj=fj+1|0;e:{if(!fj){break e}if(cj&1){if((bj|0)==-1){bj=-1;break e}fj=bj+1|0;bj=(fj>>>0)%3|0?fj:bj+ -2|0;break e}ej=jj?bj:ej;if((bj|0)==-1){bj=-1;break e}if((bj>>>0)%3){bj=bj+ -1|0;break e}bj=bj+2|0}bj=Kk(a,bj);if((bj|0)!=-1){dj=(bj>>>0)/3|0;q[hj+8>>2]=dj;fj=cj;kj=1<<(dj&31);lj=q[a+56>>2]+(dj>>>3&268435452)|0;mj=q[lj>>2];if(!(kj&mj)){continue}}break}if(!(cj&1)|(gj|0)!=1){break c}jj=q[ij>>2]+ -4|0;dj=q[jj>>2];fj=q[a+56>>2]+(dj>>>3&536870908)|0;cj=q[fj>>2];qj=fj,rj=eo(dj)&cj,q[qj>>2]=rj;q[ij>>2]=jj}dj=1;if(!gj){continue}}break}q[((zi<<2)+a|0)+44>>2]=ej;zi=q[ij>>2];ej=q[nj>>2];if((zi|0)!=(ej|0)){fj=zi-ej>>2;cj=q[a+56>>2];bj=0;while(1){gj=q[ej+(bj<<2)>>2];zi=cj+(gj>>>3&536870908)|0;a=q[zi>>2];qj=zi,rj=eo(gj)&a,q[qj>>2]=rj;bj=bj+1|0;if(bj>>>0<fj>>>0){continue}break}}T=hj+16|0}function Kk(a,zi){var bj=0,sj=0,tj=0,uj=0,vj=0;sj=-1;uj=-1;tj=-1;a:{b:{if((zi|0)==-1){break b}vj=1;uj=q[q[q[a+4>>2]+12>>2]+(zi<<2)>>2];bj=zi+1|0;bj=(bj>>>0)%3|0?bj:zi+ -2|0;if((bj|0)>=0){tj=(bj>>>0)/3|0;tj=q[(q[q[a>>2]+96>>2]+w(tj,12)|0)+(bj-w(tj,3)<<2)>>2]}c:{if((uj|0)==-1){break c}vj=0;bj=((uj>>>0)%3|0?-1:2)+uj|0;if((bj|0)<0){break c}sj=(bj>>>0)/3|0;sj=q[(q[q[a>>2]+96>>2]+w(sj,12)|0)+(bj-w(sj,3)<<2)>>2]}bj=-1;if((sj|0)!=(tj|0)){break a}tj=-1;d:{zi=((zi>>>0)%3|0?-1:2)+zi|0;if((zi|0)>=0){sj=(zi>>>0)/3|0;sj=q[(q[q[a>>2]+96>>2]+w(sj,12)|0)+(zi-w(sj,3)<<2)>>2];if(vj){break b}break d}sj=-1;if(!vj){break d}break b}zi=uj+1|0;zi=(zi>>>0)%3|0?zi:uj+ -2|0;if((zi|0)<0){break b}tj=q[q[a>>2]+96>>2];a=(zi>>>0)/3|0;tj=q[(tj+w(a,12)|0)+(zi-w(a,3)<<2)>>2]}bj=(sj|0)==(tj|0)?uj:-1}return bj}function Lk(a,zi){var wj=0,xj=0,yj=0,zj=0,Aj=0,Bj=0,Cj=0,Dj=0,Ej=0,Fj=0,Gj=0;xj=T-48|0;T=xj;q[xj+40>>2]=0;q[xj+32>>2]=0;q[xj+36>>2]=0;wj=Mm(8);q[wj+4>>2]=zi;q[wj>>2]=0;zi=wj+8|0;q[xj+40>>2]=zi;q[xj+36>>2]=zi;q[xj+32>>2]=wj;a:{b:{c:{d:{while(1){zi=zi+ -8|0;Bj=q[zi+4>>2];Gj=q[zi>>2];q[xj+36>>2]=zi;if(Gj){q[xj+24>>2]=0;q[xj+16>>2]=0;q[xj+20>>2]=0;Dj=1;zi=q[a>>2];Aj=q[zi+16>>2];zj=q[zi+12>>2];wj=q[zi+20>>2];e:{if((zj|0)<(wj|0)?1:(zj|0)<=(wj|0)?t[zi+8>>2]>Aj>>>0?0:1:0){break e}yj=r[Aj+q[zi>>2]|0];zj=Aj+1|0;if(zj>>>0<1){wj=wj+1|0}q[zi+16>>2]=zj;q[zi+20>>2]=wj;Wm(xj+16|0,yj);if(yj){zj=q[a>>2];Fj=_m(xj+16|0);Cj=q[zj+12>>2];Aj=q[zj+20>>2];Ej=q[zj+16>>2];zi=yj;wj=Ej+zi|0;if(wj>>>0<zi>>>0){Aj=Aj+1|0}if((Cj|0)<(Aj|0)?1:(Cj|0)<=(Aj|0)?t[zj+8>>2]>=wj>>>0?0:1:0){break e}Cn(Fj,Ej+q[zj>>2]|0,yj);wj=zj;zj=wj;Aj=q[wj+20>>2];yj=zi+q[wj+16>>2]|0;if(yj>>>0<zi>>>0){Aj=Aj+1|0}q[zj+16>>2]=yj;q[wj+20>>2]=Aj}Bj=Mm(24);wj=Bj+4|0;q[wj>>2]=0;q[wj+4>>2]=0;zi=Bj+16|0;q[zi>>2]=0;q[zi+4>>2]=0;q[Bj>>2]=wj;q[Bj+12>>2]=zi;q[xj+8>>2]=Bj;_k(Gj,xj+16|0,xj+8|0);zi=q[xj+8>>2];Dj=0;q[xj+8>>2]=0;if(!zi){break e}Hc(zi+12|0,q[zi+16>>2]);Ic(zi,q[zi+4>>2]);An(zi)}if(o[xj+27|0]<=-1){An(q[xj+16>>2])}if(Dj){break b}}if(!Bj){break b}q[xj+16>>2]=0;if(!Mk(1,xj+16|0,q[a>>2])){break b}zi=0;wj=q[xj+16>>2];if(wj){while(1){if(!Nk(a,Bj)){break b}zi=zi+1|0;if(zi>>>0<wj>>>0){continue}break}}q[xj+4>>2]=0;if(!Mk(1,xj+4|0,q[a>>2])){break b}Aj=q[xj+4>>2];if(Aj){Dj=0;while(1){zi=q[xj+36>>2];wj=q[xj+40>>2];f:{if(zi>>>0<wj>>>0){q[zi+4>>2]=0;q[zi>>2]=Bj;q[xj+36>>2]=q[xj+36>>2]+8;break f}Cj=q[xj+32>>2];Fj=zi-Cj|0;zi=Fj>>3;Ej=zi+1|0;if(Ej>>>0>=536870912){break d}zj=zi<<3;yj=wj-Cj|0;wj=yj>>2;yj=yj>>3>>>0<268435455?wj>>>0<Ej>>>0?Ej:wj:536870911;zi=0;g:{if(!yj){break g}if(yj>>>0>=536870912){break c}zi=Mm(yj<<3)}wj=zj+zi|0;q[wj+4>>2]=0;q[wj>>2]=Bj;yj=zi+(yj<<3)|0;wj=wj+8|0;if((Fj|0)>=1){Cn(zi,Cj,Fj)}q[xj+40>>2]=yj;q[xj+36>>2]=wj;q[xj+32>>2]=zi;if(!Cj){break f}An(Cj)}Dj=Dj+1|0;if(Dj>>>0<Aj>>>0){continue}break}}zi=q[xj+36>>2];wj=q[xj+32>>2];if((zi|0)!=(wj|0)){continue}break}a=1;break a}bn();F()}ab(14232);F()}wj=q[xj+32>>2];a=0}if(wj){q[xj+36>>2]=wj;An(wj)}T=xj+48|0;return a}function Mk(a,zi,Hj){var Ij=0,Jj=0,Kj=0,Lj=0;a:{if(a>>>0>5){break a}Kj=q[Hj+16>>2];Ij=q[Hj+12>>2];Jj=q[Hj+20>>2];if((Ij|0)<(Jj|0)?1:(Ij|0)<=(Jj|0)?t[Hj+8>>2]>Kj>>>0?0:1:0){break a}Ij=r[Kj+q[Hj>>2]|0];Kj=Kj+1|0;if(Kj>>>0<1){Jj=Jj+1|0}q[Hj+16>>2]=Kj;q[Hj+20>>2]=Jj;Jj=zi;if(Ij&128){if(!Mk(a+1|0,zi,Hj)){break a}a=q[zi>>2]<<7;q[zi>>2]=a;Ij=a|Ij&127}q[Jj>>2]=Ij;Lj=1}return Lj}function Nk(a,zi){var Hj=0,Mj=0,Nj=0,Oj=0,Pj=0,Qj=0,Rj=0,Sj=0,Tj=0,Uj=0;Mj=T-32|0;T=Mj;q[Mj+24>>2]=0;q[Mj+16>>2]=0;q[Mj+20>>2]=0;a:{Nj=q[a>>2];Hj=Nj;Pj=q[Hj+16>>2];Qj=t[Hj+8>>2]>Pj>>>0?0:1;Oj=q[Hj+12>>2];Hj=q[Hj+20>>2];b:{if((Oj|0)<(Hj|0)?1:(Oj|0)<=(Hj|0)?Qj:0){break b}Qj=r[Pj+q[Nj>>2]|0];Oj=Hj;Hj=Pj+1|0;if(Hj>>>0<1){Oj=Oj+1|0}q[Nj+16>>2]=Hj;q[Nj+20>>2]=Oj;Wm(Mj+16|0,Qj);if(Qj){Oj=q[a>>2];Sj=_m(Mj+16|0);Uj=q[Oj+12>>2];Pj=q[Oj+20>>2];Tj=q[Oj+16>>2];Nj=Qj;Hj=Tj+Nj|0;if(Hj>>>0<Nj>>>0){Pj=Pj+1|0}if((Uj|0)<(Pj|0)?1:(Uj|0)<=(Pj|0)?t[Oj+8>>2]>=Hj>>>0?0:1:0){break b}Cn(Sj,Tj+q[Oj>>2]|0,Qj);Hj=Oj;Oj=Hj;Pj=q[Hj+20>>2];Qj=Nj+q[Hj+16>>2]|0;if(Qj>>>0<Nj>>>0){Pj=Pj+1|0}q[Oj+16>>2]=Qj;q[Hj+20>>2]=Pj}q[Mj+12>>2]=0;Hj=Mk(1,Mj+12|0,q[a>>2]);Nj=q[Mj+12>>2];if(!Nj|!Hj){break b}q[Mj+8>>2]=0;q[Mj>>2]=0;q[Mj+4>>2]=0;if((Nj|0)<=-1){break a}Rj=Mm(Nj);q[Mj>>2]=Rj;q[Mj+4>>2]=Rj;q[Mj+8>>2]=Nj+Rj;Hj=Nj;while(1){o[Rj|0]=0;Rj=q[Mj+4>>2]+1|0;q[Mj+4>>2]=Rj;Hj=Hj+ -1|0;if(Hj){continue}break}Rj=0;Hj=q[a>>2];a=q[Hj+8>>2];Tj=q[Hj+12>>2];Oj=a;Sj=q[Hj+20>>2];Pj=q[Hj+16>>2];a=Nj;Qj=Pj+Nj|0;if(Qj>>>0<Nj>>>0){Sj=Sj+1|0}if((Tj|0)>(Sj|0)?1:(Tj|0)>=(Sj|0)?Oj>>>0<Qj>>>0?0:1:0){Cn(q[Mj>>2],Pj+q[Hj>>2]|0,Nj);Nj=Hj;Qj=Hj;Oj=q[Hj+20>>2];Hj=a+q[Hj+16>>2]|0;if(Hj>>>0<a>>>0){Oj=Oj+1|0}q[Qj+16>>2]=Hj;q[Nj+20>>2]=Oj;Zk(zi,Mj+16|0,Mj);Rj=1}a=q[Mj>>2];if(!a){break b}q[Mj+4>>2]=a;An(a)}if(o[Mj+27|0]<=-1){An(q[Mj+16>>2])}T=Mj+32|0;return Rj}bn();F()}function Ok(a,zi,Vj){var Wj=0,Xj=0,Yj=0,Zj=0,_j=0;Xj=T-16|0;T=Xj;a:{b:{if(!Vj){break b}q[a>>2]=zi;q[Xj+12>>2]=0;Wj=0;if(!Mk(1,Xj+12|0,zi)){break a}c:{_j=q[Xj+12>>2];if(_j){zi=0;while(1){if(!Mk(1,Xj+8|0,q[a>>2])){break b}Wj=Mm(28);Yj=Wj+4|0;q[Yj>>2]=0;q[Yj+4>>2]=0;Zj=Wj+16|0;q[Zj>>2]=0;q[Zj+4>>2]=0;q[Wj>>2]=Yj;Yj=Wj+12|0;q[Yj>>2]=Zj;q[Wj+24>>2]=q[Xj+8>>2];if(!Lk(a,Wj)){break c}q[Xj>>2]=Wj;Qk(Vj,Xj);Wj=q[Xj>>2];q[Xj>>2]=0;if(Wj){Hc(Wj+12|0,q[Wj+16>>2]);Ic(Wj,q[Wj+4>>2]);An(Wj)}zi=zi+1|0;if(zi>>>0<_j>>>0){continue}break}}Wj=Lk(a,Vj);break a}Hc(Yj,q[Wj+16>>2]);Ic(Wj,q[Wj+4>>2]);An(Wj)}Wj=0}T=Xj+16|0;return Wj}function Pk(a,zi,Vj){var $j=0,ak=0,bk=0,ck=0,dk=0,ek=0,fk=0,gk=0,hk=0,ik=0,jk=0,kk=0;$j=T-16|0;T=$j;ck=q[a+24>>2];hk=q[a+28>>2];a:{if((ck|0)!=(hk|0)){jk=$j+8|0;kk=Vj+4|0;while(1){q[jk>>2]=0;q[$j>>2]=0;q[$j+4>>2]=0;a=Yk(q[ck>>2],zi,$j);dk=r[$j+11|0];gk=dk<<24>>24;b:{c:{d:{if(!a){a=3;break d}a=0;ak=r[Vj+11|0];bk=ak<<24>>24;fk=(gk|0)<0?q[$j+4>>2]:dk;if((fk|0)!=(((bk|0)<0?q[kk>>2]:ak)|0)){break d}ek=(bk|0)<0?q[Vj>>2]:Vj;bk=q[$j>>2];ak=(gk|0)<0;e:{if(!ak){if(!fk){break e}ak=$j;if(r[ek|0]!=(bk&255)){break d}while(1){dk=dk+ -1|0;if(!dk){break e}bk=r[ek+1|0];ek=ek+1|0;ak=ak+1|0;if((bk|0)==r[ak|0]){continue}break}break d}if(!fk){break e}if(cm(ak?bk:$j,ek,fk)){break c}}ik=q[ck>>2];a=1}if((gk|0)>-1){break b}}An(q[$j>>2])}if(a>>>0>3){break a}f:{switch(a-1|0){case 0:case 1:break a;default:break f}}ck=ck+4|0;if((hk|0)!=(ck|0)){continue}break}}ik=0}T=$j+16|0;return ik}function Qk(a,zi){var Vj=0,lk=0,mk=0;lk=q[zi>>2];if(!lk){return}Vj=a+28|0;mk=q[Vj>>2];if(mk>>>0<t[a+32>>2]){q[zi>>2]=0;q[mk>>2]=lk;q[Vj>>2]=q[Vj>>2]+4;return}Rk(a+24|0,zi)}function Rk(a,zi){var nk=0,ok=0,pk=0,qk=0,rk=0;a:{b:{c:{pk=q[a>>2];qk=q[a+4>>2]-pk>>2;nk=qk+1|0;if(nk>>>0<1073741824){pk=q[a+8>>2]-pk|0;rk=pk>>1;nk=pk>>2>>>0<536870911?rk>>>0<nk>>>0?nk:rk:1073741823;if(nk){if(nk>>>0>=1073741824){break c}ok=Mm(nk<<2)}pk=q[zi>>2];q[zi>>2]=0;zi=(qk<<2)+ok|0;q[zi>>2]=pk;pk=(nk<<2)+ok|0;qk=zi+4|0;nk=q[a+4>>2];ok=q[a>>2];if((nk|0)==(ok|0)){break b}while(1){nk=nk+ -4|0;rk=q[nk>>2];q[nk>>2]=0;zi=zi+ -4|0;q[zi>>2]=rk;if((nk|0)!=(ok|0)){continue}break}ok=q[a+4>>2];nk=q[a>>2];break a}bn();F()}ab(14300);F()}nk=ok}q[a>>2]=zi;q[a+8>>2]=pk;q[a+4>>2]=qk;if((nk|0)!=(ok|0)){while(1){ok=ok+ -4|0;a=q[ok>>2];q[ok>>2]=0;if(a){Hc(a+12|0,q[a+16>>2]);Ic(a,q[a+4>>2]);An(a)}if((nk|0)!=(ok|0)){continue}break}}if(nk){An(nk)}}function Sk(a,zi,sk,tk){var uk=0,vk=0,wk=0,xk=0;uk=T-16|0;T=uk;xk=a;vk=ph(zi,uk+12|0,sk);sk=q[vk>>2];if(sk){zi=0}else{sk=Mm(32);Rm(sk+16|0,q[tk>>2]);q[sk+28>>2]=0;q[sk+8>>2]=q[uk+12>>2];q[sk>>2]=0;q[sk+4>>2]=0;q[vk>>2]=sk;tk=sk;wk=q[q[zi>>2]>>2];if(wk){q[zi>>2]=wk;tk=q[vk>>2]}nh(q[zi+4>>2],tk);zi=zi+8|0;q[zi>>2]=q[zi>>2]+1;zi=1}o[xk+4|0]=zi;q[a>>2]=sk;T=uk+16|0}function Tk(a,zi){var sk=0,tk=0,yk=0;sk=q[zi+4>>2];a:{if(!sk){tk=q[zi+8>>2];if(q[tk>>2]==(zi|0)){break a}yk=zi+8|0;while(1){sk=q[yk>>2];yk=sk+8|0;tk=q[sk+8>>2];if((sk|0)!=q[tk>>2]){continue}break}break a}while(1){tk=sk;sk=q[sk>>2];if(sk){continue}break}}if(q[a>>2]==(zi|0)){q[a>>2]=tk}tk=a+8|0;q[tk>>2]=q[tk>>2]+ -1;$k(q[a+4>>2],zi);a=q[zi+28>>2];if(a){q[zi+32>>2]=a;An(a)}if(o[zi+27|0]<=-1){An(q[zi+16>>2])}An(zi)}function Uk(a,zi,zk){var Ak=0,Bk=0,Ck=0,Dk=0,Ek=0;Ak=Mm(40);o[a+8|0]=0;q[a+4>>2]=zi+4;q[a>>2]=Ak;zi=zk+8|0;q[Ak+24>>2]=q[zi>>2];Bk=q[zk+4>>2];q[Ak+16>>2]=q[zk>>2];q[Ak+20>>2]=Bk;q[zk>>2]=0;q[zk+4>>2]=0;q[zi>>2]=0;q[Ak+36>>2]=0;q[Ak+28>>2]=0;q[Ak+32>>2]=0;Ck=zk+16|0;Bk=q[Ck>>2];zi=q[zk+12>>2];Dk=Bk-zi|0;if(Dk){zi=Ak+28|0;Ha(zi,Dk);Bk=q[Ck>>2];Ek=q[zi>>2];zi=q[zk+12>>2]}Cn(Ek,zi,Bk-zi|0);o[a+8|0]=1}function Vk(a,zi,zk){var Fk=0;Fk=a+4|0;a=fk(a,zi);a:{if((Fk|0)==(a|0)){break a}zi=q[a+32>>2];a=q[a+28>>2];if((zi-a|0)!=4){break a}q[zk>>2]=r[a|0]|r[a+1|0]<<8|(r[a+2|0]<<16|r[a+3|0]<<24)}}function Wk(a,zi,zk){var Gk=0,Hk=0,Ik=0,Jk=0;a:{zi=fk(a,zi);b:{if((zi|0)==(a+4|0)){break b}a=q[zi+28>>2];Gk=q[zi+32>>2];if((a|0)==(Gk|0)){break b}a=Gk-a|0;if(a&3){break b}Gk=a>>>2;Jk=zk+4|0;Hk=q[Jk>>2];a=q[zk>>2];Ik=Hk-a>>2;c:{if(Gk>>>0>Ik>>>0){Fa(zk,Gk-Ik|0);Hk=q[Jk>>2];a=q[zk>>2];break c}if(Gk>>>0>=Ik>>>0){break c}Hk=(Gk<<2)+a|0;q[zk+4>>2]=Hk}if((a|0)==(Hk|0)){break a}zk=a;a=q[zi+28>>2];Cn(zk,a,q[zi+32>>2]-a|0)}return}cn();F()}function Xk(a,zi,zk){var Kk=0;Kk=a+4|0;a=fk(a,zi);a:{if((Kk|0)==(a|0)){break a}zi=q[a+32>>2];a=q[a+28>>2];if((zi-a|0)!=8){break a}zi=r[a+4|0]|r[a+5|0]<<8|(r[a+6|0]<<16|r[a+7|0]<<24);q[zk>>2]=r[a|0]|r[a+1|0]<<8|(r[a+2|0]<<16|r[a+3|0]<<24);q[zk+4>>2]=zi}}function Yk(a,zi,zk){var Lk=0,Mk=0,Nk=0;Lk=a+4|0;a=fk(a,zi);a:{if((Lk|0)==(a|0)){break a}zi=a+32|0;Lk=q[zi>>2];Mk=q[a+28>>2];if((Lk|0)==(Mk|0)){break a}Wm(zk,Lk-Mk|0);zk=_m(zk);a=q[a+28>>2];Cn(zk,a,q[zi>>2]-a|0);Nk=1}return Nk}function Zk(a,zi,zk){var Ok=0,Pk=0,Qk=0,Rk=0;Ok=T+ -64|0;T=Ok;Pk=fk(a,zi);if((Pk|0)!=(a+4|0)){Tk(a,Pk)}Pk=0;q[Ok+16>>2]=0;q[Ok+8>>2]=0;q[Ok+12>>2]=0;Rk=q[zk>>2];Qk=q[zk+4>>2]-Rk|0;if(Qk){Ha(Ok+8|0,Qk);Rk=q[zk>>2];zk=q[Ok+8>>2]}else{zk=0}Cn(zk,Rk,Qk);Rk=Rm(Ok+24|0,zi);q[Ok+44>>2]=0;q[Ok+36>>2]=0;q[Ok+40>>2]=0;zi=q[Ok+12>>2];zk=q[Ok+8>>2];Qk=zi-zk|0;if(Qk){Ha(Ok+36|0,Qk);zk=q[Ok+8>>2];Pk=q[Ok+36>>2];zi=q[Ok+12>>2]}Cn(Pk,zk,zi-zk|0);zi=ph(a,Ok+60|0,Rk);if(!q[zi>>2]){Uk(Ok+48|0,a,Ok+24|0);zk=q[Ok+48>>2];q[zk+8>>2]=q[Ok+60>>2];q[zk>>2]=0;q[zk+4>>2]=0;q[zi>>2]=zk;Pk=q[q[a>>2]>>2];if(Pk){q[a>>2]=Pk;zk=q[zi>>2]}nh(q[a+4>>2],zk);a=a+8|0;q[a>>2]=q[a>>2]+1}a=q[Ok+36>>2];if(a){q[Ok+40>>2]=a;An(a)}if(o[Ok+35|0]<=-1){An(q[Ok+24>>2])}a=q[Ok+8>>2];if(a){q[Ok+12>>2]=a;An(a)}T=Ok- -64|0}function _k(a,zi,zk){var Tk=0,Uk=0;Tk=T-32|0;T=Tk;Uk=a+12|0;a:{if((fk(Uk,zi)|0)!=(a+16|0)){break a}q[Tk+16>>2]=zi;Sk(Tk+24|0,Uk,zi,Tk+16|0);a=q[Tk+24>>2];zi=q[zk>>2];q[zk>>2]=0;zk=a+28|0;a=q[zk>>2];q[zk>>2]=zi;if(!a){break a}Hc(a+12|0,q[a+16>>2]);Ic(a,q[a+4>>2]);An(a)}T=Tk+32|0}function $k(a,zi){var zk=0,Sk=0,Vk=0,Wk=0,Xk=0,Yk=0;a:{b:{Sk=zi;Vk=q[zi>>2];if(Vk){zk=q[zi+4>>2];if(!zk){break b}while(1){Sk=zk;zk=q[zk>>2];if(zk){continue}break}}Vk=q[Sk+4>>2];if(Vk){break b}Vk=0;Xk=0;break a}q[Vk+8>>2]=q[Sk+8>>2];Xk=1}Wk=q[Sk+8>>2];zk=q[Wk>>2];c:{if((zk|0)==(Sk|0)){q[Wk>>2]=Vk;if((a|0)==(Sk|0)){zk=0;a=Vk;break c}zk=q[Wk+4>>2];break c}q[Wk+4>>2]=Vk}d:{e:{f:{Yk=!r[Sk+12|0];if((zi|0)!=(Sk|0)){Wk=q[zi+8>>2];q[Sk+8>>2]=Wk;q[Wk+((q[q[zi+8>>2]>>2]!=(zi|0))<<2)>>2]=Sk;Wk=q[zi>>2];q[Sk>>2]=Wk;q[Wk+8>>2]=Sk;Wk=q[zi+4>>2];q[Sk+4>>2]=Wk;if(Wk){q[Wk+8>>2]=Sk}o[Sk+12|0]=r[zi+12|0];a=(a|0)==(zi|0)?Sk:a}if(!(Yk|!a)){if(!Xk){while(1){zi=r[zk+12|0];g:{Vk=q[zk+8>>2];if(q[Vk>>2]!=(zk|0)){if(!zi){o[zk+12|0]=1;o[Vk+12|0]=0;zi=Vk+4|0;Xk=q[zi>>2];Sk=q[Xk>>2];q[zi>>2]=Sk;if(Sk){q[Sk+8>>2]=Vk}q[Xk+8>>2]=q[Vk+8>>2];zi=q[Vk+8>>2];q[((Vk|0)==q[zi>>2]?zi:zi+4|0)>>2]=Xk;q[Xk>>2]=Vk;q[Vk+8>>2]=Xk;zi=q[zk>>2];a=(zi|0)==(a|0)?zk:a;zk=q[zi+4>>2]}Sk=q[zk>>2];if(!(r[Sk+12|0]?0:Sk)){zi=q[zk+4>>2];if(r[zi+12|0]?0:zi){break f}o[zk+12|0]=0;zk=q[zk+8>>2];h:{if((zk|0)==(a|0)){zk=a;break h}if(r[zk+12|0]){break g}}o[zk+12|0]=1;return}zi=q[zk+4>>2];if(zi){break f}break e}i:{if(zi){zi=zk;break i}o[zk+12|0]=1;o[Vk+12|0]=0;zi=q[zk+4>>2];q[Vk>>2]=zi;if(zi){q[zi+8>>2]=Vk}q[zk+8>>2]=q[Vk+8>>2];Sk=q[Vk+8>>2];j:{if((Vk|0)==q[Sk>>2]){q[Sk>>2]=zk;zi=q[Vk>>2];break j}q[Sk+4>>2]=zk}q[zk+4>>2]=Vk;q[Vk+8>>2]=zk;a=(a|0)==(Vk|0)?zk:a}Sk=q[zi>>2];k:{if(!(!Sk|r[Sk+12|0])){zk=zi;break k}zk=q[zi+4>>2];if(!(r[zk+12|0]?0:zk)){o[zi+12|0]=0;zk=q[zi+8>>2];if(r[zk+12|0]?(zk|0)!=(a|0):0){break g}o[zk+12|0]=1;return}if(Sk){if(!r[Sk+12|0]){zk=zi;break k}zk=q[zi+4>>2]}o[zk+12|0]=1;o[zi+12|0]=0;a=q[zk>>2];q[zi+4>>2]=a;if(a){q[a+8>>2]=zi}q[zk+8>>2]=q[zi+8>>2];a=q[zi+8>>2];q[(q[a>>2]==(zi|0)?a:a+4|0)>>2]=zk;q[zk>>2]=zi;q[zi+8>>2]=zk;Sk=zi}a=zk;zk=q[zk+8>>2];o[a+12|0]=r[zk+12|0];o[zk+12|0]=1;o[Sk+12|0]=1;zi=q[zk>>2];a=q[zi+4>>2];q[zk>>2]=a;if(a){q[a+8>>2]=zk}q[zi+8>>2]=q[zk+8>>2];a=q[zk+8>>2];q[((zk|0)==q[a>>2]?a:a+4|0)>>2]=zi;q[zi+4>>2]=zk;q[zk+8>>2]=zi;return}zi=q[zk+8>>2];zk=q[(q[zi>>2]==(zk|0)?zi+4|0:zi)>>2];continue}}o[Vk+12|0]=1}return}if(r[zi+12|0]){break e}Sk=zk;break d}o[Sk+12|0]=1;o[zk+12|0]=0;a=q[Sk+4>>2];q[zk>>2]=a;if(a){q[a+8>>2]=zk}q[Sk+8>>2]=q[zk+8>>2];a=q[zk+8>>2];q[(q[a>>2]==(zk|0)?a:a+4|0)>>2]=Sk;q[Sk+4>>2]=zk;q[zk+8>>2]=Sk;zi=zk}zk=q[Sk+8>>2];o[Sk+12|0]=r[zk+12|0];o[zk+12|0]=1;o[zi+12|0]=1;zi=q[zk+4>>2];a=q[zi>>2];q[zk+4>>2]=a;if(a){q[a+8>>2]=zk}q[zi+8>>2]=q[zk+8>>2];a=q[zk+8>>2];q[((zk|0)==q[a>>2]?a:a+4|0)>>2]=zi;q[zi>>2]=zk;q[zk+8>>2]=zi}function al(a){q[a>>2]=14380;Dn(a+4|0,0,80);return a}function bl(a,zi){var Zk=0;Zk=-1;a:{if((zi|0)==-1|(zi|0)>4){break a}zi=w(zi,12)+a|0;a=q[zi+20>>2];if((q[zi+24>>2]-a|0)<1){break a}Zk=q[a>>2]}return Zk}function cl(a){var zi=0,_k=0;zi=q[a+20>>2];a:{if((q[a+24>>2]-zi|0)<1){break a}zi=q[zi>>2];if((zi|0)==-1){break a}_k=q[q[a+8>>2]+(zi<<2)>>2]}return _k}function dl(a,$k){var al=0,bl=0,cl=0;al=q[a+8>>2];a=q[a+12>>2];a:{if((al|0)==(a|0)){break a}cl=a-al>>2;a=0;while(1){bl=q[(a<<2)+al>>2];if(q[bl+60>>2]==($k|0)){break a}a=a+1|0;if(a>>>0<cl>>>0){continue}break}bl=0}return bl}function el(a,$k){var dl=0,el=0;dl=q[a+8>>2];a=q[a+12>>2];if((dl|0)!=(a|0)){el=a-dl>>2;a=0;while(1){if(q[q[(a<<2)+dl>>2]+60>>2]==($k|0)){return a}a=a+1|0;if(a>>>0<el>>>0){continue}break}}return-1}function fl(a,$k){var fl=0,gl=0,hl=0,il=0,jl=0;fl=T-16|0;T=fl;gl=a+12|0;hl=q[gl>>2];il=q[a+8>>2];jl=q[$k>>2];q[$k>>2]=0;q[fl+8>>2]=jl;n[q[q[a>>2]+8>>2]](a,hl-il>>2,fl+8|0);$k=q[fl+8>>2];q[fl+8>>2]=0;if($k){Hb($k)}T=fl+16|0;return(q[gl>>2]-q[a+8>>2]>>2)+ -1|0}function gl(a,$k,kl){a=a|0;$k=$k|0;kl=kl|0;var ll=0,ml=0,nl=0,ol=0,pl=0,ql=0;ol=T-16|0;T=ol;q[ol+12>>2]=$k;pl=a+8|0;ll=q[a+12>>2];ql=q[a+8>>2];ml=ll-ql>>2;a:{if((ml|0)>($k|0)){break a}nl=$k+1|0;if(nl>>>0>ml>>>0){hl(pl,nl-ml|0);break a}if(nl>>>0>=ml>>>0){break a}ml=ql+(nl<<2)|0;if((ml|0)!=(ll|0)){while(1){ll=ll+ -4|0;nl=q[ll>>2];q[ll>>2]=0;if(nl){Hb(nl)}if((ll|0)!=(ml|0)){continue}break}}q[a+12>>2]=ml}ll=q[q[kl>>2]+56>>2];b:{if((ll|0)>4){break b}ll=w(ll,12)+a|0;ml=ll+24|0;a=q[ml>>2];if((a|0)!=q[ll+28>>2]){q[a>>2]=$k;q[ml>>2]=a+4;break b}il(ll+20|0,ol+12|0)}$k=q[kl>>2];a=q[ol+12>>2];q[$k+60>>2]=a;ll=q[pl>>2];q[kl>>2]=0;kl=ll+(a<<2)|0;a=q[kl>>2];q[kl>>2]=$k;if(a){Hb(a)}T=ol+16|0}function hl(a,$k){var kl=0,rl=0,sl=0,tl=0,ul=0,vl=0,wl=0,xl=0,yl=0;rl=q[a+8>>2];sl=a+4|0;kl=q[sl>>2];if(rl-kl>>2>>>0>=$k>>>0){a=$k<<2;xl=sl,yl=Dn(kl,0,a)+a|0,q[xl>>2]=yl;return}a:{sl=q[a>>2];tl=kl-sl>>2;ul=tl+$k|0;if(ul>>>0<1073741824){tl=tl<<2;rl=rl-sl|0;wl=rl>>1;rl=rl>>2>>>0<536870911?wl>>>0<ul>>>0?ul:wl:1073741823;if(rl){if(rl>>>0>=1073741824){break a}vl=Mm(rl<<2)}tl=tl+vl|0;Dn(tl,0,$k<<2);$k=(ul<<2)+vl|0;ul=(rl<<2)+vl|0;if((kl|0)!=(sl|0)){while(1){kl=kl+ -4|0;rl=q[kl>>2];q[kl>>2]=0;tl=tl+ -4|0;q[tl>>2]=rl;if((kl|0)!=(sl|0)){continue}break}sl=q[a>>2];kl=q[a+4>>2]}q[a>>2]=tl;q[a+8>>2]=ul;q[a+4>>2]=$k;if((kl|0)!=(sl|0)){while(1){kl=kl+ -4|0;a=q[kl>>2];q[kl>>2]=0;if(a){Hb(a)}if((kl|0)!=(sl|0)){continue}break}}if(sl){An(sl)}return}bn();F()}ab(14428);F()}function il(a,$k){var zl=0,Al=0,Bl=0,Cl=0,Dl=0,El=0;a:{Bl=q[a>>2];Dl=q[a+4>>2]-Bl|0;zl=Dl>>2;Al=zl+1|0;if(Al>>>0<1073741824){El=zl<<2;zl=q[a+8>>2]-Bl|0;Cl=zl>>1;Al=zl>>2>>>0<536870911?Cl>>>0<Al>>>0?Al:Cl:1073741823;zl=0;b:{if(!Al){break b}if(Al>>>0>=1073741824){break a}zl=Mm(Al<<2)}Cl=El+zl|0;q[Cl>>2]=q[$k>>2];$k=zl+(Al<<2)|0;Al=Cl+4|0;if((Dl|0)>=1){Cn(zl,Bl,Dl)}q[a>>2]=zl;q[a+8>>2]=$k;q[a+4>>2]=Al;if(Bl){An(Bl)}return}bn();F()}ab(14428);F()}function jl(a,$k){a=a|0;$k=$k|0;var Fl=0,Gl=0,Hl=0,Il=0,Jl=0,Kl=0,Ll=0;a:{if(($k|0)<0){break a}Fl=q[a+12>>2];Gl=q[a+8>>2];if(Fl-Gl>>2>>>0<=$k>>>0){break a}Gl=Gl+($k<<2)|0;Hl=q[Gl>>2];Kl=q[Hl+60>>2];Il=q[Hl+56>>2];Hl=Gl+4|0;b:{if((Hl|0)!=(Fl|0)){while(1){Ll=q[Hl>>2];q[Hl>>2]=0;Jl=q[Gl>>2];q[Gl>>2]=Ll;if(Jl){Hb(Jl)}Gl=Gl+4|0;Hl=Hl+4|0;if((Hl|0)!=(Fl|0)){continue}break}Fl=q[a+12>>2];if((Gl|0)==(Fl|0)){break b}}while(1){Fl=Fl+ -4|0;Hl=q[Fl>>2];q[Fl>>2]=0;if(Hl){Hb(Hl)}if((Fl|0)!=(Gl|0)){continue}break}}q[a+12>>2]=Gl;Fl=q[a+4>>2];if(Fl){kl(Fl,Kl)}c:{if((Il|0)>4){break c}d:{Gl=w(Il,12)+a|0;Fl=q[Gl+20>>2];Hl=Gl+24|0;Gl=q[Hl>>2];if((Fl|0)==(Gl|0)){break d}while(1){if(q[Fl>>2]==($k|0)){break d}Fl=Fl+4|0;if((Gl|0)!=(Fl|0)){continue}break}break c}if((Fl|0)==(Gl|0)){break c}Il=Fl+4|0;Gl=Gl-Il|0;Jl=Gl>>2;if(Gl){En(Fl,Il,Gl)}q[Hl>>2]=(Jl<<2)+Fl}Fl=q[a+24>>2];Gl=q[a+20>>2];if((Fl|0)!=(Gl|0)){Hl=Fl-Gl>>2;Fl=0;while(1){Il=Gl+(Fl<<2)|0;Jl=q[Il>>2];if((Jl|0)>($k|0)){q[Il>>2]=Jl+ -1}Fl=Fl+1|0;if(Fl>>>0<Hl>>>0){continue}break}}Fl=q[a+36>>2];Gl=q[a+32>>2];if((Fl|0)!=(Gl|0)){Hl=Fl-Gl>>2;Fl=0;while(1){Il=Gl+(Fl<<2)|0;Jl=q[Il>>2];if((Jl|0)>($k|0)){q[Il>>2]=Jl+ -1}Fl=Fl+1|0;if(Fl>>>0<Hl>>>0){continue}break}}Fl=q[a+48>>2];Gl=q[a+44>>2];if((Fl|0)!=(Gl|0)){Hl=Fl-Gl>>2;Fl=0;while(1){Il=Gl+(Fl<<2)|0;Jl=q[Il>>2];if((Jl|0)>($k|0)){q[Il>>2]=Jl+ -1}Fl=Fl+1|0;if(Fl>>>0<Hl>>>0){continue}break}}Fl=q[a+60>>2];Gl=q[a+56>>2];if((Fl|0)!=(Gl|0)){Hl=Fl-Gl>>2;Fl=0;while(1){Il=Gl+(Fl<<2)|0;Jl=q[Il>>2];if((Jl|0)>($k|0)){q[Il>>2]=Jl+ -1}Fl=Fl+1|0;if(Fl>>>0<Hl>>>0){continue}break}}Fl=q[a+72>>2];a=q[a+68>>2];if((Fl|0)==(a|0)){break a}Gl=Fl-a>>2;Fl=0;while(1){Hl=a+(Fl<<2)|0;Il=q[Hl>>2];if((Il|0)>($k|0)){q[Hl>>2]=Il+ -1}Fl=Fl+1|0;if(Fl>>>0<Gl>>>0){continue}break}}}function kl(a,$k){var Ml=0,Nl=0,Ol=0,Pl=0;a:{if(($k|0)<0){break a}Ml=q[a+28>>2];Ol=q[a+24>>2];while(1){Nl=Ol;if((Ml|0)==(Nl|0)){break a}Ol=Nl+4|0;if(q[q[Nl>>2]+24>>2]!=($k|0)){continue}break}b:{if((Ml|0)!=(Ol|0)){while(1){$k=q[Ol>>2];q[Ol>>2]=0;Pl=q[Nl>>2];q[Nl>>2]=$k;if(Pl){Hc(Pl+12|0,q[Pl+16>>2]);Ic(Pl,q[Pl+4>>2]);An(Pl)}Nl=Nl+4|0;Ol=Ol+4|0;if((Ml|0)!=(Ol|0)){continue}break}Ml=q[a+28>>2];if((Ml|0)==(Nl|0)){break b}}while(1){Ml=Ml+ -4|0;$k=q[Ml>>2];q[Ml>>2]=0;if($k){Hc($k+12|0,q[$k+16>>2]);Ic($k,q[$k+4>>2]);An($k)}if((Nl|0)!=(Ml|0)){continue}break}}q[a+28>>2]=Nl}}function ll(a){a=a|0;An(wk(a))}function ml(a,$k,Ql){return(q[a+12>>2]+ -1|0)==(Ql|0)?0:Ql+1|0}function nl(a,$k,Ql){var Rl=0,Sl=0,Tl=0;a:{if($k>>>0<=63){$k=0;Rl=q[a+12>>2];if(Rl>>>0<2){break a}Ql=q[Ql>>2];a=1;while(1){$k=t[Ql+($k<<2)>>2]>t[Ql+(a<<2)>>2]?a:$k;a=a+1|0;if(a>>>0<Rl>>>0){continue}break}break a}$k=q[a+580>>2];Rl=32-$k|0;if((Rl|0)>=4){Ql=q[a+576>>2];if((Ql|0)==q[a+568>>2]){return 0}Rl=q[Ql>>2];Sl=$k+4|0;q[a+580>>2]=Sl;$k=Rl<<$k>>>28;if((Sl|0)!=32){break a}q[a+580>>2]=0;q[a+576>>2]=Ql+4;return $k}Ql=q[a+576>>2];Sl=Ql+4|0;if((Sl|0)==q[a+568>>2]){return 0}Tl=q[Ql>>2];q[a+576>>2]=Sl;q[a+580>>2]=$k+ -28;a=60-$k|0;$k=q[Ql+4>>2]>>>a|Tl<<$k>>>a-Rl}return $k}function ol(a,$k,Ql){var Ul=0,Vl=0,Wl=0,Xl=0,Zl=0,_l=0,$l=0,am=0,bm=0;Zl=T-672|0;T=Zl;Vl=q[$k+12>>2];a:{Xl=q[$k+20>>2];Wl=q[$k+16>>2];Ul=Wl+4|0;if(Ul>>>0<4){Xl=Xl+1|0}b:{if((Vl|0)<(Xl|0)?1:(Vl|0)<=(Xl|0)?t[$k+8>>2]>=Ul>>>0?0:1:0){break b}Ul=Wl+q[$k>>2]|0;$l=r[Ul|0]|r[Ul+1|0]<<8|(r[Ul+2|0]<<16|r[Ul+3|0]<<24);q[a>>2]=$l;Ul=q[$k+20>>2];Vl=Ul;am=q[$k+16>>2];Xl=am+4|0;if(Xl>>>0<4){Ul=Ul+1|0}q[$k+16>>2]=Xl;q[$k+20>>2]=Ul;if($l>>>0>31){break b}Wl=q[$k+12>>2];Ul=am+8|0;if(Ul>>>0<8){Vl=Vl+1|0}if((Wl|0)<(Vl|0)?1:(Wl|0)<=(Vl|0)?t[$k+8>>2]>=Ul>>>0?0:1:0){break b}Ul=Xl+q[$k>>2]|0;q[a+4>>2]=r[Ul|0]|r[Ul+1|0]<<8|(r[Ul+2|0]<<16|r[Ul+3|0]<<24);Ul=q[$k+20>>2];Vl=Ul;am=q[$k+16>>2];Xl=am+4|0;if(Xl>>>0<4){Ul=Ul+1|0}q[$k+16>>2]=Xl;q[$k+20>>2]=Ul;$l=q[$k+12>>2];Ul=Vl;Wl=am+8|0;if(Wl>>>0<8){Ul=Ul+1|0}if(($l|0)<(Ul|0)?1:($l|0)<=(Ul|0)?t[$k+8>>2]>=Wl>>>0?0:1:0){break b}Ul=Xl+q[$k>>2]|0;$l=r[Ul|0]|r[Ul+1|0]<<8|(r[Ul+2|0]<<16|r[Ul+3|0]<<24);q[a+12>>2]=$l;Vl=q[$k+20>>2];Wl=Vl;Ul=$k;bm=Ul;am=q[Ul+16>>2];Xl=am+4|0;if(Xl>>>0<4){Vl=Vl+1|0}q[bm+16>>2]=Xl;q[Ul+20>>2]=Vl;Ul=q[a+20>>2];if((Ul|0)!=($l|0)?Ul:0){break b}Vl=q[$k+12>>2];Ul=Wl;Wl=am+8|0;if(Wl>>>0<8){Ul=Ul+1|0}if((Vl|0)<(Ul|0)?1:(Vl|0)<=(Ul|0)?t[$k+8>>2]>=Wl>>>0?0:1:0){break b}Ul=Xl+q[$k>>2]|0;Vl=r[Ul|0]|r[Ul+1|0]<<8|(r[Ul+2|0]<<16|r[Ul+3|0]<<24);q[a+16>>2]=Vl;Ul=$k;bm=Ul;Xl=q[Ul+20>>2];Wl=q[Ul+16>>2]+4|0;if(Wl>>>0<4){Xl=Xl+1|0}q[bm+16>>2]=Wl;q[Ul+20>>2]=Xl;if(Vl>>>0>=7){q[Zl>>2]=Vl;Yl(14496,Zl);break b}q[Zl+664>>2]=Ql;c:{if(!$l){break c}Vl=q[Ql>>2];d:{if((q[Ql+8>>2]-Vl|0)/12>>>0>=$l>>>0){break d}if($l>>>0>=357913942){break a}am=Ql+4|0;_l=q[am>>2];Ul=w($l,12);Wl=Mm(Ul);Xl=Ul+Wl|0;Ul=Wl+w((_l-Vl|0)/12|0,12)|0;e:{if((Vl|0)==(_l|0)){Wl=Ul;break e}Wl=Ul;while(1){Wl=Wl+ -12|0;_l=_l+ -12|0;q[Wl>>2]=q[_l>>2];q[Wl+4>>2]=q[_l+4>>2];q[Wl+8>>2]=q[_l+8>>2];if((Vl|0)!=(_l|0)){continue}break}_l=Vl}q[Ql>>2]=Wl;q[Ql+8>>2]=Xl;q[am>>2]=Ul;if(!_l){break d}An(_l)}Ul=q[a+16>>2];if(Ul>>>0>6){_l=0;break b}f:{switch(Ul-1|0){default:Ul=Od(Zl+8|0,3);pl(Ul,$k,Zl+664|0);Nd(Ul);break c;case 0:Ul=Od(Zl+8|0,3);ql(Ul,$k,Zl+664|0);Nd(Ul);break c;case 1:Ul=Sd(Zl+8|0,3);rl(Ul,$k,Zl+664|0);Rd(Ul);break c;case 2:Ul=Sd(Zl+8|0,3);sl(Ul,$k,Zl+664|0);Rd(Ul);break c;case 3:Ul=Wd(Zl+8|0,3);tl(Ul,$k,Zl+664|0);Vd(Ul);break c;case 4:Ul=Wd(Zl+8|0,3);ul(Ul,$k,Zl+664|0);Vd(Ul);break c;case 5:break f}}Ul=Wd(Zl+8|0,3);vl(Ul,$k,Zl+664|0);Vd(Ul)}_l=q[a+12>>2]==((q[Ql+4>>2]-q[Ql>>2]|0)/12|0)}T=Zl+672|0;return _l}ab(14557);F()}function pl(a,$k,Ql){var Yl=0,cm=0,dm=0,em=0,fm=0;cm=q[$k+12>>2];dm=q[$k+20>>2];em=q[$k+16>>2];Yl=em+4|0;if(Yl>>>0<4){dm=dm+1|0}a:{if((cm|0)<(dm|0)?1:(cm|0)<=(dm|0)?t[$k+8>>2]>=Yl>>>0?0:1:0){break a}Yl=em+q[$k>>2]|0;Yl=r[Yl|0]|r[Yl+1|0]<<8|(r[Yl+2|0]<<16|r[Yl+3|0]<<24);q[a>>2]=Yl;cm=q[$k+20>>2];em=cm;fm=q[$k+16>>2];dm=fm+4|0;if(dm>>>0<4){cm=cm+1|0}q[$k+16>>2]=dm;q[$k+20>>2]=cm;if(Yl>>>0>32){break a}cm=q[$k+12>>2];Yl=fm+8|0;if(Yl>>>0<8){em=em+1|0}if((cm|0)<(em|0)?1:(cm|0)<=(em|0)?t[$k+8>>2]>=Yl>>>0?0:1:0){break a}Yl=dm+q[$k>>2]|0;cm=r[Yl|0]|r[Yl+1|0]<<8|(r[Yl+2|0]<<16|r[Yl+3|0]<<24);q[a+4>>2]=cm;dm=q[$k+20>>2];em=q[$k+16>>2]+4|0;if(em>>>0<4){dm=dm+1|0}q[$k+16>>2]=em;q[$k+20>>2]=dm;if(!cm){break a}q[a+8>>2]=0;if(!$g(a+16|0,$k)){break a}if(!$g(a+36|0,$k)){break a}if(!$g(a+56|0,$k)){break a}if(!$g(a+76|0,$k)){break a}wl(a,q[a+4>>2],Ql)}}function ql(a,$k,Ql){var gm=0,hm=0,im=0,jm=0,km=0;hm=q[$k+12>>2];im=q[$k+20>>2];jm=q[$k+16>>2];gm=jm+4|0;if(gm>>>0<4){im=im+1|0}a:{if((hm|0)<(im|0)?1:(hm|0)<=(im|0)?t[$k+8>>2]>=gm>>>0?0:1:0){break a}gm=jm+q[$k>>2]|0;gm=r[gm|0]|r[gm+1|0]<<8|(r[gm+2|0]<<16|r[gm+3|0]<<24);q[a>>2]=gm;hm=q[$k+20>>2];jm=hm;km=q[$k+16>>2];im=km+4|0;if(im>>>0<4){hm=hm+1|0}q[$k+16>>2]=im;q[$k+20>>2]=hm;if(gm>>>0>32){break a}hm=q[$k+12>>2];gm=km+8|0;if(gm>>>0<8){jm=jm+1|0}if((hm|0)<(jm|0)?1:(hm|0)<=(jm|0)?t[$k+8>>2]>=gm>>>0?0:1:0){break a}gm=im+q[$k>>2]|0;hm=r[gm|0]|r[gm+1|0]<<8|(r[gm+2|0]<<16|r[gm+3|0]<<24);q[a+4>>2]=hm;im=q[$k+20>>2];jm=q[$k+16>>2]+4|0;if(jm>>>0<4){im=im+1|0}q[$k+16>>2]=jm;q[$k+20>>2]=im;if(!hm){break a}q[a+8>>2]=0;if(!$g(a+16|0,$k)){break a}if(!$g(a+36|0,$k)){break a}if(!$g(a+56|0,$k)){break a}if(!$g(a+76|0,$k)){break a}xl(a,q[a+4>>2],Ql)}}function rl(a,$k,Ql){var lm=0,mm=0,nm=0,om=0,pm=0;mm=q[$k+12>>2];nm=q[$k+20>>2];om=q[$k+16>>2];lm=om+4|0;if(lm>>>0<4){nm=nm+1|0}a:{if((mm|0)<(nm|0)?1:(mm|0)<=(nm|0)?t[$k+8>>2]>=lm>>>0?0:1:0){break a}lm=om+q[$k>>2]|0;lm=r[lm|0]|r[lm+1|0]<<8|(r[lm+2|0]<<16|r[lm+3|0]<<24);q[a>>2]=lm;mm=q[$k+20>>2];om=mm;pm=q[$k+16>>2];nm=pm+4|0;if(nm>>>0<4){mm=mm+1|0}q[$k+16>>2]=nm;q[$k+20>>2]=mm;if(lm>>>0>32){break a}mm=q[$k+12>>2];lm=pm+8|0;if(lm>>>0<8){om=om+1|0}if((mm|0)<(om|0)?1:(mm|0)<=(om|0)?t[$k+8>>2]>=lm>>>0?0:1:0){break a}lm=nm+q[$k>>2]|0;mm=r[lm|0]|r[lm+1|0]<<8|(r[lm+2|0]<<16|r[lm+3|0]<<24);q[a+4>>2]=mm;nm=q[$k+20>>2];om=q[$k+16>>2]+4|0;if(om>>>0<4){nm=nm+1|0}q[$k+16>>2]=om;q[$k+20>>2]=nm;if(!mm){break a}q[a+8>>2]=0;if(!bh(a+16|0,$k)){break a}if(!$g(a+32|0,$k)){break a}if(!$g(a+52|0,$k)){break a}if(!$g(a+72|0,$k)){break a}yl(a,q[a+4>>2],Ql)}}function sl(a,$k,Ql){var qm=0,rm=0,sm=0,tm=0,um=0;rm=q[$k+12>>2];sm=q[$k+20>>2];tm=q[$k+16>>2];qm=tm+4|0;if(qm>>>0<4){sm=sm+1|0}a:{if((rm|0)<(sm|0)?1:(rm|0)<=(sm|0)?t[$k+8>>2]>=qm>>>0?0:1:0){break a}qm=tm+q[$k>>2]|0;qm=r[qm|0]|r[qm+1|0]<<8|(r[qm+2|0]<<16|r[qm+3|0]<<24);q[a>>2]=qm;rm=q[$k+20>>2];tm=rm;um=q[$k+16>>2];sm=um+4|0;if(sm>>>0<4){rm=rm+1|0}q[$k+16>>2]=sm;q[$k+20>>2]=rm;if(qm>>>0>32){break a}rm=q[$k+12>>2];qm=um+8|0;if(qm>>>0<8){tm=tm+1|0}if((rm|0)<(tm|0)?1:(rm|0)<=(tm|0)?t[$k+8>>2]>=qm>>>0?0:1:0){break a}qm=sm+q[$k>>2]|0;rm=r[qm|0]|r[qm+1|0]<<8|(r[qm+2|0]<<16|r[qm+3|0]<<24);q[a+4>>2]=rm;sm=q[$k+20>>2];tm=q[$k+16>>2]+4|0;if(tm>>>0<4){sm=sm+1|0}q[$k+16>>2]=tm;q[$k+20>>2]=sm;if(!rm){break a}q[a+8>>2]=0;if(!bh(a+16|0,$k)){break a}if(!$g(a+32|0,$k)){break a}if(!$g(a+52|0,$k)){break a}if(!$g(a+72|0,$k)){break a}zl(a,q[a+4>>2],Ql)}}function tl(a,$k,Ql){var vm=0,wm=0,xm=0,ym=0,zm=0;wm=q[$k+12>>2];xm=q[$k+20>>2];ym=q[$k+16>>2];vm=ym+4|0;if(vm>>>0<4){xm=xm+1|0}a:{if((wm|0)<(xm|0)?1:(wm|0)<=(xm|0)?t[$k+8>>2]>=vm>>>0?0:1:0){break a}vm=ym+q[$k>>2]|0;vm=r[vm|0]|r[vm+1|0]<<8|(r[vm+2|0]<<16|r[vm+3|0]<<24);q[a>>2]=vm;wm=q[$k+20>>2];ym=wm;zm=q[$k+16>>2];xm=zm+4|0;if(xm>>>0<4){wm=wm+1|0}q[$k+16>>2]=xm;q[$k+20>>2]=wm;if(vm>>>0>32){break a}wm=q[$k+12>>2];vm=zm+8|0;if(vm>>>0<8){ym=ym+1|0}if((wm|0)<(ym|0)?1:(wm|0)<=(ym|0)?t[$k+8>>2]>=vm>>>0?0:1:0){break a}vm=xm+q[$k>>2]|0;wm=r[vm|0]|r[vm+1|0]<<8|(r[vm+2|0]<<16|r[vm+3|0]<<24);q[a+4>>2]=wm;xm=q[$k+20>>2];ym=q[$k+16>>2]+4|0;if(ym>>>0<4){xm=xm+1|0}q[$k+16>>2]=ym;q[$k+20>>2]=xm;if(!wm){break a}q[a+8>>2]=0;vm=0;while(1){if(!bh(((vm<<4)+a|0)+16|0,$k)){break a}vm=vm+1|0;if((vm|0)!=32){continue}break}if(!bh(a+528|0,$k)){break a}if(!$g(a+544|0,$k)){break a}if(!$g(a+564|0,$k)){break a}if(!$g(a+584|0,$k)){break a}Al(a,q[a+4>>2],Ql)}}function ul(a,$k,Ql){var Am=0,Bm=0,Cm=0,Dm=0,Em=0;Bm=q[$k+12>>2];Cm=q[$k+20>>2];Dm=q[$k+16>>2];Am=Dm+4|0;if(Am>>>0<4){Cm=Cm+1|0}a:{if((Bm|0)<(Cm|0)?1:(Bm|0)<=(Cm|0)?t[$k+8>>2]>=Am>>>0?0:1:0){break a}Am=Dm+q[$k>>2]|0;Am=r[Am|0]|r[Am+1|0]<<8|(r[Am+2|0]<<16|r[Am+3|0]<<24);q[a>>2]=Am;Bm=q[$k+20>>2];Dm=Bm;Em=q[$k+16>>2];Cm=Em+4|0;if(Cm>>>0<4){Bm=Bm+1|0}q[$k+16>>2]=Cm;q[$k+20>>2]=Bm;if(Am>>>0>32){break a}Bm=q[$k+12>>2];Am=Em+8|0;if(Am>>>0<8){Dm=Dm+1|0}if((Bm|0)<(Dm|0)?1:(Bm|0)<=(Dm|0)?t[$k+8>>2]>=Am>>>0?0:1:0){break a}Am=Cm+q[$k>>2]|0;Bm=r[Am|0]|r[Am+1|0]<<8|(r[Am+2|0]<<16|r[Am+3|0]<<24);q[a+4>>2]=Bm;Cm=q[$k+20>>2];Dm=q[$k+16>>2]+4|0;if(Dm>>>0<4){Cm=Cm+1|0}q[$k+16>>2]=Dm;q[$k+20>>2]=Cm;if(!Bm){break a}q[a+8>>2]=0;Am=0;while(1){if(!bh(((Am<<4)+a|0)+16|0,$k)){break a}Am=Am+1|0;if((Am|0)!=32){continue}break}if(!bh(a+528|0,$k)){break a}if(!$g(a+544|0,$k)){break a}if(!$g(a+564|0,$k)){break a}if(!$g(a+584|0,$k)){break a}Bl(a,q[a+4>>2],Ql)}}function vl(a,$k,Ql){var Fm=0,Gm=0,Hm=0,Im=0,Jm=0;Gm=q[$k+12>>2];Hm=q[$k+20>>2];Im=q[$k+16>>2];Fm=Im+4|0;if(Fm>>>0<4){Hm=Hm+1|0}a:{if((Gm|0)<(Hm|0)?1:(Gm|0)<=(Hm|0)?t[$k+8>>2]>=Fm>>>0?0:1:0){break a}Fm=Im+q[$k>>2]|0;Fm=r[Fm|0]|r[Fm+1|0]<<8|(r[Fm+2|0]<<16|r[Fm+3|0]<<24);q[a>>2]=Fm;Gm=q[$k+20>>2];Im=Gm;Jm=q[$k+16>>2];Hm=Jm+4|0;if(Hm>>>0<4){Gm=Gm+1|0}q[$k+16>>2]=Hm;q[$k+20>>2]=Gm;if(Fm>>>0>32){break a}Gm=q[$k+12>>2];Fm=Jm+8|0;if(Fm>>>0<8){Im=Im+1|0}if((Gm|0)<(Im|0)?1:(Gm|0)<=(Im|0)?t[$k+8>>2]>=Fm>>>0?0:1:0){break a}Fm=Hm+q[$k>>2]|0;Gm=r[Fm|0]|r[Fm+1|0]<<8|(r[Fm+2|0]<<16|r[Fm+3|0]<<24);q[a+4>>2]=Gm;Hm=q[$k+20>>2];Im=q[$k+16>>2]+4|0;if(Im>>>0<4){Hm=Hm+1|0}q[$k+16>>2]=Im;q[$k+20>>2]=Hm;if(!Gm){break a}q[a+8>>2]=0;Fm=0;while(1){if(!bh(((Fm<<4)+a|0)+16|0,$k)){break a}Fm=Fm+1|0;if((Fm|0)!=32){continue}break}if(!bh(a+528|0,$k)){break a}if(!$g(a+544|0,$k)){break a}if(!$g(a+564|0,$k)){break a}if(!$g(a+584|0,$k)){break a}Cl(a,q[a+4>>2],Ql)}}function wl(a,$k,Ql){var Km=0,Lm=0,Nm=0,Om=0,Pm=0,Qm=0,Rm=0,Sm=0,Tm=0,Um=0,Vm=0,Wm=0,Xm=0,Ym=0,Zm=0,_m=0,$m=0,an=0,cn=0,dn=0,en=0,fn=0,gn=0,hn=0,jn=0,kn=0,ln=0;Nm=T-48|0;T=Nm;Km=q[a+12>>2];q[Nm+16>>2]=0;q[Nm+8>>2]=0;q[Nm+12>>2]=0;a:{if(Km){if(Km>>>0>=1073741824){break a}Lm=Km<<2;Pm=Mm(Lm);q[Nm+8>>2]=Pm;q[Nm+12>>2]=Pm;q[Nm+16>>2]=Lm+Pm;Om=Dn(Pm,0,Lm);Lm=Km;while(1){Om=Om+4|0;Lm=Lm+ -1|0;if(Lm){continue}break}q[Nm+12>>2]=Om}Lm=q[a+120>>2];Rm=q[Lm>>2];if(Rm){q[Lm+4>>2]=Rm;An(Rm);q[Lm+8>>2]=0;q[Lm>>2]=0;q[Lm+4>>2]=0;Om=q[Nm+12>>2];Pm=q[Nm+8>>2];Km=q[a+12>>2]}q[Lm>>2]=Pm;q[Lm+4>>2]=Om;q[Lm+8>>2]=q[Nm+16>>2];Om=0;q[Nm+16>>2]=0;q[Nm+8>>2]=0;q[Nm+12>>2]=0;Lm=0;b:{if(Km){if(Km>>>0>=1073741824){break b}Rm=Km<<2;Lm=Mm(Rm);q[Nm+8>>2]=Lm;q[Nm+12>>2]=Lm;q[Nm+16>>2]=Lm+Rm;Om=Dn(Lm,0,Rm);while(1){Om=Om+4|0;Km=Km+ -1|0;if(Km){continue}break}q[Nm+12>>2]=Om}Km=q[a+132>>2];Rm=q[Km>>2];if(Rm){q[Km+4>>2]=Rm;An(Rm);q[Km+8>>2]=0;q[Km>>2]=0;q[Km+4>>2]=0;Om=q[Nm+12>>2];Lm=q[Nm+8>>2]}q[Km>>2]=Lm;q[Km+4>>2]=Om;q[Km+8>>2]=q[Nm+16>>2];Lm=Nm+24|0;q[Lm>>2]=0;q[Lm+4>>2]=0;Rm=Nm+16|0;q[Rm>>2]=0;q[Rm+4>>2]=0;q[Nm+8>>2]=0;q[Nm+12>>2]=0;re(Nm+8|0);Qm=q[Rm>>2];Rm=q[Nm+12>>2];Km=0;c:{if((Qm|0)==(Rm|0)){break c}Km=q[Lm>>2]+q[Nm+28>>2]|0;Lm=(Km>>>0)/341|0;Km=q[Rm+(Lm<<2)>>2]+w(Km-w(Lm,341)|0,12)|0}q[Km+4>>2]=0;q[Km+8>>2]=0;q[Km>>2]=$k;Lm=q[Nm+28>>2];Km=Lm+1|0;q[Nm+28>>2]=Km;d:{if(Km>>>0<Lm>>>0){break d}cn=a+132|0;$m=a+120|0;dn=a+108|0;en=a+96|0;Zm=a+48|0;fn=a+40|0;_m=a+28|0;gn=a+20|0;jn=a+80|0;while(1){Pm=q[Nm+12>>2];Qm=q[Nm+24>>2];Om=Km+ -1|0;Lm=Qm+Om|0;Rm=(Lm>>>0)/341|0;Lm=q[Pm+(Rm<<2)>>2]+w(Lm-w(Rm,341)|0,12)|0;Um=q[Lm+8>>2];Tm=q[Lm+4>>2];Rm=q[Lm>>2];q[Nm+28>>2]=Om;Lm=q[Nm+16>>2];Om=Lm-Pm|0;if(((Om?w(Om>>2,341)+ -1|0:0)-(Km+Qm|0)|0)+1>>>0>=682){An(q[Lm+ -4>>2]);q[Nm+16>>2]=q[Nm+16>>2]+ -4}if(Rm>>>0>$k>>>0){break d}Km=q[$m>>2];Pm=w(Um,12);Vm=Pm+q[cn>>2]|0;Om=ml(a,Vm,Tm);if(Om>>>0>=t[a+12>>2]){break d}Qm=Km+Pm|0;e:{f:{Tm=Om<<2;Lm=q[a>>2]-q[Tm+q[Vm>>2]>>2]|0;if(!Lm){if(!Rm){break f}Lm=0;while(1){Km=q[Qm>>2];Pm=q[Km>>2];q[Nm+32>>2]=Pm;q[Nm+36>>2]=q[Km+4>>2];q[Nm+40>>2]=q[Km+8>>2];Om=q[Ql>>2];Um=Om+4|0;Km=q[Um>>2];g:{if(Km>>>0<t[Om+8>>2]){q[Km>>2]=Pm;q[Km+4>>2]=q[Nm+36>>2];q[Km+8>>2]=q[Nm+40>>2];q[Um>>2]=Km+12;break g}Dl(Om,Nm+32|0)}q[a+8>>2]=q[a+8>>2]+1;Lm=Lm+1|0;if((Rm|0)!=(Lm|0)){continue}break}break f}h:{i:{j:{k:{if(Rm>>>0<=2){Pm=q[dn>>2];q[Pm>>2]=Om;Lm=1;Km=q[a+12>>2];if(Km>>>0>1){break k}break h}if(t[a+8>>2]>t[a+4>>2]){break d}Km=q[$m>>2];Xm=Um+1|0;Vm=w(Xm,12);Sm=Km+Vm|0;if((Sm|0)!=(Qm|0)){hd(Sm,q[Qm>>2],q[Qm+4>>2]);Km=q[$m>>2]}Km=Tm+q[Km+Vm>>2]|0;q[Km>>2]=q[Km>>2]+(1<<Lm+ -1);Km=z(Rm)^31;Lm=q[a+32>>2];Sm=32-Lm|0;l:{if((Km|0)<=(Sm|0)){Qm=q[_m>>2];if((Qm|0)==q[gn>>2]){Lm=0;break l}Sm=q[Qm>>2];Wm=Km+Lm|0;q[a+32>>2]=Wm;Lm=Sm<<Lm>>>32-Km;if((Wm|0)!=32){break l}q[a+32>>2]=0;q[_m>>2]=Qm+4;break l}Qm=q[_m>>2];Wm=Qm+4|0;if((Wm|0)==q[gn>>2]){Lm=0;break l}an=q[Qm>>2];q[_m>>2]=Wm;Sm=Km-Sm|0;q[a+32>>2]=Sm;Lm=q[Qm+4>>2]>>>32-Sm|an<<Lm>>>32-Km}Km=(Rm>>>1)-Lm|0;Lm=Rm-Km|0;m:{if((Lm|0)==(Km|0)){Lm=Km;break m}Rm=q[a+88>>2];if((Rm|0)==q[jn>>2]){break j}Qm=q[Rm>>2];Sm=q[a+92>>2];Wm=Sm+1|0;q[a+92>>2]=Wm;Qm=Qm&-2147483648>>>Sm;n:{if((Wm|0)==32){q[a+92>>2]=0;q[a+88>>2]=Rm+4;if(Qm){break n}break j}if(!Qm){break j}}}Rm=Lm;Lm=Km;break i}while(1){Om=(Km+ -1|0)==(Om|0)?0:Om+1|0;q[Pm+(Lm<<2)>>2]=Om;Lm=Lm+1|0;Km=q[a+12>>2];if(Lm>>>0<Km>>>0){continue}break}break h}Rm=Km}Km=q[cn>>2];Qm=Km+Pm|0;Pm=q[Qm>>2];Tm=Pm+Tm|0;q[Tm>>2]=q[Tm>>2]+1;hd(Km+Vm|0,Pm,q[Qm+4>>2]);if(Lm){Pm=q[Nm+28>>2]+q[Nm+24>>2]|0;Qm=q[Nm+16>>2];Km=q[Nm+12>>2];Vm=Qm-Km|0;if((Pm|0)==((Vm?w(Vm>>2,341)+ -1|0:0)|0)){re(Nm+8|0);Pm=q[Nm+24>>2]+q[Nm+28>>2]|0;Qm=q[Nm+16>>2];Km=q[Nm+12>>2]}if((Km|0)==(Qm|0)){Km=0}else{Qm=Km;Km=(Pm>>>0)/341|0;Km=q[Qm+(Km<<2)>>2]+w(Pm-w(Km,341)|0,12)|0}q[Km+8>>2]=Um;q[Km+4>>2]=Om;q[Km>>2]=Lm;q[Nm+28>>2]=q[Nm+28>>2]+1}if(!Rm){break f}Lm=q[Nm+28>>2]+q[Nm+24>>2]|0;Pm=q[Nm+16>>2];Km=q[Nm+12>>2];Qm=Pm-Km|0;if((Lm|0)==((Qm?w(Qm>>2,341)+ -1|0:0)|0)){re(Nm+8|0);Lm=q[Nm+24>>2]+q[Nm+28>>2]|0;Pm=q[Nm+16>>2];Km=q[Nm+12>>2]}Qm=0;o:{if((Km|0)==(Pm|0)){break o}Qm=Km;Km=(Lm>>>0)/341|0;Qm=q[Qm+(Km<<2)>>2]+w(Lm-w(Km,341)|0,12)|0}q[Qm+8>>2]=Xm;q[Qm+4>>2]=Om;q[Qm>>2]=Rm;Km=q[Nm+28>>2]+1|0;q[Nm+28>>2]=Km;break e}if(!Rm){break f}Um=0;while(1){p:{if(!Km){Lm=q[en>>2];break p}Lm=q[en>>2];Wm=q[dn>>2];an=q[Qm>>2];kn=q[Vm>>2];Km=0;while(1){Tm=Wm+(Km<<2)|0;q[(q[Tm>>2]<<2)+Lm>>2]=0;Pm=q[Tm>>2]<<2;Om=q[a>>2]-q[Pm+kn>>2]|0;q:{if(!Om){break q}Pm=Lm+Pm|0;Xm=q[a+52>>2];Ym=32-Xm|0;if((Om|0)<=(Ym|0)){Sm=q[Zm>>2];if((Sm|0)==q[fn>>2]){q[Pm>>2]=0;break q}q[Pm>>2]=q[Sm>>2]<<Xm>>>32-Om;Om=Om+q[a+52>>2]|0;q[a+52>>2]=Om;if((Om|0)!=32){break q}q[a+52>>2]=0;q[Zm>>2]=Sm+4;break q}Sm=q[Zm>>2];hn=Sm+4|0;if((hn|0)==q[fn>>2]){q[Pm>>2]=0;break q}ln=q[Sm>>2];q[Zm>>2]=hn;Ym=Om-Ym|0;q[a+52>>2]=Ym;q[Pm>>2]=q[Sm+4>>2]>>>32-Ym|ln<<Xm>>>32-Om}Om=q[Tm>>2]<<2;Pm=Om+Lm|0;q[Pm>>2]=q[Pm>>2]|q[Om+an>>2];Km=Km+1|0;if(Km>>>0<t[a+12>>2]){continue}break}}Om=q[Lm>>2];q[Nm+32>>2]=Om;q[Nm+36>>2]=q[Lm+4>>2];q[Nm+40>>2]=q[Lm+8>>2];Lm=q[Ql>>2];Pm=Lm+4|0;Km=q[Pm>>2];r:{if(Km>>>0<t[Lm+8>>2]){q[Km>>2]=Om;q[Km+4>>2]=q[Nm+36>>2];q[Km+8>>2]=q[Nm+40>>2];q[Pm>>2]=Km+12;break r}Dl(Lm,Nm+32|0)}q[a+8>>2]=q[a+8>>2]+1;Um=Um+1|0;if((Um|0)==(Rm|0)){break f}Km=q[a+12>>2];continue}}Km=q[Nm+28>>2]}if(Km){continue}break}}se(Nm+8|0);a=q[Nm+12>>2];$k=q[Nm+16>>2];s:{if((a|0)==($k|0)){break s}while(1){An(q[a>>2]);a=a+4|0;if(($k|0)!=(a|0)){continue}break}a=q[Nm+16>>2];$k=q[Nm+12>>2];if((a|0)==($k|0)){break s}q[Nm+16>>2]=a+(((a-$k|0)+ -4>>>2^-1)<<2)}a=q[Nm+8>>2];if(a){An(a)}T=Nm+48|0;return}bn();F()}bn();F()}function xl(a,$k,Ql){var mn=0,nn=0,on=0,pn=0,qn=0,rn=0,sn=0,tn=0,un=0,vn=0,wn=0,xn=0,yn=0,zn=0,Bn=0,Cn=0,En=0,Fn=0,Gn=0,Hn=0,In=0,Jn=0,Kn=0,Ln=0,Mn=0,Nn=0,On=0;on=T-48|0;T=on;mn=q[a+12>>2];q[on+16>>2]=0;q[on+8>>2]=0;q[on+12>>2]=0;a:{if(mn){if(mn>>>0>=1073741824){break a}nn=mn<<2;rn=Mm(nn);q[on+8>>2]=rn;q[on+12>>2]=rn;q[on+16>>2]=nn+rn;qn=Dn(rn,0,nn);pn=mn;while(1){qn=qn+4|0;pn=pn+ -1|0;if(pn){continue}break}q[on+12>>2]=qn}nn=q[a+120>>2];sn=q[nn>>2];if(sn){q[nn+4>>2]=sn;An(sn);q[nn+8>>2]=0;q[nn>>2]=0;q[nn+4>>2]=0;qn=q[on+12>>2];rn=q[on+8>>2];mn=q[a+12>>2]}q[nn>>2]=rn;q[nn+4>>2]=qn;q[nn+8>>2]=q[on+16>>2];qn=0;q[on+16>>2]=0;q[on+8>>2]=0;q[on+12>>2]=0;pn=0;b:{if(mn){if(mn>>>0>=1073741824){break b}nn=mn<<2;pn=Mm(nn);q[on+8>>2]=pn;q[on+12>>2]=pn;q[on+16>>2]=nn+pn;qn=Dn(pn,0,nn);while(1){qn=qn+4|0;mn=mn+ -1|0;if(mn){continue}break}q[on+12>>2]=qn}mn=q[a+132>>2];nn=q[mn>>2];if(nn){q[mn+4>>2]=nn;An(nn);q[mn+8>>2]=0;q[mn>>2]=0;q[mn+4>>2]=0;qn=q[on+12>>2];pn=q[on+8>>2]}q[mn>>2]=pn;q[mn+4>>2]=qn;q[mn+8>>2]=q[on+16>>2];nn=on+24|0;q[nn>>2]=0;q[nn+4>>2]=0;sn=on+16|0;q[sn>>2]=0;q[sn+4>>2]=0;q[on+8>>2]=0;q[on+12>>2]=0;re(on+8|0);pn=q[sn>>2];sn=q[on+12>>2];mn=0;c:{if((pn|0)==(sn|0)){break c}mn=q[nn>>2]+q[on+28>>2]|0;nn=(mn>>>0)/341|0;mn=q[sn+(nn<<2)>>2]+w(mn-w(nn,341)|0,12)|0}q[mn+4>>2]=0;q[mn+8>>2]=0;q[mn>>2]=$k;nn=q[on+28>>2];mn=nn+1|0;q[on+28>>2]=mn;d:{if(mn>>>0<nn>>>0){break d}Cn=a+120|0;En=a+132|0;Fn=a+108|0;Gn=a+96|0;zn=a+48|0;Hn=a+40|0;Bn=a+28|0;In=a+20|0;Kn=a+80|0;while(1){un=q[on+12>>2];qn=q[on+24>>2];rn=mn+ -1|0;nn=qn+rn|0;sn=(nn>>>0)/341|0;nn=q[un+(sn<<2)>>2]+w(nn-w(sn,341)|0,12)|0;wn=q[nn+8>>2];pn=q[nn+4>>2];sn=q[nn>>2];q[on+28>>2]=rn;nn=q[on+16>>2];rn=nn-un|0;if(((rn?w(rn>>2,341)+ -1|0:0)-(mn+qn|0)|0)+1>>>0>=682){An(q[nn+ -4>>2]);q[on+16>>2]=q[on+16>>2]+ -4}if(sn>>>0>$k>>>0){break d}mn=q[a+12>>2];qn=(pn|0)==(mn+ -1|0)?0:pn+1|0;if(qn>>>0>=mn>>>0){break d}mn=q[Cn>>2];pn=w(wn,12);rn=mn+pn|0;e:{f:{un=qn<<2;xn=pn+q[En>>2]|0;nn=q[a>>2]-q[un+q[xn>>2]>>2]|0;if(!nn){if(!sn){break f}pn=0;while(1){mn=q[rn>>2];qn=q[mn>>2];q[on+32>>2]=qn;q[on+36>>2]=q[mn+4>>2];q[on+40>>2]=q[mn+8>>2];nn=q[Ql>>2];wn=nn+4|0;mn=q[wn>>2];g:{if(mn>>>0<t[nn+8>>2]){q[mn>>2]=qn;q[mn+4>>2]=q[on+36>>2];q[mn+8>>2]=q[on+40>>2];q[wn>>2]=mn+12;break g}Dl(nn,on+32|0)}q[a+8>>2]=q[a+8>>2]+1;pn=pn+1|0;if((sn|0)!=(pn|0)){continue}break}break f}h:{i:{j:{k:{if(sn>>>0<=2){nn=q[Fn>>2];q[nn>>2]=qn;pn=1;mn=q[a+12>>2];if(mn>>>0>1){break k}break h}if(t[a+8>>2]>t[a+4>>2]){break d}tn=mn;mn=pn+12|0;hd(tn+mn|0,q[rn>>2],q[rn+4>>2]);mn=un+q[mn+q[Cn>>2]>>2]|0;q[mn>>2]=q[mn>>2]+(1<<nn+ -1);mn=z(sn)^31;nn=q[a+32>>2];vn=32-nn|0;l:{if((mn|0)<=(vn|0)){rn=q[Bn>>2];if((rn|0)==q[In>>2]){nn=0;break l}vn=q[rn>>2];tn=mn+nn|0;q[a+32>>2]=tn;nn=vn<<nn>>>32-mn;if((tn|0)!=32){break l}q[a+32>>2]=0;q[Bn>>2]=rn+4;break l}rn=q[Bn>>2];tn=rn+4|0;if((tn|0)==q[In>>2]){nn=0;break l}xn=q[rn>>2];q[Bn>>2]=tn;vn=mn-vn|0;q[a+32>>2]=vn;nn=q[rn+4>>2]>>>32-vn|xn<<nn>>>32-mn}vn=wn+1|0;mn=(sn>>>1)-nn|0;nn=sn-mn|0;m:{if((nn|0)==(mn|0)){nn=mn;break m}sn=q[a+88>>2];if((sn|0)==q[Kn>>2]){break j}rn=q[sn>>2];tn=q[a+92>>2];xn=tn+1|0;q[a+92>>2]=xn;rn=rn&-2147483648>>>tn;n:{if((xn|0)==32){q[a+92>>2]=0;q[a+88>>2]=sn+4;if(rn){break n}break j}if(!rn){break j}}}sn=nn;nn=mn;break i}while(1){qn=(mn+ -1|0)==(qn|0)?0:qn+1|0;q[nn+(pn<<2)>>2]=qn;pn=pn+1|0;mn=q[a+12>>2];if(pn>>>0<mn>>>0){continue}break}break h}sn=mn}mn=q[En>>2];pn=mn+pn|0;rn=q[pn>>2];un=rn+un|0;q[un>>2]=q[un>>2]+1;hd(mn+w(vn,12)|0,rn,q[pn+4>>2]);if(nn){pn=q[on+28>>2]+q[on+24>>2]|0;rn=q[on+16>>2];mn=q[on+12>>2];un=rn-mn|0;if((pn|0)==((un?w(un>>2,341)+ -1|0:0)|0)){re(on+8|0);pn=q[on+24>>2]+q[on+28>>2]|0;rn=q[on+16>>2];mn=q[on+12>>2]}if((mn|0)==(rn|0)){mn=0}else{tn=mn;mn=(pn>>>0)/341|0;mn=q[tn+(mn<<2)>>2]+w(pn-w(mn,341)|0,12)|0}q[mn+8>>2]=wn;q[mn+4>>2]=qn;q[mn>>2]=nn;q[on+28>>2]=q[on+28>>2]+1}if(!sn){break f}pn=q[on+28>>2]+q[on+24>>2]|0;rn=q[on+16>>2];mn=q[on+12>>2];nn=rn-mn|0;if((pn|0)==((nn?w(nn>>2,341)+ -1|0:0)|0)){re(on+8|0);pn=q[on+24>>2]+q[on+28>>2]|0;rn=q[on+16>>2];mn=q[on+12>>2]}nn=0;o:{if((mn|0)==(rn|0)){break o}nn=mn;mn=(pn>>>0)/341|0;nn=q[nn+(mn<<2)>>2]+w(pn-w(mn,341)|0,12)|0}q[nn+8>>2]=vn;q[nn+4>>2]=qn;q[nn>>2]=sn;mn=q[on+28>>2]+1|0;q[on+28>>2]=mn;break e}if(!sn){break f}wn=0;while(1){p:{if(!mn){pn=q[Gn>>2];break p}pn=q[Gn>>2];Ln=q[Fn>>2];Mn=q[rn>>2];Nn=q[xn>>2];mn=0;while(1){un=Ln+(mn<<2)|0;q[(q[un>>2]<<2)+pn>>2]=0;qn=q[un>>2]<<2;nn=q[a>>2]-q[qn+Nn>>2]|0;q:{if(!nn){break q}qn=pn+qn|0;vn=q[a+52>>2];yn=32-vn|0;if((nn|0)<=(yn|0)){tn=q[zn>>2];if((tn|0)==q[Hn>>2]){q[qn>>2]=0;break q}q[qn>>2]=q[tn>>2]<<vn>>>32-nn;nn=nn+q[a+52>>2]|0;q[a+52>>2]=nn;if((nn|0)!=32){break q}q[a+52>>2]=0;q[zn>>2]=tn+4;break q}tn=q[zn>>2];Jn=tn+4|0;if((Jn|0)==q[Hn>>2]){q[qn>>2]=0;break q}On=q[tn>>2];q[zn>>2]=Jn;yn=nn-yn|0;q[a+52>>2]=yn;q[qn>>2]=q[tn+4>>2]>>>32-yn|On<<vn>>>32-nn}nn=q[un>>2]<<2;qn=nn+pn|0;q[qn>>2]=q[qn>>2]|q[nn+Mn>>2];mn=mn+1|0;if(mn>>>0<t[a+12>>2]){continue}break}}qn=q[pn>>2];q[on+32>>2]=qn;q[on+36>>2]=q[pn+4>>2];q[on+40>>2]=q[pn+8>>2];nn=q[Ql>>2];pn=nn+4|0;mn=q[pn>>2];r:{if(mn>>>0<t[nn+8>>2]){q[mn>>2]=qn;q[mn+4>>2]=q[on+36>>2];q[mn+8>>2]=q[on+40>>2];q[pn>>2]=mn+12;break r}Dl(nn,on+32|0)}q[a+8>>2]=q[a+8>>2]+1;wn=wn+1|0;if((wn|0)==(sn|0)){break f}mn=q[a+12>>2];continue}}mn=q[on+28>>2]}if(mn){continue}break}}se(on+8|0);a=q[on+12>>2];$k=q[on+16>>2];s:{if((a|0)==($k|0)){break s}while(1){An(q[a>>2]);a=a+4|0;if(($k|0)!=(a|0)){continue}break}a=q[on+16>>2];$k=q[on+12>>2];if((a|0)==($k|0)){break s}q[on+16>>2]=a+(((a-$k|0)+ -4>>>2^-1)<<2)}a=q[on+8>>2];if(a){An(a)}T=on+48|0;return}bn();F()}bn();F()}function yl(a,$k,Ql){var Pn=0,Qn=0,Rn=0,Sn=0,Tn=0,Un=0,Vn=0,Wn=0,Xn=0,Yn=0,Zn=0,_n=0,$n=0,ao=0,bo=0,co=0,eo=0,fo=0,go=0,ho=0,io=0,jo=0,ko=0,lo=0,mo=0,no=0;Qn=T-48|0;T=Qn;Pn=q[a+12>>2];q[Qn+16>>2]=0;q[Qn+8>>2]=0;q[Qn+12>>2]=0;a:{if(Pn){if(Pn>>>0>=1073741824){break a}Rn=Pn<<2;Tn=Mm(Rn);q[Qn+8>>2]=Tn;q[Qn+12>>2]=Tn;q[Qn+16>>2]=Rn+Tn;Sn=Dn(Tn,0,Rn);Rn=Pn;while(1){Sn=Sn+4|0;Rn=Rn+ -1|0;if(Rn){continue}break}q[Qn+12>>2]=Sn}Rn=q[a+116>>2];Un=q[Rn>>2];if(Un){q[Rn+4>>2]=Un;An(Un);q[Rn+8>>2]=0;q[Rn>>2]=0;q[Rn+4>>2]=0;Sn=q[Qn+12>>2];Tn=q[Qn+8>>2];Pn=q[a+12>>2]}q[Rn>>2]=Tn;q[Rn+4>>2]=Sn;q[Rn+8>>2]=q[Qn+16>>2];Sn=0;q[Qn+16>>2]=0;q[Qn+8>>2]=0;q[Qn+12>>2]=0;Rn=0;b:{if(Pn){if(Pn>>>0>=1073741824){break b}Un=Pn<<2;Rn=Mm(Un);q[Qn+8>>2]=Rn;q[Qn+12>>2]=Rn;q[Qn+16>>2]=Rn+Un;Sn=Dn(Rn,0,Un);while(1){Sn=Sn+4|0;Pn=Pn+ -1|0;if(Pn){continue}break}q[Qn+12>>2]=Sn}Pn=q[a+128>>2];Un=q[Pn>>2];if(Un){q[Pn+4>>2]=Un;An(Un);q[Pn+8>>2]=0;q[Pn>>2]=0;q[Pn+4>>2]=0;Sn=q[Qn+12>>2];Rn=q[Qn+8>>2]}q[Pn>>2]=Rn;q[Pn+4>>2]=Sn;q[Pn+8>>2]=q[Qn+16>>2];Rn=Qn+24|0;q[Rn>>2]=0;q[Rn+4>>2]=0;Un=Qn+16|0;q[Un>>2]=0;q[Un+4>>2]=0;q[Qn+8>>2]=0;q[Qn+12>>2]=0;re(Qn+8|0);Vn=q[Un>>2];Un=q[Qn+12>>2];Pn=0;c:{if((Vn|0)==(Un|0)){break c}Pn=q[Rn>>2]+q[Qn+28>>2]|0;Rn=(Pn>>>0)/341|0;Pn=q[Un+(Rn<<2)>>2]+w(Pn-w(Rn,341)|0,12)|0}q[Pn+4>>2]=0;q[Pn+8>>2]=0;q[Pn>>2]=$k;Rn=q[Qn+28>>2];Pn=Rn+1|0;q[Qn+28>>2]=Pn;d:{if(Pn>>>0<Rn>>>0){break d}jo=a+16|0;eo=a+128|0;co=a+116|0;fo=a+104|0;go=a+92|0;ao=a+44|0;ho=a+36|0;ko=a+76|0;while(1){Tn=q[Qn+12>>2];Vn=q[Qn+24>>2];Sn=Pn+ -1|0;Rn=Vn+Sn|0;Un=(Rn>>>0)/341|0;Rn=q[Tn+(Un<<2)>>2]+w(Rn-w(Un,341)|0,12)|0;Yn=q[Rn+8>>2];Xn=q[Rn+4>>2];Un=q[Rn>>2];q[Qn+28>>2]=Sn;Rn=q[Qn+16>>2];Sn=Rn-Tn|0;if(((Sn?w(Sn>>2,341)+ -1|0:0)-(Pn+Vn|0)|0)+1>>>0>=682){An(q[Rn+ -4>>2]);q[Qn+16>>2]=q[Qn+16>>2]+ -4}if(Un>>>0>$k>>>0){break d}Pn=q[co>>2];Tn=w(Yn,12);Zn=Tn+q[eo>>2]|0;Sn=ml(a,Zn,Xn);if(Sn>>>0>=t[a+12>>2]){break d}Vn=Pn+Tn|0;e:{Xn=Sn<<2;Rn=q[a>>2]-q[Xn+q[Zn>>2]>>2]|0;if(!Rn){if(!Un){break e}Rn=0;while(1){Pn=q[Vn>>2];Tn=q[Pn>>2];q[Qn+32>>2]=Tn;q[Qn+36>>2]=q[Pn+4>>2];q[Qn+40>>2]=q[Pn+8>>2];Sn=q[Ql>>2];Yn=Sn+4|0;Pn=q[Yn>>2];f:{if(Pn>>>0<t[Sn+8>>2]){q[Pn>>2]=Tn;q[Pn+4>>2]=q[Qn+36>>2];q[Pn+8>>2]=q[Qn+40>>2];q[Yn>>2]=Pn+12;break f}Dl(Sn,Qn+32|0)}q[a+8>>2]=q[a+8>>2]+1;Rn=Rn+1|0;if((Un|0)!=(Rn|0)){continue}break}break e}g:{h:{i:{j:{if(Un>>>0<=2){Tn=q[fo>>2];q[Tn>>2]=Sn;Rn=1;Pn=q[a+12>>2];if(Pn>>>0>1){break j}break g}if(t[a+8>>2]>t[a+4>>2]){break d}Pn=q[co>>2];_n=Yn+1|0;Zn=w(_n,12);Wn=Pn+Zn|0;if((Wn|0)!=(Vn|0)){hd(Wn,q[Vn>>2],q[Vn+4>>2]);Pn=q[co>>2]}Pn=Xn+q[Pn+Zn>>2]|0;q[Pn>>2]=q[Pn>>2]+(1<<Rn+ -1);q[Qn+32>>2]=0;eh(jo,z(Un)^31,Qn+32|0);Pn=(Un>>>1)-q[Qn+32>>2]|0;Rn=Un-Pn|0;k:{if((Rn|0)==(Pn|0)){Rn=Pn;break k}Un=q[a+84>>2];if((Un|0)==q[ko>>2]){break i}Vn=q[Un>>2];Wn=q[a+88>>2];bo=Wn+1|0;q[a+88>>2]=bo;Vn=Vn&-2147483648>>>Wn;l:{if((bo|0)==32){q[a+88>>2]=0;q[a+84>>2]=Un+4;if(Vn){break l}break i}if(!Vn){break i}}}Un=Rn;Rn=Pn;break h}while(1){Sn=(Pn+ -1|0)==(Sn|0)?0:Sn+1|0;q[Tn+(Rn<<2)>>2]=Sn;Rn=Rn+1|0;Pn=q[a+12>>2];if(Rn>>>0<Pn>>>0){continue}break}break g}Un=Pn}Pn=q[eo>>2];Vn=Pn+Tn|0;Tn=q[Vn>>2];Xn=Tn+Xn|0;q[Xn>>2]=q[Xn>>2]+1;hd(Pn+Zn|0,Tn,q[Vn+4>>2]);if(Rn){Tn=q[Qn+28>>2]+q[Qn+24>>2]|0;Vn=q[Qn+16>>2];Pn=q[Qn+12>>2];Zn=Vn-Pn|0;if((Tn|0)==((Zn?w(Zn>>2,341)+ -1|0:0)|0)){re(Qn+8|0);Tn=q[Qn+24>>2]+q[Qn+28>>2]|0;Vn=q[Qn+16>>2];Pn=q[Qn+12>>2]}if((Pn|0)==(Vn|0)){Pn=0}else{Vn=Pn;Pn=(Tn>>>0)/341|0;Pn=q[Vn+(Pn<<2)>>2]+w(Tn-w(Pn,341)|0,12)|0}q[Pn+8>>2]=Yn;q[Pn+4>>2]=Sn;q[Pn>>2]=Rn;q[Qn+28>>2]=q[Qn+28>>2]+1}if(!Un){break e}Rn=q[Qn+28>>2]+q[Qn+24>>2]|0;Tn=q[Qn+16>>2];Pn=q[Qn+12>>2];Vn=Tn-Pn|0;if((Rn|0)==((Vn?w(Vn>>2,341)+ -1|0:0)|0)){re(Qn+8|0);Rn=q[Qn+24>>2]+q[Qn+28>>2]|0;Tn=q[Qn+16>>2];Pn=q[Qn+12>>2]}Vn=0;m:{if((Pn|0)==(Tn|0)){break m}Vn=Pn;Pn=(Rn>>>0)/341|0;Vn=q[Vn+(Pn<<2)>>2]+w(Rn-w(Pn,341)|0,12)|0}q[Vn+8>>2]=_n;q[Vn+4>>2]=Sn;q[Vn>>2]=Un;q[Qn+28>>2]=q[Qn+28>>2]+1;break e}if(!Un){break e}Yn=0;while(1){n:{if(!Pn){Rn=q[go>>2];break n}Rn=q[go>>2];bo=q[fo>>2];lo=q[Vn>>2];mo=q[Zn>>2];Pn=0;while(1){Xn=bo+(Pn<<2)|0;q[(q[Xn>>2]<<2)+Rn>>2]=0;Tn=q[Xn>>2]<<2;Sn=q[a>>2]-q[Tn+mo>>2]|0;o:{if(!Sn){break o}Tn=Rn+Tn|0;_n=q[a+48>>2];$n=32-_n|0;if((Sn|0)<=($n|0)){Wn=q[ao>>2];if((Wn|0)==q[ho>>2]){q[Tn>>2]=0;break o}q[Tn>>2]=q[Wn>>2]<<_n>>>32-Sn;Sn=Sn+q[a+48>>2]|0;q[a+48>>2]=Sn;if((Sn|0)!=32){break o}q[a+48>>2]=0;q[ao>>2]=Wn+4;break o}Wn=q[ao>>2];io=Wn+4|0;if((io|0)==q[ho>>2]){q[Tn>>2]=0;break o}no=q[Wn>>2];q[ao>>2]=io;$n=Sn-$n|0;q[a+48>>2]=$n;q[Tn>>2]=q[Wn+4>>2]>>>32-$n|no<<_n>>>32-Sn}Sn=q[Xn>>2]<<2;Tn=Sn+Rn|0;q[Tn>>2]=q[Tn>>2]|q[Sn+lo>>2];Pn=Pn+1|0;if(Pn>>>0<t[a+12>>2]){continue}break}}Sn=q[Rn>>2];q[Qn+32>>2]=Sn;q[Qn+36>>2]=q[Rn+4>>2];q[Qn+40>>2]=q[Rn+8>>2];Rn=q[Ql>>2];Tn=Rn+4|0;Pn=q[Tn>>2];p:{if(Pn>>>0<t[Rn+8>>2]){q[Pn>>2]=Sn;q[Pn+4>>2]=q[Qn+36>>2];q[Pn+8>>2]=q[Qn+40>>2];q[Tn>>2]=Pn+12;break p}Dl(Rn,Qn+32|0)}q[a+8>>2]=q[a+8>>2]+1;Yn=Yn+1|0;if((Yn|0)==(Un|0)){break e}Pn=q[a+12>>2];continue}}Pn=q[Qn+28>>2];if(Pn){continue}break}}se(Qn+8|0);a=q[Qn+12>>2];$k=q[Qn+16>>2];q:{if((a|0)==($k|0)){break q}while(1){An(q[a>>2]);a=a+4|0;if(($k|0)!=(a|0)){continue}break}a=q[Qn+16>>2];$k=q[Qn+12>>2];if((a|0)==($k|0)){break q}q[Qn+16>>2]=a+(((a-$k|0)+ -4>>>2^-1)<<2)}a=q[Qn+8>>2];if(a){An(a)}T=Qn+48|0;return}bn();F()}bn();F()}function zl(a,$k,Ql){var oo=0,po=0,qo=0,ro=0,so=0,to=0,uo=0,vo=0,wo=0,xo=0,yo=0,zo=0,Ao=0,Bo=0,Co=0,Do=0,Eo=0,Fo=0,Go=0,Ho=0,Io=0,Jo=0,Ko=0,Lo=0,Mo=0,No=0;po=T-48|0;T=po;oo=q[a+12>>2];q[po+16>>2]=0;q[po+8>>2]=0;q[po+12>>2]=0;a:{if(oo){if(oo>>>0>=1073741824){break a}qo=oo<<2;uo=Mm(qo);q[po+8>>2]=uo;q[po+12>>2]=uo;q[po+16>>2]=qo+uo;to=Dn(uo,0,qo);ro=oo;while(1){to=to+4|0;ro=ro+ -1|0;if(ro){continue}break}q[po+12>>2]=to}qo=q[a+116>>2];so=q[qo>>2];if(so){q[qo+4>>2]=so;An(so);q[qo+8>>2]=0;q[qo>>2]=0;q[qo+4>>2]=0;to=q[po+12>>2];uo=q[po+8>>2];oo=q[a+12>>2]}q[qo>>2]=uo;q[qo+4>>2]=to;q[qo+8>>2]=q[po+16>>2];to=0;q[po+16>>2]=0;q[po+8>>2]=0;q[po+12>>2]=0;ro=0;b:{if(oo){if(oo>>>0>=1073741824){break b}qo=oo<<2;ro=Mm(qo);q[po+8>>2]=ro;q[po+12>>2]=ro;q[po+16>>2]=qo+ro;to=Dn(ro,0,qo);while(1){to=to+4|0;oo=oo+ -1|0;if(oo){continue}break}q[po+12>>2]=to}oo=q[a+128>>2];qo=q[oo>>2];if(qo){q[oo+4>>2]=qo;An(qo);q[oo+8>>2]=0;q[oo>>2]=0;q[oo+4>>2]=0;to=q[po+12>>2];ro=q[po+8>>2]}q[oo>>2]=ro;q[oo+4>>2]=to;q[oo+8>>2]=q[po+16>>2];qo=po+24|0;q[qo>>2]=0;q[qo+4>>2]=0;so=po+16|0;q[so>>2]=0;q[so+4>>2]=0;q[po+8>>2]=0;q[po+12>>2]=0;re(po+8|0);ro=q[so>>2];so=q[po+12>>2];oo=0;c:{if((ro|0)==(so|0)){break c}oo=q[qo>>2]+q[po+28>>2]|0;qo=(oo>>>0)/341|0;oo=q[so+(qo<<2)>>2]+w(oo-w(qo,341)|0,12)|0}q[oo+4>>2]=0;q[oo+8>>2]=0;q[oo>>2]=$k;qo=q[po+28>>2];oo=qo+1|0;q[po+28>>2]=oo;d:{if(oo>>>0<qo>>>0){break d}Io=a+16|0;Co=a+116|0;Do=a+128|0;Eo=a+104|0;Fo=a+92|0;Bo=a+44|0;Go=a+36|0;Jo=a+76|0;while(1){uo=q[po+12>>2];ro=q[po+24>>2];to=oo+ -1|0;qo=ro+to|0;so=(qo>>>0)/341|0;qo=q[uo+(so<<2)>>2]+w(qo-w(so,341)|0,12)|0;xo=q[qo+8>>2];so=q[qo+4>>2];qo=q[qo>>2];q[po+28>>2]=to;to=q[po+16>>2];uo=to-uo|0;if(((uo?w(uo>>2,341)+ -1|0:0)-(oo+ro|0)|0)+1>>>0>=682){An(q[to+ -4>>2]);q[po+16>>2]=q[po+16>>2]+ -4}if(qo>>>0>$k>>>0){break d}oo=q[a+12>>2];to=(so|0)==(oo+ -1|0)?0:so+1|0;if(to>>>0>=oo>>>0){break d}oo=q[Co>>2];ro=w(xo,12);uo=oo+ro|0;e:{wo=to<<2;zo=ro+q[Do>>2]|0;so=q[a>>2]-q[wo+q[zo>>2]>>2]|0;if(!so){if(!qo){break e}ro=0;while(1){oo=q[uo>>2];to=q[oo>>2];q[po+32>>2]=to;q[po+36>>2]=q[oo+4>>2];q[po+40>>2]=q[oo+8>>2];so=q[Ql>>2];xo=so+4|0;oo=q[xo>>2];f:{if(oo>>>0<t[so+8>>2]){q[oo>>2]=to;q[oo+4>>2]=q[po+36>>2];q[oo+8>>2]=q[po+40>>2];q[xo>>2]=oo+12;break f}Dl(so,po+32|0)}q[a+8>>2]=q[a+8>>2]+1;ro=ro+1|0;if((qo|0)!=(ro|0)){continue}break}break e}g:{h:{i:{j:{if(qo>>>0<=2){so=q[Eo>>2];q[so>>2]=to;ro=1;oo=q[a+12>>2];if(oo>>>0>1){break j}break g}if(t[a+8>>2]>t[a+4>>2]){break d}vo=oo;oo=ro+12|0;hd(vo+oo|0,q[uo>>2],q[uo+4>>2]);oo=wo+q[oo+q[Co>>2]>>2]|0;q[oo>>2]=q[oo>>2]+(1<<so+ -1);q[po+32>>2]=0;eh(Io,z(qo)^31,po+32|0);yo=xo+1|0;oo=(qo>>>1)-q[po+32>>2]|0;qo=qo-oo|0;k:{if((qo|0)==(oo|0)){qo=oo;break k}so=q[a+84>>2];if((so|0)==q[Jo>>2]){break i}uo=q[so>>2];vo=q[a+88>>2];zo=vo+1|0;q[a+88>>2]=zo;uo=uo&-2147483648>>>vo;l:{if((zo|0)==32){q[a+88>>2]=0;q[a+84>>2]=so+4;if(uo){break l}break i}if(!uo){break i}}}so=qo;qo=oo;break h}while(1){to=(oo+ -1|0)==(to|0)?0:to+1|0;q[so+(ro<<2)>>2]=to;ro=ro+1|0;oo=q[a+12>>2];if(ro>>>0<oo>>>0){continue}break}break g}so=oo}oo=q[Do>>2];ro=oo+ro|0;uo=q[ro>>2];wo=uo+wo|0;q[wo>>2]=q[wo>>2]+1;hd(oo+w(yo,12)|0,uo,q[ro+4>>2]);if(qo){ro=q[po+28>>2]+q[po+24>>2]|0;uo=q[po+16>>2];oo=q[po+12>>2];wo=uo-oo|0;if((ro|0)==((wo?w(wo>>2,341)+ -1|0:0)|0)){re(po+8|0);ro=q[po+24>>2]+q[po+28>>2]|0;uo=q[po+16>>2];oo=q[po+12>>2]}if((oo|0)==(uo|0)){oo=0}else{vo=oo;oo=(ro>>>0)/341|0;oo=q[vo+(oo<<2)>>2]+w(ro-w(oo,341)|0,12)|0}q[oo+8>>2]=xo;q[oo+4>>2]=to;q[oo>>2]=qo;q[po+28>>2]=q[po+28>>2]+1}if(!so){break e}ro=q[po+28>>2]+q[po+24>>2]|0;uo=q[po+16>>2];oo=q[po+12>>2];qo=uo-oo|0;if((ro|0)==((qo?w(qo>>2,341)+ -1|0:0)|0)){re(po+8|0);ro=q[po+24>>2]+q[po+28>>2]|0;uo=q[po+16>>2];oo=q[po+12>>2]}qo=0;m:{if((oo|0)==(uo|0)){break m}qo=oo;oo=(ro>>>0)/341|0;qo=q[qo+(oo<<2)>>2]+w(ro-w(oo,341)|0,12)|0}q[qo+8>>2]=yo;q[qo+4>>2]=to;q[qo>>2]=so;q[po+28>>2]=q[po+28>>2]+1;break e}if(!qo){break e}xo=0;while(1){n:{if(!oo){ro=q[Fo>>2];break n}ro=q[Fo>>2];Ko=q[Eo>>2];Lo=q[uo>>2];Mo=q[zo>>2];oo=0;while(1){wo=Ko+(oo<<2)|0;q[(q[wo>>2]<<2)+ro>>2]=0;to=q[wo>>2]<<2;so=q[a>>2]-q[to+Mo>>2]|0;o:{if(!so){break o}to=ro+to|0;yo=q[a+48>>2];Ao=32-yo|0;if((so|0)<=(Ao|0)){vo=q[Bo>>2];if((vo|0)==q[Go>>2]){q[to>>2]=0;break o}q[to>>2]=q[vo>>2]<<yo>>>32-so;so=so+q[a+48>>2]|0;q[a+48>>2]=so;if((so|0)!=32){break o}q[a+48>>2]=0;q[Bo>>2]=vo+4;break o}vo=q[Bo>>2];Ho=vo+4|0;if((Ho|0)==q[Go>>2]){q[to>>2]=0;break o}No=q[vo>>2];q[Bo>>2]=Ho;Ao=so-Ao|0;q[a+48>>2]=Ao;q[to>>2]=q[vo+4>>2]>>>32-Ao|No<<yo>>>32-so}so=q[wo>>2]<<2;to=so+ro|0;q[to>>2]=q[to>>2]|q[so+Lo>>2];oo=oo+1|0;if(oo>>>0<t[a+12>>2]){continue}break}}to=q[ro>>2];q[po+32>>2]=to;q[po+36>>2]=q[ro+4>>2];q[po+40>>2]=q[ro+8>>2];so=q[Ql>>2];ro=so+4|0;oo=q[ro>>2];p:{if(oo>>>0<t[so+8>>2]){q[oo>>2]=to;q[oo+4>>2]=q[po+36>>2];q[oo+8>>2]=q[po+40>>2];q[ro>>2]=oo+12;break p}Dl(so,po+32|0)}q[a+8>>2]=q[a+8>>2]+1;xo=xo+1|0;if((xo|0)==(qo|0)){break e}oo=q[a+12>>2];continue}}oo=q[po+28>>2];if(oo){continue}break}}se(po+8|0);a=q[po+12>>2];$k=q[po+16>>2];q:{if((a|0)==($k|0)){break q}while(1){An(q[a>>2]);a=a+4|0;if(($k|0)!=(a|0)){continue}break}a=q[po+16>>2];$k=q[po+12>>2];if((a|0)==($k|0)){break q}q[po+16>>2]=a+(((a-$k|0)+ -4>>>2^-1)<<2)}a=q[po+8>>2];if(a){An(a)}T=po+48|0;return}bn();F()}bn();F()}function Al(a,$k,Ql){var Oo=0,Po=0,Qo=0,Ro=0,So=0,To=0,Uo=0,Vo=0,Wo=0,Xo=0,Yo=0,Zo=0,_o=0,$o=0,ap=0,bp=0,cp=0,dp=0,ep=0,fp=0,gp=0,hp=0,ip=0,jp=0,kp=0;Qo=T-48|0;T=Qo;Oo=q[a+12>>2];q[Qo+16>>2]=0;q[Qo+8>>2]=0;q[Qo+12>>2]=0;a:{if(Oo){if(Oo>>>0>=1073741824){break a}Po=Oo<<2;So=Mm(Po);q[Qo+8>>2]=So;q[Qo+12>>2]=So;q[Qo+16>>2]=Po+So;Ro=Dn(So,0,Po);Po=Oo;while(1){Ro=Ro+4|0;Po=Po+ -1|0;if(Po){continue}break}q[Qo+12>>2]=Ro}Po=q[a+628>>2];To=q[Po>>2];if(To){q[Po+4>>2]=To;An(To);q[Po+8>>2]=0;q[Po>>2]=0;q[Po+4>>2]=0;Ro=q[Qo+12>>2];So=q[Qo+8>>2];Oo=q[a+12>>2]}q[Po>>2]=So;q[Po+4>>2]=Ro;q[Po+8>>2]=q[Qo+16>>2];Ro=0;q[Qo+16>>2]=0;q[Qo+8>>2]=0;q[Qo+12>>2]=0;Po=0;b:{if(Oo){if(Oo>>>0>=1073741824){break b}So=Oo<<2;Po=Mm(So);q[Qo+8>>2]=Po;q[Qo+12>>2]=Po;q[Qo+16>>2]=Po+So;Ro=Dn(Po,0,So);while(1){Ro=Ro+4|0;Oo=Oo+ -1|0;if(Oo){continue}break}q[Qo+12>>2]=Ro}Oo=q[a+640>>2];So=q[Oo>>2];if(So){q[Oo+4>>2]=So;An(So);q[Oo+8>>2]=0;q[Oo>>2]=0;q[Oo+4>>2]=0;Ro=q[Qo+12>>2];Po=q[Qo+8>>2]}q[Oo>>2]=Po;q[Oo+4>>2]=Ro;q[Oo+8>>2]=q[Qo+16>>2];Po=Qo+24|0;q[Po>>2]=0;q[Po+4>>2]=0;So=Qo+16|0;q[So>>2]=0;q[So+4>>2]=0;q[Qo+8>>2]=0;q[Qo+12>>2]=0;re(Qo+8|0);To=q[So>>2];So=q[Qo+12>>2];Oo=0;c:{if((To|0)==(So|0)){break c}Oo=q[Po>>2]+q[Qo+28>>2]|0;Po=(Oo>>>0)/341|0;Oo=q[So+(Po<<2)>>2]+w(Oo-w(Po,341)|0,12)|0}q[Oo+4>>2]=0;q[Oo+8>>2]=0;q[Oo>>2]=$k;Po=q[Qo+28>>2];Oo=Po+1|0;q[Qo+28>>2]=Oo;d:{if(Oo>>>0<Po>>>0){break d}cp=a+640|0;bp=a+628|0;dp=a+616|0;ep=a+604|0;$o=a+556|0;fp=a+548|0;hp=a+588|0;while(1){Vo=q[Qo+12>>2];To=q[Qo+24>>2];Ro=Oo+ -1|0;Po=To+Ro|0;So=(Po>>>0)/341|0;Po=q[Vo+(So<<2)>>2]+w(Po-w(So,341)|0,12)|0;Uo=q[Po+8>>2];Wo=q[Po+4>>2];So=q[Po>>2];q[Qo+28>>2]=Ro;Po=q[Qo+16>>2];Ro=Po-Vo|0;if(((Ro?w(Ro>>2,341)+ -1|0:0)-(Oo+To|0)|0)+1>>>0>=682){An(q[Po+ -4>>2]);q[Qo+16>>2]=q[Qo+16>>2]+ -4}Po=0;if(So>>>0>$k>>>0){break d}Oo=q[bp>>2];Vo=w(Uo,12);Xo=Vo+q[cp>>2]|0;Ro=ml(a,Xo,Wo);if(Ro>>>0>=t[a+12>>2]){break d}To=Oo+Vo|0;e:{f:{Wo=Ro<<2;Zo=q[a>>2]-q[Wo+q[Xo>>2]>>2]|0;if(!Zo){if(!So){break f}while(1){Oo=q[To>>2];Uo=q[Oo>>2];q[Qo+32>>2]=Uo;q[Qo+36>>2]=q[Oo+4>>2];q[Qo+40>>2]=q[Oo+8>>2];Ro=q[Ql>>2];Vo=Ro+4|0;Oo=q[Vo>>2];g:{if(Oo>>>0<t[Ro+8>>2]){q[Oo>>2]=Uo;q[Oo+4>>2]=q[Qo+36>>2];q[Oo+8>>2]=q[Qo+40>>2];q[Vo>>2]=Oo+12;break g}Dl(Ro,Qo+32|0)}q[a+8>>2]=q[a+8>>2]+1;Po=Po+1|0;if((So|0)!=(Po|0)){continue}break}break f}h:{i:{j:{k:{if(So>>>0<=2){Uo=q[dp>>2];q[Uo>>2]=Ro;Po=1;Oo=q[a+12>>2];if(Oo>>>0>1){break k}break h}if(t[a+8>>2]>t[a+4>>2]){break d}Oo=q[bp>>2];Yo=Uo+1|0;Xo=w(Yo,12);Po=Oo+Xo|0;if((Po|0)!=(To|0)){hd(Po,q[To>>2],q[To+4>>2]);Oo=q[bp>>2]}Oo=Wo+q[Oo+Xo>>2]|0;q[Oo>>2]=q[Oo>>2]+(1<<Zo+ -1);Po=0;Oo=0;To=z(So)^31;if(To){while(1){Po=dh(((Oo<<4)+a|0)+16|0)|Po<<1;Oo=Oo+1|0;if((To|0)!=(Oo|0)){continue}break}}Po=(So>>>1)-Po|0;Oo=So-Po|0;l:{if((Oo|0)==(Po|0)){Oo=Po;break l}So=q[a+596>>2];if((So|0)==q[hp>>2]){break j}To=q[So>>2];Zo=q[a+600>>2];ap=Zo+1|0;q[a+600>>2]=ap;To=To&-2147483648>>>Zo;m:{if((ap|0)==32){q[a+600>>2]=0;q[a+596>>2]=So+4;if(To){break m}break j}if(!To){break j}}}So=Oo;Oo=Po;break i}while(1){Ro=(Oo+ -1|0)==(Ro|0)?0:Ro+1|0;q[Uo+(Po<<2)>>2]=Ro;Po=Po+1|0;Oo=q[a+12>>2];if(Po>>>0<Oo>>>0){continue}break}break h}So=Po}Po=q[cp>>2];To=Po+Vo|0;Vo=q[To>>2];Wo=Vo+Wo|0;q[Wo>>2]=q[Wo>>2]+1;hd(Po+Xo|0,Vo,q[To+4>>2]);if(Oo){Vo=q[Qo+28>>2]+q[Qo+24>>2]|0;Xo=q[Qo+16>>2];Po=q[Qo+12>>2];To=Xo-Po|0;if((Vo|0)==((To?w(To>>2,341)+ -1|0:0)|0)){re(Qo+8|0);Vo=q[Qo+24>>2]+q[Qo+28>>2]|0;Xo=q[Qo+16>>2];Po=q[Qo+12>>2]}To=0;n:{if((Po|0)==(Xo|0)){break n}To=Po;Po=(Vo>>>0)/341|0;To=q[To+(Po<<2)>>2]+w(Vo-w(Po,341)|0,12)|0}q[To+8>>2]=Uo;q[To+4>>2]=Ro;q[To>>2]=Oo;q[Qo+28>>2]=q[Qo+28>>2]+1}if(!So){break f}Po=q[Qo+28>>2]+q[Qo+24>>2]|0;To=q[Qo+16>>2];Oo=q[Qo+12>>2];Uo=To-Oo|0;if((Po|0)==((Uo?w(Uo>>2,341)+ -1|0:0)|0)){re(Qo+8|0);To=q[Qo+16>>2];Po=q[Qo+24>>2]+q[Qo+28>>2]|0;Oo=q[Qo+12>>2]}if((Oo|0)==(To|0)){Oo=0}else{To=Oo;Oo=(Po>>>0)/341|0;Oo=q[To+(Oo<<2)>>2]+w(Po-w(Oo,341)|0,12)|0}q[Oo+8>>2]=Yo;q[Oo+4>>2]=Ro;q[Oo>>2]=So;Oo=q[Qo+28>>2]+1|0;q[Qo+28>>2]=Oo;break e}if(!So){break f}Vo=0;while(1){o:{if(!Oo){Po=q[ep>>2];break o}Po=q[ep>>2];ap=q[dp>>2];ip=q[To>>2];jp=q[Xo>>2];Oo=0;while(1){Wo=ap+(Oo<<2)|0;q[(q[Wo>>2]<<2)+Po>>2]=0;Uo=q[Wo>>2]<<2;Ro=q[a>>2]-q[Uo+jp>>2]|0;p:{if(!Ro){break p}Uo=Po+Uo|0;Zo=q[a+560>>2];_o=32-Zo|0;if((Ro|0)<=(_o|0)){Yo=q[$o>>2];if((Yo|0)==q[fp>>2]){q[Uo>>2]=0;break p}q[Uo>>2]=q[Yo>>2]<<Zo>>>32-Ro;Ro=Ro+q[a+560>>2]|0;q[a+560>>2]=Ro;if((Ro|0)!=32){break p}q[a+560>>2]=0;q[$o>>2]=Yo+4;break p}Yo=q[$o>>2];gp=Yo+4|0;if((gp|0)==q[fp>>2]){q[Uo>>2]=0;break p}kp=q[Yo>>2];q[$o>>2]=gp;_o=Ro-_o|0;q[a+560>>2]=_o;q[Uo>>2]=q[Yo+4>>2]>>>32-_o|kp<<Zo>>>32-Ro}Ro=q[Wo>>2]<<2;Uo=Ro+Po|0;q[Uo>>2]=q[Uo>>2]|q[Ro+ip>>2];Oo=Oo+1|0;if(Oo>>>0<t[a+12>>2]){continue}break}}Ro=q[Po>>2];q[Qo+32>>2]=Ro;q[Qo+36>>2]=q[Po+4>>2];q[Qo+40>>2]=q[Po+8>>2];Po=q[Ql>>2];Uo=Po+4|0;Oo=q[Uo>>2];q:{if(Oo>>>0<t[Po+8>>2]){q[Oo>>2]=Ro;q[Oo+4>>2]=q[Qo+36>>2];q[Oo+8>>2]=q[Qo+40>>2];q[Uo>>2]=Oo+12;break q}Dl(Po,Qo+32|0)}q[a+8>>2]=q[a+8>>2]+1;Vo=Vo+1|0;if((Vo|0)==(So|0)){break f}Oo=q[a+12>>2];continue}}Oo=q[Qo+28>>2]}if(Oo){continue}break}}se(Qo+8|0);a=q[Qo+12>>2];$k=q[Qo+16>>2];r:{if((a|0)==($k|0)){break r}while(1){An(q[a>>2]);a=a+4|0;if(($k|0)!=(a|0)){continue}break}a=q[Qo+16>>2];$k=q[Qo+12>>2];if((a|0)==($k|0)){break r}q[Qo+16>>2]=a+(((a-$k|0)+ -4>>>2^-1)<<2)}a=q[Qo+8>>2];if(a){An(a)}T=Qo+48|0;return}bn();F()}bn();F()}function Bl(a,$k,Ql){var lp=0,mp=0,np=0,op=0,pp=0,qp=0,rp=0,sp=0,tp=0,up=0,vp=0,wp=0,xp=0,yp=0,zp=0,Ap=0,Bp=0,Cp=0,Dp=0,Ep=0,Fp=0,Gp=0,Hp=0,Ip=0,Jp=0;np=T-48|0;T=np;lp=q[a+12>>2];q[np+16>>2]=0;q[np+8>>2]=0;q[np+12>>2]=0;a:{if(lp){if(lp>>>0>=1073741824){break a}mp=lp<<2;pp=Mm(mp);q[np+8>>2]=pp;q[np+12>>2]=pp;q[np+16>>2]=mp+pp;qp=Dn(pp,0,mp);mp=lp;while(1){qp=qp+4|0;mp=mp+ -1|0;if(mp){continue}break}q[np+12>>2]=qp}mp=q[a+628>>2];op=q[mp>>2];if(op){q[mp+4>>2]=op;An(op);q[mp+8>>2]=0;q[mp>>2]=0;q[mp+4>>2]=0;qp=q[np+12>>2];pp=q[np+8>>2];lp=q[a+12>>2]}q[mp>>2]=pp;q[mp+4>>2]=qp;q[mp+8>>2]=q[np+16>>2];qp=0;q[np+16>>2]=0;q[np+8>>2]=0;q[np+12>>2]=0;mp=0;b:{if(lp){if(lp>>>0>=1073741824){break b}pp=lp<<2;mp=Mm(pp);q[np+8>>2]=mp;q[np+12>>2]=mp;q[np+16>>2]=mp+pp;qp=Dn(mp,0,pp);while(1){qp=qp+4|0;lp=lp+ -1|0;if(lp){continue}break}q[np+12>>2]=qp}lp=q[a+640>>2];pp=q[lp>>2];if(pp){q[lp+4>>2]=pp;An(pp);q[lp+8>>2]=0;q[lp>>2]=0;q[lp+4>>2]=0;qp=q[np+12>>2];mp=q[np+8>>2]}q[lp>>2]=mp;q[lp+4>>2]=qp;q[lp+8>>2]=q[np+16>>2];mp=np+24|0;q[mp>>2]=0;q[mp+4>>2]=0;pp=np+16|0;q[pp>>2]=0;q[pp+4>>2]=0;q[np+8>>2]=0;q[np+12>>2]=0;re(np+8|0);op=q[pp>>2];pp=q[np+12>>2];lp=0;c:{if((op|0)==(pp|0)){break c}lp=q[mp>>2]+q[np+28>>2]|0;mp=(lp>>>0)/341|0;lp=q[pp+(mp<<2)>>2]+w(lp-w(mp,341)|0,12)|0}q[lp+4>>2]=0;q[lp+8>>2]=0;q[lp>>2]=$k;mp=q[np+28>>2];lp=mp+1|0;q[np+28>>2]=lp;d:{if(lp>>>0<mp>>>0){break d}zp=a+628|0;Ap=a+640|0;Bp=a+616|0;Cp=a+604|0;yp=a+556|0;Dp=a+548|0;Fp=a+588|0;while(1){sp=q[np+12>>2];qp=q[np+24>>2];rp=lp+ -1|0;mp=qp+rp|0;pp=(mp>>>0)/341|0;mp=q[sp+(pp<<2)>>2]+w(mp-w(pp,341)|0,12)|0;up=q[mp+8>>2];op=q[mp+4>>2];pp=q[mp>>2];q[np+28>>2]=rp;mp=q[np+16>>2];rp=mp-sp|0;if(((rp?w(rp>>2,341)+ -1|0:0)-(lp+qp|0)|0)+1>>>0>=682){An(q[mp+ -4>>2]);q[np+16>>2]=q[np+16>>2]+ -4}if(pp>>>0>$k>>>0){break d}lp=q[a+12>>2];qp=(op|0)==(lp+ -1|0)?0:op+1|0;if(qp>>>0>=lp>>>0){break d}lp=q[zp>>2];op=w(up,12);rp=lp+op|0;e:{f:{sp=qp<<2;wp=op+q[Ap>>2]|0;mp=q[a>>2]-q[sp+q[wp>>2]>>2]|0;if(!mp){if(!pp){break f}mp=0;while(1){lp=q[rp>>2];qp=q[lp>>2];q[np+32>>2]=qp;q[np+36>>2]=q[lp+4>>2];q[np+40>>2]=q[lp+8>>2];op=q[Ql>>2];up=op+4|0;lp=q[up>>2];g:{if(lp>>>0<t[op+8>>2]){q[lp>>2]=qp;q[lp+4>>2]=q[np+36>>2];q[lp+8>>2]=q[np+40>>2];q[up>>2]=lp+12;break g}Dl(op,np+32|0)}q[a+8>>2]=q[a+8>>2]+1;mp=mp+1|0;if((pp|0)!=(mp|0)){continue}break}break f}h:{i:{j:{k:{if(pp>>>0<=2){op=q[Bp>>2];q[op>>2]=qp;mp=1;lp=q[a+12>>2];if(lp>>>0>1){break k}break h}if(t[a+8>>2]>t[a+4>>2]){break d}tp=lp;lp=op+12|0;hd(tp+lp|0,q[rp>>2],q[rp+4>>2]);lp=sp+q[lp+q[zp>>2]>>2]|0;q[lp>>2]=q[lp>>2]+(1<<mp+ -1);mp=0;lp=0;rp=z(pp)^31;if(rp){while(1){mp=dh(((lp<<4)+a|0)+16|0)|mp<<1;lp=lp+1|0;if((rp|0)!=(lp|0)){continue}break}}vp=up+1|0;mp=(pp>>>1)-mp|0;lp=pp-mp|0;l:{if((lp|0)==(mp|0)){lp=mp;break l}pp=q[a+596>>2];if((pp|0)==q[Fp>>2]){break j}rp=q[pp>>2];tp=q[a+600>>2];wp=tp+1|0;q[a+600>>2]=wp;rp=rp&-2147483648>>>tp;m:{if((wp|0)==32){q[a+600>>2]=0;q[a+596>>2]=pp+4;if(rp){break m}break j}if(!rp){break j}}}pp=lp;lp=mp;break i}while(1){qp=(lp+ -1|0)==(qp|0)?0:qp+1|0;q[op+(mp<<2)>>2]=qp;mp=mp+1|0;lp=q[a+12>>2];if(mp>>>0<lp>>>0){continue}break}break h}pp=mp}mp=q[Ap>>2];op=mp+op|0;rp=q[op>>2];sp=rp+sp|0;q[sp>>2]=q[sp>>2]+1;hd(mp+w(vp,12)|0,rp,q[op+4>>2]);if(lp){rp=q[np+28>>2]+q[np+24>>2]|0;sp=q[np+16>>2];mp=q[np+12>>2];op=sp-mp|0;if((rp|0)==((op?w(op>>2,341)+ -1|0:0)|0)){re(np+8|0);rp=q[np+24>>2]+q[np+28>>2]|0;sp=q[np+16>>2];mp=q[np+12>>2]}op=0;n:{if((mp|0)==(sp|0)){break n}op=mp;mp=(rp>>>0)/341|0;op=q[op+(mp<<2)>>2]+w(rp-w(mp,341)|0,12)|0}q[op+8>>2]=up;q[op+4>>2]=qp;q[op>>2]=lp;q[np+28>>2]=q[np+28>>2]+1}if(!pp){break f}mp=q[np+28>>2]+q[np+24>>2]|0;rp=q[np+16>>2];lp=q[np+12>>2];op=rp-lp|0;if((mp|0)==((op?w(op>>2,341)+ -1|0:0)|0)){re(np+8|0);rp=q[np+16>>2];mp=q[np+24>>2]+q[np+28>>2]|0;lp=q[np+12>>2]}if((lp|0)==(rp|0)){lp=0}else{op=lp;lp=(mp>>>0)/341|0;lp=q[op+(lp<<2)>>2]+w(mp-w(lp,341)|0,12)|0}q[lp+8>>2]=vp;q[lp+4>>2]=qp;q[lp>>2]=pp;lp=q[np+28>>2]+1|0;q[np+28>>2]=lp;break e}if(!pp){break f}up=0;while(1){o:{if(!lp){mp=q[Cp>>2];break o}mp=q[Cp>>2];Gp=q[Bp>>2];Hp=q[rp>>2];Ip=q[wp>>2];lp=0;while(1){sp=Gp+(lp<<2)|0;q[(q[sp>>2]<<2)+mp>>2]=0;qp=q[sp>>2]<<2;op=q[a>>2]-q[qp+Ip>>2]|0;p:{if(!op){break p}qp=mp+qp|0;vp=q[a+560>>2];xp=32-vp|0;if((op|0)<=(xp|0)){tp=q[yp>>2];if((tp|0)==q[Dp>>2]){q[qp>>2]=0;break p}q[qp>>2]=q[tp>>2]<<vp>>>32-op;op=op+q[a+560>>2]|0;q[a+560>>2]=op;if((op|0)!=32){break p}q[a+560>>2]=0;q[yp>>2]=tp+4;break p}tp=q[yp>>2];Ep=tp+4|0;if((Ep|0)==q[Dp>>2]){q[qp>>2]=0;break p}Jp=q[tp>>2];q[yp>>2]=Ep;xp=op-xp|0;q[a+560>>2]=xp;q[qp>>2]=q[tp+4>>2]>>>32-xp|Jp<<vp>>>32-op}op=q[sp>>2]<<2;qp=op+mp|0;q[qp>>2]=q[qp>>2]|q[op+Hp>>2];lp=lp+1|0;if(lp>>>0<t[a+12>>2]){continue}break}}op=q[mp>>2];q[np+32>>2]=op;q[np+36>>2]=q[mp+4>>2];q[np+40>>2]=q[mp+8>>2];mp=q[Ql>>2];qp=mp+4|0;lp=q[qp>>2];q:{if(lp>>>0<t[mp+8>>2]){q[lp>>2]=op;q[lp+4>>2]=q[np+36>>2];q[lp+8>>2]=q[np+40>>2];q[qp>>2]=lp+12;break q}Dl(mp,np+32|0)}q[a+8>>2]=q[a+8>>2]+1;up=up+1|0;if((up|0)==(pp|0)){break f}lp=q[a+12>>2];continue}}lp=q[np+28>>2]}if(lp){continue}break}}se(np+8|0);a=q[np+12>>2];$k=q[np+16>>2];r:{if((a|0)==($k|0)){break r}while(1){An(q[a>>2]);a=a+4|0;if(($k|0)!=(a|0)){continue}break}a=q[np+16>>2];$k=q[np+12>>2];if((a|0)==($k|0)){break r}q[np+16>>2]=a+(((a-$k|0)+ -4>>>2^-1)<<2)}a=q[np+8>>2];if(a){An(a)}T=np+48|0;return}bn();F()}bn();F()}function Cl(a,$k,Ql){var Kp=0,Lp=0,Mp=0,Np=0,Op=0,Pp=0,Qp=0,Rp=0,Sp=0,Tp=0,Up=0,Vp=0,Wp=0,Xp=0,Yp=0,Zp=0,_p=0,$p=0,aq=0,bq=0,cq=0,dq=0,eq=0,fq=0,gq=0;Mp=T-48|0;T=Mp;Kp=q[a+12>>2];q[Mp+16>>2]=0;q[Mp+8>>2]=0;q[Mp+12>>2]=0;a:{if(Kp){if(Kp>>>0>=1073741824){break a}Lp=Kp<<2;Op=Mm(Lp);q[Mp+8>>2]=Op;q[Mp+12>>2]=Op;q[Mp+16>>2]=Lp+Op;Np=Dn(Op,0,Lp);Lp=Kp;while(1){Np=Np+4|0;Lp=Lp+ -1|0;if(Lp){continue}break}q[Mp+12>>2]=Np}Lp=q[a+628>>2];Pp=q[Lp>>2];if(Pp){q[Lp+4>>2]=Pp;An(Pp);q[Lp+8>>2]=0;q[Lp>>2]=0;q[Lp+4>>2]=0;Np=q[Mp+12>>2];Op=q[Mp+8>>2];Kp=q[a+12>>2]}q[Lp>>2]=Op;q[Lp+4>>2]=Np;q[Lp+8>>2]=q[Mp+16>>2];Np=0;q[Mp+16>>2]=0;q[Mp+8>>2]=0;q[Mp+12>>2]=0;Lp=0;b:{if(Kp){if(Kp>>>0>=1073741824){break b}Op=Kp<<2;Lp=Mm(Op);q[Mp+8>>2]=Lp;q[Mp+12>>2]=Lp;q[Mp+16>>2]=Lp+Op;Np=Dn(Lp,0,Op);while(1){Np=Np+4|0;Kp=Kp+ -1|0;if(Kp){continue}break}q[Mp+12>>2]=Np}Kp=q[a+640>>2];Op=q[Kp>>2];if(Op){q[Kp+4>>2]=Op;An(Op);q[Kp+8>>2]=0;q[Kp>>2]=0;q[Kp+4>>2]=0;Np=q[Mp+12>>2];Lp=q[Mp+8>>2]}q[Kp>>2]=Lp;q[Kp+4>>2]=Np;q[Kp+8>>2]=q[Mp+16>>2];Lp=Mp+24|0;q[Lp>>2]=0;q[Lp+4>>2]=0;Op=Mp+16|0;q[Op>>2]=0;q[Op+4>>2]=0;q[Mp+8>>2]=0;q[Mp+12>>2]=0;re(Mp+8|0);Pp=q[Op>>2];Op=q[Mp+12>>2];Kp=0;c:{if((Pp|0)==(Op|0)){break c}Kp=q[Lp>>2]+q[Mp+28>>2]|0;Lp=(Kp>>>0)/341|0;Kp=q[Op+(Lp<<2)>>2]+w(Kp-w(Lp,341)|0,12)|0}q[Kp+4>>2]=0;q[Kp+8>>2]=0;q[Kp>>2]=$k;Lp=q[Mp+28>>2];Kp=Lp+1|0;q[Mp+28>>2]=Kp;d:{if(Kp>>>0<Lp>>>0){break d}_p=a+640|0;Zp=a+628|0;$p=a+616|0;aq=a+604|0;Xp=a+556|0;bq=a+548|0;dq=a+588|0;while(1){Rp=q[Mp+12>>2];Pp=q[Mp+24>>2];Np=Kp+ -1|0;Lp=Pp+Np|0;Op=(Lp>>>0)/341|0;Lp=q[Rp+(Op<<2)>>2]+w(Lp-w(Op,341)|0,12)|0;Qp=q[Lp+8>>2];Op=q[Lp>>2];q[Mp+28>>2]=Np;Lp=q[Mp+16>>2];Np=Lp-Rp|0;if(((Np?w(Np>>2,341)+ -1|0:0)-(Kp+Pp|0)|0)+1>>>0>=682){An(q[Lp+ -4>>2]);q[Mp+16>>2]=q[Mp+16>>2]+ -4}Lp=0;if(Op>>>0>$k>>>0){break d}Kp=q[Zp>>2];Rp=w(Qp,12);Sp=Rp+q[_p>>2]|0;Np=nl(a,Op,Sp);if(Np>>>0>=t[a+12>>2]){break d}Pp=Kp+Rp|0;e:{f:{Tp=Np<<2;Vp=q[a>>2]-q[Tp+q[Sp>>2]>>2]|0;if(!Vp){if(!Op){break f}while(1){Kp=q[Pp>>2];Qp=q[Kp>>2];q[Mp+32>>2]=Qp;q[Mp+36>>2]=q[Kp+4>>2];q[Mp+40>>2]=q[Kp+8>>2];Np=q[Ql>>2];Rp=Np+4|0;Kp=q[Rp>>2];g:{if(Kp>>>0<t[Np+8>>2]){q[Kp>>2]=Qp;q[Kp+4>>2]=q[Mp+36>>2];q[Kp+8>>2]=q[Mp+40>>2];q[Rp>>2]=Kp+12;break g}Dl(Np,Mp+32|0)}q[a+8>>2]=q[a+8>>2]+1;Lp=Lp+1|0;if((Op|0)!=(Lp|0)){continue}break}break f}h:{i:{j:{k:{if(Op>>>0<=2){Qp=q[$p>>2];q[Qp>>2]=Np;Lp=1;Kp=q[a+12>>2];if(Kp>>>0>1){break k}break h}if(t[a+8>>2]>t[a+4>>2]){break d}Kp=q[Zp>>2];Up=Qp+1|0;Sp=w(Up,12);Lp=Kp+Sp|0;if((Lp|0)!=(Pp|0)){hd(Lp,q[Pp>>2],q[Pp+4>>2]);Kp=q[Zp>>2]}Kp=Tp+q[Kp+Sp>>2]|0;q[Kp>>2]=q[Kp>>2]+(1<<Vp+ -1);Lp=0;Kp=0;Pp=z(Op)^31;if(Pp){while(1){Lp=dh(((Kp<<4)+a|0)+16|0)|Lp<<1;Kp=Kp+1|0;if((Pp|0)!=(Kp|0)){continue}break}}Lp=(Op>>>1)-Lp|0;Kp=Op-Lp|0;l:{if((Kp|0)==(Lp|0)){Kp=Lp;break l}Op=q[a+596>>2];if((Op|0)==q[dq>>2]){break j}Pp=q[Op>>2];Vp=q[a+600>>2];Yp=Vp+1|0;q[a+600>>2]=Yp;Pp=Pp&-2147483648>>>Vp;m:{if((Yp|0)==32){q[a+600>>2]=0;q[a+596>>2]=Op+4;if(Pp){break m}break j}if(!Pp){break j}}}Op=Kp;Kp=Lp;break i}while(1){Np=(Kp+ -1|0)==(Np|0)?0:Np+1|0;q[Qp+(Lp<<2)>>2]=Np;Lp=Lp+1|0;Kp=q[a+12>>2];if(Lp>>>0<Kp>>>0){continue}break}break h}Op=Lp}Lp=q[_p>>2];Pp=Lp+Rp|0;Rp=q[Pp>>2];Tp=Rp+Tp|0;q[Tp>>2]=q[Tp>>2]+1;hd(Lp+Sp|0,Rp,q[Pp+4>>2]);if(Kp){Rp=q[Mp+28>>2]+q[Mp+24>>2]|0;Sp=q[Mp+16>>2];Lp=q[Mp+12>>2];Pp=Sp-Lp|0;if((Rp|0)==((Pp?w(Pp>>2,341)+ -1|0:0)|0)){re(Mp+8|0);Rp=q[Mp+24>>2]+q[Mp+28>>2]|0;Sp=q[Mp+16>>2];Lp=q[Mp+12>>2]}Pp=0;n:{if((Lp|0)==(Sp|0)){break n}Pp=Lp;Lp=(Rp>>>0)/341|0;Pp=q[Pp+(Lp<<2)>>2]+w(Rp-w(Lp,341)|0,12)|0}q[Pp+8>>2]=Qp;q[Pp+4>>2]=Np;q[Pp>>2]=Kp;q[Mp+28>>2]=q[Mp+28>>2]+1}if(!Op){break f}Lp=q[Mp+28>>2]+q[Mp+24>>2]|0;Pp=q[Mp+16>>2];Kp=q[Mp+12>>2];Qp=Pp-Kp|0;if((Lp|0)==((Qp?w(Qp>>2,341)+ -1|0:0)|0)){re(Mp+8|0);Pp=q[Mp+16>>2];Lp=q[Mp+24>>2]+q[Mp+28>>2]|0;Kp=q[Mp+12>>2]}if((Kp|0)==(Pp|0)){Kp=0}else{Pp=Kp;Kp=(Lp>>>0)/341|0;Kp=q[Pp+(Kp<<2)>>2]+w(Lp-w(Kp,341)|0,12)|0}q[Kp+8>>2]=Up;q[Kp+4>>2]=Np;q[Kp>>2]=Op;Kp=q[Mp+28>>2]+1|0;q[Mp+28>>2]=Kp;break e}if(!Op){break f}Rp=0;while(1){o:{if(!Kp){Lp=q[aq>>2];break o}Lp=q[aq>>2];Yp=q[$p>>2];eq=q[Pp>>2];fq=q[Sp>>2];Kp=0;while(1){Tp=Yp+(Kp<<2)|0;q[(q[Tp>>2]<<2)+Lp>>2]=0;Qp=q[Tp>>2]<<2;Np=q[a>>2]-q[Qp+fq>>2]|0;p:{if(!Np){break p}Qp=Lp+Qp|0;Vp=q[a+560>>2];Wp=32-Vp|0;if((Np|0)<=(Wp|0)){Up=q[Xp>>2];if((Up|0)==q[bq>>2]){q[Qp>>2]=0;break p}q[Qp>>2]=q[Up>>2]<<Vp>>>32-Np;Np=Np+q[a+560>>2]|0;q[a+560>>2]=Np;if((Np|0)!=32){break p}q[a+560>>2]=0;q[Xp>>2]=Up+4;break p}Up=q[Xp>>2];cq=Up+4|0;if((cq|0)==q[bq>>2]){q[Qp>>2]=0;break p}gq=q[Up>>2];q[Xp>>2]=cq;Wp=Np-Wp|0;q[a+560>>2]=Wp;q[Qp>>2]=q[Up+4>>2]>>>32-Wp|gq<<Vp>>>32-Np}Np=q[Tp>>2]<<2;Qp=Np+Lp|0;q[Qp>>2]=q[Qp>>2]|q[Np+eq>>2];Kp=Kp+1|0;if(Kp>>>0<t[a+12>>2]){continue}break}}Np=q[Lp>>2];q[Mp+32>>2]=Np;q[Mp+36>>2]=q[Lp+4>>2];q[Mp+40>>2]=q[Lp+8>>2];Lp=q[Ql>>2];Qp=Lp+4|0;Kp=q[Qp>>2];q:{if(Kp>>>0<t[Lp+8>>2]){q[Kp>>2]=Np;q[Kp+4>>2]=q[Mp+36>>2];q[Kp+8>>2]=q[Mp+40>>2];q[Qp>>2]=Kp+12;break q}Dl(Lp,Mp+32|0)}q[a+8>>2]=q[a+8>>2]+1;Rp=Rp+1|0;if((Rp|0)==(Op|0)){break f}Kp=q[a+12>>2];continue}}Kp=q[Mp+28>>2]}if(Kp){continue}break}}se(Mp+8|0);a=q[Mp+12>>2];$k=q[Mp+16>>2];r:{if((a|0)==($k|0)){break r}while(1){An(q[a>>2]);a=a+4|0;if(($k|0)!=(a|0)){continue}break}a=q[Mp+16>>2];$k=q[Mp+12>>2];if((a|0)==($k|0)){break r}q[Mp+16>>2]=a+(((a-$k|0)+ -4>>>2^-1)<<2)}a=q[Mp+8>>2];if(a){An(a)}T=Mp+48|0;return}bn();F()}bn();F()}function Dl(a,$k){var Ql=0,Dn=0,hq=0,iq=0,jq=0,kq=0;a:{hq=q[a+4>>2];jq=q[a>>2];Dn=(hq-jq|0)/12|0;iq=Dn+1|0;if(iq>>>0<357913942){kq=w(Dn,12);Ql=(q[a+8>>2]-jq|0)/12|0;Dn=Ql<<1;Dn=Ql>>>0<178956970?Dn>>>0<iq>>>0?iq:Dn:357913941;iq=0;b:{if(!Dn){break b}if(Dn>>>0>=357913942){break a}iq=Mm(w(Dn,12))}Ql=kq+iq|0;q[Ql>>2]=q[$k>>2];q[Ql+4>>2]=q[$k+4>>2];q[Ql+8>>2]=q[$k+8>>2];Dn=iq+w(Dn,12)|0;$k=Ql+12|0;if((hq|0)!=(jq|0)){while(1){Ql=Ql+ -12|0;hq=hq+ -12|0;q[Ql>>2]=q[hq>>2];q[Ql+4>>2]=q[hq+4>>2];q[Ql+8>>2]=q[hq+8>>2];if((hq|0)!=(jq|0)){continue}break}hq=jq}q[a>>2]=Ql;q[a+8>>2]=Dn;q[a+4>>2]=$k;if(hq){An(hq)}return}bn();F()}ab(14557);F()}function El(a){var $k=0;$k=r[a+74|0];o[a+74|0]=$k+ -1|$k;$k=q[a>>2];if($k&8){q[a>>2]=$k|32;return-1}q[a+4>>2]=0;q[a+8>>2]=0;$k=q[a+44>>2];q[a+28>>2]=$k;q[a+20>>2]=$k;q[a+16>>2]=$k+q[a+48>>2];return 0}function Fl(a,Mm,bn){var An=0,lq=0,mq=0,nq=0;An=q[bn+16>>2];a:{if(!An){if(El(bn)){break a}An=q[bn+16>>2]}mq=q[bn+20>>2];if(An-mq>>>0<Mm>>>0){return n[q[bn+36>>2]](bn,a,Mm)|0}b:{if(o[bn+75|0]<0){break b}lq=Mm;while(1){An=lq;if(!An){break b}lq=An+ -1|0;if(r[lq+a|0]!=10){continue}break}lq=n[q[bn+36>>2]](bn,a,An)|0;if(lq>>>0<An>>>0){break a}Mm=Mm-An|0;a=a+An|0;mq=q[bn+20>>2];nq=An}Cn(mq,a,Mm);q[bn+20>>2]=q[bn+20>>2]+Mm;lq=Mm+nq|0}return lq}function Gl(a,Mm,bn){a:{if(q[bn+76>>2]<=-1){a=Fl(a,Mm,bn);break a}a=Fl(a,Mm,bn)}}function Hl(a){a=a|0}function Il(a,Mm,bn,oq,pq){var qq=0,rq=0,sq=0;qq=T-208|0;T=qq;q[qq+204>>2]=bn;bn=0;Dn(qq+160|0,0,40);q[qq+200>>2]=q[qq+204>>2];a:{if((Jl(0,Mm,qq+200|0,qq+80|0,qq+160|0,oq,pq)|0)<0){Mm=-1;break a}bn=q[a+76>>2]>=0?1:bn;rq=q[a>>2];if(o[a+74|0]<=0){q[a>>2]=rq&-33}sq=rq&32;b:{if(q[a+48>>2]){Mm=Jl(a,Mm,qq+200|0,qq+80|0,qq+160|0,oq,pq);break b}q[a+48>>2]=80;q[a+16>>2]=qq+80;q[a+28>>2]=qq;q[a+20>>2]=qq;rq=q[a+44>>2];q[a+44>>2]=qq;oq=Jl(a,Mm,qq+200|0,qq+80|0,qq+160|0,oq,pq);Mm=oq;if(!rq){break b}n[q[a+36>>2]](a,0,0)|0;q[a+48>>2]=0;q[a+44>>2]=rq;q[a+28>>2]=0;q[a+16>>2]=0;Mm=q[a+20>>2];q[a+20>>2]=0;Mm=Mm?oq:-1}oq=a;a=q[a>>2];q[oq>>2]=a|sq;Mm=a&32?-1:Mm;if(!bn){break a}}T=qq+208|0;return Mm}function Jl(a,Mm,bn,oq,pq,tq,uq){var vq=0,wq=0,xq=0,yq=0,zq=0,Aq=0,Bq=0,Cq=0,Dq=0,Eq=0,Fq=0,Gq=0,Hq=0,Iq=0,Jq=0;vq=T-80|0;T=vq;q[vq+76>>2]=Mm;Jq=vq+55|0;Gq=vq+56|0;Mm=0;a:{b:while(1){c:{if((Dq|0)<0){break c}if((Mm|0)>(2147483647-Dq|0)){q[4458]=61;Dq=-1;break c}Dq=Mm+Dq|0}d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{zq=q[vq+76>>2];Mm=zq;yq=r[Mm|0];if(yq){while(1){r:{s:{wq=yq&255;t:{if(!wq){yq=Mm;break t}if((wq|0)!=37){break s}yq=Mm;while(1){if(r[Mm+1|0]!=37){break t}wq=Mm+2|0;q[vq+76>>2]=wq;yq=yq+1|0;xq=r[Mm+2|0];Mm=wq;if((xq|0)==37){continue}break}}Mm=yq-zq|0;if(a){Kl(a,zq,Mm)}if(Mm){continue b}Eq=-1;yq=1;wq=vq;Aq=!Zl(o[q[vq+76>>2]+1|0]);Mm=q[vq+76>>2];if(!(Aq|r[Mm+2|0]!=36)){Eq=o[Mm+1|0]+ -48|0;Hq=1;yq=3}Mm=yq+Mm|0;q[wq+76>>2]=Mm;yq=0;Fq=o[Mm|0];xq=Fq+ -32|0;u:{if(xq>>>0>31){wq=Mm;break u}wq=Mm;xq=1<<xq;if(!(xq&75913)){break u}while(1){wq=Mm+1|0;q[vq+76>>2]=wq;yq=xq|yq;Fq=o[Mm+1|0];xq=Fq+ -32|0;if(xq>>>0>31){break u}Mm=wq;xq=1<<xq;if(xq&75913){continue}break}}v:{if((Fq|0)==42){Aq=vq;w:{x:{if(!Zl(o[wq+1|0])){break x}Mm=q[vq+76>>2];if(r[Mm+2|0]!=36){break x}q[((o[Mm+1|0]<<2)+pq|0)+ -192>>2]=10;Bq=q[((o[Mm+1|0]<<3)+oq|0)+ -384>>2];Hq=1;Mm=Mm+3|0;break w}if(Hq){break q}Hq=0;Bq=0;if(a){Mm=q[bn>>2];q[bn>>2]=Mm+4;Bq=q[Mm>>2]}Mm=q[vq+76>>2]+1|0}q[Aq+76>>2]=Mm;if((Bq|0)>-1){break v}Bq=0-Bq|0;yq=yq|8192;break v}Bq=Ll(vq+76|0);if((Bq|0)<0){break q}Mm=q[vq+76>>2]}xq=-1;y:{if(r[Mm|0]!=46){break y}if(r[Mm+1|0]==42){z:{if(!Zl(o[Mm+2|0])){break z}Mm=q[vq+76>>2];if(r[Mm+3|0]!=36){break z}q[((o[Mm+2|0]<<2)+pq|0)+ -192>>2]=10;xq=q[((o[Mm+2|0]<<3)+oq|0)+ -384>>2];Mm=Mm+4|0;q[vq+76>>2]=Mm;break y}if(Hq){break q}if(a){Mm=q[bn>>2];q[bn>>2]=Mm+4;xq=q[Mm>>2]}else{xq=0}Mm=q[vq+76>>2]+2|0;q[vq+76>>2]=Mm;break y}q[vq+76>>2]=Mm+1;xq=Ll(vq+76|0);Mm=q[vq+76>>2]}wq=0;while(1){Iq=wq;Cq=-1;if(o[Mm|0]+ -65>>>0>57){break a}Fq=Mm+1|0;q[vq+76>>2]=Fq;wq=o[Mm|0];Mm=Fq;wq=r[(wq+w(Iq,58)|0)+14591|0];if(wq+ -1>>>0<8){continue}break}if(!wq){break a}A:{B:{C:{if((wq|0)==19){if((Eq|0)<=-1){break C}break a}if((Eq|0)<0){break B}q[(Eq<<2)+pq>>2]=wq;Mm=(Eq<<3)+oq|0;wq=q[Mm+4>>2];q[vq+64>>2]=q[Mm>>2];q[vq+68>>2]=wq}Mm=0;if(!a){continue b}break A}if(!a){break d}Ml(vq- -64|0,wq,bn,uq);Fq=q[vq+76>>2]}Aq=yq&-65537;yq=yq&8192?Aq:yq;Cq=0;Eq=14625;wq=Gq;Mm=o[Fq+ -1|0];Mm=Iq?(Mm&15)==3?Mm&-33:Mm:Mm;Fq=Mm+ -88|0;if(Fq>>>0<=32){break r}D:{E:{F:{G:{Aq=Mm+ -65|0;if(Aq>>>0>6){if((Mm|0)!=83){break e}if(!xq){break G}wq=q[vq+64>>2];break E}switch(Aq-1|0){case 1:break F;case 0:case 2:break e;default:break p}}Mm=0;Nl(a,32,Bq,0,yq);break D}q[vq+12>>2]=0;q[vq+8>>2]=q[vq+64>>2];q[vq+64>>2]=vq+8;xq=-1;wq=vq+8|0}Mm=0;H:{while(1){zq=q[wq>>2];if(!zq){break H}zq=_l(vq+4|0,zq);Aq=(zq|0)<0;if(!(Aq|zq>>>0>xq-Mm>>>0)){wq=wq+4|0;Mm=Mm+zq|0;if(xq>>>0>Mm>>>0){continue}break H}break}Cq=-1;if(Aq){break a}}Nl(a,32,Bq,Mm,yq);if(!Mm){Mm=0;break D}xq=0;wq=q[vq+64>>2];while(1){zq=q[wq>>2];if(!zq){break D}zq=_l(vq+4|0,zq);xq=zq+xq|0;if((xq|0)>(Mm|0)){break D}Kl(a,vq+4|0,zq);wq=wq+4|0;if(xq>>>0<Mm>>>0){continue}break}}Nl(a,32,Bq,Mm,yq^8192);Mm=(Bq|0)>(Mm|0)?Bq:Mm;continue b}wq=Mm+1|0;q[vq+76>>2]=wq;yq=r[Mm+1|0];Mm=wq;continue}break}switch(Fq-1|0){case 21:break i;case 23:break k;case 22:break l;case 11:case 16:break m;case 10:break n;case 26:break o;case 8:case 12:case 13:case 14:break p;case 0:case 1:case 2:case 3:case 4:case 5:case 6:case 7:case 9:case 15:case 17:case 18:case 19:case 20:case 24:case 25:case 27:case 29:case 30:break e;case 28:break h;default:break j}}Cq=Dq;if(a){break a}if(!Hq){break d}Mm=1;while(1){a=q[(Mm<<2)+pq>>2];if(a){Ml((Mm<<3)+oq|0,a,bn,uq);Cq=1;Mm=Mm+1|0;if((Mm|0)!=10){continue}break a}break}Cq=1;if(Mm>>>0>=10){break a}while(1){if(q[(Mm<<2)+pq>>2]){break q}a=Mm>>>0>8;Mm=Mm+1|0;if(!a){continue}break}break a}Cq=-1;break a}Mm=n[tq](a,v[vq+64>>3],Bq,xq,yq,Mm)|0;continue}Mm=q[vq+64>>2];zq=Mm?Mm:14635;Mm=em(zq,xq);wq=Mm?Mm:xq+zq|0;yq=Aq;xq=Mm?Mm-zq|0:xq;break e}o[vq+55|0]=q[vq+64>>2];xq=1;zq=Jq;yq=Aq;break e}Aq=q[vq+68>>2];Mm=Aq;zq=q[vq+64>>2];if((Mm|0)<-1?1:(Mm|0)<=-1?zq>>>0>4294967295?0:1:0){Mm=0-(Mm+(0<zq>>>0)|0)|0;zq=0-zq|0;q[vq+64>>2]=zq;q[vq+68>>2]=Mm;Cq=1;Eq=14625;break g}if(yq&2048){Cq=1;Eq=14626;break g}Cq=yq&1;Eq=Cq?14627:14625;break g}zq=Ol(q[vq+64>>2],q[vq+68>>2],Gq);if(!(yq&8)){break f}Mm=Gq-zq|0;xq=(xq|0)>(Mm|0)?xq:Mm+1|0;break f}xq=xq>>>0>8?xq:8;yq=yq|8;Mm=120}zq=Pl(q[vq+64>>2],q[vq+68>>2],Gq,Mm&32);if(!(yq&8)|!(q[vq+64>>2]|q[vq+68>>2])){break f}Eq=(Mm>>>4)+14625|0;Cq=2;break f}Mm=0;wq=Iq&255;if(wq>>>0>7){continue}I:{switch(wq-1|0){default:q[q[vq+64>>2]>>2]=Dq;continue;case 0:q[q[vq+64>>2]>>2]=Dq;continue;case 1:wq=q[vq+64>>2];q[wq>>2]=Dq;q[wq+4>>2]=Dq>>31;continue;case 2:p[q[vq+64>>2]>>1]=Dq;continue;case 3:o[q[vq+64>>2]]=Dq;continue;case 5:q[q[vq+64>>2]>>2]=Dq;continue;case 4:continue;case 6:break I}}wq=q[vq+64>>2];q[wq>>2]=Dq;q[wq+4>>2]=Dq>>31;continue}zq=q[vq+64>>2];Mm=q[vq+68>>2];Eq=14625}zq=Ql(zq,Mm,Gq)}yq=(xq|0)>-1?yq&-65537:yq;Mm=q[vq+64>>2];Aq=q[vq+68>>2];J:{if(!(!!(Mm|Aq)|xq)){zq=Gq;xq=0;break J}Mm=!(Mm|Aq)+(Gq-zq|0)|0;xq=(xq|0)>(Mm|0)?xq:Mm}}Aq=wq-zq|0;xq=(xq|0)<(Aq|0)?Aq:xq;wq=xq+Cq|0;Mm=(Bq|0)<(wq|0)?wq:Bq;Nl(a,32,Mm,wq,yq);Kl(a,Eq,Cq);Nl(a,48,Mm,wq,yq^65536);Nl(a,48,xq,Aq,0);Kl(a,zq,Aq);Nl(a,32,Mm,wq,yq^8192);continue}break}Cq=0}T=vq+80|0;return Cq}function Kl(a,q,Mm){if(!(r[a|0]&32)){Fl(q,Mm,a)}}function Ll(a){var Mm=0,bn=0,oq=0;if(Zl(o[q[a>>2]])){while(1){Mm=q[a>>2];oq=o[Mm|0];q[a>>2]=Mm+1;bn=(w(bn,10)+oq|0)+ -48|0;if(Zl(o[Mm+1|0])){continue}break}}return bn}function Ml(a,pq,tq,uq){a:{b:{if(pq>>>0>20){break b}pq=pq+ -9|0;if(pq>>>0>9){break b}c:{switch(pq-1|0){default:pq=q[tq>>2];q[tq>>2]=pq+4;q[a>>2]=q[pq>>2];return;case 0:pq=q[tq>>2];q[tq>>2]=pq+4;pq=q[pq>>2];q[a>>2]=pq;q[a+4>>2]=pq>>31;return;case 1:pq=q[tq>>2];q[tq>>2]=pq+4;q[a>>2]=q[pq>>2];q[a+4>>2]=0;return;case 3:pq=q[tq>>2];q[tq>>2]=pq+4;pq=p[pq>>1];q[a>>2]=pq;q[a+4>>2]=pq>>31;return;case 4:pq=q[tq>>2];q[tq>>2]=pq+4;q[a>>2]=s[pq>>1];q[a+4>>2]=0;return;case 5:pq=q[tq>>2];q[tq>>2]=pq+4;pq=o[pq|0];q[a>>2]=pq;q[a+4>>2]=pq>>31;return;case 6:pq=q[tq>>2];q[tq>>2]=pq+4;q[a>>2]=r[pq|0];q[a+4>>2]=0;return;case 2:case 7:break a;case 8:break c}}n[uq](a,tq)}return}pq=q[tq>>2]+7&-8;q[tq>>2]=pq+8;tq=q[pq+4>>2];q[a>>2]=q[pq>>2];q[a+4>>2]=tq}function Nl(a,q,pq,tq,uq){var Kq=0,Lq=0,Mq=0;Kq=T-256|0;T=Kq;if(!(uq&73728|(pq|0)<=(tq|0))){uq=pq-tq|0;Lq=uq>>>0<256;Dn(Kq,q,Lq?uq:256);q=a;Mq=Kq;if(!Lq){pq=pq-tq|0;while(1){Kl(a,Kq,256);uq=uq+ -256|0;if(uq>>>0>255){continue}break}uq=pq&255}Kl(q,Mq,uq)}T=Kq+256|0}function Ol(a,q,pq){if(a|q){while(1){pq=pq+ -1|0;o[pq|0]=a&7|48;a=(q&7)<<29|a>>>3;q=q>>>3;if(a|q){continue}break}}return pq}function Pl(a,q,pq,tq){if(a|q){while(1){pq=pq+ -1|0;o[pq|0]=r[(a&15)+15120|0]|tq;a=(q&15)<<28|a>>>4;q=q>>>4;if(a|q){continue}break}}return pq}function Ql(a,q,pq){var tq=0,uq=0,Nq=0;a:{if((q|0)==1&a>>>0<0|q>>>0<1){tq=a;break a}while(1){tq=bo(a,q,10,0);uq=V;Nq=uq;uq=$n(tq,uq,10,0);pq=pq+ -1|0;o[pq|0]=a-uq|48;uq=(q|0)==9&a>>>0>4294967295|q>>>0>9;a=tq;q=Nq;if(uq){continue}break}}if(tq){while(1){pq=pq+ -1|0;a=(tq>>>0)/10|0;o[pq|0]=tq-w(a,10)|48;q=tq>>>0>9;tq=a;if(q){continue}break}}return pq}function Rl(a,q,pq){return Il(a,q,pq,355,356)}function Sl(a,pq,Oq,Pq,Qq,Rq){a=a|0;pq=+pq;Oq=Oq|0;Pq=Pq|0;Qq=Qq|0;Rq=Rq|0;var Sq=0,Tq=0,Uq=0,Vq=0,Wq=0,Xq=0,Yq=0,Zq=0,_q=0,$q=0,ar=0,br=0,cr=0,dr=0,er=0,fr=0,gr=0,hr=0,ir=0,jr=0,kr=0,lr=0,mr=0,nr=0,or=0;Wq=T-560|0;T=Wq;q[Wq+44>>2]=0;h(+pq);Sq=e(1)|0;a:{if(jr=1,kr=(mr=e(0)>>>0>4294967295?0:1,nr=0,or=(Sq|0)<=-1,or?mr:nr),lr=(Sq|0)<-1,lr?jr:kr){pq=-pq;h(+pq);Sq=e(1)|0;e(0)|0;er=1;fr=15136;break a}if(Qq&2048){er=1;fr=15139;break a}er=Qq&1;fr=er?15142:15137}b:{if((Sq&2146435072)==2146435072){Yq=er+3|0;Nl(a,32,Oq,Yq,Qq&-65537);Kl(a,fr,er);Pq=Rq>>>5&1;Kl(a,pq!=pq?Pq?15163:15167:Pq?15155:15159,3);break b}pq=am(pq,Wq+44|0);pq=pq+pq;if(pq!=0){q[Wq+44>>2]=q[Wq+44>>2]+ -1}br=Wq+16|0;gr=Rq|32;if((gr|0)==97){Xq=Rq&32;Tq=Xq?fr+9|0:fr;c:{if(Pq>>>0>11){break c}Sq=12-Pq|0;if(!Sq){break c}cr=8;while(1){cr=cr*16;Sq=Sq+ -1|0;if(Sq){continue}break}if(r[Tq|0]==45){pq=-(cr+(-pq-cr));break c}pq=pq+cr-cr}Vq=q[Wq+44>>2];Sq=Vq>>31;Sq=Ql(Sq^Sq+Vq,0,br);if((br|0)==(Sq|0)){o[Wq+15|0]=48;Sq=Wq+15|0}Vq=er|2;Uq=q[Wq+44>>2];_q=Sq+ -2|0;o[_q|0]=Rq+15;o[Sq+ -1|0]=(Uq|0)<0?45:43;fr=Qq&8;Uq=Wq+16|0;while(1){Rq=Uq;Yq=Xq;if(y(pq)<2147483648){Sq=~~pq}else{Sq=-2147483648}o[Uq|0]=Yq|r[Sq+15120|0];pq=(pq- +(Sq|0))*16;Uq=Rq+1|0;if(!((Uq-(Wq+16|0)|0)!=1|(pq==0?!((Pq|0)>0|fr):0))){o[Rq+1|0]=46;Uq=Rq+2|0}if(pq!=0){continue}break}Rq=a;Sq=Oq;if(!Pq|((Uq-Wq|0)+ -18|0)>=(Pq|0)){Xq=((br-(Wq+16|0)|0)-_q|0)+Uq|0}else{Xq=((Pq+br|0)-_q|0)+2|0}Pq=Xq;Yq=Pq+Vq|0;Nl(Rq,32,Sq,Yq,Qq);Kl(a,Tq,Vq);Nl(a,48,Oq,Yq,Qq^65536);Rq=Uq-(Wq+16|0)|0;Kl(a,Wq+16|0,Rq);Pq=br-_q|0;Nl(a,48,Xq-(Pq+Rq|0)|0,0,0);Kl(a,_q,Pq);break b}Sq=(Pq|0)<0;d:{if(pq==0){Tq=q[Wq+44>>2];break d}Tq=q[Wq+44>>2]+ -28|0;q[Wq+44>>2]=Tq;pq=pq*268435456}Xq=Sq?6:Pq;_q=(Tq|0)<0?Wq+48|0:Wq+336|0;Vq=_q;while(1){Pq=Vq;if(pq<4294967296&pq>=0){Sq=~~pq>>>0}else{Sq=0}q[Pq>>2]=Sq;Vq=Vq+4|0;pq=(pq- +(Sq>>>0))*1e9;if(pq!=0){continue}break}e:{if((Tq|0)<1){Sq=Vq;Uq=_q;break e}Uq=_q;while(1){Zq=(Tq|0)<29?Tq:29;Sq=Vq+ -4|0;f:{if(Sq>>>0<Uq>>>0){break f}Pq=Zq;Tq=0;while(1){Yq=Sq;hr=Tq;ar=q[Sq>>2];$q=Pq&31;if(32<=(Pq&63)>>>0){Tq=ar<<$q;ar=0}else{Tq=(1<<$q)-1&ar>>>32-$q;ar=ar<<$q}$q=hr+ar|0;Tq=Tq+ir|0;Tq=$q>>>0<ar>>>0?Tq+1|0:Tq;Tq=bo($q,Tq,1e9,0);ar=Yq;Yq=$n(Tq,V,1e9,0);q[ar>>2]=$q-Yq;Sq=Sq+ -4|0;if(Sq>>>0>=Uq>>>0){continue}break}if(!Tq){break f}Uq=Uq+ -4|0;q[Uq>>2]=Tq}while(1){Sq=Vq;if(Sq>>>0>Uq>>>0){Vq=Sq+ -4|0;if(!q[Vq>>2]){continue}}break}Tq=q[Wq+44>>2]-Zq|0;q[Wq+44>>2]=Tq;Vq=Sq;if((Tq|0)>0){continue}break}}if((Tq|0)<=-1){dr=((Xq+25|0)/9|0)+1|0;Zq=(gr|0)==102;while(1){Pq=(Tq|0)<-9?9:0-Tq|0;g:{if(Uq>>>0>=Sq>>>0){Uq=q[Uq>>2]?Uq:Uq+4|0;break g}Yq=1e9>>>Pq;$q=-1<<Pq^-1;Tq=0;Vq=Uq;while(1){ar=Tq;Tq=q[Vq>>2];q[Vq>>2]=ar+(Tq>>>Pq);Tq=w(Yq,Tq&$q);Vq=Vq+4|0;if(Vq>>>0<Sq>>>0){continue}break}Uq=q[Uq>>2]?Uq:Uq+4|0;if(!Tq){break g}q[Sq>>2]=Tq;Sq=Sq+4|0}Tq=Pq+q[Wq+44>>2]|0;q[Wq+44>>2]=Tq;Pq=Zq?_q:Uq;Sq=Sq-Pq>>2>(dr|0)?Pq+(dr<<2)|0:Sq;if((Tq|0)<0){continue}break}}Vq=0;h:{if(Uq>>>0>=Sq>>>0){break h}Vq=w(_q-Uq>>2,9);Tq=10;Pq=q[Uq>>2];if(Pq>>>0<10){break h}while(1){Vq=Vq+1|0;Tq=w(Tq,10);if(Pq>>>0>=Tq>>>0){continue}break}}Pq=(Xq-((gr|0)==102?0:Vq)|0)-((gr|0)==103&(Xq|0)!=0)|0;if((Pq|0)<(w(Sq-_q>>2,9)+ -9|0)){Tq=Pq+9216|0;Yq=(Tq|0)/9|0;Zq=(_q+(Yq<<2)|0)+ -4092|0;Pq=10;Tq=Tq-w(Yq,9)|0;if((Tq|0)<=7){while(1){Pq=w(Pq,10);Yq=(Tq|0)<7;Tq=Tq+1|0;if(Yq){continue}break}}Yq=q[Zq>>2];$q=(Yq>>>0)/(Pq>>>0)|0;dr=Zq+4|0;Tq=Yq-w(Pq,$q)|0;i:{if(Tq?0:(dr|0)==(Sq|0)){break i}ar=Pq>>>1;cr=Tq>>>0<ar>>>0?.5:(Sq|0)==(dr|0)?(ar|0)==(Tq|0)?1:1.5:1.5;pq=$q&1?9007199254740994:9007199254740992;if(!(!er|r[fr|0]!=45)){cr=-cr;pq=-pq}Tq=Yq-Tq|0;q[Zq>>2]=Tq;if(pq+cr==pq){break i}Pq=Pq+Tq|0;q[Zq>>2]=Pq;if(Pq>>>0>=1e9){while(1){q[Zq>>2]=0;Zq=Zq+ -4|0;if(Zq>>>0<Uq>>>0){Uq=Uq+ -4|0;q[Uq>>2]=0}Pq=q[Zq>>2]+1|0;q[Zq>>2]=Pq;if(Pq>>>0>999999999){continue}break}}Vq=w(_q-Uq>>2,9);Tq=10;Pq=q[Uq>>2];if(Pq>>>0<10){break i}while(1){Vq=Vq+1|0;Tq=w(Tq,10);if(Pq>>>0>=Tq>>>0){continue}break}}Pq=Zq+4|0;Sq=Sq>>>0>Pq>>>0?Pq:Sq}j:{while(1){Tq=Sq;Zq=0;if(Sq>>>0<=Uq>>>0){break j}Sq=Tq+ -4|0;if(!q[Sq>>2]){continue}break}Zq=1}k:{if((gr|0)!=103){$q=Qq&8;break k}Pq=Xq?Xq:1;Sq=(Pq|0)>(Vq|0)&(Vq|0)>-5;Xq=(Sq?Vq^-1:-1)+Pq|0;Rq=(Sq?-1:-2)+Rq|0;$q=Qq&8;if($q){break k}Sq=9;l:{if(!Zq){break l}Yq=q[Tq+ -4>>2];if(!Yq){break l}Pq=10;Sq=0;if((Yq>>>0)%10){break l}while(1){Sq=Sq+1|0;Pq=w(Pq,10);if(!((Yq>>>0)%(Pq>>>0))){continue}break}}Pq=w(Tq-_q>>2,9)+ -9|0;if((Rq|32)==102){$q=0;Pq=Pq-Sq|0;Pq=(Pq|0)>0?Pq:0;Xq=(Xq|0)<(Pq|0)?Xq:Pq;break k}$q=0;Pq=(Pq+Vq|0)-Sq|0;Pq=(Pq|0)>0?Pq:0;Xq=(Xq|0)<(Pq|0)?Xq:Pq}gr=Xq|$q;ar=(gr|0)!=0;Pq=a;hr=Oq;ir=Rq|32;Sq=(Vq|0)>0?Vq:0;m:{if((ir|0)==102){break m}Sq=Vq>>31;Sq=Ql(Sq+Vq^Sq,0,br);if((br-Sq|0)<=1){while(1){Sq=Sq+ -1|0;o[Sq|0]=48;if((br-Sq|0)<2){continue}break}}dr=Sq+ -2|0;o[dr|0]=Rq;o[Sq+ -1|0]=(Vq|0)<0?45:43;Sq=br-dr|0}Yq=(Sq+(ar+(Xq+er|0)|0)|0)+1|0;Nl(Pq,32,hr,Yq,Qq);Kl(a,fr,er);Nl(a,48,Oq,Yq,Qq^65536);n:{o:{p:{if((ir|0)==102){Pq=Wq+16|8;Rq=Wq+16|9;Vq=Uq>>>0>_q>>>0?_q:Uq;Uq=Vq;while(1){Sq=Ql(q[Uq>>2],0,Rq);q:{if((Uq|0)!=(Vq|0)){if(Sq>>>0<=Wq+16>>>0){break q}while(1){Sq=Sq+ -1|0;o[Sq|0]=48;if(Sq>>>0>Wq+16>>>0){continue}break}break q}if((Rq|0)!=(Sq|0)){break q}o[Wq+24|0]=48;Sq=Pq}Kl(a,Sq,Rq-Sq|0);Uq=Uq+4|0;if(Uq>>>0<=_q>>>0){continue}break}if(gr){Kl(a,15171,1)}if((Xq|0)<1|Uq>>>0>=Tq>>>0){break p}while(1){Sq=Ql(q[Uq>>2],0,Rq);if(Sq>>>0>Wq+16>>>0){while(1){Sq=Sq+ -1|0;o[Sq|0]=48;if(Sq>>>0>Wq+16>>>0){continue}break}}Kl(a,Sq,(Xq|0)<9?Xq:9);Sq=Xq+ -9|0;Uq=Uq+4|0;if(Uq>>>0>=Tq>>>0){break o}Pq=(Xq|0)>9;Xq=Sq;if(Pq){continue}break}break o}r:{if((Xq|0)<0){break r}_q=Zq?Tq:Uq+4|0;Pq=Wq+16|8;Rq=Wq+16|9;Vq=Uq;while(1){Sq=Ql(q[Vq>>2],0,Rq);if((Rq|0)==(Sq|0)){o[Wq+24|0]=48;Sq=Pq}s:{if((Uq|0)!=(Vq|0)){if(Sq>>>0<=Wq+16>>>0){break s}while(1){Sq=Sq+ -1|0;o[Sq|0]=48;if(Sq>>>0>Wq+16>>>0){continue}break}break s}Kl(a,Sq,1);Sq=Sq+1|0;if((Xq|0)<1?!$q:0){break s}Kl(a,15171,1)}Tq=Sq;Sq=Rq-Sq|0;Kl(a,Tq,(Xq|0)>(Sq|0)?Sq:Xq);Xq=Xq-Sq|0;Vq=Vq+4|0;if(Vq>>>0>=_q>>>0){break r}if((Xq|0)>-1){continue}break}}Nl(a,48,Xq+18|0,18,0);Kl(a,dr,br-dr|0);break n}Sq=Xq}Nl(a,48,Sq+9|0,9,0)}}Nl(a,32,Oq,Yq,Qq^8192);T=Wq+560|0;return((Yq|0)<(Oq|0)?Oq:Yq)|0}function Tl(a,pq){a=a|0;pq=pq|0;var Oq=0,Pq=0,Qq=0;Oq=pq;pq=q[pq>>2]+15&-16;q[Oq>>2]=pq+16;Pq=a,Qq=im(q[pq>>2],q[pq+4>>2],q[pq+8>>2],q[pq+12>>2]),v[Pq>>3]=Qq}function Ul(a,pq,Rq){a=a|0;pq=pq|0;Rq=Rq|0;var pr=0,qr=0,rr=0,sr=0,tr=0,ur=0;pr=T-32|0;T=pr;qr=q[a+28>>2];q[pr+16>>2]=qr;rr=q[a+20>>2];q[pr+28>>2]=Rq;q[pr+24>>2]=pq;pq=rr-qr|0;q[pr+20>>2]=pq;rr=pq+Rq|0;tr=2;pq=pr+16|0;while(1){a:{b:{if(fm(K(q[a+60>>2],pq|0,tr|0,pr+12|0)|0)){q[pr+12>>2]=-1;qr=-1;break b}qr=q[pr+12>>2]}c:{if((qr|0)==(rr|0)){pq=q[a+44>>2];q[a+28>>2]=pq;q[a+20>>2]=pq;q[a+16>>2]=pq+q[a+48>>2];a=Rq;break c}if((qr|0)>-1){break a}q[a+28>>2]=0;q[a+16>>2]=0;q[a+20>>2]=0;q[a>>2]=q[a>>2]|32;a=0;if((tr|0)==2){break c}a=Rq-q[pq+4>>2]|0}T=pr+32|0;return a|0}sr=q[pq+4>>2];ur=qr>>>0>sr>>>0;pq=ur?pq+8|0:pq;sr=qr-(ur?sr:0)|0;q[pq>>2]=sr+q[pq>>2];q[pq+4>>2]=q[pq+4>>2]-sr;rr=rr-qr|0;tr=tr-ur|0;continue}}function Vl(a,pq,Rq,vr){a=a|0;pq=pq|0;Rq=Rq|0;vr=vr|0;var wr=0;wr=T-16|0;T=wr;a:{if(!fm(S(q[a+60>>2],pq|0,Rq|0,vr&255,wr+8|0)|0)){pq=q[wr+12>>2];a=q[wr+8>>2];break a}q[wr+8>>2]=-1;q[wr+12>>2]=-1;pq=-1;a=-1}T=wr+16|0;V=pq;return a|0}function Wl(a){a=a|0;return L(q[a+60>>2])|0}function Xl(a,q,pq,Rq){a=a|0;q=q|0;pq=pq|0;Rq=Rq|0;V=0;return 0}function Yl(a,pq){var Rq=0;Rq=T-16|0;T=Rq;q[Rq+12>>2]=pq;Il(q[3795],a,pq,0,0);T=Rq+16|0}function Zl(a){return a+ -48>>>0<10}function _l(a,q){if(!a){return 0}return $l(a,q)}function $l(a,pq){a:{if(a){if(pq>>>0<=127){break a}b:{if(!q[q[4181]>>2]){if((pq&-128)==57216){break a}break b}if(pq>>>0<=2047){o[a+1|0]=pq&63|128;o[a|0]=pq>>>6|192;return 2}if(!((pq&-8192)!=57344?pq>>>0>=55296:0)){o[a+2|0]=pq&63|128;o[a|0]=pq>>>12|224;o[a+1|0]=pq>>>6&63|128;return 3}if(pq+ -65536>>>0<=1048575){o[a+3|0]=pq&63|128;o[a|0]=pq>>>18|240;o[a+2|0]=pq>>>6&63|128;o[a+1|0]=pq>>>12&63|128;return 4}}q[4458]=25;a=-1}else{a=1}return a}o[a|0]=pq;return 1}function am(a,pq){var vr=0,xr=0,yr=0;h(+a);vr=e(1)|0;xr=e(0)|0;yr=vr;vr=vr>>>20&2047;if((vr|0)!=2047){if(!vr){vr=pq;if(a==0){pq=0}else{a=am(a*0x10000000000000000,pq);pq=q[pq>>2]+ -64|0}q[vr>>2]=pq;return a}q[pq>>2]=vr+ -1022;f(0,xr|0);f(1,yr&-2146435073|1071644672);a=+g()}return a}function bm(a){var q=0,pq=0,zr=0,Ar=0,Br=0,Cr=0;while(1){q=a;a=q+1|0;pq=o[q|0];if((pq|0)==32|pq+ -9>>>0<5){continue}break}pq=o[q|0];Ar=pq+ -43|0;a:{if(Ar>>>0>2){break a}b:{switch(Ar-1|0){case 1:Br=1;break;case 0:break a;default:break b}}pq=o[a|0];q=a;Cr=Br}if(Zl(pq)){while(1){zr=(w(zr,10)-o[q|0]|0)+48|0;a=o[q+1|0];q=q+1|0;if(Zl(a)){continue}break}}return Cr?zr:0-zr|0}function cm(a,Dr,Er){var Fr=0,Gr=0,Hr=0;a:{if(!Er){break a}while(1){Fr=r[a|0];Gr=r[Dr|0];if((Fr|0)==(Gr|0)){Dr=Dr+1|0;a=a+1|0;Er=Er+ -1|0;if(Er){continue}break a}break}Hr=Fr-Gr|0}return Hr}function dm(a){var Dr=0,Er=0,Ir=0;a:{b:{Dr=a;if(!(Dr&3)){break b}if(!r[a|0]){break a}while(1){Dr=Dr+1|0;if(!(Dr&3)){break b}if(r[Dr|0]){continue}break}break a}while(1){Er=Dr;Dr=Dr+4|0;Ir=q[Er>>2];if(!((Ir^-1)&Ir+ -16843009&-2139062144)){continue}break}if(!(Ir&255)){Dr=Er;break a}while(1){Ir=r[Er+1|0];Dr=Er+1|0;Er=Dr;if(Ir){continue}break}}return Dr-a|0}function em(a,Jr){var Kr=0,Lr=0,Mr=0;Kr=(Jr|0)!=0;a:{b:{c:{d:{if(!Jr|!(a&3)){break d}while(1){if(!r[a|0]){break c}a=a+1|0;Jr=Jr+ -1|0;Kr=(Jr|0)!=0;if(!Jr){break d}if(a&3){continue}break}}if(!Kr){break b}}if(!r[a|0]){break a}e:{if(Jr>>>0>=4){Kr=Jr+ -4|0;Lr=Kr&-4;Kr=Kr-Lr|0;Lr=(a+Lr|0)+4|0;while(1){Mr=q[a>>2];if((Mr^-1)&Mr+ -16843009&-2139062144){break e}a=a+4|0;Jr=Jr+ -4|0;if(Jr>>>0>3){continue}break}Jr=Kr;a=Lr}if(!Jr){break b}}while(1){if(!r[a|0]){break a}a=a+1|0;Jr=Jr+ -1|0;if(Jr){continue}break}}return 0}return a}function fm(a){if(!a){return 0}q[4458]=a;return-1}function gm(a,Jr,Nr,Or,Pr,Qr){var Rr=0,Sr=0,Tr=0,Ur=0;a:{if(Qr&64){Or=Jr;Pr=Qr+ -64|0;Jr=Pr&31;if(32<=(Pr&63)>>>0){Pr=Or<<Jr;Or=0}else{Pr=(1<<Jr)-1&Or>>>32-Jr|Nr<<Jr;Or=Or<<Jr}Jr=0;Nr=0;break a}if(!Qr){break a}Rr=Or;Tr=Qr;Or=Qr&31;if(32<=(Qr&63)>>>0){Sr=Rr<<Or;Ur=0}else{Sr=(1<<Or)-1&Rr>>>32-Or|Pr<<Or;Ur=Rr<<Or}Or=Nr;Rr=Jr;Qr=64-Qr|0;Pr=Qr&31;if(32<=(Qr&63)>>>0){Qr=0;Or=Or>>>Pr}else{Qr=Or>>>Pr;Or=((1<<Pr)-1&Or)<<32-Pr|Rr>>>Pr}Or=Ur|Or;Pr=Qr|Sr;Qr=Jr;Jr=Tr&31;if(32<=(Tr&63)>>>0){Sr=Qr<<Jr;Jr=0}else{Sr=(1<<Jr)-1&Qr>>>32-Jr|Nr<<Jr;Jr=Qr<<Jr}Nr=Sr}q[a>>2]=Jr;q[a+4>>2]=Nr;q[a+8>>2]=Or;q[a+12>>2]=Pr}function hm(a,Jr,Nr,Or,Pr,Qr){var Vr=0,Wr=0,Xr=0,Yr=0;a:{b:{if(Qr&64){Nr=Qr+ -64|0;Jr=Nr&31;if(32<=(Nr&63)>>>0){Nr=0;Jr=Pr>>>Jr}else{Nr=Pr>>>Jr;Jr=((1<<Jr)-1&Pr)<<32-Jr|Or>>>Jr}Or=0;Pr=0;break b}if(!Qr){break a}Wr=Pr;Xr=Or;Yr=64-Qr|0;Vr=Yr&31;if(32<=(Yr&63)>>>0){Wr=Xr<<Vr;Yr=0}else{Wr=(1<<Vr)-1&Xr>>>32-Vr|Wr<<Vr;Yr=Xr<<Vr}Xr=Jr;Vr=Qr;Jr=Vr&31;if(32<=(Vr&63)>>>0){Vr=0;Jr=Nr>>>Jr}else{Vr=Nr>>>Jr;Jr=((1<<Jr)-1&Nr)<<32-Jr|Xr>>>Jr}Jr=Yr|Jr;Nr=Vr|Wr;Vr=Or;Or=Qr&31;if(32<=(Qr&63)>>>0){Wr=0;Or=Pr>>>Or}else{Wr=Pr>>>Or;Or=((1<<Or)-1&Pr)<<32-Or|Vr>>>Or}Pr=Wr}}q[a>>2]=Jr;q[a+4>>2]=Nr;q[a+8>>2]=Or;q[a+12>>2]=Pr}function im(a,Jr,Nr,Or){var Pr=0,Qr=0,Zr=0,_r=0,$r=0,as=0,bs=0;Zr=T-32|0;T=Zr;Pr=Or&2147483647;$r=Pr;Pr=Pr+ -1006698496|0;_r=Nr;Qr=Nr;if(Nr>>>0<0){Pr=Pr+1|0}as=Qr;Qr=Pr;Pr=$r+ -1140785152|0;bs=_r;if(_r>>>0<0){Pr=Pr+1|0}a:{if((Pr|0)==(Qr|0)&as>>>0<bs>>>0|Qr>>>0<Pr>>>0){Pr=Or<<4|Nr>>>28;Nr=Nr<<4|Jr>>>28;Jr=Jr&268435455;_r=Jr;if((Jr|0)==134217728&a>>>0>=1|Jr>>>0>134217728){Pr=Pr+1073741824|0;a=Nr+1|0;if(a>>>0<1){Pr=Pr+1|0}Qr=a;break a}Qr=Nr;Pr=Pr-((Nr>>>0<0)+ -1073741824|0)|0;if(a|_r^134217728){break a}a=Qr+(Qr&1)|0;if(a>>>0<Qr>>>0){Pr=Pr+1|0}Qr=a;break a}if(!(!_r&($r|0)==2147418112?!(a|Jr):($r|0)==2147418112&_r>>>0<0|$r>>>0<2147418112)){Pr=Or<<4|Nr>>>28;Qr=Nr<<4|Jr>>>28;Pr=Pr&524287|2146959360;break a}Qr=0;Pr=2146435072;if(($r|0)==1140785151&_r>>>0>4294967295|$r>>>0>1140785151){break a}Pr=0;_r=$r>>>16;if(_r>>>0<15249){break a}Pr=Or&65535|65536;hm(Zr,a,Jr,Nr,Pr,15361-_r|0);gm(Zr+16|0,a,Jr,Nr,Pr,_r+ -15233|0);Nr=q[Zr+4>>2];a=q[Zr+8>>2];Pr=q[Zr+12>>2]<<4|a>>>28;Qr=a<<4|Nr>>>28;a=Nr&268435455;Nr=a;Jr=q[Zr>>2]|((q[Zr+16>>2]|q[Zr+24>>2])!=0|(q[Zr+20>>2]|q[Zr+28>>2])!=0);if((a|0)==134217728&Jr>>>0>=1|a>>>0>134217728){a=Qr+1|0;if(a>>>0<1){Pr=Pr+1|0}Qr=a;break a}if(Jr|Nr^134217728){break a}a=Qr+(Qr&1)|0;if(a>>>0<Qr>>>0){Pr=Pr+1|0}Qr=a}T=Zr+32|0;f(0,Qr|0);f(1,Or&-2147483648|Pr);return+g()}function jm(a){var Jr=0,Nr=0,Or=0,cs=0,ds=0,es=0,fs=0,gs=0;cs=T-16|0;T=cs;q[cs+12>>2]=a;a:{if(a>>>0<=211){a=q[km(15184,15376,cs+12|0)>>2];break a}ds=(a>>>0)/210|0;Or=w(ds,210);q[cs+8>>2]=a-Or;es=km(15376,15568,cs+8|0)-15376>>2;b:{while(1){a=q[(es<<2)+15376>>2]+Or|0;Or=5;c:{d:{e:{while(1){if((Or|0)==47){break e}Jr=q[(Or<<2)+15184>>2];Nr=(a>>>0)/(Jr>>>0)|0;fs=Nr>>>0<Jr>>>0;gs=fs?a:gs;Or=Or+1|0;Jr=fs?1:(w(Jr,Nr)|0)==(a|0)?7:0;if(!Jr){continue}break}Or=Jr+ -4|0;if(Or>>>0>3){break b}switch(Or-1|0){case 0:case 1:break b;case 2:break d;default:break e}}Or=211;while(1){Jr=(a>>>0)/(Or>>>0)|0;if(Jr>>>0<Or>>>0){break c}if((w(Jr,Or)|0)==(a|0)){break d}Jr=Or+10|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+12|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+16|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+18|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+22|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+28|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+30|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+36|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+40|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+42|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+46|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+52|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+58|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+60|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+66|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+70|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+72|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+78|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+82|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+88|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+96|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+100|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+102|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+106|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+108|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+112|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+120|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+126|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+130|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+136|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+138|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+142|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+148|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+150|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+156|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+162|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+166|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+168|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+172|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+178|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+180|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+186|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+190|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+192|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+196|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+198|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}if((w(Jr,Nr)|0)==(a|0)){break d}Jr=Or+208|0;Nr=(a>>>0)/(Jr>>>0)|0;if(Nr>>>0<Jr>>>0){break c}Or=Or+210|0;if((w(Jr,Nr)|0)!=(a|0)){continue}break}}Or=es+1|0;a=(Or|0)==48;es=a?0:Or;ds=a+ds|0;Or=w(ds,210);continue}break}q[cs+12>>2]=a;break a}q[cs+12>>2]=a;a=gs}T=cs+16|0;return a}function km(a,hs,is){return lm(a,hs,is)}function lm(a,hs,is){var js=0;js=T-16|0;T=js;a=mm(a,hs,is);T=js+16|0;return a}function mm(a,hs,is){var ks=0,ls=0,ms=0,ns=0;ks=T-16|0;T=ks;hs=hs-a>>2;while(1){if(hs){q[ks+12>>2]=a;ls=ks+12|0;ms=ls;ns=q[ls>>2];ls=hs>>>1;q[ms>>2]=ns+(ls<<2);if(nm(q[ks+12>>2],is)){a=q[ks+12>>2]+4|0;q[ks+12>>2]=a;hs=(ls^-1)+hs|0}else{hs=ls}continue}break}T=ks+16|0;return a}function nm(a,hs){return t[a>>2]<t[hs>>2]}function om(a,hs,is){if(is){Cn(a,hs,is)}}function pm(a,hs){return qm(a,hs)}function qm(a,hs){var is=0,os=0;is=T-16|0;T=is;os=nm(a,hs);T=is+16|0;return os?hs:a}function rm(a){q[a>>2]=0;q[a+4>>2]=0;q[a+8>>2]=0}function sm(a,hs){var ps=0,qs=0;ps=r[a|0];qs=r[hs|0];a:{if(!ps|(ps|0)!=(qs|0)){break a}while(1){qs=r[hs+1|0];ps=r[a+1|0];if(!ps){break a}hs=hs+1|0;a=a+1|0;if((ps|0)==(qs|0)){continue}break}}return ps-qs|0}function tm(){var a=0,hs=0,rs=0;a=T-16|0;T=a;a:{if(M(a+12|0,a+8|0)){break a}hs=zn((q[a+12>>2]<<2)+4|0);q[4475]=hs;if(!hs){break a}b:{hs=zn(q[a+8>>2]);if(hs){rs=q[4475];if(rs){break b}}q[4475]=0;break a}q[(q[a+12>>2]<<2)+rs>>2]=0;if(!N(q[4475],hs|0)){break a}q[4475]=0}T=a+16|0}function um(ss,ts,us){var vs=0,ws=0;vs=T-160|0;T=vs;Cn(vs+8|0,15568,144);a:{b:{if(ts+ -1>>>0>=2147483647){if(ts){break b}ts=1;ss=vs+159|0}q[vs+52>>2]=ss;q[vs+28>>2]=ss;ws=-2-ss|0;ts=ts>>>0>ws>>>0?ws:ts;q[vs+56>>2]=ts;ss=ss+ts|0;q[vs+36>>2]=ss;q[vs+24>>2]=ss;ss=Rl(vs+8|0,15793,us);if(!ts){break a}ts=q[vs+28>>2];o[ts-((ts|0)==q[vs+24>>2])|0]=0;break a}q[4458]=61;ss=-1}T=vs+160|0;return ss}function vm(ss,ts,us){ss=ss|0;ts=ts|0;us=us|0;var xs=0,ys=0;ys=q[ss+20>>2];xs=q[ss+16>>2]-ys|0;xs=xs>>>0>us>>>0?us:xs;Cn(ys,ts,xs);q[ss+20>>2]=xs+q[ss+20>>2];return us|0}function wm(ss,ts,us){var zs=0;zs=T-16|0;T=zs;q[zs+12>>2]=us;ss=um(ss,ts,us);T=zs+16|0;return ss}function xm(ss){if(Bm(ss)){return q[ss+4>>2]}return r[ss+11|0]}function ym(ss){if(Bm(ss)){ss=Cm(ss)+ -1|0}else{ss=10}return ss}function zm(ss,ts){Wm(ss,ts)}function Am(ss){var ts=0;ts=ss;ss=0;while(1){if((ss|0)!=3){q[(ss<<2)+ts>>2]=0;ss=ss+1|0;continue}break}}function Bm(ss){return o[ss+11|0]<0}function Cm(ss){return q[ss+8>>2]&2147483647}function Dm(ss){if(Bm(ss)){return q[ss>>2]}return ss}function Em(ss,us){o[ss|0]=r[us|0]}function Fm(ss,us){q[ss+4>>2]=us}function Gm(ss,us){o[ss+11|0]=us}function Hm(ss){var us=0;if(ss>>>0>=11){us=ss+16&-16;ss=us+ -1|0;ss=(ss|0)==11?us:ss}else{ss=10}return ss}function Im(ss){if(4294967295<ss>>>0){ab(15712);F()}return Mm(ss)}function Jm(ss,As){q[ss>>2]=As}function Km(ss,As){q[ss+8>>2]=As|-2147483648}function Lm(ss,As){if(Bm(ss)){Fm(ss,As);return}Gm(ss,As)}function Mm(ss){var As=0,Bs=0;ss=ss?ss:1;while(1){a:{As=zn(ss);if(As){break a}Bs=q[4476];if(!Bs){break a}n[Bs]();continue}break}return As}function Nm(ss,Cs){var Ds=0,Es=0,Fs=0,Gs=0;Ds=dm(Cs);Es=Mm(Ds+13|0);q[Es+8>>2]=0;q[Es+4>>2]=Ds;q[Es>>2]=Ds;Fs=ss,Gs=Cn(Es+12|0,Cs,Ds+1|0),q[Fs>>2]=Gs}function Om(ss){var Cs=0,Hs=0,Is=0;Cs=T-16|0;T=Cs;o[Cs+15|0]=10;Hs=q[ss+16>>2];a:{if(!Hs){if(El(ss)){break a}Hs=q[ss+16>>2]}Is=q[ss+20>>2];if(!(o[ss+75|0]==10|Is>>>0>=Hs>>>0)){q[ss+20>>2]=Is+1;o[Is|0]=10;break a}if((n[q[ss+36>>2]](ss,Cs+15|0,1)|0)!=1){break a}}T=Cs+16|0}function Pm(){ab(15780);F()}function Qm(){O();F()}function Rm(ss,Js){var Ks=0,Ls=0,Ms=0;Ls=T-16|0;T=Ls;rm(ss);Ks=ss;a:{if(!Bm(Js)){q[Ks+8>>2]=q[Js+8>>2];Ms=q[Js+4>>2];q[Ks>>2]=q[Js>>2];q[Ks+4>>2]=Ms;break a}Sm(ss,q[Js>>2],q[Js+4>>2])}T=Ls+16|0;return ss}function Sm(ss,Js,Ns){var Os=0,Ps=0,Qs=0;Os=T-16|0;T=Os;if(4294967279>=Ns>>>0){a:{if(Ns>>>0<=10){Gm(ss,Ns);Ps=ss;break a}Qs=Hm(Ns)+1|0;Ps=Im(Qs);Jm(ss,Ps);Km(ss,Qs);Fm(ss,Ns)}om(Ps,Js,Ns);o[Os+15|0]=0;Em(Ns+Ps|0,Os+15|0);T=Os+16|0;return}Pm();F()}function Tm(ss,Js){if((ss|0)!=(Js|0)){Um(ss,Dm(Js),xm(Js))}}function Um(ss,Js,Ns){var Rs=0,Ss=0,Ts=0,Us=0;Ss=T-16|0;T=Ss;Rs=ym(ss);a:{if(Rs>>>0>=Ns>>>0){Ts=Dm(ss);Us=Ts;Rs=Ns;if(Ns){En(Us,Js,Rs)}o[Ss+15|0]=0;Em(Ns+Ts|0,Ss+15|0);Lm(ss,Ns);break a}Ts=ss;ss=xm(ss);Vm(Ts,Rs,Ns-Rs|0,ss,ss,Ns,Js)}T=Ss+16|0}function Vm(ss,Js,Ns,Vs,Ws,Xs,Ys){var Zs=0,_s=0,$s=0;Zs=T-16|0;T=Zs;if((Js^-1)+ -17>>>0>=Ns>>>0){_s=Dm(ss);a:{if(2147483623>Js>>>0){q[Zs+8>>2]=Js<<1;q[Zs+12>>2]=Js+Ns;Ns=Hm(q[pm(Zs+12|0,Zs+8|0)>>2]);break a}Ns=-18}$s=Ns+1|0;Ns=Im($s);if(Xs){om(Ns,Ys,Xs)}Vs=Vs-Ws|0;Ys=Vs;if(Vs){om(Ns+Xs|0,Ws+_s|0,Ys)}if((Js|0)!=10){An(_s)}Jm(ss,Ns);Km(ss,$s);Js=ss;ss=Vs+Xs|0;Fm(Js,ss);o[Zs+7|0]=0;Em(ss+Ns|0,Zs+7|0);T=Zs+16|0;return}Pm();F()}function Wm(ss,Js){var Ns=0;Ns=xm(ss);if(Ns>>>0<Js>>>0){Xm(ss,Js-Ns|0);return}Ym(ss,Js)}function Xm(ss,Js){var Vs=0,Ws=0,Xs=0,Ys=0;Xs=T-16|0;T=Xs;if(Js){Ws=ym(ss);Vs=xm(ss);Ys=Vs+Js|0;if(Ws-Vs>>>0<Js>>>0){Zm(ss,Ws,Ys-Ws|0,Vs,Vs)}Ws=Vs;Vs=Dm(ss);Ws=Ws+Vs|0;if(Js){Dn(Ws,0,Js)}Lm(ss,Ys);o[Xs+15|0]=0;Em(Vs+Ys|0,Xs+15|0)}T=Xs+16|0}function Ym(ss,Js){var at=0,bt=0;at=T-16|0;T=at;a:{if(Bm(ss)){bt=q[ss>>2];o[at+15|0]=0;Em(Js+bt|0,at+15|0);Fm(ss,Js);break a}o[at+14|0]=0;Em(ss+Js|0,at+14|0);Gm(ss,Js)}T=at+16|0}function Zm(ss,Js,ct,dt,et){var ft=0,gt=0,ht=0;ft=T-16|0;T=ft;if(-17-Js>>>0>=ct>>>0){gt=Dm(ss);a:{if(2147483623>Js>>>0){q[ft+8>>2]=Js<<1;q[ft+12>>2]=Js+ct;ct=Hm(q[pm(ft+12|0,ft+8|0)>>2]);break a}ct=-18}ht=ct+1|0;ct=Im(ht);if(et){om(ct,gt,et)}dt=dt-et|0;if(dt){om(ct+et|0,et+gt|0,dt)}if((Js|0)!=10){An(gt)}Jm(ss,ct);Km(ss,ht);T=ft+16|0;return}Pm();F()}function _m(ss){if(xm(ss)>>>0<=0){Qm();F()}return Dm(ss)}function $m(ss){var Js=0,ct=0;Js=T-16|0;T=Js;rm(Js);Am(Js);zm(Js,ym(Js));an(ss,Js);ss=Js;if(Bm(Js)){ct=q[ss>>2];Cm(ss);An(ct)}T=Js+16|0}function an(ss,dt){var et=0,it=0,jt=0,kt=0;jt=T-16|0;T=jt;et=xm(dt);while(1){a:{it=Dm(dt);q[jt>>2]=1;kt=dt;it=wm(it,et+1|0,jt);b:{if((it|0)>=0){if(it>>>0<=et>>>0){break a}et=it;break b}et=et<<1|1}zm(kt,et);continue}break}zm(dt,it);et=q[dt+4>>2];q[ss>>2]=q[dt>>2];q[ss+4>>2]=et;q[ss+8>>2]=q[dt+8>>2];Am(dt);T=jt+16|0}function bn(){ab(15796);F()}function cn(){Qm();F()}function dn(ss){var dt=0;if(q[ss+76>>2]<0){a:{if(o[ss+75|0]==10){break a}dt=q[ss+20>>2];if(dt>>>0>=t[ss+16>>2]){break a}q[ss+20>>2]=dt+1;o[dt|0]=10;return}Om(ss);return}b:{c:{if(o[ss+75|0]==10){break c}dt=q[ss+20>>2];if(dt>>>0>=t[ss+16>>2]){break c}q[ss+20>>2]=dt+1;o[dt|0]=10;break b}Om(ss)}}function en(){var ss=0;ss=T-16|0;T=ss;q[ss+12>>2]=0;ss=q[3794];Rl(ss,15803,0);dn(ss);O();F()}function fn(){en();F()}function gn(lt){lt=lt|0;return 15833}function hn(lt){lt=lt|0;q[lt>>2]=15900;jn(lt+4|0);return lt|0}function jn(lt){var mt=0,nt=0;mt=q[lt>>2]+ -12|0;nt=mt+8|0;lt=q[nt>>2]+ -1|0;q[nt>>2]=lt;a:{if((lt|0)>-1){break a}An(mt)}}function kn(lt){lt=lt|0;An(hn(lt))}function ln(lt){lt=lt|0;return q[lt+4>>2]}function mn(lt){lt=lt|0;hn(lt);An(lt)}function nn(lt,ot,pt){if(!pt){return(lt|0)==(ot|0)}return!sm(q[lt+4>>2],q[ot+4>>2])}function on(lt,ot,pt){lt=lt|0;ot=ot|0;pt=pt|0;var qt=0,rt=0;qt=T+ -64|0;T=qt;rt=1;a:{if(nn(lt,ot,0)){break a}rt=0;if(!ot){break a}ot=pn(ot);rt=0;if(!ot){break a}q[qt+20>>2]=-1;q[qt+16>>2]=lt;q[qt+12>>2]=0;q[qt+8>>2]=ot;Dn(qt+24|0,0,39);q[qt+56>>2]=1;n[q[q[ot>>2]+28>>2]](ot,qt+8|0,q[pt>>2],1);rt=0;if(q[qt+32>>2]!=1){break a}q[pt>>2]=q[qt+24>>2];rt=1}T=qt- -64|0;return rt|0}function pn(lt){var ot=0,pt=0,st=0,tt=0;ot=T+ -64|0;T=ot;pt=q[lt>>2];tt=q[pt+ -8>>2];pt=q[pt+ -4>>2];q[ot+20>>2]=0;q[ot+16>>2]=16052;q[ot+12>>2]=lt;q[ot+8>>2]=16100;Dn(ot+24|0,0,39);lt=lt+tt|0;a:{if(nn(pt,16100,0)){q[ot+56>>2]=1;n[q[q[pt>>2]+20>>2]](pt,ot+8|0,lt,lt,1,0);st=q[ot+32>>2]==1?lt:0;break a}n[q[q[pt>>2]+24>>2]](pt,ot+8|0,lt,1,0);lt=q[ot+44>>2];if(lt>>>0>1){break a}if(lt-1){st=q[ot+48>>2]==1?q[ot+36>>2]==1?q[ot+40>>2]==1?q[ot+28>>2]:0:0:0;break a}if(q[ot+32>>2]!=1){if(q[ot+48>>2]|q[ot+36>>2]!=1|q[ot+40>>2]!=1){break a}}st=q[ot+24>>2]}T=ot- -64|0;return st}function qn(lt,ut,vt){var wt=0;wt=q[lt+16>>2];if(!wt){q[lt+36>>2]=1;q[lt+24>>2]=vt;q[lt+16>>2]=ut;return}a:{if((ut|0)==(wt|0)){if(q[lt+24>>2]!=2){break a}q[lt+24>>2]=vt;return}o[lt+54|0]=1;q[lt+24>>2]=2;q[lt+36>>2]=q[lt+36>>2]+1}}function rn(lt,ut,vt,xt){lt=lt|0;ut=ut|0;vt=vt|0;xt=xt|0;if(nn(lt,q[ut+8>>2],0)){qn(ut,vt,xt)}}function sn(lt,ut,vt,xt){lt=lt|0;ut=ut|0;vt=vt|0;xt=xt|0;if(nn(lt,q[ut+8>>2],0)){qn(ut,vt,xt);return}lt=q[lt+8>>2];n[q[q[lt>>2]+28>>2]](lt,ut,vt,xt)}function tn(lt,ut,vt,xt){o[lt+53|0]=1;a:{if(q[lt+4>>2]!=(vt|0)){break a}o[lt+52|0]=1;vt=q[lt+16>>2];if(!vt){q[lt+36>>2]=1;q[lt+24>>2]=xt;q[lt+16>>2]=ut;if((xt|0)!=1|q[lt+48>>2]!=1){break a}o[lt+54|0]=1;return}if((ut|0)==(vt|0)){vt=q[lt+24>>2];if((vt|0)==2){q[lt+24>>2]=xt;vt=xt}if(q[lt+48>>2]!=1|(vt|0)!=1){break a}o[lt+54|0]=1;return}o[lt+54|0]=1;q[lt+36>>2]=q[lt+36>>2]+1}}function un(lt,ut,vt){if(!(q[lt+28>>2]==1|q[lt+4>>2]!=(ut|0))){q[lt+28>>2]=vt}}function vn(lt,ut,vt,xt,yt){lt=lt|0;ut=ut|0;vt=vt|0;xt=xt|0;yt=yt|0;if(nn(lt,q[ut+8>>2],yt)){un(ut,vt,xt);return}a:{if(nn(lt,q[ut>>2],yt)){if(!(q[ut+20>>2]!=(vt|0)?q[ut+16>>2]!=(vt|0):0)){if((xt|0)!=1){break a}q[ut+32>>2]=1;return}q[ut+32>>2]=xt;b:{if(q[ut+44>>2]==4){break b}p[ut+52>>1]=0;lt=q[lt+8>>2];n[q[q[lt>>2]+20>>2]](lt,ut,vt,vt,1,yt);if(r[ut+53|0]){q[ut+44>>2]=3;if(!r[ut+52|0]){break b}break a}q[ut+44>>2]=4}q[ut+20>>2]=vt;q[ut+40>>2]=q[ut+40>>2]+1;if(q[ut+36>>2]!=1|q[ut+24>>2]!=2){break a}o[ut+54|0]=1;return}lt=q[lt+8>>2];n[q[q[lt>>2]+24>>2]](lt,ut,vt,xt,yt)}}function wn(lt,ut,vt,xt,yt){lt=lt|0;ut=ut|0;vt=vt|0;xt=xt|0;yt=yt|0;if(nn(lt,q[ut+8>>2],yt)){un(ut,vt,xt);return}a:{if(!nn(lt,q[ut>>2],yt)){break a}if(!(q[ut+20>>2]!=(vt|0)?q[ut+16>>2]!=(vt|0):0)){if((xt|0)!=1){break a}q[ut+32>>2]=1;return}q[ut+20>>2]=vt;q[ut+32>>2]=xt;q[ut+40>>2]=q[ut+40>>2]+1;if(!(q[ut+36>>2]!=1|q[ut+24>>2]!=2)){o[ut+54|0]=1}q[ut+44>>2]=4}}function xn(lt,ut,vt,xt,yt,zt){lt=lt|0;ut=ut|0;vt=vt|0;xt=xt|0;yt=yt|0;zt=zt|0;if(nn(lt,q[ut+8>>2],zt)){tn(ut,vt,xt,yt);return}lt=q[lt+8>>2];n[q[q[lt>>2]+20>>2]](lt,ut,vt,xt,yt,zt)}function yn(lt,ut,vt,xt,yt,zt){lt=lt|0;ut=ut|0;vt=vt|0;xt=xt|0;yt=yt|0;zt=zt|0;if(nn(lt,q[ut+8>>2],zt)){tn(ut,vt,xt,yt)}}



function zn(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;l=T-16|0;T=l;a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{if(a>>>0<=244){f=q[4477];h=a>>>0<11?16:a+11&-8;b=h>>>3;a=f>>>b;if(a&3){d=b+((a^-1)&1)|0;b=d<<3;e=q[b+17956>>2];a=e+8|0;c=q[e+8>>2];b=b+17948|0;l:{if((c|0)==(b|0)){m=17908,n=eo(d)&f,q[m>>2]=n;break l}q[c+12>>2]=b;q[b+8>>2]=c}b=d<<3;q[e+4>>2]=b|3;b=b+e|0;q[b+4>>2]=q[b+4>>2]|1;break a}k=q[4479];if(h>>>0<=k>>>0){break k}if(a){c=a<<b;a=2<<b;a=c&(0-a|a);b=(0-a&a)+ -1|0;a=b>>>12&16;c=a;b=b>>>a;a=b>>>5&8;c=c|a;b=b>>>a;a=b>>>2&4;c=c|a;b=b>>>a;a=b>>>1&2;c=c|a;b=b>>>a;a=b>>>1&1;c=(c|a)+(b>>>a)|0;a=c<<3;g=q[a+17956>>2];b=q[g+8>>2];a=a+17948|0;m:{if((b|0)==(a|0)){f=eo(c)&f;q[4477]=f;break m}q[b+12>>2]=a;q[a+8>>2]=b}a=g+8|0;q[g+4>>2]=h|3;d=g+h|0;b=c<<3;e=b-h|0;q[d+4>>2]=e|1;q[b+g>>2]=e;if(k){b=k>>>3;c=(b<<3)+17948|0;h=q[4482];b=1<<b;n:{if(!(b&f)){q[4477]=b|f;b=c;break n}b=q[c+8>>2]}q[c+8>>2]=h;q[b+12>>2]=h;q[h+12>>2]=c;q[h+8>>2]=b}q[4482]=d;q[4479]=e;break a}i=q[4478];if(!i){break k}b=(i&0-i)+ -1|0;a=b>>>12&16;c=a;b=b>>>a;a=b>>>5&8;c=c|a;b=b>>>a;a=b>>>2&4;c=c|a;b=b>>>a;a=b>>>1&2;c=c|a;b=b>>>a;a=b>>>1&1;b=q[((c|a)+(b>>>a)<<2)+18212>>2];d=(q[b+4>>2]&-8)-h|0;c=b;while(1){o:{a=q[c+16>>2];if(!a){a=q[c+20>>2];if(!a){break o}}c=(q[a+4>>2]&-8)-h|0;e=c>>>0<d>>>0;d=e?c:d;b=e?a:b;c=a;continue}break}j=q[b+24>>2];e=q[b+12>>2];if((e|0)!=(b|0)){a=q[b+8>>2];q[a+12>>2]=e;q[e+8>>2]=a;break b}c=b+20|0;a=q[c>>2];if(!a){a=q[b+16>>2];if(!a){break j}c=b+16|0}while(1){g=c;e=a;c=a+20|0;a=q[c>>2];if(a){continue}c=e+16|0;a=q[e+16>>2];if(a){continue}break}q[g>>2]=0;break b}h=-1;if(a>>>0>4294967231){break k}a=a+11|0;h=a&-8;i=q[4478];if(!i){break k}a=a>>>8;g=0;p:{if(!a){break p}g=31;if(h>>>0>16777215){break p}b=a+1048320>>>16&8;a=a<<b;d=a+520192>>>16&4;a=a<<d;c=a+245760>>>16&2;a=(a<<c>>>15)-(c|(b|d))|0;g=(a<<1|h>>>a+21&1)+28|0}c=0-h|0;d=q[(g<<2)+18212>>2];q:{r:{s:{if(!d){a=0;break s}b=h<<((g|0)==31?0:25-(g>>>1)|0);a=0;while(1){t:{f=(q[d+4>>2]&-8)-h|0;if(f>>>0>=c>>>0){break t}e=d;c=f;if(c){break t}c=0;a=d;break r}f=q[d+20>>2];d=q[((b>>>29&4)+d|0)+16>>2];a=f?(f|0)==(d|0)?a:f:a;b=b<<((d|0)!=0);if(d){continue}break}}if(!(a|e)){a=2<<g;a=(0-a|a)&i;if(!a){break k}b=(a&0-a)+ -1|0;a=b>>>12&16;d=a;b=b>>>a;a=b>>>5&8;d=d|a;b=b>>>a;a=b>>>2&4;d=d|a;b=b>>>a;a=b>>>1&2;d=d|a;b=b>>>a;a=b>>>1&1;a=q[((d|a)+(b>>>a)<<2)+18212>>2]}if(!a){break q}}while(1){b=(q[a+4>>2]&-8)-h|0;d=b>>>0<c>>>0;c=d?b:c;e=d?a:e;b=q[a+16>>2];if(b){a=b}else{a=q[a+20>>2]}if(a){continue}break}}if(!e|c>>>0>=q[4479]-h>>>0){break k}g=q[e+24>>2];b=q[e+12>>2];if((e|0)!=(b|0)){a=q[e+8>>2];q[a+12>>2]=b;q[b+8>>2]=a;break c}d=e+20|0;a=q[d>>2];if(!a){a=q[e+16>>2];if(!a){break i}d=e+16|0}while(1){f=d;b=a;d=a+20|0;a=q[d>>2];if(a){continue}d=b+16|0;a=q[b+16>>2];if(a){continue}break}q[f>>2]=0;break c}c=q[4479];if(c>>>0>=h>>>0){d=q[4482];b=c-h|0;u:{if(b>>>0>=16){q[4479]=b;a=d+h|0;q[4482]=a;q[a+4>>2]=b|1;q[c+d>>2]=b;q[d+4>>2]=h|3;break u}q[4482]=0;q[4479]=0;q[d+4>>2]=c|3;a=c+d|0;q[a+4>>2]=q[a+4>>2]|1}a=d+8|0;break a}j=q[4480];if(j>>>0>h>>>0){b=j-h|0;q[4480]=b;c=q[4483];a=c+h|0;q[4483]=a;q[a+4>>2]=b|1;q[c+4>>2]=h|3;a=c+8|0;break a}a=0;i=h+47|0;b=i;if(q[4595]){c=q[4597]}else{q[4598]=-1;q[4599]=-1;q[4596]=4096;q[4597]=4096;q[4595]=l+12&-16^1431655768;q[4600]=0;q[4588]=0;c=4096}g=b+c|0;f=0-c|0;c=g&f;if(c>>>0<=h>>>0){break a}e=q[4587];if(e){d=q[4585];b=d+c|0;if(b>>>0<=d>>>0|b>>>0>e>>>0){break a}}if(r[18352]&4){break f}v:{w:{d=q[4483];if(d){a=18356;while(1){b=q[a>>2];if(b+q[a+4>>2]>>>0>d>>>0?b>>>0<=d>>>0:0){break w}a=q[a+8>>2];if(a){continue}break}}b=Bn(0);if((b|0)==-1){break g}f=c;d=q[4596];a=d+ -1|0;if(a&b){f=(c-b|0)+(a+b&0-d)|0}if(f>>>0<=h>>>0|f>>>0>2147483646){break g}e=q[4587];if(e){d=q[4585];a=d+f|0;if(a>>>0<=d>>>0|a>>>0>e>>>0){break g}}a=Bn(f);if((b|0)!=(a|0)){break v}break e}f=f&g-j;if(f>>>0>2147483646){break g}b=Bn(f);if((b|0)==(q[a>>2]+q[a+4>>2]|0)){break h}a=b}b=a;if(!(h+48>>>0<=f>>>0|f>>>0>2147483646|(a|0)==-1)){a=q[4597];a=a+(i-f|0)&0-a;if(a>>>0>2147483646){break e}if((Bn(a)|0)!=-1){f=a+f|0;break e}Bn(0-f|0);break g}if((b|0)!=-1){break e}break g}e=0;break b}b=0;break c}if((b|0)!=-1){break e}}q[4588]=q[4588]|4}if(c>>>0>2147483646){break d}b=Bn(c);a=Bn(0);if(b>>>0>=a>>>0|(b|0)==-1|(a|0)==-1){break d}f=a-b|0;if(f>>>0<=h+40>>>0){break d}}a=q[4585]+f|0;q[4585]=a;if(a>>>0>t[4586]){q[4586]=a}x:{y:{z:{d=q[4483];if(d){a=18356;while(1){e=q[a>>2];c=q[a+4>>2];if((e+c|0)==(b|0)){break z}a=q[a+8>>2];if(a){continue}break}break y}a=q[4481];if(!(b>>>0>=a>>>0?a:0)){q[4481]=b}a=0;q[4590]=f;q[4589]=b;q[4485]=-1;q[4486]=q[4595];q[4592]=0;while(1){d=a<<3;c=d+17948|0;q[d+17956>>2]=c;q[d+17960>>2]=c;a=a+1|0;if((a|0)!=32){continue}break}d=f+ -40|0;a=b+8&7?-8-b&7:0;c=d-a|0;q[4480]=c;a=a+b|0;q[4483]=a;q[a+4>>2]=c|1;q[(b+d|0)+4>>2]=40;q[4484]=q[4599];break x}if(r[a+12|0]&8|b>>>0<=d>>>0|e>>>0>d>>>0){break y}q[a+4>>2]=c+f;a=d+8&7?-8-d&7:0;c=a+d|0;q[4483]=c;b=q[4480]+f|0;a=b-a|0;q[4480]=a;q[c+4>>2]=a|1;q[(b+d|0)+4>>2]=40;q[4484]=q[4599];break x}e=q[4481];if(b>>>0<e>>>0){q[4481]=b;e=0}c=b+f|0;a=18356;A:{B:{C:{D:{E:{F:{while(1){if((c|0)!=q[a>>2]){a=q[a+8>>2];if(a){continue}break F}break}if(!(r[a+12|0]&8)){break E}}a=18356;while(1){c=q[a>>2];if(c>>>0<=d>>>0){g=c+q[a+4>>2]|0;if(g>>>0>d>>>0){break D}}a=q[a+8>>2];continue}}q[a>>2]=b;q[a+4>>2]=q[a+4>>2]+f;j=(b+8&7?-8-b&7:0)+b|0;q[j+4>>2]=h|3;b=c+(c+8&7?-8-c&7:0)|0;a=(b-j|0)-h|0;g=h+j|0;if((b|0)==(d|0)){q[4483]=g;a=q[4480]+a|0;q[4480]=a;q[g+4>>2]=a|1;break B}if(q[4482]==(b|0)){q[4482]=g;a=q[4479]+a|0;q[4479]=a;q[g+4>>2]=a|1;q[a+g>>2]=a;break B}c=q[b+4>>2];if((c&3)==1){i=c&-8;G:{if(c>>>0<=255){e=q[b+8>>2];c=c>>>3;d=q[b+12>>2];if((d|0)==(e|0)){m=17908,n=q[4477]&eo(c),q[m>>2]=n;break G}q[e+12>>2]=d;q[d+8>>2]=e;break G}k=q[b+24>>2];f=q[b+12>>2];H:{if((f|0)!=(b|0)){c=q[b+8>>2];q[c+12>>2]=f;q[f+8>>2]=c;break H}I:{d=b+20|0;h=q[d>>2];if(h){break I}d=b+16|0;h=q[d>>2];if(h){break I}f=0;break H}while(1){c=d;f=h;d=f+20|0;h=q[d>>2];if(h){continue}d=f+16|0;h=q[f+16>>2];if(h){continue}break}q[c>>2]=0}if(!k){break G}d=q[b+28>>2];c=(d<<2)+18212|0;J:{if(q[c>>2]==(b|0)){q[c>>2]=f;if(f){break J}m=17912,n=q[4478]&eo(d),q[m>>2]=n;break G}q[k+(q[k+16>>2]==(b|0)?16:20)>>2]=f;if(!f){break G}}q[f+24>>2]=k;c=q[b+16>>2];if(c){q[f+16>>2]=c;q[c+24>>2]=f}c=q[b+20>>2];if(!c){break G}q[f+20>>2]=c;q[c+24>>2]=f}b=b+i|0;a=a+i|0}q[b+4>>2]=q[b+4>>2]&-2;q[g+4>>2]=a|1;q[a+g>>2]=a;if(a>>>0<=255){a=a>>>3;b=(a<<3)+17948|0;c=q[4477];a=1<<a;K:{if(!(c&a)){q[4477]=a|c;a=b;break K}a=q[b+8>>2]}q[b+8>>2]=g;q[a+12>>2]=g;q[g+12>>2]=b;q[g+8>>2]=a;break B}b=g;d=a>>>8;c=0;L:{if(!d){break L}c=31;if(a>>>0>16777215){break L}c=d;d=d+1048320>>>16&8;c=c<<d;f=c+520192>>>16&4;c=c<<f;e=c+245760>>>16&2;c=(c<<e>>>15)-(e|(d|f))|0;c=(c<<1|a>>>c+21&1)+28|0}q[b+28>>2]=c;q[g+16>>2]=0;q[g+20>>2]=0;e=(c<<2)+18212|0;d=q[4478];b=1<<c;M:{if(!(d&b)){q[4478]=b|d;q[e>>2]=g;q[g+24>>2]=e;break M}d=a<<((c|0)==31?0:25-(c>>>1)|0);b=q[e>>2];while(1){c=b;if((q[b+4>>2]&-8)==(a|0)){break C}b=d>>>29;d=d<<1;e=(c+(b&4)|0)+16|0;b=q[e>>2];if(b){continue}break}q[e>>2]=g;q[g+24>>2]=c}q[g+12>>2]=g;q[g+8>>2]=g;break B}e=f+ -40|0;a=b+8&7?-8-b&7:0;c=e-a|0;q[4480]=c;a=a+b|0;q[4483]=a;q[a+4>>2]=c|1;q[(b+e|0)+4>>2]=40;q[4484]=q[4599];a=(g+(g+ -39&7?39-g&7:0)|0)+ -47|0;c=a>>>0<d+16>>>0?d:a;q[c+4>>2]=27;a=q[4592];q[c+16>>2]=q[4591];q[c+20>>2]=a;a=q[4590];q[c+8>>2]=q[4589];q[c+12>>2]=a;q[4591]=c+8;q[4590]=f;q[4589]=b;q[4592]=0;a=c+24|0;while(1){q[a+4>>2]=7;b=a+8|0;a=a+4|0;if(b>>>0<g>>>0){continue}break}if((c|0)==(d|0)){break x}q[c+4>>2]=q[c+4>>2]&-2;g=c-d|0;q[d+4>>2]=g|1;q[c>>2]=g;if(g>>>0<=255){a=g>>>3;b=(a<<3)+17948|0;c=q[4477];a=1<<a;N:{if(!(c&a)){q[4477]=a|c;a=b;break N}a=q[b+8>>2]}q[b+8>>2]=d;q[a+12>>2]=d;q[d+12>>2]=b;q[d+8>>2]=a;break x}q[d+16>>2]=0;q[d+20>>2]=0;a=d;c=g>>>8;b=0;O:{if(!c){break O}b=31;if(g>>>0>16777215){break O}b=c;c=c+1048320>>>16&8;b=b<<c;f=b+520192>>>16&4;b=b<<f;e=b+245760>>>16&2;b=(b<<e>>>15)-(e|(c|f))|0;b=(b<<1|g>>>b+21&1)+28|0}q[a+28>>2]=b;e=(b<<2)+18212|0;c=q[4478];a=1<<b;P:{if(!(c&a)){q[4478]=a|c;q[e>>2]=d;q[d+24>>2]=e;break P}a=g<<((b|0)==31?0:25-(b>>>1)|0);b=q[e>>2];while(1){c=b;if((g|0)==(q[b+4>>2]&-8)){break A}b=a>>>29;a=a<<1;e=(c+(b&4)|0)+16|0;b=q[e>>2];if(b){continue}break}q[e>>2]=d;q[d+24>>2]=c}q[d+12>>2]=d;q[d+8>>2]=d;break x}a=q[c+8>>2];q[a+12>>2]=g;q[c+8>>2]=g;q[g+24>>2]=0;q[g+12>>2]=c;q[g+8>>2]=a}a=j+8|0;break a}a=q[c+8>>2];q[a+12>>2]=d;q[c+8>>2]=d;q[d+24>>2]=0;q[d+12>>2]=c;q[d+8>>2]=a}a=q[4480];if(a>>>0<=h>>>0){break d}b=a-h|0;q[4480]=b;c=q[4483];a=c+h|0;q[4483]=a;q[a+4>>2]=b|1;q[c+4>>2]=h|3;a=c+8|0;break a}q[4458]=48;a=0;break a}Q:{if(!g){break Q}d=q[e+28>>2];a=(d<<2)+18212|0;R:{if(q[a>>2]==(e|0)){q[a>>2]=b;if(b){break R}i=eo(d)&i;q[4478]=i;break Q}q[g+(q[g+16>>2]==(e|0)?16:20)>>2]=b;if(!b){break Q}}q[b+24>>2]=g;a=q[e+16>>2];if(a){q[b+16>>2]=a;q[a+24>>2]=b}a=q[e+20>>2];if(!a){break Q}q[b+20>>2]=a;q[a+24>>2]=b}S:{if(c>>>0<=15){a=c+h|0;q[e+4>>2]=a|3;a=a+e|0;q[a+4>>2]=q[a+4>>2]|1;break S}q[e+4>>2]=h|3;d=e+h|0;q[d+4>>2]=c|1;q[c+d>>2]=c;if(c>>>0<=255){a=c>>>3;b=(a<<3)+17948|0;c=q[4477];a=1<<a;T:{if(!(c&a)){q[4477]=a|c;a=b;break T}a=q[b+8>>2]}q[b+8>>2]=d;q[a+12>>2]=d;q[d+12>>2]=b;q[d+8>>2]=a;break S}a=d;f=c>>>8;b=0;U:{if(!f){break U}b=31;if(c>>>0>16777215){break U}b=f;f=f+1048320>>>16&8;b=b<<f;g=b+520192>>>16&4;b=b<<g;h=b+245760>>>16&2;b=(b<<h>>>15)-(h|(f|g))|0;b=(b<<1|c>>>b+21&1)+28|0}q[a+28>>2]=b;q[d+16>>2]=0;q[d+20>>2]=0;f=(b<<2)+18212|0;V:{a=1<<b;W:{if(!(a&i)){q[4478]=a|i;q[f>>2]=d;q[d+24>>2]=f;break W}a=c<<((b|0)==31?0:25-(b>>>1)|0);h=q[f>>2];while(1){b=h;if((q[b+4>>2]&-8)==(c|0)){break V}f=a>>>29;a=a<<1;f=(b+(f&4)|0)+16|0;h=q[f>>2];if(h){continue}break}q[f>>2]=d;q[d+24>>2]=b}q[d+12>>2]=d;q[d+8>>2]=d;break S}a=q[b+8>>2];q[a+12>>2]=d;q[b+8>>2]=d;q[d+24>>2]=0;q[d+12>>2]=b;q[d+8>>2]=a}a=e+8|0;break a}X:{if(!j){break X}c=q[b+28>>2];a=(c<<2)+18212|0;Y:{if(q[a>>2]==(b|0)){q[a>>2]=e;if(e){break Y}m=17912,n=eo(c)&i,q[m>>2]=n;break X}q[(q[j+16>>2]==(b|0)?16:20)+j>>2]=e;if(!e){break X}}q[e+24>>2]=j;a=q[b+16>>2];if(a){q[e+16>>2]=a;q[a+24>>2]=e}a=q[b+20>>2];if(!a){break X}q[e+20>>2]=a;q[a+24>>2]=e}Z:{if(d>>>0<=15){a=d+h|0;q[b+4>>2]=a|3;a=a+b|0;q[a+4>>2]=q[a+4>>2]|1;break Z}q[b+4>>2]=h|3;e=b+h|0;q[e+4>>2]=d|1;q[d+e>>2]=d;if(k){a=k>>>3;c=(a<<3)+17948|0;h=q[4482];a=1<<a;_:{if(!(a&f)){q[4477]=a|f;a=c;break _}a=q[c+8>>2]}q[c+8>>2]=h;q[a+12>>2]=h;q[h+12>>2]=c;q[h+8>>2]=a}q[4482]=e;q[4479]=d}a=b+8|0}T=l+16|0;return a|0}function An(a){a=a|0;var o=0,p=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0;a:{if(!a){break a}r=a+ -8|0;p=q[a+ -4>>2];a=p&-8;u=r+a|0;b:{if(p&1){break b}if(!(p&3)){break a}p=q[r>>2];r=r-p|0;if(r>>>0<t[4481]){break a}a=a+p|0;if(q[4482]!=(r|0)){if(p>>>0<=255){s=q[r+8>>2];p=p>>>3;o=q[r+12>>2];if((o|0)==(s|0)){x=17908,y=q[4477]&eo(p),q[x>>2]=y;break b}q[s+12>>2]=o;q[o+8>>2]=s;break b}w=q[r+24>>2];p=q[r+12>>2];c:{if((p|0)!=(r|0)){o=q[r+8>>2];q[o+12>>2]=p;q[p+8>>2]=o;break c}d:{s=r+20|0;o=q[s>>2];if(o){break d}s=r+16|0;o=q[s>>2];if(o){break d}p=0;break c}while(1){v=s;p=o;s=p+20|0;o=q[s>>2];if(o){continue}s=p+16|0;o=q[p+16>>2];if(o){continue}break}q[v>>2]=0}if(!w){break b}s=q[r+28>>2];o=(s<<2)+18212|0;e:{if(q[o>>2]==(r|0)){q[o>>2]=p;if(p){break e}x=17912,y=q[4478]&eo(s),q[x>>2]=y;break b}q[w+(q[w+16>>2]==(r|0)?16:20)>>2]=p;if(!p){break b}}q[p+24>>2]=w;o=q[r+16>>2];if(o){q[p+16>>2]=o;q[o+24>>2]=p}o=q[r+20>>2];if(!o){break b}q[p+20>>2]=o;q[o+24>>2]=p;break b}p=q[u+4>>2];if((p&3)!=3){break b}q[4479]=a;q[u+4>>2]=p&-2;q[r+4>>2]=a|1;q[a+r>>2]=a;return}if(u>>>0<=r>>>0){break a}p=q[u+4>>2];if(!(p&1)){break a}f:{if(!(p&2)){if((u|0)==q[4483]){q[4483]=r;a=q[4480]+a|0;q[4480]=a;q[r+4>>2]=a|1;if(q[4482]!=(r|0)){break a}q[4479]=0;q[4482]=0;return}if((u|0)==q[4482]){q[4482]=r;a=q[4479]+a|0;q[4479]=a;q[r+4>>2]=a|1;q[a+r>>2]=a;return}a=(p&-8)+a|0;g:{if(p>>>0<=255){o=q[u+8>>2];p=p>>>3;s=q[u+12>>2];if((o|0)==(s|0)){x=17908,y=q[4477]&eo(p),q[x>>2]=y;break g}q[o+12>>2]=s;q[s+8>>2]=o;break g}w=q[u+24>>2];p=q[u+12>>2];h:{if((u|0)!=(p|0)){o=q[u+8>>2];q[o+12>>2]=p;q[p+8>>2]=o;break h}i:{s=u+20|0;o=q[s>>2];if(o){break i}s=u+16|0;o=q[s>>2];if(o){break i}p=0;break h}while(1){v=s;p=o;s=p+20|0;o=q[s>>2];if(o){continue}s=p+16|0;o=q[p+16>>2];if(o){continue}break}q[v>>2]=0}if(!w){break g}s=q[u+28>>2];o=(s<<2)+18212|0;j:{if((u|0)==q[o>>2]){q[o>>2]=p;if(p){break j}x=17912,y=q[4478]&eo(s),q[x>>2]=y;break g}q[w+((u|0)==q[w+16>>2]?16:20)>>2]=p;if(!p){break g}}q[p+24>>2]=w;o=q[u+16>>2];if(o){q[p+16>>2]=o;q[o+24>>2]=p}o=q[u+20>>2];if(!o){break g}q[p+20>>2]=o;q[o+24>>2]=p}q[r+4>>2]=a|1;q[a+r>>2]=a;if(q[4482]!=(r|0)){break f}q[4479]=a;return}q[u+4>>2]=p&-2;q[r+4>>2]=a|1;q[a+r>>2]=a}if(a>>>0<=255){a=a>>>3;p=(a<<3)+17948|0;o=q[4477];a=1<<a;k:{if(!(o&a)){q[4477]=a|o;a=p;break k}a=q[p+8>>2]}q[p+8>>2]=r;q[a+12>>2]=r;q[r+12>>2]=p;q[r+8>>2]=a;return}q[r+16>>2]=0;q[r+20>>2]=0;p=r;s=a>>>8;o=0;l:{if(!s){break l}o=31;if(a>>>0>16777215){break l}o=s;s=s+1048320>>>16&8;o=o<<s;w=o+520192>>>16&4;o=o<<w;v=o+245760>>>16&2;o=(o<<v>>>15)-(v|(s|w))|0;o=(o<<1|a>>>o+21&1)+28|0}q[p+28>>2]=o;v=(o<<2)+18212|0;s=q[4478];p=1<<o;m:{if(!(s&p)){q[4478]=p|s;q[v>>2]=r;q[r+12>>2]=r;q[r+24>>2]=v;q[r+8>>2]=r;break m}s=a<<((o|0)==31?0:25-(o>>>1)|0);p=q[v>>2];n:{while(1){o=p;if((q[p+4>>2]&-8)==(a|0)){break n}p=s>>>29;s=s<<1;v=(o+(p&4)|0)+16|0;p=q[v>>2];if(p){continue}break}q[v>>2]=r;q[r+12>>2]=r;q[r+24>>2]=o;q[r+8>>2]=r;break m}a=q[o+8>>2];q[a+12>>2]=r;q[o+8>>2]=r;q[r+24>>2]=0;q[r+12>>2]=o;q[r+8>>2]=a}a=q[4485]+ -1|0;q[4485]=a;if(a){break a}r=18364;while(1){a=q[r>>2];r=a+8|0;if(a){continue}break}q[4485]=-1}}function Bn(a){var t=0;t=q[4604];a=t+a|0;if((a|0)<=-1){q[4458]=48;return-1}a:{if(a>>>0<=W()<<16>>>0){break a}if(P(a|0)){break a}q[4458]=48;return-1}q[4604]=a;return t}function Cn(a,z,A){var B=0,C=0,D=0;if(A>>>0>=8192){Q(a|0,z|0,A|0)|0;return a}C=a+A|0;a:{if(!((a^z)&3)){b:{if((A|0)<1){A=a;break b}if(!(a&3)){A=a;break b}A=a;while(1){o[A|0]=r[z|0];z=z+1|0;A=A+1|0;if(A>>>0>=C>>>0){break b}if(A&3){continue}break}}B=C&-4;c:{if(B>>>0<64){break c}D=B+ -64|0;if(A>>>0>D>>>0){break c}while(1){q[A>>2]=q[z>>2];q[A+4>>2]=q[z+4>>2];q[A+8>>2]=q[z+8>>2];q[A+12>>2]=q[z+12>>2];q[A+16>>2]=q[z+16>>2];q[A+20>>2]=q[z+20>>2];q[A+24>>2]=q[z+24>>2];q[A+28>>2]=q[z+28>>2];q[A+32>>2]=q[z+32>>2];q[A+36>>2]=q[z+36>>2];q[A+40>>2]=q[z+40>>2];q[A+44>>2]=q[z+44>>2];q[A+48>>2]=q[z+48>>2];q[A+52>>2]=q[z+52>>2];q[A+56>>2]=q[z+56>>2];q[A+60>>2]=q[z+60>>2];z=z- -64|0;A=A- -64|0;if(A>>>0<=D>>>0){continue}break}}if(A>>>0>=B>>>0){break a}while(1){q[A>>2]=q[z>>2];z=z+4|0;A=A+4|0;if(A>>>0<B>>>0){continue}break}break a}if(C>>>0<4){A=a;break a}B=C+ -4|0;if(B>>>0<a>>>0){A=a;break a}A=a;while(1){o[A|0]=r[z|0];o[A+1|0]=r[z+1|0];o[A+2|0]=r[z+2|0];o[A+3|0]=r[z+3|0];z=z+4|0;A=A+4|0;if(A>>>0<=B>>>0){continue}break}}if(A>>>0<C>>>0){while(1){o[A|0]=r[z|0];z=z+1|0;A=A+1|0;if((C|0)!=(A|0)){continue}break}}return a}function Dn(a,z,A){var E=0,F=0,G=0,H=0;a:{if(!A){break a}E=a+A|0;o[E+ -1|0]=z;o[a|0]=z;if(A>>>0<3){break a}o[E+ -2|0]=z;o[a+1|0]=z;o[E+ -3|0]=z;o[a+2|0]=z;if(A>>>0<7){break a}o[E+ -4|0]=z;o[a+3|0]=z;if(A>>>0<9){break a}E=0-a&3;F=E+a|0;z=w(z&255,16843009);q[F>>2]=z;A=A-E&-4;E=A+F|0;q[E+ -4>>2]=z;if(A>>>0<9){break a}q[F+8>>2]=z;q[F+4>>2]=z;q[E+ -8>>2]=z;q[E+ -12>>2]=z;if(A>>>0<25){break a}q[F+24>>2]=z;q[F+20>>2]=z;q[F+16>>2]=z;q[F+12>>2]=z;q[E+ -16>>2]=z;q[E+ -20>>2]=z;q[E+ -24>>2]=z;q[E+ -28>>2]=z;H=F&4|24;A=A-H|0;if(A>>>0<32){break a}E=z;G=z;z=F+H|0;while(1){q[z+24>>2]=G;q[z+28>>2]=E;q[z+16>>2]=G;q[z+20>>2]=E;q[z+8>>2]=G;q[z+12>>2]=E;q[z>>2]=G;q[z+4>>2]=E;z=z+32|0;A=A+ -32|0;if(A>>>0>31){continue}break}}return a}function En(a,z,A){var I=0,J=0;a:{if((a|0)==(z|0)){break a}b:{if(z+A>>>0>a>>>0){J=a+A|0;if(J>>>0>z>>>0){break b}}return Cn(a,z,A)}I=(a^z)&3;c:{d:{if(a>>>0<z>>>0){if(I){I=a;break c}if(!(a&3)){I=a;break d}I=a;while(1){if(!A){break a}o[I|0]=r[z|0];z=z+1|0;A=A+ -1|0;I=I+1|0;if(I&3){continue}break}break d}e:{if(I){break e}if(J&3){while(1){if(!A){break a}A=A+ -1|0;I=A+a|0;o[I|0]=r[z+A|0];if(I&3){continue}break}}if(A>>>0<=3){break e}while(1){A=A+ -4|0;q[A+a>>2]=q[z+A>>2];if(A>>>0>3){continue}break}}if(!A){break a}while(1){A=A+ -1|0;o[A+a|0]=r[z+A|0];if(A){continue}break}break a}if(A>>>0<=3){break c}J=A;while(1){q[I>>2]=q[z>>2];z=z+4|0;I=I+4|0;J=J+ -4|0;if(J>>>0>3){continue}break}A=A&3}if(!A){break a}while(1){o[I|0]=r[z|0];I=I+1|0;z=z+1|0;A=A+ -1|0;if(A){continue}break}}return a}function Fn(a,z){a=a|0;z=z|0;if(!q[4601]){q[4602]=z;q[4601]=a}}function Gn(){return T|0}function Hn(a){a=a|0;a=T-a&-16;T=a;return a|0}function In(a){a=a|0;T=a}function Jn(a){a=a|0;return X(a|0)|0}function Kn(a,q){a=a|0;q=q|0;return n[a](q)|0}function Ln(a,q){a=a|0;q=q|0;n[a](q)}function Mn(a,q,z){a=a|0;q=q|0;z=z|0;return n[a](q,z)|0}function Nn(a,q,z){a=a|0;q=q|0;z=z|0;n[a](q,z)}function On(a,q,z,A){a=a|0;q=q|0;z=z|0;A=A|0;return n[a](q,z,A)|0}function Pn(a){a=a|0;n[a]()}function Qn(a,q,z,A){a=a|0;q=q|0;z=z|0;A=A|0;n[a](q,z,A)}function Rn(a,q,z,A,K){a=a|0;q=q|0;z=z|0;A=A|0;K=K|0;n[a](q,z,A,K)}function Sn(a,q,z,A,K,L,M){a=a|0;q=q|0;z=z|0;A=A|0;K=K|0;L=L|0;M=M|0;return n[a](q,z,A,K,L,M)|0}function Tn(a,q,z,A,K,L,M){a=a|0;q=q|0;z=+z;A=A|0;K=K|0;L=L|0;M=M|0;return n[a](q,z,A,K,L,M)|0}function Un(a,q,z,A,K,L,M){a=a|0;q=q|0;z=z|0;A=A|0;K=K|0;L=L|0;M=M|0;n[a](q,z,A,K,L,M)}function Vn(a,q,z,A,K,L){a=a|0;q=q|0;z=z|0;A=A|0;K=K|0;L=L|0;n[a](q,z,A,K,L)}function Wn(a,q,z,A,K){a=a|0;q=q|0;z=z|0;A=A|0;K=K|0;a=n[a](q,z,A,K)|0;R(V|0);return a|0}function Xn(a,q){i(a|0,q|0)}function Yn(a,q,z,A){var K=0,L=0,M=0,N=0,O=0,P=0;K=z>>>16;L=a>>>16;P=w(K,L);M=z&65535;N=a&65535;O=w(M,N);L=(O>>>16)+w(L,M)|0;K=(L&65535)+w(K,N)|0;a=(((w(q,z)+P|0)+w(a,A)|0)+(L>>>16)|0)+(K>>>16)|0;q=O&65535|K<<16;V=a;return q}function Zn(a,q,z,A){var Q=0,R=0,S=0,T=0;Q=q;R=Q>>31;Q=Q>>31;a=a^Q;S=a-Q|0;T=(q^R)-((a>>>0<Q>>>0)+R|0)|0;Q=A;R=Q>>31;Q=Q>>31;a=z^Q;Q=bo(S,T,a-Q|0,(A^R)-((a>>>0<Q>>>0)+R|0)|0);q=q^A;z=q>>31;a=q>>31;q=Q^a;A=q-a|0;V=(z^V)-((q>>>0<a>>>0)+z|0)|0;return A}function _n(a,q,A,U){var W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0;a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{Y=q;if(Y){W=A;if(!W){break j}X=U;if(!X){break i}X=z(X)-z(Y)|0;if(X>>>0<=31){break h}break b}if((U|0)==1&A>>>0>=0|U>>>0>1){break b}q=(a>>>0)/(A>>>0)|0;Xn(a-w(q,A)|0,0);V=0;return q}W=U;if(!a){break g}if(!W){break f}X=W+ -1|0;if(X&W){break f}Xn(a,X&Y);a=Y>>>(fo(W)&31);V=0;return a}X=W+ -1|0;if(!(X&W)){break e}$=(z(W)+33|0)-z(Y)|0;Z=0-$|0;break c}$=X+1|0;Z=63-X|0;break c}a=(Y>>>0)/(W>>>0)|0;Xn(0,Y-w(a,W)|0);V=0;return a}X=z(W)-z(Y)|0;if(X>>>0<31){break d}break b}Xn(a&X,0);if((W|0)==1){break a}A=a;a=fo(W);U=a&31;if(32<=(a&63)>>>0){X=0;a=q>>>U}else{X=q>>>U;a=((1<<U)-1&q)<<32-U|A>>>U}V=X;return a}$=X+1|0;Z=63-X|0}W=q;Y=a;X=$&63;_=X&31;if(32<=(X&63)>>>0){X=0;ba=W>>>_}else{X=W>>>_;ba=((1<<_)-1&W)<<32-_|Y>>>_}a=Z&63;Z=a&31;if(32<=(a&63)>>>0){W=Y<<Z;a=0}else{W=(1<<Z)-1&Y>>>32-Z|q<<Z;a=Y<<Z}q=W;if($){Y=U+ -1|0;W=A+ -1|0;if(W>>>0<4294967295){Y=Y+1|0}Z=W;while(1){W=ba;X=X<<1|W>>>31;W=W<<1;aa=X;X=q>>>31|W;ca=aa;W=aa;aa=X;_=Y-((Z>>>0<X>>>0)+W|0)|0;W=_>>31;_=_>>31;X=A&_;ba=aa-X|0;X=ca-((U&W)+(aa>>>0<X>>>0)|0)|0;W=q<<1|a>>>31;a=da|a<<1;q=W|ea;W=0;ca=W;aa=_&1;da=aa;$=$+ -1|0;if($){continue}break}}Xn(ba,X);W=q<<1|a>>>31;a=aa|a<<1;V=W|ca;return a}Xn(a,q);a=0;q=0}V=q;return a}function $n(a,q,z,A){a=Yn(a,q,z,A);return a}function ao(a,q,z,A){a=Zn(a,q,z,A);return a}function bo(a,q,z,A){a=_n(a,q,z,A);return a}function co(a){var q=0,z=0;while(1){z=q;if(a){a=a-1&a;q=q+1|0;continue}break}return z}function eo(a){var A=0;A=a&31;a=0-a&31;return(-1>>>A&-2)<<A|(-1<<a&-2)>>>a}function fo(a){if(a){return 31-z(a+ -1^a)|0}return 32}




// EMSCRIPTEN_END_FUNCS
n[1]=hn;n[2]=bd;n[3]=cd;n[4]=dd;n[5]=$c;n[6]=ad;n[7]=id;n[8]=jd;n[9]=kd;n[10]=ed;n[11]=fd;n[12]=Bd;n[13]=Cd;n[14]=xd;n[15]=yd;n[16]=Dd;n[17]=Ed;n[18]=Fd;n[19]=Bb;n[20]=Gd;n[21]=fn;n[22]=Hd;n[23]=kd;n[24]=pe;n[25]=qe;n[26]=Jd;n[27]=ge;n[28]=le;n[29]=Ee;n[30]=Fe;n[31]=xe;n[32]=ye;n[33]=ze;n[34]=Ae;n[35]=Hd;n[36]=Ce;n[37]=De;n[38]=Oe;n[39]=Pe;n[40]=He;n[41]=Je;n[42]=Qe;n[43]=Ke;n[44]=Le;n[45]=Me;n[46]=Ne;n[47]=_e;n[48]=$e;n[49]=Se;n[50]=Te;n[51]=Ue;n[52]=Xe;n[53]=Ve;n[54]=af;n[55]=Ze;n[56]=nf;n[57]=gf;n[58]=kd;n[59]=xb;n[60]=hf;n[61]=jf;n[62]=kf;n[63]=Gd;n[64]=jf;n[65]=kd;n[66]=lf;n[67]=mf;n[68]=Cd;n[69]=Cd;n[70]=gf;n[71]=dd;n[72]=hf;n[73]=of;n[74]=pf;n[75]=qf;n[76]=rf;n[77]=hf;n[78]=sf;n[79]=vf;n[80]=wf;n[81]=xf;n[82]=yf;n[83]=zf;n[84]=kd;n[85]=Gd;n[86]=Af;n[87]=Bf;n[88]=Cf;n[89]=Ef;n[90]=Ff;n[91]=Gf;n[92]=zf;n[93]=kd;n[94]=Gd;n[95]=Af;n[96]=Hf;n[97]=If;n[98]=Lf;n[99]=Mf;n[100]=Nf;n[101]=Of;n[102]=kd;n[103]=Gd;n[104]=Pf;n[105]=Qf;n[106]=Rf;n[107]=bd;n[108]=cd;n[109]=Tf;n[110]=Bb;n[111]=Sf;n[112]=gf;n[113]=kd;n[114]=hf;n[115]=Wf;n[116]=Cd;n[117]=gf;n[118]=dd;n[119]=hf;n[120]=Xf;n[121]=Yf;n[122]=Zf;n[123]=rf;n[124]=hf;n[125]=sf;n[126]=_f;n[127]=$f;n[128]=ag;n[129]=yf;n[130]=zf;n[131]=kd;n[132]=Gd;n[133]=Af;n[134]=Bf;n[135]=bg;n[136]=dg;n[137]=eg;n[138]=Gf;n[139]=zf;n[140]=kd;n[141]=Gd;n[142]=Af;n[143]=Hf;n[144]=fg;n[145]=hg;n[146]=ig;n[147]=Nf;n[148]=Of;n[149]=kd;n[150]=Gd;n[151]=Pf;n[152]=Qf;n[153]=jg;n[154]=bd;n[155]=cd;n[156]=Tf;n[157]=Bb;n[158]=kg;n[159]=gf;n[160]=jf;n[161]=kd;n[162]=mg;n[163]=$e;n[164]=ng;n[165]=pg;n[166]=og;n[167]=sg;n[168]=dd;n[169]=qg;n[170]=vg;n[171]=wg;n[172]=Nf;n[173]=xb;n[174]=xg;n[175]=kd;n[176]=Gd;n[177]=yg;n[178]=kd;n[179]=dd;n[180]=zg;n[181]=Ag;n[182]=bd;n[183]=cd;n[184]=Tf;n[185]=Bb;n[186]=Sf;n[187]=Dg;n[188]=Eg;n[189]=Nf;n[190]=xg;n[191]=kd;n[192]=Gd;n[193]=yg;n[194]=zg;n[195]=Fg;n[196]=bd;n[197]=cd;n[198]=Tf;n[199]=Bb;n[200]=kg;n[201]=bd;n[202]=cd;n[203]=jf;n[204]=kd;n[205]=jf;n[206]=kf;n[207]=Gd;n[208]=Cg;n[209]=Gg;n[210]=Hg;n[211]=Ig;n[212]=Nf;n[213]=xb;n[214]=xg;n[215]=kd;n[216]=Gd;n[217]=yg;n[218]=kd;n[219]=yf;n[220]=Jg;n[221]=Kg;n[222]=bd;n[223]=cd;n[224]=Tf;n[225]=Bb;n[226]=Sf;n[227]=Ng;n[228]=Og;n[229]=Nf;n[230]=xg;n[231]=kd;n[232]=Gd;n[233]=yg;n[234]=Jg;n[235]=Pg;n[236]=bd;n[237]=cd;n[238]=Tf;n[239]=Bb;n[240]=kg;n[241]=cd;n[242]=jf;n[243]=kd;n[244]=jf;n[245]=kf;n[246]=Gd;n[247]=Mg;n[248]=Qg;n[249]=Xg;n[250]=Yg;n[251]=Rg;n[252]=Tg;n[253]=Sg;n[254]=Ug;n[255]=Vg;n[256]=Wg;n[257]=Th;n[258]=Cd;n[259]=kd;n[260]=kd;n[261]=Sh;n[262]=Nj;n[263]=Oj;n[264]=kd;n[265]=jf;n[266]=Gd;n[267]=Gd;n[268]=Yh;n[269]=Zh;n[270]=Vh;n[271]=Uh;n[272]=Xh;n[273]=_h;n[274]=$h;n[275]=ai;n[276]=Wh;n[277]=Qi;n[278]=Ri;n[279]=di;n[280]=ei;n[281]=fi;n[282]=gi;n[283]=ni;n[284]=kd;n[285]=xb;n[286]=Di;n[287]=Si;n[288]=Ti;n[289]=di;n[290]=ei;n[291]=fi;n[292]=gi;n[293]=Fi;n[294]=kd;n[295]=xb;n[296]=Di;n[297]=Ui;n[298]=Wi;n[299]=di;n[300]=ei;n[301]=fi;n[302]=gi;n[303]=Ki;n[304]=kd;n[305]=xb;n[306]=Di;n[307]=mi;n[308]=Xi;n[309]=li;n[310]=Yi;n[311]=Zi;n[312]=bj;n[313]=cj;n[314]=dj;n[315]=ej;n[316]=aj;n[317]=gj;n[318]=_i;n[319]=hj;n[320]=ij;n[321]=kj;n[322]=lj;n[323]=mj;n[324]=nj;n[325]=jj;n[326]=pj;n[327]=qj;n[328]=rj;n[329]=sj;n[330]=tj;n[331]=Ej;n[332]=Dj;n[333]=zj;n[334]=bd;n[335]=cd;n[336]=Fj;n[337]=Gj;n[338]=Cd;n[339]=jf;n[340]=kd;n[341]=Ej;n[342]=Rj;n[343]=Qj;n[344]=Ej;n[345]=Dj;n[346]=Sj;n[347]=xk;n[348]=yk;n[349]=zk;n[350]=Bk;n[351]=wk;n[352]=ll;n[353]=gl;n[354]=jl;n[355]=Sl;n[356]=Tl;n[357]=Wl;n[358]=Ul;n[359]=Vl;n[360]=jf;n[361]=Xl;n[362]=vm;n[363]=bd;n[364]=cd;n[365]=gn;n[366]=kn;n[367]=ln;n[368]=mn;n[369]=bd;n[370]=cd;n[371]=Hl;n[372]=Hl;n[373]=on;n[374]=yn;n[375]=wn;n[376]=rn;n[377]=cd;n[378]=xn;n[379]=vn;n[380]=sn;function W(){return buffer.byteLength/65536|0}function X(pagesToAdd){pagesToAdd=pagesToAdd|0;var Y=W()|0;var Z=Y+pagesToAdd|0;if(Y<Z&&Z<65536){var _=new ArrayBuffer(w(Z,65536));var $=new global.Int8Array(_);$.set(o);o=$;o=new global.Int8Array(_);p=new global.Int16Array(_);q=new global.Int32Array(_);r=new global.Uint8Array(_);s=new global.Uint16Array(_);t=new global.Uint32Array(_);u=new global.Float32Array(_);v=new global.Float64Array(_);buffer=_;m.buffer=_}return Y}return{"__wasm_call_ctors":ea,"emscripten_bind_Status_code_0":fb,"emscripten_bind_Status_ok_0":gb,"emscripten_bind_Status_error_msg_0":hb,"emscripten_bind_Status___destroy___0":ib,"emscripten_bind_DracoUInt16Array_DracoUInt16Array_0":jb,"emscripten_bind_DracoUInt16Array_GetValue_1":kb,"emscripten_bind_DracoUInt16Array_size_0":lb,"emscripten_bind_DracoUInt16Array___destroy___0":mb,"emscripten_bind_PointCloud_PointCloud_0":nb,"emscripten_bind_PointCloud_num_attributes_0":ob,"emscripten_bind_PointCloud_num_points_0":pb,"emscripten_bind_PointCloud___destroy___0":qb,"emscripten_bind_DracoUInt8Array_DracoUInt8Array_0":jb,"emscripten_bind_DracoUInt8Array_GetValue_1":rb,"emscripten_bind_DracoUInt8Array_size_0":sb,"emscripten_bind_DracoUInt8Array___destroy___0":mb,"emscripten_bind_DracoUInt32Array_DracoUInt32Array_0":jb,"emscripten_bind_DracoUInt32Array_GetValue_1":tb,"emscripten_bind_DracoUInt32Array_size_0":ub,"emscripten_bind_DracoUInt32Array___destroy___0":mb,"emscripten_bind_AttributeOctahedronTransform_AttributeOctahedronTransform_0":vb,"emscripten_bind_AttributeOctahedronTransform_InitFromAttribute_1":wb,"emscripten_bind_AttributeOctahedronTransform_quantization_bits_0":xb,"emscripten_bind_AttributeOctahedronTransform___destroy___0":qb,"emscripten_bind_PointAttribute_PointAttribute_0":yb,"emscripten_bind_PointAttribute_size_0":pb,"emscripten_bind_PointAttribute_GetAttributeTransformData_0":zb,"emscripten_bind_PointAttribute_attribute_type_0":Ab,"emscripten_bind_PointAttribute_data_type_0":Bb,"emscripten_bind_PointAttribute_num_components_0":Cb,"emscripten_bind_PointAttribute_normalized_0":Db,"emscripten_bind_PointAttribute_byte_stride_0":Eb,"emscripten_bind_PointAttribute_byte_offset_0":Fb,"emscripten_bind_PointAttribute_unique_id_0":Gb,"emscripten_bind_PointAttribute___destroy___0":Hb,"emscripten_bind_AttributeTransformData_AttributeTransformData_0":Ib,"emscripten_bind_AttributeTransformData_transform_type_0":fb,"emscripten_bind_AttributeTransformData___destroy___0":Jb,"emscripten_bind_AttributeQuantizationTransform_AttributeQuantizationTransform_0":Kb,"emscripten_bind_AttributeQuantizationTransform_InitFromAttribute_1":wb,"emscripten_bind_AttributeQuantizationTransform_quantization_bits_0":xb,"emscripten_bind_AttributeQuantizationTransform_min_value_1":Lb,"emscripten_bind_AttributeQuantizationTransform_range_0":Mb,"emscripten_bind_AttributeQuantizationTransform___destroy___0":qb,"emscripten_bind_DracoInt8Array_DracoInt8Array_0":jb,"emscripten_bind_DracoInt8Array_GetValue_1":Nb,"emscripten_bind_DracoInt8Array_size_0":sb,"emscripten_bind_DracoInt8Array___destroy___0":mb,"emscripten_bind_MetadataQuerier_MetadataQuerier_0":Ob,"emscripten_bind_MetadataQuerier_HasEntry_2":Pb,"emscripten_bind_MetadataQuerier_GetIntEntry_2":Qb,"emscripten_bind_MetadataQuerier_GetIntEntryArray_3":Rb,"emscripten_bind_MetadataQuerier_GetDoubleEntry_2":Sb,"emscripten_bind_MetadataQuerier_GetStringEntry_2":Tb,"emscripten_bind_MetadataQuerier_NumEntries_1":Ub,"emscripten_bind_MetadataQuerier_GetEntryName_2":Vb,"emscripten_bind_MetadataQuerier___destroy___0":Wb,"emscripten_bind_DracoInt16Array_DracoInt16Array_0":jb,"emscripten_bind_DracoInt16Array_GetValue_1":Xb,"emscripten_bind_DracoInt16Array_size_0":lb,"emscripten_bind_DracoInt16Array___destroy___0":mb,"emscripten_bind_DracoFloat32Array_DracoFloat32Array_0":jb,"emscripten_bind_DracoFloat32Array_GetValue_1":Yb,"emscripten_bind_DracoFloat32Array_size_0":ub,"emscripten_bind_DracoFloat32Array___destroy___0":mb,"emscripten_bind_GeometryAttribute_GeometryAttribute_0":Zb,"emscripten_bind_GeometryAttribute___destroy___0":_b,"emscripten_bind_DecoderBuffer_DecoderBuffer_0":$b,"emscripten_bind_DecoderBuffer_Init_2":ac,"emscripten_bind_DecoderBuffer___destroy___0":_b,"emscripten_bind_Decoder_Decoder_0":bc,"emscripten_bind_Decoder_GetEncodedGeometryType_1":cc,"emscripten_bind_Decoder_DecodeBufferToPointCloud_2":dc,"emscripten_bind_Decoder_DecodeBufferToMesh_2":ec,"emscripten_bind_Decoder_GetAttributeId_2":fc,"emscripten_bind_Decoder_GetAttributeIdByName_2":gc,"emscripten_bind_Decoder_GetAttributeIdByMetadataEntry_3":hc,"emscripten_bind_Decoder_GetAttribute_2":ic,"emscripten_bind_Decoder_GetAttributeByUniqueId_2":jc,"emscripten_bind_Decoder_GetMetadata_1":kc,"emscripten_bind_Decoder_GetAttributeMetadata_2":lc,"emscripten_bind_Decoder_GetFaceFromMesh_3":mc,"emscripten_bind_Decoder_GetTriangleStripsFromMesh_2":nc,"emscripten_bind_Decoder_GetTrianglesUInt16Array_3":oc,"emscripten_bind_Decoder_GetTrianglesUInt32Array_3":pc,"emscripten_bind_Decoder_GetAttributeFloat_3":qc,"emscripten_bind_Decoder_GetAttributeFloatForAllPoints_3":rc,"emscripten_bind_Decoder_GetAttributeIntForAllPoints_3":sc,"emscripten_bind_Decoder_GetAttributeInt8ForAllPoints_3":tc,"emscripten_bind_Decoder_GetAttributeUInt8ForAllPoints_3":uc,"emscripten_bind_Decoder_GetAttributeInt16ForAllPoints_3":vc,"emscripten_bind_Decoder_GetAttributeUInt16ForAllPoints_3":wc,"emscripten_bind_Decoder_GetAttributeInt32ForAllPoints_3":sc,"emscripten_bind_Decoder_GetAttributeUInt32ForAllPoints_3":xc,"emscripten_bind_Decoder_GetAttributeDataArrayForAllPoints_5":yc,"emscripten_bind_Decoder_SkipAttributeTransform_1":zc,"emscripten_bind_Decoder___destroy___0":Ac,"emscripten_bind_Mesh_Mesh_0":Dc,"emscripten_bind_Mesh_num_faces_0":Ec,"emscripten_bind_Mesh_num_attributes_0":ob,"emscripten_bind_Mesh_num_points_0":pb,"emscripten_bind_Mesh___destroy___0":qb,"emscripten_bind_VoidPtr___destroy___0":_b,"emscripten_bind_DracoInt32Array_DracoInt32Array_0":jb,"emscripten_bind_DracoInt32Array_GetValue_1":tb,"emscripten_bind_DracoInt32Array_size_0":ub,"emscripten_bind_DracoInt32Array___destroy___0":mb,"emscripten_bind_Metadata_Metadata_0":Fc,"emscripten_bind_Metadata___destroy___0":Gc,"emscripten_enum_draco_StatusCode_OK":Jc,"emscripten_enum_draco_StatusCode_DRACO_ERROR":Kc,"emscripten_enum_draco_StatusCode_IO_ERROR":Lc,"emscripten_enum_draco_StatusCode_INVALID_PARAMETER":Mc,"emscripten_enum_draco_StatusCode_UNSUPPORTED_VERSION":Nc,"emscripten_enum_draco_StatusCode_UNKNOWN_VERSION":Oc,"emscripten_enum_draco_DataType_DT_INVALID":Jc,"emscripten_enum_draco_DataType_DT_INT8":Pc,"emscripten_enum_draco_DataType_DT_UINT8":Qc,"emscripten_enum_draco_DataType_DT_INT16":Rc,"emscripten_enum_draco_DataType_DT_UINT16":Sc,"emscripten_enum_draco_DataType_DT_INT32":Tc,"emscripten_enum_draco_DataType_DT_UINT32":Uc,"emscripten_enum_draco_DataType_DT_INT64":Vc,"emscripten_enum_draco_DataType_DT_UINT64":Wc,"emscripten_enum_draco_DataType_DT_FLOAT32":Xc,"emscripten_enum_draco_DataType_DT_FLOAT64":Yc,"emscripten_enum_draco_DataType_DT_BOOL":Zc,"emscripten_enum_draco_DataType_DT_TYPES_COUNT":_c,"emscripten_enum_draco_EncodedGeometryType_INVALID_GEOMETRY_TYPE":Kc,"emscripten_enum_draco_EncodedGeometryType_POINT_CLOUD":Jc,"emscripten_enum_draco_EncodedGeometryType_TRIANGULAR_MESH":Pc,"emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_INVALID_TRANSFORM":Kc,"emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_NO_TRANSFORM":Jc,"emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_QUANTIZATION_TRANSFORM":Pc,"emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_OCTAHEDRON_TRANSFORM":Qc,"emscripten_enum_draco_GeometryAttribute_Type_INVALID":Kc,"emscripten_enum_draco_GeometryAttribute_Type_POSITION":Jc,"emscripten_enum_draco_GeometryAttribute_Type_NORMAL":Pc,"emscripten_enum_draco_GeometryAttribute_Type_COLOR":Qc,"emscripten_enum_draco_GeometryAttribute_Type_TEX_COORD":Rc,"emscripten_enum_draco_GeometryAttribute_Type_GENERIC":Sc,"setThrew":Fn,"_ZSt18uncaught_exceptionv":Jc,"free":An,"malloc":zn,"stackSave":Gn,"stackAlloc":Hn,"stackRestore":In,"__growWasmMemory":Jn,"dynCall_ii":Kn,"dynCall_vi":Ln,"dynCall_iii":Mn,"dynCall_vii":Nn,"dynCall_iiii":On,"dynCall_v":Pn,"dynCall_viii":Qn,"dynCall_viiii":Rn,"dynCall_iiiiiii":Sn,"dynCall_iidiiii":Tn,"dynCall_jiji":Wn,"dynCall_viiiiii":Un,"dynCall_viiiii":Vn}}var aa=(function(mem){var ba=new Uint8Array(mem);return(function(offset,s){var ca,da;if(typeof Buffer==="undefined"){ca=atob(s);for(da=0;da<ca.length;da++)ba[offset+da]=ca.charCodeAt(da)}else{ca=Buffer.from(s,"base64");for(da=0;da<ca.length;da++)ba[offset+da]=ca[da]}})})(wasmMemory.buffer);aa(1027,"wAAAAMAAAADAAAAAwGFsbG9jYXRvcjxUPjo6YWxsb2NhdGUoc2l6ZV90IG4pICduJyBleGNlZWRzIG1heGltdW0gc3VwcG9ydGVkIHNpemUAAAAAALwEAAACAAAAAwAAAAQAAAAFAAAABgAAAE41ZHJhY28yOEF0dHJpYnV0ZU9jdGFoZWRyb25UcmFuc2Zvcm1FAE41ZHJhY28xOEF0dHJpYnV0ZVRyYW5zZm9ybUUA+D4AAJcEAAAgPwAAcAQAALQEAAAAAAAAEAUAAAcAAAAIAAAACQAAAAoAAAALAAAATjVkcmFjbzMwQXR0cmlidXRlUXVhbnRpemF0aW9uVHJhbnNmb3JtRQAAAAAgPwAA5AQAALQEAABhbGxvY2F0b3I8VD46OmFsbG9jYXRlKHNpemVfdCBuKSAnbicgZXhjZWVkcyBtYXhpbXVtIHN1cHBvcnRlZCBzaXplAAAAAADkBQAADAAAAA0AAAAOAAAADwAAABAAAAARAAAAEgAAABMAAAAUAAAAFQAAABYAAAAXAAAATjVkcmFjbzE3QXR0cmlidXRlc0RlY29kZXJFAE41ZHJhY28yNkF0dHJpYnV0ZXNEZWNvZGVySW50ZXJmYWNlRQAAAAD4PgAAtAUAACA/AACYBQAA3AUAAGFsbG9jYXRvcjxUPjo6YWxsb2NhdGUoc2l6ZV90IG4pICduJyBleGNlZWRzIG1heGltdW0gc3VwcG9ydGVkIHNpemUAAAAAAOgGAAAYAAAAGQAAAA4AAAAPAAAAEAAAABEAAAASAAAAEwAAABQAAAAaAAAAGwAAABwAAABLZFRyZWVBdHRyaWJ1dGVzRGVjb2RlcjogY29tcHJlc3Npb24gbGV2ZWwgJWkgbm90IHN1cHBvcnRlZC4KAHNraXBfYXR0cmlidXRlX3RyYW5zZm9ybQBONWRyYWNvMjNLZFRyZWVBdHRyaWJ1dGVzRGVjb2RlckUAAAAAID8AAMMGAADkBQAAYWxsb2NhdG9yPFQ+OjphbGxvY2F0ZShzaXplX3QgbikgJ24nIGV4Y2VlZHMgbWF4aW11bSBzdXBwb3J0ZWQgc2l6ZQBNZXRob2Qgbm90IHN1cHBvcnRlZC4gCgBWZXJzaW9uIG5vdCBzdXBwb3J0ZWQuIAo=");aa(1904,"wAcAAB0AAAAeAAAAHwAAACAAAAAhAAAAIgAAACMAAAAkAAAAJQAAAE41ZHJhY28yNlNlcXVlbnRpYWxBdHRyaWJ1dGVEZWNvZGVyRQAAAAD4PgAAmAcAAP////8AAAAAVAgAACYAAAAnAAAADgAAACgAAAApAAAAEQAAABIAAAATAAAAKgAAACsAAAAsAAAALQAAAC4AAABza2lwX2F0dHJpYnV0ZV90cmFuc2Zvcm0ATjVkcmFjbzM3U2VxdWVudGlhbEF0dHJpYnV0ZURlY29kZXJzQ29udHJvbGxlckUAAAAAID8AACEIAADkBQAAYWxsb2NhdG9yPFQ+OjphbGxvY2F0ZShzaXplX3QgbikgJ24nIGV4Y2VlZHMgbWF4aW11bSBzdXBwb3J0ZWQgc2l6ZQAAAAAADAkAAC8AAAAwAAAAMQAAACAAAAAhAAAAIgAAADIAAAAkAAAAMwAAADQAAAA1AAAANgAAADcAAABONWRyYWNvMzNTZXF1ZW50aWFsSW50ZWdlckF0dHJpYnV0ZURlY29kZXJFACA/AADgCAAAwAcAAAAAAACYCwAAOAAAADkAAAA6AAAAOwAAADwAAAA9AAAAPgAAAD8AAABAAAAAQQAAAEIAAABDAAAATjVkcmFjbzQwTWVzaFByZWRpY3Rpb25TY2hlbWVQYXJhbGxlbG9ncmFtRGVjb2RlcklpTlNfMzdQcmVkaWN0aW9uU2NoZW1lV3JhcERlY29kaW5nVHJhbnNmb3JtSWlpRUVOU18yNE1lc2hQcmVkaWN0aW9uU2NoZW1lRGF0YUlOU18yNE1lc2hBdHRyaWJ1dGVDb3JuZXJUYWJsZUVFRUVFAE41ZHJhY28yN01lc2hQcmVkaWN0aW9uU2NoZW1lRGVjb2RlcklpTlNfMzdQcmVkaWN0aW9uU2NoZW1lV3JhcERlY29kaW5nVHJhbnNmb3JtSWlpRUVOU18yNE1lc2hQcmVkaWN0aW9uU2NoZW1lRGF0YUlOU18yNE1lc2hBdHRyaWJ1dGVDb3JuZXJUYWJsZUVFRUVFAE41ZHJhY28yM1ByZWRpY3Rpb25TY2hlbWVEZWNvZGVySWlOU18zN1ByZWRpY3Rpb25TY2hlbWVXcmFwRGVjb2RpbmdUcmFuc2Zvcm1JaWlFRUVFAE41ZHJhY28zN1ByZWRpY3Rpb25TY2hlbWVUeXBlZERlY29kZXJJbnRlcmZhY2VJaWlFRQBONWRyYWNvMzJQcmVkaWN0aW9uU2NoZW1lRGVjb2RlckludGVyZmFjZUUATjVkcmFjbzI1UHJlZGljdGlvblNjaGVtZUludGVyZmFjZUUA+D4AADwLAAAgPwAAEQsAAGALAAAgPwAA3QoAAGgLAAAgPwAAiQoAAHQLAAAgPwAA8wkAAIALAAAgPwAAUAkAAIwLAAAAAAAAjAsAADgAAABEAAAAFQAAADsAAAAVAAAAPQAAAD4AAAA/AAAAQAAAAEEAAABCAAAAFQAAAAAAAACACwAAOAAAAEUAAAAVAAAAOwAAABUAAAA9AAAAPgAAAD8AAABAAAAAQQAAAEIAAAAVAAAAAAAAAPQMAAA4AAAARgAAAEcAAAA7AAAASAAAAD0AAAA+AAAAPwAAAEAAAABBAAAAQgAAAEkAAABONWRyYWNvNDVNZXNoUHJlZGljdGlvblNjaGVtZU11bHRpUGFyYWxsZWxvZ3JhbURlY29kZXJJaU5TXzM3UHJlZGljdGlvblNjaGVtZVdyYXBEZWNvZGluZ1RyYW5zZm9ybUlpaUVFTlNfMjRNZXNoUHJlZGljdGlvblNjaGVtZURhdGFJTlNfMjRNZXNoQXR0cmlidXRlQ29ybmVyVGFibGVFRUVFRQAgPwAATAwAAIwLAAAAAAAA7A0AAEoAAABLAAAATAAAADsAAABNAAAAPQAAAD4AAAA/AAAAQAAAAEEAAABOAAAATwAAAE41ZHJhY281Nk1lc2hQcmVkaWN0aW9uU2NoZW1lQ29uc3RyYWluZWRNdWx0aVBhcmFsbGVsb2dyYW1EZWNvZGVySWlOU18zN1ByZWRpY3Rpb25TY2hlbWVXcmFwRGVjb2RpbmdUcmFuc2Zvcm1JaWlFRU5TXzI0TWVzaFByZWRpY3Rpb25TY2hlbWVEYXRhSU5TXzI0TWVzaEF0dHJpYnV0ZUNvcm5lclRhYmxlRUVFRUUAACA/AAA4DQAAjAsAAAAAAADQDgAAUAAAAFEAAABSAAAAOwAAAFMAAABUAAAAVQAAAFYAAABAAAAAQQAAAFcAAABYAAAATjVkcmFjbzM2TWVzaFByZWRpY3Rpb25TY2hlbWVUZXhDb29yZHNEZWNvZGVySWlOU18zN1ByZWRpY3Rpb25TY2hlbWVXcmFwRGVjb2RpbmdUcmFuc2Zvcm1JaWlFRU5TXzI0TWVzaFByZWRpY3Rpb25TY2hlbWVEYXRhSU5TXzI0TWVzaEF0dHJpYnV0ZUNvcm5lclRhYmxlRUVFRUUAACA/AAAwDgAAjAsAAAAAAAC8DwAAWQAAAFoAAABbAAAAOwAAAFwAAABdAAAAXgAAAF8AAABAAAAAQQAAAGAAAABhAAAATjVkcmFjbzQ0TWVzaFByZWRpY3Rpb25TY2hlbWVUZXhDb29yZHNQb3J0YWJsZURlY29kZXJJaU5TXzM3UHJlZGljdGlvblNjaGVtZVdyYXBEZWNvZGluZ1RyYW5zZm9ybUlpaUVFTlNfMjRNZXNoUHJlZGljdGlvblNjaGVtZURhdGFJTlNfMjRNZXNoQXR0cmlidXRlQ29ybmVyVGFibGVFRUVFRQAAID8AABQPAACMCwAAAAAAAKgQAABiAAAAYwAAAGQAAAA7AAAAZQAAAGYAAABnAAAAaAAAAEAAAABBAAAAaQAAAGoAAABONWRyYWNvNDJNZXNoUHJlZGljdGlvblNjaGVtZUdlb21ldHJpY05vcm1hbERlY29kZXJJaU5TXzM3UHJlZGljdGlvblNjaGVtZVdyYXBEZWNvZGluZ1RyYW5zZm9ybUlpaUVFTlNfMjRNZXNoUHJlZGljdGlvblNjaGVtZURhdGFJTlNfMjRNZXNoQXR0cmlidXRlQ29ybmVyVGFibGVFRUVFRQAAAAAgPwAAABAAAIwLAAAAAAAAMBIAAGsAAABsAAAAbQAAAG4AAABvAAAATjVkcmFjbzQ4TWVzaFByZWRpY3Rpb25TY2hlbWVHZW9tZXRyaWNOb3JtYWxQcmVkaWN0b3JBcmVhSWlOU18zN1ByZWRpY3Rpb25TY2hlbWVXcmFwRGVjb2RpbmdUcmFuc2Zvcm1JaWlFRU5TXzI0TWVzaFByZWRpY3Rpb25TY2hlbWVEYXRhSU5TXzI0TWVzaEF0dHJpYnV0ZUNvcm5lclRhYmxlRUVFRUUATjVkcmFjbzQ4TWVzaFByZWRpY3Rpb25TY2hlbWVHZW9tZXRyaWNOb3JtYWxQcmVkaWN0b3JCYXNlSWlOU18zN1ByZWRpY3Rpb25TY2hlbWVXcmFwRGVjb2RpbmdUcmFuc2Zvcm1JaWlFRU5TXzI0TWVzaFByZWRpY3Rpb25TY2hlbWVEYXRhSU5TXzI0TWVzaEF0dHJpYnV0ZUNvcm5lclRhYmxlRUVFRUUAAAD4PgAAexEAACA/AADQEAAAKBIAAAAAAACgEwAAOAAAAHAAAABxAAAAOwAAAHIAAAA9AAAAPgAAAD8AAABAAAAAQQAAAEIAAABzAAAATjVkcmFjbzQwTWVzaFByZWRpY3Rpb25TY2hlbWVQYXJhbGxlbG9ncmFtRGVjb2RlcklpTlNfMzdQcmVkaWN0aW9uU2NoZW1lV3JhcERlY29kaW5nVHJhbnNmb3JtSWlpRUVOU18yNE1lc2hQcmVkaWN0aW9uU2NoZW1lRGF0YUlOU18xMUNvcm5lclRhYmxlRUVFRUUATjVkcmFjbzI3TWVzaFByZWRpY3Rpb25TY2hlbWVEZWNvZGVySWlOU18zN1ByZWRpY3Rpb25TY2hlbWVXcmFwRGVjb2RpbmdUcmFuc2Zvcm1JaWlFRU5TXzI0TWVzaFByZWRpY3Rpb25TY2hlbWVEYXRhSU5TXzExQ29ybmVyVGFibGVFRUVFRQAAID8AAAoTAACACwAAID8AAHQSAACUEwAAAAAAAJQTAAA4AAAAdAAAABUAAAA7AAAAFQAAAD0AAAA+AAAAPwAAAEAAAABBAAAAQgAAABUAAAAAAAAAuBQAADgAAAB1AAAAdgAAADsAAAB3AAAAPQAAAD4AAAA/AAAAQAAAAEEAAABCAAAAeAAAAE41ZHJhY280NU1lc2hQcmVkaWN0aW9uU2NoZW1lTXVsdGlQYXJhbGxlbG9ncmFtRGVjb2RlcklpTlNfMzdQcmVkaWN0aW9uU2NoZW1lV3JhcERlY29kaW5nVHJhbnNmb3JtSWlpRUVOU18yNE1lc2hQcmVkaWN0aW9uU2NoZW1lRGF0YUlOU18xMUNvcm5lclRhYmxlRUVFRUUAACA/AAAcFAAAlBMAAAAAAACkFQAAeQAAAHoAAAB7AAAAOwAAAHwAAAA9AAAAPgAAAD8AAABAAAAAQQAAAH0AAAB+AAAATjVkcmFjbzU2TWVzaFByZWRpY3Rpb25TY2hlbWVDb25zdHJhaW5lZE11bHRpUGFyYWxsZWxvZ3JhbURlY29kZXJJaU5TXzM3UHJlZGljdGlvblNjaGVtZVdyYXBEZWNvZGluZ1RyYW5zZm9ybUlpaUVFTlNfMjRNZXNoUHJlZGljdGlvblNjaGVtZURhdGFJTlNfMTFDb3JuZXJUYWJsZUVFRUVFAAAAID8AAPwUAACUEwAAAAAAAHwWAAB/AAAAgAAAAIEAAAA7AAAAggAAAIMAAACEAAAAhQAAAEAAAABBAAAAhgAAAIcAAABONWRyYWNvMzZNZXNoUHJlZGljdGlvblNjaGVtZVRleENvb3Jkc0RlY29kZXJJaU5TXzM3UHJlZGljdGlvblNjaGVtZVdyYXBEZWNvZGluZ1RyYW5zZm9ybUlpaUVFTlNfMjRNZXNoUHJlZGljdGlvblNjaGVtZURhdGFJTlNfMTFDb3JuZXJUYWJsZUVFRUVFAAAAID8AAOgVAACUEwAAAAAAAFwXAACIAAAAiQAAAIoAAAA7AAAAiwAAAIwAAACNAAAAjgAAAEAAAABBAAAAjwAAAJAAAABONWRyYWNvNDRNZXNoUHJlZGljdGlvblNjaGVtZVRleENvb3Jkc1BvcnRhYmxlRGVjb2RlcklpTlNfMzdQcmVkaWN0aW9uU2NoZW1lV3JhcERlY29kaW5nVHJhbnNmb3JtSWlpRUVOU18yNE1lc2hQcmVkaWN0aW9uU2NoZW1lRGF0YUlOU18xMUNvcm5lclRhYmxlRUVFRUUAAAAgPwAAwBYAAJQTAAAAAAAAOBgAAJEAAACSAAAAkwAAADsAAACUAAAAlQAAAJYAAACXAAAAQAAAAEEAAACYAAAAmQAAAE41ZHJhY280Mk1lc2hQcmVkaWN0aW9uU2NoZW1lR2VvbWV0cmljTm9ybWFsRGVjb2RlcklpTlNfMzdQcmVkaWN0aW9uU2NoZW1lV3JhcERlY29kaW5nVHJhbnNmb3JtSWlpRUVOU18yNE1lc2hQcmVkaWN0aW9uU2NoZW1lRGF0YUlOU18xMUNvcm5lclRhYmxlRUVFRUUAID8AAKAXAACUEwAAAAAAAKQZAACaAAAAmwAAAJwAAACdAAAAngAAAE41ZHJhY280OE1lc2hQcmVkaWN0aW9uU2NoZW1lR2VvbWV0cmljTm9ybWFsUHJlZGljdG9yQXJlYUlpTlNfMzdQcmVkaWN0aW9uU2NoZW1lV3JhcERlY29kaW5nVHJhbnNmb3JtSWlpRUVOU18yNE1lc2hQcmVkaWN0aW9uU2NoZW1lRGF0YUlOU18xMUNvcm5lclRhYmxlRUVFRUUATjVkcmFjbzQ4TWVzaFByZWRpY3Rpb25TY2hlbWVHZW9tZXRyaWNOb3JtYWxQcmVkaWN0b3JCYXNlSWlOU18zN1ByZWRpY3Rpb25TY2hlbWVXcmFwRGVjb2RpbmdUcmFuc2Zvcm1JaWlFRU5TXzI0TWVzaFByZWRpY3Rpb25TY2hlbWVEYXRhSU5TXzExQ29ybmVyVGFibGVFRUVFRQD4PgAA/hgAACA/AABgGAAAnBkAAAAAAABEGgAAOAAAAJ8AAACgAAAAOwAAAKEAAAA9AAAAPgAAAD8AAABAAAAAQQAAAEIAAACiAAAATjVkcmFjbzI4UHJlZGljdGlvblNjaGVtZURlbHRhRGVjb2RlcklpTlNfMzdQcmVkaWN0aW9uU2NoZW1lV3JhcERlY29kaW5nVHJhbnNmb3JtSWlpRUVFRQAAAAAgPwAA6BkAAIALAAAAAAAAuBoAAC8AAACjAAAApAAAACAAAAAhAAAApQAAADIAAAAkAAAAMwAAAKYAAACnAAAAqAAAAKkAAABONWRyYWNvMzJTZXF1ZW50aWFsTm9ybWFsQXR0cmlidXRlRGVjb2RlckUAACA/AACMGgAADAkAAAAAAADEHAAAqgAAAKsAAACsAAAArQAAAK4AAACvAAAAsAAAALEAAACyAAAAswAAALQAAAC1AAAATjVkcmFjbzQyTWVzaFByZWRpY3Rpb25TY2hlbWVHZW9tZXRyaWNOb3JtYWxEZWNvZGVySWlOU180OVByZWRpY3Rpb25TY2hlbWVOb3JtYWxPY3RhaGVkcm9uRGVjb2RpbmdUcmFuc2Zvcm1JaUVFTlNfMjRNZXNoUHJlZGljdGlvblNjaGVtZURhdGFJTlNfMjRNZXNoQXR0cmlidXRlQ29ybmVyVGFibGVFRUVFRQBONWRyYWNvMjdNZXNoUHJlZGljdGlvblNjaGVtZURlY29kZXJJaU5TXzQ5UHJlZGljdGlvblNjaGVtZU5vcm1hbE9jdGFoZWRyb25EZWNvZGluZ1RyYW5zZm9ybUlpRUVOU18yNE1lc2hQcmVkaWN0aW9uU2NoZW1lRGF0YUlOU18yNE1lc2hBdHRyaWJ1dGVDb3JuZXJUYWJsZUVFRUVFAE41ZHJhY28yM1ByZWRpY3Rpb25TY2hlbWVEZWNvZGVySWlOU180OVByZWRpY3Rpb25TY2hlbWVOb3JtYWxPY3RhaGVkcm9uRGVjb2RpbmdUcmFuc2Zvcm1JaUVFRUUAID8AAE0cAAB0CwAAID8AAKwbAACsHAAAID8AAPwaAAC4HAAAAAAAAGAeAAC2AAAAtwAAALgAAAC5AAAAugAAAE41ZHJhY280OE1lc2hQcmVkaWN0aW9uU2NoZW1lR2VvbWV0cmljTm9ybWFsUHJlZGljdG9yQXJlYUlpTlNfNDlQcmVkaWN0aW9uU2NoZW1lTm9ybWFsT2N0YWhlZHJvbkRlY29kaW5nVHJhbnNmb3JtSWlFRU5TXzI0TWVzaFByZWRpY3Rpb25TY2hlbWVEYXRhSU5TXzI0TWVzaEF0dHJpYnV0ZUNvcm5lclRhYmxlRUVFRUUATjVkcmFjbzQ4TWVzaFByZWRpY3Rpb25TY2hlbWVHZW9tZXRyaWNOb3JtYWxQcmVkaWN0b3JCYXNlSWlOU180OVByZWRpY3Rpb25TY2hlbWVOb3JtYWxPY3RhaGVkcm9uRGVjb2RpbmdUcmFuc2Zvcm1JaUVFTlNfMjRNZXNoUHJlZGljdGlvblNjaGVtZURhdGFJTlNfMjRNZXNoQXR0cmlidXRlQ29ybmVyVGFibGVFRUVFRQD4PgAAoh0AACA/AADsHAAAWB4AAAAAAADoHwAAuwAAALwAAAC9AAAArQAAAL4AAAC/AAAAwAAAAMEAAACyAAAAswAAAMIAAADDAAAATjVkcmFjbzQyTWVzaFByZWRpY3Rpb25TY2hlbWVHZW9tZXRyaWNOb3JtYWxEZWNvZGVySWlOU180OVByZWRpY3Rpb25TY2hlbWVOb3JtYWxPY3RhaGVkcm9uRGVjb2RpbmdUcmFuc2Zvcm1JaUVFTlNfMjRNZXNoUHJlZGljdGlvblNjaGVtZURhdGFJTlNfMTFDb3JuZXJUYWJsZUVFRUVFAE41ZHJhY28yN01lc2hQcmVkaWN0aW9uU2NoZW1lRGVjb2RlcklpTlNfNDlQcmVkaWN0aW9uU2NoZW1lTm9ybWFsT2N0YWhlZHJvbkRlY29kaW5nVHJhbnNmb3JtSWlFRU5TXzI0TWVzaFByZWRpY3Rpb25TY2hlbWVEYXRhSU5TXzExQ29ybmVyVGFibGVFRUVFRQAAID8AAEcfAACsHAAAID8AAKQeAADcHwAAAAAAAGwhAADEAAAAxQAAAMYAAADHAAAAyAAAAE41ZHJhY280OE1lc2hQcmVkaWN0aW9uU2NoZW1lR2VvbWV0cmljTm9ybWFsUHJlZGljdG9yQXJlYUlpTlNfNDlQcmVkaWN0aW9uU2NoZW1lTm9ybWFsT2N0YWhlZHJvbkRlY29kaW5nVHJhbnNmb3JtSWlFRU5TXzI0TWVzaFByZWRpY3Rpb25TY2hlbWVEYXRhSU5TXzExQ29ybmVyVGFibGVFRUVFRQBONWRyYWNvNDhNZXNoUHJlZGljdGlvblNjaGVtZUdlb21ldHJpY05vcm1hbFByZWRpY3RvckJhc2VJaU5TXzQ5UHJlZGljdGlvblNjaGVtZU5vcm1hbE9jdGFoZWRyb25EZWNvZGluZ1RyYW5zZm9ybUlpRUVOU18yNE1lc2hQcmVkaWN0aW9uU2NoZW1lRGF0YUlOU18xMUNvcm5lclRhYmxlRUVFRUUAAAD4PgAAuSAAACA/AAAQIAAAZCEAAAAAAAAUIgAAyQAAAMoAAADLAAAArQAAAMwAAADNAAAAzgAAAM8AAACyAAAAswAAANAAAADRAAAATjVkcmFjbzI4UHJlZGljdGlvblNjaGVtZURlbHRhRGVjb2RlcklpTlNfNDlQcmVkaWN0aW9uU2NoZW1lTm9ybWFsT2N0YWhlZHJvbkRlY29kaW5nVHJhbnNmb3JtSWlFRUVFACA/AACwIQAArBwAAAAAAABIJAAA0gAAANMAAADUAAAA1QAAANYAAADXAAAA2AAAANkAAADaAAAA2wAAANwAAADdAAAATjVkcmFjbzQyTWVzaFByZWRpY3Rpb25TY2hlbWVHZW9tZXRyaWNOb3JtYWxEZWNvZGVySWlOU182MlByZWRpY3Rpb25TY2hlbWVOb3JtYWxPY3RhaGVkcm9uQ2Fub25pY2FsaXplZERlY29kaW5nVHJhbnNmb3JtSWlFRU5TXzI0TWVzaFByZWRpY3Rpb25TY2hlbWVEYXRhSU5TXzI0TWVzaEF0dHJpYnV0ZUNvcm5lclRhYmxlRUVFRUUATjVkcmFjbzI3TWVzaFByZWRpY3Rpb25TY2hlbWVEZWNvZGVySWlOU182MlByZWRpY3Rpb25TY2hlbWVOb3JtYWxPY3RhaGVkcm9uQ2Fub25pY2FsaXplZERlY29kaW5nVHJhbnNmb3JtSWlFRU5TXzI0TWVzaFByZWRpY3Rpb25TY2hlbWVEYXRhSU5TXzI0TWVzaEF0dHJpYnV0ZUNvcm5lclRhYmxlRUVFRUUATjVkcmFjbzIzUHJlZGljdGlvblNjaGVtZURlY29kZXJJaU5TXzYyUHJlZGljdGlvblNjaGVtZU5vcm1hbE9jdGFoZWRyb25DYW5vbmljYWxpemVkRGVjb2RpbmdUcmFuc2Zvcm1JaUVFRUUAACA/AADDIwAAdAsAACA/AAAVIwAAMCQAACA/AABYIgAAPCQAAAAAAAAAJgAA3gAAAN8AAADgAAAA4QAAAOIAAABONWRyYWNvNDhNZXNoUHJlZGljdGlvblNjaGVtZUdlb21ldHJpY05vcm1hbFByZWRpY3RvckFyZWFJaU5TXzYyUHJlZGljdGlvblNjaGVtZU5vcm1hbE9jdGFoZWRyb25DYW5vbmljYWxpemVkRGVjb2RpbmdUcmFuc2Zvcm1JaUVFTlNfMjRNZXNoUHJlZGljdGlvblNjaGVtZURhdGFJTlNfMjRNZXNoQXR0cmlidXRlQ29ybmVyVGFibGVFRUVFRQBONWRyYWNvNDhNZXNoUHJlZGljdGlvblNjaGVtZUdlb21ldHJpY05vcm1hbFByZWRpY3RvckJhc2VJaU5TXzYyUHJlZGljdGlvblNjaGVtZU5vcm1hbE9jdGFoZWRyb25DYW5vbmljYWxpemVkRGVjb2RpbmdUcmFuc2Zvcm1JaUVFTlNfMjRNZXNoUHJlZGljdGlvblNjaGVtZURhdGFJTlNfMjRNZXNoQXR0cmlidXRlQ29ybmVyVGFibGVFRUVFRQAAAPg+AAAzJQAAID8AAHAkAAD4JQAAAAAAAKQnAADjAAAA5AAAAOUAAADVAAAA5gAAAOcAAADoAAAA6QAAANoAAADbAAAA6gAAAOsAAABONWRyYWNvNDJNZXNoUHJlZGljdGlvblNjaGVtZUdlb21ldHJpY05vcm1hbERlY29kZXJJaU5TXzYyUHJlZGljdGlvblNjaGVtZU5vcm1hbE9jdGFoZWRyb25DYW5vbmljYWxpemVkRGVjb2RpbmdUcmFuc2Zvcm1JaUVFTlNfMjRNZXNoUHJlZGljdGlvblNjaGVtZURhdGFJTlNfMTFDb3JuZXJUYWJsZUVFRUVFAE41ZHJhY28yN01lc2hQcmVkaWN0aW9uU2NoZW1lRGVjb2RlcklpTlNfNjJQcmVkaWN0aW9uU2NoZW1lTm9ybWFsT2N0YWhlZHJvbkNhbm9uaWNhbGl6ZWREZWNvZGluZ1RyYW5zZm9ybUlpRUVOU18yNE1lc2hQcmVkaWN0aW9uU2NoZW1lRGF0YUlOU18xMUNvcm5lclRhYmxlRUVFRUUAAAAAID8AAPQmAAAwJAAAID8AAEQmAACYJwAAAAAAAEApAADsAAAA7QAAAO4AAADvAAAA8AAAAE41ZHJhY280OE1lc2hQcmVkaWN0aW9uU2NoZW1lR2VvbWV0cmljTm9ybWFsUHJlZGljdG9yQXJlYUlpTlNfNjJQcmVkaWN0aW9uU2NoZW1lTm9ybWFsT2N0YWhlZHJvbkNhbm9uaWNhbGl6ZWREZWNvZGluZ1RyYW5zZm9ybUlpRUVOU18yNE1lc2hQcmVkaWN0aW9uU2NoZW1lRGF0YUlOU18xMUNvcm5lclRhYmxlRUVFRUUATjVkcmFjbzQ4TWVzaFByZWRpY3Rpb25TY2hlbWVHZW9tZXRyaWNOb3JtYWxQcmVkaWN0b3JCYXNlSWlOU182MlByZWRpY3Rpb25TY2hlbWVOb3JtYWxPY3RhaGVkcm9uQ2Fub25pY2FsaXplZERlY29kaW5nVHJhbnNmb3JtSWlFRU5TXzI0TWVzaFByZWRpY3Rpb25TY2hlbWVEYXRhSU5TXzExQ29ybmVyVGFibGVFRUVFRQD4PgAAgigAACA/AADMJwAAOCkAAAAAAAD4KQAAyQAAAPEAAADyAAAA1QAAAPMAAAD0AAAA9QAAAPYAAADaAAAA2wAAAPcAAAD4AAAATjVkcmFjbzI4UHJlZGljdGlvblNjaGVtZURlbHRhRGVjb2RlcklpTlNfNjJQcmVkaWN0aW9uU2NoZW1lTm9ybWFsT2N0YWhlZHJvbkNhbm9uaWNhbGl6ZWREZWNvZGluZ1RyYW5zZm9ybUlpRUVFRQAAAAAgPwAAhCkAADAkAAAAAAAAfCoAAPkAAAD6AAAA+wAAACAAAAAhAAAA/AAAADIAAAAkAAAAMwAAAP0AAAA1AAAANgAAAP4AAAD/AAAAAAEAAE41ZHJhY28zOFNlcXVlbnRpYWxRdWFudGl6YXRpb25BdHRyaWJ1dGVEZWNvZGVyRQAAAAAgPwAASCoAAAwJAABVbnN1cHBvcnRlZCBlbmNvZGluZyBtZXRob2QuAElucHV0IGlzIG5vdCBhIHBvaW50IGNsb3VkLgBJbnB1dCBpcyBub3QgYSBtZXNoLgBza2lwX2F0dHJpYnV0ZV90cmFuc2Zvcm0AYWxsb2NhdG9yPFQ+OjphbGxvY2F0ZShzaXplX3QgbikgJ24nIGV4Y2VlZHMgbWF4aW11bSBzdXBwb3J0ZWQgc2l6ZQAAAAAAAIgrAAABAQAAAgEAAAMBAAAEAQAAFQAAAAUBAAAGAQAABwEAAAgBAAAJAQAACgEAAAsBAAAVAAAATjVkcmFjbzExTWVzaERlY29kZXJFAAAAID8AAHArAABUNQAAAAAAAPQrAAAMAQAADQEAAAMBAAAOAQAADwEAAAUBAAAGAQAABwEAABABAAARAQAAEgEAABMBAAAUAQAATjVkcmFjbzIyTWVzaEVkZ2VicmVha2VyRGVjb2RlckUAAAAAID8AANArAACIKwAAAAAAABgtAAAVAQAAFgEAABcBAAAYAQAAGQEAABoBAAAbAQAAHAEAAB0BAAAeAQAA/////wAAAAB8LQAAHwEAACABAAAhAQAAIgEAACMBAAAkAQAAJQEAACYBAAAnAQAAKAEAAAAAAADcLQAAKQEAACoBAAArAQAALAEAAC0BAAAuAQAALwEAADABAAAxAQAAMgEAAE41ZHJhY28yNk1lc2hFZGdlYnJlYWtlckRlY29kZXJJbXBsSU5TXzMxTWVzaEVkZ2VicmVha2VyVHJhdmVyc2FsRGVjb2RlckVFRQBONWRyYWNvMzVNZXNoRWRnZWJyZWFrZXJEZWNvZGVySW1wbEludGVyZmFjZUUAAAD4PgAA4CwAACA/AACULAAAEC0AAE41ZHJhY28yNk1lc2hFZGdlYnJlYWtlckRlY29kZXJJbXBsSU5TXzQxTWVzaEVkZ2VicmVha2VyVHJhdmVyc2FsUHJlZGljdGl2ZURlY29kZXJFRUUAAAAgPwAAJC0AABAtAABONWRyYWNvMjZNZXNoRWRnZWJyZWFrZXJEZWNvZGVySW1wbElOU18zOE1lc2hFZGdlYnJlYWtlclRyYXZlcnNhbFZhbGVuY2VEZWNvZGVyRUVFAAAgPwAAiC0AABAtAAAAAAAA2C4AADMBAAA0AQAANQEAAE41ZHJhY28xOURlcHRoRmlyc3RUcmF2ZXJzZXJJTlNfMjRNZXNoQXR0cmlidXRlQ29ybmVyVGFibGVFTlNfMzZNZXNoQXR0cmlidXRlSW5kaWNlc0VuY29kaW5nT2JzZXJ2ZXJJUzFfRUVFRQBONWRyYWNvMTNUcmF2ZXJzZXJCYXNlSU5TXzI0TWVzaEF0dHJpYnV0ZUNvcm5lclRhYmxlRU5TXzM2TWVzaEF0dHJpYnV0ZUluZGljZXNFbmNvZGluZ09ic2VydmVySVMxX0VFRUUA+D4AAGkuAAAgPwAA/C0AANAuAAAAAAAA0C4AADYBAAA3AQAANQEAAGFsbG9jYXRvcjxUPjo6YWxsb2NhdGUoc2l6ZV90IG4pICduJyBleGNlZWRzIG1heGltdW0gc3VwcG9ydGVkIHNpemU=");aa(12100,"AQAAAAMAAAAFAAAABwAAAAAAAAAYMAAAOAEAADkBAAA6AQAAOwEAAE41ZHJhY28yMk1lc2hUcmF2ZXJzYWxTZXF1ZW5jZXJJTlNfMjhNYXhQcmVkaWN0aW9uRGVncmVlVHJhdmVyc2VySU5TXzExQ29ybmVyVGFibGVFTlNfMzZNZXNoQXR0cmlidXRlSW5kaWNlc0VuY29kaW5nT2JzZXJ2ZXJJUzJfRUVFRUVFAE41ZHJhY28xNVBvaW50c1NlcXVlbmNlckUAAAAA+D4AAPMvAAAgPwAAbC8AABAwAAD/////AAAAAAgxAAA8AQAAPQEAAD4BAABONWRyYWNvMjhNYXhQcmVkaWN0aW9uRGVncmVlVHJhdmVyc2VySU5TXzExQ29ybmVyVGFibGVFTlNfMzZNZXNoQXR0cmlidXRlSW5kaWNlc0VuY29kaW5nT2JzZXJ2ZXJJUzFfRUVFRQBONWRyYWNvMTNUcmF2ZXJzZXJCYXNlSU5TXzExQ29ybmVyVGFibGVFTlNfMzZNZXNoQXR0cmlidXRlSW5kaWNlc0VuY29kaW5nT2JzZXJ2ZXJJUzFfRUVFRQAA+D4AAKUwAAAgPwAAPDAAAAAxAAAAAAAAADEAAD8BAABAAQAAPgEAAAAAAADAMQAAQQEAAEIBAABDAQAARAEAAE41ZHJhY28yMk1lc2hUcmF2ZXJzYWxTZXF1ZW5jZXJJTlNfMTlEZXB0aEZpcnN0VHJhdmVyc2VySU5TXzExQ29ybmVyVGFibGVFTlNfMzZNZXNoQXR0cmlidXRlSW5kaWNlc0VuY29kaW5nT2JzZXJ2ZXJJUzJfRUVFRUVFAAAAID8AAEAxAAAQMAAAAAAAAEAyAABFAQAARgEAAD4BAABONWRyYWNvMTlEZXB0aEZpcnN0VHJhdmVyc2VySU5TXzExQ29ybmVyVGFibGVFTlNfMzZNZXNoQXR0cmlidXRlSW5kaWNlc0VuY29kaW5nT2JzZXJ2ZXJJUzFfRUVFRQAgPwAA4DEAAAAxAAAAAAAA8DIAAEcBAABIAQAASQEAAEoBAABONWRyYWNvMjJNZXNoVHJhdmVyc2FsU2VxdWVuY2VySU5TXzE5RGVwdGhGaXJzdFRyYXZlcnNlcklOU18yNE1lc2hBdHRyaWJ1dGVDb3JuZXJUYWJsZUVOU18zNk1lc2hBdHRyaWJ1dGVJbmRpY2VzRW5jb2RpbmdPYnNlcnZlcklTMl9FRUVFRUUAACA/AABkMgAAEDA=");aa(13060,"XDMAAAEBAABLAQAAAwEAAAQBAABMAQAABQEAAAYBAAAHAQAACAEAAAkBAAAKAQAACwEAAE0BAABONWRyYWNvMjFNZXNoU2VxdWVudGlhbERlY29kZXJFACA/AAA8MwAAiCsAAGFsbG9jYXRvcjxUPjo6YWxsb2NhdGUoc2l6ZV90IG4pICduJyBleGNlZWRzIG1heGltdW0gc3VwcG9ydGVkIHNpemUAAAAAAOAzAABOAQAATwEAAFABAABRAQAATjVkcmFjbzE1TGluZWFyU2VxdWVuY2VyRQAAACA/AADEMwAAEDAAAAAAAABUNQAAAQEAAFIBAABTAQAABAEAABUAAABUAQAABgEAAAcBAAAIAQ==");aa(13344,"RmFpbGVkIHRvIHBhcnNlIERyYWNvIGhlYWRlci4ARFJBQ08ATm90IGEgRHJhY28gZmlsZS4ARmFpbGVkIHRvIGRlY29kZSBtZXRhZGF0YS4AVXNpbmcgaW5jb21wYXRpYmxlIGRlY29kZXIgZm9yIHRoZSBpbnB1dCBnZW9tZXRyeS4AVW5rbm93biBtYWpvciB2ZXJzaW9uLgBVbmtub3duIG1pbm9yIHZlcnNpb24uAEZhaWxlZCB0byBpbml0aWFsaXplIHRoZSBkZWNvZGVyLgBGYWlsZWQgdG8gZGVjb2RlIGdlb21ldHJ5IGRhdGEuAEZhaWxlZCB0byBkZWNvZGUgcG9pbnQgYXR0cmlidXRlcy4ATjVkcmFjbzE3UG9pbnRDbG91ZERlY29kZXJFAAD4PgAANzUAAAAAAACsNQAAAQEAAFUBAABTAQAABAEAAFYBAABXAQAABgEAAAcBAAAIAQAATjVkcmFjbzIzUG9pbnRDbG91ZEtkVHJlZURlY29kZXJFAAAAID8AAIg1AABUNQAAAAAAAAw2AAABAQAAWAEAAFMBAAAEAQAAWQEAAFoBAAAGAQAABwEAAAgBAABONWRyYWNvMjdQb2ludENsb3VkU2VxdWVudGlhbERlY29kZXJFAAAAID8AAOQ1AABUNQAAAQAAAAEAAAACAAAAAgAAAAQAAAAEAAAACAAAAAgAAAAEAAAACAAAAAEAAAAAAAAA//////////9hbGxvY2F0b3I8VD46OmFsbG9jYXRlKHNpemVfdCBuKSAnbicgZXhjZWVkcyBtYXhpbXVtIHN1cHBvcnRlZCBzaXplAAAAAAC8NgAAWwEAAFwBAABdAQAAXgEAAE41ZHJhY280TWVzaEUAAAAgPwAArDYAAFQ4AABhbGxvY2F0b3I8VD46OmFsbG9jYXRlKHNpemVfdCBuKSAnbicgZXhjZWVkcyBtYXhpbXVtIHN1cHBvcnRlZCBzaXplAGFsbG9jYXRvcjxUPjo6YWxsb2NhdGUoc2l6ZV90IG4pICduJyBleGNlZWRzIG1heGltdW0gc3VwcG9ydGVkIHNpemUA/////2FsbG9jYXRvcjxUPjo6YWxsb2NhdGUoc2l6ZV90IG4pICduJyBleGNlZWRzIG1heGltdW0gc3VwcG9ydGVkIHNpemUAYWxsb2NhdG9yPFQ+OjphbGxvY2F0ZShzaXplX3QgbikgJ24nIGV4Y2VlZHMgbWF4aW11bSBzdXBwb3J0ZWQgc2l6ZQBhbGxvY2F0b3I8VD46OmFsbG9jYXRlKHNpemVfdCBuKSAnbicgZXhjZWVkcyBtYXhpbXVtIHN1cHBvcnRlZCBzaXpl");aa(14376,"VDgAAF8BAABgAQAAYQEAAGIBAABONWRyYWNvMTBQb2ludENsb3VkRQAAAAD4PgAAPDgAAGFsbG9jYXRvcjxUPjo6YWxsb2NhdGUoc2l6ZV90IG4pICduJyBleGNlZWRzIG1heGltdW0gc3VwcG9ydGVkIHNpemUARmxvYXRQb2ludHNUcmVlRGVjb2RlcjogY29tcHJlc3Npb24gbGV2ZWwgJWkgbm90IHN1cHBvcnRlZC4KAGFsbG9jYXRvcjxUPjo6YWxsb2NhdGUoc2l6ZV90IG4pICduJyBleGNlZWRzIG1heGltdW0gc3VwcG9ydGVkIHNpemUALSsgICAwWDB4AChudWxsKQ==");aa(14656,"EQAKABEREQAAAAAFAAAAAAAACQAAAAAL");aa(14688,"EQAPChEREQMKBwABEwkLCwAACQYLAAALAAYRAAAAERER");aa(14737,"Cw==");aa(14746,"EQAKChEREQAKAAACAAkLAAAACQALAAAL");aa(14795,"DA==");aa(14807,"DAAAAAAMAAAAAAkMAAAAAAAMAAAM");aa(14853,"Dg==");aa(14865,"DQAAAAQNAAAAAAkOAAAAAAAOAAAO");aa(14911,"EA==");aa(14923,"DwAAAAAPAAAAAAkQAAAAAAAQAAAQAAASAAAAEhIS");aa(14978,"EgAAABISEgAAAAAAAAk=");aa(15027,"Cw==");aa(15039,"CgAAAAAKAAAAAAkLAAAAAAALAAAL");aa(15085,"DA==");aa(15097,"DAAAAAAMAAAAAAkMAAAAAAAMAAAMAAAwMTIzNDU2Nzg5QUJDREVGLTBYKzBYIDBYLTB4KzB4IDB4AGluZgBJTkYAbmFuAE5BTgAuAAAAAHg/AAAIQAAAAAAAAAIAAAADAAAABQAAAAcAAAALAAAADQAAABEAAAATAAAAFwAAAB0AAAAfAAAAJQAAACkAAAArAAAALwAAADUAAAA7AAAAPQAAAEMAAABHAAAASQAAAE8AAABTAAAAWQAAAGEAAABlAAAAZwAAAGsAAABtAAAAcQAAAH8AAACDAAAAiQAAAIsAAACVAAAAlwAAAJ0AAACjAAAApwAAAK0AAACzAAAAtQAAAL8AAADBAAAAxQAAAMcAAADTAAAAAQAAAAsAAAANAAAAEQAAABMAAAAXAAAAHQAAAB8AAAAlAAAAKQAAACsAAAAvAAAANQAAADsAAAA9AAAAQwAAAEcAAABJAAAATwAAAFMAAABZAAAAYQAAAGUAAABnAAAAawAAAG0AAABxAAAAeQAAAH8AAACDAAAAiQAAAIsAAACPAAAAlQAAAJcAAACdAAAAowAAAKcAAACpAAAArQAAALMAAAC1AAAAuwAAAL8AAADBAAAAxQAAAMcAAADR");aa(15604,"agE=");aa(15643,"//////8=");aa(15712,"YWxsb2NhdG9yPFQ+OjphbGxvY2F0ZShzaXplX3QgbikgJ24nIGV4Y2VlZHMgbWF4aW11bSBzdXBwb3J0ZWQgc2l6ZQBiYXNpY19zdHJpbmcAJWQAdmVjdG9yAFB1cmUgdmlydHVhbCBmdW5jdGlvbiBjYWxsZWQhAHN0ZDo6ZXhjZXB0aW9uAAAAAAAMPgAAawEAAGwBAABtAQAAU3Q5ZXhjZXB0aW9uAAAAAPg+AAD8PQAAAAAAADg+AAABAAAAbgEAAG8BAABTdDExbG9naWNfZXJyb3IAID8AACg+AAAMPgAAAAAAAGw+AAABAAAAcAEAAG8BAABTdDEybGVuZ3RoX2Vycm9yAAAAACA/AABYPgAAOD4AAFN0OXR5cGVfaW5mbwAAAAD4PgAAeD4AAE4xMF9fY3h4YWJpdjExNl9fc2hpbV90eXBlX2luZm9FAAAAACA/AACQPgAAiD4AAE4xMF9fY3h4YWJpdjExN19fY2xhc3NfdHlwZV9pbmZvRQAAACA/AADAPgAAtD4AAAAAAADkPgAAcQEAAHIBAABzAQAAdAEAAHUBAAB2AQAAdwEAAHgBAAAAAAAAaD8AAHEBAAB5AQAAcwEAAHQBAAB1AQAAegEAAHsBAAB8AQAATjEwX19jeHhhYml2MTIwX19zaV9jbGFzc190eXBlX2luZm9FAAAAACA/AABAPwAA5D4=");aa(16248,"BQ==");aa(16260,"ZQE=");aa(16284,"ZgEAAGcBAACYQQ==");aa(16308,"Ag==");aa(16323,"//////8=");aa(16392,"BQ==");aa(16404,"aAE=");aa(16428,"ZgEAAGkBAACoQQAAAAQ=");aa(16452,"AQ==");aa(16467,"Cv////8=");aa(16724,"1EU=");return l({"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity,"Math":Math},asmLibraryArg,wasmMemory.buffer)}


// EMSCRIPTEN_END_ASM




)(asmLibraryArg,wasmMemory,wasmTable);return{"exports":exports}},instantiate:function(binary,info){return{then:function(ok,err){ok({"instance":new WebAssembly.Instance(new WebAssembly.Module(binary,info))})}}},RuntimeError:Error};wasmBinary=[];if(typeof WebAssembly!=="object"){err("no native wasm support detected")}function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=1?tempDouble>0?(Math_min(+Math_floor(tempDouble/4294967296),4294967295)|0)>>>0:~~+Math_ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}var wasmMemory;var wasmTable=new WebAssembly.Table({"initial":381,"maximum":381+0,"element":"anyfunc"});var ABORT=false;var EXITSTATUS=0;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}function getCFunc(ident){var func=Module["_"+ident];assert(func,"Cannot call unknown function "+ident+", make sure it is exported");return func}function ccall(ident,returnType,argTypes,args,opts){var toC={"string":function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){var len=(str.length<<2)+1;ret=stackAlloc(len);stringToUTF8(str,ret,len)}return ret},"array":function(arr){var ret=stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}};function convertReturnValue(ret){if(returnType==="string")return UTF8ToString(ret);if(returnType==="boolean")return Boolean(ret);return ret}var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);ret=convertReturnValue(ret);if(stack!==0)stackRestore(stack);return ret}var ALLOC_NONE=3;var UTF8Decoder=typeof TextDecoder!=="undefined"?new TextDecoder("utf8"):undefined;function UTF8ArrayToString(u8Array,idx,maxBytesToRead){var endIdx=idx+maxBytesToRead;var endPtr=idx;while(u8Array[endPtr]&&!(endPtr>=endIdx))++endPtr;if(endPtr-idx>16&&u8Array.subarray&&UTF8Decoder){return UTF8Decoder.decode(u8Array.subarray(idx,endPtr))}else{var str="";while(idx<endPtr){var u0=u8Array[idx++];if(!(u0&128)){str+=String.fromCharCode(u0);continue}var u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}var u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u0=(u0&7)<<18|u1<<12|u2<<6|u8Array[idx++]&63}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}return str}function UTF8ToString(ptr,maxBytesToRead){return ptr?UTF8ArrayToString(HEAPU8,ptr,maxBytesToRead):""}function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343){var u1=str.charCodeAt(++i);u=65536+((u&1023)<<10)|u1&1023}if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127)++len;else if(u<=2047)len+=2;else if(u<=65535)len+=3;else len+=4}return len}var UTF16Decoder=typeof TextDecoder!=="undefined"?new TextDecoder("utf-16le"):undefined;function writeArrayToMemory(array,buffer){HEAP8.set(array,buffer)}function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}var WASM_PAGE_SIZE=65536;function alignUp(x,multiple){if(x%multiple>0){x+=multiple-x%multiple}return x}var buffer,HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;function updateGlobalBufferAndViews(buf){buffer=buf;Module["HEAP8"]=HEAP8=new Int8Array(buf);Module["HEAP16"]=HEAP16=new Int16Array(buf);Module["HEAP32"]=HEAP32=new Int32Array(buf);Module["HEAPU8"]=HEAPU8=new Uint8Array(buf);Module["HEAPU16"]=HEAPU16=new Uint16Array(buf);Module["HEAPU32"]=HEAPU32=new Uint32Array(buf);Module["HEAPF32"]=HEAPF32=new Float32Array(buf);Module["HEAPF64"]=HEAPF64=new Float64Array(buf)}var STACK_BASE=5261456,DYNAMIC_BASE=5261456,DYNAMICTOP_PTR=18416;var INITIAL_TOTAL_MEMORY=Module["TOTAL_MEMORY"]||16777216;if(Module["wasmMemory"]){wasmMemory=Module["wasmMemory"]}else{wasmMemory=new WebAssembly.Memory({"initial":INITIAL_TOTAL_MEMORY/WASM_PAGE_SIZE})}if(wasmMemory){buffer=wasmMemory.buffer}INITIAL_TOTAL_MEMORY=buffer.byteLength;updateGlobalBufferAndViews(buffer);HEAP32[DYNAMICTOP_PTR>>2]=DYNAMIC_BASE;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Module["dynCall_v"](func)}else{Module["dynCall_vi"](func,callback.arg)}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function initRuntime(){runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}function addOnPreMain(cb){__ATMAIN__.unshift(cb)}function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}var Math_abs=Math.abs;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_min=Math.min;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["preloadedImages"]={};Module["preloadedAudios"]={};function abort(what){if(Module["onAbort"]){Module["onAbort"](what)}what+="";out(what);err(what);ABORT=true;EXITSTATUS=1;what="abort("+what+"). Build with -s ASSERTIONS=1 for more info.";throw new WebAssembly.RuntimeError(what)}var dataURIPrefix="data:application/octet-stream;base64,";function isDataURI(filename){return String.prototype.startsWith?filename.startsWith(dataURIPrefix):filename.indexOf(dataURIPrefix)===0}var wasmBinaryFile="draco_decoder.wasm";if(!isDataURI(wasmBinaryFile)){wasmBinaryFile=locateFile(wasmBinaryFile)}function getBinary(){try{if(wasmBinary){return new Uint8Array(wasmBinary)}var binary=tryParseAsDataURI(wasmBinaryFile);if(binary){return binary}if(readBinary){return readBinary(wasmBinaryFile)}else{throw"both async and sync fetching of the wasm failed"}}catch(err){abort(err)}}function getBinaryPromise(){if(!wasmBinary&&(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER)&&typeof fetch==="function"){return fetch(wasmBinaryFile,{credentials:"same-origin"}).then(function(response){if(!response["ok"]){throw"failed to load wasm binary file at '"+wasmBinaryFile+"'"}return response["arrayBuffer"]()}).catch(function(){return getBinary()})}return new Promise(function(resolve,reject){resolve(getBinary())})}function createWasm(){var info={"env":asmLibraryArg,"wasi_unstable":asmLibraryArg};function receiveInstance(instance,module){var exports=instance.exports;Module["asm"]=exports;removeRunDependency("wasm-instantiate")}addRunDependency("wasm-instantiate");function receiveInstantiatedSource(output){receiveInstance(output["instance"])}function instantiateArrayBuffer(receiver){return getBinaryPromise().then(function(binary){return WebAssembly.instantiate(binary,info)}).then(receiver,function(reason){err("failed to asynchronously prepare wasm: "+reason);abort(reason)})}function instantiateAsync(){if(!wasmBinary&&typeof WebAssembly.instantiateStreaming==="function"&&!isDataURI(wasmBinaryFile)&&typeof fetch==="function"){fetch(wasmBinaryFile,{credentials:"same-origin"}).then(function(response){var result=WebAssembly.instantiateStreaming(response,info);return result.then(receiveInstantiatedSource,function(reason){err("wasm streaming compile failed: "+reason);err("falling back to ArrayBuffer instantiation");instantiateArrayBuffer(receiveInstantiatedSource)})})}else{return instantiateArrayBuffer(receiveInstantiatedSource)}}if(Module["instantiateWasm"]){try{var exports=Module["instantiateWasm"](info,receiveInstance);return exports}catch(e){err("Module.instantiateWasm callback failed with error: "+e);return false}}instantiateAsync();return{}}var tempDouble;var tempI64;__ATINIT__.push({func:function(){___wasm_call_ctors()}});function demangle(func){return func}function demangleAll(text){var regex=/\b_Z[\w\d_]+/g;return text.replace(regex,function(x){var y=demangle(x);return x===y?x:y+" ["+x+"]"})}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function ___cxa_allocate_exception(size){return _malloc(size)}var ___exception_infos={};var ___exception_last=0;function ___cxa_throw(ptr,type,destructor){___exception_infos[ptr]={ptr:ptr,adjusted:[ptr],type:type,destructor:destructor,refcount:0,caught:false,rethrown:false};___exception_last=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exceptions=1}else{__ZSt18uncaught_exceptionv.uncaught_exceptions++}throw ptr}function _abort(){abort()}function _emscripten_get_heap_size(){return HEAP8.length}function _emscripten_get_sbrk_ptr(){return 18416}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest)}function emscripten_realloc_buffer(size){try{wasmMemory.grow(size-buffer.byteLength+65535>>16);updateGlobalBufferAndViews(wasmMemory.buffer);return 1}catch(e){}}function _emscripten_resize_heap(requestedSize){var oldSize=_emscripten_get_heap_size();var PAGE_MULTIPLE=65536;var LIMIT=2147483648-PAGE_MULTIPLE;if(requestedSize>LIMIT){return false}var MIN_TOTAL_MEMORY=16777216;var newSize=Math.max(oldSize,MIN_TOTAL_MEMORY);while(newSize<requestedSize){if(newSize<=536870912){newSize=alignUp(2*newSize,PAGE_MULTIPLE)}else{newSize=Math.min(alignUp((3*newSize+2147483648)/4,PAGE_MULTIPLE),LIMIT)}}var replacement=emscripten_realloc_buffer(newSize);if(!replacement){return false}return true}var ENV={};function _emscripten_get_environ(){if(!_emscripten_get_environ.strings){var env={"USER":"web_user","LOGNAME":"web_user","PATH":"/","PWD":"/","HOME":"/home/web_user","LANG":(typeof navigator==="object"&&navigator.languages&&navigator.languages[0]||"C").replace("-","_")+".UTF-8","_":thisProgram};for(var x in ENV){env[x]=ENV[x]}var strings=[];for(var x in env){strings.push(x+"="+env[x])}_emscripten_get_environ.strings=strings}return _emscripten_get_environ.strings}function _environ_get(__environ,environ_buf){var strings=_emscripten_get_environ();var bufSize=0;strings.forEach(function(string,i){var ptr=environ_buf+bufSize;HEAP32[__environ+i*4>>2]=ptr;writeAsciiToMemory(string,ptr);bufSize+=string.length+1});return 0}function _environ_sizes_get(penviron_count,penviron_buf_size){var strings=_emscripten_get_environ();HEAP32[penviron_count>>2]=strings.length;var bufSize=0;strings.forEach(function(string){bufSize+=string.length+1});HEAP32[penviron_buf_size>>2]=bufSize;return 0}var PATH={splitPath:function(filename){var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;return splitPathRe.exec(filename).slice(1)},normalizeArray:function(parts,allowAboveRoot){var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==="."){parts.splice(i,1)}else if(last===".."){parts.splice(i,1);up++}else if(up){parts.splice(i,1);up--}}if(allowAboveRoot){for(;up;up--){parts.unshift("..")}}return parts},normalize:function(path){var isAbsolute=path.charAt(0)==="/",trailingSlash=path.substr(-1)==="/";path=PATH.normalizeArray(path.split("/").filter(function(p){return!!p}),!isAbsolute).join("/");if(!path&&!isAbsolute){path="."}if(path&&trailingSlash){path+="/"}return(isAbsolute?"/":"")+path},dirname:function(path){var result=PATH.splitPath(path),root=result[0],dir=result[1];if(!root&&!dir){return"."}if(dir){dir=dir.substr(0,dir.length-1)}return root+dir},basename:function(path){if(path==="/")return"/";var lastSlash=path.lastIndexOf("/");if(lastSlash===-1)return path;return path.substr(lastSlash+1)},extname:function(path){return PATH.splitPath(path)[3]},join:function(){var paths=Array.prototype.slice.call(arguments,0);return PATH.normalize(paths.join("/"))},join2:function(l,r){return PATH.normalize(l+"/"+r)}};var SYSCALLS={buffers:[null,[],[]],printChar:function(stream,curr){var buffer=SYSCALLS.buffers[stream];if(curr===0||curr===10){(stream===1?out:err)(UTF8ArrayToString(buffer,0));buffer.length=0}else{buffer.push(curr)}},varargs:0,get:function(varargs){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret},getStr:function(){var ret=UTF8ToString(SYSCALLS.get());return ret},get64:function(){var low=SYSCALLS.get(),high=SYSCALLS.get();return low},getZero:function(){SYSCALLS.get()}};function _fd_close(fd){try{return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return e.errno}}function _fd_seek(fd,offset_low,offset_high,whence,newOffset){try{return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return e.errno}}function _fd_write(fd,iov,iovcnt,pnum){try{var num=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];for(var j=0;j<len;j++){SYSCALLS.printChar(fd,HEAPU8[ptr+j])}num+=len}HEAP32[pnum>>2]=num;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return e.errno}}var ASSERTIONS=false;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){if(ASSERTIONS){assert(false,"Character code "+chr+" ("+String.fromCharCode(chr)+")  at offset "+i+" not in 0x00-0xFF.")}chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}var decodeBase64=typeof atob==="function"?atob:function(input){var keyStr="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";var output="";var chr1,chr2,chr3;var enc1,enc2,enc3,enc4;var i=0;input=input.replace(/[^A-Za-z0-9\+\/\=]/g,"");do{enc1=keyStr.indexOf(input.charAt(i++));enc2=keyStr.indexOf(input.charAt(i++));enc3=keyStr.indexOf(input.charAt(i++));enc4=keyStr.indexOf(input.charAt(i++));chr1=enc1<<2|enc2>>4;chr2=(enc2&15)<<4|enc3>>2;chr3=(enc3&3)<<6|enc4;output=output+String.fromCharCode(chr1);if(enc3!==64){output=output+String.fromCharCode(chr2)}if(enc4!==64){output=output+String.fromCharCode(chr3)}}while(i<input.length);return output};function intArrayFromBase64(s){if(typeof ENVIRONMENT_IS_NODE==="boolean"&&ENVIRONMENT_IS_NODE){var buf;try{buf=Buffer.from(s,"base64")}catch(_){buf=new Buffer(s,"base64")}return new Uint8Array(buf.buffer,buf.byteOffset,buf.byteLength)}try{var decoded=decodeBase64(s);var bytes=new Uint8Array(decoded.length);for(var i=0;i<decoded.length;++i){bytes[i]=decoded.charCodeAt(i)}return bytes}catch(_){throw new Error("Converting base64 string to bytes failed.")}}function tryParseAsDataURI(filename){if(!isDataURI(filename)){return}return intArrayFromBase64(filename.slice(dataURIPrefix.length))}var asmLibraryArg={"__cxa_allocate_exception":___cxa_allocate_exception,"__cxa_throw":___cxa_throw,"abort":_abort,"emscripten_get_sbrk_ptr":_emscripten_get_sbrk_ptr,"emscripten_memcpy_big":_emscripten_memcpy_big,"emscripten_resize_heap":_emscripten_resize_heap,"environ_get":_environ_get,"environ_sizes_get":_environ_sizes_get,"fd_close":_fd_close,"fd_seek":_fd_seek,"fd_write":_fd_write,"getTempRet0":getTempRet0,"memory":wasmMemory,"setTempRet0":setTempRet0,"table":wasmTable};var asm=createWasm();Module["asm"]=asm;var ___wasm_call_ctors=Module["___wasm_call_ctors"]=function(){return Module["asm"]["__wasm_call_ctors"].apply(null,arguments)};var _emscripten_bind_Status_code_0=Module["_emscripten_bind_Status_code_0"]=function(){return Module["asm"]["emscripten_bind_Status_code_0"].apply(null,arguments)};var _emscripten_bind_Status_ok_0=Module["_emscripten_bind_Status_ok_0"]=function(){return Module["asm"]["emscripten_bind_Status_ok_0"].apply(null,arguments)};var _emscripten_bind_Status_error_msg_0=Module["_emscripten_bind_Status_error_msg_0"]=function(){return Module["asm"]["emscripten_bind_Status_error_msg_0"].apply(null,arguments)};var _emscripten_bind_Status___destroy___0=Module["_emscripten_bind_Status___destroy___0"]=function(){return Module["asm"]["emscripten_bind_Status___destroy___0"].apply(null,arguments)};var _emscripten_bind_DracoUInt16Array_DracoUInt16Array_0=Module["_emscripten_bind_DracoUInt16Array_DracoUInt16Array_0"]=function(){return Module["asm"]["emscripten_bind_DracoUInt16Array_DracoUInt16Array_0"].apply(null,arguments)};var _emscripten_bind_DracoUInt16Array_GetValue_1=Module["_emscripten_bind_DracoUInt16Array_GetValue_1"]=function(){return Module["asm"]["emscripten_bind_DracoUInt16Array_GetValue_1"].apply(null,arguments)};var _emscripten_bind_DracoUInt16Array_size_0=Module["_emscripten_bind_DracoUInt16Array_size_0"]=function(){return Module["asm"]["emscripten_bind_DracoUInt16Array_size_0"].apply(null,arguments)};var _emscripten_bind_DracoUInt16Array___destroy___0=Module["_emscripten_bind_DracoUInt16Array___destroy___0"]=function(){return Module["asm"]["emscripten_bind_DracoUInt16Array___destroy___0"].apply(null,arguments)};var _emscripten_bind_PointCloud_PointCloud_0=Module["_emscripten_bind_PointCloud_PointCloud_0"]=function(){return Module["asm"]["emscripten_bind_PointCloud_PointCloud_0"].apply(null,arguments)};var _emscripten_bind_PointCloud_num_attributes_0=Module["_emscripten_bind_PointCloud_num_attributes_0"]=function(){return Module["asm"]["emscripten_bind_PointCloud_num_attributes_0"].apply(null,arguments)};var _emscripten_bind_PointCloud_num_points_0=Module["_emscripten_bind_PointCloud_num_points_0"]=function(){return Module["asm"]["emscripten_bind_PointCloud_num_points_0"].apply(null,arguments)};var _emscripten_bind_PointCloud___destroy___0=Module["_emscripten_bind_PointCloud___destroy___0"]=function(){return Module["asm"]["emscripten_bind_PointCloud___destroy___0"].apply(null,arguments)};var _emscripten_bind_DracoUInt8Array_DracoUInt8Array_0=Module["_emscripten_bind_DracoUInt8Array_DracoUInt8Array_0"]=function(){return Module["asm"]["emscripten_bind_DracoUInt8Array_DracoUInt8Array_0"].apply(null,arguments)};var _emscripten_bind_DracoUInt8Array_GetValue_1=Module["_emscripten_bind_DracoUInt8Array_GetValue_1"]=function(){return Module["asm"]["emscripten_bind_DracoUInt8Array_GetValue_1"].apply(null,arguments)};var _emscripten_bind_DracoUInt8Array_size_0=Module["_emscripten_bind_DracoUInt8Array_size_0"]=function(){return Module["asm"]["emscripten_bind_DracoUInt8Array_size_0"].apply(null,arguments)};var _emscripten_bind_DracoUInt8Array___destroy___0=Module["_emscripten_bind_DracoUInt8Array___destroy___0"]=function(){return Module["asm"]["emscripten_bind_DracoUInt8Array___destroy___0"].apply(null,arguments)};var _emscripten_bind_DracoUInt32Array_DracoUInt32Array_0=Module["_emscripten_bind_DracoUInt32Array_DracoUInt32Array_0"]=function(){return Module["asm"]["emscripten_bind_DracoUInt32Array_DracoUInt32Array_0"].apply(null,arguments)};var _emscripten_bind_DracoUInt32Array_GetValue_1=Module["_emscripten_bind_DracoUInt32Array_GetValue_1"]=function(){return Module["asm"]["emscripten_bind_DracoUInt32Array_GetValue_1"].apply(null,arguments)};var _emscripten_bind_DracoUInt32Array_size_0=Module["_emscripten_bind_DracoUInt32Array_size_0"]=function(){return Module["asm"]["emscripten_bind_DracoUInt32Array_size_0"].apply(null,arguments)};var _emscripten_bind_DracoUInt32Array___destroy___0=Module["_emscripten_bind_DracoUInt32Array___destroy___0"]=function(){return Module["asm"]["emscripten_bind_DracoUInt32Array___destroy___0"].apply(null,arguments)};var _emscripten_bind_AttributeOctahedronTransform_AttributeOctahedronTransform_0=Module["_emscripten_bind_AttributeOctahedronTransform_AttributeOctahedronTransform_0"]=function(){return Module["asm"]["emscripten_bind_AttributeOctahedronTransform_AttributeOctahedronTransform_0"].apply(null,arguments)};var _emscripten_bind_AttributeOctahedronTransform_InitFromAttribute_1=Module["_emscripten_bind_AttributeOctahedronTransform_InitFromAttribute_1"]=function(){return Module["asm"]["emscripten_bind_AttributeOctahedronTransform_InitFromAttribute_1"].apply(null,arguments)};var _emscripten_bind_AttributeOctahedronTransform_quantization_bits_0=Module["_emscripten_bind_AttributeOctahedronTransform_quantization_bits_0"]=function(){return Module["asm"]["emscripten_bind_AttributeOctahedronTransform_quantization_bits_0"].apply(null,arguments)};var _emscripten_bind_AttributeOctahedronTransform___destroy___0=Module["_emscripten_bind_AttributeOctahedronTransform___destroy___0"]=function(){return Module["asm"]["emscripten_bind_AttributeOctahedronTransform___destroy___0"].apply(null,arguments)};var _emscripten_bind_PointAttribute_PointAttribute_0=Module["_emscripten_bind_PointAttribute_PointAttribute_0"]=function(){return Module["asm"]["emscripten_bind_PointAttribute_PointAttribute_0"].apply(null,arguments)};var _emscripten_bind_PointAttribute_size_0=Module["_emscripten_bind_PointAttribute_size_0"]=function(){return Module["asm"]["emscripten_bind_PointAttribute_size_0"].apply(null,arguments)};var _emscripten_bind_PointAttribute_GetAttributeTransformData_0=Module["_emscripten_bind_PointAttribute_GetAttributeTransformData_0"]=function(){return Module["asm"]["emscripten_bind_PointAttribute_GetAttributeTransformData_0"].apply(null,arguments)};var _emscripten_bind_PointAttribute_attribute_type_0=Module["_emscripten_bind_PointAttribute_attribute_type_0"]=function(){return Module["asm"]["emscripten_bind_PointAttribute_attribute_type_0"].apply(null,arguments)};var _emscripten_bind_PointAttribute_data_type_0=Module["_emscripten_bind_PointAttribute_data_type_0"]=function(){return Module["asm"]["emscripten_bind_PointAttribute_data_type_0"].apply(null,arguments)};var _emscripten_bind_PointAttribute_num_components_0=Module["_emscripten_bind_PointAttribute_num_components_0"]=function(){return Module["asm"]["emscripten_bind_PointAttribute_num_components_0"].apply(null,arguments)};var _emscripten_bind_PointAttribute_normalized_0=Module["_emscripten_bind_PointAttribute_normalized_0"]=function(){return Module["asm"]["emscripten_bind_PointAttribute_normalized_0"].apply(null,arguments)};var _emscripten_bind_PointAttribute_byte_stride_0=Module["_emscripten_bind_PointAttribute_byte_stride_0"]=function(){return Module["asm"]["emscripten_bind_PointAttribute_byte_stride_0"].apply(null,arguments)};var _emscripten_bind_PointAttribute_byte_offset_0=Module["_emscripten_bind_PointAttribute_byte_offset_0"]=function(){return Module["asm"]["emscripten_bind_PointAttribute_byte_offset_0"].apply(null,arguments)};var _emscripten_bind_PointAttribute_unique_id_0=Module["_emscripten_bind_PointAttribute_unique_id_0"]=function(){return Module["asm"]["emscripten_bind_PointAttribute_unique_id_0"].apply(null,arguments)};var _emscripten_bind_PointAttribute___destroy___0=Module["_emscripten_bind_PointAttribute___destroy___0"]=function(){return Module["asm"]["emscripten_bind_PointAttribute___destroy___0"].apply(null,arguments)};var _emscripten_bind_AttributeTransformData_AttributeTransformData_0=Module["_emscripten_bind_AttributeTransformData_AttributeTransformData_0"]=function(){return Module["asm"]["emscripten_bind_AttributeTransformData_AttributeTransformData_0"].apply(null,arguments)};var _emscripten_bind_AttributeTransformData_transform_type_0=Module["_emscripten_bind_AttributeTransformData_transform_type_0"]=function(){return Module["asm"]["emscripten_bind_AttributeTransformData_transform_type_0"].apply(null,arguments)};var _emscripten_bind_AttributeTransformData___destroy___0=Module["_emscripten_bind_AttributeTransformData___destroy___0"]=function(){return Module["asm"]["emscripten_bind_AttributeTransformData___destroy___0"].apply(null,arguments)};var _emscripten_bind_AttributeQuantizationTransform_AttributeQuantizationTransform_0=Module["_emscripten_bind_AttributeQuantizationTransform_AttributeQuantizationTransform_0"]=function(){return Module["asm"]["emscripten_bind_AttributeQuantizationTransform_AttributeQuantizationTransform_0"].apply(null,arguments)};var _emscripten_bind_AttributeQuantizationTransform_InitFromAttribute_1=Module["_emscripten_bind_AttributeQuantizationTransform_InitFromAttribute_1"]=function(){return Module["asm"]["emscripten_bind_AttributeQuantizationTransform_InitFromAttribute_1"].apply(null,arguments)};var _emscripten_bind_AttributeQuantizationTransform_quantization_bits_0=Module["_emscripten_bind_AttributeQuantizationTransform_quantization_bits_0"]=function(){return Module["asm"]["emscripten_bind_AttributeQuantizationTransform_quantization_bits_0"].apply(null,arguments)};var _emscripten_bind_AttributeQuantizationTransform_min_value_1=Module["_emscripten_bind_AttributeQuantizationTransform_min_value_1"]=function(){return Module["asm"]["emscripten_bind_AttributeQuantizationTransform_min_value_1"].apply(null,arguments)};var _emscripten_bind_AttributeQuantizationTransform_range_0=Module["_emscripten_bind_AttributeQuantizationTransform_range_0"]=function(){return Module["asm"]["emscripten_bind_AttributeQuantizationTransform_range_0"].apply(null,arguments)};var _emscripten_bind_AttributeQuantizationTransform___destroy___0=Module["_emscripten_bind_AttributeQuantizationTransform___destroy___0"]=function(){return Module["asm"]["emscripten_bind_AttributeQuantizationTransform___destroy___0"].apply(null,arguments)};var _emscripten_bind_DracoInt8Array_DracoInt8Array_0=Module["_emscripten_bind_DracoInt8Array_DracoInt8Array_0"]=function(){return Module["asm"]["emscripten_bind_DracoInt8Array_DracoInt8Array_0"].apply(null,arguments)};var _emscripten_bind_DracoInt8Array_GetValue_1=Module["_emscripten_bind_DracoInt8Array_GetValue_1"]=function(){return Module["asm"]["emscripten_bind_DracoInt8Array_GetValue_1"].apply(null,arguments)};var _emscripten_bind_DracoInt8Array_size_0=Module["_emscripten_bind_DracoInt8Array_size_0"]=function(){return Module["asm"]["emscripten_bind_DracoInt8Array_size_0"].apply(null,arguments)};var _emscripten_bind_DracoInt8Array___destroy___0=Module["_emscripten_bind_DracoInt8Array___destroy___0"]=function(){return Module["asm"]["emscripten_bind_DracoInt8Array___destroy___0"].apply(null,arguments)};var _emscripten_bind_MetadataQuerier_MetadataQuerier_0=Module["_emscripten_bind_MetadataQuerier_MetadataQuerier_0"]=function(){return Module["asm"]["emscripten_bind_MetadataQuerier_MetadataQuerier_0"].apply(null,arguments)};var _emscripten_bind_MetadataQuerier_HasEntry_2=Module["_emscripten_bind_MetadataQuerier_HasEntry_2"]=function(){return Module["asm"]["emscripten_bind_MetadataQuerier_HasEntry_2"].apply(null,arguments)};var _emscripten_bind_MetadataQuerier_GetIntEntry_2=Module["_emscripten_bind_MetadataQuerier_GetIntEntry_2"]=function(){return Module["asm"]["emscripten_bind_MetadataQuerier_GetIntEntry_2"].apply(null,arguments)};var _emscripten_bind_MetadataQuerier_GetIntEntryArray_3=Module["_emscripten_bind_MetadataQuerier_GetIntEntryArray_3"]=function(){return Module["asm"]["emscripten_bind_MetadataQuerier_GetIntEntryArray_3"].apply(null,arguments)};var _emscripten_bind_MetadataQuerier_GetDoubleEntry_2=Module["_emscripten_bind_MetadataQuerier_GetDoubleEntry_2"]=function(){return Module["asm"]["emscripten_bind_MetadataQuerier_GetDoubleEntry_2"].apply(null,arguments)};var _emscripten_bind_MetadataQuerier_GetStringEntry_2=Module["_emscripten_bind_MetadataQuerier_GetStringEntry_2"]=function(){return Module["asm"]["emscripten_bind_MetadataQuerier_GetStringEntry_2"].apply(null,arguments)};var _emscripten_bind_MetadataQuerier_NumEntries_1=Module["_emscripten_bind_MetadataQuerier_NumEntries_1"]=function(){return Module["asm"]["emscripten_bind_MetadataQuerier_NumEntries_1"].apply(null,arguments)};var _emscripten_bind_MetadataQuerier_GetEntryName_2=Module["_emscripten_bind_MetadataQuerier_GetEntryName_2"]=function(){return Module["asm"]["emscripten_bind_MetadataQuerier_GetEntryName_2"].apply(null,arguments)};var _emscripten_bind_MetadataQuerier___destroy___0=Module["_emscripten_bind_MetadataQuerier___destroy___0"]=function(){return Module["asm"]["emscripten_bind_MetadataQuerier___destroy___0"].apply(null,arguments)};var _emscripten_bind_DracoInt16Array_DracoInt16Array_0=Module["_emscripten_bind_DracoInt16Array_DracoInt16Array_0"]=function(){return Module["asm"]["emscripten_bind_DracoInt16Array_DracoInt16Array_0"].apply(null,arguments)};var _emscripten_bind_DracoInt16Array_GetValue_1=Module["_emscripten_bind_DracoInt16Array_GetValue_1"]=function(){return Module["asm"]["emscripten_bind_DracoInt16Array_GetValue_1"].apply(null,arguments)};var _emscripten_bind_DracoInt16Array_size_0=Module["_emscripten_bind_DracoInt16Array_size_0"]=function(){return Module["asm"]["emscripten_bind_DracoInt16Array_size_0"].apply(null,arguments)};var _emscripten_bind_DracoInt16Array___destroy___0=Module["_emscripten_bind_DracoInt16Array___destroy___0"]=function(){return Module["asm"]["emscripten_bind_DracoInt16Array___destroy___0"].apply(null,arguments)};var _emscripten_bind_DracoFloat32Array_DracoFloat32Array_0=Module["_emscripten_bind_DracoFloat32Array_DracoFloat32Array_0"]=function(){return Module["asm"]["emscripten_bind_DracoFloat32Array_DracoFloat32Array_0"].apply(null,arguments)};var _emscripten_bind_DracoFloat32Array_GetValue_1=Module["_emscripten_bind_DracoFloat32Array_GetValue_1"]=function(){return Module["asm"]["emscripten_bind_DracoFloat32Array_GetValue_1"].apply(null,arguments)};var _emscripten_bind_DracoFloat32Array_size_0=Module["_emscripten_bind_DracoFloat32Array_size_0"]=function(){return Module["asm"]["emscripten_bind_DracoFloat32Array_size_0"].apply(null,arguments)};var _emscripten_bind_DracoFloat32Array___destroy___0=Module["_emscripten_bind_DracoFloat32Array___destroy___0"]=function(){return Module["asm"]["emscripten_bind_DracoFloat32Array___destroy___0"].apply(null,arguments)};var _emscripten_bind_GeometryAttribute_GeometryAttribute_0=Module["_emscripten_bind_GeometryAttribute_GeometryAttribute_0"]=function(){return Module["asm"]["emscripten_bind_GeometryAttribute_GeometryAttribute_0"].apply(null,arguments)};var _emscripten_bind_GeometryAttribute___destroy___0=Module["_emscripten_bind_GeometryAttribute___destroy___0"]=function(){return Module["asm"]["emscripten_bind_GeometryAttribute___destroy___0"].apply(null,arguments)};var _emscripten_bind_DecoderBuffer_DecoderBuffer_0=Module["_emscripten_bind_DecoderBuffer_DecoderBuffer_0"]=function(){return Module["asm"]["emscripten_bind_DecoderBuffer_DecoderBuffer_0"].apply(null,arguments)};var _emscripten_bind_DecoderBuffer_Init_2=Module["_emscripten_bind_DecoderBuffer_Init_2"]=function(){return Module["asm"]["emscripten_bind_DecoderBuffer_Init_2"].apply(null,arguments)};var _emscripten_bind_DecoderBuffer___destroy___0=Module["_emscripten_bind_DecoderBuffer___destroy___0"]=function(){return Module["asm"]["emscripten_bind_DecoderBuffer___destroy___0"].apply(null,arguments)};var _emscripten_bind_Decoder_Decoder_0=Module["_emscripten_bind_Decoder_Decoder_0"]=function(){return Module["asm"]["emscripten_bind_Decoder_Decoder_0"].apply(null,arguments)};var _emscripten_bind_Decoder_GetEncodedGeometryType_1=Module["_emscripten_bind_Decoder_GetEncodedGeometryType_1"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetEncodedGeometryType_1"].apply(null,arguments)};var _emscripten_bind_Decoder_DecodeBufferToPointCloud_2=Module["_emscripten_bind_Decoder_DecodeBufferToPointCloud_2"]=function(){return Module["asm"]["emscripten_bind_Decoder_DecodeBufferToPointCloud_2"].apply(null,arguments)};var _emscripten_bind_Decoder_DecodeBufferToMesh_2=Module["_emscripten_bind_Decoder_DecodeBufferToMesh_2"]=function(){return Module["asm"]["emscripten_bind_Decoder_DecodeBufferToMesh_2"].apply(null,arguments)};var _emscripten_bind_Decoder_GetAttributeId_2=Module["_emscripten_bind_Decoder_GetAttributeId_2"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetAttributeId_2"].apply(null,arguments)};var _emscripten_bind_Decoder_GetAttributeIdByName_2=Module["_emscripten_bind_Decoder_GetAttributeIdByName_2"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetAttributeIdByName_2"].apply(null,arguments)};var _emscripten_bind_Decoder_GetAttributeIdByMetadataEntry_3=Module["_emscripten_bind_Decoder_GetAttributeIdByMetadataEntry_3"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetAttributeIdByMetadataEntry_3"].apply(null,arguments)};var _emscripten_bind_Decoder_GetAttribute_2=Module["_emscripten_bind_Decoder_GetAttribute_2"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetAttribute_2"].apply(null,arguments)};var _emscripten_bind_Decoder_GetAttributeByUniqueId_2=Module["_emscripten_bind_Decoder_GetAttributeByUniqueId_2"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetAttributeByUniqueId_2"].apply(null,arguments)};var _emscripten_bind_Decoder_GetMetadata_1=Module["_emscripten_bind_Decoder_GetMetadata_1"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetMetadata_1"].apply(null,arguments)};var _emscripten_bind_Decoder_GetAttributeMetadata_2=Module["_emscripten_bind_Decoder_GetAttributeMetadata_2"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetAttributeMetadata_2"].apply(null,arguments)};var _emscripten_bind_Decoder_GetFaceFromMesh_3=Module["_emscripten_bind_Decoder_GetFaceFromMesh_3"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetFaceFromMesh_3"].apply(null,arguments)};var _emscripten_bind_Decoder_GetTriangleStripsFromMesh_2=Module["_emscripten_bind_Decoder_GetTriangleStripsFromMesh_2"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetTriangleStripsFromMesh_2"].apply(null,arguments)};var _emscripten_bind_Decoder_GetTrianglesUInt16Array_3=Module["_emscripten_bind_Decoder_GetTrianglesUInt16Array_3"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetTrianglesUInt16Array_3"].apply(null,arguments)};var _emscripten_bind_Decoder_GetTrianglesUInt32Array_3=Module["_emscripten_bind_Decoder_GetTrianglesUInt32Array_3"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetTrianglesUInt32Array_3"].apply(null,arguments)};var _emscripten_bind_Decoder_GetAttributeFloat_3=Module["_emscripten_bind_Decoder_GetAttributeFloat_3"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetAttributeFloat_3"].apply(null,arguments)};var _emscripten_bind_Decoder_GetAttributeFloatForAllPoints_3=Module["_emscripten_bind_Decoder_GetAttributeFloatForAllPoints_3"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetAttributeFloatForAllPoints_3"].apply(null,arguments)};var _emscripten_bind_Decoder_GetAttributeIntForAllPoints_3=Module["_emscripten_bind_Decoder_GetAttributeIntForAllPoints_3"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetAttributeIntForAllPoints_3"].apply(null,arguments)};var _emscripten_bind_Decoder_GetAttributeInt8ForAllPoints_3=Module["_emscripten_bind_Decoder_GetAttributeInt8ForAllPoints_3"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetAttributeInt8ForAllPoints_3"].apply(null,arguments)};var _emscripten_bind_Decoder_GetAttributeUInt8ForAllPoints_3=Module["_emscripten_bind_Decoder_GetAttributeUInt8ForAllPoints_3"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetAttributeUInt8ForAllPoints_3"].apply(null,arguments)};var _emscripten_bind_Decoder_GetAttributeInt16ForAllPoints_3=Module["_emscripten_bind_Decoder_GetAttributeInt16ForAllPoints_3"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetAttributeInt16ForAllPoints_3"].apply(null,arguments)};var _emscripten_bind_Decoder_GetAttributeUInt16ForAllPoints_3=Module["_emscripten_bind_Decoder_GetAttributeUInt16ForAllPoints_3"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetAttributeUInt16ForAllPoints_3"].apply(null,arguments)};var _emscripten_bind_Decoder_GetAttributeInt32ForAllPoints_3=Module["_emscripten_bind_Decoder_GetAttributeInt32ForAllPoints_3"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetAttributeInt32ForAllPoints_3"].apply(null,arguments)};var _emscripten_bind_Decoder_GetAttributeUInt32ForAllPoints_3=Module["_emscripten_bind_Decoder_GetAttributeUInt32ForAllPoints_3"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetAttributeUInt32ForAllPoints_3"].apply(null,arguments)};var _emscripten_bind_Decoder_GetAttributeDataArrayForAllPoints_5=Module["_emscripten_bind_Decoder_GetAttributeDataArrayForAllPoints_5"]=function(){return Module["asm"]["emscripten_bind_Decoder_GetAttributeDataArrayForAllPoints_5"].apply(null,arguments)};var _emscripten_bind_Decoder_SkipAttributeTransform_1=Module["_emscripten_bind_Decoder_SkipAttributeTransform_1"]=function(){return Module["asm"]["emscripten_bind_Decoder_SkipAttributeTransform_1"].apply(null,arguments)};var _emscripten_bind_Decoder___destroy___0=Module["_emscripten_bind_Decoder___destroy___0"]=function(){return Module["asm"]["emscripten_bind_Decoder___destroy___0"].apply(null,arguments)};var _emscripten_bind_Mesh_Mesh_0=Module["_emscripten_bind_Mesh_Mesh_0"]=function(){return Module["asm"]["emscripten_bind_Mesh_Mesh_0"].apply(null,arguments)};var _emscripten_bind_Mesh_num_faces_0=Module["_emscripten_bind_Mesh_num_faces_0"]=function(){return Module["asm"]["emscripten_bind_Mesh_num_faces_0"].apply(null,arguments)};var _emscripten_bind_Mesh_num_attributes_0=Module["_emscripten_bind_Mesh_num_attributes_0"]=function(){return Module["asm"]["emscripten_bind_Mesh_num_attributes_0"].apply(null,arguments)};var _emscripten_bind_Mesh_num_points_0=Module["_emscripten_bind_Mesh_num_points_0"]=function(){return Module["asm"]["emscripten_bind_Mesh_num_points_0"].apply(null,arguments)};var _emscripten_bind_Mesh___destroy___0=Module["_emscripten_bind_Mesh___destroy___0"]=function(){return Module["asm"]["emscripten_bind_Mesh___destroy___0"].apply(null,arguments)};var _emscripten_bind_VoidPtr___destroy___0=Module["_emscripten_bind_VoidPtr___destroy___0"]=function(){return Module["asm"]["emscripten_bind_VoidPtr___destroy___0"].apply(null,arguments)};var _emscripten_bind_DracoInt32Array_DracoInt32Array_0=Module["_emscripten_bind_DracoInt32Array_DracoInt32Array_0"]=function(){return Module["asm"]["emscripten_bind_DracoInt32Array_DracoInt32Array_0"].apply(null,arguments)};var _emscripten_bind_DracoInt32Array_GetValue_1=Module["_emscripten_bind_DracoInt32Array_GetValue_1"]=function(){return Module["asm"]["emscripten_bind_DracoInt32Array_GetValue_1"].apply(null,arguments)};var _emscripten_bind_DracoInt32Array_size_0=Module["_emscripten_bind_DracoInt32Array_size_0"]=function(){return Module["asm"]["emscripten_bind_DracoInt32Array_size_0"].apply(null,arguments)};var _emscripten_bind_DracoInt32Array___destroy___0=Module["_emscripten_bind_DracoInt32Array___destroy___0"]=function(){return Module["asm"]["emscripten_bind_DracoInt32Array___destroy___0"].apply(null,arguments)};var _emscripten_bind_Metadata_Metadata_0=Module["_emscripten_bind_Metadata_Metadata_0"]=function(){return Module["asm"]["emscripten_bind_Metadata_Metadata_0"].apply(null,arguments)};var _emscripten_bind_Metadata___destroy___0=Module["_emscripten_bind_Metadata___destroy___0"]=function(){return Module["asm"]["emscripten_bind_Metadata___destroy___0"].apply(null,arguments)};var _emscripten_enum_draco_StatusCode_OK=Module["_emscripten_enum_draco_StatusCode_OK"]=function(){return Module["asm"]["emscripten_enum_draco_StatusCode_OK"].apply(null,arguments)};var _emscripten_enum_draco_StatusCode_DRACO_ERROR=Module["_emscripten_enum_draco_StatusCode_DRACO_ERROR"]=function(){return Module["asm"]["emscripten_enum_draco_StatusCode_DRACO_ERROR"].apply(null,arguments)};var _emscripten_enum_draco_StatusCode_IO_ERROR=Module["_emscripten_enum_draco_StatusCode_IO_ERROR"]=function(){return Module["asm"]["emscripten_enum_draco_StatusCode_IO_ERROR"].apply(null,arguments)};var _emscripten_enum_draco_StatusCode_INVALID_PARAMETER=Module["_emscripten_enum_draco_StatusCode_INVALID_PARAMETER"]=function(){return Module["asm"]["emscripten_enum_draco_StatusCode_INVALID_PARAMETER"].apply(null,arguments)};var _emscripten_enum_draco_StatusCode_UNSUPPORTED_VERSION=Module["_emscripten_enum_draco_StatusCode_UNSUPPORTED_VERSION"]=function(){return Module["asm"]["emscripten_enum_draco_StatusCode_UNSUPPORTED_VERSION"].apply(null,arguments)};var _emscripten_enum_draco_StatusCode_UNKNOWN_VERSION=Module["_emscripten_enum_draco_StatusCode_UNKNOWN_VERSION"]=function(){return Module["asm"]["emscripten_enum_draco_StatusCode_UNKNOWN_VERSION"].apply(null,arguments)};var _emscripten_enum_draco_DataType_DT_INVALID=Module["_emscripten_enum_draco_DataType_DT_INVALID"]=function(){return Module["asm"]["emscripten_enum_draco_DataType_DT_INVALID"].apply(null,arguments)};var _emscripten_enum_draco_DataType_DT_INT8=Module["_emscripten_enum_draco_DataType_DT_INT8"]=function(){return Module["asm"]["emscripten_enum_draco_DataType_DT_INT8"].apply(null,arguments)};var _emscripten_enum_draco_DataType_DT_UINT8=Module["_emscripten_enum_draco_DataType_DT_UINT8"]=function(){return Module["asm"]["emscripten_enum_draco_DataType_DT_UINT8"].apply(null,arguments)};var _emscripten_enum_draco_DataType_DT_INT16=Module["_emscripten_enum_draco_DataType_DT_INT16"]=function(){return Module["asm"]["emscripten_enum_draco_DataType_DT_INT16"].apply(null,arguments)};var _emscripten_enum_draco_DataType_DT_UINT16=Module["_emscripten_enum_draco_DataType_DT_UINT16"]=function(){return Module["asm"]["emscripten_enum_draco_DataType_DT_UINT16"].apply(null,arguments)};var _emscripten_enum_draco_DataType_DT_INT32=Module["_emscripten_enum_draco_DataType_DT_INT32"]=function(){return Module["asm"]["emscripten_enum_draco_DataType_DT_INT32"].apply(null,arguments)};var _emscripten_enum_draco_DataType_DT_UINT32=Module["_emscripten_enum_draco_DataType_DT_UINT32"]=function(){return Module["asm"]["emscripten_enum_draco_DataType_DT_UINT32"].apply(null,arguments)};var _emscripten_enum_draco_DataType_DT_INT64=Module["_emscripten_enum_draco_DataType_DT_INT64"]=function(){return Module["asm"]["emscripten_enum_draco_DataType_DT_INT64"].apply(null,arguments)};var _emscripten_enum_draco_DataType_DT_UINT64=Module["_emscripten_enum_draco_DataType_DT_UINT64"]=function(){return Module["asm"]["emscripten_enum_draco_DataType_DT_UINT64"].apply(null,arguments)};var _emscripten_enum_draco_DataType_DT_FLOAT32=Module["_emscripten_enum_draco_DataType_DT_FLOAT32"]=function(){return Module["asm"]["emscripten_enum_draco_DataType_DT_FLOAT32"].apply(null,arguments)};var _emscripten_enum_draco_DataType_DT_FLOAT64=Module["_emscripten_enum_draco_DataType_DT_FLOAT64"]=function(){return Module["asm"]["emscripten_enum_draco_DataType_DT_FLOAT64"].apply(null,arguments)};var _emscripten_enum_draco_DataType_DT_BOOL=Module["_emscripten_enum_draco_DataType_DT_BOOL"]=function(){return Module["asm"]["emscripten_enum_draco_DataType_DT_BOOL"].apply(null,arguments)};var _emscripten_enum_draco_DataType_DT_TYPES_COUNT=Module["_emscripten_enum_draco_DataType_DT_TYPES_COUNT"]=function(){return Module["asm"]["emscripten_enum_draco_DataType_DT_TYPES_COUNT"].apply(null,arguments)};var _emscripten_enum_draco_EncodedGeometryType_INVALID_GEOMETRY_TYPE=Module["_emscripten_enum_draco_EncodedGeometryType_INVALID_GEOMETRY_TYPE"]=function(){return Module["asm"]["emscripten_enum_draco_EncodedGeometryType_INVALID_GEOMETRY_TYPE"].apply(null,arguments)};var _emscripten_enum_draco_EncodedGeometryType_POINT_CLOUD=Module["_emscripten_enum_draco_EncodedGeometryType_POINT_CLOUD"]=function(){return Module["asm"]["emscripten_enum_draco_EncodedGeometryType_POINT_CLOUD"].apply(null,arguments)};var _emscripten_enum_draco_EncodedGeometryType_TRIANGULAR_MESH=Module["_emscripten_enum_draco_EncodedGeometryType_TRIANGULAR_MESH"]=function(){return Module["asm"]["emscripten_enum_draco_EncodedGeometryType_TRIANGULAR_MESH"].apply(null,arguments)};var _emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_INVALID_TRANSFORM=Module["_emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_INVALID_TRANSFORM"]=function(){return Module["asm"]["emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_INVALID_TRANSFORM"].apply(null,arguments)};var _emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_NO_TRANSFORM=Module["_emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_NO_TRANSFORM"]=function(){return Module["asm"]["emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_NO_TRANSFORM"].apply(null,arguments)};var _emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_QUANTIZATION_TRANSFORM=Module["_emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_QUANTIZATION_TRANSFORM"]=function(){return Module["asm"]["emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_QUANTIZATION_TRANSFORM"].apply(null,arguments)};var _emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_OCTAHEDRON_TRANSFORM=Module["_emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_OCTAHEDRON_TRANSFORM"]=function(){return Module["asm"]["emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_OCTAHEDRON_TRANSFORM"].apply(null,arguments)};var _emscripten_enum_draco_GeometryAttribute_Type_INVALID=Module["_emscripten_enum_draco_GeometryAttribute_Type_INVALID"]=function(){return Module["asm"]["emscripten_enum_draco_GeometryAttribute_Type_INVALID"].apply(null,arguments)};var _emscripten_enum_draco_GeometryAttribute_Type_POSITION=Module["_emscripten_enum_draco_GeometryAttribute_Type_POSITION"]=function(){return Module["asm"]["emscripten_enum_draco_GeometryAttribute_Type_POSITION"].apply(null,arguments)};var _emscripten_enum_draco_GeometryAttribute_Type_NORMAL=Module["_emscripten_enum_draco_GeometryAttribute_Type_NORMAL"]=function(){return Module["asm"]["emscripten_enum_draco_GeometryAttribute_Type_NORMAL"].apply(null,arguments)};var _emscripten_enum_draco_GeometryAttribute_Type_COLOR=Module["_emscripten_enum_draco_GeometryAttribute_Type_COLOR"]=function(){return Module["asm"]["emscripten_enum_draco_GeometryAttribute_Type_COLOR"].apply(null,arguments)};var _emscripten_enum_draco_GeometryAttribute_Type_TEX_COORD=Module["_emscripten_enum_draco_GeometryAttribute_Type_TEX_COORD"]=function(){return Module["asm"]["emscripten_enum_draco_GeometryAttribute_Type_TEX_COORD"].apply(null,arguments)};var _emscripten_enum_draco_GeometryAttribute_Type_GENERIC=Module["_emscripten_enum_draco_GeometryAttribute_Type_GENERIC"]=function(){return Module["asm"]["emscripten_enum_draco_GeometryAttribute_Type_GENERIC"].apply(null,arguments)};var _setThrew=Module["_setThrew"]=function(){return Module["asm"]["setThrew"].apply(null,arguments)};var __ZSt18uncaught_exceptionv=Module["__ZSt18uncaught_exceptionv"]=function(){return Module["asm"]["_ZSt18uncaught_exceptionv"].apply(null,arguments)};var _free=Module["_free"]=function(){return Module["asm"]["free"].apply(null,arguments)};var _malloc=Module["_malloc"]=function(){return Module["asm"]["malloc"].apply(null,arguments)};var stackSave=Module["stackSave"]=function(){return Module["asm"]["stackSave"].apply(null,arguments)};var stackAlloc=Module["stackAlloc"]=function(){return Module["asm"]["stackAlloc"].apply(null,arguments)};var stackRestore=Module["stackRestore"]=function(){return Module["asm"]["stackRestore"].apply(null,arguments)};var __growWasmMemory=Module["__growWasmMemory"]=function(){return Module["asm"]["__growWasmMemory"].apply(null,arguments)};var dynCall_ii=Module["dynCall_ii"]=function(){return Module["asm"]["dynCall_ii"].apply(null,arguments)};var dynCall_vi=Module["dynCall_vi"]=function(){return Module["asm"]["dynCall_vi"].apply(null,arguments)};var dynCall_iii=Module["dynCall_iii"]=function(){return Module["asm"]["dynCall_iii"].apply(null,arguments)};var dynCall_vii=Module["dynCall_vii"]=function(){return Module["asm"]["dynCall_vii"].apply(null,arguments)};var dynCall_iiii=Module["dynCall_iiii"]=function(){return Module["asm"]["dynCall_iiii"].apply(null,arguments)};var dynCall_v=Module["dynCall_v"]=function(){return Module["asm"]["dynCall_v"].apply(null,arguments)};var dynCall_viii=Module["dynCall_viii"]=function(){return Module["asm"]["dynCall_viii"].apply(null,arguments)};var dynCall_viiii=Module["dynCall_viiii"]=function(){return Module["asm"]["dynCall_viiii"].apply(null,arguments)};var dynCall_iiiiiii=Module["dynCall_iiiiiii"]=function(){return Module["asm"]["dynCall_iiiiiii"].apply(null,arguments)};var dynCall_iidiiii=Module["dynCall_iidiiii"]=function(){return Module["asm"]["dynCall_iidiiii"].apply(null,arguments)};var dynCall_jiji=Module["dynCall_jiji"]=function(){return Module["asm"]["dynCall_jiji"].apply(null,arguments)};var dynCall_viiiiii=Module["dynCall_viiiiii"]=function(){return Module["asm"]["dynCall_viiiiii"].apply(null,arguments)};var dynCall_viiiii=Module["dynCall_viiiii"]=function(){return Module["asm"]["dynCall_viiiii"].apply(null,arguments)};Module["asm"]=asm;var calledRun;Module["then"]=function(func){if(calledRun){func(Module)}else{var old=Module["onRuntimeInitialized"];Module["onRuntimeInitialized"]=function(){if(old)old();func(Module)}}return Module};function ExitStatus(status){this.name="ExitStatus";this.message="Program terminated with exit("+status+")";this.status=status}dependenciesFulfilled=function runCaller(){if(!calledRun)run();if(!calledRun)dependenciesFulfilled=runCaller};function run(args){args=args||arguments_;if(runDependencies>0){return}preRun();if(runDependencies>0)return;function doRun(){if(calledRun)return;calledRun=true;if(ABORT)return;initRuntime();preMain();if(Module["onRuntimeInitialized"])Module["onRuntimeInitialized"]();postRun()}if(Module["setStatus"]){Module["setStatus"]("Running...");setTimeout(function(){setTimeout(function(){Module["setStatus"]("")},1);doRun()},1)}else{doRun()}}Module["run"]=run;if(Module["preInit"]){if(typeof Module["preInit"]=="function")Module["preInit"]=[Module["preInit"]];while(Module["preInit"].length>0){Module["preInit"].pop()()}}noExitRuntime=true;run();function WrapperObject(){}WrapperObject.prototype=Object.create(WrapperObject.prototype);WrapperObject.prototype.constructor=WrapperObject;WrapperObject.prototype.__class__=WrapperObject;WrapperObject.__cache__={};Module["WrapperObject"]=WrapperObject;function getCache(__class__){return(__class__||WrapperObject).__cache__}Module["getCache"]=getCache;function wrapPointer(ptr,__class__){var cache=getCache(__class__);var ret=cache[ptr];if(ret)return ret;ret=Object.create((__class__||WrapperObject).prototype);ret.ptr=ptr;return cache[ptr]=ret}Module["wrapPointer"]=wrapPointer;function castObject(obj,__class__){return wrapPointer(obj.ptr,__class__)}Module["castObject"]=castObject;Module["NULL"]=wrapPointer(0);function destroy(obj){if(!obj["__destroy__"])throw"Error: Cannot destroy object. (Did you create it yourself?)";obj["__destroy__"]();delete getCache(obj.__class__)[obj.ptr]}Module["destroy"]=destroy;function compare(obj1,obj2){return obj1.ptr===obj2.ptr}Module["compare"]=compare;function getPointer(obj){return obj.ptr}Module["getPointer"]=getPointer;function getClass(obj){return obj.__class__}Module["getClass"]=getClass;var ensureCache={buffer:0,size:0,pos:0,temps:[],needed:0,prepare:function(){if(ensureCache.needed){for(var i=0;i<ensureCache.temps.length;i++){Module["_free"](ensureCache.temps[i])}ensureCache.temps.length=0;Module["_free"](ensureCache.buffer);ensureCache.buffer=0;ensureCache.size+=ensureCache.needed;ensureCache.needed=0}if(!ensureCache.buffer){ensureCache.size+=128;ensureCache.buffer=Module["_malloc"](ensureCache.size);assert(ensureCache.buffer)}ensureCache.pos=0},alloc:function(array,view){assert(ensureCache.buffer);var bytes=view.BYTES_PER_ELEMENT;var len=array.length*bytes;len=len+7&-8;var ret;if(ensureCache.pos+len>=ensureCache.size){assert(len>0);ensureCache.needed+=len;ret=Module["_malloc"](len);ensureCache.temps.push(ret)}else{ret=ensureCache.buffer+ensureCache.pos;ensureCache.pos+=len}return ret},copy:function(array,view,offset){var offsetShifted=offset;var bytes=view.BYTES_PER_ELEMENT;switch(bytes){case 2:offsetShifted>>=1;break;case 4:offsetShifted>>=2;break;case 8:offsetShifted>>=3;break}for(var i=0;i<array.length;i++){view[offsetShifted+i]=array[i]}}};function ensureString(value){if(typeof value==="string"){var intArray=intArrayFromString(value);var offset=ensureCache.alloc(intArray,HEAP8);ensureCache.copy(intArray,HEAP8,offset);return offset}return value}function ensureInt8(value){if(typeof value==="object"){var offset=ensureCache.alloc(value,HEAP8);ensureCache.copy(value,HEAP8,offset);return offset}return value}function Status(){throw"cannot construct a Status, no constructor in IDL"}Status.prototype=Object.create(WrapperObject.prototype);Status.prototype.constructor=Status;Status.prototype.__class__=Status;Status.__cache__={};Module["Status"]=Status;Status.prototype["code"]=Status.prototype.code=function(){var self=this.ptr;return _emscripten_bind_Status_code_0(self)};Status.prototype["ok"]=Status.prototype.ok=function(){var self=this.ptr;return!!_emscripten_bind_Status_ok_0(self)};Status.prototype["error_msg"]=Status.prototype.error_msg=function(){var self=this.ptr;return UTF8ToString(_emscripten_bind_Status_error_msg_0(self))};Status.prototype["__destroy__"]=Status.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_Status___destroy___0(self)};function DracoUInt16Array(){this.ptr=_emscripten_bind_DracoUInt16Array_DracoUInt16Array_0();getCache(DracoUInt16Array)[this.ptr]=this}DracoUInt16Array.prototype=Object.create(WrapperObject.prototype);DracoUInt16Array.prototype.constructor=DracoUInt16Array;DracoUInt16Array.prototype.__class__=DracoUInt16Array;DracoUInt16Array.__cache__={};Module["DracoUInt16Array"]=DracoUInt16Array;DracoUInt16Array.prototype["GetValue"]=DracoUInt16Array.prototype.GetValue=function(index){var self=this.ptr;if(index&&typeof index==="object")index=index.ptr;return _emscripten_bind_DracoUInt16Array_GetValue_1(self,index)};DracoUInt16Array.prototype["size"]=DracoUInt16Array.prototype.size=function(){var self=this.ptr;return _emscripten_bind_DracoUInt16Array_size_0(self)};DracoUInt16Array.prototype["__destroy__"]=DracoUInt16Array.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_DracoUInt16Array___destroy___0(self)};function PointCloud(){this.ptr=_emscripten_bind_PointCloud_PointCloud_0();getCache(PointCloud)[this.ptr]=this}PointCloud.prototype=Object.create(WrapperObject.prototype);PointCloud.prototype.constructor=PointCloud;PointCloud.prototype.__class__=PointCloud;PointCloud.__cache__={};Module["PointCloud"]=PointCloud;PointCloud.prototype["num_attributes"]=PointCloud.prototype.num_attributes=function(){var self=this.ptr;return _emscripten_bind_PointCloud_num_attributes_0(self)};PointCloud.prototype["num_points"]=PointCloud.prototype.num_points=function(){var self=this.ptr;return _emscripten_bind_PointCloud_num_points_0(self)};PointCloud.prototype["__destroy__"]=PointCloud.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_PointCloud___destroy___0(self)};function DracoUInt8Array(){this.ptr=_emscripten_bind_DracoUInt8Array_DracoUInt8Array_0();getCache(DracoUInt8Array)[this.ptr]=this}DracoUInt8Array.prototype=Object.create(WrapperObject.prototype);DracoUInt8Array.prototype.constructor=DracoUInt8Array;DracoUInt8Array.prototype.__class__=DracoUInt8Array;DracoUInt8Array.__cache__={};Module["DracoUInt8Array"]=DracoUInt8Array;DracoUInt8Array.prototype["GetValue"]=DracoUInt8Array.prototype.GetValue=function(index){var self=this.ptr;if(index&&typeof index==="object")index=index.ptr;return _emscripten_bind_DracoUInt8Array_GetValue_1(self,index)};DracoUInt8Array.prototype["size"]=DracoUInt8Array.prototype.size=function(){var self=this.ptr;return _emscripten_bind_DracoUInt8Array_size_0(self)};DracoUInt8Array.prototype["__destroy__"]=DracoUInt8Array.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_DracoUInt8Array___destroy___0(self)};function DracoUInt32Array(){this.ptr=_emscripten_bind_DracoUInt32Array_DracoUInt32Array_0();getCache(DracoUInt32Array)[this.ptr]=this}DracoUInt32Array.prototype=Object.create(WrapperObject.prototype);DracoUInt32Array.prototype.constructor=DracoUInt32Array;DracoUInt32Array.prototype.__class__=DracoUInt32Array;DracoUInt32Array.__cache__={};Module["DracoUInt32Array"]=DracoUInt32Array;DracoUInt32Array.prototype["GetValue"]=DracoUInt32Array.prototype.GetValue=function(index){var self=this.ptr;if(index&&typeof index==="object")index=index.ptr;return _emscripten_bind_DracoUInt32Array_GetValue_1(self,index)};DracoUInt32Array.prototype["size"]=DracoUInt32Array.prototype.size=function(){var self=this.ptr;return _emscripten_bind_DracoUInt32Array_size_0(self)};DracoUInt32Array.prototype["__destroy__"]=DracoUInt32Array.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_DracoUInt32Array___destroy___0(self)};function AttributeOctahedronTransform(){this.ptr=_emscripten_bind_AttributeOctahedronTransform_AttributeOctahedronTransform_0();getCache(AttributeOctahedronTransform)[this.ptr]=this}AttributeOctahedronTransform.prototype=Object.create(WrapperObject.prototype);AttributeOctahedronTransform.prototype.constructor=AttributeOctahedronTransform;AttributeOctahedronTransform.prototype.__class__=AttributeOctahedronTransform;AttributeOctahedronTransform.__cache__={};Module["AttributeOctahedronTransform"]=AttributeOctahedronTransform;AttributeOctahedronTransform.prototype["InitFromAttribute"]=AttributeOctahedronTransform.prototype.InitFromAttribute=function(att){var self=this.ptr;if(att&&typeof att==="object")att=att.ptr;return!!_emscripten_bind_AttributeOctahedronTransform_InitFromAttribute_1(self,att)};AttributeOctahedronTransform.prototype["quantization_bits"]=AttributeOctahedronTransform.prototype.quantization_bits=function(){var self=this.ptr;return _emscripten_bind_AttributeOctahedronTransform_quantization_bits_0(self)};AttributeOctahedronTransform.prototype["__destroy__"]=AttributeOctahedronTransform.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_AttributeOctahedronTransform___destroy___0(self)};function PointAttribute(){this.ptr=_emscripten_bind_PointAttribute_PointAttribute_0();getCache(PointAttribute)[this.ptr]=this}PointAttribute.prototype=Object.create(WrapperObject.prototype);PointAttribute.prototype.constructor=PointAttribute;PointAttribute.prototype.__class__=PointAttribute;PointAttribute.__cache__={};Module["PointAttribute"]=PointAttribute;PointAttribute.prototype["size"]=PointAttribute.prototype.size=function(){var self=this.ptr;return _emscripten_bind_PointAttribute_size_0(self)};PointAttribute.prototype["GetAttributeTransformData"]=PointAttribute.prototype.GetAttributeTransformData=function(){var self=this.ptr;return wrapPointer(_emscripten_bind_PointAttribute_GetAttributeTransformData_0(self),AttributeTransformData)};PointAttribute.prototype["attribute_type"]=PointAttribute.prototype.attribute_type=function(){var self=this.ptr;return _emscripten_bind_PointAttribute_attribute_type_0(self)};PointAttribute.prototype["data_type"]=PointAttribute.prototype.data_type=function(){var self=this.ptr;return _emscripten_bind_PointAttribute_data_type_0(self)};PointAttribute.prototype["num_components"]=PointAttribute.prototype.num_components=function(){var self=this.ptr;return _emscripten_bind_PointAttribute_num_components_0(self)};PointAttribute.prototype["normalized"]=PointAttribute.prototype.normalized=function(){var self=this.ptr;return!!_emscripten_bind_PointAttribute_normalized_0(self)};PointAttribute.prototype["byte_stride"]=PointAttribute.prototype.byte_stride=function(){var self=this.ptr;return _emscripten_bind_PointAttribute_byte_stride_0(self)};PointAttribute.prototype["byte_offset"]=PointAttribute.prototype.byte_offset=function(){var self=this.ptr;return _emscripten_bind_PointAttribute_byte_offset_0(self)};PointAttribute.prototype["unique_id"]=PointAttribute.prototype.unique_id=function(){var self=this.ptr;return _emscripten_bind_PointAttribute_unique_id_0(self)};PointAttribute.prototype["__destroy__"]=PointAttribute.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_PointAttribute___destroy___0(self)};function AttributeTransformData(){this.ptr=_emscripten_bind_AttributeTransformData_AttributeTransformData_0();getCache(AttributeTransformData)[this.ptr]=this}AttributeTransformData.prototype=Object.create(WrapperObject.prototype);AttributeTransformData.prototype.constructor=AttributeTransformData;AttributeTransformData.prototype.__class__=AttributeTransformData;AttributeTransformData.__cache__={};Module["AttributeTransformData"]=AttributeTransformData;AttributeTransformData.prototype["transform_type"]=AttributeTransformData.prototype.transform_type=function(){var self=this.ptr;return _emscripten_bind_AttributeTransformData_transform_type_0(self)};AttributeTransformData.prototype["__destroy__"]=AttributeTransformData.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_AttributeTransformData___destroy___0(self)};function AttributeQuantizationTransform(){this.ptr=_emscripten_bind_AttributeQuantizationTransform_AttributeQuantizationTransform_0();getCache(AttributeQuantizationTransform)[this.ptr]=this}AttributeQuantizationTransform.prototype=Object.create(WrapperObject.prototype);AttributeQuantizationTransform.prototype.constructor=AttributeQuantizationTransform;AttributeQuantizationTransform.prototype.__class__=AttributeQuantizationTransform;AttributeQuantizationTransform.__cache__={};Module["AttributeQuantizationTransform"]=AttributeQuantizationTransform;AttributeQuantizationTransform.prototype["InitFromAttribute"]=AttributeQuantizationTransform.prototype.InitFromAttribute=function(att){var self=this.ptr;if(att&&typeof att==="object")att=att.ptr;return!!_emscripten_bind_AttributeQuantizationTransform_InitFromAttribute_1(self,att)};AttributeQuantizationTransform.prototype["quantization_bits"]=AttributeQuantizationTransform.prototype.quantization_bits=function(){var self=this.ptr;return _emscripten_bind_AttributeQuantizationTransform_quantization_bits_0(self)};AttributeQuantizationTransform.prototype["min_value"]=AttributeQuantizationTransform.prototype.min_value=function(axis){var self=this.ptr;if(axis&&typeof axis==="object")axis=axis.ptr;return _emscripten_bind_AttributeQuantizationTransform_min_value_1(self,axis)};AttributeQuantizationTransform.prototype["range"]=AttributeQuantizationTransform.prototype.range=function(){var self=this.ptr;return _emscripten_bind_AttributeQuantizationTransform_range_0(self)};AttributeQuantizationTransform.prototype["__destroy__"]=AttributeQuantizationTransform.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_AttributeQuantizationTransform___destroy___0(self)};function DracoInt8Array(){this.ptr=_emscripten_bind_DracoInt8Array_DracoInt8Array_0();getCache(DracoInt8Array)[this.ptr]=this}DracoInt8Array.prototype=Object.create(WrapperObject.prototype);DracoInt8Array.prototype.constructor=DracoInt8Array;DracoInt8Array.prototype.__class__=DracoInt8Array;DracoInt8Array.__cache__={};Module["DracoInt8Array"]=DracoInt8Array;DracoInt8Array.prototype["GetValue"]=DracoInt8Array.prototype.GetValue=function(index){var self=this.ptr;if(index&&typeof index==="object")index=index.ptr;return _emscripten_bind_DracoInt8Array_GetValue_1(self,index)};DracoInt8Array.prototype["size"]=DracoInt8Array.prototype.size=function(){var self=this.ptr;return _emscripten_bind_DracoInt8Array_size_0(self)};DracoInt8Array.prototype["__destroy__"]=DracoInt8Array.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_DracoInt8Array___destroy___0(self)};function MetadataQuerier(){this.ptr=_emscripten_bind_MetadataQuerier_MetadataQuerier_0();getCache(MetadataQuerier)[this.ptr]=this}MetadataQuerier.prototype=Object.create(WrapperObject.prototype);MetadataQuerier.prototype.constructor=MetadataQuerier;MetadataQuerier.prototype.__class__=MetadataQuerier;MetadataQuerier.__cache__={};Module["MetadataQuerier"]=MetadataQuerier;MetadataQuerier.prototype["HasEntry"]=MetadataQuerier.prototype.HasEntry=function(metadata,entry_name){var self=this.ptr;ensureCache.prepare();if(metadata&&typeof metadata==="object")metadata=metadata.ptr;if(entry_name&&typeof entry_name==="object")entry_name=entry_name.ptr;else entry_name=ensureString(entry_name);return!!_emscripten_bind_MetadataQuerier_HasEntry_2(self,metadata,entry_name)};MetadataQuerier.prototype["GetIntEntry"]=MetadataQuerier.prototype.GetIntEntry=function(metadata,entry_name){var self=this.ptr;ensureCache.prepare();if(metadata&&typeof metadata==="object")metadata=metadata.ptr;if(entry_name&&typeof entry_name==="object")entry_name=entry_name.ptr;else entry_name=ensureString(entry_name);return _emscripten_bind_MetadataQuerier_GetIntEntry_2(self,metadata,entry_name)};MetadataQuerier.prototype["GetIntEntryArray"]=MetadataQuerier.prototype.GetIntEntryArray=function(metadata,entry_name,out_values){var self=this.ptr;ensureCache.prepare();if(metadata&&typeof metadata==="object")metadata=metadata.ptr;if(entry_name&&typeof entry_name==="object")entry_name=entry_name.ptr;else entry_name=ensureString(entry_name);if(out_values&&typeof out_values==="object")out_values=out_values.ptr;_emscripten_bind_MetadataQuerier_GetIntEntryArray_3(self,metadata,entry_name,out_values)};MetadataQuerier.prototype["GetDoubleEntry"]=MetadataQuerier.prototype.GetDoubleEntry=function(metadata,entry_name){var self=this.ptr;ensureCache.prepare();if(metadata&&typeof metadata==="object")metadata=metadata.ptr;if(entry_name&&typeof entry_name==="object")entry_name=entry_name.ptr;else entry_name=ensureString(entry_name);return _emscripten_bind_MetadataQuerier_GetDoubleEntry_2(self,metadata,entry_name)};MetadataQuerier.prototype["GetStringEntry"]=MetadataQuerier.prototype.GetStringEntry=function(metadata,entry_name){var self=this.ptr;ensureCache.prepare();if(metadata&&typeof metadata==="object")metadata=metadata.ptr;if(entry_name&&typeof entry_name==="object")entry_name=entry_name.ptr;else entry_name=ensureString(entry_name);return UTF8ToString(_emscripten_bind_MetadataQuerier_GetStringEntry_2(self,metadata,entry_name))};MetadataQuerier.prototype["NumEntries"]=MetadataQuerier.prototype.NumEntries=function(metadata){var self=this.ptr;if(metadata&&typeof metadata==="object")metadata=metadata.ptr;return _emscripten_bind_MetadataQuerier_NumEntries_1(self,metadata)};MetadataQuerier.prototype["GetEntryName"]=MetadataQuerier.prototype.GetEntryName=function(metadata,entry_id){var self=this.ptr;if(metadata&&typeof metadata==="object")metadata=metadata.ptr;if(entry_id&&typeof entry_id==="object")entry_id=entry_id.ptr;return UTF8ToString(_emscripten_bind_MetadataQuerier_GetEntryName_2(self,metadata,entry_id))};MetadataQuerier.prototype["__destroy__"]=MetadataQuerier.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_MetadataQuerier___destroy___0(self)};function DracoInt16Array(){this.ptr=_emscripten_bind_DracoInt16Array_DracoInt16Array_0();getCache(DracoInt16Array)[this.ptr]=this}DracoInt16Array.prototype=Object.create(WrapperObject.prototype);DracoInt16Array.prototype.constructor=DracoInt16Array;DracoInt16Array.prototype.__class__=DracoInt16Array;DracoInt16Array.__cache__={};Module["DracoInt16Array"]=DracoInt16Array;DracoInt16Array.prototype["GetValue"]=DracoInt16Array.prototype.GetValue=function(index){var self=this.ptr;if(index&&typeof index==="object")index=index.ptr;return _emscripten_bind_DracoInt16Array_GetValue_1(self,index)};DracoInt16Array.prototype["size"]=DracoInt16Array.prototype.size=function(){var self=this.ptr;return _emscripten_bind_DracoInt16Array_size_0(self)};DracoInt16Array.prototype["__destroy__"]=DracoInt16Array.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_DracoInt16Array___destroy___0(self)};function DracoFloat32Array(){this.ptr=_emscripten_bind_DracoFloat32Array_DracoFloat32Array_0();getCache(DracoFloat32Array)[this.ptr]=this}DracoFloat32Array.prototype=Object.create(WrapperObject.prototype);DracoFloat32Array.prototype.constructor=DracoFloat32Array;DracoFloat32Array.prototype.__class__=DracoFloat32Array;DracoFloat32Array.__cache__={};Module["DracoFloat32Array"]=DracoFloat32Array;DracoFloat32Array.prototype["GetValue"]=DracoFloat32Array.prototype.GetValue=function(index){var self=this.ptr;if(index&&typeof index==="object")index=index.ptr;return _emscripten_bind_DracoFloat32Array_GetValue_1(self,index)};DracoFloat32Array.prototype["size"]=DracoFloat32Array.prototype.size=function(){var self=this.ptr;return _emscripten_bind_DracoFloat32Array_size_0(self)};DracoFloat32Array.prototype["__destroy__"]=DracoFloat32Array.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_DracoFloat32Array___destroy___0(self)};function GeometryAttribute(){this.ptr=_emscripten_bind_GeometryAttribute_GeometryAttribute_0();getCache(GeometryAttribute)[this.ptr]=this}GeometryAttribute.prototype=Object.create(WrapperObject.prototype);GeometryAttribute.prototype.constructor=GeometryAttribute;GeometryAttribute.prototype.__class__=GeometryAttribute;GeometryAttribute.__cache__={};Module["GeometryAttribute"]=GeometryAttribute;GeometryAttribute.prototype["__destroy__"]=GeometryAttribute.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_GeometryAttribute___destroy___0(self)};function DecoderBuffer(){this.ptr=_emscripten_bind_DecoderBuffer_DecoderBuffer_0();getCache(DecoderBuffer)[this.ptr]=this}DecoderBuffer.prototype=Object.create(WrapperObject.prototype);DecoderBuffer.prototype.constructor=DecoderBuffer;DecoderBuffer.prototype.__class__=DecoderBuffer;DecoderBuffer.__cache__={};Module["DecoderBuffer"]=DecoderBuffer;DecoderBuffer.prototype["Init"]=DecoderBuffer.prototype.Init=function(data,data_size){var self=this.ptr;ensureCache.prepare();if(typeof data=="object"){data=ensureInt8(data)}if(data_size&&typeof data_size==="object")data_size=data_size.ptr;_emscripten_bind_DecoderBuffer_Init_2(self,data,data_size)};DecoderBuffer.prototype["__destroy__"]=DecoderBuffer.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_DecoderBuffer___destroy___0(self)};function Decoder(){this.ptr=_emscripten_bind_Decoder_Decoder_0();getCache(Decoder)[this.ptr]=this}Decoder.prototype=Object.create(WrapperObject.prototype);Decoder.prototype.constructor=Decoder;Decoder.prototype.__class__=Decoder;Decoder.__cache__={};Module["Decoder"]=Decoder;Decoder.prototype["GetEncodedGeometryType"]=Decoder.prototype.GetEncodedGeometryType=function(in_buffer){var self=this.ptr;if(in_buffer&&typeof in_buffer==="object")in_buffer=in_buffer.ptr;return _emscripten_bind_Decoder_GetEncodedGeometryType_1(self,in_buffer)};Decoder.prototype["DecodeBufferToPointCloud"]=Decoder.prototype.DecodeBufferToPointCloud=function(in_buffer,out_point_cloud){var self=this.ptr;if(in_buffer&&typeof in_buffer==="object")in_buffer=in_buffer.ptr;if(out_point_cloud&&typeof out_point_cloud==="object")out_point_cloud=out_point_cloud.ptr;return wrapPointer(_emscripten_bind_Decoder_DecodeBufferToPointCloud_2(self,in_buffer,out_point_cloud),Status)};Decoder.prototype["DecodeBufferToMesh"]=Decoder.prototype.DecodeBufferToMesh=function(in_buffer,out_mesh){var self=this.ptr;if(in_buffer&&typeof in_buffer==="object")in_buffer=in_buffer.ptr;if(out_mesh&&typeof out_mesh==="object")out_mesh=out_mesh.ptr;return wrapPointer(_emscripten_bind_Decoder_DecodeBufferToMesh_2(self,in_buffer,out_mesh),Status)};Decoder.prototype["GetAttributeId"]=Decoder.prototype.GetAttributeId=function(pc,type){var self=this.ptr;if(pc&&typeof pc==="object")pc=pc.ptr;if(type&&typeof type==="object")type=type.ptr;return _emscripten_bind_Decoder_GetAttributeId_2(self,pc,type)};Decoder.prototype["GetAttributeIdByName"]=Decoder.prototype.GetAttributeIdByName=function(pc,name){var self=this.ptr;ensureCache.prepare();if(pc&&typeof pc==="object")pc=pc.ptr;if(name&&typeof name==="object")name=name.ptr;else name=ensureString(name);return _emscripten_bind_Decoder_GetAttributeIdByName_2(self,pc,name)};Decoder.prototype["GetAttributeIdByMetadataEntry"]=Decoder.prototype.GetAttributeIdByMetadataEntry=function(pc,name,value){var self=this.ptr;ensureCache.prepare();if(pc&&typeof pc==="object")pc=pc.ptr;if(name&&typeof name==="object")name=name.ptr;else name=ensureString(name);if(value&&typeof value==="object")value=value.ptr;else value=ensureString(value);return _emscripten_bind_Decoder_GetAttributeIdByMetadataEntry_3(self,pc,name,value)};Decoder.prototype["GetAttribute"]=Decoder.prototype.GetAttribute=function(pc,att_id){var self=this.ptr;if(pc&&typeof pc==="object")pc=pc.ptr;if(att_id&&typeof att_id==="object")att_id=att_id.ptr;return wrapPointer(_emscripten_bind_Decoder_GetAttribute_2(self,pc,att_id),PointAttribute)};Decoder.prototype["GetAttributeByUniqueId"]=Decoder.prototype.GetAttributeByUniqueId=function(pc,unique_id){var self=this.ptr;if(pc&&typeof pc==="object")pc=pc.ptr;if(unique_id&&typeof unique_id==="object")unique_id=unique_id.ptr;return wrapPointer(_emscripten_bind_Decoder_GetAttributeByUniqueId_2(self,pc,unique_id),PointAttribute)};Decoder.prototype["GetMetadata"]=Decoder.prototype.GetMetadata=function(pc){var self=this.ptr;if(pc&&typeof pc==="object")pc=pc.ptr;return wrapPointer(_emscripten_bind_Decoder_GetMetadata_1(self,pc),Metadata)};Decoder.prototype["GetAttributeMetadata"]=Decoder.prototype.GetAttributeMetadata=function(pc,att_id){var self=this.ptr;if(pc&&typeof pc==="object")pc=pc.ptr;if(att_id&&typeof att_id==="object")att_id=att_id.ptr;return wrapPointer(_emscripten_bind_Decoder_GetAttributeMetadata_2(self,pc,att_id),Metadata)};Decoder.prototype["GetFaceFromMesh"]=Decoder.prototype.GetFaceFromMesh=function(m,face_id,out_values){var self=this.ptr;if(m&&typeof m==="object")m=m.ptr;if(face_id&&typeof face_id==="object")face_id=face_id.ptr;if(out_values&&typeof out_values==="object")out_values=out_values.ptr;return!!_emscripten_bind_Decoder_GetFaceFromMesh_3(self,m,face_id,out_values)};Decoder.prototype["GetTriangleStripsFromMesh"]=Decoder.prototype.GetTriangleStripsFromMesh=function(m,strip_values){var self=this.ptr;if(m&&typeof m==="object")m=m.ptr;if(strip_values&&typeof strip_values==="object")strip_values=strip_values.ptr;return _emscripten_bind_Decoder_GetTriangleStripsFromMesh_2(self,m,strip_values)};Decoder.prototype["GetTrianglesUInt16Array"]=Decoder.prototype.GetTrianglesUInt16Array=function(m,out_size,out_values){var self=this.ptr;if(m&&typeof m==="object")m=m.ptr;if(out_size&&typeof out_size==="object")out_size=out_size.ptr;if(out_values&&typeof out_values==="object")out_values=out_values.ptr;return!!_emscripten_bind_Decoder_GetTrianglesUInt16Array_3(self,m,out_size,out_values)};Decoder.prototype["GetTrianglesUInt32Array"]=Decoder.prototype.GetTrianglesUInt32Array=function(m,out_size,out_values){var self=this.ptr;if(m&&typeof m==="object")m=m.ptr;if(out_size&&typeof out_size==="object")out_size=out_size.ptr;if(out_values&&typeof out_values==="object")out_values=out_values.ptr;return!!_emscripten_bind_Decoder_GetTrianglesUInt32Array_3(self,m,out_size,out_values)};Decoder.prototype["GetAttributeFloat"]=Decoder.prototype.GetAttributeFloat=function(pa,att_index,out_values){var self=this.ptr;if(pa&&typeof pa==="object")pa=pa.ptr;if(att_index&&typeof att_index==="object")att_index=att_index.ptr;if(out_values&&typeof out_values==="object")out_values=out_values.ptr;return!!_emscripten_bind_Decoder_GetAttributeFloat_3(self,pa,att_index,out_values)};Decoder.prototype["GetAttributeFloatForAllPoints"]=Decoder.prototype.GetAttributeFloatForAllPoints=function(pc,pa,out_values){var self=this.ptr;if(pc&&typeof pc==="object")pc=pc.ptr;if(pa&&typeof pa==="object")pa=pa.ptr;if(out_values&&typeof out_values==="object")out_values=out_values.ptr;return!!_emscripten_bind_Decoder_GetAttributeFloatForAllPoints_3(self,pc,pa,out_values)};Decoder.prototype["GetAttributeIntForAllPoints"]=Decoder.prototype.GetAttributeIntForAllPoints=function(pc,pa,out_values){var self=this.ptr;if(pc&&typeof pc==="object")pc=pc.ptr;if(pa&&typeof pa==="object")pa=pa.ptr;if(out_values&&typeof out_values==="object")out_values=out_values.ptr;return!!_emscripten_bind_Decoder_GetAttributeIntForAllPoints_3(self,pc,pa,out_values)};Decoder.prototype["GetAttributeInt8ForAllPoints"]=Decoder.prototype.GetAttributeInt8ForAllPoints=function(pc,pa,out_values){var self=this.ptr;if(pc&&typeof pc==="object")pc=pc.ptr;if(pa&&typeof pa==="object")pa=pa.ptr;if(out_values&&typeof out_values==="object")out_values=out_values.ptr;return!!_emscripten_bind_Decoder_GetAttributeInt8ForAllPoints_3(self,pc,pa,out_values)};Decoder.prototype["GetAttributeUInt8ForAllPoints"]=Decoder.prototype.GetAttributeUInt8ForAllPoints=function(pc,pa,out_values){var self=this.ptr;if(pc&&typeof pc==="object")pc=pc.ptr;if(pa&&typeof pa==="object")pa=pa.ptr;if(out_values&&typeof out_values==="object")out_values=out_values.ptr;return!!_emscripten_bind_Decoder_GetAttributeUInt8ForAllPoints_3(self,pc,pa,out_values)};Decoder.prototype["GetAttributeInt16ForAllPoints"]=Decoder.prototype.GetAttributeInt16ForAllPoints=function(pc,pa,out_values){var self=this.ptr;if(pc&&typeof pc==="object")pc=pc.ptr;if(pa&&typeof pa==="object")pa=pa.ptr;if(out_values&&typeof out_values==="object")out_values=out_values.ptr;return!!_emscripten_bind_Decoder_GetAttributeInt16ForAllPoints_3(self,pc,pa,out_values)};Decoder.prototype["GetAttributeUInt16ForAllPoints"]=Decoder.prototype.GetAttributeUInt16ForAllPoints=function(pc,pa,out_values){var self=this.ptr;if(pc&&typeof pc==="object")pc=pc.ptr;if(pa&&typeof pa==="object")pa=pa.ptr;if(out_values&&typeof out_values==="object")out_values=out_values.ptr;return!!_emscripten_bind_Decoder_GetAttributeUInt16ForAllPoints_3(self,pc,pa,out_values)};Decoder.prototype["GetAttributeInt32ForAllPoints"]=Decoder.prototype.GetAttributeInt32ForAllPoints=function(pc,pa,out_values){var self=this.ptr;if(pc&&typeof pc==="object")pc=pc.ptr;if(pa&&typeof pa==="object")pa=pa.ptr;if(out_values&&typeof out_values==="object")out_values=out_values.ptr;return!!_emscripten_bind_Decoder_GetAttributeInt32ForAllPoints_3(self,pc,pa,out_values)};Decoder.prototype["GetAttributeUInt32ForAllPoints"]=Decoder.prototype.GetAttributeUInt32ForAllPoints=function(pc,pa,out_values){var self=this.ptr;if(pc&&typeof pc==="object")pc=pc.ptr;if(pa&&typeof pa==="object")pa=pa.ptr;if(out_values&&typeof out_values==="object")out_values=out_values.ptr;return!!_emscripten_bind_Decoder_GetAttributeUInt32ForAllPoints_3(self,pc,pa,out_values)};Decoder.prototype["GetAttributeDataArrayForAllPoints"]=Decoder.prototype.GetAttributeDataArrayForAllPoints=function(pc,pa,data_type,out_size,out_values){var self=this.ptr;if(pc&&typeof pc==="object")pc=pc.ptr;if(pa&&typeof pa==="object")pa=pa.ptr;if(data_type&&typeof data_type==="object")data_type=data_type.ptr;if(out_size&&typeof out_size==="object")out_size=out_size.ptr;if(out_values&&typeof out_values==="object")out_values=out_values.ptr;return!!_emscripten_bind_Decoder_GetAttributeDataArrayForAllPoints_5(self,pc,pa,data_type,out_size,out_values)};Decoder.prototype["SkipAttributeTransform"]=Decoder.prototype.SkipAttributeTransform=function(att_type){var self=this.ptr;if(att_type&&typeof att_type==="object")att_type=att_type.ptr;_emscripten_bind_Decoder_SkipAttributeTransform_1(self,att_type)};Decoder.prototype["__destroy__"]=Decoder.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_Decoder___destroy___0(self)};function Mesh(){this.ptr=_emscripten_bind_Mesh_Mesh_0();getCache(Mesh)[this.ptr]=this}Mesh.prototype=Object.create(WrapperObject.prototype);Mesh.prototype.constructor=Mesh;Mesh.prototype.__class__=Mesh;Mesh.__cache__={};Module["Mesh"]=Mesh;Mesh.prototype["num_faces"]=Mesh.prototype.num_faces=function(){var self=this.ptr;return _emscripten_bind_Mesh_num_faces_0(self)};Mesh.prototype["num_attributes"]=Mesh.prototype.num_attributes=function(){var self=this.ptr;return _emscripten_bind_Mesh_num_attributes_0(self)};Mesh.prototype["num_points"]=Mesh.prototype.num_points=function(){var self=this.ptr;return _emscripten_bind_Mesh_num_points_0(self)};Mesh.prototype["__destroy__"]=Mesh.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_Mesh___destroy___0(self)};function VoidPtr(){throw"cannot construct a VoidPtr, no constructor in IDL"}VoidPtr.prototype=Object.create(WrapperObject.prototype);VoidPtr.prototype.constructor=VoidPtr;VoidPtr.prototype.__class__=VoidPtr;VoidPtr.__cache__={};Module["VoidPtr"]=VoidPtr;VoidPtr.prototype["__destroy__"]=VoidPtr.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_VoidPtr___destroy___0(self)};function DracoInt32Array(){this.ptr=_emscripten_bind_DracoInt32Array_DracoInt32Array_0();getCache(DracoInt32Array)[this.ptr]=this}DracoInt32Array.prototype=Object.create(WrapperObject.prototype);DracoInt32Array.prototype.constructor=DracoInt32Array;DracoInt32Array.prototype.__class__=DracoInt32Array;DracoInt32Array.__cache__={};Module["DracoInt32Array"]=DracoInt32Array;DracoInt32Array.prototype["GetValue"]=DracoInt32Array.prototype.GetValue=function(index){var self=this.ptr;if(index&&typeof index==="object")index=index.ptr;return _emscripten_bind_DracoInt32Array_GetValue_1(self,index)};DracoInt32Array.prototype["size"]=DracoInt32Array.prototype.size=function(){var self=this.ptr;return _emscripten_bind_DracoInt32Array_size_0(self)};DracoInt32Array.prototype["__destroy__"]=DracoInt32Array.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_DracoInt32Array___destroy___0(self)};function Metadata(){this.ptr=_emscripten_bind_Metadata_Metadata_0();getCache(Metadata)[this.ptr]=this}Metadata.prototype=Object.create(WrapperObject.prototype);Metadata.prototype.constructor=Metadata;Metadata.prototype.__class__=Metadata;Metadata.__cache__={};Module["Metadata"]=Metadata;Metadata.prototype["__destroy__"]=Metadata.prototype.__destroy__=function(){var self=this.ptr;_emscripten_bind_Metadata___destroy___0(self)};(function(){function setupEnums(){Module["OK"]=_emscripten_enum_draco_StatusCode_OK();Module["DRACO_ERROR"]=_emscripten_enum_draco_StatusCode_DRACO_ERROR();Module["IO_ERROR"]=_emscripten_enum_draco_StatusCode_IO_ERROR();Module["INVALID_PARAMETER"]=_emscripten_enum_draco_StatusCode_INVALID_PARAMETER();Module["UNSUPPORTED_VERSION"]=_emscripten_enum_draco_StatusCode_UNSUPPORTED_VERSION();Module["UNKNOWN_VERSION"]=_emscripten_enum_draco_StatusCode_UNKNOWN_VERSION();Module["DT_INVALID"]=_emscripten_enum_draco_DataType_DT_INVALID();Module["DT_INT8"]=_emscripten_enum_draco_DataType_DT_INT8();Module["DT_UINT8"]=_emscripten_enum_draco_DataType_DT_UINT8();Module["DT_INT16"]=_emscripten_enum_draco_DataType_DT_INT16();Module["DT_UINT16"]=_emscripten_enum_draco_DataType_DT_UINT16();Module["DT_INT32"]=_emscripten_enum_draco_DataType_DT_INT32();Module["DT_UINT32"]=_emscripten_enum_draco_DataType_DT_UINT32();Module["DT_INT64"]=_emscripten_enum_draco_DataType_DT_INT64();Module["DT_UINT64"]=_emscripten_enum_draco_DataType_DT_UINT64();Module["DT_FLOAT32"]=_emscripten_enum_draco_DataType_DT_FLOAT32();Module["DT_FLOAT64"]=_emscripten_enum_draco_DataType_DT_FLOAT64();Module["DT_BOOL"]=_emscripten_enum_draco_DataType_DT_BOOL();Module["DT_TYPES_COUNT"]=_emscripten_enum_draco_DataType_DT_TYPES_COUNT();Module["INVALID_GEOMETRY_TYPE"]=_emscripten_enum_draco_EncodedGeometryType_INVALID_GEOMETRY_TYPE();Module["POINT_CLOUD"]=_emscripten_enum_draco_EncodedGeometryType_POINT_CLOUD();Module["TRIANGULAR_MESH"]=_emscripten_enum_draco_EncodedGeometryType_TRIANGULAR_MESH();Module["ATTRIBUTE_INVALID_TRANSFORM"]=_emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_INVALID_TRANSFORM();Module["ATTRIBUTE_NO_TRANSFORM"]=_emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_NO_TRANSFORM();Module["ATTRIBUTE_QUANTIZATION_TRANSFORM"]=_emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_QUANTIZATION_TRANSFORM();Module["ATTRIBUTE_OCTAHEDRON_TRANSFORM"]=_emscripten_enum_draco_AttributeTransformType_ATTRIBUTE_OCTAHEDRON_TRANSFORM();Module["INVALID"]=_emscripten_enum_draco_GeometryAttribute_Type_INVALID();Module["POSITION"]=_emscripten_enum_draco_GeometryAttribute_Type_POSITION();Module["NORMAL"]=_emscripten_enum_draco_GeometryAttribute_Type_NORMAL();Module["COLOR"]=_emscripten_enum_draco_GeometryAttribute_Type_COLOR();Module["TEX_COORD"]=_emscripten_enum_draco_GeometryAttribute_Type_TEX_COORD();Module["GENERIC"]=_emscripten_enum_draco_GeometryAttribute_Type_GENERIC()}if(runtimeInitialized)setupEnums();else addOnPreMain(setupEnums)})();if(typeof Module["onModuleParsed"]==="function"){Module["onModuleParsed"]()}


  return DracoDecoderModule
}
);
})();
if (typeof exports === 'object' && typeof module === 'object')
      module.exports = DracoDecoderModule;
    else if (typeof define === 'function' && define['amd'])
      define([], function() { return DracoDecoderModule; });
    else if (typeof exports === 'object')
      exports["DracoDecoderModule"] = DracoDecoderModule;
    