import uav from "./uav";

export default {
  namespaced: true,
  state: {
    devMode: false, //开发模式, 使用开发环境接口
    token: "", //登录token
    userInfo: null, //用户信息
    cesiumViewer: null, // cesium的viewer实例
    cesiumImagesLayers: {
      //cesium的地图图层
      street: {
        //街道影像
        show: false,
      },
      satellite: {
        //卫星影像
        show: false,
      },
      night: {
        //夜景影像
        show: false,
      },
      text: {
        // 地图标注
        show: false,
      },
    },
    cesium3DModels: [], //cesium的3D模型
    listCollapse: false, //无人机或盈巢列表是否折叠
    // 任务列表
    taskList: [
      /* {
        name: "任务",
        id: 1,
        children: [],
        airway: {
          name: "航线名称1",
          id: 1,
          content:
            '{"filename":"肇庆航线20240318","line":{"baseSpeed":3},"content":[{"uuid":"1nmI-Fo18IagbcVJsia7Q","latitude":23.178153411812204,"longitude":112.57807281336807,"alt":100,"yawAngle":0,"pitchAngle":0,"speed":3,"actions":[]},{"uuid":"9pTbBPlF8iIwbUNqusyHK","latitude":23.17783116525969,"longitude":112.57797543441967,"alt":100,"yawAngle":0,"pitchAngle":0,"speed":3,"actions":[]},{"uuid":"s91IhN22wuaeyG-UQs0XR","latitude":23.17786413506686,"longitude":112.57824336604547,"alt":100,"yawAngle":0,"pitchAngle":0,"speed":3,"actions":[]},{"uuid":"xS_JIl3wxQrhMPdpcjcSn","latitude":23.17820934975604,"longitude":112.5781357731637,"alt":100,"yawAngle":0,"pitchAngle":0,"speed":3,"actions":[]}],"baseSpeed":3,"gimbalYaw":0,"gimbalPitch":0,"alt":100}',
        },
      }, */
    ],
  },
  mutations: {
    /**
     * 单纯的给state赋值
     * @param {*} param0
     * @param {*} data {key: '', value}
     */
    setState(state, data) {
      try {
        state[data.key] = data.value;
      } catch (e) {
        console.log("setDate err", e);
      }
    },
  },
  actions: {
    /**
     * 切换3D模型展示
     * @param {Object} param0
     * @param {Object} data
     * @param {Boolean} data.show 是否展示
     */
    switch3DModelsShow({ state }, data) {
      state.cesium3DModels.forEach((layer) => {
        layer.visible = data.show;
      });
    },
  },
  getters: {
    //地面站websocket url
    wsUrl(state) {
      if (!state.devMode) {
        return "wss://tmj.mmcuav.cn/websocket";
      } else {
        return "wss://test.tmj.mmcuav.cn/websocket";
      }
    },
    //飞控中心mqtt url
    mqttUrl(state) {
      if (!state.devMode) {
        return "wss://fkzx.mmcuav.cn:8884/mqtt";
      } else {
        // return "wss://test.fkzx.mmcuav.cn:8884/mqtt";
        return "wss://fkzx.mmcuav.cn:8884/mqtt";
      }
    },
  },
  modules: {
    uav,
  },
};
