// 无人机实时数据各链路融合
export default {
  computed: {
    /* uav() {
      return this.$store.state.MMCFlightControlCenter.uav.uav;
    }, */
    // mqtt实时数据
    mqttDataSet() {
      return this.$store.state.MMCMQTT?.dataSet?.[this.uav?.hardId];
    },
    // 地面站实时数据
    gsDataSet() {
      return this.$store.state.MMCGroundStation?.dataSet?.[this.uav?.hardId];
    },
    token() {
      return this.$store.state.MMCFlightControlCenter.token;
    },
    userInfo() {
      return this.$store.state.MMCFlightControlCenter.userInfo;
    },
    wsUrl() {
      return this.$store.getters["MMCFlightControlCenter/wsUrl"];
    },
    mqttUrl() {
      return this.$store.getters["MMCFlightControlCenter/mqttUrl"];
    },
  },
  watch: {
    mqttDataSet(newVal) {
      if (this.uav?.network === 1) {
        if (newVal) {
          this.$store.dispatch(
            "MMCFlightControlCenter/uav/updateByMQTT",
            newVal
          );
        }
      }
    },
    gsDataSet(newVal) {
      if (this.uav?.network == 0) {
        if (newVal) {
          this.$store.dispatch(
            "MMCFlightControlCenter/uav/updateByMQTT",
            newVal
          );
        }
      }
    },
  },
  async created() {
    // 模拟飞机数据上报
    // this.$store.dispatch("MMCFlightControlCenter/uav/test", { open: true });
    // 启动mqtt服务
    try {
      this.$store
        .dispatch("MMCMQTT/init", {
          url: this.mqttUrl,
        })
        .then(() => {
          console.log("mqtt连接成功");
        });
    } catch (e) {
      console.log("mqtt失败", e);
    }

    // 由于ws连接到地面站是使用广播形式获取无人机数据的,所以在组件创建时先连接ws,后续选择无人机时,通过广播数据,筛选出选择的无人机信息出来
    try {
      const username = this.userInfo.userName;
      const token = this.token;
      this.$store
        .dispatch("MMCGroundStation/init", {
          url: this.wsUrl,
          userInfo: {
            type: 100,
            systemCode: "mmc",
            state: 1,
            username,
            token,
            appId: "40003",
          },
        })
        .then(() => {
          console.log("地面站连接成功");
        });
    } catch (e) {
      console.log("地面站连接失败", e);
    }
  },
};
